import{s as _s,o as Gs,n as Ht}from"../chunks/scheduler.25b97de1.js";import{S as Xs,i as Bs,g as o,s as n,r,A as Rs,h as i,f as s,c as l,j as Yt,u as h,x as c,k as Zs,y as J,a,v as m,d,t as u,w as M}from"../chunks/index.d9030fc9.js";import{T as Et}from"../chunks/Tip.baa67368.js";import{C as f}from"../chunks/CodeBlock.e6cd0d95.js";import{H as b,E as Vs}from"../chunks/EditOnGithub.91d95064.js";function xs(U){let p,j="One important concept you need to know when writing your own generation loop, is <code>cache_position</code>. In case you want to reuse an already filled Cache object by calling <code>forward()</code>, you have to pass in a valid <code>cache_position</code> which will indicate the positions of inputs in the sequence. Note that <code>cache_position</code> is not affected by padding, and always adds one more position for each token. For example, if key/value cache contains 10 tokens (no matter how many of it is a pad token), the cache position for the next token should be <code>torch.tensor([10])</code>.";return{c(){p=o("p"),p.innerHTML=j},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fyl20k"&&(p.innerHTML=j)},m(y,T){a(y,p,T)},p:Ht,d(y){y&&s(p)}}}function Ns(U){let p,j="Cache quantization can be detrimental in terms of latency if the context length is short and there is enough GPU VRAM available to run without cache quantization. It is recommended to seek balance between memory efficiency and latency.";return{c(){p=o("p"),p.textContent=j},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-46etli"&&(p.textContent=j)},m(y,T){a(y,p,T)},p:Ht,d(y){y&&s(p)}}}function zs(U){let p,j="Cache offloading requires a GPU and can be slower than dynamic KV cache. Use it if you are getting CUDA out of memory errors.";return{c(){p=o("p"),p.textContent=j},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-16njdjl"&&(p.textContent=j)},m(y,T){a(y,p,T)},p:Ht,d(y){y&&s(p)}}}function Qs(U){let p,j,y,T,v,Be,W,qt=`Efficient caching is crucial for optimizing the performance of models in various generative tasks,
including text generation, translation, summarization and other transformer-based applications.
Effective caching helps reduce computation time and improve response rates, especially in real-time or resource-intensive applications.`,Re,Z,St=`Transformers support various caching methods, leveraging “Cache” classes to abstract and manage the caching logic.
This document outlines best practices for using these classes to maximize performance and efficiency.
Check out all the available <code>Cache</code> classes in the <a href="./internal/generation_utils.md">API documentation</a>.`,Ve,_,xe,G,At="Imagine you’re having a conversation with someone, and instead of remembering what was said previously, you have to start from scratch every time you respond. This would be slow and inefficient, right? In the world of Transformer models, a similar concept applies, and that’s where Caching keys and values come into play. From now on, I’ll refer to the concept as KV Cache.",Ne,X,Lt="KV cache is needed to optimize the generation in autoregressive models, where the model predicts text token by token. This process can be slow since the model can generate only one token at a time, and each new prediction is dependent on the previous context. That means, to predict token number 1000 in the generation, you need information from the previous 999 tokens, which comes in the form of some matrix multiplications across the representations of those tokens. But to predict token number 1001, you also need the same information from the first 999 tokens, plus additional information from token number 1000. That is where key-value cache is used to optimize the sequential generation process by storing previous calculations to reuse in subsequent tokens, so they don’t need to be computed again.",ze,B,Dt="More concretely, key-value cache acts as a memory bank for these generative models, where the model stores key-value pairs derived from self-attention layers for previously processed tokens. By storing this information, the model can avoid redundant computations and instead retrieve keys and values of previous tokens from the cache.",Qe,g,ve,Kt="<em>For the Curious Minds Who Like to Dive Deep</em>",Vt,R,xt,We,Pt="When utilizing a cache object in the input, the Attention module performs several critical steps to integrate past and present information seamlessly.",Nt,Ze,Ot="The Attention module concatenates the current key-values with the past key-values stored in the cache. This results in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. Essentially, the past and current key-values are combined to compute attention scores, ensuring that the model considers both previous context and new input. The concatenated key-values are used to compute the attention scores resulting in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>.",zt,_e,es="Therefore, when iteratively calling <code>forward()</code> instead of the <code>generate()</code> method, it’s crucial to ensure that the attention mask shape matches the combined length of past and current key-values. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is usually handled internally when you call <code>generate()</code> method. If you want to implement your own generation loop with Cache classes, take this into consideration and prepare the attention mask to hold values to current and past tokens.",Qt,k,$t,Ge,ts="See an example below for how to implement your own generation loop.",Ft,V,$e,x,Fe,N,ss=`In 🤗 Transformers, we support various Cache types to optimize the performance across different models and tasks. By default, all models generate with caching,
with the <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> class being the default cache for most models. It allows us to dynamically grow cache size, by saving more and more keys and values as we generate. If for some reason you don’t want to use caches, you can pass <code>use_cache=False</code> into the <code>generate()</code> method.`,Ye,z,as="Refer to the table below to see the difference between cache types and choose the one that suits best for your use-case.",Ee,Q,ns="<thead><tr><th>Cache Type</th> <th>Memory Efficient</th> <th>Supports torch.compile()</th> <th>Initialization Recommended</th> <th>Latency</th> <th>Long Context Generation</th></tr></thead> <tbody><tr><td>Dynamic Cache</td> <td>No</td> <td>No</td> <td>No</td> <td>Mid</td> <td>No</td></tr> <tr><td>Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Quantized Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Offloaded Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>No</td></tr> <tr><td>Sliding Window Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Sink Cache</td> <td>Yes</td> <td>No</td> <td>Yes</td> <td>Mid</td> <td>Yes</td></tr></tbody>",He,$,ls='These cache classes can be set with a <code>cache_implementation</code> argument when generating. To learn about the available options for the cache_implementation flag, please refer to the <a href="./main_classes/text_generation.md#transformers.GenerationConfig">API Documentation</a>. Now, let’s explore each cache type in detail and see how to use them. Note that the below examples are for decoder-only Tranformer-based models. We also support [“Model-Specific Cache”] classes for models such as Mamba or Jamba, keep reading for more details.',qe,F,Se,Y,os=`The key and value cache can occupy a large portion of memory, becoming a <a href="https://huggingface.co/blog/llama31#inference-memory-requirements" rel="nofollow">bottleneck for long-context generation</a>, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,Ae,E,is='KV Cache quantization in <code>transformers</code> is largely inspired by the paper <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">“KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache”</a> and currently supports <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.QuantoQuantizedCache">~QuantoQuantizedCache</a> and <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.HQQQuantizedCache">~HQQQuantizedCache</a> classes. For more information on the inner workings see the paper.',Le,H,cs=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,De,C,Ke,q,Pe,S,Oe,A,ps=`Similarly to KV cache quantization, <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> strategy aims to reduce GPU VRAM usage.
It does so by moving the KV cache for most layers to the CPU.
As the model’s <code>forward()</code> method iterates over the layers, this strategy maintains the current layer cache on the GPU.
At the same time it asynchronously prefetches the next layer cache as well as sending the previous layer cache back to the CPU.
Unlike KV cache quantization, this strategy always produces the same result as the default KV cache implementation.
Thus, it can serve as a drop-in replacement or a fallback for it.`,et,L,rs=`Depending on your model and the characteristics of your generation task (size of context, number of generated tokens, number of beams, etc.)
you may notice a small degradation in generation throughput compared to the default KV cache implementation.`,tt,D,hs="To enable KV cache offloading, pass <code>cache_implementation=&quot;offloaded&quot;</code> in the <code>generation_config</code> or directky to the <code>generate()</code> call.",st,K,at,I,nt,P,ms="The example below shows how KV cache offloading can be used as a fallback strategy.",lt,O,ot,ee,ds="On a GPU with 50 GB of RAM, running this code will print",it,te,ct,se,us="before successfully generating 40 beams.",pt,ae,rt,ne,Ms=`Since the “DynamicCache” dynamically grows with each generation step, it prevents you from taking advantage of JIT optimizations. The <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.StaticCache">~StaticCache</a> pre-allocates
a specific maximum size for the keys and values, allowing you to generate up to the maximum length without having to modify cache size. Check the below usage example.`,ht,le,ys='For more examples with Static Cache and JIT compilation, take a look at <a href="./llm_optims.md#static-kv-cache-and-torchcompile">StaticCache &amp; torchcompile</a>',mt,oe,dt,ie,ut,ce,gs="As the name suggests, this cache type implements a sliding window over previous keys and values, retaining only the last <code>sliding_window</code> tokens. It should be used with models like Mistral that support sliding window attention. Additionally, similar to Static Cache, this one is JIT-friendly and can be used with the same compile tecniques as Static Cache.",Mt,pe,ws="Note that you can use this cache only for models that support sliding window, e.g. Mistral models.",yt,re,gt,he,wt,me,js='Sink Cache was introduced in <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">“Efficient Streaming Language Models with Attention Sinks”</a>. It allows you to generate long sequences of text (“infinite length” according to the paper) without any fine-tuning. That is achieved by smart handling of previous keys and values, specifically it retains a few initial tokens from the sequence, called “sink tokens”. This is based on the observation that these initial tokens attract a significant portion of attention scores during the generation process. Tokens that come after “sink tokens” are discarded on a sliding windowed basis, keeping only the latest <code>window_size</code> tokens. By keeping these initial tokens as “attention sinks,” the model maintains stable performance even when dealing with very long texts, thus discarding most of the previous knowledge.',jt,de,Js="Unlike other cache classes, this one can’t be used directly by indicating a <code>cache_implementation</code>. You have to initialize the Cache before calling on <code>generate()</code> as follows.",Jt,ue,bt,Me,Tt,ye,bs='The <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.EncoderDecoderCache">~EncoderDecoderCache</a> is a wrapper designed to handle the caching needs of encoder-decoder models. This cache type is specifically built to manage both self-attention and cross-attention caches, ensuring storage and retrieval of past key/values required for these complex models. Cool thing about Encoder-Decoder Cache is that you can set different cache types for the encoder and for the decoder, depending on your use case. Currently this cache is only supported in <a href="./model_doc/whisper.md">Whisper</a> models but we will be adding more models soon.',ft,ge,Ts="In terms of usage, there is nothing special to be done and calling <code>generate()</code> or <code>forward()</code> will handle everything for you.",Ut,we,kt,je,fs='Some models require storing previous keys, values, or states in a specific way, and the above cache classes cannot be used. For such cases, we have several specialized cache classes that are designed for specific models. These models only accept their own dedicated cache classes and do not support using any other cache types. Some examples include <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> for <a href="./model_doc/gemma2.md">Gemma2</a> series models or <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.MambaCache">~MambaCache</a> for <a href="./model_doc/mamba.md">Mamba</a> architecture models.',Ct,Je,It,be,Us="We have seen how to use each of the cache types when generating. What if you want to use cache in iterative generation setting, for example in applications like chatbots, where interactions involve multiple turns and continuous back-and-forth exchanges. Iterative generation with cache allows these systems to handle ongoing conversations effectively without reprocessing the entire context at each step. But there are some tips that you should know before you start implementing:",vt,Te,ks='The general format when doing iterative generation is as below. First you have to initialize an empty cache of the type you want, and you can start feeding in new prompts iteratively. Keeping track of dialogues history and formatting can be done with chat templates, read more on that in <a href="./chat_templating.md">chat_templating</a>',Wt,fe,Cs="In case you are using Sink Cache, you have to crop your inputs to that maximum length because Sink Cache can generate text longer than its maximum window size, but it expects the first input to not exceed the maximum cache length.",Zt,Ue,_t,ke,Gt,Ce,Is="Sometimes you would want to fist fill-in cache object with key/values for certain prefix prompt and re-use it several times to generate different sequences from it. We are working hard on adding this feature to 🤗 Transformers and will update this section soon.",Xt,Ie,Bt,Xe,Rt;return v=new b({props:{title:"Best Practices for Generation with Cache",local:"best-practices-for-generation-with-cache",headingTag:"h1"}}),_=new b({props:{title:"What is Cache and why we should care?",local:"what-is-cache-and-why-we-should-care",headingTag:"h2"}}),R=new b({props:{title:"Under the Hood: How Cache Object Works in Attention Mechanism",local:"under-the-hood-how-cache-object-works-in-attention-mechanism",headingTag:"h3"}}),k=new Et({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:U}}}),V=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwRHluYW1pY0NhY2hlJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElM0EwJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMHdoYXQncyUyMHlvdXIlMjBuYW1lLiUyMiU3RCU1RCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzJTBBY2FjaGVfcG9zaXRpb24lMjAlM0QlMjB0b3JjaC5hcmFuZ2UoaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMkMlMjBkdHlwZSUzRHRvcmNoLmludDY0JTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBbWF4X25ld190b2tlbnMlMjAlM0QlMjAxMCUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKG1heF9uZXdfdG9rZW5zKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGNhY2hlX3Bvc2l0aW9uJTNEY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEdyZWVkaWx5JTIwc2FtcGxlJTIwb25lJTIwbmV4dCUyMHRva2VuJTBBJTIwJTIwJTIwJTIwbmV4dF90b2tlbl9pZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyU1QiUzQSUyQyUyMC0xJTNBJTVELmFyZ21heCgtMSklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwdG9yY2guY2F0KCU1QmdlbmVyYXRlZF9pZHMlMkMlMjBuZXh0X3Rva2VuX2lkcyU1RCUyQyUyMGRpbSUzRC0xKSUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFByZXBhcmUlMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBuZXh0JTIwZ2VuZXJhdGlvbiUyMHN0ZXAlMjBieSUyMGxlYWF2aW5nJTIwdW5wcm9jZXNzZWQlMjB0b2tlbnMlMkMlMjBpbiUyMG91ciUyMGNhc2UlMjB3ZSUyMGhhdmUlMjBvbmx5JTIwb25lJTIwbmV3JTIwdG9rZW4lMEElMjAlMjAlMjAlMjAlMjMlMjBhbmQlMjBleHBhbmRpbmclMjBhdHRuJTIwbWFzayUyMGZvciUyMHRoZSUyMG5ldyUyMHRva2VuJTJDJTIwYXMlMjBleHBsYWluZWQlMjBhYm92ZSUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTIwJTNEJTIwaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUyMCUzRCUyMHRvcmNoLmNhdCglNUJhdHRlbnRpb25fbWFzayUyQyUyMGF0dGVudGlvbl9tYXNrLm5ld19vbmVzKChhdHRlbnRpb25fbWFzay5zaGFwZSU1QjAlNUQlMkMlMjAxKSklNUQlMkMlMjBkaW0lM0QtMSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMjJpbnB1dF9pZHMlMjIlM0ElMjBuZXh0X3Rva2VuX2lkcyUyQyUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTNBJTIwYXR0ZW50aW9uX21hc2slN0QlMEElMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUyMCUzRCUyMGNhY2hlX3Bvc2l0aW9uJTVCLTElM0ElNUQlMjAlMkIlMjAxJTIwJTIzJTIwYWRkJTIwb25lJTIwbW9yZSUyMHBvc2l0aW9uJTIwZm9yJTIwdGhlJTIwbmV4dCUyMHRva2VuJTBBJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = inputs.input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
<span class="hljs-meta">... </span>    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)     
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Greedily sample one next token</span>
<span class="hljs-meta">... </span>    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)   
...
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare inputs for the next generation step by leaaving unprocessed tokens, in our case we have only one new token</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
<span class="hljs-meta">... </span>    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
<span class="hljs-meta">... </span>    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;[INST] Hello, what&#x27;s your name. [/INST]  Hello! My name is LLaMA,&quot;</span>`,wrap:!1}}),x=new b({props:{title:"Generate with Cache",local:"generate-with-cache",headingTag:"h2"}}),F=new b({props:{title:"Quantized Cache",local:"quantized-cache",headingTag:"h3"}}),C=new Et({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:U}}}),q=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySSUyMGxpa2UlMjByb2NrJTIwbXVzaWMlMjBiZWNhdXNlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJxdWFudGl6ZWQlMjIlMkMlMjBjYWNoZV9jb25maWclM0QlN0IlMjJuYml0cyUyMiUzQSUyMDQlMkMlMjAlMjJiYWNrZW5kJTIyJTNBJTIwJTIycXVhbnRvJTIyJTdEKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. It&#x27;</span>s a great way to express myself <span class="hljs-keyword">and</span> rel

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. I like to listen to it when I&#x27;</span>m feeling`,wrap:!1}}),S=new b({props:{title:"OffloadedCache",local:"offloadedcache",headingTag:"h2"}}),K=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBY2twdCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJGdW4lMjBmYWN0JTNBJTIwVGhlJTIwc2hvcnRlc3QlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMm9mZmxvYWRlZCUyMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Fun fact: The shortest&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>, cache_implementation=<span class="hljs-string">&quot;offloaded&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>`,wrap:!1}}),I=new Et({props:{warning:!0,$$slots:{default:[zs]},$$scope:{ctx:U}}}),O=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">resilient_generate</span>(<span class="hljs-params">model, *args, **kwargs</span>):
<span class="hljs-meta">... </span>    oom = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> torch.cuda.OutOfMemoryError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(e)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;retrying with cache_implementation=&#x27;offloaded&#x27;&quot;</span>)
<span class="hljs-meta">... </span>        oom = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> oom:
<span class="hljs-meta">... </span>        torch.cuda.empty_cache()
<span class="hljs-meta">... </span>        kwargs[<span class="hljs-string">&quot;cache_implementation&quot;</span>] = <span class="hljs-string">&quot;offloaded&quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
...
...
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;okay &quot;</span>*<span class="hljs-number">1000</span> + <span class="hljs-string">&quot;Fun fact: The most&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>beams = { <span class="hljs-string">&quot;num_beams&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_beam_groups&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;diversity_penalty&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&quot;early_stopping&quot;</span>: <span class="hljs-literal">True</span>, }
<span class="hljs-meta">&gt;&gt;&gt; </span>out = resilient_generate(model, **inputs, **beams)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(out[:,-<span class="hljs-number">28</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),te=new f({props:{code:"Q1VEQSUyMG91dCUyMG9mJTIwbWVtb3J5LiUyMFRyaWVkJTIwdG8lMjBhbGxvY2F0ZSUyMDQuODMlMjBHaUIuJTIwR1BVJTBBcmV0cnlpbmclMjB3aXRoJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0Qnb2ZmbG9hZGVkJw==",highlighted:`CUDA <span class="hljs-keyword">out</span> <span class="hljs-keyword">of</span> memory. Tried <span class="hljs-keyword">to</span> allocate <span class="hljs-number">4.83</span> GiB. GPU
retrying <span class="hljs-keyword">with</span> cache_implementation=<span class="hljs-string">&#x27;offloaded&#x27;</span>`,wrap:!1}}),ae=new b({props:{title:"Static Cache",local:"static-cache",headingTag:"h3"}}),oe=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),ie=new b({props:{title:"Sliding Window Cache",local:"sliding-window-cache",headingTag:"h3"}}),re=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUzQTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlllc3RlcmRheSUyMEklMjB3YXMlMjBvbiUyMGElMjByb2NrJTIwY29uY2VydCUyMGFuZC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwY2FuJTIwYmUlMjB1c2VkJTIwYnklMjBwYXNzaW5nJTIwaW4lMjBjYWNoZSUyMGltcGxlbWVudGF0aW9uJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMzAlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMnNsaWRpbmdfd2luZG93JTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Yesterday I was on a rock concert and.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># can be used by passing in cache implementation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, cache_implementation=<span class="hljs-string">&quot;sliding_window&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Yesterday I was on a rock concert and. I was so excited to see my favorite band. I was so excited that I was jumping up and down and screaming. I was so excited that I&quot;</span>`,wrap:!1}}),he=new b({props:{title:"Sink Cache",local:"sink-cache",headingTag:"h3"}}),ue=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBzdG9yeSUyMGFib3V0JTIwdW5pY29ybnMlMkMlMjBmYWlyaWVzJTIwYW5kJTIwbWFnaWMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMGdldCUyMG91ciUyMGNhY2hlJTJDJTIwc3BlY2lmeSUyMG51bWJlciUyMG9mJTIwc2luayUyMHRva2VucyUyMGFuZCUyMHdpbmRvdyUyMHNpemUlMEElMjMlMjBOb3RlJTIwdGhhdCUyMHdpbmRvdyUyMHNpemUlMjBhbHJlYWR5JTIwaW5jbHVkZXMlMjBzaW5rJTIwdG9rZW5zJTJDJTIwc28lMjBoYXMlMjB0byUyMGJlJTIwbGFyZ2VyJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU2lua0NhY2hlKHdpbmRvd19sZW5ndGglM0QyNTYlMkMlMjBudW1fc2lua190b2tlbnMlM0Q0KSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get our cache, specify number of sink tokens and window size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that window size already includes sink tokens, so has to be larger</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, past_key_values=past_key_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic. It is a fantasy world where unicorns and fairies live together in harmony. The story follows a young girl named Lily&quot;</span>`,wrap:!1}}),Me=new b({props:{title:"Encoder-Decoder Cache",local:"encoder-decoder-cache",headingTag:"h3"}}),we=new b({props:{title:"Model-specific Cache Classes",local:"model-specific-cache-classes",headingTag:"h3"}}),Je=new b({props:{title:"Iterative Generation with Cache",local:"iterative-generation-with-cache",headingTag:"h2"}}),Ue=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer,AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.cache_utils <span class="hljs-keyword">import</span> (
<span class="hljs-meta">&gt;&gt;&gt; </span>    DynamicCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SinkCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    StaticCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SlidingWindowCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantoQuantizedCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantizedCacheConfig,
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&#x27;auto&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>user_prompts = [<span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>, <span class="hljs-string">&quot;Btw, yesterday I was on a rock concert.&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>max_cache_length = past_key_values.get_max_length()

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> user_prompts:
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt})
<span class="hljs-meta">... </span>    inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(model.device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(past_key_values, SinkCache):
<span class="hljs-meta">... </span>        inputs = {k: v[:, -max_cache_length:] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>
<span class="hljs-meta">... </span>    input_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">256</span>, past_key_values=past_key_values)
<span class="hljs-meta">... </span>    completion = tokenizer.decode(outputs[<span class="hljs-number">0</span>, input_length: ], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: completion})

<span class="hljs-built_in">print</span>(messages)
[{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot; Hello! My name is LLaMA, I&#x27;m a large language model trained by a team of researcher at Meta AI. 😊&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Btw, yesterday I was on a rock concert.&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27; Oh, cool! That sounds like a lot of fun! 🎉 Did you enjoy the concert? What was the band like? 🤔&#x27;</span>}]`,wrap:!1}}),ke=new b({props:{title:"Re-use Cache to continue generation",local:"re-use-cache-to-continue-generation",headingTag:"h2"}}),Ie=new Vs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/kv_cache.md"}}),{c(){p=o("meta"),j=n(),y=o("p"),T=n(),r(v.$$.fragment),Be=n(),W=o("p"),W.textContent=qt,Re=n(),Z=o("p"),Z.innerHTML=St,Ve=n(),r(_.$$.fragment),xe=n(),G=o("p"),G.textContent=At,Ne=n(),X=o("p"),X.textContent=Lt,ze=n(),B=o("p"),B.textContent=Dt,Qe=n(),g=o("details"),ve=o("summary"),ve.innerHTML=Kt,Vt=n(),r(R.$$.fragment),xt=n(),We=o("p"),We.textContent=Pt,Nt=n(),Ze=o("p"),Ze.innerHTML=Ot,zt=n(),_e=o("p"),_e.innerHTML=es,Qt=n(),r(k.$$.fragment),$t=n(),Ge=o("p"),Ge.textContent=ts,Ft=n(),r(V.$$.fragment),$e=n(),r(x.$$.fragment),Fe=n(),N=o("p"),N.innerHTML=ss,Ye=n(),z=o("p"),z.textContent=as,Ee=n(),Q=o("table"),Q.innerHTML=ns,He=n(),$=o("p"),$.innerHTML=ls,qe=n(),r(F.$$.fragment),Se=n(),Y=o("p"),Y.innerHTML=os,Ae=n(),E=o("p"),E.innerHTML=is,Le=n(),H=o("p"),H.innerHTML=cs,De=n(),r(C.$$.fragment),Ke=n(),r(q.$$.fragment),Pe=n(),r(S.$$.fragment),Oe=n(),A=o("p"),A.innerHTML=ps,et=n(),L=o("p"),L.textContent=rs,tt=n(),D=o("p"),D.innerHTML=hs,st=n(),r(K.$$.fragment),at=n(),r(I.$$.fragment),nt=n(),P=o("p"),P.textContent=ms,lt=n(),r(O.$$.fragment),ot=n(),ee=o("p"),ee.textContent=ds,it=n(),r(te.$$.fragment),ct=n(),se=o("p"),se.textContent=us,pt=n(),r(ae.$$.fragment),rt=n(),ne=o("p"),ne.innerHTML=Ms,ht=n(),le=o("p"),le.innerHTML=ys,mt=n(),r(oe.$$.fragment),dt=n(),r(ie.$$.fragment),ut=n(),ce=o("p"),ce.innerHTML=gs,Mt=n(),pe=o("p"),pe.textContent=ws,yt=n(),r(re.$$.fragment),gt=n(),r(he.$$.fragment),wt=n(),me=o("p"),me.innerHTML=js,jt=n(),de=o("p"),de.innerHTML=Js,Jt=n(),r(ue.$$.fragment),bt=n(),r(Me.$$.fragment),Tt=n(),ye=o("p"),ye.innerHTML=bs,ft=n(),ge=o("p"),ge.innerHTML=Ts,Ut=n(),r(we.$$.fragment),kt=n(),je=o("p"),je.innerHTML=fs,Ct=n(),r(Je.$$.fragment),It=n(),be=o("p"),be.textContent=Us,vt=n(),Te=o("p"),Te.innerHTML=ks,Wt=n(),fe=o("p"),fe.textContent=Cs,Zt=n(),r(Ue.$$.fragment),_t=n(),r(ke.$$.fragment),Gt=n(),Ce=o("p"),Ce.textContent=Is,Xt=n(),r(Ie.$$.fragment),Bt=n(),Xe=o("p"),this.h()},l(e){const t=Rs("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(s),j=l(e),y=i(e,"P",{}),Yt(y).forEach(s),T=l(e),h(v.$$.fragment,e),Be=l(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-ivdsz6"&&(W.textContent=qt),Re=l(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ev2dx"&&(Z.innerHTML=St),Ve=l(e),h(_.$$.fragment,e),xe=l(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-pgg2dh"&&(G.textContent=At),Ne=l(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1pcidqj"&&(X.textContent=Lt),ze=l(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1m78q9l"&&(B.textContent=Dt),Qe=l(e),g=i(e,"DETAILS",{});var w=Yt(g);ve=i(w,"SUMMARY",{"data-svelte-h":!0}),c(ve)!=="svelte-8dl4q2"&&(ve.innerHTML=Kt),Vt=l(w),h(R.$$.fragment,w),xt=l(w),We=i(w,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1e25at2"&&(We.textContent=Pt),Nt=l(w),Ze=i(w,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1l5g8w7"&&(Ze.innerHTML=Ot),zt=l(w),_e=i(w,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-8mjlg7"&&(_e.innerHTML=es),Qt=l(w),h(k.$$.fragment,w),$t=l(w),Ge=i(w,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-181iwu3"&&(Ge.textContent=ts),Ft=l(w),h(V.$$.fragment,w),w.forEach(s),$e=l(e),h(x.$$.fragment,e),Fe=l(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1hnz76"&&(N.innerHTML=ss),Ye=l(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-14tr67y"&&(z.textContent=as),Ee=l(e),Q=i(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-jygdve"&&(Q.innerHTML=ns),He=l(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1po4v5x"&&($.innerHTML=ls),qe=l(e),h(F.$$.fragment,e),Se=l(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1yajrsk"&&(Y.innerHTML=os),Ae=l(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-dtt66h"&&(E.innerHTML=is),Le=l(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-lk1mjk"&&(H.innerHTML=cs),De=l(e),h(C.$$.fragment,e),Ke=l(e),h(q.$$.fragment,e),Pe=l(e),h(S.$$.fragment,e),Oe=l(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-awzj0l"&&(A.innerHTML=ps),et=l(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1x4pr6r"&&(L.textContent=rs),tt=l(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-nhcnen"&&(D.innerHTML=hs),st=l(e),h(K.$$.fragment,e),at=l(e),h(I.$$.fragment,e),nt=l(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-f3m4wg"&&(P.textContent=ms),lt=l(e),h(O.$$.fragment,e),ot=l(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-opu10i"&&(ee.textContent=ds),it=l(e),h(te.$$.fragment,e),ct=l(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-83p2wm"&&(se.textContent=us),pt=l(e),h(ae.$$.fragment,e),rt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-179yh17"&&(ne.innerHTML=Ms),ht=l(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1ihym5y"&&(le.innerHTML=ys),mt=l(e),h(oe.$$.fragment,e),dt=l(e),h(ie.$$.fragment,e),ut=l(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-krlgtc"&&(ce.innerHTML=gs),Mt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-gmo390"&&(pe.textContent=ws),yt=l(e),h(re.$$.fragment,e),gt=l(e),h(he.$$.fragment,e),wt=l(e),me=i(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-128onc7"&&(me.innerHTML=js),jt=l(e),de=i(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1vy8lmv"&&(de.innerHTML=Js),Jt=l(e),h(ue.$$.fragment,e),bt=l(e),h(Me.$$.fragment,e),Tt=l(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-7q51h4"&&(ye.innerHTML=bs),ft=l(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-159fa3b"&&(ge.innerHTML=Ts),Ut=l(e),h(we.$$.fragment,e),kt=l(e),je=i(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1vj0kse"&&(je.innerHTML=fs),Ct=l(e),h(Je.$$.fragment,e),It=l(e),be=i(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-au9ho2"&&(be.textContent=Us),vt=l(e),Te=i(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1lko7wn"&&(Te.innerHTML=ks),Wt=l(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-g93psr"&&(fe.textContent=Cs),Zt=l(e),h(Ue.$$.fragment,e),_t=l(e),h(ke.$$.fragment,e),Gt=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-47ynnt"&&(Ce.textContent=Is),Xt=l(e),h(Ie.$$.fragment,e),Bt=l(e),Xe=i(e,"P",{}),Yt(Xe).forEach(s),this.h()},h(){Zs(p,"name","hf:doc:metadata"),Zs(p,"content",$s)},m(e,t){J(document.head,p),a(e,j,t),a(e,y,t),a(e,T,t),m(v,e,t),a(e,Be,t),a(e,W,t),a(e,Re,t),a(e,Z,t),a(e,Ve,t),m(_,e,t),a(e,xe,t),a(e,G,t),a(e,Ne,t),a(e,X,t),a(e,ze,t),a(e,B,t),a(e,Qe,t),a(e,g,t),J(g,ve),J(g,Vt),m(R,g,null),J(g,xt),J(g,We),J(g,Nt),J(g,Ze),J(g,zt),J(g,_e),J(g,Qt),m(k,g,null),J(g,$t),J(g,Ge),J(g,Ft),m(V,g,null),a(e,$e,t),m(x,e,t),a(e,Fe,t),a(e,N,t),a(e,Ye,t),a(e,z,t),a(e,Ee,t),a(e,Q,t),a(e,He,t),a(e,$,t),a(e,qe,t),m(F,e,t),a(e,Se,t),a(e,Y,t),a(e,Ae,t),a(e,E,t),a(e,Le,t),a(e,H,t),a(e,De,t),m(C,e,t),a(e,Ke,t),m(q,e,t),a(e,Pe,t),m(S,e,t),a(e,Oe,t),a(e,A,t),a(e,et,t),a(e,L,t),a(e,tt,t),a(e,D,t),a(e,st,t),m(K,e,t),a(e,at,t),m(I,e,t),a(e,nt,t),a(e,P,t),a(e,lt,t),m(O,e,t),a(e,ot,t),a(e,ee,t),a(e,it,t),m(te,e,t),a(e,ct,t),a(e,se,t),a(e,pt,t),m(ae,e,t),a(e,rt,t),a(e,ne,t),a(e,ht,t),a(e,le,t),a(e,mt,t),m(oe,e,t),a(e,dt,t),m(ie,e,t),a(e,ut,t),a(e,ce,t),a(e,Mt,t),a(e,pe,t),a(e,yt,t),m(re,e,t),a(e,gt,t),m(he,e,t),a(e,wt,t),a(e,me,t),a(e,jt,t),a(e,de,t),a(e,Jt,t),m(ue,e,t),a(e,bt,t),m(Me,e,t),a(e,Tt,t),a(e,ye,t),a(e,ft,t),a(e,ge,t),a(e,Ut,t),m(we,e,t),a(e,kt,t),a(e,je,t),a(e,Ct,t),m(Je,e,t),a(e,It,t),a(e,be,t),a(e,vt,t),a(e,Te,t),a(e,Wt,t),a(e,fe,t),a(e,Zt,t),m(Ue,e,t),a(e,_t,t),m(ke,e,t),a(e,Gt,t),a(e,Ce,t),a(e,Xt,t),m(Ie,e,t),a(e,Bt,t),a(e,Xe,t),Rt=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),k.$set(w);const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),C.$set(vs);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),I.$set(Ws)},i(e){Rt||(d(v.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(F.$$.fragment,e),d(C.$$.fragment,e),d(q.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),d(I.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(ke.$$.fragment,e),d(Ie.$$.fragment,e),Rt=!0)},o(e){u(v.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(k.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(F.$$.fragment,e),u(C.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(I.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ie.$$.fragment,e),Rt=!1},d(e){e&&(s(j),s(y),s(T),s(Be),s(W),s(Re),s(Z),s(Ve),s(xe),s(G),s(Ne),s(X),s(ze),s(B),s(Qe),s(g),s($e),s(Fe),s(N),s(Ye),s(z),s(Ee),s(Q),s(He),s($),s(qe),s(Se),s(Y),s(Ae),s(E),s(Le),s(H),s(De),s(Ke),s(Pe),s(Oe),s(A),s(et),s(L),s(tt),s(D),s(st),s(at),s(nt),s(P),s(lt),s(ot),s(ee),s(it),s(ct),s(se),s(pt),s(rt),s(ne),s(ht),s(le),s(mt),s(dt),s(ut),s(ce),s(Mt),s(pe),s(yt),s(gt),s(wt),s(me),s(jt),s(de),s(Jt),s(bt),s(Tt),s(ye),s(ft),s(ge),s(Ut),s(kt),s(je),s(Ct),s(It),s(be),s(vt),s(Te),s(Wt),s(fe),s(Zt),s(_t),s(Gt),s(Ce),s(Xt),s(Bt),s(Xe)),s(p),M(v,e),M(_,e),M(R),M(k),M(V),M(x,e),M(F,e),M(C,e),M(q,e),M(S,e),M(K,e),M(I,e),M(O,e),M(te,e),M(ae,e),M(oe,e),M(ie,e),M(re,e),M(he,e),M(ue,e),M(Me,e),M(we,e),M(Je,e),M(Ue,e),M(ke,e),M(Ie,e)}}}const $s='{"title":"Best Practices for Generation with Cache","local":"best-practices-for-generation-with-cache","sections":[{"title":"What is Cache and why we should care?","local":"what-is-cache-and-why-we-should-care","sections":[{"title":"Under the Hood: How Cache Object Works in Attention Mechanism","local":"under-the-hood-how-cache-object-works-in-attention-mechanism","sections":[],"depth":3}],"depth":2},{"title":"Generate with Cache","local":"generate-with-cache","sections":[{"title":"Quantized Cache","local":"quantized-cache","sections":[],"depth":3}],"depth":2},{"title":"OffloadedCache","local":"offloadedcache","sections":[{"title":"Static Cache","local":"static-cache","sections":[],"depth":3},{"title":"Sliding Window Cache","local":"sliding-window-cache","sections":[],"depth":3},{"title":"Sink Cache","local":"sink-cache","sections":[],"depth":3},{"title":"Encoder-Decoder Cache","local":"encoder-decoder-cache","sections":[],"depth":3},{"title":"Model-specific Cache Classes","local":"model-specific-cache-classes","sections":[],"depth":3}],"depth":2},{"title":"Iterative Generation with Cache","local":"iterative-generation-with-cache","sections":[],"depth":2},{"title":"Re-use Cache to continue generation","local":"re-use-cache-to-continue-generation","sections":[],"depth":2}],"depth":1}';function Fs(U){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends Xs{constructor(p){super(),Bs(this,p,Fs,Qs,_s,{})}}export{As as component};
