import{s as Tl,o as Jl}from"../chunks/scheduler.65852ee5.js";import{S as Cl,i as kl,g as s,s as a,r as m,A as Ul,h as o,f as l,c as i,j as Ml,u as p,x as r,k as vl,y as Ll,a as n,v as d,d as u,t as f,w as h,m as Il,n as jl}from"../chunks/index.aa74147d.js";import{T as Gl}from"../chunks/Tip.bb8ccac8.js";import{D as Zl,C as y}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as g,E as _l}from"../chunks/EditOnGithub.4eda6a96.js";function Wl(Le){let b;return{c(){b=Il(`By default, LlamaIndex uses a chunk size of 1024 and a chunk overlap of
20. For more details, see the [LlamaIndex
documentation](https://docs.llamaindex.ai/en/stable/optimizing/basic_strategies/basic_strategies.html#chunk-sizes).`)},l(c){b=jl(c,`By default, LlamaIndex uses a chunk size of 1024 and a chunk overlap of
20. For more details, see the [LlamaIndex
documentation](https://docs.llamaindex.ai/en/stable/optimizing/basic_strategies/basic_strategies.html#chunk-sizes).`)},m(c,$){n(c,b,$)},d(c){c&&l(b)}}}function Bl(Le){let b,c,$,Ie,x,je,M,Ge,v,Xt='<em>Authored by: <a href="https://huggingface.co/jinnovation" rel="nofollow">Jonathan Jin</a></em>',Ze,T,_e,J,At=`This notebook demonstrates how to quickly build a RAG-based “librarian” for your
local ebook library.`,We,C,qt=`Think about the last time you visited a library and took advantage of the
expertise of the knowledgeable staff there to help you find what you need out of
the troves of textbooks, novels, and other resources at the library. Our RAG
“librarian” will do the same for us, except for our own local collection of
ebooks.`,Be,k,Re,U,Yt=`We’d like our librarian to be <strong>lightweight</strong> and <strong>run locally as much as
possible</strong> with <strong>minimal dependencies</strong>. This means that we will leverage
open-source to the fullest extent possible, as well as bias towards models that
can be <strong>executed locally on typical hardware, e.g. M1 Macbooks</strong>.`,He,L,Ve,I,Pt="Our solution will consist of the following components:",Xe,j,Ft=`<li><a href="https://docs.llamaindex.ai/en/stable/index.html" rel="nofollow">LlamaIndex</a>, a data framework for LLM-based applications that’s, unlike
<a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a>, designed specifically for RAG;</li> <li><a href="https://ollama.com/" rel="nofollow">Ollama</a>, a user-friendly solution for running LLMs such as Llama 2 locally;</li> <li>The <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a>
embedding model, which performs <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">reasonably well and is reasonably lightweight
in size</a>;</li> <li><a href="https://ollama.com/library/llama2" rel="nofollow">Llama 2</a>, which we’ll run via <a href="https://ollama.com/" rel="nofollow">Ollama</a>.</li>`,Ae,G,qe,Z,St="First let’s install our dependencies.",Ye,_,Pe,W,Fe,B,Se,R,Et="Next, let’s create our test “library.”",Ee,H,Qt="For simplicity’s sake, let’s say that our “library” is simply a <strong>nested directory of <code>.epub</code> files</strong>. We can easily see this solution generalizing to, say, a Calibre library with a <code>metadata.db</code> database file. We’ll leave that extension as an exercise for the reader. 😇",Qe,V,zt='Let’s pull two <code>.epub</code> files from <a href="https://www.gutenberg.org/" rel="nofollow">Project Gutenberg</a> for our library.',ze,X,Ne,A,De,q,Nt="RAG with LlamaIndex, at its core, consists of the following broad phases:",Oe,Y,Dt=`<li><strong>Loading</strong>, in which you tell LlamaIndex where your data lives and how to
load it;</li> <li><strong>Indexing</strong>, in which you augment your loaded data to facilitate querying, e.g. with vector embeddings;</li> <li><strong>Querying</strong>, in which you configure an LLM to act as the query interface for
your indexed data.</li>`,Ke,P,Ot=`This explanation only scratches at the surface of what’s possible with
LlamaIndex. For more in-depth details, I highly recommend reading the
<a href="https://docs.llamaindex.ai/en/stable/getting_started/concepts.html" rel="nofollow">“High-Level Concepts” page of the LlamaIndex
documentation</a>.`,et,F,tt,S,Kt="Naturally, let’s start with the <strong>loading</strong> phase.",lt,E,el=`I mentioned before that LlamaIndex is designed specifically for RAG. This
immediately becomes obvious from its
<a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/simpledirectoryreader.html" rel="nofollow"><code>SimpleDirectoryReader</code></a>
construct, which ✨ <strong>magically</strong> ✨ supports a whole host of multi-model file
types for free. Conveniently for us, <code>.epub</code> is in the supported set.`,nt,Q,at,z,tl='<code>SimpleDirectoryReader.load_data()</code> converts our ebooks into a set of <a href="https://docs.llamaindex.ai/en/stable/api/llama_index.core.schema.Document.html" rel="nofollow"><code>Document</code>s</a> for LlamaIndex to work with.',it,N,ll="One important thing to note here is that the documents <strong>have not been chunked at this stage</strong> — that will happen during indexing. Read on…",st,D,ot,O,nl="Next up after <strong>loading</strong> the data is to <strong>index</strong> it. This will allow our RAG pipeline to look up the relevant context for our query to pass to our LLM to <strong>augment</strong> their generated response. This is also where document chunking will take place.",rt,K,al=`<a href="https://docs.llamaindex.ai/en/stable/module_guides/indexing/vector_store_index.html" rel="nofollow"><code>VectorStoreIndex</code></a>
is a “default” entrypoint for indexing in LlamaIndex. By default,
<code>VectorStoreIndex</code> uses a simple, in-memory dictionary to store the indices, but
LlamaIndex also supports <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores.html" rel="nofollow">a wide variety of vector storage
solutions</a>
for you to graduate to as you scale.`,mt,w,pt,ee,il=`Like mentioned before, we’ll use the
<a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-small-en-v1.5</code></a> to
generate our embeddings. By default, <a href="https://docs.llamaindex.ai/en/stable/getting_started/starter_example.html" rel="nofollow">LlamaIndex uses
OpenAI</a>
(specifically <code>gpt-3.5-turbo</code>), which we’d like to avoid given our desire for a lightweight, locally-runnable end-to-end solution.`,dt,te,sl="Thankfully, LlamaIndex supports retrieving embedding models from Hugging Face through the convenient <code>HuggingFaceEmbedding</code> class, so we’ll use that here.",ut,le,ft,ne,ol="We’ll pass that in to <code>VectorStoreIndex</code> as our embedding model to circumvent the OpenAI default behavior.",ht,ae,gt,ie,bt,se,rl="Now for the final piece of the RAG puzzle — wiring up the query layer.",ct,oe,ml="We’ll use Llama 2 for the purposes of this recipe, but I encourage readers to play around with different models to see which produces the “best” responses here.",yt,re,pl='First let’s start up the Ollama server. Unfortunately, there is no support in the <a href="https://github.com/ollama/ollama-python" rel="nofollow">Ollama Python client</a> for actually starting and stopping the server itself, so we’ll have to pop out of Python land for this.',wt,me,dl="In a separate terminal, run: <code>ollama serve</code>. Remember to terminate this after we’re done here!",$t,pe,ul="Now let’s hook Llama 2 up to LlamaIndex and use it as the basis of our query engine.",xt,de,Mt,ue,vt,fe,fl="With that, our basic RAG librarian is set up and we can start asking questions about our library. For example:",Tt,he,Jt,ge,hl=`Based on the context provided, there are two books available:

1. "Pride and Prejudice" by Jane Austen
2. "Les Misérables" by Victor Hugo

The context used to derive this answer includes:

* The file path for each book, which provides information about the location of the book files on the computer.
* The titles of the books, which are mentioned in the context as being available for reading.
* A list of words associated with each book, such as "epub" and "notebooks", which provide additional information about the format and storage location of each book.
`,Ct,be,kt,ce,gl=`The main character of 'Pride and Prejudice' is Elizabeth Bennet.
`,Ut,ye,Lt,we,bl="We’ve demonstrated how to build a basic RAG-based “librarian” that runs entirely locally, even on Apple silicon Macs. In doing so, we’ve also carried out a “grand tour” of LlamaIndex and how it streamlines the process of setting up RAG-based applications.",It,$e,cl="That said, we’ve really only scratched the surface of what’s possible here. Here are some ideas of how to refine and build upon this foundation.",jt,xe,Gt,Me,yl="To guard against the risk of our librarian hallucinating, how might we require that it provide citations for everything that it says?",Zt,ve,_t,Te,wl='Ebook library management solutions like <a href="https://calibre-ebook.com/" rel="nofollow">Calibre</a> create additional metadata for ebooks in a library. This can provide information such as publisher or edition that might not be readily available in the text of the book itself. How could we extend our RAG pipeline to account for additional sources of information that aren’t <code>.epub</code> files?',Wt,Je,Bt,Ce,$l="If we were to collect everything we built here into a script/executable, the resulting script would re-index our library on each invocation. For our tiny test library of two files, this is “fine,” but for any library of non-trivial size this will very quickly become annoying for users. How could we persist the embedding indices and only update them when the contents of the library have meaningfully changed, e.g. new books have been added?",Rt,ke,Ht,Ue,Vt;return x=new Zl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/update-argilla-cookbooks/notebooks/en/rag_llamaindex_librarian.ipynb"}]}}),M=new g({props:{title:"Building A RAG Ebook “Librarian” Using LlamaIndex",local:"building-a-rag-ebook-librarian-using-llamaindex",headingTag:"h1"}}),T=new g({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),k=new g({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),L=new g({props:{title:"Components",local:"components",headingTag:"h2"}}),G=new g({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),_=new y({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwJTVDJTBBJTIwJTIwJTIwJTIwbGxhbWEtaW5kZXglMjAlNUMlMEElMjAlMjAlMjAlMjBFYm9va0xpYiUyMCU1QyUwQSUyMCUyMCUyMCUyMGh0bWwydGV4dCUyMCU1QyUwQSUyMCUyMCUyMCUyMGxsYW1hLWluZGV4LWVtYmVkZGluZ3MtaHVnZ2luZ2ZhY2UlMjAlNUMlMEElMjAlMjAlMjAlMjBsbGFtYS1pbmRleC1sbG1zLW9sbGFtYQ==",highlighted:`%pip install -q \\
    llama-index \\
    EbookLib \\
    html2text \\
    llama-index-embeddings-huggingface \\
    llama-index-llms-ollama`,wrap:!1}}),W=new y({props:{code:"IWJyZXclMjBpbnN0YWxsJTIwb2xsYW1h",highlighted:"!brew install ollama",wrap:!1}}),B=new g({props:{title:"Test Library Setup",local:"test-library-setup",headingTag:"h2"}}),X=new y({props:{code:"IW1rZGlyJTIwLXAlMjAlMjIuJTJGdGVzdCUyRmxpYnJhcnklMkZqYW5lLWF1c3RlbiUyMiUwQSFta2RpciUyMC1wJTIwJTIyLiUyRnRlc3QlMkZsaWJyYXJ5JTJGdmljdG9yLWh1Z28lMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGd3d3Lmd1dGVuYmVyZy5vcmclMkZlYm9va3MlMkYxMzQyLmVwdWIubm9pbWFnZXMlMjAtTyUyMCUyMi4lMkZ0ZXN0JTJGbGlicmFyeSUyRmphbmUtYXVzdGVuJTJGcHJpZGUtYW5kLXByZWp1ZGljZS5lcHViJTIyJTBBIXdnZXQlMjBodHRwcyUzQSUyRiUyRnd3dy5ndXRlbmJlcmcub3JnJTJGZWJvb2tzJTJGMTM1LmVwdWIubm9pbWFnZXMlMjAtTyUyMCUyMi4lMkZ0ZXN0JTJGbGlicmFyeSUyRnZpY3Rvci1odWdvJTJGbGVzLW1pc2VyYWJsZXMuZXB1YiUyMg==",highlighted:`!mkdir -p <span class="hljs-string">&quot;./test/library/jane-austen&quot;</span>
!mkdir -p <span class="hljs-string">&quot;./test/library/victor-hugo&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">1342.</span>epub.noimages -O <span class="hljs-string">&quot;./test/library/jane-austen/pride-and-prejudice.epub&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">135.</span>epub.noimages -O <span class="hljs-string">&quot;./test/library/victor-hugo/les-miserables.epub&quot;</span>`,wrap:!1}}),A=new g({props:{title:"RAG with LlamaIndex",local:"rag-with-llamaindex",headingTag:"h2"}}),F=new g({props:{title:"Loading",local:"loading",headingTag:"h3"}}),Q=new y({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFsb2FkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoJTBBJTIwJTIwJTIwJTIwaW5wdXRfZGlyJTNEJTIyLiUyRnRlc3QlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjByZWN1cnNpdmUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmVxdWlyZWRfZXh0cyUzRCU1QiUyMi5lcHViJTIyJTVEJTJDJTBBKSUwQSUwQWRvY3VtZW50cyUyMCUzRCUyMGxvYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

loader = SimpleDirectoryReader(
    input_dir=<span class="hljs-string">&quot;./test/&quot;</span>,
    recursive=<span class="hljs-literal">True</span>,
    required_exts=[<span class="hljs-string">&quot;.epub&quot;</span>],
)

documents = loader.load_data()`,wrap:!1}}),D=new g({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),w=new Gl({props:{$$slots:{default:[Wl]},$$scope:{ctx:Le}}}),le=new y({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkZGluZ19tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embedding_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)`,wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkX21vZGVsJTNEZW1iZWRkaW5nX21vZGVsJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex

index = VectorStoreIndex.from_documents(
    documents,
    embed_model=embedding_model,
)`,wrap:!1}}),ie=new g({props:{title:"Querying",local:"querying",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMub2xsYW1hJTIwaW1wb3J0JTIwT2xsYW1hJTBBJTBBbGxhbWElMjAlM0QlMjBPbGxhbWEoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJsbGFtYTIlMjIlMkMlMEElMjAlMjAlMjAlMjByZXF1ZXN0X3RpbWVvdXQlM0Q0MC4wJTJDJTBBKSUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZShsbG0lM0RsbGFtYSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.ollama <span class="hljs-keyword">import</span> Ollama

llama = Ollama(
    model=<span class="hljs-string">&quot;llama2&quot;</span>,
    request_timeout=<span class="hljs-number">40.0</span>,
)

query_engine = index.as_query_engine(llm=llama)`,wrap:!1}}),ue=new g({props:{title:"Final Result",local:"final-result",headingTag:"h2"}}),he=new y({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBhcmUlMjB0aGUlMjB0aXRsZXMlMjBvZiUyMGFsbCUyMHRoZSUyMGJvb2tzJTIwYXZhaWxhYmxlJTNGJTIwU2hvdyUyMG1lJTIwdGhlJTIwY29udGV4dCUyMHVzZWQlMjB0byUyMGRlcml2ZSUyMHlvdXIlMjBhbnN3ZXIuJTIyJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    query_engine.query(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;What are the titles of all the books available? Show me the context used to derive your answer.&quot;</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),be=new y({props:{code:"cHJpbnQocXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldobyUyMGlzJTIwdGhlJTIwbWFpbiUyMGNoYXJhY3RlciUyMG9mJTIwJ1ByaWRlJTIwYW5kJTIwUHJlanVkaWNlJyUzRiUyMikp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(query_engine.query(<span class="hljs-string">&quot;Who is the main character of &#x27;Pride and Prejudice&#x27;?&quot;</span>))',wrap:!1}}),ye=new g({props:{title:"Conclusion and Future Improvements",local:"conclusion-and-future-improvements",headingTag:"h2"}}),xe=new g({props:{title:"Forcing Citations",local:"forcing-citations",headingTag:"h3"}}),ve=new g({props:{title:"Using Extended Metadata",local:"using-extended-metadata",headingTag:"h3"}}),Je=new g({props:{title:"Efficient Indexing",local:"efficient-indexing",headingTag:"h3"}}),ke=new _l({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_llamaindex_librarian.md"}}),{c(){b=s("meta"),c=a(),$=s("p"),Ie=a(),m(x.$$.fragment),je=a(),m(M.$$.fragment),Ge=a(),v=s("p"),v.innerHTML=Xt,Ze=a(),m(T.$$.fragment),_e=a(),J=s("p"),J.textContent=At,We=a(),C=s("p"),C.textContent=qt,Be=a(),m(k.$$.fragment),Re=a(),U=s("p"),U.innerHTML=Yt,He=a(),m(L.$$.fragment),Ve=a(),I=s("p"),I.textContent=Pt,Xe=a(),j=s("ul"),j.innerHTML=Ft,Ae=a(),m(G.$$.fragment),qe=a(),Z=s("p"),Z.textContent=St,Ye=a(),m(_.$$.fragment),Pe=a(),m(W.$$.fragment),Fe=a(),m(B.$$.fragment),Se=a(),R=s("p"),R.textContent=Et,Ee=a(),H=s("p"),H.innerHTML=Qt,Qe=a(),V=s("p"),V.innerHTML=zt,ze=a(),m(X.$$.fragment),Ne=a(),m(A.$$.fragment),De=a(),q=s("p"),q.textContent=Nt,Oe=a(),Y=s("ol"),Y.innerHTML=Dt,Ke=a(),P=s("p"),P.innerHTML=Ot,et=a(),m(F.$$.fragment),tt=a(),S=s("p"),S.innerHTML=Kt,lt=a(),E=s("p"),E.innerHTML=el,nt=a(),m(Q.$$.fragment),at=a(),z=s("p"),z.innerHTML=tl,it=a(),N=s("p"),N.innerHTML=ll,st=a(),m(D.$$.fragment),ot=a(),O=s("p"),O.innerHTML=nl,rt=a(),K=s("p"),K.innerHTML=al,mt=a(),m(w.$$.fragment),pt=a(),ee=s("p"),ee.innerHTML=il,dt=a(),te=s("p"),te.innerHTML=sl,ut=a(),m(le.$$.fragment),ft=a(),ne=s("p"),ne.innerHTML=ol,ht=a(),m(ae.$$.fragment),gt=a(),m(ie.$$.fragment),bt=a(),se=s("p"),se.textContent=rl,ct=a(),oe=s("p"),oe.textContent=ml,yt=a(),re=s("p"),re.innerHTML=pl,wt=a(),me=s("p"),me.innerHTML=dl,$t=a(),pe=s("p"),pe.textContent=ul,xt=a(),m(de.$$.fragment),Mt=a(),m(ue.$$.fragment),vt=a(),fe=s("p"),fe.textContent=fl,Tt=a(),m(he.$$.fragment),Jt=a(),ge=s("pre"),ge.textContent=hl,Ct=a(),m(be.$$.fragment),kt=a(),ce=s("pre"),ce.textContent=gl,Ut=a(),m(ye.$$.fragment),Lt=a(),we=s("p"),we.textContent=bl,It=a(),$e=s("p"),$e.textContent=cl,jt=a(),m(xe.$$.fragment),Gt=a(),Me=s("p"),Me.textContent=yl,Zt=a(),m(ve.$$.fragment),_t=a(),Te=s("p"),Te.innerHTML=wl,Wt=a(),m(Je.$$.fragment),Bt=a(),Ce=s("p"),Ce.textContent=$l,Rt=a(),m(ke.$$.fragment),Ht=a(),Ue=s("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),c=i(e),$=o(e,"P",{}),Ml($).forEach(l),Ie=i(e),p(x.$$.fragment,e),je=i(e),p(M.$$.fragment,e),Ge=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-15wt2km"&&(v.innerHTML=Xt),Ze=i(e),p(T.$$.fragment,e),_e=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-qfh19j"&&(J.textContent=At),We=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17t611x"&&(C.textContent=qt),Be=i(e),p(k.$$.fragment,e),Re=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1fw445c"&&(U.innerHTML=Yt),He=i(e),p(L.$$.fragment,e),Ve=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-13bey4p"&&(I.textContent=Pt),Xe=i(e),j=o(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-azwmvi"&&(j.innerHTML=Ft),Ae=i(e),p(G.$$.fragment,e),qe=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1yta0e7"&&(Z.textContent=St),Ye=i(e),p(_.$$.fragment,e),Pe=i(e),p(W.$$.fragment,e),Fe=i(e),p(B.$$.fragment,e),Se=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-u4a6ea"&&(R.textContent=Et),Ee=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-341xmi"&&(H.innerHTML=Qt),Qe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1od3m7l"&&(V.innerHTML=zt),ze=i(e),p(X.$$.fragment,e),Ne=i(e),p(A.$$.fragment,e),De=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1dd5h8w"&&(q.textContent=Nt),Oe=i(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-vs2u02"&&(Y.innerHTML=Dt),Ke=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1arec5s"&&(P.innerHTML=Ot),et=i(e),p(F.$$.fragment,e),tt=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vs6beo"&&(S.innerHTML=Kt),lt=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-atznhb"&&(E.innerHTML=el),nt=i(e),p(Q.$$.fragment,e),at=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-17k0m2j"&&(z.innerHTML=tl),it=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-10xvxlh"&&(N.innerHTML=ll),st=i(e),p(D.$$.fragment,e),ot=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-73j9ky"&&(O.innerHTML=nl),rt=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1axkw64"&&(K.innerHTML=al),mt=i(e),p(w.$$.fragment,e),pt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-dzonf1"&&(ee.innerHTML=il),dt=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-fkwvyv"&&(te.innerHTML=sl),ut=i(e),p(le.$$.fragment,e),ft=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1181vy7"&&(ne.innerHTML=ol),ht=i(e),p(ae.$$.fragment,e),gt=i(e),p(ie.$$.fragment,e),bt=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1v49o0l"&&(se.textContent=rl),ct=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-qxi4v1"&&(oe.textContent=ml),yt=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1esi2jc"&&(re.innerHTML=pl),wt=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-z54bvc"&&(me.innerHTML=dl),$t=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1xd6b55"&&(pe.textContent=ul),xt=i(e),p(de.$$.fragment,e),Mt=i(e),p(ue.$$.fragment,e),vt=i(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1l7sm6m"&&(fe.textContent=fl),Tt=i(e),p(he.$$.fragment,e),Jt=i(e),ge=o(e,"PRE",{"data-svelte-h":!0}),r(ge)!=="svelte-czhhw9"&&(ge.textContent=hl),Ct=i(e),p(be.$$.fragment,e),kt=i(e),ce=o(e,"PRE",{"data-svelte-h":!0}),r(ce)!=="svelte-13j10yu"&&(ce.textContent=gl),Ut=i(e),p(ye.$$.fragment,e),Lt=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-hu2ihj"&&(we.textContent=bl),It=i(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-8meymn"&&($e.textContent=cl),jt=i(e),p(xe.$$.fragment,e),Gt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-5ludxz"&&(Me.textContent=yl),Zt=i(e),p(ve.$$.fragment,e),_t=i(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1qo1u1t"&&(Te.innerHTML=wl),Wt=i(e),p(Je.$$.fragment,e),Bt=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-aaxqx0"&&(Ce.textContent=$l),Rt=i(e),p(ke.$$.fragment,e),Ht=i(e),Ue=o(e,"P",{}),Ml(Ue).forEach(l),this.h()},h(){vl(b,"name","hf:doc:metadata"),vl(b,"content",Rl)},m(e,t){Ll(document.head,b),n(e,c,t),n(e,$,t),n(e,Ie,t),d(x,e,t),n(e,je,t),d(M,e,t),n(e,Ge,t),n(e,v,t),n(e,Ze,t),d(T,e,t),n(e,_e,t),n(e,J,t),n(e,We,t),n(e,C,t),n(e,Be,t),d(k,e,t),n(e,Re,t),n(e,U,t),n(e,He,t),d(L,e,t),n(e,Ve,t),n(e,I,t),n(e,Xe,t),n(e,j,t),n(e,Ae,t),d(G,e,t),n(e,qe,t),n(e,Z,t),n(e,Ye,t),d(_,e,t),n(e,Pe,t),d(W,e,t),n(e,Fe,t),d(B,e,t),n(e,Se,t),n(e,R,t),n(e,Ee,t),n(e,H,t),n(e,Qe,t),n(e,V,t),n(e,ze,t),d(X,e,t),n(e,Ne,t),d(A,e,t),n(e,De,t),n(e,q,t),n(e,Oe,t),n(e,Y,t),n(e,Ke,t),n(e,P,t),n(e,et,t),d(F,e,t),n(e,tt,t),n(e,S,t),n(e,lt,t),n(e,E,t),n(e,nt,t),d(Q,e,t),n(e,at,t),n(e,z,t),n(e,it,t),n(e,N,t),n(e,st,t),d(D,e,t),n(e,ot,t),n(e,O,t),n(e,rt,t),n(e,K,t),n(e,mt,t),d(w,e,t),n(e,pt,t),n(e,ee,t),n(e,dt,t),n(e,te,t),n(e,ut,t),d(le,e,t),n(e,ft,t),n(e,ne,t),n(e,ht,t),d(ae,e,t),n(e,gt,t),d(ie,e,t),n(e,bt,t),n(e,se,t),n(e,ct,t),n(e,oe,t),n(e,yt,t),n(e,re,t),n(e,wt,t),n(e,me,t),n(e,$t,t),n(e,pe,t),n(e,xt,t),d(de,e,t),n(e,Mt,t),d(ue,e,t),n(e,vt,t),n(e,fe,t),n(e,Tt,t),d(he,e,t),n(e,Jt,t),n(e,ge,t),n(e,Ct,t),d(be,e,t),n(e,kt,t),n(e,ce,t),n(e,Ut,t),d(ye,e,t),n(e,Lt,t),n(e,we,t),n(e,It,t),n(e,$e,t),n(e,jt,t),d(xe,e,t),n(e,Gt,t),n(e,Me,t),n(e,Zt,t),d(ve,e,t),n(e,_t,t),n(e,Te,t),n(e,Wt,t),d(Je,e,t),n(e,Bt,t),n(e,Ce,t),n(e,Rt,t),d(ke,e,t),n(e,Ht,t),n(e,Ue,t),Vt=!0},p(e,[t]){const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),w.$set(xl)},i(e){Vt||(u(x.$$.fragment,e),u(M.$$.fragment,e),u(T.$$.fragment,e),u(k.$$.fragment,e),u(L.$$.fragment,e),u(G.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(X.$$.fragment,e),u(A.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(D.$$.fragment,e),u(w.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(xe.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(ke.$$.fragment,e),Vt=!0)},o(e){f(x.$$.fragment,e),f(M.$$.fragment,e),f(T.$$.fragment,e),f(k.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(_.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(X.$$.fragment,e),f(A.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(w.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(ke.$$.fragment,e),Vt=!1},d(e){e&&(l(c),l($),l(Ie),l(je),l(Ge),l(v),l(Ze),l(_e),l(J),l(We),l(C),l(Be),l(Re),l(U),l(He),l(Ve),l(I),l(Xe),l(j),l(Ae),l(qe),l(Z),l(Ye),l(Pe),l(Fe),l(Se),l(R),l(Ee),l(H),l(Qe),l(V),l(ze),l(Ne),l(De),l(q),l(Oe),l(Y),l(Ke),l(P),l(et),l(tt),l(S),l(lt),l(E),l(nt),l(at),l(z),l(it),l(N),l(st),l(ot),l(O),l(rt),l(K),l(mt),l(pt),l(ee),l(dt),l(te),l(ut),l(ft),l(ne),l(ht),l(gt),l(bt),l(se),l(ct),l(oe),l(yt),l(re),l(wt),l(me),l($t),l(pe),l(xt),l(Mt),l(vt),l(fe),l(Tt),l(Jt),l(ge),l(Ct),l(kt),l(ce),l(Ut),l(Lt),l(we),l(It),l($e),l(jt),l(Gt),l(Me),l(Zt),l(_t),l(Te),l(Wt),l(Bt),l(Ce),l(Rt),l(Ht),l(Ue)),l(b),h(x,e),h(M,e),h(T,e),h(k,e),h(L,e),h(G,e),h(_,e),h(W,e),h(B,e),h(X,e),h(A,e),h(F,e),h(Q,e),h(D,e),h(w,e),h(le,e),h(ae,e),h(ie,e),h(de,e),h(ue,e),h(he,e),h(be,e),h(ye,e),h(xe,e),h(ve,e),h(Je,e),h(ke,e)}}}const Rl='{"title":"Building A RAG Ebook “Librarian” Using LlamaIndex","local":"building-a-rag-ebook-librarian-using-llamaindex","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Components","local":"components","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2},{"title":"Test Library Setup","local":"test-library-setup","sections":[],"depth":2},{"title":"RAG with LlamaIndex","local":"rag-with-llamaindex","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Querying","local":"querying","sections":[],"depth":3}],"depth":2},{"title":"Final Result","local":"final-result","sections":[],"depth":2},{"title":"Conclusion and Future Improvements","local":"conclusion-and-future-improvements","sections":[{"title":"Forcing Citations","local":"forcing-citations","sections":[],"depth":3},{"title":"Using Extended Metadata","local":"using-extended-metadata","sections":[],"depth":3},{"title":"Efficient Indexing","local":"efficient-indexing","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hl(Le){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends Cl{constructor(b){super(),kl(this,b,Hl,Bl,Tl,{})}}export{Pl as component};
