import{s as hi,o as gi,n as B}from"../chunks/scheduler.25b97de1.js";import{S as ui,i as fi,g as m,s as o,r as g,m as w,H as z,A as _i,h as p,f as t,c as r,j as R,u,x as h,n as k,B as $,k as q,y as e,a as i,v as f,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as va}from"../chunks/Tip.baa67368.js";import{D as A}from"../chunks/Docstring.e257edda.js";import{C as fs}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Ws}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as I,E as bi}from"../chunks/EditOnGithub.91d95064.js";function yi(T){let n,v="Examples:",c,d,M;return d=new fs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlZm9ybWVyQ29uZmlnJTJDJTIwUmVmb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBSZWZvcm1lciUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwUmVmb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBSZWZvcm1lciUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReformerConfig, ReformerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Reformer configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ReformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Reformer model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function vi(T){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function wi(T){let n,v="Example:",c,d,M;return d=new fs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBSZWZvcm1lck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlZm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlZm9ybWVyLWNyaW1lLWFuZC1wdW5pc2htZW50JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerModel.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function ki(T){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function Mi(T){let n,v="Example:",c,d,M;return d=new fs({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyTW9kZWxXaXRoTE1IZWFkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVmb3JtZXItY3JpbWUtYW5kLXB1bmlzaG1lbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWZvcm1lck1vZGVsV2l0aExNSGVhZC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVmb3JtZXItY3JpbWUtYW5kLXB1bmlzaG1lbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerModelWithLMHead

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerModelWithLMHead.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function xi(T){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function Ti(T){let n,v=`This example uses a false checkpoint since we don’t have any available pretrained model for the masked language
modeling task with the Reformer architecture.`;return{c(){n=m("p"),n.textContent=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-nc373b"&&(n.textContent=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function zi(T){let n,v="Example:",c,d,M;return d=new fs({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyRm9yTWFza2VkTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGdGlueS1yYW5kb20tcmVmb3JtZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWZvcm1lckZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGdGlueS1yYW5kb20tcmVmb3JtZXIlMjIpJTBBJTBBJTIzJTIwYWRkJTIwbWFza190b2tlbiUwQXRva2VuaXplci5hZGRfc3BlY2lhbF90b2tlbnMoJTdCJTIybWFza190b2tlbiUyMiUzQSUyMCUyMiU1Qk1BU0slNUQlMjIlN0QpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMHJlc2l6ZSUyMG1vZGVsJ3MlMjBlbWJlZGRpbmclMjBtYXRyaXglMEFtb2RlbC5yZXNpemVfdG9rZW5fZW1iZWRkaW5ncyhuZXdfbnVtX3Rva2VucyUzRG1vZGVsLmNvbmZpZy52b2NhYl9zaXplJTIwJTJCJTIwMSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMHJldHJpZXZlJTIwaW5kZXglMjBvZiUyMCU1Qk1BU0slNUQlMEFtYXNrX3Rva2VuX2luZGV4JTIwJTNEJTIwKGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCklNUIwJTVELm5vbnplcm8oYXNfdHVwbGUlM0RUcnVlKSU1QjAlNUQlMEElMEFwcmVkaWN0ZWRfdG9rZW5faWQlMjAlM0QlMjBsb2dpdHMlNUIwJTJDJTIwbWFza190b2tlbl9pbmRleCU1RC5hcmdtYXgoYXhpcyUzRC0xKSUwQXByZWRpY3RlZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUocHJlZGljdGVkX3Rva2VuX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-reformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForMaskedLM.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-reformer&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add mask_token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens({<span class="hljs-string">&quot;mask_token&quot;</span>: <span class="hljs-string">&quot;[MASK]&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># resize model&#x27;s embedding matrix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(new_num_tokens=model.config.vocab_size + <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token = tokenizer.decode(predicted_token_id)`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function $i(T){let n,v;return n=new fs({props:{code:"bGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjMlMjBtYXNrJTIwbGFiZWxzJTIwb2YlMjBub24tJTVCTUFTSyU1RCUyMHRva2VucyUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLndoZXJlKCUwQSUyMCUyMCUyMCUyMGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUyQyUyMGxhYmVscyU1QiUzQSUyQyUyMCUzQSUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1Qi0xJTVEJTVEJTJDJTIwLTEwMCUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMHJvdW5kKG91dHB1dHMubG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-[MASK] tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(
<span class="hljs-meta">... </span>    inputs.input_ids == tokenizer.mask_token_id, labels[:, : inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]], -<span class="hljs-number">100</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = <span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(c){u(n.$$.fragment,c)},m(c,d){f(n,c,d),v=!0},p:B,i(c){v||(_(n.$$.fragment,c),v=!0)},o(c){b(n.$$.fragment,c),v=!1},d(c){y(n,c)}}}function Ri(T){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function Ci(T){let n,v="Example of single-label classification:",c,d,M;return d=new fs({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlZm9ybWVyLWNyaW1lLWFuZC1wdW5pc2htZW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbGFiZWwlMjAlM0QlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>label = model.config.id2label[predicted_class_id]`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-ykxpe4"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function ji(T){let n,v;return n=new fs({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTBBKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigxKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>, num_labels=num_labels
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){g(n.$$.fragment)},l(c){u(n.$$.fragment,c)},m(c,d){f(n,c,d),v=!0},p:B,i(c){v||(_(n.$$.fragment,c),v=!0)},o(c){b(n.$$.fragment,c),v=!1},d(c){y(n,c)}}}function Li(T){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=v},l(c){n=p(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(c,d){i(c,n,d)},p:B,d(c){c&&t(n)}}}function Ji(T){let n,v="Example:",c,d,M;return d=new fs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBSZWZvcm1lckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlZm9ybWVyRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlZm9ybWVyLWNyaW1lLWFuZC1wdW5pc2htZW50JTIyKSUwQSUwQXF1ZXN0aW9uJTJDJTIwdGV4dCUyMCUzRCUyMCUyMldobyUyMHdhcyUyMEppbSUyMEhlbnNvbiUzRiUyMiUyQyUyMCUyMkppbSUyMEhlbnNvbiUyMHdhcyUyMGElMjBuaWNlJTIwcHVwcGV0JTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHF1ZXN0aW9uJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cy5hcmdtYXgoKSUwQWFuc3dlcl9lbmRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMuYXJnbWF4KCklMEElMEFwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBJTBBJTIzJTIwdGFyZ2V0JTIwaXMlMjAlMjJuaWNlJTIwcHVwcGV0JTIyJTBBdGFyZ2V0X3N0YXJ0X2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE0JTVEKSUwQXRhcmdldF9lbmRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTUlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEdGFyZ2V0X3N0YXJ0X2luZGV4JTJDJTIwZW5kX3Bvc2l0aW9ucyUzRHRhcmdldF9lbmRfaW5kZXgpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){n=m("p"),n.textContent=v,c=o(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),c=r(l),u(d.$$.fragment,l)},m(l,x){i(l,n,x),i(l,c,x),f(d,l,x),M=!0},p:B,i(l){M||(_(d.$$.fragment,l),M=!0)},o(l){b(d.$$.fragment,l),M=!1},d(l){l&&(t(n),t(c)),y(d,l)}}}function qi(T){let n,v,c,d,M,l,x,Zo='<a href="https://huggingface.co/models?filter=reformer"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-reformer-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/reformer-crime-and-punishment"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',Ma,Hs,xa,Zs,Io='The Reformer model was proposed in the paper <a href="https://arxiv.org/abs/2001.04451.pdf" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev, Łukasz Kaiser, Anselm Levskaya.',Ta,Is,So="The abstract from the paper is the following:",za,Ss,No=`<em>Large Transformer models routinely achieve state-of-the-art results on a number of tasks but training these models can
be prohibitively costly, especially on long sequences. We introduce two techniques to improve the efficiency of
Transformers. For one, we replace dot-product attention by one that uses locality-sensitive hashing, changing its
complexity from O(L^2) to O(Llog(L)), where L is the length of the sequence. Furthermore, we use reversible residual
layers instead of the standard residuals, which allows storing activations only once in the training process instead of
N times, where N is the number of layers. The resulting model, the Reformer, performs on par with Transformer models
while being much more memory-efficient and much faster on long sequences.</em>`,$a,Ns,Vo=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The Authors’ code can be
found <a href="https://github.com/google/trax/tree/master/trax/models/reformer" rel="nofollow">here</a>.`,Ra,Vs,Ca,Xs,Xo='<li>Reformer does <strong>not</strong> work with <em>torch.nn.DataParallel</em> due to a bug in PyTorch, see <a href="https://github.com/pytorch/pytorch/issues/36035" rel="nofollow">issue #36035</a>.</li> <li>Use Axial position encoding (see below for more details). It’s a mechanism to avoid having a huge positional encoding matrix (when the sequence length is very big) by factorizing it into smaller matrices.</li> <li>Replace traditional attention by LSH (local-sensitive hashing) attention (see below for more details). It’s a technique to avoid computing the full product query-key in the attention layers.</li> <li>Avoid storing the intermediate results of each layer by using reversible transformer layers to obtain them during the backward pass (subtracting the residuals from the input of the next layer gives them back) or recomputing them for results inside a given layer (less efficient than storing them but saves memory).</li> <li>Compute the feedforward operations by chunks and not on the whole batch.</li>',ja,Es,La,C,vn,_s,Eo="trax library",wn,Ja,Zr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi></mrow><annotation encoding="application/x-tex">d</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span></span></span></span>',qa,je,Ao="config.hidden_size",kn,Fa,Ir='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">i, \\ldots, n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ua,Wa,Sr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ha,Le,Bo="config.max_embedding_size",Mn,Za,Nr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub><mo>=</mo><msup><mn>2</mn><mn>19</mn></msup><mo>≈</mo><mn>0.5</mn><mi>M</mi></mrow><annotation encoding="application/x-tex">n_s = 2^{19} \\approx 0.5M</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">19</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord">0.5</span><span class="mord mathnormal" style="margin-right:0.10903em;">M</span></span></span></span>',Ia,Je,Po="config.hidden_size",xn,Sa,Vr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi><mo>=</mo><msup><mn>2</mn><mn>10</mn></msup><mo>≈</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex">d = 2^{10} \\approx 1000</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">10</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Na,Va,Xr='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>d</mi><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mi>s</mi></msub><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;">[</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">d</span><span class="mclose delimcenter" style="top:0em;">]</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;">[</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">]</span></span></span></span></span></span>',Xa,gs,Tn,Ea,Er='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex">X_{i,j}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Aa,Ba,Ar='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mn>1</mn></msubsup><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msup><mi>d</mi><mn>1</mn></msup><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X^{1}_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d^1\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s^1\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2472em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span></span></span></span></span>',Pa,As,zn,Qa,Br='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mn>2</mn></msubsup><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X^{2}_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d^2\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s^2\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2472em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">2</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span></span></span></span></span>',Ga,Bs,$n,Oa,Pr='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>d</mi><mo>=</mo><msup><mi>d</mi><mn>1</mn></msup><mo>+</mo><msup><mi>d</mi><mn>2</mn></msup><mtext> and </mtext><msub><mi>n</mi><mi>s</mi></msub><mo>=</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo>×</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex">d = d^1 + d^2 \\text{ and } n_s = n_s^1 \\times n_s^2 .</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9474em;vertical-align:-0.0833em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0141em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> and </span></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1111em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1111em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',Da,Ps,Rn,Ya,Qr=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub><mo>=</mo><mrow><mo fence="true">{</mo><mtable rowspacing="0.36em" columnalign="left left" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>k</mi></mrow><mn>1</mn></msubsup><mo separator="true">,</mo></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mtext>if  </mtext><mi>i</mi><mo>&lt;</mo><msup><mi>d</mi><mn>1</mn></msup><mtext> with </mtext><mi>k</mi><mo>=</mo><mi>j</mi><mspace></mspace><mspace width="0.6667em"/><mrow><mi mathvariant="normal">m</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">d</mi></mrow><mtext> </mtext><mtext> </mtext><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo>−</mo><msup><mi>d</mi><mn>1</mn></msup><mo separator="true">,</mo><mi>l</mi></mrow><mn>2</mn></msubsup><mo separator="true">,</mo></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mtext>if </mtext><mi>i</mi><mo>≥</mo><msup><mi>d</mi><mn>1</mn></msup><mtext> with </mtext><mi>l</mi><mo>=</mo><mo stretchy="false">⌊</mo><mfrac><mi>j</mi><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup></mfrac><mo stretchy="false">⌋</mo></mrow></mstyle></mtd></mtr></mtable></mrow></mrow><annotation encoding="application/x-tex">X_{i,j} = \\begin{cases}
X^{1}_{i, k}, &amp; \\text{if }\\ i &lt; d^1 \\text{ with } k = j \\mod n_s^1 \\\\
X^{2}_{i - d^1, l}, &amp; \\text{if } i \\ge d^1 \\text{ with } l = \\lfloor\\frac{j}{n_s^1}\\rfloor
\\end{cases}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3em;vertical-align:-1.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mtable"><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7466em;"><span style="top:-3.7466em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span><span class="mpunct">,</span></span></span><span style="top:-2.3066em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.3806em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mtight"><span class="mord mathnormal mtight">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7463em;"><span style="top:-2.786em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">2</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4555em;"><span></span></span></span></span></span></span><span class="mpunct">,</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2466em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:1em;"></span><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7466em;"><span style="top:-3.7466em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">if </span></span><span class="mspace"> </span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&lt;</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace allowbreak"></span><span class="mspace" style="margin-right:0.6667em;"></span><span class="mord"><span class="mord"><span class="mord mathrm">mod</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.3066em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">if </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≥</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mopen">⌊</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9078em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight"><span class="mord mathnormal mtight">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7463em;"><span style="top:-2.214em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-2.786em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.286em;"><span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.5452em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mclose">⌋</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2466em;"><span></span></span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span></span>`,Ka,F,Cn,st,Gr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>j</mi></msub><mo>∈</mo><msup><mi mathvariant="double-struck">R</mi><mi>d</mi></msup></mrow><annotation encoding="application/x-tex">x_j \\in \\mathbb{R}^{d}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord mathbb">R</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">d</span></span></span></span></span></span></span></span></span></span></span></span>',et,at,Or='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>x</mi><mrow><mi>k</mi><mo separator="true">,</mo><mi>l</mi></mrow><mn>1</mn></msubsup><mo>+</mo><msubsup><mi>x</mi><mrow><mi>l</mi><mo separator="true">,</mo><mi>k</mi></mrow><mn>2</mn></msubsup></mrow><annotation encoding="application/x-tex">x^1_{k, l} + x^2_{l, k}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2333em;vertical-align:-0.4192em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2333em;vertical-align:-0.4192em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span></span></span></span>',tt,qe,Qo="config.max_embedding_size",jn,nt,Dr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex">j</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',ot,rt,Yr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi><mtext> and </mtext><mi>l</mi></mrow><annotation encoding="application/x-tex">k \\text{ and } l</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span></span></span></span>',it,lt,Kr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex">x_j</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7167em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',mt,pt,ms,Ln,ct,si='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>d</mi><mn>1</mn></msup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo>=</mo><msup><mn>2</mn><mn>10</mn></msup></mrow><annotation encoding="application/x-tex">d^1 = 2^9, d^2 = 2^9, n_s^1 = 2^9, n_s^2 = 2^{10}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0085em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0611em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0611em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">10</span></span></span></span></span></span></span></span></span></span></span></span>',dt,ht,ei='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mn>2</mn><mn>18</mn></msup><mo>+</mo><msup><mn>2</mn><mn>19</mn></msup><mo>≈</mo><mn>780000</mn></mrow><annotation encoding="application/x-tex">2^{18} + 2^{19} \\approx 780 000</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8974em;vertical-align:-0.0833em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">18</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">19</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">780000</span></span></span></span>',gt,ut,L,Jn,Fe,Go="config.axial_pos_embds_dim",qn,ft,ai='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msup><mi>d</mi><mn>1</mn></msup><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(d^1, d^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0641em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',_t,Ue,Oo="config.hidden_size",Fn,We,Do="config.axial_pos_shape",Un,bt,ti='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(n_s^1, n_s^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0641em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',yt,He,Yo="config.max_embedding_size",Wn,Ze,Ko=`sequence
length`,Hn,Ie,sr="input_ids",Zn,vt,Qs,wt,Gs,er=`In Locality sensitive hashing (LSH) self attention the key and query projection weights are tied. Therefore, the key
query embedding vectors are also tied. LSH self attention uses the locality sensitive hashing mechanism proposed in
<a href="https://arxiv.org/abs/1509.02897" rel="nofollow">Practical and Optimal LSH for Angular Distance</a> to assign each of the tied key
query embedding vectors to one of <code>config.num_buckets</code> possible buckets. The premise is that the more “similar”
key query embedding vectors (in terms of <em>cosine similarity</em>) are to each other, the more likely they are assigned to
the same bucket.`,kt,Os,ar=`The accuracy of the LSH mechanism can be improved by increasing <code>config.num_hashes</code> or directly the argument
<code>num_hashes</code> of the forward function so that the output of the LSH self attention better approximates the output
of the “normal” full self attention. The buckets are then sorted and chunked into query key embedding vector chunks
each of length <code>config.lsh_chunk_length</code>. For each chunk, the query embedding vectors attend to its key vectors
(which are tied to themselves) and to the key embedding vectors of <code>config.lsh_num_chunks_before</code> previous
neighboring chunks and <code>config.lsh_num_chunks_after</code> following neighboring chunks.`,Mt,Ds,tr='For more information, see the <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">original Paper</a> or this great <a href="https://www.pragmatic.ml/reformer-deep-dive/" rel="nofollow">blog post</a>.',xt,X,In,Se,nr="config.num_buckets",Sn,Tt,ni=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(n_{\\text{buckets}}^1,
n_{\\text{buckets}}^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,zt,$t,oi=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mtext>buckets</mtext></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(1,\\ldots,
n_{\\text{buckets}})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,Rt,Ct,ri=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo>−</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mn>1</mn><mo>−</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo>−</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(1-1,\\ldots, n_{\\text{buckets}}^1-1, \\ldots,
1-n_{\\text{buckets}}^2, \\ldots, n_{\\text{buckets}}^1-n_{\\text{buckets}}^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,jt,Lt,Ys,or=`When training a model from scratch, it is recommended to leave <code>config.num_buckets=None</code>, so that depending on the
sequence length a good value for <code>num_buckets</code> is calculated on the fly. This value will then automatically be
saved in the config and should be reused for inference.`,Jt,O,Nn,qt,ii='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times n_s)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Ft,Ut,li='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times \\log(n_s))</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">))</span></span></span></span>',Wt,Ht,mi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Zt,It,Ks,St,se,rr=`Local self attention is essentially a “normal” self attention layer with key, query and value projections, but is
chunked so that in each chunk of length <code>config.local_chunk_length</code> the query embedding vectors only attends to
the key embedding vectors in its chunk and to the key embedding vectors of <code>config.local_num_chunks_before</code>
previous neighboring chunks and <code>config.local_num_chunks_after</code> following neighboring chunks.`,Nt,D,Vn,Vt,pi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times n_s)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Xt,Et,ci='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times \\log(n_s))</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">))</span></span></span></span>',At,Bt,di='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Pt,Qt,ee,Gt,ae,ir=`During training, we must ensure that the sequence length is set to a value that can be divided by the least common
multiple of <code>config.lsh_chunk_length</code> and <code>config.local_chunk_length</code> and that the parameters of the Axial
Positional Encodings are correctly set as described above. Reformer is very memory efficient so that the model can
easily be trained on sequences as long as 64000 tokens.`,Ot,te,lr='For training, the <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> should be used as follows:',Dt,ne,Yt,oe,Kt,re,mr='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',sn,ie,en,P,le,Xn,Ne,pr=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>. It is used to instantiate a
Reformer model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the ReFormer
<a href="https://huggingface.co/google/reformer-crime-and-punishment" rel="nofollow">google/reformer-crime-and-punishment</a> architecture.`,En,Ve,cr=`Configuration objects inherit from <a href="/docs/transformers/pr_31172/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31172/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,An,bs,an,me,tn,Q,pe,Bn,Xe,dr='Construct a Reformer tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> .',Pn,Ee,hr=`This tokenizer inherits from <a href="/docs/transformers/pr_31172/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Qn,Ae,ce,nn,de,on,ns,he,Gn,Be,gr=`Construct a “fast” Reformer tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=unigram#models" rel="nofollow">Unigram</a>.`,On,Pe,ur=`This tokenizer inherits from <a href="/docs/transformers/pr_31172/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,rn,ge,ln,S,ue,Dn,Qe,fr=`The bare Reformer Model transformer outputting raw hidden-stateswithout any specific head on top.
Reformer was proposed in <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev,
Łukasz Kaiser, Anselm Levskaya.`,Yn,Ge,_r=`This model inherits from <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Kn,Oe,br=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,so,Y,fe,eo,De,yr='The <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> forward method, overrides the <code>__call__</code> special method.',ao,ys,to,vs,mn,_e,pn,N,be,no,Ye,vr=`Reformer Model with a <code>language modeling</code> head on top.
Reformer was proposed in <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev,
Łukasz Kaiser, Anselm Levskaya.`,oo,Ke,wr=`This model inherits from <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ro,sa,kr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,io,K,ye,lo,ea,Mr='The <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> forward method, overrides the <code>__call__</code> special method.',mo,ws,po,ks,cn,ve,dn,V,we,co,aa,xr=`Reformer Model with a <code>language modeling</code> head on top.
Reformer was proposed in <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev,
Łukasz Kaiser, Anselm Levskaya.`,ho,ta,Tr=`This model inherits from <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,go,na,zr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,uo,Z,ke,fo,oa,$r='The <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',_o,Ms,bo,xs,yo,Ts,vo,zs,hn,Me,gn,U,xe,wo,ra,Rr=`Reformer Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,ko,ia,Cr=`Reformer was proposed in <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev,
Łukasz Kaiser, Anselm Levskaya.`,Mo,la,jr=`This model inherits from <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xo,ma,Lr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,To,E,Te,zo,pa,Jr='The <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$o,$s,Ro,Rs,Co,Cs,un,ze,fn,W,$e,jo,ca,qr=`Reformer Model with a span classification head on top for extractive question-answering tasks like SQuAD / TriviaQA
( a linear layer on top of hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>.`,Lo,da,Fr=`Reformer was proposed in <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev,
Łukasz Kaiser, Anselm Levskaya.`,Jo,ha,Ur=`This model inherits from <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qo,ga,Wr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Fo,ss,Re,Uo,ua,Hr='The <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Wo,js,Ho,Ls,_n,Ce,bn,wa,yn;return M=new I({props:{title:"Reformer",local:"reformer",headingTag:"h1"}}),Hs=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Vs=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Es=new I({props:{title:"Axial Positional Encodings",local:"axial-positional-encodings",headingTag:"h3"}}),Qs=new I({props:{title:"LSH Self Attention",local:"lsh-self-attention",headingTag:"h3"}}),Ks=new I({props:{title:"Local Self Attention",local:"local-self-attention",headingTag:"h3"}}),ee=new I({props:{title:"Training",local:"training",headingTag:"h3"}}),ne=new fs({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZSglMjJUaGlzJTIwaXMlMjBhJTIwc2VudGVuY2UlMjBmcm9tJTIwdGhlJTIwdHJhaW5pbmclMjBkYXRhJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb3NzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEaW5wdXRfaWRzKSU1QjAlNUQ=",highlighted:`input_ids = tokenizer.encode(<span class="hljs-string">&quot;This is a sentence from the training data&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
loss = model(input_ids, labels=input_ids)[<span class="hljs-number">0</span>]`,wrap:!1}}),oe=new I({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ie=new I({props:{title:"ReformerConfig",local:"transformers.ReformerConfig",headingTag:"h2"}}),le=new A({props:{name:"class transformers.ReformerConfig",anchor:"transformers.ReformerConfig",parameters:[{name:"attention_head_size",val:" = 64"},{name:"attn_layers",val:" = ['local', 'lsh', 'local', 'lsh', 'local', 'lsh']"},{name:"axial_norm_std",val:" = 1.0"},{name:"axial_pos_embds",val:" = True"},{name:"axial_pos_shape",val:" = [64, 64]"},{name:"axial_pos_embds_dim",val:" = [64, 192]"},{name:"chunk_size_lm_head",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"feed_forward_size",val:" = 512"},{name:"hash_seed",val:" = None"},{name:"hidden_act",val:" = 'relu'"},{name:"hidden_dropout_prob",val:" = 0.05"},{name:"hidden_size",val:" = 256"},{name:"initializer_range",val:" = 0.02"},{name:"is_decoder",val:" = False"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"local_num_chunks_before",val:" = 1"},{name:"local_num_chunks_after",val:" = 0"},{name:"local_attention_probs_dropout_prob",val:" = 0.05"},{name:"local_attn_chunk_length",val:" = 64"},{name:"lsh_attn_chunk_length",val:" = 64"},{name:"lsh_attention_probs_dropout_prob",val:" = 0.0"},{name:"lsh_num_chunks_before",val:" = 1"},{name:"lsh_num_chunks_after",val:" = 0"},{name:"max_position_embeddings",val:" = 4096"},{name:"num_attention_heads",val:" = 12"},{name:"num_buckets",val:" = None"},{name:"num_hashes",val:" = 1"},{name:"pad_token_id",val:" = 0"},{name:"vocab_size",val:" = 320"},{name:"tie_word_embeddings",val:" = False"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerConfig.attention_head_size",description:`<strong>attention_head_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality of the projected key, query and value vectors`,name:"attention_head_size"},{anchor:"transformers.ReformerConfig.attn_layers",description:`<strong>attn_layers</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&quot;local&quot;, &quot;lsh&quot;, &quot;local&quot;, &quot;lsh&quot;, &quot;local&quot;, &quot;lsh&quot;]</code>) &#x2014;
List of attention layer types in ascending order. It can be chosen between a LSHSelfAttention layer
(<code>&quot;lsh&quot;</code>) and a LocalSelfAttention layer (<code>&quot;local&quot;</code>).</p>
<p>For more information on LSHSelfAttention layer, see <a href="reformer#lsh-self-attention">LSH Self Attention</a>. For
more information on LocalSelfAttention layer, see <a href="reformer#local-self-attention">Local Self Attention</a>.`,name:"attn_layers"},{anchor:"transformers.ReformerConfig.axial_pos_embds",description:`<strong>axial_pos_embds</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use axial position embeddings. For more information on how axial position embeddings
work, see <a href="reformer#axial-positional-encodings">Axial Position Encodings</a>.`,name:"axial_pos_embds"},{anchor:"transformers.ReformerConfig.axial_norm_std",description:`<strong>axial_norm_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The standard deviation of the normal_initializer for initializing the weight matrices of the axial
positional encodings.`,name:"axial_norm_std"},{anchor:"transformers.ReformerConfig.axial_pos_shape",description:`<strong>axial_pos_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[64, 64]</code>) &#x2014;
The position dims of the axial position encodings. During training, the product of the position dims has to
be equal to the sequence length.</p>
<p>For more information on how axial position embeddings work, see <a href="reformer#axial-positional-encodings">Axial Position
Encodings</a>.`,name:"axial_pos_shape"},{anchor:"transformers.ReformerConfig.axial_pos_embds_dim",description:`<strong>axial_pos_embds_dim</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[64, 192]</code>) &#x2014;
The embedding dims of the axial position encodings. The sum of the embedding dims has to be equal to the
hidden size.</p>
<p>For more information on how axial position embeddings work, see <a href="reformer#axial-positional-encodings">Axial Position
Encodings</a>.`,name:"axial_pos_embds_dim"},{anchor:"transformers.ReformerConfig.chunk_size_lm_head",description:`<strong>chunk_size_lm_head</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The chunk size of the final language model feed forward head layer. A chunk size of 0 means that the feed
forward layer is not chunked. A chunk size of n means that the feed forward layer processes n &lt;
sequence_length embeddings at a time.</p>
<p>For more information on feed forward chunking, see <a href="../glossary#feed-forward-chunking">How does Feed Forward Chunking
work?</a>.`,name:"chunk_size_lm_head"},{anchor:"transformers.ReformerConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The token id for the end-of-sentence token.`,name:"eos_token_id"},{anchor:"transformers.ReformerConfig.feed_forward_size",description:`<strong>feed_forward_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the feed_forward layer in the residual attention block.`,name:"feed_forward_size"},{anchor:"transformers.ReformerConfig.hash_seed",description:`<strong>hash_seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed that can be used to make local sensitive hashing in <code>LSHSelfAttention</code> deterministic. This should only
be set for testing purposed. For evaluation and training purposes <code>hash_seed</code> should be left as <code>None</code> to
ensure fully random rotations in local sensitive hashing scheme.`,name:"hash_seed"},{anchor:"transformers.ReformerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the feed forward layer in the residual attention
block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.ReformerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.ReformerConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output hidden states of the residual attention blocks.`,name:"hidden_size"},{anchor:"transformers.ReformerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ReformerConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use a causal mask in addition to the <code>attention_mask</code> passed to <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>. When
using the Reformer for causal language modeling, this argument should be set to <code>True</code>.`,name:"is_decoder"},{anchor:"transformers.ReformerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ReformerConfig.local_chunk_length",description:`<strong>local_chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Length of chunk which attends to itself in <code>LocalSelfAttention</code>. Chunking reduces memory complexity from
sequence length x sequence length (self attention) to chunk length x chunk length x sequence length / chunk
length (chunked self attention).`,name:"local_chunk_length"},{anchor:"transformers.ReformerConfig.local_num_chunks_before",description:`<strong>local_num_chunks_before</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of previous neighbouring chunks to attend to in <code>LocalSelfAttention</code> layer to itself.`,name:"local_num_chunks_before"},{anchor:"transformers.ReformerConfig.local_num_chunks_after",description:`<strong>local_num_chunks_after</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of following neighbouring chunks to attend to in <code>LocalSelfAttention</code> layer in addition to itself.`,name:"local_num_chunks_after"},{anchor:"transformers.ReformerConfig.local_attention_probs_dropout_prob",description:`<strong>local_attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities in <code>LocalSelfAttention</code>.`,name:"local_attention_probs_dropout_prob"},{anchor:"transformers.ReformerConfig.lsh_attn_chunk_length",description:`<strong>lsh_attn_chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Length of chunk which attends to itself in <code>LSHSelfAttention</code>. Chunking reduces memory complexity from
sequence length x sequence length (self attention) to chunk length x chunk length x sequence length / chunk
length (chunked self attention).`,name:"lsh_attn_chunk_length"},{anchor:"transformers.ReformerConfig.lsh_num_chunks_before",description:`<strong>lsh_num_chunks_before</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of previous neighbouring chunks to attend to in <code>LSHSelfAttention</code> layer to itself.`,name:"lsh_num_chunks_before"},{anchor:"transformers.ReformerConfig.lsh_num_chunks_after",description:`<strong>lsh_num_chunks_after</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of following neighbouring chunks to attend to in <code>LSHSelfAttention</code> layer to itself.`,name:"lsh_num_chunks_after"},{anchor:"transformers.ReformerConfig.lsh_attention_probs_dropout_prob",description:`<strong>lsh_attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities in <code>LSHSelfAttention</code>.`,name:"lsh_attention_probs_dropout_prob"},{anchor:"transformers.ReformerConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.ReformerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ReformerConfig.num_buckets",description:`<strong>num_buckets</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
Number of buckets, the key query vectors can be &#x201C;hashed into&#x201D; using the locality sensitive hashing scheme.
Each query key vector is hashed into a hash in <code>1, ..., num_buckets</code>. The number of buckets can also be
factorized into a list for improved memory complexity. In this case, each query key vector is hashed into a
hash in <code>1-1, 1-2, ..., num_buckets[0]-1, ..., num_buckets[0]-num_buckets[1]</code> if <code>num_buckets</code> is
factorized into two factors. The number of buckets (or the product the factors) should approximately equal
sequence length / lsh_chunk_length. If <code>num_buckets</code> not set, a good value is calculated on the fly.`,name:"num_buckets"},{anchor:"transformers.ReformerConfig.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of hashing rounds (e.g., number of random rotations) in Local Sensitive Hashing scheme. The higher
<code>num_hashes</code>, the more accurate the <code>LSHSelfAttention</code> becomes, but also the more memory and time intensive
the hashing becomes.`,name:"num_hashes"},{anchor:"transformers.ReformerConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The token id for the padding token.`,name:"pad_token_id"},{anchor:"transformers.ReformerConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 320) &#x2014;\\
Vocabulary size of the Reformer model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>.`,name:"vocab_size"},{anchor:"transformers.ReformerConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie input and output embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.ReformerConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.ReformerConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/configuration_reformer.py#L25"}}),bs=new Ws({props:{anchor:"transformers.ReformerConfig.example",$$slots:{default:[yi]},$$scope:{ctx:T}}}),me=new I({props:{title:"ReformerTokenizer",local:"transformers.ReformerTokenizer",headingTag:"h2"}}),pe=new A({props:{name:"class transformers.ReformerTokenizer",anchor:"transformers.ReformerTokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"additional_special_tokens",val:" = []"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.ReformerTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.ReformerTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.ReformerTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.ReformerTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/tokenization_reformer.py#L35"}}),ce=new A({props:{name:"save_vocabulary",anchor:"transformers.ReformerTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/tokenization_reformer.py#L156"}}),de=new I({props:{title:"ReformerTokenizerFast",local:"transformers.ReformerTokenizerFast",headingTag:"h2"}}),he=new A({props:{name:"class transformers.ReformerTokenizerFast",anchor:"transformers.ReformerTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"additional_special_tokens",val:" = []"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.ReformerTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.ReformerTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.ReformerTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.ReformerTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/tokenization_reformer_fast.py#L39"}}),ge=new I({props:{title:"ReformerModel",local:"transformers.ReformerModel",headingTag:"h2"}}),ue=new A({props:{name:"class transformers.ReformerModel",anchor:"transformers.ReformerModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L1970"}}),fe=new A({props:{name:"forward",anchor:"transformers.ReformerModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"num_hashes",val:": Optional = None"},{name:"past_buckets_states",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ReformerModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31172/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerModel.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerModel.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31172/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2002",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.reformer.modeling_reformer.ReformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_predict, hidden_size)</code>) — Sequence of hidden-states at the last layer of the model.</p>
<p><code>num_predict</code> corresponds to <code>target_mapping.shape[1]</code>. If <code>target_mapping</code> is <code>None</code>, then <code>num_predict</code>
corresponds to <code>sequence_length</code>.</p>
</li>
<li>
<p><strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed buckets and hidden-states that can be used (see <code>past_buckets_states</code> input) to speed
up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings and one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.reformer.modeling_reformer.ReformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ys=new va({props:{$$slots:{default:[vi]},$$scope:{ctx:T}}}),vs=new Ws({props:{anchor:"transformers.ReformerModel.forward.example",$$slots:{default:[wi]},$$scope:{ctx:T}}}),_e=new I({props:{title:"ReformerModelWithLMHead",local:"transformers.ReformerModelWithLMHead",headingTag:"h2"}}),be=new A({props:{name:"class transformers.ReformerModelWithLMHead",anchor:"transformers.ReformerModelWithLMHead",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerModelWithLMHead.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2185"}}),ye=new A({props:{name:"forward",anchor:"transformers.ReformerModelWithLMHead.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"num_hashes",val:": Optional = None"},{name:"past_buckets_states",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ReformerModelWithLMHead.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31172/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerModelWithLMHead.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerModelWithLMHead.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerModelWithLMHead.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerModelWithLMHead.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerModelWithLMHead.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerModelWithLMHead.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerModelWithLMHead.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerModelWithLMHead.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerModelWithLMHead.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerModelWithLMHead.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31172/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ReformerModelWithLMHead.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ws=new va({props:{$$slots:{default:[ki]},$$scope:{ctx:T}}}),ks=new Ws({props:{anchor:"transformers.ReformerModelWithLMHead.forward.example",$$slots:{default:[Mi]},$$scope:{ctx:T}}}),ve=new I({props:{title:"ReformerForMaskedLM",local:"transformers.ReformerForMaskedLM",headingTag:"h2"}}),we=new A({props:{name:"class transformers.ReformerForMaskedLM",anchor:"transformers.ReformerForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2312"}}),ke=new A({props:{name:"forward",anchor:"transformers.ReformerForMaskedLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"num_hashes",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ReformerForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31172/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForMaskedLM.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForMaskedLM.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerForMaskedLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31172/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ReformerForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ms=new va({props:{$$slots:{default:[xi]},$$scope:{ctx:T}}}),xs=new va({props:{warning:!0,$$slots:{default:[Ti]},$$scope:{ctx:T}}}),Ts=new Ws({props:{anchor:"transformers.ReformerForMaskedLM.forward.example",$$slots:{default:[zi]},$$scope:{ctx:T}}}),zs=new Ws({props:{anchor:"transformers.ReformerForMaskedLM.forward.example-2",$$slots:{default:[$i]},$$scope:{ctx:T}}}),Me=new I({props:{title:"ReformerForSequenceClassification",local:"transformers.ReformerForSequenceClassification",headingTag:"h2"}}),xe=new A({props:{name:"class transformers.ReformerForSequenceClassification",anchor:"transformers.ReformerForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2437"}}),Te=new A({props:{name:"forward",anchor:"transformers.ReformerForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"num_hashes",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ReformerForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31172/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForSequenceClassification.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForSequenceClassification.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31172/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ReformerForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$s=new va({props:{$$slots:{default:[Ri]},$$scope:{ctx:T}}}),Rs=new Ws({props:{anchor:"transformers.ReformerForSequenceClassification.forward.example",$$slots:{default:[Ci]},$$scope:{ctx:T}}}),Cs=new Ws({props:{anchor:"transformers.ReformerForSequenceClassification.forward.example-2",$$slots:{default:[ji]},$$scope:{ctx:T}}}),ze=new I({props:{title:"ReformerForQuestionAnswering",local:"transformers.ReformerForQuestionAnswering",headingTag:"h2"}}),$e=new A({props:{name:"class transformers.ReformerForQuestionAnswering",anchor:"transformers.ReformerForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31172/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2584"}}),Re=new A({props:{name:"forward",anchor:"transformers.ReformerForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"num_hashes",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ReformerForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31172/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31172/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForQuestionAnswering.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForQuestionAnswering.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31172/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ReformerForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ReformerForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_31172/src/transformers/models/reformer/modeling_reformer.py#L2603",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31172/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31172/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),js=new va({props:{$$slots:{default:[Li]},$$scope:{ctx:T}}}),Ls=new Ws({props:{anchor:"transformers.ReformerForQuestionAnswering.forward.example",$$slots:{default:[Ji]},$$scope:{ctx:T}}}),Ce=new bi({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/reformer.md"}}),{c(){n=m("meta"),v=o(),c=m("p"),d=o(),g(M.$$.fragment),l=o(),x=m("div"),x.innerHTML=Zo,Ma=o(),g(Hs.$$.fragment),xa=o(),Zs=m("p"),Zs.innerHTML=Io,Ta=o(),Is=m("p"),Is.textContent=So,za=o(),Ss=m("p"),Ss.innerHTML=No,$a=o(),Ns=m("p"),Ns.innerHTML=Vo,Ra=o(),g(Vs.$$.fragment),Ca=o(),Xs=m("ul"),Xs.innerHTML=Xo,ja=o(),g(Es.$$.fragment),La=o(),C=m("p"),vn=w("Axial Positional Encodings were first implemented in Google’s "),_s=m("a"),_s.textContent=Eo,wn=w(`
and developed by the authors of this model’s paper. In models that are treating very long input sequences, the
conventional position id encodings store an embeddings vector of size`),Ja=new z(!1),qa=w(" being the "),je=m("code"),je.textContent=Ao,kn=w(` for
every position`),Fa=new z(!1),Ua=w(", with"),Wa=new z(!1),Ha=w(" being "),Le=m("code"),Le.textContent=Bo,Mn=w(`. This means that having
a sequence length of`),Za=new z(!1),Ia=w(" and a "),Je=m("code"),Je.textContent=Po,xn=w(" of"),Sa=new z(!1),Na=w(`
would result in a position encoding matrix:
`),Va=new z(!1),Xa=o(),gs=m("p"),Tn=w("which alone has over 500M parameters to store. Axial positional encodings factorize"),Ea=new z(!1),Aa=w(` into two matrices:
`),Ba=new z(!1),Pa=o(),As=m("p"),zn=w(`and
`),Qa=new z(!1),Ga=o(),Bs=m("p"),$n=w(`with:
`),Oa=new z(!1),Da=o(),Ps=m("p"),Rn=w(`Therefore the following holds:
`),Ya=new z(!1),Ka=o(),F=m("p"),Cn=w("Intuitively, this means that a position embedding vector"),st=new z(!1),et=w(` is now the composition of two
factorized embedding vectors:`),at=new z(!1),tt=w(", where as the "),qe=m("code"),qe.textContent=Qo,jn=w(" dimension"),nt=new z(!1),ot=w(" is factorized into"),rt=new z(!1),it=w(". This design ensures that each position embedding vector"),lt=new z(!1),mt=w(" is unique."),pt=o(),ms=m("p"),Ln=w("Using the above example again, axial position encoding with"),ct=new z(!1),dt=w(`
can drastically reduced the number of parameters from 500 000 000 to`),ht=new z(!1),gt=w(" parameters, this means 85% less memory usage."),ut=o(),L=m("p"),Jn=w("In practice, the parameter "),Fe=m("code"),Fe.textContent=Go,qn=w(" is set to a tuple"),ft=new z(!1),_t=w(` which sum has to be
equal to `),Ue=m("code"),Ue.textContent=Oo,Fn=w(" and "),We=m("code"),We.textContent=Do,Un=w(" is set to a tuple"),bt=new z(!1),yt=w(` which
product has to be equal to `),He=m("code"),He.textContent=Yo,Wn=w(", which during training has to be equal to the "),Ze=m("em"),Ze.textContent=Ko,Hn=w(" of the "),Ie=m("code"),Ie.textContent=sr,Zn=w("."),vt=o(),g(Qs.$$.fragment),wt=o(),Gs=m("p"),Gs.innerHTML=er,kt=o(),Os=m("p"),Os.innerHTML=ar,Mt=o(),Ds=m("p"),Ds.innerHTML=tr,xt=o(),X=m("p"),In=w("Note that "),Se=m("code"),Se.textContent=nr,Sn=w(" can also be factorized into a list"),Tt=new z(!1),zt=w(". This way instead of assigning the query key embedding vectors to one of"),$t=new z(!1),Rt=w(" they are assigned to one of"),Ct=new z(!1),jt=w(`. This is crucial for very long sequences to
save memory.`),Lt=o(),Ys=m("p"),Ys.innerHTML=or,Jt=o(),O=m("p"),Nn=w("Using LSH self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),qt=new z(!1),Ft=w(" to"),Ut=new z(!1),Wt=w(`, which usually represents the memory
and time bottleneck in a transformer model, with`),Ht=new z(!1),Zt=w(" being the sequence length."),It=o(),g(Ks.$$.fragment),St=o(),se=m("p"),se.innerHTML=rr,Nt=o(),D=m("p"),Vn=w("Using Local self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Vt=new z(!1),Xt=w(" to"),Et=new z(!1),At=w(`, which usually represents the memory
and time bottleneck in a transformer model, with`),Bt=new z(!1),Pt=w(" being the sequence length."),Qt=o(),g(ee.$$.fragment),Gt=o(),ae=m("p"),ae.innerHTML=ir,Ot=o(),te=m("p"),te.innerHTML=lr,Dt=o(),g(ne.$$.fragment),Yt=o(),g(oe.$$.fragment),Kt=o(),re=m("ul"),re.innerHTML=mr,sn=o(),g(ie.$$.fragment),en=o(),P=m("div"),g(le.$$.fragment),Xn=o(),Ne=m("p"),Ne.innerHTML=pr,En=o(),Ve=m("p"),Ve.innerHTML=cr,An=o(),g(bs.$$.fragment),an=o(),g(me.$$.fragment),tn=o(),Q=m("div"),g(pe.$$.fragment),Bn=o(),Xe=m("p"),Xe.innerHTML=dr,Pn=o(),Ee=m("p"),Ee.innerHTML=hr,Qn=o(),Ae=m("div"),g(ce.$$.fragment),nn=o(),g(de.$$.fragment),on=o(),ns=m("div"),g(he.$$.fragment),Gn=o(),Be=m("p"),Be.innerHTML=gr,On=o(),Pe=m("p"),Pe.innerHTML=ur,rn=o(),g(ge.$$.fragment),ln=o(),S=m("div"),g(ue.$$.fragment),Dn=o(),Qe=m("p"),Qe.innerHTML=fr,Yn=o(),Ge=m("p"),Ge.innerHTML=_r,Kn=o(),Oe=m("p"),Oe.innerHTML=br,so=o(),Y=m("div"),g(fe.$$.fragment),eo=o(),De=m("p"),De.innerHTML=yr,ao=o(),g(ys.$$.fragment),to=o(),g(vs.$$.fragment),mn=o(),g(_e.$$.fragment),pn=o(),N=m("div"),g(be.$$.fragment),no=o(),Ye=m("p"),Ye.innerHTML=vr,oo=o(),Ke=m("p"),Ke.innerHTML=wr,ro=o(),sa=m("p"),sa.innerHTML=kr,io=o(),K=m("div"),g(ye.$$.fragment),lo=o(),ea=m("p"),ea.innerHTML=Mr,mo=o(),g(ws.$$.fragment),po=o(),g(ks.$$.fragment),cn=o(),g(ve.$$.fragment),dn=o(),V=m("div"),g(we.$$.fragment),co=o(),aa=m("p"),aa.innerHTML=xr,ho=o(),ta=m("p"),ta.innerHTML=Tr,go=o(),na=m("p"),na.innerHTML=zr,uo=o(),Z=m("div"),g(ke.$$.fragment),fo=o(),oa=m("p"),oa.innerHTML=$r,_o=o(),g(Ms.$$.fragment),bo=o(),g(xs.$$.fragment),yo=o(),g(Ts.$$.fragment),vo=o(),g(zs.$$.fragment),hn=o(),g(Me.$$.fragment),gn=o(),U=m("div"),g(xe.$$.fragment),wo=o(),ra=m("p"),ra.textContent=Rr,ko=o(),ia=m("p"),ia.innerHTML=Cr,Mo=o(),la=m("p"),la.innerHTML=jr,xo=o(),ma=m("p"),ma.innerHTML=Lr,To=o(),E=m("div"),g(Te.$$.fragment),zo=o(),pa=m("p"),pa.innerHTML=Jr,$o=o(),g($s.$$.fragment),Ro=o(),g(Rs.$$.fragment),Co=o(),g(Cs.$$.fragment),un=o(),g(ze.$$.fragment),fn=o(),W=m("div"),g($e.$$.fragment),jo=o(),ca=m("p"),ca.innerHTML=qr,Lo=o(),da=m("p"),da.innerHTML=Fr,Jo=o(),ha=m("p"),ha.innerHTML=Ur,qo=o(),ga=m("p"),ga.innerHTML=Wr,Fo=o(),ss=m("div"),g(Re.$$.fragment),Uo=o(),ua=m("p"),ua.innerHTML=Hr,Wo=o(),g(js.$$.fragment),Ho=o(),g(Ls.$$.fragment),_n=o(),g(Ce.$$.fragment),bn=o(),wa=m("p"),this.h()},l(s){const a=_i("svelte-u9bgzb",document.head);n=p(a,"META",{name:!0,content:!0}),a.forEach(t),v=r(s),c=p(s,"P",{}),R(c).forEach(t),d=r(s),u(M.$$.fragment,s),l=r(s),x=p(s,"DIV",{class:!0,"data-svelte-h":!0}),h(x)!=="svelte-4wrvou"&&(x.innerHTML=Zo),Ma=r(s),u(Hs.$$.fragment,s),xa=r(s),Zs=p(s,"P",{"data-svelte-h":!0}),h(Zs)!=="svelte-j0navk"&&(Zs.innerHTML=Io),Ta=r(s),Is=p(s,"P",{"data-svelte-h":!0}),h(Is)!=="svelte-vfdo9a"&&(Is.textContent=So),za=r(s),Ss=p(s,"P",{"data-svelte-h":!0}),h(Ss)!=="svelte-1o1aozf"&&(Ss.innerHTML=No),$a=r(s),Ns=p(s,"P",{"data-svelte-h":!0}),h(Ns)!=="svelte-1vxy8gz"&&(Ns.innerHTML=Vo),Ra=r(s),u(Vs.$$.fragment,s),Ca=r(s),Xs=p(s,"UL",{"data-svelte-h":!0}),h(Xs)!=="svelte-ri2u9g"&&(Xs.innerHTML=Xo),ja=r(s),u(Es.$$.fragment,s),La=r(s),C=p(s,"P",{});var j=R(C);vn=k(j,"Axial Positional Encodings were first implemented in Google’s "),_s=p(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),h(_s)!=="svelte-djxu9"&&(_s.textContent=Eo),wn=k(j,`
and developed by the authors of this model’s paper. In models that are treating very long input sequences, the
conventional position id encodings store an embeddings vector of size`),Ja=$(j,!1),qa=k(j," being the "),je=p(j,"CODE",{"data-svelte-h":!0}),h(je)!=="svelte-6l7gp8"&&(je.textContent=Ao),kn=k(j,` for
every position`),Fa=$(j,!1),Ua=k(j,", with"),Wa=$(j,!1),Ha=k(j," being "),Le=p(j,"CODE",{"data-svelte-h":!0}),h(Le)!=="svelte-1vzjei2"&&(Le.textContent=Bo),Mn=k(j,`. This means that having
a sequence length of`),Za=$(j,!1),Ia=k(j," and a "),Je=p(j,"CODE",{"data-svelte-h":!0}),h(Je)!=="svelte-6l7gp8"&&(Je.textContent=Po),xn=k(j," of"),Sa=$(j,!1),Na=k(j,`
would result in a position encoding matrix:
`),Va=$(j,!1),j.forEach(t),Xa=r(s),gs=p(s,"P",{});var Js=R(gs);Tn=k(Js,"which alone has over 500M parameters to store. Axial positional encodings factorize"),Ea=$(Js,!1),Aa=k(Js,` into two matrices:
`),Ba=$(Js,!1),Js.forEach(t),Pa=r(s),As=p(s,"P",{});var fa=R(As);zn=k(fa,`and
`),Qa=$(fa,!1),fa.forEach(t),Ga=r(s),Bs=p(s,"P",{});var _a=R(Bs);$n=k(_a,`with:
`),Oa=$(_a,!1),_a.forEach(t),Da=r(s),Ps=p(s,"P",{});var ba=R(Ps);Rn=k(ba,`Therefore the following holds:
`),Ya=$(ba,!1),ba.forEach(t),Ka=r(s),F=p(s,"P",{});var H=R(F);Cn=k(H,"Intuitively, this means that a position embedding vector"),st=$(H,!1),et=k(H,` is now the composition of two
factorized embedding vectors:`),at=$(H,!1),tt=k(H,", where as the "),qe=p(H,"CODE",{"data-svelte-h":!0}),h(qe)!=="svelte-1vzjei2"&&(qe.textContent=Qo),jn=k(H," dimension"),nt=$(H,!1),ot=k(H," is factorized into"),rt=$(H,!1),it=k(H,". This design ensures that each position embedding vector"),lt=$(H,!1),mt=k(H," is unique."),H.forEach(t),pt=r(s),ms=p(s,"P",{});var us=R(ms);Ln=k(us,"Using the above example again, axial position encoding with"),ct=$(us,!1),dt=k(us,`
can drastically reduced the number of parameters from 500 000 000 to`),ht=$(us,!1),gt=k(us," parameters, this means 85% less memory usage."),us.forEach(t),ut=r(s),L=p(s,"P",{});var J=R(L);Jn=k(J,"In practice, the parameter "),Fe=p(J,"CODE",{"data-svelte-h":!0}),h(Fe)!=="svelte-bgblb7"&&(Fe.textContent=Go),qn=k(J," is set to a tuple"),ft=$(J,!1),_t=k(J,` which sum has to be
equal to `),Ue=p(J,"CODE",{"data-svelte-h":!0}),h(Ue)!=="svelte-6l7gp8"&&(Ue.textContent=Oo),Fn=k(J," and "),We=p(J,"CODE",{"data-svelte-h":!0}),h(We)!=="svelte-1k6g78u"&&(We.textContent=Do),Un=k(J," is set to a tuple"),bt=$(J,!1),yt=k(J,` which
product has to be equal to `),He=p(J,"CODE",{"data-svelte-h":!0}),h(He)!=="svelte-1vzjei2"&&(He.textContent=Yo),Wn=k(J,", which during training has to be equal to the "),Ze=p(J,"EM",{"data-svelte-h":!0}),h(Ze)!=="svelte-16lxu1p"&&(Ze.textContent=Ko),Hn=k(J," of the "),Ie=p(J,"CODE",{"data-svelte-h":!0}),h(Ie)!=="svelte-4gs31l"&&(Ie.textContent=sr),Zn=k(J,"."),J.forEach(t),vt=r(s),u(Qs.$$.fragment,s),wt=r(s),Gs=p(s,"P",{"data-svelte-h":!0}),h(Gs)!=="svelte-xd6oue"&&(Gs.innerHTML=er),kt=r(s),Os=p(s,"P",{"data-svelte-h":!0}),h(Os)!=="svelte-aoz16s"&&(Os.innerHTML=ar),Mt=r(s),Ds=p(s,"P",{"data-svelte-h":!0}),h(Ds)!=="svelte-uzsb76"&&(Ds.innerHTML=tr),xt=r(s),X=p(s,"P",{});var G=R(X);In=k(G,"Note that "),Se=p(G,"CODE",{"data-svelte-h":!0}),h(Se)!=="svelte-l93flo"&&(Se.textContent=nr),Sn=k(G," can also be factorized into a list"),Tt=$(G,!1),zt=k(G,". This way instead of assigning the query key embedding vectors to one of"),$t=$(G,!1),Rt=k(G," they are assigned to one of"),Ct=$(G,!1),jt=k(G,`. This is crucial for very long sequences to
save memory.`),G.forEach(t),Lt=r(s),Ys=p(s,"P",{"data-svelte-h":!0}),h(Ys)!=="svelte-1bjm2ay"&&(Ys.innerHTML=or),Jt=r(s),O=p(s,"P",{});var os=R(O);Nn=k(os,"Using LSH self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),qt=$(os,!1),Ft=k(os," to"),Ut=$(os,!1),Wt=k(os,`, which usually represents the memory
and time bottleneck in a transformer model, with`),Ht=$(os,!1),Zt=k(os," being the sequence length."),os.forEach(t),It=r(s),u(Ks.$$.fragment,s),St=r(s),se=p(s,"P",{"data-svelte-h":!0}),h(se)!=="svelte-1nbjwv1"&&(se.innerHTML=rr),Nt=r(s),D=p(s,"P",{});var rs=R(D);Vn=k(rs,"Using Local self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Vt=$(rs,!1),Xt=k(rs," to"),Et=$(rs,!1),At=k(rs,`, which usually represents the memory
and time bottleneck in a transformer model, with`),Bt=$(rs,!1),Pt=k(rs," being the sequence length."),rs.forEach(t),Qt=r(s),u(ee.$$.fragment,s),Gt=r(s),ae=p(s,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1p0w2ej"&&(ae.innerHTML=ir),Ot=r(s),te=p(s,"P",{"data-svelte-h":!0}),h(te)!=="svelte-28lzko"&&(te.innerHTML=lr),Dt=r(s),u(ne.$$.fragment,s),Yt=r(s),u(oe.$$.fragment,s),Kt=r(s),re=p(s,"UL",{"data-svelte-h":!0}),h(re)!=="svelte-1vlk5zq"&&(re.innerHTML=mr),sn=r(s),u(ie.$$.fragment,s),en=r(s),P=p(s,"DIV",{class:!0});var is=R(P);u(le.$$.fragment,is),Xn=r(is),Ne=p(is,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-fsmyvv"&&(Ne.innerHTML=pr),En=r(is),Ve=p(is,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-d7v1pr"&&(Ve.innerHTML=cr),An=r(is),u(bs.$$.fragment,is),is.forEach(t),an=r(s),u(me.$$.fragment,s),tn=r(s),Q=p(s,"DIV",{class:!0});var ls=R(Q);u(pe.$$.fragment,ls),Bn=r(ls),Xe=p(ls,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-jlmve2"&&(Xe.innerHTML=dr),Pn=r(ls),Ee=p(ls,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-9qjpes"&&(Ee.innerHTML=hr),Qn=r(ls),Ae=p(ls,"DIV",{class:!0});var ka=R(Ae);u(ce.$$.fragment,ka),ka.forEach(t),ls.forEach(t),nn=r(s),u(de.$$.fragment,s),on=r(s),ns=p(s,"DIV",{class:!0});var ya=R(ns);u(he.$$.fragment,ya),Gn=r(ya),Be=p(ya,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-qjebx3"&&(Be.innerHTML=gr),On=r(ya),Pe=p(ya,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-1wvk6kg"&&(Pe.innerHTML=ur),ya.forEach(t),rn=r(s),u(ge.$$.fragment,s),ln=r(s),S=p(s,"DIV",{class:!0});var ps=R(S);u(ue.$$.fragment,ps),Dn=r(ps),Qe=p(ps,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-15bk3ho"&&(Qe.innerHTML=fr),Yn=r(ps),Ge=p(ps,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-wgdzpu"&&(Ge.innerHTML=_r),Kn=r(ps),Oe=p(ps,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=br),so=r(ps),Y=p(ps,"DIV",{class:!0});var qs=R(Y);u(fe.$$.fragment,qs),eo=r(qs),De=p(qs,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1ln0uvl"&&(De.innerHTML=yr),ao=r(qs),u(ys.$$.fragment,qs),to=r(qs),u(vs.$$.fragment,qs),qs.forEach(t),ps.forEach(t),mn=r(s),u(_e.$$.fragment,s),pn=r(s),N=p(s,"DIV",{class:!0});var cs=R(N);u(be.$$.fragment,cs),no=r(cs),Ye=p(cs,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-orikjh"&&(Ye.innerHTML=vr),oo=r(cs),Ke=p(cs,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-wgdzpu"&&(Ke.innerHTML=wr),ro=r(cs),sa=p(cs,"P",{"data-svelte-h":!0}),h(sa)!=="svelte-hswkmf"&&(sa.innerHTML=kr),io=r(cs),K=p(cs,"DIV",{class:!0});var Fs=R(K);u(ye.$$.fragment,Fs),lo=r(Fs),ea=p(Fs,"P",{"data-svelte-h":!0}),h(ea)!=="svelte-122zl7h"&&(ea.innerHTML=Mr),mo=r(Fs),u(ws.$$.fragment,Fs),po=r(Fs),u(ks.$$.fragment,Fs),Fs.forEach(t),cs.forEach(t),cn=r(s),u(ve.$$.fragment,s),dn=r(s),V=p(s,"DIV",{class:!0});var ds=R(V);u(we.$$.fragment,ds),co=r(ds),aa=p(ds,"P",{"data-svelte-h":!0}),h(aa)!=="svelte-orikjh"&&(aa.innerHTML=xr),ho=r(ds),ta=p(ds,"P",{"data-svelte-h":!0}),h(ta)!=="svelte-wgdzpu"&&(ta.innerHTML=Tr),go=r(ds),na=p(ds,"P",{"data-svelte-h":!0}),h(na)!=="svelte-hswkmf"&&(na.innerHTML=zr),uo=r(ds),Z=p(ds,"DIV",{class:!0});var es=R(Z);u(ke.$$.fragment,es),fo=r(es),oa=p(es,"P",{"data-svelte-h":!0}),h(oa)!=="svelte-fohwg5"&&(oa.innerHTML=$r),_o=r(es),u(Ms.$$.fragment,es),bo=r(es),u(xs.$$.fragment,es),yo=r(es),u(Ts.$$.fragment,es),vo=r(es),u(zs.$$.fragment,es),es.forEach(t),ds.forEach(t),hn=r(s),u(Me.$$.fragment,s),gn=r(s),U=p(s,"DIV",{class:!0});var as=R(U);u(xe.$$.fragment,as),wo=r(as),ra=p(as,"P",{"data-svelte-h":!0}),h(ra)!=="svelte-tck2ey"&&(ra.textContent=Rr),ko=r(as),ia=p(as,"P",{"data-svelte-h":!0}),h(ia)!=="svelte-im1kvl"&&(ia.innerHTML=Cr),Mo=r(as),la=p(as,"P",{"data-svelte-h":!0}),h(la)!=="svelte-wgdzpu"&&(la.innerHTML=jr),xo=r(as),ma=p(as,"P",{"data-svelte-h":!0}),h(ma)!=="svelte-hswkmf"&&(ma.innerHTML=Lr),To=r(as),E=p(as,"DIV",{class:!0});var hs=R(E);u(Te.$$.fragment,hs),zo=r(hs),pa=p(hs,"P",{"data-svelte-h":!0}),h(pa)!=="svelte-4v4rkh"&&(pa.innerHTML=Jr),$o=r(hs),u($s.$$.fragment,hs),Ro=r(hs),u(Rs.$$.fragment,hs),Co=r(hs),u(Cs.$$.fragment,hs),hs.forEach(t),as.forEach(t),un=r(s),u(ze.$$.fragment,s),fn=r(s),W=p(s,"DIV",{class:!0});var ts=R(W);u($e.$$.fragment,ts),jo=r(ts),ca=p(ts,"P",{"data-svelte-h":!0}),h(ca)!=="svelte-12b2org"&&(ca.innerHTML=qr),Lo=r(ts),da=p(ts,"P",{"data-svelte-h":!0}),h(da)!=="svelte-im1kvl"&&(da.innerHTML=Fr),Jo=r(ts),ha=p(ts,"P",{"data-svelte-h":!0}),h(ha)!=="svelte-wgdzpu"&&(ha.innerHTML=Ur),qo=r(ts),ga=p(ts,"P",{"data-svelte-h":!0}),h(ga)!=="svelte-hswkmf"&&(ga.innerHTML=Wr),Fo=r(ts),ss=p(ts,"DIV",{class:!0});var Us=R(ss);u(Re.$$.fragment,Us),Uo=r(Us),ua=p(Us,"P",{"data-svelte-h":!0}),h(ua)!=="svelte-1r033yn"&&(ua.innerHTML=Hr),Wo=r(Us),u(js.$$.fragment,Us),Ho=r(Us),u(Ls.$$.fragment,Us),Us.forEach(t),ts.forEach(t),_n=r(s),u(Ce.$$.fragment,s),bn=r(s),wa=p(s,"P",{}),R(wa).forEach(t),this.h()},h(){q(n,"name","hf:doc:metadata"),q(n,"content",Fi),q(x,"class","flex flex-wrap space-x-1"),q(_s,"href","https://github.com/google/trax/blob/4d99ad4965bab1deba227539758d59f0df0fef48/trax/layers/research/position_encodings.py#L29"),q(_s,"rel","nofollow"),Ja.a=qa,Fa.a=Ua,Wa.a=Ha,Za.a=Ia,Sa.a=Na,Va.a=null,Ea.a=Aa,Ba.a=null,Qa.a=null,Oa.a=null,Ya.a=null,st.a=et,at.a=tt,nt.a=ot,rt.a=it,lt.a=mt,ct.a=dt,ht.a=gt,ft.a=_t,bt.a=yt,Tt.a=zt,$t.a=Rt,Ct.a=jt,qt.a=Ft,Ut.a=Wt,Ht.a=Zt,Vt.a=Xt,Et.a=At,Bt.a=Pt,q(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,a){e(document.head,n),i(s,v,a),i(s,c,a),i(s,d,a),f(M,s,a),i(s,l,a),i(s,x,a),i(s,Ma,a),f(Hs,s,a),i(s,xa,a),i(s,Zs,a),i(s,Ta,a),i(s,Is,a),i(s,za,a),i(s,Ss,a),i(s,$a,a),i(s,Ns,a),i(s,Ra,a),f(Vs,s,a),i(s,Ca,a),i(s,Xs,a),i(s,ja,a),f(Es,s,a),i(s,La,a),i(s,C,a),e(C,vn),e(C,_s),e(C,wn),Ja.m(Zr,C),e(C,qa),e(C,je),e(C,kn),Fa.m(Ir,C),e(C,Ua),Wa.m(Sr,C),e(C,Ha),e(C,Le),e(C,Mn),Za.m(Nr,C),e(C,Ia),e(C,Je),e(C,xn),Sa.m(Vr,C),e(C,Na),Va.m(Xr,C),i(s,Xa,a),i(s,gs,a),e(gs,Tn),Ea.m(Er,gs),e(gs,Aa),Ba.m(Ar,gs),i(s,Pa,a),i(s,As,a),e(As,zn),Qa.m(Br,As),i(s,Ga,a),i(s,Bs,a),e(Bs,$n),Oa.m(Pr,Bs),i(s,Da,a),i(s,Ps,a),e(Ps,Rn),Ya.m(Qr,Ps),i(s,Ka,a),i(s,F,a),e(F,Cn),st.m(Gr,F),e(F,et),at.m(Or,F),e(F,tt),e(F,qe),e(F,jn),nt.m(Dr,F),e(F,ot),rt.m(Yr,F),e(F,it),lt.m(Kr,F),e(F,mt),i(s,pt,a),i(s,ms,a),e(ms,Ln),ct.m(si,ms),e(ms,dt),ht.m(ei,ms),e(ms,gt),i(s,ut,a),i(s,L,a),e(L,Jn),e(L,Fe),e(L,qn),ft.m(ai,L),e(L,_t),e(L,Ue),e(L,Fn),e(L,We),e(L,Un),bt.m(ti,L),e(L,yt),e(L,He),e(L,Wn),e(L,Ze),e(L,Hn),e(L,Ie),e(L,Zn),i(s,vt,a),f(Qs,s,a),i(s,wt,a),i(s,Gs,a),i(s,kt,a),i(s,Os,a),i(s,Mt,a),i(s,Ds,a),i(s,xt,a),i(s,X,a),e(X,In),e(X,Se),e(X,Sn),Tt.m(ni,X),e(X,zt),$t.m(oi,X),e(X,Rt),Ct.m(ri,X),e(X,jt),i(s,Lt,a),i(s,Ys,a),i(s,Jt,a),i(s,O,a),e(O,Nn),qt.m(ii,O),e(O,Ft),Ut.m(li,O),e(O,Wt),Ht.m(mi,O),e(O,Zt),i(s,It,a),f(Ks,s,a),i(s,St,a),i(s,se,a),i(s,Nt,a),i(s,D,a),e(D,Vn),Vt.m(pi,D),e(D,Xt),Et.m(ci,D),e(D,At),Bt.m(di,D),e(D,Pt),i(s,Qt,a),f(ee,s,a),i(s,Gt,a),i(s,ae,a),i(s,Ot,a),i(s,te,a),i(s,Dt,a),f(ne,s,a),i(s,Yt,a),f(oe,s,a),i(s,Kt,a),i(s,re,a),i(s,sn,a),f(ie,s,a),i(s,en,a),i(s,P,a),f(le,P,null),e(P,Xn),e(P,Ne),e(P,En),e(P,Ve),e(P,An),f(bs,P,null),i(s,an,a),f(me,s,a),i(s,tn,a),i(s,Q,a),f(pe,Q,null),e(Q,Bn),e(Q,Xe),e(Q,Pn),e(Q,Ee),e(Q,Qn),e(Q,Ae),f(ce,Ae,null),i(s,nn,a),f(de,s,a),i(s,on,a),i(s,ns,a),f(he,ns,null),e(ns,Gn),e(ns,Be),e(ns,On),e(ns,Pe),i(s,rn,a),f(ge,s,a),i(s,ln,a),i(s,S,a),f(ue,S,null),e(S,Dn),e(S,Qe),e(S,Yn),e(S,Ge),e(S,Kn),e(S,Oe),e(S,so),e(S,Y),f(fe,Y,null),e(Y,eo),e(Y,De),e(Y,ao),f(ys,Y,null),e(Y,to),f(vs,Y,null),i(s,mn,a),f(_e,s,a),i(s,pn,a),i(s,N,a),f(be,N,null),e(N,no),e(N,Ye),e(N,oo),e(N,Ke),e(N,ro),e(N,sa),e(N,io),e(N,K),f(ye,K,null),e(K,lo),e(K,ea),e(K,mo),f(ws,K,null),e(K,po),f(ks,K,null),i(s,cn,a),f(ve,s,a),i(s,dn,a),i(s,V,a),f(we,V,null),e(V,co),e(V,aa),e(V,ho),e(V,ta),e(V,go),e(V,na),e(V,uo),e(V,Z),f(ke,Z,null),e(Z,fo),e(Z,oa),e(Z,_o),f(Ms,Z,null),e(Z,bo),f(xs,Z,null),e(Z,yo),f(Ts,Z,null),e(Z,vo),f(zs,Z,null),i(s,hn,a),f(Me,s,a),i(s,gn,a),i(s,U,a),f(xe,U,null),e(U,wo),e(U,ra),e(U,ko),e(U,ia),e(U,Mo),e(U,la),e(U,xo),e(U,ma),e(U,To),e(U,E),f(Te,E,null),e(E,zo),e(E,pa),e(E,$o),f($s,E,null),e(E,Ro),f(Rs,E,null),e(E,Co),f(Cs,E,null),i(s,un,a),f(ze,s,a),i(s,fn,a),i(s,W,a),f($e,W,null),e(W,jo),e(W,ca),e(W,Lo),e(W,da),e(W,Jo),e(W,ha),e(W,qo),e(W,ga),e(W,Fo),e(W,ss),f(Re,ss,null),e(ss,Uo),e(ss,ua),e(ss,Wo),f(js,ss,null),e(ss,Ho),f(Ls,ss,null),i(s,_n,a),f(Ce,s,a),i(s,bn,a),i(s,wa,a),yn=!0},p(s,[a]){const j={};a&2&&(j.$$scope={dirty:a,ctx:s}),bs.$set(j);const Js={};a&2&&(Js.$$scope={dirty:a,ctx:s}),ys.$set(Js);const fa={};a&2&&(fa.$$scope={dirty:a,ctx:s}),vs.$set(fa);const _a={};a&2&&(_a.$$scope={dirty:a,ctx:s}),ws.$set(_a);const ba={};a&2&&(ba.$$scope={dirty:a,ctx:s}),ks.$set(ba);const H={};a&2&&(H.$$scope={dirty:a,ctx:s}),Ms.$set(H);const us={};a&2&&(us.$$scope={dirty:a,ctx:s}),xs.$set(us);const J={};a&2&&(J.$$scope={dirty:a,ctx:s}),Ts.$set(J);const G={};a&2&&(G.$$scope={dirty:a,ctx:s}),zs.$set(G);const os={};a&2&&(os.$$scope={dirty:a,ctx:s}),$s.$set(os);const rs={};a&2&&(rs.$$scope={dirty:a,ctx:s}),Rs.$set(rs);const is={};a&2&&(is.$$scope={dirty:a,ctx:s}),Cs.$set(is);const ls={};a&2&&(ls.$$scope={dirty:a,ctx:s}),js.$set(ls);const ka={};a&2&&(ka.$$scope={dirty:a,ctx:s}),Ls.$set(ka)},i(s){yn||(_(M.$$.fragment,s),_(Hs.$$.fragment,s),_(Vs.$$.fragment,s),_(Es.$$.fragment,s),_(Qs.$$.fragment,s),_(Ks.$$.fragment,s),_(ee.$$.fragment,s),_(ne.$$.fragment,s),_(oe.$$.fragment,s),_(ie.$$.fragment,s),_(le.$$.fragment,s),_(bs.$$.fragment,s),_(me.$$.fragment,s),_(pe.$$.fragment,s),_(ce.$$.fragment,s),_(de.$$.fragment,s),_(he.$$.fragment,s),_(ge.$$.fragment,s),_(ue.$$.fragment,s),_(fe.$$.fragment,s),_(ys.$$.fragment,s),_(vs.$$.fragment,s),_(_e.$$.fragment,s),_(be.$$.fragment,s),_(ye.$$.fragment,s),_(ws.$$.fragment,s),_(ks.$$.fragment,s),_(ve.$$.fragment,s),_(we.$$.fragment,s),_(ke.$$.fragment,s),_(Ms.$$.fragment,s),_(xs.$$.fragment,s),_(Ts.$$.fragment,s),_(zs.$$.fragment,s),_(Me.$$.fragment,s),_(xe.$$.fragment,s),_(Te.$$.fragment,s),_($s.$$.fragment,s),_(Rs.$$.fragment,s),_(Cs.$$.fragment,s),_(ze.$$.fragment,s),_($e.$$.fragment,s),_(Re.$$.fragment,s),_(js.$$.fragment,s),_(Ls.$$.fragment,s),_(Ce.$$.fragment,s),yn=!0)},o(s){b(M.$$.fragment,s),b(Hs.$$.fragment,s),b(Vs.$$.fragment,s),b(Es.$$.fragment,s),b(Qs.$$.fragment,s),b(Ks.$$.fragment,s),b(ee.$$.fragment,s),b(ne.$$.fragment,s),b(oe.$$.fragment,s),b(ie.$$.fragment,s),b(le.$$.fragment,s),b(bs.$$.fragment,s),b(me.$$.fragment,s),b(pe.$$.fragment,s),b(ce.$$.fragment,s),b(de.$$.fragment,s),b(he.$$.fragment,s),b(ge.$$.fragment,s),b(ue.$$.fragment,s),b(fe.$$.fragment,s),b(ys.$$.fragment,s),b(vs.$$.fragment,s),b(_e.$$.fragment,s),b(be.$$.fragment,s),b(ye.$$.fragment,s),b(ws.$$.fragment,s),b(ks.$$.fragment,s),b(ve.$$.fragment,s),b(we.$$.fragment,s),b(ke.$$.fragment,s),b(Ms.$$.fragment,s),b(xs.$$.fragment,s),b(Ts.$$.fragment,s),b(zs.$$.fragment,s),b(Me.$$.fragment,s),b(xe.$$.fragment,s),b(Te.$$.fragment,s),b($s.$$.fragment,s),b(Rs.$$.fragment,s),b(Cs.$$.fragment,s),b(ze.$$.fragment,s),b($e.$$.fragment,s),b(Re.$$.fragment,s),b(js.$$.fragment,s),b(Ls.$$.fragment,s),b(Ce.$$.fragment,s),yn=!1},d(s){s&&(t(v),t(c),t(d),t(l),t(x),t(Ma),t(xa),t(Zs),t(Ta),t(Is),t(za),t(Ss),t($a),t(Ns),t(Ra),t(Ca),t(Xs),t(ja),t(La),t(C),t(Xa),t(gs),t(Pa),t(As),t(Ga),t(Bs),t(Da),t(Ps),t(Ka),t(F),t(pt),t(ms),t(ut),t(L),t(vt),t(wt),t(Gs),t(kt),t(Os),t(Mt),t(Ds),t(xt),t(X),t(Lt),t(Ys),t(Jt),t(O),t(It),t(St),t(se),t(Nt),t(D),t(Qt),t(Gt),t(ae),t(Ot),t(te),t(Dt),t(Yt),t(Kt),t(re),t(sn),t(en),t(P),t(an),t(tn),t(Q),t(nn),t(on),t(ns),t(rn),t(ln),t(S),t(mn),t(pn),t(N),t(cn),t(dn),t(V),t(hn),t(gn),t(U),t(un),t(fn),t(W),t(_n),t(bn),t(wa)),t(n),y(M,s),y(Hs,s),y(Vs,s),y(Es,s),y(Qs,s),y(Ks,s),y(ee,s),y(ne,s),y(oe,s),y(ie,s),y(le),y(bs),y(me,s),y(pe),y(ce),y(de,s),y(he),y(ge,s),y(ue),y(fe),y(ys),y(vs),y(_e,s),y(be),y(ye),y(ws),y(ks),y(ve,s),y(we),y(ke),y(Ms),y(xs),y(Ts),y(zs),y(Me,s),y(xe),y(Te),y($s),y(Rs),y(Cs),y(ze,s),y($e),y(Re),y(js),y(Ls),y(Ce,s)}}}const Fi='{"title":"Reformer","local":"reformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Axial Positional Encodings","local":"axial-positional-encodings","sections":[],"depth":3},{"title":"LSH Self Attention","local":"lsh-self-attention","sections":[],"depth":3},{"title":"Local Self Attention","local":"local-self-attention","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ReformerConfig","local":"transformers.ReformerConfig","sections":[],"depth":2},{"title":"ReformerTokenizer","local":"transformers.ReformerTokenizer","sections":[],"depth":2},{"title":"ReformerTokenizerFast","local":"transformers.ReformerTokenizerFast","sections":[],"depth":2},{"title":"ReformerModel","local":"transformers.ReformerModel","sections":[],"depth":2},{"title":"ReformerModelWithLMHead","local":"transformers.ReformerModelWithLMHead","sections":[],"depth":2},{"title":"ReformerForMaskedLM","local":"transformers.ReformerForMaskedLM","sections":[],"depth":2},{"title":"ReformerForSequenceClassification","local":"transformers.ReformerForSequenceClassification","sections":[],"depth":2},{"title":"ReformerForQuestionAnswering","local":"transformers.ReformerForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function Ui(T){return gi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xi extends ui{constructor(n){super(),fi(this,n,Ui,qi,hi,{})}}export{Xi as component};
