import{s as Yl,o as Nl,n as zs}from"../chunks/scheduler.f6b352c8.js";import{S as Fl,i as zl,g as i,s as n,r as M,A as Pl,h as p,f as s,c as a,j as Rs,u,x as o,k as xs,y as f,a as l,v as r,d as y,t as c,w as h,m as Ll,n as Dl}from"../chunks/index.6149cea3.js";import{T as Vs}from"../chunks/Tip.25311665.js";import{C as w}from"../chunks/CodeBlock.6f146ba5.js";import{H as J,E as Ol}from"../chunks/index.f7afb948.js";function Kl(C){let U,j=`If you provide inference only for LLMs and VLMs following the OpenAI API, you
can probably skip most of this section and just open a PR on
<a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a> to add you as a provider.`;return{c(){U=i("p"),U.innerHTML=j},l(d){U=p(d,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1j1u5a1"&&(U.innerHTML=j)},m(d,g){l(d,U,g)},p:zs,d(d){d&&s(U)}}}function en(C){let U,j=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){U=i("p"),U.innerHTML=j},l(d){U=p(d,"P",{"data-svelte-h":!0}),o(U)!=="svelte-19q0jcc"&&(U.innerHTML=j)},m(d,g){l(d,U,g)},p:zs,d(d){d&&s(U)}}}function tn(C){let U;return{c(){U=Ll("This is publicly accessible. It's useful to be transparent by default and it helps debug client SDKs, etc.")},l(j){U=Dl(j,"This is publicly accessible. It's useful to be transparent by default and it helps debug client SDKs, etc.")},m(j,d){l(j,U,d)},d(j){j&&s(U)}}}function sn(C){let U,j="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){U=i("p"),U.innerHTML=j},l(d){U=p(d,"P",{"data-svelte-h":!0}),o(U)!=="svelte-33g0sl"&&(U.innerHTML=j)},m(d,g){l(d,U,g)},p:zs,d(d){d&&s(U)}}}function ln(C){let U,j,d,g,q,Mt,_,Ps="If you’d like to be an inference provider on the Hub, you must follow the steps outlined in this guide.",ut,Z,rt,I,yt,G,Ls=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the huggingface.js repo:
<a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>`,ct,R,Ds=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation for other downstream SDKs like Python’s <code>huggingface-hub</code> and other tools.`,ht,x,Ut,V,Os=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,dt,b,Ks='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',mt,S,el='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',Tt,$,Jt,W,jt,E,tl=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,ft,X,sl=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,wt,H,ll='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',Ct,Q,gt,Y,nl="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation.",It,N,al="TODO",bt,F,$t,z,il=`Once you’ve verified the huggingface.js/inference client can call your models successfully, you
can use our Model Mapping API.`,vt,P,pl="This API lets a Partner “register” that they support model X, Y or Z on HF.",kt,L,ol="This enables:",Bt,D,Ml="<li>The inference widget on corresponding model pages</li> <li>Inference compatibility throughout the HF ecosystem (Python and JS client SDKs for instance), and any downstream tool or library</li>",At,O,qt,K,_t,ee,ul="Create a new mapping item, with the following body (JSON-encoded):",Zt,te,Gt,se,rl=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,Rt,le,yl="In the future, we will add support for a new parameter (ping us if it’s important to you now):",xt,ne,Vt,ae,St,ie,cl=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,Wt,pe,Et,oe,hl="The endpoint validates that:",Xt,Me,Ul=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,Ht,ue,Qt,re,Yt,ye,Nt,ce,dl="Call this HTTP PUT endpoint:",Ft,he,zt,Ue,ml="With the following body (JSON-encoded):",Pt,de,Lt,me,Dt,Te,Ot,Je,Tl="This gets all mapping items from the DB. For clarity/DX, the output is grouped by task.",Kt,v,es,je,Jl="Here is an example of response:",ts,fe,ss,we,ls,Ce,jl=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.`,ns,k,fl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',as,ge,wl=`For LLM providers, a workaround some people use is to extract numbers of input and output
tokens in the responses and multiply by a hardcoded pricing table – this is quite brittle, so we
are reluctant to do this.
We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,is,Ie,ps,be,Cl=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.`,os,$e,Ms,ve,gl=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,us,ke,rs,Be,ys,Ae,Il="We require the price to be an <strong>integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",cs,qe,hs,_e,bl=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,Us,Ze,$l="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",ds,Ge,vl="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",ms,Re,Ts,xe,Js,B,js,Ve,fs,Se,kl="Create a new file under src/huggingface_hub/inference/_providers/{provider_name}.py and copy-paste the following snippet.",ws,We,Bl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of _prepare_payload_as_dict or _prepare_payload_as_bytes must be overwritten.",Cs,Ee,Al="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",gs,Xe,ql="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",Is,He,bs,Qe,$s,Ye,_l='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',vs,Ne,ks,A,tt,Zl='<p>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</p>',Ss,m,st,Gl='Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_client.py" rel="nofollow">tests/test_inference_client.py</a> and add VCR tests:',Ws,lt,Rl="a. Add an entry to <code>_RECOMMENDED_MODELS_FOR_VCR</code> at the top of the test module. This contains a mapping task &lt;&gt; test model. model-id must be the HF model id.",Es,Fe,Xs,nt,xl=`b. Set up authentication: To record VCR cassettes, you’ll need authentication:
If you are a member of the provider organization (e.g., Replicate organization: <a href="https://huggingface.co/replicate" rel="nofollow">https://huggingface.co/replicate</a>), you can set the HF_INFERENCE_TEST_TOKEN environment variable with your HF token:`,Hs,ze,Qs,at,Vl="If you’re not a member but the provider is officially released on the Hub, you can set the HF_INFERENCE_TEST_TOKEN environment variable as above. If you don’t have enough inference credits, we can help you record the VCR cassettes.",Ys,it,Sl=`c. Record and commit tests
Run the tests for your provider:`,Ns,Pe,Fs,pt,Wl="d. Commit the generated VCR cassettes with your PR.",Bs,Le,As,De,El="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",qs,Oe,Xl="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",_s,Ke,Zs,ot,Gs;return q=new J({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),Z=new J({props:{title:"1. Requirements",local:"1-requirements",headingTag:"h2"}}),I=new Vs({props:{$$slots:{default:[Kl]},$$scope:{ctx:C}}}),x=new J({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),$=new Vs({props:{$$slots:{default:[en]},$$scope:{ctx:C}}}),W=new J({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Q=new J({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),F=new J({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),O=new J({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),K=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),te=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ne=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZGaWx0ZXIlMjIlM0ElMjAlNUIlMjJzdHJpbmclMjIlNUQlMjAlMkYlMkYlMjAoYm90aCUyMGNhbid0JTIwYmUlMjBkZWZpbmVkJTIwYXQlMjB0aGUlMjBzYW1lJTIwdGltZSklMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAlNUVQb3dlciUyMHVzZXIlMjBtb3ZlJTNBJTIwcmVnaXN0ZXIlMjBhJTIwJTIydGFnJTIyJTIwc2xpY2UlMjBvZiUyMEhGJTIwaW4lMjBvbmUlMjBnby4lMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBFeGFtcGxlJTNBJTIwdGFnJTIwJTNEJTNEJTIwJTIyYmFzZV9tb2RlbCUzQWFkYXB0ZXIlM0FibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMjBmb3IlMjBhbGwlMjBGbHV4LWRldiUyMExvUkFzJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfFilter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span> <span class="hljs-comment">// (both can&#x27;t be defined at the same time)</span>
    <span class="hljs-comment">// ^Power user move: register a &quot;tag&quot; slice of HF in one go.</span>
    <span class="hljs-comment">// Example: tag == &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot; for all Flux-dev LoRAs</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ae=new J({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),pe=new J({props:{title:"Validation",local:"validation",headingTag:"h4"}}),ue=new J({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),re=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRmhmTW9kZWwlM0RuYW1lc3BhY2UlMkZtb2RlbC1uYW1l",highlighted:"DELETE /api/partners/{provider}/models?hfModel=namespace/model-name",wrap:!1}}),ye=new J({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),he=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/status",wrap:!1}}),de=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZNb2RlbCUyMiUzQSUyMCUyMm5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMjIlMkMlMjAlMkYlMkYlMjBUaGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMG9uJTIwSEYlMEElMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJsaXZlJTIyJTIwJTdDJTIwJTIyc3RhZ2luZyUyMiUyMCUyRiUyRiUyMFRoZSUyMG5ldyUyMHN0YXR1cyUyQyUyMG9uZSUyMG9mJTIwJTIyc3RhZ2luZyUyMiUyMG9yJTIwJTIybGl2ZSUyMiUwQSU3RCUyMCUyMCUyMA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;namespace/model-name&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// The name of the model on HF</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),me=new J({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),Te=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),v=new Vs({props:{warning:!0,$$slots:{default:[tn]},$$scope:{ctx:C}}}),fe=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new J({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),Ie=new J({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),$e=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),ke=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),Be=new J({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),qe=new J({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),Re=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),xe=new J({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),B=new Vs({props:{$$slots:{default:[sn]},$$scope:{ctx:C}}}),Ve=new J({props:{title:"1. Implement the provider helper",local:"1-implement-the-provider-helper",headingTag:"h3"}}),He=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),Qe=new J({props:{title:"2. Register the Provider",local:"2-register-the-provider",headingTag:"h3"}}),Ne=new J({props:{title:"3. Add tests",local:"3-add-tests",headingTag:"h3"}}),Fe=new w({props:{code:"X1JFQ09NTUVOREVEX01PREVMU19GT1JfVkNSJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyeW91ci1wcm92aWRlciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJtb2RlbC1pZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUwQSU3RA==",highlighted:`_RECOMMENDED_MODELS_FOR_VCR = {
    <span class="hljs-string">&quot;your-provider&quot;</span>: {
        <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;model-id&quot;</span>,
        ...
    },
    ...
}`,wrap:!1}}),ze=new w({props:{code:"ZXhwb3J0JTIwSEZfSU5GRVJFTkNFX1RFU1RfVE9LRU4lM0QlMjJ5b3VyLWhmLXRva2VuJTIy",highlighted:'<span class="hljs-built_in">export</span> HF_INFERENCE_TEST_TOKEN=<span class="hljs-string">&quot;your-hf-token&quot;</span>',wrap:!1}}),Pe=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X2luZmVyZW5jZV9jbGllbnQucHklMjAtayUyMCUzQ3Byb3ZpZGVyJTNF",highlighted:"pytest tests/test_inference_client.py -k &lt;provider&gt;",wrap:!1}}),Le=new J({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),Ke=new Ol({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/api-inference/register-as-a-provider.md"}}),{c(){U=i("meta"),j=n(),d=i("p"),g=n(),M(q.$$.fragment),Mt=n(),_=i("p"),_.textContent=Ps,ut=n(),M(Z.$$.fragment),rt=n(),M(I.$$.fragment),yt=n(),G=i("p"),G.innerHTML=Ls,ct=n(),R=i("p"),R.innerHTML=Ds,ht=n(),M(x.$$.fragment),Ut=n(),V=i("p"),V.innerHTML=Os,dt=n(),b=i("div"),b.innerHTML=Ks,mt=n(),S=i("p"),S.innerHTML=el,Tt=n(),M($.$$.fragment),Jt=n(),M(W.$$.fragment),jt=n(),E=i("p"),E.textContent=tl,ft=n(),X=i("p"),X.textContent=sl,wt=n(),H=i("p"),H.innerHTML=ll,Ct=n(),M(Q.$$.fragment),gt=n(),Y=i("p"),Y.textContent=nl,It=n(),N=i("p"),N.textContent=al,bt=n(),M(F.$$.fragment),$t=n(),z=i("p"),z.textContent=il,vt=n(),P=i("p"),P.textContent=pl,kt=n(),L=i("p"),L.textContent=ol,Bt=n(),D=i("ul"),D.innerHTML=Ml,At=n(),M(O.$$.fragment),qt=n(),M(K.$$.fragment),_t=n(),ee=i("p"),ee.textContent=ul,Zt=n(),M(te.$$.fragment),Gt=n(),se=i("ul"),se.innerHTML=rl,Rt=n(),le=i("p"),le.textContent=yl,xt=n(),M(ne.$$.fragment),Vt=n(),M(ae.$$.fragment),St=n(),ie=i("p"),ie.innerHTML=cl,Wt=n(),M(pe.$$.fragment),Et=n(),oe=i("p"),oe.textContent=hl,Xt=n(),Me=i("ul"),Me.innerHTML=Ul,Ht=n(),M(ue.$$.fragment),Qt=n(),M(re.$$.fragment),Yt=n(),M(ye.$$.fragment),Nt=n(),ce=i("p"),ce.textContent=dl,Ft=n(),M(he.$$.fragment),zt=n(),Ue=i("p"),Ue.textContent=ml,Pt=n(),M(de.$$.fragment),Lt=n(),M(me.$$.fragment),Dt=n(),M(Te.$$.fragment),Ot=n(),Je=i("p"),Je.textContent=Tl,Kt=n(),M(v.$$.fragment),es=n(),je=i("p"),je.textContent=Jl,ts=n(),M(fe.$$.fragment),ss=n(),M(we.$$.fragment),ls=n(),Ce=i("p"),Ce.textContent=jl,ns=n(),k=i("div"),k.innerHTML=fl,as=n(),ge=i("p"),ge.textContent=wl,is=n(),M(Ie.$$.fragment),ps=n(),be=i("p"),be.textContent=Cl,os=n(),M($e.$$.fragment),Ms=n(),ve=i("p"),ve.textContent=gl,us=n(),M(ke.$$.fragment),rs=n(),M(Be.$$.fragment),ys=n(),Ae=i("p"),Ae.innerHTML=Il,cs=n(),M(qe.$$.fragment),hs=n(),_e=i("p"),_e.textContent=bl,Us=n(),Ze=i("p"),Ze.innerHTML=$l,ds=n(),Ge=i("p"),Ge.innerHTML=vl,ms=n(),M(Re.$$.fragment),Ts=n(),M(xe.$$.fragment),Js=n(),M(B.$$.fragment),js=n(),M(Ve.$$.fragment),fs=n(),Se=i("p"),Se.textContent=kl,ws=n(),We=i("p"),We.textContent=Bl,Cs=n(),Ee=i("p"),Ee.textContent=Al,gs=n(),Xe=i("p"),Xe.textContent=ql,Is=n(),M(He.$$.fragment),bs=n(),M(Qe.$$.fragment),$s=n(),Ye=i("ul"),Ye.innerHTML=_l,vs=n(),M(Ne.$$.fragment),ks=n(),A=i("ul"),tt=i("li"),tt.innerHTML=Zl,Ss=n(),m=i("li"),st=i("p"),st.innerHTML=Gl,Ws=n(),lt=i("p"),lt.innerHTML=Rl,Es=n(),M(Fe.$$.fragment),Xs=n(),nt=i("p"),nt.innerHTML=xl,Hs=n(),M(ze.$$.fragment),Qs=n(),at=i("p"),at.textContent=Vl,Ys=n(),it=i("p"),it.textContent=Sl,Ns=n(),M(Pe.$$.fragment),Fs=n(),pt=i("p"),pt.textContent=Wl,Bs=n(),M(Le.$$.fragment),As=n(),De=i("p"),De.innerHTML=El,qs=n(),Oe=i("p"),Oe.innerHTML=Xl,_s=n(),M(Ke.$$.fragment),Zs=n(),ot=i("p"),this.h()},l(e){const t=Pl("svelte-u9bgzb",document.head);U=p(t,"META",{name:!0,content:!0}),t.forEach(s),j=a(e),d=p(e,"P",{}),Rs(d).forEach(s),g=a(e),u(q.$$.fragment,e),Mt=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-7rl0ay"&&(_.textContent=Ps),ut=a(e),u(Z.$$.fragment,e),rt=a(e),u(I.$$.fragment,e),yt=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-fxovy7"&&(G.innerHTML=Ls),ct=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-opitfu"&&(R.innerHTML=Ds),ht=a(e),u(x.$$.fragment,e),Ut=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-hjt0h1"&&(V.innerHTML=Os),dt=a(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1cxy3tx"&&(b.innerHTML=Ks),mt=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-vmhaok"&&(S.innerHTML=el),Tt=a(e),u($.$$.fragment,e),Jt=a(e),u(W.$$.fragment,e),jt=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-epfhsj"&&(E.textContent=tl),ft=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-n5dyw"&&(X.textContent=sl),wt=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-qm2nt8"&&(H.innerHTML=ll),Ct=a(e),u(Q.$$.fragment,e),gt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-4pb4mv"&&(Y.textContent=nl),It=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1yyqpus"&&(N.textContent=al),bt=a(e),u(F.$$.fragment,e),$t=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-j5kevy"&&(z.textContent=il),vt=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-15r19t1"&&(P.textContent=pl),kt=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1cwa3cu"&&(L.textContent=ol),Bt=a(e),D=p(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-1qsdsie"&&(D.innerHTML=Ml),At=a(e),u(O.$$.fragment,e),qt=a(e),u(K.$$.fragment,e),_t=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-f1hll8"&&(ee.textContent=ul),Zt=a(e),u(te.$$.fragment,e),Gt=a(e),se=p(e,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-u6m976"&&(se.innerHTML=rl),Rt=a(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1h7c5bh"&&(le.textContent=yl),xt=a(e),u(ne.$$.fragment,e),Vt=a(e),u(ae.$$.fragment,e),St=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1avk6lq"&&(ie.innerHTML=cl),Wt=a(e),u(pe.$$.fragment,e),Et=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-pwj71q"&&(oe.textContent=hl),Xt=a(e),Me=p(e,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-1i002r6"&&(Me.innerHTML=Ul),Ht=a(e),u(ue.$$.fragment,e),Qt=a(e),u(re.$$.fragment,e),Yt=a(e),u(ye.$$.fragment,e),Nt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-18yjufw"&&(ce.textContent=dl),Ft=a(e),u(he.$$.fragment,e),zt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1ar1qn2"&&(Ue.textContent=ml),Pt=a(e),u(de.$$.fragment,e),Lt=a(e),u(me.$$.fragment,e),Dt=a(e),u(Te.$$.fragment,e),Ot=a(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1kylpkn"&&(Je.textContent=Tl),Kt=a(e),u(v.$$.fragment,e),es=a(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1ovcz13"&&(je.textContent=Jl),ts=a(e),u(fe.$$.fragment,e),ss=a(e),u(we.$$.fragment,e),ls=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-gjwsil"&&(Ce.textContent=jl),ns=a(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-1roilif"&&(k.innerHTML=fl),as=a(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-s1121n"&&(ge.textContent=wl),is=a(e),u(Ie.$$.fragment,e),ps=a(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-74sgny"&&(be.textContent=Cl),os=a(e),u($e.$$.fragment,e),Ms=a(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-krncuc"&&(ve.textContent=gl),us=a(e),u(ke.$$.fragment,e),rs=a(e),u(Be.$$.fragment,e),ys=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-cj93i4"&&(Ae.innerHTML=Il),cs=a(e),u(qe.$$.fragment,e),hs=a(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-speu7d"&&(_e.textContent=bl),Us=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-13ler1d"&&(Ze.innerHTML=$l),ds=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-ub059v"&&(Ge.innerHTML=vl),ms=a(e),u(Re.$$.fragment,e),Ts=a(e),u(xe.$$.fragment,e),Js=a(e),u(B.$$.fragment,e),js=a(e),u(Ve.$$.fragment,e),fs=a(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-ndg4of"&&(Se.textContent=kl),ws=a(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-12zx66o"&&(We.textContent=Bl),Cs=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-f0qt8k"&&(Ee.textContent=Al),gs=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-w9ft7n"&&(Xe.textContent=ql),Is=a(e),u(He.$$.fragment,e),bs=a(e),u(Qe.$$.fragment,e),$s=a(e),Ye=p(e,"UL",{"data-svelte-h":!0}),o(Ye)!=="svelte-117ozzs"&&(Ye.innerHTML=_l),vs=a(e),u(Ne.$$.fragment,e),ks=a(e),A=p(e,"UL",{});var et=Rs(A);tt=p(et,"LI",{"data-svelte-h":!0}),o(tt)!=="svelte-1vfmta3"&&(tt.innerHTML=Zl),Ss=a(et),m=p(et,"LI",{});var T=Rs(m);st=p(T,"P",{"data-svelte-h":!0}),o(st)!=="svelte-zxdjo4"&&(st.innerHTML=Gl),Ws=a(T),lt=p(T,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-4kwoah"&&(lt.innerHTML=Rl),Es=a(T),u(Fe.$$.fragment,T),Xs=a(T),nt=p(T,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ruiumy"&&(nt.innerHTML=xl),Hs=a(T),u(ze.$$.fragment,T),Qs=a(T),at=p(T,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1hfm5q3"&&(at.textContent=Vl),Ys=a(T),it=p(T,"P",{"data-svelte-h":!0}),o(it)!=="svelte-15tm9wv"&&(it.textContent=Sl),Ns=a(T),u(Pe.$$.fragment,T),Fs=a(T),pt=p(T,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1maspu4"&&(pt.textContent=Wl),T.forEach(s),et.forEach(s),Bs=a(e),u(Le.$$.fragment,e),As=a(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1yfr1yr"&&(De.innerHTML=El),qs=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1duzsqa"&&(Oe.innerHTML=Xl),_s=a(e),u(Ke.$$.fragment,e),Zs=a(e),ot=p(e,"P",{}),Rs(ot).forEach(s),this.h()},h(){xs(U,"name","hf:doc:metadata"),xs(U,"content",nn),xs(b,"class","flex justify-center"),xs(k,"class","flex justify-center")},m(e,t){f(document.head,U),l(e,j,t),l(e,d,t),l(e,g,t),r(q,e,t),l(e,Mt,t),l(e,_,t),l(e,ut,t),r(Z,e,t),l(e,rt,t),r(I,e,t),l(e,yt,t),l(e,G,t),l(e,ct,t),l(e,R,t),l(e,ht,t),r(x,e,t),l(e,Ut,t),l(e,V,t),l(e,dt,t),l(e,b,t),l(e,mt,t),l(e,S,t),l(e,Tt,t),r($,e,t),l(e,Jt,t),r(W,e,t),l(e,jt,t),l(e,E,t),l(e,ft,t),l(e,X,t),l(e,wt,t),l(e,H,t),l(e,Ct,t),r(Q,e,t),l(e,gt,t),l(e,Y,t),l(e,It,t),l(e,N,t),l(e,bt,t),r(F,e,t),l(e,$t,t),l(e,z,t),l(e,vt,t),l(e,P,t),l(e,kt,t),l(e,L,t),l(e,Bt,t),l(e,D,t),l(e,At,t),r(O,e,t),l(e,qt,t),r(K,e,t),l(e,_t,t),l(e,ee,t),l(e,Zt,t),r(te,e,t),l(e,Gt,t),l(e,se,t),l(e,Rt,t),l(e,le,t),l(e,xt,t),r(ne,e,t),l(e,Vt,t),r(ae,e,t),l(e,St,t),l(e,ie,t),l(e,Wt,t),r(pe,e,t),l(e,Et,t),l(e,oe,t),l(e,Xt,t),l(e,Me,t),l(e,Ht,t),r(ue,e,t),l(e,Qt,t),r(re,e,t),l(e,Yt,t),r(ye,e,t),l(e,Nt,t),l(e,ce,t),l(e,Ft,t),r(he,e,t),l(e,zt,t),l(e,Ue,t),l(e,Pt,t),r(de,e,t),l(e,Lt,t),r(me,e,t),l(e,Dt,t),r(Te,e,t),l(e,Ot,t),l(e,Je,t),l(e,Kt,t),r(v,e,t),l(e,es,t),l(e,je,t),l(e,ts,t),r(fe,e,t),l(e,ss,t),r(we,e,t),l(e,ls,t),l(e,Ce,t),l(e,ns,t),l(e,k,t),l(e,as,t),l(e,ge,t),l(e,is,t),r(Ie,e,t),l(e,ps,t),l(e,be,t),l(e,os,t),r($e,e,t),l(e,Ms,t),l(e,ve,t),l(e,us,t),r(ke,e,t),l(e,rs,t),r(Be,e,t),l(e,ys,t),l(e,Ae,t),l(e,cs,t),r(qe,e,t),l(e,hs,t),l(e,_e,t),l(e,Us,t),l(e,Ze,t),l(e,ds,t),l(e,Ge,t),l(e,ms,t),r(Re,e,t),l(e,Ts,t),r(xe,e,t),l(e,Js,t),r(B,e,t),l(e,js,t),r(Ve,e,t),l(e,fs,t),l(e,Se,t),l(e,ws,t),l(e,We,t),l(e,Cs,t),l(e,Ee,t),l(e,gs,t),l(e,Xe,t),l(e,Is,t),r(He,e,t),l(e,bs,t),r(Qe,e,t),l(e,$s,t),l(e,Ye,t),l(e,vs,t),r(Ne,e,t),l(e,ks,t),l(e,A,t),f(A,tt),f(A,Ss),f(A,m),f(m,st),f(m,Ws),f(m,lt),f(m,Es),r(Fe,m,null),f(m,Xs),f(m,nt),f(m,Hs),r(ze,m,null),f(m,Qs),f(m,at),f(m,Ys),f(m,it),f(m,Ns),r(Pe,m,null),f(m,Fs),f(m,pt),l(e,Bs,t),r(Le,e,t),l(e,As,t),l(e,De,t),l(e,qs,t),l(e,Oe,t),l(e,_s,t),r(Ke,e,t),l(e,Zs,t),l(e,ot,t),Gs=!0},p(e,[t]){const et={};t&2&&(et.$$scope={dirty:t,ctx:e}),I.$set(et);const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),$.$set(T);const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),v.$set(Hl);const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),B.$set(Ql)},i(e){Gs||(y(q.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(x.$$.fragment,e),y($.$$.fragment,e),y(W.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(ue.$$.fragment,e),y(re.$$.fragment,e),y(ye.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Te.$$.fragment,e),y(v.$$.fragment,e),y(fe.$$.fragment,e),y(we.$$.fragment,e),y(Ie.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(Be.$$.fragment,e),y(qe.$$.fragment,e),y(Re.$$.fragment,e),y(xe.$$.fragment,e),y(B.$$.fragment,e),y(Ve.$$.fragment,e),y(He.$$.fragment,e),y(Qe.$$.fragment,e),y(Ne.$$.fragment,e),y(Fe.$$.fragment,e),y(ze.$$.fragment,e),y(Pe.$$.fragment,e),y(Le.$$.fragment,e),y(Ke.$$.fragment,e),Gs=!0)},o(e){c(q.$$.fragment,e),c(Z.$$.fragment,e),c(I.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(W.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(O.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(re.$$.fragment,e),c(ye.$$.fragment,e),c(he.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(Te.$$.fragment,e),c(v.$$.fragment,e),c(fe.$$.fragment,e),c(we.$$.fragment,e),c(Ie.$$.fragment,e),c($e.$$.fragment,e),c(ke.$$.fragment,e),c(Be.$$.fragment,e),c(qe.$$.fragment,e),c(Re.$$.fragment,e),c(xe.$$.fragment,e),c(B.$$.fragment,e),c(Ve.$$.fragment,e),c(He.$$.fragment,e),c(Qe.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(ze.$$.fragment,e),c(Pe.$$.fragment,e),c(Le.$$.fragment,e),c(Ke.$$.fragment,e),Gs=!1},d(e){e&&(s(j),s(d),s(g),s(Mt),s(_),s(ut),s(rt),s(yt),s(G),s(ct),s(R),s(ht),s(Ut),s(V),s(dt),s(b),s(mt),s(S),s(Tt),s(Jt),s(jt),s(E),s(ft),s(X),s(wt),s(H),s(Ct),s(gt),s(Y),s(It),s(N),s(bt),s($t),s(z),s(vt),s(P),s(kt),s(L),s(Bt),s(D),s(At),s(qt),s(_t),s(ee),s(Zt),s(Gt),s(se),s(Rt),s(le),s(xt),s(Vt),s(St),s(ie),s(Wt),s(Et),s(oe),s(Xt),s(Me),s(Ht),s(Qt),s(Yt),s(Nt),s(ce),s(Ft),s(zt),s(Ue),s(Pt),s(Lt),s(Dt),s(Ot),s(Je),s(Kt),s(es),s(je),s(ts),s(ss),s(ls),s(Ce),s(ns),s(k),s(as),s(ge),s(is),s(ps),s(be),s(os),s(Ms),s(ve),s(us),s(rs),s(ys),s(Ae),s(cs),s(hs),s(_e),s(Us),s(Ze),s(ds),s(Ge),s(ms),s(Ts),s(Js),s(js),s(fs),s(Se),s(ws),s(We),s(Cs),s(Ee),s(gs),s(Xe),s(Is),s(bs),s($s),s(Ye),s(vs),s(ks),s(A),s(Bs),s(As),s(De),s(qs),s(Oe),s(_s),s(Zs),s(ot)),s(U),h(q,e),h(Z,e),h(I,e),h(x,e),h($,e),h(W,e),h(Q,e),h(F,e),h(O,e),h(K,e),h(te,e),h(ne,e),h(ae,e),h(pe,e),h(ue,e),h(re,e),h(ye,e),h(he,e),h(de,e),h(me,e),h(Te,e),h(v,e),h(fe,e),h(we,e),h(Ie,e),h($e,e),h(ke,e),h(Be,e),h(qe,e),h(Re,e),h(xe,e),h(B,e),h(Ve,e),h(He,e),h(Qe,e),h(Ne,e),h(Fe),h(ze),h(Pe),h(Le,e),h(Ke,e)}}}const nn='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Requirements","local":"1-requirements","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"1. Implement the provider helper","local":"1-implement-the-provider-helper","sections":[],"depth":3},{"title":"2. Register the Provider","local":"2-register-the-provider","sections":[],"depth":3},{"title":"3. Add tests","local":"3-add-tests","sections":[],"depth":3}],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function an(C){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends Fl{constructor(U){super(),zl(this,U,an,ln,Yl,{})}}export{yn as component};
