import{s as Ft,n as Pt,o as Dt}from"../chunks/scheduler.389d799c.js";import{S as Kt,i as Ot,g as i,s as n,r as d,A as el,h as o,f as l,c as a,j as qt,u as r,x as p,k as Vt,y as tl,a as s,v as y,d as h,t as c,w}from"../chunks/index.8f81d18f.js";import{C as T}from"../chunks/CodeBlock.3845caa1.js";import{H as M,E as ll}from"../chunks/EditOnGithub.33306dfe.js";function sl(ut){let u,Te,we,Me,m,me,J,Tt='Hugging Face Endpoints supports all of the Transformers and Sentence-Transformers tasks and can support custom tasks, including custom pre- &amp; post-processing. The customization can be done through a <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> file in your model repository on the Hugging Face Hub.',Je,f,Mt='The <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> needs to implement the <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">EndpointHandler</a> class with a <code>__init__</code> and a <code>__call__</code> method.',fe,I,mt='If you want to use custom dependencies, e.g. <a href="https://raw.githubusercontent.com/huggingface/optimum" rel="nofollow">optimum</a>, the dependencies must be listed in a <code>requirements.txt</code> as described above in “add custom dependencies.”',Ie,U,Ue,j,Jt='There are already several public examples on the <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Hugging Face Hub</a> where you can take insipiration or directly use them. The repositories are tagged with <code>endpoints-template</code> and can be found under this <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">link</a>.',je,b,ft="Included examples are for:",be,g,It='<li><a href="https://huggingface.co/philschmid/distilbert-onnx-banking77" rel="nofollow">Optimum and ONNX Runtime</a></li> <li><a href="https://huggingface.co/florentgbelidji/blip_image_embeddings" rel="nofollow">Image Embeddings with BLIP</a></li> <li><a href="https://huggingface.co/philschmid/trocr-base-printed" rel="nofollow">TrOCR for OCR Detection</a></li> <li><a href="https://huggingface.co/philschmid/all-MiniLM-L6-v2-optimum-embeddings" rel="nofollow">Optimized Sentence Transformers with Optimum</a></li> <li><a href="https://huggingface.co/philschmid/pyannote-speaker-diarization-endpoint" rel="nofollow">Pyannote Speaker diarization</a></li> <li><a href="https://huggingface.co/philschmid/layoutlm-funsd" rel="nofollow">LayoutLM</a></li> <li><a href="https://huggingface.co/philschmid/flair-ner-english-ontonotes-large" rel="nofollow">Flair NER</a></li> <li><a href="https://huggingface.co/philschmid/gpt-j-6B-fp16-sharded" rel="nofollow">GPT-J 6B Single GPU</a></li> <li><a href="https://huggingface.co/philschmid/donut-base-finetuned-cord-v2" rel="nofollow">Donut Document understanding</a></li> <li><a href="https://huggingface.co/philschmid/setfit-ag-news-endpoint" rel="nofollow">SetFit classifier</a></li>',ge,C,Ce,B,Ut='Before creating a Custom Handler, you need a Hugging Face Model repository with your model weights and an Access Token with <em>WRITE</em> access to the repository. To find, create and manage Access Tokens, click <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>.',Be,G,jt='If you want to write a Custom Handler for an existing model from the community, you can use the <a href="https://huggingface.co/spaces/osanseviero/repo_duplicator" rel="nofollow">repo_duplicator</a> to create a repository fork.',Ge,$,bt='The code can also be found in this <a href="https://colab.research.google.com/drive/1hANJeRa1PK1gZaUorobnQGu4bFj4_4Rf?usp=sharing" rel="nofollow">Notebook</a>.',$e,v,gt='You can also search for already existing Custom Handlers here: <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">https://huggingface.co/models?other=endpoints-template</a>',ve,H,He,_,Ct=`The easiest way to develop our custom handler is to set up a local development environment, to implement, test, and iterate there, and then deploy it as an Inference Endpoint. The first step is to install all required development dependencies.
<em>needed to create the custom handler, not needed for inference</em>`,_e,k,ke,x,Bt="After we have installed our libraries we will clone our repository to our development environment.",xe,Z,Gt='We will use <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion" rel="nofollow">philschmid/distilbert-base-uncased-emotion</a> during the tutorial.',Ze,E,Ee,W,$t="To be able to push our model repo later you need to login into our HF account. This can be done by using the <code>huggingface-cli</code>.",We,R,vt="<em>Note: Make sure to configure git config as well.</em>",Re,N,Ne,S,Se,A,Ht="After we have set up our environment, we can start creating your custom handler. The custom handler is a Python class (<code>EndpointHandler</code>) inside a <code>handler.py</code> file in our repository. The <code>EndpointHandler</code> needs to implement an <code>__init__</code> and a <code>__call__</code> method.",Ae,Y,_t="<li>The <code>__init__</code> method will be called when starting the Endpoint and will receive 1 argument, a string with the path to your model weights. This allows you to load your model correctly.</li> <li>The <code>__call__</code> method will be called on every request and receive a dictionary with your request body as a python dictionary. It will always contain the <code>inputs</code> key.</li>",Ye,z,kt="The first step is to create our <code>handler.py</code> in the local clone of our repository.",ze,Q,Qe,X,xt="In there, you define your <code>EndpointHandler</code> class with the <code>__init__</code> and <code>__call__ </code>method.",Xe,L,Le,q,qe,V,Zt='Now, you can add all of the custom logic you want to use during initialization or inference to your Custom Endpoint. You can already find multiple <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Custom Handler on the Hub</a> if you need some inspiration. In our example, we will add a custom condition based on additional payload information.',Ve,F,Et="<em>The model we are using in the tutorial is fine-tuned to detect emotions. We will add an additional payload field for the date, and will use an external package to check if it is a holiday, to add a condition so that when the input date is a holiday, the model returns “happy” - since everyone is happy when there are holidays </em>🌴🎉😆",Fe,P,Wt='First, we need to create a new <code>requirements.txt</code> and add our <a href="https://pypi.org/project/holidays/" rel="nofollow">holiday detection package</a> and make sure we have it installed in our development environment as well.',Pe,D,De,K,Rt="Next, we have to adjust our <code>handler.py</code> and <code>EndpointHandler</code> to match our condition.",Ke,O,Oe,ee,et,te,Nt="To test our EndpointHandler, we can simplify import, initialize and test it. Therefore we only need to prepare a sample payload.",tt,le,lt,se,St="It works!!!! 🎉",st,ne,At="<em>Note: If you are using a notebook you might have to restart your kernel when you make changes to the handler.py since it is not automatically re-imported.</em>",nt,ae,at,ie,Yt="After you have successfully tested your handler locally, you can push it to your repository by simply using basic git commands.",it,oe,ot,pe,zt='Now, you should see your <code>handler.py</code> and <code>requirements.txt</code> in your repository in the <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion/tree/main" rel="nofollow">“Files and version”</a> tab.',pt,de,dt,re,Qt="The last step is to deploy your Custom Handler as an Inference Endpoint. You can deploy your Custom Handler like you would a regular Inference Endpoint. Add your repository, select your cloud and region, your instance and security setting, and deploy.",rt,ye,Xt="When creating your Endpoint, the Inference Endpoint Service will check for an available and valid <code>handler.py</code>, and will use it for serving requests no matter which “Task” you select.",yt,he,Lt='<em>Note: In your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">Inference Endpoints dashboard</a>, the Task for this Endpoint should now be set to Custom</em>',ht,ce,ct,ue,wt;return m=new M({props:{title:"Create custom Inference Handler",local:"create-custom-inference-handler",headingTag:"h1"}}),U=new M({props:{title:"Custom Handler Examples",local:"custom-handler-examples",headingTag:"h2"}}),C=new M({props:{title:"Tutorial",local:"tutorial",headingTag:"h2"}}),H=new M({props:{title:"1. Set up Development Environment",local:"1-set-up-development-environment",headingTag:"h3"}}),k=new T({props:{code:"JTIzJTIwaW5zdGFsbCUyMGdpdC1sZnMlMjB0byUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMHJlcG9zaXRvcnklMEFzdWRvJTIwYXB0LWdldCUyMHVwZGF0ZSUwQXN1ZG8lMjBhcHQtZ2V0JTIwaW5zdGFsbCUyMGdpdC1sZnMlMEElMjMlMjBpbnN0YWxsJTIwdHJhbnNmb3JtZXJzJTIwKG5vdCUyMG5lZWRlZCUyMHNpbmNlJTIwaXQlMjBpcyUyMGluc3RhbGxlZCUyMGJ5JTIwZGVmYXVsdCUyMGluJTIwdGhlJTIwY29udGFpbmVyKSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlNUJza2xlYXJuJTJDc2VudGVuY2VwaWVjZSUyQ2F1ZGlvJTJDdmlzaW9uJTVE",highlighted:`<span class="hljs-comment"># install git-lfs to interact with the repository</span>
sudo apt-<span class="hljs-built_in">get</span> update
sudo apt-<span class="hljs-built_in">get</span> install git-lfs
<span class="hljs-comment"># install transformers (not needed since it is installed by default in the container)</span>
pip install transformers[sklearn,sentencepiece,audio,vision]`,wrap:!1}}),E=new T({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnBoaWxzY2htaWQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1lbW90aW9u",highlighted:`git lfs install
git clone https:<span class="hljs-regexp">//</span>huggingface.co<span class="hljs-regexp">/philschmid/</span>distilbert-base-uncased-emotion`,wrap:!1}}),N=new T({props:{code:"JTIzJTIwc2V0dXAlMjBjbGklMjB3aXRoJTIwdG9rZW4lMEFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUwQWdpdCUyMGNvbmZpZyUyMC0tZ2xvYmFsJTIwY3JlZGVudGlhbC5oZWxwZXIlMjBzdG9yZQ==",highlighted:`# setup <span class="hljs-keyword">cli</span> with <span class="hljs-keyword">token</span>
huggingface-<span class="hljs-keyword">cli</span> login
git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),S=new M({props:{title:"2. Create EndpointHandler",local:"2-create-endpointhandler",headingTag:"h3"}}),Q=new T({props:{code:"IWNkJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZW1vdGlvbiUyMCUyNiUyNiUyMHRvdWNoJTIwaGFuZGxlci5weQ==",highlighted:'!<span class="hljs-built_in">cd</span> distilbert-base-uncased-emotion &amp;&amp; <span class="hljs-built_in">touch</span> handler.py',wrap:!1}}),L=new T({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBMaXN0JTJDJTIwQW55JTBBJTBBY2xhc3MlMjBFbmRwb2ludEhhbmRsZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBwYXRoJTNEJTIyJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByZWxvYWQlMjBhbGwlMjB0aGUlMjBlbGVtZW50cyUyMHlvdSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBuZWVkJTIwYXQlMjBpbmZlcmVuY2UuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbCUzRCUyMGxvYWRfbW9kZWwocGF0aCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwZGF0YSUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMGFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAoJTNBb2JqJTNBJTIwJTYwc3RyJTYwJTIwJTdDJTIwJTYwUElMLkltYWdlJTYwJTIwJTdDJTIwJTYwbnAuYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwUmV0dXJuJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMCUzQW9iaiUzQSU2MGxpc3QlNjAlMjAlN0MlMjAlNjBkaWN0JTYwJTNBJTIwd2lsbCUyMGJlJTIwc2VyaWFsaXplZCUyMGFuZCUyMHJldHVybmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbChpbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        <span class="hljs-comment"># Preload all the elements you are going to need at inference.</span>
        <span class="hljs-comment"># pseudo:</span>
        <span class="hljs-comment"># self.model= load_model(path)</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\` | \`PIL.Image\` | \`np.array\`)
            kwargs
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>

        <span class="hljs-comment"># pseudo</span>
        <span class="hljs-comment"># self.model(input)</span>`,wrap:!1}}),q=new M({props:{title:"3. Customize EndpointHandler",local:"3-customize-endpointhandler",headingTag:"h3"}}),D=new T({props:{code:"IWVjaG8lMjAlMjJob2xpZGF5cyUyMiUyMCUzRSUzRSUyMHJlcXVpcmVtZW50cy50eHQlMEEhcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`!echo <span class="hljs-string">&quot;holidays&quot;</span> &gt;&gt; requirements.txt
!pip install -r requirements.txt`,wrap:!1}}),O=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> holidays

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        self.pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,model=path)
        self.holidays = holidays.US()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\`)
            date (:obj: \`str\`)
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># get inputs</span>
        inputs = data.pop(<span class="hljs-string">&quot;inputs&quot;</span>,data)
        date = data.pop(<span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-literal">None</span>)

        <span class="hljs-comment"># check if date exists and if it is a holiday</span>
        <span class="hljs-keyword">if</span> date <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> date <span class="hljs-keyword">in</span> self.holidays:
          <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;happy&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}]


        <span class="hljs-comment"># run normal prediction</span>
        prediction = self.pipeline(inputs)
        <span class="hljs-keyword">return</span> prediction`,wrap:!1}}),ee=new M({props:{title:"4. Test EndpointHandler",local:"4-test-endpointhandler",headingTag:"h3"}}),le=new T({props:{code:"ZnJvbSUyMGhhbmRsZXIlMjBpbXBvcnQlMjBFbmRwb2ludEhhbmRsZXIlMEElMEElMjMlMjBpbml0JTIwaGFuZGxlciUwQW15X2hhbmRsZXIlMjAlM0QlMjBFbmRwb2ludEhhbmRsZXIocGF0aCUzRCUyMi4lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMHNhbXBsZSUyMHBheWxvYWQlMEFub25faG9saWRheV9wYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySSUyMGFtJTIwcXVpdGUlMjBleGNpdGVkJTIwaG93JTIwdGhpcyUyMHdpbGwlMjB0dXJuJTIwb3V0JTIyJTJDJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjItMDgtMDglMjIlN0QlMEFob2xpZGF5X3BheWxvYWQlMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlMjJUb2RheSUyMGlzJTIwYSUyMHRob3VnaCUyMGRheSUyMiUyQyUyMCUyMmRhdGUlMjIlM0ElMjAlMjIyMDIyLTA3LTA0JTIyJTdEJTBBJTBBJTIzJTIwdGVzdCUyMHRoZSUyMGhhbmRsZXIlMEFub25faG9saWRheV9wcmVkJTNEbXlfaGFuZGxlcihub25faG9saWRheV9wYXlsb2FkKSUwQWhvbGlkYXlfcGF5bG9hZCUzRG15X2hhbmRsZXIoaG9saWRheV9wYXlsb2FkKSUwQSUwQSUyMyUyMHNob3clMjByZXN1bHRzJTBBcHJpbnQoJTIybm9uX2hvbGlkYXlfcHJlZCUyMiUyQyUyMG5vbl9ob2xpZGF5X3ByZWQpJTBBcHJpbnQoJTIyaG9saWRheV9wYXlsb2FkJTIyJTJDJTIwaG9saWRheV9wYXlsb2FkKSUwQSUwQSUyMyUyMG5vbl9ob2xpZGF5X3ByZWQlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ2pveSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTg1OTQyMjQ0NTI5NzI0JTdEJTVEJTBBJTIzJTIwaG9saWRheV9wYXlsb2FkJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdoYXBweSclMkMlMjAnc2NvcmUnJTNBJTIwMSU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> handler <span class="hljs-keyword">import</span> EndpointHandler

<span class="hljs-comment"># init handler</span>
my_handler = EndpointHandler(path=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># prepare sample payload</span>
non_holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;I am quite excited how this will turn out&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-08-08&quot;</span>}
holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Today is a though day&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-07-04&quot;</span>}

<span class="hljs-comment"># test the handler</span>
non_holiday_pred=my_handler(non_holiday_payload)
holiday_payload=my_handler(holiday_payload)

<span class="hljs-comment"># show results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;non_holiday_pred&quot;</span>, non_holiday_pred)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;holiday_payload&quot;</span>, holiday_payload)

<span class="hljs-comment"># non_holiday_pred [{&#x27;label&#x27;: &#x27;joy&#x27;, &#x27;score&#x27;: 0.9985942244529724}]</span>
<span class="hljs-comment"># holiday_payload [{&#x27;label&#x27;: &#x27;happy&#x27;, &#x27;score&#x27;: 1}]</span>`,wrap:!1}}),ae=new M({props:{title:"5. Push the Custom Handler to your repository",local:"5-push-the-custom-handler-to-your-repository",headingTag:"h3"}}),oe=new T({props:{code:"JTIzJTIwYWRkJTIwYWxsJTIwb3VyJTIwbmV3JTIwZmlsZXMlMEEhZ2l0JTIwYWRkJTIwKiUwQSUyMyUyMGNvbW1pdCUyMG91ciUyMGZpbGVzJTBBIWdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyYWRkJTIwY3VzdG9tJTIwaGFuZGxlciUyMiUwQSUyMyUyMHB1c2glMjB0aGUlMjBmaWxlcyUyMHRvJTIwdGhlJTIwaHViJTBBIWdpdCUyMHB1c2g=",highlighted:`# <span class="hljs-built_in">add</span> <span class="hljs-keyword">all</span> our <span class="hljs-keyword">new</span> <span class="hljs-keyword">files</span>
!git <span class="hljs-built_in">add</span> *
# commit our <span class="hljs-keyword">files</span>
!git commit -<span class="hljs-keyword">m</span> <span class="hljs-string">&quot;add custom handler&quot;</span>
# push the <span class="hljs-keyword">files</span> <span class="hljs-keyword">to</span> the hub
!git push`,wrap:!1}}),de=new M({props:{title:"6. Deploy your Custom Handler as an Inference Endpoint",local:"6-deploy-your-custom-handler-as-an-inference-endpoint",headingTag:"h3"}}),ce=new ll({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/guides/custom_handler.mdx"}}),{c(){u=i("meta"),Te=n(),we=i("p"),Me=n(),d(m.$$.fragment),me=n(),J=i("p"),J.innerHTML=Tt,Je=n(),f=i("p"),f.innerHTML=Mt,fe=n(),I=i("p"),I.innerHTML=mt,Ie=n(),d(U.$$.fragment),Ue=n(),j=i("p"),j.innerHTML=Jt,je=n(),b=i("p"),b.textContent=ft,be=n(),g=i("ul"),g.innerHTML=It,ge=n(),d(C.$$.fragment),Ce=n(),B=i("p"),B.innerHTML=Ut,Be=n(),G=i("p"),G.innerHTML=jt,Ge=n(),$=i("p"),$.innerHTML=bt,$e=n(),v=i("p"),v.innerHTML=gt,ve=n(),d(H.$$.fragment),He=n(),_=i("p"),_.innerHTML=Ct,_e=n(),d(k.$$.fragment),ke=n(),x=i("p"),x.textContent=Bt,xe=n(),Z=i("p"),Z.innerHTML=Gt,Ze=n(),d(E.$$.fragment),Ee=n(),W=i("p"),W.innerHTML=$t,We=n(),R=i("p"),R.innerHTML=vt,Re=n(),d(N.$$.fragment),Ne=n(),d(S.$$.fragment),Se=n(),A=i("p"),A.innerHTML=Ht,Ae=n(),Y=i("ul"),Y.innerHTML=_t,Ye=n(),z=i("p"),z.innerHTML=kt,ze=n(),d(Q.$$.fragment),Qe=n(),X=i("p"),X.innerHTML=xt,Xe=n(),d(L.$$.fragment),Le=n(),d(q.$$.fragment),qe=n(),V=i("p"),V.innerHTML=Zt,Ve=n(),F=i("p"),F.innerHTML=Et,Fe=n(),P=i("p"),P.innerHTML=Wt,Pe=n(),d(D.$$.fragment),De=n(),K=i("p"),K.innerHTML=Rt,Ke=n(),d(O.$$.fragment),Oe=n(),d(ee.$$.fragment),et=n(),te=i("p"),te.textContent=Nt,tt=n(),d(le.$$.fragment),lt=n(),se=i("p"),se.textContent=St,st=n(),ne=i("p"),ne.innerHTML=At,nt=n(),d(ae.$$.fragment),at=n(),ie=i("p"),ie.textContent=Yt,it=n(),d(oe.$$.fragment),ot=n(),pe=i("p"),pe.innerHTML=zt,pt=n(),d(de.$$.fragment),dt=n(),re=i("p"),re.textContent=Qt,rt=n(),ye=i("p"),ye.innerHTML=Xt,yt=n(),he=i("p"),he.innerHTML=Lt,ht=n(),d(ce.$$.fragment),ct=n(),ue=i("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),we=o(e,"P",{}),qt(we).forEach(l),Me=a(e),r(m.$$.fragment,e),me=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-utxjdb"&&(J.innerHTML=Tt),Je=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-nd5753"&&(f.innerHTML=Mt),fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-rirnor"&&(I.innerHTML=mt),Ie=a(e),r(U.$$.fragment,e),Ue=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-6ei6y6"&&(j.innerHTML=Jt),je=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-wxy1ws"&&(b.textContent=ft),be=a(e),g=o(e,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-hgiuvk"&&(g.innerHTML=It),ge=a(e),r(C.$$.fragment,e),Ce=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1lc7u48"&&(B.innerHTML=Ut),Be=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-131h02t"&&(G.innerHTML=jt),Ge=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-xuocio"&&($.innerHTML=bt),$e=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-16in619"&&(v.innerHTML=gt),ve=a(e),r(H.$$.fragment,e),He=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-s875rd"&&(_.innerHTML=Ct),_e=a(e),r(k.$$.fragment,e),ke=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-12klzx5"&&(x.textContent=Bt),xe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ms7r4w"&&(Z.innerHTML=Gt),Ze=a(e),r(E.$$.fragment,e),Ee=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-54lmtl"&&(W.innerHTML=$t),We=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-k22wa5"&&(R.innerHTML=vt),Re=a(e),r(N.$$.fragment,e),Ne=a(e),r(S.$$.fragment,e),Se=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1dqini1"&&(A.innerHTML=Ht),Ae=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1gdza5u"&&(Y.innerHTML=_t),Ye=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1xwwutb"&&(z.innerHTML=kt),ze=a(e),r(Q.$$.fragment,e),Qe=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-16cpa65"&&(X.innerHTML=xt),Xe=a(e),r(L.$$.fragment,e),Le=a(e),r(q.$$.fragment,e),qe=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-uax0tq"&&(V.innerHTML=Zt),Ve=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1f0seln"&&(F.innerHTML=Et),Fe=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1fqhyg1"&&(P.innerHTML=Wt),Pe=a(e),r(D.$$.fragment,e),De=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1s8qwlb"&&(K.innerHTML=Rt),Ke=a(e),r(O.$$.fragment,e),Oe=a(e),r(ee.$$.fragment,e),et=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-4es9m7"&&(te.textContent=Nt),tt=a(e),r(le.$$.fragment,e),lt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-vtyfqm"&&(se.textContent=St),st=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-15zdf0d"&&(ne.innerHTML=At),nt=a(e),r(ae.$$.fragment,e),at=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1ii6eax"&&(ie.textContent=Yt),it=a(e),r(oe.$$.fragment,e),ot=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-8xlhlw"&&(pe.innerHTML=zt),pt=a(e),r(de.$$.fragment,e),dt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-n8fnak"&&(re.textContent=Qt),rt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1uvy9xv"&&(ye.innerHTML=Xt),yt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-hwhuk5"&&(he.innerHTML=Lt),ht=a(e),r(ce.$$.fragment,e),ct=a(e),ue=o(e,"P",{}),qt(ue).forEach(l),this.h()},h(){Vt(u,"name","hf:doc:metadata"),Vt(u,"content",nl)},m(e,t){tl(document.head,u),s(e,Te,t),s(e,we,t),s(e,Me,t),y(m,e,t),s(e,me,t),s(e,J,t),s(e,Je,t),s(e,f,t),s(e,fe,t),s(e,I,t),s(e,Ie,t),y(U,e,t),s(e,Ue,t),s(e,j,t),s(e,je,t),s(e,b,t),s(e,be,t),s(e,g,t),s(e,ge,t),y(C,e,t),s(e,Ce,t),s(e,B,t),s(e,Be,t),s(e,G,t),s(e,Ge,t),s(e,$,t),s(e,$e,t),s(e,v,t),s(e,ve,t),y(H,e,t),s(e,He,t),s(e,_,t),s(e,_e,t),y(k,e,t),s(e,ke,t),s(e,x,t),s(e,xe,t),s(e,Z,t),s(e,Ze,t),y(E,e,t),s(e,Ee,t),s(e,W,t),s(e,We,t),s(e,R,t),s(e,Re,t),y(N,e,t),s(e,Ne,t),y(S,e,t),s(e,Se,t),s(e,A,t),s(e,Ae,t),s(e,Y,t),s(e,Ye,t),s(e,z,t),s(e,ze,t),y(Q,e,t),s(e,Qe,t),s(e,X,t),s(e,Xe,t),y(L,e,t),s(e,Le,t),y(q,e,t),s(e,qe,t),s(e,V,t),s(e,Ve,t),s(e,F,t),s(e,Fe,t),s(e,P,t),s(e,Pe,t),y(D,e,t),s(e,De,t),s(e,K,t),s(e,Ke,t),y(O,e,t),s(e,Oe,t),y(ee,e,t),s(e,et,t),s(e,te,t),s(e,tt,t),y(le,e,t),s(e,lt,t),s(e,se,t),s(e,st,t),s(e,ne,t),s(e,nt,t),y(ae,e,t),s(e,at,t),s(e,ie,t),s(e,it,t),y(oe,e,t),s(e,ot,t),s(e,pe,t),s(e,pt,t),y(de,e,t),s(e,dt,t),s(e,re,t),s(e,rt,t),s(e,ye,t),s(e,yt,t),s(e,he,t),s(e,ht,t),y(ce,e,t),s(e,ct,t),s(e,ue,t),wt=!0},p:Pt,i(e){wt||(h(m.$$.fragment,e),h(U.$$.fragment,e),h(C.$$.fragment,e),h(H.$$.fragment,e),h(k.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),wt=!0)},o(e){c(m.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c(H.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),wt=!1},d(e){e&&(l(Te),l(we),l(Me),l(me),l(J),l(Je),l(f),l(fe),l(I),l(Ie),l(Ue),l(j),l(je),l(b),l(be),l(g),l(ge),l(Ce),l(B),l(Be),l(G),l(Ge),l($),l($e),l(v),l(ve),l(He),l(_),l(_e),l(ke),l(x),l(xe),l(Z),l(Ze),l(Ee),l(W),l(We),l(R),l(Re),l(Ne),l(Se),l(A),l(Ae),l(Y),l(Ye),l(z),l(ze),l(Qe),l(X),l(Xe),l(Le),l(qe),l(V),l(Ve),l(F),l(Fe),l(P),l(Pe),l(De),l(K),l(Ke),l(Oe),l(et),l(te),l(tt),l(lt),l(se),l(st),l(ne),l(nt),l(at),l(ie),l(it),l(ot),l(pe),l(pt),l(dt),l(re),l(rt),l(ye),l(yt),l(he),l(ht),l(ct),l(ue)),l(u),w(m,e),w(U,e),w(C,e),w(H,e),w(k,e),w(E,e),w(N,e),w(S,e),w(Q,e),w(L,e),w(q,e),w(D,e),w(O,e),w(ee,e),w(le,e),w(ae,e),w(oe,e),w(de,e),w(ce,e)}}}const nl='{"title":"Create custom Inference Handler","local":"create-custom-inference-handler","sections":[{"title":"Custom Handler Examples","local":"custom-handler-examples","sections":[],"depth":2},{"title":"Tutorial","local":"tutorial","sections":[{"title":"1. Set up Development Environment","local":"1-set-up-development-environment","sections":[],"depth":3},{"title":"2. Create EndpointHandler","local":"2-create-endpointhandler","sections":[],"depth":3},{"title":"3. Customize EndpointHandler","local":"3-customize-endpointhandler","sections":[],"depth":3},{"title":"4. Test EndpointHandler","local":"4-test-endpointhandler","sections":[],"depth":3},{"title":"5. Push the Custom Handler to your repository","local":"5-push-the-custom-handler-to-your-repository","sections":[],"depth":3},{"title":"6. Deploy your Custom Handler as an Inference Endpoint","local":"6-deploy-your-custom-handler-as-an-inference-endpoint","sections":[],"depth":3}],"depth":2}],"depth":1}';function al(ut){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends Kt{constructor(u){super(),Ot(this,u,al,sl,Ft,{})}}export{rl as component};
