import{s as Mn,f as Rt,n as cn,o as hn}from"../chunks/scheduler.048ce5c2.js";import{S as Cn,i as un,g as l,s as a,r as p,A as Bn,h as o,f as e,c as n,j as Un,u as r,x as i,k as gt,y as gn,a as s,v as w,d as j,t as f,w as U}from"../chunks/index.2633050f.js";import{C as M}from"../chunks/CodeBlock.b34ffc90.js";import{D as mn}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as c,E as dn}from"../chunks/EditOnGithub.336973dd.js";function Jn(Xs){let h,Kt,yt,Qt,C,vt,u,Dt,B,Ws="Sometimes it is helpful to consider the simplest possible version of something to better understand how it works. We’re going to try that in this notebook, beginning with a ‘toy’ diffusion model to see how the different pieces work, and then examining how they differ from a more complex implementation.",Tt,g,Es="We will look at",Pt,m,zs="<li>The corruption process (adding noise to data)</li> <li>What a UNet is, and how to implement an extremely minimal one from scratch</li> <li>Diffusion model training</li> <li>Sampling theory</li>",xt,d,Ss="Then we’ll compare our versions with the diffusers DDPM implementation, exploring",Ht,J,Vs="<li>Improvements over our mini UNet</li> <li>The DDPM noise schedule</li> <li>Differences in training objective</li> <li>Timestep conditioning</li> <li>Sampling approaches</li>",kt,b,Zs="This notebook is fairly in-depth, and can safely be skipped if you’re not excited about a from-scratch deep dive!",Gt,F,Ls="It is also worth noting that most of the code here is for illustrative purposes, and I wouldn’t recommend directly adopting any of it for your own work (unless you’re just trying improve on the examples shown here for learning purposes).",Nt,y,Xt,I,Wt,R,Os=`\x1B[K     |████████████████████████████████| 255 kB 16.0 MB/s 
\x1B[K     |████████████████████████████████| 163 kB 53.9 MB/s 
\x1B[?25h
`,Et,K,zt,Q,qs=`Using device: cuda
`,St,v,Vt,D,Ys="Here we’re going to test things with a very small dataset: mnist. If you’d like to give the model a slightly harder challenge without changing anything else, torchvision.datasets.FashionMNIST should work as a drop-in replacement.",Zt,T,Lt,P,_s=`Downloading http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz
Downloading http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz to mnist/MNIST/raw/train-images-idx3-ubyte.gz
`,Ot,x,qt,H,Yt,k,$s=`Input shape: torch.Size([8, 1, 28, 28])
Labels: tensor([1, 9, 7, 3, 5, 2, 1, 4])
`,_t,G,Aa="Each image is a greyscale 28px by 28px drawing of a digit, with values ranging from 0 to 1.",$t,N,Ae,X,ta="Pretend you haven’t read any diffusion model papers, but you know the process involves adding noise. How would you do it?",te,W,ea="We probably want an easy way to control the amount of corruption. So what if we take in a parameter for the <code>amount</code> of noise to add, and then we do:",ee,E,sa="<code>noise = torch.rand_like(x)</code>",se,z,aa="<code>noisy_x = (1-amount)*x + amount*noise</code>",ae,S,na="If amount = 0, we get back the input without any changes. If amount gets up to 1, we get back noise with no trace of the input x. By mixing the input with noise this way, we keep the output in the same range (0 to 1).",ne,V,la="We can implement this fairly easily (just watch the shapes so you don’t get burnt by broadcasting rules):",le,Z,oe,L,oa="And looking at the results visually to see that it works as expected:",ie,O,pe,mt,ia,re,q,pa="As noise amount approaches one, our data begins to look like pure random noise. But for most noise amounts, you can guess the digit fairly well. Do you think this is optimal?",we,Y,je,_,ra='We’d like a model that takes in a 28px noisy images and outputs a prediction of the same shape. A popular choice here is an architecture called a UNet. <a href="https://arxiv.org/abs/1505.04597" rel="nofollow">Originally invented for segmentation tasks in medical imagery</a>, a UNet consists of a ‘constricting path’ through which data is compressed down and an ‘expanding path’ through which it expands back up to the original dimension (similar to an autoencoder) but also features skip connections that allow for information and gradients to flow across at different levels.',fe,$,wa="Some UNets feature complex blocks at each stage, but for this toy demo we’ll build a minimal example that takes in a one-channel image and passes it through three convolutional layers on the down path (the down_layers in the diagram and code) and three on the up path, with skip connections between the down and up layers. We’ll use max pooling for downsampling and <code>nn.Upsample</code> for upsampling rather than relying on learnable layers like more complex UNets. Here is the rough architecture showing the number of channels in the output of each layer:",Ue,AA,ja='<img src="data:image/png;base64,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" alt="unet_diag.png"/>',Me,tA,fa="This is what that looks like in code:",ce,eA,he,sA,Ua="We can verify that the output shape is the same as the input, as we expect:",Ce,aA,ue,nA,Ma="This network has just over 300,000 parameters:",Be,lA,ge,oA,ca="You can explore changing the number of channels in each layer or swapping in different architectures if you want.",me,iA,de,pA,ha="So what should the model do, exactly? Again, there are various takes on this but for this demo let’s pick a simple framing: given a corrupted input noisy_x the model should output its best guess for what the original x looks like. We will compare this to the actual value via the mean squared error.",Je,rA,Ca="We can now have a go at training the network.",be,wA,ua="<li>Get a batch of data</li> <li>Corrupt it by random amounts</li> <li>Feed it through the model</li> <li>Compare the model predictions with the clean images to calculate our loss</li> <li>Update the model’s parameters accordingly.</li>",Fe,jA,Ba="Feel free to modify this and see if you can get it working better!",ye,fA,Ie,UA,ga=`Finished epoch 0. Average loss for this epoch: 0.026736
Finished epoch 1. Average loss for this epoch: 0.020692
Finished epoch 2. Average loss for this epoch: 0.018887
`,Re,MA,ma="We can try to see what the model predictions look like by grabbing a batch of data, corrupting it by different amounts and then seeing the models predictions:",Ke,cA,Qe,dt,da,ve,hA,Ja="You can see that for the lower amounts the predictions are pretty good! But as the level gets very high there is less for the model to work with, and by the time we get to amount=1 it outputs a blurry mess close to the mean of the dataset to try and hedge its bets on what the output might look like…",De,CA,Te,uA,ba="If our predictions at high noise levels aren’t very good, how do we generate images?",Pe,BA,Fa="Well, what if we start from random noise, look at the model predictions but then only move a small amount towards that prediction - say, 20% of the way there. Now we have a very noisy image in which there is perhaps a hint of structure, which we can feed into the model to get a new prediction. The hope is that this new prediction is slightly better than the first one (since our starting point is slightly less noisy) and so we can take another small step with this new, better prediction.",xe,gA,ya="Repeat a few times and (if all goes well) we get an image out! Here is that process illustrated over just 5 steps, visualizing the model input (left) and the predicted denoised images (right) at each stage. Note that even though the model predicts the denoised image even at step 1, we only move x part of the way there. Over a few steps the structures appear and are refined, until we get our final outputs.",He,mA,ke,Jt,Ia,Ge,dA,Ra="We can split the process up into more steps, and hope for better images that way:",Ne,JA,Xe,bt,Ka,We,bA,Qa="Not great, but there are some recognizable digits there! You can experiment with training for longer (say, 10 or 20 epochs) and tweaking model config, learning rate, optimizer and so on. Also, don’t forget that fashionMNIST is a one-line replacement if you want a slightly harder dataset to try.",Ee,FA,ze,yA,va='In this section we’ll take a look at how our toy implementation differs from the approach used in the other notebook (<a href="https://github.com/huggingface/diffusion-models-class/blob/main/unit1/01_introduction_to_diffusers.ipynb" rel="nofollow">Introduction to Diffusers</a>), which is based on the DDPM paper.',Se,IA,Da="We’ll see that",Ve,RA,Ta="<li>The diffusers <code>UNet2DModel</code> is a bit more advanced than our BasicUNet</li> <li>The corruption process in handled differently</li> <li>The training objective is different, involving predicting the noise rather than the denoised image</li> <li>The model is conditioned on the amount of noise present via timestep conditioning, where t is passed as an additional argument to the forward method.</li> <li>There are a number of different sampling strategies available, which should work better than our simplistic version above.</li>",Ze,KA,Pa='There have been a number of improvements suggested since the DDPM paper came out, but this example is hopefully instructive as to the different available design decisions. Once you’ve read through this, you may enjoy diving into the paper <a href="https://arxiv.org/abs/2206.00364" rel="nofollow">‘Elucidating the Design Space of Diffusion-Based Generative Models’</a> which explores all of these components in some detail and makes new recommendations for how to get the best performance.',Le,QA,xa="If all of this is too technical or intimidating, don’t worry! Feel free to skip the rest of this notebook or save it for a rainy day.",Oe,vA,qe,DA,Ha="The diffusers UNet2DModel model has a number of improvements over our basic UNet above:",Ye,TA,ka="<li>GroupNorm applies group normalization to the inputs of each block</li> <li>Dropout layers for smoother training</li> <li>Multiple resnet layers per block (if layers_per_block isn’t set to 1)</li> <li>Attention (usually used only at lower resolution blocks)</li> <li>Conditioning on the timestep.</li> <li>Downsampling and upsampling blocks with learnable parameters</li>",_e,PA,Ga="Let’s create and inspect a UNet2DModel:",$e,xA,As,HA,Na=`UNet2DModel(
  (conv_in): Conv2d(1, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
  (time_proj): Timesteps()
  (time_embedding): TimestepEmbedding(
    (linear_1): Linear(in_features=32, out_features=128, bias=True)
    (act): SiLU()
    (linear_2): Linear(in_features=128, out_features=128, bias=True)
  )
  (down_blocks): ModuleList(
    (0): DownBlock2D(
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 32, eps=1e-05, affine=True)
          (conv1): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=32, bias=True)
          (norm2): GroupNorm(32, 32, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 32, eps=1e-05, affine=True)
          (conv1): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=32, bias=True)
          (norm2): GroupNorm(32, 32, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
        )
      )
      (downsamplers): ModuleList(
        (0): Downsample2D(
          (conv): Conv2d(32, 32, kernel_size=(3, 3), stride=(2, 2), padding=(1, 1))
        )
      )
    )
    (1): AttnDownBlock2D(
      (attentions): ModuleList(
        (0): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (1): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
      )
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 32, eps=1e-05, affine=True)
          (conv1): Conv2d(32, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(32, 64, kernel_size=(1, 1), stride=(1, 1))
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
          (conv1): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
        )
      )
      (downsamplers): ModuleList(
        (0): Downsample2D(
          (conv): Conv2d(64, 64, kernel_size=(3, 3), stride=(2, 2), padding=(1, 1))
        )
      )
    )
    (2): AttnDownBlock2D(
      (attentions): ModuleList(
        (0): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (1): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
      )
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
          (conv1): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
          (conv1): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
        )
      )
    )
  )
  (up_blocks): ModuleList(
    (0): AttnUpBlock2D(
      (attentions): ModuleList(
        (0): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (1): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (2): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
      )
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 128, eps=1e-05, affine=True)
          (conv1): Conv2d(128, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(128, 64, kernel_size=(1, 1), stride=(1, 1))
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 128, eps=1e-05, affine=True)
          (conv1): Conv2d(128, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(128, 64, kernel_size=(1, 1), stride=(1, 1))
        )
        (2): ResnetBlock2D(
          (norm1): GroupNorm(32, 128, eps=1e-05, affine=True)
          (conv1): Conv2d(128, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(128, 64, kernel_size=(1, 1), stride=(1, 1))
        )
      )
      (upsamplers): ModuleList(
        (0): Upsample2D(
          (conv): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        )
      )
    )
    (1): AttnUpBlock2D(
      (attentions): ModuleList(
        (0): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (1): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
        (2): AttentionBlock(
          (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
          (query): Linear(in_features=64, out_features=64, bias=True)
          (key): Linear(in_features=64, out_features=64, bias=True)
          (value): Linear(in_features=64, out_features=64, bias=True)
          (proj_attn): Linear(in_features=64, out_features=64, bias=True)
        )
      )
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 128, eps=1e-05, affine=True)
          (conv1): Conv2d(128, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(128, 64, kernel_size=(1, 1), stride=(1, 1))
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 128, eps=1e-05, affine=True)
          (conv1): Conv2d(128, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(128, 64, kernel_size=(1, 1), stride=(1, 1))
        )
        (2): ResnetBlock2D(
          (norm1): GroupNorm(32, 96, eps=1e-05, affine=True)
          (conv1): Conv2d(96, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
          (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(96, 64, kernel_size=(1, 1), stride=(1, 1))
        )
      )
      (upsamplers): ModuleList(
        (0): Upsample2D(
          (conv): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        )
      )
    )
    (2): UpBlock2D(
      (resnets): ModuleList(
        (0): ResnetBlock2D(
          (norm1): GroupNorm(32, 96, eps=1e-05, affine=True)
          (conv1): Conv2d(96, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=32, bias=True)
          (norm2): GroupNorm(32, 32, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(96, 32, kernel_size=(1, 1), stride=(1, 1))
        )
        (1): ResnetBlock2D(
          (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
          (conv1): Conv2d(64, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=32, bias=True)
          (norm2): GroupNorm(32, 32, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(64, 32, kernel_size=(1, 1), stride=(1, 1))
        )
        (2): ResnetBlock2D(
          (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
          (conv1): Conv2d(64, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (time_emb_proj): Linear(in_features=128, out_features=32, bias=True)
          (norm2): GroupNorm(32, 32, eps=1e-05, affine=True)
          (dropout): Dropout(p=0.0, inplace=False)
          (conv2): Conv2d(32, 32, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
          (nonlinearity): SiLU()
          (conv_shortcut): Conv2d(64, 32, kernel_size=(1, 1), stride=(1, 1))
        )
      )
    )
  )
  (mid_block): UNetMidBlock2D(
    (attentions): ModuleList(
      (0): AttentionBlock(
        (group_norm): GroupNorm(32, 64, eps=1e-05, affine=True)
        (query): Linear(in_features=64, out_features=64, bias=True)
        (key): Linear(in_features=64, out_features=64, bias=True)
        (value): Linear(in_features=64, out_features=64, bias=True)
        (proj_attn): Linear(in_features=64, out_features=64, bias=True)
      )
    )
    (resnets): ModuleList(
      (0): ResnetBlock2D(
        (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
        (conv1): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
        (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
        (dropout): Dropout(p=0.0, inplace=False)
        (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        (nonlinearity): SiLU()
      )
      (1): ResnetBlock2D(
        (norm1): GroupNorm(32, 64, eps=1e-05, affine=True)
        (conv1): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        (time_emb_proj): Linear(in_features=128, out_features=64, bias=True)
        (norm2): GroupNorm(32, 64, eps=1e-05, affine=True)
        (dropout): Dropout(p=0.0, inplace=False)
        (conv2): Conv2d(64, 64, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
        (nonlinearity): SiLU()
      )
    )
  )
  (conv_norm_out): GroupNorm(32, 32, eps=1e-05, affine=True)
  (conv_act): SiLU()
  (conv_out): Conv2d(32, 1, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
)
`,ts,kA,Xa="As you can see, a little more going on! It also has significantly more parameters than our BasicUNet:",es,GA,ss,NA,Wa="We can replicate the training shown above using this model in place of our original one. We need to pass both x and timestep to the model (here I always pass t=0 to show that it works without this timestep conditioning and to keep the sampling code easy, but you can also try feeding in <code>(amount*1000)</code> to get a timestep equivalent from the corruption amount). Lines changed are shown with <code>#&lt;&lt;&lt;</code> if you want to inspect the code.",as,XA,ns,WA,Ea=`Finished epoch 0. Average loss for this epoch: 0.018925
Finished epoch 1. Average loss for this epoch: 0.012785
Finished epoch 2. Average loss for this epoch: 0.011694
`,ls,EA,za="This looks quite a bit better than our first set of results! You can explore tweaking the unet configuration or training for longer to get even better performance.",os,zA,is,SA,Sa="The DDPM paper describes a corruption process that adds a small amount of noise for every ‘timestep’. Given $x_{t-1}$ for some timestep, we can get the next (slightly more noisy) version $x_t$ with:<br/><br/>",ps,VA,Va=`$q(\\mathbf{x}<em>t \\vert \\mathbf{x}</em>{t-1}) = \\mathcal{N}(\\mathbf{x}<em>t; \\sqrt{1 - \\beta_t} \\mathbf{x}</em>{t-1}, \\beta<em>t\\mathbf{I}) \\quad
q(\\mathbf{x}</em>{1:T} \\vert \\mathbf{x}<em>0) = \\prod^T</em>{t=1} q(\\mathbf{x}<em>t \\vert \\mathbf{x}</em>{t-1})$<br/><br/>`,rs,ZA,Za="That is, we take $x<em>{t-1}$, scale it by $\\sqrt{1 - \\beta_t}$ and add noise scaled by $\\beta_t$. This $\\beta$ is defined for every t according to some schedule, and determines how much noise is added per timestep. Now, we don’t necessarily want to do this operation 500 times to get $x</em>{500}$ so we have another formula to get $x_t$ for any t given $x_0$: <br/><br/>",ws,LA,La=`$\\begin{aligned}
q(\\mathbf{x}<em>t \\vert \\mathbf{x}_0) &amp;= \\mathcal{N}(\\mathbf{x}_t; \\sqrt{\\bar{\\alpha}_t} \\mathbf{x}_0, \\sqrt{(1 - \\bar{\\alpha}_t)} \\mathbf{I})
\\end{aligned}$ where $\\bar{\\alpha}_t = \\prod</em>{i=1}^T \\alpha_i$ and $\\alpha_i = 1-\\beta_i$<br/><br/>`,js,OA,Oa="The maths notation always looks scary! Luckily the scheduler handles all that for us (uncomment the next cell to check out the code). We can plot $\\sqrt{\\bar{\\alpha}_t}$ (labelled as <code>sqrt_alpha_prod</code>) and $\\sqrt{(1 - \\bar{\\alpha}_t)}$ (labelled as <code>sqrt_one_minus_alpha_prod</code>) to view how the input (x) and the noise are scaled and mixed across different timesteps:",fs,qA,Us,YA,Ms,Ft,qa,cs,_A,Ya="Initially, the noisy x is mostly x (sqrt_alpha_prod ~= 1) but over time the contribution of x drops and the noise component increases. Unlike our linear mix of x and noise according to <code>amount</code>, this one gets noisy relatively quickly. We can visualize this on some data:",hs,$A,Cs,At,_a=`X shape torch.Size([8, 1, 28, 28])
Noisy X shape torch.Size([8, 1, 28, 28])
`,us,tt,$a="Another dynamic at play: the DDPM version adds noise drawn from a Gaussian distribution (mean 0, s.d. 1 from torch.randn) rather than the uniform noise between 0 and 1 (from torch.rand) we used in our original <code>corrupt</code> function. In general, it makes sense to normalize the training data as well. In the other notebook, you’ll see <code>Normalize(0.5, 0.5)</code> in the list of transforms, which maps the image data form (0, 1) to (-1, 1) and is ‘good enough’ for our purposes. We didn’t do that for this notebook, but the visualization cell above adds it in for more accurate scaling and visualization.",Bs,et,gs,st,An="In our toy example, we had the model try to predict the denoised image. In DDPM and many other diffusion model implementations, the model predicts the noise used in the corruption process (before scaling, so unit variance noise). In code, it looks something like:",ms,at,ds,nt,tn="You may think that predicting the noise (from which we can derive what the denoised image looks like) is equivalent to just predicting the denoised image directly. So why favour one over the other - is it just for mathematical convenience?",Js,lt,en="It turns out there’s another subtlety here. We compute the loss across different (randomly chosen) timesteps during training. These different objectives will lead to different ‘implicit weighting’ of these losses, where predicting the noise puts more weight on lower noise levels. You can pick more complex objectives to change this ‘implicit loss weighting’. Or perhaps you choose a noise schedule that will result in more examples at a higher noise level. Perhaps you have the model predict a ‘velocity’ v which we define as being a combination of both the image and the noise dependent on the noise level (see ‘PROGRESSIVE DISTILLATION FOR FAST SAMPLING OF DIFFUSION MODELS’). Perhaps you have the model predict the noise but then scale the loss by some factor dependent on the amount of noise based on a bit of theory (see ‘Perception Prioritized Training of Diffusion Models’) or based on experiments trying to see what noise levels are most informative to the model (see ‘Elucidating the Design Space of Diffusion-Based Generative Models’). TL;DR: choosing the objective has an effect on model performance, and research in ongoing into what the ‘best’ option is.",bs,ot,sn="At the moment, predicting the noise (epsilon or eps you’ll see in some places) is the favoured approach but over time we will likely see other objectives supported in the library and used in different situations.",Fs,it,ys,pt,an="The UNet2DModel takes in both x and timestep. The latter is turned into an embedding and fed into the model in a number of places.",Is,rt,nn="The theory behind this is that by giving the model information about what the noise level is, it can better perform its task. While it is possible to train a model without this timestep conditioning, it does seem to help performance in some cases and most implementations include it, at least in the current literature.",Rs,wt,Ks,jt,ln="Given a model that estimates the noise present in a noisy input (or predicts the denoised version), how do we produce new images?",Qs,ft,on="We could feed in pure noise, and hope that the model predicts a good image as the denoised version in one step. However, as we saw in the experiments above, this doesn’t usually work well. So, instead, we take a number of smaller steps based on the model prediction, iteratively removing a little bit of the noise at a time.",vs,Ut,pn="Exactly how we take these steps depends on the sampling method used. We won’t go into the theory too deeply, but some key design questions are:",Ds,Mt,rn="<li>How large of a step should you take? In other words, what ‘noise schedule’ should you follow?</li> <li>Do you use only the model’s current prediction to inform the update step (like DDPM, DDIM and many others)? Do you evaluate the model several times to estimate higher-order gradients for a larger, more accurate step (higher-order methods and some discrete ODE solvers)? Or do you keep a history of past predictions to try and better inform the current update step (linear multi-step and ancestral samplers)?</li> <li>Do you add in additional noise (sometimes called churn) to add more stochasticity (randomness) to the sampling process, or do you keep it completely deterministic? Many samplers control this with a parameter (such as ‘eta’ for DDIM samplers) so that the user can choose.</li>",Ts,ct,wn='Research on sampling methods for diffusion models is rapidly evolving, and more and more methods for finding good solutions in fewer steps are being proposed. The brave and curious might find it interesting to browse through the code of the different implementations available in the diffusers library <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow">here</a> or check out the <a href="https://huggingface.co/docs/diffusers/api/schedulers/overview" rel="nofollow">docs</a> which often link to the relevant papers.',Ps,ht,xs,Ct,jn="Hopefully this has been a helpful way to look at diffusion models from a slightly different angle.",Hs,ut,fn='This notebook was written for this Hugging Face course by Jonathan Whitaker, and overlaps with a <a href="https://johnowhitaker.github.io/tglcourse/dm1.html" rel="nofollow">version included in his own course</a>, ‘The Generative Landscape’. Check that out if you’d like to see this basic example extended with noise and class conditioning. Questions or bugs can be communicated through GitHub issues or via Discord. You are also welcome to reach out via Twitter <a href="https://twitter.com/johnowhitaker" rel="nofollow">@johnowhitaker</a>.',ks,Bt,Gs,It,Ns;return C=new mn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/unit3/implement_img2img_inpaint/unit1/02_diffusion_models_from_scratch.ipynb"}]}}),u=new c({props:{title:"Diffusion Models from Scratch",local:"diffusion-models-from-scratch",headingTag:"h1"}}),y=new c({props:{title:"Setup and Imports:",local:"setup-and-imports",headingTag:"h2"}}),I=new M({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGlmZnVzZXJz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>%pip install -q diffusers',wrap:!1}}),K=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaHZpc2lvbiUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG5uJTBBZnJvbSUyMHRvcmNoLm5uJTIwaW1wb3J0JTIwZnVuY3Rpb25hbCUyMGFzJTIwRiUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERFBNU2NoZWR1bGVyJTJDJTIwVU5ldDJETW9kZWwlMEFmcm9tJTIwbWF0cGxvdGxpYiUyMGltcG9ydCUyMHB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQXByaW50KGYlMjJVc2luZyUyMGRldmljZSUzQSUyMCU3QmRldmljZSU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Using device: <span class="hljs-subst">{device}</span>&quot;</span>)`,wrap:!1}}),v=new c({props:{title:"The Data",local:"the-data",headingTag:"h2"}}),T=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMHRvcmNodmlzaW9uLmRhdGFzZXRzLk1OSVNUKCUwQSUyMCUyMCUyMCUyMHJvb3QlM0QlMjJtbmlzdCUyRiUyMiUyQyUyMHRyYWluJTNEVHJ1ZSUyQyUyMGRvd25sb2FkJTNEVHJ1ZSUyQyUyMHRyYW5zZm9ybSUzRHRvcmNodmlzaW9uLnRyYW5zZm9ybXMuVG9UZW5zb3IoKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = torchvision.datasets.MNIST(
<span class="hljs-meta">... </span>    root=<span class="hljs-string">&quot;mnist/&quot;</span>, train=<span class="hljs-literal">True</span>, download=<span class="hljs-literal">True</span>, transform=torchvision.transforms.ToTensor()
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new M({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwc2h1ZmZsZSUzRFRydWUp",highlighted:'train_dataloader = DataLoader(dataset, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">True</span>)',wrap:!1}}),H=new M({props:{code:"eCUyQyUyMHklMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGF0YWxvYWRlcikpJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHguc2hhcGUpJTBBcHJpbnQoJTIyTGFiZWxzJTNBJTIyJTJDJTIweSklMEFwbHQuaW1zaG93KHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4KSU1QjAlNUQlMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>x, y = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, x.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Labels:&quot;</span>, y)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(torchvision.utils.make_grid(x)[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),N=new c({props:{title:"The Corruption Process",local:"the-corruption-process",headingTag:"h2"}}),Z=new M({props:{code:"ZGVmJTIwY29ycnVwdCh4JTJDJTIwYW1vdW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvcnJ1cHQlMjB0aGUlMjBpbnB1dCUyMCU2MHglNjAlMjBieSUyMG1peGluZyUyMGl0JTIwd2l0aCUyMG5vaXNlJTIwYWNjb3JkaW5nJTIwdG8lMjAlNjBhbW91bnQlNjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBub2lzZSUyMCUzRCUyMHRvcmNoLnJhbmRfbGlrZSh4KSUwQSUyMCUyMCUyMCUyMGFtb3VudCUyMCUzRCUyMGFtb3VudC52aWV3KC0xJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUyMCUyMCUyMyUyMFNvcnQlMjBzaGFwZSUyMHNvJTIwYnJvYWRjYXN0aW5nJTIwd29ya3MlMEElMjAlMjAlMjAlMjByZXR1cm4lMjB4JTIwKiUyMCgxJTIwLSUyMGFtb3VudCklMjAlMkIlMjBub2lzZSUyMColMjBhbW91bnQ=",highlighted:'<span class="hljs-keyword">def</span> <span class="hljs-title function_">corrupt</span>(<span class="hljs-params">x, amount</span>):\n    <span class="hljs-string">&quot;&quot;&quot;Corrupt the input `x` by mixing it with noise according to `amount`&quot;&quot;&quot;</span>\n    noise = torch.rand_like(x)\n    amount = amount.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)  <span class="hljs-comment"># Sort shape so broadcasting works</span>\n    <span class="hljs-keyword">return</span> x * (<span class="hljs-number">1</span> - amount) + noise * amount',wrap:!1}}),O=new M({props:{code:"JTIzJTIwUGxvdHRpbmclMjB0aGUlMjBpbnB1dCUyMGRhdGElMEFmaWclMkMlMjBheHMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMiUyQyUyMDElMkMlMjBmaWdzaXplJTNEKDEyJTJDJTIwNSkpJTBBYXhzJTVCMCU1RC5zZXRfdGl0bGUoJTIySW5wdXQlMjBkYXRhJTIyKSUwQWF4cyU1QjAlNUQuaW1zaG93KHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4KSU1QjAlNUQlMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIpJTBBJTBBJTIzJTIwQWRkaW5nJTIwbm9pc2UlMEFhbW91bnQlMjAlM0QlMjB0b3JjaC5saW5zcGFjZSgwJTJDJTIwMSUyQyUyMHguc2hhcGUlNUIwJTVEKSUyMCUyMCUyMyUyMExlZnQlMjB0byUyMHJpZ2h0JTIwLSUzRSUyMG1vcmUlMjBjb3JydXB0aW9uJTBBbm9pc2VkX3glMjAlM0QlMjBjb3JydXB0KHglMkMlMjBhbW91bnQpJTBBJTBBJTIzJTIwUGxvdHRpbmclMjB0aGUlMjBub2lzZWQlMjB2ZXJzaW9uJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyQ29ycnVwdGVkJTIwZGF0YSUyMCgtLSUyMGFtb3VudCUyMGluY3JlYXNlcyUyMC0tJTNFKSUyMiklMEFheHMlNUIxJTVELmltc2hvdyh0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQobm9pc2VkX3gpJTVCMCU1RCUyQyUyMGNtYXAlM0QlMjJHcmV5cyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plotting the input data</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input data&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(torchvision.utils.make_grid(x)[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;Greys&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Adding noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>amount = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, x.shape[<span class="hljs-number">0</span>])  <span class="hljs-comment"># Left to right -&gt; more corruption</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noised_x = corrupt(x, amount)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plotting the noised version</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Corrupted data (-- amount increases --&gt;)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(torchvision.utils.make_grid(noised_x)[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),Y=new c({props:{title:"The Model",local:"the-model",headingTag:"h2"}}),eA=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">BasicUNet</span>(nn.Module):
    <span class="hljs-string">&quot;&quot;&quot;A minimal UNet implementation.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels=<span class="hljs-number">1</span>, out_channels=<span class="hljs-number">1</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.down_layers = torch.nn.ModuleList(
            [
                nn.Conv2d(in_channels, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
                nn.Conv2d(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
                nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
            ]
        )
        self.up_layers = torch.nn.ModuleList(
            [
                nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
                nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
                nn.Conv2d(<span class="hljs-number">32</span>, out_channels, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
            ]
        )
        self.act = nn.SiLU()  <span class="hljs-comment"># The activation function</span>
        self.downscale = nn.MaxPool2d(<span class="hljs-number">2</span>)
        self.upscale = nn.Upsample(scale_factor=<span class="hljs-number">2</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        h = []
        <span class="hljs-keyword">for</span> i, l <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.down_layers):
            x = self.act(l(x))  <span class="hljs-comment"># Through the layer and the activation function</span>
            <span class="hljs-keyword">if</span> i &lt; <span class="hljs-number">2</span>:  <span class="hljs-comment"># For all but the third (final) down layer:</span>
                h.append(x)  <span class="hljs-comment"># Storing output for skip connection</span>
                x = self.downscale(x)  <span class="hljs-comment"># Downscale ready for the next layer</span>

        <span class="hljs-keyword">for</span> i, l <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.up_layers):
            <span class="hljs-keyword">if</span> i &gt; <span class="hljs-number">0</span>:  <span class="hljs-comment"># For all except the first up layer</span>
                x = self.upscale(x)  <span class="hljs-comment"># Upscale</span>
                x += h.pop()  <span class="hljs-comment"># Fetching stored output (skip connection)</span>
            x = self.act(l(x))  <span class="hljs-comment"># Through the layer and the activation function</span>

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),aA=new M({props:{code:"bmV0JTIwJTNEJTIwQmFzaWNVTmV0KCklMEF4JTIwJTNEJTIwdG9yY2gucmFuZCg4JTJDJTIwMSUyQyUyMDI4JTJDJTIwMjgpJTBBbmV0KHgpLnNoYXBl",highlighted:`net = BasicUNet()
x = torch.rand(<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>)
net(x).shape`,wrap:!1}}),lA=new M({props:{code:"c3VtKCU1QnAubnVtZWwoKSUyMGZvciUyMHAlMjBpbiUyMG5ldC5wYXJhbWV0ZXJzKCklNUQp",highlighted:'<span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> net.parameters()])',wrap:!1}}),iA=new c({props:{title:"Training the network",local:"training-the-network",headingTag:"h2"}}),fA=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Dataloader (you can mess with batch size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(dataset, batch_size=batch_size, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># How many runs through the data should we do?</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_epochs = <span class="hljs-number">3</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the network</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>net = BasicUNet()
<span class="hljs-meta">&gt;&gt;&gt; </span>net.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Our loss function</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss_fn = nn.MSELoss()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The optimizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>opt = torch.optim.Adam(net.parameters(), lr=<span class="hljs-number">1e-3</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Keeping a record of the losses for later viewing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>losses = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The training loop</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> x, y <span class="hljs-keyword">in</span> train_dataloader:

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get some data and prepare the corrupted version</span>
<span class="hljs-meta">... </span>        x = x.to(device)  <span class="hljs-comment"># Data on the GPU</span>
<span class="hljs-meta">... </span>        noise_amount = torch.rand(x.shape[<span class="hljs-number">0</span>]).to(device)  <span class="hljs-comment"># Pick random noise amounts</span>
<span class="hljs-meta">... </span>        noisy_x = corrupt(x, noise_amount)  <span class="hljs-comment"># Create our noisy x</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the model prediction</span>
<span class="hljs-meta">... </span>        pred = net(noisy_x)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Calculate the loss</span>
<span class="hljs-meta">... </span>        loss = loss_fn(pred, x)  <span class="hljs-comment"># How close is the output to the true &#x27;clean&#x27; x?</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Backprop and update the params:</span>
<span class="hljs-meta">... </span>        opt.zero_grad()
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        opt.step()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Store the loss for later</span>
<span class="hljs-meta">... </span>        losses.append(loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Print our the average of the loss values for this epoch:</span>
<span class="hljs-meta">... </span>    avg_loss = <span class="hljs-built_in">sum</span>(losses[-<span class="hljs-built_in">len</span>(train_dataloader) :]) / <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Finished epoch <span class="hljs-subst">{epoch}</span>. Average loss for this epoch: <span class="hljs-subst">{avg_loss:05f}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the loss curve</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(losses)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylim(<span class="hljs-number">0</span>, <span class="hljs-number">0.1</span>)`,wrap:!1}}),cA=new M({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBWaXN1YWxpemluZyUyMG1vZGVsJTIwcHJlZGljdGlvbnMlMjBvbiUyMG5vaXN5JTIwaW5wdXRzJTNBJTBBJTBBJTIzJTIwRmV0Y2glMjBzb21lJTIwZGF0YSUwQXglMkMlMjB5JTIwJTNEJTIwbmV4dChpdGVyKHRyYWluX2RhdGFsb2FkZXIpKSUwQXglMjAlM0QlMjB4JTVCJTNBOCU1RCUyMCUyMCUyMyUyME9ubHklMjB1c2luZyUyMHRoZSUyMGZpcnN0JTIwOCUyMGZvciUyMGVhc3klMjBwbG90dGluZyUwQSUwQSUyMyUyMENvcnJ1cHQlMjB3aXRoJTIwYSUyMHJhbmdlJTIwb2YlMjBhbW91bnRzJTBBYW1vdW50JTIwJTNEJTIwdG9yY2gubGluc3BhY2UoMCUyQyUyMDElMkMlMjB4LnNoYXBlJTVCMCU1RCklMjAlMjAlMjMlMjBMZWZ0JTIwdG8lMjByaWdodCUyMC0lM0UlMjBtb3JlJTIwY29ycnVwdGlvbiUwQW5vaXNlZF94JTIwJTNEJTIwY29ycnVwdCh4JTJDJTIwYW1vdW50KSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMG1vZGVsJTIwcHJlZGljdGlvbnMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZHMlMjAlM0QlMjBuZXQobm9pc2VkX3gudG8oZGV2aWNlKSkuZGV0YWNoKCkuY3B1KCklMEElMEElMjMlMjBQbG90JTBBZmlnJTJDJTIwYXhzJTIwJTNEJTIwcGx0LnN1YnBsb3RzKDMlMkMlMjAxJTJDJTIwZmlnc2l6ZSUzRCgxMiUyQyUyMDcpKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMklucHV0JTIwZGF0YSUyMiklMEFheHMlNUIwJTVELmltc2hvdyh0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQoeCklNUIwJTVELmNsaXAoMCUyQyUyMDEpJTJDJTIwY21hcCUzRCUyMkdyZXlzJTIyKSUwQWF4cyU1QjElNUQuc2V0X3RpdGxlKCUyMkNvcnJ1cHRlZCUyMGRhdGElMjIpJTBBYXhzJTVCMSU1RC5pbXNob3codG9yY2h2aXNpb24udXRpbHMubWFrZV9ncmlkKG5vaXNlZF94KSU1QjAlNUQuY2xpcCgwJTJDJTIwMSklMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIpJTBBYXhzJTVCMiU1RC5zZXRfdGl0bGUoJTIyTmV0d29yayUyMFByZWRpY3Rpb25zJTIyKSUwQWF4cyU1QjIlNUQuaW1zaG93KHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZChwcmVkcyklNUIwJTVELmNsaXAoMCUyQyUyMDEpJTJDJTIwY21hcCUzRCUyMkdyZXlzJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Visualizing model predictions on noisy inputs:</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Fetch some data</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x, y = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span>x = x[:<span class="hljs-number">8</span>]  <span class="hljs-comment"># Only using the first 8 for easy plotting</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Corrupt with a range of amounts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>amount = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, x.shape[<span class="hljs-number">0</span>])  <span class="hljs-comment"># Left to right -&gt; more corruption</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noised_x = corrupt(x, amount)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get the model predictions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    preds = net(noised_x.to(device)).detach().cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">3</span>, <span class="hljs-number">1</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">7</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input data&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(torchvision.utils.make_grid(x)[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Corrupted data&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(torchvision.utils.make_grid(noised_x)[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].set_title(<span class="hljs-string">&quot;Network Predictions&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].imshow(torchvision.utils.make_grid(preds)[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),CA=new c({props:{title:"Sampling",local:"sampling",headingTag:"h2"}}),mA=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Sampling strategy: Break the process into 5 steps and move 1/5&#x27;th of the way there each time:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_steps = <span class="hljs-number">5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.rand(<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>).to(device)  <span class="hljs-comment"># Start from random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>step_history = [x.detach().cpu()]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_output_history = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():  <span class="hljs-comment"># No need to track gradients during inference</span>
<span class="hljs-meta">... </span>        pred = net(x)  <span class="hljs-comment"># Predict the denoised x0</span>
<span class="hljs-meta">... </span>    pred_output_history.append(pred.detach().cpu())  <span class="hljs-comment"># Store model output for plotting</span>
<span class="hljs-meta">... </span>    mix_factor = <span class="hljs-number">1</span> / (n_steps - i)  <span class="hljs-comment"># How much we move towards the prediction</span>
<span class="hljs-meta">... </span>    x = x * (<span class="hljs-number">1</span> - mix_factor) + pred * mix_factor  <span class="hljs-comment"># Move part of the way there</span>
<span class="hljs-meta">... </span>    step_history.append(x.detach().cpu())  <span class="hljs-comment"># Store step for plotting</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(n_steps, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">9</span>, <span class="hljs-number">4</span>), sharex=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;x (model input)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;model prediction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps):
<span class="hljs-meta">... </span>    axs[i, <span class="hljs-number">0</span>].imshow(torchvision.utils.make_grid(step_history[i])[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">... </span>    axs[i, <span class="hljs-number">1</span>].imshow(torchvision.utils.make_grid(pred_output_history[i])[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),JA=new M({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBTaG93aW5nJTIwbW9yZSUyMHJlc3VsdHMlMkMlMjB1c2luZyUyMDQwJTIwc2FtcGxpbmclMjBzdGVwcyUwQW5fc3RlcHMlMjAlM0QlMjA0MCUwQXglMjAlM0QlMjB0b3JjaC5yYW5kKDY0JTJDJTIwMSUyQyUyMDI4JTJDJTIwMjgpLnRvKGRldmljZSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZShuX3N0ZXBzKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXNlX2Ftb3VudCUyMCUzRCUyMHRvcmNoLm9uZXMoKHguc2hhcGUlNUIwJTVEJTJDKSkudG8oZGV2aWNlKSUyMColMjAoMSUyMC0lMjAoaSUyMCUyRiUyMG5fc3RlcHMpKSUyMCUyMCUyMyUyMFN0YXJ0aW5nJTIwaGlnaCUyMGdvaW5nJTIwbG93JTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZWQlMjAlM0QlMjBuZXQoeCklMEElMjAlMjAlMjAlMjBtaXhfZmFjdG9yJTIwJTNEJTIwMSUyMCUyRiUyMChuX3N0ZXBzJTIwLSUyMGkpJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMHglMjAqJTIwKDElMjAtJTIwbWl4X2ZhY3RvciklMjAlMkIlMjBwcmVkJTIwKiUyMG1peF9mYWN0b3IlMEFmaWclMkMlMjBheCUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMSUyQyUyMGZpZ3NpemUlM0QoMTIlMkMlMjAxMikpJTBBYXguaW1zaG93KHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4LmRldGFjaCgpLmNwdSgpJTJDJTIwbnJvdyUzRDgpJTVCMCU1RC5jbGlwKDAlMkMlMjAxKSUyQyUyMGNtYXAlM0QlMjJHcmV5cyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Showing more results, using 40 sampling steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_steps = <span class="hljs-number">40</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.rand(<span class="hljs-number">64</span>, <span class="hljs-number">1</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps):
<span class="hljs-meta">... </span>    noise_amount = torch.ones((x.shape[<span class="hljs-number">0</span>],)).to(device) * (<span class="hljs-number">1</span> - (i / n_steps))  <span class="hljs-comment"># Starting high going low</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        pred = net(x)
<span class="hljs-meta">... </span>    mix_factor = <span class="hljs-number">1</span> / (n_steps - i)
<span class="hljs-meta">... </span>    x = x * (<span class="hljs-number">1</span> - mix_factor) + pred * mix_factor
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">12</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.imshow(torchvision.utils.make_grid(x.detach().cpu(), nrow=<span class="hljs-number">8</span>)[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),FA=new c({props:{title:"Comparison To DDPM",local:"comparison-to-ddpm",headingTag:"h2"}}),vA=new c({props:{title:"The UNet",local:"the-unet",headingTag:"h3"}}),xA=new M({props:{code:"bW9kZWwlMjAlM0QlMjBVTmV0MkRNb2RlbCglMEElMjAlMjAlMjAlMjBzYW1wbGVfc2l6ZSUzRDI4JTJDJTIwJTIwJTIzJTIwdGhlJTIwdGFyZ2V0JTIwaW1hZ2UlMjByZXNvbHV0aW9uJTBBJTIwJTIwJTIwJTIwaW5fY2hhbm5lbHMlM0QxJTJDJTIwJTIwJTIzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjBpbnB1dCUyMGNoYW5uZWxzJTJDJTIwMyUyMGZvciUyMFJHQiUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMG91dF9jaGFubmVscyUzRDElMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMG91dHB1dCUyMGNoYW5uZWxzJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMjAlMjAlMjMlMjBob3clMjBtYW55JTIwUmVzTmV0JTIwbGF5ZXJzJTIwdG8lMjB1c2UlMjBwZXIlMjBVTmV0JTIwYmxvY2slMEElMjAlMjAlMjAlMjBibG9ja19vdXRfY2hhbm5lbHMlM0QoMzIlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMCUyMCUyMyUyMFJvdWdobHklMjBtYXRjaGluZyUyMG91ciUyMGJhc2ljJTIwdW5ldCUyMGV4YW1wbGUlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMHJlZ3VsYXIlMjBSZXNOZXQlMjBkb3duc2FtcGxpbmclMjBibG9jayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkF0dG5Eb3duQmxvY2syRCUyMiUyQyUyMCUyMCUyMyUyMGElMjBSZXNOZXQlMjBkb3duc2FtcGxpbmclMjBibG9jayUyMHdpdGglMjBzcGF0aWFsJTIwc2VsZi1hdHRlbnRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdHRuRG93bkJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwdXBfYmxvY2tfdHlwZXMlM0QoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXR0blVwQmxvY2syRCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkF0dG5VcEJsb2NrMkQlMjIlMkMlMjAlMjAlMjMlMjBhJTIwUmVzTmV0JTIwdXBzYW1wbGluZyUyMGJsb2NrJTIwd2l0aCUyMHNwYXRpYWwlMjBzZWxmLWF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlVwQmxvY2syRCUyMiUyQyUyMCUyMCUyMyUyMGElMjByZWd1bGFyJTIwUmVzTmV0JTIwdXBzYW1wbGluZyUyMGJsb2NrJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSklMEFwcmludChtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=<span class="hljs-number">28</span>,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>),  <span class="hljs-comment"># Roughly matching our basic unet example</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)`,wrap:!1}}),GA=new M({props:{code:"c3VtKCU1QnAubnVtZWwoKSUyMGZvciUyMHAlMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSU1RCklMjAlMjAlMjMlMjAxLjdNJTIwdnMlMjB0aGUlMjB+MzA5ayUyMHBhcmFtZXRlcnMlMjBvZiUyMHRoZSUyMEJhc2ljVU5ldA==",highlighted:'<span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()])  <span class="hljs-comment"># 1.7M vs the ~309k parameters of the BasicUNet</span>',wrap:!1}}),XA=new M({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBUcnlpbmclMjBVTmV0MkRNb2RlbCUyMGluc3RlYWQlMjBvZiUyMEJhc2ljVU5ldCUzQSUwQSUwQSUyMyUyMERhdGFsb2FkZXIlMjAoeW91JTIwY2FuJTIwbWVzcyUyMHdpdGglMjBiYXRjaCUyMHNpemUpJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDEyOCUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHNodWZmbGUlM0RUcnVlKSUwQSUwQSUyMyUyMEhvdyUyMG1hbnklMjBydW5zJTIwdGhyb3VnaCUyMHRoZSUyMGRhdGElMjBzaG91bGQlMjB3ZSUyMGRvJTNGJTBBbl9lcG9jaHMlMjAlM0QlMjAzJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwbmV0d29yayUwQW5ldCUyMCUzRCUyMFVOZXQyRE1vZGVsKCUwQSUyMCUyMCUyMCUyMHNhbXBsZV9zaXplJTNEMjglMkMlMjAlMjAlMjMlMjB0aGUlMjB0YXJnZXQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDElMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMGlucHV0JTIwY2hhbm5lbHMlMkMlMjAzJTIwZm9yJTIwUkdCJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwb3V0X2NoYW5uZWxzJTNEMSUyQyUyMCUyMCUyMyUyMHRoZSUyMG51bWJlciUyMG9mJTIwb3V0cHV0JTIwY2hhbm5lbHMlMEElMjAlMjAlMjAlMjBsYXllcnNfcGVyX2Jsb2NrJTNEMiUyQyUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBSZXNOZXQlMjBsYXllcnMlMjB0byUyMHVzZSUyMHBlciUyMFVOZXQlMjBibG9jayUwQSUyMCUyMCUyMCUyMGJsb2NrX291dF9jaGFubmVscyUzRCgzMiUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwJTIwJTIzJTIwUm91Z2hseSUyMG1hdGNoaW5nJTIwb3VyJTIwYmFzaWMlMjB1bmV0JTIwZXhhbXBsZSUwQSUyMCUyMCUyMCUyMGRvd25fYmxvY2tfdHlwZXMlM0QoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRG93bkJsb2NrMkQlMjIlMkMlMjAlMjAlMjMlMjBhJTIwcmVndWxhciUyMFJlc05ldCUyMGRvd25zYW1wbGluZyUyMGJsb2NrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXR0bkRvd25CbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMFJlc05ldCUyMGRvd25zYW1wbGluZyUyMGJsb2NrJTIwd2l0aCUyMHNwYXRpYWwlMjBzZWxmLWF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkF0dG5Eb3duQmxvY2syRCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB1cF9ibG9ja190eXBlcyUzRCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdHRuVXBCbG9jazJEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXR0blVwQmxvY2syRCUyMiUyQyUyMCUyMCUyMyUyMGElMjBSZXNOZXQlMjB1cHNhbXBsaW5nJTIwYmxvY2slMjB3aXRoJTIwc3BhdGlhbCUyMHNlbGYtYXR0ZW50aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXBCbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMHJlZ3VsYXIlMjBSZXNOZXQlMjB1cHNhbXBsaW5nJTIwYmxvY2slMEElMjAlMjAlMjAlMjApJTJDJTBBKSUyMCUyMCUyMyUyMCUzQyUzQyUzQyUwQW5ldC50byhkZXZpY2UpJTBBJTBBJTIzJTIwT3VyJTIwbG9zcyUyMGZpbmN0aW9uJTBBbG9zc19mbiUyMCUzRCUyMG5uLk1TRUxvc3MoKSUwQSUwQSUyMyUyMFRoZSUyMG9wdGltaXplciUwQW9wdCUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW0obmV0LnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEMWUtMyklMEElMEElMjMlMjBLZWVwaW5nJTIwYSUyMHJlY29yZCUyMG9mJTIwdGhlJTIwbG9zc2VzJTIwZm9yJTIwbGF0ZXIlMjB2aWV3aW5nJTBBbG9zc2VzJTIwJTNEJTIwJTVCJTVEJTBBJTBBJTIzJTIwVGhlJTIwdHJhaW5pbmclMjBsb29wJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG5fZXBvY2hzKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGZvciUyMHglMkMlMjB5JTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwc29tZSUyMGRhdGElMjBhbmQlMjBwcmVwYXJlJTIwdGhlJTIwY29ycnVwdGVkJTIwdmVyc2lvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjB4LnRvKGRldmljZSklMjAlMjAlMjMlMjBEYXRhJTIwb24lMjB0aGUlMjBHUFUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9hbW91bnQlMjAlM0QlMjB0b3JjaC5yYW5kKHguc2hhcGUlNUIwJTVEKS50byhkZXZpY2UpJTIwJTIwJTIzJTIwUGljayUyMHJhbmRvbSUyMG5vaXNlJTIwYW1vdW50cyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vaXN5X3glMjAlM0QlMjBjb3JydXB0KHglMkMlMjBub2lzZV9hbW91bnQpJTIwJTIwJTIzJTIwQ3JlYXRlJTIwb3VyJTIwbm9pc3klMjB4JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwdGhlJTIwbW9kZWwlMjBwcmVkaWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZCUyMCUzRCUyMG5ldChub2lzeV94JTJDJTIwMCkuc2FtcGxlJTIwJTIwJTIzJTIwJTNDJTNDJTNDJTIwVXNpbmclMjB0aW1lc3RlcCUyMDAlMjBhbHdheXMlMkMlMjBhZGRpbmclMjAuc2FtcGxlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ2FsY3VsYXRlJTIwdGhlJTIwbG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZuKHByZWQlMkMlMjB4KSUyMCUyMCUyMyUyMEhvdyUyMGNsb3NlJTIwaXMlMjB0aGUlMjBvdXRwdXQlMjB0byUyMHRoZSUyMHRydWUlMjAnY2xlYW4nJTIweCUzRiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEJhY2twcm9wJTIwYW5kJTIwdXBkYXRlJTIwdGhlJTIwcGFyYW1zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0Lnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0LnN0ZXAoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0b3JlJTIwdGhlJTIwbG9zcyUyMGZvciUyMGxhdGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc2VzLmFwcGVuZChsb3NzLml0ZW0oKSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQcmludCUyMG91ciUyMHRoZSUyMGF2ZXJhZ2UlMjBvZiUyMHRoZSUyMGxvc3MlMjB2YWx1ZXMlMjBmb3IlMjB0aGlzJTIwZXBvY2glM0ElMEElMjAlMjAlMjAlMjBhdmdfbG9zcyUyMCUzRCUyMHN1bShsb3NzZXMlNUItbGVuKHRyYWluX2RhdGFsb2FkZXIpJTIwJTNBJTVEKSUyMCUyRiUyMGxlbih0cmFpbl9kYXRhbG9hZGVyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJGaW5pc2hlZCUyMGVwb2NoJTIwJTdCZXBvY2glN0QuJTIwQXZlcmFnZSUyMGxvc3MlMjBmb3IlMjB0aGlzJTIwZXBvY2glM0ElMjAlN0JhdmdfbG9zcyUzQTA1ZiU3RCUyMiklMEElMEElMjMlMjBQbG90JTIwbG9zc2VzJTIwYW5kJTIwc29tZSUyMHNhbXBsZXMlMEFmaWclMkMlMjBheHMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMSUyQyUyMDIlMkMlMjBmaWdzaXplJTNEKDEyJTJDJTIwNSkpJTBBJTBBJTIzJTIwTG9zc2VzJTBBYXhzJTVCMCU1RC5wbG90KGxvc3NlcyklMEFheHMlNUIwJTVELnNldF95bGltKDAlMkMlMjAwLjEpJTBBYXhzJTVCMCU1RC5zZXRfdGl0bGUoJTIyTG9zcyUyMG92ZXIlMjB0aW1lJTIyKSUwQSUwQSUyMyUyMFNhbXBsZXMlMEFuX3N0ZXBzJTIwJTNEJTIwNDAlMEF4JTIwJTNEJTIwdG9yY2gucmFuZCg2NCUyQyUyMDElMkMlMjAyOCUyQyUyMDI4KS50byhkZXZpY2UpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2Uobl9zdGVwcyklM0ElMEElMjAlMjAlMjAlMjBub2lzZV9hbW91bnQlMjAlM0QlMjB0b3JjaC5vbmVzKCh4LnNoYXBlJTVCMCU1RCUyQykpLnRvKGRldmljZSklMjAqJTIwKDElMjAtJTIwKGklMjAlMkYlMjBuX3N0ZXBzKSklMjAlMjAlMjMlMjBTdGFydGluZyUyMGhpZ2glMjBnb2luZyUyMGxvdyUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkJTIwJTNEJTIwbmV0KHglMkMlMjAwKS5zYW1wbGUlMEElMjAlMjAlMjAlMjBtaXhfZmFjdG9yJTIwJTNEJTIwMSUyMCUyRiUyMChuX3N0ZXBzJTIwLSUyMGkpJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMHglMjAqJTIwKDElMjAtJTIwbWl4X2ZhY3RvciklMjAlMkIlMjBwcmVkJTIwKiUyMG1peF9mYWN0b3IlMEElMEFheHMlNUIxJTVELmltc2hvdyh0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQoeC5kZXRhY2goKS5jcHUoKSUyQyUyMG5yb3clM0Q4KSU1QjAlNUQuY2xpcCgwJTJDJTIwMSklMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIpJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyR2VuZXJhdGVkJTIwU2FtcGxlcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Trying UNet2DModel instead of BasicUNet:</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Dataloader (you can mess with batch size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(dataset, batch_size=batch_size, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># How many runs through the data should we do?</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_epochs = <span class="hljs-number">3</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the network</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>net = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=<span class="hljs-number">28</span>,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>),  <span class="hljs-comment"># Roughly matching our basic unet example</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># &lt;&lt;&lt;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>net.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Our loss finction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss_fn = nn.MSELoss()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The optimizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>opt = torch.optim.Adam(net.parameters(), lr=<span class="hljs-number">1e-3</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Keeping a record of the losses for later viewing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>losses = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The training loop</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> x, y <span class="hljs-keyword">in</span> train_dataloader:

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get some data and prepare the corrupted version</span>
<span class="hljs-meta">... </span>        x = x.to(device)  <span class="hljs-comment"># Data on the GPU</span>
<span class="hljs-meta">... </span>        noise_amount = torch.rand(x.shape[<span class="hljs-number">0</span>]).to(device)  <span class="hljs-comment"># Pick random noise amounts</span>
<span class="hljs-meta">... </span>        noisy_x = corrupt(x, noise_amount)  <span class="hljs-comment"># Create our noisy x</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the model prediction</span>
<span class="hljs-meta">... </span>        pred = net(noisy_x, <span class="hljs-number">0</span>).sample  <span class="hljs-comment"># &lt;&lt;&lt; Using timestep 0 always, adding .sample</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Calculate the loss</span>
<span class="hljs-meta">... </span>        loss = loss_fn(pred, x)  <span class="hljs-comment"># How close is the output to the true &#x27;clean&#x27; x?</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Backprop and update the params:</span>
<span class="hljs-meta">... </span>        opt.zero_grad()
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        opt.step()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Store the loss for later</span>
<span class="hljs-meta">... </span>        losses.append(loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Print our the average of the loss values for this epoch:</span>
<span class="hljs-meta">... </span>    avg_loss = <span class="hljs-built_in">sum</span>(losses[-<span class="hljs-built_in">len</span>(train_dataloader) :]) / <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Finished epoch <span class="hljs-subst">{epoch}</span>. Average loss for this epoch: <span class="hljs-subst">{avg_loss:05f}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot losses and some samples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Losses</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].plot(losses)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_ylim(<span class="hljs-number">0</span>, <span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Loss over time&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Samples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_steps = <span class="hljs-number">40</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.rand(<span class="hljs-number">64</span>, <span class="hljs-number">1</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps):
<span class="hljs-meta">... </span>    noise_amount = torch.ones((x.shape[<span class="hljs-number">0</span>],)).to(device) * (<span class="hljs-number">1</span> - (i / n_steps))  <span class="hljs-comment"># Starting high going low</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        pred = net(x, <span class="hljs-number">0</span>).sample
<span class="hljs-meta">... </span>    mix_factor = <span class="hljs-number">1</span> / (n_steps - i)
<span class="hljs-meta">... </span>    x = x * (<span class="hljs-number">1</span> - mix_factor) + pred * mix_factor

<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(torchvision.utils.make_grid(x.detach().cpu(), nrow=<span class="hljs-number">8</span>)[<span class="hljs-number">0</span>].clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Generated Samples&quot;</span>)`,wrap:!1}}),zA=new c({props:{title:"The Corruption Process",local:"the-corruption-process",headingTag:"h3"}}),qA=new M({props:{code:"JTIzJTIwJTNGJTNGbm9pc2Vfc2NoZWR1bGVyLmFkZF9ub2lzZQ==",highlighted:'<span class="hljs-comment"># ??noise_scheduler.add_noise</span>',wrap:!1}}),YA=new M({props:{code:"bm9pc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERQTVNjaGVkdWxlcihudW1fdHJhaW5fdGltZXN0ZXBzJTNEMTAwMCklMEFwbHQucGxvdChub2lzZV9zY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QuY3B1KCklMjAqKiUyMDAuNSUyQyUyMGxhYmVsJTNEciUyMiUyNCU3QiU1Q3NxcnQlN0IlNUNiYXIlN0IlNUNhbHBoYSU3RF90JTdEJTdEJTI0JTIyKSUwQXBsdC5wbG90KCgxJTIwLSUyMG5vaXNlX3NjaGVkdWxlci5hbHBoYXNfY3VtcHJvZC5jcHUoKSklMjAqKiUyMDAuNSUyQyUyMGxhYmVsJTNEciUyMiUyNCU1Q3NxcnQlN0IoMSUyMC0lMjAlNUNiYXIlN0IlNUNhbHBoYSU3RF90KSU3RCUyNCUyMiklMEFwbHQubGVnZW5kKGZvbnRzaXplJTNEJTIyeC1sYXJnZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(noise_scheduler.alphas_cumprod.cpu() ** <span class="hljs-number">0.5</span>, label=<span class="hljs-string">r&quot;\${\\sqrt{\\bar{\\alpha}_t}}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot((<span class="hljs-number">1</span> - noise_scheduler.alphas_cumprod.cpu()) ** <span class="hljs-number">0.5</span>, label=<span class="hljs-string">r&quot;$\\sqrt{(1 - \\bar{\\alpha}_t)}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.legend(fontsize=<span class="hljs-string">&quot;x-large&quot;</span>)`,wrap:!1}}),$A=new M({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjB2aXN1YWxpemUlMjB0aGUlMjBERFBNJTIwbm9pc2luZyUyMHByb2Nlc3MlMjBmb3IlMjBkaWZmZXJlbnQlMjB0aW1lc3RlcHMlM0ElMEElMEElMjMlMjBOb2lzZSUyMGElMjBiYXRjaCUyMG9mJTIwaW1hZ2VzJTIwdG8lMjB2aWV3JTIwdGhlJTIwZWZmZWN0JTBBZmlnJTJDJTIwYXhzJTIwJTNEJTIwcGx0LnN1YnBsb3RzKDMlMkMlMjAxJTJDJTIwZmlnc2l6ZSUzRCgxNiUyQyUyMDEwKSklMEF4YiUyQyUyMHliJTIwJTNEJTIwbmV4dChpdGVyKHRyYWluX2RhdGFsb2FkZXIpKSUwQXhiJTIwJTNEJTIweGIudG8oZGV2aWNlKSU1QiUzQTglNUQlMEF4YiUyMCUzRCUyMHhiJTIwKiUyMDIuMCUyMC0lMjAxLjAlMjAlMjAlMjMlMjBNYXAlMjB0byUyMCgtMSUyQyUyMDEpJTBBcHJpbnQoJTIyWCUyMHNoYXBlJTIyJTJDJTIweGIuc2hhcGUpJTBBJTBBJTIzJTIwU2hvdyUyMGNsZWFuJTIwaW5wdXRzJTBBYXhzJTVCMCU1RC5pbXNob3codG9yY2h2aXNpb24udXRpbHMubWFrZV9ncmlkKHhiJTVCJTNBOCU1RCklNUIwJTVELmRldGFjaCgpLmNwdSgpJTJDJTIwY21hcCUzRCUyMkdyZXlzJTIyKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMkNsZWFuJTIwWCUyMiklMEElMEElMjMlMjBBZGQlMjBub2lzZSUyMHdpdGglMjBzY2hlZHVsZXIlMEF0aW1lc3RlcHMlMjAlM0QlMjB0b3JjaC5saW5zcGFjZSgwJTJDJTIwOTk5JTJDJTIwOCkubG9uZygpLnRvKGRldmljZSklMEFub2lzZSUyMCUzRCUyMHRvcmNoLnJhbmRuX2xpa2UoeGIpJTIwJTIwJTIzJTIwJTNDJTNDJTIwTkIlM0ElMjByYW5kbiUyMG5vdCUyMHJhbmQlMEFub2lzeV94YiUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2UoeGIlMkMlMjBub2lzZSUyQyUyMHRpbWVzdGVwcyklMEFwcmludCglMjJOb2lzeSUyMFglMjBzaGFwZSUyMiUyQyUyMG5vaXN5X3hiLnNoYXBlKSUwQSUwQSUyMyUyMFNob3clMjBub2lzeSUyMHZlcnNpb24lMjAod2l0aCUyMGFuZCUyMHdpdGhvdXQlMjBjbGlwcGluZyklMEFheHMlNUIxJTVELmltc2hvdyh0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQobm9pc3lfeGIlNUIlM0E4JTVEKSU1QjAlNUQuZGV0YWNoKCkuY3B1KCkuY2xpcCgtMSUyQyUyMDEpJTJDJTIwY21hcCUzRCUyMkdyZXlzJTIyKSUwQWF4cyU1QjElNUQuc2V0X3RpdGxlKCUyMk5vaXN5JTIwWCUyMChjbGlwcGVkJTIwdG8lMjAoLTElMkMlMjAxKSUyMiklMEFheHMlNUIyJTVELmltc2hvdyh0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQobm9pc3lfeGIlNUIlM0E4JTVEKSU1QjAlNUQuZGV0YWNoKCkuY3B1KCklMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIpJTBBYXhzJTVCMiU1RC5zZXRfdGl0bGUoJTIyTm9pc3klMjBYJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown visualize the DDPM noising process for different timesteps:</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Noise a batch of images to view the effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">3</span>, <span class="hljs-number">1</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>xb, yb = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span>xb = xb.to(device)[:<span class="hljs-number">8</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xb = xb * <span class="hljs-number">2.0</span> - <span class="hljs-number">1.0</span>  <span class="hljs-comment"># Map to (-1, 1)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;X shape&quot;</span>, xb.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Show clean inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(torchvision.utils.make_grid(xb[:<span class="hljs-number">8</span>])[<span class="hljs-number">0</span>].detach().cpu(), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Clean X&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Add noise with scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">999</span>, <span class="hljs-number">8</span>).long().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn_like(xb)  <span class="hljs-comment"># &lt;&lt; NB: randn not rand</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_xb = noise_scheduler.add_noise(xb, noise, timesteps)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Noisy X shape&quot;</span>, noisy_xb.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Show noisy version (with and without clipping)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(torchvision.utils.make_grid(noisy_xb[:<span class="hljs-number">8</span>])[<span class="hljs-number">0</span>].detach().cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Noisy X (clipped to (-1, 1)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].imshow(torchvision.utils.make_grid(noisy_xb[:<span class="hljs-number">8</span>])[<span class="hljs-number">0</span>].detach().cpu(), cmap=<span class="hljs-string">&quot;Greys&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].set_title(<span class="hljs-string">&quot;Noisy X&quot;</span>)`,wrap:!1}}),et=new c({props:{title:"Training Objective",local:"training-objective",headingTag:"h3"}}),at=new M({props:{code:"bm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbl9saWtlKHhiKSUyMCUyMyUyMCUzQyUzQyUyME5CJTNBJTIwcmFuZG4lMjBub3QlMjByYW5kJTBBbm9pc3lfeCUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2UoeCUyQyUyMG5vaXNlJTJDJTIwdGltZXN0ZXBzKSUwQW1vZGVsX3ByZWRpY3Rpb24lMjAlM0QlMjBtb2RlbChub2lzeV94JTJDJTIwdGltZXN0ZXBzKS5zYW1wbGUlMEFsb3NzJTIwJTNEJTIwbXNlX2xvc3MobW9kZWxfcHJlZGljdGlvbiUyQyUyMG5vaXNlKSUyMCUyMyUyMG5vaXNlJTIwYXMlMjB0aGUlMjB0YXJnZXQ=",highlighted:`noise = torch.randn_like(xb) <span class="hljs-comment"># &lt;&lt; NB: randn not rand</span>
noisy_x = noise_scheduler.add_noise(x, noise, timesteps)
model_prediction = model(noisy_x, timesteps).sample
loss = mse_loss(model_prediction, noise) <span class="hljs-comment"># noise as the target</span>`,wrap:!1}}),it=new c({props:{title:"Timestep Conditioning",local:"timestep-conditioning",headingTag:"h3"}}),wt=new c({props:{title:"Sampling",local:"sampling",headingTag:"h3"}}),ht=new c({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),Bt=new dn({props:{source:"https://github.com/huggingface/diffusion-models-class/blob/main/unit1/02_diffusion_models_from_scratch.md"}}),{c(){h=l("meta"),Kt=a(),yt=l("p"),Qt=a(),p(C.$$.fragment),vt=a(),p(u.$$.fragment),Dt=a(),B=l("p"),B.textContent=Ws,Tt=a(),g=l("p"),g.textContent=Es,Pt=a(),m=l("ul"),m.innerHTML=zs,xt=a(),d=l("p"),d.textContent=Ss,Ht=a(),J=l("ul"),J.innerHTML=Vs,kt=a(),b=l("p"),b.textContent=Zs,Gt=a(),F=l("p"),F.textContent=Ls,Nt=a(),p(y.$$.fragment),Xt=a(),p(I.$$.fragment),Wt=a(),R=l("pre"),R.textContent=Os,Et=a(),p(K.$$.fragment),zt=a(),Q=l("pre"),Q.textContent=qs,St=a(),p(v.$$.fragment),Vt=a(),D=l("p"),D.textContent=Ys,Zt=a(),p(T.$$.fragment),Lt=a(),P=l("pre"),P.textContent=_s,Ot=a(),p(x.$$.fragment),qt=a(),p(H.$$.fragment),Yt=a(),k=l("pre"),k.textContent=$s,_t=a(),G=l("p"),G.textContent=Aa,$t=a(),p(N.$$.fragment),Ae=a(),X=l("p"),X.textContent=ta,te=a(),W=l("p"),W.innerHTML=ea,ee=a(),E=l("p"),E.innerHTML=sa,se=a(),z=l("p"),z.innerHTML=aa,ae=a(),S=l("p"),S.textContent=na,ne=a(),V=l("p"),V.textContent=la,le=a(),p(Z.$$.fragment),oe=a(),L=l("p"),L.textContent=oa,ie=a(),p(O.$$.fragment),pe=a(),mt=l("img"),re=a(),q=l("p"),q.textContent=pa,we=a(),p(Y.$$.fragment),je=a(),_=l("p"),_.innerHTML=ra,fe=a(),$=l("p"),$.innerHTML=wa,Ue=a(),AA=l("p"),AA.innerHTML=ja,Me=a(),tA=l("p"),tA.textContent=fa,ce=a(),p(eA.$$.fragment),he=a(),sA=l("p"),sA.textContent=Ua,Ce=a(),p(aA.$$.fragment),ue=a(),nA=l("p"),nA.textContent=Ma,Be=a(),p(lA.$$.fragment),ge=a(),oA=l("p"),oA.textContent=ca,me=a(),p(iA.$$.fragment),de=a(),pA=l("p"),pA.textContent=ha,Je=a(),rA=l("p"),rA.textContent=Ca,be=a(),wA=l("ul"),wA.innerHTML=ua,Fe=a(),jA=l("p"),jA.textContent=Ba,ye=a(),p(fA.$$.fragment),Ie=a(),UA=l("pre"),UA.textContent=ga,Re=a(),MA=l("p"),MA.textContent=ma,Ke=a(),p(cA.$$.fragment),Qe=a(),dt=l("img"),ve=a(),hA=l("p"),hA.textContent=Ja,De=a(),p(CA.$$.fragment),Te=a(),uA=l("p"),uA.textContent=ba,Pe=a(),BA=l("p"),BA.textContent=Fa,xe=a(),gA=l("p"),gA.textContent=ya,He=a(),p(mA.$$.fragment),ke=a(),Jt=l("img"),Ge=a(),dA=l("p"),dA.textContent=Ra,Ne=a(),p(JA.$$.fragment),Xe=a(),bt=l("img"),We=a(),bA=l("p"),bA.textContent=Qa,Ee=a(),p(FA.$$.fragment),ze=a(),yA=l("p"),yA.innerHTML=va,Se=a(),IA=l("p"),IA.textContent=Da,Ve=a(),RA=l("ul"),RA.innerHTML=Ta,Ze=a(),KA=l("p"),KA.innerHTML=Pa,Le=a(),QA=l("p"),QA.textContent=xa,Oe=a(),p(vA.$$.fragment),qe=a(),DA=l("p"),DA.textContent=Ha,Ye=a(),TA=l("ul"),TA.innerHTML=ka,_e=a(),PA=l("p"),PA.textContent=Ga,$e=a(),p(xA.$$.fragment),As=a(),HA=l("pre"),HA.textContent=Na,ts=a(),kA=l("p"),kA.textContent=Xa,es=a(),p(GA.$$.fragment),ss=a(),NA=l("p"),NA.innerHTML=Wa,as=a(),p(XA.$$.fragment),ns=a(),WA=l("pre"),WA.textContent=Ea,ls=a(),EA=l("p"),EA.textContent=za,os=a(),p(zA.$$.fragment),is=a(),SA=l("p"),SA.innerHTML=Sa,ps=a(),VA=l("p"),VA.innerHTML=Va,rs=a(),ZA=l("p"),ZA.innerHTML=Za,ws=a(),LA=l("p"),LA.innerHTML=La,js=a(),OA=l("p"),OA.innerHTML=Oa,fs=a(),p(qA.$$.fragment),Us=a(),p(YA.$$.fragment),Ms=a(),Ft=l("img"),cs=a(),_A=l("p"),_A.innerHTML=Ya,hs=a(),p($A.$$.fragment),Cs=a(),At=l("pre"),At.textContent=_a,us=a(),tt=l("p"),tt.innerHTML=$a,Bs=a(),p(et.$$.fragment),gs=a(),st=l("p"),st.textContent=An,ms=a(),p(at.$$.fragment),ds=a(),nt=l("p"),nt.textContent=tn,Js=a(),lt=l("p"),lt.textContent=en,bs=a(),ot=l("p"),ot.textContent=sn,Fs=a(),p(it.$$.fragment),ys=a(),pt=l("p"),pt.textContent=an,Is=a(),rt=l("p"),rt.textContent=nn,Rs=a(),p(wt.$$.fragment),Ks=a(),jt=l("p"),jt.textContent=ln,Qs=a(),ft=l("p"),ft.textContent=on,vs=a(),Ut=l("p"),Ut.textContent=pn,Ds=a(),Mt=l("ul"),Mt.innerHTML=rn,Ts=a(),ct=l("p"),ct.innerHTML=wn,Ps=a(),p(ht.$$.fragment),xs=a(),Ct=l("p"),Ct.textContent=jn,Hs=a(),ut=l("p"),ut.innerHTML=fn,ks=a(),p(Bt.$$.fragment),Gs=a(),It=l("p"),this.h()},l(A){const t=Bn("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(e),Kt=n(A),yt=o(A,"P",{}),Un(yt).forEach(e),Qt=n(A),r(C.$$.fragment,A),vt=n(A),r(u.$$.fragment,A),Dt=n(A),B=o(A,"P",{"data-svelte-h":!0}),i(B)!=="svelte-b06c6n"&&(B.textContent=Ws),Tt=n(A),g=o(A,"P",{"data-svelte-h":!0}),i(g)!=="svelte-12gxjj8"&&(g.textContent=Es),Pt=n(A),m=o(A,"UL",{"data-svelte-h":!0}),i(m)!=="svelte-1mlcx51"&&(m.innerHTML=zs),xt=n(A),d=o(A,"P",{"data-svelte-h":!0}),i(d)!=="svelte-7gx5fp"&&(d.textContent=Ss),Ht=n(A),J=o(A,"UL",{"data-svelte-h":!0}),i(J)!=="svelte-twyjrz"&&(J.innerHTML=Vs),kt=n(A),b=o(A,"P",{"data-svelte-h":!0}),i(b)!=="svelte-lcstmc"&&(b.textContent=Zs),Gt=n(A),F=o(A,"P",{"data-svelte-h":!0}),i(F)!=="svelte-c0karq"&&(F.textContent=Ls),Nt=n(A),r(y.$$.fragment,A),Xt=n(A),r(I.$$.fragment,A),Wt=n(A),R=o(A,"PRE",{"data-svelte-h":!0}),i(R)!=="svelte-154h9wa"&&(R.textContent=Os),Et=n(A),r(K.$$.fragment,A),zt=n(A),Q=o(A,"PRE",{"data-svelte-h":!0}),i(Q)!=="svelte-r4w2rl"&&(Q.textContent=qs),St=n(A),r(v.$$.fragment,A),Vt=n(A),D=o(A,"P",{"data-svelte-h":!0}),i(D)!=="svelte-5tk719"&&(D.textContent=Ys),Zt=n(A),r(T.$$.fragment,A),Lt=n(A),P=o(A,"PRE",{"data-svelte-h":!0}),i(P)!=="svelte-10x3oeh"&&(P.textContent=_s),Ot=n(A),r(x.$$.fragment,A),qt=n(A),r(H.$$.fragment,A),Yt=n(A),k=o(A,"PRE",{"data-svelte-h":!0}),i(k)!=="svelte-q6g64n"&&(k.textContent=$s),_t=n(A),G=o(A,"P",{"data-svelte-h":!0}),i(G)!=="svelte-90cqok"&&(G.textContent=Aa),$t=n(A),r(N.$$.fragment,A),Ae=n(A),X=o(A,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1m5p5jw"&&(X.textContent=ta),te=n(A),W=o(A,"P",{"data-svelte-h":!0}),i(W)!=="svelte-5fmovs"&&(W.innerHTML=ea),ee=n(A),E=o(A,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1a25b9u"&&(E.innerHTML=sa),se=n(A),z=o(A,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1kxec1l"&&(z.innerHTML=aa),ae=n(A),S=o(A,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1bz3rwd"&&(S.textContent=na),ne=n(A),V=o(A,"P",{"data-svelte-h":!0}),i(V)!=="svelte-d76chv"&&(V.textContent=la),le=n(A),r(Z.$$.fragment,A),oe=n(A),L=o(A,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1amwbff"&&(L.textContent=oa),ie=n(A),r(O.$$.fragment,A),pe=n(A),mt=o(A,"IMG",{src:!0}),re=n(A),q=o(A,"P",{"data-svelte-h":!0}),i(q)!=="svelte-w5pptg"&&(q.textContent=pa),we=n(A),r(Y.$$.fragment,A),je=n(A),_=o(A,"P",{"data-svelte-h":!0}),i(_)!=="svelte-15vbw"&&(_.innerHTML=ra),fe=n(A),$=o(A,"P",{"data-svelte-h":!0}),i($)!=="svelte-1sngau9"&&($.innerHTML=wa),Ue=n(A),AA=o(A,"P",{"data-svelte-h":!0}),i(AA)!=="svelte-vvy0q0"&&(AA.innerHTML=ja),Me=n(A),tA=o(A,"P",{"data-svelte-h":!0}),i(tA)!=="svelte-b3rllk"&&(tA.textContent=fa),ce=n(A),r(eA.$$.fragment,A),he=n(A),sA=o(A,"P",{"data-svelte-h":!0}),i(sA)!=="svelte-1exzxim"&&(sA.textContent=Ua),Ce=n(A),r(aA.$$.fragment,A),ue=n(A),nA=o(A,"P",{"data-svelte-h":!0}),i(nA)!=="svelte-1qijb03"&&(nA.textContent=Ma),Be=n(A),r(lA.$$.fragment,A),ge=n(A),oA=o(A,"P",{"data-svelte-h":!0}),i(oA)!=="svelte-1fy88vj"&&(oA.textContent=ca),me=n(A),r(iA.$$.fragment,A),de=n(A),pA=o(A,"P",{"data-svelte-h":!0}),i(pA)!=="svelte-1kka2ga"&&(pA.textContent=ha),Je=n(A),rA=o(A,"P",{"data-svelte-h":!0}),i(rA)!=="svelte-z8s247"&&(rA.textContent=Ca),be=n(A),wA=o(A,"UL",{"data-svelte-h":!0}),i(wA)!=="svelte-vmtac3"&&(wA.innerHTML=ua),Fe=n(A),jA=o(A,"P",{"data-svelte-h":!0}),i(jA)!=="svelte-ztogie"&&(jA.textContent=Ba),ye=n(A),r(fA.$$.fragment,A),Ie=n(A),UA=o(A,"PRE",{"data-svelte-h":!0}),i(UA)!=="svelte-1m76b1h"&&(UA.textContent=ga),Re=n(A),MA=o(A,"P",{"data-svelte-h":!0}),i(MA)!=="svelte-j4uhw5"&&(MA.textContent=ma),Ke=n(A),r(cA.$$.fragment,A),Qe=n(A),dt=o(A,"IMG",{src:!0}),ve=n(A),hA=o(A,"P",{"data-svelte-h":!0}),i(hA)!=="svelte-1sifkv"&&(hA.textContent=Ja),De=n(A),r(CA.$$.fragment,A),Te=n(A),uA=o(A,"P",{"data-svelte-h":!0}),i(uA)!=="svelte-wf9kkw"&&(uA.textContent=ba),Pe=n(A),BA=o(A,"P",{"data-svelte-h":!0}),i(BA)!=="svelte-8j9qs8"&&(BA.textContent=Fa),xe=n(A),gA=o(A,"P",{"data-svelte-h":!0}),i(gA)!=="svelte-1cbek8f"&&(gA.textContent=ya),He=n(A),r(mA.$$.fragment,A),ke=n(A),Jt=o(A,"IMG",{src:!0}),Ge=n(A),dA=o(A,"P",{"data-svelte-h":!0}),i(dA)!=="svelte-1xe0skz"&&(dA.textContent=Ra),Ne=n(A),r(JA.$$.fragment,A),Xe=n(A),bt=o(A,"IMG",{src:!0}),We=n(A),bA=o(A,"P",{"data-svelte-h":!0}),i(bA)!=="svelte-1kovoa5"&&(bA.textContent=Qa),Ee=n(A),r(FA.$$.fragment,A),ze=n(A),yA=o(A,"P",{"data-svelte-h":!0}),i(yA)!=="svelte-izoyfr"&&(yA.innerHTML=va),Se=n(A),IA=o(A,"P",{"data-svelte-h":!0}),i(IA)!=="svelte-1o8v54r"&&(IA.textContent=Da),Ve=n(A),RA=o(A,"UL",{"data-svelte-h":!0}),i(RA)!=="svelte-1a28sxj"&&(RA.innerHTML=Ta),Ze=n(A),KA=o(A,"P",{"data-svelte-h":!0}),i(KA)!=="svelte-8cnnhm"&&(KA.innerHTML=Pa),Le=n(A),QA=o(A,"P",{"data-svelte-h":!0}),i(QA)!=="svelte-1tjaz0n"&&(QA.textContent=xa),Oe=n(A),r(vA.$$.fragment,A),qe=n(A),DA=o(A,"P",{"data-svelte-h":!0}),i(DA)!=="svelte-xt7xu1"&&(DA.textContent=Ha),Ye=n(A),TA=o(A,"UL",{"data-svelte-h":!0}),i(TA)!=="svelte-1eq7s2r"&&(TA.innerHTML=ka),_e=n(A),PA=o(A,"P",{"data-svelte-h":!0}),i(PA)!=="svelte-1pk3y7y"&&(PA.textContent=Ga),$e=n(A),r(xA.$$.fragment,A),As=n(A),HA=o(A,"PRE",{"data-svelte-h":!0}),i(HA)!=="svelte-k9peum"&&(HA.textContent=Na),ts=n(A),kA=o(A,"P",{"data-svelte-h":!0}),i(kA)!=="svelte-18bm2vg"&&(kA.textContent=Xa),es=n(A),r(GA.$$.fragment,A),ss=n(A),NA=o(A,"P",{"data-svelte-h":!0}),i(NA)!=="svelte-nfg94z"&&(NA.innerHTML=Wa),as=n(A),r(XA.$$.fragment,A),ns=n(A),WA=o(A,"PRE",{"data-svelte-h":!0}),i(WA)!=="svelte-jla4rf"&&(WA.textContent=Ea),ls=n(A),EA=o(A,"P",{"data-svelte-h":!0}),i(EA)!=="svelte-10gz4yk"&&(EA.textContent=za),os=n(A),r(zA.$$.fragment,A),is=n(A),SA=o(A,"P",{"data-svelte-h":!0}),i(SA)!=="svelte-1frxnc3"&&(SA.innerHTML=Sa),ps=n(A),VA=o(A,"P",{"data-svelte-h":!0}),i(VA)!=="svelte-ktr7ft"&&(VA.innerHTML=Va),rs=n(A),ZA=o(A,"P",{"data-svelte-h":!0}),i(ZA)!=="svelte-1577x24"&&(ZA.innerHTML=Za),ws=n(A),LA=o(A,"P",{"data-svelte-h":!0}),i(LA)!=="svelte-1k962rq"&&(LA.innerHTML=La),js=n(A),OA=o(A,"P",{"data-svelte-h":!0}),i(OA)!=="svelte-1efrp0i"&&(OA.innerHTML=Oa),fs=n(A),r(qA.$$.fragment,A),Us=n(A),r(YA.$$.fragment,A),Ms=n(A),Ft=o(A,"IMG",{src:!0}),cs=n(A),_A=o(A,"P",{"data-svelte-h":!0}),i(_A)!=="svelte-1a9zjhg"&&(_A.innerHTML=Ya),hs=n(A),r($A.$$.fragment,A),Cs=n(A),At=o(A,"PRE",{"data-svelte-h":!0}),i(At)!=="svelte-17hx7t6"&&(At.textContent=_a),us=n(A),tt=o(A,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-jz9t4x"&&(tt.innerHTML=$a),Bs=n(A),r(et.$$.fragment,A),gs=n(A),st=o(A,"P",{"data-svelte-h":!0}),i(st)!=="svelte-748a95"&&(st.textContent=An),ms=n(A),r(at.$$.fragment,A),ds=n(A),nt=o(A,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-jgjz88"&&(nt.textContent=tn),Js=n(A),lt=o(A,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-xkn1u9"&&(lt.textContent=en),bs=n(A),ot=o(A,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-1r7rs8"&&(ot.textContent=sn),Fs=n(A),r(it.$$.fragment,A),ys=n(A),pt=o(A,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-fluvwp"&&(pt.textContent=an),Is=n(A),rt=o(A,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1ny9szf"&&(rt.textContent=nn),Rs=n(A),r(wt.$$.fragment,A),Ks=n(A),jt=o(A,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1my7zov"&&(jt.textContent=ln),Qs=n(A),ft=o(A,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-1u6t28a"&&(ft.textContent=on),vs=n(A),Ut=o(A,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-57ihi0"&&(Ut.textContent=pn),Ds=n(A),Mt=o(A,"UL",{"data-svelte-h":!0}),i(Mt)!=="svelte-16phoes"&&(Mt.innerHTML=rn),Ts=n(A),ct=o(A,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-8931k9"&&(ct.innerHTML=wn),Ps=n(A),r(ht.$$.fragment,A),xs=n(A),Ct=o(A,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-15ld5kn"&&(Ct.textContent=jn),Hs=n(A),ut=o(A,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-78fmk"&&(ut.innerHTML=fn),ks=n(A),r(Bt.$$.fragment,A),Gs=n(A),It=o(A,"P",{}),Un(It).forEach(e),this.h()},h(){gt(h,"name","hf:doc:metadata"),gt(h,"content",bn),Rt(mt.src,ia="data:image/jpeg;base64,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")||gt(mt,"src",ia),Rt(dt.src,da="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAGUAr8DASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKK8P+KWt6j4c8f6tq2k3H2e+g8KQ+XLsV9u7UEU8MCDwSORQB7hRXg/ijxX4+8E3HiLSrzxJBqMkWlQahZXosY43jzdRwsCgG3nc4IO7opBByKof8LN8T6V40TR5fFMGsaQmq2Ec2tx28EcCwuCZIyVUqN2T827I8lsd8AH0PRXzx4u8XnxL4vcxeJMaBpniXSktZolhWOEtHL5su9kO7a0bEEkpgk4Ixj0P4seJdX8HeCrCTTNTjgu572Gzk1C6hDlFKszSFVUjPyc4Q8E4XOMAHeQ39ncXlzZw3cEl1a7ftEKSAvFuGV3KOVyORnrVivmx/FF54b1HxjqC+NpLqeS902FtY07Tbe4FwDbznb5ZcIANoBIJOU6cnBH4r1Xxfb6VZalrl3Pead4ytIkuY4LZVMUgcRuNgZS6mKQ8Fk+fq4xgA+k6K+fPGXxT1XRfEuqW+ieLLu4/sp40azutLtlimZCkcoMu5ZGJbcSEQd9uFG4fQdABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVl+I9fsfC3h+81rUmkFpaoGfy13MxJCqoHqWIHOBzyQOa1K5vx94am8X+CNT0K3uI7ee5RDHJICV3I6uAccgErjPOM5wcYoAPCnjSx8WPqEEFlqWn3mnui3NnqNv5MqB13I2MkYIBxznjpggnUvte0bTLgW+oatYWkxUOI7i5SNipJAOCQcZB59jXN+CfDWvaZrfiHXvEdxpr6hrD24MOnB/KjWFCgOX5yc8jtjrzgXtE0jTdG8Xatb6Xp1pYwtYWbtHawrEpbzLkZIUAZwBz7UAXf+Ev8ADP8A0MWkf+Bsf/xVH/CX+Gf+hi0j/wADY/8A4qtmigDG/wCEv8M/9DFpH/gbH/8AFUf8Jf4Z/wChi0j/AMDY/wD4qtmigDG/4S/wz/0MWkf+Bsf/AMVR/wAJf4Z/6GLSP/A2P/4qtmigDG/4S/wz/wBDFpH/AIGx/wDxVH/CX+Gf+hi0j/wNj/8Aiq2aKAMb/hL/AAz/ANDFpH/gbH/8VR/wl/hn/oYtI/8AA2P/AOKrZooAxv8AhL/DP/QxaR/4Gx//ABVH/CX+Gf8AoYtI/wDA2P8A+KrZooAxv+Ev8M/9DFpH/gbH/wDFUf8ACX+Gf+hi0j/wNj/+KrZooAxv+Ev8M/8AQxaR/wCBsf8A8VR/wl/hn/oYtI/8DY//AIqtmigDG/4S/wAM/wDQxaR/4Gx//FUf8Jf4Z/6GLSP/AANj/wDiq2aKAMb/AIS/wz/0MWkf+Bsf/wAVR/wl/hn/AKGLSP8AwNj/APiq2aKAMb/hL/DP/QxaR/4Gx/8AxVH/AAl/hn/oYtI/8DY//iq2aKAMb/hL/DP/AEMWkf8AgbH/APFUf8Jf4Z/6GLSP/A2P/wCKrZooAxv+Ev8ADP8A0MWkf+Bsf/xVH/CX+Gf+hi0j/wADY/8A4qtmigDG/wCEv8M/9DFpH/gbH/8AFUf8Jf4Z/wChi0j/AMDY/wD4qtmigDG/4S/wz/0MWkf+Bsf/AMVR/wAJf4Z/6GLSP/A2P/4qtmigDG/4S/wz/wBDFpH/AIGx/wDxVH/CX+Gf+hi0j/wNj/8Aiq2aKAMb/hL/AAz/ANDFpH/gbH/8VR/wl/hn/oYtI/8AA2P/AOKrZooAxv8AhL/DP/QxaR/4Gx//ABVH/CX+Gf8AoYtI/wDA2P8A+KrZooAxv+Ev8M/9DFpH/gbH/wDFVn32peAdTlklv73w1dySRCB3nlgkLRhg4QknlQwDY6ZGetdTRQB5942h8G+MdBvrH/hI9Bs766ijg/tDzYZJFjWVZdmdwJUlemcZOa0IX+GtvZ3NnC3hOO1utv2iFDbBJdpyu5Rw2DyM9K7GigDihH8L1t3t1TwgIHdXeMC22syghSR0JAZgD23H1rQm1nwPc6WNLn1Lw9Lp4RUFo88LRBVxtGwnGBgYGOMCulooA4oR/C9bd7dU8ICB3V3jAttrMoIUkdCQGYA9tx9aBH8L1t3t1TwgIHdXeMC22syghSR0JAZgD23H1rtaKAOG+x/Cn/n28Gf98WtdB/wl/hn/AKGLSP8AwNj/APiq2aKAMb/hL/DP/QxaR/4Gx/8AxVH/AAl/hn/oYtI/8DY//iq2aKAMb/hL/DP/AEMWkf8AgbH/APFUf8Jf4Z/6GLSP/A2P/wCKrZooAxv+Ev8ADP8A0MWkf+Bsf/xVH/CX+Gf+hi0j/wADY/8A4qtmigDG/wCEv8M/9DFpH/gbH/8AFUf8Jf4Z/wChi0j/AMDY/wD4qtmigDG/4S/wz/0MWkf+Bsf/AMVR/wAJf4Z/6GLSP/A2P/4qtmigDG/4S/wz/wBDFpH/AIGx/wDxVH/CX+Gf+hi0j/wNj/8Aiq2aKAMb/hL/AAz/ANDFpH/gbH/8VR/wl/hn/oYtI/8AA2P/AOKrZooAxv8AhL/DP/QxaR/4Gx//ABVH/CX+Gf8AoYtI/wDA2P8A+KrZooAxv+Ev8M/9DFpH/gbH/wDFUf8ACX+Gf+hi0j/wNj/+KrZooAxv+Ev8M/8AQxaR/wCBsf8A8VR/wl/hn/oYtI/8DY//AIqtmigDG/4S/wAM/wDQxaR/4Gx//FUf8Jf4Z/6GLSP/AANj/wDiq2aKAMb/AIS/wz/0MWkf+Bsf/wAVR/wl/hn/AKGLSP8AwNj/APiq2aKAMb/hL/DP/QxaR/4Gx/8AxVH/AAl/hn/oYtI/8DY//iq2aKAMb/hL/DP/AEMWkf8AgbH/APFUf8Jf4Z/6GLSP/A2P/wCKrZooAxv+Ev8ADP8A0MWkf+Bsf/xVH/CX+Gf+hi0j/wADY/8A4qtmigDG/wCEv8M/9DFpH/gbH/8AFUf8Jf4Z/wChi0j/AMDY/wD4qtmigDG/4S/wz/0MWkf+Bsf/AMVR/wAJf4Z/6GLSP/A2P/4qtmigDG/4S/wz/wBDFpH/AIGx/wDxVH/CX+Gf+hi0j/wNj/8Aiq2aKAMb/hL/AAz/ANDFpH/gbH/8VWrBPDc28dxbypLDKoeOSNgyupGQQRwQR3qSsbwh/wAiVoP/AGDrf/0WtAGzRRRQAVjW3/I66p/2DrP/ANGXNbNY1t/yOuqf9g6z/wDRlzQBs0UUUAFFFNd1jRnYgKBkk0AOoryX4h/F+18PCWxsVMt1ym+KQfKccGvG7P4t+MobtZ59XupYMjKHGDz9KAPr6iuM+H3jeHxhpCTBDHN825GYE4BxXZ0AFFFFABRRRQAUUyWRYYmkdgqqMknoBXA658VtP0q5mgtrR794uogkHpQB6DRXm2i/GHS9T2C8tW05m/huJQMc139lqVnqMQktLmKdD3jcMP0oAtUUUUAFFFFABRRRQAUUUUAFFUdV1a00azNzeTRxR5xl2wM+lQeH9dt/EWmC/tceUXZBhgelAGrRRWF4p8TW/hbR5tRuIzIsQB2hgCecUAbtFcf4E8dx+OLW6uIdOmtUgkEf7xgd2RnIxXYUAFFFFABRRRQAUUVUv9Ts9NhMt3cxQoOpkYKKALdFcHf/ABX8P2UcjLcwzFTjaky815d4u+MerapOlt4cNxA7AjMTBjnP0oA+jaK4P4XReJBoslz4j1Ga7kuAjxCVNpjGORXeUAFFFFABRRRQAUUVk+JtWOiaBc6gEL+UAdoOCecUAS6hr2k6Upa/1C3tlAzmR8VNYanY6pD51jdRXEf96NsivnjS/CfiT4pyalc3mtTW1sk5RIpY9w2nnimGHxr8Mb0COW9vNMibMnlx4QqOO9AH0rRXPeDvEkfibQ7e7VCkjRqzqTkgn1roaACiiigAooooAKKKKAIbq6gsbWS5upUigiXc8jnAUeprL0/xb4f1WbybDWLS5kzjbHICc1x/xm1Wax8JXFtGzBbiB1bHccV88fDnVJtP8Z6asbsqy3CBsHrQB9o0VDayebbI5OcjNTUAFFFFABRRRQAUUUUAFFFFABRRUclxDEMySKo9zigCSism78T6LZHE+qWkZ9GmAq7Y6ha6lb+fZzxzxZxvjYMM0AWaKKKACiiigAqlqmp22lWMlzcypGqqSNxxkgZxVt3CIzscADJryLxVqV1408UDw7YF0gs5UlmkX5lkQ8EfzoAdYXniD4hX5msdQvNK04AMk0Dblcg4K16fpVlPYWawz3kl04JzJJ1NM0bRrLQ9OjsrGBIYUzhUGBzWjQAUUUUAFY3hD/kStB/7B1v/AOi1rZrG8If8iVoP/YOt/wD0WtAGzXzZpdz4NttNXR7u8tDpMfj15I7dLiN82wiKxu28ndBu2BmOQV3c5r6TooA4P4MiFfhTo628kkkAe5EbyIEZl+0SYJUEgHHbJx6mtbRJdSl8Xas2qWlpbTfYLMKlrdNOpXzLnks0aEHOeMfjXTVjW3/I66p/2DrP/wBGXNAGzRRRQAV558VfGi+GNBaOJz9ouVeNdpGVOOpr0OvmD45F5fEYi3ADziBn/dFAHJ+EfDGo+P8AxEzySbiGV5nZCQwzjtXues/CXw9ZeFnVLOBbiJGYy884BPrVj4NaDZ6P4Vt78SRefdQjzCH9CapfFn4iWelWL6ZbSF7gnaxTDDBU0AcP+zzeTnxfeWZc+QlqzBfQ7hX0rXyV8GPEVr4e8ZS3F3u2TwmIbcdSwr60Vg6hgeCM0ALRRRQAUUUUARzwR3MEkEqho5FKsp7g1zdv8PvDFtcy3EekwiSQYY8811FFAHEa38LfDOrQvjTIEmIOJDng44715qo134S6rHHLcPc6U7LGqxR4UMx9TXtHiTxHa+GNOF7dxTSRltuIlyema8Q8afES1+IJg0bSUmjUTxykzKB0PP8AOgD3+xvI761SeIgqw7HNWay/D2m/2TpEVrkHHPHvWpQAUUUUAFFFFABRRVe9uUtLOWeRgqohbJPoM0AeJ/H7XsaemkJKNwlSQrke9dX8Dc/8K4hz/wA/En868G8W6ifHfxB8+3zscRp8w7A47V9S+EfD8PhnQItOgACgl+Dnk0AbtfOXxx8Vz3+qQaLZzEW7xETIMEFg1e/6xqMelabLdy52JjOPevlXw/ZyeNPigY5fmiaaXkjAAyT2oA+iPhxoEeg+F4FQLm4jSRsDvtFdhUFlALWxgtx0jjCD8Bip6ACiiigAooooA4v4leLG8K+GZLu3mCXIkRQARuwT6GvmvxN4+8R+L8wPNPLbkAGMIOSD7Cu6+P14W8TRWHlyYaKNt+Pl6njNeheBfhnoVlo0U1xZh7lvm3Bz0IFAHgOg/DXXNdiMqwywDdj95C3NeteBPglcaJq9vqOo3tvcRodxiCMD0r2uC3itoxHEu1R2qWgBscaRRrGgwijAHoKdRRQAUUUUAFFFFABXMfEJGk8EagqKWYquAB7iunqG6to7u3aGVdyN1FAHm/wd1W3vNK1CBRskiuAhViMk4ru9cXTZNLuI9T8o2zIQ6yNgEV84vq958MPH9xJLu+w3F1JLsRckrkjvWpbal4o+K2pywpKsWkiQrtli2ko3uKAPQ/CPiHSodbuNL0fSpkgEip5sfzJj1z6V6VXO+E/Cdl4Y0uK3t4wJQirIwJO4j610VABRRRQAUUUUAFFFFAHknx1kQaAil1BMUmBn6V81aO9wmsWjWhIuBIPLIGTmvZv2hLyZbvTYQ3yMJMjHuK8s8DKT430fAJ/0laAPsDwY93J4Q0179ma6MI8wsMEn6Vu1Xsv+POP6VYoAKKKKACiiigAooqG6uYrO2knmYKiDcSTjigB000cETSSuqqoySxwK4HxR8ULPRV2WlncXz5IJtiGA461xXi/x/feLNb/4Rnw67RgymCeR0DKQfQiu78G/Du00XSkW/RJrtowsrqxwTQB5Tqnxb8YXs5/sm0v4UJ4UwBv6VlHXvihrk5jkGoRpjPzWhA/lX0nbeHtMs33wW4VvXJrTAAoA+cdM+D/iLxKyXeralGozgpLCwPFe6eFfDsHhjR10+3ChAxY7RwSa26KACiiigAoopCcDNAHE/ErxO3h3R4UiLCW8ZoVK44OKj+GmhR2uhw6tOim/uo8TS4wWweK43x7fJ4k8eaZooBZLK+QyD2OPSvZrO0isbVLeFdsaDCj0oAnooooAKKKKACsbwh/yJWg/9g63/wDRa1s1jeEP+RK0H/sHW/8A6LWgDZooryfXvi9rPhi6s7HV/BWzUr6Lfa2dtqqTyM/m7AjhUyuRkggNk4Uc7toB6xWNbf8AI66p/wBg6z/9GXNVPB3iibxRb6s1xYR2U+m6nNp0iR3BmV2jC5YMUU4Jb07U3RNX03WfF2rXGl6jaX0K2FmjSWsyyqG8y5OCVJGcEce9AHTUUUUAFfMHx3hdNeEhU7WmbB/4CK+n65Dxx4C0/wAZ2ccd0JA8JZkKNt5I70AfKGneMtX0uwaztpUELIUwVycVhyzPNIXkYsT6mvZdQ+AmqQyyvbhDboMjdMM4/KvKda0t9J1eSxb7yY7560AbHw/8L3HirxJHa2xUNCBM25scAivs62hEFukY7ACvFfgP4NbT7f8A4SGUYeeN4sbsjG70/Cvb6ACiiigAooooAKKKKAKep6XbataNbXaFoznIBxXkniD4TW2gqdU8Nx7LhCCfOkLDaOTx+Fez02RA8bKRkEEUAcN8OPHH/CUab5d0cXqM4KhNowpxXd14Qn2bwd8bRDvdLaSxLY68sa91RgyKw6EA0AOooooAKKKKACvEvjj40l0+0XSbNtswkHmZXjaV9a9trzbx78LrbxfePdkyecSOkmBwMUAfN3gvWbLRNeW8vw5iA/gGTnINfSVl8bfCF5IsMcl2Hx/FDgVwln+z85uT9rJEOONs3Ofyp998AGR82LvjH8U+P6UAdD8TviJpM3gq6t7GV2uZCm3KcdawPgBpcNylzqr485LhgPm9V9K8q8d+FLvwhrMWn3LkmSISD95u74r234N+BrnSLZdSuCylm3KokyCCvcUAezUUDpRQAUUUUAFFFFAHm/xb8JHXtC+0WyA3UckZyT/CDk1peBvGuma5pywwyMssJ8pg67eVGDXaSIsiFWGQRXgvjL4OalHeveeGncbvmYPcbeSeaAPewysMgg/Q0tfNOmfEjxV4PultNVhgMCZDNgseOPWvZfBPj/TvGFs7W8hMqMFZdhXnGe9AHY0UUUAFFFFABRRRQAVma9rVtoGkzahdMRFEAW2jJ646VouwRSx6V89a/r2ofEXxh/wjkW37Fl43KZU/KT3/AAoA5zxNB4g+KE13q8Kw/Y9Odo4wy7GKk5H1r1T4O63ZPpk2lcrdWpSKQFcZYDt613mgeHrTRdHjsoU+XYofPOSBivDdetpfCvxbsbq3JVLq7aRhng/hQB9GUVW0+4N1p8E5xmRA3FWaACiiigAooooAKKKKAPm79ob/AJCel/ST+YrmPg/p8F74sgeYEtFMhXB+tdJ+0JKj6rpqqclRJn8xWH8FpFTxSgY9ZUx+tAH1eihFCjoKWgHIooAKKKKACiiigArzL4z3Wpw+GJIrEAwywuJvlyccdK9NJA6mo5oY7iJkkUMrDByM0AfH3gPxRL4Tu57hreYyOVI/cluRXrNj8erJAv8AaUVwnqVtiK9WHh7TIyz/AGdOevyivEfjVqumoLbSdMRDdrKUlHl9ARxzQB7Z4b8R2PifSIdRsGcwyjK71weuOlbFecfBzRZNM8GWcs24SSRnK7sgfMa9HoAKKKKACiiigArO16+/s3Qr687wws44z0FaNYXjGym1DwlqlrAMySWzqozjkigDzD4W2cHiPxbrGv3KszyeXIh6DOfT8K9srxL4Q65b6NcT+Hr8+XdwqkeAuQWye/412/jfxpHoSxWcDBrueQRKpUkZI4oA7Ga4igTe7gL65pkN7BcHEcin8RXIx+FJfEfgu30/XpJY51cuxt5Spzk45rzHV9ET4aa1HdWt3cvuKptllLj5j6UAfQlFQ2kvnW0b+qg/pU1ABWN4Q/5ErQf+wdb/APota2axvCH/ACJWg/8AYOt//Ra0AbNeT/8ACotYaDV2l8WwS6nqsscs+rNpji7Ty3R0WNhOFRQyLwF7Afwrj1iigDn/AAp4evNAi1Vr/Vf7SutR1CS+eUQmMJuVFEagu52qEAHPAwO1T23/ACOuqf8AYOs//RlzWzWNbf8AI66p/wBg6z/9GXNAGzRRRQAUUUjHapPpQByHxG8VWnhbw3JJcyBGuVeGLg8ttPpXydpFje+J/EUKIpkdpE3/ADdFyB3rvPjj4judQ8SS6TIuILWUMnzE9V9K3PgR4Sma6k1meE/Z5YsRsQCMhu1AHuXhrRo9B0SGwjJKoSct15Oa16KKACiiigAooooAKKKKACiiqd/qlnpsDS3c6RKB1agDw/4mlpvipbQxKN/2RDkdcZNe8W/FtFn+4P5V4bYXP/Ca/F9dWso1mskszFvU5GQfevdUGEUegoAWiiigAooooAKKKKACmucIx9qdTZP9W30NAHyL4tmvPGfj/wAl0HmIGRQp7Kx9a+rdFs1sdItYV/hiQH8AK+XtD5+K5+sv8zX1Zb/8e0X+4P5UASUUUUAFFFFABRRRQAUhAPUVieLNS1DSdDe60yyF5cqwAiLYyO5ryNvi14waUxx+GIyR/wBNjQB7Jqugafq9o9vcW8eH6sEGRXheu2tr8K/HmmXFhNI1vcF5ZUlPA7dB9ayrj4heNLwy+XYSxncc7ZzxWBY+HvFPizxFA+oRXMke8gs77tgPPc0AfWOl3o1HSrW9GMTxLIMe4zVuqGh2psdCsbVs5hhVDn2FX6ACiiigAooooA5D4m302m+Bry5gJEisgBBx1Ncl8EtGMGkXl9cxgzyXTMGOCQCPWvR/EWiReIdGl06d2RJCCSoBPBzXjtr4A8X6DJPFps988DSFhiYKPbvQB7hcXcNpA80z7Y0GWPpXg3jzWrXxn460TTtNZX8iZ0d1GCCf/wBVWovhp4s1W426lrOqwQufmAnyAPpmvRfCXw+07wwm8Obq4bBMsyDcCPQ0AdFotqbHRbO1YkmKIKSevFX6AMdKKACiiigAooooAKKKKAPj74sWt7B41vpLot5Ulw5hy2eM9vSpPhIbceLbbzpWRvOTaB35r1j4xfDzU/E0lrc6RatNLGH3KuBknHrXOfDL4Ra1Za0L/XIJrI28ivEoKnf65waAPoaPGwYORTqbGmxAuc4p1ABRRRQAUUUUAeSfGjULvS47W7tp5YxHExIRyoPI64qzo3xl8Jw+H7NbrVQLtIFDqUYndjmvRNU0m01e0e3u4Y5FYYyyg4/OuPuvhLoNyCNoTP8AdjX/AAoA828ZfGmfVUfS9BSKRbjdF5oLKwz0IqX4a/C271C7i1zX2mJUrNEDIH3kHvmvV9E+H2h6Ko2WsMzDGGkiXPH4V1EcUcSBI0VFHQKMAUALHGkSBEUKo6ADAp1FFABRRRQAUUUUAFIQCCCMg0tFAHj3xS8GamZotb8PwBp0lMs4DBBtA/WvHtP8Wa7F4rmvJbaO4ucqTFKxZVIPGM19gOiupV1DKeCCKojQtJDlxplpvPVvJXP8qAPJLP4l+O9SXy7Xw7YEkYH70irOh/D7Wdc1sax4pV4ZNu3yUlDpweDg161HY2kX+rtok/3UAqwAB0oAaiCNFUdAMU6iigArG8If8iVoP/YOt/8A0WtbNY3hD/kStB/7B1v/AOi1oA2aKK+RPF8HhuPXLGXw7exz+GXtwL6LR4Jo54rYXXPneaW3OWKBWcgEqnyqNmQD67rGtv8AkddU/wCwdZ/+jLmuQ+Dv2P8As7xZ/Z3kfYf+ElvPs/2fHl+XiPbsxxtxjGOMVo2+tQaB4v1JPFPiLRYriWwtDCxAs1ZRJcZAWSVyxBPUHuOPUA7eiuf/AOE78H/9DXof/gxh/wDiqP8AhO/B/wD0Neh/+DGH/wCKoA6CjrXP/wDCd+D/APoa9D/8GMP/AMVR/wAJ34P/AOhr0P8A8GMP/wAVQBau/DGhX87T3ekWc8rcs8kIYn8au2Wn2enQLBZW0VvEvRI1CgfhWR/wnfg//oa9D/8ABjD/APFUf8J34P8A+hr0P/wYw/8AxVAHQUVz/wDwnfg//oa9D/8ABjD/APFUf8J34P8A+hr0P/wYw/8AxVAHQUVz/wDwnfg//oa9D/8ABjD/APFUf8J34P8A+hr0P/wYw/8AxVAHQUVz/wDwnfg//oa9D/8ABjD/APFUf8J34P8A+hr0P/wYw/8AxVAHQUVz/wDwnfg//oa9D/8ABjD/APFUf8J34P8A+hr0P/wYw/8AxVAHQVyHibwRL4juxKdXnt4vlzCqgqcVf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgCfQvDOm+H7cR2dtEjDOXVACc1s1z//AAnfg/8A6GvQ/wDwYw//ABVH/Cd+D/8Aoa9D/wDBjD/8VQB0FFc//wAJ34P/AOhr0P8A8GMP/wAVR/wnfg//AKGvQ/8AwYw//FUAdBRXP/8ACd+D/wDoa9D/APBjD/8AFUf8J34P/wChr0P/AMGMP/xVAHQUVz//AAnfg/8A6GvQ/wDwYw//ABVH/Cd+D/8Aoa9D/wDBjD/8VQB0FIwypHqKwP8AhO/B/wD0Neh/+DGH/wCKo/4Tvwf/ANDXof8A4MYf/iqAOSg+D1pB4rGupqcgYBh5QjGOT616XGnlxqmc7QBWD/wnfg//AKGvQ/8AwYw//FUf8J34P/6GvQ//AAYw/wDxVAHQUVz/APwnfg//AKGvQ/8AwYw//FUf8J34P/6GvQ//AAYw/wDxVAHQUVz/APwnfg//AKGvQ/8AwYw//FUf8J34P/6GvQ//AAYw/wDxVAHQUVz/APwnfg//AKGvQ/8AwYw//FUf8J34P/6GvQ//AAYw/wDxVAG88aSLtdQy+hqkNF0xW3Cwtw3r5YrO/wCE78H/APQ16H/4MYf/AIqj/hO/B/8A0Neh/wDgxh/+KoAvL4f0dc7dNtRk5OIhU8Gl2FscwWkMZ9VQCsr/AITvwf8A9DXof/gxh/8AiqP+E78H/wDQ16H/AODGH/4qgDoAMDAorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Ciuf/4Tvwf/ANDXof8A4MYf/iqP+E78H/8AQ16H/wCDGH/4qgDoKK5//hO/B/8A0Neh/wDgxh/+Ko/4Tvwf/wBDXof/AIMYf/iqAOgorn/+E78H/wDQ16H/AODGH/4qj/hO/B//AENeh/8Agxh/+KoA6Csbwh/yJWg/9g63/wDRa1B/wnfg/wD6GvQ//BjD/wDFVN4OIbwRoDKQQdNtyCO/7taANqiiigArn9QutHtvGWmS3mt2NtfLaTW0NjNMiyTedJFtZQWBPMJUAA5J9uegr5/+I3hvUbzxR4yto/CV9qF3rf8AZ39k6hDaLJHBsCrLulJ/dZ2kHpwMnC4NAH0BRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAc34l1LQdR03V/DVx4h02zvLiymikSS4TzIVaIkuULA4Cnd24Gcgc1qaZruj635v9k6rY3/AJOPM+yXCS7M5xnaTjOD19DXifjZfEZ13xLP4W0zxBJPrDzWepWlxpGLeS3itvKWSObOSSfMZNpy5IBXgCTsPhjbFfEXiG8i0DUtHtJrLS444b1JAN0cDIyIXRSQnyoSc5I3ZwwAAPTKKKKACiiigAooooAKKKKACiiigAooooAKKKKACstvEugql67a3poSwcJeMbpMW7FioEnPyEsCMHHIxWpXg/iKzaLVviNHF4X1W8tdSu9MeC2g024RL3yZA1wBIqYXJ3/P3zkZzQB6Zo/iDwro2kkN4r0aSCe9u5UmN5EqlpJmmZAdxBKiVQfqDgZrqIJ4bq3iuLeWOaCVA8ckbBldSMggjggjnNfPk2nvH4qttYuvBeuajo3/AAkGrXMlo+mNM8iSwwBJDG6LhWfLAMBjbjJKk1638MtN1LSfhvodlqzSG8S3yyyFt0asxZEO4AgqpVcdtuBwKAOsooooAKKKKACiiigAooooAKKKKACiiigAooooApyatpsOqQ6XLqFomoTJvitGmUSuvPKpnJHytyB2PpWHp+s+G7nxDqerWfibSrndp8KzRQ3UbeTHC8rNIxDHC/vgCSABjrzxz/jJBbfFfwZq66XfTR2cV2L26tNOmn2o8ZWJS0aHPzF/l5xuJwAcnzQ6D4vHgrVPCWnjWdR0VdHW6ggutEayaK4+1xyPECwJdwu84DMDkhc4FAH0PpurabrNu1xpeoWl9ArlGktZllUNgHBKkjOCDj3FXK8z+GFgy+J/F+sW/hy70HSb57RLO1urRbZsxxsJMRjoNzZz0OT3Bx6ZQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVT1LVtN0a3W41TULSxgZwiyXUyxKWwTgFiBnAJx7Grlcn8Q9Sm0nw0t5Z+GpNf1CO4Q2VutqZxDMAxWZgASoXB5HOSBkZyAA13xB4V1HTrWGXxXo1sj3FveRSNeRESLDcK/wAvzDILRMmR0OeuMVsQ+JdBudUOlwa3psuoB2Q2iXSNKGXO4bAc5GDkY4wa+dJvCLaVpWv2sWga5qt9qmlRE3dtpdxaxx3X2oO8McZhAEeBG2SBxEQNu/C9Hpmi6lJ48e3g8O6lZ6gPGU+pHWnsmjiawAbdF54GSHwQF+624c80Ae+UUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRVe+v7PTLOS8v7uC0tY8b5p5BGi5IAyx4GSQPxoAsUVn6Zruj635v9k6rY3/k48z7JcJLsznGdpOM4PX0NaFABRRRQAUVXur+zsfI+2XcFv58qwQ+dIE8yRvuouerHBwByasUAFFZ+t63p3hzR59W1a4+z2MG3zJdjPt3MFHCgk8kDgVoUAFFZ+la3p2t/bf7OuPO+w3cllcfIy7JkxuXkDOMjkZHvVia/s7e8trOa7gjurrd9nheQB5doy21Ty2BycdKALFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRXN+PvEs3hDwRqeu29vHcT2yII45CQu53VATjkgFs44zjGRnNAHSUVxfgnxLr2p634h0HxHb6amoaO9uTNpxfypFmQuBh+cjHJ756cZOjD4vjvb2a107RNaunhjSSQtai12hywX5bho2P3G5AI980AdHRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzRWN/beof9Cvq//f20/wDj9H9t6h/0K+r/APf20/8Aj9AGzRWN/beof9Cvq/8A39tP/j9H9t6h/wBCvq//AH9tP/j9AGzXk/xmh2aj4P1LUrae48M2WoF9UCnMaZKCNpEw25R84+6cglcguK7/APtvUP8AoV9X/wC/tp/8fo/tvUP+hX1f/v7af/H6APIPFvivwTJ4es5PBeo/2Pa/23aRatdaPbSWUiwMk3UhAWwFcgYbkdKxNCutV8UatomjWXjTxAun3Wu6nEl8LyTz5baKGB0BJI5K5xkYUuTt6g+9f23qH/Qr6v8A9/bT/wCP0f23qH/Qr6v/AN/bT/4/QB4De6JeWHw/8U6vB4p8Ribwxrb6fpsX9oHy440aOIHAHDbJXGVKjBxjGQdfXfHM+saP8T9W0DXr5rGH+yvsEscssXk5YLJsBwUyQwOAM+9ez/23qH/Qr6v/AN/bT/4/WP4ptpPF3hy70O/8N69Ha3Wze8E1mHG11cYJlI6qO1AHhtzf2d7f3V5H4j8Qaz4b0nXdKkF7d3dwzQwOkvnOQNpUhwFDBQw4CnLc2PE+tbvFniW20f4g3dlYWqWz2Era/dSREFU83bsSVpTuboGUryeQp2/QX9t6h/0K+r/9/bT/AOP0f23qH/Qr6v8A9/bT/wCP0AfNPjvWr+507XrXxN4k1VPEq6r5J0aDzBYNbKFKuEYABcjKtkk4UlfmLj1v416tqWl2/hoR6hd6Zos+pqmpX9lM0c8S44C7Tkgr5rY2tyi/Q93/AG3qH/Qr6v8A9/bT/wCP0f23qH/Qr6v/AN/bT/4/QB86r4vsdB8C3sNrf+ILhL3xReTW97Z6h9lnmiSKIbpZCjElvMQkbRk8kjGDJoeuWt9r3hS+8Ra/fSafDqup2Ud7LqM4ZYfKiMX70bGGXl5chCVIDYVQq/Q39t6h/wBCvq//AH9tP/j9H9t6h/0K+r/9/bT/AOP0AeA2fj+8u/idZixv/EdjJL4gjglsNS1IyIYZJGV0+z+UFj25AwXJXIxkjcv0vWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/R/beof9Cvq/8A39tP/j9AGzRWN/beof8AQr6v/wB/bT/4/R/beof9Cvq//f20/wDj9AGzRWN/beof9Cvq/wD39tP/AI/V/TL+PVNKs9RhR0iuoEnRZAAwVlDAHBIzz2JoAtVl+I9AsfFPh+80XUlkNpdIFfy22spBDKwPqGAPORxyCOK1KKAOb8KeC7Hwm+oTwXupaheag6Nc3mo3HnSuEXai5wBgAnHGeeuAALdt/wAjrqn/AGDrP/0Zc1s1jW3/ACOuqf8AYOs//RlzQBs0UUUAFFFFABRTXkSNSzsFUdycVUXV9Ndtq6has3oJVz/OgC7RSKwYZUgj1FLQAUUUUAMkJA4NRBnOfm/+tUkjYYDHJqLawJ54PWgBRKVyCc+9BZyAd+AaYAgYgjNOKZwMjb6UASqGA5fNMy5XG7n1oZlTjaT9KSPliegx0oACzbuHyKUysHHUjFNUDHTAp6Y70AIZCGA55ocswyrdOtNPMbE9jxTYw2xgOM0AWckR56nFUprxs+WoIPTPpVmUslqxU/MF4rNCyTRs2dr4+bI+9QBNLPKkcIWQsScMwp4ndpSgfpyTUMVtJ5KFpAoPY1J5aRE7VyTxkUASSzSJ86Zcei1H9pmMOcMGz93vSRRzodqSAKOelSBWccHEn972oAhMlw8RZJTnPTFP82aF13ylsjpUMRkto2kZ8gN93vU8pUbXdd5xxigBIJ5WWXzGK5Pyk9hTJbySLqxPofWomnU5VlLA9hUktqZo0fICIPumgCxYTSTF2dsjsPSquoXVz5jRQB029XA4qfTQAZAOnasvU7i8t9QcJJ+6kO3aBQBPaahcIpjmZn44l7E1ZszNsIe8Er4PA6is+GKaYtb7tqKMqCKfYWz2V05kO59vMgHBHpQBYF3LDN9lluMvjd5h4/Cls7ua4YszlVBIwe9VrmewkTzngLPnbnNQzSNa6a/lsGmLZVh2FAGjJc3EV5HHlnVhnI7VTOqXJaUqHIRsYFSWUd20iTXFyjAD7uMVStnZbi5EkqxoZD9/jIoA0LXVnMcjyKxC9jVlbppfKdZNok6LVcmxWAkNG6kfOFbOaqm4iRk2QPtz+7bHC0AXt9wuoMHugsZI2oe9Xb66S0hDO4XccDJxk1mTRfaTaPje6yBiwo8TWn2uCzXcBsuFbmgCvHqF9c3D2qiWMou/zSOG9qkXVJ5LHcWaKUPja3XFOZp7fWZjnNuIhhQO9Yi6/Zz3BVrOYt0344oA2riS6vYc22oC3Hd8AjNZw165S7VZZGWNMqxbADe9TNJa2jC2aE/ZnG846Z+tRXTabNHiS0Zkx97sKAN611IXls7xqQV469a56+8R3TTSiGKaJbYkOT0audl8eQaTfJHBZXDWqEiRUAOcelaWi+IdO1yS4h8ph9pboxHyZ9aAOjh1WZ7CKYbnZ1zx2qN7q7bypRe7CDloSOT7Vm+VeQzlLa6SK3tzyCPvD0FV4LK7u9YF2byNYd4YKR94egoA2xrNzJPKptpoURcqzdHPoK0tPu5bvSvtEkTwuQ3yv1GKzteu/IgtdkEj5mAIUZxW1A6zWuShUMCCGoA8/wBK8Q6xqMrWkcsrMGLeeACMA9K62DUZZdSSFN0kXlktIvKhvT61ky2seiBjpduVU9RGM9etQaZqcek6dJeMrfZhIdyjruJoAjj8QX9/4g+yLK9rCpZSz4wcVnprfiPS7+eS4FzfWySHaETAK9scVsl9JlsZr1vLY7s7d4zzTLvXI4Zba0hPmiZePLIO32NAFqDU7jULi0kt74IrcywcErnsfQ0eIo9YkgVtM1XyWjyZAFBrCsnt7CHVbmGBo7xm3Ix9fpVSDWtQtlaGZ2mn1L5EZF/1Z9WoA6HR7zVptPeKe6eScJxLt6n1qfR9dmWeTS76RmuoEy8rYG7PtWXp+qH7LcaXFKIdSso/3kr4xIe2BVXTLVpyb6/u4Wvpl2uScE+gxQB0STahFqctxJf+ZZsmEjwMbvrUek32qXfihzM8kdn5PELr/F65rJu57jyv7OVXhMR8wTOvyH2FXfCranc6q11dXSzQeWVAVe/1oAl8VareC/TSNOuzbXckYkVxg4APPFczLr/iXQL6KC5kuNTiddzTRoAqex4q/wDEKddO1GLULO2kk1NYwiNGNzbCeRisK88bG70KW1tdNvLe8fH7x04B70Ad9JqlxNbwvbyneyAlByc1yWpar4k+3LbWeoSN5jEMyICIP97itzQ0jtbGGZ5UNwyhi+ehxzmgabJoy32pyTLJBMfOkVRyRQBzUOra/BFfR3XiJRLGuELKBk+1bPgzUdWkWd77WBfmVRsRQAYT6msnWTod7d6Xc/Y9qSvulyfvis4pe2niOd9Bjexs2cAlkyrr7GgDpNR8V3+h6zLbSmW8V8LGEwME0msa7rNxo0NvbSzaffeaC8jqPu/Ss+Xwjrep6t/ah1i3igLBkVl5BFV9el1GTU5bdbxLyVEDM0IzkY6cUAbmgeJLq31b+xL6/wDtsgjMv2wEBf8Ad+orema81O0Y6fq6RndjeoDYx1Fct4N03TJtG+33Vr5UpZ0JlODWj4b8m20qU2qFYvPbpyOtAHQeJ9Qu9I8L3F5bRSXFzEq4WMfMxyK5C+8dvodjDPcXH2p5IxIyKwBj/wBk+9d5qe5tJfa4QlR8x7V5Z4g0nR9Vk+xw2f2W7kBG6U48w55YDuKAOX8T/EjxbHcW8kH2zT7afLI7oNpXsQcV0tr8StRt9JsbcpPqF5eJsE0WP3bepFc742a4sX0PT9UzqVusZRIIF52jtXR6bpdqLCy1DT7NtOW2USPHMCGYegoA2rSTxDd2u8eIgtwVy1uUG6M+hqhC/iiPVF+0eK1CxMGkgKAEj06d6swzQPLNqtlEVuMb7g9S4HaqWi6dJrXiK+1y/dYbKWMGNJvlOR15oA1/E/j27gt4U0uxuZZfNXeYsH5e9Qa3421NbKOXT7W5acuoMKAFgO5+lTaaILjX71bGWP7PHb7htOQT3rH03VTd6K2tWMb/AGvzWiaMDL7QeePSgCfX73xTLrkEtlrElnpxgG8lAVD+5x1qo3jLWvCWs2+n6hey62LhDKJIgAEHoa30vrHWPBs0sqi3t/N2skzAfMD1rkdO0l9XSW4jkWOeJykbv2WgD1Xwu91NZzXFzqAu/OfeigD90CPuH6VJ4Q/5ErQf+wdb/wDota5b4URX0Onaql9OJmF2QhAxgYrqfCH/ACJWg/8AYOt//Ra0AbNY/wDwlnhv+zv7R/4SDSvsPm+R9p+2x+X5mN2zdnG7HOOuK2K8D0uH+zgsLeFdZe0j8cPqcVvHpV1Esdp5ZWOYbY+AjFW8vqduMYNAHuljf2ep2cd5YXcF3ayZ2TQSCRGwSDhhwcEEfhWdbf8AI66p/wBg6z/9GXNYnwnsptO+Gul2s9jd2Do9wRbXYIljUzyFQ2VXJ2kc7RnrgZq9ollcWPi7Vo7jU7vUXNhZsJbpYlZR5lz8o8tEGO/Izz1oA6aiiigAqG6uI7S1lnkYBI1LE57Cpq8a+NnjY6Zpy6XaPiWYvHLle2OxoA5T4lfF2+uLyfStIk2xBijFowdykdjXlVtHq9kyajHFMvOQxjOOK7X4S+Ax4r1Z7i8UmC32SA78Z5/+tX0J4l0fTLTwpNbmPbFHG5T1ztNAHM/B/wAb3HiXTFtb2QPdIGZsKAMZ4r1KvmT9nkn/AITu+GePsjcf8CFfTdABRRRQBHJ99cdajwRuLEH6U+XbkFs5qIOM+1AEU8yQW8s+1iI1LEAZJxXlureOfEN5qFzFosUkUcfK+bbk9q9XGPm9GojiVSTtXn2oA8VsPilr2kThPEEE03ZmgtiB/nFem+HfGGm+JYBLZs6Zz8suAePata/022voHhmjBBBBrxjxb4XufBN7FrOisq2zypEVkfceTzxQB7k/zpxTc5XaaztG1OPVtLjnXPPHIx0rSSTeu09aAEY8gD7vek3/ACkr1FIqg5ApQCqkDGaAJh80XPcVVlKKQMEntirLf6g7vTnFVwyLGSPTigCqzq7mO4BIH3cetCGYSGKNlCL61M4iaJPMzufgYqCS3khAEZHHqaAMrxV4oh8J6R9uug7RlwgEYycmofBviV/EfhxdWKsA0rJgrg8H0rzT4u+IZWmGmgg4dGwFrtvhj9t/4RJIGEYPmsenagDsp4jJIJVPyAcj3rkPHHii48N6a80EqCQLkAgE9fSuxTfCdqY29Tn1r50+IFzda142t7EkGPa6kDjoTQB6h8PtW1fU7K6u9XmjlYyBofLXGFI7133mCe0fZnG35h61znhzR7Ww02zitVcM8Sl9xzziui2/ZlJj6/xZoAXTGBDqARt9azdSt7yTUdySRiMMCAeorWshIWkkfGH5GKpXyuLlynQn5/pQBWmluPNKREeYOWbHBFWba4FyGtpOZFXcSOlVvtoCfZ7UHPTLimW9tcaaTLclSh4+Tk0ASQ2dsLItMMruPeud1vxLpnhyMxXSyTOfmHk/NgGqfjHxDBaRG0ti4zg/MK8rlj1We+FnYqDNIN4aUHbj60AdhqnxBuWmSG3fy5HXMZZBgD3rMPiLWfEMUltLKrSg7EITA/StTSfh4NVjWTXFP2heFMMmBiuy8OeBrDSGe5dWLxtmM788Y70AVPBOkNY28iakpdptpBTOB9a6Zr1YGmtpEYw/diCjoPeizmuJZ544wnkq2GyOcVbu1jhjhJBJPTHNADtPDJHH5RCqeoPXFW9SiikgDS42xnf1x0qrbWyF1mOdzHnmqni8K1hbq+7Y0wDbfSgBovH1XTxeac4j3Eg+YOoHWuchuVe8xHFIlt33Lj5vrVmS5itpF02xVxAmH+YH8eauapdxPoPlQDD+YDkj3oAu6rFZzWX2IcbwGyW4rBub9E0K5sirMxOBtGRioNRSCXTjcozmFcK3POacSNI0iR5QWkOGTaNwx70AZfh+2iJma8iaaLfysYyQK5fVdG1rQ76+vdAZIra5kMjq6liB2+ldL4C1ie01uWwlC/6bOXTjoMfpW1qWrNpGsSW160TQXkh4QZIFAGNod/qd9YW4vZFYIo85VXBb6V0lyIjBYfZ4ZRhx5eQflPvXPaPqunS+JZ0gEoWOUfeXFeiRyMnmTPt8px+6wOfxoAp3h1B7BFhmiF4h3OSOMfStDSprmXRhJdOjzYbJQcVi3CPHILqAfv7giOXd02+1dBYWsen6cIYgdiAkZOaAOBsNZ1y4tWWzAiYSHJli/hzzTtQlh1LSZLCxjdIncNJvHVs881qal4gePwy2owKN3neXgp746VTtGlTQHSQL9qeTeMDjBoApXPgkGWCOykjjkZMne55NJe6XbeG4VFsVGoOMrIWyobvmrOrR3+navZ63OVMFvDtYJyefapbrRLG6spNVvzI0G3zGCMc4PPSgDntS1SW905r62cK9iuboMOZD/sisnQtavNYkllsXEE8OCPPXGT7etamsv4c0aOCXFzslXcgGTx71zNrdW2va5bvpxKQ2soaYSfKSPb1oA72Dw79ojGp6jJG2ozDJdWwu4dOKujSNJghtrvUYmuL4uMtCxIDdjgdqi1bTGmtdPkt2xA8n73Lc7fb3rQ0Ow0u11C7WwE3m+Xg+aSQPzoAjvxea3qM2nuypbLGHUsMfN9aueEIbjSR/ZF0yvKu6QMg+XBPrVm406e80lUuWTfG3mAo2OR0qHwlqLalH512B9tBZTsGF2g8UAXNSsg+sx3cbIsyxbQWPauTu9St9Hka31lHubqVi8TW65UL6H3o8ca1Fpniy2S5EpgNvk+WpPJJq3qUNloXhufVpwxkUB053HB9qAKekQQW+l30+qRSSJJJviVAchOw+tQ+KPFkdlYW1k9tcGzuYypUR8hfTPaqVn4uuNdKNpyqPL+U+amBmtvUNYsNR0WfzwTJax7ZQq9/b1oAwdA1Hw7rc0Fjc2s6eUQtuZDtAz79631ku5r7UtHjkjFvbIFtDjoSPXvXOXen6atjZ6jrAl+xAb4Bb/f2/7QHen6VfnWLnOgZSzsyJF+1AqxH49aAKXiKfxP4f02yTVb+0ms2mCNFCvzkd/wBKk8L3dhaeJrvUbGKW3017bascww4I69ag8XPpF/cpe3S3J1JHD/Lny8gccVmXb63renRX8/kJHK/lkD5Tjp0oA7G61zStT0M3QbFj5mPKLAPuH41JY+KNJT4ez6lp0MyW0dz5ZRx8xbIBNcpP8M9MbRgli8v27duO6c7MVa0bwZrkvht7VjAqefnBbHSgD0Px3qJsfh7dXyqxxEjAKMnkivL/AAfe6p401i21bWMRjTm8uDenl/KR+teya1pz33hh7FSm8xqvzHjjFeerpureIrS4sJfITyG8lNvy5AoA0v8AhG7fVdet7+3nhE1nISCXzyfaqt3DrOqa+9pPfWjWlvLh4wQGKntXB6DDdaL4qk0+WTF01xtgyxK8eprdg0ObV9b1Gbw9Jt1i0kzdm5YiMydtvqKANs39pa3d/pukwSwXMa7ZJJVOx/TaT1qjEbm+tk0zXXWW2i5VI/lYH3rX1m11eHSdEudSa2M9lJ5t95J6qOu2oEtbTWbm68R2jMLK+i2x+YdrcDHTtQBFb+ENS00vd+F7u1t7F0KmOU7mI/iqpYWs+n6MZtCT7LqjSFGe4XK7T14NVLe41jQlQloxphbEWeW3n19q24dWvdT1ZrK/VA3lbh5S4HtzQBiS+D/EFzpMljrF7aXNrJJ5jRwcMT1FdHoVva6WU0m+BkuZfmj8s8BQOh965rR9M8a6N4gN/PJYNbBWUfPng9K17bxN4Zm1hdahF2JLbdFIXQgbu+B6UAdx4Q0+TT4L1XZSsk5ZAp6D0NW/CH/IlaD/ANg63/8ARa1Q8FXv2+1vZxnY05K5GOCKv+EP+RK0H/sHW/8A6LWgDZooooAKxrb/AJHXVP8AsHWf/oy5rZrGtv8AkddU/wCwdZ/+jLmgDZooooAK+XvjjtPibEhITzjnH+6K+oa+a/j3pVzBqUN4yfuppW2nP+yKAO7+F3iDw3pXgq123DLLHBmbKHPBP51w/wAUPi3DrCtp2iyLJbBgd5QqTxzXjMd5dRRlI7iVEIwVVyBioSSTk0Adl8NfFbeE/FAu1Cnz18k7hnqRX2PBMs8KyKeCM18i/CHwvb+KfFzW1yzqkEXnDbjqCPWvryNBHGqDoBigB1FFFAFefPmLimlMkEfjU0oBx61G5AUc0AIVbGQBQNxHzcY6YpykFQGOM9Ka67B8pznrQBg+LtX1PR9HF3p0MUsgb5hJ0C4JrxC78Y33j3UItPvo0ijSRZCIgR0PvX0YRG0QRlVwezDNcf4v8HWupWjG1iWCZfmBhUKTgetAHTaVaQWdjHBb58oDOT1zVxxjrwPavLfhj4muWzoWo4E6l5ASxLYzxXqB+ZgM5GKAHhflwvemEBCGB6daX7rDByKeUBIbPFACyHdbk+oqkkbsjj24q9IxWBioyQOBVKOdpM71C464oAhhtykpaUnj7vPes7xLqw0/T5JJmCgghSO5xWtPOI0QLg7jivGvijfSvfmzaV0Ebg4BPpQBxttHe+JPEuWVWQYOc88GvonSooraxSCLgjnFfOWj6vH4f1Fr6NhJKV27H6V1ifGmR4ADb2yPnGBu6UAeu6zqIsLR7n+JcDHavG/DNrcaj49jKIjo7uzFux5NWtW+Itvrekvpsbx+bIQ2VznjmtP4Q6hbXiXMMm1bjzyFIHOAPWgD1qL9xEizBVZRhcUt1scxFiQp9Kj2FW/ek5B+T3FRNds4eMIMDjPpQBp26gINv3ccVnXWpxQXckUvAHHSrtiHEI3dMcVm3Szw6k8ggR43IBLdhQA9GtbpW8onbjJOMHFFg8SAxQsXiUEgvyc1S1CEO3mWrHLHDAcAClSaC0tli38A/ePU0AeWfE+HVdRnWWCGIW2+Nd2cHOa9M06zEWjxW8sUYyqksAM9B3qj4o0a68Q6M1nDCFG4SB0IByK5bwf4wg0lmtfEVwLeZHZVViWyo4FAHpVzGsemOrjamBkjrVdZ7PyB+8faBzTYddtL3ECurGUZQY6irTJI5VkhTKjhexoApgRLDM9sxMTcyk9R9K0I2K2duyANFjLFuuKqXlusrxI5MTNwVToanZzZxRRRjeOjZ7UAMmv4JLiCKJjw47Yo8T3P2WwjbAJaTaMjPNMkSe4uYG8hVjVwQw6mtW/t/tNq6bQxwcZ9cUAcZNdaqmnRK1vb7TIAWHXFTzLBPdf2Rc5W1KebvX7270zVPS9JvbK4lF4zkbDhWbIzRbtexaYWMKtH5hHmsfm69KALmn6P5sLfZ8tCGI+Y0to1xBBNpjJG1zKxaMNyMD3p8cepafpzLHCGBbdkt61h+Kr6a0lgab9yTHnep5FAHN+LlutFuVm01VL4LSlj91s9qx9C8I3V7rNtr0kszyI/mlWlyuT7Vo22l6jqdtc3N4rKqt+6O7O9fU1peHhb21+lpqNzJbvKwWFQfv0AdDB4fuP7Qju4o02yvul5xge1a8mp232v+zZXIkiIEYA6k+tT6jevpdnAVQGID5WPcVzstleancHUBHtEnzRFT1NAG5BdaidTktriGEJEAwK100UvmWhduBg5xXH6ZDcW7StqpMPycMGySa6fSWhm0hfIlMkTbgGNAHFWl2Z79mtAr6ZgjLDnf34qxBPJbasmiKqlJUM2T1FQaoLHw1ZtbW8xe537xG/oTWfp+sW76umsalILdo0MQA5GKANnxBqF5ZTxWVrFHI8iZAk5HFUdPvrCLfBp80kt5KcvHLnYH7ge1Satq942mTXZtIvJU/LLnnHasj+2by+iW0msYbaKZf8AXx8MB6igDmNbu5rS9u57tU8pXJl77fpWfoun6Nd6rDqOoXFxDA7h4TCcbh7ipPFXg27n1CyaOadrNyTM+7t9O9OtNMj1O+sdN052kWxcLORwVFAHqMUf9pi1SA5srRhJatnBc/7VaN291ab7qWONTKNsm3svtXnkMUtnrl1p0FzMXJCIu7HJror2Pz9Ih0PUbmSK8hORtbLMx6An8aAOj0NLG6svJs7iWS3wcM5Oc96uaNpcWm3RSMnGCeTnrXB+H/CWs2t5J9tea3tthw0cveum8M2K22uu0V7PcR+UR+9bPNAFvxM2ppdI8FrbSWgQbmk+8GriNZ03UtZ1+0ikCiQxHbGH+Qj3rS8fapqieKrfTNKiE072/mCJmwDycmsNtU1S60+W5voFtbyFtiLGx5H1oA6Sz0PS2gksbV3yx2znoVYelRS+FI9IuotRZ3+yW+Xly2cj6d642G7Wa+ifUbuWzA7xE/MPU1191La6heaNBYX8txFjEoJOD9fWgDm7fWNUudT1u70yGGaytzvQS/3fpXRNaTeLvD2lXUCpDdwHzZliOxfp71lzagbfxM2nTQR26CbZEEGPO/3q0bG01gX2uILcQ2zxYiKNjt29KANRfKvYks5EjM9sfMlG3oPrXC+PrmyudsVtJIsAdSNgxzWz4etNL0qORdR1SdLu4QxFWOeT05rZa80rwvocVlKI7i4L7cTJkndQBxtjpUsfg6HUbaWRgbkJln5xmvRdauZpdPXS9HKNqjqkio/C7e5zUGheHZQXvJwUjZGAgBGwH1x6159LcMuh3MD3csevfaj5UYY58vd6/SgD1fxhJZ2/gm5fVppYLdY1814c7gcjpj3ryiHx/ePYzajFHGBYfJbfKR5idiw9a9Y8S3/9meCZLuSGOcxxJlJRlSeOtePrrFtDHN4hu4IYZrQ5itFX91KD/eFAFKW5tNfmF/4ieS1ZjviNrkcHrmtnUNUu9CsdPubJVMSAtaMes2P79LL4isNW8Mags0MEQu487kTmPP8AdrtvDekafa+BopfMNzELUNumAbaMdqAON8Ow6rrcGv6/qQ2zyWxkWJHygIB4x+FYa6l4g1XQdCi1SCC201blWR7dsO3PII9K2jr+s+GtQLR6bBJo2qOIkmZuidyB+NN07wfPfeJb67glmewCBrVd3yFh7dqAL/jm8h1AW3h+xOY4Z45S3Rvzq/Y397b+OX8NWkMTxrZ+eXf73I9aTQfB11P4hutU1JXjvTBgQAgoMdDTdLs9Zhv5NX1+1SxdlMIaN8+w5oAytQjOmaTNp1zLIFebzCwbJznpn0rN1TWIZPCtxp1+iw3DlTF5S43KO5PrWjqOmW/hjN5e3UktwWysU3zKVJ61VurMap4v06W1RZHMBxFj5TQB2/wg1u41nw/dieNEFtMIk2jGVCjk11nhD/kStB/7B1v/AOi1qzo9rHaWSokEcJwNyooHOPaq3hD/AJErQf8AsHW//otaANmvA/EPi3xrperzaRovjOPVDaJHDq+pXOn28Frp0sk6oh3gEZwQrKQ2BvPUER++Vxcfwo8HQ6XNpcWnXaafM++W0XU7oRO3HLJ5mCflXkjsPSgCT4f6jq19F4it9X1D7dJp+tz2cEx8rPkqqFA3lALu+Y54yCSCARgWtE1O31Xxdq01vHdoi2FmhF1aS27Z8y5PCyKpI56gY/KtLQ/D2meHLe5g0uCSJLm4a6mMk8krSSsAGcs7EknaO9RW3/I66p/2DrP/ANGXNAGzRRRQAVm6vodjrVv5N5bxSjBwXQNjPpmtKigDybV/groW25vftTxKql9oiXAwK+cvEFraw+IJbeylEkOVCsBjrX018YvGo8MeH0htwJZrpmhZVfBQFTzXzv4G8PTeKfEscO5j5TJI527sjcOtAH0B8FfClvpXhuHU8ZuZd6MSoBxu9fwr1Sqmm2EOmWSWtuipGvQKMCrdABRRRQBDKMyoO1BIDKuAaJyeABye/pUedpBPJoAe2MjjgfpTcBmOGzRI2VyvfrTVB25oAVTtbaVp0hGCMBiRjFNC7gDuw1G358E4460AeLa5IfDHxVS4jhHlvagbegyT7V7REwMaHsyg5rxXx/BJf/FGCwR23/ZVfI64zXtFmCsMSN1CDr9KAJR8vXpTC+5sZwKeEJzu9eBQCpzhBxQA98fZzubAxyaqbI/JYRvuJHFXJMGA7hxjmsfzGF2ojB2K3agC1bWwRVaViW7qe1YviLwnY6+/mPhXzksqAmtmYiY4Evlkdcd6aiSwksC0ikdPSgDhbP4aafBevKZDMhTADRjFJdfDLSb+wMSbYpd+crGM4rv7eQuSBFgYqnKhtWchyTtNAHzx4y0e18N+L7WztGEsTQbmkK4IPpxXrHgrSIdL04SxRrvkIfdtAIyK8juGl1nx4HumZmVWAibnIBPNfRunQW8WmxLtRAEX+VAE80iSWu7d8wWoo5d8J2RA7RyalNsogfY2/POBUTsgjCRsEOMNigC/ZTeam3GCo6VSvYWlnfbK3y8lRVnTkCq3zbie9Nu8wuWVNxlO3jtQBkNZGRVZJ3355QdqfGtpDdf6TKokx/q2q3NEILWIl9km7k9z7VEiJLfM89uMbeHagC8Zoj8qMA2PuivOvEHgW01uZp7qdrJumUUevWu6lkRVKwASSf3l61DY+TPZOLuVSd55ftQB5XH4V1zw/J9qt5rq7gj6SO2MDpXQaH4wl1K/it1b9/GdhjDHk4rsX1bRWtpIG1C22g4KlxXjPiG/TQfFltfadEPs4ZnkeM4HXqaAPaLazuS5ubguOdwBOcVHdRut7bSJIzq7/MOwFUdM1W+1PSra48qRY3jDHnIINXzeo0HlyoImAwjE9T7UAaaRPLcdSqKcjHek1wA2QBumt+eGU89Kp6Y7yybWuT8uP+BVa10M1rGFh835+R6e9AHJTwS6bp8V/wDbZrkySCPDnjk1rxSwrOLeYqild2w9PrVW7htr6Mac9ysJQiQD0rOuNFmGJoNUe6nyF2jrigDU+36ZZxtE+r+apJbLnp7V5zpN5d+LvHMJvkaK3hLxpHu3LIo6Hmuj8a+GpLTw1I1k7SXO5TlV5681h6Pf2unWDNc7LK+BGxm4YjuaAOvGpxJq0NrBBG4jJQoOhxXnfjWXVNQ8QQXFrYmFbSRsmM4rtYdS0TT9KuJ/7Qt5rmT5xLn5kNcygn8SeI7F7WZlto5P9I2ciQH1oA6iLVXl0XR2mHmTRKC0bHO8+hrUhEs7fbbxmsYPvRoD8v0pljpNsZbqGSRQU4iBHT6VvwWMSWcENy4kHQBx1oAqw6tp8sbCaaMxyDart3Na+j2kNppC29vKZIxnD/WuZvHSDVJrKDSFljjUHKjATPeul0Qj+xkKtuHzcigDi/EuhxCzMb3kjzbwwkYZbHp9K5y4spobqNb+LyI9owDyD6Guk8UXQuoNsrfZZQ4PJ5IFQT65azaf9oktUuZ0IQQk5JHrQA/xK11HoRtRaYtpEUmUHp+Fc9a6fMHgmWV3Kj5Yz0NdTba9PfMmmXujsjzDKK5z8o9qfdWgMTWtmoaV+NyDmI+lAHCap4gglhudOS4DXjZRIs8hvQVz/gfX59J1LWVmtFMqEZLHnNdB400IfaLFdItRLdgEXM8K/NG3qfesObR4rLVNFga+AmvZQl42MEf71AHo9lb3PiSCHUpLEWZhImiljwTOfQ1pyT3caLdjTFuL2c7HRjzGPXNWvNOl6Ra2FnGZ4kGzzkOAB/ernr831jd21wt7JJDLMqZ7UAT3cWqwO0UNzPPe4y9sX+6vrV3wTK0eptazkicIWKnrir8mjN/akmppfsZJoxEUA6D1q7oWnLpd59maPz5dpY3jDkgn7tAHP+LtAnv/ABjb3ryyWlmltta7QjKtk/L+NUdNW3e6N5rLLZwwExqH5WVezH610/jvaPD8rPd+QNyjP41zc/hOez8PSyXWoSXaNhwZF4A9KAKusa7DLp15JcaLbw2sXyx3OPvL2bpTB4xhs30iOx0u3mEqj51OCK5z4gWWtX9paWdjazpug2rbR/8ALf3q3Z25vtDtpL+0OjXOlRBdrjmY460Adlqb2+pxQXtvawyXEPzz4AzEfrXIa3BqdurXsF9ciPUMrhWwEHtWmg1G48PXYsreVGkh+WROs1clFPr+njTotXs7nZHIPLjm6Sn0FAHoei6aln4IsBLCt5cEEGaUAtnnnNYd3BBq7Dw/fTmCa3InW56u57LTl/4SDWL65dobrS7NE3QW/wDCW9B9azJrj+zIoby/41R5AkkEn31XsTQBqvb6zer/AGN9uurW5X95hH5K1ft5Y/D+m7ZtOhu9Z35SGQDeyHvmo4L2TU/E5hslJcW+77Uhycf3a5iXxfcaJ4rSa/09711QoA7YIyaAPXPE8l5/wiU8lnpq31yUUraMeGPHFeLaVpct3qhTXYfsCu5zA3K49K9/88tYJMsWdyBtn1FeZvoFvBqF3qLasL8eaztGQP3Of4KAKnid/wCxLnRXstEguLFFPmtgBSO2a27GIzJBO8zQW98AVth9xR6AelcNF4jgt7280jUdQE8d/IVhkkbi1X0Aq34LvIp9T1ZLzXd1rpjj7MHb5WHtQBd1Lxhp8figeGmtbeU20yxwhurMfbtWzea5HZy3dlaqg1COMmW2U4MQI4NcPq2qaSvjS2v5LOCONrpWF4f4sY5zXe3V/pU91cXWmWsF/Per5U1zEQTGmMbifQUAcdpmszOANU1eawiXn7VvOXP9012Gn+I9A8QJ/Y1rq8d2V/e+YDluKh0nwpoWjaKft+pQaojBgjzKMFj0A96y/DGhWenltSubKPSslk+ZccfX3oA7G80yz1PSGkAS6KsFBZQelcDqvh64h8a6fDBcTQ2zwMWuE4MZ9Ku+LdYvZdEk0jwk73V27rIJLRuQM8iorDV7u6vrbTtQt3ido/nu5DyhA6UAd94G15dbsrtFYObObyC+clsDqa0fCH/IlaD/ANg63/8ARa1meBf7PFnerp6RACfEjR/xNjqa0/CH/IlaD/2Drf8A9FrQBs0UVw//AAt/wIIPOfXfLjMXnIZbSdPMTf5eUyg3/NkfLn7rdlOADuKxrb/kddU/7B1n/wCjLmpdD8Q6Z4jt7mfS55JUtrhrWYSQSRNHKoBZCrqCCNw7VFbf8jrqn/YOs/8A0Zc0AbNFFFABSNnacdaWigD5k+LWg+LNZ8XXYt9NvrqyVwYikRK/dHSu1+C3gG50S3Oq6hA0NxPHsMMiFWXDd69mooAKKKKACiiigCKU4I4/GmfLtycE1JMCVwKhaPhcDmgBd44wmPWlX7zDPHYU0Bjx0pyxsgJznNADWXaM96wdd8UW2iowl/eS9lDAGt/5m+U5z61lX3hnSb6fzryyWaXj5jnt0oA828OWl/4m8ejxDd2k1uggaECVfTpzXryjYoGdzAdaigtY7eAJEm0A9KlIO4FBg0ALuKnk7jShl5wMGhUz82ORSrHht1ACy/8AHu2eOKqRIqoWEe7jqO9W7kZtpBjOR0qtBK7QCJUZGUYyRQBA1uZHEmdmT901YHIMaMAR1xT/ACZGQCRgWHeo44TFMz9SR1oASCQRMUK4OPvUyeBLm3dQyiTB5plwz+bgRsc98UKj2zZZS7EYyBQB84wW4tfGbO9yslwC4BHUDNfRdk0dzp0bBOiAFfXisWLwD4cXUPtz6UjXJz+8ye9bcUTQzLHChSMDpigBSTANyvlR1UVAskUrl9mCDyv96ppYnVHO0knngUi24kCMkZRx1JHegC5ZIV3PjardF9Kqalfi1Z90TN/dPoa04QwjCsckDrWZqCieUq0LMqHJ460AUILma5tfMmheQEEqT2PrU2krNLGzXEm8bTgEVVklvV+W2jkjtuix7ORT7KW5t5yZIpGiIwFC96AMbVNI1u60tpNL1F7OfzOoTJx3rl49K8UXLlzqc0EYyrRMn3j616ndTSQ2XmwRv94DYBzUAfzR55t5AAMFSOSaAPBbLwr4mkuprWaS4WWWQsjtEeldRpvguaWVLbVZ1kDcESLXpFut3OXuGDLMjERkr0FSfZluWzJbt5w6ORQA0xrpllZWVqm5NgTCdMCn3KwC3XzrbLY4J/hNTYaIonlOXHCsBwKjlhur0SR5KY4JZetAElj9njjiMaq7twSvarWsNItqDHndnoO9QaZp/wBiUb8MxGMgVpzqGUZXPPFAHBQ2bXWqSXc/7mRo9vlOPmFOt7e9MhjjWS0I588jg+1a+oaZc3l+Ghby5RgmUrkEelakinAtZY2kAG7cBxQBzeoQXrW5uZbpmRflNvjlveuUfwS2sQyalc3KjyjtEbpziu01Vrm+lEFrBLC+OJGXgYrRtdLa2t/Ln/eq3LADqaAOLtfh/YStE7ywmFR+8jK8NXR6Zo2lWCSLYQQxBOHdP61NdxeXot+be1kWVc7ABkn6VFpenXMFtGZASlwoaZNvJoAi2PZXzT/ZnvEkbIKD7tSf2zJLdur2EyLEcru7VsGCe3jV4DtgjGTEByR6UyW3bUUgmgU24LbpVdeWX0oAwdRvb04u7Ozm3THa7KM5Wuj0QMmhLmFoWAb5D1FYt1dajbaxLbW8Uos0UFAE4z35ro7SSSfTC7qyuVbhhzQB5RPI9/dv9uk3HkDf+lWtN8PG5tmsvtaRXjNvSbHIX0xVOy0DWL3W3guRIEwWEjRkL7V2VvodxpFsbu6b7XdrwrxqchT2xQAafo17DasLuczXynEN4U5jX0qpoccg1KaZrsfupSrp/wA9D61Yk1rVJ42tY7W5SR/uyNHwKz0huJdZtoLezngMmTLMyHaW9aAKd3cQ6Xr0jGRSt3KWbBxt+tZ3/CN2EmpXGq3OoW86s3mRRnrFV3xP4euQcpbyTSnOHRCcGm2elxalp0enx6TcW12E2S3EiEKzetAFIa3c3F8LO1ujHbowDEHI21fuZ2u7mLTogXjtXEhlHKkVPa+C2hkht4Y9kluwNzKVOJ19BUt/Y3Gk6i89naSm1nxH5UaElR3oA0NRuWFnFLb3ixKJB8wPDe1a2iS3V/qf24zsluY9n2dhzkfxZrI1KC0tvDMWdJnmG/5YkUllPrWl4G+0voqPfRSJc72GXXBxnigDnPHF/dr4ytbF7CbUNOe23vboMgtk4P4VY17+1ptFaaOaVEVFAsNvzOP/AK1bniS4bSb9dWFnPdCOPy/LgXLcmuPPijVLjS7q5fR9Q+3q+LdzCflQnp0oAxbDxNeRFl1Uv9rQ4tp5cAwL3Fa1j4lt9at7uCbQZrzZ8rXI5X61asvDsOomOTW9OkuWmG45UjbnsaualA2g2yw6Bps0Fu4PnxohbfjpQAk9lPBBpsya0mm2o58l8AEenNaN2+iapaxpNf2dzPb/ADxvvBKt2IrnI0k8VQOmpaTdCKxGQkqEb8+lVP8AhEIbSaK9stNkiikYExbTuAHY0Aa9uupQ3E0+oa0qWbriBpMBQ3qDXPweGZvEXiuXz9US5SNFkNztyrgfw8V399pNhqPhi2S+055oY8usGDuBGa426a60zTUuvD2lXdnFK3leR5RLAdyfagBfGUY0crf+HdThtHJWEpDgnnqalsdDtNOZG8Qol/K/z/a5BgDPRay7TwnfahthmgkQg+ZudCBxXStpWo+Idcit7hXTSUiw8MiEbnHQ5oA7HXdSTSPDcl6OEjRcYOOOBXMX2hrd+Fb1tJkSO4vFEhkjGSGPNdRr9rayeHZre6tGurcKoMKDlsV5jea1r6ss/h6wvbDTrPKT2rwZac9ivFAEOkeAtG0YPeeJL+zvZmO9RN8pT1HWsaawtLnV7iw0KzHkX7+W11ANyWw7M3tWtF4c1HxH4c1ufWLeWS7kXNpvjKmPPbHes/wJb6roGk6/YNpt4JnjCRSCE4zg8/rQBo61pGjeHfDVlpd5bxa5dkGITJ1jbH3yKi0nXLfQdDtdPsdHkmvIzi5aLqyZ71UsfBniiOE6ld3XmmcZWIREMh966Ofwpqj+G7O50d/sOsyNi6ndCS6c8Y/KgDC1lLzX0Q2wfQtORg8ZlHybh2HvV/UtQiuPBUen3GsQzXf2gEzlhyuemKs3mmazceHl0bVI5btoWMvmLGdremK4ix+H2reIrpEgik0+JGDkTxMM4P8AWgDq4rO58KaxDqumQyXq+VsNnbD5m3dWrstTtrG5ngsFtFjvbuPzRJjlO5Bp+s6ZdxaSLjQl+yX8YWMOU3cd+Kq6VpmseaupajN517GNqOExgHrxQB1WgWFhp9o8VjFHHlsy7O7Y5JpvhD/kStB/7B1v/wCi1qTRNPksIZjI4Zpn8w4GOtR+EP8AkStB/wCwdb/+i1oA2a+fPF/gbxh4o8R2PiK28HSQXdqgluLPU9XjvILhxPuESAtwm1iSpKLjcAAQC/0HRQBxfw50jU9Kt/EcuqWElk+o67c30MUkkbt5UgTaTsZgDwRjPao0J8KeM57Wy0nWtTGoafHJERfLOw8mRxJlrmYEAefFwDj5jjvXcV5/4j+I3hrw/wCLXjvbDVZ7jTIlhur+2tmeCxS4ZGxIcjrsjPCnpgZORQB0H/CQ6p/0Jmuf9/rL/wCSKP8AhIdU/wChM1z/AL/WX/yRXQUUAc//AMJDqn/Qma5/3+sv/kij/hIdU/6EzXP+/wBZf/JFdBRQBz//AAkOqf8AQma5/wB/rL/5Io/4SHVP+hM1z/v9Zf8AyRXQUUAc/wD8JDqn/Qma5/3+sv8A5Io/4SHVP+hM1z/v9Zf/ACRXQUUAc/8A8JDqn/Qma5/3+sv/AJIo/wCEh1T/AKEzXP8Av9Zf/JFdBRQBz/8AwkOqf9CZrn/f6y/+SKP+Eh1T/oTNc/7/AFl/8kV0FFAHP/8ACQ6p/wBCZrn/AH+sv/kij/hIdU/6EzXP+/1l/wDJFdBRQBz/APwkOqf9CZrn/f6y/wDkij/hIdU/6EzXP+/1l/8AJFdBRQBy9/4vu9M065v7zwjrkdraxPNM/mWZ2ooJY4Fxk4APSrH/AAkOqf8AQma5/wB/rL/5IrL1rxhpVzL4p0G70jUrq00qyZtVlj8tYxE8DSbQTIrksoK8Dg9wOaueEvHVh4wnvYbOyvrWS0it5nF2sY3JOhkjI2O3VcHnGMjvnABY/wCEh1T/AKEzXP8Av9Zf/JFH/CQ6p/0Jmuf9/rL/AOSK6CigDn/+Eh1T/oTNc/7/AFl/8kUf8JDqn/Qma5/3+sv/AJIroKKAOf8A+Eh1T/oTNc/7/WX/AMkUf8JDqn/Qma5/3+sv/kiugooA5/8A4SHVP+hM1z/v9Zf/ACRR/wAJDqn/AEJmuf8Af6y/+SK6CigDn/8AhIdU/wChM1z/AL/WX/yRR/wkOqf9CZrn/f6y/wDkiugooA5//hIdU/6EzXP+/wBZf/JFH/CQ6p/0Jmuf9/rL/wCSK6CigDn/APhIdU/6EzXP+/1l/wDJFH/CQ6p/0Jmuf9/rL/5IroKKAOf/AOEh1T/oTNc/7/WX/wAkUf8ACQ6p/wBCZrn/AH+sv/kiugrh7v4paPYweJ5bnT9Vj/4RyWKK7RoUDSea5RGjBflTjdk4ypBGc0AaFn4vu9Qgaa18Ia5JGsskJPmWYw8btG45uOzKw98ccVY/4SHVP+hM1z/v9Zf/ACRXJwfFPQdKQWVn4d8QPcS6nfW5sreBJpftEbLLOcCU5G6YngkcN0AFd5oes2fiHQ7LV7B99rdxLKmSCVz1VsEgMDkEZ4IIoAz/APhIdU/6EzXP+/1l/wDJFH/CQ6p/0Jmuf9/rL/5IroKKAOf/AOEh1T/oTNc/7/WX/wAkUf8ACQ6p/wBCZrn/AH+sv/kiugooA5//AISHVP8AoTNc/wC/1l/8kUf8JDqn/Qma5/3+sv8A5IroKKAOf/4SHVP+hM1z/v8AWX/yRR/wkOqf9CZrn/f6y/8AkiugooA5/wD4SHU/+hM1z/v9Zf8AyRR/wkOqf9CZrn/f6y/+SK6CigDn/wDhIdU/6EzXP+/1l/8AJFH/AAkOqf8AQma5/wB/rL/5IroKKAOf/wCEh1T/AKEzXP8Av9Zf/JFH/CQ6p/0Jmuf9/rL/AOSK6CigDn/+Eh1P/oTNc/7/AFl/8kVXTxfdyajNYL4Q1w3UMUc0ieZZ/Kjlwpz9oxyY3/L3FWL7xdZ6f400vwvNZ332rUonlt7kRDyDsDMyli2dwC8gA43L61z9l8QtEk0G98dPouq2mmtaKpvZvKPnCOVkSJUWViG3yOASqjnlsAUAdB/wkOp/9CZrn/f6y/8Akij/AISHVP8AoTNc/wC/1l/8kVH4U8aWPix9QggstS0+8090W5s9Rt/JlQOu5GxkjBAOOc8dMEE9JQBz/wDwkOp/9CZrn/f6y/8Akij/AISHU/8AoTNc/wC/1l/8kV0FFAHP/wDCQ6n/ANCZrn/f6y/+SKP+Eh1P/oTNc/7/AFl/8kV0FFAHP/8ACQ6p/wBCZrn/AH+sv/kij/hIdT/6EzXP+/1l/wDJFdBRQBz/APwkOp/9CZrn/f6y/wDkij/hIdT/AOhM1z/v9Zf/ACRXQUUAc/8A8JDqf/Qma5/3+sv/AJIo/wCEh1P/AKEzXP8Av9Zf/JFdBRQBz/8AwkOp/wDQma5/3+sv/kij/hIdT/6EzXP+/wBZf/JFdBRQBz//AAkOp/8AQma5/wB/rL/5Io/4SHU/+hM1z/v9Zf8AyRXQVl65rLaLb20qaVqWpPPcLbrFYRK7KWB+ZtzKFQYwWJwMjNAGXeeL7vT4FmuvCGuRxtLHCD5lmcvI6xoOLjuzKPbPPFWP+Eh1P/oTNc/7/WX/AMkVw+ofGjwne21xDdaNrkn2Dy7u8gaBI3tXiuUVQ4MincJPLOBn7wz0YDoLP4paPeeKG0P+z9Vg26hJpv2+eFFtDcIG/diTf95tvyrjJyOOaANj/hIdT/6EzXP+/wBZf/JFH/CQ6n/0Jmuf9/rL/wCSK6CigDn/APhIdU/6EzXP+/1l/wDJFH/CQ6n/ANCZrn/f6y/+SK6CigDn/wDhIdT/AOhM1z/v9Zf/ACRR/wAJDqf/AEJmuf8Af6y/+SK6CigDn/8AhIdT/wChM1z/AL/WX/yRR/wkOp/9CZrn/f6y/wDkiugooA5//hIdT/6EzXP+/wBZf/JFH/CQ6n/0Jmuf9/rL/wCSK6CigDn/APhIdU/6EzXP+/1l/wDJFH/CQ6p/0Jmuf9/rL/5IroKKAOf/AOEh1T/oTNc/7/WX/wAkVc8NWs9j4V0i0uojFcQWUMUsZIO11QAjIJBwQehxWpRQAUUUUAFeT+MPhr4k1zXPEQ03UNKj0jxH9i+2tcpJ58HkYH7sL8rdM/MRnOOMbj6xRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHjfjL4XeJfFmrXd3Gvh/Tp3uLhxqNvNcfaJoWhEUcUi42gFVCvgkYYlV+8H7DwX4f8AEem63rOq+I5tNluL+3sog1l1ZoUZXd/3aZLM2R1wDtzhRXaUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXles+CvGVxrPiy+0ttGgfWbixmtZpLuQtbG0ZSjFPJIYttBxnA6ZavVKKAPH28AeOINetvENjJ4cTUotVv74QyvKYQlxFFGq/JGpZgEbJwMnDHJJr0DwP4b/AOER8F6XoZk8yS1i/euGyDIxLvtOB8u5mxkZxjPNdBRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAcX4o0DXtQ8b+Gtd0uHTZYNGS5LR3V28TStMmzA2xOAFABzznJGBjJ8/PwQ1CWLVI7eDRtHS80dbQpa3dxcq9ys8cu8+YoKI3l7cZYrwfm5r3SigDi/BPhrXtM1vxDr3iO4019Q1h7cGHTg/lRrChQHL85OeR2x15wO0oooAKKKKACiiigAooooAKKKKACiiigAooooAK5vxzYeJtT8NSWPhS+tLG/ncJJcXDMpSLB3bCoJD5wM44BJGDgjpKKAPE5/hX4mt9Jv9I0O18P6fp99pkVlNHLdtcNJKkxk+0Oxthl9rOowBtyCMbFA1LP4ceJP+Eob7dc6V/wj3/CSyeIV8h5PtfmYby1OV2bc7dw69cN0r1iigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKp6tqUOjaNfapcLI0FlbyXEixgFiqKWIGSBnA9RVysfxZY3Gp+DdcsLOPzLq60+4hhTcBudo2CjJ4GSR1oAw9D+J+g+IX0BLGO7L629ykKsEzA0C7nEuHO0lSCAM5DAnGa0Lvx94VttLv7+LXtNu0srdriWO1vIpHKjAwBu6liqjOMlgO9eOWvwd8S2WuadHaQbNNm0SZZxLcr5dpezWTQyDG9i25whLKuMEAcKKNM+HXiX7PHFceDZ7a6g0q7tY7pNQsFRpJLV4xuSOJXfcxABdyV3ZLHnIB7Po3jfw3runJeWes2P8Ax6C8mha6j8y3jwCxlUMdm3IDZ4B71cm8S6DbIHn1vTYkNut0Ge6RQYWYKsnJ+4WIAboSQK8b8V/DLXvF3h7wRbJpP9n3WmRR6bqMkzwtIIgkY81drkPGpEmFLBstwvJNZGmfB/xdZadcXmo6VY6tfWmq2Tw201yjNdWsAdWRXYELGwaMBWx8sfK8KCAe7/8ACWeG/wCzv7R/4SDSvsPm+R9p+2x+X5mN2zdnG7HOOuK5vw/8WPDmv3+tBb20tNL097dIdQurjyVuWlR2ICyBSpBRhjnOCa4NPh1r2o6m9/N4RsdLsbrxBpk8mkRzwyJFbQRyLKxC4Qqxk+6OTluO5j1n4ceJNJ+Lcvinw34V0250u1uIGtrHzIYUkHkgOyLkBCrAkE8hirANg0AeweJ/FFt4Wt7CW4tLu6e/vY7GCK1CbmlcHaDvZQB8uM57isfTPil4ZvtGutTvbiTRktriW2eDVNsU5eJVZwsYYliN4GBznjHTMfj/AELUfFOneF1tbKdfJ1u0vLyP7QsUkEIDbzuV/vLu/gYnPKk9ax7z4WaXZ+KvCcWk6BA/h61lvptQink85A8kKKhKysS2Si9AcYzx1oA7yHxLoNzqh0uDW9Nl1AOyG0S6RpQy53DYDnIwcjHGDXN6l8TdHh17S9K0m80rUvtsV1JJcLqSCO18mLzB5hUNhWwRuPQAnBxivIF+Enih9Hj0G58K75IpXVNUh1CyjjyWYLI37g3DRgNkqXyQOADgC5Y/Dzxa1ppdofA1ppkljpmpW895DeQM17JNbukZf5i2dxA5JA3HG1eAAe3v4u0Gzt7RtU13RrOe4t0nVG1BNrKw+8jNtLoSDhsDOO1Y9p8S9B1aw1abS7/TRPp1w0LLqN+lvHIqui+cHXefKJcBW28nA4zXm9l4D8SaH4iTUbnwDpviaCfR7K3MVxeQqbaWOCON1w5Kk5jPIU8FcMPmB0NS8JeLbnwj8QPDyeHpCdU1h9RsLkXcG2ZWuIyVIL5U7U3DPXkHBADAHrE3iXQbbVBpc+t6bFqBdUFo90iylmxtGwnOTkYGOcio/wDhLPDf9o/2d/wkGlfbvN8j7N9tj8zzM7dm3Od2eMdc143rHw58UXGs6lZW3hu0U3viM6lD4niukE9pC7A4RdyOSnJIJIznAztetT/hXWrf2j/aP9iQfbv+E6/tL7Tui8z+z87t27OduednXPagD1TTfEug6zcNb6Xrem306oXaO1uklYLkDJCknGSBn3FaleL/AAz8FeI/Cvi2CSHQf7N0aW0kF8dRntbmcSluFimhUOVIWI7WAUfPxnaT7RQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXF/FnVb7RfhhrV/ptzJa3aJGiTR8MoeVEbB7Hax5HI6jB5rtKjnghureW3uIo5oJUKSRyKGV1IwQQeCCOMUAeb/DC/ZvE/i/R7fxHd69pNi9o9ndXV2ty2ZI2MmJB1G5cY6DB7k56O21bxBq2t3dpBbR6NHbW0Mvl6jbLPJIXaUZBhuNoX92ODznPtW7puk6bo1u1vpen2ljAzl2jtYViUtgDJCgDOABn2FUrb/kddU/7B1n/AOjLmgA+zeJv+gvpH/grk/8Akij7N4m/6C+kf+CuT/5IrZooAxvs3ib/AKC+kf8Agrk/+SKPs3ib/oL6R/4K5P8A5IrZooAxvs3ib/oL6R/4K5P/AJIo+zeJv+gvpH/grk/+SK2CQKAc0AY/2bxN/wBBfSP/AAVyf/JFH2bxN/0F9I/8Fcn/AMkVs0UAY32bxN/0F9I/8Fcn/wAkUfZvE3/QX0j/AMFcn/yRWzRQBjfZvE3/AEF9I/8ABXJ/8kUfZvE3/QX0j/wVyf8AyRWzRQBjfZvE3/QX0j/wVyf/ACRR9m8Tf9BfSP8AwVyf/JFbNFAGN9m8Tf8AQX0j/wAFcn/yRR9m8Tf9BfSP/BXJ/wDJFbNFAGN9m8Tf9BfSP/BXJ/8AJFH2bxN/0F9I/wDBXJ/8kVs0UAY32bxN/wBBfSP/AAVyf/JFH2bxN/0F9I/8Fcn/AMkVs0UAY32bxN/0F9I/8Fcn/wAkUfZvE3/QX0j/AMFcn/yRWzRQBjfZvE3/AEF9I/8ABXJ/8kUfZvE3/QX0j/wVyf8AyRWzRQBjfZvE3/QX0j/wVyf/ACRR9m8Tf9BfSP8AwVyf/JFbNFAGN9m8Tf8AQX0j/wAFcn/yRR9m8Tf9BfSP/BXJ/wDJFbNFAGN9m8Tf9BfSP/BXJ/8AJFH2bxN/0F9I/wDBXJ/8kVs0UAY32bxN/wBBfSP/AAVyf/JFH2bxN/0F9I/8Fcn/AMkVs0UAY32bxN/0F9I/8Fcn/wAkUfZvE3/QX0j/AMFcn/yRWzRQBjfZvE3/AEF9I/8ABXJ/8kUfZvE3/QX0j/wVyf8AyRWzRQBjfZvE3/QX0j/wVyf/ACRR9m8Tf9BfSP8AwVyf/JFbNFAGN9m8Tf8AQX0j/wAFcn/yRR9m8Tf9BfSP/BXJ/wDJFbNFAGN9m8Tf9BfSP/BXJ/8AJFH2bxN/0F9I/wDBXJ/8kVs0UAY32bxN/wBBfSP/AAVyf/JFH2bxN/0F9I/8Fcn/AMkVs0UAY32bxN/0F9I/8Fcn/wAkUfZvE3/QX0j/AMFcn/yRWzRQBjfZvE3/AEF9I/8ABXJ/8kUfZvE3/QX0j/wVyf8AyRWzRQBjfZvE3/QX0j/wVyf/ACRR9m8Tf9BfSP8AwVyf/JFbNFAGN9m8Tf8AQX0j/wAFcn/yRR9m8Tf9BfSP/BXJ/wDJFbNFAGN9m8Tf9BfSP/BXJ/8AJFH2bxN/0F9I/wDBXJ/8kVsCloAxvs3ib/oL6R/4K5P/AJIo+zeJv+gvpH/grk/+SK2aKAMb7N4m/wCgvpH/AIK5P/kij7N4m/6C+kf+CuT/AOSK2aKAMb7N4m/6C+kf+CuT/wCSKPs3ib/oL6R/4K5P/kitmigDG+zeJv8AoL6R/wCCuT/5Io+zeJv+gvpH/grk/wDkitmigDG+zeJv+gvpH/grk/8Akij7N4m/6C+kf+CuT/5IrZooAxvs3ib/AKC+kf8Agrk/+SKPs3ib/oL6R/4K5P8A5IrZooAxvs3ib/oL6R/4K5P/AJIo+zeJv+gvpH/grk/+SK2aKAMb7N4m/wCgvpH/AIK5P/kij7N4m/6C+kf+CuT/AOSK2aKAMb7N4m/6C+kf+CuT/wCSKPs3ib/oL6R/4K5P/kitmjOaAMb7N4m/6C+kf+CuT/5Io+zeJv8AoL6R/wCCuT/5IrZooAxvs3ib/oL6R/4K5P8A5Io+zeJv+gvpH/grk/8AkitiloAxvs3ib/oL6R/4K5P/AJIo+zeJv+gvpH/grk/+SK2MZ70AY70AY/2bxN/0F9I/8Fcn/wAkUfZvE3/QX0j/AMFcn/yRWxn0oz6UAY/2bxN/0F9I/wDBXJ/8kUfZvE3/AEF9I/8ABXJ/8kVrnk+1A4PHNAGR9m8Tf9BfSP8AwVyf/JFWdBvptT8O6ZqFwEE11aRTSCMEKGZAxwCScZPqa0KxvCH/ACJWg/8AYOt//Ra0AbNFFcHB8VtKudGi1BNI1kPJrA0VbOSGNJxcld2CGkAUduSCD1HegDvKxrb/AJHXVP8AsHWf/oy5pfC3iSz8XeHLTXLCOeO1ut+xJ1AcbXZDkAkdVPektv8AkddU/wCwdZ/+jLmgDZooooAKKKpapqUGlafPd3EiokaF/mOM4FAEt3eW1lCZbmVY0HJZjxWBH8QPDM10beLV7VpBjgNXzv8AED4nap4h1V7PTLiaO234URSZD5GMVzkfhnxNbWa6oILuPPJbb6UAfZsFxFcRh4nDqehFS14x8EfGM2sQHTLu4aW4iR3JdsnGfSvZ6ACiiigAooooAKQ471HcyNHbu6KWYKSAO9eO+JdQ8c3upzxaXbajDCD8rR9MYoA9mBB6Glr53h8TfELwzcb9SstTu4AQCznA9a9I8JfFDTfEJWCXy7W5wSY3lBPWgD0CikByMigHNAC0UUUAFFFFABRRRQAUVyHxB8YJ4R0MXm3e7SBAobB5p3w88QT+JfDSahOrKzSuuGOehoA62kZgoyTgUteX/F3xufDeltbWtxsupY9ybXw3WgD0lLqKR9qOGOccVPXmPwkutT1HTJrvUZZZCzqVMhzwRXp1ABRRRQAUUUUAFFMkkSJC0jBVHc15/wCLPihpehZjinhlkwDhZQO9AHoRIHU1Wn1C1tlLTTogHcmvnDWvjbqUkuy0WVVI6rJ/9aqmna54s8YSeVG16qsdu4Hd70AfTVvqNpdDME6Sf7pqypzXJeCdButK01PtkzySsqk7xgg4rqgSGIA4oAkooooAKKBzRQAVFPOtvEZHIAHrUhIUZNc/4gumOnyrHnOOxoA5DxF8WotJneOG1jmCZBPmEdD9KseFPi1pOuymG4lgtpSwUKXJz+lU/Dvg2y1f7TJe28cmZcfOma43xl8IrzTLl9R0OeRMFnCwx42+lAH0BDdwXChoZVdT0IqXGe9eR/DCfWEH2bUZZ3aMKp8yvXB0oAWiiigAooFFABTSwFONQzHC8DmgCC+1GGyhaSR1UAZ5Ncunjuzl1BbWN42JfbwxrnfihqlzZ6NO8TOpWNjweteE+FNZvbrxVbiS5kHmzLwT0oA+w7W7WdOCOlWR0rK0KDy9NhLtuYryTWtxQAUd6KKACk5paKACk6c0p6VWuLjyoycdqAHyTrHgkioWuwT2ArmtT8QJDIFYYycDmsaTXJ5mcRuwXHykGgDvjdxKNzSAD60+G8imbCOG+leH+IfE2o2AXbdSt82NobFN8O/EGe3vd12XVSMbXf3oA96zgZNIp4rE0rxBa6pAskUiEHsGzW2rArkUAOpD6UE8Ue9AATjFGeOaQkZzmoXlAJ+bpQBKZAM1C10iAs7AD3rLv9SEQYA4981yOoeIWR2Tzs47bqAO5GqRMxwy4x606HUFlX5cZ+teUNr05lJSZlHoDW/pGsSzAJyD65oA9Ajk3Lk8VMhBFZtmxZAC+6tFMDigBwrH8If8iVoP/YOt/wD0WtbAGKx/CH/IlaD/ANg63/8ARa0AbNeT2fgvxxp87TWo0OORvEsmuk/bpTlJEaN4ObfurMN/bPAzXrFFAHN+AtCvvDXgyy0rU3tHvInmeVrRdsWXld/lG1QBhhwFAHQcU3RNI03RvF2rW+l6daWMLWFm7R2sKxKW8y5GSFAGcAc+1dNWNbf8jrqn/YOs/wD0Zc0AbNFFFABXg/x28VXVrFFpttI6K7ukgBGGGK93b7pr5e+OEv8AxUi7wSqznj8BQBL8Hvh2utXP9pahErW6hZIw6HBO7sa9u8ZW+nab4WmQxxRpsYKOnO01wPw7+IuiaP4PtLeVHV4osEbl9T71wvxN+KcniRzY6eZY7ZWDYYA54waAJ/2fGVfHd4SQM2jY/wC+hX0/2r4q8BeIp/DfiSO6gDlpAIiEGTgkV9m2Fwbq0SUqVyOhoAs0UUUAFFFFACHBGD0pqxovKgCnEcUAcUAV7yxtb6Fo7mJJEI5DCvC/iJ4PtvC2oRaxoxjty0scZiiXnGea9V8Z3erWWktLpTMJhn7qbux7V89Wmv8AinxDraReIzObdWDfvIdgyDx2oA+lPDGoS6losVxKjK5yCG68VsA5qjpH2UWCLaMhj/2WzV7gUALRRRQAUUUUAFNYhFLHoBmnVzfjPXotD0OaZnwzKyryOu00AeGfG/xP/aOtDR4nLRq0bjDAjNet/CWym0/wXDBMGB8125GOtfOvhSzfxl4z8y9+fADZYYHBHpX17Y28VpapDEAFA6CgCdmCqSTXyl8QribxZ4+is1kL7PMjXvgBj6V9J+KdWi0fQp7pmA247jua+efhhpUuv/ENtTk+aJJ5eSPXJoA+hvCmlRaVoFpCiBT5KbsDGTgVuUyJNkSoOwxT6ACiiigAooo7UAeWfFzxlN4fsDBbs4kYp90juTXi9r4A1/xTKLqR5cN/EYicd67346adczahFc5/cDygcjvk969c8HLbf2BB5BUjAzg55wKAOC8O/BfTILZDqEME0nHLRkdq9C0TwppWiJttLWJDnOVFbh6U1BjNAAuc4HAFPoooAKDRRQAUUUUAMlXcmKytRsPMs5Ao+Y+1bFNcqqksQB70Ach4cu0043MVy4jBlyC5xxWL4r+Jem2k/wBgtnW4kfKkRyg81w3xf8TPZXS2+nTAMytu2kHnNYPw08BSa9qqapfPG/7xZCCCDyKAPV/AlxLfXs9w0LorlSN1el1m6bo9vpsCRwoF2gDitHPOKAFooooAKKKKACkKg9RS1XvLgW8DOTjAoA8j+M+o21tpTQ+WC7xuMg9OleJ/Dy1W88ZWLEDAuEODXR/F7X5L3VzAHJQM6np61mfCh4I/EsTzLkiVCOfegD63sohHaRqBwBVmq9pMktujKeCKsUAFAoooAKM0UhHNACMflrK1ORhC2ATwelaj8is+/AWFj6CgDzXX7gJKpaIucnioNNhnvAWVWhXGQGFP1SG4n1SVgcKH4BFdNpEC/ZIw+MquTmgDm77wn9ujDyIGbrkqa5a+8Gutwu8qBkdVNeyRzRsSijIUVn3dil5P/qyQCDQBX8I6GtpaqoK9ScgV3KJtTFUNMtUgtwFGOa0u1ABSEZpabk4NADWArLvWPzBTtPrWi54ORWVqBIQlQehxQBzerO5iAD7mUnOK5O6ts5nk+Xf0BrpLsvGbiVs525Fcbf6m84VJHyqnO30oAoXEbxPvV8AnArqPDNrdSThndiuDyRXLSM19drBFwAQa9R0G0aJljHC4zQB0OnWzxgFpMitVcdcVUhARcCranjBoAfWN4Q/5ErQf+wdb/wDota2axvCH/IlaD/2Drf8A9FrQBs0UV84a7eX7veS+FfGHiNfDWmeVaatrt5qEk6SO9wnMCgAlkDDJQruVcfxZkAPo+sa2/wCR11T/ALB1n/6MuawPhrJOYvFNtLqU9/HaeILm3geaeWYxxqseI90nzfLkg9RkEgkHJ0tEl1KXxdqzapaWltN9gswqWt006lfMueSzRoQc54x+NAHTUUUUAIRkYr5z+OmhXcl9HdRRs6mRidqk9hX0bVS90631CIxzpuUjFAHwe0MycNG4+qmozkHmvrzxH8OfDn9m3Ny8MqssbNkSegr5X1WCBtcaG1yYmZVXPvQB2vwd8NJr3ikm5jLQxxFxyRyCK+s44xHGFUYAFedfCHwvDo3hiC42ETuXBJOeM16RQAUUUUAFFFFABSHjpS03OTQApAI5rmPFvhm31fSnVEAmHzAk+grpyM0jDKEe1AHjHwl1i+s9QfRdQkUkeZIMDHfivZyM4NeA+JrmTw98VUaDChrcdeepr3yBvMt429VB/SgCSiiigAooooARiQpxXz/8db29AWABjGJR0X/Zr6BrG1rw1p+ux7byNm5zw2KAPj/wx4hu/D1x5ttHJvwR/q813C/GzxNEw3ZCD1t69ptPhhoNrMZBDIeO8lWbr4deHryIiWCTHs+KAPnrxd8UrrxLo72MpcMxU8xhelegfs/wGLTrlmUgtPkHH+zXl/xP0Ky0bxZHZ6cG8sxAkMc85NfSXw80SPSfD0OxSDIqucnPVRQB2VFFFABRRRQAUmcUtISBQBy3jnwsnifRntiF3blYZJHSvIPCnxCfwHdvpWtLK0W9mBijzx0H8q+iOorhvE/wx0XxPL5t3HJvxjKSbaANbQ/G+ka+im1kIJ7PgHpn1rogyuMqQfoa8Pvfg7caGrXOivgryBJOTU3gTxzqS64NE1IoHEvljCeg9aAPa+KWo48Miv6jNSUAFFFFABRSdKCQKAFrzr4l+MG0Swa3tHzcOmQAA3eul8TeKrLw5psl1cswC4HC5614L4Pjv/iB49GpXm1rOGSRBtO045I4oAdo/wAOtW8Syvqd+YyS25M5Xg812fhO6/4RbXI9Nu2CiSQIuPb6161bwrb26RRqAqqBXzd8Y7ydPF1k0JAkjkfbigD6YSZJYRIhBDDIpUOeTXD+Ab27ufDOnmfG/wAlc4FdvGDtyaAJKKKKACikPSloAazbVJrl/EdzNJbvCjD5lIrppgzIQK5/UbBjmQ9vegD5x8a+Gna+NzIV25Zm5rN8DW8R8RKkQI2SqDk10nxQ1T7PI1tggtuUfL71xvgG5lTxFCqYzJKoOaAPrbQhttEX0UVtisvQ4pF02FpMZK9q1R70AFIBilooAQ5zxS/WikJCjJoArzzrGMtms65f7QVCZx71leKPESaVAzuQAAe3vWbo3i6G+KgN1x1WgC1PpkjXTOQMZyKpyNJbSyqzrtPAFdFdalCtk8u4cKSa8t1TWRdauqo3DyAUAei6NEjQhsEkjrWsoEIAUVBocaR6VCo64q/tUnae1AFq3Uhcmpqhj9Klz2oAWkpaKAGsMqfes69AWI8VosSBxVG7K7ctQBxutrKtsWXo4IxivPW0aW5u5JBgDGRmvRdb1NUcRe+OlYYvImZo1B3Ac8UAZ/h/RhDdebJt3Yx1r0nTISkYZiCenFcZYi1LAvvz7V2mmSRsoVd2PegDWRAgzirQxxTI8FKfjmgBaxvCH/IlaD/2Drf/ANFrWzWN4Q/5ErQf+wdb/wDotaANmuf/AOEE8H/9Cpof/guh/wDia6CigCnpuk6bo1u1vpen2ljAzl2jtYViUtgDJCgDOABn2FUrb/kddU/7B1n/AOjLmtmsa2/5HXVP+wdZ/wDoy5oA2aKKKACiimyZMbbeuOKAPIvjT4yXStLFhA/752ZHGDwCteK/DPw8PEXiZUk3FYdshwf9oV23xL+HfirW/Ft1eWlq89vI4K5lGBwOgNd58Jfh5N4Ytftl/G0d3Km1kOCBzmgD1G2t0tYFijGFHSpqKKACiiigAoopM0AKaQCiloAO1N24BNOPAzXLeKvFY0S1YQqkkx4CsSOooA8k+IkB1P4tw20XJFqjccdDXvtqhjtIlPUIB+leNeA/DOq6t4p/4SPV4GjPltEBuDDrx1r2ocKB6CgB1FJmloAKKKKACiiigBByOarXX7m3dge1WqjnQSQsp9DQB8jXLNrfxFCP82N459ia+s9OjEOnW6AYAjUfpXyvDZzWPxQCIm5iJGwfqa+q7M7rOHI52D+VAE9FFFABRRRQAUUUdqAK9zcJCvzHFRx6jbMmfMrK8RaBJq9m0SXE0TEjmNsV5HdfCfxMzuYtQ1DBJwBc4/rQB67c+NNCtnMc13gjqNhNfPvjfX4j47sbzR8MVZzyu3JJqa3+D3iy4vCt1JdiPJ+bzwT/ADr0Pwr8J4dJuY5rx5JXU5/ebW7UAd74Xu7q80CzmuFUO0Kk4+lbYz3qOGFbeBIo1AVRgADFS0AFFFFAAeaaUB706kI5oA85+LXhxtW8KTrCW8zcmBux3rzD4e+MNO8CQT2motsdpS3CFj0x1FfRd9ZJewGN+h7Vwd78I9I1CczTSSq2TwFX/CgDLvfjn4djtW+z3BaYj5QYWxmvP9J0u++I/i9dRkjX7LHcbsqdvB56GvWtP+EmhWUyy5eQqc4dFx/Ku0sNKs9NiEdtBGg/2UA/lQBFo2lRaVp0NtGDhEC81pUUUAFFBooAQkUtNxmndBQAVHLEJEII604HNAPNAHhvxg8LveRrNbxglFYnkDvXl/w70uWPxnapMuPLuEDc+9fVOtadHewOjqCCCOlcnpXgq1sNUa9UHcXDD5RxQB6DaqFto1XoBU1QW5/dKPQVPQAY5zRRRQAU1xuXFOoPIoA8f+KXh6/1ULHaAksjD7+O9c7onhfUrLTz5qkPGoxh69yubFZmywz+FMTTkCFfLGD7CgDxHVLXXZrF4YlHKkD56yvDfgjW/tqT3K8lgR+8yOtfQh0i2IBZQPwFSx2FvHjao49qAMbR9NubaBVl4OOzVuxwkAFutShFHOafigBAuDS9KWigAooooAgmkESsW6Vyur6mEjncNwgJFdbKFKnNc9qemC8DIo+U5BIoA8q1HWpprkHC7d3pWppxkuY1ZFBD8E11aeF4Y9qrGHx1LKK1oNLWGJI0iUbfYUAY+n6VFbQqw3Ficc109hbeXGCRinJZKVBcbfpV1I1CAA0AP6jAqSmkEcilyc0ALnNY3hD/AJErQf8AsHW//ota2axvCH/IlaD/ANg63/8ARa0AbNeN6l8c7vSNSXSrvwpHLqkiAR2ljqqXLLN5pj8mQomFfCk4G48qMDJ2+yV5Pr3wh1nxPdWd9q/jXfqVjFstby20pIJFfzd4dyr5bAyAAVwcMOd24A7Twd4om8UW+rNcWEdlPpupzadIkdwZldowuWDFFOCW9O1W7b/kddU/7B1n/wCjLmqng7wvN4Xt9WW4v472fUtTm1GR47cwqjSBcqFLscAr696yvsUvhjxobPwz4f0ZIdT04SlBObNVa3kwxISFwSRcx4P+yfQZAO5orn/tnjD/AKAWh/8Ag5m/+RaPtnjD/oBaH/4OZv8A5FoA6CkJPpWB9s8Yf9ALQ/8Awczf/ItH2zxh/wBALQ//AAczf/ItAG6Y0bkoCacAAMAYrA+2eMP+gFof/g5m/wDkWj7Z4w/6AWh/+Dmb/wCRaAOgorn/ALZ4w/6AWh/+Dmb/AORaPtnjD/oBaH/4OZv/AJFoA6Ciuf8AtnjD/oBaH/4OZv8A5Fo+2eMP+gFof/g5m/8AkWgDoKTFYH2zxh/0AtD/APBzN/8AItH2zxh/0AtD/wDBzN/8i0AdBRXP/bPGH/QC0P8A8HM3/wAi0fbPGH/QC0P/AMHM3/yLQB0Bqjc6TaXbhpoY3/3lBrN+2eMP+gFof/g5m/8AkWj7Z4w/6AWh/wDg5m/+RaANyKCKBdsUaoPRRinkZrlNW17xVo2jX2qXGgaM0FlbyXEix6xKWKopYgZtgM4HqKufbPGH/QC0P/wczf8AyLQBvgUtc/8AbPGH/QC0P/wczf8AyLR9s8Yf9ALQ/wDwczf/ACLQB0FFc/8AbPGH/QC0P/wczf8AyLR9s8Yf9ALQ/wDwczf/ACLQB0FFc/8AbPGH/QC0P/wczf8AyLR9s8Yf9ALQ/wDwczf/ACLQB0FJ2xisD7Z4w/6AWh/+Dmb/AORaPtnjD/oBaH/4OZv/AJFoAtDw5pn20XZs4DOM/P5Yz+daoUKAAMAVgfbPGH/QC0P/AMHM3/yLR9s8Yf8AQC0P/wAHM3/yLQB0FFc/9s8Yf9ALQ/8Awczf/ItH2zxh/wBALQ//AAczf/ItAHQUVz/2zxh/0AtD/wDBzN/8i0fbPGH/AEAtD/8ABzN/8i0Ab9HIFYH2zxh/0AtD/wDBzN/8i0fbPGH/AEAtD/8ABzN/8i0Ab5J7CkBPcVyuma94q1W1e4g0DRlRLie3IfWJQd0UrRMeLY8bkJHtjp0q59s8Yf8AQC0P/wAHM3/yLQBuquDnGKdjmsD7Z4w/6AWh/wDg5m/+RaPtnjD/AKAWh/8Ag5m/+RaAOgorn/tnjD/oBaH/AODmb/5Fo+2eMP8AoBaH/wCDmb/5FoA6Ciuf+2eMP+gFof8A4OZv/kWj7Z4w/wCgFof/AIOZv/kWgDoKK5/7Z4w/6AWh/wDg5m/+RaPtnjD/AKAWh/8Ag5m/+RaAN880tc/9s8Yf9ALQ/wDwczf/ACLR9s8Yf9ALQ/8Awczf/ItAG+eRQBisD7Z4w/6AWh/+Dmb/AORaPtnjD/oBaH/4OZv/AJFoA6Ciuf8AtnjD/oBaH/4OZv8A5Fo+2eMP+gFof/g5m/8AkWgDoKK5/wC2eMP+gFof/g5m/wDkWqceveKpdZudLXQNG8+3t4bh2OsS7SsjSKoH+jZzmJs8dx17AHVBcUvasD7Z4w/6AWh/+Dmb/wCRaPtnjD/oBaH/AODmb/5FoA3wKMc1gfbPGH/QC0P/AMHM3/yLR9s8Yf8AQC0P/wAHM3/yLQButGGHIpohUfwj8qxPtnjD/oBaH/4OZv8A5Fo+2eMP+gFof/g5m/8AkWgDfCgDgUtc/wDbPGH/AEAtD/8ABzN/8i0fbPGH/QC0P/wczf8AyLQB0FFc/wDbPGH/AEAtD/8ABzN/8i0fbPGH/QC0P/wczf8AyLQB0FJzWB9s8Yf9ALQ//BzN/wDItH2zxh/0AtD/APBzN/8AItAG/ilrn/tnjD/oBaH/AODmb/5Fo+2eMP8AoBaH/wCDmb/5FoA38UY9qwPtnjD/AKAWh/8Ag5m/+RaPtnjD/oBaH/4OZv8A5FoA38cUVymp694q0q1S4n0DRmR7iC3ATWJSd0sqxKebYcbnBPtnr0q59s8Yf9ALQ/8Awczf/ItAHQUYrn/tnjD/AKAWh/8Ag5m/+RaPtnjD/oBaH/4OZv8A5FoA6CkPWsD7Z4w/6AWh/wDg5m/+RaPtnjD/AKAWh/8Ag5m/+RaAN5lyp71CIuDx1rH+2eMP+gFof/g5m/8AkWj7Z4w/6AWh/wDg5m/+RaANpYFA96cYxgYFYf2zxh/0AtD/APBzN/8AItH2zxh/0AtD/wDBzN/8i0AbhTjFKq1hfbPGH/QC0P8A8HM3/wAi0fbPGH/QC0P/AMHM3/yLQBvnpS1z/wBs8Yf9ALQ//BzN/wDItH2zxh/0AtD/APBzN/8AItAHQVjeEP8AkStB/wCwdb/+i1qD7Z4w/wCgFof/AIOZv/kWr+gWM2meHNL0+4MZntbSKGQxklSyoFOCQCRkegoA0aKKKACvI/GPxD17RfEuv3On6Vo0un+GEtEu3ui/2qVbkqSImHCA4UEHPKA/NwB65XD+IPhXoXiPXLnU7q71WFb3yft1nbXZSC88r7nmLjJwABwRjGRg5NAHcUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHk/in4jT6Z4g8U6PqT6VDYWto62MN5YyuNRk+yea8Rk3iMYLxgqRlhIFHJBrpPBev+JtR1vWdK8TWVpbT2NvZTJ9nhZAxmRmcZLuGCspTcpwSrfQV9c+FWm+JHlXWNd8QXdo9xNcpZyXamKGSRSAUGzICZ+RSSBzwQzA6nhLwLYeD572azvb66ku4reFzdtGdqQIY4wNiL0XA5znA75yAdRRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAV5fe+OvFlvdeNrCCy0qe/0i7sYdNRVcLKLqXCCQs4+bay9NoDZ6ivUK4PV/hXp+tXGuy3Ouayqa48TXsUZtwrCI/ulGYiVC4A4OTjkmgDl4/G/jZNbt/DWnaf4fg1CfWNRtd1xaTQROsSRzCXarkgyea7Z5zuU+pPongfxJ/wl3gvS9cMflyXUX71AuAJFJR9oyfl3K2MnOMZ5rm5vg/pUrxzrr3iCC8S9ub77Zb3McUplnVFkOVjAAIjHAA+83bgdpoejWfh7Q7LSLBNlraRLEmQAWx1ZsAAsTkk45JJoA0KKKKACiiigAooooAKKKKACiiigAooooAKKKKAOP1nxJrGmfEzw1oaR2LaRq8Vxucq5nWSJGc4OdoU5jxwT97pxXnel/GaWbwjqviB5dGn16GyDSadDp00TIBcCONnnZ2DoPN3bBg/OQCOTXqGu+D4tc8QaZrR1fUrK70xJFtfsvklUMg2uxEkbZJXA54GBgA5Jx7n4U6VqRuW1fV9Z1N59MGmb7qaPcsSyLIrBkjUs4dQdzbs87s0AWPBPiXXtT1vxDoPiO301NQ0d7cmbTi/lSLMhcDD85GOT3z04ye0rm/Cngux8JvqE8F7qWoXmoOjXN5qNx50rhF2oucAYAJxxnnrgADpKACiiigAooooAKKKKACiiigAooooAKKKKACsfxJNrFvp0c+kXOlWvlyh7yfUw5jitwCXYBSvzDg8kDAOSOtbFc/4x8I2fjbQ/wCyL+8vra1Mqyv9jlCGTbnCtlSCuSDjHVVPagDyOP4q+Nta0LVr+HQtGuLPSLdLppjaTSR3TC5KpJGrOrKgCO+4g7TAxO0nC9JZ/EfxJ/wlDfbrbSv+Ee/4SWTw8vkJJ9r8zDeWxy2zbnbuPXrhelamqfCDS9ZLG913WWDWSaftjW1iUW6SCRYwqQAABlB4weMdOKuWfwt0ez8UNrn9oarPu1CTUvsE8yNaC4cN+8Eez7y7vlbORgc8UAdxRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAH/9k=")||gt(dt,"src",da),Rt(Jt.src,Ia="data:image/jpeg;base64,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")||gt(Jt,"src",Ia),Rt(bt.src,Ka="data:image/jpeg;base64,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")||gt(bt,"src",Ka),Rt(Ft.src,qa="data:image/jpeg;base64,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")||gt(Ft,"src",qa)},m(A,t){gn(document.head,h),s(A,Kt,t),s(A,yt,t),s(A,Qt,t),w(C,A,t),s(A,vt,t),w(u,A,t),s(A,Dt,t),s(A,B,t),s(A,Tt,t),s(A,g,t),s(A,Pt,t),s(A,m,t),s(A,xt,t),s(A,d,t),s(A,Ht,t),s(A,J,t),s(A,kt,t),s(A,b,t),s(A,Gt,t),s(A,F,t),s(A,Nt,t),w(y,A,t),s(A,Xt,t),w(I,A,t),s(A,Wt,t),s(A,R,t),s(A,Et,t),w(K,A,t),s(A,zt,t),s(A,Q,t),s(A,St,t),w(v,A,t),s(A,Vt,t),s(A,D,t),s(A,Zt,t),w(T,A,t),s(A,Lt,t),s(A,P,t),s(A,Ot,t),w(x,A,t),s(A,qt,t),w(H,A,t),s(A,Yt,t),s(A,k,t),s(A,_t,t),s(A,G,t),s(A,$t,t),w(N,A,t),s(A,Ae,t),s(A,X,t),s(A,te,t),s(A,W,t),s(A,ee,t),s(A,E,t),s(A,se,t),s(A,z,t),s(A,ae,t),s(A,S,t),s(A,ne,t),s(A,V,t),s(A,le,t),w(Z,A,t),s(A,oe,t),s(A,L,t),s(A,ie,t),w(O,A,t),s(A,pe,t),s(A,mt,t),s(A,re,t),s(A,q,t),s(A,we,t),w(Y,A,t),s(A,je,t),s(A,_,t),s(A,fe,t),s(A,$,t),s(A,Ue,t),s(A,AA,t),s(A,Me,t),s(A,tA,t),s(A,ce,t),w(eA,A,t),s(A,he,t),s(A,sA,t),s(A,Ce,t),w(aA,A,t),s(A,ue,t),s(A,nA,t),s(A,Be,t),w(lA,A,t),s(A,ge,t),s(A,oA,t),s(A,me,t),w(iA,A,t),s(A,de,t),s(A,pA,t),s(A,Je,t),s(A,rA,t),s(A,be,t),s(A,wA,t),s(A,Fe,t),s(A,jA,t),s(A,ye,t),w(fA,A,t),s(A,Ie,t),s(A,UA,t),s(A,Re,t),s(A,MA,t),s(A,Ke,t),w(cA,A,t),s(A,Qe,t),s(A,dt,t),s(A,ve,t),s(A,hA,t),s(A,De,t),w(CA,A,t),s(A,Te,t),s(A,uA,t),s(A,Pe,t),s(A,BA,t),s(A,xe,t),s(A,gA,t),s(A,He,t),w(mA,A,t),s(A,ke,t),s(A,Jt,t),s(A,Ge,t),s(A,dA,t),s(A,Ne,t),w(JA,A,t),s(A,Xe,t),s(A,bt,t),s(A,We,t),s(A,bA,t),s(A,Ee,t),w(FA,A,t),s(A,ze,t),s(A,yA,t),s(A,Se,t),s(A,IA,t),s(A,Ve,t),s(A,RA,t),s(A,Ze,t),s(A,KA,t),s(A,Le,t),s(A,QA,t),s(A,Oe,t),w(vA,A,t),s(A,qe,t),s(A,DA,t),s(A,Ye,t),s(A,TA,t),s(A,_e,t),s(A,PA,t),s(A,$e,t),w(xA,A,t),s(A,As,t),s(A,HA,t),s(A,ts,t),s(A,kA,t),s(A,es,t),w(GA,A,t),s(A,ss,t),s(A,NA,t),s(A,as,t),w(XA,A,t),s(A,ns,t),s(A,WA,t),s(A,ls,t),s(A,EA,t),s(A,os,t),w(zA,A,t),s(A,is,t),s(A,SA,t),s(A,ps,t),s(A,VA,t),s(A,rs,t),s(A,ZA,t),s(A,ws,t),s(A,LA,t),s(A,js,t),s(A,OA,t),s(A,fs,t),w(qA,A,t),s(A,Us,t),w(YA,A,t),s(A,Ms,t),s(A,Ft,t),s(A,cs,t),s(A,_A,t),s(A,hs,t),w($A,A,t),s(A,Cs,t),s(A,At,t),s(A,us,t),s(A,tt,t),s(A,Bs,t),w(et,A,t),s(A,gs,t),s(A,st,t),s(A,ms,t),w(at,A,t),s(A,ds,t),s(A,nt,t),s(A,Js,t),s(A,lt,t),s(A,bs,t),s(A,ot,t),s(A,Fs,t),w(it,A,t),s(A,ys,t),s(A,pt,t),s(A,Is,t),s(A,rt,t),s(A,Rs,t),w(wt,A,t),s(A,Ks,t),s(A,jt,t),s(A,Qs,t),s(A,ft,t),s(A,vs,t),s(A,Ut,t),s(A,Ds,t),s(A,Mt,t),s(A,Ts,t),s(A,ct,t),s(A,Ps,t),w(ht,A,t),s(A,xs,t),s(A,Ct,t),s(A,Hs,t),s(A,ut,t),s(A,ks,t),w(Bt,A,t),s(A,Gs,t),s(A,It,t),Ns=!0},p:cn,i(A){Ns||(j(C.$$.fragment,A),j(u.$$.fragment,A),j(y.$$.fragment,A),j(I.$$.fragment,A),j(K.$$.fragment,A),j(v.$$.fragment,A),j(T.$$.fragment,A),j(x.$$.fragment,A),j(H.$$.fragment,A),j(N.$$.fragment,A),j(Z.$$.fragment,A),j(O.$$.fragment,A),j(Y.$$.fragment,A),j(eA.$$.fragment,A),j(aA.$$.fragment,A),j(lA.$$.fragment,A),j(iA.$$.fragment,A),j(fA.$$.fragment,A),j(cA.$$.fragment,A),j(CA.$$.fragment,A),j(mA.$$.fragment,A),j(JA.$$.fragment,A),j(FA.$$.fragment,A),j(vA.$$.fragment,A),j(xA.$$.fragment,A),j(GA.$$.fragment,A),j(XA.$$.fragment,A),j(zA.$$.fragment,A),j(qA.$$.fragment,A),j(YA.$$.fragment,A),j($A.$$.fragment,A),j(et.$$.fragment,A),j(at.$$.fragment,A),j(it.$$.fragment,A),j(wt.$$.fragment,A),j(ht.$$.fragment,A),j(Bt.$$.fragment,A),Ns=!0)},o(A){f(C.$$.fragment,A),f(u.$$.fragment,A),f(y.$$.fragment,A),f(I.$$.fragment,A),f(K.$$.fragment,A),f(v.$$.fragment,A),f(T.$$.fragment,A),f(x.$$.fragment,A),f(H.$$.fragment,A),f(N.$$.fragment,A),f(Z.$$.fragment,A),f(O.$$.fragment,A),f(Y.$$.fragment,A),f(eA.$$.fragment,A),f(aA.$$.fragment,A),f(lA.$$.fragment,A),f(iA.$$.fragment,A),f(fA.$$.fragment,A),f(cA.$$.fragment,A),f(CA.$$.fragment,A),f(mA.$$.fragment,A),f(JA.$$.fragment,A),f(FA.$$.fragment,A),f(vA.$$.fragment,A),f(xA.$$.fragment,A),f(GA.$$.fragment,A),f(XA.$$.fragment,A),f(zA.$$.fragment,A),f(qA.$$.fragment,A),f(YA.$$.fragment,A),f($A.$$.fragment,A),f(et.$$.fragment,A),f(at.$$.fragment,A),f(it.$$.fragment,A),f(wt.$$.fragment,A),f(ht.$$.fragment,A),f(Bt.$$.fragment,A),Ns=!1},d(A){A&&(e(Kt),e(yt),e(Qt),e(vt),e(Dt),e(B),e(Tt),e(g),e(Pt),e(m),e(xt),e(d),e(Ht),e(J),e(kt),e(b),e(Gt),e(F),e(Nt),e(Xt),e(Wt),e(R),e(Et),e(zt),e(Q),e(St),e(Vt),e(D),e(Zt),e(Lt),e(P),e(Ot),e(qt),e(Yt),e(k),e(_t),e(G),e($t),e(Ae),e(X),e(te),e(W),e(ee),e(E),e(se),e(z),e(ae),e(S),e(ne),e(V),e(le),e(oe),e(L),e(ie),e(pe),e(mt),e(re),e(q),e(we),e(je),e(_),e(fe),e($),e(Ue),e(AA),e(Me),e(tA),e(ce),e(he),e(sA),e(Ce),e(ue),e(nA),e(Be),e(ge),e(oA),e(me),e(de),e(pA),e(Je),e(rA),e(be),e(wA),e(Fe),e(jA),e(ye),e(Ie),e(UA),e(Re),e(MA),e(Ke),e(Qe),e(dt),e(ve),e(hA),e(De),e(Te),e(uA),e(Pe),e(BA),e(xe),e(gA),e(He),e(ke),e(Jt),e(Ge),e(dA),e(Ne),e(Xe),e(bt),e(We),e(bA),e(Ee),e(ze),e(yA),e(Se),e(IA),e(Ve),e(RA),e(Ze),e(KA),e(Le),e(QA),e(Oe),e(qe),e(DA),e(Ye),e(TA),e(_e),e(PA),e($e),e(As),e(HA),e(ts),e(kA),e(es),e(ss),e(NA),e(as),e(ns),e(WA),e(ls),e(EA),e(os),e(is),e(SA),e(ps),e(VA),e(rs),e(ZA),e(ws),e(LA),e(js),e(OA),e(fs),e(Us),e(Ms),e(Ft),e(cs),e(_A),e(hs),e(Cs),e(At),e(us),e(tt),e(Bs),e(gs),e(st),e(ms),e(ds),e(nt),e(Js),e(lt),e(bs),e(ot),e(Fs),e(ys),e(pt),e(Is),e(rt),e(Rs),e(Ks),e(jt),e(Qs),e(ft),e(vs),e(Ut),e(Ds),e(Mt),e(Ts),e(ct),e(Ps),e(xs),e(Ct),e(Hs),e(ut),e(ks),e(Gs),e(It)),e(h),U(C,A),U(u,A),U(y,A),U(I,A),U(K,A),U(v,A),U(T,A),U(x,A),U(H,A),U(N,A),U(Z,A),U(O,A),U(Y,A),U(eA,A),U(aA,A),U(lA,A),U(iA,A),U(fA,A),U(cA,A),U(CA,A),U(mA,A),U(JA,A),U(FA,A),U(vA,A),U(xA,A),U(GA,A),U(XA,A),U(zA,A),U(qA,A),U(YA,A),U($A,A),U(et,A),U(at,A),U(it,A),U(wt,A),U(ht,A),U(Bt,A)}}}const bn='{"title":"Diffusion Models from Scratch","local":"diffusion-models-from-scratch","sections":[{"title":"Setup and Imports:","local":"setup-and-imports","sections":[],"depth":2},{"title":"The Data","local":"the-data","sections":[],"depth":2},{"title":"The Corruption Process","local":"the-corruption-process","sections":[],"depth":2},{"title":"The Model","local":"the-model","sections":[],"depth":2},{"title":"Training the network","local":"training-the-network","sections":[],"depth":2},{"title":"Sampling","local":"sampling","sections":[],"depth":2},{"title":"Comparison To DDPM","local":"comparison-to-ddpm","sections":[{"title":"The UNet","local":"the-unet","sections":[],"depth":3},{"title":"The Corruption Process","local":"the-corruption-process","sections":[],"depth":3},{"title":"Training Objective","local":"training-objective","sections":[],"depth":3},{"title":"Timestep Conditioning","local":"timestep-conditioning","sections":[],"depth":3},{"title":"Sampling","local":"sampling","sections":[],"depth":3}],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Fn(Xs){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends Cn{constructor(h){super(),un(this,h,Fn,Jn,Mn,{})}}export{vn as component};
