import{s as ir,o as rr,n as jl}from"../chunks/scheduler.37c15a92.js";import{S as or,i as pr,g as i,s as a,r as p,A as hr,h as r,f as l,c as n,j as ar,u as h,x as o,k as nr,y as mr,a as s,v as m,d,t as M,w as c}from"../chunks/index.7cb9c9b8.js";import{T as fl}from"../chunks/Tip.d10b3fc9.js";import{Y as dr}from"../chunks/Youtube.8666c400.js";import{C as y}from"../chunks/CodeBlock.abae2786.js";import{C as Mr}from"../chunks/CourseFloatingBanner.df82c153.js";import{F as cr}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as j,E as ur}from"../chunks/getInferenceSnippets.363af239.js";function yr(f){let u,J="✏️ <strong>Your turn!</strong> Check that everything seems correct with the second element of the training dataset.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-f3t9l4"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function wr(f){let u,J="In the next part of the course, we’ll look at more advanced techniques that can help you reduce your memory footprint and let you fine-tune the biggest models.";return{c(){u=i("p"),u.textContent=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-9j5678"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function Jr(f){let u,J="💡 You should always make sure you can run <code>trainer.evaluate()</code> before launching <code>trainer.train()</code>, to avoid wasting lots of compute resources before hitting an error.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-g6yrru"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function br(f){let u,J="💡 If you’re using a manual training loop, the same steps apply to debug your training pipeline, but it’s easier to separate them. Make sure you have not forgotten the <code>model.eval()</code> or <code>model.train()</code> at the right places, or the <code>zero_grad()</code> at each step, however!";return{c(){u=i("p"),u.innerHTML=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-nq8rs"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function fr(f){let u,J="⚠️ If you are doing distributed training, print samples of your dataset in each process and triple-check that you get the same thing. One common bug is to have some source of randomness in the data creation that makes each process have a different version of the dataset.";return{c(){u=i("p"),u.textContent=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-19nz6fs"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function jr(f){let u,J="💡 If your training data is unbalanced, make sure to build a batch of training data containing all the labels.";return{c(){u=i("p"),u.textContent=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-ye7yyo"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function Tr(f){let u,J="⚠️ You will have to recreate your model and your <code>Trainer</code> after this test, as the model obtained probably won’t be able to recover and learn something useful on your full dataset.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=r(w,"P",{"data-svelte-h":!0}),o(u)!=="svelte-nhw6g4"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function Ur(f){let u,J,w,b,T,Ul,v,gl,B,kl,W,Un='You’ve written a beautiful script to train or fine-tune a model on a given task, dutifully following the advice from <a href="/course/chapter7">Chapter 7</a>. But when you launch the command <code>trainer.train()</code>, something horrible happens: you get an error 😱! Or worse, everything seems to be fine and the training runs without error, but the resulting model is crappy. In this section, we will show you what you can do to debug these kinds of issues.',$l,X,Cl,R,Zl,G,gn="The problem when you encounter an error in <code>trainer.train()</code> is that it could come from multiple sources, as the <code>Trainer</code> usually puts together lots of things. It converts datasets to dataloaders, so the problem could be something wrong in your dataset, or some issue when trying to batch elements of the datasets together. Then it takes a batch of data and feeds it to the model, so the problem could be in the model code. After that, it computes the gradients and performs the optimization step, so the problem could also be in your optimizer. And even if everything goes well for training, something could still go wrong during the evaluation if there is a problem with your metric.",Il,V,kn="The best way to debug an error that arises in <code>trainer.train()</code> is to manually go through this whole pipeline to see where things went awry. The error is then often very easy to solve.",vl,x,$n='To demonstrate this, we will use the following script that (tries to) fine-tune a DistilBERT model on the <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI dataset</a>:',Bl,_,Wl,Y,Cn="If you try to execute it, you will be met with a rather cryptic error:",Xl,A,Rl,F,Gl,H,Zn="This goes without saying, but if your data is corrupted, the <code>Trainer</code> is not going to be able to form batches, let alone train your model. So first things first, you need to have a look at what is inside your training set.",Vl,z,In="To avoid countless hours spent trying to fix something that is not the source of the bug, we recommend you use <code>trainer.train_dataset</code> for your checks and nothing else. So let’s do that here:",xl,Q,_l,N,Yl,E,vn="Do you notice something wrong? This, in conjunction with the error message about <code>input_ids</code> missing, should make you realize those are texts, not numbers the model can make sense of. Here, the original error is very misleading because the <code>Trainer</code> automatically removes the columns that don’t match the model signature (that is, the arguments expected by the model). That means here, everything apart from the labels was discarded. There was thus no issue with creating batches and then sending them to the model, which in turn complained it didn’t receive the proper input.",Al,S,Bn="Why wasn’t the data processed? We did use the <code>Dataset.map()</code> method on the datasets to apply the tokenizer on each sample. But if you look closely at the code, you will see that we made a mistake when passing the training and evaluation sets to the <code>Trainer</code>. Instead of using <code>tokenized_datasets</code> here, we used <code>raw_datasets</code> 🤦. So let’s fix this!",Fl,q,Hl,L,Wn="This new code will now give a different error (progress!):",zl,D,Ql,P,Xn="Looking at the traceback, we can see the error happens in the data collation step:",Nl,K,El,O,Rn="So, we should move to that. Before we do, however, let’s finish inspecting our data, just to be 100% sure it’s correct.",Sl,ee,Gn="One thing you should always do when debugging a training session is have a look at the decoded inputs of your model. We can’t make sense of the numbers that we feed it directly, so we should look at what those numbers represent. In computer vision, for example, that means looking at the decoded pictures of the pixels you pass, in speech it means listening to the decoded audio samples, and for our NLP example here it means using our tokenizer to decode the inputs:",ql,te,Ll,le,Dl,se,Vn="So that seems correct. You should do this for all the keys in the inputs:",Pl,ae,Kl,ne,Ol,ie,xn="Note that the keys that don’t correspond to inputs accepted by the model will be automatically discarded, so here we will only keep <code>input_ids</code>, <code>attention_mask</code>, and <code>label</code> (which will be renamed <code>labels</code>). To double-check the model signature, you can print the class of your model, then go check its documentation:",es,re,ts,oe,ls,pe,_n='So in our case, we can check the parameters accepted on <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">this page</a>. The <code>Trainer</code> will also log the columns it’s discarding.',ss,he,Yn="We have checked that the input IDs are correct by decoding them. Next is the <code>attention_mask</code>:",as,me,ns,de,is,Me,An="Since we didn’t apply padding in our preprocessing, this seems perfectly natural. To be sure there is no issue with that attention mask, let’s check it is the same length as our input IDs:",rs,ce,os,ue,ps,ye,Fn="That’s good! Lastly, let’s check our label:",hs,we,ms,Je,ds,be,Hn="Like the input IDs, this is a number that doesn’t really make sense on its own. As we saw before, the map between integers and label names is stored inside the <code>names</code> attribute of the corresponding <em>feature</em> of the dataset:",Ms,fe,cs,je,us,Te,zn="So <code>1</code> means <code>neutral</code>, which means the two sentences we saw above are not in contradiction, and the first one does not imply the second one. That seems correct!",ys,Ue,Qn="We don’t have token type IDs here, since DistilBERT does not expect them; if you have some in your model, you should also make sure that they properly match where the first and second sentences are in the input.",ws,U,Js,ge,Nn="We are only doing the check on the training set here, but you should of course double-check the validation and test sets the same way.",bs,ke,En="Now that we know our datasets look good, it’s time to check the next step of the training pipeline.",fs,$e,js,Ce,Sn="The next thing that can go wrong in the training pipeline is when the <code>Trainer</code> tries to form batches from the training or validation set. Once you are sure the <code>Trainer</code>’s datasets are correct, you can try to manually form a batch by executing the following (replace <code>train</code> with <code>eval</code> for the validation dataloader):",Ts,Ze,Us,Ie,qn="This code creates the training dataloader, then iterates through it, stopping at the first iteration. If the code executes without error, you have the first training batch that you can inspect, and if the code errors out, you know for sure the problem is in the dataloader, as is the case here:",gs,ve,ks,Be,Ln="Inspecting the last frame of the traceback should be enough to give you a clue, but let’s do a bit more digging. Most of the problems during batch creation arise because of the collation of examples into a single batch, so the first thing to check when in doubt is what <code>collate_fn</code> your <code>DataLoader</code> is using:",$s,We,Cs,Xe,Zs,Re,Dn="So this is the <code>default_data_collator</code>, but that’s not what we want in this case. We want to pad our examples to the longest sentence in the batch, which is done by the <code>DataCollatorWithPadding</code> collator. And this data collator is supposed to be used by default by the <code>Trainer</code>, so why is it not used here?",Is,Ge,Pn="The answer is because we did not pass the <code>tokenizer</code> to the <code>Trainer</code>, so it couldn’t create the <code>DataCollatorWithPadding</code> we want. In practice, you should never hesitate to explicitly pass along the data collator you want to use, to make sure you avoid these kinds of errors. Let’s adapt our code to do exactly that:",vs,Ve,Bs,xe,Kn="The good news? We don’t get the same error as before, which is definitely progress. The bad news? We get an infamous CUDA error instead:",Ws,_e,Xs,Ye,On="This is bad because CUDA errors are extremely hard to debug in general. We will see in a minute how to solve this, but first let’s finish our analysis of batch creation.",Rs,Ae,ei="If you are sure your data collator is the right one, you should try to apply it on a couple of samples of your dataset:",Gs,Fe,Vs,He,ti="This code will fail because the <code>train_dataset</code> contains string columns, which the <code>Trainer</code> usually removes. You can remove them manually, or if you want to replicate exactly what the <code>Trainer</code> is doing behind the scenes, you can call the private <code>Trainer._remove_unused_columns()</code> method that does that:",xs,ze,_s,Qe,li="You should then be able to manually debug what happens inside the data collator if the error persists.",Ys,Ne,si="Now that we’ve debugged the batch creation process, it’s time to pass one through the model!",As,Ee,Fs,Se,ai="You should be able to get a batch by executing the following command:",Hs,qe,zs,Le,ni="If you’re running this code in a notebook, you may get a CUDA error that’s similar to the one we saw earlier, in which case you need to restart your notebook and reexecute the last snippet without the <code>trainer.train()</code> line. That’s the second most annoying thing about CUDA errors: they irremediably break your kernel. The most annoying thing about them is the fact that they are hard to debug.",Qs,De,ii="Why is that? It has to do with the way GPUs work. They are extremely efficient at executing a lot of operations in parallel, but the drawback is that when one of those instructions results in an error, you don’t know it instantly. It’s only when the program calls a synchronization of the multiple processes on the GPU that it will realize something went wrong, so the error is actually raised at a place that has nothing to do with what created it. For instance, if we look at our previous traceback, the error was raised during the backward pass, but we will see in a minute that it actually stems from something in the forward pass.",Ns,Pe,ri="So how do we debug those errors? The answer is easy: we don’t. Unless your CUDA error is an out-of-memory error (which means there is not enough memory in your GPU), you should always go back to the CPU to debug it.",Es,Ke,oi="To do this in our case, we just have to put the model back on the CPU and call it on our batch — the batch returned by the <code>DataLoader</code> has not been moved to the GPU yet:",Ss,Oe,qs,et,Ls,tt,pi="So, the picture is getting clearer. Instead of having a CUDA error, we now have an <code>IndexError</code> in the loss computation (so nothing to do with the backward pass, as we said earlier). More precisely, we can see that it’s target 2 that creates the error, so this is a very good moment to check the number of labels of our model:",Ds,lt,Ps,st,Ks,at,hi="With two labels, only 0s and 1s are allowed as targets, but according to the error message we got a 2. Getting a 2 is actually normal: if we remember the label names we extracted earlier, there were three, so we have indices 0, 1, and 2 in our dataset. The problem is that we didn’t tell that to our model, which should have been created with three labels. So let’s fix that!",Os,nt,ea,it,mi="We aren’t including the <code>trainer.train()</code> line yet, to take the time to check that everything looks good. If we request a batch and pass it to our model, it now works without error!",ta,rt,la,ot,di="The next step is then to move back to the GPU and check that everything still works:",sa,pt,aa,ht,Mi="If you still get an error, make sure you restart your notebook and only execute the last version of the script.",na,mt,ia,dt,ci="Now that we know that we can build batches that actually go through the model, we are ready for the next step of the training pipeline: computing the gradients and performing an optimization step.",ra,Mt,ui="The first part is just a matter of calling the <code>backward()</code> method on the loss:",oa,ct,pa,ut,yi="It’s pretty rare to get an error at this stage, but if you do get one, make sure to go back to the CPU to get a helpful error message.",ha,yt,wi="To perform the optimization step, we just need to create the <code>optimizer</code> and call its <code>step()</code> method:",ma,wt,da,Jt,Ji="Again, if you’re using the default optimizer in the <code>Trainer</code>, you shouldn’t get an error at this stage, but if you have a custom optimizer, there might be some problems to debug here. Don’t forget to go back to the CPU if you get a weird CUDA error at this stage. Speaking of CUDA errors, earlier we mentioned a special case. Let’s have a look at that now.",Ma,bt,ca,ft,bi="Whenever you get an error message that starts with <code>RuntimeError: CUDA out of memory</code>, this indicates that you are out of GPU memory. This is not directly linked to your code, and it can happen with a script that runs perfectly fine. This error means that you tried to put too many things in the internal memory of your GPU, and that resulted in an error. Like with other CUDA errors, you will need to restart your kernel to be in a spot where you can run your training again.",ua,jt,fi="To solve this issue, you just need to use less GPU space — something that is often easier said than done. First, make sure you don’t have two models on the GPU at the same time (unless that’s required for your problem, of course). Then, you should probably reduce your batch size, as it directly affects the sizes of all the intermediate outputs of the model and their gradients. If the problem persists, consider using a smaller version of your model.",ya,g,wa,Tt,Ja,Ut,ji="Now that we’ve solved all the issues with our code, everything is perfect and the training should run smoothly, right? Not so fast! If you run the <code>trainer.train()</code> command, everything will look good at first, but after a while you will get the following:",ba,gt,fa,kt,ja,$t,Ti="You will realize this error appears during the evaluation phase, so this is the last thing we will need to debug.",Ta,Ct,Ui="You can run the evaluation loop of the <code>Trainer</code> independently form the training like this:",Ua,Zt,ga,It,ka,k,$a,vt,gi="Before attempting to debug a problem in the evaluation loop, you should first make sure that you’ve had a look at the data, are able to form a batch properly, and can run your model on it. We’ve completed all of those steps, so the following code can be executed without error:",Ca,Bt,Za,Wt,ki="The error comes later, at the end of the evaluation phase, and if we look at the traceback we see this:",Ia,Xt,va,Rt,$i="This tells us that the error originates in the <code>datasets/metric.py</code> module — so this is a problem with our <code>compute_metrics()</code> function. It takes a tuple with the logits and the labels as NumPy arrays, so let’s try to feed it that:",Ba,Gt,Wa,Vt,Xa,xt,Ci="We get the same error, so the problem definitely lies with that function. If we look back at its code, we see it’s just forwarding the <code>predictions</code> and the <code>labels</code> to <code>metric.compute()</code>. So is there a problem with that method? Not really. Let’s have a quick look at the shapes:",Ra,_t,Ga,Yt,Va,At,Zi="Our predictions are still logits, not the actual predictions, which is why the metric is returning this (somewhat obscure) error. The fix is pretty easy; we just have to add an argmax in the <code>compute_metrics()</code> function:",xa,Ft,_a,Ht,Ya,zt,Ii="Now our error is fixed! This was the last one, so our script will now train a model properly.",Aa,Qt,vi="For reference, here is the completely fixed script:",Fa,Nt,Ha,Et,Bi="In this instance, there are no more problems, and our script will fine-tune a model that should give reasonable results. But what can we do when the training proceeds without any error, and the model trained does not perform well at all? That’s the hardest part of machine learning, and we’ll show you a few techniques that can help.",za,$,Qa,St,Na,qt,Wi="What can we do to debug a training that completes without error but doesn’t get good results? We’ll give you some pointers here, but be aware that this kind of debugging is the hardest part of machine learning, and there is no magical answer.",Ea,Lt,Sa,Dt,Xi="Your model will only learn something if it’s actually possible to learn anything from your data. If there is a bug that corrupts the data or the labels are attributed randomly, it’s very likely you won’t get any model training on your dataset. So always start by double-checking your decoded inputs and labels, and ask yourself the following questions:",qa,Pt,Ri="<li>Is the decoded data understandable?</li> <li>Do you agree with the labels?</li> <li>Is there one label that’s more common than the others?</li> <li>What should the loss/metric be if the model predicted a random answer/always the same answer?</li>",La,C,Da,Kt,Gi="After looking at your data, go through a few of the model’s predictions and decode them too. If the model is always predicting the same thing, it might be because your dataset is biased toward one category (for classification problems); techniques like oversampling rare classes might help.",Pa,Ot,Vi="If the loss/metric you get on your initial model is very different from the loss/metric you would expect for random predictions, double-check the way your loss or metric is computed, as there is probably a bug there. If you are using several losses that you add at the end, make sure they are of the same scale.",Ka,el,xi="When you are sure your data is perfect, you can see if the model is capable of training on it with one simple test.",Oa,tl,en,ll,_i="Overfitting is usually something we try to avoid when training, as it means the model is not learning to recognize the general features we want it to but is instead just memorizing the training samples. However, trying to train your model on one batch over and over again is a good test to check if the problem as you framed it can be solved by the model you are attempting to train. It will also help you see if your initial learning rate is too high.",tn,sl,Yi="Doing this once you have defined your <code>Trainer</code> is really easy; just grab a batch of training data, then run a small manual training loop only using that batch for something like 20 steps:",ln,al,sn,Z,an,nl,Ai="The resulting model should have close-to-perfect results on the same <code>batch</code>. Let’s compute the metric on the resulting predictions:",nn,il,rn,rl,on,ol,Fi="100% accuracy, now this is a nice example of overfitting (meaning that if you try your model on any other sentence, it will very likely give you a wrong answer)!",pn,pl,Hi="If you don’t manage to have your model obtain perfect results like this, it means there is something wrong with the way you framed the problem or your data, so you should fix that. Only when you manage to pass the overfitting test can you be sure that your model can actually learn something.",hn,I,mn,hl,dn,ml,zi="Hyperparameter tuning is always emphasized as being the hardest part of machine learning, but it’s just the last step to help you gain a little bit on the metric. Most of the time, the default hyperparameters of the <code>Trainer</code> will work just fine to give you good results, so don’t launch into a time-consuming and costly hyperparameter search until you have something that beats the baseline you have on your dataset.",Mn,dl,Qi="Once you have a good enough model, you can start tweaking a bit. Don’t try launching a thousand runs with different hyperparameters, but compare a couple of runs with different values for one hyperparameter to get an idea of which has the greatest impact.",cn,Ml,Ni="If you are tweaking the model itself, keep it simple and don’t try anything you can’t reasonably justify. Always make sure you go back to the overfitting test to verify that your change hasn’t had any unintended consequences.",un,cl,yn,ul,Ei='Hopefully you will have found some advice in this section that helped you solve your issue, but if that’s not the case, remember you can always ask the community on the <a href="https://discuss.huggingface.co/" rel="nofollow">forums</a>.',wn,yl,Si="Here are some additional resources that may prove helpful:",Jn,wl,qi='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> by Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> by Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> by Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> by Andrej Karpathy</li>',bn,Jl,Li="Of course, not every problem you encounter when training neural nets is your own fault! If you encounter something in the 🤗 Transformers or 🤗 Datasets library that does not seem right, you may have encountered a bug. You should definitely tell us all about it, and in the next section we’ll explain exactly how to do that.",fn,bl,jn,Tl,Tn;return T=new cr({props:{fw:f[0]}}),v=new j({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h1"}}),B=new Mr({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"}]}}),X=new j({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h2"}}),R=new dr({props:{id:"L-WSwUWde1U"}}),_=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),A=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),F=new j({props:{title:"Check your data",local:"check-your-data",headingTag:"h3"}}),Q=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),N=new y({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),q=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),D=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),K=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),te=new y({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),le=new y({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ae=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ne=new y({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),re=new y({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),oe=new y({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),me=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),de=new y({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),ce=new y({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),ue=new y({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),we=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),Je=new y({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),fe=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),je=new y({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new fl({props:{$$slots:{default:[yr]},$$scope:{ctx:f}}}),$e=new j({props:{title:"From datasets to dataloaders",local:"from-datasets-to-dataloaders",headingTag:"h3"}}),Ze=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),ve=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),We=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Xe=new y({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ve=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),_e=new y({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Fe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),ze=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Ee=new j({props:{title:"Going through the model",local:"going-through-the-model",headingTag:"h3"}}),qe=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Oe=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),et=new y({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),lt=new y({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),st=new y({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),rt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),pt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),mt=new j({props:{title:"Performing one optimization step",local:"performing-one-optimization-step",headingTag:"h3"}}),ct=new y({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),wt=new y({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),bt=new j({props:{title:"Dealing with CUDA out-of-memory errors",local:"dealing-with-cuda-out-of-memory-errors",headingTag:"h3"}}),g=new fl({props:{$$slots:{default:[wr]},$$scope:{ctx:f}}}),Tt=new j({props:{title:"Evaluating the model",local:"evaluating-the-model",headingTag:"h3"}}),gt=new y({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjB0YWtlJTIwYSUyMGxvbmclMjB0aW1lJTIwYW5kJTIwZXJyb3IlMjBvdXQlMkMlMjBzbyUyMHlvdSUyMHNob3VsZG4ndCUyMHJ1biUyMHRoaXMlMjBjZWxsJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># This will take a long time and error out, so you shouldn&#x27;t run this cell</span>
trainer.train()`,wrap:!1}}),kt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),Zt=new y({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),It=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),k=new fl({props:{$$slots:{default:[Jr]},$$scope:{ctx:f}}}),Bt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Xt=new y({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),Gt=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Vt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),_t=new y({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),Yt=new y({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),Ft=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Ht=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),$=new fl({props:{$$slots:{default:[br]},$$scope:{ctx:f}}}),St=new j({props:{title:"Debugging silent errors during training",local:"debugging-silent-errors-during-training",headingTag:"h2"}}),Lt=new j({props:{title:"Check your data (again!)",local:"check-your-data-again",headingTag:"h3"}}),C=new fl({props:{warning:!0,$$slots:{default:[fr]},$$scope:{ctx:f}}}),tl=new j({props:{title:"Overfit your model on one batch",local:"overfit-your-model-on-one-batch",headingTag:"h3"}}),al=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),Z=new fl({props:{$$slots:{default:[jr]},$$scope:{ctx:f}}}),il=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),rl=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),I=new fl({props:{warning:!0,$$slots:{default:[Tr]},$$scope:{ctx:f}}}),hl=new j({props:{title:"Don’t tune anything until you have a first baseline",local:"dont-tune-anything-until-you-have-a-first-baseline",headingTag:"h3"}}),cl=new j({props:{title:"Ask for help",local:"ask-for-help",headingTag:"h3"}}),bl=new ur({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter8/4.mdx"}}),{c(){u=i("meta"),J=a(),w=i("p"),b=a(),p(T.$$.fragment),Ul=a(),p(v.$$.fragment),gl=a(),p(B.$$.fragment),kl=a(),W=i("p"),W.innerHTML=Un,$l=a(),p(X.$$.fragment),Cl=a(),p(R.$$.fragment),Zl=a(),G=i("p"),G.innerHTML=gn,Il=a(),V=i("p"),V.innerHTML=kn,vl=a(),x=i("p"),x.innerHTML=$n,Bl=a(),p(_.$$.fragment),Wl=a(),Y=i("p"),Y.textContent=Cn,Xl=a(),p(A.$$.fragment),Rl=a(),p(F.$$.fragment),Gl=a(),H=i("p"),H.innerHTML=Zn,Vl=a(),z=i("p"),z.innerHTML=In,xl=a(),p(Q.$$.fragment),_l=a(),p(N.$$.fragment),Yl=a(),E=i("p"),E.innerHTML=vn,Al=a(),S=i("p"),S.innerHTML=Bn,Fl=a(),p(q.$$.fragment),Hl=a(),L=i("p"),L.textContent=Wn,zl=a(),p(D.$$.fragment),Ql=a(),P=i("p"),P.textContent=Xn,Nl=a(),p(K.$$.fragment),El=a(),O=i("p"),O.textContent=Rn,Sl=a(),ee=i("p"),ee.textContent=Gn,ql=a(),p(te.$$.fragment),Ll=a(),p(le.$$.fragment),Dl=a(),se=i("p"),se.textContent=Vn,Pl=a(),p(ae.$$.fragment),Kl=a(),p(ne.$$.fragment),Ol=a(),ie=i("p"),ie.innerHTML=xn,es=a(),p(re.$$.fragment),ts=a(),p(oe.$$.fragment),ls=a(),pe=i("p"),pe.innerHTML=_n,ss=a(),he=i("p"),he.innerHTML=Yn,as=a(),p(me.$$.fragment),ns=a(),p(de.$$.fragment),is=a(),Me=i("p"),Me.textContent=An,rs=a(),p(ce.$$.fragment),os=a(),p(ue.$$.fragment),ps=a(),ye=i("p"),ye.textContent=Fn,hs=a(),p(we.$$.fragment),ms=a(),p(Je.$$.fragment),ds=a(),be=i("p"),be.innerHTML=Hn,Ms=a(),p(fe.$$.fragment),cs=a(),p(je.$$.fragment),us=a(),Te=i("p"),Te.innerHTML=zn,ys=a(),Ue=i("p"),Ue.textContent=Qn,ws=a(),p(U.$$.fragment),Js=a(),ge=i("p"),ge.textContent=Nn,bs=a(),ke=i("p"),ke.textContent=En,fs=a(),p($e.$$.fragment),js=a(),Ce=i("p"),Ce.innerHTML=Sn,Ts=a(),p(Ze.$$.fragment),Us=a(),Ie=i("p"),Ie.textContent=qn,gs=a(),p(ve.$$.fragment),ks=a(),Be=i("p"),Be.innerHTML=Ln,$s=a(),p(We.$$.fragment),Cs=a(),p(Xe.$$.fragment),Zs=a(),Re=i("p"),Re.innerHTML=Dn,Is=a(),Ge=i("p"),Ge.innerHTML=Pn,vs=a(),p(Ve.$$.fragment),Bs=a(),xe=i("p"),xe.textContent=Kn,Ws=a(),p(_e.$$.fragment),Xs=a(),Ye=i("p"),Ye.textContent=On,Rs=a(),Ae=i("p"),Ae.textContent=ei,Gs=a(),p(Fe.$$.fragment),Vs=a(),He=i("p"),He.innerHTML=ti,xs=a(),p(ze.$$.fragment),_s=a(),Qe=i("p"),Qe.textContent=li,Ys=a(),Ne=i("p"),Ne.textContent=si,As=a(),p(Ee.$$.fragment),Fs=a(),Se=i("p"),Se.textContent=ai,Hs=a(),p(qe.$$.fragment),zs=a(),Le=i("p"),Le.innerHTML=ni,Qs=a(),De=i("p"),De.textContent=ii,Ns=a(),Pe=i("p"),Pe.textContent=ri,Es=a(),Ke=i("p"),Ke.innerHTML=oi,Ss=a(),p(Oe.$$.fragment),qs=a(),p(et.$$.fragment),Ls=a(),tt=i("p"),tt.innerHTML=pi,Ds=a(),p(lt.$$.fragment),Ps=a(),p(st.$$.fragment),Ks=a(),at=i("p"),at.textContent=hi,Os=a(),p(nt.$$.fragment),ea=a(),it=i("p"),it.innerHTML=mi,ta=a(),p(rt.$$.fragment),la=a(),ot=i("p"),ot.textContent=di,sa=a(),p(pt.$$.fragment),aa=a(),ht=i("p"),ht.textContent=Mi,na=a(),p(mt.$$.fragment),ia=a(),dt=i("p"),dt.textContent=ci,ra=a(),Mt=i("p"),Mt.innerHTML=ui,oa=a(),p(ct.$$.fragment),pa=a(),ut=i("p"),ut.textContent=yi,ha=a(),yt=i("p"),yt.innerHTML=wi,ma=a(),p(wt.$$.fragment),da=a(),Jt=i("p"),Jt.innerHTML=Ji,Ma=a(),p(bt.$$.fragment),ca=a(),ft=i("p"),ft.innerHTML=bi,ua=a(),jt=i("p"),jt.textContent=fi,ya=a(),p(g.$$.fragment),wa=a(),p(Tt.$$.fragment),Ja=a(),Ut=i("p"),Ut.innerHTML=ji,ba=a(),p(gt.$$.fragment),fa=a(),p(kt.$$.fragment),ja=a(),$t=i("p"),$t.textContent=Ti,Ta=a(),Ct=i("p"),Ct.innerHTML=Ui,Ua=a(),p(Zt.$$.fragment),ga=a(),p(It.$$.fragment),ka=a(),p(k.$$.fragment),$a=a(),vt=i("p"),vt.textContent=gi,Ca=a(),p(Bt.$$.fragment),Za=a(),Wt=i("p"),Wt.textContent=ki,Ia=a(),p(Xt.$$.fragment),va=a(),Rt=i("p"),Rt.innerHTML=$i,Ba=a(),p(Gt.$$.fragment),Wa=a(),p(Vt.$$.fragment),Xa=a(),xt=i("p"),xt.innerHTML=Ci,Ra=a(),p(_t.$$.fragment),Ga=a(),p(Yt.$$.fragment),Va=a(),At=i("p"),At.innerHTML=Zi,xa=a(),p(Ft.$$.fragment),_a=a(),p(Ht.$$.fragment),Ya=a(),zt=i("p"),zt.textContent=Ii,Aa=a(),Qt=i("p"),Qt.textContent=vi,Fa=a(),p(Nt.$$.fragment),Ha=a(),Et=i("p"),Et.textContent=Bi,za=a(),p($.$$.fragment),Qa=a(),p(St.$$.fragment),Na=a(),qt=i("p"),qt.textContent=Wi,Ea=a(),p(Lt.$$.fragment),Sa=a(),Dt=i("p"),Dt.textContent=Xi,qa=a(),Pt=i("ul"),Pt.innerHTML=Ri,La=a(),p(C.$$.fragment),Da=a(),Kt=i("p"),Kt.textContent=Gi,Pa=a(),Ot=i("p"),Ot.textContent=Vi,Ka=a(),el=i("p"),el.textContent=xi,Oa=a(),p(tl.$$.fragment),en=a(),ll=i("p"),ll.textContent=_i,tn=a(),sl=i("p"),sl.innerHTML=Yi,ln=a(),p(al.$$.fragment),sn=a(),p(Z.$$.fragment),an=a(),nl=i("p"),nl.innerHTML=Ai,nn=a(),p(il.$$.fragment),rn=a(),p(rl.$$.fragment),on=a(),ol=i("p"),ol.textContent=Fi,pn=a(),pl=i("p"),pl.textContent=Hi,hn=a(),p(I.$$.fragment),mn=a(),p(hl.$$.fragment),dn=a(),ml=i("p"),ml.innerHTML=zi,Mn=a(),dl=i("p"),dl.textContent=Qi,cn=a(),Ml=i("p"),Ml.textContent=Ni,un=a(),p(cl.$$.fragment),yn=a(),ul=i("p"),ul.innerHTML=Ei,wn=a(),yl=i("p"),yl.textContent=Si,Jn=a(),wl=i("ul"),wl.innerHTML=qi,bn=a(),Jl=i("p"),Jl.textContent=Li,fn=a(),p(bl.$$.fragment),jn=a(),Tl=i("p"),this.h()},l(e){const t=hr("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),w=r(e,"P",{}),ar(w).forEach(l),b=n(e),h(T.$$.fragment,e),Ul=n(e),h(v.$$.fragment,e),gl=n(e),h(B.$$.fragment,e),kl=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ytuhj4"&&(W.innerHTML=Un),$l=n(e),h(X.$$.fragment,e),Cl=n(e),h(R.$$.fragment,e),Zl=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-tnyumb"&&(G.innerHTML=gn),Il=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-hzxl7e"&&(V.innerHTML=kn),vl=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-q32aak"&&(x.innerHTML=$n),Bl=n(e),h(_.$$.fragment,e),Wl=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-3pg78t"&&(Y.textContent=Cn),Xl=n(e),h(A.$$.fragment,e),Rl=n(e),h(F.$$.fragment,e),Gl=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-gzpow8"&&(H.innerHTML=Zn),Vl=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-3sg9xy"&&(z.innerHTML=In),xl=n(e),h(Q.$$.fragment,e),_l=n(e),h(N.$$.fragment,e),Yl=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-6jps2k"&&(E.innerHTML=vn),Al=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1wolr01"&&(S.innerHTML=Bn),Fl=n(e),h(q.$$.fragment,e),Hl=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1k94mat"&&(L.textContent=Wn),zl=n(e),h(D.$$.fragment,e),Ql=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1tmbf0v"&&(P.textContent=Xn),Nl=n(e),h(K.$$.fragment,e),El=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-10gbmtc"&&(O.textContent=Rn),Sl=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4qxohk"&&(ee.textContent=Gn),ql=n(e),h(te.$$.fragment,e),Ll=n(e),h(le.$$.fragment,e),Dl=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1dgrscj"&&(se.textContent=Vn),Pl=n(e),h(ae.$$.fragment,e),Kl=n(e),h(ne.$$.fragment,e),Ol=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1ojy6k7"&&(ie.innerHTML=xn),es=n(e),h(re.$$.fragment,e),ts=n(e),h(oe.$$.fragment,e),ls=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1xoucm3"&&(pe.innerHTML=_n),ss=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-5x641b"&&(he.innerHTML=Yn),as=n(e),h(me.$$.fragment,e),ns=n(e),h(de.$$.fragment,e),is=n(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1pojahx"&&(Me.textContent=An),rs=n(e),h(ce.$$.fragment,e),os=n(e),h(ue.$$.fragment,e),ps=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-9qe8oh"&&(ye.textContent=Fn),hs=n(e),h(we.$$.fragment,e),ms=n(e),h(Je.$$.fragment,e),ds=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-z61tvp"&&(be.innerHTML=Hn),Ms=n(e),h(fe.$$.fragment,e),cs=n(e),h(je.$$.fragment,e),us=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-tigzcg"&&(Te.innerHTML=zn),ys=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1d4x6k6"&&(Ue.textContent=Qn),ws=n(e),h(U.$$.fragment,e),Js=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1n42cxl"&&(ge.textContent=Nn),bs=n(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-j9xc0o"&&(ke.textContent=En),fs=n(e),h($e.$$.fragment,e),js=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-dmtbok"&&(Ce.innerHTML=Sn),Ts=n(e),h(Ze.$$.fragment,e),Us=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-78cxp3"&&(Ie.textContent=qn),gs=n(e),h(ve.$$.fragment,e),ks=n(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1g50zb3"&&(Be.innerHTML=Ln),$s=n(e),h(We.$$.fragment,e),Cs=n(e),h(Xe.$$.fragment,e),Zs=n(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-6x08fd"&&(Re.innerHTML=Dn),Is=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-il2k2h"&&(Ge.innerHTML=Pn),vs=n(e),h(Ve.$$.fragment,e),Bs=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-ijqm5z"&&(xe.textContent=Kn),Ws=n(e),h(_e.$$.fragment,e),Xs=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1a7o2xm"&&(Ye.textContent=On),Rs=n(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-11i1sfm"&&(Ae.textContent=ei),Gs=n(e),h(Fe.$$.fragment,e),Vs=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-41j77u"&&(He.innerHTML=ti),xs=n(e),h(ze.$$.fragment,e),_s=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1f68fby"&&(Qe.textContent=li),Ys=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1jk0zgp"&&(Ne.textContent=si),As=n(e),h(Ee.$$.fragment,e),Fs=n(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-17wdfhf"&&(Se.textContent=ai),Hs=n(e),h(qe.$$.fragment,e),zs=n(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1otof6i"&&(Le.innerHTML=ni),Qs=n(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-zojoe4"&&(De.textContent=ii),Ns=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-3hnmla"&&(Pe.textContent=ri),Es=n(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1f20ywv"&&(Ke.innerHTML=oi),Ss=n(e),h(Oe.$$.fragment,e),qs=n(e),h(et.$$.fragment,e),Ls=n(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1d72w7m"&&(tt.innerHTML=pi),Ds=n(e),h(lt.$$.fragment,e),Ps=n(e),h(st.$$.fragment,e),Ks=n(e),at=r(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1kos5jb"&&(at.textContent=hi),Os=n(e),h(nt.$$.fragment,e),ea=n(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-dvos0i"&&(it.innerHTML=mi),ta=n(e),h(rt.$$.fragment,e),la=n(e),ot=r(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1mlispf"&&(ot.textContent=di),sa=n(e),h(pt.$$.fragment,e),aa=n(e),ht=r(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1ofmtfm"&&(ht.textContent=Mi),na=n(e),h(mt.$$.fragment,e),ia=n(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1jisdcu"&&(dt.textContent=ci),ra=n(e),Mt=r(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-tjcz1h"&&(Mt.innerHTML=ui),oa=n(e),h(ct.$$.fragment,e),pa=n(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1rq3476"&&(ut.textContent=yi),ha=n(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-9h4y7g"&&(yt.innerHTML=wi),ma=n(e),h(wt.$$.fragment,e),da=n(e),Jt=r(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1yyc42o"&&(Jt.innerHTML=Ji),Ma=n(e),h(bt.$$.fragment,e),ca=n(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-126rjjn"&&(ft.innerHTML=bi),ua=n(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-18vu150"&&(jt.textContent=fi),ya=n(e),h(g.$$.fragment,e),wa=n(e),h(Tt.$$.fragment,e),Ja=n(e),Ut=r(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-2gm1u9"&&(Ut.innerHTML=ji),ba=n(e),h(gt.$$.fragment,e),fa=n(e),h(kt.$$.fragment,e),ja=n(e),$t=r(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-im7b67"&&($t.textContent=Ti),Ta=n(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1doyjwq"&&(Ct.innerHTML=Ui),Ua=n(e),h(Zt.$$.fragment,e),ga=n(e),h(It.$$.fragment,e),ka=n(e),h(k.$$.fragment,e),$a=n(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1nz2xql"&&(vt.textContent=gi),Ca=n(e),h(Bt.$$.fragment,e),Za=n(e),Wt=r(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-ffb80c"&&(Wt.textContent=ki),Ia=n(e),h(Xt.$$.fragment,e),va=n(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1rvvrss"&&(Rt.innerHTML=$i),Ba=n(e),h(Gt.$$.fragment,e),Wa=n(e),h(Vt.$$.fragment,e),Xa=n(e),xt=r(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-12tu8pl"&&(xt.innerHTML=Ci),Ra=n(e),h(_t.$$.fragment,e),Ga=n(e),h(Yt.$$.fragment,e),Va=n(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-nr86wp"&&(At.innerHTML=Zi),xa=n(e),h(Ft.$$.fragment,e),_a=n(e),h(Ht.$$.fragment,e),Ya=n(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-26f203"&&(zt.textContent=Ii),Aa=n(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-lmu6ng"&&(Qt.textContent=vi),Fa=n(e),h(Nt.$$.fragment,e),Ha=n(e),Et=r(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-14dxkx4"&&(Et.textContent=Bi),za=n(e),h($.$$.fragment,e),Qa=n(e),h(St.$$.fragment,e),Na=n(e),qt=r(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-ejwpcu"&&(qt.textContent=Wi),Ea=n(e),h(Lt.$$.fragment,e),Sa=n(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-12i4wz3"&&(Dt.textContent=Xi),qa=n(e),Pt=r(e,"UL",{"data-svelte-h":!0}),o(Pt)!=="svelte-1m9el5s"&&(Pt.innerHTML=Ri),La=n(e),h(C.$$.fragment,e),Da=n(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1u3f40c"&&(Kt.textContent=Gi),Pa=n(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1122ld9"&&(Ot.textContent=Vi),Ka=n(e),el=r(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-8qgi72"&&(el.textContent=xi),Oa=n(e),h(tl.$$.fragment,e),en=n(e),ll=r(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-ud8t14"&&(ll.textContent=_i),tn=n(e),sl=r(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-mho0en"&&(sl.innerHTML=Yi),ln=n(e),h(al.$$.fragment,e),sn=n(e),h(Z.$$.fragment,e),an=n(e),nl=r(e,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-zb5hop"&&(nl.innerHTML=Ai),nn=n(e),h(il.$$.fragment,e),rn=n(e),h(rl.$$.fragment,e),on=n(e),ol=r(e,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-ccee5n"&&(ol.textContent=Fi),pn=n(e),pl=r(e,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-1appsmg"&&(pl.textContent=Hi),hn=n(e),h(I.$$.fragment,e),mn=n(e),h(hl.$$.fragment,e),dn=n(e),ml=r(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1inlulo"&&(ml.innerHTML=zi),Mn=n(e),dl=r(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-ngq5bm"&&(dl.textContent=Qi),cn=n(e),Ml=r(e,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-17qlrbw"&&(Ml.textContent=Ni),un=n(e),h(cl.$$.fragment,e),yn=n(e),ul=r(e,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1kejrvw"&&(ul.innerHTML=Ei),wn=n(e),yl=r(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-1wt0l4q"&&(yl.textContent=Si),Jn=n(e),wl=r(e,"UL",{"data-svelte-h":!0}),o(wl)!=="svelte-vkgmp2"&&(wl.innerHTML=qi),bn=n(e),Jl=r(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-vjjrmr"&&(Jl.textContent=Li),fn=n(e),h(bl.$$.fragment,e),jn=n(e),Tl=r(e,"P",{}),ar(Tl).forEach(l),this.h()},h(){nr(u,"name","hf:doc:metadata"),nr(u,"content",gr)},m(e,t){mr(document.head,u),s(e,J,t),s(e,w,t),s(e,b,t),m(T,e,t),s(e,Ul,t),m(v,e,t),s(e,gl,t),m(B,e,t),s(e,kl,t),s(e,W,t),s(e,$l,t),m(X,e,t),s(e,Cl,t),m(R,e,t),s(e,Zl,t),s(e,G,t),s(e,Il,t),s(e,V,t),s(e,vl,t),s(e,x,t),s(e,Bl,t),m(_,e,t),s(e,Wl,t),s(e,Y,t),s(e,Xl,t),m(A,e,t),s(e,Rl,t),m(F,e,t),s(e,Gl,t),s(e,H,t),s(e,Vl,t),s(e,z,t),s(e,xl,t),m(Q,e,t),s(e,_l,t),m(N,e,t),s(e,Yl,t),s(e,E,t),s(e,Al,t),s(e,S,t),s(e,Fl,t),m(q,e,t),s(e,Hl,t),s(e,L,t),s(e,zl,t),m(D,e,t),s(e,Ql,t),s(e,P,t),s(e,Nl,t),m(K,e,t),s(e,El,t),s(e,O,t),s(e,Sl,t),s(e,ee,t),s(e,ql,t),m(te,e,t),s(e,Ll,t),m(le,e,t),s(e,Dl,t),s(e,se,t),s(e,Pl,t),m(ae,e,t),s(e,Kl,t),m(ne,e,t),s(e,Ol,t),s(e,ie,t),s(e,es,t),m(re,e,t),s(e,ts,t),m(oe,e,t),s(e,ls,t),s(e,pe,t),s(e,ss,t),s(e,he,t),s(e,as,t),m(me,e,t),s(e,ns,t),m(de,e,t),s(e,is,t),s(e,Me,t),s(e,rs,t),m(ce,e,t),s(e,os,t),m(ue,e,t),s(e,ps,t),s(e,ye,t),s(e,hs,t),m(we,e,t),s(e,ms,t),m(Je,e,t),s(e,ds,t),s(e,be,t),s(e,Ms,t),m(fe,e,t),s(e,cs,t),m(je,e,t),s(e,us,t),s(e,Te,t),s(e,ys,t),s(e,Ue,t),s(e,ws,t),m(U,e,t),s(e,Js,t),s(e,ge,t),s(e,bs,t),s(e,ke,t),s(e,fs,t),m($e,e,t),s(e,js,t),s(e,Ce,t),s(e,Ts,t),m(Ze,e,t),s(e,Us,t),s(e,Ie,t),s(e,gs,t),m(ve,e,t),s(e,ks,t),s(e,Be,t),s(e,$s,t),m(We,e,t),s(e,Cs,t),m(Xe,e,t),s(e,Zs,t),s(e,Re,t),s(e,Is,t),s(e,Ge,t),s(e,vs,t),m(Ve,e,t),s(e,Bs,t),s(e,xe,t),s(e,Ws,t),m(_e,e,t),s(e,Xs,t),s(e,Ye,t),s(e,Rs,t),s(e,Ae,t),s(e,Gs,t),m(Fe,e,t),s(e,Vs,t),s(e,He,t),s(e,xs,t),m(ze,e,t),s(e,_s,t),s(e,Qe,t),s(e,Ys,t),s(e,Ne,t),s(e,As,t),m(Ee,e,t),s(e,Fs,t),s(e,Se,t),s(e,Hs,t),m(qe,e,t),s(e,zs,t),s(e,Le,t),s(e,Qs,t),s(e,De,t),s(e,Ns,t),s(e,Pe,t),s(e,Es,t),s(e,Ke,t),s(e,Ss,t),m(Oe,e,t),s(e,qs,t),m(et,e,t),s(e,Ls,t),s(e,tt,t),s(e,Ds,t),m(lt,e,t),s(e,Ps,t),m(st,e,t),s(e,Ks,t),s(e,at,t),s(e,Os,t),m(nt,e,t),s(e,ea,t),s(e,it,t),s(e,ta,t),m(rt,e,t),s(e,la,t),s(e,ot,t),s(e,sa,t),m(pt,e,t),s(e,aa,t),s(e,ht,t),s(e,na,t),m(mt,e,t),s(e,ia,t),s(e,dt,t),s(e,ra,t),s(e,Mt,t),s(e,oa,t),m(ct,e,t),s(e,pa,t),s(e,ut,t),s(e,ha,t),s(e,yt,t),s(e,ma,t),m(wt,e,t),s(e,da,t),s(e,Jt,t),s(e,Ma,t),m(bt,e,t),s(e,ca,t),s(e,ft,t),s(e,ua,t),s(e,jt,t),s(e,ya,t),m(g,e,t),s(e,wa,t),m(Tt,e,t),s(e,Ja,t),s(e,Ut,t),s(e,ba,t),m(gt,e,t),s(e,fa,t),m(kt,e,t),s(e,ja,t),s(e,$t,t),s(e,Ta,t),s(e,Ct,t),s(e,Ua,t),m(Zt,e,t),s(e,ga,t),m(It,e,t),s(e,ka,t),m(k,e,t),s(e,$a,t),s(e,vt,t),s(e,Ca,t),m(Bt,e,t),s(e,Za,t),s(e,Wt,t),s(e,Ia,t),m(Xt,e,t),s(e,va,t),s(e,Rt,t),s(e,Ba,t),m(Gt,e,t),s(e,Wa,t),m(Vt,e,t),s(e,Xa,t),s(e,xt,t),s(e,Ra,t),m(_t,e,t),s(e,Ga,t),m(Yt,e,t),s(e,Va,t),s(e,At,t),s(e,xa,t),m(Ft,e,t),s(e,_a,t),m(Ht,e,t),s(e,Ya,t),s(e,zt,t),s(e,Aa,t),s(e,Qt,t),s(e,Fa,t),m(Nt,e,t),s(e,Ha,t),s(e,Et,t),s(e,za,t),m($,e,t),s(e,Qa,t),m(St,e,t),s(e,Na,t),s(e,qt,t),s(e,Ea,t),m(Lt,e,t),s(e,Sa,t),s(e,Dt,t),s(e,qa,t),s(e,Pt,t),s(e,La,t),m(C,e,t),s(e,Da,t),s(e,Kt,t),s(e,Pa,t),s(e,Ot,t),s(e,Ka,t),s(e,el,t),s(e,Oa,t),m(tl,e,t),s(e,en,t),s(e,ll,t),s(e,tn,t),s(e,sl,t),s(e,ln,t),m(al,e,t),s(e,sn,t),m(Z,e,t),s(e,an,t),s(e,nl,t),s(e,nn,t),m(il,e,t),s(e,rn,t),m(rl,e,t),s(e,on,t),s(e,ol,t),s(e,pn,t),s(e,pl,t),s(e,hn,t),m(I,e,t),s(e,mn,t),m(hl,e,t),s(e,dn,t),s(e,ml,t),s(e,Mn,t),s(e,dl,t),s(e,cn,t),s(e,Ml,t),s(e,un,t),m(cl,e,t),s(e,yn,t),s(e,ul,t),s(e,wn,t),s(e,yl,t),s(e,Jn,t),s(e,wl,t),s(e,bn,t),s(e,Jl,t),s(e,fn,t),m(bl,e,t),s(e,jn,t),s(e,Tl,t),Tn=!0},p(e,[t]){const Di={};t&1&&(Di.fw=e[0]),T.$set(Di);const Pi={};t&2&&(Pi.$$scope={dirty:t,ctx:e}),U.$set(Pi);const Ki={};t&2&&(Ki.$$scope={dirty:t,ctx:e}),g.$set(Ki);const Oi={};t&2&&(Oi.$$scope={dirty:t,ctx:e}),k.$set(Oi);const er={};t&2&&(er.$$scope={dirty:t,ctx:e}),$.$set(er);const tr={};t&2&&(tr.$$scope={dirty:t,ctx:e}),C.$set(tr);const lr={};t&2&&(lr.$$scope={dirty:t,ctx:e}),Z.$set(lr);const sr={};t&2&&(sr.$$scope={dirty:t,ctx:e}),I.$set(sr)},i(e){Tn||(d(T.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(U.$$.fragment,e),d($e.$$.fragment,e),d(Ze.$$.fragment,e),d(ve.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ve.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(ze.$$.fragment,e),d(Ee.$$.fragment,e),d(qe.$$.fragment,e),d(Oe.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(st.$$.fragment,e),d(nt.$$.fragment,e),d(rt.$$.fragment,e),d(pt.$$.fragment,e),d(mt.$$.fragment,e),d(ct.$$.fragment,e),d(wt.$$.fragment,e),d(bt.$$.fragment,e),d(g.$$.fragment,e),d(Tt.$$.fragment,e),d(gt.$$.fragment,e),d(kt.$$.fragment,e),d(Zt.$$.fragment,e),d(It.$$.fragment,e),d(k.$$.fragment,e),d(Bt.$$.fragment,e),d(Xt.$$.fragment,e),d(Gt.$$.fragment,e),d(Vt.$$.fragment,e),d(_t.$$.fragment,e),d(Yt.$$.fragment,e),d(Ft.$$.fragment,e),d(Ht.$$.fragment,e),d(Nt.$$.fragment,e),d($.$$.fragment,e),d(St.$$.fragment,e),d(Lt.$$.fragment,e),d(C.$$.fragment,e),d(tl.$$.fragment,e),d(al.$$.fragment,e),d(Z.$$.fragment,e),d(il.$$.fragment,e),d(rl.$$.fragment,e),d(I.$$.fragment,e),d(hl.$$.fragment,e),d(cl.$$.fragment,e),d(bl.$$.fragment,e),Tn=!0)},o(e){M(T.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M(X.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(A.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(ne.$$.fragment,e),M(re.$$.fragment,e),M(oe.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(fe.$$.fragment,e),M(je.$$.fragment,e),M(U.$$.fragment,e),M($e.$$.fragment,e),M(Ze.$$.fragment,e),M(ve.$$.fragment,e),M(We.$$.fragment,e),M(Xe.$$.fragment,e),M(Ve.$$.fragment,e),M(_e.$$.fragment,e),M(Fe.$$.fragment,e),M(ze.$$.fragment,e),M(Ee.$$.fragment,e),M(qe.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),M(lt.$$.fragment,e),M(st.$$.fragment,e),M(nt.$$.fragment,e),M(rt.$$.fragment,e),M(pt.$$.fragment,e),M(mt.$$.fragment,e),M(ct.$$.fragment,e),M(wt.$$.fragment,e),M(bt.$$.fragment,e),M(g.$$.fragment,e),M(Tt.$$.fragment,e),M(gt.$$.fragment,e),M(kt.$$.fragment,e),M(Zt.$$.fragment,e),M(It.$$.fragment,e),M(k.$$.fragment,e),M(Bt.$$.fragment,e),M(Xt.$$.fragment,e),M(Gt.$$.fragment,e),M(Vt.$$.fragment,e),M(_t.$$.fragment,e),M(Yt.$$.fragment,e),M(Ft.$$.fragment,e),M(Ht.$$.fragment,e),M(Nt.$$.fragment,e),M($.$$.fragment,e),M(St.$$.fragment,e),M(Lt.$$.fragment,e),M(C.$$.fragment,e),M(tl.$$.fragment,e),M(al.$$.fragment,e),M(Z.$$.fragment,e),M(il.$$.fragment,e),M(rl.$$.fragment,e),M(I.$$.fragment,e),M(hl.$$.fragment,e),M(cl.$$.fragment,e),M(bl.$$.fragment,e),Tn=!1},d(e){e&&(l(J),l(w),l(b),l(Ul),l(gl),l(kl),l(W),l($l),l(Cl),l(Zl),l(G),l(Il),l(V),l(vl),l(x),l(Bl),l(Wl),l(Y),l(Xl),l(Rl),l(Gl),l(H),l(Vl),l(z),l(xl),l(_l),l(Yl),l(E),l(Al),l(S),l(Fl),l(Hl),l(L),l(zl),l(Ql),l(P),l(Nl),l(El),l(O),l(Sl),l(ee),l(ql),l(Ll),l(Dl),l(se),l(Pl),l(Kl),l(Ol),l(ie),l(es),l(ts),l(ls),l(pe),l(ss),l(he),l(as),l(ns),l(is),l(Me),l(rs),l(os),l(ps),l(ye),l(hs),l(ms),l(ds),l(be),l(Ms),l(cs),l(us),l(Te),l(ys),l(Ue),l(ws),l(Js),l(ge),l(bs),l(ke),l(fs),l(js),l(Ce),l(Ts),l(Us),l(Ie),l(gs),l(ks),l(Be),l($s),l(Cs),l(Zs),l(Re),l(Is),l(Ge),l(vs),l(Bs),l(xe),l(Ws),l(Xs),l(Ye),l(Rs),l(Ae),l(Gs),l(Vs),l(He),l(xs),l(_s),l(Qe),l(Ys),l(Ne),l(As),l(Fs),l(Se),l(Hs),l(zs),l(Le),l(Qs),l(De),l(Ns),l(Pe),l(Es),l(Ke),l(Ss),l(qs),l(Ls),l(tt),l(Ds),l(Ps),l(Ks),l(at),l(Os),l(ea),l(it),l(ta),l(la),l(ot),l(sa),l(aa),l(ht),l(na),l(ia),l(dt),l(ra),l(Mt),l(oa),l(pa),l(ut),l(ha),l(yt),l(ma),l(da),l(Jt),l(Ma),l(ca),l(ft),l(ua),l(jt),l(ya),l(wa),l(Ja),l(Ut),l(ba),l(fa),l(ja),l($t),l(Ta),l(Ct),l(Ua),l(ga),l(ka),l($a),l(vt),l(Ca),l(Za),l(Wt),l(Ia),l(va),l(Rt),l(Ba),l(Wa),l(Xa),l(xt),l(Ra),l(Ga),l(Va),l(At),l(xa),l(_a),l(Ya),l(zt),l(Aa),l(Qt),l(Fa),l(Ha),l(Et),l(za),l(Qa),l(Na),l(qt),l(Ea),l(Sa),l(Dt),l(qa),l(Pt),l(La),l(Da),l(Kt),l(Pa),l(Ot),l(Ka),l(el),l(Oa),l(en),l(ll),l(tn),l(sl),l(ln),l(sn),l(an),l(nl),l(nn),l(rn),l(on),l(ol),l(pn),l(pl),l(hn),l(mn),l(dn),l(ml),l(Mn),l(dl),l(cn),l(Ml),l(un),l(yn),l(ul),l(wn),l(yl),l(Jn),l(wl),l(bn),l(Jl),l(fn),l(jn),l(Tl)),l(u),c(T,e),c(v,e),c(B,e),c(X,e),c(R,e),c(_,e),c(A,e),c(F,e),c(Q,e),c(N,e),c(q,e),c(D,e),c(K,e),c(te,e),c(le,e),c(ae,e),c(ne,e),c(re,e),c(oe,e),c(me,e),c(de,e),c(ce,e),c(ue,e),c(we,e),c(Je,e),c(fe,e),c(je,e),c(U,e),c($e,e),c(Ze,e),c(ve,e),c(We,e),c(Xe,e),c(Ve,e),c(_e,e),c(Fe,e),c(ze,e),c(Ee,e),c(qe,e),c(Oe,e),c(et,e),c(lt,e),c(st,e),c(nt,e),c(rt,e),c(pt,e),c(mt,e),c(ct,e),c(wt,e),c(bt,e),c(g,e),c(Tt,e),c(gt,e),c(kt,e),c(Zt,e),c(It,e),c(k,e),c(Bt,e),c(Xt,e),c(Gt,e),c(Vt,e),c(_t,e),c(Yt,e),c(Ft,e),c(Ht,e),c(Nt,e),c($,e),c(St,e),c(Lt,e),c(C,e),c(tl,e),c(al,e),c(Z,e),c(il,e),c(rl,e),c(I,e),c(hl,e),c(cl,e),c(bl,e)}}}const gr='{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Check your data","local":"check-your-data","sections":[],"depth":3},{"title":"From datasets to dataloaders","local":"from-datasets-to-dataloaders","sections":[],"depth":3},{"title":"Going through the model","local":"going-through-the-model","sections":[],"depth":3},{"title":"Performing one optimization step","local":"performing-one-optimization-step","sections":[],"depth":3},{"title":"Dealing with CUDA out-of-memory errors","local":"dealing-with-cuda-out-of-memory-errors","sections":[],"depth":3},{"title":"Evaluating the model","local":"evaluating-the-model","sections":[],"depth":3}],"depth":2},{"title":"Debugging silent errors during training","local":"debugging-silent-errors-during-training","sections":[{"title":"Check your data (again!)","local":"check-your-data-again","sections":[],"depth":3},{"title":"Overfit your model on one batch","local":"overfit-your-model-on-one-batch","sections":[],"depth":3},{"title":"Don’t tune anything until you have a first baseline","local":"dont-tune-anything-until-you-have-a-first-baseline","sections":[],"depth":3},{"title":"Ask for help","local":"ask-for-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function kr(f,u,J){let w="pt";return rr(()=>{const b=new URLSearchParams(window.location.search);J(0,w=b.get("fw")||"pt")}),[w]}class Rr extends or{constructor(u){super(),pr(this,u,kr,Ur,ir,{})}}export{Rr as component};
