import{s as jn,o as Jn,n as Ys}from"../chunks/scheduler.37c15a92.js";import{S as Un,i as mn,g as u,s as e,r as M,A as Tn,h as j,f as a,c as t,j as yn,u as i,x as U,k as un,y as hn,a as n,v as o,d as r,t as c,w as y}from"../chunks/index.2bf4358c.js";import{T as Rs}from"../chunks/Tip.363c041f.js";import{Y as wn}from"../chunks/Youtube.1e50a667.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{C as dn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as Ca}from"../chunks/Heading.8ada512a.js";import{E as gn}from"../chunks/getInferenceSnippets.a9aea2b8.js";function Cn(w){let p,T="💡 Esta sección cubre BPE en produndidad, yendo tan lejos como para mostrar una implementación completa. Puedes saltarte hasta el final si sólo quieres una descripción general del algoritmo de tokenización.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1l9fmnz"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function xn(w){let p,T="Los tokenizadores de GPT-2 y RoBERTa (que son bastante similares) tienen una manera bien inteligente de lidiar con esto: ellos no miran a las palabras como si estuvieran escritas con caracteres Unicode, sino con bytes. De esa manera el vocabulario base tiene un tamaño pequeño (256), pero cada caracter que te puedas imaginar estará incluido y no terminará convertido en el token “desconocido”. Este truco se llama <em>byte-level BPE</em>.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1vbdz5"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function In(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> Cuál crees que será la siguiente regla de fusión?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1h3ygda"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function fn(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> ¿Cómo crees será tokenizada la palabra <code>&quot;unhug&quot;</code>?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-iix713"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function bn(w){let p,T="💡 Usar <code>train_new_from_iterator()</code> en el mismo corpus no resultará en exactament el mismo vocabulario. Esto es porque cuando hay una elección del par más frecuente, seleccionamos el primero encontrado, mientras que la librería 🤗 Tokenizers selecciona el primero basado en sus IDs internos.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-2i5pf2"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function qn(w){let p,T="⚠️ Nuestra implementación arrojará un error si hay un caracter desconocido dado que no hicimos nada para manejarlos. GPT-2 en realidad no tiene un token desconocido (es imposible obtener un caracter desconocido cuando se usa byte-level BPE), pero esto podría ocurrir acá porque no incluímos todos los posibles bytes en el vocabulario inicial. Este aspectode BPE va más allá del alcance de está sección, por lo que dejaremos los detalles fuera.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1hld7v5"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Ys,d(J){J&&a(p)}}}function $n(w){let p,T,J,h,b,Ks,q,Fs,$,xa="La codificación por pares de byte (Byte-Pair Encoding (BPE)) fue inicialmente desarrollado como un algoritmo para comprimir textos, y luego fue usado por OpenAI para la tokenización al momento de pre-entrenar el modelo GPT. Es usado por un montón de modelos Transformers, incluyendo GPT, GPT-2, RoBERTa, BART, y DeBERTa.",Ls,k,Os,d,sl,Q,ll,A,Ia="El entrenamiento de BPE comienza calculando el conjunto de palabras únicas usada en el corpus (después de completar las etapas de normalización y pre-tokenización), para luego contruir el vocabulario tomando todos los símbolos usados para escribir esas palabras. Como un ejemplo muy simple, digamos que nuestros corpus usa estas cinco palabras:",al,B,nl,z,fa="El vocabulario vase entonces será <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Para casos reales, el vocabulario base contendrá todos los caracteres ASCII, al menos, y probablemente algunos caracteres Unicode también. Si un ejemplo que estás tokenizando usa un caracter que no está en el corpus de entrenamiento, ese caracter será convertido al token “desconocido”. Esa es una razón por la cual muchos modelos de NLP son muy malos analizando contenido con emojis.",el,g,tl,E,ba="Luego de obtener el vocabulario base, agregamos nuevos tokens hasta que el tamaño deseado del vocabulario se alcance por medio de aprender <em>fusiones</em> (merges), las cuales son reglas para fusionar dos elementos del vocabulario existente en uno nuevo. Por lo que al inicio de estas fusiones crearemos tokens con dos caracteres, y luego, a medida que el entrenamiento avance, subpalabras más largas.",pl,v,qa="En cualquier etapa durante el entrenamiento del tokenizador, el algoritmo BPE buscará pos los pares más frecuentes de los tokens existentes (por “par”, acá nos referimos a dos tokens consecutivos en una palabra). El par más frecuente es el que será fusionado, y enjuagamos y repetimos para la siguiente etapa.",Ml,V,$a="Volviedo a nuestro ejemplo previo, asumamos que las palabras tenían las siguientes frecuencias:",il,Z,ol,S,ka="lo que significa que <code>&quot;hug&quot;</code> estuvo presente 10 veces en el corpus, <code>&quot;pug&quot;</code> 5 veces, <code>&quot;pun&quot;</code> 12 veces, <code>&quot;bun&quot;</code> 4 veces, and <code>&quot;hugs&quot;</code> 5 veces. Empezamos el entrenamiento separando cada palabra en caracteres (los que formaron nuestro vocabulario inicial) para que podamos ver cada palabra como una lista de tokens:",rl,G,cl,_,Qa="Luego miramos los pares. El par <code>(&quot;h&quot;, &quot;u&quot;)</code> está presente en las palabras <code>&quot;hug&quot;</code> y <code>&quot;hugs&quot;</code>, 15 veces en el total del corpus. No es el par más frecuente: ese honor le corresponde a <code>(&quot;u&quot;, &quot;g&quot;)</code>, el cual está presente en <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, y <code>&quot;hugs&quot;</code>, para un gran total de 20 veces en el vocabulario.",yl,N,Aa="Por lo tanto, la primera regla de fusión aprendida por el tokenizador es <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, lo que significa que <code>&quot;ug&quot;</code> será agregado al vocabulario, y el par debería ser fusionado en todas las palabras del corpus. Al final de esta etapa, el vocabulario se ve así:",ul,H,jl,D,Ba="Ahora tenemos algunos pares que resultan en un token más largo de dos caracteres: por ejemplo el par <code>(&quot;h&quot;, &quot;ug&quot;)</code> (presente 15 veces en el corpus). Sin embargo, el par más frecuente en este punto is <code>(&quot;u&quot;, &quot;n&quot;)</code>, presente 16 veces en el corpus, por lo que la segunda regla de fusión aprendida es <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. Agregando esto y fusionando todas las ocurrencias existentes nos lleva a:",Jl,X,Ul,W,za="Ahora el par más frecuente es <code>(&quot;h&quot;, &quot;ug&quot;)</code>, por lo que aprendemos que la regla de fusión es <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>, lo cual nos da tuestro primer token de tres letras. Luego de la fusión el corpus se ve así:",ml,R,Tl,Y,Ea="Y continuamos así hasta que alcancemos el tamaño deseado del vocabulario.",hl,C,wl,P,dl,K,va="La tokenización sigue el proceso de entrenamiento de cerca, en el sentido que nuevos inputs son tokenizados aplicando los siguientes pasos:",gl,F,Va="<li>Normalización</li> <li>Pre-tokenización</li> <li>Separar las palabras en caracteres individuales</li> <li>Aplicar las reglas de fusión aprendidas en orden en dichas separaciones.</li>",Cl,L,Za="Tomemos el ejemplo que usamos durante el entrenamiento, con las tres reglas de fusión aprendidas:",xl,O,Il,ss,Sa="La palabra <code>&quot;bug&quot;</code> será tokenizada como <code>[&quot;b&quot;, &quot;ug&quot;]</code>. En cambio, <code>&quot;mug&quot;</code>, será tokenizado como <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> dado que la letra <code>&quot;m&quot;</code> no fue parte del vocabulario base. De la misma manera, la palabra <code>&quot;thug&quot;</code> será tokenizada como <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: la letra <code>&quot;t&quot;</code> no está en el vocabulario base, y aplicando las reglas de fusión resulta primero la fusión de <code>&quot;u&quot;</code> y <code>&quot;g&quot;</code> y luego de <code>&quot;hu&quot;</code> and <code>&quot;g&quot;</code>.",fl,x,bl,ls,ql,as,Ga="Ahora echemos un vistazo a una implementación el algoritmo BPE. Esta no será una versión optimizada que puedes usar en corpus grande; sólo queremos mostrar el código para que puedas entender el algoritmo un poquito mejor.",$l,ns,_a="Primero necesitamos un corpus, así que creemos uno simple con algunas oraciones:",kl,es,Ql,ts,Na="A continuación, necesitamos pre-tokenizar el corpus en palabras. Dado que estamos replicando un tokenizador BPE (como GPT-2), usaremos el tokenizdor <code>gpt2</code> para la pre-tokenización:",Al,ps,Bl,Ms,Ha="Luego calculamos las frecuencias de cada palabra en el corpues mientras hacemos la pre-tokenización:",zl,is,El,os,vl,rs,Da="El siguiente paso es calcualar el vocabulario base, formado por todos los caracteres usados en el corpus:",Vl,cs,Zl,ys,Sl,us,Xa="También agregamos el token especial usado por el modelo al inicio de ese vocabulario. En el caso de GPT-2, el único token especial es <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",Gl,js,_l,Js,Wa="Ahora necesitamos separar cada palabra en caracteres individuales, para poder comenzar el entrenamiento:",Nl,Us,Hl,ms,Ra="Ahora estamos listos para el entrenamiento, escribamos una función que calcule la frecuencia de cada par. Necesitaremos usar esto en cada paso del entrenamiento:",Dl,Ts,Xl,hs,Ya="Ahora miremos una parte de ese diccionario después de las separaciones iniciales:",Wl,ws,Rl,ds,Yl,gs,Pa="Ahora, encontrar el par más frecuenta sólo toma un rápido ciclo:",Pl,Cs,Kl,xs,Fl,Is,Ka="Por lo que la primera fusión a aprender es <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, y luego agregamos <code>&#39;Ġt&#39;</code> al vocabulario:",Ll,fs,Ol,bs,Fa="Para continuar, necesitamos aplicar la fusión en nuestro diccionario de divisiones (<code>splits</code> dictionary). Escribamos otra función para esto:",sa,qs,la,$s,La="Y podemos echar un vistazo al resultado de nuestra primera fusión:",aa,ks,na,Qs,ea,As,Oa="Ahora tenemos todo lo que necesitamos para iterar hasta que aprendamos todas las fusiones que queramos. Apuntemos a un tamaño de vocabulario de 50:",ta,Bs,pa,zs,sn="Como resultado, hemos aprendido 19 reglas de fusión (el vocabulario inicial tenía un tamaño de 31 — 30 caracteres del alfabeto, más el token especial):",Ma,Es,ia,vs,oa,Vs,ln="And the vocabulary is composed of the special token, the initial alphabet, and all the results of the merges:",ra,Zs,ca,Ss,ya,I,ua,Gs,an="Para tokenizar un nuevo texto lo pre-tokenizamos, lo separamos, luego aplicamos todas las reglas de fusión aprendidas:",ja,_s,Ja,Ns,nn="Podemos intentar esto con cualquier texto compuesto de de caracteres del alfabeto:",Ua,Hs,ma,Ds,Ta,f,ha,Xs,en="Eso es todo para el algoritmo BPE! A continuación echaremos un vistazo a WordPiece.",wa,Ws,da,Ps,ga;return b=new Ca({props:{title:"Tokenización por Codificación Byte-Pair",local:"byte-pair-encoding-tokenization",headingTag:"h1"}}),q=new dn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"}]}}),k=new wn({props:{id:"HEikzVL-lZU"}}),d=new Rs({props:{$$slots:{default:[Cn]},$$scope:{ctx:w}}}),Q=new Ca({props:{title:"Algoritmo de Entrenamiento",local:"training-algorithm",headingTag:"h2"}}),B=new m({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),g=new Rs({props:{$$slots:{default:[xn]},$$scope:{ctx:w}}}),Z=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),G=new m({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),X=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),C=new Rs({props:{$$slots:{default:[In]},$$scope:{ctx:w}}}),P=new Ca({props:{title:"Algoritmo de Tokenización",local:"tokenization-algorithm",headingTag:"h2"}}),O=new m({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),x=new Rs({props:{$$slots:{default:[fn]},$$scope:{ctx:w}}}),ls=new Ca({props:{title:"Implementando BPE",local:"implementing-bpe",headingTag:"h2"}}),es=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),ps=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),is=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),os=new m({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),cs=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),ys=new m({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Us=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),Ts=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),ws=new m({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ds=new m({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),Cs=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),xs=new m({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),fs=new m({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),ks=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),Qs=new m({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Es=new m({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),vs=new m({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Zs=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new m({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),I=new Rs({props:{$$slots:{default:[bn]},$$scope:{ctx:w}}}),_s=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Ds=new m({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),f=new Rs({props:{warning:!0,$$slots:{default:[qn]},$$scope:{ctx:w}}}),Ws=new gn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter6/5.mdx"}}),{c(){p=u("meta"),T=e(),J=u("p"),h=e(),M(b.$$.fragment),Ks=e(),M(q.$$.fragment),Fs=e(),$=u("p"),$.textContent=xa,Ls=e(),M(k.$$.fragment),Os=e(),M(d.$$.fragment),sl=e(),M(Q.$$.fragment),ll=e(),A=u("p"),A.textContent=Ia,al=e(),M(B.$$.fragment),nl=e(),z=u("p"),z.innerHTML=fa,el=e(),M(g.$$.fragment),tl=e(),E=u("p"),E.innerHTML=ba,pl=e(),v=u("p"),v.textContent=qa,Ml=e(),V=u("p"),V.textContent=$a,il=e(),M(Z.$$.fragment),ol=e(),S=u("p"),S.innerHTML=ka,rl=e(),M(G.$$.fragment),cl=e(),_=u("p"),_.innerHTML=Qa,yl=e(),N=u("p"),N.innerHTML=Aa,ul=e(),M(H.$$.fragment),jl=e(),D=u("p"),D.innerHTML=Ba,Jl=e(),M(X.$$.fragment),Ul=e(),W=u("p"),W.innerHTML=za,ml=e(),M(R.$$.fragment),Tl=e(),Y=u("p"),Y.textContent=Ea,hl=e(),M(C.$$.fragment),wl=e(),M(P.$$.fragment),dl=e(),K=u("p"),K.textContent=va,gl=e(),F=u("ol"),F.innerHTML=Va,Cl=e(),L=u("p"),L.textContent=Za,xl=e(),M(O.$$.fragment),Il=e(),ss=u("p"),ss.innerHTML=Sa,fl=e(),M(x.$$.fragment),bl=e(),M(ls.$$.fragment),ql=e(),as=u("p"),as.textContent=Ga,$l=e(),ns=u("p"),ns.textContent=_a,kl=e(),M(es.$$.fragment),Ql=e(),ts=u("p"),ts.innerHTML=Na,Al=e(),M(ps.$$.fragment),Bl=e(),Ms=u("p"),Ms.textContent=Ha,zl=e(),M(is.$$.fragment),El=e(),M(os.$$.fragment),vl=e(),rs=u("p"),rs.textContent=Da,Vl=e(),M(cs.$$.fragment),Zl=e(),M(ys.$$.fragment),Sl=e(),us=u("p"),us.innerHTML=Xa,Gl=e(),M(js.$$.fragment),_l=e(),Js=u("p"),Js.textContent=Wa,Nl=e(),M(Us.$$.fragment),Hl=e(),ms=u("p"),ms.textContent=Ra,Dl=e(),M(Ts.$$.fragment),Xl=e(),hs=u("p"),hs.textContent=Ya,Wl=e(),M(ws.$$.fragment),Rl=e(),M(ds.$$.fragment),Yl=e(),gs=u("p"),gs.textContent=Pa,Pl=e(),M(Cs.$$.fragment),Kl=e(),M(xs.$$.fragment),Fl=e(),Is=u("p"),Is.innerHTML=Ka,Ll=e(),M(fs.$$.fragment),Ol=e(),bs=u("p"),bs.innerHTML=Fa,sa=e(),M(qs.$$.fragment),la=e(),$s=u("p"),$s.textContent=La,aa=e(),M(ks.$$.fragment),na=e(),M(Qs.$$.fragment),ea=e(),As=u("p"),As.textContent=Oa,ta=e(),M(Bs.$$.fragment),pa=e(),zs=u("p"),zs.textContent=sn,Ma=e(),M(Es.$$.fragment),ia=e(),M(vs.$$.fragment),oa=e(),Vs=u("p"),Vs.textContent=ln,ra=e(),M(Zs.$$.fragment),ca=e(),M(Ss.$$.fragment),ya=e(),M(I.$$.fragment),ua=e(),Gs=u("p"),Gs.textContent=an,ja=e(),M(_s.$$.fragment),Ja=e(),Ns=u("p"),Ns.textContent=nn,Ua=e(),M(Hs.$$.fragment),ma=e(),M(Ds.$$.fragment),Ta=e(),M(f.$$.fragment),ha=e(),Xs=u("p"),Xs.textContent=en,wa=e(),M(Ws.$$.fragment),da=e(),Ps=u("p"),this.h()},l(s){const l=Tn("svelte-u9bgzb",document.head);p=j(l,"META",{name:!0,content:!0}),l.forEach(a),T=t(s),J=j(s,"P",{}),yn(J).forEach(a),h=t(s),i(b.$$.fragment,s),Ks=t(s),i(q.$$.fragment,s),Fs=t(s),$=j(s,"P",{"data-svelte-h":!0}),U($)!=="svelte-nlw4yb"&&($.textContent=xa),Ls=t(s),i(k.$$.fragment,s),Os=t(s),i(d.$$.fragment,s),sl=t(s),i(Q.$$.fragment,s),ll=t(s),A=j(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1ge6ors"&&(A.textContent=Ia),al=t(s),i(B.$$.fragment,s),nl=t(s),z=j(s,"P",{"data-svelte-h":!0}),U(z)!=="svelte-12w7uzv"&&(z.innerHTML=fa),el=t(s),i(g.$$.fragment,s),tl=t(s),E=j(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-9h9iwk"&&(E.innerHTML=ba),pl=t(s),v=j(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1kei5ki"&&(v.textContent=qa),Ml=t(s),V=j(s,"P",{"data-svelte-h":!0}),U(V)!=="svelte-w4nnp4"&&(V.textContent=$a),il=t(s),i(Z.$$.fragment,s),ol=t(s),S=j(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-hu3c76"&&(S.innerHTML=ka),rl=t(s),i(G.$$.fragment,s),cl=t(s),_=j(s,"P",{"data-svelte-h":!0}),U(_)!=="svelte-2m2yo1"&&(_.innerHTML=Qa),yl=t(s),N=j(s,"P",{"data-svelte-h":!0}),U(N)!=="svelte-ap5znc"&&(N.innerHTML=Aa),ul=t(s),i(H.$$.fragment,s),jl=t(s),D=j(s,"P",{"data-svelte-h":!0}),U(D)!=="svelte-1i5m5fd"&&(D.innerHTML=Ba),Jl=t(s),i(X.$$.fragment,s),Ul=t(s),W=j(s,"P",{"data-svelte-h":!0}),U(W)!=="svelte-17mrt8d"&&(W.innerHTML=za),ml=t(s),i(R.$$.fragment,s),Tl=t(s),Y=j(s,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1683jdr"&&(Y.textContent=Ea),hl=t(s),i(C.$$.fragment,s),wl=t(s),i(P.$$.fragment,s),dl=t(s),K=j(s,"P",{"data-svelte-h":!0}),U(K)!=="svelte-potlx5"&&(K.textContent=va),gl=t(s),F=j(s,"OL",{"data-svelte-h":!0}),U(F)!=="svelte-jpgiaq"&&(F.innerHTML=Va),Cl=t(s),L=j(s,"P",{"data-svelte-h":!0}),U(L)!=="svelte-8vvsjz"&&(L.textContent=Za),xl=t(s),i(O.$$.fragment,s),Il=t(s),ss=j(s,"P",{"data-svelte-h":!0}),U(ss)!=="svelte-1ukpsru"&&(ss.innerHTML=Sa),fl=t(s),i(x.$$.fragment,s),bl=t(s),i(ls.$$.fragment,s),ql=t(s),as=j(s,"P",{"data-svelte-h":!0}),U(as)!=="svelte-1esepyc"&&(as.textContent=Ga),$l=t(s),ns=j(s,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-b2t54"&&(ns.textContent=_a),kl=t(s),i(es.$$.fragment,s),Ql=t(s),ts=j(s,"P",{"data-svelte-h":!0}),U(ts)!=="svelte-gkz8m0"&&(ts.innerHTML=Na),Al=t(s),i(ps.$$.fragment,s),Bl=t(s),Ms=j(s,"P",{"data-svelte-h":!0}),U(Ms)!=="svelte-a1kxvi"&&(Ms.textContent=Ha),zl=t(s),i(is.$$.fragment,s),El=t(s),i(os.$$.fragment,s),vl=t(s),rs=j(s,"P",{"data-svelte-h":!0}),U(rs)!=="svelte-ohzu6i"&&(rs.textContent=Da),Vl=t(s),i(cs.$$.fragment,s),Zl=t(s),i(ys.$$.fragment,s),Sl=t(s),us=j(s,"P",{"data-svelte-h":!0}),U(us)!=="svelte-aiji2y"&&(us.innerHTML=Xa),Gl=t(s),i(js.$$.fragment,s),_l=t(s),Js=j(s,"P",{"data-svelte-h":!0}),U(Js)!=="svelte-pq7l32"&&(Js.textContent=Wa),Nl=t(s),i(Us.$$.fragment,s),Hl=t(s),ms=j(s,"P",{"data-svelte-h":!0}),U(ms)!=="svelte-19ak7xx"&&(ms.textContent=Ra),Dl=t(s),i(Ts.$$.fragment,s),Xl=t(s),hs=j(s,"P",{"data-svelte-h":!0}),U(hs)!=="svelte-ijk6v3"&&(hs.textContent=Ya),Wl=t(s),i(ws.$$.fragment,s),Rl=t(s),i(ds.$$.fragment,s),Yl=t(s),gs=j(s,"P",{"data-svelte-h":!0}),U(gs)!=="svelte-1a4me0z"&&(gs.textContent=Pa),Pl=t(s),i(Cs.$$.fragment,s),Kl=t(s),i(xs.$$.fragment,s),Fl=t(s),Is=j(s,"P",{"data-svelte-h":!0}),U(Is)!=="svelte-1fkmilf"&&(Is.innerHTML=Ka),Ll=t(s),i(fs.$$.fragment,s),Ol=t(s),bs=j(s,"P",{"data-svelte-h":!0}),U(bs)!=="svelte-1rczgta"&&(bs.innerHTML=Fa),sa=t(s),i(qs.$$.fragment,s),la=t(s),$s=j(s,"P",{"data-svelte-h":!0}),U($s)!=="svelte-139whv7"&&($s.textContent=La),aa=t(s),i(ks.$$.fragment,s),na=t(s),i(Qs.$$.fragment,s),ea=t(s),As=j(s,"P",{"data-svelte-h":!0}),U(As)!=="svelte-16k7mbs"&&(As.textContent=Oa),ta=t(s),i(Bs.$$.fragment,s),pa=t(s),zs=j(s,"P",{"data-svelte-h":!0}),U(zs)!=="svelte-1d3hrno"&&(zs.textContent=sn),Ma=t(s),i(Es.$$.fragment,s),ia=t(s),i(vs.$$.fragment,s),oa=t(s),Vs=j(s,"P",{"data-svelte-h":!0}),U(Vs)!=="svelte-okpg4u"&&(Vs.textContent=ln),ra=t(s),i(Zs.$$.fragment,s),ca=t(s),i(Ss.$$.fragment,s),ya=t(s),i(I.$$.fragment,s),ua=t(s),Gs=j(s,"P",{"data-svelte-h":!0}),U(Gs)!=="svelte-ms7due"&&(Gs.textContent=an),ja=t(s),i(_s.$$.fragment,s),Ja=t(s),Ns=j(s,"P",{"data-svelte-h":!0}),U(Ns)!=="svelte-7dx30b"&&(Ns.textContent=nn),Ua=t(s),i(Hs.$$.fragment,s),ma=t(s),i(Ds.$$.fragment,s),Ta=t(s),i(f.$$.fragment,s),ha=t(s),Xs=j(s,"P",{"data-svelte-h":!0}),U(Xs)!=="svelte-1jk90c"&&(Xs.textContent=en),wa=t(s),i(Ws.$$.fragment,s),da=t(s),Ps=j(s,"P",{}),yn(Ps).forEach(a),this.h()},h(){un(p,"name","hf:doc:metadata"),un(p,"content",kn)},m(s,l){hn(document.head,p),n(s,T,l),n(s,J,l),n(s,h,l),o(b,s,l),n(s,Ks,l),o(q,s,l),n(s,Fs,l),n(s,$,l),n(s,Ls,l),o(k,s,l),n(s,Os,l),o(d,s,l),n(s,sl,l),o(Q,s,l),n(s,ll,l),n(s,A,l),n(s,al,l),o(B,s,l),n(s,nl,l),n(s,z,l),n(s,el,l),o(g,s,l),n(s,tl,l),n(s,E,l),n(s,pl,l),n(s,v,l),n(s,Ml,l),n(s,V,l),n(s,il,l),o(Z,s,l),n(s,ol,l),n(s,S,l),n(s,rl,l),o(G,s,l),n(s,cl,l),n(s,_,l),n(s,yl,l),n(s,N,l),n(s,ul,l),o(H,s,l),n(s,jl,l),n(s,D,l),n(s,Jl,l),o(X,s,l),n(s,Ul,l),n(s,W,l),n(s,ml,l),o(R,s,l),n(s,Tl,l),n(s,Y,l),n(s,hl,l),o(C,s,l),n(s,wl,l),o(P,s,l),n(s,dl,l),n(s,K,l),n(s,gl,l),n(s,F,l),n(s,Cl,l),n(s,L,l),n(s,xl,l),o(O,s,l),n(s,Il,l),n(s,ss,l),n(s,fl,l),o(x,s,l),n(s,bl,l),o(ls,s,l),n(s,ql,l),n(s,as,l),n(s,$l,l),n(s,ns,l),n(s,kl,l),o(es,s,l),n(s,Ql,l),n(s,ts,l),n(s,Al,l),o(ps,s,l),n(s,Bl,l),n(s,Ms,l),n(s,zl,l),o(is,s,l),n(s,El,l),o(os,s,l),n(s,vl,l),n(s,rs,l),n(s,Vl,l),o(cs,s,l),n(s,Zl,l),o(ys,s,l),n(s,Sl,l),n(s,us,l),n(s,Gl,l),o(js,s,l),n(s,_l,l),n(s,Js,l),n(s,Nl,l),o(Us,s,l),n(s,Hl,l),n(s,ms,l),n(s,Dl,l),o(Ts,s,l),n(s,Xl,l),n(s,hs,l),n(s,Wl,l),o(ws,s,l),n(s,Rl,l),o(ds,s,l),n(s,Yl,l),n(s,gs,l),n(s,Pl,l),o(Cs,s,l),n(s,Kl,l),o(xs,s,l),n(s,Fl,l),n(s,Is,l),n(s,Ll,l),o(fs,s,l),n(s,Ol,l),n(s,bs,l),n(s,sa,l),o(qs,s,l),n(s,la,l),n(s,$s,l),n(s,aa,l),o(ks,s,l),n(s,na,l),o(Qs,s,l),n(s,ea,l),n(s,As,l),n(s,ta,l),o(Bs,s,l),n(s,pa,l),n(s,zs,l),n(s,Ma,l),o(Es,s,l),n(s,ia,l),o(vs,s,l),n(s,oa,l),n(s,Vs,l),n(s,ra,l),o(Zs,s,l),n(s,ca,l),o(Ss,s,l),n(s,ya,l),o(I,s,l),n(s,ua,l),n(s,Gs,l),n(s,ja,l),o(_s,s,l),n(s,Ja,l),n(s,Ns,l),n(s,Ua,l),o(Hs,s,l),n(s,ma,l),o(Ds,s,l),n(s,Ta,l),o(f,s,l),n(s,ha,l),n(s,Xs,l),n(s,wa,l),o(Ws,s,l),n(s,da,l),n(s,Ps,l),ga=!0},p(s,[l]){const tn={};l&2&&(tn.$$scope={dirty:l,ctx:s}),d.$set(tn);const pn={};l&2&&(pn.$$scope={dirty:l,ctx:s}),g.$set(pn);const Mn={};l&2&&(Mn.$$scope={dirty:l,ctx:s}),C.$set(Mn);const on={};l&2&&(on.$$scope={dirty:l,ctx:s}),x.$set(on);const rn={};l&2&&(rn.$$scope={dirty:l,ctx:s}),I.$set(rn);const cn={};l&2&&(cn.$$scope={dirty:l,ctx:s}),f.$set(cn)},i(s){ga||(r(b.$$.fragment,s),r(q.$$.fragment,s),r(k.$$.fragment,s),r(d.$$.fragment,s),r(Q.$$.fragment,s),r(B.$$.fragment,s),r(g.$$.fragment,s),r(Z.$$.fragment,s),r(G.$$.fragment,s),r(H.$$.fragment,s),r(X.$$.fragment,s),r(R.$$.fragment,s),r(C.$$.fragment,s),r(P.$$.fragment,s),r(O.$$.fragment,s),r(x.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(ys.$$.fragment,s),r(js.$$.fragment,s),r(Us.$$.fragment,s),r(Ts.$$.fragment,s),r(ws.$$.fragment,s),r(ds.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(fs.$$.fragment,s),r(qs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Bs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(Zs.$$.fragment,s),r(Ss.$$.fragment,s),r(I.$$.fragment,s),r(_s.$$.fragment,s),r(Hs.$$.fragment,s),r(Ds.$$.fragment,s),r(f.$$.fragment,s),r(Ws.$$.fragment,s),ga=!0)},o(s){c(b.$$.fragment,s),c(q.$$.fragment,s),c(k.$$.fragment,s),c(d.$$.fragment,s),c(Q.$$.fragment,s),c(B.$$.fragment,s),c(g.$$.fragment,s),c(Z.$$.fragment,s),c(G.$$.fragment,s),c(H.$$.fragment,s),c(X.$$.fragment,s),c(R.$$.fragment,s),c(C.$$.fragment,s),c(P.$$.fragment,s),c(O.$$.fragment,s),c(x.$$.fragment,s),c(ls.$$.fragment,s),c(es.$$.fragment,s),c(ps.$$.fragment,s),c(is.$$.fragment,s),c(os.$$.fragment,s),c(cs.$$.fragment,s),c(ys.$$.fragment,s),c(js.$$.fragment,s),c(Us.$$.fragment,s),c(Ts.$$.fragment,s),c(ws.$$.fragment,s),c(ds.$$.fragment,s),c(Cs.$$.fragment,s),c(xs.$$.fragment,s),c(fs.$$.fragment,s),c(qs.$$.fragment,s),c(ks.$$.fragment,s),c(Qs.$$.fragment,s),c(Bs.$$.fragment,s),c(Es.$$.fragment,s),c(vs.$$.fragment,s),c(Zs.$$.fragment,s),c(Ss.$$.fragment,s),c(I.$$.fragment,s),c(_s.$$.fragment,s),c(Hs.$$.fragment,s),c(Ds.$$.fragment,s),c(f.$$.fragment,s),c(Ws.$$.fragment,s),ga=!1},d(s){s&&(a(T),a(J),a(h),a(Ks),a(Fs),a($),a(Ls),a(Os),a(sl),a(ll),a(A),a(al),a(nl),a(z),a(el),a(tl),a(E),a(pl),a(v),a(Ml),a(V),a(il),a(ol),a(S),a(rl),a(cl),a(_),a(yl),a(N),a(ul),a(jl),a(D),a(Jl),a(Ul),a(W),a(ml),a(Tl),a(Y),a(hl),a(wl),a(dl),a(K),a(gl),a(F),a(Cl),a(L),a(xl),a(Il),a(ss),a(fl),a(bl),a(ql),a(as),a($l),a(ns),a(kl),a(Ql),a(ts),a(Al),a(Bl),a(Ms),a(zl),a(El),a(vl),a(rs),a(Vl),a(Zl),a(Sl),a(us),a(Gl),a(_l),a(Js),a(Nl),a(Hl),a(ms),a(Dl),a(Xl),a(hs),a(Wl),a(Rl),a(Yl),a(gs),a(Pl),a(Kl),a(Fl),a(Is),a(Ll),a(Ol),a(bs),a(sa),a(la),a($s),a(aa),a(na),a(ea),a(As),a(ta),a(pa),a(zs),a(Ma),a(ia),a(oa),a(Vs),a(ra),a(ca),a(ya),a(ua),a(Gs),a(ja),a(Ja),a(Ns),a(Ua),a(ma),a(Ta),a(ha),a(Xs),a(wa),a(da),a(Ps)),a(p),y(b,s),y(q,s),y(k,s),y(d,s),y(Q,s),y(B,s),y(g,s),y(Z,s),y(G,s),y(H,s),y(X,s),y(R,s),y(C,s),y(P,s),y(O,s),y(x,s),y(ls,s),y(es,s),y(ps,s),y(is,s),y(os,s),y(cs,s),y(ys,s),y(js,s),y(Us,s),y(Ts,s),y(ws,s),y(ds,s),y(Cs,s),y(xs,s),y(fs,s),y(qs,s),y(ks,s),y(Qs,s),y(Bs,s),y(Es,s),y(vs,s),y(Zs,s),y(Ss,s),y(I,s),y(_s,s),y(Hs,s),y(Ds,s),y(f,s),y(Ws,s)}}}const kn='{"title":"Tokenización por Codificación Byte-Pair","local":"byte-pair-encoding-tokenization","sections":[{"title":"Algoritmo de Entrenamiento","local":"training-algorithm","sections":[],"depth":2},{"title":"Algoritmo de Tokenización","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementando BPE","local":"implementing-bpe","sections":[],"depth":2}],"depth":1}';function Qn(w){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gn extends Un{constructor(p){super(),mn(this,p,Qn,$n,jn,{})}}export{Gn as component};
