import{s as fa,o as oa,n as hl}from"../chunks/scheduler.37c15a92.js";import{S as $a,i as da,g as j,s as a,r as T,A as Na,h as p,f as M,c as e,j as Qa,u as U,x as J,k as ka,y as xa,a as n,v as w,d as I,t as A,w as C}from"../chunks/index.2bf4358c.js";import{T as cl}from"../chunks/Tip.363c041f.js";import{Y as Ea}from"../chunks/Youtube.1e50a667.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{C as Ba}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{F as va}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as D,E as za}from"../chunks/getInferenceSnippets.80a69898.js";function Ra(h){let y,r="✏️ <strong>여러분 차례입니다!</strong> 다른 문제를 해결 후 추가 도전으로, 이 단계로 돌아와 모델이 내부 손실 대신 원래 Keras 손실함수로 작동하도록 할 수 있습니다. 레이블이 올바르게 출력되도록 하려면 <code>to_tf_dataset()</code>의 <code>label_cols</code> 인수에 <code>&quot;labels&quot;</code>를 추가해야 합니다. 그러면 그래디언트가 계산됩니다. 하지만 우리가 지정한 손실함수에는 한 가지 문제가 더 있습니다. 학습은 문제가 있음에도 불구하고 계속 실행되지만 학습이 매우 느리고 높은 train 손실값에서 정체 될 수 있습니다. 왜 그런지 알아 볼까요?",t,u,i="만약 어렵다면 ROT13 인코드 방식의 힌트를 보세요 Transformers에서 SequenceClassification 모델의 출력을 보면 첫 번째 출력은 ‘logits’입니다. logits란 무엇일까요?(살면서 ROT13 인코딩은 처음 봤네요, 궁금하면 영어 원본으로 보세요.)",k,c,x="두번째 힌트: 옵티마이저, 활성함수 또는 손실함수를 문자열로 지정하면 Keras는 해당 함수의 모든 인수 값을 기본값으로 설정합니다. SparseCategoricalCrossentropy에는 어떤 인수가 있으며 기본값은 무엇일까요?";return{c(){y=j("p"),y.innerHTML=r,t=a(),u=j("p"),u.textContent=i,k=a(),c=j("p"),c.textContent=x},l(b){y=p(b,"P",{"data-svelte-h":!0}),J(y)!=="svelte-oceu4s"&&(y.innerHTML=r),t=e(b),u=p(b,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1acodk6"&&(u.textContent=i),k=e(b),c=p(b,"P",{"data-svelte-h":!0}),J(c)!=="svelte-kqd61h"&&(c.textContent=x)},m(b,Q){n(b,y,Q),n(b,t,Q),n(b,u,Q),n(b,k,Q),n(b,c,Q)},p:hl,d(b){b&&(M(y),M(t),M(u),M(k),M(c))}}}function ga(h){let y,r="🤗 Transformers에서 <code>create_optimizer()</code> 함수를 가져올 수도 있습니다. 이렇게 하면 적합한 가중치 감쇠(weight decay)와 학습률 워밍업과 감쇠가 포함된 AdamW 옵티마이저가 제공됩니다. 이 옵티마이저는 기본 Adam 옵티마이저로 얻은 결과보다 약간 더 나은 결과를 만들어내는 경우가 많습니다.";return{c(){y=j("p"),y.innerHTML=r},l(t){y=p(t,"P",{"data-svelte-h":!0}),J(y)!=="svelte-13ix21d"&&(y.innerHTML=r)},m(t,u){n(t,y,u)},p:hl,d(t){t&&M(y)}}}function _a(h){let y,r="다음 장에서는 메모리 사용량을 줄이고 가장 큰 모델을 파인튜닝 할 수 있는 고급 기술을 살펴보겠습니다.";return{c(){y=j("p"),y.textContent=r},l(t){y=p(t,"P",{"data-svelte-h":!0}),J(y)!=="svelte-12h0fgf"&&(y.textContent=r)},m(t,u){n(t,y,u)},p:hl,d(t){t&&M(y)}}}function Sa(h){let y,r="💡 학습 데이터가 불균형한 경우 모든 레이블을 포함하는 학습 데이터 배치를 구성해야 합니다.";return{c(){y=j("p"),y.textContent=r},l(t){y=p(t,"P",{"data-svelte-h":!0}),J(y)!=="svelte-1qo4rpe"&&(y.textContent=r)},m(t,u){n(t,y,u)},p:hl,d(t){t&&M(y)}}}function Ga(h){let y,r="⚠️ 과적합 테스트 후에 모델을 다시 만들고 다시 컴파일해야 합니다. 학습 모델이 전체 데이터 세트에서 유용한 것을 복구하고 학습할 수 없기 때문입니다.";return{c(){y=j("p"),y.textContent=r},l(t){y=p(t,"P",{"data-svelte-h":!0}),J(y)!=="svelte-jecg9g"&&(y.textContent=r)},m(t,u){n(t,y,u)},p:hl,d(t){t&&M(y)}}}function Za(h){let y,r,t,u,i,k,c,x,b,Q,E,tn='<a href="/course/chapter7">단원 7</a>의 조언에 충실히 따라 주어진 작업에서 모델을 훈련하거나 파인튜닝하는 멋진 스크립트를 작성했습니다. 하지만 <code>model.fit()</code> 명령을 실행하면 끔찍한 일이 발생합니다. 오류가 발생했네요 😱! 또는 더 좋지 못한 일은 모든 것이 정상인 것처럼 보이고 훈련은 오류 없이 실행되었지만 결과 모델이 엉망인 경우입니다. 이 장에서는 이러한 종류의 이슈를 디버그하기 위해 수행할 수 있는 작업을 보여줍니다.',Dl,B,il,v,Ql,z,mn="<code>model.fit()</code>에서 오류가 발생했을 때 문제는 여러 곳에서 발생할 수 있습니다. 학습은 일반적으로 시작부터 해당 에러 지점까지 많은 작업이 진행되기 때문인데, 문제는 데이터세트가 뭔가 잘못 되었거나, 데이터세트의 배치 데이터를 함께 일괄 처리하려고 할 때 발생하는 문제일 수 있습니다. 또는 모델 코드, 손실 함수 또는 옵티마이저에 문제가 있을 수 있습니다. 모든 것이 훈련에 적합하더라도 메트릭에 문제가 있는 경우 평가 중에 문제가 발생할 수 있습니다.",kl,R,un="<code>model.fit()</code>에서 발생하는 오류를 디버그하는 가장 좋은 방법은 이 전체 파이프라인을 직접 살펴보고 문제가 발생한 부분을 확인하는 것입니다. 가끔 에러는 해결하기 쉬울 때도 있습니다.",fl,g,rn='예시를 위해서 <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI 데이터세트</a>에서 DistilBERT 모델을 파인튜닝(을 시도하는) 아래 스크립트를 사용합니다.:',ol,_,$l,S,bn="이 코드를 실행하려고 하면 데이터 세트를 변환할 때 ‘VisibleDeprecationWarning’이 표시될 수 있습니다. 이는 알려진 UX 문제이므로 무시하시면 됩니다. 예를 들어, 2021년 11월 이후에 이 코스를 읽고 있는데 여전히 진행 중이라면 수정 할 때까지 @carrigmat로 분노의 트윗을 보내주세요.",dl,G,cn="위 문제보단 누가봐도 명백한 에러가 발생한다는 것인데, 정말 끔찍하게 깁니다:",Nl,Z,xl,L,hn="이게 무슨 뜻일까요? 데이터로 학습하려고 하는데 그라디언트가 없다니? 꽤나 당황스러운 일입니다; 이럴 경우 어떻게 디버깅을 할 수 있을까요? 에러가 발생했을 때 문제가 어디에 있는지 바로 알 수 없는 경우 가장 좋은 해결책은 각 단계에서 모든 것이 올바르게 보이는지 확인하면서 순서대로 살펴보는 것이 효과적인 경우가 있습니다. 물론 시작하는 곳은 항상…",El,Y,Bl,X,Dn="굳이 언급하자면, 데이터가 손상된 경우 Keras는 스스로 수정할 수 없습니다. 따라서 가장 먼저 해야 할 일은 학습 세트 내부가 어떤지 살피는 것입니다.",vl,V,Qn="<code>raw_datasets</code> 및 <code>tokenized_datasets</code> 내부를 살펴보면 좋겠지만 왠만하면 모델에 들어가기 전 지점의 데이터를 확인하는 것이 좋습니다. 즉, <code>to_tf_dataset()</code> 함수로 생성한 <code>tf.data.Dataset</code>에서 출력을 확인해야 합니다! 그럼 어떻게 해야 할까요? <code>tf.data.Dataset</code> 객체는 한 번에 전체 배치를 제공하고 인덱싱을 지원하지 않으므로 <code>train_dataset[0]</code>의 방식으로 요청할 수 없습니다. 그렇지만 우리는 살며시 배치를 요청할 수 있습니다.:",zl,F,Rl,W,kn="<code>break</code>는 한 번의 반복 후에 루프를 종료하므로 <code>train_dataset</code>에서 나오는 첫 번째 배치를 가져와 <code>batch</code>로 저장합니다. 이제 내부를 살펴보겠습니다.:",gl,H,_l,P,fn="맞는 것 같지 않나요? 모델에 ‘labels’, ‘attention_mask’, ‘input_ids’를 전달하고 있는데, 이는 출력값과 손실값을 계산하는 데 필요한 모든 것이 있어야 합니다. 그럼 왜 그래디언트가 없는 걸까요? 자세히 보면 단일 Dictionary 구조로 입력값을 전달하지만 학습 배치는 일반적으로 텐서 또는 Dictionary, 그리고 레이블 텐서입니다. Dictionary 입력에서 레이블은 키로 되어있습니다.",Sl,O,on="이것이 문제일까요? 항상 그런 것은 아닙니다! 그렇지만 TensorFlow로 Transformer 모델을 훈련할 때 접하게 되는 가장 일반적인 문제 중 하나입니다. 우리 모델은 모두 내부적으로 손실값을 계산할 수 있지만 그렇게 하려면 레이블이 입력 Dictionary에 전달되어야 합니다. 이것은 <code>compile()</code>에 손실 파라미터 값을 지정하지 않을 때 사용되는 손실값 입니다. 반면에 Keras는 일반적으로 레이블이 입력 Dictionary와 별도로 전달될 것으로 예상하며 그렇게 하지 않으면 일반적으로 손실값 계산이 실패합니다.",Gl,q,$n="문제는 이제 명확해졌습니다. 우리는 ‘loss’ 파라미터값을 설정 했었습니다. 즉, Keras에게 손실값을 계산하도록 요청했지만, Keras가 예상하는 위치가 모델에다가 레이블을 직접 전달했습니다! 따라서 둘 중 하나를 선택해야 합니다. 모델의 내부 손실 함수를 사용하고 레이블을 그대로 유지하거나, Keras 손실함수를 사용하고 레이블을 Keras가 예상하는 위치로 이동해야 합니다. 심플하게 첫 번째 접근 방식을 취하겠습니다. <code>compile()</code>에 대한 호출을 다음과 같이 변경합니다.:",Zl,K,Ll,ss,dn=`이제 모델의 내부 손실 함수를 사용하게 될 것이고 문제가 해결 될 겁니다!
Now we’ll use the model’s internal loss, and this problem should be resolved!`,Yl,f,Xl,ls,Nn="이제 훈련을 해보죠. 그라디언트를 가져와야 하므로 부디(갑자기 불길한 음악이 재생됨) <code>model.fit()</code>을 호출하면 모든 것이 잘 작동할 것입니다!",Vl,Ms,Fl,ns,xn="이런.",Wl,as,En="<code>nan</code>은 썩 내키지 않는 손실값 입니다. 데이터를 확인했었지만 괜찮아 보였는데 말이죠. 이게 문제가 아니라면 다음은 어떤 것을 확인해야할까요? 다음 단계는 분명히…",Hl,es,Pl,js,Bn="<code>model.fit()</code>은 Keras에서 정말 훌륭한 함수이지만 많은 일을 수행하므로 문제가 발생한 위치를 정확히 찾기가 더 어려울 수 있습니다. 모델을 디버깅하는 경우 진짜 도움이 될만한 전략으로 모델에 단일 배치를 전달하고 해당 배치에 대한 출력을 자세히 살펴보는 방법이 있습니다. 모델에서 오류가 발생하는 경우 정말 유용한 또 다른 팁은 <code>run_eagerly=True</code>로 모델을 <code>compile()</code>하는 것입니다. 이렇게 하면 속도가 훨씬 느려지지만 모델 코드에서 문제가 발생한 위치를 정확히 나타내기 때문에 에러 메시지를 훨씬 더 이해하기 쉽게 만듭니다.",Ol,ps,vn=`하지만 지금은 아직 <code>run_eagerly</code>가 필요하지 않습니다. 모델을 통해 이전에 얻은 <code>batch</code>를 실행하고 출력이 어떻게 보이는지 봅시다:
For now, though, we don’t need <code>run_eagerly</code> just yet. Let’s run the <code>batch</code> we got before through the model and see what the outputs look like:`,ql,Js,Kl,ys,sM,Ts,zn="흠, 무언가 복잡하네요. 모든 것이 <code>nan</code> 입니다! 하지만 이상하지 않나요? 모든 로짓은 어떻게 <code>nan</code>이 될까요? <code>nan</code>은 “not a number.”, 즉 숫자가 아님을 뜻합니다. <code>nan</code> 값은 0으로 나누는 것과 같은 금지된 연산을 수행할 때 종종 발생합니다. 그러나 기계 학습에서 <code>nan</code>에 대해 알아야 할 매우 중요한 한 가지는 이 값이 <em>전파</em>되는 경향이 있다는 것입니다. 숫자에 <code>nan</code>을 곱하면 출력도 <code>nan</code>이 됩니다. 출력, 손실값 또는 그래디언트의 아무 곳에서나 <code>nan</code>을 얻으면 전체 모델에 빠르게 확산됩니다. 왜냐하면 그 <code>nan</code> 값이 네트워크를 통해 다시 전파될 때 <code>nan</code> 그래디언트를 사용하여 가중치 업데이트를 계산하면 ‘nan’ 가중치를 얻을 수 있으며 이러한 가중치는 더 많은 <code>nan</code> 출력을 계산합니다! 곧 전체 네트워크는 하나의 큰 <code>nan</code> 블록이 될 것입니다. 그런 일이 발생하면 문제가 어디에서 시작되었는지 확인하기가 매우 어렵습니다. ‘nan’이 처음 들어온 곳을 어떻게 분리할 수 있을까요?",lM,Us,Rn="정답은 모델을 <em>재초기화</em> 하는 것입니다. 한번 훈련을 시작하면서 어딘가에 <code>nan</code>이 생겼고 모델 전체로 빠르게 전파되었습니다. 따라서 체크포인트에서 모델을 로드하고 가중치 업데이트를 수행하지 않고 <code>nan</code> 값이 생기는 위치를 확인합니다.:",MM,ws,nM,Is,gn="코드를 실행하면 다음의 값이 출력됩니다.:",aM,As,eM,Cs,_n="<em>이제</em> <code>nan</code>값의 위치를 알았내요! 우리 로짓값에는 <code>nan</code> 값이 없습니다. 그러나 우리는 손실값에서 몇 개의 ‘nan’ 값이 보이네요. 특히 이 문제를 일으키는 샘플에 대해 뭔가가 있는 걸까요? 어떤 것들이 있는지 봅시다(이 코드를 직접 실행하면 데이터세트가 섞였기 때문에 다른 인덱스를 얻을 수 있습니다):",jM,ts,pM,ms,JM,us,Sn="이 인덱스로 불러온 샘플을 살펴보겠습니다.:",yM,rs,TM,bs,UM,cs,Gn="음, 여기에 많은 것이 있지만 특별한게 없습니다. 레이블을 살펴보겠습니다.:",wM,hs,IM,Ds,AM,is,Zn="아! <code>nan</code> 샘플은 모두 동일하게 레이블 2를 가지고 있습니다. 이건 강력한 힌트입니다. 레이블이 2일 때 ‘nan’손실값이 발생한다는 사실은 우리 모델의 레이블 수를 확인하기에 아주 좋은 시기임을 뜻합니다.:",CM,Qs,tM,ks,mM,fs,Ln="이제 문제가 보입니다. 모델은 클래스가 두 개뿐이라고 생각하지만 레이블이 최대 2까지 갑니다. 이는 실제로 세 개의 클래스가 있다는 것을 의미합니다(0도 클래스이기 때문에). 이게 <code>nan</code>값이 발생한 이유 — 존재하지 않는 클래스에 대한 손실을 계산하려고 시도 했기 때문입니다! 이를 변경하고 모델을 다시 피팅해 보겠습니다.:",uM,os,rM,$s,bM,ds,Yn="학습이 진행되는군요! 더이상 <code>nan</code> 없으며, 손실값이 감소하는 듯 보입니다… 한참을 보다보면 손실값이 완고하게 높은 상태를 유지하기 때문에 조금 조바심이 나기 시작할지도 모릅니다. 여기서 학습을 중단하고 이 문제의 원인이 무엇인지 생각해 보겠습니다. 이 시점에서 우리는 데이터와 모델이 모두 괜찮다고 확신하지만 우리 모델은 잘 학습하지 못하고 있습니다. 무엇이 더 남았을까요? 그건 바로…",cM,Ns,hM,xs,Xn="위의 코드를 다시 보면 <code>batch_size</code>를 제외하고는 하이퍼파라미터를 전혀 볼 수 없는데, 이것이 범인일 가능성은 없어 보입니다. 하지만 속지 마세요. 항상 하이퍼파라미터가 있어야 하며, 이를 볼 수 없다면 이는 단지 하이퍼파라미터가 무엇으로 설정되어 있는지 모른다는 것을 의미합니다. 특히 Keras에 대한 중요한 점을 기억하세요. 손실 함수, 옵티마이저 함수 또는 활성화 함수를 문자열로 설정하면 <em>모든 인수가 기본값으로 설정됩니다</em>. 즉 문자열을 사용하는 것이 매우 편리하더라도 심각한 이슈 쉽게 숨길 수 있으므로 그렇게 할 때 매우 조심해야 함을 의미합니다. (이러한 선택적인 도전을 시도하는 사람은 이 사실을 염두해야 합니다.)",DM,Es,Vn='이 경우 문자열로 인수를 설정한 위치가 어디일까요? 처음에는 문자열로 손실 함수를 설정했지만 더 이상 그렇게 하지 않습니다. 다시보니 옵티마이저를 문자열로 설정하고 있습니다. 이게 어떤 것을 숨기고 있을까요? 옵티마이저의 <a href="https://www.tensorflow.org/api_docs/python/tf/keras/optimizers/Adam" rel="nofollow">인수</a>를 살펴보겠습니다.',iM,Bs,Fn="눈에 띄는 것이 있었나요? 맞습니다. 학습률입니다! 문자열 <code>&#39;adam&#39;</code>을 사용하면 기본 학습률이 0.001 또는 1e-3이 됩니다. 트랜스포머 모델에게는 상당히 높은 값입니다. 일반적으로 트랜스포머 모델 계열은 1e-5와 1e-4 사이의 학습률을 시도하는 것이 좋습니다. 이 값은 우리가 여기서 실제로 사용한 학습률보다 10배에서 100배 사이에 있습니다. 큰 문제가 될 것 같으니 줄여보겠습니다. 그렇게 하려면 실제 ‘optimizer’ 객체를 가져와야 합니다. 학습 속도가 높은 훈련이 가중치를 손상시키는 경우를 대비하여 체크포인트에서 모델을 다시 초기화 하겠습니다.:",QM,vs,kM,o,fM,zs,Wn="이제 새롭고, 개선된 학습률로 모델 학습에 도전해보겠습니다.:",oM,Rs,$M,gs,dM,_s,Hn="이제 손실값은 정말로 움직이고 있습니다! 학습이 마침내 효과가 있는 것 같습니다. 여기에는 교훈이 있습니다. 모델이 실행 중이지만 손실값이 감소하지 않고 데이터가 괜찮다고 확신하는 경우 학습률 및 가중치 감쇠와 같은 하이퍼파라미터를 확인하는 것이 좋습니다. 둘 중 하나를 너무 높게 설정하면 학습이 높은 손실 값에서 “정지”될 가능성이 매우 높습니다.",NM,Ss,xM,Gs,Pn="위의 스크립트에서 문제를 다루었지만 직면할 수 있는 여러가지 다른 일반적인 오류가 있습니다. (매우 불완전한) 목록을 살펴보겠습니다.",EM,Zs,BM,Ls,On="메모리 부족을 알리는 신호는 “OOM when allocating tensor”와 같은 에러입니다. OOM은 “out of memory”의 줄임말입니다. 이것은 큰 언어 모델을 다룰 때 매우 흔한 위험입니다. 이 문제가 발생하면 배치 크기를 절반으로 줄이고 다시 시도하는 것이 좋습니다. 그러나 일부 모델은 <em>매우</em> 큽니다. 예를 들어, 최대크기 GPT-2는 1.5B개의 매개변수가 있습니다. 즉, 모델을 저장하는 데만 6GB의 메모리가 필요하고 그라디언트에는 6GB가 추가로 필요합니다! 최대 크기 GPT-2 모델을 학습하려면 사용하는 배치 크기에 관계없이 일반적으로 20GB 이상의 VRAM이 필요하며, 소수의 GPU만 해당합니다. ‘distilbert-base-cased’와 같은 더 가벼운 모델은 실행하기가 훨씬 쉽고 훨씬 빠르게 학습할 수 있습니다.",vM,$,zM,Ys,RM,Xs,qn="TensorFlow의 특별한 특징 중 하나는 모델을 로드하거나 학습을 수행하는 즉시 GPU 메모리의 <em>모든</em>을 자체적으로 할당한 다음 필요에 따라 해당 메모리를 분할한다는 것입니다. 이것은 PyTorch와 같은 다른 프레임워크의 동작과 다른데, 이는 내부적으로 수행하지 않고 CUDA에서 필요에 따라 메모리를 할당합니다. TensorFlow 접근 방식의 한 가지 장점은 메모리가 부족할 때 종종 유용한 오류를 제공할 수 있고 전체 CUDA 커널을 충돌시키지 않고 해당 상태에서 복구할 수 있다는 것입니다. 그러나 중요한 단점도 있습니다. 한 번에 두 개의 TensorFlow 프로세스를 실행하면 <strong>나쁜 시간을 보내게 됩니다</strong>.",gM,Vs,Kn="Colab에서 실행하는 경우에는 이에 대해 걱정할 필요가 없지만 로컬에서 실행하는 경우에는 확실히 주의해야 합니다. 특히 노트북(주피터 노트북 등) 탭을 닫아도 해당 노트북이 반드시 종료되는 것은 아닙니다. 실행 중인 노트북(녹색 아이콘이 있는 노트북)을 선택하고 디렉토리 목록에서 수동으로 종료해야 할 수도 있습니다. TensorFlow를 사용하는 실행 중인 노트북은 여전히 ​​많은 GPU 메모리를 보유하고 있을 수 있으며, 이는 새로 시작하는 노트북에서 매우 이상한 문제가 발생할 수 있음을 의미합니다.",_M,Fs,sa="이전에 작동했던 코드에서 CUDA, BLAS 또는 cuBLAS에 대한 오류가 발생하기 시작하면 이 현상이 범인인 경우가 많습니다. <code>nvidia-smi</code>와 같은 명령을 사용하여 현재 노트북을 종료하거나 다시 시작할 때 대부분의 메모리가 사용 가능한지, 아니면 여전히 사용 중인지 확인할 수 있습니다. 아직 사용 중이라면 다른 무언가가 GPU를 붙잡고 있는 것입니다!",SM,Ws,GM,Hs,la="모델은 데이터에서 실제로 무엇이든 학습할 수 있는 경우에만 무언가를 학습합니다. 데이터를 손상시키는 버그가 있거나 레이블이 무작위로 지정된 경우 데이터 세트에 대해 모델이 학습을 하지 못할 가능성이 매우 높습니다. 여기에서 유용한 도구 중 하나는 <code>tokenizer.decode()</code>입니다. 이렇게 하면 <code>input_ids</code>가 다시 문자열로 바뀌므로 데이터를 보고 학습 데이터가 원하는 내용을 가르치는지 확인할 수 있습니다. 예를 들어, 위에서 했던 것처럼 <code>tf.data.Dataset</code>에서 <code>batch</code>를 얻은 후 다음과 같이 첫 번째 요소를 디코딩할 수 있습니다.:",ZM,Ps,LM,Os,Ma="그리고 첫번째 레이블과 함께 다음처럼 비교해볼 수 있습니다.:",YM,qs,XM,Ks,na="이처럼 데이터를 볼 수 있게 되면 스스로에게 다음과 같은 질문을 할 수 있습니다.:",VM,sl,aa="<li>디코드된 데이터가 이해할만한가?</li> <li>디코드된 데이터에 대한 레이블이 적합한가?</li> <li>다른 레이블보다 더 일반적인 레이블이 있는가?</li> <li>모델이 임의의 답변을 내거나, 같은 답변만 한다면 어떤 손실/평가 함수를 사용해야 할까?</li>",FM,ll,ea="데이터를 살펴본 후 모델의 예측을 몇 가지 살펴보세요. 모델이 토큰을 출력하는 경우 디코딩도 시도해 보세요. 모델이 항상 동일한 것을 예측하는 경우 데이터 세트가 하나의 범주(분류 문제의 경우)로 편향되어 있으므로 희귀 클래스를 오버샘플링하는 것과 같은 기술이 도움이 될 수 있습니다. 또는 잘못된 하이퍼파라미터 설정과 같은 학습 문제로 인해 발생할 수도 있습니다.",WM,Ml,ja="학습 전에 초기 모델에서 얻은 손실값/평가값이 무작위 예측에 대해 예상하는 손실값/평가값과 매우 다른 경우 버그가 있을 수 있으므로 손실값 또는 평가값이 계산되는 방식을 다시 확인하세요. 마지막에 여러 손실함수를 추가해 사용하는 경우 동일한 스케일의 값인지 확인하세요.",HM,nl,pa="데이터가 완벽하다고 확신한다면 한 번의 간단한 테스트로 모델이 데이터를 학습할 수 있는지 확인할 수 있습니다.",PM,al,OM,el,Ja="과적합은 일반적으로 학습할 때 피하려고 합니다. 이는 모델이 우리가 원하는 일반적인 기능을 인식하는 것을 학습하지 않고 대신 학습 샘플을 기억한다는 것을 의미하기 때문입니다. 그러나 한 배치에서 모델을 계속해서 훈련시키려고 시도하는 것은 학습하려는 모델로 우리가 구성한 문제를 해결할 수 있는지 확인하는 좋은 테스트입니다. 또한 초기 학습률이 너무 높은지 확인하는 데 도움이 됩니다.",qM,jl,ya="‘모델’을 정의한 후에 이 작업을 수행하는 것은 정말 쉽습니다. 학습 데이터 배치를 가져온 다음 해당 <code>배치</code>를 전체 데이터 세트로 처리하고 여러 에포크에 걸쳐 학습합니다.:",KM,pl,sn,d,ln,Jl,Ta="결과 모델은 <code>배치</code>에서 완벽에 가까운 결과를 가져야 하며 손실은 0(또는 사용 중인 손실의 최소값)으로 빠르게 감소합니다.",Mn,yl,Ua="모델이 이와 같은 완벽한 결과를 얻도록 관리하지 못한다면 문제 또는 데이터를 구성하는 방식에 문제가 있음을 의미하므로 수정해야 합니다. 과적합 테스트를 통과해야만 모델이 실제로 무언가를 학습할 수 있다고 확신할 수 있습니다.",nn,N,an,Tl,en,Ul,wa="강렬한 하이퍼파라미터 조정은 항상 기계 학습의 가장 어려운 부분으로 강조되지만 지표에서 약간의 이득을 얻는 데 도움이 되는 마지막 단계일 뿐입니다. Transformer 모델과 함께 기본 Adam 학습률 1e-3을 사용하는 것과 같이 하이퍼파라미터에 대한 <em>매우</em> 나쁜 값은 학습 진행을 매우 느리게 또는 완전히 중단하게 만들지만 대부분의 경우 다음과 같은 “합리적인” 하이퍼파라미터 1e-5에서 5e-5까지의 학습률을 사용하면 좋은 결과를 얻을 수 있습니다. 따라서 데이터 세트의 기준을 능가하는 결과를 얻을 때까지 시간과 비용이 많이 드는 하이퍼파라미터 검색을 시작하지 마세요.",jn,wl,Ia="적당한 모델을 갖고나면 약간 조정을 시작할 수 있습니다. 다른 하이퍼파라미터로 천 개의 실행을 시작하려고 하지 말고 하나의 하이퍼파라미터에 대해 다른 값을 가진 몇 개의 실행을 비교하여 가장 큰 영향력을 미치는 아이디어를 얻어보세요.",pn,Il,Aa="모델 자체를 조정하는 경우 단순하게 유지하고 합리적으로 정당화할 수 없는 것은 시도하지 마세요. 항상 과적합 테스트로 돌아가서 변경 사항이 의도하지 않은 결과를 초래하지 않았는지 확인하세요.",Jn,Al,yn,Cl,Ca='이 단원에서 문제를 해결하는 데 도움이 되는 몇 가지 조언을 찾았으면 좋겠지만, 그렇지 않은 경우 <a href="https://discuss.huggingface.co/" rel="nofollow">포럼</a>에서 커뮤니티에 언제든지 질문할 수 있음을 기억하세요.',Tn,tl,ta="다음은 도움이 될 수 있는 몇 가지 추가 자료입니다.:",Un,ml,ma='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> by Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> by Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> by Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> by Andrej Karpathy</li>',wn,ul,ua="물론 신경망을 훈련할 때 발생하는 모든 문제가 자신의 잘못은 아닙니다! 🤗 Transformers 또는 🤗 Datasets 라이브러리에서 이상한 것을 본다면 버그가 발생했을 수 있습니다. 버그를 봤을 경우 우리에게 상세하게 말해야 하며, 다음 섹션에서 그 방법을 정확히 설명할 것입니다.",In,rl,An,bl,Cn;return i=new va({props:{fw:h[0]}}),c=new D({props:{title:"학습 파이프라인 디버깅",local:"학습-파이프라인-디버깅",headingTag:"h1"}}),b=new Ba({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4_tf.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4_tf.ipynb"}]}}),B=new D({props:{title:"학습 파이프라인 디버깅",local:"학습-파이프라인-디버깅",headingTag:"h2"}}),v=new Ea({props:{id:"N9kO52itd0Q"}}),_=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Ub2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEpJTBBJTBBcmF3X2RhdGFzZXRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdsdWUlMjIlMkMlMjAlMjJtbmxpJTIyKSUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJwcmVtaXNlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJoeXBvdGhlc2lzJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCUyQyUyMGJhdGNoX3NpemUlM0QxNiUyQyUyMHNodWZmbGUlM0RUcnVlJTBBKSUwQSUwQXZhbGlkYXRpb25fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnZhbGlkYXRpb25fbWF0Y2hlZCUyMiU1RC50b190Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQlMkMlMjBiYXRjaF9zaXplJTNEMTYlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUwQSklMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCklMEElMEFtb2RlbC5jb21waWxlKGxvc3MlM0QlMjJzcGFyc2VfY2F0ZWdvcmljYWxfY3Jvc3NlbnRyb3B5JTIyJTJDJTIwb3B0aW1pemVyJTNEJTIyYWRhbSUyMiklMEElMEFtb2RlbC5maXQodHJhaW5fZGF0YXNldCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    TFAutoModelForSequenceClassification,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)

train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].to_tf_dataset(
    columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>], batch_size=<span class="hljs-number">16</span>, shuffle=<span class="hljs-literal">True</span>
)

validation_dataset = tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>].to_tf_dataset(
    columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>], batch_size=<span class="hljs-number">16</span>, shuffle=<span class="hljs-literal">True</span>
)

model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint)

model.<span class="hljs-built_in">compile</span>(loss=<span class="hljs-string">&quot;sparse_categorical_crossentropy&quot;</span>, optimizer=<span class="hljs-string">&quot;adam&quot;</span>)

model.fit(train_dataset)`,wrap:!1}}),Z=new m({props:{code:"VmFsdWVFcnJvciUzQSUyME5vJTIwZ3JhZGllbnRzJTIwcHJvdmlkZWQlMjBmb3IlMjBhbnklMjB2YXJpYWJsZSUzQSUyMCU1Qid0Zl9kaXN0aWxfYmVydF9mb3Jfc2VxdWVuY2VfY2xhc3NpZmljYXRpb24lMkZkaXN0aWxiZXJ0JTJGZW1iZWRkaW5ncyUyRndvcmRfZW1iZWRkaW5ncyUyRndlaWdodCUzQTAnJTJDJTIwJy4uLiclNUQ=",highlighted:'ValueError: No gradients provided <span class="hljs-keyword">for</span> <span class="hljs-built_in">any</span> variable: [<span class="hljs-string">&#x27;tf_distil_bert_for_sequence_classification/distilbert/embeddings/word_embeddings/weight:0&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>]',wrap:!1}}),Y=new D({props:{title:"데이터 확인",local:"데이터-확인",headingTag:"h3"}}),F=new m({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataset:
    <span class="hljs-keyword">break</span>`,wrap:!1}}),H=new m({props:{code:"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",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">16</span>, <span class="hljs-number">76</span>), dtype=int64, numpy=
 array([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        ...,
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]])&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">16</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>])&gt;,
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">16</span>, <span class="hljs-number">76</span>), dtype=int64, numpy=
 array([[ <span class="hljs-number">101</span>, <span class="hljs-number">2174</span>, <span class="hljs-number">1010</span>, ...,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>],
        [ <span class="hljs-number">101</span>, <span class="hljs-number">3174</span>, <span class="hljs-number">2420</span>, ...,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>],
        [ <span class="hljs-number">101</span>, <span class="hljs-number">2044</span>, <span class="hljs-number">2048</span>, ...,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>],
        ...,
        [ <span class="hljs-number">101</span>, <span class="hljs-number">3398</span>, <span class="hljs-number">3398</span>, ..., <span class="hljs-number">2051</span>, <span class="hljs-number">2894</span>,  <span class="hljs-number">102</span>],
        [ <span class="hljs-number">101</span>, <span class="hljs-number">1996</span>, <span class="hljs-number">4124</span>, ...,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>],
        [ <span class="hljs-number">101</span>, <span class="hljs-number">1999</span>, <span class="hljs-number">2070</span>, ...,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>]])&gt;}`,wrap:!1}}),K=new m({props:{code:"bW9kZWwuY29tcGlsZShvcHRpbWl6ZXIlM0QlMjJhZGFtJTIyKQ==",highlighted:'model.<span class="hljs-built_in">compile</span>(optimizer=<span class="hljs-string">&quot;adam&quot;</span>)',wrap:!1}}),f=new cl({props:{$$slots:{default:[Ra]},$$scope:{ctx:h}}}),Ms=new m({props:{code:"JTIwJTIwMjQ2JTJGMjQ1NDMlMjAlNUIuLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4lNUQlMjAtJTIwRVRBJTNBJTIwMTUlM0E1MiUyMC0lMjBsb3NzJTNBJTIwbmFu",highlighted:'  <span class="hljs-number">246</span>/<span class="hljs-number">24543</span> [..............................] - ETA: <span class="hljs-number">15</span>:<span class="hljs-number">52</span> - loss: nan',wrap:!1}}),es=new D({props:{title:"모델 확인",local:"모델-확인",headingTag:"h3"}}),Js=new m({props:{code:"bW9kZWwoYmF0Y2gp",highlighted:"model(batch)",wrap:!1}}),ys=new m({props:{code:"VEZTZXF1ZW5jZUNsYXNzaWZpZXJPdXRwdXQobG9zcyUzRCUzQ3RmLlRlbnNvciUzQSUyMHNoYXBlJTNEKDE2JTJDKSUyQyUyMGR0eXBlJTNEZmxvYXQzMiUyQyUyMG51bXB5JTNEJTBBYXJyYXkoJTVCbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFuJTJDJTIwbmFuJTJDJTIwbmFuJTVEJTJDJTIwZHR5cGUlM0RmbG9hdDMyKSUzRSUyQyUyMGxvZ2l0cyUzRCUzQ3RmLlRlbnNvciUzQSUyMHNoYXBlJTNEKDE2JTJDJTIwMiklMkMlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMjBudW1weSUzRCUwQWFycmF5KCU1QiU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qm5hbiUyQyUyMG5hbiU1RCU1RCUyQyUyMGR0eXBlJTNEZmxvYXQzMiklM0UlMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`TFSequenceClassifierOutput(loss=&lt;tf.Tensor: shape=(<span class="hljs-number">16</span>,), dtype=float32, numpy=
array([nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
       nan, nan, nan], dtype=float32)&gt;, logits=&lt;tf.Tensor: shape=(<span class="hljs-number">16</span>, <span class="hljs-number">2</span>), dtype=float32, numpy=
array([[nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan],
       [nan, nan]], dtype=float32)&gt;, hidden_states=<span class="hljs-literal">None</span>, attentions=<span class="hljs-literal">None</span>)`,wrap:!1}}),ws=new m({props:{code:"bW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBbW9kZWwoYmF0Y2gp",highlighted:`model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint)
model(batch)`,wrap:!1}}),As=new m({props:{code:"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",highlighted:`TFSequenceClassifierOutput(loss=&lt;tf.Tensor: shape=(<span class="hljs-number">16</span>,), dtype=float32, numpy=
array([<span class="hljs-number">0.6844486</span> ,        nan,        nan, <span class="hljs-number">0.67127866</span>, <span class="hljs-number">0.7068601</span> ,
              nan, <span class="hljs-number">0.69309855</span>,        nan, <span class="hljs-number">0.65531296</span>,        nan,
              nan,        nan, <span class="hljs-number">0.675402</span>  ,        nan,        nan,
       <span class="hljs-number">0.69831556</span>], dtype=float32)&gt;, logits=&lt;tf.Tensor: shape=(<span class="hljs-number">16</span>, <span class="hljs-number">2</span>), dtype=float32, numpy=
array([[-<span class="hljs-number">0.04761693</span>, -<span class="hljs-number">0.06509043</span>],
       [-<span class="hljs-number">0.0481936</span> , -<span class="hljs-number">0.04556257</span>],
       [-<span class="hljs-number">0.0040929</span> , -<span class="hljs-number">0.05848458</span>],
       [-<span class="hljs-number">0.02417453</span>, -<span class="hljs-number">0.0684005</span> ],
       [-<span class="hljs-number">0.02517801</span>, -<span class="hljs-number">0.05241832</span>],
       [-<span class="hljs-number">0.04514256</span>, -<span class="hljs-number">0.0757378</span> ],
       [-<span class="hljs-number">0.02656011</span>, -<span class="hljs-number">0.02646275</span>],
       [ <span class="hljs-number">0.00766164</span>, -<span class="hljs-number">0.04350497</span>],
       [ <span class="hljs-number">0.02060014</span>, -<span class="hljs-number">0.05655622</span>],
       [-<span class="hljs-number">0.02615328</span>, -<span class="hljs-number">0.0447021</span> ],
       [-<span class="hljs-number">0.05119278</span>, -<span class="hljs-number">0.06928903</span>],
       [-<span class="hljs-number">0.02859691</span>, -<span class="hljs-number">0.04879177</span>],
       [-<span class="hljs-number">0.02210129</span>, -<span class="hljs-number">0.05791225</span>],
       [-<span class="hljs-number">0.02363213</span>, -<span class="hljs-number">0.05962167</span>],
       [-<span class="hljs-number">0.05352269</span>, -<span class="hljs-number">0.0481673</span> ],
       [-<span class="hljs-number">0.08141848</span>, -<span class="hljs-number">0.07110836</span>]], dtype=float32)&gt;, hidden_states=<span class="hljs-literal">None</span>, attentions=<span class="hljs-literal">None</span>)`,wrap:!1}}),ts=new m({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbG9zcyUyMCUzRCUyMG1vZGVsKGJhdGNoKS5sb3NzLm51bXB5KCklMEFpbmRpY2VzJTIwJTNEJTIwbnAuZmxhdG5vbnplcm8obnAuaXNuYW4obG9zcykpJTBBaW5kaWNlcw==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

loss = model(batch).loss.numpy()
indices = np.flatnonzero(np.isnan(loss))
indices`,wrap:!1}}),ms=new m({props:{code:"YXJyYXkoJTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjA1JTJDJTIwJTIwNyUyQyUyMCUyMDklMkMlMjAxMCUyQyUyMDExJTJDJTIwMTMlMkMlMjAxNCU1RCk=",highlighted:'array([ <span class="hljs-number">1</span>,  <span class="hljs-number">2</span>,  <span class="hljs-number">5</span>,  <span class="hljs-number">7</span>,  <span class="hljs-number">9</span>, <span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>])',wrap:!1}}),rs=new m({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQubnVtcHkoKSUwQWlucHV0X2lkcyU1QmluZGljZXMlNUQ=",highlighted:`input_ids = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].numpy()
input_ids[indices]`,wrap:!1}}),bs=new m({props:{code:"YXJyYXkoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMjAwNyUyQyUyMCUyMDIwMzIlMkMlMjAlMjAyMDAxJTJDJTIwJTIwMTAzNyUyQyUyMDE2NDgwJTJDJTIwJTIwMzkxNyUyQyUyMCUyMDI1OTQlMkMlMjAlMjA0MTM1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjMyMTIlMkMlMjAlMjAzMDcwJTJDJTIwJTIwMjIxNCUyQyUyMDEwMTcwJTJDJTIwJTIwMTAxMCUyQyUyMCUyMDIwMTIlMkMlMjAlMjA0MzU2JTJDJTIwJTIwMTk5NyUyQyUyMCUyMDMxODMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA2ODM4JTJDJTIwMTI5NTMlMkMlMjAlMjAyMDM5JTJDJTIwJTIwMjAwMCUyQyUyMCUyMDE5OTYlMkMlMjAlMjA2MTQ3JTJDJTIwJTIwMTk5NyUyQyUyMCUyMDIwMTAlMkMlMjAlMjAyNjA2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMDY4MzglMkMlMjAlMjAyMDAxJTJDJTIwJTIwMzI5NCUyQyUyMCUyMDY2MjUlMkMlMjAlMjAzNzczJTJDJTIwJTIwMTk5NiUyQyUyMCUyMDIyMTQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMTU4JTJDJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjAlMjAxMDElMkMlMjAlMjAxOTk4JTJDJTIwJTIwNjgxNCUyQyUyMCUyMDIwMTYlMkMlMjAlMjAyMjM0JTJDJTIwJTIwMjQ2MSUyQyUyMCUyMDIxNTMlMkMlMjAlMjAxOTk4JTJDJTIwMTMzMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDA5JTJDJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMDIwNDUlMkMlMjAlMjAxMDA1JTJDJTIwJTIwMTA1NSUyQyUyMCUyMDIwNTMlMkMlMjAlMjAzMzgyJTJDJTIwJTIwMjAwOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIwMTYlMkMlMjAlMjAxMDA1JTJDJTIwJTIwMjIyMiUyQyUyMCUyMDMwNDYlMkMlMjAlMjA4MTAzJTJDJTIwJTIwMjA3NSUyQyUyMCUyMDIwMDklMkMlMjAlMjAyMTUzJTJDJTIwJTIwMTAxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMCUyMDE5OTglMkMlMjAlMjAyMDA3JTJDJTIwJTIwMTk5NiUyQyUyMCUyMDM3MTIlMkMlMjAlMjA0NjM0JTJDJTIwJTIwMTAxMCUyQyUyMCUyMDIwNTclMkMlMjAlMjA4MTA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjAyNSUyQyUyMCUyMDM0MDQlMkMlMjAlMjAyMDI4JTJDJTIwJTIwMTAxMiUyQyUyMCUyMDE5OTYlMkMlMjAlMjAyNjE2JTJDJTIwMTg0NDklMkMlMjAlMjAyMTI1JTJDJTIwJTIwMTk5OSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDEwMzclMkMlMjAlMjA5NjY2JTJDJTIwJTIwMTk5NyUyQyUyMCUyMDQxMDAlMkMlMjAlMjA4NjYzJTJDJTIwMTEwMjAlMkMlMjAlMjA2MzEzJTJDJTIwJTIwMjc5MSUyQyUyMCUyMDE5OTglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyNDMxJTJDJTIwJTIwMTAxMSUyQyUyMCUyMDQzMDElMkMlMjAlMjAxMDEyJTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwMjAyOCUyQyUyMCUyMDEwMDUlMkMlMjAlMjAxMDU1JTJDJTIwJTIwNTE3NyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIxMTAlMkMlMjAlMjAxOTk4JTJDJTIwJTIwMzk3NyUyQyUyMCUyMDIwMDAlMkMlMjAlMjAyODMyJTJDJTIwJTIwMjEwNiUyQyUyMCUyMDIwMjUlMkMlMjAlMjAyNjg5JTJDJTIwJTIwMjEwNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIxMjIlMkMlMjAlMjA2MjE0JTJDJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMCUyMDEwNDUlMkMlMjAlMjAyMDAxJTJDJTIwJTIwMTk5OSUyQyUyMCUyMDEwMzclMkMlMjAxMzA5MCUyQyUyMCUyMDU5NDglMkMlMjAlMjAyMDA3JTJDJTIwJTIwMjA0OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIzMDglMkMlMjAlMjAyMDA2JTJDJTIwJTIwMjAyNiUyQyUyMCUyMDUwMDElMkMlMjAlMjAyMDQzJTJDJTIwJTIwMjAyNiUyQyUyMCUyMDIxNzElMkMlMjAlMjAyMDAxJTJDJTIwJTIwMjE3MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDEwMTIlMkMlMjAlMjAlMjAxMDIlMkMlMjAlMjAxMDQ1JTJDJTIwJTIwMjAwMSUyQyUyMCUyMDM1NjQlMkMlMjAlMjAxOTk5JTJDJTIwJTIwMjI3NyUyQyUyMCUyMDEwMTIlMkMlMjAlMjAlMjAxMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwMTAxJTJDJTIwJTIwMjE5NSUyQyUyMCUyMDQyNzklMkMlMjAlMjAyMTkxJTJDJTIwJTIwMjAzOSUyQyUyMCUyMDE5OTYlMkMlMjAlMjAyMTgxJTJDJTIwJTIwMjEyNCUyQyUyMCUyMDIwMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxOTk2JTJDJTIwJTIwMjIyNSUyQyUyMCUyMDczNjMlMkMlMjAlMjAxMDEyJTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwMjA0NSUyQyUyMCUyMDIwMDMlMkMlMjAlMjAyMDY5JTJDJTIwJTIwMjAyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDI0NTElMkMlMjAlMjAxOTk5JTJDJTIwJTIwMTk5NiUyQyUyMCUyMDIyMjUlMkMlMjAlMjA3MzYzJTJDJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMCUyMDIwNjElMkMlMjAlMjAyMDA4JTJDJTIwJTIwMTA0NSUyQyUyMCUyMDIxMjMlMkMlMjAlMjAxMDA1JTJDJTIwJTIwMTA1NiUyQyUyMCUyMDIxMTMlMkMlMjAlMjAyMDY1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjAwOSUyQyUyMCUyMDI0MjglMkMlMjAxMDY1NCUyQyUyMCUyMDczNDclMkMlMjAlMjAyMDMwJTJDJTIwJTIwMjAwOSUyQyUyMCUyMDcxMjYlMkMlMjAlMjAyMjU2JTJDJTIwJTIwMjQ5NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIyOTElMkMlMjAlMjAlMjAxMDIlMkMlMjAlMjAyMDA5JTJDJTIwJTIwMjAwMyUyQyUyMCUyMDUwOTQlMkMlMjAlMjAyMjU2JTJDJTIwJTIwMjQ5NSUyQyUyMCUyMDIyOTElMkMlMjAlMjAyMDM1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjEwNSUyQyUyMCUyMDEwMTIlMkMlMjAlMjAlMjAxMDIlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwMTAxJTJDJTIwJTIwMjA1MSUyQyUyMCUyMDEwMTAlMkMlMjAlMjAyMDI5JTJDJTIwJTIwMzIxNiUyQyUyMCUyMDIwMTklMkMlMjAlMjAyNTAzJTJDJTIwJTIwMzQ0NCUyQyUyMCUyMDEwMTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA2NzMyJTJDJTIwJTIwMTk5NiUyQyUyMCUyMDIyNjUlMkMlMjAlMjAyMDM4JTJDJTIwMTk4NDAlMkMlMjAlMjAyMDk4JTJDJTIwJTIwMjEyNSUyQyUyMCUyMDk5MDYlMkMlMjAlMjAxOTk4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjAwMyUyQyUyMCUyMDI3NzAlMkMlMjAlMjAyMDQxJTJDJTIwJTIwMTk5NyUyQyUyMCUyMDQ3ODQlMkMlMjAlMjAxMDEyJTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwMjA1MSUyQyUyMCUyMDY3MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxOTk2JTJDJTIwJTIwMjI2NSUyQyUyMCUyMDIwMDMlMkMlMjAlMjA5NTI1JTJDJTIwJTIwMTk5OCUyQyUyMCUyMDQ1NjklMkMlMjAlMjAxMDEyJTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjAlMjAxMDElMkMlMjAlMjAxOTk2JTJDJTIwMTA1NTYlMkMlMjAlMjAyMTQwJTJDJTIwMTE1MTUlMkMlMjAlMjAyMDU4JTJDJTIwJTIwMTAxMCUyQyUyMCUyMDIwMTAlMkMlMjAlMjAyMTYyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjI1MiUyQyUyMCUyMDU2ODklMkMlMjAlMjAyMDEzJTJDJTIwJTIwMjAxMCUyQyUyMCUyMDcyMjMlMkMlMjAlMjAxMDEyJTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwMjA0MyUyQyUyMCUyMDE5OTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDU1NiUyQyUyMCUyMDIxNDAlMkMlMjAxMTUxNSUyQyUyMCUyMDIwNTglMkMlMjAlMjAxMDEwJTJDJTIwJTIwMjAxMCUyQyUyMCUyMDIyNTIlMkMlMjAlMjAzMDYyJTJDJTIwJTIwMjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDE5OTYlMkMlMjAlMjAyNTk4JTJDJTIwJTIwMTAxMiUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMDEzNTQzJTJDJTIwJTIwMTk5OSUyQyUyMCUyMDIwNDklMkMlMjAlMjA2MTQzJTJDJTIwJTIwMjkzMyUyQyUyMCUyMDI0NDMlMkMlMjAlMjAlMjAxMDIlMkMlMjAlMjAyMDI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTM1NDMlMkMlMjAlMjAxOTk5JTJDJTIwJTIwNjE0MyUyQyUyMCUyMDI5MzMlMkMlMjAlMjAyMDAzJTJDJTIwJTIwMjQ0MyUyQyUyMCUyMCUyMDEwMiUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCU1RCk=",highlighted:`array([[  <span class="hljs-number">101</span>,  <span class="hljs-number">2007</span>,  <span class="hljs-number">2032</span>,  <span class="hljs-number">2001</span>,  <span class="hljs-number">1037</span>, <span class="hljs-number">16480</span>,  <span class="hljs-number">3917</span>,  <span class="hljs-number">2594</span>,  <span class="hljs-number">4135</span>,
        <span class="hljs-number">23212</span>,  <span class="hljs-number">3070</span>,  <span class="hljs-number">2214</span>, <span class="hljs-number">10170</span>,  <span class="hljs-number">1010</span>,  <span class="hljs-number">2012</span>,  <span class="hljs-number">4356</span>,  <span class="hljs-number">1997</span>,  <span class="hljs-number">3183</span>,
         <span class="hljs-number">6838</span>, <span class="hljs-number">12953</span>,  <span class="hljs-number">2039</span>,  <span class="hljs-number">2000</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">6147</span>,  <span class="hljs-number">1997</span>,  <span class="hljs-number">2010</span>,  <span class="hljs-number">2606</span>,
         <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">6838</span>,  <span class="hljs-number">2001</span>,  <span class="hljs-number">3294</span>,  <span class="hljs-number">6625</span>,  <span class="hljs-number">3773</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">2214</span>,
         <span class="hljs-number">2158</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">1998</span>,  <span class="hljs-number">6814</span>,  <span class="hljs-number">2016</span>,  <span class="hljs-number">2234</span>,  <span class="hljs-number">2461</span>,  <span class="hljs-number">2153</span>,  <span class="hljs-number">1998</span>, <span class="hljs-number">13322</span>,
         <span class="hljs-number">2009</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1055</span>,  <span class="hljs-number">2053</span>,  <span class="hljs-number">3382</span>,  <span class="hljs-number">2008</span>,
         <span class="hljs-number">2016</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">2222</span>,  <span class="hljs-number">3046</span>,  <span class="hljs-number">8103</span>,  <span class="hljs-number">2075</span>,  <span class="hljs-number">2009</span>,  <span class="hljs-number">2153</span>,  <span class="hljs-number">1012</span>,
          <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">1998</span>,  <span class="hljs-number">2007</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">3712</span>,  <span class="hljs-number">4634</span>,  <span class="hljs-number">1010</span>,  <span class="hljs-number">2057</span>,  <span class="hljs-number">8108</span>,
         <span class="hljs-number">2025</span>,  <span class="hljs-number">3404</span>,  <span class="hljs-number">2028</span>,  <span class="hljs-number">1012</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">2616</span>, <span class="hljs-number">18449</span>,  <span class="hljs-number">2125</span>,  <span class="hljs-number">1999</span>,
         <span class="hljs-number">1037</span>,  <span class="hljs-number">9666</span>,  <span class="hljs-number">1997</span>,  <span class="hljs-number">4100</span>,  <span class="hljs-number">8663</span>, <span class="hljs-number">11020</span>,  <span class="hljs-number">6313</span>,  <span class="hljs-number">2791</span>,  <span class="hljs-number">1998</span>,
         <span class="hljs-number">2431</span>,  <span class="hljs-number">1011</span>,  <span class="hljs-number">4301</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2028</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1055</span>,  <span class="hljs-number">5177</span>,
         <span class="hljs-number">2110</span>,  <span class="hljs-number">1998</span>,  <span class="hljs-number">3977</span>,  <span class="hljs-number">2000</span>,  <span class="hljs-number">2832</span>,  <span class="hljs-number">2106</span>,  <span class="hljs-number">2025</span>,  <span class="hljs-number">2689</span>,  <span class="hljs-number">2104</span>,
         <span class="hljs-number">2122</span>,  <span class="hljs-number">6214</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">2001</span>,  <span class="hljs-number">1999</span>,  <span class="hljs-number">1037</span>, <span class="hljs-number">13090</span>,  <span class="hljs-number">5948</span>,  <span class="hljs-number">2007</span>,  <span class="hljs-number">2048</span>,
         <span class="hljs-number">2308</span>,  <span class="hljs-number">2006</span>,  <span class="hljs-number">2026</span>,  <span class="hljs-number">5001</span>,  <span class="hljs-number">2043</span>,  <span class="hljs-number">2026</span>,  <span class="hljs-number">2171</span>,  <span class="hljs-number">2001</span>,  <span class="hljs-number">2170</span>,
         <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">2001</span>,  <span class="hljs-number">3564</span>,  <span class="hljs-number">1999</span>,  <span class="hljs-number">2277</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">2195</span>,  <span class="hljs-number">4279</span>,  <span class="hljs-number">2191</span>,  <span class="hljs-number">2039</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">2181</span>,  <span class="hljs-number">2124</span>,  <span class="hljs-number">2004</span>,
         <span class="hljs-number">1996</span>,  <span class="hljs-number">2225</span>,  <span class="hljs-number">7363</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2045</span>,  <span class="hljs-number">2003</span>,  <span class="hljs-number">2069</span>,  <span class="hljs-number">2028</span>,
         <span class="hljs-number">2451</span>,  <span class="hljs-number">1999</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">2225</span>,  <span class="hljs-number">7363</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">2061</span>,  <span class="hljs-number">2008</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">2123</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1056</span>,  <span class="hljs-number">2113</span>,  <span class="hljs-number">2065</span>,
         <span class="hljs-number">2009</span>,  <span class="hljs-number">2428</span>, <span class="hljs-number">10654</span>,  <span class="hljs-number">7347</span>,  <span class="hljs-number">2030</span>,  <span class="hljs-number">2009</span>,  <span class="hljs-number">7126</span>,  <span class="hljs-number">2256</span>,  <span class="hljs-number">2495</span>,
         <span class="hljs-number">2291</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2009</span>,  <span class="hljs-number">2003</span>,  <span class="hljs-number">5094</span>,  <span class="hljs-number">2256</span>,  <span class="hljs-number">2495</span>,  <span class="hljs-number">2291</span>,  <span class="hljs-number">2035</span>,
         <span class="hljs-number">2105</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">2051</span>,  <span class="hljs-number">1010</span>,  <span class="hljs-number">2029</span>,  <span class="hljs-number">3216</span>,  <span class="hljs-number">2019</span>,  <span class="hljs-number">2503</span>,  <span class="hljs-number">3444</span>,  <span class="hljs-number">1010</span>,
         <span class="hljs-number">6732</span>,  <span class="hljs-number">1996</span>,  <span class="hljs-number">2265</span>,  <span class="hljs-number">2038</span>, <span class="hljs-number">19840</span>,  <span class="hljs-number">2098</span>,  <span class="hljs-number">2125</span>,  <span class="hljs-number">9906</span>,  <span class="hljs-number">1998</span>,
         <span class="hljs-number">2003</span>,  <span class="hljs-number">2770</span>,  <span class="hljs-number">2041</span>,  <span class="hljs-number">1997</span>,  <span class="hljs-number">4784</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2051</span>,  <span class="hljs-number">6732</span>,
         <span class="hljs-number">1996</span>,  <span class="hljs-number">2265</span>,  <span class="hljs-number">2003</span>,  <span class="hljs-number">9525</span>,  <span class="hljs-number">1998</span>,  <span class="hljs-number">4569</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>,  <span class="hljs-number">1996</span>, <span class="hljs-number">10556</span>,  <span class="hljs-number">2140</span>, <span class="hljs-number">11515</span>,  <span class="hljs-number">2058</span>,  <span class="hljs-number">1010</span>,  <span class="hljs-number">2010</span>,  <span class="hljs-number">2162</span>,
         <span class="hljs-number">2252</span>,  <span class="hljs-number">5689</span>,  <span class="hljs-number">2013</span>,  <span class="hljs-number">2010</span>,  <span class="hljs-number">7223</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2043</span>,  <span class="hljs-number">1996</span>,
        <span class="hljs-number">10556</span>,  <span class="hljs-number">2140</span>, <span class="hljs-number">11515</span>,  <span class="hljs-number">2058</span>,  <span class="hljs-number">1010</span>,  <span class="hljs-number">2010</span>,  <span class="hljs-number">2252</span>,  <span class="hljs-number">3062</span>,  <span class="hljs-number">2000</span>,
         <span class="hljs-number">1996</span>,  <span class="hljs-number">2598</span>,  <span class="hljs-number">1012</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
       [  <span class="hljs-number">101</span>, <span class="hljs-number">13543</span>,  <span class="hljs-number">1999</span>,  <span class="hljs-number">2049</span>,  <span class="hljs-number">6143</span>,  <span class="hljs-number">2933</span>,  <span class="hljs-number">2443</span>,   <span class="hljs-number">102</span>,  <span class="hljs-number">2025</span>,
        <span class="hljs-number">13543</span>,  <span class="hljs-number">1999</span>,  <span class="hljs-number">6143</span>,  <span class="hljs-number">2933</span>,  <span class="hljs-number">2003</span>,  <span class="hljs-number">2443</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,
            <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>]])`,wrap:!1}}),hs=new m({props:{code:"bGFiZWxzJTIwJTNEJTIwYmF0Y2glNUInbGFiZWxzJyU1RC5udW1weSgpJTBBbGFiZWxzJTVCaW5kaWNlcyU1RA==",highlighted:`labels = batch[<span class="hljs-string">&#x27;labels&#x27;</span>].numpy()
labels[indices]`,wrap:!1}}),Ds=new m({props:{code:"YXJyYXkoJTVCMiUyQyUyMDIlMkMlMjAyJTJDJTIwMiUyQyUyMDIlMkMlMjAyJTJDJTIwMiUyQyUyMDIlMkMlMjAyJTVEKQ==",highlighted:'array([<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>])',wrap:!1}}),Qs=new m({props:{code:"bW9kZWwuY29uZmlnLm51bV9sYWJlbHM=",highlighted:"model.config.num_labels",wrap:!1}}),ks=new m({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),os=new m({props:{code:"bW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMyklMEFtb2RlbC5jb21waWxlKG9wdGltaXplciUzRCdhZGFtJyklMEFtb2RlbC5maXQodHJhaW5fZGF0YXNldCk=",highlighted:`model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint, <span class="hljs-attribute">num_labels</span>=3)
model.compile(<span class="hljs-attribute">optimizer</span>=<span class="hljs-string">&#x27;adam&#x27;</span>)
model.fit(train_dataset)`,wrap:!1}}),$s=new m({props:{code:"JTIwJTIwODY5JTJGMjQ1NDMlMjAlNUIlM0UuLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLiU1RCUyMC0lMjBFVEElM0ElMjAxNSUzQTI5JTIwLSUyMGxvc3MlM0ElMjAxLjEwMzI=",highlighted:'  <span class="hljs-number">869</span>/<span class="hljs-number">24543</span> [&gt;.............................] - ETA: <span class="hljs-number">15</span>:<span class="hljs-number">29</span> - loss: <span class="hljs-number">1.1032</span>',wrap:!1}}),Ns=new D({props:{title:"하이퍼파라미터 확인",local:"하이퍼파라미터-확인",headingTag:"h3"}}),vs=new m({props:{code:"ZnJvbSUyMHRlbnNvcmZsb3cua2VyYXMub3B0aW1pemVycyUyMGltcG9ydCUyMEFkYW0lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCklMEFtb2RlbC5jb21waWxlKG9wdGltaXplciUzREFkYW0oNWUtNSkp",highlighted:`<span class="hljs-keyword">from</span> tensorflow.keras.optimizers <span class="hljs-keyword">import</span> Adam

model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint)
model.<span class="hljs-built_in">compile</span>(optimizer=Adam(<span class="hljs-number">5e-5</span>))`,wrap:!1}}),o=new cl({props:{$$slots:{default:[ga]},$$scope:{ctx:h}}}),Rs=new m({props:{code:"bW9kZWwuZml0KHRyYWluX2RhdGFzZXQp",highlighted:"model.fit(train_dataset)",wrap:!1}}),gs=new m({props:{code:"MzE5JTJGMjQ1NDMlMjAlNUIuLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4lNUQlMjAtJTIwRVRBJTNBJTIwMTYlM0EwNyUyMC0lMjBsb3NzJTNBJTIwMC45NzE4",highlighted:'<span class="hljs-number">319</span>/<span class="hljs-number">24543</span> [..............................] - ETA: <span class="hljs-number">16</span>:07 - loss: <span class="hljs-number">0.9718</span>',wrap:!1}}),Ss=new D({props:{title:"다른 잠재적 이슈들",local:"다른-잠재적-이슈들",headingTag:"h2"}}),Zs=new D({props:{title:"메모리 부족 에러 처리",local:"메모리-부족-에러-처리",headingTag:"h3"}}),$=new cl({props:{$$slots:{default:[_a]},$$scope:{ctx:h}}}),Ys=new D({props:{title:"몹시 배고픈 TensorFlow 🦛",local:"몹시-배고픈-tensorflow-",headingTag:"h3"}}),Ws=new D({props:{title:"데이터 확인 (다시!)",local:"데이터-확인-다시",headingTag:"h3"}}),Ps=new m({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQubnVtcHkoKSUwQXRva2VuaXplci5kZWNvZGUoaW5wdXRfaWRzJTVCMCU1RCk=",highlighted:`input_ids = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].numpy()
tokenizer.decode(input_ids[<span class="hljs-number">0</span>])`,wrap:!1}}),qs=new m({props:{code:"bGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQubnVtcHkoKSUwQWxhYmVsJTIwJTNEJTIwbGFiZWxzJTVCMCU1RA==",highlighted:`labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].numpy()
label = labels[<span class="hljs-number">0</span>]`,wrap:!1}}),al=new D({props:{title:"한 배치에서 모델 과대적합",local:"한-배치에서-모델-과대적합",headingTag:"h3"}}),pl=new m({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSUwQSUyMyUyME1ha2UlMjBzdXJlJTIweW91JTIwaGF2ZSUyMHJ1biUyMG1vZGVsLmNvbXBpbGUoKSUyMGFuZCUyMHNldCUyMHlvdXIlMjBvcHRpbWl6ZXIlMkMlMEElMjMlMjBhbmQlMjB5b3VyJTIwbG9zcyUyRm1ldHJpY3MlMjBpZiUyMHlvdSdyZSUyMHVzaW5nJTIwdGhlbSUwQSUwQW1vZGVsLmZpdChiYXRjaCUyQyUyMGVwb2NocyUzRDIwKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataset:
    <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Make sure you have run model.compile() and set your optimizer,</span>
<span class="hljs-comment"># and your loss/metrics if you&#x27;re using them</span>

model.fit(batch, epochs=<span class="hljs-number">20</span>)`,wrap:!1}}),d=new cl({props:{$$slots:{default:[Sa]},$$scope:{ctx:h}}}),N=new cl({props:{warning:!0,$$slots:{default:[Ga]},$$scope:{ctx:h}}}),Tl=new D({props:{title:"첫 번째 기준이 생길 때까지 아무 것도 조정하지 마세요.",local:"첫-번째-기준이-생길-때까지-아무-것도-조정하지-마세요",headingTag:"h3"}}),Al=new D({props:{title:"도움 요청하기",local:"도움-요청하기",headingTag:"h3"}}),rl=new za({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ko/chapter8/4_tf.mdx"}}),{c(){y=j("meta"),r=a(),t=j("p"),u=a(),T(i.$$.fragment),k=a(),T(c.$$.fragment),x=a(),T(b.$$.fragment),Q=a(),E=j("p"),E.innerHTML=tn,Dl=a(),T(B.$$.fragment),il=a(),T(v.$$.fragment),Ql=a(),z=j("p"),z.innerHTML=mn,kl=a(),R=j("p"),R.innerHTML=un,fl=a(),g=j("p"),g.innerHTML=rn,ol=a(),T(_.$$.fragment),$l=a(),S=j("p"),S.textContent=bn,dl=a(),G=j("p"),G.textContent=cn,Nl=a(),T(Z.$$.fragment),xl=a(),L=j("p"),L.textContent=hn,El=a(),T(Y.$$.fragment),Bl=a(),X=j("p"),X.textContent=Dn,vl=a(),V=j("p"),V.innerHTML=Qn,zl=a(),T(F.$$.fragment),Rl=a(),W=j("p"),W.innerHTML=kn,gl=a(),T(H.$$.fragment),_l=a(),P=j("p"),P.textContent=fn,Sl=a(),O=j("p"),O.innerHTML=on,Gl=a(),q=j("p"),q.innerHTML=$n,Zl=a(),T(K.$$.fragment),Ll=a(),ss=j("p"),ss.textContent=dn,Yl=a(),T(f.$$.fragment),Xl=a(),ls=j("p"),ls.innerHTML=Nn,Vl=a(),T(Ms.$$.fragment),Fl=a(),ns=j("p"),ns.textContent=xn,Wl=a(),as=j("p"),as.innerHTML=En,Hl=a(),T(es.$$.fragment),Pl=a(),js=j("p"),js.innerHTML=Bn,Ol=a(),ps=j("p"),ps.innerHTML=vn,ql=a(),T(Js.$$.fragment),Kl=a(),T(ys.$$.fragment),sM=a(),Ts=j("p"),Ts.innerHTML=zn,lM=a(),Us=j("p"),Us.innerHTML=Rn,MM=a(),T(ws.$$.fragment),nM=a(),Is=j("p"),Is.textContent=gn,aM=a(),T(As.$$.fragment),eM=a(),Cs=j("p"),Cs.innerHTML=_n,jM=a(),T(ts.$$.fragment),pM=a(),T(ms.$$.fragment),JM=a(),us=j("p"),us.textContent=Sn,yM=a(),T(rs.$$.fragment),TM=a(),T(bs.$$.fragment),UM=a(),cs=j("p"),cs.textContent=Gn,wM=a(),T(hs.$$.fragment),IM=a(),T(Ds.$$.fragment),AM=a(),is=j("p"),is.innerHTML=Zn,CM=a(),T(Qs.$$.fragment),tM=a(),T(ks.$$.fragment),mM=a(),fs=j("p"),fs.innerHTML=Ln,uM=a(),T(os.$$.fragment),rM=a(),T($s.$$.fragment),bM=a(),ds=j("p"),ds.innerHTML=Yn,cM=a(),T(Ns.$$.fragment),hM=a(),xs=j("p"),xs.innerHTML=Xn,DM=a(),Es=j("p"),Es.innerHTML=Vn,iM=a(),Bs=j("p"),Bs.innerHTML=Fn,QM=a(),T(vs.$$.fragment),kM=a(),T(o.$$.fragment),fM=a(),zs=j("p"),zs.textContent=Wn,oM=a(),T(Rs.$$.fragment),$M=a(),T(gs.$$.fragment),dM=a(),_s=j("p"),_s.textContent=Hn,NM=a(),T(Ss.$$.fragment),xM=a(),Gs=j("p"),Gs.textContent=Pn,EM=a(),T(Zs.$$.fragment),BM=a(),Ls=j("p"),Ls.innerHTML=On,vM=a(),T($.$$.fragment),zM=a(),T(Ys.$$.fragment),RM=a(),Xs=j("p"),Xs.innerHTML=qn,gM=a(),Vs=j("p"),Vs.textContent=Kn,_M=a(),Fs=j("p"),Fs.innerHTML=sa,SM=a(),T(Ws.$$.fragment),GM=a(),Hs=j("p"),Hs.innerHTML=la,ZM=a(),T(Ps.$$.fragment),LM=a(),Os=j("p"),Os.textContent=Ma,YM=a(),T(qs.$$.fragment),XM=a(),Ks=j("p"),Ks.textContent=na,VM=a(),sl=j("ul"),sl.innerHTML=aa,FM=a(),ll=j("p"),ll.textContent=ea,WM=a(),Ml=j("p"),Ml.textContent=ja,HM=a(),nl=j("p"),nl.textContent=pa,PM=a(),T(al.$$.fragment),OM=a(),el=j("p"),el.textContent=Ja,qM=a(),jl=j("p"),jl.innerHTML=ya,KM=a(),T(pl.$$.fragment),sn=a(),T(d.$$.fragment),ln=a(),Jl=j("p"),Jl.innerHTML=Ta,Mn=a(),yl=j("p"),yl.textContent=Ua,nn=a(),T(N.$$.fragment),an=a(),T(Tl.$$.fragment),en=a(),Ul=j("p"),Ul.innerHTML=wa,jn=a(),wl=j("p"),wl.textContent=Ia,pn=a(),Il=j("p"),Il.textContent=Aa,Jn=a(),T(Al.$$.fragment),yn=a(),Cl=j("p"),Cl.innerHTML=Ca,Tn=a(),tl=j("p"),tl.textContent=ta,Un=a(),ml=j("ul"),ml.innerHTML=ma,wn=a(),ul=j("p"),ul.textContent=ua,In=a(),T(rl.$$.fragment),An=a(),bl=j("p"),this.h()},l(s){const l=Na("svelte-u9bgzb",document.head);y=p(l,"META",{name:!0,content:!0}),l.forEach(M),r=e(s),t=p(s,"P",{}),Qa(t).forEach(M),u=e(s),U(i.$$.fragment,s),k=e(s),U(c.$$.fragment,s),x=e(s),U(b.$$.fragment,s),Q=e(s),E=p(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-1kcrir3"&&(E.innerHTML=tn),Dl=e(s),U(B.$$.fragment,s),il=e(s),U(v.$$.fragment,s),Ql=e(s),z=p(s,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1avuq2"&&(z.innerHTML=mn),kl=e(s),R=p(s,"P",{"data-svelte-h":!0}),J(R)!=="svelte-9llt36"&&(R.innerHTML=un),fl=e(s),g=p(s,"P",{"data-svelte-h":!0}),J(g)!=="svelte-r6t8uz"&&(g.innerHTML=rn),ol=e(s),U(_.$$.fragment,s),$l=e(s),S=p(s,"P",{"data-svelte-h":!0}),J(S)!=="svelte-40kgcj"&&(S.textContent=bn),dl=e(s),G=p(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-bxilxd"&&(G.textContent=cn),Nl=e(s),U(Z.$$.fragment,s),xl=e(s),L=p(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-rlzrsr"&&(L.textContent=hn),El=e(s),U(Y.$$.fragment,s),Bl=e(s),X=p(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-w257ih"&&(X.textContent=Dn),vl=e(s),V=p(s,"P",{"data-svelte-h":!0}),J(V)!=="svelte-gk453o"&&(V.innerHTML=Qn),zl=e(s),U(F.$$.fragment,s),Rl=e(s),W=p(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1h86zuv"&&(W.innerHTML=kn),gl=e(s),U(H.$$.fragment,s),_l=e(s),P=p(s,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1j9wapy"&&(P.textContent=fn),Sl=e(s),O=p(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-oqj6th"&&(O.innerHTML=on),Gl=e(s),q=p(s,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1mr64tu"&&(q.innerHTML=$n),Zl=e(s),U(K.$$.fragment,s),Ll=e(s),ss=p(s,"P",{"data-svelte-h":!0}),J(ss)!=="svelte-sd5bej"&&(ss.textContent=dn),Yl=e(s),U(f.$$.fragment,s),Xl=e(s),ls=p(s,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-1jxzieg"&&(ls.innerHTML=Nn),Vl=e(s),U(Ms.$$.fragment,s),Fl=e(s),ns=p(s,"P",{"data-svelte-h":!0}),J(ns)!=="svelte-1s5r1pi"&&(ns.textContent=xn),Wl=e(s),as=p(s,"P",{"data-svelte-h":!0}),J(as)!=="svelte-xa7xl5"&&(as.innerHTML=En),Hl=e(s),U(es.$$.fragment,s),Pl=e(s),js=p(s,"P",{"data-svelte-h":!0}),J(js)!=="svelte-1p1hol7"&&(js.innerHTML=Bn),Ol=e(s),ps=p(s,"P",{"data-svelte-h":!0}),J(ps)!=="svelte-1albpi4"&&(ps.innerHTML=vn),ql=e(s),U(Js.$$.fragment,s),Kl=e(s),U(ys.$$.fragment,s),sM=e(s),Ts=p(s,"P",{"data-svelte-h":!0}),J(Ts)!=="svelte-1p1f1om"&&(Ts.innerHTML=zn),lM=e(s),Us=p(s,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-o4k5wq"&&(Us.innerHTML=Rn),MM=e(s),U(ws.$$.fragment,s),nM=e(s),Is=p(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-w7b5dh"&&(Is.textContent=gn),aM=e(s),U(As.$$.fragment,s),eM=e(s),Cs=p(s,"P",{"data-svelte-h":!0}),J(Cs)!=="svelte-dapu32"&&(Cs.innerHTML=_n),jM=e(s),U(ts.$$.fragment,s),pM=e(s),U(ms.$$.fragment,s),JM=e(s),us=p(s,"P",{"data-svelte-h":!0}),J(us)!=="svelte-u8yu28"&&(us.textContent=Sn),yM=e(s),U(rs.$$.fragment,s),TM=e(s),U(bs.$$.fragment,s),UM=e(s),cs=p(s,"P",{"data-svelte-h":!0}),J(cs)!=="svelte-xgeoke"&&(cs.textContent=Gn),wM=e(s),U(hs.$$.fragment,s),IM=e(s),U(Ds.$$.fragment,s),AM=e(s),is=p(s,"P",{"data-svelte-h":!0}),J(is)!=="svelte-16tn8gv"&&(is.innerHTML=Zn),CM=e(s),U(Qs.$$.fragment,s),tM=e(s),U(ks.$$.fragment,s),mM=e(s),fs=p(s,"P",{"data-svelte-h":!0}),J(fs)!=="svelte-1655wqp"&&(fs.innerHTML=Ln),uM=e(s),U(os.$$.fragment,s),rM=e(s),U($s.$$.fragment,s),bM=e(s),ds=p(s,"P",{"data-svelte-h":!0}),J(ds)!=="svelte-ozv4ae"&&(ds.innerHTML=Yn),cM=e(s),U(Ns.$$.fragment,s),hM=e(s),xs=p(s,"P",{"data-svelte-h":!0}),J(xs)!=="svelte-iuysvc"&&(xs.innerHTML=Xn),DM=e(s),Es=p(s,"P",{"data-svelte-h":!0}),J(Es)!=="svelte-1jnxgvj"&&(Es.innerHTML=Vn),iM=e(s),Bs=p(s,"P",{"data-svelte-h":!0}),J(Bs)!=="svelte-111kjn3"&&(Bs.innerHTML=Fn),QM=e(s),U(vs.$$.fragment,s),kM=e(s),U(o.$$.fragment,s),fM=e(s),zs=p(s,"P",{"data-svelte-h":!0}),J(zs)!=="svelte-g17ly2"&&(zs.textContent=Wn),oM=e(s),U(Rs.$$.fragment,s),$M=e(s),U(gs.$$.fragment,s),dM=e(s),_s=p(s,"P",{"data-svelte-h":!0}),J(_s)!=="svelte-oe6a8g"&&(_s.textContent=Hn),NM=e(s),U(Ss.$$.fragment,s),xM=e(s),Gs=p(s,"P",{"data-svelte-h":!0}),J(Gs)!=="svelte-1kxph3g"&&(Gs.textContent=Pn),EM=e(s),U(Zs.$$.fragment,s),BM=e(s),Ls=p(s,"P",{"data-svelte-h":!0}),J(Ls)!=="svelte-1j09zk0"&&(Ls.innerHTML=On),vM=e(s),U($.$$.fragment,s),zM=e(s),U(Ys.$$.fragment,s),RM=e(s),Xs=p(s,"P",{"data-svelte-h":!0}),J(Xs)!=="svelte-1nwv35e"&&(Xs.innerHTML=qn),gM=e(s),Vs=p(s,"P",{"data-svelte-h":!0}),J(Vs)!=="svelte-p3j0jd"&&(Vs.textContent=Kn),_M=e(s),Fs=p(s,"P",{"data-svelte-h":!0}),J(Fs)!=="svelte-1ju2lxn"&&(Fs.innerHTML=sa),SM=e(s),U(Ws.$$.fragment,s),GM=e(s),Hs=p(s,"P",{"data-svelte-h":!0}),J(Hs)!=="svelte-i6ldmb"&&(Hs.innerHTML=la),ZM=e(s),U(Ps.$$.fragment,s),LM=e(s),Os=p(s,"P",{"data-svelte-h":!0}),J(Os)!=="svelte-ytc4fo"&&(Os.textContent=Ma),YM=e(s),U(qs.$$.fragment,s),XM=e(s),Ks=p(s,"P",{"data-svelte-h":!0}),J(Ks)!=="svelte-dqde3k"&&(Ks.textContent=na),VM=e(s),sl=p(s,"UL",{"data-svelte-h":!0}),J(sl)!=="svelte-ox4153"&&(sl.innerHTML=aa),FM=e(s),ll=p(s,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-16xks0t"&&(ll.textContent=ea),WM=e(s),Ml=p(s,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-1c1wmvs"&&(Ml.textContent=ja),HM=e(s),nl=p(s,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-1kh2cpo"&&(nl.textContent=pa),PM=e(s),U(al.$$.fragment,s),OM=e(s),el=p(s,"P",{"data-svelte-h":!0}),J(el)!=="svelte-1qhrfix"&&(el.textContent=Ja),qM=e(s),jl=p(s,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-1aghpsw"&&(jl.innerHTML=ya),KM=e(s),U(pl.$$.fragment,s),sn=e(s),U(d.$$.fragment,s),ln=e(s),Jl=p(s,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-10d44b4"&&(Jl.innerHTML=Ta),Mn=e(s),yl=p(s,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-5narjn"&&(yl.textContent=Ua),nn=e(s),U(N.$$.fragment,s),an=e(s),U(Tl.$$.fragment,s),en=e(s),Ul=p(s,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-hedtof"&&(Ul.innerHTML=wa),jn=e(s),wl=p(s,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-fd3fh3"&&(wl.textContent=Ia),pn=e(s),Il=p(s,"P",{"data-svelte-h":!0}),J(Il)!=="svelte-r9yjuu"&&(Il.textContent=Aa),Jn=e(s),U(Al.$$.fragment,s),yn=e(s),Cl=p(s,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-3o51s0"&&(Cl.innerHTML=Ca),Tn=e(s),tl=p(s,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-1iluomu"&&(tl.textContent=ta),Un=e(s),ml=p(s,"UL",{"data-svelte-h":!0}),J(ml)!=="svelte-vkgmp2"&&(ml.innerHTML=ma),wn=e(s),ul=p(s,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-17eyduh"&&(ul.textContent=ua),In=e(s),U(rl.$$.fragment,s),An=e(s),bl=p(s,"P",{}),Qa(bl).forEach(M),this.h()},h(){ka(y,"name","hf:doc:metadata"),ka(y,"content",La)},m(s,l){xa(document.head,y),n(s,r,l),n(s,t,l),n(s,u,l),w(i,s,l),n(s,k,l),w(c,s,l),n(s,x,l),w(b,s,l),n(s,Q,l),n(s,E,l),n(s,Dl,l),w(B,s,l),n(s,il,l),w(v,s,l),n(s,Ql,l),n(s,z,l),n(s,kl,l),n(s,R,l),n(s,fl,l),n(s,g,l),n(s,ol,l),w(_,s,l),n(s,$l,l),n(s,S,l),n(s,dl,l),n(s,G,l),n(s,Nl,l),w(Z,s,l),n(s,xl,l),n(s,L,l),n(s,El,l),w(Y,s,l),n(s,Bl,l),n(s,X,l),n(s,vl,l),n(s,V,l),n(s,zl,l),w(F,s,l),n(s,Rl,l),n(s,W,l),n(s,gl,l),w(H,s,l),n(s,_l,l),n(s,P,l),n(s,Sl,l),n(s,O,l),n(s,Gl,l),n(s,q,l),n(s,Zl,l),w(K,s,l),n(s,Ll,l),n(s,ss,l),n(s,Yl,l),w(f,s,l),n(s,Xl,l),n(s,ls,l),n(s,Vl,l),w(Ms,s,l),n(s,Fl,l),n(s,ns,l),n(s,Wl,l),n(s,as,l),n(s,Hl,l),w(es,s,l),n(s,Pl,l),n(s,js,l),n(s,Ol,l),n(s,ps,l),n(s,ql,l),w(Js,s,l),n(s,Kl,l),w(ys,s,l),n(s,sM,l),n(s,Ts,l),n(s,lM,l),n(s,Us,l),n(s,MM,l),w(ws,s,l),n(s,nM,l),n(s,Is,l),n(s,aM,l),w(As,s,l),n(s,eM,l),n(s,Cs,l),n(s,jM,l),w(ts,s,l),n(s,pM,l),w(ms,s,l),n(s,JM,l),n(s,us,l),n(s,yM,l),w(rs,s,l),n(s,TM,l),w(bs,s,l),n(s,UM,l),n(s,cs,l),n(s,wM,l),w(hs,s,l),n(s,IM,l),w(Ds,s,l),n(s,AM,l),n(s,is,l),n(s,CM,l),w(Qs,s,l),n(s,tM,l),w(ks,s,l),n(s,mM,l),n(s,fs,l),n(s,uM,l),w(os,s,l),n(s,rM,l),w($s,s,l),n(s,bM,l),n(s,ds,l),n(s,cM,l),w(Ns,s,l),n(s,hM,l),n(s,xs,l),n(s,DM,l),n(s,Es,l),n(s,iM,l),n(s,Bs,l),n(s,QM,l),w(vs,s,l),n(s,kM,l),w(o,s,l),n(s,fM,l),n(s,zs,l),n(s,oM,l),w(Rs,s,l),n(s,$M,l),w(gs,s,l),n(s,dM,l),n(s,_s,l),n(s,NM,l),w(Ss,s,l),n(s,xM,l),n(s,Gs,l),n(s,EM,l),w(Zs,s,l),n(s,BM,l),n(s,Ls,l),n(s,vM,l),w($,s,l),n(s,zM,l),w(Ys,s,l),n(s,RM,l),n(s,Xs,l),n(s,gM,l),n(s,Vs,l),n(s,_M,l),n(s,Fs,l),n(s,SM,l),w(Ws,s,l),n(s,GM,l),n(s,Hs,l),n(s,ZM,l),w(Ps,s,l),n(s,LM,l),n(s,Os,l),n(s,YM,l),w(qs,s,l),n(s,XM,l),n(s,Ks,l),n(s,VM,l),n(s,sl,l),n(s,FM,l),n(s,ll,l),n(s,WM,l),n(s,Ml,l),n(s,HM,l),n(s,nl,l),n(s,PM,l),w(al,s,l),n(s,OM,l),n(s,el,l),n(s,qM,l),n(s,jl,l),n(s,KM,l),w(pl,s,l),n(s,sn,l),w(d,s,l),n(s,ln,l),n(s,Jl,l),n(s,Mn,l),n(s,yl,l),n(s,nn,l),w(N,s,l),n(s,an,l),w(Tl,s,l),n(s,en,l),n(s,Ul,l),n(s,jn,l),n(s,wl,l),n(s,pn,l),n(s,Il,l),n(s,Jn,l),w(Al,s,l),n(s,yn,l),n(s,Cl,l),n(s,Tn,l),n(s,tl,l),n(s,Un,l),n(s,ml,l),n(s,wn,l),n(s,ul,l),n(s,In,l),w(rl,s,l),n(s,An,l),n(s,bl,l),Cn=!0},p(s,[l]){const ra={};l&1&&(ra.fw=s[0]),i.$set(ra);const ba={};l&2&&(ba.$$scope={dirty:l,ctx:s}),f.$set(ba);const ca={};l&2&&(ca.$$scope={dirty:l,ctx:s}),o.$set(ca);const ha={};l&2&&(ha.$$scope={dirty:l,ctx:s}),$.$set(ha);const Da={};l&2&&(Da.$$scope={dirty:l,ctx:s}),d.$set(Da);const ia={};l&2&&(ia.$$scope={dirty:l,ctx:s}),N.$set(ia)},i(s){Cn||(I(i.$$.fragment,s),I(c.$$.fragment,s),I(b.$$.fragment,s),I(B.$$.fragment,s),I(v.$$.fragment,s),I(_.$$.fragment,s),I(Z.$$.fragment,s),I(Y.$$.fragment,s),I(F.$$.fragment,s),I(H.$$.fragment,s),I(K.$$.fragment,s),I(f.$$.fragment,s),I(Ms.$$.fragment,s),I(es.$$.fragment,s),I(Js.$$.fragment,s),I(ys.$$.fragment,s),I(ws.$$.fragment,s),I(As.$$.fragment,s),I(ts.$$.fragment,s),I(ms.$$.fragment,s),I(rs.$$.fragment,s),I(bs.$$.fragment,s),I(hs.$$.fragment,s),I(Ds.$$.fragment,s),I(Qs.$$.fragment,s),I(ks.$$.fragment,s),I(os.$$.fragment,s),I($s.$$.fragment,s),I(Ns.$$.fragment,s),I(vs.$$.fragment,s),I(o.$$.fragment,s),I(Rs.$$.fragment,s),I(gs.$$.fragment,s),I(Ss.$$.fragment,s),I(Zs.$$.fragment,s),I($.$$.fragment,s),I(Ys.$$.fragment,s),I(Ws.$$.fragment,s),I(Ps.$$.fragment,s),I(qs.$$.fragment,s),I(al.$$.fragment,s),I(pl.$$.fragment,s),I(d.$$.fragment,s),I(N.$$.fragment,s),I(Tl.$$.fragment,s),I(Al.$$.fragment,s),I(rl.$$.fragment,s),Cn=!0)},o(s){A(i.$$.fragment,s),A(c.$$.fragment,s),A(b.$$.fragment,s),A(B.$$.fragment,s),A(v.$$.fragment,s),A(_.$$.fragment,s),A(Z.$$.fragment,s),A(Y.$$.fragment,s),A(F.$$.fragment,s),A(H.$$.fragment,s),A(K.$$.fragment,s),A(f.$$.fragment,s),A(Ms.$$.fragment,s),A(es.$$.fragment,s),A(Js.$$.fragment,s),A(ys.$$.fragment,s),A(ws.$$.fragment,s),A(As.$$.fragment,s),A(ts.$$.fragment,s),A(ms.$$.fragment,s),A(rs.$$.fragment,s),A(bs.$$.fragment,s),A(hs.$$.fragment,s),A(Ds.$$.fragment,s),A(Qs.$$.fragment,s),A(ks.$$.fragment,s),A(os.$$.fragment,s),A($s.$$.fragment,s),A(Ns.$$.fragment,s),A(vs.$$.fragment,s),A(o.$$.fragment,s),A(Rs.$$.fragment,s),A(gs.$$.fragment,s),A(Ss.$$.fragment,s),A(Zs.$$.fragment,s),A($.$$.fragment,s),A(Ys.$$.fragment,s),A(Ws.$$.fragment,s),A(Ps.$$.fragment,s),A(qs.$$.fragment,s),A(al.$$.fragment,s),A(pl.$$.fragment,s),A(d.$$.fragment,s),A(N.$$.fragment,s),A(Tl.$$.fragment,s),A(Al.$$.fragment,s),A(rl.$$.fragment,s),Cn=!1},d(s){s&&(M(r),M(t),M(u),M(k),M(x),M(Q),M(E),M(Dl),M(il),M(Ql),M(z),M(kl),M(R),M(fl),M(g),M(ol),M($l),M(S),M(dl),M(G),M(Nl),M(xl),M(L),M(El),M(Bl),M(X),M(vl),M(V),M(zl),M(Rl),M(W),M(gl),M(_l),M(P),M(Sl),M(O),M(Gl),M(q),M(Zl),M(Ll),M(ss),M(Yl),M(Xl),M(ls),M(Vl),M(Fl),M(ns),M(Wl),M(as),M(Hl),M(Pl),M(js),M(Ol),M(ps),M(ql),M(Kl),M(sM),M(Ts),M(lM),M(Us),M(MM),M(nM),M(Is),M(aM),M(eM),M(Cs),M(jM),M(pM),M(JM),M(us),M(yM),M(TM),M(UM),M(cs),M(wM),M(IM),M(AM),M(is),M(CM),M(tM),M(mM),M(fs),M(uM),M(rM),M(bM),M(ds),M(cM),M(hM),M(xs),M(DM),M(Es),M(iM),M(Bs),M(QM),M(kM),M(fM),M(zs),M(oM),M($M),M(dM),M(_s),M(NM),M(xM),M(Gs),M(EM),M(BM),M(Ls),M(vM),M(zM),M(RM),M(Xs),M(gM),M(Vs),M(_M),M(Fs),M(SM),M(GM),M(Hs),M(ZM),M(LM),M(Os),M(YM),M(XM),M(Ks),M(VM),M(sl),M(FM),M(ll),M(WM),M(Ml),M(HM),M(nl),M(PM),M(OM),M(el),M(qM),M(jl),M(KM),M(sn),M(ln),M(Jl),M(Mn),M(yl),M(nn),M(an),M(en),M(Ul),M(jn),M(wl),M(pn),M(Il),M(Jn),M(yn),M(Cl),M(Tn),M(tl),M(Un),M(ml),M(wn),M(ul),M(In),M(An),M(bl)),M(y),C(i,s),C(c,s),C(b,s),C(B,s),C(v,s),C(_,s),C(Z,s),C(Y,s),C(F,s),C(H,s),C(K,s),C(f,s),C(Ms,s),C(es,s),C(Js,s),C(ys,s),C(ws,s),C(As,s),C(ts,s),C(ms,s),C(rs,s),C(bs,s),C(hs,s),C(Ds,s),C(Qs,s),C(ks,s),C(os,s),C($s,s),C(Ns,s),C(vs,s),C(o,s),C(Rs,s),C(gs,s),C(Ss,s),C(Zs,s),C($,s),C(Ys,s),C(Ws,s),C(Ps,s),C(qs,s),C(al,s),C(pl,s),C(d,s),C(N,s),C(Tl,s),C(Al,s),C(rl,s)}}}const La='{"title":"학습 파이프라인 디버깅","local":"학습-파이프라인-디버깅","sections":[{"title":"학습 파이프라인 디버깅","local":"학습-파이프라인-디버깅","sections":[{"title":"데이터 확인","local":"데이터-확인","sections":[],"depth":3},{"title":"모델 확인","local":"모델-확인","sections":[],"depth":3},{"title":"하이퍼파라미터 확인","local":"하이퍼파라미터-확인","sections":[],"depth":3}],"depth":2},{"title":"다른 잠재적 이슈들","local":"다른-잠재적-이슈들","sections":[{"title":"메모리 부족 에러 처리","local":"메모리-부족-에러-처리","sections":[],"depth":3},{"title":"몹시 배고픈 TensorFlow 🦛","local":"몹시-배고픈-tensorflow-","sections":[],"depth":3},{"title":"데이터 확인 (다시!)","local":"데이터-확인-다시","sections":[],"depth":3},{"title":"한 배치에서 모델 과대적합","local":"한-배치에서-모델-과대적합","sections":[],"depth":3},{"title":"첫 번째 기준이 생길 때까지 아무 것도 조정하지 마세요.","local":"첫-번째-기준이-생길-때까지-아무-것도-조정하지-마세요","sections":[],"depth":3},{"title":"도움 요청하기","local":"도움-요청하기","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ya(h,y,r){let t="pt";return oa(()=>{const u=new URLSearchParams(window.location.search);r(0,t=u.get("fw")||"pt")}),[t]}class Ka extends $a{constructor(y){super(),da(this,y,Ya,Za,fa,{})}}export{Ka as component};
