import{s as Ct,o as Ht,n as kt}from"../chunks/scheduler.6062bdaf.js";import{S as Lt,i as Mt,g as i,s as t,r as u,A as Pt,h as o,f as a,c as r,j as I,u as l,x as d,k as $,y as n,a as p,v as h,d as m,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as jt}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.d7918b6d.js";import{C as At}from"../chunks/CodeBlock.fa01571c.js";import{E as Dt}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as Ge,E as qt}from"../chunks/EditOnGithub.74ab2baa.js";function Vt(be){let f,M='Check out the <a href="../guides/inference_endpoints">related guide</a> to learn how to use <code>huggingface_hub</code> to manage your Inference Endpoints programmatically.';return{c(){f=i("p"),f.innerHTML=M},l(v){f=o(v,"P",{"data-svelte-h":!0}),d(f)!=="svelte-tmb85g"&&(f.innerHTML=M)},m(v,x){p(v,f,x)},p:kt,d(v){v&&a(f)}}}function zt(be){let f,M="Example:",v,x,w;return x=new At({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEElMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBZW5kcG9pbnQucmVzdW1lKCklMEFlbmRwb2ludC53YWl0KCklMEFlbmRwb2ludC5jbGllbnQudGV4dF90b19pbWFnZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)

<span class="hljs-comment"># Pause endpoint to save $$$</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># Resume and wait for deployment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){f=i("p"),f.textContent=M,v=t(),u(x.$$.fragment)},l(E){f=o(E,"P",{"data-svelte-h":!0}),d(f)!=="svelte-11lpom8"&&(f.textContent=M),v=r(E),l(x.$$.fragment,E)},m(E,L){p(E,f,L),p(E,v,L),h(x,E,L),w=!0},p:kt,i(E){w||(m(x.$$.fragment,E),w=!0)},o(E){_(x.$$.fragment,E),w=!1},d(E){E&&(a(f),a(v)),b(x,E)}}}function Nt(be){let f,M,v,x,w,E,L,Jn='Inference Endpoints provides a secure production solution to easily deploy models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>. This page is a reference for <code>huggingface_hub</code>’s integration with Inference Endpoints. For more information about the Inference Endpoints product, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.',Ze,V,Be,Z,Kn='Inference Endpoints can be fully managed via API. The endpoints are documented with <a href="https://api.endpoints.huggingface.cloud/" rel="nofollow">Swagger</a>. The <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> class is a simple wrapper built on top on this API.',Qe,B,Ye,Q,et='A subset of the Inference Endpoint features are implemented in <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>:',Xe,Y,nt='<li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a> and <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to get information about your Inference Endpoints</li> <li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> and <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a> to deploy and manage Inference Endpoints</li> <li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> and <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a> to pause and resume an Inference Endpoint</li> <li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a> to manually scale an Endpoint to 0 replicas</li>',Je,X,Ke,J,tt='The main dataclass is <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>. It contains information about a deployed <code>InferenceEndpoint</code>, including its configuration and current state. Once deployed, you can run inference on the Endpoint using the  <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.client">InferenceEndpoint.client</a> and <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.async_client">InferenceEndpoint.async_client</a> properties that respectively return an <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> object.',en,s,K,_n,Ee,rt="Contains information about a deployed Inference Endpoint.",bn,z,En,N,ee,vn,ve,at="Initialize object from raw dictionary.",In,S,ne,$n,Ie,it="Returns a client to make predictions on this Inference Endpoint.",xn,U,te,yn,$e,ot="Returns a client to make predictions on this Inference Endpoint.",wn,T,re,Tn,xe,ct="Delete the Inference Endpoint.",kn,ye,pt=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a> or scale it to zero with <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.`,Cn,we,st='This is an alias for <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">HfApi.delete_inference_endpoint()</a>.',Hn,W,ae,Ln,Te,dt="Fetch latest information about the Inference Endpoint.",Mn,k,ie,Pn,ke,gt="Pause the Inference Endpoint.",jn,Ce,ft=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>, which
would be automatically restarted when a request is made to it.`,An,He,ut=`This is an alias for <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">HfApi.pause_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Dn,P,oe,qn,Le,lt="Resume the Inference Endpoint.",Vn,Me,ht=`This is an alias for <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">HfApi.resume_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,zn,C,ce,Nn,Pe,mt="Scale Inference Endpoint to zero.",Sn,je,_t=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.`,Un,Ae,bt=`This is an alias for <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">HfApi.scale_to_zero_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Wn,H,pe,Rn,De,Et="Update the Inference Endpoint.",Fn,qe,vt=`This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.`,Gn,Ve,It=`This is an alias for <a href="/docs/huggingface_hub/pr_2344/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">HfApi.update_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,On,j,se,Zn,ze,$t="Wait for the Inference Endpoint to be deployed.",Bn,Ne,xt=`Information from the server will be fetched every 1s. If the Inference Endpoint is not deployed after <code>timeout</code>
seconds, a <code>InferenceEndpointTimeoutError</code> will be raised. The <a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> will be mutated in place with the latest
data.`,nn,de,tn,A,ge,Qn,Se,yt="An enumeration.",rn,fe,an,D,ue,Yn,Ue,wt="An enumeration.",on,le,cn,q,he,Xn,We,Tt="Generic exception when dealing with Inference Endpoints.",pn,me,sn,Oe,dn;return w=new Ge({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),V=new jt({props:{$$slots:{default:[Vt]},$$scope:{ctx:be}}}),B=new Ge({props:{title:"Methods",local:"methods",headingTag:"h2"}}),X=new Ge({props:{title:"InferenceEndpoint",local:"huggingface_hub.InferenceEndpoint",headingTag:"h2"}}),K=new y({props:{name:"class huggingface_hub.InferenceEndpoint",anchor:"huggingface_hub.InferenceEndpoint",parameters:[{name:"namespace",val:": str"},{name:"raw",val:": Dict"},{name:"_token",val:": Union"},{name:"_api",val:": HfApi"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name of the Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.InferenceEndpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>) &#x2014;
The namespace where the Inference Endpoint is located.`,name:"namespace"},{anchor:"huggingface_hub.InferenceEndpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository deployed on this Inference Endpoint.`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.status",description:`<strong>status</strong> (<a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>) &#x2014;
The current status of the Inference Endpoint.`,name:"status"},{anchor:"huggingface_hub.InferenceEndpoint.url",description:`<strong>url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the Inference Endpoint, if available. Only a deployed Inference Endpoint will have a URL.`,name:"url"},{anchor:"huggingface_hub.InferenceEndpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model.`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The specific model revision deployed on the Inference Endpoint.`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task associated with the deployed model.`,name:"task"},{anchor:"huggingface_hub.InferenceEndpoint.created_at",description:`<strong>created_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp when the Inference Endpoint was created.`,name:"created_at"},{anchor:"huggingface_hub.InferenceEndpoint.updated_at",description:`<strong>updated_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp of the last update of the Inference Endpoint.`,name:"updated_at"},{anchor:"huggingface_hub.InferenceEndpoint.type",description:`<strong>type</strong> (<a href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointType">InferenceEndpointType</a>) &#x2014;
The type of the Inference Endpoint (public, protected, private).`,name:"type"},{anchor:"huggingface_hub.InferenceEndpoint.raw",description:`<strong>raw</strong> (<code>Dict</code>) &#x2014;
The raw dictionary data returned from the API.`,name:"raw"},{anchor:"huggingface_hub.InferenceEndpoint.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Authentication token for the Inference Endpoint, if set when requesting the API. Will default to the
locally saved token if not provided. Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L38"}}),z=new Dt({props:{anchor:"huggingface_hub.InferenceEndpoint.example",$$slots:{default:[zt]},$$scope:{ctx:be}}}),ee=new y({props:{name:"from_raw",anchor:"huggingface_hub.InferenceEndpoint.from_raw",parameters:[{name:"raw",val:": Dict"},{name:"namespace",val:": str"},{name:"token",val:": Union = None"},{name:"api",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L121"}}),ne=new y({props:{name:"client",anchor:"huggingface_hub.InferenceEndpoint.client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_client#huggingface_hub.InferenceClient"
>InferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),te=new y({props:{name:"async_client",anchor:"huggingface_hub.InferenceEndpoint.async_client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an asyncio-compatible inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient"
>AsyncInferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),re=new y({props:{name:"delete",anchor:"huggingface_hub.InferenceEndpoint.delete",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L357"}}),ae=new y({props:{name:"fetch",anchor:"huggingface_hub.InferenceEndpoint.fetch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L221",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ie=new y({props:{name:"pause",anchor:"huggingface_hub.InferenceEndpoint.pause",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),oe=new y({props:{name:"resume",anchor:"huggingface_hub.InferenceEndpoint.resume",parameters:[{name:"running_ok",val:": bool = True"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.resume.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L318",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ce=new y({props:{name:"scale_to_zero",anchor:"huggingface_hub.InferenceEndpoint.scale_to_zero",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L339",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),pe=new y({props:{name:"update",anchor:"huggingface_hub.InferenceEndpoint.update",parameters:[{name:"accelerator",val:": Optional = None"},{name:"instance_size",val:": Optional = None"},{name:"instance_type",val:": Optional = None"},{name:"min_replica",val:": Optional = None"},{name:"max_replica",val:": Optional = None"},{name:"repository",val:": Optional = None"},{name:"framework",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"task",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.update.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.InferenceEndpoint.update.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.update.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.update.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L232",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),se=new y({props:{name:"wait",anchor:"huggingface_hub.InferenceEndpoint.wait",parameters:[{name:"timeout",val:": Optional = None"},{name:"refresh_every",val:": int = 5"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.wait.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum time to wait for the Inference Endpoint to be deployed, in seconds. If <code>None</code>, will wait
indefinitely.`,name:"timeout"},{anchor:"huggingface_hub.InferenceEndpoint.wait.refresh_every",description:`<strong>refresh_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The time to wait between each fetch of the Inference Endpoint status, in seconds. Defaults to 5s.`,name:"refresh_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L174",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> —
If the Inference Endpoint ended up in a failed state.</li>
<li><code>InferenceEndpointTimeoutError</code> —
If the Inference Endpoint is not deployed after <code>timeout</code> seconds.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2344/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> or <code>InferenceEndpointTimeoutError</code></p>
`}}),de=new Ge({props:{title:"InferenceEndpointStatus",local:"huggingface_hub.InferenceEndpointStatus",headingTag:"h2"}}),ge=new y({props:{name:"class huggingface_hub.InferenceEndpointStatus",anchor:"huggingface_hub.InferenceEndpointStatus",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L21"}}),fe=new Ge({props:{title:"InferenceEndpointType",local:"huggingface_hub.InferenceEndpointType",headingTag:"h2"}}),ue=new y({props:{name:"class huggingface_hub.InferenceEndpointType",anchor:"huggingface_hub.InferenceEndpointType",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/_inference_endpoints.py#L32"}}),le=new Ge({props:{title:"InferenceEndpointError",local:"huggingface_hub.InferenceEndpointError",headingTag:"h2"}}),he=new y({props:{name:"class huggingface_hub.InferenceEndpointError",anchor:"huggingface_hub.InferenceEndpointError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/vr_2344/src/huggingface_hub/errors.py#L30"}}),me=new qt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_endpoints.md"}}),{c(){f=i("meta"),M=t(),v=i("p"),x=t(),u(w.$$.fragment),E=t(),L=i("p"),L.innerHTML=Jn,Ze=t(),u(V.$$.fragment),Be=t(),Z=i("p"),Z.innerHTML=Kn,Qe=t(),u(B.$$.fragment),Ye=t(),Q=i("p"),Q.innerHTML=et,Xe=t(),Y=i("ul"),Y.innerHTML=nt,Je=t(),u(X.$$.fragment),Ke=t(),J=i("p"),J.innerHTML=tt,en=t(),s=i("div"),u(K.$$.fragment),_n=t(),Ee=i("p"),Ee.textContent=rt,bn=t(),u(z.$$.fragment),En=t(),N=i("div"),u(ee.$$.fragment),vn=t(),ve=i("p"),ve.textContent=at,In=t(),S=i("div"),u(ne.$$.fragment),$n=t(),Ie=i("p"),Ie.textContent=it,xn=t(),U=i("div"),u(te.$$.fragment),yn=t(),$e=i("p"),$e.textContent=ot,wn=t(),T=i("div"),u(re.$$.fragment),Tn=t(),xe=i("p"),xe.textContent=ct,kn=t(),ye=i("p"),ye.innerHTML=pt,Cn=t(),we=i("p"),we.innerHTML=st,Hn=t(),W=i("div"),u(ae.$$.fragment),Ln=t(),Te=i("p"),Te.textContent=dt,Mn=t(),k=i("div"),u(ie.$$.fragment),Pn=t(),ke=i("p"),ke.textContent=gt,jn=t(),Ce=i("p"),Ce.innerHTML=ft,An=t(),He=i("p"),He.innerHTML=ut,Dn=t(),P=i("div"),u(oe.$$.fragment),qn=t(),Le=i("p"),Le.textContent=lt,Vn=t(),Me=i("p"),Me.innerHTML=ht,zn=t(),C=i("div"),u(ce.$$.fragment),Nn=t(),Pe=i("p"),Pe.textContent=mt,Sn=t(),je=i("p"),je.innerHTML=_t,Un=t(),Ae=i("p"),Ae.innerHTML=bt,Wn=t(),H=i("div"),u(pe.$$.fragment),Rn=t(),De=i("p"),De.textContent=Et,Fn=t(),qe=i("p"),qe.textContent=vt,Gn=t(),Ve=i("p"),Ve.innerHTML=It,On=t(),j=i("div"),u(se.$$.fragment),Zn=t(),ze=i("p"),ze.textContent=$t,Bn=t(),Ne=i("p"),Ne.innerHTML=xt,nn=t(),u(de.$$.fragment),tn=t(),A=i("div"),u(ge.$$.fragment),Qn=t(),Se=i("p"),Se.textContent=yt,rn=t(),u(fe.$$.fragment),an=t(),D=i("div"),u(ue.$$.fragment),Yn=t(),Ue=i("p"),Ue.textContent=wt,on=t(),u(le.$$.fragment),cn=t(),q=i("div"),u(he.$$.fragment),Xn=t(),We=i("p"),We.textContent=Tt,pn=t(),u(me.$$.fragment),sn=t(),Oe=i("p"),this.h()},l(e){const c=Pt("svelte-u9bgzb",document.head);f=o(c,"META",{name:!0,content:!0}),c.forEach(a),M=r(e),v=o(e,"P",{}),I(v).forEach(a),x=r(e),l(w.$$.fragment,e),E=r(e),L=o(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1bwc3b2"&&(L.innerHTML=Jn),Ze=r(e),l(V.$$.fragment,e),Be=r(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-nrmjfe"&&(Z.innerHTML=Kn),Qe=r(e),l(B.$$.fragment,e),Ye=r(e),Q=o(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1to59i0"&&(Q.innerHTML=et),Xe=r(e),Y=o(e,"UL",{"data-svelte-h":!0}),d(Y)!=="svelte-ql1x48"&&(Y.innerHTML=nt),Je=r(e),l(X.$$.fragment,e),Ke=r(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-k9f4kx"&&(J.innerHTML=tt),en=r(e),s=o(e,"DIV",{class:!0});var g=I(s);l(K.$$.fragment,g),_n=r(g),Ee=o(g,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1bmjqnv"&&(Ee.textContent=rt),bn=r(g),l(z.$$.fragment,g),En=r(g),N=o(g,"DIV",{class:!0});var _e=I(N);l(ee.$$.fragment,_e),vn=r(_e),ve=o(_e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-gljdbx"&&(ve.textContent=at),_e.forEach(a),In=r(g),S=o(g,"DIV",{class:!0});var gn=I(S);l(ne.$$.fragment,gn),$n=r(gn),Ie=o(gn,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jw5rtn"&&(Ie.textContent=it),gn.forEach(a),xn=r(g),U=o(g,"DIV",{class:!0});var fn=I(U);l(te.$$.fragment,fn),yn=r(fn),$e=o(fn,"P",{"data-svelte-h":!0}),d($e)!=="svelte-jw5rtn"&&($e.textContent=ot),fn.forEach(a),wn=r(g),T=o(g,"DIV",{class:!0});var R=I(T);l(re.$$.fragment,R),Tn=r(R),xe=o(R,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1awp4uu"&&(xe.textContent=ct),kn=r(R),ye=o(R,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1h1lxv5"&&(ye.innerHTML=pt),Cn=r(R),we=o(R,"P",{"data-svelte-h":!0}),d(we)!=="svelte-138lv6c"&&(we.innerHTML=st),R.forEach(a),Hn=r(g),W=o(g,"DIV",{class:!0});var un=I(W);l(ae.$$.fragment,un),Ln=r(un),Te=o(un,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1dh96nb"&&(Te.textContent=dt),un.forEach(a),Mn=r(g),k=o(g,"DIV",{class:!0});var F=I(k);l(ie.$$.fragment,F),Pn=r(F),ke=o(F,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1bfttgz"&&(ke.textContent=gt),jn=r(F),Ce=o(F,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-4iuvuk"&&(Ce.innerHTML=ft),An=r(F),He=o(F,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1386zbv"&&(He.innerHTML=ut),F.forEach(a),Dn=r(g),P=o(g,"DIV",{class:!0});var Re=I(P);l(oe.$$.fragment,Re),qn=r(Re),Le=o(Re,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-akp3j2"&&(Le.textContent=lt),Vn=r(Re),Me=o(Re,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-11d9ckj"&&(Me.innerHTML=ht),Re.forEach(a),zn=r(g),C=o(g,"DIV",{class:!0});var G=I(C);l(ce.$$.fragment,G),Nn=r(G),Pe=o(G,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-6vx93v"&&(Pe.textContent=mt),Sn=r(G),je=o(G,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1vst03e"&&(je.innerHTML=_t),Un=r(G),Ae=o(G,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1i7n2xp"&&(Ae.innerHTML=bt),G.forEach(a),Wn=r(g),H=o(g,"DIV",{class:!0});var O=I(H);l(pe.$$.fragment,O),Rn=r(O),De=o(O,"P",{"data-svelte-h":!0}),d(De)!=="svelte-16hllis"&&(De.textContent=Et),Fn=r(O),qe=o(O,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-llxqqu"&&(qe.textContent=vt),Gn=r(O),Ve=o(O,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1f35kd3"&&(Ve.innerHTML=It),O.forEach(a),On=r(g),j=o(g,"DIV",{class:!0});var Fe=I(j);l(se.$$.fragment,Fe),Zn=r(Fe),ze=o(Fe,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-15saqtl"&&(ze.textContent=$t),Bn=r(Fe),Ne=o(Fe,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-j7bo0p"&&(Ne.innerHTML=xt),Fe.forEach(a),g.forEach(a),nn=r(e),l(de.$$.fragment,e),tn=r(e),A=o(e,"DIV",{class:!0});var ln=I(A);l(ge.$$.fragment,ln),Qn=r(ln),Se=o(ln,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-ofujqi"&&(Se.textContent=yt),ln.forEach(a),rn=r(e),l(fe.$$.fragment,e),an=r(e),D=o(e,"DIV",{class:!0});var hn=I(D);l(ue.$$.fragment,hn),Yn=r(hn),Ue=o(hn,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-ofujqi"&&(Ue.textContent=wt),hn.forEach(a),on=r(e),l(le.$$.fragment,e),cn=r(e),q=o(e,"DIV",{class:!0});var mn=I(q);l(he.$$.fragment,mn),Xn=r(mn),We=o(mn,"P",{"data-svelte-h":!0}),d(We)!=="svelte-dy4pdd"&&(We.textContent=Tt),mn.forEach(a),pn=r(e),l(me.$$.fragment,e),sn=r(e),Oe=o(e,"P",{}),I(Oe).forEach(a),this.h()},h(){$(f,"name","hf:doc:metadata"),$(f,"content",St),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,f),p(e,M,c),p(e,v,c),p(e,x,c),h(w,e,c),p(e,E,c),p(e,L,c),p(e,Ze,c),h(V,e,c),p(e,Be,c),p(e,Z,c),p(e,Qe,c),h(B,e,c),p(e,Ye,c),p(e,Q,c),p(e,Xe,c),p(e,Y,c),p(e,Je,c),h(X,e,c),p(e,Ke,c),p(e,J,c),p(e,en,c),p(e,s,c),h(K,s,null),n(s,_n),n(s,Ee),n(s,bn),h(z,s,null),n(s,En),n(s,N),h(ee,N,null),n(N,vn),n(N,ve),n(s,In),n(s,S),h(ne,S,null),n(S,$n),n(S,Ie),n(s,xn),n(s,U),h(te,U,null),n(U,yn),n(U,$e),n(s,wn),n(s,T),h(re,T,null),n(T,Tn),n(T,xe),n(T,kn),n(T,ye),n(T,Cn),n(T,we),n(s,Hn),n(s,W),h(ae,W,null),n(W,Ln),n(W,Te),n(s,Mn),n(s,k),h(ie,k,null),n(k,Pn),n(k,ke),n(k,jn),n(k,Ce),n(k,An),n(k,He),n(s,Dn),n(s,P),h(oe,P,null),n(P,qn),n(P,Le),n(P,Vn),n(P,Me),n(s,zn),n(s,C),h(ce,C,null),n(C,Nn),n(C,Pe),n(C,Sn),n(C,je),n(C,Un),n(C,Ae),n(s,Wn),n(s,H),h(pe,H,null),n(H,Rn),n(H,De),n(H,Fn),n(H,qe),n(H,Gn),n(H,Ve),n(s,On),n(s,j),h(se,j,null),n(j,Zn),n(j,ze),n(j,Bn),n(j,Ne),p(e,nn,c),h(de,e,c),p(e,tn,c),p(e,A,c),h(ge,A,null),n(A,Qn),n(A,Se),p(e,rn,c),h(fe,e,c),p(e,an,c),p(e,D,c),h(ue,D,null),n(D,Yn),n(D,Ue),p(e,on,c),h(le,e,c),p(e,cn,c),p(e,q,c),h(he,q,null),n(q,Xn),n(q,We),p(e,pn,c),h(me,e,c),p(e,sn,c),p(e,Oe,c),dn=!0},p(e,[c]){const g={};c&2&&(g.$$scope={dirty:c,ctx:e}),V.$set(g);const _e={};c&2&&(_e.$$scope={dirty:c,ctx:e}),z.$set(_e)},i(e){dn||(m(w.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(K.$$.fragment,e),m(z.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(re.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(se.$$.fragment,e),m(de.$$.fragment,e),m(ge.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(le.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),dn=!0)},o(e){_(w.$$.fragment,e),_(V.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(K.$$.fragment,e),_(z.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(le.$$.fragment,e),_(he.$$.fragment,e),_(me.$$.fragment,e),dn=!1},d(e){e&&(a(M),a(v),a(x),a(E),a(L),a(Ze),a(Be),a(Z),a(Qe),a(Ye),a(Q),a(Xe),a(Y),a(Je),a(Ke),a(J),a(en),a(s),a(nn),a(tn),a(A),a(rn),a(an),a(D),a(on),a(cn),a(q),a(pn),a(sn),a(Oe)),a(f),b(w,e),b(V,e),b(B,e),b(X,e),b(K),b(z),b(ee),b(ne),b(te),b(re),b(ae),b(ie),b(oe),b(ce),b(pe),b(se),b(de,e),b(ge),b(fe,e),b(ue),b(le,e),b(he),b(me,e)}}}const St='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Methods","local":"methods","sections":[],"depth":2},{"title":"InferenceEndpoint","local":"huggingface_hub.InferenceEndpoint","sections":[],"depth":2},{"title":"InferenceEndpointStatus","local":"huggingface_hub.InferenceEndpointStatus","sections":[],"depth":2},{"title":"InferenceEndpointType","local":"huggingface_hub.InferenceEndpointType","sections":[],"depth":2},{"title":"InferenceEndpointError","local":"huggingface_hub.InferenceEndpointError","sections":[],"depth":2}],"depth":1}';function Ut(be){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Lt{constructor(f){super(),Mt(this,f,Ut,Nt,Ct,{})}}export{Qt as component};
