import{s as ye,n as fe,o as Je}from"../chunks/scheduler.9bc65507.js";import{S as we,i as Te,g as p,s as a,r as m,A as xe,h as i,f as l,c as n,j as be,u as c,x as r,k as qs,y as Ue,a as e,v as o,d as g,t as h,w as j}from"../chunks/index.707bf1b6.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{D as $e}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as zs,E as Ce}from"../chunks/EditOnGithub.922df6ba.js";function Ze(xl){let d,Ls,Ys,Ss,f,Ps,J,Ds,w,Ul=`Visual Question Answering (VQA) は、画像に基づいて自由形式の質問に答えるタスクです。
このタスクをサポートするモデルへの入力は通常、画像と質問の組み合わせであり、出力は
自然言語で表現された答え。`,Ks,T,$l="VQA の注目すべき使用例には次のようなものがあります。",Os,x,Cl="<li>視覚障害者向けのアクセシビリティ アプリケーション。</li> <li>教育: 講義や教科書で示されている視覚的な資料について質問を投げかけること。 VQA は、インタラクティブな博物館の展示物や史跡でも利用できます。</li> <li>カスタマー サービスと電子商取引: VQA は、ユーザーが製品について質問できるようにすることでユーザー エクスペリエンスを向上させます。</li> <li>画像検索: VQA モデルを使用して、特定の特徴を持つ画像を検索できます。たとえば、ユーザーは「犬はいますか?」と尋ねることができます。一連の画像から犬が写っているすべての画像を検索します。</li>",st,U,Zl="このガイドでは、次の方法を学びます。",tt,$,_l='<li><a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> データセット</a> 上で分類 VQA モデル、特に <a href="../model_doc/vilt">ViLT</a> を微調整します。</li> <li>微調整された ViLT を推論に使用します。</li> <li>BLIP-2 などの生成モデルを使用してゼロショット VQA 推論を実行します。</li>',lt,C,et,Z,vl=`ViLT モデルは、Vision Transformer (ViT) にテキスト埋め込みを組み込んでおり、最小限の設計を可能にします。
視覚と言語の事前トレーニング (VLP)。このモデルは、いくつかの下流タスクに使用できます。 VQA タスクの場合、分類子
head は最上部 (<code>[CLS]</code> トークンの最終的な非表示状態の最上部にある線形層) に配置され、ランダムに初期化されます。
したがって、視覚的質問応答は <strong>分類問題</strong> として扱われます。`,at,_,Vl=`BLIP、BLIP-2、InstructBLIP などの最近のモデルは、VQA を生成タスクとして扱います。このガイドの後半では、
ゼロショット VQA 推論にそれらを使用する方法を示します。`,nt,v,Gl="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",pt,V,it,G,Wl=`モデルをコミュニティと共有することをお勧めします。 Hugging Face アカウントにログインして、🤗 ハブにアップロードします。
プロンプトが表示されたら、トークンを入力してログインします。`,rt,W,mt,I,Il="モデルのチェックポイントをグローバル変数として定義しましょう。",ct,k,ot,B,gt,X,kl=`説明の目的で、このガイドでは、注釈付きの視覚的な質問に答える「Graphcore/vqa」データセットの非常に小さなサンプルを使用します。
完全なデータセットは <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a> で見つけることができます。`,ht,Q,Bl=`<a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> データセット</a> の代わりに、
公式 <a href="https://visualqa.org/download.html" rel="nofollow">VQA データセット ページ</a> から同じデータを手動で取得します。フォローしたい場合は、
カスタム データを使用したチュートリアルでは、<a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">画像データセットを作成する</a> 方法を確認してください。
🤗 データセットのドキュメントのガイド。`,jt,R,Xl="検証分割から最初の 200 個の例をロードし、データセットの機能を調べてみましょう。",Mt,H,dt,F,Ql="データセットの特徴を理解するために例を見てみましょう。",ut,N,bt,E,Rl="このタスクに関連する機能には次のものがあります。",yt,z,Hl="<li><code>question</code>: 画像から回答する質問</li> <li><code>image_id</code>: 質問が参照する画像へのパス</li> <li><code>label</code>: 注釈</li>",ft,Y,Fl="残りの機能は必要ないので削除できます。",Jt,A,wt,q,Nl=`ご覧のとおり、<code>label</code>機能には、さまざまなヒューマン・アノテーターによって収集された、同じ質問に対する複数の回答 (ここでは<code>id</code>と呼びます) が含まれています。
質問に対する答えは主観的なものになる可能性があるためです。この場合、問題は “彼はどこを見ているのか？“ということです。一部の人々
これには “ダウン” という注釈が付けられ、他のものには “テーブルで” という注釈が付けられ、別の注釈には “スケートボード” という注釈が付けられました。`,Tt,L,El="画像を見て、どの答えを出すかを考えてください。",xt,S,Ut,u,zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',$t,P,Yl=`質問と回答のあいまいさのため、このようなデータセットはマルチラベル分類問題として扱われます (
複数の回答が有効である可能性があります)。さらに、ワンホット エンコードされたベクトルを作成するだけではなく、
注釈内に特定の回答が出現した回数に基づくソフト エンコーディング。`,Ct,D,Al=`たとえば、上の例では、“down”という回答が他の回答よりも頻繁に選択されるため、
スコア (データセットでは<code>weight</code>と呼ばれます) は 1.0 で、残りの回答のスコアは 1.0 未満です。`,Zt,K,ql=`後で適切な分類ヘッドを使用してモデルをインスタンス化するために、2 つの辞書を作成しましょう。
ラベル名を整数に変換する、またはその逆:`,_t,O,vt,ss,Ll="マッピングができたので、文字列の回答をその ID に置き換え、さらに前処理をより便利にするためにデータセットをフラット化することができます。",Vt,ts,Gt,ls,Wt,es,Sl=`次のステップでは、ViLT プロセッサをロードして、モデルの画像データとテキスト データを準備します。
<code>ViltProcessor</code> は、BERT トークナイザーと ViLT 画像プロセッサを便利な単一プロセッサにラップします。`,It,as,kt,ns,Pl=`データを前処理するには、<code>ViltProcessor</code> を使用して画像と質問をエンコードする必要があります。プロセッサーは使用します
<a href="/docs/transformers/pr_30803/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> を使用してテキストをトークン化し、テキスト データの <code>input_ids</code>、<code>attention_mask</code>、および <code>token_type_ids</code> を作成します。
画像に関しては、プロセッサは <code>ViltImageProcessor</code> を利用して画像のサイズ変更と正規化を行い、<code>pixel_values</code> と <code>pixel_mask</code> を作成します。`,Bt,ps,Dl=`これらの前処理ステップはすべて内部で行われ、<code>processor</code>を呼び出すだけで済みます。ただし、それでも必要なのは、
対象のラベルを準備します。この表現では、各要素は考えられる答え (ラベル) に対応します。正解の場合、要素は保持されます。
それぞれのスコア (重み) が設定され、残りの要素は 0 に設定されます。`,Xt,is,Kl="次の関数は、画像と質問に <code>processor</code> を適用し、上で説明したようにラベルをフォーマットします。",Qt,rs,Rt,ms,Ol=`データセット全体に前処理関数を適用するには、🤗 Datasets <code>map</code> 関数を使用します。 <code>map</code> を高速化するには、次のようにします。
データセットの複数の要素を一度に処理するには、<code>batched=True</code> を設定します。この時点で、不要な列は自由に削除してください。`,Ht,cs,Ft,os,se="最後のステップとして、<code>DefaultDataCollat​​or</code> を使用してサンプルのバッチを作成します。",Nt,gs,Et,hs,zt,js,te=`これでモデルのトレーニングを開始する準備が整いました。 <code>ViltForQuestionAnswering</code> で ViLT をロードします。ラベルの数を指定します
ラベルマッピングとともに:`,Yt,Ms,At,ds,le="この時点で残っているステップは 3 つだけです。",qt,us,ee='<li><a href="/docs/transformers/pr_30803/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。</li>',Lt,bs,St,b,ae='<li>トレーニング引数をモデル、データセット、プロセッサー、データ照合器とともに <a href="/docs/transformers/pr_30803/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li>',Pt,ys,Dt,y,ne='<li><a href="/docs/transformers/pr_30803/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',Kt,fs,Ot,Js,pe='トレーニングが完了したら、 <a href="/docs/transformers/pr_30803/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを使用してモデルをハブに共有し、🤗 ハブで最終モデルを共有します。',sl,ws,tl,Ts,ll,xs,ie=`ViLT モデルを微調整し、🤗 Hub にアップロードしたので、それを推論に使用できます。もっとも単純な
推論用に微調整されたモデルを試す方法は、それを <a href="/docs/transformers/pr_30803/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a> で使用することです。`,el,Us,al,$s,re=`このガイドのモデルは 200 の例でのみトレーニングされているため、多くを期待しないでください。少なくともそれがあるかどうか見てみましょう
データから何かを学習し、推論を説明するためにデータセットから最初の例を取り出します。`,nl,Cs,pl,Zs,me="あまり自信がありませんが、モデルは確かに何かを学習しました。より多くの例とより長いトレーニングを行うと、はるかに良い結果が得られます。",il,_s,ce="必要に応じて、パイプラインの結果を手動で複製することもできます。",rl,vs,oe="<li>画像と質問を取得し、モデルのプロセッサを使用してモデル用に準備します。</li> <li>モデルを通じて結果または前処理を転送します。</li> <li>ロジットから、最も可能性の高い回答の ID を取得し、<code>id2label</code> で実際の回答を見つけます。</li>",ml,Vs,cl,Gs,ol,Ws,ge=`以前のモデルでは、VQA を分類タスクとして扱いました。 BLIP、BLIP-2、InstructBLIP アプローチなどの一部の最近のモデル
生成タスクとしての VQA。 <a href="../model_doc/blip-2">BLIP-2</a> を例として考えてみましょう。新しいビジュアル言語の事前トレーニングを導入しました
事前にトレーニングされたビジョン エンコーダーと LLM を任意に組み合わせて使用​​できるパラダイム (詳細については、<a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 ブログ投稿</a> を参照)。
これにより、視覚的な質問応答を含む複数の視覚言語タスクで最先端の結果を達成することができます。`,gl,Is,he=`このモデルを VQA に使用する方法を説明しましょう。まず、モデルをロードしましょう。ここではモデルを明示的に送信します。
GPU (利用可能な場合)。これは <a href="/docs/transformers/pr_30803/ja/main_classes/trainer#transformers.Trainer">Trainer</a> が自動的に処理するため、トレーニング時に事前に行う必要はありませんでした。`,hl,ks,jl,Bs,je="モデルは画像とテキストを入力として受け取るため、VQA データセットの最初の例とまったく同じ画像と質問のペアを使用してみましょう。",Ml,Xs,dl,Qs,Me="視覚的な質問応答タスクに BLIP-2 を使用するには、テキスト プロンプトが特定の形式 (<code>Question: {} Answer:</code>) に従う必要があります。",ul,Rs,bl,Hs,de="次に、モデルのプロセッサで画像/プロンプトを前処理し、処理された入力をモデルに渡し、出力をデコードする必要があります。",yl,Fs,fl,Ns,ue=`ご覧のとおり、モデルは群衆と顔の向き (下を向いている) を認識しましたが、見逃しているようです。
観客がスケーターの後ろにいるという事実。それでも、人間が注釈を付けたデータセットを取得することが不可能な場合には、これは
このアプローチにより、有用な結果がすぐに得られます。`,Jl,Es,wl,As,Tl;return f=new zs({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h1"}}),J=new $e({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/visual_question_answering.ipynb"}]}}),C=new zs({props:{title:"Fine-tuning ViLT",local:"fine-tuning-vilt",headingTag:"h2"}}),V=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),k=new M({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>',wrap:!1}}),B=new zs({props:{title:"Load the data",local:"load-the-data",headingTag:"h2"}}),H=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),N=new M({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`,wrap:!1}}),A=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])',wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),O=new M({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()}`,wrap:!1}}),ts=new M({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),ls=new zs({props:{title:"Preprocessing data",local:"preprocessing-data",headingTag:"h2"}}),as=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),rs=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()

<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score

<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),cs=new M({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),gs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),hs=new zs({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),Ms=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`,wrap:!1}}),bs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ys=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0Rwcm9jZXNzb3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    processing_class=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fs=new M({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),ws=new M({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Ts=new zs({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Us=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`,wrap:!1}}),Cs=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`,wrap:!1}}),Vs=new M({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`,wrap:!1}}),Gs=new zs({props:{title:"Zero-shot VQA",local:"zero-shot-vqa",headingTag:"h2"}}),ks=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),Xs=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`,wrap:!1}}),Rs=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjI=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span>',wrap:!1}}),Fs=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span>`,wrap:!1}}),Es=new Ce({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/visual_question_answering.md"}}),{c(){d=p("meta"),Ls=a(),Ys=p("p"),Ss=a(),m(f.$$.fragment),Ps=a(),m(J.$$.fragment),Ds=a(),w=p("p"),w.textContent=Ul,Ks=a(),T=p("p"),T.textContent=$l,Os=a(),x=p("ul"),x.innerHTML=Cl,st=a(),U=p("p"),U.textContent=Zl,tt=a(),$=p("ul"),$.innerHTML=_l,lt=a(),m(C.$$.fragment),et=a(),Z=p("p"),Z.innerHTML=vl,at=a(),_=p("p"),_.textContent=Vl,nt=a(),v=p("p"),v.textContent=Gl,pt=a(),m(V.$$.fragment),it=a(),G=p("p"),G.textContent=Wl,rt=a(),m(W.$$.fragment),mt=a(),I=p("p"),I.textContent=Il,ct=a(),m(k.$$.fragment),ot=a(),m(B.$$.fragment),gt=a(),X=p("p"),X.innerHTML=kl,ht=a(),Q=p("p"),Q.innerHTML=Bl,jt=a(),R=p("p"),R.textContent=Xl,Mt=a(),m(H.$$.fragment),dt=a(),F=p("p"),F.textContent=Ql,ut=a(),m(N.$$.fragment),bt=a(),E=p("p"),E.textContent=Rl,yt=a(),z=p("ul"),z.innerHTML=Hl,ft=a(),Y=p("p"),Y.textContent=Fl,Jt=a(),m(A.$$.fragment),wt=a(),q=p("p"),q.innerHTML=Nl,Tt=a(),L=p("p"),L.textContent=El,xt=a(),m(S.$$.fragment),Ut=a(),u=p("div"),u.innerHTML=zl,$t=a(),P=p("p"),P.textContent=Yl,Ct=a(),D=p("p"),D.innerHTML=Al,Zt=a(),K=p("p"),K.textContent=ql,_t=a(),m(O.$$.fragment),vt=a(),ss=p("p"),ss.textContent=Ll,Vt=a(),m(ts.$$.fragment),Gt=a(),m(ls.$$.fragment),Wt=a(),es=p("p"),es.innerHTML=Sl,It=a(),m(as.$$.fragment),kt=a(),ns=p("p"),ns.innerHTML=Pl,Bt=a(),ps=p("p"),ps.innerHTML=Dl,Xt=a(),is=p("p"),is.innerHTML=Kl,Qt=a(),m(rs.$$.fragment),Rt=a(),ms=p("p"),ms.innerHTML=Ol,Ht=a(),m(cs.$$.fragment),Ft=a(),os=p("p"),os.innerHTML=se,Nt=a(),m(gs.$$.fragment),Et=a(),m(hs.$$.fragment),zt=a(),js=p("p"),js.innerHTML=te,Yt=a(),m(Ms.$$.fragment),At=a(),ds=p("p"),ds.textContent=le,qt=a(),us=p("ol"),us.innerHTML=ee,Lt=a(),m(bs.$$.fragment),St=a(),b=p("ol"),b.innerHTML=ae,Pt=a(),m(ys.$$.fragment),Dt=a(),y=p("ol"),y.innerHTML=ne,Kt=a(),m(fs.$$.fragment),Ot=a(),Js=p("p"),Js.innerHTML=pe,sl=a(),m(ws.$$.fragment),tl=a(),m(Ts.$$.fragment),ll=a(),xs=p("p"),xs.innerHTML=ie,el=a(),m(Us.$$.fragment),al=a(),$s=p("p"),$s.textContent=re,nl=a(),m(Cs.$$.fragment),pl=a(),Zs=p("p"),Zs.textContent=me,il=a(),_s=p("p"),_s.textContent=ce,rl=a(),vs=p("ol"),vs.innerHTML=oe,ml=a(),m(Vs.$$.fragment),cl=a(),m(Gs.$$.fragment),ol=a(),Ws=p("p"),Ws.innerHTML=ge,gl=a(),Is=p("p"),Is.innerHTML=he,hl=a(),m(ks.$$.fragment),jl=a(),Bs=p("p"),Bs.textContent=je,Ml=a(),m(Xs.$$.fragment),dl=a(),Qs=p("p"),Qs.innerHTML=Me,ul=a(),m(Rs.$$.fragment),bl=a(),Hs=p("p"),Hs.textContent=de,yl=a(),m(Fs.$$.fragment),fl=a(),Ns=p("p"),Ns.textContent=ue,Jl=a(),m(Es.$$.fragment),wl=a(),As=p("p"),this.h()},l(s){const t=xe("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ls=n(s),Ys=i(s,"P",{}),be(Ys).forEach(l),Ss=n(s),c(f.$$.fragment,s),Ps=n(s),c(J.$$.fragment,s),Ds=n(s),w=i(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-z5p4lq"&&(w.textContent=Ul),Ks=n(s),T=i(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1bsqzv5"&&(T.textContent=$l),Os=n(s),x=i(s,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-gjbyh7"&&(x.innerHTML=Cl),st=n(s),U=i(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-tlz6vm"&&(U.textContent=Zl),tt=n(s),$=i(s,"UL",{"data-svelte-h":!0}),r($)!=="svelte-d7nud4"&&($.innerHTML=_l),lt=n(s),c(C.$$.fragment,s),et=n(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-d53v3a"&&(Z.innerHTML=vl),at=n(s),_=i(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1sum5cu"&&(_.textContent=Vl),nt=n(s),v=i(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1lya3k8"&&(v.textContent=Gl),pt=n(s),c(V.$$.fragment,s),it=n(s),G=i(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1hem303"&&(G.textContent=Wl),rt=n(s),c(W.$$.fragment,s),mt=n(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-iplcic"&&(I.textContent=Il),ct=n(s),c(k.$$.fragment,s),ot=n(s),c(B.$$.fragment,s),gt=n(s),X=i(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1vjrhc4"&&(X.innerHTML=kl),ht=n(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-v5knu3"&&(Q.innerHTML=Bl),jt=n(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-47v14o"&&(R.textContent=Xl),Mt=n(s),c(H.$$.fragment,s),dt=n(s),F=i(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ikgoa4"&&(F.textContent=Ql),ut=n(s),c(N.$$.fragment,s),bt=n(s),E=i(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-jey0ks"&&(E.textContent=Rl),yt=n(s),z=i(s,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1t9fv7w"&&(z.innerHTML=Hl),ft=n(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1nj8sgc"&&(Y.textContent=Fl),Jt=n(s),c(A.$$.fragment,s),wt=n(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-15q0vhz"&&(q.innerHTML=Nl),Tt=n(s),L=i(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-e3b9au"&&(L.textContent=El),xt=n(s),c(S.$$.fragment,s),Ut=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-1tjg4st"&&(u.innerHTML=zl),$t=n(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1wqu7xn"&&(P.textContent=Yl),Ct=n(s),D=i(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-hb89fv"&&(D.innerHTML=Al),Zt=n(s),K=i(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-qvd28s"&&(K.textContent=ql),_t=n(s),c(O.$$.fragment,s),vt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1sdx2d3"&&(ss.textContent=Ll),Vt=n(s),c(ts.$$.fragment,s),Gt=n(s),c(ls.$$.fragment,s),Wt=n(s),es=i(s,"P",{"data-svelte-h":!0}),r(es)!=="svelte-6lrmjf"&&(es.innerHTML=Sl),It=n(s),c(as.$$.fragment,s),kt=n(s),ns=i(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1wdh765"&&(ns.innerHTML=Pl),Bt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1xf2jbp"&&(ps.innerHTML=Dl),Xt=n(s),is=i(s,"P",{"data-svelte-h":!0}),r(is)!=="svelte-bclke1"&&(is.innerHTML=Kl),Qt=n(s),c(rs.$$.fragment,s),Rt=n(s),ms=i(s,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-g4fkvx"&&(ms.innerHTML=Ol),Ht=n(s),c(cs.$$.fragment,s),Ft=n(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1s8gffv"&&(os.innerHTML=se),Nt=n(s),c(gs.$$.fragment,s),Et=n(s),c(hs.$$.fragment,s),zt=n(s),js=i(s,"P",{"data-svelte-h":!0}),r(js)!=="svelte-it9en8"&&(js.innerHTML=te),Yt=n(s),c(Ms.$$.fragment,s),At=n(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-5p19xw"&&(ds.textContent=le),qt=n(s),us=i(s,"OL",{"data-svelte-h":!0}),r(us)!=="svelte-paz7wr"&&(us.innerHTML=ee),Lt=n(s),c(bs.$$.fragment,s),St=n(s),b=i(s,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-16tsz6h"&&(b.innerHTML=ae),Pt=n(s),c(ys.$$.fragment,s),Dt=n(s),y=i(s,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1qbrx8y"&&(y.innerHTML=ne),Kt=n(s),c(fs.$$.fragment,s),Ot=n(s),Js=i(s,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-fjpezx"&&(Js.innerHTML=pe),sl=n(s),c(ws.$$.fragment,s),tl=n(s),c(Ts.$$.fragment,s),ll=n(s),xs=i(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-17g7uai"&&(xs.innerHTML=ie),el=n(s),c(Us.$$.fragment,s),al=n(s),$s=i(s,"P",{"data-svelte-h":!0}),r($s)!=="svelte-2yjxo8"&&($s.textContent=re),nl=n(s),c(Cs.$$.fragment,s),pl=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-14dsq7i"&&(Zs.textContent=me),il=n(s),_s=i(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-19p6rx9"&&(_s.textContent=ce),rl=n(s),vs=i(s,"OL",{"data-svelte-h":!0}),r(vs)!=="svelte-k3vm8e"&&(vs.innerHTML=oe),ml=n(s),c(Vs.$$.fragment,s),cl=n(s),c(Gs.$$.fragment,s),ol=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1m8xmos"&&(Ws.innerHTML=ge),gl=n(s),Is=i(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-y6qdyy"&&(Is.innerHTML=he),hl=n(s),c(ks.$$.fragment,s),jl=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-10h2pbz"&&(Bs.textContent=je),Ml=n(s),c(Xs.$$.fragment,s),dl=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1wfjkls"&&(Qs.innerHTML=Me),ul=n(s),c(Rs.$$.fragment,s),bl=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-qde1tk"&&(Hs.textContent=de),yl=n(s),c(Fs.$$.fragment,s),fl=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-1x8sl8j"&&(Ns.textContent=ue),Jl=n(s),c(Es.$$.fragment,s),wl=n(s),As=i(s,"P",{}),be(As).forEach(l),this.h()},h(){qs(d,"name","hf:doc:metadata"),qs(d,"content",_e),qs(u,"class","flex justify-center"),qs(b,"start","2"),qs(y,"start","3")},m(s,t){Ue(document.head,d),e(s,Ls,t),e(s,Ys,t),e(s,Ss,t),o(f,s,t),e(s,Ps,t),o(J,s,t),e(s,Ds,t),e(s,w,t),e(s,Ks,t),e(s,T,t),e(s,Os,t),e(s,x,t),e(s,st,t),e(s,U,t),e(s,tt,t),e(s,$,t),e(s,lt,t),o(C,s,t),e(s,et,t),e(s,Z,t),e(s,at,t),e(s,_,t),e(s,nt,t),e(s,v,t),e(s,pt,t),o(V,s,t),e(s,it,t),e(s,G,t),e(s,rt,t),o(W,s,t),e(s,mt,t),e(s,I,t),e(s,ct,t),o(k,s,t),e(s,ot,t),o(B,s,t),e(s,gt,t),e(s,X,t),e(s,ht,t),e(s,Q,t),e(s,jt,t),e(s,R,t),e(s,Mt,t),o(H,s,t),e(s,dt,t),e(s,F,t),e(s,ut,t),o(N,s,t),e(s,bt,t),e(s,E,t),e(s,yt,t),e(s,z,t),e(s,ft,t),e(s,Y,t),e(s,Jt,t),o(A,s,t),e(s,wt,t),e(s,q,t),e(s,Tt,t),e(s,L,t),e(s,xt,t),o(S,s,t),e(s,Ut,t),e(s,u,t),e(s,$t,t),e(s,P,t),e(s,Ct,t),e(s,D,t),e(s,Zt,t),e(s,K,t),e(s,_t,t),o(O,s,t),e(s,vt,t),e(s,ss,t),e(s,Vt,t),o(ts,s,t),e(s,Gt,t),o(ls,s,t),e(s,Wt,t),e(s,es,t),e(s,It,t),o(as,s,t),e(s,kt,t),e(s,ns,t),e(s,Bt,t),e(s,ps,t),e(s,Xt,t),e(s,is,t),e(s,Qt,t),o(rs,s,t),e(s,Rt,t),e(s,ms,t),e(s,Ht,t),o(cs,s,t),e(s,Ft,t),e(s,os,t),e(s,Nt,t),o(gs,s,t),e(s,Et,t),o(hs,s,t),e(s,zt,t),e(s,js,t),e(s,Yt,t),o(Ms,s,t),e(s,At,t),e(s,ds,t),e(s,qt,t),e(s,us,t),e(s,Lt,t),o(bs,s,t),e(s,St,t),e(s,b,t),e(s,Pt,t),o(ys,s,t),e(s,Dt,t),e(s,y,t),e(s,Kt,t),o(fs,s,t),e(s,Ot,t),e(s,Js,t),e(s,sl,t),o(ws,s,t),e(s,tl,t),o(Ts,s,t),e(s,ll,t),e(s,xs,t),e(s,el,t),o(Us,s,t),e(s,al,t),e(s,$s,t),e(s,nl,t),o(Cs,s,t),e(s,pl,t),e(s,Zs,t),e(s,il,t),e(s,_s,t),e(s,rl,t),e(s,vs,t),e(s,ml,t),o(Vs,s,t),e(s,cl,t),o(Gs,s,t),e(s,ol,t),e(s,Ws,t),e(s,gl,t),e(s,Is,t),e(s,hl,t),o(ks,s,t),e(s,jl,t),e(s,Bs,t),e(s,Ml,t),o(Xs,s,t),e(s,dl,t),e(s,Qs,t),e(s,ul,t),o(Rs,s,t),e(s,bl,t),e(s,Hs,t),e(s,yl,t),o(Fs,s,t),e(s,fl,t),e(s,Ns,t),e(s,Jl,t),o(Es,s,t),e(s,wl,t),e(s,As,t),Tl=!0},p:fe,i(s){Tl||(g(f.$$.fragment,s),g(J.$$.fragment,s),g(C.$$.fragment,s),g(V.$$.fragment,s),g(W.$$.fragment,s),g(k.$$.fragment,s),g(B.$$.fragment,s),g(H.$$.fragment,s),g(N.$$.fragment,s),g(A.$$.fragment,s),g(S.$$.fragment,s),g(O.$$.fragment,s),g(ts.$$.fragment,s),g(ls.$$.fragment,s),g(as.$$.fragment,s),g(rs.$$.fragment,s),g(cs.$$.fragment,s),g(gs.$$.fragment,s),g(hs.$$.fragment,s),g(Ms.$$.fragment,s),g(bs.$$.fragment,s),g(ys.$$.fragment,s),g(fs.$$.fragment,s),g(ws.$$.fragment,s),g(Ts.$$.fragment,s),g(Us.$$.fragment,s),g(Cs.$$.fragment,s),g(Vs.$$.fragment,s),g(Gs.$$.fragment,s),g(ks.$$.fragment,s),g(Xs.$$.fragment,s),g(Rs.$$.fragment,s),g(Fs.$$.fragment,s),g(Es.$$.fragment,s),Tl=!0)},o(s){h(f.$$.fragment,s),h(J.$$.fragment,s),h(C.$$.fragment,s),h(V.$$.fragment,s),h(W.$$.fragment,s),h(k.$$.fragment,s),h(B.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(A.$$.fragment,s),h(S.$$.fragment,s),h(O.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(as.$$.fragment,s),h(rs.$$.fragment,s),h(cs.$$.fragment,s),h(gs.$$.fragment,s),h(hs.$$.fragment,s),h(Ms.$$.fragment,s),h(bs.$$.fragment,s),h(ys.$$.fragment,s),h(fs.$$.fragment,s),h(ws.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h(Cs.$$.fragment,s),h(Vs.$$.fragment,s),h(Gs.$$.fragment,s),h(ks.$$.fragment,s),h(Xs.$$.fragment,s),h(Rs.$$.fragment,s),h(Fs.$$.fragment,s),h(Es.$$.fragment,s),Tl=!1},d(s){s&&(l(Ls),l(Ys),l(Ss),l(Ps),l(Ds),l(w),l(Ks),l(T),l(Os),l(x),l(st),l(U),l(tt),l($),l(lt),l(et),l(Z),l(at),l(_),l(nt),l(v),l(pt),l(it),l(G),l(rt),l(mt),l(I),l(ct),l(ot),l(gt),l(X),l(ht),l(Q),l(jt),l(R),l(Mt),l(dt),l(F),l(ut),l(bt),l(E),l(yt),l(z),l(ft),l(Y),l(Jt),l(wt),l(q),l(Tt),l(L),l(xt),l(Ut),l(u),l($t),l(P),l(Ct),l(D),l(Zt),l(K),l(_t),l(vt),l(ss),l(Vt),l(Gt),l(Wt),l(es),l(It),l(kt),l(ns),l(Bt),l(ps),l(Xt),l(is),l(Qt),l(Rt),l(ms),l(Ht),l(Ft),l(os),l(Nt),l(Et),l(zt),l(js),l(Yt),l(At),l(ds),l(qt),l(us),l(Lt),l(St),l(b),l(Pt),l(Dt),l(y),l(Kt),l(Ot),l(Js),l(sl),l(tl),l(ll),l(xs),l(el),l(al),l($s),l(nl),l(pl),l(Zs),l(il),l(_s),l(rl),l(vs),l(ml),l(cl),l(ol),l(Ws),l(gl),l(Is),l(hl),l(jl),l(Bs),l(Ml),l(dl),l(Qs),l(ul),l(bl),l(Hs),l(yl),l(fl),l(Ns),l(Jl),l(wl),l(As)),l(d),j(f,s),j(J,s),j(C,s),j(V,s),j(W,s),j(k,s),j(B,s),j(H,s),j(N,s),j(A,s),j(S,s),j(O,s),j(ts,s),j(ls,s),j(as,s),j(rs,s),j(cs,s),j(gs,s),j(hs,s),j(Ms,s),j(bs,s),j(ys,s),j(fs,s),j(ws,s),j(Ts,s),j(Us,s),j(Cs,s),j(Vs,s),j(Gs,s),j(ks,s),j(Xs,s),j(Rs,s),j(Fs,s),j(Es,s)}}}const _e='{"title":"Visual Question Answering","local":"visual-question-answering","sections":[{"title":"Fine-tuning ViLT","local":"fine-tuning-vilt","sections":[],"depth":2},{"title":"Load the data","local":"load-the-data","sections":[],"depth":2},{"title":"Preprocessing data","local":"preprocessing-data","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Zero-shot VQA","local":"zero-shot-vqa","sections":[],"depth":2}],"depth":1}';function ve(xl){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends we{constructor(d){super(),Te(this,d,ve,Ze,ye,{})}}export{Be as component};
