import{s as qo,o as jo,n as Tt}from"../chunks/scheduler.9bc65507.js";import{S as Fo,i as Io,g as l,s as n,r as f,A as Uo,h as i,f as o,c as s,j as z,u,x as c,k as q,y as a,a as r,v as _,d as h,t as g,w as k}from"../chunks/index.707bf1b6.js";import{T as wo}from"../chunks/Tip.c2ecdbf4.js";import{D as I}from"../chunks/Docstring.86474e80.js";import{C as Ae}from"../chunks/CodeBlock.54a9f38d.js";import{E as zo}from"../chunks/ExampleCodeBlock.034f3a73.js";import{H as Ne,E as Jo}from"../chunks/EditOnGithub.922df6ba.js";function Eo(U){let d,L="Code Llama のベースとなる<code>Llama2</code>ファミリー モデルは、<code>bfloat16</code>を使用してトレーニングされましたが、元の推論では<code>float16</code>を使用します。さまざまな精度を見てみましょう。",m,b,M="<li><code>float32</code>: モデルの初期化に関する PyTorch の規約では、モデルの重みがどの <code>dtype</code> で格納されたかに関係なく、モデルを <code>float32</code> にロードします。 「transformers」も、PyTorch との一貫性を保つためにこの規則に従っています。これはデフォルトで選択されます。 <code>AutoModel</code> API でストレージの重み付けタイプを使用してチェックポイントのロードをキャストする場合は、<code>torch_dtype=&quot;auto&quot;</code> を指定する必要があります。 <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>。</li> <li><code>bfloat16</code>: コード Llama はこの精度でトレーニングされているため、さらなるトレーニングや微調整に使用することをお勧めします。</li> <li><code>float16</code>: この精度を使用して推論を実行することをお勧めします。通常は <code>bfloat16</code> より高速であり、評価メトリクスには <code>bfloat16</code> と比べて明らかな低下が見られないためです。 bfloat16 を使用して推論を実行することもできます。微調整後、float16 と bfloat16 の両方で推論結果を確認することをお勧めします。</li>",v,y,N="上で述べたように、モデルを初期化するときに <code>torch_dtype=&quot;auto&quot;</code> を使用しない限り、ストレージの重みの <code>dtype</code> はほとんど無関係です。その理由は、モデルが最初にダウンロードされ (オンラインのチェックポイントの <code>dtype</code> を使用)、次に <code>torch</code> のデフォルトの <code>dtype</code> にキャストされるためです (<code>torch.float32</code> になります)。指定された <code>torch_dtype</code> がある場合は、代わりにそれが使用されます。";return{c(){d=l("p"),d.innerHTML=L,m=n(),b=l("ul"),b.innerHTML=M,v=n(),y=l("p"),y.innerHTML=N},l(x){d=i(x,"P",{"data-svelte-h":!0}),c(d)!=="svelte-roqng7"&&(d.innerHTML=L),m=s(x),b=i(x,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-71l69f"&&(b.innerHTML=M),v=s(x),y=i(x,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1g8mroy"&&(y.innerHTML=N)},m(x,P){r(x,d,P),r(x,m,P),r(x,b,P),r(x,v,P),r(x,y,P)},p:Tt,d(x){x&&(o(d),o(m),o(b),o(v),o(y))}}}function Po(U){let d,L=`コード Llama は、<code>Llama2</code> モデルと同じアーキテクチャを持っています。API リファレンスについては、<a href="llama2">Llama2 のドキュメント ページ</a> を参照してください。
以下の Code Llama トークナイザーのリファレンスを見つけてください。`;return{c(){d=l("p"),d.innerHTML=L},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-cvveze"&&(d.innerHTML=L)},m(m,b){r(m,d,b)},p:Tt,d(m){m&&o(d)}}}function Wo(U){let d,L="sequence pair mask has the following format:",m,b,M;return b=new Ae({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=l("p"),d.textContent=L,m=n(),f(b.$$.fragment)},l(v){d=i(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-16klr56"&&(d.textContent=L),m=s(v),u(b.$$.fragment,v)},m(v,y){r(v,d,y),r(v,m,y),_(b,v,y),M=!0},p:Tt,i(v){M||(h(b.$$.fragment,v),M=!0)},o(v){g(b.$$.fragment,v),M=!1},d(v){v&&(o(d),o(m)),k(b,v)}}}function Ho(U){let d,L;return d=new Ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVMbGFtYVRva2VuaXplckZhc3QlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGxhbWEtdG9rZW5pemVyJTIyKSUwQXRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGlzJTIwaXMlMjBhJTIwdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeLlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){f(d.$$.fragment)},l(m){u(d.$$.fragment,m)},m(m,b){_(d,m,b),L=!0},p:Tt,i(m){L||(h(d.$$.fragment,m),L=!0)},o(m){g(d.$$.fragment,m),L=!1},d(m){k(d,m)}}}function Zo(U){let d,L,m,b,M,v,y,N,x,P=`Code Llama モデルはによって <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> で提案されました。 Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.
論文の要約は次のとおりです。`,Xe,A,Qt="<em>私たちは Code Llama をリリースします。これは Llama 2 に基づくコードの大規模言語モデル ファミリであり、オープン モデルの中で最先端のパフォーマンス、埋め込み機能、大規模な入力コンテキストのサポート、プログラミング タスクのゼロショット命令追従機能を提供します。 。幅広いアプリケーションをカバーするための複数のフレーバーを提供しています。基盤モデル (Code Llama)、Python 特化 (Code Llama - Python)、およびそれぞれ 7B、13B、および 34B パラメーターを備えた命令追従モデル (Code Llama - Instruct) です。すべてのモデルは 16,000 トークンのシーケンスでトレーニングされ、最大 100,000 トークンの入力で改善が見られます。 7B および 13B コード ラマとコード ラマ - 命令バリアントは、周囲のコンテンツに基づいた埋め込みをサポートします。 Code Llama は、いくつかのコード ベンチマークでオープン モデルの中で最先端のパフォーマンスに達し、HumanEval と MBPP でそれぞれ最大 53% と 55% のスコアを獲得しました。特に、Code Llama - Python 7B は HumanEval および MBPP 上で Llama 2 70B よりも優れたパフォーマンスを示し、すべてのモデルは MultiPL-E 上で公開されている他のすべてのモデルよりも優れています。私たちは、研究と商業利用の両方を許可する寛容なライセンスに基づいて Code Llama をリリースしています。</em>",Se,X,Ot='すべての Code Llama モデル チェックポイントを <a href="https://huggingface.co/models?search=code_llama" rel="nofollow">こちら</a> で確認し、<a href="https://huggingface.co/meta-llama" rel="nofollow">meta llama org</a> で正式にリリースされたチェックポイントを確認してください。',Ye,S,Kt='このモデルは <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZucker</a> によって提供されました。著者のオリジナルのコードは <a href="https://github.com/facebookresearch/llama" rel="nofollow">こちら</a> にあります。',Qe,Y,Oe,W,Ke,Q,eo="チップ：",et,O,to="<li>充填タスクはすぐにサポートされます。入力を埋めたい場所には <code>tokenizer.fill_token</code> を使用する必要があります。</li> <li>モデル変換スクリプトは、<code>Llama2</code> ファミリの場合と同じです。</li>",tt,K,oo="使用例は次のとおりです。",ot,ee,nt,te,no=`スクリプトを実行するには、(最大のバージョンであっても) float16 精度でモデル全体をホストするのに十分な CPU RAM が必要であることに注意してください。
いくつかのチェックポイントがあり、それぞれにモデルの各重みの一部が含まれているため、すべてを RAM にロードする必要があります)。`,st,oe,so="変換後、モデルとトークナイザーは次の方法でロードできます。",at,ne,rt,se,ao="塗りつぶされた部分だけが必要な場合:",lt,ae,it,re,ro='内部では、トークナイザーが <a href="https://huggingface.co/docs/transformers/main/model_doc/code_llama#transformers.CodeLlamaTokenizer.fill_token" rel="nofollow"><code>&lt;FILL_ME&gt;</code> によって自動的に分割</a> して、<a href="https://github.com/facebookresearch/codellama/blob/cb51c14ec761370ba2e2bc351374a79265d0465e/llama/generation.py#L402" rel="nofollow">に続く書式設定された入力文字列を作成します。オリジナルのトレーニング パターン</a>。これは、パターンを自分で準備するよりも堅牢です。トークンの接着など、デバッグが非常に難しい落とし穴を回避できます。このモデルまたは他のモデルに必要な CPU および GPU メモリの量を確認するには、その値を決定するのに役立つ <a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">この計算ツール</a> を試してください。',dt,le,lo='LLaMA トークナイザーは、<a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a> に基づく BPE モデルです。センテンスピースの癖の 1 つは、シーケンスをデコードするときに、最初のトークンが単語の先頭 (例: 「Banana」) である場合、トークナイザーは文字列の先頭にプレフィックス スペースを追加しないことです。',ct,H,mt,ie,pt,$,de,xt,ye,io=`Construct a CodeLlama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as
there is no padding token in the original model.`,yt,$e,co=`The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,$t,Le,ce,Lt,Z,me,Ct,Ce,mo=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Mt,j,pe,wt,Me,po="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",zt,G,qt,we,fo="if token_ids_1 is None, only returns the first portion of the mask (0s).",jt,B,fe,Ft,ze,uo="Save the vocabulary and special tokens file to a directory.",ft,ue,ut,p,_e,It,qe,_o="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Ut,je,ho="This uses notably ByteFallback and no normalization.",Jt,R,Et,Fe,go=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Pt,Ie,ko=`This tokenizer inherits from <a href="/docs/transformers/pr_29969/ja/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods. The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">meta-llama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Wt,w,he,Ht,Ue,bo=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,Zt,Je,vo="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",Gt,Ee,To="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",Bt,Pe,xo=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Rt,V,ge,Vt,We,yo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Dt,J,ke,Nt,He,$o=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,At,Ze,Lo="Should be overridden in a subclass if the model has a special way of building those.",Xt,D,be,St,Ge,Co="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Yt,Be,ve,_t,Te,ht,Ve,gt;return M=new Ne({props:{title:"CodeLlama",local:"codellama",headingTag:"h1"}}),y=new Ne({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new Ne({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),W=new wo({props:{warning:!0,$$slots:{default:[Eo]},$$scope:{ctx:U}}}),ee=new Ae({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),ne=new Ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBDb2RlTGxhbWFUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGQ29kZUxsYW1hLTdiLWhmJTIyKSUwQVBST01QVCUyMCUzRCUyMCcnJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKFBST01QVCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4KSUwQSUwQWZpbGxpbmclMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlNUIlM0ElMkMlMjBpbnB1dF9pZHMuc2hhcGUlNUIxJTVEJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUyMCUzRCUyMFRydWUpJTVCMCU1RCUwQXByaW50KFBST01QVC5yZXBsYWNlKCUyMiUzQ0ZJTExfTUUlM0UlMjIlMkMlMjBmaWxsaW5nKSklMEElMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, CodeLlamaTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>PROMPT = <span class="hljs-string">&#x27;&#x27;&#x27;def remove_non_ascii(s: str) -&gt; str:
    &quot;&quot;&quot; &lt;FILL_ME&gt;
    return result
&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_ids, max_new_tokens=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filling = tokenizer.batch_decode(generated_ids[:, input_ids.shape[<span class="hljs-number">1</span>]:], skip_special_tokens = <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(PROMPT.replace(<span class="hljs-string">&quot;&lt;FILL_ME&gt;&quot;</span>, filling))
<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_non_ascii</span>(<span class="hljs-params">s: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot; Remove non-ASCII characters from a string.

    Args:
        s: The string to remove non-ASCII characters from.

    Returns:
        The string with non-ASCII characters removed.
    &quot;&quot;&quot;</span>
    result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> s:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">ord</span>(c) &lt; <span class="hljs-number">128</span>:
            result += c
    <span class="hljs-keyword">return</span> result`,wrap:!1}}),ae=new Ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkNtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIlMkN0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEFnZW5lcmF0b3IoJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTVDbiUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyMCUzQ0ZJTExfTUUlM0UlNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0JyUyQyUyMG1heF9uZXdfdG9rZW5zJTIwJTNEJTIwMTI4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>,model=<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>,torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return result&#x27;</span>, max_new_tokens = <span class="hljs-number">128</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return resultRemove non-ASCII characters from a string. &quot;&quot;&quot;\\n    result = &quot;&quot;\\n    for c in s:\\n        if ord(c) &lt; 128:\\n            result += c&#x27;</span>}]`,wrap:!1}}),H=new wo({props:{$$slots:{default:[Po]},$$scope:{ctx:U}}}),ie=new Ne({props:{title:"CodeLlamaTokenizer",local:"transformers.CodeLlamaTokenizer",headingTag:"h2"}}),de=new I({props:{name:"class transformers.CodeLlamaTokenizer",anchor:"transformers.CodeLlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"suffix_first",val:" = False"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"additional_special_tokens",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizer.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizer.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizer.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizer.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.CodeLlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama.py#L49"}}),ce=new I({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama.py#L357"}}),me=new I({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama.py#L369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),pe=new I({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),G=new zo({props:{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Wo]},$$scope:{ctx:U}}}),fe=new I({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama.py#L329",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),ue=new Ne({props:{title:"CodeLlamaTokenizerFast",local:"transformers.CodeLlamaTokenizerFast",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.CodeLlamaTokenizerFast",anchor:"transformers.CodeLlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"additional_special_tokens",val:" = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CodeLlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Wether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizerFast.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L52"}}),R=new zo({props:{anchor:"transformers.CodeLlamaTokenizerFast.example",$$slots:{default:[Ho]},$$scope:{ctx:U}}}),he=new I({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ge=new I({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/tokenization_utils_base.py#L3944",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),ke=new I({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/tokenization_utils_base.py#L3474",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),be=new I({props:{name:"update_post_processor",anchor:"transformers.CodeLlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L179"}}),ve=new I({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29969/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L333"}}),Te=new Jo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/model_doc/code_llama.md"}}),{c(){d=l("meta"),L=n(),m=l("p"),b=n(),f(M.$$.fragment),v=n(),f(y.$$.fragment),N=n(),x=l("p"),x.innerHTML=P,Xe=n(),A=l("p"),A.innerHTML=Qt,Se=n(),X=l("p"),X.innerHTML=Ot,Ye=n(),S=l("p"),S.innerHTML=Kt,Qe=n(),f(Y.$$.fragment),Oe=n(),f(W.$$.fragment),Ke=n(),Q=l("p"),Q.textContent=eo,et=n(),O=l("ul"),O.innerHTML=to,tt=n(),K=l("p"),K.textContent=oo,ot=n(),f(ee.$$.fragment),nt=n(),te=l("p"),te.textContent=no,st=n(),oe=l("p"),oe.textContent=so,at=n(),f(ne.$$.fragment),rt=n(),se=l("p"),se.textContent=ao,lt=n(),f(ae.$$.fragment),it=n(),re=l("p"),re.innerHTML=ro,dt=n(),le=l("p"),le.innerHTML=lo,ct=n(),f(H.$$.fragment),mt=n(),f(ie.$$.fragment),pt=n(),$=l("div"),f(de.$$.fragment),xt=n(),ye=l("p"),ye.textContent=io,yt=n(),$e=l("p"),$e.innerHTML=co,$t=n(),Le=l("div"),f(ce.$$.fragment),Lt=n(),Z=l("div"),f(me.$$.fragment),Ct=n(),Ce=l("p"),Ce.innerHTML=mo,Mt=n(),j=l("div"),f(pe.$$.fragment),wt=n(),Me=l("p"),Me.textContent=po,zt=n(),f(G.$$.fragment),qt=n(),we=l("p"),we.textContent=fo,jt=n(),B=l("div"),f(fe.$$.fragment),Ft=n(),ze=l("p"),ze.textContent=uo,ft=n(),f(ue.$$.fragment),ut=n(),p=l("div"),f(_e.$$.fragment),It=n(),qe=l("p"),qe.textContent=_o,Ut=n(),je=l("p"),je.textContent=ho,Jt=n(),f(R.$$.fragment),Et=n(),Fe=l("p"),Fe.innerHTML=go,Pt=n(),Ie=l("p"),Ie.innerHTML=ko,Wt=n(),w=l("div"),f(he.$$.fragment),Ht=n(),Ue=l("p"),Ue.textContent=bo,Zt=n(),Je=l("p"),Je.innerHTML=vo,Gt=n(),Ee=l("ul"),Ee.innerHTML=To,Bt=n(),Pe=l("p"),Pe.textContent=xo,Rt=n(),V=l("div"),f(ge.$$.fragment),Vt=n(),We=l("p"),We.innerHTML=yo,Dt=n(),J=l("div"),f(ke.$$.fragment),Nt=n(),He=l("p"),He.innerHTML=$o,At=n(),Ze=l("p"),Ze.textContent=Lo,Xt=n(),D=l("div"),f(be.$$.fragment),St=n(),Ge=l("p"),Ge.innerHTML=Co,Yt=n(),Be=l("div"),f(ve.$$.fragment),_t=n(),f(Te.$$.fragment),ht=n(),Ve=l("p"),this.h()},l(e){const t=Uo("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(o),L=s(e),m=i(e,"P",{}),z(m).forEach(o),b=s(e),u(M.$$.fragment,e),v=s(e),u(y.$$.fragment,e),N=s(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1njx1ag"&&(x.innerHTML=P),Xe=s(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-sy6as4"&&(A.innerHTML=Qt),Se=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-191lytw"&&(X.innerHTML=Ot),Ye=s(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-2m739y"&&(S.innerHTML=Kt),Qe=s(e),u(Y.$$.fragment,e),Oe=s(e),u(W.$$.fragment,e),Ke=s(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-fhhf9b"&&(Q.textContent=eo),et=s(e),O=i(e,"UL",{"data-svelte-h":!0}),c(O)!=="svelte-1bm3iwk"&&(O.innerHTML=to),tt=s(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1l145o"&&(K.textContent=oo),ot=s(e),u(ee.$$.fragment,e),nt=s(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-8qdh8l"&&(te.textContent=no),st=s(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1otl2iw"&&(oe.textContent=so),at=s(e),u(ne.$$.fragment,e),rt=s(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1fz6bbs"&&(se.textContent=ao),lt=s(e),u(ae.$$.fragment,e),it=s(e),re=i(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1eh4tus"&&(re.innerHTML=ro),dt=s(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-53awnm"&&(le.innerHTML=lo),ct=s(e),u(H.$$.fragment,e),mt=s(e),u(ie.$$.fragment,e),pt=s(e),$=i(e,"DIV",{class:!0});var C=z($);u(de.$$.fragment,C),xt=s(C),ye=i(C,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1vmwvh5"&&(ye.textContent=io),yt=s(C),$e=i(C,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1a4a72p"&&($e.innerHTML=co),$t=s(C),Le=i(C,"DIV",{class:!0});var De=z(Le);u(ce.$$.fragment,De),De.forEach(o),Lt=s(C),Z=i(C,"DIV",{class:!0});var xe=z(Z);u(me.$$.fragment,xe),Ct=s(xe),Ce=i(xe,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1f4f5kp"&&(Ce.innerHTML=mo),xe.forEach(o),Mt=s(C),j=i(C,"DIV",{class:!0});var F=z(j);u(pe.$$.fragment,F),wt=s(F),Me=i(F,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-13bfd60"&&(Me.textContent=po),zt=s(F),u(G.$$.fragment,F),qt=s(F),we=i(F,"P",{"data-svelte-h":!0}),c(we)!=="svelte-wtrslu"&&(we.textContent=fo),F.forEach(o),jt=s(C),B=i(C,"DIV",{class:!0});var kt=z(B);u(fe.$$.fragment,kt),Ft=s(kt),ze=i(kt,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1slb66l"&&(ze.textContent=uo),kt.forEach(o),C.forEach(o),ft=s(e),u(ue.$$.fragment,e),ut=s(e),p=i(e,"DIV",{class:!0});var T=z(p);u(_e.$$.fragment,T),It=s(T),qe=i(T,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-15tdcz8"&&(qe.textContent=_o),Ut=s(T),je=i(T,"P",{"data-svelte-h":!0}),c(je)!=="svelte-llhmpa"&&(je.textContent=ho),Jt=s(T),u(R.$$.fragment,T),Et=s(T),Fe=i(T,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-cnb6q1"&&(Fe.innerHTML=go),Pt=s(T),Ie=i(T,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-11gxl4z"&&(Ie.innerHTML=ko),Wt=s(T),w=i(T,"DIV",{class:!0});var E=z(w);u(he.$$.fragment,E),Ht=s(E),Ue=i(E,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1vll0v2"&&(Ue.textContent=bo),Zt=s(E),Je=i(E,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-90np8u"&&(Je.innerHTML=vo),Gt=s(E),Ee=i(E,"UL",{"data-svelte-h":!0}),c(Ee)!=="svelte-mlrsks"&&(Ee.innerHTML=To),Bt=s(E),Pe=i(E,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-46aam0"&&(Pe.textContent=xo),E.forEach(o),Rt=s(T),V=i(T,"DIV",{class:!0});var bt=z(V);u(ge.$$.fragment,bt),Vt=s(bt),We=i(bt,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1wmjg8a"&&(We.innerHTML=yo),bt.forEach(o),Dt=s(T),J=i(T,"DIV",{class:!0});var Re=z(J);u(ke.$$.fragment,Re),Nt=s(Re),He=i(Re,"P",{"data-svelte-h":!0}),c(He)!=="svelte-zj1vf1"&&(He.innerHTML=$o),At=s(Re),Ze=i(Re,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-9vptpw"&&(Ze.textContent=Lo),Re.forEach(o),Xt=s(T),D=i(T,"DIV",{class:!0});var vt=z(D);u(be.$$.fragment,vt),St=s(vt),Ge=i(vt,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-nfci2w"&&(Ge.innerHTML=Co),vt.forEach(o),Yt=s(T),Be=i(T,"DIV",{class:!0});var Mo=z(Be);u(ve.$$.fragment,Mo),Mo.forEach(o),T.forEach(o),_t=s(e),u(Te.$$.fragment,e),ht=s(e),Ve=i(e,"P",{}),z(Ve).forEach(o),this.h()},h(){q(d,"name","hf:doc:metadata"),q(d,"content",Go),q(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,d),r(e,L,t),r(e,m,t),r(e,b,t),_(M,e,t),r(e,v,t),_(y,e,t),r(e,N,t),r(e,x,t),r(e,Xe,t),r(e,A,t),r(e,Se,t),r(e,X,t),r(e,Ye,t),r(e,S,t),r(e,Qe,t),_(Y,e,t),r(e,Oe,t),_(W,e,t),r(e,Ke,t),r(e,Q,t),r(e,et,t),r(e,O,t),r(e,tt,t),r(e,K,t),r(e,ot,t),_(ee,e,t),r(e,nt,t),r(e,te,t),r(e,st,t),r(e,oe,t),r(e,at,t),_(ne,e,t),r(e,rt,t),r(e,se,t),r(e,lt,t),_(ae,e,t),r(e,it,t),r(e,re,t),r(e,dt,t),r(e,le,t),r(e,ct,t),_(H,e,t),r(e,mt,t),_(ie,e,t),r(e,pt,t),r(e,$,t),_(de,$,null),a($,xt),a($,ye),a($,yt),a($,$e),a($,$t),a($,Le),_(ce,Le,null),a($,Lt),a($,Z),_(me,Z,null),a(Z,Ct),a(Z,Ce),a($,Mt),a($,j),_(pe,j,null),a(j,wt),a(j,Me),a(j,zt),_(G,j,null),a(j,qt),a(j,we),a($,jt),a($,B),_(fe,B,null),a(B,Ft),a(B,ze),r(e,ft,t),_(ue,e,t),r(e,ut,t),r(e,p,t),_(_e,p,null),a(p,It),a(p,qe),a(p,Ut),a(p,je),a(p,Jt),_(R,p,null),a(p,Et),a(p,Fe),a(p,Pt),a(p,Ie),a(p,Wt),a(p,w),_(he,w,null),a(w,Ht),a(w,Ue),a(w,Zt),a(w,Je),a(w,Gt),a(w,Ee),a(w,Bt),a(w,Pe),a(p,Rt),a(p,V),_(ge,V,null),a(V,Vt),a(V,We),a(p,Dt),a(p,J),_(ke,J,null),a(J,Nt),a(J,He),a(J,At),a(J,Ze),a(p,Xt),a(p,D),_(be,D,null),a(D,St),a(D,Ge),a(p,Yt),a(p,Be),_(ve,Be,null),r(e,_t,t),_(Te,e,t),r(e,ht,t),r(e,Ve,t),gt=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),W.$set(C);const De={};t&2&&(De.$$scope={dirty:t,ctx:e}),H.$set(De);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),G.$set(xe);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),R.$set(F)},i(e){gt||(h(M.$$.fragment,e),h(y.$$.fragment,e),h(Y.$$.fragment,e),h(W.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(H.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(G.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(R.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(ke.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),gt=!0)},o(e){g(M.$$.fragment,e),g(y.$$.fragment,e),g(Y.$$.fragment,e),g(W.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(H.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(G.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(R.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(ke.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),gt=!1},d(e){e&&(o(L),o(m),o(b),o(v),o(N),o(x),o(Xe),o(A),o(Se),o(X),o(Ye),o(S),o(Qe),o(Oe),o(Ke),o(Q),o(et),o(O),o(tt),o(K),o(ot),o(nt),o(te),o(st),o(oe),o(at),o(rt),o(se),o(lt),o(it),o(re),o(dt),o(le),o(ct),o(mt),o(pt),o($),o(ft),o(ut),o(p),o(_t),o(ht),o(Ve)),o(d),k(M,e),k(y,e),k(Y,e),k(W,e),k(ee,e),k(ne,e),k(ae,e),k(H,e),k(ie,e),k(de),k(ce),k(me),k(pe),k(G),k(fe),k(ue,e),k(_e),k(R),k(he),k(ge),k(ke),k(be),k(ve),k(Te,e)}}}const Go='{"title":"CodeLlama","local":"codellama","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"CodeLlamaTokenizer","local":"transformers.CodeLlamaTokenizer","sections":[],"depth":2},{"title":"CodeLlamaTokenizerFast","local":"transformers.CodeLlamaTokenizerFast","sections":[],"depth":2}],"depth":1}';function Bo(U){return jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yo extends Fo{constructor(d){super(),Io(this,d,Bo,Zo,qo,{})}}export{Yo as component};
