import{s as Lo,o as Po,n as ws}from"../chunks/scheduler.25b97de1.js";import{S as Do,i as Ko,g as o,s as a,r,A as Oo,h as i,f as s,c as n,j as Yo,u as M,x as p,k as Fo,y as ti,a as l,v as y,d as c,t as m,w as u,m as ei,n as si}from"../chunks/index.d9030fc9.js";import{T as Ts}from"../chunks/Tip.baa67368.js";import{C as d}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as li}from"../chunks/EditOnGithub.91d95064.js";function ai(C){let h,w=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,J,U,I=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){h=o("p"),h.innerHTML=w,J=a(),U=o("p"),U.innerHTML=I},l(f){h=i(f,"P",{"data-svelte-h":!0}),p(h)!=="svelte-148xjo3"&&(h.innerHTML=w),J=n(f),U=i(f,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1hgzema"&&(U.innerHTML=I)},m(f,G){l(f,h,G),l(f,J,G),l(f,U,G)},p:ws,d(f){f&&(s(h),s(J),s(U))}}}function ni(C){let h,w=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){h=o("p"),h.innerHTML=w},l(J){h=i(J,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1wfdwuk"&&(h.innerHTML=w)},m(J,U){l(J,h,U)},p:ws,d(J){J&&s(h)}}}function oi(C){let h,w=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,J,U,I,f,G="and",x,g,Q;return U=new d({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),g=new d({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){h=o("p"),h.innerHTML=w,J=a(),r(U.$$.fragment),I=a(),f=o("p"),f.textContent=G,x=a(),r(g.$$.fragment)},l(T){h=i(T,"P",{"data-svelte-h":!0}),p(h)!=="svelte-70hqps"&&(h.innerHTML=w),J=n(T),M(U.$$.fragment,T),I=n(T),f=i(T,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1qlona5"&&(f.textContent=G),x=n(T),M(g.$$.fragment,T)},m(T,b){l(T,h,b),l(T,J,b),y(U,T,b),l(T,I,b),l(T,f,b),l(T,x,b),y(g,T,b),Q=!0},p:ws,i(T){Q||(c(U.$$.fragment,T),c(g.$$.fragment,T),Q=!0)},o(T){m(U.$$.fragment,T),m(g.$$.fragment,T),Q=!1},d(T){T&&(s(h),s(J),s(I),s(f),s(x)),u(U,T),u(g,T)}}}function ii(C){let h;return{c(){h=ei(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(w){h=si(w,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(w,J){l(w,h,J)},d(w){w&&s(h)}}}function pi(C){let h,w=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){h=o("p"),h.innerHTML=w},l(J){h=i(J,"P",{"data-svelte-h":!0}),p(h)!=="svelte-qy60pj"&&(h.innerHTML=w)},m(J,U){l(J,h,U)},p:ws,d(J){J&&s(h)}}}function ri(C){let h,w=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){h=o("p"),h.innerHTML=w},l(J){h=i(J,"P",{"data-svelte-h":!0}),p(h)!=="svelte-cvlh0x"&&(h.innerHTML=w)},m(J,U){l(J,h,U)},p:ws,d(J){J&&s(h)}}}function Mi(C){let h,w,J,U,I,f,G,x,g,Q=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,T,b,cn=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,js,q,mn=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,fs,W,Is,V,un=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>mistralai/Mistral-7B-Instruct-v0.1</code> model.`,gs,S,bs,A,hn=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!). Mistral-instruct was trained with these tokens, but BlenderBot was not.`,Cs,_,Gs,z,dn=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_29969/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,xs,R,Jn="Here’s an example of preparing input for <code>model.generate()</code>, using the <code>Zephyr</code> assistant model:",Bs,X,$s,E,Tn="This will yield a string in the input format that Zephyr expects.",vs,H,Zs,Y,Un="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",ks,F,Ns,L,wn="This will yield:",Qs,P,qs,D,jn="Arr, ‘twas easy after all!",Ws,K,Vs,O,fn=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_29969/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Ss,tt,As,et,_s,st,In=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,zs,lt,Rs,at,gn=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Xs,nt,Es,ot,bn="Here’s what this will look like without a generation prompt, using the ChatML template we saw in the Zephyr example:",Hs,it,Ys,pt,Cn="And here’s what it looks like <strong>with</strong> a generation prompt:",Fs,rt,Ls,Mt,Gn=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Ps,yt,xn=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ds,ct,Ks,mt,Bn=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,Os,ut,tl,ht,$n="And we get:",el,dt,sl,Jt,vn="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",ll,B,al,Tt,nl,Ut,Zn=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,ol,wt,kn=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,il,jt,pl,ft,Nn=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,rl,It,Ml,gt,Qn=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,yl,bt,qn=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,cl,Ct,ml,Gt,Wn=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,ul,xt,Vn="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",hl,Bt,dl,$t,Sn=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,Jl,vt,An="First, let’s load our model and tokenizer:",Tl,Zt,Ul,kt,_n="Next, let’s define a list of tools:",wl,Nt,jl,Qt,zn="Now, let’s set up a conversation for our bot:",fl,qt,Il,Wt,Rn="Now, let’s apply the chat template and generate a response:",gl,Vt,bl,St,Xn="And we get:",Cl,At,Gl,_t,En=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,xl,$,Bl,zt,Hn="Next, let’s append the model’s tool call to the conversation.",$l,Rt,vl,Xt,Yn=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,Zl,Et,kl,v,Nl,Ht,Fn="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Ql,Yt,ql,Ft,Ln="And we get:",Wl,Lt,Vl,Pt,Pn=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,Sl,Dt,Al,Kt,Dn=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,_l,Ot,Kn=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,zl,te,Rl,ee,On="This will yield:",Xl,se,El,le,to=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Hl,ae,eo="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Yl,ne,Fl,oe,Ll,ie,so=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,Pl,pe,lo="Here’s an example of a RAG template in action:",Dl,re,Kl,Me,Ol,ye,ao=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,ta,ce,ea,me,no=`That’s kind of intimidating. Let’s clean it up a little to make it more readable. In the process, though, we also make
sure that the newlines and indentation we add don’t end up being included in the template output - see the tip on
<a href="#trimming-whitespace">trimming whitespace</a> below!`,sa,ue,la,he,oo=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,aa,de,na,Je,io="Effectively, the template does three things:",oa,Te,po="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",ia,Ue,ro=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,pa,we,ra,je,Mo=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Ma,fe,ya,Ie,ca,ge,yo=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,ma,be,ua,Ce,co=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_29969/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_29969/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,ha,Ge,da,xe,mo=`The method <a href="/docs/transformers/pr_29969/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_29969/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_29969/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,Ja,Z,Ta,Be,Ua,$e,uo=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,wa,ve,ho=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,ja,Ze,Jo=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,fa,ke,Ia,Ne,To=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,ga,Qe,Uo=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,ba,qe,Ca,We,wo=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Ga,Ve,xa,Se,jo=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Ba,Ae,$a,_e,fo=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_29969/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,va,ze,Za,Re,Io=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_29969/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,ka,Xe,go=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Na,Ee,bo=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Qa,He,qa,k,Wa,Ye,Co=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,Va,Fe,Go="You can also use the following tips to write clean, efficient Jinja templates:",Sa,Le,Aa,Pe,xo=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,_a,De,za,Ke,Bo="rather than like this:",Ra,Oe,Xa,ts,$o=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,Ea,es,Ha,ss,vo=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,Ya,ls,Zo="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",Fa,N,La,as,Pa,ns,ko="There is also a short list of callable functions available to you inside your templates. These are:",Da,os,No=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,Ka,is,Oa,ps,Qo=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,tn,rs,qo=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,en,Ms,Wo=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,sn,ys,ln,cs,Vo=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,an,ms,nn,us,So="Or load the edited template back into the tokenizer:",on,hs,pn,ds,Ao=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,rn,Js,Mn,Us,yn;return I=new j({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),G=new j({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),W=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),S=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),_=new j({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),X=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),H=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),F=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),P=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),K=new j({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),tt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),et=new d({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),lt=new j({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),nt=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),it=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),rt=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),ct=new j({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),ut=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),dt=new d({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),B=new Ts({props:{$$slots:{default:[ai]},$$scope:{ctx:C}}}),Tt=new j({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),jt=new j({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),It=new d({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),Ct=new j({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Bt=new j({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),Zt=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Nt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),qt=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),Vt=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),At=new d({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),$=new Ts({props:{$$slots:{default:[ni]},$$scope:{ctx:C}}}),Rt=new d({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),Et=new d({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),v=new Ts({props:{$$slots:{default:[oi]},$$scope:{ctx:C}}}),Yt=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Lt=new d({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),Dt=new j({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),te=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),se=new d({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ne=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),oe=new j({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),re=new d({props:{code:"ZG9jdW1lbnQxJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJUaGUlMjBNb29uJTNBJTIwT3VyJTIwQWdlLU9sZCUyMEZvZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnRzJTIyJTNBJTIwJTIyTWFuJTIwaGFzJTIwYWx3YXlzJTIwZHJlYW1lZCUyMG9mJTIwZGVzdHJveWluZyUyMHRoZSUyMG1vb24uJTIwSW4lMjB0aGlzJTIwZXNzYXklMkMlMjBJJTIwc2hhbGwuLi4lMjIlMEElN0QlMEElMEFkb2N1bWVudDIlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMlRoZSUyMFN1biUzQSUyME91ciUyMEFnZS1PbGQlMjBGcmllbmQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50cyUyMiUzQSUyMCUyMkFsdGhvdWdoJTIwb2Z0ZW4lMjB1bmRlcmFwcHJlY2lhdGVkJTJDJTIwdGhlJTIwc3VuJTIwcHJvdmlkZXMlMjBzZXZlcmFsJTIwbm90YWJsZSUyMGJlbmVmaXRzLi4uJTIyJTBBJTdEJTBBJTBBbW9kZWxfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRCU1QmRvY3VtZW50MSUyQyUyMGRvY3VtZW50MiU1RCUwQSk=",highlighted:`document1 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
}

document2 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
}

model_input = tokenizer.apply_chat_template(
    messages,
    documents=[document1, document2]
)`,wrap:!1}}),Me=new j({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),ce=new d({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5jaGF0X3RlbXBsYXRl",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),ue=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclMjAlMjAnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3Qi0lMjBlb3NfdG9rZW4lMjAlN0QlN0Q=",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> message[&#x27;role&#x27;] == &#x27;user&#x27; %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27; &#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> not loop.last %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27;  &#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{- eos_token }}</span>`,wrap:!1}}),de=new d({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),we=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),fe=new j({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),Ie=new j({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),be=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Ge=new d({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),Z=new Ts({props:{$$slots:{default:[ii]},$$scope:{ctx:C}}}),Be=new j({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),ke=new j({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),qe=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Ve=new d({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Ae=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),ze=new j({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),He=new j({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),k=new Ts({props:{$$slots:{default:[pi]},$$scope:{ctx:C}}}),Le=new j({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),De=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Oe=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),es=new j({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),N=new Ts({props:{$$slots:{default:[ri]},$$scope:{ctx:C}}}),as=new j({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),is=new j({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),ys=new j({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),ms=new d({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),hs=new d({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Js=new li({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){h=o("meta"),w=a(),J=o("p"),U=a(),r(I.$$.fragment),f=a(),r(G.$$.fragment),x=a(),g=o("p"),g.innerHTML=Q,T=a(),b=o("p"),b.innerHTML=cn,js=a(),q=o("p"),q.innerHTML=mn,fs=a(),r(W.$$.fragment),Is=a(),V=o("p"),V.innerHTML=un,gs=a(),r(S.$$.fragment),bs=a(),A=o("p"),A.textContent=hn,Cs=a(),r(_.$$.fragment),Gs=a(),z=o("p"),z.innerHTML=dn,xs=a(),R=o("p"),R.innerHTML=Jn,Bs=a(),r(X.$$.fragment),$s=a(),E=o("p"),E.textContent=Tn,vs=a(),r(H.$$.fragment),Zs=a(),Y=o("p"),Y.textContent=Un,ks=a(),r(F.$$.fragment),Ns=a(),L=o("p"),L.textContent=wn,Qs=a(),r(P.$$.fragment),qs=a(),D=o("p"),D.textContent=jn,Ws=a(),r(K.$$.fragment),Vs=a(),O=o("p"),O.innerHTML=fn,Ss=a(),r(tt.$$.fragment),As=a(),r(et.$$.fragment),_s=a(),st=o("p"),st.innerHTML=In,zs=a(),r(lt.$$.fragment),Rs=a(),at=o("p"),at.innerHTML=gn,Xs=a(),r(nt.$$.fragment),Es=a(),ot=o("p"),ot.textContent=bn,Hs=a(),r(it.$$.fragment),Ys=a(),pt=o("p"),pt.innerHTML=Cn,Fs=a(),r(rt.$$.fragment),Ls=a(),Mt=o("p"),Mt.textContent=Gn,Ps=a(),yt=o("p"),yt.innerHTML=xn,Ds=a(),r(ct.$$.fragment),Ks=a(),mt=o("p"),mt.innerHTML=Bn,Os=a(),r(ut.$$.fragment),tl=a(),ht=o("p"),ht.textContent=$n,el=a(),r(dt.$$.fragment),sl=a(),Jt=o("p"),Jt.innerHTML=vn,ll=a(),r(B.$$.fragment),al=a(),r(Tt.$$.fragment),nl=a(),Ut=o("p"),Ut.innerHTML=Zn,ol=a(),wt=o("p"),wt.textContent=kn,il=a(),r(jt.$$.fragment),pl=a(),ft=o("p"),ft.innerHTML=Nn,rl=a(),r(It.$$.fragment),Ml=a(),gt=o("p"),gt.textContent=Qn,yl=a(),bt=o("ul"),bt.innerHTML=qn,cl=a(),r(Ct.$$.fragment),ml=a(),Gt=o("p"),Gt.textContent=Wn,ul=a(),xt=o("ol"),xt.innerHTML=Vn,hl=a(),r(Bt.$$.fragment),dl=a(),$t=o("p"),$t.innerHTML=Sn,Jl=a(),vt=o("p"),vt.textContent=An,Tl=a(),r(Zt.$$.fragment),Ul=a(),kt=o("p"),kt.textContent=_n,wl=a(),r(Nt.$$.fragment),jl=a(),Qt=o("p"),Qt.textContent=zn,fl=a(),r(qt.$$.fragment),Il=a(),Wt=o("p"),Wt.textContent=Rn,gl=a(),r(Vt.$$.fragment),bl=a(),St=o("p"),St.textContent=Xn,Cl=a(),r(At.$$.fragment),Gl=a(),_t=o("p"),_t.textContent=En,xl=a(),r($.$$.fragment),Bl=a(),zt=o("p"),zt.textContent=Hn,$l=a(),r(Rt.$$.fragment),vl=a(),Xt=o("p"),Xt.textContent=Yn,Zl=a(),r(Et.$$.fragment),kl=a(),r(v.$$.fragment),Nl=a(),Ht=o("p"),Ht.textContent=Fn,Ql=a(),r(Yt.$$.fragment),ql=a(),Ft=o("p"),Ft.textContent=Ln,Wl=a(),r(Lt.$$.fragment),Vl=a(),Pt=o("p"),Pt.textContent=Pn,Sl=a(),r(Dt.$$.fragment),Al=a(),Kt=o("p"),Kt.innerHTML=Dn,_l=a(),Ot=o("p"),Ot.textContent=Kn,zl=a(),r(te.$$.fragment),Rl=a(),ee=o("p"),ee.textContent=On,Xl=a(),r(se.$$.fragment),El=a(),le=o("p"),le.innerHTML=to,Hl=a(),ae=o("p"),ae.innerHTML=eo,Yl=a(),r(ne.$$.fragment),Fl=a(),r(oe.$$.fragment),Ll=a(),ie=o("p"),ie.innerHTML=so,Pl=a(),pe=o("p"),pe.textContent=lo,Dl=a(),r(re.$$.fragment),Kl=a(),r(Me.$$.fragment),Ol=a(),ye=o("p"),ye.innerHTML=ao,ta=a(),r(ce.$$.fragment),ea=a(),me=o("p"),me.innerHTML=no,sa=a(),r(ue.$$.fragment),la=a(),he=o("p"),he.innerHTML=oo,aa=a(),r(de.$$.fragment),na=a(),Je=o("p"),Je.textContent=io,oa=a(),Te=o("ol"),Te.innerHTML=po,ia=a(),Ue=o("p"),Ue.textContent=ro,pa=a(),r(we.$$.fragment),ra=a(),je=o("p"),je.textContent=Mo,Ma=a(),r(fe.$$.fragment),ya=a(),r(Ie.$$.fragment),ca=a(),ge=o("p"),ge.innerHTML=yo,ma=a(),r(be.$$.fragment),ua=a(),Ce=o("p"),Ce.innerHTML=co,ha=a(),r(Ge.$$.fragment),da=a(),xe=o("p"),xe.innerHTML=mo,Ja=a(),r(Z.$$.fragment),Ta=a(),r(Be.$$.fragment),Ua=a(),$e=o("p"),$e.innerHTML=uo,wa=a(),ve=o("p"),ve.innerHTML=ho,ja=a(),Ze=o("p"),Ze.textContent=Jo,fa=a(),r(ke.$$.fragment),Ia=a(),Ne=o("p"),Ne.textContent=To,ga=a(),Qe=o("p"),Qe.innerHTML=Uo,ba=a(),r(qe.$$.fragment),Ca=a(),We=o("p"),We.innerHTML=wo,Ga=a(),r(Ve.$$.fragment),xa=a(),Se=o("p"),Se.innerHTML=jo,Ba=a(),r(Ae.$$.fragment),$a=a(),_e=o("p"),_e.innerHTML=fo,va=a(),r(ze.$$.fragment),Za=a(),Re=o("p"),Re.innerHTML=Io,ka=a(),Xe=o("p"),Xe.innerHTML=go,Na=a(),Ee=o("p"),Ee.textContent=bo,Qa=a(),r(He.$$.fragment),qa=a(),r(k.$$.fragment),Wa=a(),Ye=o("p"),Ye.innerHTML=Co,Va=a(),Fe=o("p"),Fe.textContent=Go,Sa=a(),r(Le.$$.fragment),Aa=a(),Pe=o("p"),Pe.textContent=xo,_a=a(),r(De.$$.fragment),za=a(),Ke=o("p"),Ke.textContent=Bo,Ra=a(),r(Oe.$$.fragment),Xa=a(),ts=o("p"),ts.innerHTML=$o,Ea=a(),r(es.$$.fragment),Ha=a(),ss=o("p"),ss.innerHTML=vo,Ya=a(),ls=o("ul"),ls.innerHTML=Zo,Fa=a(),r(N.$$.fragment),La=a(),r(as.$$.fragment),Pa=a(),ns=o("p"),ns.textContent=ko,Da=a(),os=o("ul"),os.innerHTML=No,Ka=a(),r(is.$$.fragment),Oa=a(),ps=o("p"),ps.innerHTML=Qo,tn=a(),rs=o("p"),rs.textContent=qo,en=a(),Ms=o("ul"),Ms.innerHTML=Wo,sn=a(),r(ys.$$.fragment),ln=a(),cs=o("p"),cs.textContent=Vo,an=a(),r(ms.$$.fragment),nn=a(),us=o("p"),us.textContent=So,on=a(),r(hs.$$.fragment),pn=a(),ds=o("p"),ds.textContent=Ao,rn=a(),r(Js.$$.fragment),Mn=a(),Us=o("p"),this.h()},l(t){const e=Oo("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(t),J=i(t,"P",{}),Yo(J).forEach(s),U=n(t),M(I.$$.fragment,t),f=n(t),M(G.$$.fragment,t),x=n(t),g=i(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ydi30o"&&(g.innerHTML=Q),T=n(t),b=i(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1p8dq8"&&(b.innerHTML=cn),js=n(t),q=i(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1n6wf0k"&&(q.innerHTML=mn),fs=n(t),M(W.$$.fragment,t),Is=n(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1e3bvfs"&&(V.innerHTML=un),gs=n(t),M(S.$$.fragment,t),bs=n(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-15k3bj3"&&(A.textContent=hn),Cs=n(t),M(_.$$.fragment,t),Gs=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-7hlg3n"&&(z.innerHTML=dn),xs=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-gmslqw"&&(R.innerHTML=Jn),Bs=n(t),M(X.$$.fragment,t),$s=n(t),E=i(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1vy7akj"&&(E.textContent=Tn),vs=n(t),M(H.$$.fragment,t),Zs=n(t),Y=i(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-hj60o5"&&(Y.textContent=Un),ks=n(t),M(F.$$.fragment,t),Ns=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1bfcqd3"&&(L.textContent=wn),Qs=n(t),M(P.$$.fragment,t),qs=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-k9m2iy"&&(D.textContent=jn),Ws=n(t),M(K.$$.fragment,t),Vs=n(t),O=i(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-90u0fi"&&(O.innerHTML=fn),Ss=n(t),M(tt.$$.fragment,t),As=n(t),M(et.$$.fragment,t),_s=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-5umvde"&&(st.innerHTML=In),zs=n(t),M(lt.$$.fragment,t),Rs=n(t),at=i(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-rhnu79"&&(at.innerHTML=gn),Xs=n(t),M(nt.$$.fragment,t),Es=n(t),ot=i(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1g5nifq"&&(ot.textContent=bn),Hs=n(t),M(it.$$.fragment,t),Ys=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-61bp3d"&&(pt.innerHTML=Cn),Fs=n(t),M(rt.$$.fragment,t),Ls=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-inq88f"&&(Mt.textContent=Gn),Ps=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-76qw2e"&&(yt.innerHTML=xn),Ds=n(t),M(ct.$$.fragment,t),Ks=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-i3l9c1"&&(mt.innerHTML=Bn),Os=n(t),M(ut.$$.fragment,t),tl=n(t),ht=i(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-13505nn"&&(ht.textContent=$n),el=n(t),M(dt.$$.fragment,t),sl=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-ziuqkt"&&(Jt.innerHTML=vn),ll=n(t),M(B.$$.fragment,t),al=n(t),M(Tt.$$.fragment,t),nl=n(t),Ut=i(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-dd615e"&&(Ut.innerHTML=Zn),ol=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-dcun4m"&&(wt.textContent=kn),il=n(t),M(jt.$$.fragment,t),pl=n(t),ft=i(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-6sd0wq"&&(ft.innerHTML=Nn),rl=n(t),M(It.$$.fragment,t),Ml=n(t),gt=i(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-608o9m"&&(gt.textContent=Qn),yl=n(t),bt=i(t,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-n1b3zm"&&(bt.innerHTML=qn),cl=n(t),M(Ct.$$.fragment,t),ml=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-11962fa"&&(Gt.textContent=Wn),ul=n(t),xt=i(t,"OL",{"data-svelte-h":!0}),p(xt)!=="svelte-1vd84s7"&&(xt.innerHTML=Vn),hl=n(t),M(Bt.$$.fragment,t),dl=n(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-1oi0gsn"&&($t.innerHTML=Sn),Jl=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-o8n6v4"&&(vt.textContent=An),Tl=n(t),M(Zt.$$.fragment,t),Ul=n(t),kt=i(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-1q7358y"&&(kt.textContent=_n),wl=n(t),M(Nt.$$.fragment,t),jl=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-11hfyaa"&&(Qt.textContent=zn),fl=n(t),M(qt.$$.fragment,t),Il=n(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1usrd3e"&&(Wt.textContent=Rn),gl=n(t),M(Vt.$$.fragment,t),bl=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-13505nn"&&(St.textContent=Xn),Cl=n(t),M(At.$$.fragment,t),Gl=n(t),_t=i(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-nxltbo"&&(_t.textContent=En),xl=n(t),M($.$$.fragment,t),Bl=n(t),zt=i(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-336ooj"&&(zt.textContent=Hn),$l=n(t),M(Rt.$$.fragment,t),vl=n(t),Xt=i(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-1mv1vl9"&&(Xt.textContent=Yn),Zl=n(t),M(Et.$$.fragment,t),kl=n(t),M(v.$$.fragment,t),Nl=n(t),Ht=i(t,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1qjybqz"&&(Ht.textContent=Fn),Ql=n(t),M(Yt.$$.fragment,t),ql=n(t),Ft=i(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-13505nn"&&(Ft.textContent=Ln),Wl=n(t),M(Lt.$$.fragment,t),Vl=n(t),Pt=i(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1evxmus"&&(Pt.textContent=Pn),Sl=n(t),M(Dt.$$.fragment,t),Al=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-pl4mbs"&&(Kt.innerHTML=Dn),_l=n(t),Ot=i(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-37xmdz"&&(Ot.textContent=Kn),zl=n(t),M(te.$$.fragment,t),Rl=n(t),ee=i(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1bfcqd3"&&(ee.textContent=On),Xl=n(t),M(se.$$.fragment,t),El=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-19t6fs5"&&(le.innerHTML=to),Hl=n(t),ae=i(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1nlyrys"&&(ae.innerHTML=eo),Yl=n(t),M(ne.$$.fragment,t),Fl=n(t),M(oe.$$.fragment,t),Ll=n(t),ie=i(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1977j4z"&&(ie.innerHTML=so),Pl=n(t),pe=i(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1xmnzcc"&&(pe.textContent=lo),Dl=n(t),M(re.$$.fragment,t),Kl=n(t),M(Me.$$.fragment,t),Ol=n(t),ye=i(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-9hx4bd"&&(ye.innerHTML=ao),ta=n(t),M(ce.$$.fragment,t),ea=n(t),me=i(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1adekhh"&&(me.innerHTML=no),sa=n(t),M(ue.$$.fragment,t),la=n(t),he=i(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-zet1qo"&&(he.innerHTML=oo),aa=n(t),M(de.$$.fragment,t),na=n(t),Je=i(t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-9bdwn1"&&(Je.textContent=io),oa=n(t),Te=i(t,"OL",{"data-svelte-h":!0}),p(Te)!=="svelte-yy2gop"&&(Te.innerHTML=po),ia=n(t),Ue=i(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-jxu6rq"&&(Ue.textContent=ro),pa=n(t),M(we.$$.fragment,t),ra=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-dqaxjt"&&(je.textContent=Mo),Ma=n(t),M(fe.$$.fragment,t),ya=n(t),M(Ie.$$.fragment,t),ca=n(t),ge=i(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1ubxgh9"&&(ge.innerHTML=yo),ma=n(t),M(be.$$.fragment,t),ua=n(t),Ce=i(t,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-kkgzno"&&(Ce.innerHTML=co),ha=n(t),M(Ge.$$.fragment,t),da=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-4i2tnb"&&(xe.innerHTML=mo),Ja=n(t),M(Z.$$.fragment,t),Ta=n(t),M(Be.$$.fragment,t),Ua=n(t),$e=i(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1d7cql4"&&($e.innerHTML=uo),wa=n(t),ve=i(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1u88h1j"&&(ve.innerHTML=ho),ja=n(t),Ze=i(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1g7ri12"&&(Ze.textContent=Jo),fa=n(t),M(ke.$$.fragment,t),Ia=n(t),Ne=i(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-5u6sqi"&&(Ne.textContent=To),ga=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-ffreiw"&&(Qe.innerHTML=Uo),ba=n(t),M(qe.$$.fragment,t),Ca=n(t),We=i(t,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1cj1ql7"&&(We.innerHTML=wo),Ga=n(t),M(Ve.$$.fragment,t),xa=n(t),Se=i(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-soh9qu"&&(Se.innerHTML=jo),Ba=n(t),M(Ae.$$.fragment,t),$a=n(t),_e=i(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-y9nsgz"&&(_e.innerHTML=fo),va=n(t),M(ze.$$.fragment,t),Za=n(t),Re=i(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1aoic20"&&(Re.innerHTML=Io),ka=n(t),Xe=i(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-kn2i6o"&&(Xe.innerHTML=go),Na=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-197jyne"&&(Ee.textContent=bo),Qa=n(t),M(He.$$.fragment,t),qa=n(t),M(k.$$.fragment,t),Wa=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1eu5v04"&&(Ye.innerHTML=Co),Va=n(t),Fe=i(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-10wmjwo"&&(Fe.textContent=Go),Sa=n(t),M(Le.$$.fragment,t),Aa=n(t),Pe=i(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1ttgeg7"&&(Pe.textContent=xo),_a=n(t),M(De.$$.fragment,t),za=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-qihux6"&&(Ke.textContent=Bo),Ra=n(t),M(Oe.$$.fragment,t),Xa=n(t),ts=i(t,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-pefrh0"&&(ts.innerHTML=$o),Ea=n(t),M(es.$$.fragment,t),Ha=n(t),ss=i(t,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-1s7e55r"&&(ss.innerHTML=vo),Ya=n(t),ls=i(t,"UL",{"data-svelte-h":!0}),p(ls)!=="svelte-1rdzqgp"&&(ls.innerHTML=Zo),Fa=n(t),M(N.$$.fragment,t),La=n(t),M(as.$$.fragment,t),Pa=n(t),ns=i(t,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-w29vry"&&(ns.textContent=ko),Da=n(t),os=i(t,"UL",{"data-svelte-h":!0}),p(os)!=="svelte-1fmzhdy"&&(os.innerHTML=No),Ka=n(t),M(is.$$.fragment,t),Oa=n(t),ps=i(t,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-jvvtjt"&&(ps.innerHTML=Qo),tn=n(t),rs=i(t,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-f0ucf0"&&(rs.textContent=qo),en=n(t),Ms=i(t,"UL",{"data-svelte-h":!0}),p(Ms)!=="svelte-doa6oc"&&(Ms.innerHTML=Wo),sn=n(t),M(ys.$$.fragment,t),ln=n(t),cs=i(t,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-180ap61"&&(cs.textContent=Vo),an=n(t),M(ms.$$.fragment,t),nn=n(t),us=i(t,"P",{"data-svelte-h":!0}),p(us)!=="svelte-1bv602"&&(us.textContent=So),on=n(t),M(hs.$$.fragment,t),pn=n(t),ds=i(t,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-1mq7g8k"&&(ds.textContent=Ao),rn=n(t),M(Js.$$.fragment,t),Mn=n(t),Us=i(t,"P",{}),Yo(Us).forEach(s),this.h()},h(){Fo(h,"name","hf:doc:metadata"),Fo(h,"content",yi)},m(t,e){ti(document.head,h),l(t,w,e),l(t,J,e),l(t,U,e),y(I,t,e),l(t,f,e),y(G,t,e),l(t,x,e),l(t,g,e),l(t,T,e),l(t,b,e),l(t,js,e),l(t,q,e),l(t,fs,e),y(W,t,e),l(t,Is,e),l(t,V,e),l(t,gs,e),y(S,t,e),l(t,bs,e),l(t,A,e),l(t,Cs,e),y(_,t,e),l(t,Gs,e),l(t,z,e),l(t,xs,e),l(t,R,e),l(t,Bs,e),y(X,t,e),l(t,$s,e),l(t,E,e),l(t,vs,e),y(H,t,e),l(t,Zs,e),l(t,Y,e),l(t,ks,e),y(F,t,e),l(t,Ns,e),l(t,L,e),l(t,Qs,e),y(P,t,e),l(t,qs,e),l(t,D,e),l(t,Ws,e),y(K,t,e),l(t,Vs,e),l(t,O,e),l(t,Ss,e),y(tt,t,e),l(t,As,e),y(et,t,e),l(t,_s,e),l(t,st,e),l(t,zs,e),y(lt,t,e),l(t,Rs,e),l(t,at,e),l(t,Xs,e),y(nt,t,e),l(t,Es,e),l(t,ot,e),l(t,Hs,e),y(it,t,e),l(t,Ys,e),l(t,pt,e),l(t,Fs,e),y(rt,t,e),l(t,Ls,e),l(t,Mt,e),l(t,Ps,e),l(t,yt,e),l(t,Ds,e),y(ct,t,e),l(t,Ks,e),l(t,mt,e),l(t,Os,e),y(ut,t,e),l(t,tl,e),l(t,ht,e),l(t,el,e),y(dt,t,e),l(t,sl,e),l(t,Jt,e),l(t,ll,e),y(B,t,e),l(t,al,e),y(Tt,t,e),l(t,nl,e),l(t,Ut,e),l(t,ol,e),l(t,wt,e),l(t,il,e),y(jt,t,e),l(t,pl,e),l(t,ft,e),l(t,rl,e),y(It,t,e),l(t,Ml,e),l(t,gt,e),l(t,yl,e),l(t,bt,e),l(t,cl,e),y(Ct,t,e),l(t,ml,e),l(t,Gt,e),l(t,ul,e),l(t,xt,e),l(t,hl,e),y(Bt,t,e),l(t,dl,e),l(t,$t,e),l(t,Jl,e),l(t,vt,e),l(t,Tl,e),y(Zt,t,e),l(t,Ul,e),l(t,kt,e),l(t,wl,e),y(Nt,t,e),l(t,jl,e),l(t,Qt,e),l(t,fl,e),y(qt,t,e),l(t,Il,e),l(t,Wt,e),l(t,gl,e),y(Vt,t,e),l(t,bl,e),l(t,St,e),l(t,Cl,e),y(At,t,e),l(t,Gl,e),l(t,_t,e),l(t,xl,e),y($,t,e),l(t,Bl,e),l(t,zt,e),l(t,$l,e),y(Rt,t,e),l(t,vl,e),l(t,Xt,e),l(t,Zl,e),y(Et,t,e),l(t,kl,e),y(v,t,e),l(t,Nl,e),l(t,Ht,e),l(t,Ql,e),y(Yt,t,e),l(t,ql,e),l(t,Ft,e),l(t,Wl,e),y(Lt,t,e),l(t,Vl,e),l(t,Pt,e),l(t,Sl,e),y(Dt,t,e),l(t,Al,e),l(t,Kt,e),l(t,_l,e),l(t,Ot,e),l(t,zl,e),y(te,t,e),l(t,Rl,e),l(t,ee,e),l(t,Xl,e),y(se,t,e),l(t,El,e),l(t,le,e),l(t,Hl,e),l(t,ae,e),l(t,Yl,e),y(ne,t,e),l(t,Fl,e),y(oe,t,e),l(t,Ll,e),l(t,ie,e),l(t,Pl,e),l(t,pe,e),l(t,Dl,e),y(re,t,e),l(t,Kl,e),y(Me,t,e),l(t,Ol,e),l(t,ye,e),l(t,ta,e),y(ce,t,e),l(t,ea,e),l(t,me,e),l(t,sa,e),y(ue,t,e),l(t,la,e),l(t,he,e),l(t,aa,e),y(de,t,e),l(t,na,e),l(t,Je,e),l(t,oa,e),l(t,Te,e),l(t,ia,e),l(t,Ue,e),l(t,pa,e),y(we,t,e),l(t,ra,e),l(t,je,e),l(t,Ma,e),y(fe,t,e),l(t,ya,e),y(Ie,t,e),l(t,ca,e),l(t,ge,e),l(t,ma,e),y(be,t,e),l(t,ua,e),l(t,Ce,e),l(t,ha,e),y(Ge,t,e),l(t,da,e),l(t,xe,e),l(t,Ja,e),y(Z,t,e),l(t,Ta,e),y(Be,t,e),l(t,Ua,e),l(t,$e,e),l(t,wa,e),l(t,ve,e),l(t,ja,e),l(t,Ze,e),l(t,fa,e),y(ke,t,e),l(t,Ia,e),l(t,Ne,e),l(t,ga,e),l(t,Qe,e),l(t,ba,e),y(qe,t,e),l(t,Ca,e),l(t,We,e),l(t,Ga,e),y(Ve,t,e),l(t,xa,e),l(t,Se,e),l(t,Ba,e),y(Ae,t,e),l(t,$a,e),l(t,_e,e),l(t,va,e),y(ze,t,e),l(t,Za,e),l(t,Re,e),l(t,ka,e),l(t,Xe,e),l(t,Na,e),l(t,Ee,e),l(t,Qa,e),y(He,t,e),l(t,qa,e),y(k,t,e),l(t,Wa,e),l(t,Ye,e),l(t,Va,e),l(t,Fe,e),l(t,Sa,e),y(Le,t,e),l(t,Aa,e),l(t,Pe,e),l(t,_a,e),y(De,t,e),l(t,za,e),l(t,Ke,e),l(t,Ra,e),y(Oe,t,e),l(t,Xa,e),l(t,ts,e),l(t,Ea,e),y(es,t,e),l(t,Ha,e),l(t,ss,e),l(t,Ya,e),l(t,ls,e),l(t,Fa,e),y(N,t,e),l(t,La,e),y(as,t,e),l(t,Pa,e),l(t,ns,e),l(t,Da,e),l(t,os,e),l(t,Ka,e),y(is,t,e),l(t,Oa,e),l(t,ps,e),l(t,tn,e),l(t,rs,e),l(t,en,e),l(t,Ms,e),l(t,sn,e),y(ys,t,e),l(t,ln,e),l(t,cs,e),l(t,an,e),y(ms,t,e),l(t,nn,e),l(t,us,e),l(t,on,e),y(hs,t,e),l(t,pn,e),l(t,ds,e),l(t,rn,e),y(Js,t,e),l(t,Mn,e),l(t,Us,e),yn=!0},p(t,[e]){const _o={};e&2&&(_o.$$scope={dirty:e,ctx:t}),B.$set(_o);const zo={};e&2&&(zo.$$scope={dirty:e,ctx:t}),$.$set(zo);const Ro={};e&2&&(Ro.$$scope={dirty:e,ctx:t}),v.$set(Ro);const Xo={};e&2&&(Xo.$$scope={dirty:e,ctx:t}),Z.$set(Xo);const Eo={};e&2&&(Eo.$$scope={dirty:e,ctx:t}),k.$set(Eo);const Ho={};e&2&&(Ho.$$scope={dirty:e,ctx:t}),N.$set(Ho)},i(t){yn||(c(I.$$.fragment,t),c(G.$$.fragment,t),c(W.$$.fragment,t),c(S.$$.fragment,t),c(_.$$.fragment,t),c(X.$$.fragment,t),c(H.$$.fragment,t),c(F.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(rt.$$.fragment,t),c(ct.$$.fragment,t),c(ut.$$.fragment,t),c(dt.$$.fragment,t),c(B.$$.fragment,t),c(Tt.$$.fragment,t),c(jt.$$.fragment,t),c(It.$$.fragment,t),c(Ct.$$.fragment,t),c(Bt.$$.fragment,t),c(Zt.$$.fragment,t),c(Nt.$$.fragment,t),c(qt.$$.fragment,t),c(Vt.$$.fragment,t),c(At.$$.fragment,t),c($.$$.fragment,t),c(Rt.$$.fragment,t),c(Et.$$.fragment,t),c(v.$$.fragment,t),c(Yt.$$.fragment,t),c(Lt.$$.fragment,t),c(Dt.$$.fragment,t),c(te.$$.fragment,t),c(se.$$.fragment,t),c(ne.$$.fragment,t),c(oe.$$.fragment,t),c(re.$$.fragment,t),c(Me.$$.fragment,t),c(ce.$$.fragment,t),c(ue.$$.fragment,t),c(de.$$.fragment,t),c(we.$$.fragment,t),c(fe.$$.fragment,t),c(Ie.$$.fragment,t),c(be.$$.fragment,t),c(Ge.$$.fragment,t),c(Z.$$.fragment,t),c(Be.$$.fragment,t),c(ke.$$.fragment,t),c(qe.$$.fragment,t),c(Ve.$$.fragment,t),c(Ae.$$.fragment,t),c(ze.$$.fragment,t),c(He.$$.fragment,t),c(k.$$.fragment,t),c(Le.$$.fragment,t),c(De.$$.fragment,t),c(Oe.$$.fragment,t),c(es.$$.fragment,t),c(N.$$.fragment,t),c(as.$$.fragment,t),c(is.$$.fragment,t),c(ys.$$.fragment,t),c(ms.$$.fragment,t),c(hs.$$.fragment,t),c(Js.$$.fragment,t),yn=!0)},o(t){m(I.$$.fragment,t),m(G.$$.fragment,t),m(W.$$.fragment,t),m(S.$$.fragment,t),m(_.$$.fragment,t),m(X.$$.fragment,t),m(H.$$.fragment,t),m(F.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(dt.$$.fragment,t),m(B.$$.fragment,t),m(Tt.$$.fragment,t),m(jt.$$.fragment,t),m(It.$$.fragment,t),m(Ct.$$.fragment,t),m(Bt.$$.fragment,t),m(Zt.$$.fragment,t),m(Nt.$$.fragment,t),m(qt.$$.fragment,t),m(Vt.$$.fragment,t),m(At.$$.fragment,t),m($.$$.fragment,t),m(Rt.$$.fragment,t),m(Et.$$.fragment,t),m(v.$$.fragment,t),m(Yt.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(te.$$.fragment,t),m(se.$$.fragment,t),m(ne.$$.fragment,t),m(oe.$$.fragment,t),m(re.$$.fragment,t),m(Me.$$.fragment,t),m(ce.$$.fragment,t),m(ue.$$.fragment,t),m(de.$$.fragment,t),m(we.$$.fragment,t),m(fe.$$.fragment,t),m(Ie.$$.fragment,t),m(be.$$.fragment,t),m(Ge.$$.fragment,t),m(Z.$$.fragment,t),m(Be.$$.fragment,t),m(ke.$$.fragment,t),m(qe.$$.fragment,t),m(Ve.$$.fragment,t),m(Ae.$$.fragment,t),m(ze.$$.fragment,t),m(He.$$.fragment,t),m(k.$$.fragment,t),m(Le.$$.fragment,t),m(De.$$.fragment,t),m(Oe.$$.fragment,t),m(es.$$.fragment,t),m(N.$$.fragment,t),m(as.$$.fragment,t),m(is.$$.fragment,t),m(ys.$$.fragment,t),m(ms.$$.fragment,t),m(hs.$$.fragment,t),m(Js.$$.fragment,t),yn=!1},d(t){t&&(s(w),s(J),s(U),s(f),s(x),s(g),s(T),s(b),s(js),s(q),s(fs),s(Is),s(V),s(gs),s(bs),s(A),s(Cs),s(Gs),s(z),s(xs),s(R),s(Bs),s($s),s(E),s(vs),s(Zs),s(Y),s(ks),s(Ns),s(L),s(Qs),s(qs),s(D),s(Ws),s(Vs),s(O),s(Ss),s(As),s(_s),s(st),s(zs),s(Rs),s(at),s(Xs),s(Es),s(ot),s(Hs),s(Ys),s(pt),s(Fs),s(Ls),s(Mt),s(Ps),s(yt),s(Ds),s(Ks),s(mt),s(Os),s(tl),s(ht),s(el),s(sl),s(Jt),s(ll),s(al),s(nl),s(Ut),s(ol),s(wt),s(il),s(pl),s(ft),s(rl),s(Ml),s(gt),s(yl),s(bt),s(cl),s(ml),s(Gt),s(ul),s(xt),s(hl),s(dl),s($t),s(Jl),s(vt),s(Tl),s(Ul),s(kt),s(wl),s(jl),s(Qt),s(fl),s(Il),s(Wt),s(gl),s(bl),s(St),s(Cl),s(Gl),s(_t),s(xl),s(Bl),s(zt),s($l),s(vl),s(Xt),s(Zl),s(kl),s(Nl),s(Ht),s(Ql),s(ql),s(Ft),s(Wl),s(Vl),s(Pt),s(Sl),s(Al),s(Kt),s(_l),s(Ot),s(zl),s(Rl),s(ee),s(Xl),s(El),s(le),s(Hl),s(ae),s(Yl),s(Fl),s(Ll),s(ie),s(Pl),s(pe),s(Dl),s(Kl),s(Ol),s(ye),s(ta),s(ea),s(me),s(sa),s(la),s(he),s(aa),s(na),s(Je),s(oa),s(Te),s(ia),s(Ue),s(pa),s(ra),s(je),s(Ma),s(ya),s(ca),s(ge),s(ma),s(ua),s(Ce),s(ha),s(da),s(xe),s(Ja),s(Ta),s(Ua),s($e),s(wa),s(ve),s(ja),s(Ze),s(fa),s(Ia),s(Ne),s(ga),s(Qe),s(ba),s(Ca),s(We),s(Ga),s(xa),s(Se),s(Ba),s($a),s(_e),s(va),s(Za),s(Re),s(ka),s(Xe),s(Na),s(Ee),s(Qa),s(qa),s(Wa),s(Ye),s(Va),s(Fe),s(Sa),s(Aa),s(Pe),s(_a),s(za),s(Ke),s(Ra),s(Xa),s(ts),s(Ea),s(Ha),s(ss),s(Ya),s(ls),s(Fa),s(La),s(Pa),s(ns),s(Da),s(os),s(Ka),s(Oa),s(ps),s(tn),s(rs),s(en),s(Ms),s(sn),s(ln),s(cs),s(an),s(nn),s(us),s(on),s(pn),s(ds),s(rn),s(Mn),s(Us)),s(h),u(I,t),u(G,t),u(W,t),u(S,t),u(_,t),u(X,t),u(H,t),u(F,t),u(P,t),u(K,t),u(tt,t),u(et,t),u(lt,t),u(nt,t),u(it,t),u(rt,t),u(ct,t),u(ut,t),u(dt,t),u(B,t),u(Tt,t),u(jt,t),u(It,t),u(Ct,t),u(Bt,t),u(Zt,t),u(Nt,t),u(qt,t),u(Vt,t),u(At,t),u($,t),u(Rt,t),u(Et,t),u(v,t),u(Yt,t),u(Lt,t),u(Dt,t),u(te,t),u(se,t),u(ne,t),u(oe,t),u(re,t),u(Me,t),u(ce,t),u(ue,t),u(de,t),u(we,t),u(fe,t),u(Ie,t),u(be,t),u(Ge,t),u(Z,t),u(Be,t),u(ke,t),u(qe,t),u(Ve,t),u(Ae,t),u(ze,t),u(He,t),u(k,t),u(Le,t),u(De,t),u(Oe,t),u(es,t),u(N,t),u(as,t),u(is,t),u(ys,t),u(ms,t),u(hs,t),u(Js,t)}}}const yi='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3}],"depth":2}],"depth":1}';function ci(C){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ti extends Do{constructor(h){super(),Ko(this,h,ci,Mi,Lo,{})}}export{Ti as component};
