import{s as ke,o as Ae,n as Re}from"../chunks/scheduler.25b97de1.js";import{S as Ve,i as Xe,g as p,s as t,r as M,A as xe,h as i,f as a,c as n,j as Be,u as m,x as o,k as Va,y as $e,a as e,v as c,d as y,t as h,w as r}from"../chunks/index.d9030fc9.js";import{T as Fe}from"../chunks/Tip.baa67368.js";import{C as d}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Ye}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Ps,E as ze}from"../chunks/EditOnGithub.91d95064.js";function Ee(ll){let w,u='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/video-classification" rel="nofollow">task-page</a>.';return{c(){w=p("p"),w.innerHTML=u},l(J){w=i(J,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1cybrxm"&&(w.innerHTML=u)},m(J,Os){e(J,w,Os)},p:Re,d(J){J&&a(w)}}}function Se(ll){let w,u,J,Os,b,al,f,el,g,Xa="Video classification is the task of assigning a label or class to an entire video. Videos are expected to have only one class for each video. Video classification models take a video as input and return a prediction about which class the video belongs to. These models can be used to categorize what a video is all about. A real-world application of video classification is action / activity recognition, which is useful for fitness applications. It is also helpful for vision-impaired individuals, especially when they are commuting.",tl,I,xa="This guide will show you how to:",nl,C,$a='<li>Fine-tune <a href="https://huggingface.co/docs/transformers/main/en/model_doc/videomae" rel="nofollow">VideoMAE</a> on a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF101</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',pl,j,il,v,Fa="Before you begin, make sure you have all the necessary libraries installed:",ol,Z,Ml,G,Ya='You will use <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo</a> (dubbed <code>pytorchvideo</code>) to process and prepare the videos.',ml,_,za="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",cl,W,yl,B,hl,k,Ea='Start by loading a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF-101 dataset</a>. This will give you a chance to experiment and make sure everything works before spending more time training on the full dataset.',rl,A,dl,R,Sa="After the subset has been downloaded, you need to extract the compressed archive:",wl,V,Jl,X,Na="At a high level, the dataset is organized like so:",jl,x,Tl,$,Qa="You can then count the number of total videos.",Ul,F,ul,Y,bl,z,fl,E,Ha="The (<code>sorted</code>) video paths appear like so:",gl,S,Il,N,La="You will notice that there are video clips belonging to the same group / scene where group is denoted by <code>g</code> in the video file paths. <code>v_ApplyEyeMakeup_g07_c04.avi</code> and <code>v_ApplyEyeMakeup_g07_c06.avi</code>, for example.",Cl,Q,qa='For the validation and evaluation splits, you wouldn’t want to have video clips from the same group / scene to prevent <a href="https://www.kaggle.com/code/alexisbcook/data-leakage" rel="nofollow">data leakage</a>. The subset that you are using in this tutorial takes this information into account.',vl,H,Ka="Next up, you will derive the set of labels present in the dataset. Also, create two dictionaries that’ll be helpful when initializing the model:",Zl,L,Da="<li><code>label2id</code>: maps the class names to integers.</li> <li><code>id2label</code>: maps the integers to class names.</li>",Gl,q,_l,K,Pa="There are 10 unique classes. For each class, there are 30 videos in the training set.",Wl,D,Bl,P,Oa="Instantiate a video classification model from a pretrained checkpoint and its associated image processor. The model’s encoder comes with pre-trained parameters, and the classification head is randomly initialized. The image processor will come in handy when writing the preprocessing pipeline for our dataset.",kl,O,Al,ss,se="While the model is loading, you might notice the following warning:",Rl,ls,Vl,as,le="The warning is telling us we are throwing away some weights (e.g. the weights and bias of the <code>classifier</code> layer) and randomly initializing some others (the weights and bias of a new <code>classifier</code> layer). This is expected in this case, because we are adding a new head for which we don’t have pretrained weights, so the library warns us we should fine-tune this model before using it for inference, which is exactly what we are going to do.",Xl,es,ae='<strong>Note</strong> that <a href="https://huggingface.co/MCG-NJU/videomae-base-finetuned-kinetics" rel="nofollow">this checkpoint</a> leads to better performance on this task as the checkpoint was obtained fine-tuning on a similar downstream task having considerable domain overlap. You can check out <a href="https://huggingface.co/sayakpaul/videomae-base-finetuned-kinetics-finetuned-ucf101-subset" rel="nofollow">this checkpoint</a> which was obtained by fine-tuning <code>MCG-NJU/videomae-base-finetuned-kinetics</code>.',xl,ts,$l,ns,ee='For preprocessing the videos, you will leverage the <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo library</a>. Start by importing the dependencies we need.',Fl,ps,Yl,is,te='For the training dataset transformations, use a combination of uniform temporal subsampling, pixel normalization, random cropping, and random horizontal flipping. For the validation and evaluation dataset transformations, keep the same transformation chain except for random cropping and horizontal flipping. To learn more about the details of these transformations check out the <a href="https://pytorchvideo.org" rel="nofollow">official documentation of PyTorchVideo</a>.',zl,os,ne="Use the <code>image_processor</code> associated with the pre-trained model to obtain the following information:",El,Ms,pe="<li>Image mean and standard deviation with which the video frame pixels will be normalized.</li> <li>Spatial resolution to which the video frames will be resized.</li>",Sl,ms,ie="Start by defining some constants.",Nl,cs,Ql,ys,oe="Now, define the dataset-specific transformations and the datasets respectively. Starting with the training set:",Hl,hs,Ll,rs,Me="The same sequence of workflow can be applied to the validation and evaluation sets:",ql,ds,Kl,ws,me='<strong>Note</strong>: The above dataset pipelines are taken from the <a href="https://pytorchvideo.org/docs/tutorial_classification#dataset" rel="nofollow">official PyTorchVideo example</a>. We’re using the <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.Ucf101" rel="nofollow"><code>pytorchvideo.data.Ucf101()</code></a> function because it’s tailored for the UCF-101 dataset. Under the hood, it returns a <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.LabeledVideoDataset" rel="nofollow"><code>pytorchvideo.data.labeled_video_dataset.LabeledVideoDataset</code></a> object. <code>LabeledVideoDataset</code> class is the base class for all things video in the PyTorchVideo dataset. So, if you want to use a custom dataset not supported off-the-shelf by PyTorchVideo, you can extend the <code>LabeledVideoDataset</code> class accordingly. Refer to the <code>data</code> API <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html" rel="nofollow">documentation to</a> learn more. Also, if your dataset follows a similar structure (as shown above), then using the <code>pytorchvideo.data.Ucf101()</code> should work just fine.',Dl,Js,ce="You can access the <code>num_videos</code> argument to know the number of videos in the dataset.",Pl,js,Ol,Ts,sa,Us,la,T,ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif.gif" alt="Person playing basketball"/>',aa,us,ea,bs,he='Leverage <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow"><code>Trainer</code></a> from  🤗 Transformers for training the model. To instantiate a <code>Trainer</code>, you need to define the training configuration and an evaluation metric. The most important is the <a href="https://huggingface.co/transformers/main_classes/trainer.html#transformers.TrainingArguments" rel="nofollow"><code>TrainingArguments</code></a>, which is a class that contains all the attributes to configure the training. It requires an output folder name, which will be used to save the checkpoints of the model. It also helps sync all the information in the model repository on 🤗 Hub.',ta,fs,re="Most of the training arguments are self-explanatory, but one that is quite important here is <code>remove_unused_columns=False</code>. This one will drop any features not used by the model’s call function. By default it’s <code>True</code> because usually it’s ideal to drop unused feature columns, making it easier to unpack inputs into the model’s call function. But, in this case, you need the unused features (‘video’ in particular) in order to create <code>pixel_values</code> (which is a mandatory key our model expects in its inputs).",na,gs,pa,Is,de="The dataset returned by <code>pytorchvideo.data.Ucf101()</code> doesn’t implement the <code>__len__</code> method. As such, we must define <code>max_steps</code> when instantiating <code>TrainingArguments</code>.",ia,Cs,we="Next, you need to define a function to compute the metrics from the predictions, which will use the <code>metric</code> you’ll load now. The only preprocessing you have to do is to take the argmax of our predicted logits:",oa,vs,Ma,Zs,Je="<strong>A note on evaluation</strong>:",ma,Gs,je='In the <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE paper</a>, the authors use the following evaluation strategy. They evaluate the model on several clips from test videos and apply different crops to those clips and report the aggregate score. However, in the interest of simplicity and brevity, we don’t consider that in this tutorial.',ca,_s,Te="Also, define a <code>collate_fn</code>, which will be used to batch examples together. Each batch consists of 2 keys, namely <code>pixel_values</code> and <code>labels</code>.",ya,Ws,ha,Bs,Ue="Then you just pass all of this along with the datasets to <code>Trainer</code>:",ra,ks,da,As,ue="You might wonder why you passed along the <code>image_processor</code> as a tokenizer when you preprocessed the data already. This is only to make sure the image processor configuration file (stored as JSON) will also be uploaded to the repo on the Hub.",wa,Rs,be="Now fine-tune our model by calling the <code>train</code> method:",Ja,Vs,ja,Xs,fe='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/pr_29619/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',Ta,xs,Ua,$s,ua,Fs,ge="Great, now that you have fine-tuned a model, you can use it for inference!",ba,Ys,Ie="Load a video for inference:",fa,zs,ga,U,Ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif_two.gif" alt="Teams playing basketball"/>',Ia,Es,ve='The simplest way to try out your fine-tuned model for inference is to use it in a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.VideoClassificationPipeline" rel="nofollow"><code>pipeline</code></a>. Instantiate a <code>pipeline</code> for video classification with your model, and pass your video to it:',Ca,Ss,va,Ns,Ze="You can also manually replicate the results of the <code>pipeline</code> if you’d like.",Za,Qs,Ga,Hs,Ge="Now, pass your input to the model and return the <code>logits</code>:",_a,Ls,Wa,qs,_e="Decoding the <code>logits</code>, we get:",Ba,Ks,ka,Ds,Aa,sl,Ra;return b=new Ps({props:{title:"Video classification",local:"video-classification",headingTag:"h1"}}),f=new Ye({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"}]}}),j=new Fe({props:{$$slots:{default:[Ee]},$$scope:{ctx:ll}}}),Z=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0b3JjaHZpZGVvJTIwdHJhbnNmb3JtZXJzJTIwZXZhbHVhdGU=",highlighted:"pip install -q pytorchvideo transformers evaluate",wrap:!1}}),W=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),B=new Ps({props:{title:"Load UCF101 dataset",local:"load-ucf101-dataset",headingTag:"h2"}}),A=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWhmX2RhdGFzZXRfaWRlbnRpZmllciUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRnVjZjEwMS1zdWJzZXQlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMlVDRjEwMV9zdWJzZXQudGFyLmd6JTIyJTBBZmlsZV9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0RoZl9kYXRhc2V0X2lkZW50aWZpZXIlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_dataset_identifier = <span class="hljs-string">&quot;sayakpaul/ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;UCF101_subset.tar.gz&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=hf_dataset_identifier, filename=filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),V=new d({props:{code:"aW1wb3J0JTIwdGFyZmlsZSUwQSUwQXdpdGglMjB0YXJmaWxlLm9wZW4oZmlsZV9wYXRoKSUyMGFzJTIwdCUzQSUwQSUyMCUyMCUyMCUyMCUyMHQuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tarfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(file_path) <span class="hljs-keyword">as</span> t:
<span class="hljs-meta">... </span>     t.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),x=new d({props:{code:"VUNGMTAxX3N1YnNldCUyRiUwQSUyMCUyMCUyMCUyMHRyYWluJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdmFsJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdGVzdCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhbmRNYXJjaGluZyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzEubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMi5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcmNoZXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`UCF101_subset/
    train/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    val/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    <span class="hljs-built_in">test</span>/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...`,wrap:!1}}),F=new d({props:{code:"aW1wb3J0JTIwcGF0aGxpYiUwQWRhdGFzZXRfcm9vdF9wYXRoJTIwJTNEJTIwJTIyVUNGMTAxX3N1YnNldCUyMiUwQWRhdGFzZXRfcm9vdF9wYXRoJTIwJTNEJTIwcGF0aGxpYi5QYXRoKGRhdGFzZXRfcm9vdF9wYXRoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pathlib
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_root_path = <span class="hljs-string">&quot;UCF101_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_root_path = pathlib.Path(dataset_root_path)`,wrap:!1}}),Y=new d({props:{code:"dmlkZW9fY291bnRfdHJhaW4lMjAlM0QlMjBsZW4obGlzdChkYXRhc2V0X3Jvb3RfcGF0aC5nbG9iKCUyMnRyYWluJTJGKiUyRiouYXZpJTIyKSkpJTBBdmlkZW9fY291bnRfdmFsJTIwJTNEJTIwbGVuKGxpc3QoZGF0YXNldF9yb290X3BhdGguZ2xvYiglMjJ2YWwlMkYqJTJGKi5hdmklMjIpKSklMEF2aWRlb19jb3VudF90ZXN0JTIwJTNEJTIwbGVuKGxpc3QoZGF0YXNldF9yb290X3BhdGguZ2xvYiglMjJ0ZXN0JTJGKiUyRiouYXZpJTIyKSkpJTBBdmlkZW9fdG90YWwlMjAlM0QlMjB2aWRlb19jb3VudF90cmFpbiUyMCUyQiUyMHZpZGVvX2NvdW50X3ZhbCUyMCUyQiUyMHZpZGVvX2NvdW50X3Rlc3QlMEFwcmludChmJTIyVG90YWwlMjB2aWRlb3MlM0ElMjAlN0J2aWRlb190b3RhbCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>video_count_train = <span class="hljs-built_in">len</span>(<span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;train/*/*.avi&quot;</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_count_val = <span class="hljs-built_in">len</span>(<span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;val/*/*.avi&quot;</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_count_test = <span class="hljs-built_in">len</span>(<span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;test/*/*.avi&quot;</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_total = video_count_train + video_count_val + video_count_test
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total videos: <span class="hljs-subst">{video_total}</span>&quot;</span>)`,wrap:!1}}),z=new d({props:{code:"YWxsX3ZpZGVvX2ZpbGVfcGF0aHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbGlzdChkYXRhc2V0X3Jvb3RfcGF0aC5nbG9iKCUyMnRyYWluJTJGKiUyRiouYXZpJTIyKSklMEElMjAlMjAlMjAlMjAlMkIlMjBsaXN0KGRhdGFzZXRfcm9vdF9wYXRoLmdsb2IoJTIydmFsJTJGKiUyRiouYXZpJTIyKSklMEElMjAlMjAlMjAlMjAlMkIlMjBsaXN0KGRhdGFzZXRfcm9vdF9wYXRoLmdsb2IoJTIydGVzdCUyRiolMkYqLmF2aSUyMikpJTBBJTIwKSUwQWFsbF92aWRlb19maWxlX3BhdGhzJTVCJTNBNSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_video_file_paths = (
<span class="hljs-meta">... </span>    <span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;train/*/*.avi&quot;</span>))
<span class="hljs-meta">... </span>    + <span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;val/*/*.avi&quot;</span>))
<span class="hljs-meta">... </span>    + <span class="hljs-built_in">list</span>(dataset_root_path.glob(<span class="hljs-string">&quot;test/*/*.avi&quot;</span>))
<span class="hljs-meta">... </span> )
<span class="hljs-meta">&gt;&gt;&gt; </span>all_video_file_paths[:<span class="hljs-number">5</span>]`,wrap:!1}}),S=new d({props:{code:"",highlighted:`...
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c04.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c06.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g08_c01.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c02.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c06.avi&#x27;</span>
...`,wrap:!1}}),q=new d({props:{code:"Y2xhc3NfbGFiZWxzJTIwJTNEJTIwc29ydGVkKCU3QnN0cihwYXRoKS5zcGxpdCglMjIlMkYlMjIpJTVCMiU1RCUyMGZvciUyMHBhdGglMjBpbiUyMGFsbF92aWRlb19maWxlX3BhdGhzJTdEKSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxhYmVsJTIwaW4lMjBlbnVtZXJhdGUoY2xhc3NfbGFiZWxzKSU3RCUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaSUzQSUyMGxhYmVsJTIwZm9yJTIwbGFiZWwlMkMlMjBpJTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTBBJTBBcHJpbnQoZiUyMlVuaXF1ZSUyMGNsYXNzZXMlM0ElMjAlN0JsaXN0KGxhYmVsMmlkLmtleXMoKSklN0QuJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>class_labels = <span class="hljs-built_in">sorted</span>({<span class="hljs-built_in">str</span>(path).split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">2</span>] <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> all_video_file_paths})
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: i <span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(class_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {i: label <span class="hljs-keyword">for</span> label, i <span class="hljs-keyword">in</span> label2id.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Unique classes: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(label2id.keys())}</span>.&quot;</span>)

<span class="hljs-comment"># Unique classes: [&#x27;ApplyEyeMakeup&#x27;, &#x27;ApplyLipstick&#x27;, &#x27;Archery&#x27;, &#x27;BabyCrawling&#x27;, &#x27;BalanceBeam&#x27;, &#x27;BandMarching&#x27;, &#x27;BaseballPitch&#x27;, &#x27;Basketball&#x27;, &#x27;BasketballDunk&#x27;, &#x27;BenchPress&#x27;].</span>`,wrap:!1}}),D=new Ps({props:{title:"Load a model to fine-tune",local:"load-a-model-to-fine-tune",headingTag:"h2"}}),O=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWaWRlb01BRUltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0KSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9ja3B0JTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMjAlMjAlMjMlMjBwcm92aWRlJTIwdGhpcyUyMGluJTIwY2FzZSUyMHlvdSdyZSUyMHBsYW5uaW5nJTIwdG8lMjBmaW5lLXR1bmUlMjBhbiUyMGFscmVhZHklMjBmaW5lLXR1bmVkJTIwY2hlY2twb2ludCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEImageProcessor, VideoMAEForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VideoMAEImageProcessor.from_pretrained(model_ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    model_ckpt,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ls=new d({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjB3ZXJlJTIwbm90JTIwdXNlZCUyMHdoZW4lMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lM0ElMjAlNUIuLi4lMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4xLmF0dGVudGlvbi5vdXRwdXQuZGVuc2UuYmlhcyclMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4yLmF0dGVudGlvbi5hdHRlbnRpb24ua2V5LndlaWdodCclNUQlMEEtJTIwVGhpcyUyMElTJTIwZXhwZWN0ZWQlMjBpZiUyMHlvdSUyMGFyZSUyMGluaXRpYWxpemluZyUyMFZpZGVvTUFFRm9yVmlkZW9DbGFzc2lmaWNhdGlvbiUyMGZyb20lMjB0aGUlMjBjaGVja3BvaW50JTIwb2YlMjBhJTIwbW9kZWwlMjB0cmFpbmVkJTIwb24lMjBhbm90aGVyJTIwdGFzayUyMG9yJTIwd2l0aCUyMGFub3RoZXIlMjBhcmNoaXRlY3R1cmUlMjAoZS5nLiUyMGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yUHJlVHJhaW5pbmclMjBtb2RlbCkuJTBBLSUyMFRoaXMlMjBJUyUyME5PVCUyMGV4cGVjdGVkJTIwaWYlMjB5b3UlMjBhcmUlMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMjBmcm9tJTIwdGhlJTIwY2hlY2twb2ludCUyMG9mJTIwYSUyMG1vZGVsJTIwdGhhdCUyMHlvdSUyMGV4cGVjdCUyMHRvJTIwYmUlMjBleGFjdGx5JTIwaWRlbnRpY2FsJTIwKGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsKS4lMEFTb21lJTIwd2VpZ2h0cyUyMG9mJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJ2NsYXNzaWZpZXIuYmlhcyclMkMlMjAnY2xhc3NpZmllci53ZWlnaHQnJTVEJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of the model checkpoint at MCG-NJU/videomae-base were not used when initializing VideoMAEForVideoClassification: [..., <span class="hljs-string">&#x27;decoder.decoder_layers.1.attention.output.dense.bias&#x27;</span>, <span class="hljs-string">&#x27;decoder.decoder_layers.2.attention.attention.key.weight&#x27;</span>]
- This IS expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model trained on another task or with another architecture (e.g. initializing a BertForSequenceClassification model from a BertForPreTraining model).
- This IS NOT expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model that you expect to be exactly identical (initializing a BertForSequenceClassification model from a BertForSequenceClassification model).
Some weights of VideoMAEForVideoClassification were not initialized from the model checkpoint at MCG-NJU/videomae-base and are newly initialized: [<span class="hljs-string">&#x27;classifier.bias&#x27;</span>, <span class="hljs-string">&#x27;classifier.weight&#x27;</span>]
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),ts=new Ps({props:{title:"Prepare the datasets for training",local:"prepare-the-datasets-for-training",headingTag:"h2"}}),ps=new d({props:{code:"aW1wb3J0JTIwcHl0b3JjaHZpZGVvLmRhdGElMEElMEFmcm9tJTIwcHl0b3JjaHZpZGVvLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSUyQyUwQSUyMCUyMCUyMCUyME5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVNob3J0U2lkZVNjYWxlJTJDJTBBJTIwJTIwJTIwJTIwUmVtb3ZlS2V5JTJDJTBBJTIwJTIwJTIwJTIwU2hvcnRTaWRlU2NhbGUlMkMlMEElMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUlMkMlMEEpJTBBJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29tcG9zZSUyQyUwQSUyMCUyMCUyMCUyMExhbWJkYSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbUNyb3AlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJlc2l6ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pytorchvideo.data

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pytorchvideo.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    ApplyTransformToKey,
<span class="hljs-meta">... </span>    Normalize,
<span class="hljs-meta">... </span>    RandomShortSideScale,
<span class="hljs-meta">... </span>    RemoveKey,
<span class="hljs-meta">... </span>    ShortSideScale,
<span class="hljs-meta">... </span>    UniformTemporalSubsample,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    Compose,
<span class="hljs-meta">... </span>    Lambda,
<span class="hljs-meta">... </span>    RandomCrop,
<span class="hljs-meta">... </span>    RandomHorizontalFlip,
<span class="hljs-meta">... </span>    Resize,
<span class="hljs-meta">... </span>)`,wrap:!1}}),cs=new d({props:{code:"bWVhbiUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9tZWFuJTBBc3RkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLmltYWdlX3N0ZCUwQWlmJTIwJTIyc2hvcnRlc3RfZWRnZSUyMiUyMGluJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjB3aWR0aCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyc2hvcnRlc3RfZWRnZSUyMiU1RCUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUyMCUyMCUyMCUyMHdpZHRoJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJ3aWR0aCUyMiU1RCUwQXJlc2l6ZV90byUyMCUzRCUyMChoZWlnaHQlMkMlMjB3aWR0aCklMEElMEFudW1fZnJhbWVzX3RvX3NhbXBsZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5udW1fZnJhbWVzJTBBc2FtcGxlX3JhdGUlMjAlM0QlMjA0JTBBZnBzJTIwJTNEJTIwMzAlMEFjbGlwX2R1cmF0aW9uJTIwJTNEJTIwbnVtX2ZyYW1lc190b19zYW1wbGUlMjAqJTIwc2FtcGxlX3JhdGUlMjAlMkYlMjBmcHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>mean = image_processor.image_mean
<span class="hljs-meta">&gt;&gt;&gt; </span>std = image_processor.image_std
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-string">&quot;shortest_edge&quot;</span> <span class="hljs-keyword">in</span> image_processor.size:
<span class="hljs-meta">... </span>    height = width = image_processor.size[<span class="hljs-string">&quot;shortest_edge&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">... </span>    width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>resize_to = (height, width)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames_to_sample = model.config.num_frames
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_rate = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fps = <span class="hljs-number">30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>clip_duration = num_frames_to_sample * sample_rate / fps`,wrap:!1}}),hs=new d({props:{code:"dHJhaW5fdHJhbnNmb3JtJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcHBseVRyYW5zZm9ybVRvS2V5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtleSUzRCUyMnZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUobnVtX2ZyYW1lc190b19zYW1wbGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGFtYmRhKGxhbWJkYSUyMHglM0ElMjB4JTIwJTJGJTIwMjU1LjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTm9ybWFsaXplKG1lYW4lMkMlMjBzdGQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tU2hvcnRTaWRlU2NhbGUobWluX3NpemUlM0QyNTYlMkMlMjBtYXhfc2l6ZSUzRDMyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Dcm9wKHJlc2l6ZV90byklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydHJhaW4lMjIpJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGVyJTNEcHl0b3JjaHZpZGVvLmRhdGEubWFrZV9jbGlwX3NhbXBsZXIoJTIycmFuZG9tJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHRyYWluX3RyYW5zZm9ybSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    RandomShortSideScale(min_size=<span class="hljs-number">256</span>, max_size=<span class="hljs-number">320</span>),
<span class="hljs-meta">... </span>                    RandomCrop(resize_to),
<span class="hljs-meta">... </span>                    RandomHorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;train&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;random&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=train_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ds=new d({props:{code:"dmFsX3RyYW5zZm9ybSUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXklM0QlMjJ2aWRlbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5pZm9ybVRlbXBvcmFsU3Vic2FtcGxlKG51bV9mcmFtZXNfdG9fc2FtcGxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExhbWJkYShsYW1iZGElMjB4JTNBJTIweCUyMCUyRiUyMDI1NS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME5vcm1hbGl6ZShtZWFuJTJDJTIwc3RkKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShyZXNpemVfdG8pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydmFsJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlciUzRHB5dG9yY2h2aWRlby5kYXRhLm1ha2VfY2xpcF9zYW1wbGVyKCUyMnVuaWZvcm0lMjIlMkMlMjBjbGlwX2R1cmF0aW9uKSUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9hdWRpbyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEdmFsX3RyYW5zZm9ybSUyQyUwQSklMEElMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydGVzdCUyMiklMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZXIlM0RweXRvcmNodmlkZW8uZGF0YS5tYWtlX2NsaXBfc2FtcGxlciglMjJ1bmlmb3JtJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHZhbF90cmFuc2Zvcm0lMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>val_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    Resize(resize_to),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;val&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;test&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),js=new d({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldC5udW1fdmlkZW9zJTJDJTIwdmFsX2RhdGFzZXQubnVtX3ZpZGVvcyUyQyUyMHRlc3RfZGF0YXNldC5udW1fdmlkZW9zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset.num_videos, val_dataset.num_videos, test_dataset.num_videos)
<span class="hljs-comment"># (300, 30, 75)</span>`,wrap:!1}}),Ts=new Ps({props:{title:"Visualize the preprocessed video for better debugging",local:"visualize-the-preprocessed-video-for-better-debugging",headingTag:"h2"}}),Us=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> imageio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">unnormalize_img</span>(<span class="hljs-params">img</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Un-normalizes the image pixels.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    img = (img * std) + mean
<span class="hljs-meta">... </span>    img = (img * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img.clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_gif</span>(<span class="hljs-params">video_tensor, filename=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares a GIF from a video tensor.
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    The video tensor is expected to have the following shape:
<span class="hljs-meta">... </span>    (num_frames, num_channels, height, width).
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> video_frame <span class="hljs-keyword">in</span> video_tensor:
<span class="hljs-meta">... </span>        frame_unnormalized = unnormalize_img(video_frame.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).numpy())
<span class="hljs-meta">... </span>        frames.append(frame_unnormalized)
<span class="hljs-meta">... </span>    kargs = {<span class="hljs-string">&quot;duration&quot;</span>: <span class="hljs-number">0.25</span>}
<span class="hljs-meta">... </span>    imageio.mimsave(filename, frames, <span class="hljs-string">&quot;GIF&quot;</span>, **kargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> filename

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_gif</span>(<span class="hljs-params">video_tensor, gif_name=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares and displays a GIF from a video tensor.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    video_tensor = video_tensor.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    gif_filename = create_gif(video_tensor, gif_name)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> Image(filename=gif_filename)

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataset))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_tensor = sample_video[<span class="hljs-string">&quot;video&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>display_gif(video_tensor)`,wrap:!1}}),us=new Ps({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),gs=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBtb2RlbF9ja3B0LnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQW5ld19tb2RlbF9uYW1lJTIwJTNEJTIwZiUyMiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLXVjZjEwMS1zdWJzZXQlMjIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNCUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBuZXdfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3JhdGlvJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRCh0cmFpbl9kYXRhc2V0Lm51bV92aWRlb3MlMjAlMkYlMkYlMjBiYXRjaF9zaXplKSUyMColMjBudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = model_ckpt.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>new_model_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">4</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    new_model_name,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=batch_size,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=batch_size,
<span class="hljs-meta">... </span>    warmup_ratio=<span class="hljs-number">0.1</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_steps=(train_dataset.num_videos // batch_size) * num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),vs=new d({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgoZXZhbF9wcmVkLnByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RldmFsX3ByZWQubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),Ws=new d({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJtdXRlJTIwdG8lMjAobnVtX2ZyYW1lcyUyQyUyMG51bV9jaGFubmVscyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmV4YW1wbGUlNUIlMjJ2aWRlbyUyMiU1RC5wZXJtdXRlKDElMkMlMjAwJTJDJTIwMiUyQyUyMDMpJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmV4YW1wbGUlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBpeGVsX3ZhbHVlcyUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMGxhYmVscyU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># permute to (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    pixel_values = torch.stack(
<span class="hljs-meta">... </span>        [example[<span class="hljs-string">&quot;video&quot;</span>].permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),ks=new d({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=val_dataset,
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Vs=new d({props:{code:"dHJhaW5fcmVzdWx0cyUyMCUzRCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_results = trainer.train()',wrap:!1}}),xs=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),$s=new Ps({props:{title:"Inference",local:"inference",headingTag:"h2"}}),zs=new d({props:{code:"c2FtcGxlX3Rlc3RfdmlkZW8lMjAlM0QlMjBuZXh0KGl0ZXIodGVzdF9kYXRhc2V0KSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample_test_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(test_dataset))',wrap:!1}}),Ss=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlkZW9fY2xzJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJteV9hd2Vzb21lX3ZpZGVvX2Nsc19tb2RlbCUyMiklMEF2aWRlb19jbHMoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGdWNmMTAxLXN1YnNldCUyRnJlc29sdmUlMkZtYWluJTJGdl9CYXNrZXRiYWxsRHVua19nMTRfYzA2LmF2aSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls = pipeline(model=<span class="hljs-string">&quot;my_awesome_video_cls_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/ucf101-subset/resolve/main/v_BasketballDunk_g14_c06.avi&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9272987842559814</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BasketballDunk&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.017777055501937866</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BabyCrawling&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.01663011871278286</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BalanceBeam&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.009560945443809032</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BandMarching&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0068979403004050255</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BaseballPitch&#x27;</span>}]`,wrap:!1}}),Qs=new d({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShtb2RlbCUyQyUyMHZpZGVvKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMChudW1fZnJhbWVzJTJDJTIwbnVtX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBJTIwJTIwJTIwJTIwcGVydW11dGVkX3NhbXBsZV90ZXN0X3ZpZGVvJTIwJTNEJTIwdmlkZW8ucGVybXV0ZSgxJTJDJTIwMCUyQyUyMDIlMkMlMjAzKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBlcnVtdXRlZF9zYW1wbGVfdGVzdF92aWRlby51bnNxdWVlemUoMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjB0b3JjaC50ZW5zb3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjB0aGlzJTIwY2FuJTIwYmUlMjBza2lwcGVkJTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBsYWJlbHMlMjBhdmFpbGFibGUuJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG1vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">model, video</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    perumuted_sample_test_video = video.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    inputs = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pixel_values&quot;</span>: perumuted_sample_test_video.unsqueeze(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;labels&quot;</span>: torch.tensor(
<span class="hljs-meta">... </span>            [sample_test_video[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>        ),  <span class="hljs-comment"># this can be skipped if you don&#x27;t have labels available.</span>
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">... </span>    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>    model = model.to(device)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**inputs)
<span class="hljs-meta">... </span>        logits = outputs.logits

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> logits`,wrap:!1}}),Ls=new d({props:{code:"bG9naXRzJTIwJTNEJTIwcnVuX2luZmVyZW5jZSh0cmFpbmVkX21vZGVsJTJDJTIwc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJ2aWRlbyUyMiU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>logits = run_inference(trained_model, sample_test_video[<span class="hljs-string">&quot;video&quot;</span>])',wrap:!1}}),Ks=new d({props:{code:"cHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-comment"># Predicted class: BasketballDunk</span>`,wrap:!1}}),Ds=new ze({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/video_classification.md"}}),{c(){w=p("meta"),u=t(),J=p("p"),Os=t(),M(b.$$.fragment),al=t(),M(f.$$.fragment),el=t(),g=p("p"),g.textContent=Xa,tl=t(),I=p("p"),I.textContent=xa,nl=t(),C=p("ol"),C.innerHTML=$a,pl=t(),M(j.$$.fragment),il=t(),v=p("p"),v.textContent=Fa,ol=t(),M(Z.$$.fragment),Ml=t(),G=p("p"),G.innerHTML=Ya,ml=t(),_=p("p"),_.textContent=za,cl=t(),M(W.$$.fragment),yl=t(),M(B.$$.fragment),hl=t(),k=p("p"),k.innerHTML=Ea,rl=t(),M(A.$$.fragment),dl=t(),R=p("p"),R.textContent=Sa,wl=t(),M(V.$$.fragment),Jl=t(),X=p("p"),X.textContent=Na,jl=t(),M(x.$$.fragment),Tl=t(),$=p("p"),$.textContent=Qa,Ul=t(),M(F.$$.fragment),ul=t(),M(Y.$$.fragment),bl=t(),M(z.$$.fragment),fl=t(),E=p("p"),E.innerHTML=Ha,gl=t(),M(S.$$.fragment),Il=t(),N=p("p"),N.innerHTML=La,Cl=t(),Q=p("p"),Q.innerHTML=qa,vl=t(),H=p("p"),H.textContent=Ka,Zl=t(),L=p("ul"),L.innerHTML=Da,Gl=t(),M(q.$$.fragment),_l=t(),K=p("p"),K.textContent=Pa,Wl=t(),M(D.$$.fragment),Bl=t(),P=p("p"),P.textContent=Oa,kl=t(),M(O.$$.fragment),Al=t(),ss=p("p"),ss.textContent=se,Rl=t(),M(ls.$$.fragment),Vl=t(),as=p("p"),as.innerHTML=le,Xl=t(),es=p("p"),es.innerHTML=ae,xl=t(),M(ts.$$.fragment),$l=t(),ns=p("p"),ns.innerHTML=ee,Fl=t(),M(ps.$$.fragment),Yl=t(),is=p("p"),is.innerHTML=te,zl=t(),os=p("p"),os.innerHTML=ne,El=t(),Ms=p("ul"),Ms.innerHTML=pe,Sl=t(),ms=p("p"),ms.textContent=ie,Nl=t(),M(cs.$$.fragment),Ql=t(),ys=p("p"),ys.textContent=oe,Hl=t(),M(hs.$$.fragment),Ll=t(),rs=p("p"),rs.textContent=Me,ql=t(),M(ds.$$.fragment),Kl=t(),ws=p("p"),ws.innerHTML=me,Dl=t(),Js=p("p"),Js.innerHTML=ce,Pl=t(),M(js.$$.fragment),Ol=t(),M(Ts.$$.fragment),sa=t(),M(Us.$$.fragment),la=t(),T=p("div"),T.innerHTML=ye,aa=t(),M(us.$$.fragment),ea=t(),bs=p("p"),bs.innerHTML=he,ta=t(),fs=p("p"),fs.innerHTML=re,na=t(),M(gs.$$.fragment),pa=t(),Is=p("p"),Is.innerHTML=de,ia=t(),Cs=p("p"),Cs.innerHTML=we,oa=t(),M(vs.$$.fragment),Ma=t(),Zs=p("p"),Zs.innerHTML=Je,ma=t(),Gs=p("p"),Gs.innerHTML=je,ca=t(),_s=p("p"),_s.innerHTML=Te,ya=t(),M(Ws.$$.fragment),ha=t(),Bs=p("p"),Bs.innerHTML=Ue,ra=t(),M(ks.$$.fragment),da=t(),As=p("p"),As.innerHTML=ue,wa=t(),Rs=p("p"),Rs.innerHTML=be,Ja=t(),M(Vs.$$.fragment),ja=t(),Xs=p("p"),Xs.innerHTML=fe,Ta=t(),M(xs.$$.fragment),Ua=t(),M($s.$$.fragment),ua=t(),Fs=p("p"),Fs.textContent=ge,ba=t(),Ys=p("p"),Ys.textContent=Ie,fa=t(),M(zs.$$.fragment),ga=t(),U=p("div"),U.innerHTML=Ce,Ia=t(),Es=p("p"),Es.innerHTML=ve,Ca=t(),M(Ss.$$.fragment),va=t(),Ns=p("p"),Ns.innerHTML=Ze,Za=t(),M(Qs.$$.fragment),Ga=t(),Hs=p("p"),Hs.innerHTML=Ge,_a=t(),M(Ls.$$.fragment),Wa=t(),qs=p("p"),qs.innerHTML=_e,Ba=t(),M(Ks.$$.fragment),ka=t(),M(Ds.$$.fragment),Aa=t(),sl=p("p"),this.h()},l(s){const l=xe("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(a),u=n(s),J=i(s,"P",{}),Be(J).forEach(a),Os=n(s),m(b.$$.fragment,s),al=n(s),m(f.$$.fragment,s),el=n(s),g=i(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1uw5n59"&&(g.textContent=Xa),tl=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1aff4p7"&&(I.textContent=xa),nl=n(s),C=i(s,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-1qfvs25"&&(C.innerHTML=$a),pl=n(s),m(j.$$.fragment,s),il=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1c9nexd"&&(v.textContent=Fa),ol=n(s),m(Z.$$.fragment,s),Ml=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-cnicg0"&&(G.innerHTML=Ya),ml=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-27hn0u"&&(_.textContent=za),cl=n(s),m(W.$$.fragment,s),yl=n(s),m(B.$$.fragment,s),hl=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-zo4tpc"&&(k.innerHTML=Ea),rl=n(s),m(A.$$.fragment,s),dl=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-yyrc6l"&&(R.textContent=Sa),wl=n(s),m(V.$$.fragment,s),Jl=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-vxwx6z"&&(X.textContent=Na),jl=n(s),m(x.$$.fragment,s),Tl=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1q9jgqq"&&($.textContent=Qa),Ul=n(s),m(F.$$.fragment,s),ul=n(s),m(Y.$$.fragment,s),bl=n(s),m(z.$$.fragment,s),fl=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-xl39ap"&&(E.innerHTML=Ha),gl=n(s),m(S.$$.fragment,s),Il=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1t7u230"&&(N.innerHTML=La),Cl=n(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-igo46q"&&(Q.innerHTML=qa),vl=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-4ll1ff"&&(H.textContent=Ka),Zl=n(s),L=i(s,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1y0n38a"&&(L.innerHTML=Da),Gl=n(s),m(q.$$.fragment,s),_l=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1z0r2k5"&&(K.textContent=Pa),Wl=n(s),m(D.$$.fragment,s),Bl=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-14088fx"&&(P.textContent=Oa),kl=n(s),m(O.$$.fragment,s),Al=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1rauzal"&&(ss.textContent=se),Rl=n(s),m(ls.$$.fragment,s),Vl=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-19dkvgp"&&(as.innerHTML=le),Xl=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-nk737h"&&(es.innerHTML=ae),xl=n(s),m(ts.$$.fragment,s),$l=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-islfqt"&&(ns.innerHTML=ee),Fl=n(s),m(ps.$$.fragment,s),Yl=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-5m4gle"&&(is.innerHTML=te),zl=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-8w7a7w"&&(os.innerHTML=ne),El=n(s),Ms=i(s,"UL",{"data-svelte-h":!0}),o(Ms)!=="svelte-u2neln"&&(Ms.innerHTML=pe),Sl=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-llv4fi"&&(ms.textContent=ie),Nl=n(s),m(cs.$$.fragment,s),Ql=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-1lr33l4"&&(ys.textContent=oe),Hl=n(s),m(hs.$$.fragment,s),Ll=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-92qkhv"&&(rs.textContent=Me),ql=n(s),m(ds.$$.fragment,s),Kl=n(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-lyltai"&&(ws.innerHTML=me),Dl=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1vli4t8"&&(Js.innerHTML=ce),Pl=n(s),m(js.$$.fragment,s),Ol=n(s),m(Ts.$$.fragment,s),sa=n(s),m(Us.$$.fragment,s),la=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1mxsghh"&&(T.innerHTML=ye),aa=n(s),m(us.$$.fragment,s),ea=n(s),bs=i(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-rirkpj"&&(bs.innerHTML=he),ta=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-ixq0kp"&&(fs.innerHTML=re),na=n(s),m(gs.$$.fragment,s),pa=n(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-1v50sum"&&(Is.innerHTML=de),ia=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1kbaooa"&&(Cs.innerHTML=we),oa=n(s),m(vs.$$.fragment,s),Ma=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1yc7v5f"&&(Zs.innerHTML=Je),ma=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-9bk5j6"&&(Gs.innerHTML=je),ca=n(s),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1csqroh"&&(_s.innerHTML=Te),ya=n(s),m(Ws.$$.fragment,s),ha=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-16wl6hd"&&(Bs.innerHTML=Ue),ra=n(s),m(ks.$$.fragment,s),da=n(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-g6wg27"&&(As.innerHTML=ue),wa=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-umxz0w"&&(Rs.innerHTML=be),Ja=n(s),m(Vs.$$.fragment,s),ja=n(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-10rgjtz"&&(Xs.innerHTML=fe),Ta=n(s),m(xs.$$.fragment,s),Ua=n(s),m($s.$$.fragment,s),ua=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-riodtu"&&(Fs.textContent=ge),ba=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-w1spga"&&(Ys.textContent=Ie),fa=n(s),m(zs.$$.fragment,s),ga=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-556htt"&&(U.innerHTML=Ce),Ia=n(s),Es=i(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-e8z0ag"&&(Es.innerHTML=ve),Ca=n(s),m(Ss.$$.fragment,s),va=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1j33lbi"&&(Ns.innerHTML=Ze),Za=n(s),m(Qs.$$.fragment,s),Ga=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-12olihs"&&(Hs.innerHTML=Ge),_a=n(s),m(Ls.$$.fragment,s),Wa=n(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1v8qszj"&&(qs.innerHTML=_e),Ba=n(s),m(Ks.$$.fragment,s),ka=n(s),m(Ds.$$.fragment,s),Aa=n(s),sl=i(s,"P",{}),Be(sl).forEach(a),this.h()},h(){Va(w,"name","hf:doc:metadata"),Va(w,"content",Ne),Va(T,"class","flex justify-center"),Va(U,"class","flex justify-center")},m(s,l){$e(document.head,w),e(s,u,l),e(s,J,l),e(s,Os,l),c(b,s,l),e(s,al,l),c(f,s,l),e(s,el,l),e(s,g,l),e(s,tl,l),e(s,I,l),e(s,nl,l),e(s,C,l),e(s,pl,l),c(j,s,l),e(s,il,l),e(s,v,l),e(s,ol,l),c(Z,s,l),e(s,Ml,l),e(s,G,l),e(s,ml,l),e(s,_,l),e(s,cl,l),c(W,s,l),e(s,yl,l),c(B,s,l),e(s,hl,l),e(s,k,l),e(s,rl,l),c(A,s,l),e(s,dl,l),e(s,R,l),e(s,wl,l),c(V,s,l),e(s,Jl,l),e(s,X,l),e(s,jl,l),c(x,s,l),e(s,Tl,l),e(s,$,l),e(s,Ul,l),c(F,s,l),e(s,ul,l),c(Y,s,l),e(s,bl,l),c(z,s,l),e(s,fl,l),e(s,E,l),e(s,gl,l),c(S,s,l),e(s,Il,l),e(s,N,l),e(s,Cl,l),e(s,Q,l),e(s,vl,l),e(s,H,l),e(s,Zl,l),e(s,L,l),e(s,Gl,l),c(q,s,l),e(s,_l,l),e(s,K,l),e(s,Wl,l),c(D,s,l),e(s,Bl,l),e(s,P,l),e(s,kl,l),c(O,s,l),e(s,Al,l),e(s,ss,l),e(s,Rl,l),c(ls,s,l),e(s,Vl,l),e(s,as,l),e(s,Xl,l),e(s,es,l),e(s,xl,l),c(ts,s,l),e(s,$l,l),e(s,ns,l),e(s,Fl,l),c(ps,s,l),e(s,Yl,l),e(s,is,l),e(s,zl,l),e(s,os,l),e(s,El,l),e(s,Ms,l),e(s,Sl,l),e(s,ms,l),e(s,Nl,l),c(cs,s,l),e(s,Ql,l),e(s,ys,l),e(s,Hl,l),c(hs,s,l),e(s,Ll,l),e(s,rs,l),e(s,ql,l),c(ds,s,l),e(s,Kl,l),e(s,ws,l),e(s,Dl,l),e(s,Js,l),e(s,Pl,l),c(js,s,l),e(s,Ol,l),c(Ts,s,l),e(s,sa,l),c(Us,s,l),e(s,la,l),e(s,T,l),e(s,aa,l),c(us,s,l),e(s,ea,l),e(s,bs,l),e(s,ta,l),e(s,fs,l),e(s,na,l),c(gs,s,l),e(s,pa,l),e(s,Is,l),e(s,ia,l),e(s,Cs,l),e(s,oa,l),c(vs,s,l),e(s,Ma,l),e(s,Zs,l),e(s,ma,l),e(s,Gs,l),e(s,ca,l),e(s,_s,l),e(s,ya,l),c(Ws,s,l),e(s,ha,l),e(s,Bs,l),e(s,ra,l),c(ks,s,l),e(s,da,l),e(s,As,l),e(s,wa,l),e(s,Rs,l),e(s,Ja,l),c(Vs,s,l),e(s,ja,l),e(s,Xs,l),e(s,Ta,l),c(xs,s,l),e(s,Ua,l),c($s,s,l),e(s,ua,l),e(s,Fs,l),e(s,ba,l),e(s,Ys,l),e(s,fa,l),c(zs,s,l),e(s,ga,l),e(s,U,l),e(s,Ia,l),e(s,Es,l),e(s,Ca,l),c(Ss,s,l),e(s,va,l),e(s,Ns,l),e(s,Za,l),c(Qs,s,l),e(s,Ga,l),e(s,Hs,l),e(s,_a,l),c(Ls,s,l),e(s,Wa,l),e(s,qs,l),e(s,Ba,l),c(Ks,s,l),e(s,ka,l),c(Ds,s,l),e(s,Aa,l),e(s,sl,l),Ra=!0},p(s,[l]){const We={};l&2&&(We.$$scope={dirty:l,ctx:s}),j.$set(We)},i(s){Ra||(y(b.$$.fragment,s),y(f.$$.fragment,s),y(j.$$.fragment,s),y(Z.$$.fragment,s),y(W.$$.fragment,s),y(B.$$.fragment,s),y(A.$$.fragment,s),y(V.$$.fragment,s),y(x.$$.fragment,s),y(F.$$.fragment,s),y(Y.$$.fragment,s),y(z.$$.fragment,s),y(S.$$.fragment,s),y(q.$$.fragment,s),y(D.$$.fragment,s),y(O.$$.fragment,s),y(ls.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(cs.$$.fragment,s),y(hs.$$.fragment,s),y(ds.$$.fragment,s),y(js.$$.fragment,s),y(Ts.$$.fragment,s),y(Us.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(vs.$$.fragment,s),y(Ws.$$.fragment,s),y(ks.$$.fragment,s),y(Vs.$$.fragment,s),y(xs.$$.fragment,s),y($s.$$.fragment,s),y(zs.$$.fragment,s),y(Ss.$$.fragment,s),y(Qs.$$.fragment,s),y(Ls.$$.fragment,s),y(Ks.$$.fragment,s),y(Ds.$$.fragment,s),Ra=!0)},o(s){h(b.$$.fragment,s),h(f.$$.fragment,s),h(j.$$.fragment,s),h(Z.$$.fragment,s),h(W.$$.fragment,s),h(B.$$.fragment,s),h(A.$$.fragment,s),h(V.$$.fragment,s),h(x.$$.fragment,s),h(F.$$.fragment,s),h(Y.$$.fragment,s),h(z.$$.fragment,s),h(S.$$.fragment,s),h(q.$$.fragment,s),h(D.$$.fragment,s),h(O.$$.fragment,s),h(ls.$$.fragment,s),h(ts.$$.fragment,s),h(ps.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(ds.$$.fragment,s),h(js.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h(us.$$.fragment,s),h(gs.$$.fragment,s),h(vs.$$.fragment,s),h(Ws.$$.fragment,s),h(ks.$$.fragment,s),h(Vs.$$.fragment,s),h(xs.$$.fragment,s),h($s.$$.fragment,s),h(zs.$$.fragment,s),h(Ss.$$.fragment,s),h(Qs.$$.fragment,s),h(Ls.$$.fragment,s),h(Ks.$$.fragment,s),h(Ds.$$.fragment,s),Ra=!1},d(s){s&&(a(u),a(J),a(Os),a(al),a(el),a(g),a(tl),a(I),a(nl),a(C),a(pl),a(il),a(v),a(ol),a(Ml),a(G),a(ml),a(_),a(cl),a(yl),a(hl),a(k),a(rl),a(dl),a(R),a(wl),a(Jl),a(X),a(jl),a(Tl),a($),a(Ul),a(ul),a(bl),a(fl),a(E),a(gl),a(Il),a(N),a(Cl),a(Q),a(vl),a(H),a(Zl),a(L),a(Gl),a(_l),a(K),a(Wl),a(Bl),a(P),a(kl),a(Al),a(ss),a(Rl),a(Vl),a(as),a(Xl),a(es),a(xl),a($l),a(ns),a(Fl),a(Yl),a(is),a(zl),a(os),a(El),a(Ms),a(Sl),a(ms),a(Nl),a(Ql),a(ys),a(Hl),a(Ll),a(rs),a(ql),a(Kl),a(ws),a(Dl),a(Js),a(Pl),a(Ol),a(sa),a(la),a(T),a(aa),a(ea),a(bs),a(ta),a(fs),a(na),a(pa),a(Is),a(ia),a(Cs),a(oa),a(Ma),a(Zs),a(ma),a(Gs),a(ca),a(_s),a(ya),a(ha),a(Bs),a(ra),a(da),a(As),a(wa),a(Rs),a(Ja),a(ja),a(Xs),a(Ta),a(Ua),a(ua),a(Fs),a(ba),a(Ys),a(fa),a(ga),a(U),a(Ia),a(Es),a(Ca),a(va),a(Ns),a(Za),a(Ga),a(Hs),a(_a),a(Wa),a(qs),a(Ba),a(ka),a(Aa),a(sl)),a(w),r(b,s),r(f,s),r(j,s),r(Z,s),r(W,s),r(B,s),r(A,s),r(V,s),r(x,s),r(F,s),r(Y,s),r(z,s),r(S,s),r(q,s),r(D,s),r(O,s),r(ls,s),r(ts,s),r(ps,s),r(cs,s),r(hs,s),r(ds,s),r(js,s),r(Ts,s),r(Us,s),r(us,s),r(gs,s),r(vs,s),r(Ws,s),r(ks,s),r(Vs,s),r(xs,s),r($s,s),r(zs,s),r(Ss,s),r(Qs,s),r(Ls,s),r(Ks,s),r(Ds,s)}}}const Ne='{"title":"Video classification","local":"video-classification","sections":[{"title":"Load UCF101 dataset","local":"load-ucf101-dataset","sections":[],"depth":2},{"title":"Load a model to fine-tune","local":"load-a-model-to-fine-tune","sections":[],"depth":2},{"title":"Prepare the datasets for training","local":"prepare-the-datasets-for-training","sections":[],"depth":2},{"title":"Visualize the preprocessed video for better debugging","local":"visualize-the-preprocessed-video-for-better-debugging","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Qe(ll){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ve{constructor(w){super(),Xe(this,w,Qe,Se,ke,{})}}export{Oe as component};
