import{s as cs,o as rs,n as ps}from"../chunks/scheduler.c57aa7ef.js";import{S as us,i as hs,g as o,s as l,r,A as ds,h as i,f as s,c as n,j as os,u,x as p,k as Ut,y as ms,a,v as h,d,t as m,w as y}from"../chunks/index.c50cb18e.js";import{T as is}from"../chunks/Tip.9268b0ca.js";import{C as je}from"../chunks/CodeBlock.34f0a53d.js";import{H as b,E as ys}from"../chunks/EditOnGithub.958a8a49.js";function Ms(Je){let c,T="This last point is not true for prefix tuning techniques like prompt tuning. There, the extra embeddings are directly stored in the <code>state_dict</code> without any prefixes added to the keys.";return{c(){c=o("p"),c.innerHTML=T},l(M){c=i(M,"P",{"data-svelte-h":!0}),p(c)!=="svelte-745gf7"&&(c.innerHTML=T)},m(M,f){a(M,c,f)},p:ps,d(M){M&&s(c)}}}function Ts(Je){let c,T="If you call <code>save_pretrained(&quot;some/path&quot;)</code> and the adapter name is not <code>&quot;default&quot;</code>, the adapter is stored in a sub-directory with the same name as the adapter. So if the name is “other”, it would be stored inside of <code>some/path/other</code>.";return{c(){c=o("p"),c.innerHTML=T},l(M){c=i(M,"P",{"data-svelte-h":!0}),p(c)!=="svelte-53ohw7"&&(c.innerHTML=T)},m(M,f){a(M,c,f)},p:ps,d(M){M&&s(c)}}}function fs(Je){let c,T,M,f,_,Ue,I,bt="This document describes how PEFT’s checkpoint files are structured and how to convert between the PEFT format and other formats.",be,C,_e,g,_t="PEFT (parameter-efficient fine-tuning) methods only update a small subset of a model’s parameters rather than all of them. This is nice because checkpoint files can generally be much smaller than the original model files and are easier to store and share. However, this also means that to load a PEFT model, you need to have the original model available as well.",Ie,v,It='When you call <a href="/docs/peft/pr_1915/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a> on a PEFT model, the PEFT model saves three files, described below:',Ce,q,Ct="<li><code>adapter_model.safetensors</code> or <code>adapter_model.bin</code></li>",ge,B,gt='By default, the model is saved in the <code>safetensors</code> format, a secure alternative to the <code>bin</code> format, which is known to be susceptible to <a href="https://huggingface.co/docs/hub/security-pickle" rel="nofollow">security vulnerabilities</a> because it uses the pickle utility under the hood. Both formats store the same <code>state_dict</code> though, and are interchangeable.',ve,$,vt="The <code>state_dict</code> only contains the parameters of the adapter module, not the base model. To illustrate the difference in size, a normal BERT model requires ~420MB of disk space, whereas an IA³ adapter on top of this BERT model only requires ~260KB.",qe,j,qt="<li><code>adapter_config.json</code></li>",Be,E,Bt="The <code>adapter_config.json</code> file contains the configuration of the adapter module, which is necessary to load the model. Below is an example of an <code>adapter_config.json</code> for an IA³ adapter with standard settings applied to a BERT model:",$e,k,Ee,A,$t="The configuration file contains:",ke,Z,Et="<li>the adapter module type stored, <code>&quot;peft_type&quot;: &quot;IA3&quot;</code></li> <li>information about the base model like <code>&quot;base_model_name_or_path&quot;: &quot;bert-base-uncased&quot;</code></li> <li>the revision of the model (if any), <code>&quot;revision&quot;: null</code></li>",Ae,x,kt="If the base model is not a pretrained Transformers model, the latter two entries will be <code>null</code>. Other than that, the settings are all related to the specific IA³ adapter that was used to fine-tune the model.",Ze,J,At="<li><code>README.md</code></li>",xe,V,Zt="The generated <code>README.md</code> is the model card of a PEFT model and contains a few pre-filled entries. The intent of this is to make it easier to share the model with others and to provide some basic information about the model. This file is not needed to load the model.",Ve,F,Fe,L,xt="When converting from another format to the PEFT format, we require both the <code>adapter_model.safetensors</code> (or <code>adapter_model.bin</code>) file and the <code>adapter_config.json</code> file.",Le,Q,Qe,H,Vt="For the model weights, it is important to use the correct mapping from parameter name to value for PEFT to load the file. Getting this mapping right is an exercise in checking the implementation details, as there is no generally agreed upon format for PEFT adapters.",He,R,Ft='Fortunately, figuring out this mapping is not overly complicated for common base cases. Let’s look at a concrete example, the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow"><code>LoraLayer</code></a>:',Re,X,Xe,W,Lt="In the <code>__init__</code> code used by all <code>LoraLayer</code> classes in PEFT, there are a bunch of parameters used to initialize the model, but only a few are relevant for the checkpoint file: <code>lora_A</code>, <code>lora_B</code>, <code>lora_embedding_A</code>, and <code>lora_embedding_B</code>. These parameters are listed in the class attribute <code>adapter_layer_names</code> and contain the learnable parameters, so they must be included in the checkpoint file. All the other parameters, like the rank <code>r</code>, are derived from the <code>adapter_config.json</code> and must be included there (unless the default value is used).",We,G,Qt="Let’s check the <code>state_dict</code> of a PEFT LoRA model applied to BERT. When printing the first five keys using the default LoRA settings (the remaining keys are the same, just with different layer numbers), we get:",Ge,P,Ht="<li><code>base_model.model.encoder.layer.0.attention.self.query.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.query.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.1.attention.self.query.lora_A.weight</code></li> <li>etc.</li>",Pe,Y,Rt="Let’s break this down:",Ye,N,Xt="<li>By default, for BERT models, LoRA is applied to the <code>query</code> and <code>value</code> layers of the attention module. This is why you see <code>attention.self.query</code> and <code>attention.self.value</code> in the key names for each layer.</li> <li>LoRA decomposes the weights into two low-rank matrices, <code>lora_A</code> and <code>lora_B</code>. This is where <code>lora_A</code> and <code>lora_B</code> come from in the key names.</li> <li>These LoRA matrices are implemented as <code>nn.Linear</code> layers, so the parameters are stored in the <code>.weight</code> attribute (<code>lora_A.weight</code>, <code>lora_B.weight</code>).</li> <li>By default, LoRA isn’t applied to BERT’s embedding layer, so there are <em>no entries</em> for <code>lora_A_embedding</code> and <code>lora_B_embedding</code>.</li> <li>The keys of the <code>state_dict</code> always start with <code>&quot;base_model.model.&quot;</code>. The reason is that, in PEFT, we wrap the base model inside a tuner-specific model (<code>LoraModel</code> in this case), which itself is wrapped in a general PEFT model (<code>PeftModel</code>). For this reason, these two prefixes are added to the keys. When converting to the PEFT format, it is required to add these prefixes.</li>",Ne,w,Se,S,Wt="When inspecting the parameter names in the loaded model, you might be surprised to find that they look a bit different, e.g. <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.default.weight</code>. The difference is the <em><code>.default</code></em> part in the second to last segment. This part exists because PEFT generally allows the addition of multiple adapters at once (using an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code> to store them). For example, if you add another adapter called “other”, the key for that adapter would be <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.other.weight</code>.",ze,z,Gt='When you call <a href="/docs/peft/pr_1915/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a>, the adapter name is stripped from the keys. The reason is that the adapter name is not an important part of the model architecture; it is just an arbitrary name. When loading the adapter, you could choose a totally different name, and the model would still work the same way. This is why the adapter name is not stored in the checkpoint file.',De,U,Oe,D,Pt="In some circumstances, deciding which values to add to the checkpoint file can become a bit more complicated. For example, in PEFT, DoRA is implemented as a special case of LoRA. If you want to convert a DoRA model to PEFT, you should create a LoRA checkpoint with extra entries for DoRA. You can see this in the <code>__init__</code> of the previous <code>LoraLayer</code> code:",Ke,O,et,K,Yt="This indicates that there is an optional extra parameter per layer for DoRA.",tt,ee,st,te,Nt="All the other information needed to load a PEFT model is contained in the <code>adapter_config.json</code> file. Let’s check this file for a LoRA model applied to BERT:",at,se,lt,ae,St="This contains a lot of entries, and at first glance, it could feel overwhelming to figure out all the right values to put in there. However, most of the entries are not necessary to load the model. This is either because they use the default values and don’t need to be added or because they only affect the initialization of the LoRA weights, which is irrelevant when it comes to loading the model. If you find that you don’t know what a specific parameter does, e.g., <code>&quot;use_rslora&quot;,</code> don’t add it, and you should be fine. Also note that as more options are added, this file will get more entries in the future, but it should be backward compatible.",nt,le,zt="At the minimum, you should include the following entries:",ot,ne,it,oe,Dt='However, adding as many entries as possible, like the rank <code>r</code> or the <code>base_model_name_or_path</code> (if it’s a Transformers model) is recommended. This information can help others understand the model better and share it more easily. To check which keys and values are expected, check out the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/config.py" rel="nofollow">config.py</a> file (as an example, this is the config file for LoRA) in the PEFT source code.',pt,ie,ct,pe,Ot="In some circumstances, you might want to store the whole PEFT model, including the base weights. This can be necessary if, for instance, the base model is not available to the users trying to load the PEFT model. You can merge the weights first or convert it into a Transformer model.",rt,ce,ut,re,Kt="The most straightforward way to store the whole PEFT model is to merge the adapter weights into the base weights:",ht,ue,dt,he,es="There are some disadvantages to this approach, though:",mt,de,ts='<li>Once <a href="/docs/peft/pr_1915/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> is called, you get a basic model without any PEFT-specific functionality. This means you can’t use any of the PEFT-specific methods anymore.</li> <li>You cannot unmerge the weights, load multiple adapters at once, disable the adapter, etc.</li> <li>Not all PEFT methods support merging weights.</li> <li>Some PEFT methods may generally allow merging, but not with specific settings (e.g. when using certain quantization techniques).</li> <li>The whole model will be much larger than the PEFT model, as it will contain all the base weights as well.</li>',yt,me,ss="But inference with a merged model should be a bit faster.",Mt,ye,Tt,Me,as="Another way to save the whole model, assuming the base model is a Transformers model, is to use this hacky approach to directly insert the PEFT weights into the base model and save it, which only works if you “trick” Transformers into believing the PEFT model is not a PEFT model. This only works with LoRA because other adapters are not implemented in Transformers.",ft,Te,jt,fe,Jt,we,wt;return _=new b({props:{title:"PEFT checkpoint format",local:"peft-checkpoint-format",headingTag:"h1"}}),C=new b({props:{title:"PEFT files",local:"peft-files",headingTag:"h2"}}),k=new je({props:{code:"JTdCJTBBJTIwJTIwJTIyYXV0b19tYXBwaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9jbGFzcyUyMiUzQSUyMCUyMkJlcnRNb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmVudF9saWJyYXJ5JTIyJTNBJTIwJTIydHJhbnNmb3JtZXJzLm1vZGVscy5iZXJ0Lm1vZGVsaW5nX2JlcnQlMjIlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyMiUzQSUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmZlZWRmb3J3YXJkX21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJvdXRwdXQuZGVuc2UlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJpbmZlcmVuY2VfbW9kZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJpbml0X2lhM193ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMm1vZHVsZXNfdG9fc2F2ZSUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJwZWZ0X3R5cGUlMjIlM0ElMjAlMjJJQTMlMjIlMkMlMEElMjAlMjAlMjJyZXZpc2lvbiUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJ0YXJnZXRfbW9kdWxlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmtleSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0LmRlbnNlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feedforward_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_ia3_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;IA3&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;key&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),F=new b({props:{title:"Convert to PEFT format",local:"convert-to-peft-format",headingTag:"h2"}}),Q=new b({props:{title:"adapter_model",local:"adaptermodel",headingTag:"h3"}}),X=new je({props:{code:"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",highlighted:`<span class="hljs-comment"># showing only part of the code</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoraLayer</span>(<span class="hljs-title class_ inherited__">BaseTunerLayer</span>):
    <span class="hljs-comment"># All names of layers that may contain (trainable) adapter weights</span>
    adapter_layer_names = (<span class="hljs-string">&quot;lora_A&quot;</span>, <span class="hljs-string">&quot;lora_B&quot;</span>, <span class="hljs-string">&quot;lora_embedding_A&quot;</span>, <span class="hljs-string">&quot;lora_embedding_B&quot;</span>)
    <span class="hljs-comment"># All names of other parameters that may contain adapter-related parameters</span>
    other_param_names = (<span class="hljs-string">&quot;r&quot;</span>, <span class="hljs-string">&quot;lora_alpha&quot;</span>, <span class="hljs-string">&quot;scaling&quot;</span>, <span class="hljs-string">&quot;lora_dropout&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, base_layer: nn.Module, **kwargs</span>) -&gt; <span class="hljs-literal">None</span>:
        self.base_layer = base_layer
        self.r = {}
        self.lora_alpha = {}
        self.scaling = {}
        self.lora_dropout = nn.ModuleDict({})
        self.lora_A = nn.ModuleDict({})
        self.lora_B = nn.ModuleDict({})
        <span class="hljs-comment"># For Embedding layer</span>
        self.lora_embedding_A = nn.ParameterDict({})
        self.lora_embedding_B = nn.ParameterDict({})
        <span class="hljs-comment"># Mark the weight as unmerged</span>
        self._disable_adapters = <span class="hljs-literal">False</span>
        self.merged_adapters = []
        self.use_dora: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>] = {}
        self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>
        self._caches: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {}
        self.kwargs = kwargs`,wrap:!1}}),w=new is({props:{$$slots:{default:[Ms]},$$scope:{ctx:Je}}}),U=new is({props:{$$slots:{default:[Ts]},$$scope:{ctx:Je}}}),O=new je({props:{code:"c2VsZi5sb3JhX21hZ25pdHVkZV92ZWN0b3IlM0ElMjBPcHRpb25hbCU1QnRvcmNoLm5uLlBhcmFtZXRlckRpY3QlNUQlMjAlM0QlMjBOb25lJTIwJTIwJTIzJTIwZm9yJTIwRG9SQQ==",highlighted:'self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>',wrap:!1}}),ee=new b({props:{title:"adapter_config",local:"adapterconfig",headingTag:"h3"}}),se=new je({props:{code:"JTdCJTBBJTIwJTIwJTIyYWxwaGFfcGF0dGVybiUyMiUzQSUyMCU3QiU3RCUyQyUwQSUyMCUyMCUyMmF1dG9fbWFwcGluZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmJhc2VfbW9kZWxfY2xhc3MlMjIlM0ElMjAlMjJCZXJ0TW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJlbnRfbGlicmFyeSUyMiUzQSUyMCUyMnRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIyJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMjIlM0ElMjAlMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMmJpYXMlMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmluZmVyZW5jZV9tb2RlJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmluaXRfbG9yYV93ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmxheWVyX3JlcGxpY2F0aW9uJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc19wYXR0ZXJuJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc190b190cmFuc2Zvcm0lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybG9mdHFfY29uZmlnJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIybG9yYV9hbHBoYSUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjJsb3JhX2Ryb3BvdXQlMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjJtZWdhdHJvbl9jb25maWclMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybWVnYXRyb25fY29yZSUyMiUzQSUyMCUyMm1lZ2F0cm9uLmNvcmUlMjIlMkMlMEElMjAlMjAlMjJtb2R1bGVzX3RvX3NhdmUlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUyQyUwQSUyMCUyMCUyMnIlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIycmFua19wYXR0ZXJuJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIycmV2aXNpb24lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMnVzZV9kb3JhJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjJ1c2VfcnNsb3JhJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;alpha_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_lora_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layer_replication&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_to_transform&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;loftq_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_alpha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_dropout&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_core&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;megatron.core&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;r&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;rank_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_dora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_rslora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ne=new je({props:{code:"JTdCJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMjJxdWVyeSUyMiUyQyUyMCUyMnZhbHVlJTIyJTVEJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ie=new b({props:{title:"Model storage",local:"model-storage",headingTag:"h2"}}),ce=new b({props:{title:"Merge the weights",local:"merge-the-weights",headingTag:"h3"}}),ue=new je({props:{code:"bWVyZ2VkX21vZGVsJTIwJTNEJTIwbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBbWVyZ2VkX21vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4p",highlighted:`merged_model = model.merge_and_unload()
merged_model.save_pretrained(...)`,wrap:!1}}),ye=new b({props:{title:"Convert to a Transformers model",local:"convert-to-a-transformers-model",headingTag:"h3"}}),Te=new je({props:{code:"",highlighted:`model = ...  <span class="hljs-comment"># the PEFT model</span>
...
<span class="hljs-comment"># after you finish training the model, save it in a temporary location</span>
model.save_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now load this model directly into a transformers model, without the PEFT wrapper</span>
<span class="hljs-comment"># the PEFT weights are directly injected into the base model</span>
model_loaded = AutoModel.from_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now make the loaded model believe that it is _not_ a PEFT model</span>
model_loaded._hf_peft_config_loaded = <span class="hljs-literal">False</span>
<span class="hljs-comment"># now when we save it, it will save the whole model</span>
model_loaded.save_pretrained(&lt;final_location&gt;)
<span class="hljs-comment"># or upload to Hugging Face Hub</span>
model_loaded.push_to_hub(&lt;final_location&gt;)`,wrap:!1}}),fe=new ys({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/checkpoint.md"}}),{c(){c=o("meta"),T=l(),M=o("p"),f=l(),r(_.$$.fragment),Ue=l(),I=o("p"),I.textContent=bt,be=l(),r(C.$$.fragment),_e=l(),g=o("p"),g.textContent=_t,Ie=l(),v=o("p"),v.innerHTML=It,Ce=l(),q=o("ol"),q.innerHTML=Ct,ge=l(),B=o("p"),B.innerHTML=gt,ve=l(),$=o("p"),$.innerHTML=vt,qe=l(),j=o("ol"),j.innerHTML=qt,Be=l(),E=o("p"),E.innerHTML=Bt,$e=l(),r(k.$$.fragment),Ee=l(),A=o("p"),A.textContent=$t,ke=l(),Z=o("ul"),Z.innerHTML=Et,Ae=l(),x=o("p"),x.innerHTML=kt,Ze=l(),J=o("ol"),J.innerHTML=At,xe=l(),V=o("p"),V.innerHTML=Zt,Ve=l(),r(F.$$.fragment),Fe=l(),L=o("p"),L.innerHTML=xt,Le=l(),r(Q.$$.fragment),Qe=l(),H=o("p"),H.textContent=Vt,He=l(),R=o("p"),R.innerHTML=Ft,Re=l(),r(X.$$.fragment),Xe=l(),W=o("p"),W.innerHTML=Lt,We=l(),G=o("p"),G.innerHTML=Qt,Ge=l(),P=o("ul"),P.innerHTML=Ht,Pe=l(),Y=o("p"),Y.textContent=Rt,Ye=l(),N=o("ul"),N.innerHTML=Xt,Ne=l(),r(w.$$.fragment),Se=l(),S=o("p"),S.innerHTML=Wt,ze=l(),z=o("p"),z.innerHTML=Gt,De=l(),r(U.$$.fragment),Oe=l(),D=o("p"),D.innerHTML=Pt,Ke=l(),r(O.$$.fragment),et=l(),K=o("p"),K.textContent=Yt,tt=l(),r(ee.$$.fragment),st=l(),te=o("p"),te.innerHTML=Nt,at=l(),r(se.$$.fragment),lt=l(),ae=o("p"),ae.innerHTML=St,nt=l(),le=o("p"),le.textContent=zt,ot=l(),r(ne.$$.fragment),it=l(),oe=o("p"),oe.innerHTML=Dt,pt=l(),r(ie.$$.fragment),ct=l(),pe=o("p"),pe.textContent=Ot,rt=l(),r(ce.$$.fragment),ut=l(),re=o("p"),re.textContent=Kt,ht=l(),r(ue.$$.fragment),dt=l(),he=o("p"),he.textContent=es,mt=l(),de=o("ul"),de.innerHTML=ts,yt=l(),me=o("p"),me.textContent=ss,Mt=l(),r(ye.$$.fragment),Tt=l(),Me=o("p"),Me.textContent=as,ft=l(),r(Te.$$.fragment),jt=l(),r(fe.$$.fragment),Jt=l(),we=o("p"),this.h()},l(e){const t=ds("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(s),T=n(e),M=i(e,"P",{}),os(M).forEach(s),f=n(e),u(_.$$.fragment,e),Ue=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-i846eh"&&(I.textContent=bt),be=n(e),u(C.$$.fragment,e),_e=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1jlobya"&&(g.textContent=_t),Ie=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-blu6og"&&(v.innerHTML=It),Ce=n(e),q=i(e,"OL",{"data-svelte-h":!0}),p(q)!=="svelte-1buhd3i"&&(q.innerHTML=Ct),ge=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-12xl22z"&&(B.innerHTML=gt),ve=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1uhgqli"&&($.innerHTML=vt),qe=n(e),j=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(j)!=="svelte-u9vwkh"&&(j.innerHTML=qt),Be=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ubabis"&&(E.innerHTML=Bt),$e=n(e),u(k.$$.fragment,e),Ee=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-18i1sdg"&&(A.textContent=$t),ke=n(e),Z=i(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-1fi0uuu"&&(Z.innerHTML=Et),Ae=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1nfr73w"&&(x.innerHTML=kt),Ze=n(e),J=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(J)!=="svelte-11vms8t"&&(J.innerHTML=At),xe=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-bfnv50"&&(V.innerHTML=Zt),Ve=n(e),u(F.$$.fragment,e),Fe=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1k4p1z7"&&(L.innerHTML=xt),Le=n(e),u(Q.$$.fragment,e),Qe=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-kd80je"&&(H.textContent=Vt),He=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-vjr9ez"&&(R.innerHTML=Ft),Re=n(e),u(X.$$.fragment,e),Xe=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1bnpl7i"&&(W.innerHTML=Lt),We=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-my5lpq"&&(G.innerHTML=Qt),Ge=n(e),P=i(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-18g5t5x"&&(P.innerHTML=Ht),Pe=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1cey2tw"&&(Y.textContent=Rt),Ye=n(e),N=i(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-12zgb0p"&&(N.innerHTML=Xt),Ne=n(e),u(w.$$.fragment,e),Se=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1g2h6ud"&&(S.innerHTML=Wt),ze=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1i8spmk"&&(z.innerHTML=Gt),De=n(e),u(U.$$.fragment,e),Oe=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1bo4lop"&&(D.innerHTML=Pt),Ke=n(e),u(O.$$.fragment,e),et=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-34pnf6"&&(K.textContent=Yt),tt=n(e),u(ee.$$.fragment,e),st=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-6fxao8"&&(te.innerHTML=Nt),at=n(e),u(se.$$.fragment,e),lt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-6hfyn3"&&(ae.innerHTML=St),nt=n(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-190wzyy"&&(le.textContent=zt),ot=n(e),u(ne.$$.fragment,e),it=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-19ijgni"&&(oe.innerHTML=Dt),pt=n(e),u(ie.$$.fragment,e),ct=n(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1bwnzmb"&&(pe.textContent=Ot),rt=n(e),u(ce.$$.fragment,e),ut=n(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1k0zco1"&&(re.textContent=Kt),ht=n(e),u(ue.$$.fragment,e),dt=n(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-scpch6"&&(he.textContent=es),mt=n(e),de=i(e,"UL",{"data-svelte-h":!0}),p(de)!=="svelte-1apaocp"&&(de.innerHTML=ts),yt=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-ohejod"&&(me.textContent=ss),Mt=n(e),u(ye.$$.fragment,e),Tt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-lzrdax"&&(Me.textContent=as),ft=n(e),u(Te.$$.fragment,e),jt=n(e),u(fe.$$.fragment,e),Jt=n(e),we=i(e,"P",{}),os(we).forEach(s),this.h()},h(){Ut(c,"name","hf:doc:metadata"),Ut(c,"content",js),Ut(j,"start","2"),Ut(J,"start","3")},m(e,t){ms(document.head,c),a(e,T,t),a(e,M,t),a(e,f,t),h(_,e,t),a(e,Ue,t),a(e,I,t),a(e,be,t),h(C,e,t),a(e,_e,t),a(e,g,t),a(e,Ie,t),a(e,v,t),a(e,Ce,t),a(e,q,t),a(e,ge,t),a(e,B,t),a(e,ve,t),a(e,$,t),a(e,qe,t),a(e,j,t),a(e,Be,t),a(e,E,t),a(e,$e,t),h(k,e,t),a(e,Ee,t),a(e,A,t),a(e,ke,t),a(e,Z,t),a(e,Ae,t),a(e,x,t),a(e,Ze,t),a(e,J,t),a(e,xe,t),a(e,V,t),a(e,Ve,t),h(F,e,t),a(e,Fe,t),a(e,L,t),a(e,Le,t),h(Q,e,t),a(e,Qe,t),a(e,H,t),a(e,He,t),a(e,R,t),a(e,Re,t),h(X,e,t),a(e,Xe,t),a(e,W,t),a(e,We,t),a(e,G,t),a(e,Ge,t),a(e,P,t),a(e,Pe,t),a(e,Y,t),a(e,Ye,t),a(e,N,t),a(e,Ne,t),h(w,e,t),a(e,Se,t),a(e,S,t),a(e,ze,t),a(e,z,t),a(e,De,t),h(U,e,t),a(e,Oe,t),a(e,D,t),a(e,Ke,t),h(O,e,t),a(e,et,t),a(e,K,t),a(e,tt,t),h(ee,e,t),a(e,st,t),a(e,te,t),a(e,at,t),h(se,e,t),a(e,lt,t),a(e,ae,t),a(e,nt,t),a(e,le,t),a(e,ot,t),h(ne,e,t),a(e,it,t),a(e,oe,t),a(e,pt,t),h(ie,e,t),a(e,ct,t),a(e,pe,t),a(e,rt,t),h(ce,e,t),a(e,ut,t),a(e,re,t),a(e,ht,t),h(ue,e,t),a(e,dt,t),a(e,he,t),a(e,mt,t),a(e,de,t),a(e,yt,t),a(e,me,t),a(e,Mt,t),h(ye,e,t),a(e,Tt,t),a(e,Me,t),a(e,ft,t),h(Te,e,t),a(e,jt,t),h(fe,e,t),a(e,Jt,t),a(e,we,t),wt=!0},p(e,[t]){const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),w.$set(ls);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),U.$set(ns)},i(e){wt||(d(_.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(X.$$.fragment,e),d(w.$$.fragment,e),d(U.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),wt=!0)},o(e){m(_.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(X.$$.fragment,e),m(w.$$.fragment,e),m(U.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),wt=!1},d(e){e&&(s(T),s(M),s(f),s(Ue),s(I),s(be),s(_e),s(g),s(Ie),s(v),s(Ce),s(q),s(ge),s(B),s(ve),s($),s(qe),s(j),s(Be),s(E),s($e),s(Ee),s(A),s(ke),s(Z),s(Ae),s(x),s(Ze),s(J),s(xe),s(V),s(Ve),s(Fe),s(L),s(Le),s(Qe),s(H),s(He),s(R),s(Re),s(Xe),s(W),s(We),s(G),s(Ge),s(P),s(Pe),s(Y),s(Ye),s(N),s(Ne),s(Se),s(S),s(ze),s(z),s(De),s(Oe),s(D),s(Ke),s(et),s(K),s(tt),s(st),s(te),s(at),s(lt),s(ae),s(nt),s(le),s(ot),s(it),s(oe),s(pt),s(ct),s(pe),s(rt),s(ut),s(re),s(ht),s(dt),s(he),s(mt),s(de),s(yt),s(me),s(Mt),s(Tt),s(Me),s(ft),s(jt),s(Jt),s(we)),s(c),y(_,e),y(C,e),y(k,e),y(F,e),y(Q,e),y(X,e),y(w,e),y(U,e),y(O,e),y(ee,e),y(se,e),y(ne,e),y(ie,e),y(ce,e),y(ue,e),y(ye,e),y(Te,e),y(fe,e)}}}const js='{"title":"PEFT checkpoint format","local":"peft-checkpoint-format","sections":[{"title":"PEFT files","local":"peft-files","sections":[],"depth":2},{"title":"Convert to PEFT format","local":"convert-to-peft-format","sections":[{"title":"adapter_model","local":"adaptermodel","sections":[],"depth":3},{"title":"adapter_config","local":"adapterconfig","sections":[],"depth":3}],"depth":2},{"title":"Model storage","local":"model-storage","sections":[{"title":"Merge the weights","local":"merge-the-weights","sections":[],"depth":3},{"title":"Convert to a Transformers model","local":"convert-to-a-transformers-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function Js(Je){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends us{constructor(c){super(),hs(this,c,Js,fs,cs,{})}}export{Cs as component};
