import{s as Vn,o as Sn,n as $}from"../chunks/scheduler.b108d059.js";import{S as Hn,i as Zn,g as o,s,r as u,A as Wn,h as M,f as l,c as a,j as Ln,u as m,x as r,k as Qn,y as Fn,a as n,v as d,d as y,t as c,w as h}from"../chunks/index.008de539.js";import{T as b}from"../chunks/Tip.aeb15ab7.js";import{C as f}from"../chunks/CodeBlock.7b00c886.js";import{H as g,E as Nn}from"../chunks/getInferenceSnippets.79dc142e.js";function Pn(U){let i,T="Note that endpoint names must to be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){i=o("p"),i.textContent=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-zrbum5"&&(i.textContent=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function Xn(U){let i,T="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){i=o("p"),i.innerHTML=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-fg1top"&&(i.innerHTML=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function Yn(U){let i,T='Since for some models and inference engines you need to run those on a GPU-accelerated instance, you may need to request a quota increase for some of the supported instances as per the model you want to deploy. Also, keep into consideration that each model comes with a list of all the supported instances, being the recommended one for each tier the lower instance in terms of available VRAM. Read more about quota increase requests for Azure ML at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){i=o("p"),i.innerHTML=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-3styqc"&&(i.innerHTML=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function Dn(U){let i,T="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){i=o("p"),i.textContent=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-13fiegq"&&(i.textContent=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function On(U){let i,T="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){i=o("p"),i.textContent=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1q2pvid"&&(i.textContent=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function Kn(U){let i,T="Note that below only some of the options are listed, but you can send requests to the deployed endpoint as long as you send the HTTP requests with the <code>azureml-model-deployment</code> header set to the name of the Azure AI Deployment (not the Endpoint), and have the necessary authentication token / key to send requests to the given endpoint; then you can send HTTP request to all the routes that the backend engine is exposing, not only to the scoring route.";return{c(){i=o("p"),i.innerHTML=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1fmd54g"&&(i.innerHTML=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function es(U){let i,T='Support for Hugging Face models via <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ai/azure-ai-inference" rel="nofollow"><code>azure-ai-inference</code> Python SDK</a> is still a work in progress, but that will be included soon and set as the recommended inference method, stay tuned!';return{c(){i=o("p"),i.innerHTML=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1c2r502"&&(i.innerHTML=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function ts(U){let i,T="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",p,w,I,A,C="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",x;return w=new f({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/v1&quot;</span>',wrap:!1}}),{c(){i=o("p"),i.textContent=T,p=s(),u(w.$$.fragment),I=s(),A=o("p"),A.textContent=C},l(J){i=M(J,"P",{"data-svelte-h":!0}),r(i)!=="svelte-ufs9gh"&&(i.textContent=T),p=a(J),m(w.$$.fragment,J),I=a(J),A=M(J,"P",{"data-svelte-h":!0}),r(A)!=="svelte-vz1qru"&&(A.textContent=C)},m(J,j){n(J,i,j),n(J,p,j),d(w,J,j),n(J,I,j),n(J,A,j),x=!0},p:$,i(J){x||(y(w.$$.fragment,J),x=!0)},o(J){c(w.$$.fragment,J),x=!1},d(J){J&&(l(i),l(p),l(I),l(A)),h(w,J)}}}function ls(U){let i,T='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/deploy-smollm3/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){i=o("p"),i.innerHTML=T},l(p){i=M(p,"P",{"data-svelte-h":!0}),r(i)!=="svelte-wlxxqu"&&(i.innerHTML=T)},m(p,w){n(p,i,w)},p:$,d(p){p&&l(i)}}}function ns(U){let i,T,p,w,I,A,C,x="This example showcases how to deploy SmolLM3 from the Hugging Face Collection in Azure AI Foundry Hub as an Azure ML Managed Online Endpoint, powered by Transformers with an OpenAI compatible interface. Additionally, this example also showcases how to run inference with both the Azure ML Python SDK, the OpenAI Python SDK, and even how to locally run a Gradio application for chat completion.",J,j,Ll='<img src="https://cdn-uploads.huggingface.co/production/uploads/61c141342aac764ce1654e43/zy0dqTCCt5IHmuzwoqtJ9.png" alt="SmolLM3 3B logo image"/>',at,L,Ql="TL;DR Transformers acts as the model-definition framework for state-of-the-art machine learning models in text, computer vision, audio, video, and multimodal model, for both inference and training. Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",it,ot,Mt,Q,Vl='This example will specifically deploy <a href="https://huggingface.co/HuggingFaceTB/SmolLM3-3B" rel="nofollow"><code>HuggingFaceTB/SmolLM3-3B</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/huggingfacetb-smollm3-3b/version/1/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/huggingfacetb-smollm3-3b/version/1/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',pt,V,Sl="SmolLM3 is a 3B parameter language model designed to push the boundaries of small models. It supports dual mode reasoning, 6 languages and long context. SmolLM3 is a fully open model that offers strong performance at the 3B–4B scale.",rt,S,Hl='<img src="https://cdn-uploads.huggingface.co/production/uploads/6200d0a443eb0913fa2df7cc/db3az7eGzs-Sb-8yUj-ff.png" alt="SmolLM3 3B size and performance comparison"/>',ut,H,Zl="The model is a decoder-only transformer using GQA and NoPE (with 3:1 ratio), it was pretrained on 11.2T tokens with a staged curriculum of web, code, math and reasoning data. Post-training included midtraining on 140B reasoning tokens followed by supervised fine-tuning and alignment via Anchored Preference Optimization (APO).",mt,Z,Wl="Key features",dt,W,Fl="<li>Instruct model optimized for <strong>hybrid reasoning</strong></li> <li><strong>Fully open model</strong>: open weights + full training details including public data mixture and training configs</li> <li><strong>Long context:</strong> Trained on 64k context and suppots up to <strong>128k tokens</strong> using YARN extrapolation</li> <li><strong>Multilingual</strong>: 6 natively supported (English, French, Spanish, German, Italian, and Portuguese)</li>",yt,F,Nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-smollm3/smollm3-hub.png" alt="SmolLM3 3B on the Hugging Face Hub"/>',ct,N,Pl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-smollm3/smollm3-azure-ai.png" alt="SmolLM3 3B on Azure AI Foundry"/>',ht,P,Xl='For more information, make sure to check <a href="https://huggingface.co/HuggingFaceTB/SmolLM3-3B/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a>.',Tt,X,wt,Y,Yl='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',Jt,D,Dl="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",Ut,O,Ol='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',ft,K,jt,ee,Kl='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',gt,te,It,le,en='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',At,ne,tn="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",Ct,se,bt,ae,ln="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",$t,v,vt,ie,zt,oe,Et,Me,nn="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>HuggingFaceTB/SmolLM3-3B</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",qt,z,Bt,pe,_t,re,kt,ue,sn="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/&lt;REGISTRY_NAME&gt;/models/&lt;MODEL_ID&gt;/labels/latest</code> (even if the URI contains <code>azureml</code> it’s the same as in Azure AI Foundry, since the model catalog is shared), that means that the <code>REGISTRY_NAME</code> should be set to “HuggingFace” as you intend to deploy a model from the Hugging Face Collection, and the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID, but rather the ID with hyphen replacements for both backslash (/) and underscores (_) with hyphens (-), and then into lower case, as follows:",Rt,me,Gt,de,an='Note that you will need to verify in advance that the URI is valid, and that the given Hugging Face Hub Model ID exists on Azure, since Hugging Face is publishing those models into their collection, meaning that some models may be available on the Hugging Face Hub but not yet on the Azure Model Catalog (you can request adding a model following the guide <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition</a>).',xt,ye,on="Alternatively, you can use the following snippet to verify if a model is available on the Azure Model Catalog programmatically:",Lt,ce,Qt,he,Mn='As mentioned previously, the Managed Online Endpoint expects a unique name per region. It’s a good practice to add some sort of unique name in case of multi-region deployments. You can set the name via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint Python class</a>.',Vt,Te,pn='Also note that by default the <code>ManagedOnlineEndpoint</code> will use the <code>key</code> authentication method, meaning that there will be a primary and secondary key that should be sent within the Authentication headers as a Bearer token; but also the <code>aml_token</code> authentication method can be used, read more about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-authenticate-online-endpoint" rel="nofollow">Authenticate clients for online endpoints</a>.',St,we,rn='The deployment, created via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlinedeployment?view=azure-python" rel="nofollow">ManagedOnlineDeployment Python class</a>, will be exposed via the defined endpoint. The <code>ManagedOnlineDeployment</code> expects: the <code>model</code> (previously defined URI), the <code>endpoint_name</code>, and the instance requirements (<code>instance_type</code> and <code>instance_count</code>).',Ht,Je,un='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>); in this case, a NVIDIA H100 GPU will be used i.e., <code>Standard_NC40ads_H100_v5</code>.',Zt,E,Wt,Ue,Ft,fe,Nt,je,mn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-smollm3/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Pt,q,Xt,ge,Yt,Ie,dn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-smollm3/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',Dt,B,Ot,Ae,yn='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>.',Kt,Ce,cn='Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',el,be,tl,$e,hn="Finally, now that the Azure AI Endpoint is deployed, you can send requests to it. In this case, since the task of the model is <code>text-generation</code> (also known as <code>chat-completion</code>) you can either use leverage having an OpenAI-compatible OpenAPI interface and send requests to <code>/v1/chat/completions</code>.",ll,_,nl,k,sl,ve,al,ze,Tn="With this OpenAI-compatible Transformers interface, you can also leverage the OpenAI Python SDK to send requests to the deployed Azure AI Endpoint.",il,Ee,ol,qe,wn="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to first retrieve:",Ml,Be,Jn="<li><code>api_url</code> with the <code>/v1</code> route (that contains the <code>v1/chat/completions</code> endpoint that the OpenAI Python SDK will send requests to)</li> <li><code>api_key</code> which is the API Key in Azure AI or the primary key in Azure ML (unless a dedicated Azure ML Token is used instead)</li>",pl,_e,rl,R,ul,ke,Un="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",ml,Re,fn="Via the OpenAI Python SDK it can either be set within each call to <code>chat.completions.create</code> via the <code>extra_headers</code> parameter as commented below, or via the <code>default_headers</code> parameter when instantiating the <code>OpenAI</code> client (which is the recommended approach since the header needs to be present on each request, so setting it just once is preferred).",dl,Ge,yl,xe,cl,Le,hl,Qe,Tl,Ve,jn="By default, <code>SmolLM3-3B</code> enables extended thinking, so the example above generates the output with a reasoning trace. For choosing between enabling, you can provide the <code>/think</code> and <code>/no_think</code> flags through the system prompt as shown in the snippet below for extended thinking disabled. The code for generating the response with extended thinking would be the same except that the system prompt should have <code>/think</code> instead of <code>/no_think</code>.",wl,Se,Jl,He,Ul,Ze,gn="As mentioned, <code>SmolLM3-3B</code> has been trained to natively suport 6 languages: English, French, Spanish, German, Italian, and Portuguese.",fl,We,In="You can try and leverage its multilingual potential.",jl,Fe,gl,Ne,Il,Pe,An="<code>SmolLM3-3B</code> supports tool calling. Just pass your list of tools as dictionary objects as follows. You have to specify the name, the description and the parameters so the model can generate the correct tool call.",Al,Xe,Cn="Remember to set the <code>max_completion_tokens</code> parameter to a realtively high value, since the model will need enough tokens to generate the answer.",Cl,Ye,bl,De,$l,Oe,bn="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",vl,Ke,zl,et,El,tt,$n="Throughout this example you learnt how to create and configure your Azure account for Azure ML and Azure AI Foundry, how to then create a Managed Online Endpoint running an open model from the Hugging Face Collection in the Azure ML / Azure AI Foundry model catalog, how to send inference requests with OpenAI SDK, and finally, how to stop and release the resources.",ql,lt,vn='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',Bl,_l,kl,G,Rl,nt,Gl,st,xl;return I=new g({props:{title:"Deploy SmolLM3 on Azure AI",local:"deploy-smollm3-on-azure-ai",headingTag:"h1"}}),X=new g({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),K=new g({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),te=new f({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),se=new f({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),v=new b({props:{$$slots:{default:[Pn]},$$scope:{ctx:U}}}),ie=new f({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIyc21vbGxtMy1lbmRwb2ludC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIyJTBBb3MuZW52aXJvbiU1QiUyMkRFUExPWU1FTlRfTkFNRSUyMiU1RCUyMCUzRCUyMGYlMjJzbW9sbG0zLWRlcGxveW1lbnQtJTdCc3RyKHV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;smollm3-endpoint-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;smollm3-deployment-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),oe=new g({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),z=new b({props:{$$slots:{default:[Xn]},$$scope:{ctx:U}}}),pe=new f({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),re=new g({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),me=new f({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUwQSUwQW1vZGVsX3VyaSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBmJTIyYXp1cmVtbCUzQSUyRiUyRnJlZ2lzdHJpZXMlMkZIdWdnaW5nRmFjZSUyRm1vZGVscyUyRiU3Qm1vZGVsX2lkLnJlcGxhY2UoJyUyRiclMkMlMjAnLScpLnJlcGxhY2UoJ18nJTJDJTIwJy0nKS5sb3dlcigpJTdEJTJGbGFiZWxzJTJGbGF0ZXN0JTIyJTBBKSUwQW1vZGVsX3VyaQ==",highlighted:`model_id = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),ce=new f({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChmJTIyaHR0cHMlM0ElMkYlMkZnZW5lcmF0ZS1henVyZW1sLXVybHMuYXp1cmV3ZWJzaXRlcy5uZXQlMkZhcGklMkZnZW5lcmF0ZSUzRm1vZGVsSWQlM0QlN0Jtb2RlbF9pZCU3RCUyMiklMEFpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwISUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1QiU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTNEJTdEJTVEJTIwJTdCbW9kZWxfaWQlM0QlN0QlMjBub3QlMjBhdmFpbGFibGUlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwQ29sbGVjdGlvbiUyMGluJTIwQXp1cmUlMjBNb2RlbCUyMENhdGFsb2clMjIp",highlighted:`<span class="hljs-keyword">import</span> requests

response = requests.get(<span class="hljs-string">f&quot;https://generate-azureml-urls.azurewebsites.net/api/generate?modelId=<span class="hljs-subst">{model_id}</span>&quot;</span>)
<span class="hljs-keyword">if</span> response.status_code != <span class="hljs-number">200</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;[{response.status_code=}] {model_id=} not available on the Hugging Face Collection in Azure Model Catalog&quot;</span>)`,wrap:!1}}),E=new b({props:{warning:!0,$$slots:{default:[Yn]},$$scope:{ctx:U}}}),Ue=new f({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),fe=new f({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),q=new b({props:{$$slots:{default:[Dn]},$$scope:{ctx:U}}}),ge=new f({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),B=new b({props:{$$slots:{default:[On]},$$scope:{ctx:U}}}),be=new g({props:{title:"Send requests to the Azure AI Endpoint",local:"send-requests-to-the-azure-ai-endpoint",headingTag:"h2"}}),_=new b({props:{$$slots:{default:[Kn]},$$scope:{ctx:U}}}),k=new b({props:{warning:!0,$$slots:{default:[es]},$$scope:{ctx:U}}}),ve=new g({props:{title:"OpenAI Python SDK",local:"openai-python-sdk",headingTag:"h3"}}),Ee=new f({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG9wZW5haSUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install openai --upgrade --quiet",wrap:!1}}),_e=new f({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmkucmVwbGFjZSglMjIlMkZjaGF0JTJGY29tcGxldGlvbnMlMjIlMkMlMjAlMjIlMjIp",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/chat/completions&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),R=new b({props:{$$slots:{default:[ts]},$$scope:{ctx:U}}}),Ge=new f({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX2NsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRGFwaV91cmwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEYXBpX2tleSUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHRfaGVhZGVycyUzRCU3QiUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUyMiUzQSUyMG9zLmdldGVudiglMjJERVBMT1lNRU5UX05BTUUlMjIpJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)`,wrap:!1}}),xe=new g({props:{title:"Chat completion call",local:"chat-completion-call",headingTag:"h4"}}),Le=new f({props:{code:"Y29tcGxldGlvbiUyMCUzRCUyMG9wZW5haV9jbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGxpa2UlMjBhJTIwcGlyYXRlLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkdpdmUlMjBtZSUyMGElMjBicmllZiUyMGV4cGxhbmF0aW9uJTIwb2YlMjBncmF2aXR5JTIwaW4lMjBzaW1wbGUlMjB0ZXJtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNENTAlMkMlMEEpJTBBcHJpbnQoY29tcGxldGlvbik=",highlighted:`completion = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds like a pirate.&quot;</span>},
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Give me a brief explanation of gravity in simple terms.&quot;</span>,
        },
    ],
    max_tokens=<span class="hljs-number">50</span>,
)
<span class="hljs-built_in">print</span>(completion)`,wrap:!1}}),Qe=new g({props:{title:"Enabling and Disabling Extended Thinking Mode",local:"enabling-and-disabling-extended-thinking-mode",headingTag:"h4"}}),Se=new f({props:{code:"Y29tcGxldGlvbiUyMCUzRCUyMG9wZW5haV9jbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGxpa2UlMjBhJTIwcGlyYXRlLiUyMCUyRm5vX3RoaW5rJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyR2l2ZSUyMG1lJTIwYSUyMGJyaWVmJTIwZXhwbGFuYXRpb24lMjBvZiUyMGdyYXZpdHklMjBpbiUyMHNpbXBsZSUyMHRlcm1zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MCUyQyUwQSklMEFwcmludChjb21wbGV0aW9uKQ==",highlighted:`completion = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds like a pirate. /no_think&quot;</span>},
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Give me a brief explanation of gravity in simple terms.&quot;</span>,
        },
    ],
    max_tokens=<span class="hljs-number">50</span>,
)
<span class="hljs-built_in">print</span>(completion)`,wrap:!1}}),He=new g({props:{title:"Multilingual capabilities",local:"multilingual-capabilities",headingTag:"h4"}}),Fe=new f({props:{code:"Y29tcGxldGlvbiUyMCUzRCUyMG9wZW5haV9jbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGV4cGVydCUyMHRyYW5zbGF0aW9uLiUyMCUyRm5vX3RoaW5rJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVHJhbnNsYXRlJTIwdGhlJTIwZm9sbG93aW5nJTIwRW5nbGlzaCUyMHNlbnRlbmNlJTIwaW50byUyMFNwYW5pc2glMjBhbmQlMjBHZXJtYW4lM0ElMjBUaGUlMjBicm93biUyMGNhdCUyMHNhdCUyMG9uJTIwdGhlJTIwbWF0LiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MCUyQyUwQSklMEFwcmludChjb21wbGV0aW9uKQ==",highlighted:`completion = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an expert translation. /no_think&quot;</span>},
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Translate the following English sentence into Spanish and German: The brown cat sat on the mat.&quot;</span>,
        },
    ],
    max_tokens=<span class="hljs-number">50</span>,
)
<span class="hljs-built_in">print</span>(completion)`,wrap:!1}}),Ne=new g({props:{title:"Agentic Usage: Tool Calling",local:"agentic-usage-tool-calling",headingTag:"h4"}}),Ye=new f({props:{code:"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",highlighted:`response = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>}],
    tools=[
        {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
            <span class="hljs-string">&quot;function&quot;</span>: {
                <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
                <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather in a given location&quot;</span>,
                <span class="hljs-string">&quot;parameters&quot;</span>: {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                    <span class="hljs-string">&quot;properties&quot;</span>: {
                        <span class="hljs-string">&quot;location&quot;</span>: {
                            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                        },
                        <span class="hljs-string">&quot;unit&quot;</span>: {
                            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                            <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The unit of temperature&quot;</span>,
                        },
                    },
                    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>],
                },
            },
        }
    ],
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
    max_completion_tokens=<span class="hljs-number">300</span>,
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),De=new g({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),Ke=new f({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),et=new g({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),G=new b({props:{$$slots:{default:[ls]},$$scope:{ctx:U}}}),nt=new Nn({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/deploy-smollm3.mdx"}}),{c(){i=o("meta"),T=s(),p=o("p"),w=s(),u(I.$$.fragment),A=s(),C=o("p"),C.textContent=x,J=s(),j=o("p"),j.innerHTML=Ll,at=s(),L=o("p"),L.textContent=Ql,it=s(),ot=o("hr"),Mt=s(),Q=o("p"),Q.innerHTML=Vl,pt=s(),V=o("p"),V.textContent=Sl,rt=s(),S=o("p"),S.innerHTML=Hl,ut=s(),H=o("p"),H.textContent=Zl,mt=s(),Z=o("p"),Z.textContent=Wl,dt=s(),W=o("ul"),W.innerHTML=Fl,yt=s(),F=o("p"),F.innerHTML=Nl,ct=s(),N=o("p"),N.innerHTML=Pl,ht=s(),P=o("p"),P.innerHTML=Xl,Tt=s(),u(X.$$.fragment),wt=s(),Y=o("p"),Y.innerHTML=Yl,Jt=s(),D=o("ul"),D.innerHTML=Dl,Ut=s(),O=o("p"),O.innerHTML=Ol,ft=s(),u(K.$$.fragment),jt=s(),ee=o("p"),ee.innerHTML=Kl,gt=s(),u(te.$$.fragment),It=s(),le=o("p"),le.innerHTML=en,At=s(),ne=o("p"),ne.textContent=tn,Ct=s(),u(se.$$.fragment),bt=s(),ae=o("p"),ae.textContent=ln,$t=s(),u(v.$$.fragment),vt=s(),u(ie.$$.fragment),zt=s(),u(oe.$$.fragment),Et=s(),Me=o("p"),Me.innerHTML=nn,qt=s(),u(z.$$.fragment),Bt=s(),u(pe.$$.fragment),_t=s(),u(re.$$.fragment),kt=s(),ue=o("p"),ue.innerHTML=sn,Rt=s(),u(me.$$.fragment),Gt=s(),de=o("p"),de.innerHTML=an,xt=s(),ye=o("p"),ye.textContent=on,Lt=s(),u(ce.$$.fragment),Qt=s(),he=o("p"),he.innerHTML=Mn,Vt=s(),Te=o("p"),Te.innerHTML=pn,St=s(),we=o("p"),we.innerHTML=rn,Ht=s(),Je=o("p"),Je.innerHTML=un,Zt=s(),u(E.$$.fragment),Wt=s(),u(Ue.$$.fragment),Ft=s(),u(fe.$$.fragment),Nt=s(),je=o("p"),je.innerHTML=mn,Pt=s(),u(q.$$.fragment),Xt=s(),u(ge.$$.fragment),Yt=s(),Ie=o("p"),Ie.innerHTML=dn,Dt=s(),u(B.$$.fragment),Ot=s(),Ae=o("p"),Ae.innerHTML=yn,Kt=s(),Ce=o("p"),Ce.innerHTML=cn,el=s(),u(be.$$.fragment),tl=s(),$e=o("p"),$e.innerHTML=hn,ll=s(),u(_.$$.fragment),nl=s(),u(k.$$.fragment),sl=s(),u(ve.$$.fragment),al=s(),ze=o("p"),ze.textContent=Tn,il=s(),u(Ee.$$.fragment),ol=s(),qe=o("p"),qe.textContent=wn,Ml=s(),Be=o("ul"),Be.innerHTML=Jn,pl=s(),u(_e.$$.fragment),rl=s(),u(R.$$.fragment),ul=s(),ke=o("p"),ke.innerHTML=Un,ml=s(),Re=o("p"),Re.innerHTML=fn,dl=s(),u(Ge.$$.fragment),yl=s(),u(xe.$$.fragment),cl=s(),u(Le.$$.fragment),hl=s(),u(Qe.$$.fragment),Tl=s(),Ve=o("p"),Ve.innerHTML=jn,wl=s(),u(Se.$$.fragment),Jl=s(),u(He.$$.fragment),Ul=s(),Ze=o("p"),Ze.innerHTML=gn,fl=s(),We=o("p"),We.textContent=In,jl=s(),u(Fe.$$.fragment),gl=s(),u(Ne.$$.fragment),Il=s(),Pe=o("p"),Pe.innerHTML=An,Al=s(),Xe=o("p"),Xe.innerHTML=Cn,Cl=s(),u(Ye.$$.fragment),bl=s(),u(De.$$.fragment),$l=s(),Oe=o("p"),Oe.textContent=bn,vl=s(),u(Ke.$$.fragment),zl=s(),u(et.$$.fragment),El=s(),tt=o("p"),tt.textContent=$n,ql=s(),lt=o("p"),lt.innerHTML=vn,Bl=s(),_l=o("hr"),kl=s(),u(G.$$.fragment),Rl=s(),u(nt.$$.fragment),Gl=s(),st=o("p"),this.h()},l(e){const t=Wn("svelte-u9bgzb",document.head);i=M(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),p=M(e,"P",{}),Ln(p).forEach(l),w=a(e),m(I.$$.fragment,e),A=a(e),C=M(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cujdg3"&&(C.textContent=x),J=a(e),j=M(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1b46x50"&&(j.innerHTML=Ll),at=a(e),L=M(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-brcatq"&&(L.textContent=Ql),it=a(e),ot=M(e,"HR",{}),Mt=a(e),Q=M(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-st898r"&&(Q.innerHTML=Vl),pt=a(e),V=M(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1w9vywx"&&(V.textContent=Sl),rt=a(e),S=M(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vk6j64"&&(S.innerHTML=Hl),ut=a(e),H=M(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-9udqy4"&&(H.textContent=Zl),mt=a(e),Z=M(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-qirnvq"&&(Z.textContent=Wl),dt=a(e),W=M(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-p6zfge"&&(W.innerHTML=Fl),yt=a(e),F=M(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1sdfk7n"&&(F.innerHTML=Nl),ct=a(e),N=M(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1lu30tc"&&(N.innerHTML=Pl),ht=a(e),P=M(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ulesnv"&&(P.innerHTML=Xl),Tt=a(e),m(X.$$.fragment,e),wt=a(e),Y=M(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-dnkqle"&&(Y.innerHTML=Yl),Jt=a(e),D=M(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-dlzkka"&&(D.innerHTML=Dl),Ut=a(e),O=M(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1myp7ii"&&(O.innerHTML=Ol),ft=a(e),m(K.$$.fragment,e),jt=a(e),ee=M(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-bexho5"&&(ee.innerHTML=Kl),gt=a(e),m(te.$$.fragment,e),It=a(e),le=M(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1v277rw"&&(le.innerHTML=en),At=a(e),ne=M(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-11uslf2"&&(ne.textContent=tn),Ct=a(e),m(se.$$.fragment,e),bt=a(e),ae=M(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1wrtw53"&&(ae.textContent=ln),$t=a(e),m(v.$$.fragment,e),vt=a(e),m(ie.$$.fragment,e),zt=a(e),m(oe.$$.fragment,e),Et=a(e),Me=M(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-19nb770"&&(Me.innerHTML=nn),qt=a(e),m(z.$$.fragment,e),Bt=a(e),m(pe.$$.fragment,e),_t=a(e),m(re.$$.fragment,e),kt=a(e),ue=M(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-thijw5"&&(ue.innerHTML=sn),Rt=a(e),m(me.$$.fragment,e),Gt=a(e),de=M(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1hy4n1w"&&(de.innerHTML=an),xt=a(e),ye=M(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1kr526q"&&(ye.textContent=on),Lt=a(e),m(ce.$$.fragment,e),Qt=a(e),he=M(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ol8a62"&&(he.innerHTML=Mn),Vt=a(e),Te=M(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1kte4k3"&&(Te.innerHTML=pn),St=a(e),we=M(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-13m1uw0"&&(we.innerHTML=rn),Ht=a(e),Je=M(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1weda3f"&&(Je.innerHTML=un),Zt=a(e),m(E.$$.fragment,e),Wt=a(e),m(Ue.$$.fragment,e),Ft=a(e),m(fe.$$.fragment,e),Nt=a(e),je=M(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-rurq1p"&&(je.innerHTML=mn),Pt=a(e),m(q.$$.fragment,e),Xt=a(e),m(ge.$$.fragment,e),Yt=a(e),Ie=M(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-19ycyw5"&&(Ie.innerHTML=dn),Dt=a(e),m(B.$$.fragment,e),Ot=a(e),Ae=M(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1v1bv0"&&(Ae.innerHTML=yn),Kt=a(e),Ce=M(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-kgt4mo"&&(Ce.innerHTML=cn),el=a(e),m(be.$$.fragment,e),tl=a(e),$e=M(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11iklo0"&&($e.innerHTML=hn),ll=a(e),m(_.$$.fragment,e),nl=a(e),m(k.$$.fragment,e),sl=a(e),m(ve.$$.fragment,e),al=a(e),ze=M(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-16dzbln"&&(ze.textContent=Tn),il=a(e),m(Ee.$$.fragment,e),ol=a(e),qe=M(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-9zyo13"&&(qe.textContent=wn),Ml=a(e),Be=M(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-kvalv2"&&(Be.innerHTML=Jn),pl=a(e),m(_e.$$.fragment,e),rl=a(e),m(R.$$.fragment,e),ul=a(e),ke=M(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1t4oej1"&&(ke.innerHTML=Un),ml=a(e),Re=M(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1t8h4hs"&&(Re.innerHTML=fn),dl=a(e),m(Ge.$$.fragment,e),yl=a(e),m(xe.$$.fragment,e),cl=a(e),m(Le.$$.fragment,e),hl=a(e),m(Qe.$$.fragment,e),Tl=a(e),Ve=M(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-qeuit6"&&(Ve.innerHTML=jn),wl=a(e),m(Se.$$.fragment,e),Jl=a(e),m(He.$$.fragment,e),Ul=a(e),Ze=M(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1uyvh6n"&&(Ze.innerHTML=gn),fl=a(e),We=M(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-a43xwf"&&(We.textContent=In),jl=a(e),m(Fe.$$.fragment,e),gl=a(e),m(Ne.$$.fragment,e),Il=a(e),Pe=M(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1vt1hoc"&&(Pe.innerHTML=An),Al=a(e),Xe=M(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-76zn6c"&&(Xe.innerHTML=Cn),Cl=a(e),m(Ye.$$.fragment,e),bl=a(e),m(De.$$.fragment,e),$l=a(e),Oe=M(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-rntoeu"&&(Oe.textContent=bn),vl=a(e),m(Ke.$$.fragment,e),zl=a(e),m(et.$$.fragment,e),El=a(e),tt=M(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1o661jx"&&(tt.textContent=$n),ql=a(e),lt=M(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1nopug0"&&(lt.innerHTML=vn),Bl=a(e),_l=M(e,"HR",{}),kl=a(e),m(G.$$.fragment,e),Rl=a(e),m(nt.$$.fragment,e),Gl=a(e),st=M(e,"P",{}),Ln(st).forEach(l),this.h()},h(){Qn(i,"name","hf:doc:metadata"),Qn(i,"content",ss)},m(e,t){Fn(document.head,i),n(e,T,t),n(e,p,t),n(e,w,t),d(I,e,t),n(e,A,t),n(e,C,t),n(e,J,t),n(e,j,t),n(e,at,t),n(e,L,t),n(e,it,t),n(e,ot,t),n(e,Mt,t),n(e,Q,t),n(e,pt,t),n(e,V,t),n(e,rt,t),n(e,S,t),n(e,ut,t),n(e,H,t),n(e,mt,t),n(e,Z,t),n(e,dt,t),n(e,W,t),n(e,yt,t),n(e,F,t),n(e,ct,t),n(e,N,t),n(e,ht,t),n(e,P,t),n(e,Tt,t),d(X,e,t),n(e,wt,t),n(e,Y,t),n(e,Jt,t),n(e,D,t),n(e,Ut,t),n(e,O,t),n(e,ft,t),d(K,e,t),n(e,jt,t),n(e,ee,t),n(e,gt,t),d(te,e,t),n(e,It,t),n(e,le,t),n(e,At,t),n(e,ne,t),n(e,Ct,t),d(se,e,t),n(e,bt,t),n(e,ae,t),n(e,$t,t),d(v,e,t),n(e,vt,t),d(ie,e,t),n(e,zt,t),d(oe,e,t),n(e,Et,t),n(e,Me,t),n(e,qt,t),d(z,e,t),n(e,Bt,t),d(pe,e,t),n(e,_t,t),d(re,e,t),n(e,kt,t),n(e,ue,t),n(e,Rt,t),d(me,e,t),n(e,Gt,t),n(e,de,t),n(e,xt,t),n(e,ye,t),n(e,Lt,t),d(ce,e,t),n(e,Qt,t),n(e,he,t),n(e,Vt,t),n(e,Te,t),n(e,St,t),n(e,we,t),n(e,Ht,t),n(e,Je,t),n(e,Zt,t),d(E,e,t),n(e,Wt,t),d(Ue,e,t),n(e,Ft,t),d(fe,e,t),n(e,Nt,t),n(e,je,t),n(e,Pt,t),d(q,e,t),n(e,Xt,t),d(ge,e,t),n(e,Yt,t),n(e,Ie,t),n(e,Dt,t),d(B,e,t),n(e,Ot,t),n(e,Ae,t),n(e,Kt,t),n(e,Ce,t),n(e,el,t),d(be,e,t),n(e,tl,t),n(e,$e,t),n(e,ll,t),d(_,e,t),n(e,nl,t),d(k,e,t),n(e,sl,t),d(ve,e,t),n(e,al,t),n(e,ze,t),n(e,il,t),d(Ee,e,t),n(e,ol,t),n(e,qe,t),n(e,Ml,t),n(e,Be,t),n(e,pl,t),d(_e,e,t),n(e,rl,t),d(R,e,t),n(e,ul,t),n(e,ke,t),n(e,ml,t),n(e,Re,t),n(e,dl,t),d(Ge,e,t),n(e,yl,t),d(xe,e,t),n(e,cl,t),d(Le,e,t),n(e,hl,t),d(Qe,e,t),n(e,Tl,t),n(e,Ve,t),n(e,wl,t),d(Se,e,t),n(e,Jl,t),d(He,e,t),n(e,Ul,t),n(e,Ze,t),n(e,fl,t),n(e,We,t),n(e,jl,t),d(Fe,e,t),n(e,gl,t),d(Ne,e,t),n(e,Il,t),n(e,Pe,t),n(e,Al,t),n(e,Xe,t),n(e,Cl,t),d(Ye,e,t),n(e,bl,t),d(De,e,t),n(e,$l,t),n(e,Oe,t),n(e,vl,t),d(Ke,e,t),n(e,zl,t),d(et,e,t),n(e,El,t),n(e,tt,t),n(e,ql,t),n(e,lt,t),n(e,Bl,t),n(e,_l,t),n(e,kl,t),d(G,e,t),n(e,Rl,t),d(nt,e,t),n(e,Gl,t),n(e,st,t),xl=!0},p(e,[t]){const zn={};t&2&&(zn.$$scope={dirty:t,ctx:e}),v.$set(zn);const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),z.$set(En);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),E.$set(qn);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),q.$set(Bn);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),B.$set(_n);const kn={};t&2&&(kn.$$scope={dirty:t,ctx:e}),_.$set(kn);const Rn={};t&2&&(Rn.$$scope={dirty:t,ctx:e}),k.$set(Rn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),R.$set(Gn);const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),G.$set(xn)},i(e){xl||(y(I.$$.fragment,e),y(X.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(v.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(z.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(me.$$.fragment,e),y(ce.$$.fragment,e),y(E.$$.fragment,e),y(Ue.$$.fragment,e),y(fe.$$.fragment,e),y(q.$$.fragment,e),y(ge.$$.fragment,e),y(B.$$.fragment,e),y(be.$$.fragment,e),y(_.$$.fragment,e),y(k.$$.fragment,e),y(ve.$$.fragment,e),y(Ee.$$.fragment,e),y(_e.$$.fragment,e),y(R.$$.fragment,e),y(Ge.$$.fragment,e),y(xe.$$.fragment,e),y(Le.$$.fragment,e),y(Qe.$$.fragment,e),y(Se.$$.fragment,e),y(He.$$.fragment,e),y(Fe.$$.fragment,e),y(Ne.$$.fragment,e),y(Ye.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(G.$$.fragment,e),y(nt.$$.fragment,e),xl=!0)},o(e){c(I.$$.fragment,e),c(X.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(v.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(z.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(E.$$.fragment,e),c(Ue.$$.fragment,e),c(fe.$$.fragment,e),c(q.$$.fragment,e),c(ge.$$.fragment,e),c(B.$$.fragment,e),c(be.$$.fragment,e),c(_.$$.fragment,e),c(k.$$.fragment,e),c(ve.$$.fragment,e),c(Ee.$$.fragment,e),c(_e.$$.fragment,e),c(R.$$.fragment,e),c(Ge.$$.fragment,e),c(xe.$$.fragment,e),c(Le.$$.fragment,e),c(Qe.$$.fragment,e),c(Se.$$.fragment,e),c(He.$$.fragment,e),c(Fe.$$.fragment,e),c(Ne.$$.fragment,e),c(Ye.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(G.$$.fragment,e),c(nt.$$.fragment,e),xl=!1},d(e){e&&(l(T),l(p),l(w),l(A),l(C),l(J),l(j),l(at),l(L),l(it),l(ot),l(Mt),l(Q),l(pt),l(V),l(rt),l(S),l(ut),l(H),l(mt),l(Z),l(dt),l(W),l(yt),l(F),l(ct),l(N),l(ht),l(P),l(Tt),l(wt),l(Y),l(Jt),l(D),l(Ut),l(O),l(ft),l(jt),l(ee),l(gt),l(It),l(le),l(At),l(ne),l(Ct),l(bt),l(ae),l($t),l(vt),l(zt),l(Et),l(Me),l(qt),l(Bt),l(_t),l(kt),l(ue),l(Rt),l(Gt),l(de),l(xt),l(ye),l(Lt),l(Qt),l(he),l(Vt),l(Te),l(St),l(we),l(Ht),l(Je),l(Zt),l(Wt),l(Ft),l(Nt),l(je),l(Pt),l(Xt),l(Yt),l(Ie),l(Dt),l(Ot),l(Ae),l(Kt),l(Ce),l(el),l(tl),l($e),l(ll),l(nl),l(sl),l(al),l(ze),l(il),l(ol),l(qe),l(Ml),l(Be),l(pl),l(rl),l(ul),l(ke),l(ml),l(Re),l(dl),l(yl),l(cl),l(hl),l(Tl),l(Ve),l(wl),l(Jl),l(Ul),l(Ze),l(fl),l(We),l(jl),l(gl),l(Il),l(Pe),l(Al),l(Xe),l(Cl),l(bl),l($l),l(Oe),l(vl),l(zl),l(El),l(tt),l(ql),l(lt),l(Bl),l(_l),l(kl),l(Rl),l(Gl),l(st)),l(i),h(I,e),h(X,e),h(K,e),h(te,e),h(se,e),h(v,e),h(ie,e),h(oe,e),h(z,e),h(pe,e),h(re,e),h(me,e),h(ce,e),h(E,e),h(Ue,e),h(fe,e),h(q,e),h(ge,e),h(B,e),h(be,e),h(_,e),h(k,e),h(ve,e),h(Ee,e),h(_e,e),h(R,e),h(Ge,e),h(xe,e),h(Le,e),h(Qe,e),h(Se,e),h(He,e),h(Fe,e),h(Ne,e),h(Ye,e),h(De,e),h(Ke,e),h(et,e),h(G,e),h(nt,e)}}}const ss='{"title":"Deploy SmolLM3 on Azure AI","local":"deploy-smollm3-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Send requests to the Azure AI Endpoint","local":"send-requests-to-the-azure-ai-endpoint","sections":[{"title":"OpenAI Python SDK","local":"openai-python-sdk","sections":[{"title":"Chat completion call","local":"chat-completion-call","sections":[],"depth":4},{"title":"Enabling and Disabling Extended Thinking Mode","local":"enabling-and-disabling-extended-thinking-mode","sections":[],"depth":4},{"title":"Multilingual capabilities","local":"multilingual-capabilities","sections":[],"depth":4},{"title":"Agentic Usage: Tool Calling","local":"agentic-usage-tool-calling","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function as(U){return Sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Hn{constructor(i){super(),Zn(this,i,as,ns,Vn,{})}}export{us as component};
