import{s as Pn,o as Yn,n as v}from"../chunks/scheduler.b108d059.js";import{S as Dn,i as On,g as r,s as a,r as d,A as Kn,h as p,f as l,c as s,j as xn,u as M,x as u,k as Xn,y as ea,a as n,v as m,d as c,t as h,w as y}from"../chunks/index.008de539.js";import{T as I}from"../chunks/Tip.aeb15ab7.js";import{C as T}from"../chunks/CodeBlock.7b00c886.js";import{H as j,E as ta}from"../chunks/getInferenceSnippets.79dc142e.js";function la(U){let i,f="Note that you can select any Automatic Speech Recognition (ASR) model available on the Hugging Face Hub with the tag <code>NeMo</code> and the “Deploy to AzureML” option enabled, or directly select any of the ASR models available on either Azure ML or Azure AI Foundry Hub Model Catalog under the “HuggingFace” collection (note that for Azure AI Foundry the Hugging Face Collection will only be available for Hub-based projects), but only the NVIDIA Parakeet models are powered by NVIDIA NeMo, the rest of those rely on the Hugging Face Inference Toolkit.";return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-hbrmnf"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function na(U){let i,f="Note that endpoint names must be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){i=r("p"),i.textContent=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1o1z8dc"&&(i.textContent=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function aa(U){let i,f="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fg1top"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function sa(U){let i,f='Since for some models and inference engines you need to run those on a GPU-accelerated instance, you may need to request a quota increase for some of the supported instances as per the model you want to deploy. Also, keep into consideration that each model comes with a list of all the supported instances, being the recommended one for each tier the lower instance in terms of available VRAM. Read more about quota increase requests for Azure ML at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-3styqc"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function ia(U){let i,f="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){i=r("p"),i.textContent=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-13fiegq"&&(i.textContent=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function oa(U){let i,f="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){i=r("p"),i.textContent=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1q2pvid"&&(i.textContent=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function ra(U){let i,f='Support for Hugging Face models via <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ai/azure-ai-inference" rel="nofollow"><code>azure-ai-inference</code> Python SDK</a> is still a work in progress, but that will be included soon and set as the recommended inference method, stay tuned!';return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1c2r502"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function pa(U){let i,f="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",o,w,J,$,A="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",W;return w=new T({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGYXBpJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/api/v1&quot;</span>',wrap:!1}}),{c(){i=r("p"),i.textContent=f,o=a(),d(w.$$.fragment),J=a(),$=r("p"),$.textContent=A},l(g){i=p(g,"P",{"data-svelte-h":!0}),u(i)!=="svelte-ufs9gh"&&(i.textContent=f),o=s(g),M(w.$$.fragment,g),J=s(g),$=p(g,"P",{"data-svelte-h":!0}),u($)!=="svelte-vz1qru"&&($.textContent=A)},m(g,b){n(g,i,b),n(g,o,b),m(w,g,b),n(g,J,b),n(g,$,b),W=!0},p:v,i(g){W||(c(w.$$.fragment,g),W=!0)},o(g){h(w.$$.fragment,g),W=!1},d(g){g&&(l(i),l(o),l(J),l($)),y(w,g)}}}function ua(U){let i,f='Alternatively, the Gradio demo connected to your Azure ML Managed Online Endpoint as an Azure Container App as described in <a href="https://learn.microsoft.com/en-us/azure/container-apps/tutorial-deploy-from-code?tabs=python" rel="nofollow">Tutorial: Build and deploy from source code to Azure Container Apps</a>. If you’d like us to show you how to do it for Gradio in particular, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue requesting it</a>.';return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1gkmk5y"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function da(U){let i,f='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/deploy-nvidia-parakeet-asr/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){i=r("p"),i.innerHTML=f},l(o){i=p(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-12wyo3t"&&(i.innerHTML=f)},m(o,w){n(o,i,w)},p:v,d(o){o&&l(i)}}}function Ma(U){let i,f,o,w,J,$,A,W="This example showcases how to deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) from the Hugging Face Collection in Azure AI Foundry Hub as an Azure ML Managed Online Endpoint, powered by Hugging Face’s Inference container on top of NVIDIA NeMo. It also covers how to run inference with cURL, requests, OpenAI Python SDK, and even how to locally run a Gradio application for audio transcription from both recordings and files.",g,b,xl="TL;DR NVIDIA NeMo is a scalable generative AI framework built for researchers and developers working on Large Language Models, Multimodal, and Speech AI (Automatic Speech Recognition and Text-to-Speech). NVIDIA NeMo Parakeet ASR Models attain strong speech recognition accuracy while being efficient for inference. Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",pt,ut,dt,F,Xl='This example will specifically deploy <a href="https://huggingface.co/nvidia/parakeet-tdt-0.6b-v2" rel="nofollow"><code>nvidia/parakeet-tdt-0.6b-v2</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/nvidia-parakeet-tdt-0.6b-v2/version/4/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/nvidia-parakeet-tdt-0.6b-v2/version/4/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',Mt,N,Pl="<code>nvidia/parakeet-tdt-0.6b-v2</code> is a 600-million-parameter automatic speech recognition (ASR) model designed for high-quality English transcription, featuring support for punctuation, capitalization, and accurate timestamp prediction.",mt,S,Yl="This XL variant of the FastConformer architecture integrates the TDT decoder and is trained with full attention, enabling efficient transcription of audio segments up to 24 minutes in a single pass. The model achieves an RTFx of 3380 on the HF-Open-ASR leaderboard with a batch size of 128. Note: RTFx Performance may vary depending on dataset audio duration and batch size.",ct,G,Dl="<li>Accurate word-level timestamp predictions</li> <li>Automatic punctuation and capitalization</li> <li>Robust performance on spoken numbers, and song lyrics transcription</li>",ht,Q,Ol='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/nvidia-parakeet-hub.png" alt="NVIDIA Parakeet on the Hugging Face Hub"/>',yt,H,Kl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/nvidia-parakeet-azure-ai.png" alt="NVIDIA Parakeet on Azure AI Foundry"/>',ft,q,en='For more information, make sure to check <a href="https://huggingface.co/nvidia/parakeet-tdt-0.6b-v2/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a> and the <a href="https://docs.nvidia.com/nemo-framework/user-guide/latest/nemotoolkit/asr/models.html" rel="nofollow">NVIDIA NeMo Documentation</a>.',wt,C,gt,x,Tt,X,tn='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',Ut,P,ln="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",bt,Y,nn='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',Jt,D,$t,O,an='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',jt,K,At,ee,sn='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',It,te,on="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",vt,le,Ct,ne,rn="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",kt,k,zt,ae,Et,se,Zt,ie,Rt,oe,pn="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>nvidia/parakeet-tdt-0.6b-v2</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",_t,z,Vt,re,Bt,pe,Lt,ue,un="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/&lt;REGISTRY_NAME&gt;/models/&lt;MODEL_ID&gt;/labels/latest</code> (even if the URI contains <code>azureml</code> it’s the same as in Azure AI Foundry, since the model catalog is shared), that means that the <code>REGISTRY_NAME</code> should be set to “HuggingFace” as you intend to deploy a model from the Hugging Face Collection, and the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID, but rather the ID with hyphen replacements for both backslash (/) and underscores (_) with hyphens (-), and then into lower case, as follows:",Wt,de,Ft,Me,dn='Note that you will need to verify in advance that the URI is valid, and that the given Hugging Face Hub Model ID exists on Azure, since Hugging Face is publishing those models into their collection, meaning that some models may be available on the Hugging Face Hub but not yet on the Azure Model Catalog (you can request adding a model following the guide <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition</a>).',Nt,me,Mn="Alternatively, you can use the following snippet to verify if a model is available on the Azure Model Catalog programmatically:",St,ce,Gt,he,mn='Then you can create the Managed Online Endpoint specifying its name (note that the name must be unique per entire region, not only within a single subscription, resource group, workspace, etc., so it’s a nice practice to add some sort of unique name to it in case multi-region deployments are intended) via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint Python class</a>.',Qt,ye,cn='Also note that by default the <code>ManagedOnlineEndpoint</code> will use the <code>key</code> authentication method, meaning that there will be a primary and secondary key that should be sent within the Authentication headers as a Bearer token; but also the <code>aml_token</code> authentication method can be used, read more about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-authenticate-online-endpoint" rel="nofollow">Authenticate clients for online endpoints</a>.',Ht,fe,hn='The deployment, created via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlinedeployment?view=azure-python" rel="nofollow">ManagedOnlineDeployment Python class</a>, will define the actual model deployment that will be exposed via the previously created endpoint. The <code>ManagedOnlineDeployment</code> will expect: the <code>model</code> i.e., the previously created URI <code>azureml://registries/HuggingFace/models/nvidia-parakeet-tdt-0.6b-v2/labels/latest</code>, the <code>endpoint_name</code>, and the instance requirements being the <code>instance_type</code> and the <code>instance_count</code>.',qt,we,yn='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>); in this case, a NVIDIA H100 GPU will be used i.e., <code>Standard_NC40ads_H100_v5</code>.',xt,E,Xt,ge,Pt,Te,Yt,Ue,fn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Dt,Z,Ot,be,Kt,Je,wn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',el,R,tl,$e,gn='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>.',ll,je,Tn='Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',nl,Ae,al,Ie,Un="Finally, now that the Azure AI Endpoint is deployed, you can send requests to it. In this case, since the task of the model is <code>automatic-speech-recognition</code> and since it expects a multi-part request to be sent along the audio file, the <code>invoke</code> method cannot be used since it only supports JSON payloads.",sl,ve,bn="This being said, you can still send requests to it programmatically via <code>requests</code>, via the OpenAI SDK for Python or with cURL, to the <code>/api/v1/audio/transcriptions</code> route which is the OpenAI-compatible route for the Transcriptions API.",il,_,ol,Ce,Jn="To send the requests then we need both the <code>primary_key</code> and the <code>scoring_uri</code>, which can be retrieved via the Azure ML Python SDK as it follows:",rl,ke,pl,ze,$n="Additionally, since you will need a sample audio file to run the inference over, you will need to download an audio file as e.g. the following, which is the audio file showcased within the <code>nvidia/parakeet-tdt-0.6b-v2</code> model card:",ul,Ee,dl,Ze,Ml,Re,jn="As the deployed Azure AI Endpoint for ASR expects a multi-part request, you need to send separately the files, in this case being the audio files, and the data, being the request parameters such as e.g. the model name or the temperature, among others. To do so, you first need to read the audio file into an <code>io.BytesIO</code> object, and then prepare the requests with the necessary headers for both the authentication and the <code>azureml-model-deployment</code> set to point to the actual Azure AI Deployment, and send the HTTP POST with both the file and the data as follows:",ml,_e,cl,Ve,hl,Be,An="As the exposed scoring URI is an OpenAI-compatible route i.e., <code>/api/v1/audio/transcriptions</code>, you can leverage the OpenAI Python SDK to send requests to the deployed Azure AI Endpoint.",yl,Le,fl,We,In="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to update the <code>api_url</code> value defined above, since the default <code>scoring_uri</code> comes with the full route, whereas the OpenAI SDK expects the route up until the <code>v1</code> included, meaning that the <code>/audio/transcriptions</code> should be removed before instantiating the client.",wl,Fe,gl,V,Tl,Ne,vn="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",Ul,Se,Cn="Via the OpenAI Python SDK it can either be set within each call to <code>chat.completions.create</code> via the <code>extra_headers</code> parameter as commented below, or via the <code>default_headers</code> parameter when instantiating the <code>OpenAI</code> client (which is the recommended approach since the header needs to be present on each request, so setting it just once is preferred).",bl,Ge,Jl,Qe,$l,He,kn="Alternatively, you can also just use <code>cURL</code> to send requests to the deployed endpoint, with the <code>api_url</code> and <code>api_key</code> values programmatically retrieved in the OpenAI snippet and now set as environment variables so that <code>cURL</code> can use those, as it follows:",jl,qe,Al,xe,Il,Xe,zn="You can also just go to the Azure AI Endpoint in either the Azure AI Foundry under “My assets -> Models + endpoints” or in the Azure ML Studio via “Endpoints”, and retrieve both the scoring URI and the API Key values, as well as the Azure AI / ML Deployment name for the given model, and then send the request as follows after replacing the values:",vl,Pe,Cl,Ye,kl,De,En='<a href="https://www.gradio.app/" rel="nofollow">Gradio</a> is the fastest way to demo your machine learning model with a friendly web interface so that anyone can use it. You can also leverage the OpenAI Python SDK to build a simple automatic-speech-recognition i.e., speech to text demo that you can use within the Jupyter Notebook cell where you are running it.',zl,B,El,Oe,Zl,Ke,Rl,et,Zn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ml-gradio.png" alt="Gradio Chat Interface with Azure ML Endpoint"/>',_l,tt,Vl,lt,Rn="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",Bl,nt,Ll,at,Wl,st,_n="Throughout this example you learnt how to create and configure your Azure account for Azure ML and Azure AI Foundry, how to then create a Managed Online Endpoint running an open model for Automatic Speech Recognition (ASR) from the Hugging Face Collection in the Azure AI Foundry Hub / Azure ML Model Catalog, how to send inference requests to it afterwards with different alternatives, how to build a simple Gradio chat interface around it, and finally, how to stop and release the resources.",Fl,it,Vn='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',Nl,Sl,Gl,L,Ql,ot,Hl,rt,ql;return J=new j({props:{title:"Deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) on Azure AI",local:"deploy-nvidia-parakeet-for-automatic-speech-recognition-asr-on-azure-ai",headingTag:"h1"}}),C=new I({props:{$$slots:{default:[la]},$$scope:{ctx:U}}}),x=new j({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),D=new j({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),K=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),le=new T({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),k=new I({props:{$$slots:{default:[na]},$$scope:{ctx:U}}}),ae=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIybnZpZGlhLXBhcmFrZWV0LSU3QnN0cih1dWlkNCgpKSU1QiUzQTglNUQlN0QlMjIlMEFvcy5lbnZpcm9uJTVCJTIyREVQTE9ZTUVOVF9OQU1FJTIyJTVEJTIwJTNEJTIwZiUyMm52aWRpYS1wYXJha2VldC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;nvidia-parakeet-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;nvidia-parakeet-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),se=new T({props:{code:"IWVjaG8lMjAlMjRFTkRQT0lOVF9OQU1FJTBBIWVjaG8lMjAlMjRERVBMT1lNRU5UX05BTUU=",highlighted:`!echo $ENDPOINT_NAME
!echo $DEPLOYMENT_NAME`,wrap:!1}}),ie=new j({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),z=new I({props:{$$slots:{default:[aa]},$$scope:{ctx:U}}}),re=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),pe=new j({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),de=new T({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJudmlkaWElMkZwYXJha2VldC10ZHQtMC42Yi12MiUyMiUwQSUwQW1vZGVsX3VyaSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBmJTIyYXp1cmVtbCUzQSUyRiUyRnJlZ2lzdHJpZXMlMkZIdWdnaW5nRmFjZSUyRm1vZGVscyUyRiU3Qm1vZGVsX2lkLnJlcGxhY2UoJyUyRiclMkMlMjAnLScpLnJlcGxhY2UoJ18nJTJDJTIwJy0nKS5sb3dlcigpJTdEJTJGbGFiZWxzJTJGbGF0ZXN0JTIyJTBBKSUwQW1vZGVsX3VyaQ==",highlighted:`model_id = <span class="hljs-string">&quot;nvidia/parakeet-tdt-0.6b-v2&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),ce=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChmJTIyaHR0cHMlM0ElMkYlMkZnZW5lcmF0ZS1henVyZW1sLXVybHMuYXp1cmV3ZWJzaXRlcy5uZXQlMkZhcGklMkZnZW5lcmF0ZSUzRm1vZGVsSWQlM0QlN0Jtb2RlbF9pZCU3RCUyMiklMEFpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwISUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiU1QiU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTNEJTdEJTVEJTIwJTdCbW9kZWxfaWQlM0QlN0QlMjBub3QlMjBhdmFpbGFibGUlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwQ29sbGVjdGlvbiUyMGluJTIwQXp1cmUlMjBNTCUyME1vZGVsJTIwQ2F0YWxvZyUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">import</span> requests

response = requests.get(<span class="hljs-string">f&quot;https://generate-azureml-urls.azurewebsites.net/api/generate?modelId=<span class="hljs-subst">{model_id}</span>&quot;</span>)
<span class="hljs-keyword">if</span> response.status_code != <span class="hljs-number">200</span>:
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;[{response.status_code=}] {model_id=} not available on the Hugging Face Collection in Azure ML Model Catalog&quot;</span>
    )`,wrap:!1}}),E=new I({props:{warning:!0,$$slots:{default:[sa]},$$scope:{ctx:U}}}),ge=new T({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Te=new T({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),Z=new I({props:{$$slots:{default:[ia]},$$scope:{ctx:U}}}),be=new T({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),R=new I({props:{$$slots:{default:[oa]},$$scope:{ctx:U}}}),Ae=new j({props:{title:"Send requests to the Azure AI Endpoint",local:"send-requests-to-the-azure-ai-endpoint",headingTag:"h2"}}),_=new I({props:{warning:!0,$$slots:{default:[ra]},$$scope:{ctx:U}}}),ke=new T({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmk=",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri`,wrap:!1}}),Ee=new T({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmRsZGF0YS1wdWJsaWMuczMudXMtZWFzdC0yLmFtYXpvbmF3cy5jb20lMkYyMDg2LTE0OTIyMC0wMDMzLndhdg==",highlighted:'!wget https://dldata-public.s3.us-east-<span class="hljs-number">2.</span>amazonaws.com/<span class="hljs-number">2086</span>-<span class="hljs-number">149220</span>-<span class="hljs-number">0033.</span>wav',wrap:!1}}),Ze=new j({props:{title:"Python requests",local:"python-requests",headingTag:"h3"}}),_e=new T({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBYXVkaW9fZmlsZSUyMCUzRCUyMEJ5dGVzSU8ob3BlbiglMjIyMDg2LTE0OTIyMC0wMDMzLndhdiUyMiUyQyUyMCUyMnJiJTIyKS5yZWFkKCkpJTBBYXVkaW9fZmlsZS5uYW1lJTIwJTNEJTIwJTIyMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QmFwaV9rZXklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlMjIlM0ElMjBvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGZpbGVzJTNEJTdCJTIyZmlsZSUyMiUzQSUyMChhdWRpb19maWxlLm5hbWUlMkMlMjBhdWRpb19maWxlJTJDJTIwJTIyYXVkaW8lMkZ3YXYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCU3QiUyMm1vZGVsJTIyJTNBJTIwbW9kZWxfaWQlN0QlMkMlMEEpJTBBcHJpbnQocmVzcG9uc2UuanNvbigpKSUwQSUyMyUyMCU3Qid0ZXh0JyUzQSUyMCUyMldlbGwlMkMlMjBJJTIwZG9uJ3QlMjB3aXNoJTIwdG8lMjBzZWUlMjBpdCUyMGFueSUyMG1vcmUlMkMlMjBvYnNlcnZlZCUyMFBoZWJlJTJDJTIwdHVybmluZyUyMGF3YXklMjBoZXIlMjBleWVzLiUyMEl0JTIwaXMlMjBjZXJ0YWlubHklMjB2ZXJ5JTIwbGlrZSUyMHRoZSUyMG9sZCUyMHBvcnRyYWl0LiUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">import</span> requests

audio_file = BytesIO(<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read())
audio_file.name = <span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>

response = requests.post(
    api_url,
    headers={
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{api_key}</span>&quot;</span>,
        <span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    },
    files={<span class="hljs-string">&quot;file&quot;</span>: (audio_file.name, audio_file, <span class="hljs-string">&quot;audio/wav&quot;</span>)},
    data={<span class="hljs-string">&quot;model&quot;</span>: model_id},
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;text&#x27;: &quot;Well, I don&#x27;t wish to see it any more, observed Phebe, turning away her eyes. It is certainly very like the old portrait.&quot;}</span>`,wrap:!1}}),Ve=new j({props:{title:"OpenAI Python SDK",local:"openai-python-sdk",headingTag:"h3"}}),Le=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG9wZW5haSUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install openai --upgrade --quiet",wrap:!1}}),Fe=new T({props:{code:"YXBpX3VybCUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldChvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnNjb3JpbmdfdXJpLnJlcGxhY2UoJTIyJTJGYXVkaW8lMkZ0cmFuc2NyaXB0aW9ucyUyMiUyQyUyMCUyMiUyMik=",highlighted:'api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/audio/transcriptions&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)',wrap:!1}}),V=new I({props:{$$slots:{default:[pa]},$$scope:{ctx:U}}}),Ge=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX2NsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRGFwaV91cmwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEYXBpX2tleSUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHRfaGVhZGVycyUzRCU3QiUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUyMiUzQSUyMG9zLmdldGVudiglMjJERVBMT1lNRU5UX05BTUUlMjIpJTdEJTJDJTBBKSUwQSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBvcGVuYWlfY2xpZW50LmF1ZGlvLnRyYW5zY3JpcHRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZmlsZSUzRG9wZW4oJTIyMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjIlMkMlMjAlMjJyYiUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9mb3JtYXQlM0QlMjJqc29uJTIyJTJDJTBBKSUwQXByaW50KHRyYW5zY3JpcHRpb24udGV4dCklMEElMjMlMjBXZWxsJTJDJTIwSSUyMGRvbid0JTIwd2lzaCUyMHRvJTIwc2VlJTIwaXQlMjBhbnklMjBtb3JlJTJDJTIwb2JzZXJ2ZWQlMjBQaGViZSUyQyUyMHR1cm5pbmclMjBhd2F5JTIwaGVyJTIwZXllcy4lMjBJdCUyMGlzJTIwY2VydGFpbmx5JTIwdmVyeSUyMGxpa2UlMjB0aGUlMjBvbGQlMjBwb3J0cmFpdC4=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)

transcription = openai_client.audio.transcriptions.create(
    model=model_id,
    file=<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>),
    response_format=<span class="hljs-string">&quot;json&quot;</span>,
)
<span class="hljs-built_in">print</span>(transcription.text)
<span class="hljs-comment"># Well, I don&#x27;t wish to see it any more, observed Phebe, turning away her eyes. It is certainly very like the old portrait.</span>`,wrap:!1}}),Qe=new j({props:{title:"cURL",local:"curl",headingTag:"h3"}}),qe=new T({props:{code:"b3MuZW52aXJvbiU1QiUyMkFQSV9VUkwlMjIlNUQlMjAlM0QlMjBhcGlfdXJsJTBBb3MuZW52aXJvbiU1QiUyMkFQSV9LRVklMjIlNUQlMjAlM0QlMjBhcGlfa2V5",highlighted:`os.environ[<span class="hljs-string">&quot;API_URL&quot;</span>] = api_url
os.environ[<span class="hljs-string">&quot;API_KEY&quot;</span>] = api_key`,wrap:!1}}),xe=new T({props:{code:"IWN1cmwlMjAtc1MlMjAlMjRBUElfVVJMJTJGYXVkaW8lMkZ0cmFuc2NyaXB0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCUyNEFQSV9LRVklMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUzQSUyMCUyNERFUExPWU1FTlRfTkFNRSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwbXVsdGlwYXJ0JTJGZm9ybS1kYXRhJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUYlMjBmaWxlJTNEJTQwMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjAlNUMlMEElMjAlMjAlMjAlMjAtRiUyMG1vZGVsJTNEbnZpZGlhJTJGcGFyYWtlZXQtdGR0LTAuNmItdjI=",highlighted:`!curl -sS $API_URL/audio/transcriptions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer $API_KEY&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: $DEPLOYMENT_NAME&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: multipart/form-data&quot;</span> \\
    -F file=@<span class="hljs-number">2086</span>-<span class="hljs-number">149220</span>-<span class="hljs-number">0033.</span>wav \\
    -F model=nvidia/parakeet-tdt-<span class="hljs-number">0.6</span>b-v2`,wrap:!1}}),Pe=new T({props:{code:"Y3VybCUyMC1zUyUyMCUzQ0FQSV9VUkwlM0UlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlM0NQUklNQVJZX0tFWSUzRSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyYXp1cmVtbC1tb2RlbC1kZXBsb3ltZW50JTNBJTIwJTI0REVQTE9ZTUVOVF9OQU1FJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJDb250ZW50LVR5cGUlM0ElMjBtdWx0aXBhcnQlMkZmb3JtLWRhdGElMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtRiUyMGZpbGUlM0QlNDAyMDg2LTE0OTIyMC0wMDMzLndhdiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1GJTIwbW9kZWwlM0RudmlkaWElMkZwYXJha2VldC10ZHQtMC42Yi12MiUyMCU3QyUyMGpx",highlighted:`curl -sS &lt;API_URL&gt; \\
    -H <span class="hljs-string">&quot;Authorization: Bearer &lt;PRIMARY_KEY&gt;&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: <span class="hljs-variable">$DEPLOYMENT_NAME</span>&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: multipart/form-data&quot;</span> \\
    -F file=@2086-149220-0033.wav \\
    -F model=nvidia/parakeet-tdt-0.6b-v2 | jq`,wrap:!1}}),Ye=new j({props:{title:"Gradio",local:"gradio",headingTag:"h3"}}),B=new I({props:{$$slots:{default:[ua]},$$scope:{ctx:U}}}),Oe=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install gradio --upgrade --quiet",wrap:!1}}),Ke=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;API_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;API_KEY&quot;</span>),
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio: Path, temperature: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> openai_client.audio.transcriptions.create(
        model=model_id,
        file=<span class="hljs-built_in">open</span>(audio, <span class="hljs-string">&quot;rb&quot;</span>),
        temperature=temperature,
        response_format=<span class="hljs-string">&quot;text&quot;</span>,
    )


demo = gr.Interface(
    fn=transcribe,
    inputs=[
        <span class="hljs-comment"># https://www.gradio.app/docs/gradio/audio</span>
        gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, streaming=<span class="hljs-literal">False</span>, label=<span class="hljs-string">&quot;Upload or Record Audio&quot;</span>),
        gr.Slider(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, value=<span class="hljs-number">0.0</span>, step=<span class="hljs-number">0.1</span>, label=<span class="hljs-string">&quot;Temperature&quot;</span>),
    ],
    outputs=gr.Textbox(label=<span class="hljs-string">&quot;Transcribed Text&quot;</span>),
    title=<span class="hljs-string">&quot;NVIDIA Parakeet on Azure AI&quot;</span>,
    description=<span class="hljs-string">&quot;Upload or record audio and get the transcribed text using NVIDIA Parakeet on Azure AI via the OpenAI&#x27;s Transcription API.&quot;</span>,
)

demo.launch()`,wrap:!1}}),tt=new j({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),nt=new T({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),at=new j({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),L=new I({props:{$$slots:{default:[da]},$$scope:{ctx:U}}}),ot=new ta({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/deploy-nvidia-parakeet-asr.mdx"}}),{c(){i=r("meta"),f=a(),o=r("p"),w=a(),d(J.$$.fragment),$=a(),A=r("p"),A.textContent=W,g=a(),b=r("p"),b.textContent=xl,pt=a(),ut=r("hr"),dt=a(),F=r("p"),F.innerHTML=Xl,Mt=a(),N=r("p"),N.innerHTML=Pl,mt=a(),S=r("p"),S.textContent=Yl,ct=a(),G=r("ul"),G.innerHTML=Dl,ht=a(),Q=r("p"),Q.innerHTML=Ol,yt=a(),H=r("p"),H.innerHTML=Kl,ft=a(),q=r("p"),q.innerHTML=en,wt=a(),d(C.$$.fragment),gt=a(),d(x.$$.fragment),Tt=a(),X=r("p"),X.innerHTML=tn,Ut=a(),P=r("ul"),P.innerHTML=ln,bt=a(),Y=r("p"),Y.innerHTML=nn,Jt=a(),d(D.$$.fragment),$t=a(),O=r("p"),O.innerHTML=an,jt=a(),d(K.$$.fragment),At=a(),ee=r("p"),ee.innerHTML=sn,It=a(),te=r("p"),te.textContent=on,vt=a(),d(le.$$.fragment),Ct=a(),ne=r("p"),ne.textContent=rn,kt=a(),d(k.$$.fragment),zt=a(),d(ae.$$.fragment),Et=a(),d(se.$$.fragment),Zt=a(),d(ie.$$.fragment),Rt=a(),oe=r("p"),oe.innerHTML=pn,_t=a(),d(z.$$.fragment),Vt=a(),d(re.$$.fragment),Bt=a(),d(pe.$$.fragment),Lt=a(),ue=r("p"),ue.innerHTML=un,Wt=a(),d(de.$$.fragment),Ft=a(),Me=r("p"),Me.innerHTML=dn,Nt=a(),me=r("p"),me.textContent=Mn,St=a(),d(ce.$$.fragment),Gt=a(),he=r("p"),he.innerHTML=mn,Qt=a(),ye=r("p"),ye.innerHTML=cn,Ht=a(),fe=r("p"),fe.innerHTML=hn,qt=a(),we=r("p"),we.innerHTML=yn,xt=a(),d(E.$$.fragment),Xt=a(),d(ge.$$.fragment),Pt=a(),d(Te.$$.fragment),Yt=a(),Ue=r("p"),Ue.innerHTML=fn,Dt=a(),d(Z.$$.fragment),Ot=a(),d(be.$$.fragment),Kt=a(),Je=r("p"),Je.innerHTML=wn,el=a(),d(R.$$.fragment),tl=a(),$e=r("p"),$e.innerHTML=gn,ll=a(),je=r("p"),je.innerHTML=Tn,nl=a(),d(Ae.$$.fragment),al=a(),Ie=r("p"),Ie.innerHTML=Un,sl=a(),ve=r("p"),ve.innerHTML=bn,il=a(),d(_.$$.fragment),ol=a(),Ce=r("p"),Ce.innerHTML=Jn,rl=a(),d(ke.$$.fragment),pl=a(),ze=r("p"),ze.innerHTML=$n,ul=a(),d(Ee.$$.fragment),dl=a(),d(Ze.$$.fragment),Ml=a(),Re=r("p"),Re.innerHTML=jn,ml=a(),d(_e.$$.fragment),cl=a(),d(Ve.$$.fragment),hl=a(),Be=r("p"),Be.innerHTML=An,yl=a(),d(Le.$$.fragment),fl=a(),We=r("p"),We.innerHTML=In,wl=a(),d(Fe.$$.fragment),gl=a(),d(V.$$.fragment),Tl=a(),Ne=r("p"),Ne.innerHTML=vn,Ul=a(),Se=r("p"),Se.innerHTML=Cn,bl=a(),d(Ge.$$.fragment),Jl=a(),d(Qe.$$.fragment),$l=a(),He=r("p"),He.innerHTML=kn,jl=a(),d(qe.$$.fragment),Al=a(),d(xe.$$.fragment),Il=a(),Xe=r("p"),Xe.textContent=zn,vl=a(),d(Pe.$$.fragment),Cl=a(),d(Ye.$$.fragment),kl=a(),De=r("p"),De.innerHTML=En,zl=a(),d(B.$$.fragment),El=a(),d(Oe.$$.fragment),Zl=a(),d(Ke.$$.fragment),Rl=a(),et=r("p"),et.innerHTML=Zn,_l=a(),d(tt.$$.fragment),Vl=a(),lt=r("p"),lt.textContent=Rn,Bl=a(),d(nt.$$.fragment),Ll=a(),d(at.$$.fragment),Wl=a(),st=r("p"),st.textContent=_n,Fl=a(),it=r("p"),it.innerHTML=Vn,Nl=a(),Sl=r("hr"),Gl=a(),d(L.$$.fragment),Ql=a(),d(ot.$$.fragment),Hl=a(),rt=r("p"),this.h()},l(e){const t=Kn("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(l),f=s(e),o=p(e,"P",{}),xn(o).forEach(l),w=s(e),M(J.$$.fragment,e),$=s(e),A=p(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-qcuv86"&&(A.textContent=W),g=s(e),b=p(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-qzlp4s"&&(b.textContent=xl),pt=s(e),ut=p(e,"HR",{}),dt=s(e),F=p(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-ygi5er"&&(F.innerHTML=Xl),Mt=s(e),N=p(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-17a4trs"&&(N.innerHTML=Pl),mt=s(e),S=p(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1mr2e6"&&(S.textContent=Yl),ct=s(e),G=p(e,"UL",{"data-svelte-h":!0}),u(G)!=="svelte-eb82nc"&&(G.innerHTML=Dl),ht=s(e),Q=p(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-10zpqm2"&&(Q.innerHTML=Ol),yt=s(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1dzfint"&&(H.innerHTML=Kl),ft=s(e),q=p(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1gli84r"&&(q.innerHTML=en),wt=s(e),M(C.$$.fragment,e),gt=s(e),M(x.$$.fragment,e),Tt=s(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-dnkqle"&&(X.innerHTML=tn),Ut=s(e),P=p(e,"UL",{"data-svelte-h":!0}),u(P)!=="svelte-dlzkka"&&(P.innerHTML=ln),bt=s(e),Y=p(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1myp7ii"&&(Y.innerHTML=nn),Jt=s(e),M(D.$$.fragment,e),$t=s(e),O=p(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-bexho5"&&(O.innerHTML=an),jt=s(e),M(K.$$.fragment,e),At=s(e),ee=p(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1v277rw"&&(ee.innerHTML=sn),It=s(e),te=p(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-11uslf2"&&(te.textContent=on),vt=s(e),M(le.$$.fragment,e),Ct=s(e),ne=p(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1wrtw53"&&(ne.textContent=rn),kt=s(e),M(k.$$.fragment,e),zt=s(e),M(ae.$$.fragment,e),Et=s(e),M(se.$$.fragment,e),Zt=s(e),M(ie.$$.fragment,e),Rt=s(e),oe=p(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-1v2xdwc"&&(oe.innerHTML=pn),_t=s(e),M(z.$$.fragment,e),Vt=s(e),M(re.$$.fragment,e),Bt=s(e),M(pe.$$.fragment,e),Lt=s(e),ue=p(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-thijw5"&&(ue.innerHTML=un),Wt=s(e),M(de.$$.fragment,e),Ft=s(e),Me=p(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1hy4n1w"&&(Me.innerHTML=dn),Nt=s(e),me=p(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1kr526q"&&(me.textContent=Mn),St=s(e),M(ce.$$.fragment,e),Gt=s(e),he=p(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1qpei6p"&&(he.innerHTML=mn),Qt=s(e),ye=p(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1kte4k3"&&(ye.innerHTML=cn),Ht=s(e),fe=p(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1p3ugrp"&&(fe.innerHTML=hn),qt=s(e),we=p(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1weda3f"&&(we.innerHTML=yn),xt=s(e),M(E.$$.fragment,e),Xt=s(e),M(ge.$$.fragment,e),Pt=s(e),M(Te.$$.fragment,e),Yt=s(e),Ue=p(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-oe1xgq"&&(Ue.innerHTML=fn),Dt=s(e),M(Z.$$.fragment,e),Ot=s(e),M(be.$$.fragment,e),Kt=s(e),Je=p(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1lo3ppe"&&(Je.innerHTML=wn),el=s(e),M(R.$$.fragment,e),tl=s(e),$e=p(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1v1bv0"&&($e.innerHTML=gn),ll=s(e),je=p(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-kgt4mo"&&(je.innerHTML=Tn),nl=s(e),M(Ae.$$.fragment,e),al=s(e),Ie=p(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-11ec10k"&&(Ie.innerHTML=Un),sl=s(e),ve=p(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1l8sq3y"&&(ve.innerHTML=bn),il=s(e),M(_.$$.fragment,e),ol=s(e),Ce=p(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-fhm0e5"&&(Ce.innerHTML=Jn),rl=s(e),M(ke.$$.fragment,e),pl=s(e),ze=p(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-1x7qtcm"&&(ze.innerHTML=$n),ul=s(e),M(Ee.$$.fragment,e),dl=s(e),M(Ze.$$.fragment,e),Ml=s(e),Re=p(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-31zkgr"&&(Re.innerHTML=jn),ml=s(e),M(_e.$$.fragment,e),cl=s(e),M(Ve.$$.fragment,e),hl=s(e),Be=p(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-1cwwxgq"&&(Be.innerHTML=An),yl=s(e),M(Le.$$.fragment,e),fl=s(e),We=p(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-hibrsl"&&(We.innerHTML=In),wl=s(e),M(Fe.$$.fragment,e),gl=s(e),M(V.$$.fragment,e),Tl=s(e),Ne=p(e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1t4oej1"&&(Ne.innerHTML=vn),Ul=s(e),Se=p(e,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-1t8h4hs"&&(Se.innerHTML=Cn),bl=s(e),M(Ge.$$.fragment,e),Jl=s(e),M(Qe.$$.fragment,e),$l=s(e),He=p(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-6rxgjf"&&(He.innerHTML=kn),jl=s(e),M(qe.$$.fragment,e),Al=s(e),M(xe.$$.fragment,e),Il=s(e),Xe=p(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-g40hbk"&&(Xe.textContent=zn),vl=s(e),M(Pe.$$.fragment,e),Cl=s(e),M(Ye.$$.fragment,e),kl=s(e),De=p(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-84t7ko"&&(De.innerHTML=En),zl=s(e),M(B.$$.fragment,e),El=s(e),M(Oe.$$.fragment,e),Zl=s(e),M(Ke.$$.fragment,e),Rl=s(e),et=p(e,"P",{"data-svelte-h":!0}),u(et)!=="svelte-hn6aoa"&&(et.innerHTML=Zn),_l=s(e),M(tt.$$.fragment,e),Vl=s(e),lt=p(e,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-rntoeu"&&(lt.textContent=Rn),Bl=s(e),M(nt.$$.fragment,e),Ll=s(e),M(at.$$.fragment,e),Wl=s(e),st=p(e,"P",{"data-svelte-h":!0}),u(st)!=="svelte-19mlnr1"&&(st.textContent=_n),Fl=s(e),it=p(e,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1nopug0"&&(it.innerHTML=Vn),Nl=s(e),Sl=p(e,"HR",{}),Gl=s(e),M(L.$$.fragment,e),Ql=s(e),M(ot.$$.fragment,e),Hl=s(e),rt=p(e,"P",{}),xn(rt).forEach(l),this.h()},h(){Xn(i,"name","hf:doc:metadata"),Xn(i,"content",ma)},m(e,t){ea(document.head,i),n(e,f,t),n(e,o,t),n(e,w,t),m(J,e,t),n(e,$,t),n(e,A,t),n(e,g,t),n(e,b,t),n(e,pt,t),n(e,ut,t),n(e,dt,t),n(e,F,t),n(e,Mt,t),n(e,N,t),n(e,mt,t),n(e,S,t),n(e,ct,t),n(e,G,t),n(e,ht,t),n(e,Q,t),n(e,yt,t),n(e,H,t),n(e,ft,t),n(e,q,t),n(e,wt,t),m(C,e,t),n(e,gt,t),m(x,e,t),n(e,Tt,t),n(e,X,t),n(e,Ut,t),n(e,P,t),n(e,bt,t),n(e,Y,t),n(e,Jt,t),m(D,e,t),n(e,$t,t),n(e,O,t),n(e,jt,t),m(K,e,t),n(e,At,t),n(e,ee,t),n(e,It,t),n(e,te,t),n(e,vt,t),m(le,e,t),n(e,Ct,t),n(e,ne,t),n(e,kt,t),m(k,e,t),n(e,zt,t),m(ae,e,t),n(e,Et,t),m(se,e,t),n(e,Zt,t),m(ie,e,t),n(e,Rt,t),n(e,oe,t),n(e,_t,t),m(z,e,t),n(e,Vt,t),m(re,e,t),n(e,Bt,t),m(pe,e,t),n(e,Lt,t),n(e,ue,t),n(e,Wt,t),m(de,e,t),n(e,Ft,t),n(e,Me,t),n(e,Nt,t),n(e,me,t),n(e,St,t),m(ce,e,t),n(e,Gt,t),n(e,he,t),n(e,Qt,t),n(e,ye,t),n(e,Ht,t),n(e,fe,t),n(e,qt,t),n(e,we,t),n(e,xt,t),m(E,e,t),n(e,Xt,t),m(ge,e,t),n(e,Pt,t),m(Te,e,t),n(e,Yt,t),n(e,Ue,t),n(e,Dt,t),m(Z,e,t),n(e,Ot,t),m(be,e,t),n(e,Kt,t),n(e,Je,t),n(e,el,t),m(R,e,t),n(e,tl,t),n(e,$e,t),n(e,ll,t),n(e,je,t),n(e,nl,t),m(Ae,e,t),n(e,al,t),n(e,Ie,t),n(e,sl,t),n(e,ve,t),n(e,il,t),m(_,e,t),n(e,ol,t),n(e,Ce,t),n(e,rl,t),m(ke,e,t),n(e,pl,t),n(e,ze,t),n(e,ul,t),m(Ee,e,t),n(e,dl,t),m(Ze,e,t),n(e,Ml,t),n(e,Re,t),n(e,ml,t),m(_e,e,t),n(e,cl,t),m(Ve,e,t),n(e,hl,t),n(e,Be,t),n(e,yl,t),m(Le,e,t),n(e,fl,t),n(e,We,t),n(e,wl,t),m(Fe,e,t),n(e,gl,t),m(V,e,t),n(e,Tl,t),n(e,Ne,t),n(e,Ul,t),n(e,Se,t),n(e,bl,t),m(Ge,e,t),n(e,Jl,t),m(Qe,e,t),n(e,$l,t),n(e,He,t),n(e,jl,t),m(qe,e,t),n(e,Al,t),m(xe,e,t),n(e,Il,t),n(e,Xe,t),n(e,vl,t),m(Pe,e,t),n(e,Cl,t),m(Ye,e,t),n(e,kl,t),n(e,De,t),n(e,zl,t),m(B,e,t),n(e,El,t),m(Oe,e,t),n(e,Zl,t),m(Ke,e,t),n(e,Rl,t),n(e,et,t),n(e,_l,t),m(tt,e,t),n(e,Vl,t),n(e,lt,t),n(e,Bl,t),m(nt,e,t),n(e,Ll,t),m(at,e,t),n(e,Wl,t),n(e,st,t),n(e,Fl,t),n(e,it,t),n(e,Nl,t),n(e,Sl,t),n(e,Gl,t),m(L,e,t),n(e,Ql,t),m(ot,e,t),n(e,Hl,t),n(e,rt,t),ql=!0},p(e,[t]){const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),C.$set(Bn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),k.$set(Ln);const Wn={};t&2&&(Wn.$$scope={dirty:t,ctx:e}),z.$set(Wn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),E.$set(Fn);const Nn={};t&2&&(Nn.$$scope={dirty:t,ctx:e}),Z.$set(Nn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),R.$set(Sn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),_.$set(Gn);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),V.$set(Qn);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),B.$set(Hn);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),L.$set(qn)},i(e){ql||(c(J.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(le.$$.fragment,e),c(k.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(z.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(E.$$.fragment,e),c(ge.$$.fragment,e),c(Te.$$.fragment,e),c(Z.$$.fragment,e),c(be.$$.fragment,e),c(R.$$.fragment,e),c(Ae.$$.fragment,e),c(_.$$.fragment,e),c(ke.$$.fragment,e),c(Ee.$$.fragment,e),c(Ze.$$.fragment,e),c(_e.$$.fragment,e),c(Ve.$$.fragment,e),c(Le.$$.fragment,e),c(Fe.$$.fragment,e),c(V.$$.fragment,e),c(Ge.$$.fragment,e),c(Qe.$$.fragment,e),c(qe.$$.fragment,e),c(xe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ye.$$.fragment,e),c(B.$$.fragment,e),c(Oe.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(at.$$.fragment,e),c(L.$$.fragment,e),c(ot.$$.fragment,e),ql=!0)},o(e){h(J.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(le.$$.fragment,e),h(k.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(z.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(E.$$.fragment,e),h(ge.$$.fragment,e),h(Te.$$.fragment,e),h(Z.$$.fragment,e),h(be.$$.fragment,e),h(R.$$.fragment,e),h(Ae.$$.fragment,e),h(_.$$.fragment,e),h(ke.$$.fragment,e),h(Ee.$$.fragment,e),h(Ze.$$.fragment,e),h(_e.$$.fragment,e),h(Ve.$$.fragment,e),h(Le.$$.fragment,e),h(Fe.$$.fragment,e),h(V.$$.fragment,e),h(Ge.$$.fragment,e),h(Qe.$$.fragment,e),h(qe.$$.fragment,e),h(xe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ye.$$.fragment,e),h(B.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(nt.$$.fragment,e),h(at.$$.fragment,e),h(L.$$.fragment,e),h(ot.$$.fragment,e),ql=!1},d(e){e&&(l(f),l(o),l(w),l($),l(A),l(g),l(b),l(pt),l(ut),l(dt),l(F),l(Mt),l(N),l(mt),l(S),l(ct),l(G),l(ht),l(Q),l(yt),l(H),l(ft),l(q),l(wt),l(gt),l(Tt),l(X),l(Ut),l(P),l(bt),l(Y),l(Jt),l($t),l(O),l(jt),l(At),l(ee),l(It),l(te),l(vt),l(Ct),l(ne),l(kt),l(zt),l(Et),l(Zt),l(Rt),l(oe),l(_t),l(Vt),l(Bt),l(Lt),l(ue),l(Wt),l(Ft),l(Me),l(Nt),l(me),l(St),l(Gt),l(he),l(Qt),l(ye),l(Ht),l(fe),l(qt),l(we),l(xt),l(Xt),l(Pt),l(Yt),l(Ue),l(Dt),l(Ot),l(Kt),l(Je),l(el),l(tl),l($e),l(ll),l(je),l(nl),l(al),l(Ie),l(sl),l(ve),l(il),l(ol),l(Ce),l(rl),l(pl),l(ze),l(ul),l(dl),l(Ml),l(Re),l(ml),l(cl),l(hl),l(Be),l(yl),l(fl),l(We),l(wl),l(gl),l(Tl),l(Ne),l(Ul),l(Se),l(bl),l(Jl),l($l),l(He),l(jl),l(Al),l(Il),l(Xe),l(vl),l(Cl),l(kl),l(De),l(zl),l(El),l(Zl),l(Rl),l(et),l(_l),l(Vl),l(lt),l(Bl),l(Ll),l(Wl),l(st),l(Fl),l(it),l(Nl),l(Sl),l(Gl),l(Ql),l(Hl),l(rt)),l(i),y(J,e),y(C,e),y(x,e),y(D,e),y(K,e),y(le,e),y(k,e),y(ae,e),y(se,e),y(ie,e),y(z,e),y(re,e),y(pe,e),y(de,e),y(ce,e),y(E,e),y(ge,e),y(Te,e),y(Z,e),y(be,e),y(R,e),y(Ae,e),y(_,e),y(ke,e),y(Ee,e),y(Ze,e),y(_e,e),y(Ve,e),y(Le,e),y(Fe,e),y(V,e),y(Ge,e),y(Qe,e),y(qe,e),y(xe,e),y(Pe,e),y(Ye,e),y(B,e),y(Oe,e),y(Ke,e),y(tt,e),y(nt,e),y(at,e),y(L,e),y(ot,e)}}}const ma='{"title":"Deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) on Azure AI","local":"deploy-nvidia-parakeet-for-automatic-speech-recognition-asr-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Send requests to the Azure AI Endpoint","local":"send-requests-to-the-azure-ai-endpoint","sections":[{"title":"Python requests","local":"python-requests","sections":[],"depth":3},{"title":"OpenAI Python SDK","local":"openai-python-sdk","sections":[],"depth":3},{"title":"cURL","local":"curl","sections":[],"depth":3},{"title":"Gradio","local":"gradio","sections":[],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ca(U){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends Dn{constructor(i){super(),On(this,i,ca,Ma,Pn,{})}}export{Ta as component};
