import{s as Xl,o as Pl,n as I}from"../chunks/scheduler.b108d059.js";import{S as Yl,i as Dl,g as r,s as a,r as d,A as Ol,h as p,f as n,c as o,j as Sl,u as c,x as u,k as xl,y as Kl,a as l,v as m,d as M,t as h,w as y}from"../chunks/index.008de539.js";import{T as $}from"../chunks/Tip.aeb15ab7.js";import{C as J}from"../chunks/CodeBlock.7b00c886.js";import{H as C,E as es}from"../chunks/getInferenceSnippets.79dc142e.js";function ts(T){let s,f='Note that this example will go through the Python SDK / Azure CLI programmatic deployment, if you’d rather prefer using the one-click deployment experience, please check <a href="https://huggingface.co/docs/microsoft-azure/guides/one-click-deployment-azure-ml" rel="nofollow">One-click deployments from the Hugging Face Hub on Azure ML</a>. But note that when deploying from the Hugging Face Hub, the endpoint + deployment will be created within Azure ML instead of within Azure AI Foundry, whereas this example focuses on Azure AI Foundry Hub deployments (also made available on Azure ML, but not the other way around).';return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-147duvx"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ns(T){let s,f="Note that you can select any LLM available on the Hugging Face Hub with the “Deploy to AzureML” option enabled, or directly select any of the LLMs available in either the Azure ML or Azure AI Foundry Hub Model Catalog under the “HuggingFace” collection (note that for Azure AI Foundry the Hugging Face Collection will only be available for Hub-based projects).";return{c(){s=r("p"),s.textContent=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1a5zyti"&&(s.textContent=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ls(T){let s,f="Note that endpoint names must to be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){s=r("p"),s.textContent=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-zrbum5"&&(s.textContent=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ss(T){let s,f="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fg1top"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function as(T){let s,f='Since for some models and inference engines you need to run those on a GPU-accelerated instance, you may need to request a quota increase for some of the supported instances as per the model you want to deploy. Also, keep into consideration that each model comes with a list of all the supported instances, being the recommended one for each tier the lower instance in terms of available VRAM. Read more about quota increase requests for Azure ML at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-3styqc"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function os(T){let s,f="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){s=r("p"),s.textContent=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-13fiegq"&&(s.textContent=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function is(T){let s,f="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){s=r("p"),s.textContent=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1q2pvid"&&(s.textContent=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function rs(T){let s,f="Note that below only some of the options are listed, but you can send requests to the deployed endpoint as long as you send the HTTP requests with the <code>azureml-model-deployment</code> header set to the name of the Azure AI Deployment (not the Endpoint), and have the necessary authentication token / key to send requests to the given endpoint; then you can send HTTP request to all the routes that the backend engine is exposing, not only to the scoring route.";return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1fmd54g"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ps(T){let s,f='Support for Hugging Face models via <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ai/azure-ai-inference" rel="nofollow"><code>azure-ai-inference</code> Python SDK</a> is still a work in progress, but that will be included soon and set as the recommended inference method, stay tuned!';return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1c2r502"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function us(T){let s,f="Note that the Azure ML Python SDK requires a path to a JSON file when invoking the endpoints, meaning that whatever payload you want to send to the endpoint will need to be first converted into a JSON file, whilst that only applies to the requests sent via the Azure ML Python SDK.";return{c(){s=r("p"),s.textContent=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1tlguht"&&(s.textContent=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ds(T){let s,f="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",i,w,b,j,A="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",G;return w=new J({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/v1&quot;</span>',wrap:!1}}),{c(){s=r("p"),s.textContent=f,i=a(),d(w.$$.fragment),b=a(),j=r("p"),j.textContent=A},l(g){s=p(g,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ufs9gh"&&(s.textContent=f),i=o(g),c(w.$$.fragment,g),b=o(g),j=p(g,"P",{"data-svelte-h":!0}),u(j)!=="svelte-vz1qru"&&(j.textContent=A)},m(g,U){l(g,s,U),l(g,i,U),m(w,g,U),l(g,b,U),l(g,j,U),G=!0},p:I,i(g){G||(M(w.$$.fragment,g),G=!0)},o(g){h(w.$$.fragment,g),G=!1},d(g){g&&(n(s),n(i),n(b),n(j)),y(w,g)}}}function cs(T){let s,f='Ideally you could deploy the Gradio Chat Interface connected to your Azure ML Managed Online Endpoint as an Azure Container App as described in <a href="https://learn.microsoft.com/en-us/azure/container-apps/tutorial-deploy-from-code?tabs=python" rel="nofollow">Tutorial: Build and deploy from source code to Azure Container Apps</a>. If you’d like us to show you how to do it for Gradio in particular, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue requesting it</a>.';return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ncfpy5"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function ms(T){let s,f='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/deploy-large-language-models/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){s=r("p"),s.innerHTML=f},l(i){s=p(i,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1dt9wzm"&&(s.innerHTML=f)},m(i,w){l(i,s,w)},p:I,d(i){i&&n(s)}}}function Ms(T){let s,f,i,w,b,j,A,G="This example showcases how to deploy a Large Language Model (LLM) from the Hugging Face Collection in Azure AI Foundry Hub as an Azure ML Managed Online Endpoint, powered by Hugging Face’s Text Generation Inference (TGI). Additionally, this example also showcases how to run inference with both the Azure ML Python SDK, the OpenAI Python SDK, and even how to locally run a Gradio application for chat completion.",g,U,rt,W,Sn="TL;DR Text Generation Inference (TGI) is a solution developed by Hugging Face for deploying and serving LLMs and VLMs with high performance text generation. Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",pt,ut,dt,N,xn='This example will specifically deploy <a href="https://huggingface.co/Qwen/Qwen2.5-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-32B-Instruct</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/qwen-qwen2.5-32b-instruct/version/1/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/qwen-qwen2.5-32b-instruct/version/1/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',ct,F,Xn="Qwen2.5 is one of the latest series of Qwen large language models, bringing the following improvements upon Qwen2 such as:",mt,H,Pn="<li>Significantly more knowledge and has greatly improved capabilities in coding and mathematics, thanks to our specialized expert models in these domains.</li> <li>Significant improvements in instruction following, generating long texts (over 8K tokens), understanding structured data (e.g, tables), and generating structured outputs especially JSON. More resilient to the diversity of system prompts, enhancing role-play implementation and condition-setting for chatbots.</li> <li>Long-context Support up to 128K tokens and can generate up to 8K tokens.</li> <li>Multilingual support for over 29 languages, including Chinese, English, French, Spanish, Portuguese, German, Italian, Russian, Japanese, Korean, Vietnamese, Thai, Arabic, and more.</li>",Mt,S,Yn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-large-language-models/qwen2.5-hub.png" alt="Qwen2.5 32B Instruct on the Hugging Face Hub"/>',ht,x,Dn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-large-language-models/qwen2.5-azure-ai-foundry.png" alt="Qwen2.5 32B Instruct on Azure AI Foundry"/>',yt,X,On='For more information, make sure to check <a href="https://huggingface.co/Qwen/Qwen2.5-32B-Instruct/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a>.',ft,v,wt,P,Tt,Y,Kn='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',gt,D,el="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",Jt,O,tl='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',Ut,K,$t,ee,nl='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',It,te,bt,ne,ll='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',jt,le,sl="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",Ct,se,At,ae,al="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",vt,z,zt,oe,Et,ie,Rt,re,kt,pe,ol="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>Qwen/Qwen2.5-32B-Instruct</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",_t,E,qt,ue,Lt,de,Bt,ce,il="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/&lt;REGISTRY_NAME&gt;/models/&lt;MODEL_ID&gt;/labels/latest</code> (even if the URI contains <code>azureml</code> it’s the same as in Azure AI Foundry, since the model catalog is shared), that means that the <code>REGISTRY_NAME</code> should be set to “HuggingFace” as you intend to deploy a model from the Hugging Face Collection, and the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID, but rather the ID with hyphen replacements for both backslash (/) and underscores (_) with hyphens (-), and then into lower case, as follows:",Qt,me,Vt,Me,rl='Note that you will need to verify in advance that the URI is valid, and that the given Hugging Face Hub Model ID exists on Azure, since Hugging Face is publishing those models into their collection, meaning that some models may be available on the Hugging Face Hub but not yet on the Azure Model Catalog (you can request adding a model following the guide <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition</a>).',Zt,he,pl="Alternatively, you can use the following snippet to verify if a model is available on the Azure Model Catalog programmatically:",Gt,ye,Wt,fe,ul='Then you can create the Managed Online Endpoint specifying its name (note that the name must be unique per entire region, not only within a single subscription, resource group, workspace, etc., so it’s a nice practice to add some sort of unique name to it in case multi-region deployments are intended) via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint Python class</a>.',Nt,we,dl='Also note that by default the <code>ManagedOnlineEndpoint</code> will use the <code>key</code> authentication method, meaning that there will be a primary and secondary key that should be sent within the Authentication headers as a Bearer token; but also the <code>aml_token</code> authentication method can be used, read more about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-authenticate-online-endpoint" rel="nofollow">Authenticate clients for online endpoints</a>.',Ft,Te,cl='The deployment, created via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlinedeployment?view=azure-python" rel="nofollow">ManagedOnlineDeployment Python class</a>, will define the actual model deployment that will be exposed via the previously created endpoint. The <code>ManagedOnlineDeployment</code> will expect: the <code>model</code> i.e., the previously created URI <code>azureml://registries/HuggingFace/models/qwen-qwen2.5-32b-instruct/labels/latest</code>, the <code>endpoint_name</code>, and the instance requirements being the <code>instance_type</code> and the <code>instance_count</code>.',Ht,ge,ml='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>); in this case, a NVIDIA H100 GPU will be used i.e., <code>Standard_NC40ads_H100_v5</code>.',St,R,xt,Je,Xt,Ue,Pt,$e,Ml='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-large-language-models/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Yt,k,Dt,Ie,Ot,be,hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-large-language-models/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',Kt,_,en,je,yl='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>.',tn,Ce,fl='Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',nn,Ae,ln,ve,wl="Finally, now that the Azure AI Endpoint is deployed, you can send requests to it. In this case, since the task of the model is <code>text-generation</code> (also known as <code>chat-completion</code>) you can either use the default scoring endpoint, being <code>/generate</code> which is the standard text generation endpoint without chat capabilities (as leveraging the chat template or having an OpenAI-compatible OpenAPI interface), or alternatively just benefit from the fact that Text Generation Inference (TGI) i.e., the inference engine in which the model is running on top, exposes OpenAI-compatible routes as <code>/v1/chat/completions</code>.",sn,q,an,L,on,ze,rn,Ee,Tl='You can invoke the Azure AI Endpoint on the scoring route, in this case <code>/generate</code> (more information about it in the <code>Qwen/Qwen2.5-32B-Instruct</code> page in either <a href="https://ml.azure.com/models/qwen-qwen2.5-32b-instruct/version/1/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or <a href="https://ai.azure.com/explore/models/qwen-qwen2.5-32b-instruct/version/1/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a> catalogs), via the Azure Python SDK with the previously instantiated <code>azure.ai.ml.MLClient</code> (or instantiate a new one if working from a different session).',pn,Re,un,B,dn,ke,cn,_e,gl="Since Text Generation Inference (TGI) also exposes OpenAI-compatible routes, you can also leverage the OpenAI Python SDK to send requests to the deployed Azure AI Endpoint.",mn,qe,Mn,Le,Jl="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to first retrieve:",hn,Be,Ul="<li><code>api_url</code> with the <code>/v1</code> route (that contains the <code>v1/chat/completions</code> endpoint that the OpenAI Python SDK will send requests to)</li> <li><code>api_key</code> which is the API Key in Azure AI or the primary key in Azure ML (unless a dedicated Azure ML Token is used instead)</li>",yn,Qe,fn,Q,wn,Ve,$l="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",Tn,Ze,Il="Via the OpenAI Python SDK it can either be set within each call to <code>chat.completions.create</code> via the <code>extra_headers</code> parameter as commented below, or via the <code>default_headers</code> parameter when instantiating the <code>OpenAI</code> client (which is the recommended approach since the header needs to be present on each request, so setting it just once is preferred).",gn,Ge,Jn,We,Un,Ne,bl="Alternatively, you can also just use <code>cURL</code> to send requests to the deployed endpoint, with the <code>api_url</code> and <code>api_key</code> values programmatically retrieved in the OpenAI snippet and now set as environment variables so that <code>cURL</code> can use those, as it follows:",$n,Fe,In,He,bn,Se,jl="You can also just go to the Azure AI Endpoint in either the Azure AI Foundry under “My assets -&gt; Models + endpoints” or in the Azure ML Studio via “Endpoints”, and retrieve both the URL (note that it will default to the <code>/generate</code> endpoint, but to use the OpenAI-compatible layer you need to use the <code>/v1/chat/completions</code> endpoint instead) and the API Key values, as well as the Azure AI Deployment name for the given model, and then send the request as follows after replacing the values from Azure ML:",jn,xe,Cn,Xe,An,Pe,Cl='<a href="https://www.gradio.app/" rel="nofollow">Gradio</a> is the fastest way to demo your machine learning model with a friendly web interface so that anyone can use it. You can also leverage the OpenAI Python SDK to build a simple <code>ChatInterface</code> that you can use within the Jupyter Notebook cell where you are running it.',vn,V,zn,Ye,En,De,Al='See below an example on how to leverage Gradio’s <code>ChatInterface</code>, or find more information about it at <a href="https://www.gradio.app/docs/gradio/chatinterface" rel="nofollow">Gradio ChatInterface Docs</a>.',Rn,Oe,kn,Ke,vl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-large-language-models/azure-ml-gradio.png" alt="Gradio Chat Interface with Azure AI Endpoint"/>',_n,et,qn,tt,zl="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",Ln,nt,Bn,lt,Qn,st,El="Throughout this example you learnt how to create and configure your Azure account for Azure ML and Azure AI Foundry, how to then create a Managed Online Endpoint running an open model from the Hugging Face Collection in the Azure ML / Azure AI Foundry model catalog, how to send inference requests to it afterwards with different alternatives, how to build a simple Gradio chat interface around it, and finally, how to stop and release the resources.",Vn,at,Rl='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',Zn,Gn,Wn,Z,Nn,ot,Fn,it,Hn;return b=new C({props:{title:"Deploy Large Language Models (LLMs) on Azure AI",local:"deploy-large-language-models-llms-on-azure-ai",headingTag:"h1"}}),U=new $({props:{$$slots:{default:[ts]},$$scope:{ctx:T}}}),v=new $({props:{$$slots:{default:[ns]},$$scope:{ctx:T}}}),P=new C({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),K=new C({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),te=new J({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),se=new J({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),z=new $({props:{$$slots:{default:[ls]},$$scope:{ctx:T}}}),oe=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIycXdlbi1lbmRwb2ludC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIyJTBBb3MuZW52aXJvbiU1QiUyMkRFUExPWU1FTlRfTkFNRSUyMiU1RCUyMCUzRCUyMGYlMjJxd2VuLWRlcGxveW1lbnQtJTdCc3RyKHV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-endpoint-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-deployment-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),ie=new J({props:{code:"IWVjaG8lMjAlMjRFTkRQT0lOVF9OQU1FJTBBIWVjaG8lMjAlMjRERVBMT1lNRU5UX05BTUU=",highlighted:`!echo $ENDPOINT_NAME
!echo $DEPLOYMENT_NAME`,wrap:!1}}),re=new C({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),E=new $({props:{$$slots:{default:[ss]},$$scope:{ctx:T}}}),ue=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),de=new C({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),me=new J({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS0zMkItSW5zdHJ1Y3QlMjIlMEElMEFtb2RlbF91cmklMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMmF6dXJlbWwlM0ElMkYlMkZyZWdpc3RyaWVzJTJGSHVnZ2luZ0ZhY2UlMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZC5yZXBsYWNlKCclMkYnJTJDJTIwJy0nKS5yZXBsYWNlKCdfJyUyQyUyMCctJykubG93ZXIoKSU3RCUyRmxhYmVscyUyRmxhdGVzdCUyMiUwQSklMEFtb2RlbF91cmk=",highlighted:`model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-32B-Instruct&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),ye=new J({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChmJTIyaHR0cHMlM0ElMkYlMkZnZW5lcmF0ZS1henVyZW1sLXVybHMuYXp1cmV3ZWJzaXRlcy5uZXQlMkZhcGklMkZnZW5lcmF0ZSUzRm1vZGVsSWQlM0QlN0Jtb2RlbF9pZCU3RCUyMiklMEFpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwISUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1QiU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTNEJTdEJTVEJTIwJTdCbW9kZWxfaWQlM0QlN0QlMjBub3QlMjBhdmFpbGFibGUlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwQ29sbGVjdGlvbiUyMGluJTIwQXp1cmUlMjBNb2RlbCUyMENhdGFsb2clMjIp",highlighted:`<span class="hljs-keyword">import</span> requests

response = requests.get(<span class="hljs-string">f&quot;https://generate-azureml-urls.azurewebsites.net/api/generate?modelId=<span class="hljs-subst">{model_id}</span>&quot;</span>)
<span class="hljs-keyword">if</span> response.status_code != <span class="hljs-number">200</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;[{response.status_code=}] {model_id=} not available on the Hugging Face Collection in Azure Model Catalog&quot;</span>)`,wrap:!1}}),R=new $({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:T}}}),Je=new J({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ue=new J({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),k=new $({props:{$$slots:{default:[os]},$$scope:{ctx:T}}}),Ie=new J({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),_=new $({props:{$$slots:{default:[is]},$$scope:{ctx:T}}}),Ae=new C({props:{title:"Send requests to the Azure AI Endpoint",local:"send-requests-to-the-azure-ai-endpoint",headingTag:"h2"}}),q=new $({props:{$$slots:{default:[rs]},$$scope:{ctx:T}}}),L=new $({props:{warning:!0,$$slots:{default:[ps]},$$scope:{ctx:T}}}),ze=new C({props:{title:"Azure Python SDK",local:"azure-python-sdk",headingTag:"h3"}}),Re=new J({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG9zJTBBaW1wb3J0JTIwdGVtcGZpbGUlMEElMEF3aXRoJTIwdGVtcGZpbGUuTmFtZWRUZW1wb3JhcnlGaWxlKG1vZGUlM0QlMjJ3JTJCJTIyJTJDJTIwZGVsZXRlJTNEVHJ1ZSUyQyUyMHN1ZmZpeCUzRCUyMi5qc29uJTIyKSUyMGFzJTIwdG1wJTNBJTBBJTIwJTIwJTIwJTIwanNvbi5kdW1wKCU3QiUyMmlucHV0cyUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCU3RCU3RCUyQyUyMHRtcCklMEElMjAlMjAlMjAlMjB0bXAuZmx1c2goKSUwQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuaW52b2tlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuZHBvaW50X25hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXBsb3ltZW50X25hbWUlM0Rvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcXVlc3RfZmlsZSUzRHRtcC5uYW1lJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQXByaW50KGpzb24ubG9hZHMocmVzcG9uc2UpKQ==",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">with</span> tempfile.NamedTemporaryFile(mode=<span class="hljs-string">&quot;w+&quot;</span>, delete=<span class="hljs-literal">True</span>, suffix=<span class="hljs-string">&quot;.json&quot;</span>) <span class="hljs-keyword">as</span> tmp:
    json.dump({<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>, <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>}}, tmp)
    tmp.flush()

    response = client.online_endpoints.invoke(
        endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
        deployment_name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
        request_file=tmp.name,
    )

<span class="hljs-built_in">print</span>(json.loads(response))`,wrap:!1}}),B=new $({props:{$$slots:{default:[us]},$$scope:{ctx:T}}}),ke=new C({props:{title:"OpenAI Python SDK",local:"openai-python-sdk",headingTag:"h3"}}),qe=new J({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG9wZW5haSUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install openai --upgrade --quiet",wrap:!1}}),Qe=new J({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmkucmVwbGFjZSglMjIlMkZnZW5lcmF0ZSUyMiUyQyUyMCUyMiUyRnYxJTIyKQ==",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/generate&quot;</span>, <span class="hljs-string">&quot;/v1&quot;</span>)`,wrap:!1}}),Q=new $({props:{$$slots:{default:[ds]},$$scope:{ctx:T}}}),Ge=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX2NsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRGFwaV91cmwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEYXBpX2tleSUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHRfaGVhZGVycyUzRCU3QiUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUyMiUzQSUyMG9zLmdldGVudiglMjJERVBMT1lNRU5UX05BTUUlMjIpJTdEJTJDJTBBKSUwQSUwQWNvbXBsZXRpb24lMjAlM0QlMjBvcGVuYWlfY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyUXdlbiUyRlF3ZW4yLjUtMzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGFuJTIwYXNzaXN0YW50JTIwdGhhdCUyMHJlc3BvbmRzJTIwbGlrZSUyMGElMjBwaXJhdGUuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGV4dHJhX2hlYWRlcnMlM0QlN0IlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlMjIlM0ElMjBvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSU3RCUyQyUwQSklMEFwcmludChjb21wbGV0aW9uKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)

completion = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen2.5-32B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds like a pirate.&quot;</span>},
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>,
        },
    ],
    max_tokens=<span class="hljs-number">128</span>,
    <span class="hljs-comment"># extra_headers={&quot;azureml-model-deployment&quot;: os.getenv(&quot;DEPLOYMENT_NAME&quot;)},</span>
)
<span class="hljs-built_in">print</span>(completion)`,wrap:!1}}),We=new C({props:{title:"cURL",local:"curl",headingTag:"h3"}}),Fe=new J({props:{code:"b3MuZW52aXJvbiU1QiUyMkFQSV9VUkwlMjIlNUQlMjAlM0QlMjBhcGlfdXJsJTBBb3MuZW52aXJvbiU1QiUyMkFQSV9LRVklMjIlNUQlMjAlM0QlMjBhcGlfa2V5",highlighted:`os.environ[<span class="hljs-string">&quot;API_URL&quot;</span>] = api_url
os.environ[<span class="hljs-string">&quot;API_KEY&quot;</span>] = api_key`,wrap:!1}}),He=new J({props:{code:"IWN1cmwlMjAtc1MlMjAlMjRBUElfVVJMJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTI0QVBJX0tFWSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlM0ElMjAlMjRERVBMT1lNRU5UX05BTUUlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtZCUyMCclN0IlMjAlNUMlMEElMjJtZXNzYWdlcyUyMiUzQSU1QiUyMCU1QyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjJzeXN0ZW0lMjIlMkMlMjJjb250ZW50JTIyJTNBJTIyWW91JTIwYXJlJTIwYW4lMjBhc3Npc3RhbnQlMjB0aGF0JTIwcmVwbGllcyUyMGxpa2UlMjBhJTIwcGlyYXRlLiUyMiU3RCUyQyUyMCU1QyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjJ1c2VyJTIyJTJDJTIyY29udGVudCUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiU3RCUyMCU1QyUwQSU1RCUyQyUyMCU1QyUwQSUyMm1heF90b2tlbnMlMjIlM0ExMjglMjAlNUMlMEElN0QnJTIwJTdDJTIwanE=",highlighted:`!curl -sS $API_URL/chat/completions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer $API_KEY&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: application/json&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: $DEPLOYMENT_NAME&quot;</span> \\
    -d <span class="hljs-string">&#x27;{ \\
&quot;messages&quot;:[ \\
    {&quot;role&quot;:&quot;system&quot;,&quot;content&quot;:&quot;You are an assistant that replies like a pirate.&quot;}, \\
    {&quot;role&quot;:&quot;user&quot;,&quot;content&quot;:&quot;What is Deep Learning?&quot;} \\
], \\
&quot;max_tokens&quot;:128 \\
}&#x27;</span> | jq`,wrap:!1}}),xe=new J({props:{code:"Y3VybCUyMC1zUyUyMCUzQ0FQSV9VUkwlM0UlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCUzQ1BSSU1BUllfS0VZJTNFJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUzQSUyMCUyNERFUExPWU1FTlRfTkFNRSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMCU1QyUwQSUyMm1lc3NhZ2VzJTIyJTNBJTVCJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMnN5c3RlbSUyMiUyQyUyMmNvbnRlbnQlMjIlM0ElMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXBsaWVzJTIwbGlrZSUyMGElMjBwaXJhdGUuJTIyJTdEJTJDJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMnVzZXIlMjIlMkMlMjJjb250ZW50JTIyJTNBJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTIwJTVDJTBBJTVEJTJDJTIwJTVDJTBBJTIybWF4X3Rva2VucyUyMiUzQTEyOCUyMCU1QyUwQSU3RCclMjAlN0MlMjBqcQ==",highlighted:`curl -sS &lt;API_URL&gt;/v1/chat/completions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer &lt;PRIMARY_KEY&gt;&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: application/json&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: <span class="hljs-variable">$DEPLOYMENT_NAME</span>&quot;</span> \\
    -d <span class="hljs-string">&#x27;{ \\
&quot;messages&quot;:[ \\
    {&quot;role&quot;:&quot;system&quot;,&quot;content&quot;:&quot;You are an assistant that replies like a pirate.&quot;}, \\
    {&quot;role&quot;:&quot;user&quot;,&quot;content&quot;:&quot;What is Deep Learning?&quot;} \\
], \\
&quot;max_tokens&quot;:128 \\
}&#x27;</span> | jq`,wrap:!1}}),Xe=new C({props:{title:"Gradio",local:"gradio",headingTag:"h3"}}),V=new $({props:{$$slots:{default:[cs]},$$scope:{ctx:T}}}),Ye=new J({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install gradio --upgrade --quiet",wrap:!1}}),Oe=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwRGljdCUyQyUyMEl0ZXJhdG9yJTJDJTIwTGlzdCUyQyUyMExpdGVyYWwlMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQW9wZW5haV9jbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0RhcGlfdXJsJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRGFwaV9rZXklMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0X2hlYWRlcnMlM0QlN0IlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlMjIlM0ElMjBvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSU3RCUyQyUwQSklMEElMEElMEFkZWYlMjBwcmVkaWN0KG1lc3NhZ2UlM0ElMjBzdHIlMkMlMjBoaXN0b3J5JTNBJTIwTGlzdCU1QkRpY3QlNUJMaXRlcmFsJTVCJTIycm9sZSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlNUQlMkMlMjBzdHIlNUQlNUQpJTIwLSUzRSUyMEl0ZXJhdG9yJTVCc3RyJTVEJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeS5hcHBlbmQoJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwbWVzc2FnZSU3RCklMEElMEElMjAlMjAlMjAlMjBzdHJlYW0lMjAlM0QlMjBvcGVuYWlfY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyUXdlbiUyRlF3ZW4yLjUtMzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0RoaXN0b3J5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBjaHVua3MlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBjaHVuayUyMGluJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2h1bmtzLmFwcGVuZChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTIwb3IlMjAlMjIlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjAlMjIlMjIuam9pbihjaHVua3MpJTBBJTBBJTBBZGVtbyUyMCUzRCUyMGdyLkNoYXRJbnRlcmZhY2UocHJlZGljdCUyQyUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiklMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, Iterator, <span class="hljs-type">List</span>, <span class="hljs-type">Literal</span>

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">message: <span class="hljs-built_in">str</span>, history: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;role&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-built_in">str</span>]]</span>) -&gt; Iterator[<span class="hljs-built_in">str</span>]:
    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})

    stream = openai_client.chat.completions.create(
        model=<span class="hljs-string">&quot;Qwen/Qwen2.5-32B-Instruct&quot;</span>,
        messages=history,
        stream=<span class="hljs-literal">True</span>,
    )
    chunks = []
    <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> stream:
        chunks.append(chunk.choices[<span class="hljs-number">0</span>].delta.content <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;&quot;</span>)
        <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;&quot;</span>.join(chunks)


demo = gr.ChatInterface(predict, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
demo.launch()`,wrap:!1}}),et=new C({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),nt=new J({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),lt=new C({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Z=new $({props:{$$slots:{default:[ms]},$$scope:{ctx:T}}}),ot=new es({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/deploy-large-language-models.mdx"}}),{c(){s=r("meta"),f=a(),i=r("p"),w=a(),d(b.$$.fragment),j=a(),A=r("p"),A.textContent=G,g=a(),d(U.$$.fragment),rt=a(),W=r("p"),W.textContent=Sn,pt=a(),ut=r("hr"),dt=a(),N=r("p"),N.innerHTML=xn,ct=a(),F=r("p"),F.textContent=Xn,mt=a(),H=r("ul"),H.innerHTML=Pn,Mt=a(),S=r("p"),S.innerHTML=Yn,ht=a(),x=r("p"),x.innerHTML=Dn,yt=a(),X=r("p"),X.innerHTML=On,ft=a(),d(v.$$.fragment),wt=a(),d(P.$$.fragment),Tt=a(),Y=r("p"),Y.innerHTML=Kn,gt=a(),D=r("ul"),D.innerHTML=el,Jt=a(),O=r("p"),O.innerHTML=tl,Ut=a(),d(K.$$.fragment),$t=a(),ee=r("p"),ee.innerHTML=nl,It=a(),d(te.$$.fragment),bt=a(),ne=r("p"),ne.innerHTML=ll,jt=a(),le=r("p"),le.textContent=sl,Ct=a(),d(se.$$.fragment),At=a(),ae=r("p"),ae.textContent=al,vt=a(),d(z.$$.fragment),zt=a(),d(oe.$$.fragment),Et=a(),d(ie.$$.fragment),Rt=a(),d(re.$$.fragment),kt=a(),pe=r("p"),pe.innerHTML=ol,_t=a(),d(E.$$.fragment),qt=a(),d(ue.$$.fragment),Lt=a(),d(de.$$.fragment),Bt=a(),ce=r("p"),ce.innerHTML=il,Qt=a(),d(me.$$.fragment),Vt=a(),Me=r("p"),Me.innerHTML=rl,Zt=a(),he=r("p"),he.textContent=pl,Gt=a(),d(ye.$$.fragment),Wt=a(),fe=r("p"),fe.innerHTML=ul,Nt=a(),we=r("p"),we.innerHTML=dl,Ft=a(),Te=r("p"),Te.innerHTML=cl,Ht=a(),ge=r("p"),ge.innerHTML=ml,St=a(),d(R.$$.fragment),xt=a(),d(Je.$$.fragment),Xt=a(),d(Ue.$$.fragment),Pt=a(),$e=r("p"),$e.innerHTML=Ml,Yt=a(),d(k.$$.fragment),Dt=a(),d(Ie.$$.fragment),Ot=a(),be=r("p"),be.innerHTML=hl,Kt=a(),d(_.$$.fragment),en=a(),je=r("p"),je.innerHTML=yl,tn=a(),Ce=r("p"),Ce.innerHTML=fl,nn=a(),d(Ae.$$.fragment),ln=a(),ve=r("p"),ve.innerHTML=wl,sn=a(),d(q.$$.fragment),an=a(),d(L.$$.fragment),on=a(),d(ze.$$.fragment),rn=a(),Ee=r("p"),Ee.innerHTML=Tl,pn=a(),d(Re.$$.fragment),un=a(),d(B.$$.fragment),dn=a(),d(ke.$$.fragment),cn=a(),_e=r("p"),_e.textContent=gl,mn=a(),d(qe.$$.fragment),Mn=a(),Le=r("p"),Le.textContent=Jl,hn=a(),Be=r("ul"),Be.innerHTML=Ul,yn=a(),d(Qe.$$.fragment),fn=a(),d(Q.$$.fragment),wn=a(),Ve=r("p"),Ve.innerHTML=$l,Tn=a(),Ze=r("p"),Ze.innerHTML=Il,gn=a(),d(Ge.$$.fragment),Jn=a(),d(We.$$.fragment),Un=a(),Ne=r("p"),Ne.innerHTML=bl,$n=a(),d(Fe.$$.fragment),In=a(),d(He.$$.fragment),bn=a(),Se=r("p"),Se.innerHTML=jl,jn=a(),d(xe.$$.fragment),Cn=a(),d(Xe.$$.fragment),An=a(),Pe=r("p"),Pe.innerHTML=Cl,vn=a(),d(V.$$.fragment),zn=a(),d(Ye.$$.fragment),En=a(),De=r("p"),De.innerHTML=Al,Rn=a(),d(Oe.$$.fragment),kn=a(),Ke=r("p"),Ke.innerHTML=vl,_n=a(),d(et.$$.fragment),qn=a(),tt=r("p"),tt.textContent=zl,Ln=a(),d(nt.$$.fragment),Bn=a(),d(lt.$$.fragment),Qn=a(),st=r("p"),st.textContent=El,Vn=a(),at=r("p"),at.innerHTML=Rl,Zn=a(),Gn=r("hr"),Wn=a(),d(Z.$$.fragment),Nn=a(),d(ot.$$.fragment),Fn=a(),it=r("p"),this.h()},l(e){const t=Ol("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(n),f=o(e),i=p(e,"P",{}),Sl(i).forEach(n),w=o(e),c(b.$$.fragment,e),j=o(e),A=p(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-349stc"&&(A.textContent=G),g=o(e),c(U.$$.fragment,e),rt=o(e),W=p(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-ax1atv"&&(W.textContent=Sn),pt=o(e),ut=p(e,"HR",{}),dt=o(e),N=p(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1s5xzdd"&&(N.innerHTML=xn),ct=o(e),F=p(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-zv8h7c"&&(F.textContent=Xn),mt=o(e),H=p(e,"UL",{"data-svelte-h":!0}),u(H)!=="svelte-fyu9n9"&&(H.innerHTML=Pn),Mt=o(e),S=p(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-187l7cr"&&(S.innerHTML=Yn),ht=o(e),x=p(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1v6b7se"&&(x.innerHTML=Dn),yt=o(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-19k6u5u"&&(X.innerHTML=On),ft=o(e),c(v.$$.fragment,e),wt=o(e),c(P.$$.fragment,e),Tt=o(e),Y=p(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-dnkqle"&&(Y.innerHTML=Kn),gt=o(e),D=p(e,"UL",{"data-svelte-h":!0}),u(D)!=="svelte-dlzkka"&&(D.innerHTML=el),Jt=o(e),O=p(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1myp7ii"&&(O.innerHTML=tl),Ut=o(e),c(K.$$.fragment,e),$t=o(e),ee=p(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-bexho5"&&(ee.innerHTML=nl),It=o(e),c(te.$$.fragment,e),bt=o(e),ne=p(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1v277rw"&&(ne.innerHTML=ll),jt=o(e),le=p(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-11uslf2"&&(le.textContent=sl),Ct=o(e),c(se.$$.fragment,e),At=o(e),ae=p(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1wrtw53"&&(ae.textContent=al),vt=o(e),c(z.$$.fragment,e),zt=o(e),c(oe.$$.fragment,e),Et=o(e),c(ie.$$.fragment,e),Rt=o(e),c(re.$$.fragment,e),kt=o(e),pe=p(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1fy23dh"&&(pe.innerHTML=ol),_t=o(e),c(E.$$.fragment,e),qt=o(e),c(ue.$$.fragment,e),Lt=o(e),c(de.$$.fragment,e),Bt=o(e),ce=p(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-thijw5"&&(ce.innerHTML=il),Qt=o(e),c(me.$$.fragment,e),Vt=o(e),Me=p(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1hy4n1w"&&(Me.innerHTML=rl),Zt=o(e),he=p(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1kr526q"&&(he.textContent=pl),Gt=o(e),c(ye.$$.fragment,e),Wt=o(e),fe=p(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1qpei6p"&&(fe.innerHTML=ul),Nt=o(e),we=p(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1kte4k3"&&(we.innerHTML=dl),Ft=o(e),Te=p(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-mdv3ng"&&(Te.innerHTML=cl),Ht=o(e),ge=p(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1weda3f"&&(ge.innerHTML=ml),St=o(e),c(R.$$.fragment,e),xt=o(e),c(Je.$$.fragment,e),Xt=o(e),c(Ue.$$.fragment,e),Pt=o(e),$e=p(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-cd51sx"&&($e.innerHTML=Ml),Yt=o(e),c(k.$$.fragment,e),Dt=o(e),c(Ie.$$.fragment,e),Ot=o(e),be=p(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1cyaahl"&&(be.innerHTML=hl),Kt=o(e),c(_.$$.fragment,e),en=o(e),je=p(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1v1bv0"&&(je.innerHTML=yl),tn=o(e),Ce=p(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-kgt4mo"&&(Ce.innerHTML=fl),nn=o(e),c(Ae.$$.fragment,e),ln=o(e),ve=p(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-b8ajgt"&&(ve.innerHTML=wl),sn=o(e),c(q.$$.fragment,e),an=o(e),c(L.$$.fragment,e),on=o(e),c(ze.$$.fragment,e),rn=o(e),Ee=p(e,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-nyu5ju"&&(Ee.innerHTML=Tl),pn=o(e),c(Re.$$.fragment,e),un=o(e),c(B.$$.fragment,e),dn=o(e),c(ke.$$.fragment,e),cn=o(e),_e=p(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-q0evy3"&&(_e.textContent=gl),mn=o(e),c(qe.$$.fragment,e),Mn=o(e),Le=p(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-9zyo13"&&(Le.textContent=Jl),hn=o(e),Be=p(e,"UL",{"data-svelte-h":!0}),u(Be)!=="svelte-kvalv2"&&(Be.innerHTML=Ul),yn=o(e),c(Qe.$$.fragment,e),fn=o(e),c(Q.$$.fragment,e),wn=o(e),Ve=p(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1t4oej1"&&(Ve.innerHTML=$l),Tn=o(e),Ze=p(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1t8h4hs"&&(Ze.innerHTML=Il),gn=o(e),c(Ge.$$.fragment,e),Jn=o(e),c(We.$$.fragment,e),Un=o(e),Ne=p(e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-6rxgjf"&&(Ne.innerHTML=bl),$n=o(e),c(Fe.$$.fragment,e),In=o(e),c(He.$$.fragment,e),bn=o(e),Se=p(e,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-nd1bhb"&&(Se.innerHTML=jl),jn=o(e),c(xe.$$.fragment,e),Cn=o(e),c(Xe.$$.fragment,e),An=o(e),Pe=p(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-e42t4p"&&(Pe.innerHTML=Cl),vn=o(e),c(V.$$.fragment,e),zn=o(e),c(Ye.$$.fragment,e),En=o(e),De=p(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-1hthzd7"&&(De.innerHTML=Al),Rn=o(e),c(Oe.$$.fragment,e),kn=o(e),Ke=p(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-r0xzrm"&&(Ke.innerHTML=vl),_n=o(e),c(et.$$.fragment,e),qn=o(e),tt=p(e,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-rntoeu"&&(tt.textContent=zl),Ln=o(e),c(nt.$$.fragment,e),Bn=o(e),c(lt.$$.fragment,e),Qn=o(e),st=p(e,"P",{"data-svelte-h":!0}),u(st)!=="svelte-heicvy"&&(st.textContent=El),Vn=o(e),at=p(e,"P",{"data-svelte-h":!0}),u(at)!=="svelte-1nopug0"&&(at.innerHTML=Rl),Zn=o(e),Gn=p(e,"HR",{}),Wn=o(e),c(Z.$$.fragment,e),Nn=o(e),c(ot.$$.fragment,e),Fn=o(e),it=p(e,"P",{}),Sl(it).forEach(n),this.h()},h(){xl(s,"name","hf:doc:metadata"),xl(s,"content",hs)},m(e,t){Kl(document.head,s),l(e,f,t),l(e,i,t),l(e,w,t),m(b,e,t),l(e,j,t),l(e,A,t),l(e,g,t),m(U,e,t),l(e,rt,t),l(e,W,t),l(e,pt,t),l(e,ut,t),l(e,dt,t),l(e,N,t),l(e,ct,t),l(e,F,t),l(e,mt,t),l(e,H,t),l(e,Mt,t),l(e,S,t),l(e,ht,t),l(e,x,t),l(e,yt,t),l(e,X,t),l(e,ft,t),m(v,e,t),l(e,wt,t),m(P,e,t),l(e,Tt,t),l(e,Y,t),l(e,gt,t),l(e,D,t),l(e,Jt,t),l(e,O,t),l(e,Ut,t),m(K,e,t),l(e,$t,t),l(e,ee,t),l(e,It,t),m(te,e,t),l(e,bt,t),l(e,ne,t),l(e,jt,t),l(e,le,t),l(e,Ct,t),m(se,e,t),l(e,At,t),l(e,ae,t),l(e,vt,t),m(z,e,t),l(e,zt,t),m(oe,e,t),l(e,Et,t),m(ie,e,t),l(e,Rt,t),m(re,e,t),l(e,kt,t),l(e,pe,t),l(e,_t,t),m(E,e,t),l(e,qt,t),m(ue,e,t),l(e,Lt,t),m(de,e,t),l(e,Bt,t),l(e,ce,t),l(e,Qt,t),m(me,e,t),l(e,Vt,t),l(e,Me,t),l(e,Zt,t),l(e,he,t),l(e,Gt,t),m(ye,e,t),l(e,Wt,t),l(e,fe,t),l(e,Nt,t),l(e,we,t),l(e,Ft,t),l(e,Te,t),l(e,Ht,t),l(e,ge,t),l(e,St,t),m(R,e,t),l(e,xt,t),m(Je,e,t),l(e,Xt,t),m(Ue,e,t),l(e,Pt,t),l(e,$e,t),l(e,Yt,t),m(k,e,t),l(e,Dt,t),m(Ie,e,t),l(e,Ot,t),l(e,be,t),l(e,Kt,t),m(_,e,t),l(e,en,t),l(e,je,t),l(e,tn,t),l(e,Ce,t),l(e,nn,t),m(Ae,e,t),l(e,ln,t),l(e,ve,t),l(e,sn,t),m(q,e,t),l(e,an,t),m(L,e,t),l(e,on,t),m(ze,e,t),l(e,rn,t),l(e,Ee,t),l(e,pn,t),m(Re,e,t),l(e,un,t),m(B,e,t),l(e,dn,t),m(ke,e,t),l(e,cn,t),l(e,_e,t),l(e,mn,t),m(qe,e,t),l(e,Mn,t),l(e,Le,t),l(e,hn,t),l(e,Be,t),l(e,yn,t),m(Qe,e,t),l(e,fn,t),m(Q,e,t),l(e,wn,t),l(e,Ve,t),l(e,Tn,t),l(e,Ze,t),l(e,gn,t),m(Ge,e,t),l(e,Jn,t),m(We,e,t),l(e,Un,t),l(e,Ne,t),l(e,$n,t),m(Fe,e,t),l(e,In,t),m(He,e,t),l(e,bn,t),l(e,Se,t),l(e,jn,t),m(xe,e,t),l(e,Cn,t),m(Xe,e,t),l(e,An,t),l(e,Pe,t),l(e,vn,t),m(V,e,t),l(e,zn,t),m(Ye,e,t),l(e,En,t),l(e,De,t),l(e,Rn,t),m(Oe,e,t),l(e,kn,t),l(e,Ke,t),l(e,_n,t),m(et,e,t),l(e,qn,t),l(e,tt,t),l(e,Ln,t),m(nt,e,t),l(e,Bn,t),m(lt,e,t),l(e,Qn,t),l(e,st,t),l(e,Vn,t),l(e,at,t),l(e,Zn,t),l(e,Gn,t),l(e,Wn,t),m(Z,e,t),l(e,Nn,t),m(ot,e,t),l(e,Fn,t),l(e,it,t),Hn=!0},p(e,[t]){const kl={};t&2&&(kl.$$scope={dirty:t,ctx:e}),U.$set(kl);const _l={};t&2&&(_l.$$scope={dirty:t,ctx:e}),v.$set(_l);const ql={};t&2&&(ql.$$scope={dirty:t,ctx:e}),z.$set(ql);const Ll={};t&2&&(Ll.$$scope={dirty:t,ctx:e}),E.$set(Ll);const Bl={};t&2&&(Bl.$$scope={dirty:t,ctx:e}),R.$set(Bl);const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),k.$set(Ql);const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),_.$set(Vl);const Zl={};t&2&&(Zl.$$scope={dirty:t,ctx:e}),q.$set(Zl);const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),L.$set(Gl);const Wl={};t&2&&(Wl.$$scope={dirty:t,ctx:e}),B.$set(Wl);const Nl={};t&2&&(Nl.$$scope={dirty:t,ctx:e}),Q.$set(Nl);const Fl={};t&2&&(Fl.$$scope={dirty:t,ctx:e}),V.$set(Fl);const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),Z.$set(Hl)},i(e){Hn||(M(b.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(z.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(E.$$.fragment,e),M(ue.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(R.$$.fragment,e),M(Je.$$.fragment,e),M(Ue.$$.fragment,e),M(k.$$.fragment,e),M(Ie.$$.fragment,e),M(_.$$.fragment,e),M(Ae.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(ze.$$.fragment,e),M(Re.$$.fragment,e),M(B.$$.fragment,e),M(ke.$$.fragment,e),M(qe.$$.fragment,e),M(Qe.$$.fragment,e),M(Q.$$.fragment,e),M(Ge.$$.fragment,e),M(We.$$.fragment,e),M(Fe.$$.fragment,e),M(He.$$.fragment,e),M(xe.$$.fragment,e),M(Xe.$$.fragment,e),M(V.$$.fragment,e),M(Ye.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),M(nt.$$.fragment,e),M(lt.$$.fragment,e),M(Z.$$.fragment,e),M(ot.$$.fragment,e),Hn=!0)},o(e){h(b.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(z.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(E.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(R.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(k.$$.fragment,e),h(Ie.$$.fragment,e),h(_.$$.fragment,e),h(Ae.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(B.$$.fragment,e),h(ke.$$.fragment,e),h(qe.$$.fragment,e),h(Qe.$$.fragment,e),h(Q.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(Fe.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Xe.$$.fragment,e),h(V.$$.fragment,e),h(Ye.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(nt.$$.fragment,e),h(lt.$$.fragment,e),h(Z.$$.fragment,e),h(ot.$$.fragment,e),Hn=!1},d(e){e&&(n(f),n(i),n(w),n(j),n(A),n(g),n(rt),n(W),n(pt),n(ut),n(dt),n(N),n(ct),n(F),n(mt),n(H),n(Mt),n(S),n(ht),n(x),n(yt),n(X),n(ft),n(wt),n(Tt),n(Y),n(gt),n(D),n(Jt),n(O),n(Ut),n($t),n(ee),n(It),n(bt),n(ne),n(jt),n(le),n(Ct),n(At),n(ae),n(vt),n(zt),n(Et),n(Rt),n(kt),n(pe),n(_t),n(qt),n(Lt),n(Bt),n(ce),n(Qt),n(Vt),n(Me),n(Zt),n(he),n(Gt),n(Wt),n(fe),n(Nt),n(we),n(Ft),n(Te),n(Ht),n(ge),n(St),n(xt),n(Xt),n(Pt),n($e),n(Yt),n(Dt),n(Ot),n(be),n(Kt),n(en),n(je),n(tn),n(Ce),n(nn),n(ln),n(ve),n(sn),n(an),n(on),n(rn),n(Ee),n(pn),n(un),n(dn),n(cn),n(_e),n(mn),n(Mn),n(Le),n(hn),n(Be),n(yn),n(fn),n(wn),n(Ve),n(Tn),n(Ze),n(gn),n(Jn),n(Un),n(Ne),n($n),n(In),n(bn),n(Se),n(jn),n(Cn),n(An),n(Pe),n(vn),n(zn),n(En),n(De),n(Rn),n(kn),n(Ke),n(_n),n(qn),n(tt),n(Ln),n(Bn),n(Qn),n(st),n(Vn),n(at),n(Zn),n(Gn),n(Wn),n(Nn),n(Fn),n(it)),n(s),y(b,e),y(U,e),y(v,e),y(P,e),y(K,e),y(te,e),y(se,e),y(z,e),y(oe,e),y(ie,e),y(re,e),y(E,e),y(ue,e),y(de,e),y(me,e),y(ye,e),y(R,e),y(Je,e),y(Ue,e),y(k,e),y(Ie,e),y(_,e),y(Ae,e),y(q,e),y(L,e),y(ze,e),y(Re,e),y(B,e),y(ke,e),y(qe,e),y(Qe,e),y(Q,e),y(Ge,e),y(We,e),y(Fe,e),y(He,e),y(xe,e),y(Xe,e),y(V,e),y(Ye,e),y(Oe,e),y(et,e),y(nt,e),y(lt,e),y(Z,e),y(ot,e)}}}const hs='{"title":"Deploy Large Language Models (LLMs) on Azure AI","local":"deploy-large-language-models-llms-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Send requests to the Azure AI Endpoint","local":"send-requests-to-the-azure-ai-endpoint","sections":[{"title":"Azure Python SDK","local":"azure-python-sdk","sections":[],"depth":3},{"title":"OpenAI Python SDK","local":"openai-python-sdk","sections":[],"depth":3},{"title":"cURL","local":"curl","sections":[],"depth":3},{"title":"Gradio","local":"gradio","sections":[],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ys(T){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends Yl{constructor(s){super(),Dl(this,s,ys,Ms,Xl,{})}}export{Us as component};
