import{s as St,o as Qt,n as Zt}from"../chunks/scheduler.f6b352c8.js";import{S as kt,i as Rt,g as J,s as p,r as I,A as Xt,h as T,f as s,c as M,j as Et,u as j,x as c,k as Nt,y as xt,a as n,v as d,d as h,t as y,w as m}from"../chunks/index.7f38e934.js";import{Y as _t}from"../chunks/Youtube.39b26cbc.js";import{C as jt}from"../chunks/CodeBlock.3ee8293b.js";import{H as z,E as Vt}from"../chunks/getInferenceSnippets.7402b4e4.js";import{H as Yt,a as Gt}from"../chunks/HfOption.1d09dd6f.js";function qt(U){let a,i,o,w;return a=new _t({props:{id:"exzrb5QNUis"}}),o=new jt({props:{code:"ZnJvbSUyMG1jcC5zZXJ2ZXIuZmFzdG1jcCUyMGltcG9ydCUyMEZhc3RNQ1AlMEElMEElMjMlMjBDcmVhdGUlMjBhbiUyME1DUCUyMHNlcnZlciUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBJTBBJTQwbWNwLnRvb2woKSUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB0aGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGZvciUyMGElMjBzcGVjaWZpZWQlMjBsb2NhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyV2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlM0ElMjBTdW5ueSUyQyUyMDcyJUMyJUIwRiUyMiUwQSUwQSUwQSU0MG1jcC5yZXNvdXJjZSglMjJ3ZWF0aGVyJTNBJTJGJTJGJTdCbG9jYXRpb24lN0QlMjIpJTBBZGVmJTIwd2VhdGhlcl9yZXNvdXJjZShsb2NhdGlvbiUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUHJvdmlkZSUyMHdlYXRoZXIlMjBkYXRhJTIwYXMlMjBhJTIwcmVzb3VyY2UuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZiUyMldlYXRoZXIlMjBkYXRhJTIwZm9yJTIwJTdCbG9jYXRpb24lN0QlM0ElMjBTdW5ueSUyQyUyMDcyJUMyJUIwRiUyMiUwQSUwQSUwQSU0MG1jcC5wcm9tcHQoKSUwQWRlZiUyMHdlYXRoZXJfcmVwb3J0KGxvY2F0aW9uJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDcmVhdGUlMjBhJTIwd2VhdGhlciUyMHJlcG9ydCUyMHByb21wdC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyJTIyJTIyWW91JTIwYXJlJTIwYSUyMHdlYXRoZXIlMjByZXBvcnRlci4lMjBXZWF0aGVyJTIwcmVwb3J0JTIwZm9yJTIwJTdCbG9jYXRpb24lN0QlM0YlMjIlMjIlMjIlMEElMEElMEElMjMlMjBSdW4lMjB0aGUlMjBzZXJ2ZXIlMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtY3AucnVuKCklMEE=",highlighted:`<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

<span class="hljs-comment"># Create an MCP server</span>
mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)


<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Get the current weather for a specified location.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather in <span class="hljs-subst">{location}</span>: Sunny, 72°F&quot;</span>


<span class="hljs-meta">@mcp.resource(<span class="hljs-params"><span class="hljs-string">&quot;weather://{location}&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">weather_resource</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Provide weather data as a resource.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather data for <span class="hljs-subst">{location}</span>: Sunny, 72°F&quot;</span>


<span class="hljs-meta">@mcp.prompt()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">weather_report</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Create a weather report prompt.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;&quot;&quot;You are a weather reporter. Weather report for <span class="hljs-subst">{location}</span>?&quot;&quot;&quot;</span>


<span class="hljs-comment"># Run the server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    mcp.run()
`,wrap:!1}}),{c(){I(a.$$.fragment),i=p(),I(o.$$.fragment)},l(e){j(a.$$.fragment,e),i=M(e),j(o.$$.fragment,e)},m(e,r){d(a,e,r),n(e,i,r),d(o,e,r),w=!0},p:Zt,i(e){w||(h(a.$$.fragment,e),h(o.$$.fragment,e),w=!0)},o(e){y(a.$$.fragment,e),y(o.$$.fragment,e),w=!1},d(e){e&&s(i),m(a,e),m(o,e)}}}function Wt(U){let a,i;return a=new jt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">McpServer</span>, <span class="hljs-title class_">ResourceTemplate</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@modelcontextprotocol/sdk/server/mcp.js&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">StdioServerTransport</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@modelcontextprotocol/sdk/server/stdio.js&quot;</span>;
<span class="hljs-keyword">import</span> { z } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;zod&quot;</span>;

<span class="hljs-comment">// Create an MCP server</span>
<span class="hljs-keyword">const</span> server = <span class="hljs-keyword">new</span> <span class="hljs-title class_">McpServer</span>({
    <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;Weather Service&quot;</span>,
    <span class="hljs-attr">version</span>: <span class="hljs-string">&quot;1.0.0&quot;</span>
});

<span class="hljs-comment">// Tool implementation</span>
server.<span class="hljs-title function_">tool</span>(<span class="hljs-string">&quot;get_weather&quot;</span>,
    { <span class="hljs-attr">location</span>: z.<span class="hljs-title function_">string</span>() },
    <span class="hljs-keyword">async</span> ({ location }) =&gt; ({
        <span class="hljs-attr">content</span>: [{
            <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather in <span class="hljs-subst">\${location}</span>: Sunny, 72°F\`</span>
        }]
    })
);

<span class="hljs-comment">// Resource implementation</span>
server.<span class="hljs-title function_">resource</span>(
    <span class="hljs-string">&quot;weather&quot;</span>,
    <span class="hljs-keyword">new</span> <span class="hljs-title class_">ResourceTemplate</span>(<span class="hljs-string">&quot;weather://{location}&quot;</span>, { <span class="hljs-attr">list</span>: <span class="hljs-literal">undefined</span> }),
    <span class="hljs-keyword">async</span> (uri, { location }) =&gt; ({
        <span class="hljs-attr">contents</span>: [{
            <span class="hljs-attr">uri</span>: uri.<span class="hljs-property">href</span>,
            <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather data for <span class="hljs-subst">\${location}</span>: Sunny, 72°F\`</span>
        }]
    })
);

<span class="hljs-comment">// Prompt implementation</span>
server.<span class="hljs-title function_">prompt</span>(
    <span class="hljs-string">&quot;weather_report&quot;</span>,
    { <span class="hljs-attr">location</span>: z.<span class="hljs-title function_">string</span>() },
    <span class="hljs-keyword">async</span> ({ location }) =&gt; ({
        <span class="hljs-attr">messages</span>: [
            {
                <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-attr">content</span>: {
                    <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-attr">text</span>: <span class="hljs-string">&quot;You are a weather reporter.&quot;</span>
                }
            },
            {
                <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-attr">content</span>: {
                    <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-attr">text</span>: <span class="hljs-string">\`Weather report for <span class="hljs-subst">\${location}</span>?\`</span>
                }
            }
        ]
    })
);

<span class="hljs-comment">// Run the server</span>
<span class="hljs-keyword">const</span> transport = <span class="hljs-keyword">new</span> <span class="hljs-title class_">StdioServerTransport</span>();
<span class="hljs-keyword">await</span> server.<span class="hljs-title function_">connect</span>(transport);`,wrap:!1}}),{c(){I(a.$$.fragment)},l(o){j(a.$$.fragment,o)},m(o,w){d(a,o,w),i=!0},p:Zt,i(o){i||(h(a.$$.fragment,o),i=!0)},o(o){y(a.$$.fragment,o),i=!1},d(o){m(a,o)}}}function zt(U){let a,i,o,w;return a=new Gt({props:{id:"server-implementation",option:"python",$$slots:{default:[qt]},$$scope:{ctx:U}}}),o=new Gt({props:{id:"server-implementation",option:"javascript",$$slots:{default:[Wt]},$$scope:{ctx:U}}}),{c(){I(a.$$.fragment),i=p(),I(o.$$.fragment)},l(e){j(a.$$.fragment,e),i=M(e),j(o.$$.fragment,e)},m(e,r){d(a,e,r),n(e,i,r),d(o,e,r),w=!0},p(e,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:e}),a.$set(u);const q={};r&2&&(q.$$scope={dirty:r,ctx:e}),o.$set(q)},i(e){w||(h(a.$$.fragment,e),h(o.$$.fragment,e),w=!0)},o(e){y(a.$$.fragment,e),y(o.$$.fragment,e),w=!1},d(e){e&&s(i),m(a,e),m(o,e)}}}function Pt(U){let a,i,o,w,e,r,u,q="The Model Context Protocol provides official SDKs for both JavaScript, Python and other languages. This makes it easy to implement MCP clients and servers in your applications. These SDKs handle the low-level protocol details, allowing you to focus on building your application’s capabilities.",P,C,F,B,dt="Both SDKs provide similar core functionality, following the MCP protocol specification we discussed earlier. They handle:",H,b,ht="<li>Protocol-level communication</li> <li>Capability registration and discovery</li> <li>Message serialization/deserialization</li> <li>Connection management</li> <li>Error handling</li>",D,v,K,A,yt="Let’s explore how to implement each of the core primitives (Tools, Resources, and Prompts) using both SDKs.",L,f,O,$,mt="Once you have your server implemented, you can start it by running the server script.",tt,g,lt,E,ut="This will initialize a development server running the file <code>server.py</code>. And log the following output:",st,N,et,G,Ut='You can then open the MCP Inspector at <a href="http://127.0.0.1:6274" rel="nofollow">http://127.0.0.1:6274</a> to see the server’s capabilities and interact with them.',nt,Z,ft="You’ll see the server’s capabilities and the ability to call them via the UI.",at,S,Ct='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit1/6.png" alt="MCP Inspector"/>',ot,Q,pt,k,Bt="MCP is designed to be language-agnostic, and there are official SDKs available for several popular programming languages:",Mt,R,bt='<thead><tr><th>Language</th> <th>Repository</th> <th>Maintainer(s)</th> <th>Status</th></tr></thead> <tbody><tr><td>TypeScript</td> <td><a href="https://github.com/modelcontextprotocol/typescript-sdk" rel="nofollow">github.com/modelcontextprotocol/typescript-sdk</a></td> <td>Anthropic</td> <td>Active</td></tr> <tr><td>Python</td> <td><a href="https://github.com/modelcontextprotocol/python-sdk" rel="nofollow">github.com/modelcontextprotocol/python-sdk</a></td> <td>Anthropic</td> <td>Active</td></tr> <tr><td>Java</td> <td><a href="https://github.com/modelcontextprotocol/java-sdk" rel="nofollow">github.com/modelcontextprotocol/java-sdk</a></td> <td>Spring AI (VMware)</td> <td>Active</td></tr> <tr><td>Kotlin</td> <td><a href="https://github.com/modelcontextprotocol/kotlin-sdk" rel="nofollow">github.com/modelcontextprotocol/kotlin-sdk</a></td> <td>JetBrains</td> <td>Active</td></tr> <tr><td>C#</td> <td><a href="https://github.com/modelcontextprotocol/csharp-sdk" rel="nofollow">github.com/modelcontextprotocol/csharp-sdk</a></td> <td>Microsoft</td> <td>Active (Preview)</td></tr> <tr><td>Swift</td> <td><a href="https://github.com/modelcontextprotocol/swift-sdk" rel="nofollow">github.com/modelcontextprotocol/swift-sdk</a></td> <td>loopwork-ai</td> <td>Active</td></tr> <tr><td>Rust</td> <td><a href="https://github.com/modelcontextprotocol/rust-sdk" rel="nofollow">github.com/modelcontextprotocol/rust-sdk</a></td> <td>Anthropic/Community</td> <td>Active</td></tr> <tr><td>Dart</td> <td><a href="https://github.com/leehack/mcp_dart" rel="nofollow">https://github.com/leehack/mcp_dart</a></td> <td>Flutter Community</td> <td>Active</td></tr></tbody>',it,X,vt="These SDKs provide language-specific abstractions that simplify working with the MCP protocol, allowing you to focus on implementing the core logic of your servers or clients rather than dealing with low-level protocol details.",rt,x,Jt,_,At="We’ve only scratched the surface of what you can do with the MCP but you’ve already got a basic server running. In fact, you’ve also connected to it using the MCP Client in the browser.",Tt,V,$t="In the next section, we’ll look at how to connect to your server from an LLM.",wt,Y,ct,W,It;return e=new z({props:{title:"MCP SDK",local:"mcp-sdk",headingTag:"h1"}}),C=new z({props:{title:"SDK Overview",local:"sdk-overview",headingTag:"h2"}}),v=new z({props:{title:"Core Primitives Implementation",local:"core-primitives-implementation",headingTag:"h2"}}),f=new Yt({props:{id:"server-implementation",options:["python","javascript"],$$slots:{default:[zt]},$$scope:{ctx:U}}}),g=new jt({props:{code:"bWNwJTIwZGV2JTIwc2VydmVyLnB5",highlighted:"mcp dev server.py",wrap:!1}}),N=new jt({props:{code:"U3RhcnRpbmclMjBNQ1AlMjBpbnNwZWN0b3IuLi4lMEElRTIlOUElOTklRUYlQjglOEYlMjBQcm94eSUyMHNlcnZlciUyMGxpc3RlbmluZyUyMG9uJTIwcG9ydCUyMDYyNzclMEFTcGF3bmVkJTIwc3RkaW8lMjB0cmFuc3BvcnQlMEFDb25uZWN0ZWQlMjBNQ1AlMjBjbGllbnQlMjB0byUyMGJhY2tpbmclMjBzZXJ2ZXIlMjB0cmFuc3BvcnQlMEFDcmVhdGVkJTIwd2ViJTIwYXBwJTIwdHJhbnNwb3J0JTBBU2V0JTIwdXAlMjBNQ1AlMjBwcm94eSUwQSVGMCU5RiU5NCU4RCUyME1DUCUyMEluc3BlY3RvciUyMGlzJTIwdXAlMjBhbmQlMjBydW5uaW5nJTIwYXQlMjBodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBNjI3NCUyMCVGMCU5RiU5QSU4MA==",highlighted:`Starting MCP inspector...
⚙️ Proxy server listening on port 6277
Spawned stdio transport
Connected MCP client to backing server transport
Created web app transport
Set up MCP proxy
🔍 MCP Inspector is up and running at http://127.0.0.1:6274 🚀`,wrap:!1}}),Q=new z({props:{title:"MCP SDKs",local:"mcp-sdks",headingTag:"h2"}}),x=new z({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Y=new Vt({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/sdk.mdx"}}),{c(){a=J("meta"),i=p(),o=J("p"),w=p(),I(e.$$.fragment),r=p(),u=J("p"),u.textContent=q,P=p(),I(C.$$.fragment),F=p(),B=J("p"),B.textContent=dt,H=p(),b=J("ul"),b.innerHTML=ht,D=p(),I(v.$$.fragment),K=p(),A=J("p"),A.textContent=yt,L=p(),I(f.$$.fragment),O=p(),$=J("p"),$.textContent=mt,tt=p(),I(g.$$.fragment),lt=p(),E=J("p"),E.innerHTML=ut,st=p(),I(N.$$.fragment),et=p(),G=J("p"),G.innerHTML=Ut,nt=p(),Z=J("p"),Z.textContent=ft,at=p(),S=J("p"),S.innerHTML=Ct,ot=p(),I(Q.$$.fragment),pt=p(),k=J("p"),k.textContent=Bt,Mt=p(),R=J("table"),R.innerHTML=bt,it=p(),X=J("p"),X.textContent=vt,rt=p(),I(x.$$.fragment),Jt=p(),_=J("p"),_.textContent=At,Tt=p(),V=J("p"),V.textContent=$t,wt=p(),I(Y.$$.fragment),ct=p(),W=J("p"),this.h()},l(t){const l=Xt("svelte-u9bgzb",document.head);a=T(l,"META",{name:!0,content:!0}),l.forEach(s),i=M(t),o=T(t,"P",{}),Et(o).forEach(s),w=M(t),j(e.$$.fragment,t),r=M(t),u=T(t,"P",{"data-svelte-h":!0}),c(u)!=="svelte-d74ti7"&&(u.textContent=q),P=M(t),j(C.$$.fragment,t),F=M(t),B=T(t,"P",{"data-svelte-h":!0}),c(B)!=="svelte-13pn39g"&&(B.textContent=dt),H=M(t),b=T(t,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-68l2gn"&&(b.innerHTML=ht),D=M(t),j(v.$$.fragment,t),K=M(t),A=T(t,"P",{"data-svelte-h":!0}),c(A)!=="svelte-ttdup7"&&(A.textContent=yt),L=M(t),j(f.$$.fragment,t),O=M(t),$=T(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-o6gns3"&&($.textContent=mt),tt=M(t),j(g.$$.fragment,t),lt=M(t),E=T(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-o7d2nm"&&(E.innerHTML=ut),st=M(t),j(N.$$.fragment,t),et=M(t),G=T(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1t493b1"&&(G.innerHTML=Ut),nt=M(t),Z=T(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-14xr1ub"&&(Z.textContent=ft),at=M(t),S=T(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1pax2up"&&(S.innerHTML=Ct),ot=M(t),j(Q.$$.fragment,t),pt=M(t),k=T(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1jgjuju"&&(k.textContent=Bt),Mt=M(t),R=T(t,"TABLE",{"data-svelte-h":!0}),c(R)!=="svelte-hr2s98"&&(R.innerHTML=bt),it=M(t),X=T(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1b923fr"&&(X.textContent=vt),rt=M(t),j(x.$$.fragment,t),Jt=M(t),_=T(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1mzm78"&&(_.textContent=At),Tt=M(t),V=T(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-v6yatx"&&(V.textContent=$t),wt=M(t),j(Y.$$.fragment,t),ct=M(t),W=T(t,"P",{}),Et(W).forEach(s),this.h()},h(){Nt(a,"name","hf:doc:metadata"),Nt(a,"content",Ft)},m(t,l){xt(document.head,a),n(t,i,l),n(t,o,l),n(t,w,l),d(e,t,l),n(t,r,l),n(t,u,l),n(t,P,l),d(C,t,l),n(t,F,l),n(t,B,l),n(t,H,l),n(t,b,l),n(t,D,l),d(v,t,l),n(t,K,l),n(t,A,l),n(t,L,l),d(f,t,l),n(t,O,l),n(t,$,l),n(t,tt,l),d(g,t,l),n(t,lt,l),n(t,E,l),n(t,st,l),d(N,t,l),n(t,et,l),n(t,G,l),n(t,nt,l),n(t,Z,l),n(t,at,l),n(t,S,l),n(t,ot,l),d(Q,t,l),n(t,pt,l),n(t,k,l),n(t,Mt,l),n(t,R,l),n(t,it,l),n(t,X,l),n(t,rt,l),d(x,t,l),n(t,Jt,l),n(t,_,l),n(t,Tt,l),n(t,V,l),n(t,wt,l),d(Y,t,l),n(t,ct,l),n(t,W,l),It=!0},p(t,[l]){const gt={};l&2&&(gt.$$scope={dirty:l,ctx:t}),f.$set(gt)},i(t){It||(h(e.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(f.$$.fragment,t),h(g.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(x.$$.fragment,t),h(Y.$$.fragment,t),It=!0)},o(t){y(e.$$.fragment,t),y(C.$$.fragment,t),y(v.$$.fragment,t),y(f.$$.fragment,t),y(g.$$.fragment,t),y(N.$$.fragment,t),y(Q.$$.fragment,t),y(x.$$.fragment,t),y(Y.$$.fragment,t),It=!1},d(t){t&&(s(i),s(o),s(w),s(r),s(u),s(P),s(F),s(B),s(H),s(b),s(D),s(K),s(A),s(L),s(O),s($),s(tt),s(lt),s(E),s(st),s(et),s(G),s(nt),s(Z),s(at),s(S),s(ot),s(pt),s(k),s(Mt),s(R),s(it),s(X),s(rt),s(Jt),s(_),s(Tt),s(V),s(wt),s(ct),s(W)),s(a),m(e,t),m(C,t),m(v,t),m(f,t),m(g,t),m(N,t),m(Q,t),m(x,t),m(Y,t)}}}const Ft='{"title":"MCP SDK","local":"mcp-sdk","sections":[{"title":"SDK Overview","local":"sdk-overview","sections":[],"depth":2},{"title":"Core Primitives Implementation","local":"core-primitives-implementation","sections":[],"depth":2},{"title":"MCP SDKs","local":"mcp-sdks","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ht(U){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends kt{constructor(a){super(),Rt(this,a,Ht,Pt,St,{})}}export{sl as component};
