import{s as fe,o as Be,n as Lt}from"../chunks/scheduler.f7e1785c.js";import{S as Ze,i as ve,g as M,s as n,r as J,A as ke,h as i,f as s,c as a,j as Ae,u as T,x as o,k as be,y as $e,a as e,v as w,d as j,t as U,w as c}from"../chunks/index.d8354395.js";import{T as Pt}from"../chunks/Tip.d2769a7f.js";import{C as h}from"../chunks/CodeBlock.191e5103.js";import{H as I,E as xe}from"../chunks/getInferenceSnippets.ce3094f0.js";function Ge(C){let p,r="For educational purposes, we will build the MCP Server and MCP Client in the same repo. In a real-world application, you would likely have a separate repo for the MCP Server and MCP Client. In fact, you might only build one of these components.";return{c(){p=M("p"),p.textContent=r},l(y){p=i(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-4xwc5k"&&(p.textContent=r)},m(y,u){e(y,p,u)},p:Lt,d(y){y&&s(p)}}}function We(C){let p,r="The <code>stdio</code> connection type means the agent starts your MCP server as a subprocess and communicates with it through standard input/output. This is perfect for development and single-machine deployments.";return{c(){p=M("p"),p.innerHTML=r},l(y){p=i(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-oyis2i"&&(p.innerHTML=r)},m(y,u){e(y,p,u)},p:Lt,d(y){y&&s(p)}}}function _e(C){let p,r="Processing both the comment and discussion title increases our chances of catching relevant tags. Users might mention tags in the title like “Missing pytorch tag” or in comments like “This needs #transformers”.";return{c(){p=M("p"),p.textContent=r},l(y){p=i(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-3tutm2"&&(p.textContent=r)},m(y,u){e(y,p,u)},p:Lt,d(y){y&&s(p)}}}function Ee(C){let p,r="Webhook endpoints should respond within 10 seconds or the platform may consider them timed out. Using background tasks ensures you can always respond quickly while handling complex processing asynchronously.";return{c(){p=M("p"),p.textContent=r},l(y){p=i(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-337a4i"&&(p.textContent=r)},m(y,u){e(y,p,u)},p:Lt,d(y){y&&s(p)}}}function qe(C){let p,r="The Agent class from <code>huggingface_hub</code> provides both MCP tool integration and language model reasoning, making it perfect for building intelligent automation workflows like our PR agent.";return{c(){p=M("p"),p.innerHTML=r},l(y){p=i(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1mc8wky"&&(p.innerHTML=r)},m(y,u){e(y,p,u)},p:Lt,d(y){y&&s(p)}}}function Ne(C){let p,r,y,u,f,Kt,B,gs="Now that we have our MCP server with tagging tools, we need to create a client that can interact with these tools. The MCP client serves as the bridge between our webhook handler and the MCP server, enabling our agent to use the Hub tagging functionality.",Dt,Z,As="For the sake of this project, we’ll build both an API and a Gradio app. The API will be used to test the MCP server and the webhook listener, and the Gradio app will be used to test the MCP client with simulated webhook events.",Ot,d,tl,v,ll,k,bs="In our application, the MCP client is integrated into the main FastAPI application (<code>app.py</code>). It creates and manages connections to our MCP server, providing a seamless interface for tool execution.",sl,$,fs='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit3/app.png" alt="MCP Client Integration"/>',el,x,nl,G,Bs="We use the <code>huggingface_hub</code> Agent class that has built-in MCP support. This provides both language model capabilities and MCP tool integration in a single component.",al,W,Ml,_,Zs="Let’s start by setting up the agent configuration and understanding each component:",il,E,ol,q,vs="We start with the necessary imports and configuration. The global <code>agent_instance</code> variable ensures we create the agent only once and reuse it across multiple requests. This is important for performance since agent initialization can be expensive.",pl,N,ks="Now let’s implement the function that creates and manages our agent:",yl,R,Jl,Q,$s="The function starts by checking if we already have an agent instance. This singleton pattern prevents unnecessary recreations and ensures consistent state.",Tl,X,xs="Let’s continue with the agent creation:",wl,Y,jl,V,Gs="This is where the important part happens! Let’s break down the Agent configuration:",Ul,H,Ws="<strong>Agent Parameters:</strong>",cl,F,_s="<li><code>model</code>: The language model that will reason about tool usage</li> <li><code>provider</code>: How to access the model (Hugging Face Inference Providers)</li> <li><code>api_key</code>: Hugging Face API key</li>",rl,S,Es="<strong>MCP Server Connection:</strong>",Il,z,qs="<li><code>type: &quot;stdio&quot;</code>: Connect to the MCP server via standard input/output</li> <li><code>command: &quot;python&quot;</code>: Run our MCP server as a Python subprocess</li> <li><code>args: [&quot;mcp_server.py&quot;]</code>: The script file to execute</li> <li><code>env</code>: Pass the HF_TOKEN to the server process</li>",ul,m,Cl,P,Ns="The <code>load_tools()</code> call is crucial - it discovers what tools are available from the MCP server and makes them accessible to the agent’s reasoning engine.",hl,L,Rs="This completes our agent management function with proper error handling and logging.",dl,K,ml,D,Qs="Once the agent is created and tools are loaded, it can automatically discover and use the MCP tools. This is where the real power of the Agent approach shines.",gl,O,Al,tt,Xs="The agent discovers our MCP tools automatically:",bl,lt,Ys="<li><code>get_current_tags(repo_id: str)</code> - Retrieve existing repository tags</li> <li><code>add_new_tag(repo_id: str, new_tag: str)</code> - Add new tag via pull request</li>",fl,st,Vs="The agent doesn’t just call these tools blindly - it reasons about when and how to use them based on the prompt you give it.",Bl,et,Zl,nt,Hs="Here’s how the agent intelligently uses tools:",vl,at,kl,Mt,Fs="Notice how we give the agent a natural language instruction, and it figures out:",$l,it,Ss="<li>First call <code>get_current_tags</code> to see what tags exist</li> <li>Check if <code>conversational-ai</code> is already there</li> <li>If not, call <code>add_new_tag</code> to add it</li> <li>Provide a summary of what it did</li>",xl,ot,zs="This is much more intelligent than calling tools directly!",Gl,pt,Wl,yt,Ps="Now let’s see how the MCP client integrates into our webhook processing pipeline. This is where everything comes together.",_l,Jt,El,Tt,Ls="Here’s the main function that processes webhook events and uses our MCP agent:",ql,wt,Nl,jt,Ks="This first part extracts and combines tags from both the comment content and discussion title. We use a set to deduplicate any tags that appear in both places.",Rl,g,Ql,Ut,Ds="Next, we get our agent and process each tag:",Xl,ct,Yl,rt,Os="The key insight here is that we give the agent a clear, structured prompt for each tag. The agent then:",Vl,It,te="<li>Understands it needs to check the current tags first</li> <li>Compares with the new tag we want to add</li> <li>Creates a pull request if needed</li> <li>Returns a summary of its actions</li>",Hl,ut,le="This approach handles the complexity of tool orchestration automatically.",Fl,Ct,Sl,ht,se="Let’s examine the tag extraction logic that feeds into our MCP processing:",zl,dt,Pl,mt,ee="This curated list of recognized tags helps us focus on relevant ML/AI tags and avoid adding inappropriate tags to repositories.",Ll,gt,ne="Now the extraction function itself:",Kl,At,Dl,bt,ae="This function uses multiple strategies to extract tags:",Ol,ft,Me="<li><strong>Explicit patterns</strong>: “tags: pytorch, transformers” or “tag: nlp”</li> <li><strong>Hashtags</strong>: “#pytorch #nlp”</li> <li><strong>Natural mentions</strong>: “This transformers model does text-generation”</li>",ts,Bt,ie="The validation step ensures we only suggest appropriate tags, preventing spam or irrelevant tags from being added.",ls,Zt,ss,vt,oe="When building production MCP clients, performance is critical for maintaining responsive webhook processing. Let’s look at some of the considerations we’ve made.",es,kt,ns,$t,pe="The agent is created once and reused to avoid:",as,xt,ye="<li>Repeated MCP server startup overhead</li> <li>Tool loading delays</li> <li>Connection establishment costs</li>",Ms,Gt,Je="This pattern is essential for webhook handlers that need to respond quickly.",is,Wt,os,_t,Te="All MCP operations are async to:",ps,Et,we="<li>Handle multiple webhook requests concurrently</li> <li>Avoid blocking the main FastAPI thread</li> <li>Provide responsive webhook responses</li>",ys,qt,je="The async nature allows your webhook handler to accept new requests while processing tags in the background.",Js,Nt,Ts,Rt,Ue="FastAPI has a built in <code>BackgroundTasks</code> class that can be used to run tasks in the background. This is useful for running long running tasks without blocking the main thread.",ws,Qt,js,Xt,ce="This pattern ensures webhook responses are fast (under 1 second) while allowing complex tag processing to happen in the background.",Us,A,cs,Yt,rs,Vt,re="With our MCP client implemented, we can now:",Is,Ht,Ie="<li><strong>Implement the Webhook Listener</strong> - Create the FastAPI endpoint that receives Hub events</li> <li><strong>Integrate Everything</strong> - Connect webhooks, client, and server into a complete system</li> <li><strong>Add Testing Interface</strong> - Create a Gradio interface for development and monitoring</li> <li><strong>Deploy and Test</strong> - Validate the complete system in production</li>",us,Ft,ue="In the next section, we’ll implement the webhook listener that will trigger our MCP-powered tagging agent.",Cs,b,hs,St,ds,zt,ms;return f=new I({props:{title:"MCP Client",local:"mcp-client",headingTag:"h1"}}),d=new Pt({props:{$$slots:{default:[Ge]},$$scope:{ctx:C}}}),v=new I({props:{title:"Understanding the MCP Client Architecture",local:"understanding-the-mcp-client-architecture",headingTag:"h2"}}),x=new I({props:{title:"Agent-Based MCP Client",local:"agent-based-mcp-client",headingTag:"h2"}}),W=new I({props:{title:"1. Agent Configuration",local:"1-agent-configuration",headingTag:"h3"}}),E=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5pbmZlcmVuY2UuX21jcC5hZ2VudCUyMGltcG9ydCUyMEFnZW50JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTJDJTIwTGl0ZXJhbCUwQSUwQSUyMyUyMENvbmZpZ3VyYXRpb24lMEFIRl9UT0tFTiUyMCUzRCUyMG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMEFIRl9NT0RFTCUyMCUzRCUyMG9zLmdldGVudiglMjJIRl9NT0RFTCUyMiUyQyUyMCUyMm1pY3Jvc29mdCUyRkRpYWxvR1BULW1lZGl1bSUyMiklMEFERUZBVUxUX1BST1ZJREVSJTNBJTIwTGl0ZXJhbCU1QiUyMmhmLWluZmVyZW5jZSUyMiU1RCUyMCUzRCUyMCUyMmhmLWluZmVyZW5jZSUyMiUwQSUwQSUyMyUyMEdsb2JhbCUyMGFnZW50JTIwaW5zdGFuY2UlMEFhZ2VudF9pbnN0YW5jZSUzQSUyME9wdGlvbmFsJTVCQWdlbnQlNUQlMjAlM0QlMjBOb25l",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub.inference._mcp.agent <span class="hljs-keyword">import</span> Agent
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Literal</span>

<span class="hljs-comment"># Configuration</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
HF_MODEL = os.getenv(<span class="hljs-string">&quot;HF_MODEL&quot;</span>, <span class="hljs-string">&quot;microsoft/DialoGPT-medium&quot;</span>)
DEFAULT_PROVIDER: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;hf-inference&quot;</span>] = <span class="hljs-string">&quot;hf-inference&quot;</span>

<span class="hljs-comment"># Global agent instance</span>
agent_instance: <span class="hljs-type">Optional</span>[Agent] = <span class="hljs-literal">None</span>`,wrap:!1}}),R=new h({props:{code:"YXN5bmMlMjBkZWYlMjBnZXRfYWdlbnQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMG9yJTIwY3JlYXRlJTIwQWdlbnQlMjBpbnN0YW5jZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVGMCU5RiVBNCU5NiUyMGdldF9hZ2VudCgpJTIwY2FsbGVkLi4uJTIyKSUwQSUyMCUyMCUyMCUyMGdsb2JhbCUyMGFnZW50X2luc3RhbmNlJTBBJTIwJTIwJTIwJTIwaWYlMjBhZ2VudF9pbnN0YW5jZSUyMGlzJTIwTm9uZSUyMGFuZCUyMEhGX1RPS0VOJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJTk0JUE3JTIwQ3JlYXRpbmclMjBuZXclMjBBZ2VudCUyMGluc3RhbmNlLi4uJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlOTElMjBIRl9UT0tFTiUyMHByZXNlbnQlM0ElMjAlN0Jib29sKEhGX1RPS0VOKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJUE0JTk2JTIwTW9kZWwlM0ElMjAlN0JIRl9NT0RFTCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTk0JTk3JTIwUHJvdmlkZXIlM0ElMjAlN0JERUZBVUxUX1BST1ZJREVSJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_agent</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get or create Agent instance&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🤖 get_agent() called...&quot;</span>)
    <span class="hljs-keyword">global</span> agent_instance
    <span class="hljs-keyword">if</span> agent_instance <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> HF_TOKEN:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Creating new Agent instance...&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔑 HF_TOKEN present: <span class="hljs-subst">{<span class="hljs-built_in">bool</span>(HF_TOKEN)}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Model: <span class="hljs-subst">{HF_MODEL}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔗 Provider: <span class="hljs-subst">{DEFAULT_PROVIDER}</span>&quot;</span>)`,wrap:!1}}),Y=new h({props:{code:"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",highlighted:`        <span class="hljs-keyword">try</span>:
            agent_instance = Agent(
                model=HF_MODEL,
                provider=DEFAULT_PROVIDER,
                api_key=HF_TOKEN,
                servers=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;stdio&quot;</span>,
                        <span class="hljs-string">&quot;config&quot;</span>: {
                            <span class="hljs-string">&quot;command&quot;</span>: <span class="hljs-string">&quot;python&quot;</span>,
                            <span class="hljs-string">&quot;args&quot;</span>: [<span class="hljs-string">&quot;mcp_server.py&quot;</span>],
                            <span class="hljs-string">&quot;cwd&quot;</span>: <span class="hljs-string">&quot;.&quot;</span>,
                            <span class="hljs-string">&quot;env&quot;</span>: {<span class="hljs-string">&quot;HF_TOKEN&quot;</span>: HF_TOKEN} <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> {},
                        },
                    }
                ],
            )
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Agent instance created successfully&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Loading tools...&quot;</span>)
            <span class="hljs-keyword">await</span> agent_instance.load_tools()
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Tools loaded successfully&quot;</span>)
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error creating/loading agent: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
            agent_instance = <span class="hljs-literal">None</span>`,wrap:!1}}),m=new Pt({props:{$$slots:{default:[We]},$$scope:{ctx:C}}}),K=new I({props:{title:"Tool Discovery and Usage",local:"tool-discovery-and-usage",headingTag:"h2"}}),O=new I({props:{title:"Available Tools",local:"available-tools",headingTag:"h3"}}),et=new I({props:{title:"Tool Execution Example",local:"tool-execution-example",headingTag:"h3"}}),at=new h({props:{code:"JTIzJTIwRXhhbXBsZSUyMG9mJTIwaG93JTIwdGhlJTIwYWdlbnQlMjB3b3VsZCUyMHVzZSUyMHRvb2xzJTBBYXN5bmMlMjBkZWYlMjBleGFtcGxlX3Rvb2xfdXNhZ2UoKSUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwYXdhaXQlMjBnZXRfYWdlbnQoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGlmJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBhZ2VudCUyMGNhbiUyMHJlYXNvbiUyMGFib3V0JTIwd2hpY2glMjB0b29scyUyMHRvJTIwdXNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB0YWdzJTIwZm9yJTIwbWljcm9zb2Z0JTJGRGlhbG9HUFQtbWVkaXVtJTIwYW5kJTIwYWRkJTIwdGhlJTIwdGFnJTIwJ2NvbnZlcnNhdGlvbmFsLWFpJyUyMGlmJTIwaXQncyUyMG5vdCUyMGFscmVhZHklMjBwcmVzZW50JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-comment"># Example of how the agent would use tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">example_tool_usage</span>():
    agent = <span class="hljs-keyword">await</span> get_agent()
    
    <span class="hljs-keyword">if</span> agent:
        <span class="hljs-comment"># The agent can reason about which tools to use</span>
        response = <span class="hljs-keyword">await</span> agent.run(
            <span class="hljs-string">&quot;Check the current tags for microsoft/DialoGPT-medium and add the tag &#x27;conversational-ai&#x27; if it&#x27;s not already present&quot;</span>
        )
        <span class="hljs-built_in">print</span>(response)`,wrap:!1}}),pt=new I({props:{title:"Integration with Webhook Processing",local:"integration-with-webhook-processing",headingTag:"h2"}}),Jt=new I({props:{title:"1. Tag Extraction and Processing",local:"1-tag-extraction-and-processing",headingTag:"h3"}}),wt=new h({props:{code:"YXN5bmMlMjBkZWYlMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudCh3ZWJob29rX2RhdGElM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlByb2Nlc3MlMjB3ZWJob29rJTIwdG8lMjBkZXRlY3QlMjBhbmQlMjBhZGQlMjB0YWdzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJThGJUI3JUVGJUI4JThGJTIwU3RhcnRpbmclMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudC4uLiUyMiklMEElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21tZW50X2NvbnRlbnQlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJjb21tZW50JTIyJTVEJTVCJTIyY29udGVudCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc2N1c3Npb25fdGl0bGUlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJkaXNjdXNzaW9uJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX25hbWUlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJyZXBvJTIyJTVEJTVCJTIybmFtZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjBwb3RlbnRpYWwlMjB0YWdzJTIwZnJvbSUyMHRoZSUyMGNvbW1lbnQlMjBhbmQlMjBkaXNjdXNzaW9uJTIwdGl0bGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21tZW50X3RhZ3MlMjAlM0QlMjBleHRyYWN0X3RhZ3NfZnJvbV90ZXh0KGNvbW1lbnRfY29udGVudCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZV90YWdzJTIwJTNEJTIwZXh0cmFjdF90YWdzX2Zyb21fdGV4dChkaXNjdXNzaW9uX3RpdGxlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsbF90YWdzJTIwJTNEJTIwbGlzdChzZXQoY29tbWVudF90YWdzJTIwJTJCJTIwdGl0bGVfdGFncykpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCU4RCUyMEFsbCUyMHVuaXF1ZSUyMHRhZ3MlM0ElMjAlN0JhbGxfdGFncyU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGFsbF90YWdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTIyTm8lMjByZWNvZ25pemFibGUlMjB0YWdzJTIwZm91bmQlMjBpbiUyMHRoZSUyMGRpc2N1c3Npb24uJTIyJTVE",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_webhook_comment</span>(<span class="hljs-params">webhook_data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>):
    <span class="hljs-string">&quot;&quot;&quot;Process webhook to detect and add tags&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🏷️ Starting process_webhook_comment...&quot;</span>)

    <span class="hljs-keyword">try</span>:
        comment_content = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]
        discussion_title = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        repo_name = webhook_data[<span class="hljs-string">&quot;repo&quot;</span>][<span class="hljs-string">&quot;name&quot;</span>]
        
        <span class="hljs-comment"># Extract potential tags from the comment and discussion title</span>
        comment_tags = extract_tags_from_text(comment_content)
        title_tags = extract_tags_from_text(discussion_title)
        all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(comment_tags + title_tags))

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 All unique tags: <span class="hljs-subst">{all_tags}</span>&quot;</span>)

        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> all_tags:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;No recognizable tags found in the discussion.&quot;</span>]`,wrap:!1}}),g=new Pt({props:{$$slots:{default:[_e]},$$scope:{ctx:C}}}),ct=new h({props:{code:"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",highlighted:`        <span class="hljs-comment"># Get agent instance</span>
        agent = <span class="hljs-keyword">await</span> get_agent()
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> agent:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;Error: Agent not configured (missing HF_TOKEN)&quot;</span>]

        <span class="hljs-comment"># Process each tag</span>
        result_messages = []
        <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
            <span class="hljs-keyword">try</span>:
                <span class="hljs-comment"># Use agent to process the tag</span>
                prompt = <span class="hljs-string">f&quot;&quot;&quot;
                For the repository &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;, check if the tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; already exists.
                If it doesn&#x27;t exist, add it via a pull request.
                
                Repository: <span class="hljs-subst">{repo_name}</span>
                Tag to check/add: <span class="hljs-subst">{tag}</span>
                &quot;&quot;&quot;</span>
                
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; for repo &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;&quot;</span>)
                response = <span class="hljs-keyword">await</span> agent.run(prompt)
                
                <span class="hljs-comment"># Parse agent response for success/failure</span>
                <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;success&quot;</span> <span class="hljs-keyword">in</span> response.lower():
                    result_messages.append(<span class="hljs-string">f&quot;✅ Tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; processed successfully&quot;</span>)
                <span class="hljs-keyword">else</span>:
                    result_messages.append(<span class="hljs-string">f&quot;⚠️ Issue with tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{response}</span>&quot;</span>)
                    
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                error_msg = <span class="hljs-string">f&quot;❌ Error processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
                <span class="hljs-built_in">print</span>(error_msg)
                result_messages.append(error_msg)

        <span class="hljs-keyword">return</span> result_messages`,wrap:!1}}),Ct=new I({props:{title:"2. Tag Extraction Logic",local:"2-tag-extraction-logic",headingTag:"h3"}}),dt=new h({props:{code:"aW1wb3J0JTIwcmUlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQSUyMyUyMFJlY29nbml6ZWQlMjBNTCUyRkFJJTIwdGFncyUyMGZvciUyMHZhbGlkYXRpb24lMEFSRUNPR05JWkVEX1RBR1MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJweXRvcmNoJTIyJTJDJTIwJTIydGVuc29yZmxvdyUyMiUyQyUyMCUyMmpheCUyMiUyQyUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmlsbC1tYXNrJTIyJTJDJTIwJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbiUyMiUyQyUyMCUyMnN1bW1hcml6YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjAlMjJzZW50ZW5jZS1zaW1pbGFyaXR5JTIyJTJDJTIwJTIyemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2UtdG8tdGV4dCUyMiUyQyUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjAlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvaWNlLWFjdGl2aXR5LWRldGVjdGlvbiUyMiUyQyUyMCUyMmRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjAlMjJpbWFnZS1zZWdtZW50YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ2aWRlby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnJlaW5mb3JjZW1lbnQtbGVhcm5pbmclMjIlMkMlMjAlMjJ0YWJ1bGFyLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFidWxhci1yZWdyZXNzaW9uJTIyJTJDJTIwJTIydGltZS1zZXJpZXMtZm9yZWNhc3RpbmclMjIlMkMlMjAlMjJncmFwaC1tbCUyMiUyQyUyMCUyMnJvYm90aWNzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcHV0ZXItdmlzaW9uJTIyJTJDJTIwJTIybmxwJTIyJTJDJTIwJTIyY3YlMjIlMkMlMjAlMjJtdWx0aW1vZGFsJTIyJTJDJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-comment"># Recognized ML/AI tags for validation</span>
RECOGNIZED_TAGS = {
    <span class="hljs-string">&quot;pytorch&quot;</span>, <span class="hljs-string">&quot;tensorflow&quot;</span>, <span class="hljs-string">&quot;jax&quot;</span>, <span class="hljs-string">&quot;transformers&quot;</span>, <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;question-answering&quot;</span>,
    <span class="hljs-string">&quot;text-to-image&quot;</span>, <span class="hljs-string">&quot;image-classification&quot;</span>, <span class="hljs-string">&quot;object-detection&quot;</span>,
    <span class="hljs-string">&quot;fill-mask&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>, <span class="hljs-string">&quot;translation&quot;</span>, <span class="hljs-string">&quot;summarization&quot;</span>,
    <span class="hljs-string">&quot;feature-extraction&quot;</span>, <span class="hljs-string">&quot;sentence-similarity&quot;</span>, <span class="hljs-string">&quot;zero-shot-classification&quot;</span>,
    <span class="hljs-string">&quot;image-to-text&quot;</span>, <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, <span class="hljs-string">&quot;audio-classification&quot;</span>,
    <span class="hljs-string">&quot;voice-activity-detection&quot;</span>, <span class="hljs-string">&quot;depth-estimation&quot;</span>, <span class="hljs-string">&quot;image-segmentation&quot;</span>,
    <span class="hljs-string">&quot;video-classification&quot;</span>, <span class="hljs-string">&quot;reinforcement-learning&quot;</span>, <span class="hljs-string">&quot;tabular-classification&quot;</span>,
    <span class="hljs-string">&quot;tabular-regression&quot;</span>, <span class="hljs-string">&quot;time-series-forecasting&quot;</span>, <span class="hljs-string">&quot;graph-ml&quot;</span>, <span class="hljs-string">&quot;robotics&quot;</span>,
    <span class="hljs-string">&quot;computer-vision&quot;</span>, <span class="hljs-string">&quot;nlp&quot;</span>, <span class="hljs-string">&quot;cv&quot;</span>, <span class="hljs-string">&quot;multimodal&quot;</span>,
}`,wrap:!1}}),At=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_tags_from_text</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;Extract potential tags from discussion text&quot;&quot;&quot;</span>
    text_lower = text.lower()
    explicit_tags = []

    <span class="hljs-comment"># Pattern 1: &quot;tag: something&quot; or &quot;tags: something&quot;</span>
    tag_pattern = <span class="hljs-string">r&quot;tags?:\\s*([a-zA-Z0-9-_,\\s]+)&quot;</span>
    matches = re.findall(tag_pattern, text_lower)
    <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches:
        tags = [tag.strip() <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> <span class="hljs-keyword">match</span>.split(<span class="hljs-string">&quot;,&quot;</span>)]
        explicit_tags.extend(tags)

    <span class="hljs-comment"># Pattern 2: &quot;#hashtag&quot; style</span>
    hashtag_pattern = <span class="hljs-string">r&quot;#([a-zA-Z0-9-_]+)&quot;</span>
    hashtag_matches = re.findall(hashtag_pattern, text_lower)
    explicit_tags.extend(hashtag_matches)

    <span class="hljs-comment"># Pattern 3: Look for recognized tags mentioned in natural text</span>
    mentioned_tags = []
    <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> RECOGNIZED_TAGS:
        <span class="hljs-keyword">if</span> tag <span class="hljs-keyword">in</span> text_lower:
            mentioned_tags.append(tag)

    <span class="hljs-comment"># Combine and deduplicate</span>
    all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(explicit_tags + mentioned_tags))

    <span class="hljs-comment"># Filter to only include recognized tags or explicitly mentioned ones</span>
    valid_tags = []
    <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
        <span class="hljs-keyword">if</span> tag <span class="hljs-keyword">in</span> RECOGNIZED_TAGS <span class="hljs-keyword">or</span> tag <span class="hljs-keyword">in</span> explicit_tags:
            valid_tags.append(tag)

    <span class="hljs-keyword">return</span> valid_tags`,wrap:!1}}),Zt=new I({props:{title:"Performance Considerations",local:"performance-considerations",headingTag:"h2"}}),kt=new I({props:{title:"1. Agent Singleton Pattern",local:"1-agent-singleton-pattern",headingTag:"h3"}}),Wt=new I({props:{title:"2. Async Processing",local:"2-async-processing",headingTag:"h3"}}),Nt=new I({props:{title:"3. Background Task Processing",local:"3-background-task-processing",headingTag:"h3"}}),Qt=new h({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBCYWNrZ3JvdW5kVGFza3MlMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwd2ViaG9va19oYW5kbGVyKHJlcXVlc3QlM0ElMjBSZXF1ZXN0JTJDJTIwYmFja2dyb3VuZF90YXNrcyUzQSUyMEJhY2tncm91bmRUYXNrcyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJIYW5kbGUlMjB3ZWJob29rJTIwYW5kJTIwcHJvY2VzcyUyMGluJTIwYmFja2dyb3VuZCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFZhbGlkYXRlJTIwd2ViaG9vayUyMHF1aWNrbHklMEElMjAlMjAlMjAlMjBpZiUyMHJlcXVlc3QuaGVhZGVycy5nZXQoJTIyWC1XZWJob29rLVNlY3JldCUyMiklMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMkludmFsaWQlMjBzZWNyZXQlMjIlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB3ZWJob29rX2RhdGElMjAlM0QlMjBhd2FpdCUyMHJlcXVlc3QuanNvbigpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvY2VzcyUyMGluJTIwYmFja2dyb3VuZCUyMHRvJTIwcmV0dXJuJTIwcXVpY2tseSUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmRfdGFza3MuYWRkX3Rhc2socHJvY2Vzc193ZWJob29rX2NvbW1lbnQlMkMlMjB3ZWJob29rX2RhdGEpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyc3RhdHVzJTIyJTNBJTIwJTIyYWNjZXB0ZWQlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> BackgroundTasks

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">webhook_handler</span>(<span class="hljs-params">request: Request, background_tasks: BackgroundTasks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Handle webhook and process in background&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Validate webhook quickly</span>
    <span class="hljs-keyword">if</span> request.headers.get(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>) != WEBHOOK_SECRET:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;Invalid secret&quot;</span>}
    
    webhook_data = <span class="hljs-keyword">await</span> request.json()
    
    <span class="hljs-comment"># Process in background to return quickly</span>
    background_tasks.add_task(process_webhook_comment, webhook_data)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;accepted&quot;</span>}`,wrap:!1}}),A=new Pt({props:{$$slots:{default:[Ee]},$$scope:{ctx:C}}}),Yt=new I({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),b=new Pt({props:{$$slots:{default:[qe]},$$scope:{ctx:C}}}),St=new xe({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/mcp-client.mdx"}}),{c(){p=M("meta"),r=n(),y=M("p"),u=n(),J(f.$$.fragment),Kt=n(),B=M("p"),B.textContent=gs,Dt=n(),Z=M("p"),Z.textContent=As,Ot=n(),J(d.$$.fragment),tl=n(),J(v.$$.fragment),ll=n(),k=M("p"),k.innerHTML=bs,sl=n(),$=M("p"),$.innerHTML=fs,el=n(),J(x.$$.fragment),nl=n(),G=M("p"),G.innerHTML=Bs,al=n(),J(W.$$.fragment),Ml=n(),_=M("p"),_.textContent=Zs,il=n(),J(E.$$.fragment),ol=n(),q=M("p"),q.innerHTML=vs,pl=n(),N=M("p"),N.textContent=ks,yl=n(),J(R.$$.fragment),Jl=n(),Q=M("p"),Q.textContent=$s,Tl=n(),X=M("p"),X.textContent=xs,wl=n(),J(Y.$$.fragment),jl=n(),V=M("p"),V.textContent=Gs,Ul=n(),H=M("p"),H.innerHTML=Ws,cl=n(),F=M("ul"),F.innerHTML=_s,rl=n(),S=M("p"),S.innerHTML=Es,Il=n(),z=M("ul"),z.innerHTML=qs,ul=n(),J(m.$$.fragment),Cl=n(),P=M("p"),P.innerHTML=Ns,hl=n(),L=M("p"),L.textContent=Rs,dl=n(),J(K.$$.fragment),ml=n(),D=M("p"),D.textContent=Qs,gl=n(),J(O.$$.fragment),Al=n(),tt=M("p"),tt.textContent=Xs,bl=n(),lt=M("ul"),lt.innerHTML=Ys,fl=n(),st=M("p"),st.textContent=Vs,Bl=n(),J(et.$$.fragment),Zl=n(),nt=M("p"),nt.textContent=Hs,vl=n(),J(at.$$.fragment),kl=n(),Mt=M("p"),Mt.textContent=Fs,$l=n(),it=M("ol"),it.innerHTML=Ss,xl=n(),ot=M("p"),ot.textContent=zs,Gl=n(),J(pt.$$.fragment),Wl=n(),yt=M("p"),yt.textContent=Ps,_l=n(),J(Jt.$$.fragment),El=n(),Tt=M("p"),Tt.textContent=Ls,ql=n(),J(wt.$$.fragment),Nl=n(),jt=M("p"),jt.textContent=Ks,Rl=n(),J(g.$$.fragment),Ql=n(),Ut=M("p"),Ut.textContent=Ds,Xl=n(),J(ct.$$.fragment),Yl=n(),rt=M("p"),rt.textContent=Os,Vl=n(),It=M("ol"),It.innerHTML=te,Hl=n(),ut=M("p"),ut.textContent=le,Fl=n(),J(Ct.$$.fragment),Sl=n(),ht=M("p"),ht.textContent=se,zl=n(),J(dt.$$.fragment),Pl=n(),mt=M("p"),mt.textContent=ee,Ll=n(),gt=M("p"),gt.textContent=ne,Kl=n(),J(At.$$.fragment),Dl=n(),bt=M("p"),bt.textContent=ae,Ol=n(),ft=M("ol"),ft.innerHTML=Me,ts=n(),Bt=M("p"),Bt.textContent=ie,ls=n(),J(Zt.$$.fragment),ss=n(),vt=M("p"),vt.textContent=oe,es=n(),J(kt.$$.fragment),ns=n(),$t=M("p"),$t.textContent=pe,as=n(),xt=M("ul"),xt.innerHTML=ye,Ms=n(),Gt=M("p"),Gt.textContent=Je,is=n(),J(Wt.$$.fragment),os=n(),_t=M("p"),_t.textContent=Te,ps=n(),Et=M("ul"),Et.innerHTML=we,ys=n(),qt=M("p"),qt.textContent=je,Js=n(),J(Nt.$$.fragment),Ts=n(),Rt=M("p"),Rt.innerHTML=Ue,ws=n(),J(Qt.$$.fragment),js=n(),Xt=M("p"),Xt.textContent=ce,Us=n(),J(A.$$.fragment),cs=n(),J(Yt.$$.fragment),rs=n(),Vt=M("p"),Vt.textContent=re,Is=n(),Ht=M("ol"),Ht.innerHTML=Ie,us=n(),Ft=M("p"),Ft.textContent=ue,Cs=n(),J(b.$$.fragment),hs=n(),J(St.$$.fragment),ds=n(),zt=M("p"),this.h()},l(t){const l=ke("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(s),r=a(t),y=i(t,"P",{}),Ae(y).forEach(s),u=a(t),T(f.$$.fragment,t),Kt=a(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-o5mfkz"&&(B.textContent=gs),Dt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1tiz43l"&&(Z.textContent=As),Ot=a(t),T(d.$$.fragment,t),tl=a(t),T(v.$$.fragment,t),ll=a(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-sk08k0"&&(k.innerHTML=bs),sl=a(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-g1jj0m"&&($.innerHTML=fs),el=a(t),T(x.$$.fragment,t),nl=a(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ipr9ey"&&(G.innerHTML=Bs),al=a(t),T(W.$$.fragment,t),Ml=a(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-zgdnms"&&(_.textContent=Zs),il=a(t),T(E.$$.fragment,t),ol=a(t),q=i(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1k99sys"&&(q.innerHTML=vs),pl=a(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1kuar4n"&&(N.textContent=ks),yl=a(t),T(R.$$.fragment,t),Jl=a(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1kzsmkd"&&(Q.textContent=$s),Tl=a(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-d22zqt"&&(X.textContent=xs),wl=a(t),T(Y.$$.fragment,t),jl=a(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1uv0eq9"&&(V.textContent=Gs),Ul=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-7oshyu"&&(H.innerHTML=Ws),cl=a(t),F=i(t,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-r83xmx"&&(F.innerHTML=_s),rl=a(t),S=i(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1872chq"&&(S.innerHTML=Es),Il=a(t),z=i(t,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-s9520z"&&(z.innerHTML=qs),ul=a(t),T(m.$$.fragment,t),Cl=a(t),P=i(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-h2m3sn"&&(P.innerHTML=Ns),hl=a(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-12j4xsp"&&(L.textContent=Rs),dl=a(t),T(K.$$.fragment,t),ml=a(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-qaqek9"&&(D.textContent=Qs),gl=a(t),T(O.$$.fragment,t),Al=a(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1b55wgg"&&(tt.textContent=Xs),bl=a(t),lt=i(t,"UL",{"data-svelte-h":!0}),o(lt)!=="svelte-1uktuvs"&&(lt.innerHTML=Ys),fl=a(t),st=i(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-k2412b"&&(st.textContent=Vs),Bl=a(t),T(et.$$.fragment,t),Zl=a(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1bm9ul5"&&(nt.textContent=Hs),vl=a(t),T(at.$$.fragment,t),kl=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-hzu4xy"&&(Mt.textContent=Fs),$l=a(t),it=i(t,"OL",{"data-svelte-h":!0}),o(it)!=="svelte-1om1rwe"&&(it.innerHTML=Ss),xl=a(t),ot=i(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1pgsrpk"&&(ot.textContent=zs),Gl=a(t),T(pt.$$.fragment,t),Wl=a(t),yt=i(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-d5c1ft"&&(yt.textContent=Ps),_l=a(t),T(Jt.$$.fragment,t),El=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-xrdu6q"&&(Tt.textContent=Ls),ql=a(t),T(wt.$$.fragment,t),Nl=a(t),jt=i(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-4cm3gu"&&(jt.textContent=Ks),Rl=a(t),T(g.$$.fragment,t),Ql=a(t),Ut=i(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-65h1kx"&&(Ut.textContent=Ds),Xl=a(t),T(ct.$$.fragment,t),Yl=a(t),rt=i(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-ty7tki"&&(rt.textContent=Os),Vl=a(t),It=i(t,"OL",{"data-svelte-h":!0}),o(It)!=="svelte-e2mg28"&&(It.innerHTML=te),Hl=a(t),ut=i(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-16ed2bp"&&(ut.textContent=le),Fl=a(t),T(Ct.$$.fragment,t),Sl=a(t),ht=i(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1hplsxl"&&(ht.textContent=se),zl=a(t),T(dt.$$.fragment,t),Pl=a(t),mt=i(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1q4pd90"&&(mt.textContent=ee),Ll=a(t),gt=i(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-149cgcf"&&(gt.textContent=ne),Kl=a(t),T(At.$$.fragment,t),Dl=a(t),bt=i(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-fgnove"&&(bt.textContent=ae),Ol=a(t),ft=i(t,"OL",{"data-svelte-h":!0}),o(ft)!=="svelte-1dk0z4o"&&(ft.innerHTML=Me),ts=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1wl0e0h"&&(Bt.textContent=ie),ls=a(t),T(Zt.$$.fragment,t),ss=a(t),vt=i(t,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1x0jdeh"&&(vt.textContent=oe),es=a(t),T(kt.$$.fragment,t),ns=a(t),$t=i(t,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1bw24v8"&&($t.textContent=pe),as=a(t),xt=i(t,"UL",{"data-svelte-h":!0}),o(xt)!=="svelte-1j5mius"&&(xt.innerHTML=ye),Ms=a(t),Gt=i(t,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-2opepg"&&(Gt.textContent=Je),is=a(t),T(Wt.$$.fragment,t),os=a(t),_t=i(t,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-oqkbu0"&&(_t.textContent=Te),ps=a(t),Et=i(t,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-i1e590"&&(Et.innerHTML=we),ys=a(t),qt=i(t,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-lkn7k8"&&(qt.textContent=je),Js=a(t),T(Nt.$$.fragment,t),Ts=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1h2ni44"&&(Rt.innerHTML=Ue),ws=a(t),T(Qt.$$.fragment,t),js=a(t),Xt=i(t,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-fd134s"&&(Xt.textContent=ce),Us=a(t),T(A.$$.fragment,t),cs=a(t),T(Yt.$$.fragment,t),rs=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1vyqah1"&&(Vt.textContent=re),Is=a(t),Ht=i(t,"OL",{"data-svelte-h":!0}),o(Ht)!=="svelte-p0gh2q"&&(Ht.innerHTML=Ie),us=a(t),Ft=i(t,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-qg9wgy"&&(Ft.textContent=ue),Cs=a(t),T(b.$$.fragment,t),hs=a(t),T(St.$$.fragment,t),ds=a(t),zt=i(t,"P",{}),Ae(zt).forEach(s),this.h()},h(){be(p,"name","hf:doc:metadata"),be(p,"content",Re)},m(t,l){$e(document.head,p),e(t,r,l),e(t,y,l),e(t,u,l),w(f,t,l),e(t,Kt,l),e(t,B,l),e(t,Dt,l),e(t,Z,l),e(t,Ot,l),w(d,t,l),e(t,tl,l),w(v,t,l),e(t,ll,l),e(t,k,l),e(t,sl,l),e(t,$,l),e(t,el,l),w(x,t,l),e(t,nl,l),e(t,G,l),e(t,al,l),w(W,t,l),e(t,Ml,l),e(t,_,l),e(t,il,l),w(E,t,l),e(t,ol,l),e(t,q,l),e(t,pl,l),e(t,N,l),e(t,yl,l),w(R,t,l),e(t,Jl,l),e(t,Q,l),e(t,Tl,l),e(t,X,l),e(t,wl,l),w(Y,t,l),e(t,jl,l),e(t,V,l),e(t,Ul,l),e(t,H,l),e(t,cl,l),e(t,F,l),e(t,rl,l),e(t,S,l),e(t,Il,l),e(t,z,l),e(t,ul,l),w(m,t,l),e(t,Cl,l),e(t,P,l),e(t,hl,l),e(t,L,l),e(t,dl,l),w(K,t,l),e(t,ml,l),e(t,D,l),e(t,gl,l),w(O,t,l),e(t,Al,l),e(t,tt,l),e(t,bl,l),e(t,lt,l),e(t,fl,l),e(t,st,l),e(t,Bl,l),w(et,t,l),e(t,Zl,l),e(t,nt,l),e(t,vl,l),w(at,t,l),e(t,kl,l),e(t,Mt,l),e(t,$l,l),e(t,it,l),e(t,xl,l),e(t,ot,l),e(t,Gl,l),w(pt,t,l),e(t,Wl,l),e(t,yt,l),e(t,_l,l),w(Jt,t,l),e(t,El,l),e(t,Tt,l),e(t,ql,l),w(wt,t,l),e(t,Nl,l),e(t,jt,l),e(t,Rl,l),w(g,t,l),e(t,Ql,l),e(t,Ut,l),e(t,Xl,l),w(ct,t,l),e(t,Yl,l),e(t,rt,l),e(t,Vl,l),e(t,It,l),e(t,Hl,l),e(t,ut,l),e(t,Fl,l),w(Ct,t,l),e(t,Sl,l),e(t,ht,l),e(t,zl,l),w(dt,t,l),e(t,Pl,l),e(t,mt,l),e(t,Ll,l),e(t,gt,l),e(t,Kl,l),w(At,t,l),e(t,Dl,l),e(t,bt,l),e(t,Ol,l),e(t,ft,l),e(t,ts,l),e(t,Bt,l),e(t,ls,l),w(Zt,t,l),e(t,ss,l),e(t,vt,l),e(t,es,l),w(kt,t,l),e(t,ns,l),e(t,$t,l),e(t,as,l),e(t,xt,l),e(t,Ms,l),e(t,Gt,l),e(t,is,l),w(Wt,t,l),e(t,os,l),e(t,_t,l),e(t,ps,l),e(t,Et,l),e(t,ys,l),e(t,qt,l),e(t,Js,l),w(Nt,t,l),e(t,Ts,l),e(t,Rt,l),e(t,ws,l),w(Qt,t,l),e(t,js,l),e(t,Xt,l),e(t,Us,l),w(A,t,l),e(t,cs,l),w(Yt,t,l),e(t,rs,l),e(t,Vt,l),e(t,Is,l),e(t,Ht,l),e(t,us,l),e(t,Ft,l),e(t,Cs,l),w(b,t,l),e(t,hs,l),w(St,t,l),e(t,ds,l),e(t,zt,l),ms=!0},p(t,[l]){const Ce={};l&2&&(Ce.$$scope={dirty:l,ctx:t}),d.$set(Ce);const he={};l&2&&(he.$$scope={dirty:l,ctx:t}),m.$set(he);const de={};l&2&&(de.$$scope={dirty:l,ctx:t}),g.$set(de);const me={};l&2&&(me.$$scope={dirty:l,ctx:t}),A.$set(me);const ge={};l&2&&(ge.$$scope={dirty:l,ctx:t}),b.$set(ge)},i(t){ms||(j(f.$$.fragment,t),j(d.$$.fragment,t),j(v.$$.fragment,t),j(x.$$.fragment,t),j(W.$$.fragment,t),j(E.$$.fragment,t),j(R.$$.fragment,t),j(Y.$$.fragment,t),j(m.$$.fragment,t),j(K.$$.fragment,t),j(O.$$.fragment,t),j(et.$$.fragment,t),j(at.$$.fragment,t),j(pt.$$.fragment,t),j(Jt.$$.fragment,t),j(wt.$$.fragment,t),j(g.$$.fragment,t),j(ct.$$.fragment,t),j(Ct.$$.fragment,t),j(dt.$$.fragment,t),j(At.$$.fragment,t),j(Zt.$$.fragment,t),j(kt.$$.fragment,t),j(Wt.$$.fragment,t),j(Nt.$$.fragment,t),j(Qt.$$.fragment,t),j(A.$$.fragment,t),j(Yt.$$.fragment,t),j(b.$$.fragment,t),j(St.$$.fragment,t),ms=!0)},o(t){U(f.$$.fragment,t),U(d.$$.fragment,t),U(v.$$.fragment,t),U(x.$$.fragment,t),U(W.$$.fragment,t),U(E.$$.fragment,t),U(R.$$.fragment,t),U(Y.$$.fragment,t),U(m.$$.fragment,t),U(K.$$.fragment,t),U(O.$$.fragment,t),U(et.$$.fragment,t),U(at.$$.fragment,t),U(pt.$$.fragment,t),U(Jt.$$.fragment,t),U(wt.$$.fragment,t),U(g.$$.fragment,t),U(ct.$$.fragment,t),U(Ct.$$.fragment,t),U(dt.$$.fragment,t),U(At.$$.fragment,t),U(Zt.$$.fragment,t),U(kt.$$.fragment,t),U(Wt.$$.fragment,t),U(Nt.$$.fragment,t),U(Qt.$$.fragment,t),U(A.$$.fragment,t),U(Yt.$$.fragment,t),U(b.$$.fragment,t),U(St.$$.fragment,t),ms=!1},d(t){t&&(s(r),s(y),s(u),s(Kt),s(B),s(Dt),s(Z),s(Ot),s(tl),s(ll),s(k),s(sl),s($),s(el),s(nl),s(G),s(al),s(Ml),s(_),s(il),s(ol),s(q),s(pl),s(N),s(yl),s(Jl),s(Q),s(Tl),s(X),s(wl),s(jl),s(V),s(Ul),s(H),s(cl),s(F),s(rl),s(S),s(Il),s(z),s(ul),s(Cl),s(P),s(hl),s(L),s(dl),s(ml),s(D),s(gl),s(Al),s(tt),s(bl),s(lt),s(fl),s(st),s(Bl),s(Zl),s(nt),s(vl),s(kl),s(Mt),s($l),s(it),s(xl),s(ot),s(Gl),s(Wl),s(yt),s(_l),s(El),s(Tt),s(ql),s(Nl),s(jt),s(Rl),s(Ql),s(Ut),s(Xl),s(Yl),s(rt),s(Vl),s(It),s(Hl),s(ut),s(Fl),s(Sl),s(ht),s(zl),s(Pl),s(mt),s(Ll),s(gt),s(Kl),s(Dl),s(bt),s(Ol),s(ft),s(ts),s(Bt),s(ls),s(ss),s(vt),s(es),s(ns),s($t),s(as),s(xt),s(Ms),s(Gt),s(is),s(os),s(_t),s(ps),s(Et),s(ys),s(qt),s(Js),s(Ts),s(Rt),s(ws),s(js),s(Xt),s(Us),s(cs),s(rs),s(Vt),s(Is),s(Ht),s(us),s(Ft),s(Cs),s(hs),s(ds),s(zt)),s(p),c(f,t),c(d,t),c(v,t),c(x,t),c(W,t),c(E,t),c(R,t),c(Y,t),c(m,t),c(K,t),c(O,t),c(et,t),c(at,t),c(pt,t),c(Jt,t),c(wt,t),c(g,t),c(ct,t),c(Ct,t),c(dt,t),c(At,t),c(Zt,t),c(kt,t),c(Wt,t),c(Nt,t),c(Qt,t),c(A,t),c(Yt,t),c(b,t),c(St,t)}}}const Re='{"title":"MCP Client","local":"mcp-client","sections":[{"title":"Understanding the MCP Client Architecture","local":"understanding-the-mcp-client-architecture","sections":[],"depth":2},{"title":"Agent-Based MCP Client","local":"agent-based-mcp-client","sections":[{"title":"1. Agent Configuration","local":"1-agent-configuration","sections":[],"depth":3}],"depth":2},{"title":"Tool Discovery and Usage","local":"tool-discovery-and-usage","sections":[{"title":"Available Tools","local":"available-tools","sections":[],"depth":3},{"title":"Tool Execution Example","local":"tool-execution-example","sections":[],"depth":3}],"depth":2},{"title":"Integration with Webhook Processing","local":"integration-with-webhook-processing","sections":[{"title":"1. Tag Extraction and Processing","local":"1-tag-extraction-and-processing","sections":[],"depth":3},{"title":"2. Tag Extraction Logic","local":"2-tag-extraction-logic","sections":[],"depth":3}],"depth":2},{"title":"Performance Considerations","local":"performance-considerations","sections":[{"title":"1. Agent Singleton Pattern","local":"1-agent-singleton-pattern","sections":[],"depth":3},{"title":"2. Async Processing","local":"2-async-processing","sections":[],"depth":3},{"title":"3. Background Task Processing","local":"3-background-task-processing","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Qe(C){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends Ze{constructor(p){super(),ve(this,p,Qe,Ne,fe,{})}}export{Se as component};
