import{s as ut,n as Jt,o as dt}from"../chunks/scheduler.3e37077e.js";import{S as Tt,i as jt,g as n,s as a,r,A as Ut,h as i,f as l,c as o,j as yt,u as M,x as p,k as wt,y as bt,a as s,v as c,d as y,t as w,w as u}from"../chunks/index.263272b0.js";import{C as Qe}from"../chunks/CodeBlock.76c31e3c.js";import{H as d,E as mt}from"../chunks/getInferenceSnippets.932de0ac.js";function ft(xe){let J,te,O,le,T,se,j,ze="This guide shows how to build and modify processing pipelines that connect teleoperators (e.g., phone) to robots and datasets. Pipelines standardize conversions between different action/observation spaces so you can swap teleops and robots without rewriting glue code.",ae,U,Ne="We use the Phone to SO‑100 follower examples for concreteness, but the same patterns apply to other robots.",oe,b,Se="<strong>What you’ll learn</strong>",ne,m,Ye="<li>Absolute vs. relative EE control: What each means, trade‑offs, and how to choose for your task.</li> <li>Three-pipeline pattern: How to map teleop actions → dataset actions → robot commands, and robot observations → dataset observations.</li> <li>Adapters (<code>to_transition</code> / <code>to_output</code>): How these convert raw dicts to <code>EnvTransition</code> and back to reduce boilerplate.</li> <li>Dataset feature contracts: How steps declare features via <code>transform_features(...)</code>, and how to aggregate/merge them for recording.</li> <li>Choosing a representation: When to store joints, absolute EE poses, or relative EE deltas—and how that affects training.</li> <li>Pipeline customization guidance: How to swap robots/URDFs safely and tune bounds, step sizes, and options like IK initialization.</li>",ie,f,pe,h,ke="The examples in this guide use absolute end effector (EE) poses because they are easy to reason about. In practice, relative EE deltas or joint position are often preferred as learning features.",re,I,Fe="With processors, you choose the learning features you want to use for your policy. This could be joints positions/velocities, absolute EE, or relative EE positions. You can also choose to store other features, such as joint torques, motor currents, etc.",Me,C,ce,v,Pe=`We often compose three pipelines. Depending on your setup, some can be empty if action and observation spaces already match.
Each of these pipelines handle different conversions between different action and observation spaces. Below is a quick explanation of each pipeline.`,ye,_,Le="<li>Pipeline 1: Teleop action space → dataset action space (phone pose → EE targets)</li> <li>Pipeline 2: Dataset action space → robot command space (EE targets → joints)</li> <li>Pipeline 3: Robot observation space → dataset observation space (joints → EE pose)</li>",we,A,qe="Below is an example of the three pipelines that we use in the phone to SO-100 follower examples:",ue,R,Je,B,de,Z,De=`To convert from robot/teleoperator to pipeline and back, we use the <code>to_transition</code> and <code>to_output</code> pipeline adapters.
They standardize conversions to reduce boilerplate code, and form the bridge between the robot and teleoperators raw dictionaries and the pipeline’s <code>EnvTransition</code> format.
In the phone to SO-100 follower examples we use the following adapters:`,Te,G,Ke="<li><code>robot_action_to_transition</code>: transforms the teleop action dict to a pipeline transition.</li> <li><code>transition_to_robot_action</code>: transforms the pipeline transition to a robot action dict.</li> <li><code>observation_to_transition</code>: transforms the robot observation dict to a pipeline transition.</li> <li><code>transition_to_observation</code>: transforms the pipeline transition to a observation dict.</li>",je,V,Oe='Checkout <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/processor/converters.py" rel="nofollow">src/lerobot/processor/converters.py</a> for more details.',Ue,X,be,W,et="Dataset features are determined by the keys saved in the dataset. Each step can declare what features it modifies in a contract called <code>transform_features(...)</code>. Once you build a processor, the processor can then aggregate all of these features with <code>aggregate_pipeline_dataset_features()</code> and merge multiple feature dicts with <code>combine_feature_dicts(...)</code>.",me,E,tt="Below is and example of how we declare features with the <code>transform_features</code> method in the phone to SO-100 follower examples:",fe,g,he,H,lt="Here we declare what PolicyFeatures we modify in this step, so we know what features we can expect when we run the processor. These features can then be aggregated and used to create the dataset features.",Ie,$,st="Below is an example of how we aggregate and merge features in the phone to SO-100 record example:",Ce,Q,ve,x,at="How it works:",_e,z,ot="<li><code>aggregate_pipeline_dataset_features(...)</code>: applies <code>transform_features</code> across the pipeline and filters by patterns (images included when <code>use_videos=True</code>, and state features included when <code>patterns</code> is specified).</li> <li><code>combine_feature_dicts(...)</code>: combine multiple feature dicts.</li> <li>Recording with <code>record_loop(...)</code> uses <code>build_dataset_frame(...)</code> to build frames consistent with <code>dataset.features</code> before we call <code>add_frame(...)</code> to add the frame to the dataset.</li>",Ae,N,Re,S,nt="You can store any of the following features as your action/observation space:",Be,Y,it="<li>Joint positions</li> <li>Absolute EE poses</li> <li>Relative EE deltas</li> <li>Other features: joint velocity, torques, etc.</li>",Ze,k,pt="Pick what you want to use for your policy action and observation space and configure/modify the pipelines and steps accordingly.",Ge,F,Ve,P,rt="<li>You can easily reuse pipelines, for example to use another robot with phone teleop, modify the examples and swap the robot <code>RobotKinematics</code> (URDF) and <code>motor_names</code> to use your own robot with Phone teleop. Additionally you should ensure <code>target_frame_name</code> points to your gripper/wrist.</li>",Xe,L,We,q,Mt="<li>When changing pipelines, start with tight bounds, implement safety steps when working with real robots.</li> <li>Its advised to start with simulation first and then move to real robots.</li>",Ee,D,ct='Thats it! We hope this guide helps you get started with customizing your robot pipelines, If you run into any issues at any point, jump into our <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord community</a> for support.',ge,K,He,ee,$e;return T=new d({props:{title:"Processors for Robots and Teleoperators",local:"processors-for-robots-and-teleoperators",headingTag:"h1"}}),f=new d({props:{title:"Absolute vs relative EE control",local:"absolute-vs-relative-ee-control",headingTag:"h3"}}),C=new d({props:{title:"Three pipelines",local:"three-pipelines",headingTag:"h2"}}),R=new Qe({props:{code:"cGhvbmVfdG9fcm9ib3RfZWVfcG9zZV9wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lJTVCUm9ib3RBY3Rpb24lMkMlMjBSb2JvdEFjdGlvbiU1RCglMjAlMjMlMjB0ZWxlb3AlMjAtJTNFJTIwZGF0YXNldCUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMHN0ZXBzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTWFwUGhvbmVBY3Rpb25Ub1JvYm90QWN0aW9uKHBsYXRmb3JtJTNEdGVsZW9wX2NvbmZpZy5waG9uZV9vcyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBFRVJlZmVyZW5jZUFuZERlbHRhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtpbmVtYXRpY3MlM0RraW5lbWF0aWNzX3NvbHZlciUyQyUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNEJTdCJTIyeCUyMiUzQSUyMDAuNSUyQyUyMCUyMnklMjIlM0ElMjAwLjUlMkMlMjAlMjJ6JTIyJTNBJTIwMC41JTdEJTJDJTIwbW90b3JfbmFtZXMlM0RsaXN0KHJvYm90LmJ1cy5tb3RvcnMua2V5cygpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBFRUJvdW5kc0FuZFNhZmV0eSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmRfZWZmZWN0b3JfYm91bmRzJTNEJTdCJTIybWluJTIyJTNBJTIwJTVCLTEuMCUyQyUyMC0xLjAlMkMlMjAtMS4wJTVEJTJDJTIwJTIybWF4JTIyJTNBJTIwJTVCMS4wJTJDJTIwMS4wJTJDJTIwMS4wJTVEJTdEJTJDJTIwbWF4X2VlX3N0ZXBfbSUzRDAuMjAlMkMlMjBtYXhfZWVfdHdpc3Rfc3RlcF9yYWQlM0QwLjUwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdyaXBwZXJWZWxvY2l0eVRvSm9pbnQoKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvX3RyYW5zaXRpb24lM0Ryb2JvdF9hY3Rpb25fdG9fdHJhbnNpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMHRvX291dHB1dCUzRHRyYW5zaXRpb25fdG9fcm9ib3RfYWN0aW9uJTJDJTBBKSUwQSUwQXJvYm90X2VlX3RvX2pvaW50c19wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lJTVCUm9ib3RBY3Rpb24lMkMlMjBSb2JvdEFjdGlvbiU1RCglMjAlMjMlMjBkYXRhc2V0JTIwYWN0aW9uJTIwLSUzRSUyMHJvYm90JTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJbnZlcnNlS2luZW1hdGljc0VFVG9Kb2ludHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2luZW1hdGljcyUzRGtpbmVtYXRpY3Nfc29sdmVyJTJDJTIwbW90b3JfbmFtZXMlM0RsaXN0KHJvYm90LmJ1cy5tb3RvcnMua2V5cygpKSUyQyUyMGluaXRpYWxfZ3Vlc3NfY3VycmVudF9qb2ludHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvX3RyYW5zaXRpb24lM0Ryb2JvdF9hY3Rpb25fdG9fdHJhbnNpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMHRvX291dHB1dCUzRHRyYW5zaXRpb25fdG9fcm9ib3RfYWN0aW9uJTJDJTBBKSUwQSUwQXJvYm90X2pvaW50c190b19lZV9wb3NlJTIwJTNEJTIwUm9ib3RQcm9jZXNzb3JQaXBlbGluZSU1QlJvYm90T2JzZXJ2YXRpb24lMkMlMjBSb2JvdE9ic2VydmF0aW9uJTVEKCUyMCUyMyUyMHJvYm90JTIwb2JzJTIwLSUzRSUyMGRhdGFzZXQlMjBvYnMlMEElMjAlMjAlMjAlMjBzdGVwcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZvcndhcmRLaW5lbWF0aWNzSm9pbnRzVG9FRShraW5lbWF0aWNzJTNEa2luZW1hdGljc19zb2x2ZXIlMkMlMjBtb3Rvcl9uYW1lcyUzRGxpc3Qocm9ib3QuYnVzLm1vdG9ycy5rZXlzKCkpKSUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvX3RyYW5zaXRpb24lM0RvYnNlcnZhdGlvbl90b190cmFuc2l0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9fb3V0cHV0JTNEdHJhbnNpdGlvbl90b19vYnNlcnZhdGlvbiUyQyUwQSk=",highlighted:`phone_to_robot_ee_pose_processor = RobotProcessorPipeline[RobotAction, RobotAction]( # teleop -&gt; dataset action
    steps=[
        MapPhoneActionToRobotAction(<span class="hljs-attribute">platform</span>=teleop_config.phone_os),
        EEReferenceAndDelta(
            <span class="hljs-attribute">kinematics</span>=kinematics_solver, end_effector_step_sizes={<span class="hljs-string">&quot;x&quot;</span>: 0.5, <span class="hljs-string">&quot;y&quot;</span>: 0.5, <span class="hljs-string">&quot;z&quot;</span>: 0.5}, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
        ),
        EEBoundsAndSafety(
            end_effector_bounds={<span class="hljs-string">&quot;min&quot;</span>: [-1.0, -1.0, -1.0], <span class="hljs-string">&quot;max&quot;</span>: [1.0, 1.0, 1.0]}, <span class="hljs-attribute">max_ee_step_m</span>=0.20, <span class="hljs-attribute">max_ee_twist_step_rad</span>=0.50,
        ),
        GripperVelocityToJoint(),
    ],
    <span class="hljs-attribute">to_transition</span>=robot_action_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_robot_action,
)

robot_ee_to_joints_processor = RobotProcessorPipeline[RobotAction, RobotAction]( # dataset action -&gt; robot
    steps=[
        InverseKinematicsEEToJoints(
            <span class="hljs-attribute">kinematics</span>=kinematics_solver, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()), <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">True</span>,
        ),
    ],
    <span class="hljs-attribute">to_transition</span>=robot_action_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_robot_action,
)

robot_joints_to_ee_pose = RobotProcessorPipeline[RobotObservation, RobotObservation]( # robot obs -&gt; dataset obs
    steps=[
        ForwardKinematicsJointsToEE(<span class="hljs-attribute">kinematics</span>=kinematics_solver, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()))
    ],
    <span class="hljs-attribute">to_transition</span>=observation_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_observation,
)`,wrap:!1}}),B=new d({props:{title:"Why to_transition / to_output",local:"why-totransition--tooutput",headingTag:"h2"}}),X=new d({props:{title:"Dataset feature contracts",local:"dataset-feature-contracts",headingTag:"h2"}}),g=new Qe({props:{code:"JTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlMEElMjAlMjAlMjAlMjApJTIwLSUzRSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBXZSUyMG9ubHklMjB1c2UlMjB0aGUlMjBlZSUyMHBvc2UlMjBpbiUyMHRoZSUyMGRhdGFzZXQlMkMlMjBzbyUyMHdlJTIwZG9uJ3QlMjBuZWVkJTIwdGhlJTIwam9pbnQlMjBwb3NpdGlvbnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBuJTIwaW4lMjBzZWxmLm1vdG9yX25hbWVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUJQaXBlbGluZUZlYXR1cmVUeXBlLkFDVElPTiU1RC5wb3AoZiUyMiU3Qm4lN0QucG9zJTIyJTJDJTIwTm9uZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBXZSUyMHNwZWNpZnklMjB0aGUlMjBkYXRhc2V0JTIwZmVhdHVyZXMlMjBvZiUyMHRoaXMlMjBzdGVwJTIwdGhhdCUyMHdlJTIwd2FudCUyMHRvJTIwYmUlMjBzdG9yZWQlMjBpbiUyMHRoZSUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrJTIwaW4lMjAlNUIlMjJ4JTIyJTJDJTIwJTIyeSUyMiUyQyUyMCUyMnolMjIlMkMlMjAlMjJ3eCUyMiUyQyUyMCUyMnd5JTIyJTJDJTIwJTIyd3olMjIlMkMlMjAlMjJncmlwcGVyX3BvcyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTVCUGlwZWxpbmVGZWF0dXJlVHlwZS5BQ1RJT04lNUQlNUJmJTIyZWUuJTdCayU3RCUyMiU1RCUyMCUzRCUyMFBvbGljeUZlYXR1cmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzREZlYXR1cmVUeXBlLlNUQVRFJTJDJTIwc2hhcGUlM0QoMSUyQyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">
        self, features: <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]
    </span>) -&gt; <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]:
        <span class="hljs-comment"># We only use the ee pose in the dataset, so we don&#x27;t need the joint positions</span>
        <span class="hljs-keyword">for</span> n <span class="hljs-keyword">in</span> self.motor_names:
            features[PipelineFeatureType.ACTION].pop(<span class="hljs-string">f&quot;<span class="hljs-subst">{n}</span>.pos&quot;</span>, <span class="hljs-literal">None</span>)
        <span class="hljs-comment"># We specify the dataset features of this step that we want to be stored in the dataset</span>
        <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;x&quot;</span>, <span class="hljs-string">&quot;y&quot;</span>, <span class="hljs-string">&quot;z&quot;</span>, <span class="hljs-string">&quot;wx&quot;</span>, <span class="hljs-string">&quot;wy&quot;</span>, <span class="hljs-string">&quot;wz&quot;</span>, <span class="hljs-string">&quot;gripper_pos&quot;</span>]:
            features[PipelineFeatureType.ACTION][<span class="hljs-string">f&quot;ee.<span class="hljs-subst">{k}</span>&quot;</span>] = PolicyFeature(
                <span class="hljs-built_in">type</span>=FeatureType.STATE, shape=(<span class="hljs-number">1</span>,)
            )
        <span class="hljs-keyword">return</span> features`,wrap:!1}}),Q=new Qe({props:{code:"ZmVhdHVyZXMlM0Rjb21iaW5lX2ZlYXR1cmVfZGljdHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUnVuJTIwdGhlJTIwZmVhdHVyZSUyMGNvbnRyYWN0JTIwb2YlMjB0aGUlMjBwaXBlbGluZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwdGVsbHMlMjB5b3UlMjBob3clMjB0aGUlMjBmZWF0dXJlcyUyMHdvdWxkJTIwbG9vayUyMGxpa2UlMjBhZnRlciUyMHRoZSUyMHBpcGVsaW5lJTIwc3RlcHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhZ2dyZWdhdGVfcGlwZWxpbmVfZGF0YXNldF9mZWF0dXJlcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZSUzRHBob25lX3RvX3JvYm90X2VlX3Bvc2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5pdGlhbF9mZWF0dXJlcyUzRGNyZWF0ZV9pbml0aWFsX2ZlYXR1cmVzKGFjdGlvbiUzRHBob25lLmFjdGlvbl9mZWF0dXJlcyklMkMlMjAlMjMlMjAlM0MtJTIwQWN0aW9uJTIwZmVhdHVyZXMlMjB3ZSUyMGNhbiUyMGV4cGVjdCUyQyUyMHRoZXNlJTIwY29tZSUyMGZyb20lMjBvdXIlMjB0ZWxlb3AlMjBkZXZpY2UlMjAocGhvbmUpJTIwYW5kJTIwYWN0aW9uJTIwcHJvY2Vzc29yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX3ZpZGVvcyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWdncmVnYXRlX3BpcGVsaW5lX2RhdGFzZXRfZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0Ryb2JvdF9qb2ludHNfdG9fZWVfcG9zZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluaXRpYWxfZmVhdHVyZXMlM0RjcmVhdGVfaW5pdGlhbF9mZWF0dXJlcyhvYnNlcnZhdGlvbiUzRHJvYm90Lm9ic2VydmF0aW9uX2ZlYXR1cmVzKSUyQyUyMCUyMyUyMCUzQy0lMjBPYnNlcnZhdGlvbiUyMGZlYXR1cmVzJTIwd2UlMjBjYW4lMjBleHBlY3QlMkMlMjB0aGVzZSUyMGNvbWUlMjBmcm9tJTIwb3VyJTIwcm9ib3QlMjBhbmQlMjBvYnNlcnZhdGlvbiUyMHByb2Nlc3NvciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV92aWRlb3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0dGVybnMlM0QlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZS5lZSUyMiU1RCUyQyUyMCUyMyUyMCUzQy0lMjBIZXJlJTIweW91JTIwY291bGQlMjBvcHRpb25hbGx5JTIwZmlsdGVyJTIwdGhlJTIwZmVhdHVyZXMlMjB3ZSUyMHdhbnQlMjB0byUyMHN0b3JlJTIwaW4lMjB0aGUlMjBkYXRhc2V0JTJDJTIwd2l0aCUyMGElMjBzcGVjaWZpYyUyMHBhdHRlcm4lMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwKSUyQw==",highlighted:`<span class="hljs-attribute">features</span>=combine_feature_dicts(
        # <span class="hljs-built_in">Run</span> the feature contract of the pipelines
        # This tells you how the features would look like after the pipeline steps
        aggregate_pipeline_dataset_features(
            <span class="hljs-attribute">pipeline</span>=phone_to_robot_ee_pose_processor,
            <span class="hljs-attribute">initial_features</span>=create_initial_features(action=phone.action_features), # &lt;- Action features we can expect, these come <span class="hljs-keyword">from</span> our teleop device (phone) <span class="hljs-keyword">and</span> action processor
            <span class="hljs-attribute">use_videos</span>=<span class="hljs-literal">True</span>,
        ),
        aggregate_pipeline_dataset_features(
            <span class="hljs-attribute">pipeline</span>=robot_joints_to_ee_pose,
            <span class="hljs-attribute">initial_features</span>=create_initial_features(observation=robot.observation_features), # &lt;- Observation features we can expect, these come <span class="hljs-keyword">from</span> our robot <span class="hljs-keyword">and</span> observation processor
            <span class="hljs-attribute">use_videos</span>=<span class="hljs-literal">True</span>,
            patterns=[<span class="hljs-string">&quot;observation.state.ee&quot;</span>], # &lt;- Here you could optionally<span class="hljs-built_in"> filter </span>the features we want <span class="hljs-keyword">to</span> store <span class="hljs-keyword">in</span> the dataset, with a specific pattern

        ),
    ),`,wrap:!1}}),N=new d({props:{title:"Guidance when customizing robot pipelines",local:"guidance-when-customizing-robot-pipelines",headingTag:"h2"}}),F=new d({props:{title:"Different robots",local:"different-robots",headingTag:"h3"}}),L=new d({props:{title:"Safety first",local:"safety-first",headingTag:"h3"}}),K=new mt({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/processors_robots_teleop.mdx"}}),{c(){J=n("meta"),te=a(),O=n("p"),le=a(),r(T.$$.fragment),se=a(),j=n("p"),j.textContent=ze,ae=a(),U=n("p"),U.textContent=Ne,oe=a(),b=n("p"),b.innerHTML=Se,ne=a(),m=n("ul"),m.innerHTML=Ye,ie=a(),r(f.$$.fragment),pe=a(),h=n("p"),h.textContent=ke,re=a(),I=n("p"),I.textContent=Fe,Me=a(),r(C.$$.fragment),ce=a(),v=n("p"),v.textContent=Pe,ye=a(),_=n("ol"),_.innerHTML=Le,we=a(),A=n("p"),A.textContent=qe,ue=a(),r(R.$$.fragment),Je=a(),r(B.$$.fragment),de=a(),Z=n("p"),Z.innerHTML=De,Te=a(),G=n("ul"),G.innerHTML=Ke,je=a(),V=n("p"),V.innerHTML=Oe,Ue=a(),r(X.$$.fragment),be=a(),W=n("p"),W.innerHTML=et,me=a(),E=n("p"),E.innerHTML=tt,fe=a(),r(g.$$.fragment),he=a(),H=n("p"),H.textContent=lt,Ie=a(),$=n("p"),$.textContent=st,Ce=a(),r(Q.$$.fragment),ve=a(),x=n("p"),x.textContent=at,_e=a(),z=n("ul"),z.innerHTML=ot,Ae=a(),r(N.$$.fragment),Re=a(),S=n("p"),S.textContent=nt,Be=a(),Y=n("ul"),Y.innerHTML=it,Ze=a(),k=n("p"),k.textContent=pt,Ge=a(),r(F.$$.fragment),Ve=a(),P=n("ul"),P.innerHTML=rt,Xe=a(),r(L.$$.fragment),We=a(),q=n("ul"),q.innerHTML=Mt,Ee=a(),D=n("p"),D.innerHTML=ct,ge=a(),r(K.$$.fragment),He=a(),ee=n("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),te=o(e),O=i(e,"P",{}),yt(O).forEach(l),le=o(e),M(T.$$.fragment,e),se=o(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-zkbknq"&&(j.textContent=ze),ae=o(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-121qa2u"&&(U.textContent=Ne),oe=o(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-rtu37n"&&(b.innerHTML=Se),ne=o(e),m=i(e,"UL",{"data-svelte-h":!0}),p(m)!=="svelte-1nl3mqe"&&(m.innerHTML=Ye),ie=o(e),M(f.$$.fragment,e),pe=o(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-i5sp88"&&(h.textContent=ke),re=o(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-beme34"&&(I.textContent=Fe),Me=o(e),M(C.$$.fragment,e),ce=o(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1uacg6x"&&(v.textContent=Pe),ye=o(e),_=i(e,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-1q5dwz6"&&(_.innerHTML=Le),we=o(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-zwkq5z"&&(A.textContent=qe),ue=o(e),M(R.$$.fragment,e),Je=o(e),M(B.$$.fragment,e),de=o(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-113cthv"&&(Z.innerHTML=De),Te=o(e),G=i(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-1kdi6lh"&&(G.innerHTML=Ke),je=o(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1cus9pi"&&(V.innerHTML=Oe),Ue=o(e),M(X.$$.fragment,e),be=o(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-rtv714"&&(W.innerHTML=et),me=o(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1f03gmf"&&(E.innerHTML=tt),fe=o(e),M(g.$$.fragment,e),he=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-v2rcdh"&&(H.textContent=lt),Ie=o(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-2wlws6"&&($.textContent=st),Ce=o(e),M(Q.$$.fragment,e),ve=o(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-14pxkqx"&&(x.textContent=at),_e=o(e),z=i(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1xxprhi"&&(z.innerHTML=ot),Ae=o(e),M(N.$$.fragment,e),Re=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-mdmhp8"&&(S.textContent=nt),Be=o(e),Y=i(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1nvqm69"&&(Y.innerHTML=it),Ze=o(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1t3566s"&&(k.textContent=pt),Ge=o(e),M(F.$$.fragment,e),Ve=o(e),P=i(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-mi45gr"&&(P.innerHTML=rt),Xe=o(e),M(L.$$.fragment,e),We=o(e),q=i(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1yaajmi"&&(q.innerHTML=Mt),Ee=o(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-18l4o8d"&&(D.innerHTML=ct),ge=o(e),M(K.$$.fragment,e),He=o(e),ee=i(e,"P",{}),yt(ee).forEach(l),this.h()},h(){wt(J,"name","hf:doc:metadata"),wt(J,"content",ht)},m(e,t){bt(document.head,J),s(e,te,t),s(e,O,t),s(e,le,t),c(T,e,t),s(e,se,t),s(e,j,t),s(e,ae,t),s(e,U,t),s(e,oe,t),s(e,b,t),s(e,ne,t),s(e,m,t),s(e,ie,t),c(f,e,t),s(e,pe,t),s(e,h,t),s(e,re,t),s(e,I,t),s(e,Me,t),c(C,e,t),s(e,ce,t),s(e,v,t),s(e,ye,t),s(e,_,t),s(e,we,t),s(e,A,t),s(e,ue,t),c(R,e,t),s(e,Je,t),c(B,e,t),s(e,de,t),s(e,Z,t),s(e,Te,t),s(e,G,t),s(e,je,t),s(e,V,t),s(e,Ue,t),c(X,e,t),s(e,be,t),s(e,W,t),s(e,me,t),s(e,E,t),s(e,fe,t),c(g,e,t),s(e,he,t),s(e,H,t),s(e,Ie,t),s(e,$,t),s(e,Ce,t),c(Q,e,t),s(e,ve,t),s(e,x,t),s(e,_e,t),s(e,z,t),s(e,Ae,t),c(N,e,t),s(e,Re,t),s(e,S,t),s(e,Be,t),s(e,Y,t),s(e,Ze,t),s(e,k,t),s(e,Ge,t),c(F,e,t),s(e,Ve,t),s(e,P,t),s(e,Xe,t),c(L,e,t),s(e,We,t),s(e,q,t),s(e,Ee,t),s(e,D,t),s(e,ge,t),c(K,e,t),s(e,He,t),s(e,ee,t),$e=!0},p:Jt,i(e){$e||(y(T.$$.fragment,e),y(f.$$.fragment,e),y(C.$$.fragment,e),y(R.$$.fragment,e),y(B.$$.fragment,e),y(X.$$.fragment,e),y(g.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(F.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),$e=!0)},o(e){w(T.$$.fragment,e),w(f.$$.fragment,e),w(C.$$.fragment,e),w(R.$$.fragment,e),w(B.$$.fragment,e),w(X.$$.fragment,e),w(g.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(F.$$.fragment,e),w(L.$$.fragment,e),w(K.$$.fragment,e),$e=!1},d(e){e&&(l(te),l(O),l(le),l(se),l(j),l(ae),l(U),l(oe),l(b),l(ne),l(m),l(ie),l(pe),l(h),l(re),l(I),l(Me),l(ce),l(v),l(ye),l(_),l(we),l(A),l(ue),l(Je),l(de),l(Z),l(Te),l(G),l(je),l(V),l(Ue),l(be),l(W),l(me),l(E),l(fe),l(he),l(H),l(Ie),l($),l(Ce),l(ve),l(x),l(_e),l(z),l(Ae),l(Re),l(S),l(Be),l(Y),l(Ze),l(k),l(Ge),l(Ve),l(P),l(Xe),l(We),l(q),l(Ee),l(D),l(ge),l(He),l(ee)),l(J),u(T,e),u(f,e),u(C,e),u(R,e),u(B,e),u(X,e),u(g,e),u(Q,e),u(N,e),u(F,e),u(L,e),u(K,e)}}}const ht='{"title":"Processors for Robots and Teleoperators","local":"processors-for-robots-and-teleoperators","sections":[{"title":"Absolute vs relative EE control","local":"absolute-vs-relative-ee-control","sections":[],"depth":3},{"title":"Three pipelines","local":"three-pipelines","sections":[],"depth":2},{"title":"Why to_transition / to_output","local":"why-totransition--tooutput","sections":[],"depth":2},{"title":"Dataset feature contracts","local":"dataset-feature-contracts","sections":[],"depth":2},{"title":"Guidance when customizing robot pipelines","local":"guidance-when-customizing-robot-pipelines","sections":[{"title":"Different robots","local":"different-robots","sections":[],"depth":3},{"title":"Safety first","local":"safety-first","sections":[],"depth":3}],"depth":2}],"depth":1}';function It(xe){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Tt{constructor(J){super(),jt(this,J,It,ft,ut,{})}}export{Rt as component};
