import{s as Nl,f as Yl,n as Fl,o as ql}from"../chunks/scheduler.3e37077e.js";import{S as Ol,i as Kl,g as i,s as n,r as c,A as Dl,h as o,f as t,c as a,j as M,u as d,x as r,k as Ve,y as p,a as s,v as u,d as h,t as m,w as f}from"../chunks/index.263272b0.js";import{C as y}from"../chunks/CodeBlock.76c31e3c.js";import{H as g,E as es}from"../chunks/getInferenceSnippets.932de0ac.js";function ts(dl){let w,ze,He,Qe,C,Ne,v,ul="Use your phone (iOS or Android) to control your robot.",Ye,_,hl="<strong>In this guide you’ll learn:</strong>",Fe,J,ml="<li>How to connect an iOS/Android phone</li> <li>How phone pose is mapped to robot end‑effector (EE) targets</li> <li>How to tweak safety limits, gripper control, and IK settings</li>",qe,E,fl="To use phone to control your robot, install the relevant dependencies with:",Oe,x,Ke,I,De,R,et,A,Ml="<li>iOS: Uses the HEBI Mobile I/O app (ARKit pose + buttons). Download the app first, open it and the examples will discover it on your network and stream the phone pose and inputs.</li> <li>Android: Uses the <code>teleop</code> package (WebXR). When you start the Python process, it prints a local URL. Open the link on your phone, tap Start, then use Move to stream pose.</li>",tt,Z,bl="Links:",lt,k,yl='<li>Android WebXR library: <a href="https://pypi.org/project/teleop/" rel="nofollow"><code>teleop</code> on PyPI</a></li> <li>iOS app: <a href="https://docs.hebi.us/tools.html#mobile-io" rel="nofollow">HEBI Mobile I/O</a></li>',st,G,nt,L,gl="<li>Orientation: hold the phone with the screen facing up and the top edge pointing in the same direction as the robot gripper. This ensures calibration aligns the phone’s frame with the robot frame so motion feels natural, see the image below for reference.</li> <li>Enable/disable:<ul><li>iOS: Hold <code>B1</code> to enable teleoperation, release to stop. The first press captures a reference pose.</li> <li>Android: Press and hold the <code>Move</code> button, release to stop. The first press captures a reference pose.</li></ul></li> <li>Gripper control:<ul><li>iOS: Analog input <code>A3</code> controls the gripper as velocity input.</li> <li>Android: Buttons <code>A</code> and <code>B</code> act like increment/decrement (A opens, B closes). You can tune velocity in the <code>GripperVelocityToJoint</code> step.</li></ul></li>",at,j,$l,it,S,ot,W,Ul="Modify the examples to use <code>PhoneOS.IOS</code> or <code>PhoneOS.ANDROID</code> in <code>PhoneConfig</code>. The API is identical across platforms, only the input source differs. All examples are under <code>examples/</code> and have <code>phone_so100_*.py</code> variants.",pt,X,wl="Teleoperation example:",rt,B,ct,V,dt,H,jl="When <code>Phone(teleop_config)</code> is created and <code>connect()</code> is called, calibration is prompted automatically. Hold the phone in the orientation described above, then:",ut,P,Tl="<li>iOS: press and hold <code>B1</code> to capture the reference pose.</li> <li>Android: press <code>Move</code> button on the WebXR page to capture the reference pose.</li>",ht,z,Cl="Why calibrate? We capture the current pose so subsequent poses are expressed in a robot aligned frame. When you again press the button to enable control, the position is recaptured to avoid drift when your phone is repositioned while it was disabled.",mt,Q,ft,N,vl="Run on of the examples scripts to teleoperate, record a dataset, replay a dataset or evaluate a policy.",Mt,Y,_l="All scripts assume you configured your robot (e.g., SO-100 follower) and set the correct serial port.",bt,F,Jl='Additionally you need to <strong>copy the urdf of the robot to the examples folder</strong>. For the examples in this tutorial (Using SO100/SO101) it is highly recommended to use the urdf in the <a href="https://github.com/TheRobotStudio/SO-ARM100/blob/main/Simulation/SO101/so101_new_calib.urdf" rel="nofollow">SO-ARM100 repo</a>',yt,Ee,q,xe,El="Run this example to teleoperate:",Nt,O,gt,K,xl="After running the example:",$t,D,Il="<li>Android: after starting the script, open the printed local URL on your phone, tap Start, then press and hold Move.</li> <li>iOS: open HEBI Mobile I/O first; B1 enables motion. A3 controls the gripper.</li>",Ut,ee,Rl='Additionally you can customize mapping or safety limits by editing the processor steps shown in the examples. You can also remap inputs (e.g., use a different analog input) or adapt the pipeline to other robots (e.g., LeKiwi) by modifying the input and kinematics steps. More about this in the <a href="./processors_robots_teleop.mdx">Processors for Robots and Teleoperators</a> guide.',wt,$,te,Ie,Al="Run this example to record a dataset, which saves absolute end effector observations and actions:",Yt,le,Ft,se,Re,Zl="Run this example to replay recorded episodes:",qt,ne,Ot,ae,Ae,kl="Run this example to evaluate a pretrained policy:",Kt,ie,jt,oe,Tt,b,pe,Ze,Gl='Kinematics are used in multiple steps. We use <a href="https://github.com/Rhoban/placo" rel="nofollow">Placo</a> which is a wrapper around Pinocchio for handling our kinematics. We construct the kinematics object by passing the robot’s URDF and target frame. We set <code>target_frame_name</code> to the gripper frame.',Dt,re,el,ce,ke,Ll="The <code>MapPhoneActionToRobotAction</code> step converts the calibrated phone pose and inputs into target deltas and gripper commands, below is shown what the step outputs.",tl,de,ll,ue,Ge,Sl="The <code>EEReferenceAndDelta</code> step converts target deltas to an absolute desired EE pose, storing a reference on enable, the <code>end_effector_step_sizes</code> are the step sizes for the EE pose and can be modified to change the motion speed.",sl,he,nl,me,Le,Wl="The <code>EEBoundsAndSafety</code> step clamps EE motion to a workspace and checks for large ee step jumps to ensure safety. The <code>end_effector_bounds</code> are the bounds for the EE pose and can be modified to change the workspace. The <code>max_ee_step_m</code> and <code>max_ee_twist_step_rad</code> are the step limits for the EE pose and can be modified to change the safety limits.",al,fe,il,Me,Se,Xl="The <code>GripperVelocityToJoint</code> step turns a velocity‑like gripper input into absolute gripper position using the current measured state. The <code>speed_factor</code> is the factor by which the velocity is multiplied.",ol,be,Ct,ye,vt,ge,Bl="We use different IK initial guesses in the kinematic steps. As initial guess either the current measured joints or the previous IK solution is used.",_t,T,$e,We,Vl="Closed loop (used in record/eval): sets <code>initial_guess_current_joints=True</code> so IK starts from the measured joints each frame.",pl,Ue,rl,we,Xe,Hl="Open loop (used in replay): sets <code>initial_guess_current_joints=False</code> so IK continues from the previous IK solution rather than the measured state. This preserves action stability when we replay without feedback.",cl,je,Jt,Te,Et,Ce,Pl="<li>MapPhoneActionToRobotAction: converts calibrated phone pose and inputs into target deltas and a gripper command. Motion is gated by an enable signal (B1 on iOS, Move on Android).</li> <li>EEReferenceAndDelta: latches a reference EE pose on enable and combines it with target deltas to produce an absolute desired EE pose each frame. When disabled, it keeps sending the last commanded pose.</li> <li>EEBoundsAndSafety: clamps the EE pose to a workspace and rate‑limits jumps for safety. Also declares <code>action.ee.*</code> features.</li> <li>InverseKinematicsEEToJoints: turns an EE pose into joint positions with IK. <code>initial_guess_current_joints=True</code> is recommended for closed‑loop control; set <code>False</code> for open‑loop replay for stability.</li> <li>GripperVelocityToJoint: integrates a velocity‑like gripper input into an absolute gripper position using the current measured state.</li> <li>ForwardKinematicsJointsToEE: computes <code>observation.state.ee.*</code> from observed joints for logging and training on EE state.</li>",xt,ve,It,_e,zl="<li>iOS not discovered: ensure HEBI Mobile I/O is open and your laptop/phone are on the same network.</li> <li>Android URL not reachable: check local you used <code>https</code> instead of <code>http</code>, use the exact IP printed by the script and allow your browser to enter and ignore the certificate issue.</li> <li>Motion feels inverted: adjust the sign flips in <code>MapPhoneActionToRobotAction</code> or swap axes to match your setup.</li>",Rt,Je,At,Pe,Zt;return C=new g({props:{title:"Phone",local:"phone",headingTag:"h1"}}),x=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxlcm9ib3QlNUJwaG9uZSU1RA==",highlighted:"pip install lerobot[phone]",wrap:!1}}),I=new g({props:{title:"Get started",local:"get-started",headingTag:"h2"}}),R=new g({props:{title:"Supported platforms",local:"supported-platforms",headingTag:"h3"}}),G=new g({props:{title:"Phone orientation and controls",local:"phone-orientation-and-controls",headingTag:"h3"}}),S=new g({props:{title:"Step 1: Choose the platform",local:"step-1-choose-the-platform",headingTag:"h3"}}),B=new y({props:{code:"ZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy5waG9uZS5jb25maWdfcGhvbmUlMjBpbXBvcnQlMjBQaG9uZUNvbmZpZyUyQyUyMFBob25lT1MlMEElMEF0ZWxlb3BfY29uZmlnJTIwJTNEJTIwUGhvbmVDb25maWcocGhvbmVfb3MlM0RQaG9uZU9TLklPUyklMjAlMjAlMjMlMjBvciUyMFBob25lT1MuQU5EUk9JRCUwQXRlbGVvcF9kZXZpY2UlMjAlM0QlMjBQaG9uZSh0ZWxlb3BfY29uZmlnKQ==",highlighted:`from lerobot.teleoperators.phone.config_phone import PhoneConfig, PhoneOS

teleop_config = <span class="hljs-constructor">PhoneConfig(<span class="hljs-params">phone_os</span>=PhoneOS.IOS)</span>  # <span class="hljs-keyword">or</span> PhoneOS.ANDROID
teleop_device = <span class="hljs-constructor">Phone(<span class="hljs-params">teleop_config</span>)</span>`,wrap:!1}}),V=new g({props:{title:"Step 2: Connect and calibrate",local:"step-2-connect-and-calibrate",headingTag:"h3"}}),Q=new g({props:{title:"Step 3: Run an example",local:"step-3-run-an-example",headingTag:"h3"}}),O=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnRlbGVvcGVyYXRlLnB5",highlighted:"python examples/phone_to_so100/teleoperate.py",wrap:!1}}),le=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnJlY29yZC5weQ==",highlighted:"python examples/phone_to_so100/record.py",wrap:!1}}),ne=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnJlcGxheS5weQ==",highlighted:"python examples/phone_to_so100/replay.py",wrap:!1}}),ie=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRmV2YWx1YXRlLnB5",highlighted:"python examples/phone_to_so100/evaluate.py",wrap:!1}}),oe=new g({props:{title:"Important pipeline steps and options",local:"important-pipeline-steps-and-options",headingTag:"h3"}}),re=new y({props:{code:"a2luZW1hdGljc19zb2x2ZXIlMjAlM0QlMjBSb2JvdEtpbmVtYXRpY3MoJTBBJTIwJTIwdXJkZl9wYXRoJTNEJTIyLiUyRlNPMTAxJTJGc28xMDFfbmV3X2NhbGliLnVyZGYlMjIlMkMlMEElMjAlMjB0YXJnZXRfZnJhbWVfbmFtZSUzRCUyMmdyaXBwZXJfZnJhbWVfbGluayUyMiUyQyUwQSUyMCUyMGpvaW50X25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEEpJTBB",highlighted:`kinematics_solver = RobotKinematics(
  <span class="hljs-attribute">urdf_path</span>=<span class="hljs-string">&quot;./SO101/so101_new_calib.urdf&quot;</span>,
  <span class="hljs-attribute">target_frame_name</span>=<span class="hljs-string">&quot;gripper_frame_link&quot;</span>,
  <span class="hljs-attribute">joint_names</span>=list(robot.bus.motors.keys()),
)
`,wrap:!1}}),de=new y({props:{code:"YWN0aW9uJTVCJTIyZW5hYmxlZCUyMiU1RCUyMCUzRCUyMGVuYWJsZWQlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfeCUyMiU1RCUyMCUzRCUyMC1wb3MlNUIxJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMnRhcmdldF95JTIyJTVEJTIwJTNEJTIwcG9zJTVCMCU1RCUyMGlmJTIwZW5hYmxlZCUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfeiUyMiU1RCUyMCUzRCUyMHBvcyU1QjIlNUQlMjBpZiUyMGVuYWJsZWQlMjBlbHNlJTIwMC4wJTBBJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTVCJTIydGFyZ2V0X3d4JTIyJTVEJTIwJTNEJTIwcm90dmVjJTVCMSU1RCUyMGlmJTIwZW5hYmxlZCUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfd3klMjIlNUQlMjAlM0QlMjByb3R2ZWMlNUIwJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMnRhcmdldF93eiUyMiU1RCUyMCUzRCUyMC1yb3R2ZWMlNUIyJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMmdyaXBwZXJfdmVsJTIyJTVEJTIwJTNEJTIwZ3JpcHBlcl92ZWwlMjAlMjAlMjMlMjBTdGlsbCUyMHNlbmQlMjBncmlwcGVyJTIwYWN0aW9uJTIwd2hlbiUyMGRpc2FibGVk",highlighted:`<span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;enabled&quot;</span>] = enabled
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_x&quot;</span>] = -pos[<span class="hljs-number">1</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_y&quot;</span>] = pos[<span class="hljs-number">0</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_z&quot;</span>] = pos[<span class="hljs-number">2</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wx&quot;</span>] = rotvec[<span class="hljs-number">1</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wy&quot;</span>] = rotvec[<span class="hljs-number">0</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wz&quot;</span>] = -rotvec[<span class="hljs-number">2</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;gripper_vel&quot;</span>] = gripper_vel  # Still send gripper action when disabled`,wrap:!1}}),he=new y({props:{code:"RUVSZWZlcmVuY2VBbmREZWx0YSglMEElMjAlMjAlMjAlMjBraW5lbWF0aWNzJTNEa2luZW1hdGljc19zb2x2ZXIlMkMlMEElMjAlMjAlMjAlMjBlbmRfZWZmZWN0b3Jfc3RlcF9zaXplcyUzRCU3QiUyMnglMjIlM0ElMjAwLjUlMkMlMjAlMjJ5JTIyJTNBJTIwMC41JTJDJTIwJTIyeiUyMiUzQSUyMDAuNSU3RCUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjB1c2VfbGF0Y2hlZF9yZWZlcmVuY2UlM0RUcnVlJTJDJTBBKSUyQw==",highlighted:`EEReferenceAndDelta(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    end_effector_step_sizes={<span class="hljs-string">&quot;x&quot;</span>: 0.5, <span class="hljs-string">&quot;y&quot;</span>: 0.5, <span class="hljs-string">&quot;z&quot;</span>: 0.5},
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">use_latched_reference</span>=<span class="hljs-literal">True</span>,
),`,wrap:!1}}),fe=new y({props:{code:"RUVCb3VuZHNBbmRTYWZldHkoJTBBJTIwJTIwJTIwJTIwZW5kX2VmZmVjdG9yX2JvdW5kcyUzRCU3QiUyMm1pbiUyMiUzQSUyMCU1Qi0xLjAlMkMlMjAtMS4wJTJDJTIwLTEuMCU1RCUyQyUyMCUyMm1heCUyMiUzQSUyMCU1QjEuMCUyQyUyMDEuMCUyQyUyMDEuMCU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9lZV9zdGVwX20lM0QwLjEwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2VlX3R3aXN0X3N0ZXBfcmFkJTNEMC41MCUyQyUwQSk=",highlighted:`EEBoundsAndSafety(
    end_effector_bounds={<span class="hljs-string">&quot;min&quot;</span>: [-1.0, -1.0, -1.0], <span class="hljs-string">&quot;max&quot;</span>: [1.0, 1.0, 1.0]},
    <span class="hljs-attribute">max_ee_step_m</span>=0.10,
    <span class="hljs-attribute">max_ee_twist_step_rad</span>=0.50,
)`,wrap:!1}}),be=new y({props:{code:"R3JpcHBlclZlbG9jaXR5VG9Kb2ludChzcGVlZF9mYWN0b3IlM0QyMC4wKQ==",highlighted:'<span class="hljs-function"><span class="hljs-title">GripperVelocityToJoint</span><span class="hljs-params">(speed_factor=<span class="hljs-number">20.0</span>)</span></span>',wrap:!1}}),ye=new g({props:{title:"Different IK initial guesses",local:"different-ik-initial-guesses",headingTag:"h4"}}),Ue=new y({props:{code:"SW52ZXJzZUtpbmVtYXRpY3NFRVRvSm9pbnRzKCUwQSUyMCUyMCUyMCUyMGtpbmVtYXRpY3MlM0RraW5lbWF0aWNzX3NvbHZlciUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjBpbml0aWFsX2d1ZXNzX2N1cnJlbnRfam9pbnRzJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMGNsb3NlZCUyMGxvb3AlMEEp",highlighted:`InverseKinematicsEEToJoints(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">True</span>,  # closed loop
)`,wrap:!1}}),je=new y({props:{code:"SW52ZXJzZUtpbmVtYXRpY3NFRVRvSm9pbnRzKCUwQSUyMCUyMCUyMCUyMGtpbmVtYXRpY3MlM0RraW5lbWF0aWNzX3NvbHZlciUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjBpbml0aWFsX2d1ZXNzX2N1cnJlbnRfam9pbnRzJTNERmFsc2UlMkMlMjAlMjAlMjMlMjBvcGVuJTIwbG9vcCUwQSk=",highlighted:`InverseKinematicsEEToJoints(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">False</span>,  # open loop
)`,wrap:!1}}),Te=new g({props:{title:"Pipeline steps explained",local:"pipeline-steps-explained",headingTag:"h3"}}),ve=new g({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h3"}}),Je=new es({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/phone_teleop.mdx"}}),{c(){w=i("meta"),ze=n(),He=i("p"),Qe=n(),c(C.$$.fragment),Ne=n(),v=i("p"),v.textContent=ul,Ye=n(),_=i("p"),_.innerHTML=hl,Fe=n(),J=i("ul"),J.innerHTML=ml,qe=n(),E=i("p"),E.textContent=fl,Oe=n(),c(x.$$.fragment),Ke=n(),c(I.$$.fragment),De=n(),c(R.$$.fragment),et=n(),A=i("ul"),A.innerHTML=Ml,tt=n(),Z=i("p"),Z.textContent=bl,lt=n(),k=i("ul"),k.innerHTML=yl,st=n(),c(G.$$.fragment),nt=n(),L=i("ul"),L.innerHTML=gl,at=n(),j=i("img"),it=n(),c(S.$$.fragment),ot=n(),W=i("p"),W.innerHTML=Ul,pt=n(),X=i("p"),X.textContent=wl,rt=n(),c(B.$$.fragment),ct=n(),c(V.$$.fragment),dt=n(),H=i("p"),H.innerHTML=jl,ut=n(),P=i("ul"),P.innerHTML=Tl,ht=n(),z=i("p"),z.textContent=Cl,mt=n(),c(Q.$$.fragment),ft=n(),N=i("p"),N.textContent=vl,Mt=n(),Y=i("p"),Y.textContent=_l,bt=n(),F=i("p"),F.innerHTML=Jl,yt=n(),Ee=i("ul"),q=i("li"),xe=i("p"),xe.textContent=El,Nt=n(),c(O.$$.fragment),gt=n(),K=i("p"),K.textContent=xl,$t=n(),D=i("ul"),D.innerHTML=Il,Ut=n(),ee=i("p"),ee.innerHTML=Rl,wt=n(),$=i("ul"),te=i("li"),Ie=i("p"),Ie.textContent=Al,Yt=n(),c(le.$$.fragment),Ft=n(),se=i("li"),Re=i("p"),Re.textContent=Zl,qt=n(),c(ne.$$.fragment),Ot=n(),ae=i("li"),Ae=i("p"),Ae.textContent=kl,Kt=n(),c(ie.$$.fragment),jt=n(),c(oe.$$.fragment),Tt=n(),b=i("ul"),pe=i("li"),Ze=i("p"),Ze.innerHTML=Gl,Dt=n(),c(re.$$.fragment),el=n(),ce=i("li"),ke=i("p"),ke.innerHTML=Ll,tl=n(),c(de.$$.fragment),ll=n(),ue=i("li"),Ge=i("p"),Ge.innerHTML=Sl,sl=n(),c(he.$$.fragment),nl=n(),me=i("li"),Le=i("p"),Le.innerHTML=Wl,al=n(),c(fe.$$.fragment),il=n(),Me=i("li"),Se=i("p"),Se.innerHTML=Xl,ol=n(),c(be.$$.fragment),Ct=n(),c(ye.$$.fragment),vt=n(),ge=i("p"),ge.textContent=Bl,_t=n(),T=i("ul"),$e=i("li"),We=i("p"),We.innerHTML=Vl,pl=n(),c(Ue.$$.fragment),rl=n(),we=i("li"),Xe=i("p"),Xe.innerHTML=Hl,cl=n(),c(je.$$.fragment),Jt=n(),c(Te.$$.fragment),Et=n(),Ce=i("ul"),Ce.innerHTML=Pl,xt=n(),c(ve.$$.fragment),It=n(),_e=i("ul"),_e.innerHTML=zl,Rt=n(),c(Je.$$.fragment),At=n(),Pe=i("p"),this.h()},l(e){const l=Dl("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),ze=a(e),He=o(e,"P",{}),M(He).forEach(t),Qe=a(e),d(C.$$.fragment,e),Ne=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3vf8g7"&&(v.textContent=ul),Ye=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1er8ae6"&&(_.innerHTML=hl),Fe=a(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-1nz9ma3"&&(J.innerHTML=ml),qe=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1lyia1j"&&(E.textContent=fl),Oe=a(e),d(x.$$.fragment,e),Ke=a(e),d(I.$$.fragment,e),De=a(e),d(R.$$.fragment,e),et=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-xkftyz"&&(A.innerHTML=Ml),tt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-y594fb"&&(Z.textContent=bl),lt=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-faeeyl"&&(k.innerHTML=yl),st=a(e),d(G.$$.fragment,e),nt=a(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-dfqf70"&&(L.innerHTML=gl),at=a(e),j=o(e,"IMG",{src:!0,alt:!0,title:!0,width:!0}),it=a(e),d(S.$$.fragment,e),ot=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1c3fk2a"&&(W.innerHTML=Ul),pt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rrbhjt"&&(X.textContent=wl),rt=a(e),d(B.$$.fragment,e),ct=a(e),d(V.$$.fragment,e),dt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-11v1co9"&&(H.innerHTML=jl),ut=a(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-10nmcyd"&&(P.innerHTML=Tl),ht=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1v5ctat"&&(z.textContent=Cl),mt=a(e),d(Q.$$.fragment,e),ft=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-biq5h"&&(N.textContent=vl),Mt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-cziu4v"&&(Y.textContent=_l),bt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-bo4jsw"&&(F.innerHTML=Jl),yt=a(e),Ee=o(e,"UL",{});var Ql=M(Ee);q=o(Ql,"LI",{});var kt=M(q);xe=o(kt,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1n9m9bo"&&(xe.textContent=El),Nt=a(kt),d(O.$$.fragment,kt),kt.forEach(t),Ql.forEach(t),gt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-tep4ru"&&(K.textContent=xl),$t=a(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-19691k6"&&(D.innerHTML=Il),Ut=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-ijvg9p"&&(ee.innerHTML=Rl),wt=a(e),$=o(e,"UL",{});var Be=M($);te=o(Be,"LI",{});var Gt=M(te);Ie=o(Gt,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-11bjw3i"&&(Ie.textContent=Al),Yt=a(Gt),d(le.$$.fragment,Gt),Gt.forEach(t),Ft=a(Be),se=o(Be,"LI",{});var Lt=M(se);Re=o(Lt,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-eb2jkf"&&(Re.textContent=Zl),qt=a(Lt),d(ne.$$.fragment,Lt),Lt.forEach(t),Ot=a(Be),ae=o(Be,"LI",{});var St=M(ae);Ae=o(St,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-r2to9q"&&(Ae.textContent=kl),Kt=a(St),d(ie.$$.fragment,St),St.forEach(t),Be.forEach(t),jt=a(e),d(oe.$$.fragment,e),Tt=a(e),b=o(e,"UL",{});var U=M(b);pe=o(U,"LI",{});var Wt=M(pe);Ze=o(Wt,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1y9rs6w"&&(Ze.innerHTML=Gl),Dt=a(Wt),d(re.$$.fragment,Wt),Wt.forEach(t),el=a(U),ce=o(U,"LI",{});var Xt=M(ce);ke=o(Xt,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-b5g37b"&&(ke.innerHTML=Ll),tl=a(Xt),d(de.$$.fragment,Xt),Xt.forEach(t),ll=a(U),ue=o(U,"LI",{});var Bt=M(ue);Ge=o(Bt,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1lpl7iy"&&(Ge.innerHTML=Sl),sl=a(Bt),d(he.$$.fragment,Bt),Bt.forEach(t),nl=a(U),me=o(U,"LI",{});var Vt=M(me);Le=o(Vt,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-tkbla1"&&(Le.innerHTML=Wl),al=a(Vt),d(fe.$$.fragment,Vt),Vt.forEach(t),il=a(U),Me=o(U,"LI",{});var Ht=M(Me);Se=o(Ht,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1c721cm"&&(Se.innerHTML=Xl),ol=a(Ht),d(be.$$.fragment,Ht),Ht.forEach(t),U.forEach(t),Ct=a(e),d(ye.$$.fragment,e),vt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1s0tjx9"&&(ge.textContent=Bl),_t=a(e),T=o(e,"UL",{});var Pt=M(T);$e=o(Pt,"LI",{});var zt=M($e);We=o(zt,"P",{"data-svelte-h":!0}),r(We)!=="svelte-sebqar"&&(We.innerHTML=Vl),pl=a(zt),d(Ue.$$.fragment,zt),zt.forEach(t),rl=a(Pt),we=o(Pt,"LI",{});var Qt=M(we);Xe=o(Qt,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-13tu7ua"&&(Xe.innerHTML=Hl),cl=a(Qt),d(je.$$.fragment,Qt),Qt.forEach(t),Pt.forEach(t),Jt=a(e),d(Te.$$.fragment,e),Et=a(e),Ce=o(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1a6s0a3"&&(Ce.innerHTML=Pl),xt=a(e),d(ve.$$.fragment,e),It=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-adc87g"&&(_e.innerHTML=zl),Rt=a(e),d(Je.$$.fragment,e),At=a(e),Pe=o(e,"P",{}),M(Pe).forEach(t),this.h()},h(){Ve(w,"name","hf:doc:metadata"),Ve(w,"content",ls),Yl(j.src,$l="https://huggingface.co/datasets/huggingface/documentation-images/blob/main/lerobot/phone_teleop.webp")||Ve(j,"src",$l),Ve(j,"alt","Phone teleop orientation"),Ve(j,"title","Phone teleop orientation"),Ve(j,"width","60%")},m(e,l){p(document.head,w),s(e,ze,l),s(e,He,l),s(e,Qe,l),u(C,e,l),s(e,Ne,l),s(e,v,l),s(e,Ye,l),s(e,_,l),s(e,Fe,l),s(e,J,l),s(e,qe,l),s(e,E,l),s(e,Oe,l),u(x,e,l),s(e,Ke,l),u(I,e,l),s(e,De,l),u(R,e,l),s(e,et,l),s(e,A,l),s(e,tt,l),s(e,Z,l),s(e,lt,l),s(e,k,l),s(e,st,l),u(G,e,l),s(e,nt,l),s(e,L,l),s(e,at,l),s(e,j,l),s(e,it,l),u(S,e,l),s(e,ot,l),s(e,W,l),s(e,pt,l),s(e,X,l),s(e,rt,l),u(B,e,l),s(e,ct,l),u(V,e,l),s(e,dt,l),s(e,H,l),s(e,ut,l),s(e,P,l),s(e,ht,l),s(e,z,l),s(e,mt,l),u(Q,e,l),s(e,ft,l),s(e,N,l),s(e,Mt,l),s(e,Y,l),s(e,bt,l),s(e,F,l),s(e,yt,l),s(e,Ee,l),p(Ee,q),p(q,xe),p(q,Nt),u(O,q,null),s(e,gt,l),s(e,K,l),s(e,$t,l),s(e,D,l),s(e,Ut,l),s(e,ee,l),s(e,wt,l),s(e,$,l),p($,te),p(te,Ie),p(te,Yt),u(le,te,null),p($,Ft),p($,se),p(se,Re),p(se,qt),u(ne,se,null),p($,Ot),p($,ae),p(ae,Ae),p(ae,Kt),u(ie,ae,null),s(e,jt,l),u(oe,e,l),s(e,Tt,l),s(e,b,l),p(b,pe),p(pe,Ze),p(pe,Dt),u(re,pe,null),p(b,el),p(b,ce),p(ce,ke),p(ce,tl),u(de,ce,null),p(b,ll),p(b,ue),p(ue,Ge),p(ue,sl),u(he,ue,null),p(b,nl),p(b,me),p(me,Le),p(me,al),u(fe,me,null),p(b,il),p(b,Me),p(Me,Se),p(Me,ol),u(be,Me,null),s(e,Ct,l),u(ye,e,l),s(e,vt,l),s(e,ge,l),s(e,_t,l),s(e,T,l),p(T,$e),p($e,We),p($e,pl),u(Ue,$e,null),p(T,rl),p(T,we),p(we,Xe),p(we,cl),u(je,we,null),s(e,Jt,l),u(Te,e,l),s(e,Et,l),s(e,Ce,l),s(e,xt,l),u(ve,e,l),s(e,It,l),s(e,_e,l),s(e,Rt,l),u(Je,e,l),s(e,At,l),s(e,Pe,l),Zt=!0},p:Fl,i(e){Zt||(h(C.$$.fragment,e),h(x.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(B.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(O.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),Zt=!0)},o(e){m(C.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(R.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(ve.$$.fragment,e),m(Je.$$.fragment,e),Zt=!1},d(e){e&&(t(ze),t(He),t(Qe),t(Ne),t(v),t(Ye),t(_),t(Fe),t(J),t(qe),t(E),t(Oe),t(Ke),t(De),t(et),t(A),t(tt),t(Z),t(lt),t(k),t(st),t(nt),t(L),t(at),t(j),t(it),t(ot),t(W),t(pt),t(X),t(rt),t(ct),t(dt),t(H),t(ut),t(P),t(ht),t(z),t(mt),t(ft),t(N),t(Mt),t(Y),t(bt),t(F),t(yt),t(Ee),t(gt),t(K),t($t),t(D),t(Ut),t(ee),t(wt),t($),t(jt),t(Tt),t(b),t(Ct),t(vt),t(ge),t(_t),t(T),t(Jt),t(Et),t(Ce),t(xt),t(It),t(_e),t(Rt),t(At),t(Pe)),t(w),f(C,e),f(x,e),f(I,e),f(R,e),f(G,e),f(S,e),f(B,e),f(V,e),f(Q,e),f(O),f(le),f(ne),f(ie),f(oe,e),f(re),f(de),f(he),f(fe),f(be),f(ye,e),f(Ue),f(je),f(Te,e),f(ve,e),f(Je,e)}}}const ls='{"title":"Phone","local":"phone","sections":[{"title":"Get started","local":"get-started","sections":[{"title":"Supported platforms","local":"supported-platforms","sections":[],"depth":3},{"title":"Phone orientation and controls","local":"phone-orientation-and-controls","sections":[],"depth":3},{"title":"Step 1: Choose the platform","local":"step-1-choose-the-platform","sections":[],"depth":3},{"title":"Step 2: Connect and calibrate","local":"step-2-connect-and-calibrate","sections":[],"depth":3},{"title":"Step 3: Run an example","local":"step-3-run-an-example","sections":[],"depth":3},{"title":"Important pipeline steps and options","local":"important-pipeline-steps-and-options","sections":[{"title":"Different IK initial guesses","local":"different-ik-initial-guesses","sections":[],"depth":4}],"depth":3},{"title":"Pipeline steps explained","local":"pipeline-steps-explained","sections":[],"depth":3},{"title":"Troubleshooting","local":"troubleshooting","sections":[],"depth":3}],"depth":2}],"depth":1}';function ss(dl){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Ol{constructor(w){super(),Kl(this,w,ss,ts,Nl,{})}}export{ps as component};
