import{s as hs,n as Us,o as bs}from"../chunks/scheduler.3e37077e.js";import{S as Is,i as fs,g as o,s as n,r as c,A as vs,h as i,f as s,c as a,j as js,u as p,x as r,k as us,y as Cs,a as l,v as M,d,t as y,w as m}from"../chunks/index.263272b0.js";import{C as w}from"../chunks/CodeBlock.76c31e3c.js";import{H as J,E as Bs}from"../chunks/getInferenceSnippets.932de0ac.js";function gs(Ee){let T,Bt,vt,gt,j,At,u,Xe=`In robotics, there’s a fundamental mismatch between the data that robots and humans produce and what machine learning models expect.
Robots output raw sensor data like camera images and joint positions that need normalization, batching, and device placement before models can process them.
Language instructions from humans must be tokenized into numerical representations, and different robots use different coordinate systems that need standardization.`,Zt,h,Ye=`The challenge extends to model outputs as well.
Models might output end-effector positions while robots need joint-space commands, or teleoperators produce relative movements while robots expect absolute commands.
Model predictions are often normalized and need conversion back to real-world scales.`,Gt,U,Qe=`Cross-domain translation adds another layer of complexity.
Training data from one robot setup needs adaptation for deployment on different hardware, models trained with specific camera configurations must work with new arrangements, and datasets with different naming conventions need harmonization.`,Rt,b,ze=`<strong>That’s where processors come in.</strong> They serve as universal translators that bridge these gaps, ensuring seamless data flow from sensors to models to actuators.
Processors handle all the preprocessing and postprocessing steps needed to convert raw environment data into model-ready inputs and vice versa.`,_t,I,We="This means that your favorite policy can be used like this:",Nt,f,$t,v,Vt,C,ke="In robotics, data comes in many forms: images from cameras, joint positions from sensors, text instructions from users, and more. Each type of data requires specific transformations before a model can use it effectively. Models need this data to be:",Et,B,He="<li><strong>Normalized</strong>: Scaled to appropriate ranges for neural network processing</li> <li><strong>Batched</strong>: Organized with proper dimensions for batch processing</li> <li><strong>Tokenized</strong>: Text converted to numerical representations</li> <li><strong>Device-placed</strong>: Moved to the right hardware (CPU/GPU)</li> <li><strong>Type-converted</strong>: Cast to appropriate data types</li>",Xt,g,Fe="Processors handle these transformations through composable, reusable steps that can be chained together into pipelines. Think of them as a modular assembly line where each station performs a specific transformation on your data.",Yt,A,Qt,Z,zt,G,Se=`The <code>EnvTransition</code> is the fundamental data structure that flows through all processors.
It’s a typed dictionary that represents a complete robot-environment interaction:`,Wt,R,Pe="<li><strong>OBSERVATION</strong>: All sensor data (images, states, proprioception)</li> <li><strong>ACTION</strong>: The action to execute or that was executed</li> <li><strong>REWARD</strong>: Reinforcement learning signal</li> <li><strong>DONE/TRUNCATED</strong>: Episode boundary indicators</li> <li><strong>INFO</strong>: Arbitrary metadata</li> <li><strong>COMPLEMENTARY_DATA</strong>: Task descriptions, indices, padding flags, inter-step data</li>",kt,_,Ht,N,xe="A <code>ProcessorStep</code> is a single transformation unit that processes transitions. It’s an abstract base class with two required methods:",Ft,$,St,V,qe="<code>__call__</code> is the core of your processor step. It takes an <code>EnvTransition</code> and returns a modified <code>EnvTransition</code>.",Pt,E,Le="<code>transform_features</code> is used to declare how this step transforms feature shapes/types.",xt,X,qt,Y,De="The <code>DataProcessorPipeline[TInput, TOutput]</code> chains multiple <code>ProcessorStep</code> instances together:",Lt,Q,Dt,z,Kt,W,Ke="The key distinction is in the data structures they handle:",Ot,k,Oe="<thead><tr><th>Aspect</th> <th>RobotProcessorPipeline</th> <th>PolicyProcessorPipeline</th></tr></thead> <tbody><tr><td><strong>Input</strong></td> <td><code>dict[str, Any]</code> - Individual robot values</td> <td><code>dict[str, Any]</code> - Batched tensors</td></tr> <tr><td><strong>Output</strong></td> <td><code>dict[str, Any]</code> - Individual robot commands</td> <td><code>torch.Tensor</code> - Policy predictions</td></tr> <tr><td><strong>Use Case</strong></td> <td>Real-time robot control</td> <td>Model training/inference</td></tr> <tr><td><strong>Data Format</strong></td> <td>Unbatched, heterogeneous</td> <td>Batched, homogeneous</td></tr> <tr><td><strong>Examples</strong></td> <td><code>{&quot;joint_1&quot;: 0.5}</code></td> <td><code>{&quot;observation.state&quot;: tensor([[0.5]])}</code></td></tr></tbody>",te,H,ts="<strong>Use <code>RobotProcessorPipeline</code></strong> for robot hardware interfaces:",ee,F,se,S,es="<strong>Use <code>PolicyProcessorPipeline</code></strong> for model training and batch processing:",le,P,ne,x,ae,q,ss="LeRobot provides converter functions to bridge different data formats in <code>lerobot.processor.converters</code>. These functions handle the crucial translations between robot hardware data structures, policy model formats, and the internal <code>EnvTransition</code> representation that flows through processor pipelines.",oe,L,ls="<thead><tr><th>Category</th> <th>Function</th> <th>Description</th></tr></thead> <tbody><tr><td><strong>Robot Hardware Converters</strong></td> <td><code>robot_action_to_transition</code></td> <td>Robot dict → EnvTransition</td></tr> <tr><td></td> <td><code>observation_to_transition</code></td> <td>Robot obs → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_robot_action</code></td> <td>EnvTransition → Robot dict</td></tr> <tr><td><strong>Policy/Training Converters</strong></td> <td><code>batch_to_transition</code></td> <td>Batch dict → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_batch</code></td> <td>EnvTransition → Batch dict</td></tr> <tr><td></td> <td><code>policy_action_to_transition</code></td> <td>Policy tensor → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_policy_action</code></td> <td>EnvTransition → Policy tensor</td></tr> <tr><td><strong>Utilities</strong></td> <td><code>create_transition</code></td> <td>Build transitions with defaults</td></tr> <tr><td></td> <td><code>identity_transition</code></td> <td>Pass-through converter</td></tr></tbody>",ie,D,ns="The key insight is that <strong>robot hardware converters</strong> work with individual values and dictionaries, while <strong>policy/training converters</strong> work with batched tensors and model outputs. The converter functions automatically handle the structural differences, so your processor steps can focus on the core transformations without worrying about data format compatibility.",re,K,ce,O,as="The following examples demonstrate real-world processor configurations for policy training and inference.",pe,tt,os="Here is an example processor for policy training and inference:",Me,et,de,st,ye,lt,is="The most common real-world scenario combines both pipeline types robot hardware generates observations that need policy processing, and policy outputs need robot-compatible postprocessing:",me,nt,Je,at,Te,ot,rs="Processors don’t just transform data - they can also <strong>change the data structure itself</strong>. The <code>transform_features()</code> method declares these changes, which is crucial for dataset recording and policy creation.",we,it,je,rt,cs="When building datasets or policies, LeRobot needs to know:",ue,ct,ps="<li><strong>What data fields will exist</strong> after processing</li> <li><strong>What shapes and types</strong> each field will have</li> <li><strong>How to configure models</strong> for the expected data structure</li>",he,pt,Ue,Mt,be,dt,Ms=`<code>create_initial_features()</code> and <code>aggregate_pipeline_dataset_features()</code> solve a critical dataset creation problem: determining the exact final data structure before any data is processed.
Since processor pipelines can add new features (like velocity fields), change tensor shapes (like cropping images), or rename keys, datasets need to know the complete output specification upfront to allocate proper storage and define schemas.
These functions work together by starting with robot hardware specifications (<code>create_initial_features()</code>) then simulating the entire pipeline transformation (<code>aggregate_pipeline_dataset_features()</code>) to compute the final feature dictionary that gets passed to <code>LeRobotDataset.create()</code>, ensuring perfect alignment between what processors output and what datasets expect to store.`,Ie,yt,fe,mt,ve,Jt,ds="LeRobot provides many registered processor steps. Here are the most commonly used core processors:",Ce,Tt,Be,wt,ys="<li><strong><code>normalizer_processor</code></strong>: Normalize observations/actions using dataset statistics (mean/std or min/max)</li> <li><strong><code>device_processor</code></strong>: Move tensors to CPU/GPU with optional dtype conversion</li> <li><strong><code>to_batch_processor</code></strong>: Add batch dimensions to transitions for model compatibility</li> <li><strong><code>rename_observations_processor</code></strong>: Rename observation keys using mapping dictionaries</li> <li><strong><code>tokenizer_processor</code></strong>: Tokenize natural language task descriptions into tokens and attention masks</li>",ge,jt,Ae,ut,ms='<li><strong><a href="implement_your_own_processor.mdx">Implement Your Own Processor</a></strong> - Create custom processor steps</li> <li><strong><a href="debug_processor_pipeline.mdx">Debug Your Pipeline</a></strong> - Troubleshoot and optimize pipelines</li> <li><strong><a href="processors_robots_teleop.mdx">Processors for Robots and Teleoperators</a></strong> - Real-world integration patterns</li>',Ze,ht,Ge,Ut,Js="Processors solve the data translation problem in robotics by providing:",Re,bt,Ts="<li><strong>Modular transformations</strong>: Composable, reusable processing steps</li> <li><strong>Type safety</strong>: Generic pipelines with compile-time checking</li> <li><strong>Performance optimization</strong>: GPU-accelerated operations</li> <li><strong>Robot/Policy distinction</strong>: Separate pipelines for different data structures</li> <li><strong>Comprehensive ecosystem</strong>: 30+ registered processors for common tasks</li>",_e,It,ws="The key insight: <code>RobotProcessorPipeline</code> handles unbatched robot hardware data, while <code>PolicyProcessorPipeline</code> handles batched model data. Choose the right tool for your data structure!",Ne,ft,$e,Ct,Ve;return j=new J({props:{title:"Introduction to Processors",local:"introduction-to-processors",headingTag:"h1"}}),f=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwbGVyb2JvdC5kYXRhc2V0cy5sZXJvYm90X2RhdGFzZXQlMjBpbXBvcnQlMjBMZVJvYm90RGF0YXNldCUwQWZyb20lMjBsZXJvYm90LnBvbGljaWVzLmZhY3RvcnklMjBpbXBvcnQlMjBtYWtlX3ByZV9wb3N0X3Byb2Nlc3NvcnMlMEFmcm9tJTIwbGVyb2JvdC5wb2xpY2llcy55b3VyX3BvbGljeSUyMGltcG9ydCUyMFlvdXJQb2xpY3klMEFmcm9tJTIwbGVyb2JvdC5wcm9jZXNzb3IucGlwZWxpbmUlMjBpbXBvcnQlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lJTJDJTIwUG9saWN5UHJvY2Vzc29yUGlwZWxpbmUlMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQoJTIyaGZfdXNlciUyRmRhdGFzZXQlMjIlMkMlMjBlcGlzb2RlcyUzRCU1QjAlNUQpJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjEwJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBZb3VyUG9saWN5LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoZl91c2VyJTJGbW9kZWwlMjIlMkMlMEEpJTBBbW9kZWwuZXZhbCgpJTBBbW9kZWwudG8oJTIyY3VkYSUyMiklMEFwcmVwcm9jZXNzb3IlMkMlMjBwb3N0cHJvY2Vzc29yJTIwJTNEJTIwbWFrZV9wcmVfcG9zdF9wcm9jZXNzb3JzKG1vZGVsLmNvbmZpZyUyQyUyMHByZXRyYWluZWRfcGF0aCUzRCUyMmhmX3VzZXIlMkZtb2RlbCUyMiUyQyUyMGRhdGFzZXRfc3RhdHMlM0RkYXRhc2V0Lm1ldGEuc3RhdHMpJTBBJTBBcHJlcHJvY2Vzc2VkX3NhbXBsZSUyMCUzRCUyMHByZXByb2Nlc3NvcihzYW1wbGUpJTBBYWN0aW9uJTIwJTNEJTIwbW9kZWwuc2VsZWN0X2FjdGlvbihwcmVwcm9jZXNzZWRfc2FtcGxlKSUwQXBvc3Rwcm9jZXNzZWRfYWN0aW9uJTIwJTNEJTIwcG9zdHByb2Nlc3NvcihhY3Rpb24p",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset
<span class="hljs-keyword">from</span> lerobot.policies.factory <span class="hljs-keyword">import</span> make_pre_post_processors
<span class="hljs-keyword">from</span> lerobot.policies.your_policy <span class="hljs-keyword">import</span> YourPolicy
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessorPipeline, PolicyProcessorPipeline
dataset = LeRobotDataset(<span class="hljs-string">&quot;hf_user/dataset&quot;</span>, episodes=[<span class="hljs-number">0</span>])
sample = dataset[<span class="hljs-number">10</span>]

model = YourPolicy.from_pretrained(
    <span class="hljs-string">&quot;hf_user/model&quot;</span>,
)
model.<span class="hljs-built_in">eval</span>()
model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
preprocessor, postprocessor = make_pre_post_processors(model.config, pretrained_path=<span class="hljs-string">&quot;hf_user/model&quot;</span>, dataset_stats=dataset.meta.stats)

preprocessed_sample = preprocessor(sample)
action = model.select_action(preprocessed_sample)
postprocessed_action = postprocessor(action)`,wrap:!1}}),v=new J({props:{title:"What are Processors?",local:"what-are-processors",headingTag:"h2"}}),A=new J({props:{title:"Core Concepts",local:"core-concepts",headingTag:"h2"}}),Z=new J({props:{title:"EnvTransition: The Universal Data Container",local:"envtransition-the-universal-data-container",headingTag:"h3"}}),_=new J({props:{title:"ProcessorStep: The Building Block",local:"processorstep-the-building-block",headingTag:"h3"}}),$=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUHJvY2Vzc29yU3RlcCUyQyUyMEVudlRyYW5zaXRpb24lMEElMEFjbGFzcyUyME15UHJvY2Vzc29yU3RlcChQcm9jZXNzb3JTdGVwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkV4YW1wbGUlMjBwcm9jZXNzb3IlMjBzdGVwJTIwLSUyMGluaGVyaXQlMjBhbmQlMjBpbXBsZW1lbnQlMjBhYnN0cmFjdCUyMG1ldGhvZHMuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNmb3JtJTIwdGhlJTIwdHJhbnNpdGlvbiUyMC0lMjBSRVFVSVJFRCUyMGFic3RyYWN0JTIwbWV0aG9kLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBwcm9jZXNzaW5nJTIwbG9naWMlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNpdGlvbiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRyYW5zZm9ybV9mZWF0dXJlcyhzZWxmJTJDJTIwZmVhdHVyZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyRGVjbGFyZSUyMGhvdyUyMHRoaXMlMjBzdGVwJTIwdHJhbnNmb3JtcyUyMGZlYXR1cmUlMjBzaGFwZXMlMkZ0eXBlcyUyMC0lMjBSRVFVSVJFRCUyMGFic3RyYWN0JTIwbWV0aG9kLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZlYXR1cmVzJTIwJTIwJTIzJTIwTW9zdCUyMHByb2Nlc3NvcnMlMjByZXR1cm4lMjBmZWF0dXJlcyUyMHVuY2hhbmdlZA==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> ProcessorStep, EnvTransition

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyProcessorStep</span>(<span class="hljs-title class_ inherited__">ProcessorStep</span>):
    <span class="hljs-string">&quot;&quot;&quot;Example processor step - inherit and implement abstract methods.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        <span class="hljs-string">&quot;&quot;&quot;Transform the transition - REQUIRED abstract method.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># Your processing logic here</span>
        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features</span>):
        <span class="hljs-string">&quot;&quot;&quot;Declare how this step transforms feature shapes/types - REQUIRED abstract method.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> features  <span class="hljs-comment"># Most processors return features unchanged</span>`,wrap:!1}}),X=new J({props:{title:"DataProcessorPipeline: The Generic Orchestrator",local:"dataprocessorpipeline-the-generic-orchestrator",headingTag:"h3"}}),Q=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3JQaXBlbGluZSUyQyUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTBBJTBBJTIzJTIwRm9yJTIwcm9ib3QlMjBoYXJkd2FyZSUyMCh1bmJhdGNoZWQlMjBkYXRhKSUwQXJvYm90X3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yUGlwZWxpbmUlNUJSb2JvdEFjdGlvbiUyQyUyMFJvYm90QWN0aW9uJTVEKCUwQSUyMCUyMCUyMCUyMHN0ZXBzJTNEJTVCc3RlcDElMkMlMjBzdGVwMiUyQyUyMHN0ZXAzJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMnJvYm90X3BpcGVsaW5lJTIyJTBBKSUwQSUwQSUyMyUyMEZvciUyMG1vZGVsJTIwdHJhaW5pbmclMkZpbmZlcmVuY2UlMjAoYmF0Y2hlZCUyMGRhdGEpJTBBcG9saWN5X3Byb2Nlc3NvciUyMCUzRCUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTVCZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUJzdGVwMSUyQyUyMHN0ZXAyJTJDJTIwc3RlcDMlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIycG9saWN5X3BpcGVsaW5lJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> RobotProcessorPipeline, PolicyProcessorPipeline

<span class="hljs-comment"># For robot hardware (unbatched data)</span>
robot_processor = RobotProcessorPipeline[RobotAction, RobotAction](
    steps=[step1, step2, step3],
    name=<span class="hljs-string">&quot;robot_pipeline&quot;</span>
)

<span class="hljs-comment"># For model training/inference (batched data)</span>
policy_processor = PolicyProcessorPipeline[<span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]](
    steps=[step1, step2, step3],
    name=<span class="hljs-string">&quot;policy_pipeline&quot;</span>
)`,wrap:!1}}),z=new J({props:{title:"RobotProcessorPipeline vs PolicyProcessorPipeline",local:"robotprocessorpipeline-vs-policyprocessorpipeline",headingTag:"h2"}}),F=new w({props:{code:"JTIzJTIwUm9ib3QlMjBkYXRhJTIwc3RydWN0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjBmb3IlMjBvYnNlcnZhdGlvbnMlMjBhbmQlMjBhY3Rpb25zJTBBcm9ib3Rfb2JzJTNBJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzElMjIlM0ElMjAwLjUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJbmRpdmlkdWFsJTIwam9pbnQlMjB2YWx1ZXMlMEElMjAlMjAlMjAlMjAlMjJqb2ludF8yJTIyJTNBJTIwLTAuMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmNhbWVyYV8wJTIyJTNBJTIwaW1hZ2VfYXJyYXklMjAlMjAlMjAlMjMlMjBSYXclMjBjYW1lcmElMjBkYXRhJTBBJTdEJTBBJTBBcm9ib3RfYWN0aW9uJTNBJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzElMjIlM0ElMjAwLjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYXJnZXQlMjBqb2ludCUyMHBvc2l0aW9ucyUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzIlMjIlM0ElMjAwLjElMkMlMEElMjAlMjAlMjAlMjAlMjJncmlwcGVyJTIyJTNBJTIwMC44JTBBJTdE",highlighted:`<span class="hljs-comment"># Robot data structures: dict[str, Any] for observations and actions</span>
robot_obs: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;joint_1&quot;</span>: <span class="hljs-number">0.5</span>,           <span class="hljs-comment"># Individual joint values</span>
    <span class="hljs-string">&quot;joint_2&quot;</span>: -<span class="hljs-number">0.3</span>,
    <span class="hljs-string">&quot;camera_0&quot;</span>: image_array   <span class="hljs-comment"># Raw camera data</span>
}

robot_action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;joint_1&quot;</span>: <span class="hljs-number">0.2</span>,          <span class="hljs-comment"># Target joint positions</span>
    <span class="hljs-string">&quot;joint_2&quot;</span>: <span class="hljs-number">0.1</span>,
    <span class="hljs-string">&quot;gripper&quot;</span>: <span class="hljs-number">0.8</span>
}`,wrap:!1}}),P=new w({props:{code:"JTIzJTIwUG9saWN5JTIwZGF0YSUyMHN0cnVjdHVyZXMlM0ElMjBiYXRjaCUyMGRpY3RzJTIwYW5kJTIwdGVuc29ycyUwQXBvbGljeV9iYXRjaCUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiUzQSUyMHRvcmNoLnRlbnNvciglNUIlNUIwLjUlMkMlMjAtMC4zJTVEJTVEKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEJhdGNoZWQlMjBzdGF0ZXMlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuY2FtZXJhMCUyMiUzQSUyMHRvcmNoLnRlbnNvciguLi4pJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmF0Y2hlZCUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbiUyMiUzQSUyMHRvcmNoLnRlbnNvciglNUIlNUIwLjIlMkMlMjAwLjElMkMlMjAwLjglNUQlNUQpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmF0Y2hlZCUyMGFjdGlvbnMlMEElN0QlMEElMEFwb2xpY3lfYWN0aW9uJTNBJTIwdG9yY2guVGVuc29yJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QiU1QjAuMiUyQyUyMDAuMSUyQyUyMDAuOCU1RCU1RCklMjAlMjAlMjMlMjBNb2RlbCUyMG91dHB1dCUyMHRlbnNvcg==",highlighted:`<span class="hljs-comment"># Policy data structures: batch dicts and tensors</span>
policy_batch: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;observation.state&quot;</span>: torch.tensor([[<span class="hljs-number">0.5</span>, -<span class="hljs-number">0.3</span>]]),      <span class="hljs-comment"># Batched states</span>
    <span class="hljs-string">&quot;observation.images.camera0&quot;</span>: torch.tensor(...),        <span class="hljs-comment"># Batched images</span>
    <span class="hljs-string">&quot;action&quot;</span>: torch.tensor([[<span class="hljs-number">0.2</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.8</span>]])              <span class="hljs-comment"># Batched actions</span>
}

policy_action: torch.Tensor = torch.tensor([[<span class="hljs-number">0.2</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.8</span>]])  <span class="hljs-comment"># Model output tensor</span>`,wrap:!1}}),x=new J({props:{title:"Converter Functions",local:"converter-functions",headingTag:"h2"}}),K=new J({props:{title:"Processor Examples",local:"processor-examples",headingTag:"h2"}}),et=new w({props:{code:"JTIzJTIwVHJhaW5pbmclMjBkYXRhJTIwcHJlcHJvY2Vzc2luZyUyMChvcHRpbWl6ZWQlMjBvcmRlciUyMGZvciUyMEdQVSUyMHBlcmZvcm1hbmNlKSUwQXRyYWluaW5nX3ByZXByb2Nlc3NvciUyMCUzRCUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTVCZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZW5hbWVPYnNlcnZhdGlvbnNQcm9jZXNzb3JTdGVwKHJlbmFtZV9tYXAlM0QlN0IlN0QpJTJDJTIwJTIwJTIwJTIwJTIwJTIzJTIwU3RhbmRhcmRpemUlMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQWRkQmF0Y2hEaW1lbnNpb25Qcm9jZXNzb3JTdGVwKCklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBiYXRjaCUyMGRpbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb2tlbml6ZXJQcm9jZXNzb3JTdGVwKHRva2VuaXplcl9uYW1lJTNEJTIyLi4uJTIyJTJDJTIwLi4uKSUyQyUyMCUyMCUyMyUyMFRva2VuaXplJTIwbGFuZ3VhZ2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTW92ZSUyMHRvJTIwR1BVJTIwZmlyc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOb3JtYWxpemVyUHJvY2Vzc29yU3RlcChmZWF0dXJlcyUzRC4uLiUyQyUyMHN0YXRzJTNELi4uKSUyQyUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMG9uJTIwR1BVJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQSUyMyUyME1vZGVsJTIwb3V0cHV0JTIwcG9zdHByb2Nlc3NpbmclMEF0cmFpbmluZ19wb3N0cHJvY2Vzc29yJTIwJTNEJTIwUG9saWN5UHJvY2Vzc29yUGlwZWxpbmUlNUJ0b3JjaC5UZW5zb3IlMkMlMjB0b3JjaC5UZW5zb3IlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmNwdSUyMiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb3ZlJTIwdG8lMjBDUFUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbm5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKGZlYXR1cmVzJTNELi4uJTJDJTIwc3RhdHMlM0QuLi4pJTJDJTIwJTIzJTIwRGVub3JtYWxpemUlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjB0b190cmFuc2l0aW9uJTNEcG9saWN5X2FjdGlvbl90b190cmFuc2l0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9fb3V0cHV0JTNEdHJhbnNpdGlvbl90b19wb2xpY3lfYWN0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Training data preprocessing (optimized order for GPU performance)</span>
training_preprocessor = PolicyProcessorPipeline[<span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]](
    steps=[
        RenameObservationsProcessorStep(rename_map={}),     <span class="hljs-comment"># Standardize keys</span>
        AddBatchDimensionProcessorStep(),                   <span class="hljs-comment"># Add batch dims</span>
        TokenizerProcessorStep(tokenizer_name=<span class="hljs-string">&quot;...&quot;</span>, ...),  <span class="hljs-comment"># Tokenize language</span>
        DeviceProcessorStep(device=<span class="hljs-string">&quot;cuda&quot;</span>),                 <span class="hljs-comment"># Move to GPU first</span>
        NormalizerProcessorStep(features=..., stats=...),   <span class="hljs-comment"># Normalize on GPU</span>
    ]
)

<span class="hljs-comment"># Model output postprocessing</span>
training_postprocessor = PolicyProcessorPipeline[torch.Tensor, torch.Tensor](
    steps=[
        DeviceProcessorStep(device=<span class="hljs-string">&quot;cpu&quot;</span>),                  <span class="hljs-comment"># Move to CPU</span>
        UnnormalizerProcessorStep(features=..., stats=...), <span class="hljs-comment"># Denormalize</span>
    ]
    to_transition=policy_action_to_transition,
    to_output=transition_to_policy_action,
)`,wrap:!1}}),st=new J({props:{title:"An interaction between a robot and a policy with processors",local:"an-interaction-between-a-robot-and-a-policy-with-processors",headingTag:"h3"}}),nt=new w({props:{code:"JTIzJTIwUmVhbCUyMGRlcGxveW1lbnQlM0ElMjBSb2JvdCUyMHNlbnNvcnMlMjAlRTIlODYlOTIlMjBNb2RlbCUyMCVFMiU4NiU5MiUyMFJvYm90JTIwY29tbWFuZHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBub3QlMjBkb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X29icyUyMCUzRCUyMHJvYm90LmdldF9vYnNlcnZhdGlvbigpJTIwJTIwJTIzJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFkZCUyMHlvdXIlMjByb2JvdCUyMG9ic2VydmF0aW9uJTIwdG8lMjBwb2xpY3klMjBvYnNlcnZhdGlvbiUyMHByb2Nlc3NvciUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbGljeV9pbnB1dCUyMCUzRCUyMHBvbGljeV9wcmVwcm9jZXNzb3IocmF3X29icyklMjAlMjAlMjMlMjBCYXRjaGVkJTIwZGljdCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbGljeV9vdXRwdXQlMjAlM0QlMjBwb2xpY3kuc2VsZWN0X2FjdGlvbihwb2xpY3lfaW5wdXQpJTIwJTIwJTIzJTIwUG9saWN5JTIwdGVuc29yJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9saWN5X2FjdGlvbiUyMCUzRCUyMHBvbGljeV9wb3N0cHJvY2Vzc29yKHBvbGljeV9vdXRwdXQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWRkJTIweW91ciUyMHJvYm90JTIwYWN0aW9uJTIwdG8lMjBwb2xpY3klMjBhY3Rpb24lMjBwcm9jZXNzb3IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2JvdC5zZW5kX2FjdGlvbihwb2xpY3lfYWN0aW9uKQ==",highlighted:`<span class="hljs-comment"># Real deployment: Robot sensors → Model → Robot commands</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        raw_obs = robot.get_observation()  <span class="hljs-comment"># dict[str, Any]</span>

        <span class="hljs-comment"># Add your robot observation to policy observation processor</span>

        policy_input = policy_preprocessor(raw_obs)  <span class="hljs-comment"># Batched dict</span>

        policy_output = policy.select_action(policy_input)  <span class="hljs-comment"># Policy tensor</span>

        policy_action = policy_postprocessor(policy_output)

        <span class="hljs-comment"># Add your robot action to policy action processor</span>

        robot.send_action(policy_action)`,wrap:!1}}),at=new J({props:{title:"Feature Contracts: Shape and Type Transformation",local:"feature-contracts-shape-and-type-transformation",headingTag:"h2"}}),it=new J({props:{title:"Why Feature Contracts Matter",local:"why-feature-contracts-matter",headingTag:"h3"}}),pt=new w({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMEElMjBwcm9jZXNzb3IlMjB0aGF0JTIwYWRkcyUyMHZlbG9jaXR5JTIwdG8lMjBvYnNlcnZhdGlvbnMlMEFjbGFzcyUyMFZlbG9jaXR5UHJvY2Vzc29yKE9ic2VydmF0aW9uUHJvY2Vzc29yU3RlcCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBvYnNlcnZhdGlvbihzZWxmJTJDJTIwb2JzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5ld19vYnMlMjAlM0QlMjBvYnMuY29weSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiUyMGluJTIwb2JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwY29uY2F0ZW5hdGUlMjBjb21wdXRlZCUyMHZlbG9jaXR5JTIwZmllbGQlMjB0byUyMHRoZSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X29icyU1QiUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTVEJTIwJTNEJTIwc2VsZi5fY29tcHV0ZV92ZWxvY2l0eShvYnMlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBuZXdfb2JzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJEZWNsYXJlJTIwdGhlJTIwbmV3JTIwdmVsb2NpdHklMjBmaWVsZCUyMHdlJ3JlJTIwYWRkaW5nLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlX2ZlYXR1cmUlMjAlM0QlMjBmZWF0dXJlcyU1QlBpcGVsaW5lRmVhdHVyZVR5cGUuT0JTRVJWQVRJT04lNUQuZ2V0KCUyMm9ic2VydmF0aW9uLnN0YXRlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RhdGVfZmVhdHVyZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvdWJsZV9zaGFwZSUyMCUzRCUyMChzdGF0ZV9mZWF0dXJlLnNoYXBlJTVCMCU1RCUyMColMjAyJTJDKSUyMGlmJTIwc3RhdGVfZmVhdHVyZS5zaGFwZSUyMGVsc2UlMjAoMiUyQyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyU1QlBpcGVsaW5lRmVhdHVyZVR5cGUuT0JTRVJWQVRJT04lNUQlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RCUyMCUzRCUyMFBvbGljeUZlYXR1cmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzREZlYXR1cmVUeXBlLlNUQVRFJTJDJTIwc2hhcGUlM0Rkb3VibGVfc2hhcGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-comment"># Example: A processor that adds velocity to observations</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">VelocityProcessor</span>(<span class="hljs-title class_ inherited__">ObservationProcessorStep</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">observation</span>(<span class="hljs-params">self, obs</span>):
        new_obs = obs.copy()
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">in</span> obs:
            <span class="hljs-comment"># concatenate computed velocity field to the state</span>
            new_obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = self._compute_velocity(obs[<span class="hljs-string">&quot;observation.state&quot;</span>])
        <span class="hljs-keyword">return</span> new_obs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features</span>):
        <span class="hljs-string">&quot;&quot;&quot;Declare the new velocity field we&#x27;re adding.&quot;&quot;&quot;</span>
        state_feature = features[PipelineFeatureType.OBSERVATION].get(<span class="hljs-string">&quot;observation.state&quot;</span>)
        <span class="hljs-keyword">if</span> state_feature:
            double_shape = (state_feature.shape[<span class="hljs-number">0</span>] * <span class="hljs-number">2</span>,) <span class="hljs-keyword">if</span> state_feature.shape <span class="hljs-keyword">else</span> (<span class="hljs-number">2</span>,)
            features[PipelineFeatureType.OBSERVATION][<span class="hljs-string">&quot;observation.state&quot;</span>] = PolicyFeature(
                <span class="hljs-built_in">type</span>=FeatureType.STATE, shape=double_shape
            )
        <span class="hljs-keyword">return</span> features`,wrap:!1}}),Mt=new J({props:{title:"Feature Specification Functions",local:"feature-specification-functions",headingTag:"h3"}}),yt=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMucGlwZWxpbmVfZmVhdHVyZXMlMjBpbXBvcnQlMjBhZ2dyZWdhdGVfcGlwZWxpbmVfZGF0YXNldF9mZWF0dXJlcyUwQSUwQSUyMyUyMFN0YXJ0JTIwd2l0aCUyMHJvYm90J3MlMjByYXclMjBmZWF0dXJlcyUwQWluaXRpYWxfZmVhdHVyZXMlMjAlM0QlMjBjcmVhdGVfaW5pdGlhbF9mZWF0dXJlcyglMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUzRHJvYm90Lm9ic2VydmF0aW9uX2ZlYXR1cmVzJTJDJTIwJTIwJTIzJTIwJTdCJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUyMCUyMmNhbWVyYV8wJTIyJTNBJTIwKDQ4MCUyQzY0MCUyQzMpJTdEJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTNEcm9ib3QuYWN0aW9uX2ZlYXR1cmVzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJTdCJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUyMCUyMmdyaXBwZXIucG9zJTIyJTNBJTIwZmxvYXQlN0QlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjBwcm9jZXNzb3IlMjBwaXBlbGluZSUyMHRvJTIwY29tcHV0ZSUyMGZpbmFsJTIwZmVhdHVyZXMlMEFmaW5hbF9mZWF0dXJlcyUyMCUzRCUyMGFnZ3JlZ2F0ZV9waXBlbGluZV9kYXRhc2V0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEbXlfcHJvY2Vzc29yX3BpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9mZWF0dXJlcyUzRGluaXRpYWxfZmVhdHVyZXMlMkMlMEElMjAlMjAlMjAlMjB1c2VfdmlkZW9zJTNEVHJ1ZSUwQSklMEElMEElMjMlMjBVc2UlMjBmb3IlMjBkYXRhc2V0JTIwY3JlYXRpb24lMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJteV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0RmaW5hbF9mZWF0dXJlcyUyQyUyMCUyMCUyMyUyMEtub3dzJTIwZXhhY3RseSUyMHdoYXQlMjBkYXRhJTIwdG8lMjBleHBlY3QlMEElMjAlMjAlMjAlMjAuLi4lMEEp",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.pipeline_features <span class="hljs-keyword">import</span> aggregate_pipeline_dataset_features

<span class="hljs-comment"># Start with robot&#x27;s raw features</span>
initial_features = create_initial_features(
    observation=robot.observation_features,  <span class="hljs-comment"># {&quot;joint_1.pos&quot;: float, &quot;camera_0&quot;: (480,640,3)}</span>
    action=robot.action_features            <span class="hljs-comment"># {&quot;joint_1.pos&quot;: float, &quot;gripper.pos&quot;: float}</span>
)

<span class="hljs-comment"># Apply processor pipeline to compute final features</span>
final_features = aggregate_pipeline_dataset_features(
    pipeline=my_processor_pipeline,
    initial_features=initial_features,
    use_videos=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Use for dataset creation</span>
dataset = LeRobotDataset.create(
    repo_id=<span class="hljs-string">&quot;my_dataset&quot;</span>,
    features=final_features,  <span class="hljs-comment"># Knows exactly what data to expect</span>
    ...
)`,wrap:!1}}),mt=new J({props:{title:"Common Processor Steps",local:"common-processor-steps",headingTag:"h2"}}),Tt=new J({props:{title:"Essential Processors",local:"essential-processors",headingTag:"h3"}}),jt=new J({props:{title:"Next Steps",local:"next-steps",headingTag:"h3"}}),ht=new J({props:{title:"Summary",local:"summary",headingTag:"h2"}}),ft=new Bs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/introduction_processors.mdx"}}),{c(){T=o("meta"),Bt=n(),vt=o("p"),gt=n(),c(j.$$.fragment),At=n(),u=o("p"),u.textContent=Xe,Zt=n(),h=o("p"),h.textContent=Ye,Gt=n(),U=o("p"),U.textContent=Qe,Rt=n(),b=o("p"),b.innerHTML=ze,_t=n(),I=o("p"),I.textContent=We,Nt=n(),c(f.$$.fragment),$t=n(),c(v.$$.fragment),Vt=n(),C=o("p"),C.textContent=ke,Et=n(),B=o("ul"),B.innerHTML=He,Xt=n(),g=o("p"),g.textContent=Fe,Yt=n(),c(A.$$.fragment),Qt=n(),c(Z.$$.fragment),zt=n(),G=o("p"),G.innerHTML=Se,Wt=n(),R=o("ul"),R.innerHTML=Pe,kt=n(),c(_.$$.fragment),Ht=n(),N=o("p"),N.innerHTML=xe,Ft=n(),c($.$$.fragment),St=n(),V=o("p"),V.innerHTML=qe,Pt=n(),E=o("p"),E.innerHTML=Le,xt=n(),c(X.$$.fragment),qt=n(),Y=o("p"),Y.innerHTML=De,Lt=n(),c(Q.$$.fragment),Dt=n(),c(z.$$.fragment),Kt=n(),W=o("p"),W.textContent=Ke,Ot=n(),k=o("table"),k.innerHTML=Oe,te=n(),H=o("p"),H.innerHTML=ts,ee=n(),c(F.$$.fragment),se=n(),S=o("p"),S.innerHTML=es,le=n(),c(P.$$.fragment),ne=n(),c(x.$$.fragment),ae=n(),q=o("p"),q.innerHTML=ss,oe=n(),L=o("table"),L.innerHTML=ls,ie=n(),D=o("p"),D.innerHTML=ns,re=n(),c(K.$$.fragment),ce=n(),O=o("p"),O.textContent=as,pe=n(),tt=o("p"),tt.textContent=os,Me=n(),c(et.$$.fragment),de=n(),c(st.$$.fragment),ye=n(),lt=o("p"),lt.textContent=is,me=n(),c(nt.$$.fragment),Je=n(),c(at.$$.fragment),Te=n(),ot=o("p"),ot.innerHTML=rs,we=n(),c(it.$$.fragment),je=n(),rt=o("p"),rt.textContent=cs,ue=n(),ct=o("ul"),ct.innerHTML=ps,he=n(),c(pt.$$.fragment),Ue=n(),c(Mt.$$.fragment),be=n(),dt=o("p"),dt.innerHTML=Ms,Ie=n(),c(yt.$$.fragment),fe=n(),c(mt.$$.fragment),ve=n(),Jt=o("p"),Jt.textContent=ds,Ce=n(),c(Tt.$$.fragment),Be=n(),wt=o("ul"),wt.innerHTML=ys,ge=n(),c(jt.$$.fragment),Ae=n(),ut=o("ul"),ut.innerHTML=ms,Ze=n(),c(ht.$$.fragment),Ge=n(),Ut=o("p"),Ut.textContent=Js,Re=n(),bt=o("ul"),bt.innerHTML=Ts,_e=n(),It=o("p"),It.innerHTML=ws,Ne=n(),c(ft.$$.fragment),$e=n(),Ct=o("p"),this.h()},l(t){const e=vs("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(s),Bt=a(t),vt=i(t,"P",{}),js(vt).forEach(s),gt=a(t),p(j.$$.fragment,t),At=a(t),u=i(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1p4wxkn"&&(u.textContent=Xe),Zt=a(t),h=i(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-14636jx"&&(h.textContent=Ye),Gt=a(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1oobog8"&&(U.textContent=Qe),Rt=a(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ur6am2"&&(b.innerHTML=ze),_t=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ka3nux"&&(I.textContent=We),Nt=a(t),p(f.$$.fragment,t),$t=a(t),p(v.$$.fragment,t),Vt=a(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1begaqk"&&(C.textContent=ke),Et=a(t),B=i(t,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1ladsw4"&&(B.innerHTML=He),Xt=a(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-u7yi05"&&(g.textContent=Fe),Yt=a(t),p(A.$$.fragment,t),Qt=a(t),p(Z.$$.fragment,t),zt=a(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ppq2fo"&&(G.innerHTML=Se),Wt=a(t),R=i(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-106dygg"&&(R.innerHTML=Pe),kt=a(t),p(_.$$.fragment,t),Ht=a(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-8rfarm"&&(N.innerHTML=xe),Ft=a(t),p($.$$.fragment,t),St=a(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-13brd71"&&(V.innerHTML=qe),Pt=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mifbwe"&&(E.innerHTML=Le),xt=a(t),p(X.$$.fragment,t),qt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-8mdwcy"&&(Y.innerHTML=De),Lt=a(t),p(Q.$$.fragment,t),Dt=a(t),p(z.$$.fragment,t),Kt=a(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-wjgvgq"&&(W.textContent=Ke),Ot=a(t),k=i(t,"TABLE",{"data-svelte-h":!0}),r(k)!=="svelte-1gwm6ye"&&(k.innerHTML=Oe),te=a(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1tvtb9y"&&(H.innerHTML=ts),ee=a(t),p(F.$$.fragment,t),se=a(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-u5i30h"&&(S.innerHTML=es),le=a(t),p(P.$$.fragment,t),ne=a(t),p(x.$$.fragment,t),ae=a(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1svxhl3"&&(q.innerHTML=ss),oe=a(t),L=i(t,"TABLE",{"data-svelte-h":!0}),r(L)!=="svelte-5rwep8"&&(L.innerHTML=ls),ie=a(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-fqoi61"&&(D.innerHTML=ns),re=a(t),p(K.$$.fragment,t),ce=a(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-zzgjs2"&&(O.textContent=as),pe=a(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1bcvc84"&&(tt.textContent=os),Me=a(t),p(et.$$.fragment,t),de=a(t),p(st.$$.fragment,t),ye=a(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1is1ww4"&&(lt.textContent=is),me=a(t),p(nt.$$.fragment,t),Je=a(t),p(at.$$.fragment,t),Te=a(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1xj3b0m"&&(ot.innerHTML=rs),we=a(t),p(it.$$.fragment,t),je=a(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-np5mv2"&&(rt.textContent=cs),ue=a(t),ct=i(t,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1yhmz2o"&&(ct.innerHTML=ps),he=a(t),p(pt.$$.fragment,t),Ue=a(t),p(Mt.$$.fragment,t),be=a(t),dt=i(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-6gv7sj"&&(dt.innerHTML=Ms),Ie=a(t),p(yt.$$.fragment,t),fe=a(t),p(mt.$$.fragment,t),ve=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-kvop2o"&&(Jt.textContent=ds),Ce=a(t),p(Tt.$$.fragment,t),Be=a(t),wt=i(t,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-cbajy3"&&(wt.innerHTML=ys),ge=a(t),p(jt.$$.fragment,t),Ae=a(t),ut=i(t,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-1mbcjka"&&(ut.innerHTML=ms),Ze=a(t),p(ht.$$.fragment,t),Ge=a(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-kqr9xc"&&(Ut.textContent=Js),Re=a(t),bt=i(t,"UL",{"data-svelte-h":!0}),r(bt)!=="svelte-tctthc"&&(bt.innerHTML=Ts),_e=a(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1eyaijl"&&(It.innerHTML=ws),Ne=a(t),p(ft.$$.fragment,t),$e=a(t),Ct=i(t,"P",{}),js(Ct).forEach(s),this.h()},h(){us(T,"name","hf:doc:metadata"),us(T,"content",As)},m(t,e){Cs(document.head,T),l(t,Bt,e),l(t,vt,e),l(t,gt,e),M(j,t,e),l(t,At,e),l(t,u,e),l(t,Zt,e),l(t,h,e),l(t,Gt,e),l(t,U,e),l(t,Rt,e),l(t,b,e),l(t,_t,e),l(t,I,e),l(t,Nt,e),M(f,t,e),l(t,$t,e),M(v,t,e),l(t,Vt,e),l(t,C,e),l(t,Et,e),l(t,B,e),l(t,Xt,e),l(t,g,e),l(t,Yt,e),M(A,t,e),l(t,Qt,e),M(Z,t,e),l(t,zt,e),l(t,G,e),l(t,Wt,e),l(t,R,e),l(t,kt,e),M(_,t,e),l(t,Ht,e),l(t,N,e),l(t,Ft,e),M($,t,e),l(t,St,e),l(t,V,e),l(t,Pt,e),l(t,E,e),l(t,xt,e),M(X,t,e),l(t,qt,e),l(t,Y,e),l(t,Lt,e),M(Q,t,e),l(t,Dt,e),M(z,t,e),l(t,Kt,e),l(t,W,e),l(t,Ot,e),l(t,k,e),l(t,te,e),l(t,H,e),l(t,ee,e),M(F,t,e),l(t,se,e),l(t,S,e),l(t,le,e),M(P,t,e),l(t,ne,e),M(x,t,e),l(t,ae,e),l(t,q,e),l(t,oe,e),l(t,L,e),l(t,ie,e),l(t,D,e),l(t,re,e),M(K,t,e),l(t,ce,e),l(t,O,e),l(t,pe,e),l(t,tt,e),l(t,Me,e),M(et,t,e),l(t,de,e),M(st,t,e),l(t,ye,e),l(t,lt,e),l(t,me,e),M(nt,t,e),l(t,Je,e),M(at,t,e),l(t,Te,e),l(t,ot,e),l(t,we,e),M(it,t,e),l(t,je,e),l(t,rt,e),l(t,ue,e),l(t,ct,e),l(t,he,e),M(pt,t,e),l(t,Ue,e),M(Mt,t,e),l(t,be,e),l(t,dt,e),l(t,Ie,e),M(yt,t,e),l(t,fe,e),M(mt,t,e),l(t,ve,e),l(t,Jt,e),l(t,Ce,e),M(Tt,t,e),l(t,Be,e),l(t,wt,e),l(t,ge,e),M(jt,t,e),l(t,Ae,e),l(t,ut,e),l(t,Ze,e),M(ht,t,e),l(t,Ge,e),l(t,Ut,e),l(t,Re,e),l(t,bt,e),l(t,_e,e),l(t,It,e),l(t,Ne,e),M(ft,t,e),l(t,$e,e),l(t,Ct,e),Ve=!0},p:Us,i(t){Ve||(d(j.$$.fragment,t),d(f.$$.fragment,t),d(v.$$.fragment,t),d(A.$$.fragment,t),d(Z.$$.fragment,t),d(_.$$.fragment,t),d($.$$.fragment,t),d(X.$$.fragment,t),d(Q.$$.fragment,t),d(z.$$.fragment,t),d(F.$$.fragment,t),d(P.$$.fragment,t),d(x.$$.fragment,t),d(K.$$.fragment,t),d(et.$$.fragment,t),d(st.$$.fragment,t),d(nt.$$.fragment,t),d(at.$$.fragment,t),d(it.$$.fragment,t),d(pt.$$.fragment,t),d(Mt.$$.fragment,t),d(yt.$$.fragment,t),d(mt.$$.fragment,t),d(Tt.$$.fragment,t),d(jt.$$.fragment,t),d(ht.$$.fragment,t),d(ft.$$.fragment,t),Ve=!0)},o(t){y(j.$$.fragment,t),y(f.$$.fragment,t),y(v.$$.fragment,t),y(A.$$.fragment,t),y(Z.$$.fragment,t),y(_.$$.fragment,t),y($.$$.fragment,t),y(X.$$.fragment,t),y(Q.$$.fragment,t),y(z.$$.fragment,t),y(F.$$.fragment,t),y(P.$$.fragment,t),y(x.$$.fragment,t),y(K.$$.fragment,t),y(et.$$.fragment,t),y(st.$$.fragment,t),y(nt.$$.fragment,t),y(at.$$.fragment,t),y(it.$$.fragment,t),y(pt.$$.fragment,t),y(Mt.$$.fragment,t),y(yt.$$.fragment,t),y(mt.$$.fragment,t),y(Tt.$$.fragment,t),y(jt.$$.fragment,t),y(ht.$$.fragment,t),y(ft.$$.fragment,t),Ve=!1},d(t){t&&(s(Bt),s(vt),s(gt),s(At),s(u),s(Zt),s(h),s(Gt),s(U),s(Rt),s(b),s(_t),s(I),s(Nt),s($t),s(Vt),s(C),s(Et),s(B),s(Xt),s(g),s(Yt),s(Qt),s(zt),s(G),s(Wt),s(R),s(kt),s(Ht),s(N),s(Ft),s(St),s(V),s(Pt),s(E),s(xt),s(qt),s(Y),s(Lt),s(Dt),s(Kt),s(W),s(Ot),s(k),s(te),s(H),s(ee),s(se),s(S),s(le),s(ne),s(ae),s(q),s(oe),s(L),s(ie),s(D),s(re),s(ce),s(O),s(pe),s(tt),s(Me),s(de),s(ye),s(lt),s(me),s(Je),s(Te),s(ot),s(we),s(je),s(rt),s(ue),s(ct),s(he),s(Ue),s(be),s(dt),s(Ie),s(fe),s(ve),s(Jt),s(Ce),s(Be),s(wt),s(ge),s(Ae),s(ut),s(Ze),s(Ge),s(Ut),s(Re),s(bt),s(_e),s(It),s(Ne),s($e),s(Ct)),s(T),m(j,t),m(f,t),m(v,t),m(A,t),m(Z,t),m(_,t),m($,t),m(X,t),m(Q,t),m(z,t),m(F,t),m(P,t),m(x,t),m(K,t),m(et,t),m(st,t),m(nt,t),m(at,t),m(it,t),m(pt,t),m(Mt,t),m(yt,t),m(mt,t),m(Tt,t),m(jt,t),m(ht,t),m(ft,t)}}}const As='{"title":"Introduction to Processors","local":"introduction-to-processors","sections":[{"title":"What are Processors?","local":"what-are-processors","sections":[],"depth":2},{"title":"Core Concepts","local":"core-concepts","sections":[{"title":"EnvTransition: The Universal Data Container","local":"envtransition-the-universal-data-container","sections":[],"depth":3},{"title":"ProcessorStep: The Building Block","local":"processorstep-the-building-block","sections":[],"depth":3},{"title":"DataProcessorPipeline: The Generic Orchestrator","local":"dataprocessorpipeline-the-generic-orchestrator","sections":[],"depth":3}],"depth":2},{"title":"RobotProcessorPipeline vs PolicyProcessorPipeline","local":"robotprocessorpipeline-vs-policyprocessorpipeline","sections":[],"depth":2},{"title":"Converter Functions","local":"converter-functions","sections":[],"depth":2},{"title":"Processor Examples","local":"processor-examples","sections":[{"title":"An interaction between a robot and a policy with processors","local":"an-interaction-between-a-robot-and-a-policy-with-processors","sections":[],"depth":3}],"depth":2},{"title":"Feature Contracts: Shape and Type Transformation","local":"feature-contracts-shape-and-type-transformation","sections":[{"title":"Why Feature Contracts Matter","local":"why-feature-contracts-matter","sections":[],"depth":3},{"title":"Feature Specification Functions","local":"feature-specification-functions","sections":[],"depth":3}],"depth":2},{"title":"Common Processor Steps","local":"common-processor-steps","sections":[{"title":"Essential Processors","local":"essential-processors","sections":[],"depth":3},{"title":"Next Steps","local":"next-steps","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Zs(Ee){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends Is{constructor(T){super(),fs(this,T,Zs,gs,hs,{})}}export{$s as component};
