import{s as Ls,n as Fs,o as qs}from"../chunks/scheduler.3e37077e.js";import{S as Ps,i as Ks,g as i,s as n,r as p,A as Ds,h as o,f as s,c as a,j as Es,u as c,x as r,k as Ys,y as Os,a as l,v as M,d as m,t as d,w as y}from"../chunks/index.263272b0.js";import{C as T}from"../chunks/CodeBlock.76c31e3c.js";import{H as u,E as el}from"../chunks/getInferenceSnippets.932de0ac.js";function tl(Ot){let J,Re,Ne,He,w,ke,U,es=`In this tutorial, you’ll learn how to implement your own Robot Processor.
It begins by exploring the need for a custom processor, then uses the <code>NormalizerProcessorStep</code> as the running example to explain how to implement, configure, and serialize a processor. Finally, it lists all helper processors that ship with LeRobot.`,Ae,j,xe,h,ts="In most cases, when reading raw data from sensors or when models output actions, you need to process this data to make it compatible with your target system. For example, a common need is normalizing data ranges to make them suitable for neural networks.",Xe,f,ss="LeRobot’s <code>NormalizerProcessorStep</code> handles this crucial task:",We,I,Se,b,ls="Other common processing needs include:",Qe,C,ns="<li><strong>Device placement</strong>: Moving tensors between CPU/GPU and converting data types</li> <li><strong>Format conversion</strong>: Transforming between different data structures</li> <li><strong>Batching</strong>: Adding/removing batch dimensions for model compatibility</li> <li><strong>Safety constraints</strong>: Applying limits to robot commands</li>",Ve,g,Ee,v,as="LeRobot provides a pipeline mechanism to implement sequences of processing steps for both input data and output actions, making it easy to compose these transformations in the right order for optimal performance.",Ye,Z,Le,_,is="We’ll use the <code>NormalizerProcessorStep</code> as our main example because it demonstrates essential processor patterns including state management, configuration serialization, and tensor handling that you’ll commonly need.",Fe,z,os="Prepare the sequence of processing steps necessary for your problem. A processor step is a class that implements the following methods:",qe,B,rs="<li><code>__call__</code>: implements the processing step for the input transition.</li> <li><code>get_config</code>: gets the configuration of the processor step.</li> <li><code>state_dict</code>: gets the state of the processor step.</li> <li><code>load_state_dict</code>: loads the state of the processor step.</li> <li><code>reset</code>: resets the state of the processor step.</li> <li><code>feature_contract</code>: displays the modification to the feature space during the processor step.</li>",Pe,$,Ke,N,ps="The <code>__call__</code> method is the core of your processor step. It takes an <code>EnvTransition</code> and returns a modified <code>EnvTransition</code>. Here’s how the <code>NormalizerProcessorStep</code> works:",De,G,Oe,R,cs="See the full implementation in <code>src/lerobot/processor/normalize_processor.py</code> for complete details.",et,H,Ms="<strong>Key principles:</strong>",tt,k,ms="<li><strong>Always use <code>transition.copy()</code></strong> to avoid side effects</li> <li><strong>Handle both observations and actions</strong> consistently</li> <li><strong>Separate config from state</strong>: <code>get_config()</code> returns JSON-serializable params, <code>state_dict()</code> returns tensors</li> <li><strong>Convert stats to tensors</strong> in <code>__post_init__()</code> for efficient computation</li>",st,A,lt,x,ds="Processors support serialization through three methods that separate configuration from tensor state. The <code>NormalizerProcessorStep</code> demonstrates this perfectly - it carries dataset statistics (tensors) in its state, and hyperparameters in its config:",nt,X,at,W,ys="<strong>Usage:</strong>",it,S,ot,Q,rt,V,us="The <code>transform_features</code> method defines how your processor transforms feature names and shapes. This is crucial for policy configuration and debugging.",pt,E,Js="For <code>NormalizerProcessorStep</code>, features are typically preserved unchanged since normalization doesn’t alter keys or shapes:",ct,Y,Mt,L,Ts="When your processor renames or reshapes data, implement this method to reflect the mapping for downstream components. For example, a simple rename processor:",mt,F,dt,q,ws="<strong>Key principles:</strong>",yt,P,Us="<li>Use <code>features.pop(old_key)</code> to remove and get the old feature</li> <li>Use <code>features[new_key] = old_feature</code> to add the renamed feature</li> <li>Always return the modified features dictionary</li> <li>Document transformations clearly in the docstring</li>",ut,K,Jt,D,js="You can override step parameters at load-time using <code>overrides</code>. This is handy for non-serializable objects or site-specific settings. It works both in policy factories and with <code>DataProcessorPipeline.from_pretrained(...)</code>.",Tt,O,hs="<strong>Foundational model adaptation</strong>: This is particularly useful when working with foundational pretrained policies where you rarely have access to the original training statistics. You can inject your own dataset statistics to adapt the normalizer to your specific robot or environment data.",wt,ee,fs=`Example: during policy evaluation on the robot, override the device and rename map.
Use this to run a policy trained on CUDA on a CPU-only robot, or to remap camera keys when the robot uses different names than the dataset.`,Ut,te,Is="Direct usage with <code>from_pretrained</code>:",jt,se,ht,le,ft,ne,bs="Based on analysis of all LeRobot processor implementations, here are the key patterns and practices:",It,ae,bt,ie,Cs="Always create copies of input data to avoid unintended side effects. Use <code>transition.copy()</code> and <code>observation.copy()</code> rather than modifying data in-place. This prevents your processor from accidentally affecting other components in the pipeline.",Ct,oe,gs="Check for required data before processing and handle missing data gracefully. If your processor expects certain keys (like <code>&quot;pixels&quot;</code> for image processing), validate their presence first. For optional data, use safe access patterns like <code>transition.get()</code> and handle <code>None</code> values appropriately.",gt,re,vs="When data validation fails, provide clear, actionable error messages that help users understand what went wrong and how to fix it.",vt,pe,Zt,ce,Zs="LeRobot provides specialized base classes that reduce boilerplate code and ensure consistency. Use <code>ObservationProcessorStep</code> when you only need to modify observations, <code>ActionProcessorStep</code> for action-only processing, and <code>RobotActionProcessorStep</code> specifically for dictionary-based robot actions.",_t,Me,_s="Only inherit directly from <code>ProcessorStep</code> when you need full control over the entire transition or when processing multiple transition components simultaneously. The specialized base classes handle the transition management for you and provide type safety.",zt,me,Bt,de,zs="Register your processors with descriptive, namespaced names using <code>@ProcessorStepRegistry.register()</code>. Use organization prefixes like <code>&quot;robotics_lab/safety_clipper&quot;</code> or <code>&quot;acme_corp/vision_enhancer&quot;</code> to avoid naming conflicts. Avoid generic names like <code>&quot;processor&quot;</code> or <code>&quot;step&quot;</code> that could clash with other implementations.",$t,ye,Bs="Good registration makes your processors discoverable and enables clean serialization/deserialization when saving and loading pipelines.",Nt,ue,Gt,Je,$s="Distinguish between configuration parameters (JSON-serializable values) and internal state (tensors, buffers). Use dataclass fields with <code>init=False, repr=False</code> for internal state that shouldn’t appear in the constructor or string representation.",Rt,Te,Ns="Implement the <code>reset()</code> method to clear internal state between episodes. This is crucial for stateful processors that accumulate data over time, like moving averages or temporal filters.",Ht,we,Gs="Remember that <code>get_config()</code> should only return JSON-serializable configuration, while <code>state_dict()</code> handles tensor state separately.",kt,Ue,At,je,Rs="Validate input types and shapes before processing. Check tensor properties like <code>dtype</code> and dimensions to ensure compatibility with your algorithms. For robot actions, verify that required pose components or joint values are present and within expected ranges.",xt,he,Hs="Use early returns for edge cases where no processing is needed. Provide clear, descriptive error messages that include the expected vs. actual data types or shapes. This makes debugging much easier for users.",Xt,fe,Wt,Ie,ks="Design your processors to automatically adapt to the device and dtype of input tensors. Internal tensors (like normalization statistics) should match the input tensor’s device and dtype to ensure compatibility with multi-GPU training, mixed precision, and distributed setups.",St,be,As="Implement a <code>to()</code> method that moves your processor’s internal state to the specified device. Check device/dtype compatibility at runtime and automatically migrate internal state when needed. This pattern enables seamless operation across different hardware configurations without manual intervention.",Qt,Ce,Vt,ge,xs="You now have all the tools to implement custom processors in LeRobot! The key steps are:",Et,ve,Xs="<li><strong>Define your processor</strong> as a dataclass with the required methods (<code>__call__</code>, <code>get_config</code>, <code>state_dict</code>, <code>load_state_dict</code>, <code>reset</code>, <code>transform_features</code>)</li> <li><strong>Register it</strong> using <code>@ProcessorStepRegistry.register(&quot;name&quot;)</code> for discoverability</li> <li><strong>Integrate it</strong> into a <code>DataProcessorPipeline</code> with other processing steps</li> <li><strong>Use base classes</strong> like <code>ObservationProcessorStep</code> when possible to reduce boilerplate</li> <li><strong>Implement device/dtype awareness</strong> to support multi-GPU and mixed precision setups</li>",Yt,Ze,Ws="The processor system is designed to be modular and composable, allowing you to build complex data processing pipelines from simple, focused components. Whether you’re preprocessing sensor data for training or post-processing model outputs for robot execution, custom processors give you the flexibility to handle any data transformation your robotics application requires.",Lt,_e,Ss="Key principles for robust processors:",Ft,ze,Qs="<li><strong>Device/dtype adaptation</strong>: Internal tensors should match input tensors</li> <li><strong>Clear error messages</strong>: Help users understand what went wrong</li> <li><strong>Base class usage</strong>: Leverage specialized base classes to reduce boilerplate</li> <li><strong>Feature contracts</strong>: Declare data structure changes with <code>transform_features()</code></li>",qt,Be,Vs="Start simple, test thoroughly, and ensure your processors work seamlessly across different hardware configurations!",Pt,$e,Kt,Ge,Dt;return w=new u({props:{title:"Implement your own Robot Processor",local:"implement-your-own-robot-processor",headingTag:"h1"}}),j=new u({props:{title:"Why would you need a custom processor?",local:"why-would-you-need-a-custom-processor",headingTag:"h2"}}),I=new T({props:{code:"JTIzJTIwSW5wdXQlM0ElMjByYXclMjBqb2ludCUyMHBvc2l0aW9ucyUyMGluJTIwJTVCMCUyQyUyMDE4MCU1RCUyMGRlZ3JlZXMlMEFyYXdfYWN0aW9uJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjkwLjAlMkMlMjA0NS4wJTJDJTIwMTM1LjAlNUQpJTBBJTBBJTIzJTIwQWZ0ZXIlMjBwcm9jZXNzaW5nJTNBJTIwbm9ybWFsaXplZCUyMHRvJTIwJTVCLTElMkMlMjAxJTVEJTIwcmFuZ2UlMjBmb3IlMjBtb2RlbCUyMHRyYWluaW5nJTBBbm9ybWFsaXplciUyMCUzRCUyME5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKGZlYXR1cmVzJTNEZmVhdHVyZXMlMkMlMjBub3JtX21hcCUzRG5vcm1fbWFwJTJDJTIwc3RhdHMlM0RkYXRhc2V0X3N0YXRzKSUwQW5vcm1hbGl6ZWRfcmVzdWx0JTIwJTNEJTIwbm9ybWFsaXplcih0cmFuc2l0aW9uKSUwQSUyMyUyMC4uLg==",highlighted:`<span class="hljs-comment"># Input: raw joint positions in [0, 180] degrees</span>
raw_action = torch.tensor([<span class="hljs-number">90.0</span>, <span class="hljs-number">45.0</span>, <span class="hljs-number">135.0</span>])

<span class="hljs-comment"># After processing: normalized to [-1, 1] range for model training</span>
normalizer = NormalizerProcessorStep(features=features, norm_map=norm_map, stats=dataset_stats)
normalized_result = normalizer(transition)
<span class="hljs-comment"># ...</span>`,wrap:!1}}),g=new T({props:{code:"JTIzJTIwRXhhbXBsZSUyMHBpcGVsaW5lJTIwY29tYmluaW5nJTIwbXVsdGlwbGUlMjBwcm9jZXNzb3JzJTBBcGlwZWxpbmUlMjAlM0QlMjBQb2xpY3lQcm9jZXNzb3JQaXBlbGluZSglNUIlMEElMjAlMjAlMjAlMjBSZW5hbWVPYnNlcnZhdGlvbnNQcm9jZXNzb3JTdGVwKHJlbmFtZV9tYXAlM0QlN0IlN0QpJTJDJTBBJTIwJTIwJTIwJTIwQWRkQmF0Y2hEaW1lbnNpb25Qcm9jZXNzb3JTdGVwKCklMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemVyUHJvY2Vzc29yU3RlcChmZWF0dXJlcyUzRGZlYXR1cmVzJTJDJTIwc3RhdHMlM0RzdGF0cyklMkMlMEElMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTVEKQ==",highlighted:`<span class="hljs-comment"># Example pipeline combining multiple processors</span>
pipeline = PolicyProcessorPipeline([
    RenameObservationsProcessorStep(rename_map={}),
    AddBatchDimensionProcessorStep(),
    NormalizerProcessorStep(features=features, stats=stats),
    DeviceProcessorStep(device=<span class="hljs-string">&quot;cuda&quot;</span>),
    <span class="hljs-comment"># ...</span>
])`,wrap:!1}}),Z=new u({props:{title:"How to implement your own processor?",local:"how-to-implement-your-own-processor",headingTag:"h2"}}),$=new u({props:{title:"Implement the __call__ method",local:"implement-the-call-method",headingTag:"h3"}}),G=new T({props:{code:"JTQwZGF0YWNsYXNzJTBBJTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMm5vcm1hbGl6ZXJfcHJvY2Vzc29yJTIyKSUwQWNsYXNzJTIwTm9ybWFsaXplclByb2Nlc3NvclN0ZXAoUHJvY2Vzc29yU3RlcCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJOb3JtYWxpemUlMjBvYnNlcnZhdGlvbnMlMkZhY3Rpb25zJTIwdXNpbmclMjBkYXRhc2V0JTIwc3RhdGlzdGljcy4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBQb2xpY3lGZWF0dXJlJTVEJTBBJTIwJTIwJTIwJTIwbm9ybV9tYXAlM0ElMjBkaWN0JTVCRmVhdHVyZVR5cGUlMkMlMjBOb3JtYWxpemF0aW9uTW9kZSU1RCUwQSUyMCUyMCUyMCUyMHN0YXRzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQlMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGVwcyUzQSUyMGZsb2F0JTIwJTNEJTIwMWUtOCUwQSUyMCUyMCUyMCUyMF90ZW5zb3Jfc3RhdHMlM0ElMjBkaWN0JTIwJTNEJTIwZmllbGQoZGVmYXVsdF9mYWN0b3J5JTNEZGljdCUyQyUyMGluaXQlM0RGYWxzZSUyQyUyMHJlcHIlM0RGYWxzZSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX3Bvc3RfaW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29udmVydCUyMHN0YXRzJTIwdG8lMjB0ZW5zb3JzJTIwZm9yJTIwZWZmaWNpZW50JTIwY29tcHV0YXRpb24uJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zdGF0cyUyMCUzRCUyMHNlbGYuc3RhdHMlMjBvciUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX3RlbnNvcl9zdGF0cyUyMCUzRCUyMHRvX3RlbnNvcihzZWxmLnN0YXRzJTJDJTIwZGV2aWNlJTNEc2VsZi5kZXZpY2UlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MzIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X3RyYW5zaXRpb24lMjAlM0QlMjB0cmFuc2l0aW9uLmNvcHkoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMG9ic2VydmF0aW9ucyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG5ld190cmFuc2l0aW9uJTBB",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;normalizer_processor&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">NormalizerProcessorStep</span>(<span class="hljs-title class_ inherited__">ProcessorStep</span>):
    <span class="hljs-string">&quot;&quot;&quot;Normalize observations/actions using dataset statistics.&quot;&quot;&quot;</span>

    features: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]
    norm_map: <span class="hljs-built_in">dict</span>[FeatureType, NormalizationMode]
    stats: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>
    eps: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-8</span>
    _tensor_stats: <span class="hljs-built_in">dict</span> = field(default_factory=<span class="hljs-built_in">dict</span>, init=<span class="hljs-literal">False</span>, <span class="hljs-built_in">repr</span>=<span class="hljs-literal">False</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Convert stats to tensors for efficient computation.&quot;&quot;&quot;</span>
        self.stats = self.stats <span class="hljs-keyword">or</span> {}
        self._tensor_stats = to_tensor(self.stats, device=self.device, dtype=torch.float32)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        new_transition = transition.copy()
        <span class="hljs-comment"># Normalize observations</span>
        <span class="hljs-comment"># ...</span>
        <span class="hljs-comment"># Normalize action</span>
        <span class="hljs-comment"># ...</span>
        <span class="hljs-keyword">return</span> new_transition
`,wrap:!1}}),A=new u({props:{title:"Configuration and State Management",local:"configuration-and-state-management",headingTag:"h3"}}),X=new T({props:{code:"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",highlighted:`<span class="hljs-comment"># Continuing the NormalizerProcessorStep example...</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-string">&quot;&quot;&quot;JSON-serializable configuration (no tensors).&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;eps&quot;</span>: self.eps,
        <span class="hljs-string">&quot;features&quot;</span>: {k: {<span class="hljs-string">&quot;type&quot;</span>: v.<span class="hljs-built_in">type</span>.value, <span class="hljs-string">&quot;shape&quot;</span>: v.shape} <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> self.features.items()},
        <span class="hljs-string">&quot;norm_map&quot;</span>: {ft.value: nm.value <span class="hljs-keyword">for</span> ft, nm <span class="hljs-keyword">in</span> self.norm_map.items()},
        <span class="hljs-comment"># ...</span>
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
    <span class="hljs-string">&quot;&quot;&quot;Tensor state only (e.g., dataset statistics).&quot;&quot;&quot;</span>
    flat: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor] = {}
    <span class="hljs-keyword">for</span> key, sub <span class="hljs-keyword">in</span> self._tensor_stats.items():
        <span class="hljs-keyword">for</span> stat_name, tensor <span class="hljs-keyword">in</span> sub.items():
            flat[<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>.<span class="hljs-subst">{stat_name}</span>&quot;</span>] = tensor.cpu()  <span class="hljs-comment"># Always save to CPU</span>
    <span class="hljs-keyword">return</span> flat

<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Restore tensor state at runtime.&quot;&quot;&quot;</span>
    self._tensor_stats.clear()
    <span class="hljs-keyword">for</span> flat_key, tensor <span class="hljs-keyword">in</span> state.items():
        key, stat_name = flat_key.rsplit(<span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-number">1</span>)
        <span class="hljs-comment"># Load to processor&#x27;s configured device</span>
        self._tensor_stats.setdefault(key, {})[stat_name] = tensor.to(
            dtype=torch.float32, device=self.device
        )
        <span class="hljs-comment"># ...</span>`,wrap:!1}}),S=new T({props:{code:"JTIzJTIwU2F2ZSUyMChlLmcuJTJDJTIwaW5zaWRlJTIwYSUyMHBvbGljeSklMEFjb25maWclMjAlM0QlMjBub3JtYWxpemVyLmdldF9jb25maWcoKSUwQXRlbnNvcnMlMjAlM0QlMjBub3JtYWxpemVyLnN0YXRlX2RpY3QoKSUwQSUwQSUyMyUyMFJlc3RvcmUlMjAoZS5nLiUyQyUyMGxvYWRpbmclMjBhJTIwcHJldHJhaW5lZCUyMHBvbGljeSklMEFuZXdfbm9ybWFsaXplciUyMCUzRCUyME5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKCoqY29uZmlnKSUwQW5ld19ub3JtYWxpemVyLmxvYWRfc3RhdGVfZGljdCh0ZW5zb3JzKSUwQSUyMyUyME5vdyUyMG5ld19ub3JtYWxpemVyJTIwaGFzJTIwdGhlJTIwc2FtZSUyMHN0YXRzJTIwYW5kJTIwY29uZmlndXJhdGlvbg==",highlighted:`<span class="hljs-comment"># Save (e.g., inside a policy)</span>
config = normalizer.get_config()
tensors = normalizer.state_dict()

<span class="hljs-comment"># Restore (e.g., loading a pretrained policy)</span>
new_normalizer = NormalizerProcessorStep(**config)
new_normalizer.load_state_dict(tensors)
<span class="hljs-comment"># Now new_normalizer has the same stats and configuration</span>`,wrap:!1}}),Q=new u({props:{title:"Transform features",local:"transform-features",headingTag:"h3"}}),Y=new T({props:{code:"ZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQpJTIwLSUzRSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJOb3JtYWxpemF0aW9uJTIwcHJlc2VydmVzJTIwYWxsJTIwZmVhdHVyZSUyMGRlZmluaXRpb25zLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGZlYXR1cmVzJTIwJTIwJTIzJTIwTm8lMjBjaGFuZ2VzJTIwdG8lMjBmZWF0dXJlJTIwc3RydWN0dXJlJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features: <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]</span>) -&gt; <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]:
    <span class="hljs-string">&quot;&quot;&quot;Normalization preserves all feature definitions.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> features  <span class="hljs-comment"># No changes to feature structure</span>
    <span class="hljs-comment"># ...</span>`,wrap:!1}}),F=new T({props:{code:"ZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBQb2xpY3lGZWF0dXJlJTVEKSUyMC0lM0UlMjBkaWN0JTVCc3RyJTJDJTIwUG9saWN5RmVhdHVyZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNpbXBsZSUyMHJlbmFtaW5nJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJwaXhlbHMlMjIlMjBpbiUyMGZlYXR1cmVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUIlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiU1RCUyMCUzRCUyMGZlYXR1cmVzLnBvcCglMjJwaXhlbHMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGF0dGVybi1iYXNlZCUyMHJlbmFtaW5nJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTIwaW4lMjBsaXN0KGZlYXR1cmVzLmtleXMoKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGtleS5zdGFydHN3aXRoKCUyMmVudl9zdGF0ZS4lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VmZml4JTIwJTNEJTIwa2V5JTVCbGVuKCUyMmVudl9zdGF0ZS4lMjIpJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUJmJTIyb2JzZXJ2YXRpb24uJTdCc3VmZml4JTdEJTIyJTVEJTIwJTNEJTIwZmVhdHVyZXMucG9wKGtleSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]:
    <span class="hljs-comment"># Simple renaming</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pixels&quot;</span> <span class="hljs-keyword">in</span> features:
        features[<span class="hljs-string">&quot;observation.image&quot;</span>] = features.pop(<span class="hljs-string">&quot;pixels&quot;</span>)

    <span class="hljs-comment"># Pattern-based renaming</span>
    <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(features.keys()):
        <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;env_state.&quot;</span>):
            suffix = key[<span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;env_state.&quot;</span>):]
            features[<span class="hljs-string">f&quot;observation.<span class="hljs-subst">{suffix}</span>&quot;</span>] = features.pop(key)
            <span class="hljs-comment"># ...</span>

    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new u({props:{title:"Using overrides",local:"using-overrides",headingTag:"h3"}}),se=new T({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3JQaXBlbGluZSUwQSUwQSUyMyUyMExvYWQlMjBhJTIwZm91bmRhdGlvbmFsJTIwcG9saWN5JTIwdHJhaW5lZCUyMG9uJTIwZGl2ZXJzZSUyMHJvYm90JTIwZGF0YSUwQSUyMyUyMGJ1dCUyMGFkYXB0JTIwbm9ybWFsaXphdGlvbiUyMHRvJTIweW91ciUyMHNwZWNpZmljJTIwcm9ib3QlMkZlbnZpcm9ubWVudCUwQW5ld19zdGF0cyUyMCUzRCUyMExlUm9ib3REYXRhc2V0KHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWRhdGFzZXQlMjIpLm1ldGEuc3RhdHMlMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodWdnaW5nZmFjZSUyRmZvdW5kYXRpb25hbC1yb2JvdC1wb2xpY3klMjIlMkMlMjAlMjAlMjMlMjBQcmV0cmFpbmVkJTIwZm91bmRhdGlvbiUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybm9ybWFsaXplcl9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJzdGF0cyUyMiUzQSUyMG5ld19zdGF0cyU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMEluamVjdCUyMHlvdXIlMjByb2JvdCdzJTIwc3RhdGlzdGljcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZV9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTNBMCUyMiU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlZ2lzdHJ5JTIwbmFtZSUyMGZvciUyMHJlZ2lzdGVyZWQlMjBzdGVwcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlbmFtZV9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJyZW5hbWVfbWFwJTIyJTNBJTIwcm9ib3Rfa2V5X21hcCU3RCUyQyUyMCUyMyUyME1hcCUyMHlvdXIlMjByb2JvdCdzJTIwb2JzZXJ2YXRpb24lMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> RobotProcessorPipeline

<span class="hljs-comment"># Load a foundational policy trained on diverse robot data</span>
<span class="hljs-comment"># but adapt normalization to your specific robot/environment</span>
new_stats = LeRobotDataset(repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>).meta.stats
processor = RobotProcessorPipeline.from_pretrained(
    <span class="hljs-string">&quot;huggingface/foundational-robot-policy&quot;</span>,  <span class="hljs-comment"># Pretrained foundation model</span>
    overrides={
        <span class="hljs-string">&quot;normalizer_processor&quot;</span>: {<span class="hljs-string">&quot;stats&quot;</span>: new_stats},     <span class="hljs-comment"># Inject your robot&#x27;s statistics</span>
        <span class="hljs-string">&quot;device_processor&quot;</span>: {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda:0&quot;</span>},         <span class="hljs-comment"># registry name for registered steps</span>
        <span class="hljs-string">&quot;rename_processor&quot;</span>: {<span class="hljs-string">&quot;rename_map&quot;</span>: robot_key_map}, <span class="hljs-comment"># Map your robot&#x27;s observation keys</span>
        <span class="hljs-comment"># ...</span>
    },
)`,wrap:!1}}),le=new u({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),ae=new u({props:{title:"1. Safe Data Handling",local:"1-safe-data-handling",headingTag:"h3"}}),pe=new u({props:{title:"2. Choose Appropriate Base Classes",local:"2-choose-appropriate-base-classes",headingTag:"h3"}}),me=new u({props:{title:"3. Registration and Naming",local:"3-registration-and-naming",headingTag:"h3"}}),ue=new u({props:{title:"4. State Management Patterns",local:"4-state-management-patterns",headingTag:"h3"}}),Ue=new u({props:{title:"5. Input Validation and Error Handling",local:"5-input-validation-and-error-handling",headingTag:"h3"}}),fe=new u({props:{title:"6. Device and Dtype Awareness",local:"6-device-and-dtype-awareness",headingTag:"h3"}}),Ce=new u({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),$e=new el({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/implement_your_own_processor.mdx"}}),{c(){J=i("meta"),Re=n(),Ne=i("p"),He=n(),p(w.$$.fragment),ke=n(),U=i("p"),U.innerHTML=es,Ae=n(),p(j.$$.fragment),xe=n(),h=i("p"),h.textContent=ts,Xe=n(),f=i("p"),f.innerHTML=ss,We=n(),p(I.$$.fragment),Se=n(),b=i("p"),b.textContent=ls,Qe=n(),C=i("ul"),C.innerHTML=ns,Ve=n(),p(g.$$.fragment),Ee=n(),v=i("p"),v.textContent=as,Ye=n(),p(Z.$$.fragment),Le=n(),_=i("p"),_.innerHTML=is,Fe=n(),z=i("p"),z.textContent=os,qe=n(),B=i("ul"),B.innerHTML=rs,Pe=n(),p($.$$.fragment),Ke=n(),N=i("p"),N.innerHTML=ps,De=n(),p(G.$$.fragment),Oe=n(),R=i("p"),R.innerHTML=cs,et=n(),H=i("p"),H.innerHTML=Ms,tt=n(),k=i("ul"),k.innerHTML=ms,st=n(),p(A.$$.fragment),lt=n(),x=i("p"),x.innerHTML=ds,nt=n(),p(X.$$.fragment),at=n(),W=i("p"),W.innerHTML=ys,it=n(),p(S.$$.fragment),ot=n(),p(Q.$$.fragment),rt=n(),V=i("p"),V.innerHTML=us,pt=n(),E=i("p"),E.innerHTML=Js,ct=n(),p(Y.$$.fragment),Mt=n(),L=i("p"),L.textContent=Ts,mt=n(),p(F.$$.fragment),dt=n(),q=i("p"),q.innerHTML=ws,yt=n(),P=i("ul"),P.innerHTML=Us,ut=n(),p(K.$$.fragment),Jt=n(),D=i("p"),D.innerHTML=js,Tt=n(),O=i("p"),O.innerHTML=hs,wt=n(),ee=i("p"),ee.textContent=fs,Ut=n(),te=i("p"),te.innerHTML=Is,jt=n(),p(se.$$.fragment),ht=n(),p(le.$$.fragment),ft=n(),ne=i("p"),ne.textContent=bs,It=n(),p(ae.$$.fragment),bt=n(),ie=i("p"),ie.innerHTML=Cs,Ct=n(),oe=i("p"),oe.innerHTML=gs,gt=n(),re=i("p"),re.textContent=vs,vt=n(),p(pe.$$.fragment),Zt=n(),ce=i("p"),ce.innerHTML=Zs,_t=n(),Me=i("p"),Me.innerHTML=_s,zt=n(),p(me.$$.fragment),Bt=n(),de=i("p"),de.innerHTML=zs,$t=n(),ye=i("p"),ye.textContent=Bs,Nt=n(),p(ue.$$.fragment),Gt=n(),Je=i("p"),Je.innerHTML=$s,Rt=n(),Te=i("p"),Te.innerHTML=Ns,Ht=n(),we=i("p"),we.innerHTML=Gs,kt=n(),p(Ue.$$.fragment),At=n(),je=i("p"),je.innerHTML=Rs,xt=n(),he=i("p"),he.textContent=Hs,Xt=n(),p(fe.$$.fragment),Wt=n(),Ie=i("p"),Ie.textContent=ks,St=n(),be=i("p"),be.innerHTML=As,Qt=n(),p(Ce.$$.fragment),Vt=n(),ge=i("p"),ge.textContent=xs,Et=n(),ve=i("ol"),ve.innerHTML=Xs,Yt=n(),Ze=i("p"),Ze.textContent=Ws,Lt=n(),_e=i("p"),_e.textContent=Ss,Ft=n(),ze=i("ul"),ze.innerHTML=Qs,qt=n(),Be=i("p"),Be.textContent=Vs,Pt=n(),p($e.$$.fragment),Kt=n(),Ge=i("p"),this.h()},l(e){const t=Ds("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(s),Re=a(e),Ne=o(e,"P",{}),Es(Ne).forEach(s),He=a(e),c(w.$$.fragment,e),ke=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-f2ydop"&&(U.innerHTML=es),Ae=a(e),c(j.$$.fragment,e),xe=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-14012gf"&&(h.textContent=ts),Xe=a(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1pqilce"&&(f.innerHTML=ss),We=a(e),c(I.$$.fragment,e),Se=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-s4qb1l"&&(b.textContent=ls),Qe=a(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-j94eby"&&(C.innerHTML=ns),Ve=a(e),c(g.$$.fragment,e),Ee=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1vf7vne"&&(v.textContent=as),Ye=a(e),c(Z.$$.fragment,e),Le=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1qsxaj2"&&(_.innerHTML=is),Fe=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-119p6dx"&&(z.textContent=os),qe=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-3mrreh"&&(B.innerHTML=rs),Pe=a(e),c($.$$.fragment,e),Ke=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ata62c"&&(N.innerHTML=ps),De=a(e),c(G.$$.fragment,e),Oe=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-15o252k"&&(R.innerHTML=cs),et=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-3wif3z"&&(H.innerHTML=Ms),tt=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1mvgztx"&&(k.innerHTML=ms),st=a(e),c(A.$$.fragment,e),lt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-b2vh7o"&&(x.innerHTML=ds),nt=a(e),c(X.$$.fragment,e),at=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-qbjyqk"&&(W.innerHTML=ys),it=a(e),c(S.$$.fragment,e),ot=a(e),c(Q.$$.fragment,e),rt=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-zpl57h"&&(V.innerHTML=us),pt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1se5k3a"&&(E.innerHTML=Js),ct=a(e),c(Y.$$.fragment,e),Mt=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n4v86e"&&(L.textContent=Ts),mt=a(e),c(F.$$.fragment,e),dt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-3wif3z"&&(q.innerHTML=ws),yt=a(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-4cbkzr"&&(P.innerHTML=Us),ut=a(e),c(K.$$.fragment,e),Jt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1j2nqgx"&&(D.innerHTML=js),Tt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1q1vmke"&&(O.innerHTML=hs),wt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-4yxneh"&&(ee.textContent=fs),Ut=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1lufxqo"&&(te.innerHTML=Is),jt=a(e),c(se.$$.fragment,e),ht=a(e),c(le.$$.fragment,e),ft=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-a9gap8"&&(ne.textContent=bs),It=a(e),c(ae.$$.fragment,e),bt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-d8shql"&&(ie.innerHTML=Cs),Ct=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1tanh7n"&&(oe.innerHTML=gs),gt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-11gh8f3"&&(re.textContent=vs),vt=a(e),c(pe.$$.fragment,e),Zt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-ajlzxq"&&(ce.innerHTML=Zs),_t=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1de5ugl"&&(Me.innerHTML=_s),zt=a(e),c(me.$$.fragment,e),Bt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-14yccwa"&&(de.innerHTML=zs),$t=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1td2c4"&&(ye.textContent=Bs),Nt=a(e),c(ue.$$.fragment,e),Gt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1xtlp1l"&&(Je.innerHTML=$s),Rt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1o9ps7u"&&(Te.innerHTML=Ns),Ht=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11a1j3g"&&(we.innerHTML=Gs),kt=a(e),c(Ue.$$.fragment,e),At=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-gzrs9k"&&(je.innerHTML=Rs),xt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-d41fwr"&&(he.textContent=Hs),Xt=a(e),c(fe.$$.fragment,e),Wt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1kwzte0"&&(Ie.textContent=ks),St=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-14re3q4"&&(be.innerHTML=As),Qt=a(e),c(Ce.$$.fragment,e),Vt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-18m2ax2"&&(ge.textContent=xs),Et=a(e),ve=o(e,"OL",{"data-svelte-h":!0}),r(ve)!=="svelte-1b1ldni"&&(ve.innerHTML=Xs),Yt=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-w0jjpx"&&(Ze.textContent=Ws),Lt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-nopmtt"&&(_e.textContent=Ss),Ft=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1o9k3ro"&&(ze.innerHTML=Qs),qt=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-9erybv"&&(Be.textContent=Vs),Pt=a(e),c($e.$$.fragment,e),Kt=a(e),Ge=o(e,"P",{}),Es(Ge).forEach(s),this.h()},h(){Ys(J,"name","hf:doc:metadata"),Ys(J,"content",sl)},m(e,t){Os(document.head,J),l(e,Re,t),l(e,Ne,t),l(e,He,t),M(w,e,t),l(e,ke,t),l(e,U,t),l(e,Ae,t),M(j,e,t),l(e,xe,t),l(e,h,t),l(e,Xe,t),l(e,f,t),l(e,We,t),M(I,e,t),l(e,Se,t),l(e,b,t),l(e,Qe,t),l(e,C,t),l(e,Ve,t),M(g,e,t),l(e,Ee,t),l(e,v,t),l(e,Ye,t),M(Z,e,t),l(e,Le,t),l(e,_,t),l(e,Fe,t),l(e,z,t),l(e,qe,t),l(e,B,t),l(e,Pe,t),M($,e,t),l(e,Ke,t),l(e,N,t),l(e,De,t),M(G,e,t),l(e,Oe,t),l(e,R,t),l(e,et,t),l(e,H,t),l(e,tt,t),l(e,k,t),l(e,st,t),M(A,e,t),l(e,lt,t),l(e,x,t),l(e,nt,t),M(X,e,t),l(e,at,t),l(e,W,t),l(e,it,t),M(S,e,t),l(e,ot,t),M(Q,e,t),l(e,rt,t),l(e,V,t),l(e,pt,t),l(e,E,t),l(e,ct,t),M(Y,e,t),l(e,Mt,t),l(e,L,t),l(e,mt,t),M(F,e,t),l(e,dt,t),l(e,q,t),l(e,yt,t),l(e,P,t),l(e,ut,t),M(K,e,t),l(e,Jt,t),l(e,D,t),l(e,Tt,t),l(e,O,t),l(e,wt,t),l(e,ee,t),l(e,Ut,t),l(e,te,t),l(e,jt,t),M(se,e,t),l(e,ht,t),M(le,e,t),l(e,ft,t),l(e,ne,t),l(e,It,t),M(ae,e,t),l(e,bt,t),l(e,ie,t),l(e,Ct,t),l(e,oe,t),l(e,gt,t),l(e,re,t),l(e,vt,t),M(pe,e,t),l(e,Zt,t),l(e,ce,t),l(e,_t,t),l(e,Me,t),l(e,zt,t),M(me,e,t),l(e,Bt,t),l(e,de,t),l(e,$t,t),l(e,ye,t),l(e,Nt,t),M(ue,e,t),l(e,Gt,t),l(e,Je,t),l(e,Rt,t),l(e,Te,t),l(e,Ht,t),l(e,we,t),l(e,kt,t),M(Ue,e,t),l(e,At,t),l(e,je,t),l(e,xt,t),l(e,he,t),l(e,Xt,t),M(fe,e,t),l(e,Wt,t),l(e,Ie,t),l(e,St,t),l(e,be,t),l(e,Qt,t),M(Ce,e,t),l(e,Vt,t),l(e,ge,t),l(e,Et,t),l(e,ve,t),l(e,Yt,t),l(e,Ze,t),l(e,Lt,t),l(e,_e,t),l(e,Ft,t),l(e,ze,t),l(e,qt,t),l(e,Be,t),l(e,Pt,t),M($e,e,t),l(e,Kt,t),l(e,Ge,t),Dt=!0},p:Fs,i(e){Dt||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m($.$$.fragment,e),m(G.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(Ue.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m($e.$$.fragment,e),Dt=!0)},o(e){d(w.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(g.$$.fragment,e),d(Z.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(A.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(Ue.$$.fragment,e),d(fe.$$.fragment,e),d(Ce.$$.fragment,e),d($e.$$.fragment,e),Dt=!1},d(e){e&&(s(Re),s(Ne),s(He),s(ke),s(U),s(Ae),s(xe),s(h),s(Xe),s(f),s(We),s(Se),s(b),s(Qe),s(C),s(Ve),s(Ee),s(v),s(Ye),s(Le),s(_),s(Fe),s(z),s(qe),s(B),s(Pe),s(Ke),s(N),s(De),s(Oe),s(R),s(et),s(H),s(tt),s(k),s(st),s(lt),s(x),s(nt),s(at),s(W),s(it),s(ot),s(rt),s(V),s(pt),s(E),s(ct),s(Mt),s(L),s(mt),s(dt),s(q),s(yt),s(P),s(ut),s(Jt),s(D),s(Tt),s(O),s(wt),s(ee),s(Ut),s(te),s(jt),s(ht),s(ft),s(ne),s(It),s(bt),s(ie),s(Ct),s(oe),s(gt),s(re),s(vt),s(Zt),s(ce),s(_t),s(Me),s(zt),s(Bt),s(de),s($t),s(ye),s(Nt),s(Gt),s(Je),s(Rt),s(Te),s(Ht),s(we),s(kt),s(At),s(je),s(xt),s(he),s(Xt),s(Wt),s(Ie),s(St),s(be),s(Qt),s(Vt),s(ge),s(Et),s(ve),s(Yt),s(Ze),s(Lt),s(_e),s(Ft),s(ze),s(qt),s(Be),s(Pt),s(Kt),s(Ge)),s(J),y(w,e),y(j,e),y(I,e),y(g,e),y(Z,e),y($,e),y(G,e),y(A,e),y(X,e),y(S,e),y(Q,e),y(Y,e),y(F,e),y(K,e),y(se,e),y(le,e),y(ae,e),y(pe,e),y(me,e),y(ue,e),y(Ue,e),y(fe,e),y(Ce,e),y($e,e)}}}const sl='{"title":"Implement your own Robot Processor","local":"implement-your-own-robot-processor","sections":[{"title":"Why would you need a custom processor?","local":"why-would-you-need-a-custom-processor","sections":[],"depth":2},{"title":"How to implement your own processor?","local":"how-to-implement-your-own-processor","sections":[{"title":"Implement the __call__ method","local":"implement-the-call-method","sections":[],"depth":3},{"title":"Configuration and State Management","local":"configuration-and-state-management","sections":[],"depth":3},{"title":"Transform features","local":"transform-features","sections":[],"depth":3},{"title":"Using overrides","local":"using-overrides","sections":[],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[{"title":"1. Safe Data Handling","local":"1-safe-data-handling","sections":[],"depth":3},{"title":"2. Choose Appropriate Base Classes","local":"2-choose-appropriate-base-classes","sections":[],"depth":3},{"title":"3. Registration and Naming","local":"3-registration-and-naming","sections":[],"depth":3},{"title":"4. State Management Patterns","local":"4-state-management-patterns","sections":[],"depth":3},{"title":"5. Input Validation and Error Handling","local":"5-input-validation-and-error-handling","sections":[],"depth":3},{"title":"6. Device and Dtype Awareness","local":"6-device-and-dtype-awareness","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ll(Ot){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends Ps{constructor(J){super(),Ks(this,J,ll,tl,Ls,{})}}export{rl as component};
