import{s as MM,n as aM,o as nM}from"../chunks/scheduler.362310b7.js";import{S as eM,i as jM,g as e,s as a,r as y,m as zl,A as oM,h as j,f as t,c as n,j as I,u as T,x as J,n as Rl,k as tM,y as o,a as M,v as p,d as i,t as U,w as u}from"../chunks/index.57dfc70d.js";import{C as A}from"../chunks/CodeBlock.d3c47f83.js";import{H as c,E as JM}from"../chunks/EditOnGithub.9633c464.js";function yM(mt){let r,Fl,_l,Dl,d,Ll,q,dt='Text Generation Inference (TGI) now supports <a href="#grammar-and-constraints">JSON and regex grammars</a> and <a href="#tools-and-functions">tools and functions</a> to help developers guide LLM responses to fit their needs.',Pl,g,qt='These feature are available starting from version <code>1.4.3</code>. They are accessible via the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The tool support is compatible with OpenAI’s client libraries. The following guide will walk you through the new features and how to use them!',Ol,b,gt="<em>note: guidance is supported as grammar in the <code>/generate</code> endpoint and as tools in the <code>v1/chat/completions</code> endpoint.</em>",Kl,f,ls,E,bt='TGI leverages the <a href="https://github.com/outlines-dev/outlines" rel="nofollow">outlines</a> library to efficiently parse and compile the grammatical structures and tools specified by users. This integration transforms the defined grammars into an intermediate representation that acts as a framework to guide and constrain content generation, ensuring that outputs adhere to the specified grammatical rules.',ss,B,ft='If you are interested in the technical details on how outlines is used in TGI, you can check out the <a href="../conceptual/guidance">conceptual guidance documentation</a>.',ts,Q,Ms,N,as,Z,Et='<li><a href="#the-grammar-parameter">The Grammar Parameter</a>: Shape your AI’s responses with precision.</li> <li><a href="#constrain-with-pydantic">Constrain with Pydantic</a>: Define a grammar using Pydantic models.</li> <li><a href="#json-schema-integration">JSON Schema Integration</a>: Fine-grained control over your requests via JSON schema.</li> <li><a href="#using-the-client">Using the client</a>: Use TGI’s client libraries to shape the AI’s responses.</li>',ns,G,es,W,Bt='<li><a href="#the-tools-parameter">The Tools Parameter</a>: Enhance the AI’s capabilities with predefined functions.</li> <li><a href="#text-generation-inference-client">Via the client</a>: Use TGI’s client libraries to interact with the Messages API and Tool functions.</li> <li><a href="#openai-integration">OpenAI integration</a>: Use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.</li>',js,S,os,v,Js,$,Qt="In TGI <code>1.4.3</code>, we’ve introduced the grammar parameter, which allows you to specify the format of the response you want from the LLM.",ys,k,Nt='Using curl, you can make a request to TGI’s Messages API with the grammar parameter. This is the most primitive way to interact with the API and using <a href="#constrain-with-pydantic">Pydantic</a> is recommended for ease of use and readability.',Ts,x,ps,X,is,Y,Zt="The Hugging Face Hub Python library provides a client that makes it easy to interact with the Messages API. Here’s an example of how to use the client to send a request with a grammar parameter.",Us,V,us,z,Gt="A grammar can be defined using Pydantic models, JSON schemas, or regular expressions. The LLM will then generate a response that conforms to the specified grammar.",Is,R,Wt="<p>Note: A grammar must compile to an intermediate representation to constrain the output. Grammar compilation is a computationally expensive and may take a few seconds to complete on the first request. Subsequent requests will use the cached grammar and will be much faster.</p>",cs,_,ws,H,St="Using Pydantic models we can define a similar grammar as the previous example in a shorter and more readable way.",As,F,rs,D,vt="defining a grammar as regular expressions",hs,L,Cs,P,ms,O,ds,K,$t="In addition to the grammar parameter, we’ve also introduced a set of tools and functions to help you get the most out of the Messages API.",qs,ll,kt="Tools are a set of user defined functions that can be used in tandem with the chat functionality to enhance the LLM’s capabilities. Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",gs,sl,xt="Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",bs,tl,fs,Ml,Es,al,Xt="Grammars are supported in the <code>/generate</code> endpoint, while tools are supported in the <code>/chat/completions</code> endpoint. Here’s an example of how to use the client to send a request with a tool parameter.",Bs,nl,Qs,el,Ns,jl,Yt="TGI exposes an OpenAI-compatible API, which means you can use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.",Zs,ol,Gs,Jl,Ws,yl,Vt="When configuring how the model interacts with tools during a chat completion, there are several options for determining if or how a tool should be called. These options are controlled by the <code>tool_choice</code> parameter, which specifies the behavior of the model in relation to tool usage. The following modes are supported:",Ss,w,Tl,gl,zt="<strong><code>auto</code></strong>:",Ps,h,bl,Rt="The model decides whether to call a tool or generate a response message based on the user’s input.",Os,fl,_t="If tools are provided, this is the default mode.",Ks,El,lt,pl,st,il,Bl,Ht="<strong><code>none</code></strong>:",tt,C,Ql,Ft="The model will never call any tools and will only generate a response message.",Mt,Nl,Dt="If no tools are provided, this is the default mode.",at,Zl,nt,Ul,et,ul,Gl,Lt="<strong><code>required</code></strong>:",jt,Il,Wl,Pt="The model must call one or more tools and will not generate a response message on its own.",ot,Sl,Jt,cl,yt,wl,vl,Ot="<strong>Specific Tool Call by Function Name</strong>:",Tt,Al,$l,Kt="You can force the model to call a specific tool either by specifying the tool function directly or by using an object definition.",pt,kl,it,rl,xl,Ut,hl,ut,Xl,It,Cl,vs,ml,lM="These options allow flexibility when integrating tools with the chat completions endpoint. You can configure the model to either rely on tools automatically or force it to follow a predefined behavior, based on the needs of the task at hand.",$s,ks,xs,dl,sM="<thead><tr><th><strong>Tool Choice Option</strong></th> <th><strong>Description</strong></th> <th><strong>When to Use</strong></th></tr></thead> <tbody><tr><td><code>auto</code></td> <td>The model decides whether to call a tool or generate a message. This is the default if tools are provided.</td> <td>Use when you want the model to decide when a tool is necessary.</td></tr> <tr><td><code>none</code></td> <td>The model generates a message without calling any tools. This is the default if no tools are provided.</td> <td>Use when you do not want the model to call any tools.</td></tr> <tr><td><code>required</code></td> <td>The model must call one or more tools and will not generate a message on its own.</td> <td>Use when a tool call is mandatory, and you do not want a regular message generated.</td></tr> <tr><td>Specific Tool Call (<code>name</code> or object)</td> <td>Force the model to call a specific tool either by specifying its name (<code>tool_choice=&quot;get_current_weather&quot;</code>) or using an object.</td> <td>Use when you want to restrict the model to calling a particular tool for the response.</td></tr></tbody>",Xs,ql,Ys,Hl,Vs;return d=new c({props:{title:"Guidance",local:"guidance",headingTag:"h1"}}),f=new c({props:{title:"How it works",local:"how-it-works",headingTag:"h2"}}),Q=new c({props:{title:"Table of Contents 📚",local:"table-of-contents-",headingTag:"h2"}}),N=new c({props:{title:"Grammar and Constraints",local:"grammar-and-constraints",headingTag:"h3"}}),G=new c({props:{title:"Tools and Functions",local:"tools-and-functions",headingTag:"h3"}}),S=new c({props:{title:"Grammar and Constraints 🛣️",local:"grammar-and-constraints-",headingTag:"h2"}}),v=new c({props:{title:"The Grammar Parameter",local:"the-grammar-parameter",headingTag:"h3"}}),x=new A({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/generate \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;json&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;value&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;integer&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;minimum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;maximum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;array&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;items&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span>
                <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;activity&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals_seen&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;generated_text&quot;:&quot;{ \\n\\n\\&quot;activity\\&quot;: \\&quot;biking\\&quot;,\\n\\&quot;animals\\&quot;: [\\&quot;puppy\\&quot;,\\&quot;cat\\&quot;,\\&quot;raccoon\\&quot;],\\n\\&quot;animals_seen\\&quot;: 3,\\n\\&quot;location\\&quot;: \\&quot;park\\&quot;\\n}&quot;}</span>
`,wrap:!1}}),X=new c({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),V=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

schema = {
    <span class="hljs-string">&quot;properties&quot;</span>: {
        <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Location&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Activity&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;animals_seen&quot;</span>: {
            <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>,
            <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals Seen&quot;</span>,
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
        },
        <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}, <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>},
    },
    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>,
    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
}

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{schema}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: schema},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>
`,wrap:!1}}),_=new c({props:{title:"Constrain with Pydantic",local:"constrain-with-pydantic",headingTag:"h3"}}),F=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbCUyQyUyMGNvbmludCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBMaXN0JTBBJTBBJTBBY2xhc3MlMjBBbmltYWxzKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGFjdGl2aXR5JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYW5pbWFsc19zZWVuJTNBJTIwY29uaW50KGdlJTNEMSUyQyUyMGxlJTNENSklMjAlMjAlMjMlMjBDb25zdHJhaW5lZCUyMGludGVnZXIlMjB0eXBlJTBBJTIwJTIwJTIwJTIwYW5pbWFscyUzQSUyMExpc3QlNUJzdHIlNUQlMEElMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBdXNlcl9pbnB1dCUyMCUzRCUyMCUyMkklMjBzYXclMjBhJTIwcHVwcHklMjBhJTIwY2F0JTIwYW5kJTIwYSUyMHJhY2Nvb24lMjBkdXJpbmclMjBteSUyMGJpa2UlMjByaWRlJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBcmVzcCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwZiUyMmNvbnZlcnQlMjB0byUyMEpTT04lM0ElMjAnZiU3QnVzZXJfaW5wdXQlN0QnLiUyMHBsZWFzZSUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHNjaGVtYSUzQSUyMCU3QkFuaW1hbHMuc2NoZW1hKCklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyanNvbiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNBJTIwQW5pbWFscy5zY2hlbWEoKSU3RCUyQyUwQSklMEElMEFwcmludChyZXNwKSUwQSUyMyUyMCU3QiUyMCUyMmFjdGl2aXR5JTIyJTNBJTIwJTIyYmlrZSUyMHJpZGUlMjIlMkMlMjAlMjJhbmltYWxzJTIyJTNBJTIwJTVCJTIycHVwcHklMjIlMkMlMjAlMjJjYXQlMjIlMkMlMjAlMjJyYWNjb29uJTIyJTVEJTJDJTIwJTIyYW5pbWFsc19zZWVuJTIyJTNBJTIwMyUyQyUyMCUyMmxvY2F0aW9uJTIyJTNBJTIwJTIycGFyayUyMiUyMCU3RCUwQSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, conint
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Animals</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span>
    activity: <span class="hljs-built_in">str</span>
    animals_seen: conint(ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)  <span class="hljs-comment"># Constrained integer type</span>
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]


client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{Animals.schema()}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: Animals.schema()},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>

`,wrap:!1}}),L=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyMiklMEElMEFzZWN0aW9uX3JlZ2V4JTIwJTNEJTIwJTIyKCUzRiUzQTI1JTVCMC01JTVEJTdDMiU1QjAtNCU1RCU1QjAtOSU1RCU3QyU1QjAxJTVEJTNGJTVCMC05JTVEJTVCMC05JTVEJTNGKSUyMiUwQXJlZ2V4cCUyMCUzRCUyMGYlMjJIRUxMTyU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLldPUkxEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlMjIlMEElMEElMjMlMjBUaGlzJTIwaXMlMjBhJTIwbW9yZSUyMHJlYWxpc3RpYyUyMGV4YW1wbGUlMjBvZiUyMGFuJTIwaXAlMjBhZGRyZXNzJTIwcmVnZXglMEElMjMlMjByZWdleHAlMjAlM0QlMjBmJTIyJTdCc2VjdGlvbl9yZWdleCU3RCU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlNUMuJTdCc2VjdGlvbl9yZWdleCU3RCUyMiUwQSUwQSUwQXJlc3AlMjAlM0QlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMGYlMjJXaGF0cyUyMEdvb2dsZXMlMjBETlMlM0YlMjBQbGVhc2UlMjB1c2UlMjB0aGUlMjBmb2xsb3dpbmclMjByZWdleCUzQSUyMCU3QnJlZ2V4cCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIycmVnZXglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMHJlZ2V4cCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEElMEFwcmludChyZXNwKSUwQSUyMyUyMEhFTExPLjI1NS5XT1JMRC4yNTUlMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

section_regex = <span class="hljs-string">&quot;(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)&quot;</span>
regexp = <span class="hljs-string">f&quot;HELLO\\.<span class="hljs-subst">{section_regex}</span>\\.WORLD\\.<span class="hljs-subst">{section_regex}</span>&quot;</span>

<span class="hljs-comment"># This is a more realistic example of an ip address regex</span>
<span class="hljs-comment"># regexp = f&quot;{section_regex}\\.{section_regex}\\.{section_regex}\\.{section_regex}&quot;</span>


resp = client.text_generation(
    <span class="hljs-string">f&quot;Whats Googles DNS? Please use the following regex: <span class="hljs-subst">{regexp}</span>&quot;</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;regex&quot;</span>,
        <span class="hljs-string">&quot;value&quot;</span>: regexp,
    },
)


<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># HELLO.255.WORLD.255</span>
`,wrap:!1}}),P=new c({props:{title:"Tools and Functions 🛠️",local:"tools-and-functions-",headingTag:"h2"}}),O=new c({props:{title:"The Tools Parameter",local:"the-tools-parameter",headingTag:"h3"}}),tl=new A({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/v1/chat/completions \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tgi&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tools&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Get the current weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;format&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;enum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;celsius&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;fahrenheit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;format&quot;</span><span class="hljs-punctuation">]</span>
                <span class="hljs-punctuation">}</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tool_choice&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051640,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:19,&quot;total_tokens&quot;:176}}</span>`,wrap:!1}}),Ml=new c({props:{title:"Chat Completion with Tools",local:"chat-completion-with-tools",headingTag:"h3"}}),nl=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
            },
        },
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                    <span class="hljs-string">&quot;num_days&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
            },
        },
    },
]

chat = client.chat_completion(
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You&#x27;re a helpful assistant! Answer the users question best you can.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in Brooklyn, New York?&quot;</span>,
        },
    ],
    tools=tools,
    seed=<span class="hljs-number">42</span>,
    max_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(chat.choices[<span class="hljs-number">0</span>].message.tool_calls)
<span class="hljs-comment"># [ChatCompletionOutputToolCall(function=ChatCompletionOutputFunctionDefinition(arguments={&#x27;format&#x27;: &#x27;fahrenheit&#x27;, &#x27;location&#x27;: &#x27;Brooklyn, New York&#x27;, &#x27;num_days&#x27;: 7}, name=&#x27;get_n_day_weather_forecast&#x27;, description=None), id=0, type=&#x27;function&#x27;)]</span>
`,wrap:!1}}),el=new c({props:{title:"OpenAI integration",local:"openai-integration",headingTag:"h3"}}),ol=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the client, pointing it to one of the available models</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;_&quot;</span>,
)

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
        },
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># tool selected by model</span>
    max_tokens=<span class="hljs-number">500</span>,
)


called = chat_completion.choices[<span class="hljs-number">0</span>].message.tool_calls
<span class="hljs-built_in">print</span>(called)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &quot;id&quot;: 0,</span>
<span class="hljs-comment">#     &quot;type&quot;: &quot;function&quot;,</span>
<span class="hljs-comment">#     &quot;function&quot;: {</span>
<span class="hljs-comment">#         &quot;description&quot;: None,</span>
<span class="hljs-comment">#         &quot;name&quot;: &quot;tools&quot;,</span>
<span class="hljs-comment">#         &quot;parameters&quot;: {</span>
<span class="hljs-comment">#             &quot;format&quot;: &quot;celsius&quot;,</span>
<span class="hljs-comment">#             &quot;location&quot;: &quot;San Francisco, CA&quot;,</span>
<span class="hljs-comment">#             &quot;num_days&quot;: 3,</span>
<span class="hljs-comment">#         },</span>
<span class="hljs-comment">#     },</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),Jl=new c({props:{title:"Tool Choice Configuration",local:"tool-choice-configuration",headingTag:"h3"}}),pl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJhdXRvJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;auto&quot;</span>',wrap:!1}}),Ul=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJub25lJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;none&quot;</span>',wrap:!1}}),cl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJyZXF1aXJlZCUyMg==",highlighted:'tool_choice=<span class="hljs-string">&quot;required&quot;</span>',wrap:!1}}),hl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;get_current_weather&quot;</span>',wrap:!1}}),Cl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlN0IlMEElMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIyJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`tool_choice={
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
  <span class="hljs-string">&quot;function&quot;</span>: {
      <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>
  }
}`,wrap:!1}}),ql=new JM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/using_guidance.md"}}),{c(){r=e("meta"),Fl=a(),_l=e("p"),Dl=a(),y(d.$$.fragment),Ll=a(),q=e("p"),q.innerHTML=dt,Pl=a(),g=e("p"),g.innerHTML=qt,Ol=a(),b=e("p"),b.innerHTML=gt,Kl=a(),y(f.$$.fragment),ls=a(),E=e("p"),E.innerHTML=bt,ss=a(),B=e("p"),B.innerHTML=ft,ts=a(),y(Q.$$.fragment),Ms=a(),y(N.$$.fragment),as=a(),Z=e("ul"),Z.innerHTML=Et,ns=a(),y(G.$$.fragment),es=a(),W=e("ul"),W.innerHTML=Bt,js=a(),y(S.$$.fragment),os=a(),y(v.$$.fragment),Js=a(),$=e("p"),$.innerHTML=Qt,ys=a(),k=e("p"),k.innerHTML=Nt,Ts=a(),y(x.$$.fragment),ps=a(),y(X.$$.fragment),is=a(),Y=e("p"),Y.textContent=Zt,Us=a(),y(V.$$.fragment),us=a(),z=e("p"),z.textContent=Gt,Is=a(),R=e("blockquote"),R.innerHTML=Wt,cs=a(),y(_.$$.fragment),ws=a(),H=e("p"),H.textContent=St,As=a(),y(F.$$.fragment),rs=a(),D=e("p"),D.textContent=vt,hs=a(),y(L.$$.fragment),Cs=a(),y(P.$$.fragment),ms=a(),y(O.$$.fragment),ds=a(),K=e("p"),K.textContent=$t,qs=a(),ll=e("p"),ll.textContent=kt,gs=a(),sl=e("p"),sl.textContent=xt,bs=a(),y(tl.$$.fragment),fs=a(),y(Ml.$$.fragment),Es=a(),al=e("p"),al.innerHTML=Xt,Bs=a(),y(nl.$$.fragment),Qs=a(),y(el.$$.fragment),Ns=a(),jl=e("p"),jl.textContent=Yt,Zs=a(),y(ol.$$.fragment),Gs=a(),y(Jl.$$.fragment),Ws=a(),yl=e("p"),yl.innerHTML=Vt,Ss=a(),w=e("ol"),Tl=e("li"),gl=e("p"),gl.innerHTML=zt,Ps=a(),h=e("ul"),bl=e("li"),bl.textContent=Rt,Os=a(),fl=e("li"),fl.textContent=_t,Ks=a(),El=e("li"),lt=zl(`Example usage:
	`),y(pl.$$.fragment),st=a(),il=e("li"),Bl=e("p"),Bl.innerHTML=Ht,tt=a(),C=e("ul"),Ql=e("li"),Ql.textContent=Ft,Mt=a(),Nl=e("li"),Nl.textContent=Dt,at=a(),Zl=e("li"),nt=zl(`Example usage:
	`),y(Ul.$$.fragment),et=a(),ul=e("li"),Gl=e("p"),Gl.innerHTML=Lt,jt=a(),Il=e("ul"),Wl=e("li"),Wl.textContent=Pt,ot=a(),Sl=e("li"),Jt=zl(`Example usage:
	`),y(cl.$$.fragment),yt=a(),wl=e("li"),vl=e("p"),vl.innerHTML=Ot,Tt=a(),Al=e("ul"),$l=e("li"),$l.textContent=Kt,pt=a(),kl=e("li"),it=zl("Two ways to do this:"),rl=e("ol"),xl=e("li"),Ut=zl(`Provide the function name as a string:
	`),y(hl.$$.fragment),ut=a(),Xl=e("li"),It=zl(`Use the function object format:
	`),y(Cl.$$.fragment),vs=a(),ml=e("p"),ml.textContent=lM,$s=a(),ks=e("hr"),xs=a(),dl=e("table"),dl.innerHTML=sM,Xs=a(),y(ql.$$.fragment),Ys=a(),Hl=e("p"),this.h()},l(l){const s=oM("svelte-u9bgzb",document.head);r=j(s,"META",{name:!0,content:!0}),s.forEach(t),Fl=n(l),_l=j(l,"P",{}),I(_l).forEach(t),Dl=n(l),T(d.$$.fragment,l),Ll=n(l),q=j(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-kbjeep"&&(q.innerHTML=dt),Pl=n(l),g=j(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-fq1iv3"&&(g.innerHTML=qt),Ol=n(l),b=j(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-bfgv2a"&&(b.innerHTML=gt),Kl=n(l),T(f.$$.fragment,l),ls=n(l),E=j(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-wsp0l4"&&(E.innerHTML=bt),ss=n(l),B=j(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-15m2t7v"&&(B.innerHTML=ft),ts=n(l),T(Q.$$.fragment,l),Ms=n(l),T(N.$$.fragment,l),as=n(l),Z=j(l,"UL",{"data-svelte-h":!0}),J(Z)!=="svelte-12576sd"&&(Z.innerHTML=Et),ns=n(l),T(G.$$.fragment,l),es=n(l),W=j(l,"UL",{"data-svelte-h":!0}),J(W)!=="svelte-18ofpvb"&&(W.innerHTML=Bt),js=n(l),T(S.$$.fragment,l),os=n(l),T(v.$$.fragment,l),Js=n(l),$=j(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-yoqu28"&&($.innerHTML=Qt),ys=n(l),k=j(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1vsv0tm"&&(k.innerHTML=Nt),Ts=n(l),T(x.$$.fragment,l),ps=n(l),T(X.$$.fragment,l),is=n(l),Y=j(l,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-126mt2g"&&(Y.textContent=Zt),Us=n(l),T(V.$$.fragment,l),us=n(l),z=j(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1nlfjb7"&&(z.textContent=Gt),Is=n(l),R=j(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(R)!=="svelte-cm9i0i"&&(R.innerHTML=Wt),cs=n(l),T(_.$$.fragment,l),ws=n(l),H=j(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-3pxjtu"&&(H.textContent=St),As=n(l),T(F.$$.fragment,l),rs=n(l),D=j(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-6wpj0x"&&(D.textContent=vt),hs=n(l),T(L.$$.fragment,l),Cs=n(l),T(P.$$.fragment,l),ms=n(l),T(O.$$.fragment,l),ds=n(l),K=j(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-lut42n"&&(K.textContent=$t),qs=n(l),ll=j(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-1a560wn"&&(ll.textContent=kt),gs=n(l),sl=j(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1yk642r"&&(sl.textContent=xt),bs=n(l),T(tl.$$.fragment,l),fs=n(l),T(Ml.$$.fragment,l),Es=n(l),al=j(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-13xxzo"&&(al.innerHTML=Xt),Bs=n(l),T(nl.$$.fragment,l),Qs=n(l),T(el.$$.fragment,l),Ns=n(l),jl=j(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-qj1me9"&&(jl.textContent=Yt),Zs=n(l),T(ol.$$.fragment,l),Gs=n(l),T(Jl.$$.fragment,l),Ws=n(l),yl=j(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-13rggpe"&&(yl.innerHTML=Vt),Ss=n(l),w=j(l,"OL",{});var m=I(w);Tl=j(m,"LI",{});var zs=I(Tl);gl=j(zs,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-xbr04b"&&(gl.innerHTML=zt),Ps=n(zs),h=j(zs,"UL",{});var Yl=I(h);bl=j(Yl,"LI",{"data-svelte-h":!0}),J(bl)!=="svelte-kqytsb"&&(bl.textContent=Rt),Os=n(Yl),fl=j(Yl,"LI",{"data-svelte-h":!0}),J(fl)!=="svelte-1jg6yx2"&&(fl.textContent=_t),Ks=n(Yl),El=j(Yl,"LI",{});var ct=I(El);lt=Rl(ct,`Example usage:
	`),T(pl.$$.fragment,ct),ct.forEach(t),Yl.forEach(t),zs.forEach(t),st=n(m),il=j(m,"LI",{});var Rs=I(il);Bl=j(Rs,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-11bn5m0"&&(Bl.innerHTML=Ht),tt=n(Rs),C=j(Rs,"UL",{});var Vl=I(C);Ql=j(Vl,"LI",{"data-svelte-h":!0}),J(Ql)!=="svelte-klffq4"&&(Ql.textContent=Ft),Mt=n(Vl),Nl=j(Vl,"LI",{"data-svelte-h":!0}),J(Nl)!=="svelte-up128b"&&(Nl.textContent=Dt),at=n(Vl),Zl=j(Vl,"LI",{});var wt=I(Zl);nt=Rl(wt,`Example usage:
	`),T(Ul.$$.fragment,wt),wt.forEach(t),Vl.forEach(t),Rs.forEach(t),et=n(m),ul=j(m,"LI",{});var _s=I(ul);Gl=j(_s,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1u693el"&&(Gl.innerHTML=Lt),jt=n(_s),Il=j(_s,"UL",{});var Hs=I(Il);Wl=j(Hs,"LI",{"data-svelte-h":!0}),J(Wl)!=="svelte-9fo4bt"&&(Wl.textContent=Pt),ot=n(Hs),Sl=j(Hs,"LI",{});var At=I(Sl);Jt=Rl(At,`Example usage:
	`),T(cl.$$.fragment,At),At.forEach(t),Hs.forEach(t),_s.forEach(t),yt=n(m),wl=j(m,"LI",{});var Fs=I(wl);vl=j(Fs,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-gefj73"&&(vl.innerHTML=Ot),Tt=n(Fs),Al=j(Fs,"UL",{});var Ds=I(Al);$l=j(Ds,"LI",{"data-svelte-h":!0}),J($l)!=="svelte-1o336wz"&&($l.textContent=Kt),pt=n(Ds),kl=j(Ds,"LI",{});var rt=I(kl);it=Rl(rt,"Two ways to do this:"),rl=j(rt,"OL",{});var Ls=I(rl);xl=j(Ls,"LI",{});var ht=I(xl);Ut=Rl(ht,`Provide the function name as a string:
	`),T(hl.$$.fragment,ht),ht.forEach(t),ut=n(Ls),Xl=j(Ls,"LI",{});var Ct=I(Xl);It=Rl(Ct,`Use the function object format:
	`),T(Cl.$$.fragment,Ct),Ct.forEach(t),Ls.forEach(t),rt.forEach(t),Ds.forEach(t),Fs.forEach(t),m.forEach(t),vs=n(l),ml=j(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-6l9nzs"&&(ml.textContent=lM),$s=n(l),ks=j(l,"HR",{}),xs=n(l),dl=j(l,"TABLE",{"data-svelte-h":!0}),J(dl)!=="svelte-9e6c3b"&&(dl.innerHTML=sM),Xs=n(l),T(ql.$$.fragment,l),Ys=n(l),Hl=j(l,"P",{}),I(Hl).forEach(t),this.h()},h(){tM(r,"name","hf:doc:metadata"),tM(r,"content",TM)},m(l,s){o(document.head,r),M(l,Fl,s),M(l,_l,s),M(l,Dl,s),p(d,l,s),M(l,Ll,s),M(l,q,s),M(l,Pl,s),M(l,g,s),M(l,Ol,s),M(l,b,s),M(l,Kl,s),p(f,l,s),M(l,ls,s),M(l,E,s),M(l,ss,s),M(l,B,s),M(l,ts,s),p(Q,l,s),M(l,Ms,s),p(N,l,s),M(l,as,s),M(l,Z,s),M(l,ns,s),p(G,l,s),M(l,es,s),M(l,W,s),M(l,js,s),p(S,l,s),M(l,os,s),p(v,l,s),M(l,Js,s),M(l,$,s),M(l,ys,s),M(l,k,s),M(l,Ts,s),p(x,l,s),M(l,ps,s),p(X,l,s),M(l,is,s),M(l,Y,s),M(l,Us,s),p(V,l,s),M(l,us,s),M(l,z,s),M(l,Is,s),M(l,R,s),M(l,cs,s),p(_,l,s),M(l,ws,s),M(l,H,s),M(l,As,s),p(F,l,s),M(l,rs,s),M(l,D,s),M(l,hs,s),p(L,l,s),M(l,Cs,s),p(P,l,s),M(l,ms,s),p(O,l,s),M(l,ds,s),M(l,K,s),M(l,qs,s),M(l,ll,s),M(l,gs,s),M(l,sl,s),M(l,bs,s),p(tl,l,s),M(l,fs,s),p(Ml,l,s),M(l,Es,s),M(l,al,s),M(l,Bs,s),p(nl,l,s),M(l,Qs,s),p(el,l,s),M(l,Ns,s),M(l,jl,s),M(l,Zs,s),p(ol,l,s),M(l,Gs,s),p(Jl,l,s),M(l,Ws,s),M(l,yl,s),M(l,Ss,s),M(l,w,s),o(w,Tl),o(Tl,gl),o(Tl,Ps),o(Tl,h),o(h,bl),o(h,Os),o(h,fl),o(h,Ks),o(h,El),o(El,lt),p(pl,El,null),o(w,st),o(w,il),o(il,Bl),o(il,tt),o(il,C),o(C,Ql),o(C,Mt),o(C,Nl),o(C,at),o(C,Zl),o(Zl,nt),p(Ul,Zl,null),o(w,et),o(w,ul),o(ul,Gl),o(ul,jt),o(ul,Il),o(Il,Wl),o(Il,ot),o(Il,Sl),o(Sl,Jt),p(cl,Sl,null),o(w,yt),o(w,wl),o(wl,vl),o(wl,Tt),o(wl,Al),o(Al,$l),o(Al,pt),o(Al,kl),o(kl,it),o(kl,rl),o(rl,xl),o(xl,Ut),p(hl,xl,null),o(rl,ut),o(rl,Xl),o(Xl,It),p(Cl,Xl,null),M(l,vs,s),M(l,ml,s),M(l,$s,s),M(l,ks,s),M(l,xs,s),M(l,dl,s),M(l,Xs,s),p(ql,l,s),M(l,Ys,s),M(l,Hl,s),Vs=!0},p:aM,i(l){Vs||(i(d.$$.fragment,l),i(f.$$.fragment,l),i(Q.$$.fragment,l),i(N.$$.fragment,l),i(G.$$.fragment,l),i(S.$$.fragment,l),i(v.$$.fragment,l),i(x.$$.fragment,l),i(X.$$.fragment,l),i(V.$$.fragment,l),i(_.$$.fragment,l),i(F.$$.fragment,l),i(L.$$.fragment,l),i(P.$$.fragment,l),i(O.$$.fragment,l),i(tl.$$.fragment,l),i(Ml.$$.fragment,l),i(nl.$$.fragment,l),i(el.$$.fragment,l),i(ol.$$.fragment,l),i(Jl.$$.fragment,l),i(pl.$$.fragment,l),i(Ul.$$.fragment,l),i(cl.$$.fragment,l),i(hl.$$.fragment,l),i(Cl.$$.fragment,l),i(ql.$$.fragment,l),Vs=!0)},o(l){U(d.$$.fragment,l),U(f.$$.fragment,l),U(Q.$$.fragment,l),U(N.$$.fragment,l),U(G.$$.fragment,l),U(S.$$.fragment,l),U(v.$$.fragment,l),U(x.$$.fragment,l),U(X.$$.fragment,l),U(V.$$.fragment,l),U(_.$$.fragment,l),U(F.$$.fragment,l),U(L.$$.fragment,l),U(P.$$.fragment,l),U(O.$$.fragment,l),U(tl.$$.fragment,l),U(Ml.$$.fragment,l),U(nl.$$.fragment,l),U(el.$$.fragment,l),U(ol.$$.fragment,l),U(Jl.$$.fragment,l),U(pl.$$.fragment,l),U(Ul.$$.fragment,l),U(cl.$$.fragment,l),U(hl.$$.fragment,l),U(Cl.$$.fragment,l),U(ql.$$.fragment,l),Vs=!1},d(l){l&&(t(Fl),t(_l),t(Dl),t(Ll),t(q),t(Pl),t(g),t(Ol),t(b),t(Kl),t(ls),t(E),t(ss),t(B),t(ts),t(Ms),t(as),t(Z),t(ns),t(es),t(W),t(js),t(os),t(Js),t($),t(ys),t(k),t(Ts),t(ps),t(is),t(Y),t(Us),t(us),t(z),t(Is),t(R),t(cs),t(ws),t(H),t(As),t(rs),t(D),t(hs),t(Cs),t(ms),t(ds),t(K),t(qs),t(ll),t(gs),t(sl),t(bs),t(fs),t(Es),t(al),t(Bs),t(Qs),t(Ns),t(jl),t(Zs),t(Gs),t(Ws),t(yl),t(Ss),t(w),t(vs),t(ml),t($s),t(ks),t(xs),t(dl),t(Xs),t(Ys),t(Hl)),t(r),u(d,l),u(f,l),u(Q,l),u(N,l),u(G,l),u(S,l),u(v,l),u(x,l),u(X,l),u(V,l),u(_,l),u(F,l),u(L,l),u(P,l),u(O,l),u(tl,l),u(Ml,l),u(nl,l),u(el,l),u(ol,l),u(Jl,l),u(pl),u(Ul),u(cl),u(hl),u(Cl),u(ql,l)}}}const TM='{"title":"Guidance","local":"guidance","sections":[{"title":"How it works","local":"how-it-works","sections":[],"depth":2},{"title":"Table of Contents 📚","local":"table-of-contents-","sections":[{"title":"Grammar and Constraints","local":"grammar-and-constraints","sections":[],"depth":3},{"title":"Tools and Functions","local":"tools-and-functions","sections":[],"depth":3}],"depth":2},{"title":"Grammar and Constraints 🛣️","local":"grammar-and-constraints-","sections":[{"title":"The Grammar Parameter","local":"the-grammar-parameter","sections":[],"depth":3},{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Constrain with Pydantic","local":"constrain-with-pydantic","sections":[],"depth":3}],"depth":2},{"title":"Tools and Functions 🛠️","local":"tools-and-functions-","sections":[{"title":"The Tools Parameter","local":"the-tools-parameter","sections":[],"depth":3},{"title":"Chat Completion with Tools","local":"chat-completion-with-tools","sections":[],"depth":3},{"title":"OpenAI integration","local":"openai-integration","sections":[],"depth":3},{"title":"Tool Choice Configuration","local":"tool-choice-configuration","sections":[],"depth":3}],"depth":2}],"depth":1}';function pM(mt){return nM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cM extends eM{constructor(r){super(),jM(this,r,pM,yM,MM,{})}}export{cM as component};
