import{s as En,o as qn,n as Rl}from"../chunks/scheduler.c57aa7ef.js";import{S as Fn,i as Yn,g as i,s as n,r as p,A as Nn,h as o,f as a,c as s,j as zn,u as d,x as r,k as Cl,y as Sn,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.394f8801.js";import{T as Ll}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.5228ed01.js";import{H as y,E as Pn}from"../chunks/EditOnGithub.157fddbf.js";function Dn(T){let c,g='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-9hfq4t"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Rl,d(w){w&&a(c)}}}function Kn(T){let c,g='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Rl,d(w){w&&a(c)}}}function On(T){let c,g='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Rl,d(w){w&&a(c)}}}function es(T){let c,g,w,b,j,jt,Z,Bl='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Zt,k,Il="This guide explores in more detail other options and features for using LoRA.",kt,U,Ut,C,Wl='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Ct,L,Al='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Lt,R,Rt,B,Gl="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",Bt,I,It,W,Wt,A,Vl='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',At,G,Ql="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Gt,V,Vt,Q,xl="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",Qt,x,xt,H,Hl='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',Ht,X,Xt,z,Xl=`<a href="https://arxiv.org/pdf/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,zt,E,zl="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",Et,q,qt,F,El='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',Ft,Y,Yt,N,ql='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',Nt,S,Fl="You just need to pass a single additional option to use OLoRA:",St,P,Pt,D,Yl='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',Dt,K,Kt,O,Nl='<a href="https://arxiv.org/pdf/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',Ot,ee,Sl='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',ea,te,ta,ae,Pl="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",aa,le,Dl='It is recommended to perform EVA initialization on a GPU as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',la,ne,na,se,Kl='Then, call <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',sa,ie,ia,oe,Ol='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',oa,J,ra,re,pa,pe,da,de,en='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',ma,me,tn="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",fa,fe,ha,he,an="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",ua,ue,ca,ce,ln='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ma,Me,nn="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",wa,we,sn="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",ya,ye,on="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",ga,_,ba,ge,Ta,be,rn='Another way to initialize <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Ja,Te,_a,Je,$a,_e,pn='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',va,$e,ja,ve,dn="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",Za,je,ka,Ze,mn="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Ua,ke,Ca,Ue,fn=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,La,Ce,hn='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',Ra,Le,Ba,Re,un='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Ia,Be,Wa,Ie,cn='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Aa,We,Ga,Ae,Va,Ge,Mn='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Qa,Ve,xa,Qe,wn='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',Ha,xe,yn=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Xa,He,za,Xe,gn="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",Ea,ze,qa,Ee,bn='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',Fa,qe,Ya,Fe,Na,Ye,Tn='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Sa,Ne,Jn="Below is a diagram that explains the intuition of LoRA adapter merging:",Pa,$,_n='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',Da,Se,$n="We show in the snippets below how to run that using PEFT.",Ka,Pe,Oa,De,vn='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/pr_1324/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/pr_1324/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',el,Ke,tl,Oe,jn='The <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',al,et,Zn="First load the base model:",ll,tt,nl,at,kn="Then we load the first adapter:",sl,lt,il,nt,Un="Then load a different adapter and merge it with the first one:",ol,st,rl,v,pl,it,Cn="Now, perform inference:",dl,ot,ml,rt,fl,pt,Ln='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',hl,dt,ul,mt,Rn='To return the base model, you could use <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',cl,ft,Ml,ht,wl,ut,Bn="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",yl,ct,In="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",gl,Mt,bl,wt,Wn="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Tl,yt,Jl,gt,An="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",_l,bt,Gn="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",$l,Tt,vl,Jt,Vn="Using this features has some drawbacks, namely:",jl,_t,Qn='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Zl,$t,kl,vt,Ul;return j=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),U=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),I=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),W=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),V=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),x=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),X=new y({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),q=new M({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),Y=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),K=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),ne=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),ie=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new Ll({props:{$$slots:{default:[Dn]},$$scope:{ctx:T}}}),re=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),pe=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),fe=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),ue=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new Ll({props:{$$slots:{default:[Kn]},$$scope:{ctx:T}}}),ge=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Je=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),$e=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),je=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),ke=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Le=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Be=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),We=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Ae=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),Ve=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),He=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),ze=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),qe=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Fe=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Ke=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),lt=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),st=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),v=new Ll({props:{$$slots:{default:[On]},$$scope:{ctx:T}}}),ot=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),rt=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),dt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ft=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ht=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Mt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),yt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Tt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),$t=new Pn({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),g=n(),w=i("p"),b=n(),p(j.$$.fragment),jt=n(),Z=i("p"),Z.innerHTML=Bl,Zt=n(),k=i("p"),k.textContent=Il,kt=n(),p(U.$$.fragment),Ut=n(),C=i("p"),C.innerHTML=Wl,Ct=n(),L=i("p"),L.innerHTML=Al,Lt=n(),p(R.$$.fragment),Rt=n(),B=i("p"),B.innerHTML=Gl,Bt=n(),p(I.$$.fragment),It=n(),p(W.$$.fragment),Wt=n(),A=i("p"),A.innerHTML=Vl,At=n(),G=i("p"),G.textContent=Ql,Gt=n(),p(V.$$.fragment),Vt=n(),Q=i("p"),Q.textContent=xl,Qt=n(),p(x.$$.fragment),xt=n(),H=i("p"),H.innerHTML=Hl,Ht=n(),p(X.$$.fragment),Xt=n(),z=i("p"),z.innerHTML=Xl,zt=n(),E=i("p"),E.textContent=zl,Et=n(),p(q.$$.fragment),qt=n(),F=i("p"),F.innerHTML=El,Ft=n(),p(Y.$$.fragment),Yt=n(),N=i("p"),N.innerHTML=ql,Nt=n(),S=i("p"),S.textContent=Fl,St=n(),p(P.$$.fragment),Pt=n(),D=i("p"),D.innerHTML=Yl,Dt=n(),p(K.$$.fragment),Kt=n(),O=i("p"),O.innerHTML=Nl,Ot=n(),ee=i("p"),ee.innerHTML=Sl,ea=n(),p(te.$$.fragment),ta=n(),ae=i("p"),ae.innerHTML=Pl,aa=n(),le=i("p"),le.innerHTML=Dl,la=n(),p(ne.$$.fragment),na=n(),se=i("p"),se.innerHTML=Kl,sa=n(),p(ie.$$.fragment),ia=n(),oe=i("p"),oe.innerHTML=Ol,oa=n(),p(J.$$.fragment),ra=n(),p(re.$$.fragment),pa=n(),p(pe.$$.fragment),da=n(),de=i("p"),de.innerHTML=en,ma=n(),me=i("p"),me.innerHTML=tn,fa=n(),p(fe.$$.fragment),ha=n(),he=i("p"),he.innerHTML=an,ua=n(),p(ue.$$.fragment),ca=n(),ce=i("p"),ce.innerHTML=ln,Ma=n(),Me=i("p"),Me.innerHTML=nn,wa=n(),we=i("p"),we.innerHTML=sn,ya=n(),ye=i("ul"),ye.innerHTML=on,ga=n(),p(_.$$.fragment),ba=n(),p(ge.$$.fragment),Ta=n(),be=i("p"),be.innerHTML=rn,Ja=n(),p(Te.$$.fragment),_a=n(),p(Je.$$.fragment),$a=n(),_e=i("p"),_e.innerHTML=pn,va=n(),p($e.$$.fragment),ja=n(),ve=i("p"),ve.innerHTML=dn,Za=n(),p(je.$$.fragment),ka=n(),Ze=i("p"),Ze.innerHTML=mn,Ua=n(),p(ke.$$.fragment),Ca=n(),Ue=i("p"),Ue.innerHTML=fn,La=n(),Ce=i("table"),Ce.innerHTML=hn,Ra=n(),p(Le.$$.fragment),Ba=n(),Re=i("ul"),Re.innerHTML=un,Ia=n(),p(Be.$$.fragment),Wa=n(),Ie=i("p"),Ie.innerHTML=cn,Aa=n(),p(We.$$.fragment),Ga=n(),p(Ae.$$.fragment),Va=n(),Ge=i("p"),Ge.innerHTML=Mn,Qa=n(),p(Ve.$$.fragment),xa=n(),Qe=i("p"),Qe.innerHTML=wn,Ha=n(),xe=i("p"),xe.innerHTML=yn,Xa=n(),p(He.$$.fragment),za=n(),Xe=i("p"),Xe.textContent=gn,Ea=n(),p(ze.$$.fragment),qa=n(),Ee=i("p"),Ee.innerHTML=bn,Fa=n(),p(qe.$$.fragment),Ya=n(),p(Fe.$$.fragment),Na=n(),Ye=i("p"),Ye.innerHTML=Tn,Sa=n(),Ne=i("p"),Ne.textContent=Jn,Pa=n(),$=i("div"),$.innerHTML=_n,Da=n(),Se=i("p"),Se.textContent=$n,Ka=n(),p(Pe.$$.fragment),Oa=n(),De=i("p"),De.innerHTML=vn,el=n(),p(Ke.$$.fragment),tl=n(),Oe=i("p"),Oe.innerHTML=jn,al=n(),et=i("p"),et.textContent=Zn,ll=n(),p(tt.$$.fragment),nl=n(),at=i("p"),at.textContent=kn,sl=n(),p(lt.$$.fragment),il=n(),nt=i("p"),nt.textContent=Un,ol=n(),p(st.$$.fragment),rl=n(),p(v.$$.fragment),pl=n(),it=i("p"),it.textContent=Cn,dl=n(),p(ot.$$.fragment),ml=n(),p(rt.$$.fragment),fl=n(),pt=i("p"),pt.innerHTML=Ln,hl=n(),p(dt.$$.fragment),ul=n(),mt=i("p"),mt.innerHTML=Rn,cl=n(),p(ft.$$.fragment),Ml=n(),p(ht.$$.fragment),wl=n(),ut=i("p"),ut.textContent=Bn,yl=n(),ct=i("p"),ct.innerHTML=In,gl=n(),p(Mt.$$.fragment),bl=n(),wt=i("p"),wt.innerHTML=Wn,Tl=n(),p(yt.$$.fragment),Jl=n(),gt=i("p"),gt.innerHTML=An,_l=n(),bt=i("p"),bt.innerHTML=Gn,$l=n(),p(Tt.$$.fragment),vl=n(),Jt=i("p"),Jt.textContent=Vn,jl=n(),_t=i("ul"),_t.innerHTML=Qn,Zl=n(),p($t.$$.fragment),kl=n(),vt=i("p"),this.h()},l(e){const t=Nn("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=s(e),w=o(e,"P",{}),zn(w).forEach(a),b=s(e),d(j.$$.fragment,e),jt=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-p00je4"&&(Z.innerHTML=Bl),Zt=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ovsn32"&&(k.textContent=Il),kt=s(e),d(U.$$.fragment,e),Ut=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17lw2fr"&&(C.innerHTML=Wl),Ct=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1fujb7a"&&(L.innerHTML=Al),Lt=s(e),d(R.$$.fragment,e),Rt=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-mwvui1"&&(B.innerHTML=Gl),Bt=s(e),d(I.$$.fragment,e),It=s(e),d(W.$$.fragment,e),Wt=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1skluc"&&(A.innerHTML=Vl),At=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1hy0lgx"&&(G.textContent=Ql),Gt=s(e),d(V.$$.fragment,e),Vt=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-auzrbb"&&(Q.textContent=xl),Qt=s(e),d(x.$$.fragment,e),xt=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16k39wq"&&(H.innerHTML=Hl),Ht=s(e),d(X.$$.fragment,e),Xt=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-197rrjy"&&(z.innerHTML=Xl),zt=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1huziu5"&&(E.textContent=zl),Et=s(e),d(q.$$.fragment,e),qt=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19qemwc"&&(F.innerHTML=El),Ft=s(e),d(Y.$$.fragment,e),Yt=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-17kc0j8"&&(N.innerHTML=ql),Nt=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1j9g8qn"&&(S.textContent=Fl),St=s(e),d(P.$$.fragment,e),Pt=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-sulxp4"&&(D.innerHTML=Yl),Dt=s(e),d(K.$$.fragment,e),Kt=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-jrbt6r"&&(O.innerHTML=Nl),Ot=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1pf31q8"&&(ee.innerHTML=Sl),ea=s(e),d(te.$$.fragment,e),ta=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-168zxvb"&&(ae.innerHTML=Pl),aa=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-lbwrph"&&(le.innerHTML=Dl),la=s(e),d(ne.$$.fragment,e),na=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-9mytae"&&(se.innerHTML=Kl),sa=s(e),d(ie.$$.fragment,e),ia=s(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ku7xgt"&&(oe.innerHTML=Ol),oa=s(e),d(J.$$.fragment,e),ra=s(e),d(re.$$.fragment,e),pa=s(e),d(pe.$$.fragment,e),da=s(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ts8vpq"&&(de.innerHTML=en),ma=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-7f0aai"&&(me.innerHTML=tn),fa=s(e),d(fe.$$.fragment,e),ha=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14vtcq9"&&(he.innerHTML=an),ua=s(e),d(ue.$$.fragment,e),ca=s(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1nywyxh"&&(ce.innerHTML=ln),Ma=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1d2jix1"&&(Me.innerHTML=nn),wa=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-yl8kok"&&(we.innerHTML=sn),ya=s(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-12tl4fy"&&(ye.innerHTML=on),ga=s(e),d(_.$$.fragment,e),ba=s(e),d(ge.$$.fragment,e),Ta=s(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-n4u4ov"&&(be.innerHTML=rn),Ja=s(e),d(Te.$$.fragment,e),_a=s(e),d(Je.$$.fragment,e),$a=s(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1ukfkwt"&&(_e.innerHTML=pn),va=s(e),d($e.$$.fragment,e),ja=s(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-8wzhde"&&(ve.innerHTML=dn),Za=s(e),d(je.$$.fragment,e),ka=s(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-16lyt50"&&(Ze.innerHTML=mn),Ua=s(e),d(ke.$$.fragment,e),Ca=s(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-zr3cxq"&&(Ue.innerHTML=fn),La=s(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1iyfgt7"&&(Ce.innerHTML=hn),Ra=s(e),d(Le.$$.fragment,e),Ba=s(e),Re=o(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-6zi1s1"&&(Re.innerHTML=un),Ia=s(e),d(Be.$$.fragment,e),Wa=s(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-15vxux2"&&(Ie.innerHTML=cn),Aa=s(e),d(We.$$.fragment,e),Ga=s(e),d(Ae.$$.fragment,e),Va=s(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mosto0"&&(Ge.innerHTML=Mn),Qa=s(e),d(Ve.$$.fragment,e),xa=s(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1ttqqw0"&&(Qe.innerHTML=wn),Ha=s(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-foj0wd"&&(xe.innerHTML=yn),Xa=s(e),d(He.$$.fragment,e),za=s(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-rkzqzi"&&(Xe.textContent=gn),Ea=s(e),d(ze.$$.fragment,e),qa=s(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-9dmo2s"&&(Ee.innerHTML=bn),Fa=s(e),d(qe.$$.fragment,e),Ya=s(e),d(Fe.$$.fragment,e),Na=s(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-7m1f0a"&&(Ye.innerHTML=Tn),Sa=s(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1wwmf5r"&&(Ne.textContent=Jn),Pa=s(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-1f6iuw5"&&($.innerHTML=_n),Da=s(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-hlzwis"&&(Se.textContent=$n),Ka=s(e),d(Pe.$$.fragment,e),Oa=s(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ftdov9"&&(De.innerHTML=vn),el=s(e),d(Ke.$$.fragment,e),tl=s(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1n4a8sh"&&(Oe.innerHTML=jn),al=s(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1mwdwt1"&&(et.textContent=Zn),ll=s(e),d(tt.$$.fragment,e),nl=s(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-nuhu05"&&(at.textContent=kn),sl=s(e),d(lt.$$.fragment,e),il=s(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1n53hd9"&&(nt.textContent=Un),ol=s(e),d(st.$$.fragment,e),rl=s(e),d(v.$$.fragment,e),pl=s(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-qwbdkg"&&(it.textContent=Cn),dl=s(e),d(ot.$$.fragment,e),ml=s(e),d(rt.$$.fragment,e),fl=s(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1pigtsk"&&(pt.innerHTML=Ln),hl=s(e),d(dt.$$.fragment,e),ul=s(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1u4sd22"&&(mt.innerHTML=Rn),cl=s(e),d(ft.$$.fragment,e),Ml=s(e),d(ht.$$.fragment,e),wl=s(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1fq5tpu"&&(ut.textContent=Bn),yl=s(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-lcywla"&&(ct.innerHTML=In),gl=s(e),d(Mt.$$.fragment,e),bl=s(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-6wkyom"&&(wt.innerHTML=Wn),Tl=s(e),d(yt.$$.fragment,e),Jl=s(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1o40ch6"&&(gt.innerHTML=An),_l=s(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-13py9hk"&&(bt.innerHTML=Gn),$l=s(e),d(Tt.$$.fragment,e),vl=s(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-fpz5mj"&&(Jt.textContent=Vn),jl=s(e),_t=o(e,"UL",{"data-svelte-h":!0}),r(_t)!=="svelte-150o10n"&&(_t.innerHTML=Qn),Zl=s(e),d($t.$$.fragment,e),kl=s(e),vt=o(e,"P",{}),zn(vt).forEach(a),this.h()},h(){Cl(c,"name","hf:doc:metadata"),Cl(c,"content",ts),Cl($,"class","flex justify-center")},m(e,t){Sn(document.head,c),l(e,g,t),l(e,w,t),l(e,b,t),m(j,e,t),l(e,jt,t),l(e,Z,t),l(e,Zt,t),l(e,k,t),l(e,kt,t),m(U,e,t),l(e,Ut,t),l(e,C,t),l(e,Ct,t),l(e,L,t),l(e,Lt,t),m(R,e,t),l(e,Rt,t),l(e,B,t),l(e,Bt,t),m(I,e,t),l(e,It,t),m(W,e,t),l(e,Wt,t),l(e,A,t),l(e,At,t),l(e,G,t),l(e,Gt,t),m(V,e,t),l(e,Vt,t),l(e,Q,t),l(e,Qt,t),m(x,e,t),l(e,xt,t),l(e,H,t),l(e,Ht,t),m(X,e,t),l(e,Xt,t),l(e,z,t),l(e,zt,t),l(e,E,t),l(e,Et,t),m(q,e,t),l(e,qt,t),l(e,F,t),l(e,Ft,t),m(Y,e,t),l(e,Yt,t),l(e,N,t),l(e,Nt,t),l(e,S,t),l(e,St,t),m(P,e,t),l(e,Pt,t),l(e,D,t),l(e,Dt,t),m(K,e,t),l(e,Kt,t),l(e,O,t),l(e,Ot,t),l(e,ee,t),l(e,ea,t),m(te,e,t),l(e,ta,t),l(e,ae,t),l(e,aa,t),l(e,le,t),l(e,la,t),m(ne,e,t),l(e,na,t),l(e,se,t),l(e,sa,t),m(ie,e,t),l(e,ia,t),l(e,oe,t),l(e,oa,t),m(J,e,t),l(e,ra,t),m(re,e,t),l(e,pa,t),m(pe,e,t),l(e,da,t),l(e,de,t),l(e,ma,t),l(e,me,t),l(e,fa,t),m(fe,e,t),l(e,ha,t),l(e,he,t),l(e,ua,t),m(ue,e,t),l(e,ca,t),l(e,ce,t),l(e,Ma,t),l(e,Me,t),l(e,wa,t),l(e,we,t),l(e,ya,t),l(e,ye,t),l(e,ga,t),m(_,e,t),l(e,ba,t),m(ge,e,t),l(e,Ta,t),l(e,be,t),l(e,Ja,t),m(Te,e,t),l(e,_a,t),m(Je,e,t),l(e,$a,t),l(e,_e,t),l(e,va,t),m($e,e,t),l(e,ja,t),l(e,ve,t),l(e,Za,t),m(je,e,t),l(e,ka,t),l(e,Ze,t),l(e,Ua,t),m(ke,e,t),l(e,Ca,t),l(e,Ue,t),l(e,La,t),l(e,Ce,t),l(e,Ra,t),m(Le,e,t),l(e,Ba,t),l(e,Re,t),l(e,Ia,t),m(Be,e,t),l(e,Wa,t),l(e,Ie,t),l(e,Aa,t),m(We,e,t),l(e,Ga,t),m(Ae,e,t),l(e,Va,t),l(e,Ge,t),l(e,Qa,t),m(Ve,e,t),l(e,xa,t),l(e,Qe,t),l(e,Ha,t),l(e,xe,t),l(e,Xa,t),m(He,e,t),l(e,za,t),l(e,Xe,t),l(e,Ea,t),m(ze,e,t),l(e,qa,t),l(e,Ee,t),l(e,Fa,t),m(qe,e,t),l(e,Ya,t),m(Fe,e,t),l(e,Na,t),l(e,Ye,t),l(e,Sa,t),l(e,Ne,t),l(e,Pa,t),l(e,$,t),l(e,Da,t),l(e,Se,t),l(e,Ka,t),m(Pe,e,t),l(e,Oa,t),l(e,De,t),l(e,el,t),m(Ke,e,t),l(e,tl,t),l(e,Oe,t),l(e,al,t),l(e,et,t),l(e,ll,t),m(tt,e,t),l(e,nl,t),l(e,at,t),l(e,sl,t),m(lt,e,t),l(e,il,t),l(e,nt,t),l(e,ol,t),m(st,e,t),l(e,rl,t),m(v,e,t),l(e,pl,t),l(e,it,t),l(e,dl,t),m(ot,e,t),l(e,ml,t),m(rt,e,t),l(e,fl,t),l(e,pt,t),l(e,hl,t),m(dt,e,t),l(e,ul,t),l(e,mt,t),l(e,cl,t),m(ft,e,t),l(e,Ml,t),m(ht,e,t),l(e,wl,t),l(e,ut,t),l(e,yl,t),l(e,ct,t),l(e,gl,t),m(Mt,e,t),l(e,bl,t),l(e,wt,t),l(e,Tl,t),m(yt,e,t),l(e,Jl,t),l(e,gt,t),l(e,_l,t),l(e,bt,t),l(e,$l,t),m(Tt,e,t),l(e,vl,t),l(e,Jt,t),l(e,jl,t),l(e,_t,t),l(e,Zl,t),m($t,e,t),l(e,kl,t),l(e,vt,t),Ul=!0},p(e,[t]){const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),J.$set(xn);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),_.$set(Hn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),v.$set(Xn)},i(e){Ul||(f(j.$$.fragment,e),f(U.$$.fragment,e),f(R.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(X.$$.fragment,e),f(q.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(J.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(_.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(je.$$.fragment,e),f(ke.$$.fragment,e),f(Le.$$.fragment,e),f(Be.$$.fragment,e),f(We.$$.fragment,e),f(Ae.$$.fragment,e),f(Ve.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(qe.$$.fragment,e),f(Fe.$$.fragment,e),f(Pe.$$.fragment,e),f(Ke.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(v.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(Mt.$$.fragment,e),f(yt.$$.fragment,e),f(Tt.$$.fragment,e),f($t.$$.fragment,e),Ul=!0)},o(e){h(j.$$.fragment,e),h(U.$$.fragment,e),h(R.$$.fragment,e),h(I.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(x.$$.fragment,e),h(X.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(J.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(_.$$.fragment,e),h(ge.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(He.$$.fragment,e),h(ze.$$.fragment,e),h(qe.$$.fragment,e),h(Fe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(v.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ft.$$.fragment,e),h(ht.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(Tt.$$.fragment,e),h($t.$$.fragment,e),Ul=!1},d(e){e&&(a(g),a(w),a(b),a(jt),a(Z),a(Zt),a(k),a(kt),a(Ut),a(C),a(Ct),a(L),a(Lt),a(Rt),a(B),a(Bt),a(It),a(Wt),a(A),a(At),a(G),a(Gt),a(Vt),a(Q),a(Qt),a(xt),a(H),a(Ht),a(Xt),a(z),a(zt),a(E),a(Et),a(qt),a(F),a(Ft),a(Yt),a(N),a(Nt),a(S),a(St),a(Pt),a(D),a(Dt),a(Kt),a(O),a(Ot),a(ee),a(ea),a(ta),a(ae),a(aa),a(le),a(la),a(na),a(se),a(sa),a(ia),a(oe),a(oa),a(ra),a(pa),a(da),a(de),a(ma),a(me),a(fa),a(ha),a(he),a(ua),a(ca),a(ce),a(Ma),a(Me),a(wa),a(we),a(ya),a(ye),a(ga),a(ba),a(Ta),a(be),a(Ja),a(_a),a($a),a(_e),a(va),a(ja),a(ve),a(Za),a(ka),a(Ze),a(Ua),a(Ca),a(Ue),a(La),a(Ce),a(Ra),a(Ba),a(Re),a(Ia),a(Wa),a(Ie),a(Aa),a(Ga),a(Va),a(Ge),a(Qa),a(xa),a(Qe),a(Ha),a(xe),a(Xa),a(za),a(Xe),a(Ea),a(qa),a(Ee),a(Fa),a(Ya),a(Na),a(Ye),a(Sa),a(Ne),a(Pa),a($),a(Da),a(Se),a(Ka),a(Oa),a(De),a(el),a(tl),a(Oe),a(al),a(et),a(ll),a(nl),a(at),a(sl),a(il),a(nt),a(ol),a(rl),a(pl),a(it),a(dl),a(ml),a(fl),a(pt),a(hl),a(ul),a(mt),a(cl),a(Ml),a(wl),a(ut),a(yl),a(ct),a(gl),a(bl),a(wt),a(Tl),a(Jl),a(gt),a(_l),a(bt),a($l),a(vl),a(Jt),a(jl),a(_t),a(Zl),a(kl),a(vt)),a(c),u(j,e),u(U,e),u(R,e),u(I,e),u(W,e),u(V,e),u(x,e),u(X,e),u(q,e),u(Y,e),u(P,e),u(K,e),u(te,e),u(ne,e),u(ie,e),u(J,e),u(re,e),u(pe,e),u(fe,e),u(ue,e),u(_,e),u(ge,e),u(Te,e),u(Je,e),u($e,e),u(je,e),u(ke,e),u(Le,e),u(Be,e),u(We,e),u(Ae,e),u(Ve,e),u(He,e),u(ze,e),u(qe,e),u(Fe,e),u(Pe,e),u(Ke,e),u(tt,e),u(lt,e),u(st,e),u(v,e),u(ot,e),u(rt,e),u(dt,e),u(ft,e),u(ht,e),u(Mt,e),u(yt,e),u(Tt,e),u($t,e)}}}const ts='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(T){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Fn{constructor(c){super(),Yn(this,c,as,es,En,{})}}export{rs as component};
