import{s as na,f as _l,o as aa,n as Fs}from"../chunks/scheduler.9039eef2.js";import{S as ia,i as pa,g as i,s as n,r as o,A as ma,h as p,f as t,c as a,j as sa,u as r,x as m,k as J,y as oa,a as s,v as u,d as c,t as M,w as d}from"../chunks/index.cdcc3d35.js";import{T as Qs}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function ra(B){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",f,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,f=n(),g=i("p"),g.innerHTML=j},l(w){y=p(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),f=a(w),g=p(w,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(w,U){s(w,y,U),s(w,f,U),s(w,g,U)},p:Fs,d(w){w&&(t(y),t(f),t(g))}}}function ua(B){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:Fs,d(f){f&&t(y)}}}function ca(B){let y,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3zwean"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:Fs,d(f){f&&t(y)}}}function Ma(B){let y,T,f,g,j,w,U,vl,v,Es='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',Nl,N,Hs="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",$l,$,Ls='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',xl,x,kl,k,Rl,R,zs="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",Sl,S,qs="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",Yl,Y,As="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",Ql,Q,Ds="<strong><em>Export via CLI</em></strong>",Fl,F,Ps="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",El,E,Hl,H,Ks="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Ll,L,Os="<strong><em>Export via Python API</em></strong>",zl,z,en="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",ql,C,Al,q,Dl,A,Pl,D,ln="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",Kl,P,tn="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",Ol,K,et,Z,sn,lt,O,tt,ee,nn="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",st,le,nt,te,an='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',at,se,it,ne,pn="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",pt,ae,mt,ie,mn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',ot,pe,rt,me,on="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",ut,oe,ct,re,rn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',Mt,ue,dt,ce,un='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',yt,Me,cn="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",ht,de,bt,ye,Mn="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",ft,he,dn="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Jt,be,yn="<strong><em>Export via CLI</em></strong>",gt,fe,hn="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",wt,Je,Tt,ge,bn="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Ut,we,fn="<strong><em>Export via Python API</em></strong>",jt,Te,Jn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Zt,Ue,Wt,je,It,Ze,gn="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Gt,We,Xt,W,wn,Bt,Ie,Ct,Ge,Tn="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",Vt,Xe,_t,Be,Un='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',vt,Ce,Nt,Ve,jn="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",$t,_e,xt,ve,Zn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',kt,Ne,Rt,$e,Wn='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',St,xe,In="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",Yt,ke,Qt,Re,Ft,I,Gn,Et,Se,Ht,Ye,Lt,Qe,Xn='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',zt,V,qt,Fe,At,Ee,Bn='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',Dt,He,Cn="In <code>optimum-neuron</code>, you can:",Pt,Le,Vn="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",Kt,ze,_n='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',Ot,qe,es,Ae,vn="<strong><em>LCM of Stable Diffusion</em></strong>",ls,De,ts,Pe,Nn="<strong><em>LCM of Stable Diffusion XL</em></strong>",ss,Ke,ns,Oe,as,el,$n="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",is,ll,xn="<strong><em>LCM of Stable Diffusion</em></strong>",ps,tl,ms,sl,kn="<strong><em>LCM of Stable Diffusion XL</em></strong>",os,nl,rs,al,us,il,Rn='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',cs,pl,Sn="In <code>optimum-neuron</code>, you can:",Ms,ml,Yn="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",ds,ol,Qn='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',ys,rl,hs,ul,bs,cl,fs,Ml,Fn="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Js,dl,gs,_,ws,yl,Ts,hl,Us,bl,En="Low-Rank Adaptation is fast way to Stable Diffusion to adapt styles of generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",js,fl,Zs,G,Hn,Ws,Jl,Is,gl,Ln="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. The you can use the compiled artifacts to generate styled images.",Gs,wl,Xs,Tl,zn="We can either compile one or multiple ControlNet via the Optimum CLI or programatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",Bs,Ul,qn="<li>Export via the Optimum CLI</li>",Cs,jl,Vs,Zl,An="<li>Export via Python API</li>",_s,Wl,vs,Il,Ns,Gl,Dn="For text-to-image, we can specify an additional conditioning input.",$s,Xl,Pn="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",xs,Bl,ks,X,Kn,Rs,Cl,On='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Ss,Vl,Ys;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),x=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),k=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),E=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDUxMiUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0td2lkdGglMjA1MTIlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --task stable-diffusion \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),C=new Qs({props:{$$slots:{default:[ra]},$$scope:{ctx:B}}}),q=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),A=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),K=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),O=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),le=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),se=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),ae=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),pe=new h({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h3"}}),oe=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),ue=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),de=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),Je=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDEwMjQlMjAlNjAlMjMlMjBoZWlnaHQlMjBpbiUyMHBpeGVscyUyMG9mJTIwZ2VuZXJhdGVkJTIwaW1hZ2UlMkMlMjBlZy4lMjA3NjglMkMlMjAxMDI0JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDEwMjQlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDQlMjAlNjAlMjMlMjBudW1iZXIlMjBvZiUyMGltYWdlcyUyMHRvJTIwZ2VuZXJhdGUlMjBwZXIlMjBwcm9tcHQlMkMlMjBkZWZhdWx0cyUyMHRvJTIwMSU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTYwJTIzJTIwY2FzdCUyMG9ubHklMjBtYXRyaXglMjBtdWx0aXBsaWNhdGlvbiUyMG9wZXJhdGlvbnMlNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdF90eXBlJTIwYmYxNiUyMCU2MCUyMyUyMGNhc3QlMjBvcGVyYXRpb25zJTIwZnJvbSUyMEZQMzIlMjB0byUyMEJGMTYlNjAlMjAlNUMlMEElMjAlMjBzZF9uZXVyb25feGwlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --task stable-diffusion-xl \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),Ue=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),je=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),We=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Xe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ce=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),_e=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ne=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),ke=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Re=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Se=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Ye=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),V=new Qs({props:{$$slots:{default:[ua]},$$scope:{ctx:B}}}),Fe=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),qe=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),De=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),Ke=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),Oe=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),tl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),nl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),al=new h({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),rl=new h({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),ul=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwc2R4bF90dXJib19uZXVyb24lMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --task stable-diffusion-xl --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),cl=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),dl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),_=new Qs({props:{$$slots:{default:[ca]},$$scope:{ctx:B}}}),yl=new h({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),hl=new h({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),fl=new b({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Jl=new h({props:{title:"ControlNet",local:"controlnet",headingTag:"h2"}}),wl=new h({props:{title:"Compile ControlNet",local:"compile-controlnet",headingTag:"h3"}}),jl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWNvbnRyb2xuZXRfaWRzJTIwbGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDElMjBzZF9uZXVyb25fY29udHJvbG5ldCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m runwayml/stable-diffusion-v1-5 --task stable-diffusion --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),Wl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXRfaWQlMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUwQSUwQSUyMyUyMCU1Qk5ldXJvbiU1RCUyMHBpcGVsaW5lJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2lkcyUzRGNvbnRyb2xuZXRfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfbmV1cm9uX2NvbnRyb2xuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),Il=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Bl=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),{c(){y=i("meta"),T=n(),f=i("p"),g=n(),o(j.$$.fragment),w=n(),o(U.$$.fragment),vl=n(),v=i("p"),v.innerHTML=Es,Nl=n(),N=i("p"),N.innerHTML=Hs,$l=n(),$=i("p"),$.innerHTML=Ls,xl=n(),o(x.$$.fragment),kl=n(),o(k.$$.fragment),Rl=n(),R=i("p"),R.innerHTML=zs,Sl=n(),S=i("ul"),S.innerHTML=qs,Yl=n(),Y=i("p"),Y.innerHTML=As,Ql=n(),Q=i("p"),Q.innerHTML=Ds,Fl=n(),F=i("p"),F.innerHTML=Ps,El=n(),o(E.$$.fragment),Hl=n(),H=i("p"),H.innerHTML=Ks,Ll=n(),L=i("p"),L.innerHTML=Os,zl=n(),z=i("p"),z.innerHTML=en,ql=n(),o(C.$$.fragment),Al=n(),o(q.$$.fragment),Dl=n(),o(A.$$.fragment),Pl=n(),D=i("p"),D.innerHTML=ln,Kl=n(),P=i("p"),P.textContent=tn,Ol=n(),o(K.$$.fragment),et=n(),Z=i("img"),lt=n(),o(O.$$.fragment),tt=n(),ee=i("p"),ee.innerHTML=nn,st=n(),o(le.$$.fragment),nt=n(),te=i("table"),te.innerHTML=an,at=n(),o(se.$$.fragment),it=n(),ne=i("p"),ne.innerHTML=pn,pt=n(),o(ae.$$.fragment),mt=n(),ie=i("table"),ie.innerHTML=mn,ot=n(),o(pe.$$.fragment),rt=n(),me=i("p"),me.innerHTML=on,ut=n(),o(oe.$$.fragment),ct=n(),re=i("table"),re.innerHTML=rn,Mt=n(),o(ue.$$.fragment),dt=n(),ce=i("p"),ce.innerHTML=un,yt=n(),Me=i("p"),Me.textContent=cn,ht=n(),o(de.$$.fragment),bt=n(),ye=i("p"),ye.textContent=Mn,ft=n(),he=i("ul"),he.innerHTML=dn,Jt=n(),be=i("p"),be.innerHTML=yn,gt=n(),fe=i("p"),fe.innerHTML=hn,wt=n(),o(Je.$$.fragment),Tt=n(),ge=i("p"),ge.innerHTML=bn,Ut=n(),we=i("p"),we.innerHTML=fn,jt=n(),Te=i("p"),Te.innerHTML=Jn,Zt=n(),o(Ue.$$.fragment),Wt=n(),o(je.$$.fragment),It=n(),Ze=i("p"),Ze.textContent=gn,Gt=n(),o(We.$$.fragment),Xt=n(),W=i("img"),Bt=n(),o(Ie.$$.fragment),Ct=n(),Ge=i("p"),Ge.innerHTML=Tn,Vt=n(),o(Xe.$$.fragment),_t=n(),Be=i("table"),Be.innerHTML=Un,vt=n(),o(Ce.$$.fragment),Nt=n(),Ve=i("p"),Ve.innerHTML=jn,$t=n(),o(_e.$$.fragment),xt=n(),ve=i("table"),ve.innerHTML=Zn,kt=n(),o(Ne.$$.fragment),Rt=n(),$e=i("p"),$e.innerHTML=Wn,St=n(),xe=i("ol"),xe.innerHTML=In,Yt=n(),o(ke.$$.fragment),Qt=n(),o(Re.$$.fragment),Ft=n(),I=i("img"),Et=n(),o(Se.$$.fragment),Ht=n(),o(Ye.$$.fragment),Lt=n(),Qe=i("table"),Qe.innerHTML=Xn,zt=n(),o(V.$$.fragment),qt=n(),o(Fe.$$.fragment),At=n(),Ee=i("p"),Ee.innerHTML=Bn,Dt=n(),He=i("p"),He.innerHTML=Cn,Pt=n(),Le=i("ul"),Le.innerHTML=Vn,Kt=n(),ze=i("p"),ze.innerHTML=_n,Ot=n(),o(qe.$$.fragment),es=n(),Ae=i("p"),Ae.innerHTML=vn,ls=n(),o(De.$$.fragment),ts=n(),Pe=i("p"),Pe.innerHTML=Nn,ss=n(),o(Ke.$$.fragment),ns=n(),o(Oe.$$.fragment),as=n(),el=i("p"),el.textContent=$n,is=n(),ll=i("p"),ll.innerHTML=xn,ps=n(),o(tl.$$.fragment),ms=n(),sl=i("p"),sl.innerHTML=kn,os=n(),o(nl.$$.fragment),rs=n(),o(al.$$.fragment),us=n(),il=i("p"),il.innerHTML=Rn,cs=n(),pl=i("p"),pl.innerHTML=Sn,Ms=n(),ml=i("ul"),ml.innerHTML=Yn,ds=n(),ol=i("p"),ol.innerHTML=Qn,ys=n(),o(rl.$$.fragment),hs=n(),o(ul.$$.fragment),bs=n(),o(cl.$$.fragment),fs=n(),Ml=i("p"),Ml.textContent=Fn,Js=n(),o(dl.$$.fragment),gs=n(),o(_.$$.fragment),ws=n(),o(yl.$$.fragment),Ts=n(),o(hl.$$.fragment),Us=n(),bl=i("p"),bl.textContent=En,js=n(),o(fl.$$.fragment),Zs=n(),G=i("img"),Ws=n(),o(Jl.$$.fragment),Is=n(),gl=i("p"),gl.textContent=Ln,Gs=n(),o(wl.$$.fragment),Xs=n(),Tl=i("p"),Tl.innerHTML=zn,Bs=n(),Ul=i("ul"),Ul.innerHTML=qn,Cs=n(),o(jl.$$.fragment),Vs=n(),Zl=i("ul"),Zl.innerHTML=An,_s=n(),o(Wl.$$.fragment),vs=n(),o(Il.$$.fragment),Ns=n(),Gl=i("p"),Gl.textContent=Dn,$s=n(),Xl=i("p"),Xl.textContent=Pn,xs=n(),o(Bl.$$.fragment),ks=n(),X=i("img"),Rs=n(),Cl=i("p"),Cl.innerHTML=On,Ss=n(),Vl=i("p"),this.h()},l(e){const l=ma("svelte-u9bgzb",document.head);y=p(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),f=p(e,"P",{}),sa(f).forEach(t),g=a(e),r(j.$$.fragment,e),w=a(e),r(U.$$.fragment,e),vl=a(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-140c11v"&&(v.innerHTML=Es),Nl=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1g87d8z"&&(N.innerHTML=Hs),$l=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1u4t7n7"&&($.innerHTML=Ls),xl=a(e),r(x.$$.fragment,e),kl=a(e),r(k.$$.fragment,e),Rl=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-3qllio"&&(R.innerHTML=zs),Sl=a(e),S=p(e,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-1c1t3y0"&&(S.innerHTML=qs),Yl=a(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-15y00oa"&&(Y.innerHTML=As),Ql=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1a2m8iq"&&(Q.innerHTML=Ds),Fl=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-ktaj8q"&&(F.innerHTML=Ps),El=a(e),r(E.$$.fragment,e),Hl=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-jz092x"&&(H.innerHTML=Ks),Ll=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-kxhd34"&&(L.innerHTML=Os),zl=a(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1bahy14"&&(z.innerHTML=en),ql=a(e),r(C.$$.fragment,e),Al=a(e),r(q.$$.fragment,e),Dl=a(e),r(A.$$.fragment,e),Pl=a(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1r61oa5"&&(D.innerHTML=ln),Kl=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1q8fgqb"&&(P.textContent=tn),Ol=a(e),r(K.$$.fragment,e),et=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),lt=a(e),r(O.$$.fragment,e),tt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-kqnotf"&&(ee.innerHTML=nn),st=a(e),r(le.$$.fragment,e),nt=a(e),te=p(e,"TABLE",{"data-svelte-h":!0}),m(te)!=="svelte-i6e2ex"&&(te.innerHTML=an),at=a(e),r(se.$$.fragment,e),it=a(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-vhijyl"&&(ne.innerHTML=pn),pt=a(e),r(ae.$$.fragment,e),mt=a(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),m(ie)!=="svelte-v8z5s8"&&(ie.innerHTML=mn),ot=a(e),r(pe.$$.fragment,e),rt=a(e),me=p(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1836mxv"&&(me.innerHTML=on),ut=a(e),r(oe.$$.fragment,e),ct=a(e),re=p(e,"TABLE",{"data-svelte-h":!0}),m(re)!=="svelte-w6yzym"&&(re.innerHTML=rn),Mt=a(e),r(ue.$$.fragment,e),dt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1q6nuso"&&(ce.innerHTML=un),yt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-7xctqf"&&(Me.textContent=cn),ht=a(e),r(de.$$.fragment,e),bt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-u4wwem"&&(ye.textContent=Mn),ft=a(e),he=p(e,"UL",{"data-svelte-h":!0}),m(he)!=="svelte-17e9k9s"&&(he.innerHTML=dn),Jt=a(e),be=p(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1a2m8iq"&&(be.innerHTML=yn),gt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-9niqj3"&&(fe.innerHTML=hn),wt=a(e),r(Je.$$.fragment,e),Tt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-eias7g"&&(ge.innerHTML=bn),Ut=a(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-kxhd34"&&(we.innerHTML=fn),jt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-17tzr0c"&&(Te.innerHTML=Jn),Zt=a(e),r(Ue.$$.fragment,e),Wt=a(e),r(je.$$.fragment,e),It=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-8q3qyn"&&(Ze.textContent=gn),Gt=a(e),r(We.$$.fragment,e),Xt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Bt=a(e),r(Ie.$$.fragment,e),Ct=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-luub4o"&&(Ge.innerHTML=Tn),Vt=a(e),r(Xe.$$.fragment,e),_t=a(e),Be=p(e,"TABLE",{"data-svelte-h":!0}),m(Be)!=="svelte-1s0d0pv"&&(Be.innerHTML=Un),vt=a(e),r(Ce.$$.fragment,e),Nt=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-11fbw00"&&(Ve.innerHTML=jn),$t=a(e),r(_e.$$.fragment,e),xt=a(e),ve=p(e,"TABLE",{"data-svelte-h":!0}),m(ve)!=="svelte-18741xe"&&(ve.innerHTML=Zn),kt=a(e),r(Ne.$$.fragment,e),Rt=a(e),$e=p(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1usq821"&&($e.innerHTML=Wn),St=a(e),xe=p(e,"OL",{"data-svelte-h":!0}),m(xe)!=="svelte-6p4eqi"&&(xe.innerHTML=In),Yt=a(e),r(ke.$$.fragment,e),Qt=a(e),r(Re.$$.fragment,e),Ft=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Et=a(e),r(Se.$$.fragment,e),Ht=a(e),r(Ye.$$.fragment,e),Lt=a(e),Qe=p(e,"TABLE",{"data-svelte-h":!0}),m(Qe)!=="svelte-1s7g03c"&&(Qe.innerHTML=Xn),zt=a(e),r(V.$$.fragment,e),qt=a(e),r(Fe.$$.fragment,e),At=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1ud6a8q"&&(Ee.innerHTML=Bn),Dt=a(e),He=p(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-1ayizu6"&&(He.innerHTML=Cn),Pt=a(e),Le=p(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-r4tdj0"&&(Le.innerHTML=Vn),Kt=a(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-c4lhmw"&&(ze.innerHTML=_n),Ot=a(e),r(qe.$$.fragment,e),es=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1s0vvjb"&&(Ae.innerHTML=vn),ls=a(e),r(De.$$.fragment,e),ts=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-51zp7x"&&(Pe.innerHTML=Nn),ss=a(e),r(Ke.$$.fragment,e),ns=a(e),r(Oe.$$.fragment,e),as=a(e),el=p(e,"P",{"data-svelte-h":!0}),m(el)!=="svelte-1ebkvay"&&(el.textContent=$n),is=a(e),ll=p(e,"P",{"data-svelte-h":!0}),m(ll)!=="svelte-1s0vvjb"&&(ll.innerHTML=xn),ps=a(e),r(tl.$$.fragment,e),ms=a(e),sl=p(e,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-51zp7x"&&(sl.innerHTML=kn),os=a(e),r(nl.$$.fragment,e),rs=a(e),r(al.$$.fragment,e),us=a(e),il=p(e,"P",{"data-svelte-h":!0}),m(il)!=="svelte-10h80ju"&&(il.innerHTML=Rn),cs=a(e),pl=p(e,"P",{"data-svelte-h":!0}),m(pl)!=="svelte-1ayizu6"&&(pl.innerHTML=Sn),Ms=a(e),ml=p(e,"UL",{"data-svelte-h":!0}),m(ml)!=="svelte-t7g18i"&&(ml.innerHTML=Yn),ds=a(e),ol=p(e,"P",{"data-svelte-h":!0}),m(ol)!=="svelte-ohwj0a"&&(ol.innerHTML=Qn),ys=a(e),r(rl.$$.fragment,e),hs=a(e),r(ul.$$.fragment,e),bs=a(e),r(cl.$$.fragment,e),fs=a(e),Ml=p(e,"P",{"data-svelte-h":!0}),m(Ml)!=="svelte-1ebkvay"&&(Ml.textContent=Fn),Js=a(e),r(dl.$$.fragment,e),gs=a(e),r(_.$$.fragment,e),ws=a(e),r(yl.$$.fragment,e),Ts=a(e),r(hl.$$.fragment,e),Us=a(e),bl=p(e,"P",{"data-svelte-h":!0}),m(bl)!=="svelte-k1lsm0"&&(bl.textContent=En),js=a(e),r(fl.$$.fragment,e),Zs=a(e),G=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ws=a(e),r(Jl.$$.fragment,e),Is=a(e),gl=p(e,"P",{"data-svelte-h":!0}),m(gl)!=="svelte-15r2htw"&&(gl.textContent=Ln),Gs=a(e),r(wl.$$.fragment,e),Xs=a(e),Tl=p(e,"P",{"data-svelte-h":!0}),m(Tl)!=="svelte-clsbw5"&&(Tl.innerHTML=zn),Bs=a(e),Ul=p(e,"UL",{"data-svelte-h":!0}),m(Ul)!=="svelte-127fndl"&&(Ul.innerHTML=qn),Cs=a(e),r(jl.$$.fragment,e),Vs=a(e),Zl=p(e,"UL",{"data-svelte-h":!0}),m(Zl)!=="svelte-zxjvv9"&&(Zl.innerHTML=An),_s=a(e),r(Wl.$$.fragment,e),vs=a(e),r(Il.$$.fragment,e),Ns=a(e),Gl=p(e,"P",{"data-svelte-h":!0}),m(Gl)!=="svelte-92hvy2"&&(Gl.textContent=Dn),$s=a(e),Xl=p(e,"P",{"data-svelte-h":!0}),m(Xl)!=="svelte-e5xot3"&&(Xl.textContent=Pn),xs=a(e),r(Bl.$$.fragment,e),ks=a(e),X=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Rs=a(e),Cl=p(e,"P",{"data-svelte-h":!0}),m(Cl)!=="svelte-xbi604"&&(Cl.innerHTML=On),Ss=a(e),Vl=p(e,"P",{}),sa(Vl).forEach(t),this.h()},h(){J(y,"name","hf:doc:metadata"),J(y,"content",da),_l(Z.src,sn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||J(Z,"src",sn),J(Z,"width","256"),J(Z,"height","256"),J(Z,"alt","stable diffusion generated image"),_l(W.src,wn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||J(W,"src",wn),J(W,"width","256"),J(W,"height","256"),J(W,"alt","sdxl generated image"),_l(I.src,Gn="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||J(I,"src",Gn),J(I,"width","256"),J(I,"height","256"),J(I,"alt","sdxl base + refiner"),_l(G.src,Hn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||J(G,"src",Hn),J(G,"width","256"),J(G,"height","256"),J(G,"alt","stable diffusion generated image with LoRA adapter."),_l(X.src,Kn="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||J(X,"src",Kn),J(X,"width","768"),J(X,"height","256"),J(X,"alt","stable diffusion 1.5 generated image with controlnet.")},m(e,l){oa(document.head,y),s(e,T,l),s(e,f,l),s(e,g,l),u(j,e,l),s(e,w,l),u(U,e,l),s(e,vl,l),s(e,v,l),s(e,Nl,l),s(e,N,l),s(e,$l,l),s(e,$,l),s(e,xl,l),u(x,e,l),s(e,kl,l),u(k,e,l),s(e,Rl,l),s(e,R,l),s(e,Sl,l),s(e,S,l),s(e,Yl,l),s(e,Y,l),s(e,Ql,l),s(e,Q,l),s(e,Fl,l),s(e,F,l),s(e,El,l),u(E,e,l),s(e,Hl,l),s(e,H,l),s(e,Ll,l),s(e,L,l),s(e,zl,l),s(e,z,l),s(e,ql,l),u(C,e,l),s(e,Al,l),u(q,e,l),s(e,Dl,l),u(A,e,l),s(e,Pl,l),s(e,D,l),s(e,Kl,l),s(e,P,l),s(e,Ol,l),u(K,e,l),s(e,et,l),s(e,Z,l),s(e,lt,l),u(O,e,l),s(e,tt,l),s(e,ee,l),s(e,st,l),u(le,e,l),s(e,nt,l),s(e,te,l),s(e,at,l),u(se,e,l),s(e,it,l),s(e,ne,l),s(e,pt,l),u(ae,e,l),s(e,mt,l),s(e,ie,l),s(e,ot,l),u(pe,e,l),s(e,rt,l),s(e,me,l),s(e,ut,l),u(oe,e,l),s(e,ct,l),s(e,re,l),s(e,Mt,l),u(ue,e,l),s(e,dt,l),s(e,ce,l),s(e,yt,l),s(e,Me,l),s(e,ht,l),u(de,e,l),s(e,bt,l),s(e,ye,l),s(e,ft,l),s(e,he,l),s(e,Jt,l),s(e,be,l),s(e,gt,l),s(e,fe,l),s(e,wt,l),u(Je,e,l),s(e,Tt,l),s(e,ge,l),s(e,Ut,l),s(e,we,l),s(e,jt,l),s(e,Te,l),s(e,Zt,l),u(Ue,e,l),s(e,Wt,l),u(je,e,l),s(e,It,l),s(e,Ze,l),s(e,Gt,l),u(We,e,l),s(e,Xt,l),s(e,W,l),s(e,Bt,l),u(Ie,e,l),s(e,Ct,l),s(e,Ge,l),s(e,Vt,l),u(Xe,e,l),s(e,_t,l),s(e,Be,l),s(e,vt,l),u(Ce,e,l),s(e,Nt,l),s(e,Ve,l),s(e,$t,l),u(_e,e,l),s(e,xt,l),s(e,ve,l),s(e,kt,l),u(Ne,e,l),s(e,Rt,l),s(e,$e,l),s(e,St,l),s(e,xe,l),s(e,Yt,l),u(ke,e,l),s(e,Qt,l),u(Re,e,l),s(e,Ft,l),s(e,I,l),s(e,Et,l),u(Se,e,l),s(e,Ht,l),u(Ye,e,l),s(e,Lt,l),s(e,Qe,l),s(e,zt,l),u(V,e,l),s(e,qt,l),u(Fe,e,l),s(e,At,l),s(e,Ee,l),s(e,Dt,l),s(e,He,l),s(e,Pt,l),s(e,Le,l),s(e,Kt,l),s(e,ze,l),s(e,Ot,l),u(qe,e,l),s(e,es,l),s(e,Ae,l),s(e,ls,l),u(De,e,l),s(e,ts,l),s(e,Pe,l),s(e,ss,l),u(Ke,e,l),s(e,ns,l),u(Oe,e,l),s(e,as,l),s(e,el,l),s(e,is,l),s(e,ll,l),s(e,ps,l),u(tl,e,l),s(e,ms,l),s(e,sl,l),s(e,os,l),u(nl,e,l),s(e,rs,l),u(al,e,l),s(e,us,l),s(e,il,l),s(e,cs,l),s(e,pl,l),s(e,Ms,l),s(e,ml,l),s(e,ds,l),s(e,ol,l),s(e,ys,l),u(rl,e,l),s(e,hs,l),u(ul,e,l),s(e,bs,l),u(cl,e,l),s(e,fs,l),s(e,Ml,l),s(e,Js,l),u(dl,e,l),s(e,gs,l),u(_,e,l),s(e,ws,l),u(yl,e,l),s(e,Ts,l),u(hl,e,l),s(e,Us,l),s(e,bl,l),s(e,js,l),u(fl,e,l),s(e,Zs,l),s(e,G,l),s(e,Ws,l),u(Jl,e,l),s(e,Is,l),s(e,gl,l),s(e,Gs,l),u(wl,e,l),s(e,Xs,l),s(e,Tl,l),s(e,Bs,l),s(e,Ul,l),s(e,Cs,l),u(jl,e,l),s(e,Vs,l),s(e,Zl,l),s(e,_s,l),u(Wl,e,l),s(e,vs,l),u(Il,e,l),s(e,Ns,l),s(e,Gl,l),s(e,$s,l),s(e,Xl,l),s(e,xs,l),u(Bl,e,l),s(e,ks,l),s(e,X,l),s(e,Rs,l),s(e,Cl,l),s(e,Ss,l),s(e,Vl,l),Ys=!0},p(e,[l]){const ea={};l&2&&(ea.$$scope={dirty:l,ctx:e}),C.$set(ea);const la={};l&2&&(la.$$scope={dirty:l,ctx:e}),V.$set(la);const ta={};l&2&&(ta.$$scope={dirty:l,ctx:e}),_.$set(ta)},i(e){Ys||(c(j.$$.fragment,e),c(U.$$.fragment,e),c(x.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(C.$$.fragment,e),c(q.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(We.$$.fragment,e),c(Ie.$$.fragment,e),c(Xe.$$.fragment,e),c(Ce.$$.fragment,e),c(_e.$$.fragment,e),c(Ne.$$.fragment,e),c(ke.$$.fragment,e),c(Re.$$.fragment,e),c(Se.$$.fragment,e),c(Ye.$$.fragment,e),c(V.$$.fragment,e),c(Fe.$$.fragment,e),c(qe.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(Oe.$$.fragment,e),c(tl.$$.fragment,e),c(nl.$$.fragment,e),c(al.$$.fragment,e),c(rl.$$.fragment,e),c(ul.$$.fragment,e),c(cl.$$.fragment,e),c(dl.$$.fragment,e),c(_.$$.fragment,e),c(yl.$$.fragment,e),c(hl.$$.fragment,e),c(fl.$$.fragment,e),c(Jl.$$.fragment,e),c(wl.$$.fragment,e),c(jl.$$.fragment,e),c(Wl.$$.fragment,e),c(Il.$$.fragment,e),c(Bl.$$.fragment,e),Ys=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M(x.$$.fragment,e),M(k.$$.fragment,e),M(E.$$.fragment,e),M(C.$$.fragment,e),M(q.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(ue.$$.fragment,e),M(de.$$.fragment,e),M(Je.$$.fragment,e),M(Ue.$$.fragment,e),M(je.$$.fragment,e),M(We.$$.fragment,e),M(Ie.$$.fragment,e),M(Xe.$$.fragment,e),M(Ce.$$.fragment,e),M(_e.$$.fragment,e),M(Ne.$$.fragment,e),M(ke.$$.fragment,e),M(Re.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(V.$$.fragment,e),M(Fe.$$.fragment,e),M(qe.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(Oe.$$.fragment,e),M(tl.$$.fragment,e),M(nl.$$.fragment,e),M(al.$$.fragment,e),M(rl.$$.fragment,e),M(ul.$$.fragment,e),M(cl.$$.fragment,e),M(dl.$$.fragment,e),M(_.$$.fragment,e),M(yl.$$.fragment,e),M(hl.$$.fragment,e),M(fl.$$.fragment,e),M(Jl.$$.fragment,e),M(wl.$$.fragment,e),M(jl.$$.fragment,e),M(Wl.$$.fragment,e),M(Il.$$.fragment,e),M(Bl.$$.fragment,e),Ys=!1},d(e){e&&(t(T),t(f),t(g),t(w),t(vl),t(v),t(Nl),t(N),t($l),t($),t(xl),t(kl),t(Rl),t(R),t(Sl),t(S),t(Yl),t(Y),t(Ql),t(Q),t(Fl),t(F),t(El),t(Hl),t(H),t(Ll),t(L),t(zl),t(z),t(ql),t(Al),t(Dl),t(Pl),t(D),t(Kl),t(P),t(Ol),t(et),t(Z),t(lt),t(tt),t(ee),t(st),t(nt),t(te),t(at),t(it),t(ne),t(pt),t(mt),t(ie),t(ot),t(rt),t(me),t(ut),t(ct),t(re),t(Mt),t(dt),t(ce),t(yt),t(Me),t(ht),t(bt),t(ye),t(ft),t(he),t(Jt),t(be),t(gt),t(fe),t(wt),t(Tt),t(ge),t(Ut),t(we),t(jt),t(Te),t(Zt),t(Wt),t(It),t(Ze),t(Gt),t(Xt),t(W),t(Bt),t(Ct),t(Ge),t(Vt),t(_t),t(Be),t(vt),t(Nt),t(Ve),t($t),t(xt),t(ve),t(kt),t(Rt),t($e),t(St),t(xe),t(Yt),t(Qt),t(Ft),t(I),t(Et),t(Ht),t(Lt),t(Qe),t(zt),t(qt),t(At),t(Ee),t(Dt),t(He),t(Pt),t(Le),t(Kt),t(ze),t(Ot),t(es),t(Ae),t(ls),t(ts),t(Pe),t(ss),t(ns),t(as),t(el),t(is),t(ll),t(ps),t(ms),t(sl),t(os),t(rs),t(us),t(il),t(cs),t(pl),t(Ms),t(ml),t(ds),t(ol),t(ys),t(hs),t(bs),t(fs),t(Ml),t(Js),t(gs),t(ws),t(Ts),t(Us),t(bl),t(js),t(Zs),t(G),t(Ws),t(Is),t(gl),t(Gs),t(Xs),t(Tl),t(Bs),t(Ul),t(Cs),t(Vs),t(Zl),t(_s),t(vs),t(Ns),t(Gl),t($s),t(Xl),t(xs),t(ks),t(X),t(Rs),t(Cl),t(Ss),t(Vl)),t(y),d(j,e),d(U,e),d(x,e),d(k,e),d(E,e),d(C,e),d(q,e),d(A,e),d(K,e),d(O,e),d(le,e),d(se,e),d(ae,e),d(pe,e),d(oe,e),d(ue,e),d(de,e),d(Je,e),d(Ue,e),d(je,e),d(We,e),d(Ie,e),d(Xe,e),d(Ce,e),d(_e,e),d(Ne,e),d(ke,e),d(Re,e),d(Se,e),d(Ye,e),d(V,e),d(Fe,e),d(qe,e),d(De,e),d(Ke,e),d(Oe,e),d(tl,e),d(nl,e),d(al,e),d(rl,e),d(ul,e),d(cl,e),d(dl,e),d(_,e),d(yl,e),d(hl,e),d(fl,e),d(Jl,e),d(wl,e),d(jl,e),d(Wl,e),d(Il,e),d(Bl,e)}}}const da='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3}],"depth":2},{"title":"ControlNet","local":"controlnet","sections":[{"title":"Compile ControlNet","local":"compile-controlnet","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function ya(B){return aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends ia{constructor(y){super(),pa(this,y,ya,Ma,na,{})}}export{wa as component};
