import{s as vt,o as Mt,n as Ne}from"../chunks/scheduler.25b97de1.js";import{S as kt,i as $t,g as c,s as r,r as g,A as Ct,h as p,f as o,c as i,j as ie,u as _,x as u,k as le,l as Pt,y as h,a,v as b,d as y,t as T,w}from"../chunks/index.d9030fc9.js";import{T as gt}from"../chunks/Tip.baa67368.js";import{D as Ie}from"../chunks/Docstring.e257edda.js";import{C as lt}from"../chunks/CodeBlock.e6cd0d95.js";import{F as xt,M as jt}from"../chunks/Markdown.7217f838.js";import{E as wt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Pe,E as zt}from"../chunks/EditOnGithub.91d95064.js";function Ut(k){let n,f="Phi-2 has been integrated in the development version (4.37.0.dev) of <code>transformers</code>. Until the official version is released through <code>pip</code>, ensure that you are doing one of the following:",s,d,v="<li><p>When loading the model, ensure that <code>trust_remote_code=True</code> is passed as an argument of the <code>from_pretrained()</code> function.</p></li> <li><p>Update your local <code>transformers</code> to the development version: <code>pip uninstall -y transformers &amp;&amp; pip install git+https://github.com/huggingface/transformers</code>. The previous command is an alternative to cloning and installing from the source.</p></li>";return{c(){n=c("p"),n.innerHTML=f,s=r(),d=c("ul"),d.innerHTML=v},l(l){n=p(l,"P",{"data-svelte-h":!0}),u(n)!=="svelte-o2znv2"&&(n.innerHTML=f),s=i(l),d=p(l,"UL",{"data-svelte-h":!0}),u(d)!=="svelte-1ysocqo"&&(d.innerHTML=v)},m(l,M){a(l,n,M),a(l,s,M),a(l,d,M)},p:Ne,d(l){l&&(o(n),o(s),o(d))}}}function Jt(k){let n,f="Example:",s,d,v;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaU1vZGVsJTJDJTIwUGhpQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBoaS0xJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBoaUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcGhpLTElMjIpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFBoaU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiModel, PhiConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Phi-1 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PhiConfig.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=f,s=r(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=f),s=i(l),_(d.$$.fragment,l)},m(l,M){a(l,n,M),a(l,s,M),b(d,l,M),v=!0},p:Ne,i(l){v||(y(d.$$.fragment,l),v=!0)},o(l){T(d.$$.fragment,l),v=!1},d(l){l&&(o(n),o(s)),w(d,l)}}}function It(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=f},l(s){n=p(s,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(s,d){a(s,n,d)},p:Ne,d(s){s&&o(n)}}}function Ft(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=f},l(s){n=p(s,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(s,d){a(s,n,d)},p:Ne,d(s){s&&o(n)}}}function Gt(k){let n,f="Example:",s,d,v;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGlGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwUGhpRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0xJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwZXhhbXBsZSUyMHNjcmlwdCUyMC4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhiForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;This is an example script .&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;This is an example script .\\n\\n\\n\\nfrom typing import List\\n\\ndef find_most_common_letter(words: List[str&#x27;</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=f,s=r(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=f),s=i(l),_(d.$$.fragment,l)},m(l,M){a(l,n,M),a(l,s,M),b(d,l,M),v=!0},p:Ne,i(l){v||(y(d.$$.fragment,l),v=!0)},o(l){T(d.$$.fragment,l),v=!1},d(l){l&&(o(n),o(s)),w(d,l)}}}function Zt(k){let n,f=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,s,d,v=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){n=c("p"),n.innerHTML=f,s=r(),d=c("p"),d.innerHTML=v},l(l){n=p(l,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1c5u34l"&&(n.innerHTML=f),s=i(l),d=p(l,"P",{"data-svelte-h":!0}),u(d)!=="svelte-fvlq1g"&&(d.innerHTML=v)},m(l,M){a(l,n,M),a(l,s,M),a(l,d,M)},p:Ne,d(l){l&&(o(n),o(s),o(d))}}}function Bt(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=f},l(s){n=p(s,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(s,d){a(s,n,d)},p:Ne,d(s){s&&o(n)}}}function Lt(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=f},l(s){n=p(s,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(s,d){a(s,n,d)},p:Ne,d(s){s&&o(n)}}}function Wt(k){let n,f="Example:",s,d,v;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGlGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZwaGktMSUyMiklMEFtb2RlbCUyMCUzRCUyMFBoaUZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0xJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhiForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=c("p"),n.textContent=f,s=r(),g(d.$$.fragment)},l(l){n=p(l,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=f),s=i(l),_(d.$$.fragment,l)},m(l,M){a(l,n,M),a(l,s,M),b(d,l,M),v=!0},p:Ne,i(l){v||(y(d.$$.fragment,l),v=!0)},o(l){T(d.$$.fragment,l),v=!1},d(l){l&&(o(n),o(s)),w(d,l)}}}function qt(k){let n,f,s,d,v,l,M=`The bare Phi Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Re,H,_t=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xe,N,bt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>PhiDecoderLayer</code>",Ee,P,ee,de,Fe,tt='The <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiModel">PhiModel</a> forward method, overrides the <code>__call__</code> special method.',ce,pe,Ge,B,nt,J,L,dt,z,W,ct,he,xe='The <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',pt,A,me,ue,Ae,x,te,fe,Ze,ot="Generates sequences of token ids for models with a language modeling head.",ge,O,Q,ne,oe,$,q,Oe,R,st="The PhiModel with a sequence classification head on top (linear layer).",_e,be,je=`<a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,ht,ye,ze=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Qe,X,yt=`This model inherits from <a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ye,E,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,De,j,se,Te,Be,at='The <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',we,ve,Le,I,rt,C,S,mt,Me,F=`PhiModel with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,ke,Ue,We=`This model inherits from <a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,Je,qe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,G,Z,Ke,V,it='The <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiForTokenClassification">PhiForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',$e,Y,Se,D,e;return n=new Pe({props:{title:"PhiModel",local:"transformers.PhiModel",headingTag:"h2"}}),d=new Ie({props:{name:"class transformers.PhiModel",anchor:"transformers.PhiModel",parameters:[{name:"config",val:": PhiConfig"}],parametersDescription:[{anchor:"transformers.PhiModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; PhiConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L915"}}),ee=new Ie({props:{name:"forward",anchor:"transformers.PhiModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PhiModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L952"}}),pe=new gt({props:{$$slots:{default:[It]},$$scope:{ctx:k}}}),B=new Pe({props:{title:"PhiForCausalLM",local:"transformers.PhiForCausalLM",headingTag:"h2"}}),L=new Ie({props:{name:"class transformers.PhiForCausalLM",anchor:"transformers.PhiForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1084"}}),W=new Ie({props:{name:"forward",anchor:"transformers.PhiForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PhiForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiConfig"
>PhiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new gt({props:{$$slots:{default:[Ft]},$$scope:{ctx:k}}}),ue=new wt({props:{anchor:"transformers.PhiForCausalLM.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:k}}}),te=new Ie({props:{name:"generate",anchor:"transformers.PhiForCausalLM.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhiForCausalLM.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.PhiForCausalLM.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/pr_30627/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_30627/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.PhiForCausalLM.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.PhiForCausalLM.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.PhiForCausalLM.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.PhiForCausalLM.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.PhiForCausalLM.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.PhiForCausalLM.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.PhiForCausalLM.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.PhiForCausalLM.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.PhiForCausalLM.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/generation/utils.py#L1531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),O=new gt({props:{warning:!0,$$slots:{default:[Zt]},$$scope:{ctx:k}}}),ne=new Pe({props:{title:"PhiForSequenceClassification",local:"transformers.PhiForSequenceClassification",headingTag:"h2"}}),q=new Ie({props:{name:"class transformers.PhiForSequenceClassification",anchor:"transformers.PhiForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PhiForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1276"}}),se=new Ie({props:{name:"forward",anchor:"transformers.PhiForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PhiForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhiForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1308"}}),ve=new gt({props:{$$slots:{default:[Bt]},$$scope:{ctx:k}}}),I=new Pe({props:{title:"PhiForTokenClassification",local:"transformers.PhiForTokenClassification",headingTag:"h2"}}),S=new Ie({props:{name:"class transformers.PhiForTokenClassification",anchor:"transformers.PhiForTokenClassification",parameters:[{name:"config",val:": PhiConfig"}],parametersDescription:[{anchor:"transformers.PhiForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1400"}}),Z=new Ie({props:{name:"forward",anchor:"transformers.PhiForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**deprecated_arguments",val:""}],parametersDescription:[{anchor:"transformers.PhiForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30627/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhiForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/modeling_phi.py#L1426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiConfig"
>PhiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30627/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new gt({props:{$$slots:{default:[Lt]},$$scope:{ctx:k}}}),D=new wt({props:{anchor:"transformers.PhiForTokenClassification.forward.example",$$slots:{default:[Wt]},$$scope:{ctx:k}}}),{c(){g(n.$$.fragment),f=r(),s=c("div"),g(d.$$.fragment),v=r(),l=c("p"),l.innerHTML=M,Re=r(),H=c("p"),H.innerHTML=_t,Xe=r(),N=c("p"),N.innerHTML=bt,Ee=r(),P=c("div"),g(ee.$$.fragment),de=r(),Fe=c("p"),Fe.innerHTML=tt,ce=r(),g(pe.$$.fragment),Ge=r(),g(B.$$.fragment),nt=r(),J=c("div"),g(L.$$.fragment),dt=r(),z=c("div"),g(W.$$.fragment),ct=r(),he=c("p"),he.innerHTML=xe,pt=r(),g(A.$$.fragment),me=r(),g(ue.$$.fragment),Ae=r(),x=c("div"),g(te.$$.fragment),fe=r(),Ze=c("p"),Ze.textContent=ot,ge=r(),g(O.$$.fragment),Q=r(),g(ne.$$.fragment),oe=r(),$=c("div"),g(q.$$.fragment),Oe=r(),R=c("p"),R.textContent=st,_e=r(),be=c("p"),be.innerHTML=je,ht=r(),ye=c("p"),ye.innerHTML=ze,Qe=r(),X=c("p"),X.innerHTML=yt,Ye=r(),E=c("p"),E.innerHTML=Tt,De=r(),j=c("div"),g(se.$$.fragment),Te=r(),Be=c("p"),Be.innerHTML=at,we=r(),g(ve.$$.fragment),Le=r(),g(I.$$.fragment),rt=r(),C=c("div"),g(S.$$.fragment),mt=r(),Me=c("p"),Me.textContent=F,ke=r(),Ue=c("p"),Ue.innerHTML=We,ut=r(),Je=c("p"),Je.innerHTML=qe,ft=r(),G=c("div"),g(Z.$$.fragment),Ke=r(),V=c("p"),V.innerHTML=it,$e=r(),g(Y.$$.fragment),Se=r(),g(D.$$.fragment),this.h()},l(t){_(n.$$.fragment,t),f=i(t),s=p(t,"DIV",{class:!0});var m=ie(s);_(d.$$.fragment,m),v=i(m),l=p(m,"P",{"data-svelte-h":!0}),u(l)!=="svelte-c56n3h"&&(l.innerHTML=M),Re=i(m),H=p(m,"P",{"data-svelte-h":!0}),u(H)!=="svelte-hswkmf"&&(H.innerHTML=_t),Xe=i(m),N=p(m,"P",{"data-svelte-h":!0}),u(N)!=="svelte-9ccchq"&&(N.innerHTML=bt),Ee=i(m),P=p(m,"DIV",{class:!0});var ae=ie(P);_(ee.$$.fragment,ae),de=i(ae),Fe=p(ae,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-v8159c"&&(Fe.innerHTML=tt),ce=i(ae),_(pe.$$.fragment,ae),ae.forEach(o),m.forEach(o),Ge=i(t),_(B.$$.fragment,t),nt=i(t),J=p(t,"DIV",{class:!0});var re=ie(J);_(L.$$.fragment,re),dt=i(re),z=p(re,"DIV",{class:!0});var Ce=ie(z);_(W.$$.fragment,Ce),ct=i(Ce),he=p(Ce,"P",{"data-svelte-h":!0}),u(he)!=="svelte-h8h3e0"&&(he.innerHTML=xe),pt=i(Ce),_(A.$$.fragment,Ce),me=i(Ce),_(ue.$$.fragment,Ce),Ce.forEach(o),Ae=i(re),x=p(re,"DIV",{class:!0});var Ve=ie(x);_(te.$$.fragment,Ve),fe=i(Ve),Ze=p(Ve,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-s5ko3x"&&(Ze.textContent=ot),ge=i(Ve),_(O.$$.fragment,Ve),Ve.forEach(o),re.forEach(o),Q=i(t),_(ne.$$.fragment,t),oe=i(t),$=p(t,"DIV",{class:!0});var U=ie($);_(q.$$.fragment,U),Oe=i(U),R=p(U,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1ei5ef0"&&(R.textContent=st),_e=i(U),be=p(U,"P",{"data-svelte-h":!0}),u(be)!=="svelte-evwvzb"&&(be.innerHTML=je),ht=i(U),ye=p(U,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-10ugs3m"&&(ye.innerHTML=ze),Qe=i(U),X=p(U,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1h6rjuc"&&(X.innerHTML=yt),Ye=i(U),E=p(U,"P",{"data-svelte-h":!0}),u(E)!=="svelte-hswkmf"&&(E.innerHTML=Tt),De=i(U),j=p(U,"DIV",{class:!0});var He=ie(j);_(se.$$.fragment,He),Te=i(He),Be=p(He,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-qs04ku"&&(Be.innerHTML=at),we=i(He),_(ve.$$.fragment,He),He.forEach(o),U.forEach(o),Le=i(t),_(I.$$.fragment,t),rt=i(t),C=p(t,"DIV",{class:!0});var K=ie(C);_(S.$$.fragment,K),mt=i(K),Me=p(K,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-mycuhq"&&(Me.textContent=F),ke=i(K),Ue=p(K,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1h6rjuc"&&(Ue.innerHTML=We),ut=i(K),Je=p(K,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-hswkmf"&&(Je.innerHTML=qe),ft=i(K),G=p(K,"DIV",{class:!0});var et=ie(G);_(Z.$$.fragment,et),Ke=i(et),V=p(et,"P",{"data-svelte-h":!0}),u(V)!=="svelte-hii1d4"&&(V.innerHTML=it),$e=i(et),_(Y.$$.fragment,et),Se=i(et),_(D.$$.fragment,et),et.forEach(o),K.forEach(o),this.h()},h(){le(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,m){b(n,t,m),a(t,f,m),a(t,s,m),b(d,s,null),h(s,v),h(s,l),h(s,Re),h(s,H),h(s,Xe),h(s,N),h(s,Ee),h(s,P),b(ee,P,null),h(P,de),h(P,Fe),h(P,ce),b(pe,P,null),a(t,Ge,m),b(B,t,m),a(t,nt,m),a(t,J,m),b(L,J,null),h(J,dt),h(J,z),b(W,z,null),h(z,ct),h(z,he),h(z,pt),b(A,z,null),h(z,me),b(ue,z,null),h(J,Ae),h(J,x),b(te,x,null),h(x,fe),h(x,Ze),h(x,ge),b(O,x,null),a(t,Q,m),b(ne,t,m),a(t,oe,m),a(t,$,m),b(q,$,null),h($,Oe),h($,R),h($,_e),h($,be),h($,ht),h($,ye),h($,Qe),h($,X),h($,Ye),h($,E),h($,De),h($,j),b(se,j,null),h(j,Te),h(j,Be),h(j,we),b(ve,j,null),a(t,Le,m),b(I,t,m),a(t,rt,m),a(t,C,m),b(S,C,null),h(C,mt),h(C,Me),h(C,ke),h(C,Ue),h(C,ut),h(C,Je),h(C,ft),h(C,G),b(Z,G,null),h(G,Ke),h(G,V),h(G,$e),b(Y,G,null),h(G,Se),b(D,G,null),e=!0},p(t,m){const ae={};m&2&&(ae.$$scope={dirty:m,ctx:t}),pe.$set(ae);const re={};m&2&&(re.$$scope={dirty:m,ctx:t}),A.$set(re);const Ce={};m&2&&(Ce.$$scope={dirty:m,ctx:t}),ue.$set(Ce);const Ve={};m&2&&(Ve.$$scope={dirty:m,ctx:t}),O.$set(Ve);const U={};m&2&&(U.$$scope={dirty:m,ctx:t}),ve.$set(U);const He={};m&2&&(He.$$scope={dirty:m,ctx:t}),Y.$set(He);const K={};m&2&&(K.$$scope={dirty:m,ctx:t}),D.$set(K)},i(t){e||(y(n.$$.fragment,t),y(d.$$.fragment,t),y(ee.$$.fragment,t),y(pe.$$.fragment,t),y(B.$$.fragment,t),y(L.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(ue.$$.fragment,t),y(te.$$.fragment,t),y(O.$$.fragment,t),y(ne.$$.fragment,t),y(q.$$.fragment,t),y(se.$$.fragment,t),y(ve.$$.fragment,t),y(I.$$.fragment,t),y(S.$$.fragment,t),y(Z.$$.fragment,t),y(Y.$$.fragment,t),y(D.$$.fragment,t),e=!0)},o(t){T(n.$$.fragment,t),T(d.$$.fragment,t),T(ee.$$.fragment,t),T(pe.$$.fragment,t),T(B.$$.fragment,t),T(L.$$.fragment,t),T(W.$$.fragment,t),T(A.$$.fragment,t),T(ue.$$.fragment,t),T(te.$$.fragment,t),T(O.$$.fragment,t),T(ne.$$.fragment,t),T(q.$$.fragment,t),T(se.$$.fragment,t),T(ve.$$.fragment,t),T(I.$$.fragment,t),T(S.$$.fragment,t),T(Z.$$.fragment,t),T(Y.$$.fragment,t),T(D.$$.fragment,t),e=!1},d(t){t&&(o(f),o(s),o(Ge),o(nt),o(J),o(Q),o(oe),o($),o(Le),o(rt),o(C)),w(n,t),w(d),w(ee),w(pe),w(B,t),w(L),w(W),w(A),w(ue),w(te),w(O),w(ne,t),w(q),w(se),w(ve),w(I,t),w(S),w(Z),w(Y),w(D)}}}function St(k){let n,f;return n=new jt({props:{$$slots:{default:[qt]},$$scope:{ctx:k}}}),{c(){g(n.$$.fragment)},l(s){_(n.$$.fragment,s)},m(s,d){b(n,s,d),f=!0},p(s,d){const v={};d&2&&(v.$$scope={dirty:d,ctx:s}),n.$set(v)},i(s){f||(y(n.$$.fragment,s),f=!0)},o(s){T(n.$$.fragment,s),f=!1},d(s){w(n,s)}}}function Vt(k){let n,f,s,d,v,l,M,Re,H,_t='The Phi-1 model was proposed in <a href="https://arxiv.org/abs/2306.11644" rel="nofollow">Textbooks Are All You Need</a> by Suriya Gunasekar, Yi Zhang, Jyoti Aneja, Caio César Teodoro Mendes, Allie Del Giorno, Sivakanth Gopi, Mojan Javaheripi, Piero Kauffmann, Gustavo de Rosa, Olli Saarikivi, Adil Salim, Shital Shah, Harkirat Singh Behl, Xin Wang, Sébastien Bubeck, Ronen Eldan, Adam Tauman Kalai, Yin Tat Lee and Yuanzhi Li.',Xe,N,bt='The Phi-1.5 model was proposed in <a href="https://arxiv.org/abs/2309.05463" rel="nofollow">Textbooks Are All You Need II: phi-1.5 technical report</a> by Yuanzhi Li, Sébastien Bubeck, Ronen Eldan, Allie Del Giorno, Suriya Gunasekar and Yin Tat Lee.',Ee,P,ee,de,Fe=`In Phi-1 and Phi-1.5 papers, the authors showed how important the quality of the data is in training relative to the model size.
They selected high quality “textbook” data alongside with synthetically generated data for training their small sized Transformer
based model Phi-1 with 1.3B parameters. Despite this small scale, phi-1 attains pass@1 accuracy 50.6% on HumanEval and 55.5% on MBPP.
They follow the same strategy for Phi-1.5 and created another 1.3B parameter model with performance on natural language tasks comparable
to models 5x larger, and surpassing most non-frontier LLMs. Phi-1.5 exhibits many of the traits of much larger LLMs such as the ability
to “think step by step” or perform some rudimentary in-context learning.
With these two experiments the authors successfully showed the huge impact of quality of training data when training machine learning models.`,tt,ce,pe="The abstract from the Phi-1 paper is the following:",Ge,B,nt=`<em>We introduce phi-1, a new large language model for code, with significantly smaller size than
competing models: phi-1 is a Transformer-based model with 1.3B parameters, trained for 4 days on
8 A100s, using a selection of “textbook quality” data from the web (6B tokens) and synthetically
generated textbooks and exercises with GPT-3.5 (1B tokens). Despite this small scale, phi-1 attains
pass@1 accuracy 50.6% on HumanEval and 55.5% on MBPP. It also displays surprising emergent
properties compared to phi-1-base, our model before our finetuning stage on a dataset of coding
exercises, and phi-1-small, a smaller model with 350M parameters trained with the same pipeline as
phi-1 that still achieves 45% on HumanEval.</em>`,J,L,dt="The abstract from the Phi-1.5 paper is the following:",z,W,ct=`<em>We continue the investigation into the power of smaller Transformer-based language models as
initiated by TinyStories – a 10 million parameter model that can produce coherent English – and
the follow-up work on phi-1, a 1.3 billion parameter model with Python coding performance close
to the state-of-the-art. The latter work proposed to use existing Large Language Models (LLMs) to
generate “textbook quality” data as a way to enhance the learning process compared to traditional
web data. We follow the “Textbooks Are All You Need” approach, focusing this time on common
sense reasoning in natural language, and create a new 1.3 billion parameter model named phi-1.5,
with performance on natural language tasks comparable to models 5x larger, and surpassing most
non-frontier LLMs on more complex reasoning tasks such as grade-school mathematics and basic
coding. More generally, phi-1.5 exhibits many of the traits of much larger LLMs, both good –such
as the ability to “think step by step” or perform some rudimentary in-context learning– and bad,
including hallucinations and the potential for toxic and biased generations –encouragingly though, we
are seeing improvement on that front thanks to the absence of web data. We open-source phi-1.5 to
promote further research on these urgent topics.</em>`,he,xe,pt='This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>.',A,me,ue='The original code for Phi-1, Phi-1.5 and Phi-2 can be found <a href="https://huggingface.co/microsoft/phi-1" rel="nofollow">here</a>, <a href="https://huggingface.co/microsoft/phi-1_5" rel="nofollow">here</a> and <a href="https://huggingface.co/microsoft/phi-2" rel="nofollow">here</a>, respectively.',Ae,x,te,fe,Ze='<li>This model is quite similar to <code>Llama</code> with the main difference in <code>PhiDecoderLayer</code>, where they used <code>PhiAttention</code> and <code>PhiMLP</code> layers in parallel configuration.</li> <li>The tokenizer used for this model is identical to the <a href="/docs/transformers/pr_30627/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a>.</li>',ot,ge,O,Q,ne,oe,$,q,Oe,R,st,_e,be,je,ht="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",ye,ze,Qe,X,yt="Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of flash-attn repository. Make also sure to load your model in half-precision (e.g. `torch.float16“)",Ye,E,Tt="To load and run a model using Flash Attention 2, refer to the snippet below:",De,j,se,Te,Be="### Expected speedups",at,we,ve="Below is an expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>microsoft/phi-1</code> checkpoint and the Flash Attention 2 version of the model using a sequence length of 2048.",Le,I,rt='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/phi_1_speedup_plot.jpg"/>',C,S,mt="## PhiConfig[[transformers.PhiConfig]]",Me,F,ke,Ue,We,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiModel">PhiModel</a>. It is used to instantiate an Phi
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Phi
<a href="https://huggingface.co/microsoft/phi-1" rel="nofollow">microsoft/phi-1</a>.`,Je,qe,ft=`Configuration objects inherit from <a href="/docs/transformers/pr_30627/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30627/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,G,Z,Ke,V,it,$e,Y,Se,D;return v=new Pe({props:{title:"Phi",local:"phi",headingTag:"h1"}}),M=new Pe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),P=new Pe({props:{title:"Summary",local:"summary",headingTag:"h3"}}),x=new Pe({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ge=new Pe({props:{title:"How to use Phi-2",local:"how-to-use-phi-2",headingTag:"h2"}}),Q=new gt({props:{warning:!0,$$slots:{default:[Ut]},$$scope:{ctx:k}}}),oe=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcignQ2FuJTIweW91JTIwaGVscCUyMG1lJTIwd3JpdGUlMjBhJTIwZm9ybWFsJTIwZW1haWwlMjB0byUyMGElMjBwb3RlbnRpYWwlMjBidXNpbmVzcyUyMHBhcnRuZXIlMjBwcm9wb3NpbmclMjBhJTIwam9pbnQlMjB2ZW50dXJlJTNGJyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdGV4dCUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEJTBBcHJpbnQodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&#x27;Can you help me write a formal email to a potential business partner proposing a joint venture?&#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_attention_mask=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(text)
Can you <span class="hljs-built_in">help</span> me write a formal email to a potential business partner proposing a joint venture?
Input: Company A: ABC Inc.
Company B`,wrap:!1}}),q=new Pe({props:{title:"Example :",local:"example-",headingTag:"h3"}}),R=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaUZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyLiUwQW1vZGVsJTIwJTNEJTIwUGhpRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0xXzUlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcGhpLTFfNSUyMiklMEElMEElMjMlMjBmZWVsJTIwZnJlZSUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwcHJvbXB0JTIwdG8lMjB5b3VyJTIwbGlraW5nLiUwQXByb21wdCUyMCUzRCUyMCUyMklmJTIwSSUyMHdlcmUlMjBhbiUyMEFJJTIwdGhhdCUyMGhhZCUyMGp1c3QlMjBhY2hpZXZlZCUyMiUwQSUwQSUyMyUyMGFwcGx5JTIwdGhlJTIwdG9rZW5pemVyLiUwQXRva2VucyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMHVzZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMG5ldyUyMHRva2Vucy4lMEFnZW5lcmF0ZWRfb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip0b2tlbnMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9vdXRwdXQpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the model and tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1_5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1_5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the prompt to your liking.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I were an AI that had just achieved&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use the model to generate new tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_output = model.generate(**tokens, use_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_output)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;If I were an AI that had just achieved a breakthrough in machine learning, I would be thrilled&#x27;</span>`,wrap:!1}}),_e=new Pe({props:{title:"Combining Phi and Flash Attention 2",local:"combining-phi-and-flash-attention-2",headingTag:"h2"}}),ze=new lt({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),j=new lt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwUGhpRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTIzJTIwZGVmaW5lJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMjBhbmQlMjBwdXNoJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbnMlMjB0byUyMHRoZSUyMEdQVS4lMEFtb2RlbCUyMCUzRCUyMFBoaUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZwaGktMV81JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKS50byglMjJjdWRhJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0xXzUlMjIpJTBBJTBBJTIzJTIwZmVlbCUyMGZyZWUlMjB0byUyMGNoYW5nZSUyMHRoZSUyMHByb21wdCUyMHRvJTIweW91ciUyMGxpa2luZy4lMEFwcm9tcHQlMjAlM0QlMjAlMjJJZiUyMEklMjB3ZXJlJTIwYW4lMjBBSSUyMHRoYXQlMjBoYWQlMjBqdXN0JTIwYWNoaWV2ZWQlMjIlMEElMEElMjMlMjBhcHBseSUyMHRoZSUyMHRva2VuaXplci4lMEF0b2tlbnMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjB1c2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBuZXclMjB0b2tlbnMuJTBBZ2VuZXJhdGVkX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdG9rZW5zJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfb3V0cHV0KSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the model and tokenizer and push the model and tokens to the GPU.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1_5&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-1_5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the prompt to your liking.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I were an AI that had just achieved&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use the model to generate new tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_output = model.generate(**tokens, use_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_output)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;If I were an AI that had just achieved a breakthrough in machine learning, I would be thrilled&#x27;</span>`,wrap:!1}}),ke=new Ie({props:{name:"class transformers.PhiConfig",anchor:"transformers.PhiConfig",parameters:[{name:"vocab_size",val:" = 51200"},{name:"hidden_size",val:" = 2048"},{name:"intermediate_size",val:" = 8192"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"resid_pdrop",val:" = 0.0"},{name:"embd_pdrop",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'gelu_new'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"qk_layernorm",val:" = False"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhiConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 51200) &#x2014;
Vocabulary size of the Phi model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30627/en/model_doc/phi#transformers.PhiModel">PhiModel</a>.`,name:"vocab_size"},{anchor:"transformers.PhiConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PhiConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PhiConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.PhiConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.PhiConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.PhiConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for mlp outputs.`,name:"resid_pdrop"},{anchor:"transformers.PhiConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.PhiConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.PhiConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_new&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PhiConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Phi-1 and Phi-1.5 supports up to 2048
tokens.`,name:"max_position_embeddings"},{anchor:"transformers.PhiConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PhiConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PhiConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings or not.`,name:"use_cache"},{anchor:"transformers.PhiConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.PhiConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PhiConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be an float greater than 1. The expected format
is <code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalPersimmon/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalPersimmon/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This
is an experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.PhiConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.PhiConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states.`,name:"qk_layernorm"},{anchor:"transformers.PhiConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Denotes beginning of sequences token id.`,name:"bos_token_id"},{anchor:"transformers.PhiConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Denotes end of sequences token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/phi/configuration_phi.py#L25"}}),Z=new wt({props:{anchor:"transformers.PhiConfig.example",$$slots:{default:[Jt]},$$scope:{ctx:k}}}),V=new xt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[St]},$$scope:{ctx:k}}}),$e=new zt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/phi.md"}}),{c(){n=c("meta"),f=r(),s=c("p"),d=r(),g(v.$$.fragment),l=r(),g(M.$$.fragment),Re=r(),H=c("p"),H.innerHTML=_t,Xe=r(),N=c("p"),N.innerHTML=bt,Ee=r(),g(P.$$.fragment),ee=r(),de=c("p"),de.textContent=Fe,tt=r(),ce=c("p"),ce.textContent=pe,Ge=r(),B=c("p"),B.innerHTML=nt,J=r(),L=c("p"),L.textContent=dt,z=r(),W=c("p"),W.innerHTML=ct,he=r(),xe=c("p"),xe.innerHTML=pt,A=r(),me=c("p"),me.innerHTML=ue,Ae=r(),g(x.$$.fragment),te=r(),fe=c("ul"),fe.innerHTML=Ze,ot=r(),g(ge.$$.fragment),O=r(),g(Q.$$.fragment),ne=r(),g(oe.$$.fragment),$=r(),g(q.$$.fragment),Oe=r(),g(R.$$.fragment),st=r(),g(_e.$$.fragment),be=r(),je=c("p"),je.textContent=ht,ye=r(),g(ze.$$.fragment),Qe=r(),X=c("p"),X.textContent=yt,Ye=r(),E=c("p"),E.textContent=Tt,De=r(),g(j.$$.fragment),se=r(),Te=c("p"),Te.textContent=Be,at=r(),we=c("p"),we.innerHTML=ve,Le=r(),I=c("div"),I.innerHTML=rt,C=r(),S=c("p"),S.textContent=mt,Me=r(),F=c("div"),g(ke.$$.fragment),Ue=r(),We=c("p"),We.innerHTML=ut,Je=r(),qe=c("p"),qe.innerHTML=ft,G=r(),g(Z.$$.fragment),Ke=r(),g(V.$$.fragment),it=r(),g($e.$$.fragment),Y=r(),Se=c("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(o),f=i(e),s=p(e,"P",{}),ie(s).forEach(o),d=i(e),_(v.$$.fragment,e),l=i(e),_(M.$$.fragment,e),Re=i(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1yhjn85"&&(H.innerHTML=_t),Xe=i(e),N=p(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1fvv6h4"&&(N.innerHTML=bt),Ee=i(e),_(P.$$.fragment,e),ee=i(e),de=p(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-x3eyc9"&&(de.textContent=Fe),tt=i(e),ce=p(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-tgcdxr"&&(ce.textContent=pe),Ge=i(e),B=p(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-187tpcl"&&(B.innerHTML=nt),J=i(e),L=p(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-10n16wm"&&(L.textContent=dt),z=i(e),W=p(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1wjkxlu"&&(W.innerHTML=ct),he=i(e),xe=p(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1xwsyyw"&&(xe.innerHTML=pt),A=i(e),me=p(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-n44v4x"&&(me.innerHTML=ue),Ae=i(e),_(x.$$.fragment,e),te=i(e),fe=p(e,"UL",{"data-svelte-h":!0}),u(fe)!=="svelte-1rh0cj2"&&(fe.innerHTML=Ze),ot=i(e),_(ge.$$.fragment,e),O=i(e),_(Q.$$.fragment,e),ne=i(e),_(oe.$$.fragment,e),$=i(e),_(q.$$.fragment,e),Oe=i(e),_(R.$$.fragment,e),st=i(e),_(_e.$$.fragment,e),be=i(e),je=p(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-o3pzzu"&&(je.textContent=ht),ye=i(e),_(ze.$$.fragment,e),Qe=i(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-enej3y"&&(X.textContent=yt),Ye=i(e),E=p(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-14hchid"&&(E.textContent=Tt),De=i(e),_(j.$$.fragment,e),se=i(e),Te=p(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1dwgw8m"&&(Te.textContent=Be),at=i(e),we=p(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-myov30"&&(we.innerHTML=ve),Le=i(e),I=p(e,"DIV",{style:!0,"data-svelte-h":!0}),u(I)!=="svelte-1kvqy0w"&&(I.innerHTML=rt),C=i(e),S=p(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-12ob0i4"&&(S.textContent=mt),Me=i(e),F=p(e,"DIV",{class:!0});var m=ie(F);_(ke.$$.fragment,m),Ue=i(m),We=p(m,"P",{"data-svelte-h":!0}),u(We)!=="svelte-1gust5z"&&(We.innerHTML=ut),Je=i(m),qe=p(m,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-1o9wyr7"&&(qe.innerHTML=ft),G=i(m),_(Z.$$.fragment,m),m.forEach(o),Ke=i(e),_(V.$$.fragment,e),it=i(e),_($e.$$.fragment,e),Y=i(e),Se=p(e,"P",{}),ie(Se).forEach(o),this.h()},h(){le(n,"name","hf:doc:metadata"),le(n,"content",Ht),Pt(I,"text-align","center"),le(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){h(document.head,n),a(e,f,t),a(e,s,t),a(e,d,t),b(v,e,t),a(e,l,t),b(M,e,t),a(e,Re,t),a(e,H,t),a(e,Xe,t),a(e,N,t),a(e,Ee,t),b(P,e,t),a(e,ee,t),a(e,de,t),a(e,tt,t),a(e,ce,t),a(e,Ge,t),a(e,B,t),a(e,J,t),a(e,L,t),a(e,z,t),a(e,W,t),a(e,he,t),a(e,xe,t),a(e,A,t),a(e,me,t),a(e,Ae,t),b(x,e,t),a(e,te,t),a(e,fe,t),a(e,ot,t),b(ge,e,t),a(e,O,t),b(Q,e,t),a(e,ne,t),b(oe,e,t),a(e,$,t),b(q,e,t),a(e,Oe,t),b(R,e,t),a(e,st,t),b(_e,e,t),a(e,be,t),a(e,je,t),a(e,ye,t),b(ze,e,t),a(e,Qe,t),a(e,X,t),a(e,Ye,t),a(e,E,t),a(e,De,t),b(j,e,t),a(e,se,t),a(e,Te,t),a(e,at,t),a(e,we,t),a(e,Le,t),a(e,I,t),a(e,C,t),a(e,S,t),a(e,Me,t),a(e,F,t),b(ke,F,null),h(F,Ue),h(F,We),h(F,Je),h(F,qe),h(F,G),b(Z,F,null),a(e,Ke,t),b(V,e,t),a(e,it,t),b($e,e,t),a(e,Y,t),a(e,Se,t),D=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),Q.$set(m);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:e}),Z.$set(ae);const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),V.$set(re)},i(e){D||(y(v.$$.fragment,e),y(M.$$.fragment,e),y(P.$$.fragment,e),y(x.$$.fragment,e),y(ge.$$.fragment,e),y(Q.$$.fragment,e),y(oe.$$.fragment,e),y(q.$$.fragment,e),y(R.$$.fragment,e),y(_e.$$.fragment,e),y(ze.$$.fragment,e),y(j.$$.fragment,e),y(ke.$$.fragment,e),y(Z.$$.fragment,e),y(V.$$.fragment,e),y($e.$$.fragment,e),D=!0)},o(e){T(v.$$.fragment,e),T(M.$$.fragment,e),T(P.$$.fragment,e),T(x.$$.fragment,e),T(ge.$$.fragment,e),T(Q.$$.fragment,e),T(oe.$$.fragment,e),T(q.$$.fragment,e),T(R.$$.fragment,e),T(_e.$$.fragment,e),T(ze.$$.fragment,e),T(j.$$.fragment,e),T(ke.$$.fragment,e),T(Z.$$.fragment,e),T(V.$$.fragment,e),T($e.$$.fragment,e),D=!1},d(e){e&&(o(f),o(s),o(d),o(l),o(Re),o(H),o(Xe),o(N),o(Ee),o(ee),o(de),o(tt),o(ce),o(Ge),o(B),o(J),o(L),o(z),o(W),o(he),o(xe),o(A),o(me),o(Ae),o(te),o(fe),o(ot),o(O),o(ne),o($),o(Oe),o(st),o(be),o(je),o(ye),o(Qe),o(X),o(Ye),o(E),o(De),o(se),o(Te),o(at),o(we),o(Le),o(I),o(C),o(S),o(Me),o(F),o(Ke),o(it),o(Y),o(Se)),o(n),w(v,e),w(M,e),w(P,e),w(x,e),w(ge,e),w(Q,e),w(oe,e),w(q,e),w(R,e),w(_e,e),w(ze,e),w(j,e),w(ke),w(Z),w(V,e),w($e,e)}}}const Ht='{"title":"Phi","local":"phi","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"How to use Phi-2","local":"how-to-use-phi-2","sections":[{"title":"Example :","local":"example-","sections":[],"depth":3}],"depth":2},{"title":"Combining Phi and Flash Attention 2","local":"combining-phi-and-flash-attention-2","sections":[],"depth":2},{"title":"PhiModel","local":"transformers.PhiModel","sections":[],"depth":2},{"title":"PhiForCausalLM","local":"transformers.PhiForCausalLM","sections":[],"depth":2},{"title":"PhiForSequenceClassification","local":"transformers.PhiForSequenceClassification","sections":[],"depth":2},{"title":"PhiForTokenClassification","local":"transformers.PhiForTokenClassification","sections":[],"depth":2}],"depth":1}';function Nt(k){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends kt{constructor(n){super(),$t(this,n,Nt,Vt,vt,{})}}export{Kt as component};
