import{s as yl,o as Jl,n as wl}from"../chunks/scheduler.987d3921.js";import{S as Tl,i as vl,g as i,s as a,r as o,A as $l,h as p,f as t,c as n,j as bl,u,x as r,k as vt,y as Ul,a as l,v as c,d as m,t as d,w as h,m as Zl,n as Il}from"../chunks/index.c8b1fed4.js";import{T as $t}from"../chunks/Tip.6bc1e794.js";import{C as f}from"../chunks/CodeBlock.18094d58.js";import{H as y,E as xl}from"../chunks/EditOnGithub.a3fde557.js";function Gl(v){let M,b="Consultez la documentation du <code>pipeline()</code> pour une liste complète des tâches prises en charge et des paramètres disponibles.";return{c(){M=i("p"),M.innerHTML=b},l(j){M=p(j,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1bbt0n6"&&(M.innerHTML=b)},m(j,w){l(j,M,w)},p:wl,d(j){j&&t(M)}}}function Bl(v){let M;return{c(){M=Zl("Créer un moteur d'inférence est un sujet complexe qui mérite sa propre page.")},l(b){M=Il(b,"Créer un moteur d'inférence est un sujet complexe qui mérite sa propre page.")},m(b,j){l(b,M,j)},d(b){b&&t(M)}}}function kl(v){let M,b='Pour exécuter l’exemple ci-dessus, vous devez avoir <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installé en plus de 🤗 Transformers :',j,w,J;return w=new f({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){M=i("p"),M.innerHTML=b,j=a(),o(w.$$.fragment)},l(g){M=p(g,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1c5b3uo"&&(M.innerHTML=b),j=n(g),u(w.$$.fragment,g)},m(g,T){l(g,M,T),l(g,j,T),c(w,g,T),J=!0},p:wl,i(g){J||(m(w.$$.fragment,g),J=!0)},o(g){d(w.$$.fragment,g),J=!1},d(g){g&&(t(M),t(j)),h(w,g)}}}function ql(v){let M,b,j,w,J,g,T,Ut='L’objet <code>pipeline()</code> rend simple l’utilisation de n’importe quel modèle du <a href="https://huggingface.co/models" rel="nofollow">Hub</a> pour l’inférence sur n’importe quelle langue, tâches de vision par ordinateur, d’audio et multimodales. Même si vous n’avez pas d’expérience avec une modalité spécifique ou si vous n’êtes pas familier avec le code ci-dessous des modèles, vous pouvez toujours les utiliser pour l’inférence avec la <code>pipeline()</code> ! Ce tutoriel vous apprendra à :',De,x,Zt="<li>Utiliser un <code>pipeline()</code> pour l’inférence.</li> <li>Utiliser un tokenizer ou modèle spécifique.</li> <li>Utiliser un <code>pipeline()</code> pour des tâches audio, de vision et multimodales.</li>",Ke,$,Oe,G,es,B,It="Bien que chaque tâche ait son propre <code>pipeline()</code>, il est plus simple d’utiliser le <code>pipeline()</code> générale qui inclut tous les pipelines spécifiques aux différentes tâches. Cette approche charge automatiquement un modèle par défaut et une classe de prétraitement adaptée à votre tâche, simplifiant ainsi votre utilisation. Prenons l’exemple de l’utilisation du <code>pipeline()</code> pour la reconnaissance automatique de la parole (ASR) ou de la transcription de la parole en texte.",ss,k,xt="<li>Commencez par créer un <code>pipeline()</code> et spécifiez la tâche d’inférence :</li>",ts,q,ls,U,Gt="<li>Passez votre entrée au <code>pipeline()</code>. Dans le cas de la reconnaissance vocale, il s’agit d’un fichier audio :</li>",as,C,ns,W,Bt=`Pas le résultat que vous aviez en tête ? Consultez certains des <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">modèles de reconnaissance vocale automatique les plus téléchargés</a>
sur le Hub pour voir si vous pouvez obtenir une meilleure transcription.`,is,z,kt='Essayons le modèle <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> de OpenAI. Whisper a été publié 2 ans après Wav2Vec2 et a été entraîné sur près de 10 fois plus de données. En tant que tel, il surpasse Wav2Vec2 sur la plupart des benchmarks en aval. Il a également l’avantage supplémentaire de prédire la ponctuation et la casse, ce qui n’est pas possible avec Wav2Vec2.',ps,X,qt="Essayons-le ici pour voir comment il fonctionne :",rs,H,os,R,Ct=`Maintenant, ce résultat semble plus précis ! Pour une comparaison approfondie entre Wav2Vec2 et Whisper, consultez le <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">cours Audio Transformers</a>.
Nous vous encourageons vraiment à consulter le Hub pour des modèles dans différentes langues, des modèles spécialisés dans votre domaine, et plus encore.
Vous pouvez consulter et comparer les résultats des modèles directement depuis votre navigateur sur le Hub pour voir s’ils conviennent ou gèrent mieux les cas particuliers que d’autres.
Et si vous ne trouvez pas de modèle pour votre cas d’utilisation, vous pouvez toujours commencer à <a href="training">entraîner</a> le vôtre !`,us,_,Wt="Si vous avez plusieurs entrées, vous pouvez passer votre entrée sous forme de liste :",cs,N,ms,Y,zt=`Les pipelines sont excellents pour l’expérimentation car passer d’un modèle à un autre est trivial ; cependant, il existe des moyens de les optimiser pour des charges de travail plus importantes que l’expérimentation. Consultez les guides suivants qui expliquent comment itérer sur des ensembles de données complets ou utiliser des pipelines dans un serveur web :
de la documentation :`,ds,V,Xt='<li><a href="#using-pipelines-on-a-dataset">Utilisation des pipelines sur un ensemble de données</a></li> <li><a href="./pipeline_webserver">Utilisation des pipelines pour un serveur web</a></li>',hs,L,Ms,S,Ht=`<code>pipeline()</code> prend en charge de nombreux paramètres ; certains sont spécifiques à la tâche et d’autres sont généraux pour tous les pipelines.
En général, vous pouvez spécifier les paramètres où vous le souhaitez :`,fs,F,gs,Q,Rt="Voyons 3 paramètres importants :",js,E,bs,P,_t=`Si vous utilisez <code>device=n</code>, le pipeline met automatiquement le modèle sur l’appareil spécifié.
Cela fonctionnera que vous utilisiez PyTorch ou Tensorflow.`,ws,A,ys,D,Nt='Si le modèle est trop grand pour un seul GPU et que vous utilisez PyTorch, vous pouvez définir <code>device_map=&quot;auto&quot;</code> pour déterminer automatiquement comment charger et stocker les poids du modèle. L’utilisation de l’argument <code>device_map</code> nécessite le package 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a> :',Js,K,Ts,O,Yt="Le code suivant charge et stocke automatiquement les poids du modèle sur plusieurs appareils :",vs,ee,$s,se,Vt="Notez que si <code>device_map=&quot;auto&quot;</code> est passé, il n’est pas nécessaire d’ajouter l’argument <code>device=device</code> lors de l’instanciation de votre <code>pipeline</code> car vous pourriez rencontrer des comportements inattendus !",Us,te,Zs,le,Lt='Par défaut, les pipelines ne feront pas d’inférence en batch pour des raisons expliquées en détail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">ici</a>. La raison est que le batching n’est pas nécessairement plus rapide, et peut en fait être beaucoup plus lent dans certains cas.',Is,ae,St="Mais si cela fonctionne dans votre cas d’utilisation, vous pouvez utiliser :",xs,ne,Gs,ie,Ft=`Cela exécute le pipeline sur les 4 fichiers audio fournis, mais les passera par batch de 2 au modèle (qui est sur un GPU, où le batching est plus susceptible d’aider) sans nécessiter de code supplémentaire de votre part.
La sortie doit toujours correspondre à ce que vous auriez reçu sans batching. Il s’agit uniquement d’un moyen de vous aider à obtenir plus de vitesse avec un pipeline.`,Bs,pe,Qt='Les pipelines peuvent également atténuer certaines des complexités du batching car, pour certains pipelines, un seul élément (comme un long fichier audio) doit être divisé en plusieurs parties pour être traité par un modèle. Le pipeline effectue ce <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>batching par morceaux</em></a> pour vous.',ks,re,qs,oe,Et=`Toutes les tâches fournissent des paramètres spécifiques à la tâche qui permettent une flexibilité et des options supplémentaires pour vous aider à accomplir votre travail.
Par exemple, la méthode <code>transformers.AutomaticSpeechRecognitionPipeline.__call__()</code> dispose d’un paramètre <code>return_timestamps</code> qui semble prometteur pour le sous-titrage des vidéos :`,Cs,ue,Ws,ce,Pt="Comme vous pouvez le voir, le modèle a inféré le texte et a également indiqué <strong>quand</strong> les différentes phrases ont été prononcées.",zs,me,At=`Il existe de nombreux paramètres disponibles pour chaque tâche, alors consultez la référence API de chaque tâche pour voir ce que vous pouvez ajuster !
Par exemple, le <code>AutomaticSpeechRecognitionPipeline</code> dispose d’un paramètre <code>chunk_length_s</code> qui est utile pour travailler sur des fichiers audio très longs (par exemple, le sous-titrage de films entiers ou de vidéos d’une heure) qu’un modèle ne peut généralement pas gérer seul :`,Xs,de,Hs,he,Dt='Si vous ne trouvez pas un paramètre qui vous aiderait vraiment, n’hésitez pas à <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">le demander</a> !',Rs,Me,_s,fe,Kt="Le pipeline peut également exécuter des inférences sur un grand ensemble de données. Le moyen le plus simple que nous recommandons pour cela est d’utiliser un itérateur :",Ns,ge,Ys,je,Ot=`L’itérateur <code>data()</code> génère chaque résultat, et le pipeline reconnaît automatiquement que l’entrée est itérable et commencera à récupérer les données tout en continuant à les traiter sur le GPU (cela utilise <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> sous le capot).
C’est important car vous n’avez pas besoin d’allouer de mémoire pour l’ensemble de données complet et vous pouvez alimenter le GPU aussi rapidement que possible.`,Vs,be,el="Étant donné que le lotissement pourrait accélérer les choses, il peut être utile d’essayer de régler le paramètre <code>batch_size</code> ici.",Ls,we,sl='La façon la plus simple d’itérer sur un ensemble de données est d’en charger un depuis 🤗 <a href="https://github.com/huggingface/datasets" rel="nofollow">Datasets</a> :',Ss,ye,Fs,Je,Qs,Z,Es,Te,tl='<a href="./pipeline_webserver">Lien</a>',Ps,ve,As,$e,ll="Utiliser un <code>pipeline()</code> pour les tâches de vision est pratiquement identique.",Ds,Ue,al="Spécifiez votre tâche et passez votre image au classificateur. L’image peut être un lien, un chemin local ou une image encodée en base64. Par exemple, quelle espèce de chat est montrée ci-dessous ?",Ks,Ze,nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Os,Ie,et,xe,st,Ge,il="Utiliser un <code>pipeline()</code> pour les tâches de NLP est pratiquement identique.",tt,Be,lt,ke,at,qe,pl="Le <code>pipeline()</code> prend en charge plus d’une modalité. Par exemple, une tâche de réponse à des questions visuelles (VQA) combine texte et image. N’hésitez pas à utiliser n’importe quel lien d’image que vous aimez et une question que vous souhaitez poser à propos de l’image. L’image peut être une URL ou un chemin local vers l’image.",nt,Ce,rl='Par exemple, si vous utilisez cette <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">image de facture</a> :',it,We,pt,I,rt,ze,ot,Xe,ol="Vous pouvez facilement exécuter <code>pipeline</code> sur de grands modèles en utilisant 🤗 <code>accelerate</code> ! Assurez-vous d’abord d’avoir installé <code>accelerate</code> avec <code>pip install accelerate</code>.",ut,He,ul="Chargez d’abord votre modèle en utilisant <code>device_map=&quot;auto&quot;</code> ! Nous utiliserons <code>facebook/opt-1.3b</code> pour notre exemple.",ct,Re,mt,_e,cl=`Vous pouvez également passer des modèles chargés en 8 bits si vous installez <code>bitsandbytes</code> et ajoutez l’argument <code>load_in_8bit=True</code>
Notez que vous pouvez remplacer le point de contrôle par n’importe quel modèle.`,dt,Ne,ht,Ye,Mt,Ve,ml=`Hugging Face prenant en charge le chargement de grands modèles, comme BLOOM.
Les pipelines sont automatiquement pris en charge dans <a href="https://github.com/gradio-app/gradio/" rel="nofollow">Gradio</a>, une bibliothèque qui facilite la création d’applications d’apprentissage automatique belles et conviviales sur le web. Tout d’abord, assurez-vous que Gradio est installé :`,ft,Le,gt,Se,dl='Ensuite, vous pouvez créer une démonstration web autour d’un pipeline de classification d’images (ou tout autre pipeline) en une seule ligne de code en appelant la fonction <a href="https://www.gradio.app/docs/interface#interface-from-pipeline" rel="nofollow"><code>Interface.from_pipeline</code></a> de Gradio pour lancer le pipeline. Cela crée une interface intuitive de glisser-déposer dans votre navigateur :',jt,Fe,bt,Qe,hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/panda-classification.png"/>',wt,Ee,Ml='Par défaut, la démonstration web s’exécute sur un serveur local. Si vous souhaitez la partager avec d’autres, vous pouvez générer un lien public temporaire en définissant <code>share=True</code> dans <code>launch()</code>. Vous pouvez également héberger votre démonstration sur <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> pour obtenir un lien permanent.',yt,Pe,Jt,Ae,Tt;return J=new y({props:{title:"Pipelines pour l’inférence",local:"pipelines-pour-linférence",headingTag:"h1"}}),$=new $t({props:{$$slots:{default:[Gl]},$$scope:{ctx:v}}}),G=new y({props:{title:"Utilisation du pipeline",local:"utilisation-du-pipeline",headingTag:"h2"}}),q=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),C=new f({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),H=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),N=new f({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),L=new y({props:{title:"Paramètres",local:"paramètres",headingTag:"h2"}}),F=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),E=new y({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),K=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),ee=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),te=new y({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ne=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),re=new y({props:{title:"Paramètres spécifiques à la tâche",local:"paramètres-spécifiques-à-la-tâche",headingTag:"h3"}}),ue=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),de=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnJlYWNoLXZiJTJGcmFuZG9tLWF1ZGlvcyUyRnJlc29sdmUlMkZtYWluJTJGdGVkXzYwLndhdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/reach-vb/random-audios/resolve/main/ted_60.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; So in college, I was a government major, which means I had to write a lot of papers. Now, when a normal student writes a paper, they might spread the work out a little like this. So, you know. You get started maybe a little slowly, but you get enough done in the first week that with some heavier days later on, everything gets done and things stay civil. And I would want to do that like that. That would be the plan. I would have it all ready to go, but then actually the paper would come along, and then I would kind of do this. And that would happen every single paper. But then came my 90-page senior thesis, a paper you&#x27;re supposed to spend a year on. I knew for a paper like that, my normal workflow was not an option, it was way too big a project. So I planned things out and I decided I kind of had to go something like this. This is how the year would go. So I&#x27;d start off light and I&#x27;d bump it up&quot;</span>}`,wrap:!1}}),Me=new y({props:{title:"Utilisation des pipelines sur un ensemble de données",local:"utilisation-des-pipelines-sur-un-ensemble-de-données",headingTag:"h2"}}),ge=new f({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBkZXZpY2UlM0QwKSUwQWdlbmVyYXRlZF9jaGFyYWN0ZXJzJTIwJTNEJTIwMCUwQWZvciUyMG91dCUyMGluJTIwcGlwZShkYXRhKCkpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlMkIlM0QlMjBsZW4ob3V0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),ye=new f({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Je=new y({props:{title:"Utilisation des pipelines pour un serveur web",local:"utilisation-des-pipelines-pour-un-serveur-web",headingTag:"h2"}}),Z=new $t({props:{$$slots:{default:[Bl]},$$scope:{ctx:v}}}),ve=new y({props:{title:"Pipeline de vision",local:"pipeline-de-vision",headingTag:"h2"}}),Ie=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),xe=new y({props:{title:"Pipeline de texte",local:"pipeline-de-texte",headingTag:"h2"}}),Be=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),ke=new y({props:{title:"Pipeline multimodal",local:"pipeline-multimodal",headingTag:"h2"}}),We=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEFvdXRwdXQlMjAlM0QlMjB2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKSUwQW91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyMCUzRCUyMHJvdW5kKG91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDMpJTBBb3V0cHV0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] = <span class="hljs-built_in">round</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.425</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),I=new $t({props:{$$slots:{default:[kl]},$$scope:{ctx:v}}}),ze=new y({props:{title:"Utilisation de pipeline sur de grands modèles avec 🤗 accelerate :",local:"utilisation-de-pipeline-sur-de-grands-modèles-avec--accelerate-",headingTag:"h2"}}),Re=new f({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ne=new f({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ye=new y({props:{title:"Création de démonstrations web à partir de pipelines avec gradio",local:"création-de-démonstrations-web-à-partir-de-pipelines-avec-gradio",headingTag:"h2"}}),Le=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbw==",highlighted:'pip <span class="hljs-keyword">install</span> gradio',wrap:!1}}),Fe=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBZ3IuSW50ZXJmYWNlLmZyb21fcGlwZWxpbmUocGlwZSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)

gr.Interface.from_pipeline(pipe).launch()`,wrap:!1}}),Pe=new xl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/fr/tutoriel_pipeline.md"}}),{c(){M=i("meta"),b=a(),j=i("p"),w=a(),o(J.$$.fragment),g=a(),T=i("p"),T.innerHTML=Ut,De=a(),x=i("ul"),x.innerHTML=Zt,Ke=a(),o($.$$.fragment),Oe=a(),o(G.$$.fragment),es=a(),B=i("p"),B.innerHTML=It,ss=a(),k=i("ol"),k.innerHTML=xt,ts=a(),o(q.$$.fragment),ls=a(),U=i("ol"),U.innerHTML=Gt,as=a(),o(C.$$.fragment),ns=a(),W=i("p"),W.innerHTML=Bt,is=a(),z=i("p"),z.innerHTML=kt,ps=a(),X=i("p"),X.textContent=qt,rs=a(),o(H.$$.fragment),os=a(),R=i("p"),R.innerHTML=Ct,us=a(),_=i("p"),_.textContent=Wt,cs=a(),o(N.$$.fragment),ms=a(),Y=i("p"),Y.textContent=zt,ds=a(),V=i("ul"),V.innerHTML=Xt,hs=a(),o(L.$$.fragment),Ms=a(),S=i("p"),S.innerHTML=Ht,fs=a(),o(F.$$.fragment),gs=a(),Q=i("p"),Q.textContent=Rt,js=a(),o(E.$$.fragment),bs=a(),P=i("p"),P.innerHTML=_t,ws=a(),o(A.$$.fragment),ys=a(),D=i("p"),D.innerHTML=Nt,Js=a(),o(K.$$.fragment),Ts=a(),O=i("p"),O.textContent=Yt,vs=a(),o(ee.$$.fragment),$s=a(),se=i("p"),se.innerHTML=Vt,Us=a(),o(te.$$.fragment),Zs=a(),le=i("p"),le.innerHTML=Lt,Is=a(),ae=i("p"),ae.textContent=St,xs=a(),o(ne.$$.fragment),Gs=a(),ie=i("p"),ie.textContent=Ft,Bs=a(),pe=i("p"),pe.innerHTML=Qt,ks=a(),o(re.$$.fragment),qs=a(),oe=i("p"),oe.innerHTML=Et,Cs=a(),o(ue.$$.fragment),Ws=a(),ce=i("p"),ce.innerHTML=Pt,zs=a(),me=i("p"),me.innerHTML=At,Xs=a(),o(de.$$.fragment),Hs=a(),he=i("p"),he.innerHTML=Dt,Rs=a(),o(Me.$$.fragment),_s=a(),fe=i("p"),fe.textContent=Kt,Ns=a(),o(ge.$$.fragment),Ys=a(),je=i("p"),je.innerHTML=Ot,Vs=a(),be=i("p"),be.innerHTML=el,Ls=a(),we=i("p"),we.innerHTML=sl,Ss=a(),o(ye.$$.fragment),Fs=a(),o(Je.$$.fragment),Qs=a(),o(Z.$$.fragment),Es=a(),Te=i("p"),Te.innerHTML=tl,Ps=a(),o(ve.$$.fragment),As=a(),$e=i("p"),$e.innerHTML=ll,Ds=a(),Ue=i("p"),Ue.textContent=al,Ks=a(),Ze=i("p"),Ze.innerHTML=nl,Os=a(),o(Ie.$$.fragment),et=a(),o(xe.$$.fragment),st=a(),Ge=i("p"),Ge.innerHTML=il,tt=a(),o(Be.$$.fragment),lt=a(),o(ke.$$.fragment),at=a(),qe=i("p"),qe.innerHTML=pl,nt=a(),Ce=i("p"),Ce.innerHTML=rl,it=a(),o(We.$$.fragment),pt=a(),o(I.$$.fragment),rt=a(),o(ze.$$.fragment),ot=a(),Xe=i("p"),Xe.innerHTML=ol,ut=a(),He=i("p"),He.innerHTML=ul,ct=a(),o(Re.$$.fragment),mt=a(),_e=i("p"),_e.innerHTML=cl,dt=a(),o(Ne.$$.fragment),ht=a(),o(Ye.$$.fragment),Mt=a(),Ve=i("p"),Ve.innerHTML=ml,ft=a(),o(Le.$$.fragment),gt=a(),Se=i("p"),Se.innerHTML=dl,jt=a(),o(Fe.$$.fragment),bt=a(),Qe=i("p"),Qe.innerHTML=hl,wt=a(),Ee=i("p"),Ee.innerHTML=Ml,yt=a(),o(Pe.$$.fragment),Jt=a(),Ae=i("p"),this.h()},l(e){const s=$l("svelte-u9bgzb",document.head);M=p(s,"META",{name:!0,content:!0}),s.forEach(t),b=n(e),j=p(e,"P",{}),bl(j).forEach(t),w=n(e),u(J.$$.fragment,e),g=n(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-h0w3ee"&&(T.innerHTML=Ut),De=n(e),x=p(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-10scum8"&&(x.innerHTML=Zt),Ke=n(e),u($.$$.fragment,e),Oe=n(e),u(G.$$.fragment,e),es=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1u9jsz2"&&(B.innerHTML=It),ss=n(e),k=p(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-1arzf4j"&&(k.innerHTML=xt),ts=n(e),u(q.$$.fragment,e),ls=n(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-gnpjsb"&&(U.innerHTML=Gt),as=n(e),u(C.$$.fragment,e),ns=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1td4esp"&&(W.innerHTML=Bt),is=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-xt9r0p"&&(z.innerHTML=kt),ps=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-m5ompv"&&(X.textContent=qt),rs=n(e),u(H.$$.fragment,e),os=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10s5tz3"&&(R.innerHTML=Ct),us=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-19hcx9z"&&(_.textContent=Wt),cs=n(e),u(N.$$.fragment,e),ms=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1fq1d9s"&&(Y.textContent=zt),ds=n(e),V=p(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-ajxopt"&&(V.innerHTML=Xt),hs=n(e),u(L.$$.fragment,e),Ms=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-14znczl"&&(S.innerHTML=Ht),fs=n(e),u(F.$$.fragment,e),gs=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-mi1z3p"&&(Q.textContent=Rt),js=n(e),u(E.$$.fragment,e),bs=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1i17yb2"&&(P.innerHTML=_t),ws=n(e),u(A.$$.fragment,e),ys=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-tcmrd6"&&(D.innerHTML=Nt),Js=n(e),u(K.$$.fragment,e),Ts=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1xs45t9"&&(O.textContent=Yt),vs=n(e),u(ee.$$.fragment,e),$s=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-10m6e1b"&&(se.innerHTML=Vt),Us=n(e),u(te.$$.fragment,e),Zs=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-avukc5"&&(le.innerHTML=Lt),Is=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-fff3nw"&&(ae.textContent=St),xs=n(e),u(ne.$$.fragment,e),Gs=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1cyvpe4"&&(ie.textContent=Ft),Bs=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1lwuvpp"&&(pe.innerHTML=Qt),ks=n(e),u(re.$$.fragment,e),qs=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1uupeqb"&&(oe.innerHTML=Et),Cs=n(e),u(ue.$$.fragment,e),Ws=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-nj0nps"&&(ce.innerHTML=Pt),zs=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-bgzba0"&&(me.innerHTML=At),Xs=n(e),u(de.$$.fragment,e),Hs=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14jr8cl"&&(he.innerHTML=Dt),Rs=n(e),u(Me.$$.fragment,e),_s=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-13zedtm"&&(fe.textContent=Kt),Ns=n(e),u(ge.$$.fragment,e),Ys=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1ruicpo"&&(je.innerHTML=Ot),Vs=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-i6whev"&&(be.innerHTML=el),Ls=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1xorsvm"&&(we.innerHTML=sl),Ss=n(e),u(ye.$$.fragment,e),Fs=n(e),u(Je.$$.fragment,e),Qs=n(e),u(Z.$$.fragment,e),Es=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-r28pea"&&(Te.innerHTML=tl),Ps=n(e),u(ve.$$.fragment,e),As=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-nrbs13"&&($e.innerHTML=ll),Ds=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-9t37uo"&&(Ue.textContent=al),Ks=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bks2jw"&&(Ze.innerHTML=nl),Os=n(e),u(Ie.$$.fragment,e),et=n(e),u(xe.$$.fragment,e),st=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-mknqi7"&&(Ge.innerHTML=il),tt=n(e),u(Be.$$.fragment,e),lt=n(e),u(ke.$$.fragment,e),at=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-19n1ves"&&(qe.innerHTML=pl),nt=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-2yzyld"&&(Ce.innerHTML=rl),it=n(e),u(We.$$.fragment,e),pt=n(e),u(I.$$.fragment,e),rt=n(e),u(ze.$$.fragment,e),ot=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-dh90b"&&(Xe.innerHTML=ol),ut=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1x92yvt"&&(He.innerHTML=ul),ct=n(e),u(Re.$$.fragment,e),mt=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-75hct4"&&(_e.innerHTML=cl),dt=n(e),u(Ne.$$.fragment,e),ht=n(e),u(Ye.$$.fragment,e),Mt=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-a5zg71"&&(Ve.innerHTML=ml),ft=n(e),u(Le.$$.fragment,e),gt=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-sz552t"&&(Se.innerHTML=dl),jt=n(e),u(Fe.$$.fragment,e),bt=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-rjj5jb"&&(Qe.innerHTML=hl),wt=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1r40b7i"&&(Ee.innerHTML=Ml),yt=n(e),u(Pe.$$.fragment,e),Jt=n(e),Ae=p(e,"P",{}),bl(Ae).forEach(t),this.h()},h(){vt(M,"name","hf:doc:metadata"),vt(M,"content",Cl),vt(U,"start","2")},m(e,s){Ul(document.head,M),l(e,b,s),l(e,j,s),l(e,w,s),c(J,e,s),l(e,g,s),l(e,T,s),l(e,De,s),l(e,x,s),l(e,Ke,s),c($,e,s),l(e,Oe,s),c(G,e,s),l(e,es,s),l(e,B,s),l(e,ss,s),l(e,k,s),l(e,ts,s),c(q,e,s),l(e,ls,s),l(e,U,s),l(e,as,s),c(C,e,s),l(e,ns,s),l(e,W,s),l(e,is,s),l(e,z,s),l(e,ps,s),l(e,X,s),l(e,rs,s),c(H,e,s),l(e,os,s),l(e,R,s),l(e,us,s),l(e,_,s),l(e,cs,s),c(N,e,s),l(e,ms,s),l(e,Y,s),l(e,ds,s),l(e,V,s),l(e,hs,s),c(L,e,s),l(e,Ms,s),l(e,S,s),l(e,fs,s),c(F,e,s),l(e,gs,s),l(e,Q,s),l(e,js,s),c(E,e,s),l(e,bs,s),l(e,P,s),l(e,ws,s),c(A,e,s),l(e,ys,s),l(e,D,s),l(e,Js,s),c(K,e,s),l(e,Ts,s),l(e,O,s),l(e,vs,s),c(ee,e,s),l(e,$s,s),l(e,se,s),l(e,Us,s),c(te,e,s),l(e,Zs,s),l(e,le,s),l(e,Is,s),l(e,ae,s),l(e,xs,s),c(ne,e,s),l(e,Gs,s),l(e,ie,s),l(e,Bs,s),l(e,pe,s),l(e,ks,s),c(re,e,s),l(e,qs,s),l(e,oe,s),l(e,Cs,s),c(ue,e,s),l(e,Ws,s),l(e,ce,s),l(e,zs,s),l(e,me,s),l(e,Xs,s),c(de,e,s),l(e,Hs,s),l(e,he,s),l(e,Rs,s),c(Me,e,s),l(e,_s,s),l(e,fe,s),l(e,Ns,s),c(ge,e,s),l(e,Ys,s),l(e,je,s),l(e,Vs,s),l(e,be,s),l(e,Ls,s),l(e,we,s),l(e,Ss,s),c(ye,e,s),l(e,Fs,s),c(Je,e,s),l(e,Qs,s),c(Z,e,s),l(e,Es,s),l(e,Te,s),l(e,Ps,s),c(ve,e,s),l(e,As,s),l(e,$e,s),l(e,Ds,s),l(e,Ue,s),l(e,Ks,s),l(e,Ze,s),l(e,Os,s),c(Ie,e,s),l(e,et,s),c(xe,e,s),l(e,st,s),l(e,Ge,s),l(e,tt,s),c(Be,e,s),l(e,lt,s),c(ke,e,s),l(e,at,s),l(e,qe,s),l(e,nt,s),l(e,Ce,s),l(e,it,s),c(We,e,s),l(e,pt,s),c(I,e,s),l(e,rt,s),c(ze,e,s),l(e,ot,s),l(e,Xe,s),l(e,ut,s),l(e,He,s),l(e,ct,s),c(Re,e,s),l(e,mt,s),l(e,_e,s),l(e,dt,s),c(Ne,e,s),l(e,ht,s),c(Ye,e,s),l(e,Mt,s),l(e,Ve,s),l(e,ft,s),c(Le,e,s),l(e,gt,s),l(e,Se,s),l(e,jt,s),c(Fe,e,s),l(e,bt,s),l(e,Qe,s),l(e,wt,s),l(e,Ee,s),l(e,yt,s),c(Pe,e,s),l(e,Jt,s),l(e,Ae,s),Tt=!0},p(e,[s]){const fl={};s&2&&(fl.$$scope={dirty:s,ctx:e}),$.$set(fl);const gl={};s&2&&(gl.$$scope={dirty:s,ctx:e}),Z.$set(gl);const jl={};s&2&&(jl.$$scope={dirty:s,ctx:e}),I.$set(jl)},i(e){Tt||(m(J.$$.fragment,e),m($.$$.fragment,e),m(G.$$.fragment,e),m(q.$$.fragment,e),m(C.$$.fragment,e),m(H.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(Z.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m(xe.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(We.$$.fragment,e),m(I.$$.fragment,e),m(ze.$$.fragment,e),m(Re.$$.fragment,e),m(Ne.$$.fragment,e),m(Ye.$$.fragment,e),m(Le.$$.fragment,e),m(Fe.$$.fragment,e),m(Pe.$$.fragment,e),Tt=!0)},o(e){d(J.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(q.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(Z.$$.fragment,e),d(ve.$$.fragment,e),d(Ie.$$.fragment,e),d(xe.$$.fragment,e),d(Be.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(I.$$.fragment,e),d(ze.$$.fragment,e),d(Re.$$.fragment,e),d(Ne.$$.fragment,e),d(Ye.$$.fragment,e),d(Le.$$.fragment,e),d(Fe.$$.fragment,e),d(Pe.$$.fragment,e),Tt=!1},d(e){e&&(t(b),t(j),t(w),t(g),t(T),t(De),t(x),t(Ke),t(Oe),t(es),t(B),t(ss),t(k),t(ts),t(ls),t(U),t(as),t(ns),t(W),t(is),t(z),t(ps),t(X),t(rs),t(os),t(R),t(us),t(_),t(cs),t(ms),t(Y),t(ds),t(V),t(hs),t(Ms),t(S),t(fs),t(gs),t(Q),t(js),t(bs),t(P),t(ws),t(ys),t(D),t(Js),t(Ts),t(O),t(vs),t($s),t(se),t(Us),t(Zs),t(le),t(Is),t(ae),t(xs),t(Gs),t(ie),t(Bs),t(pe),t(ks),t(qs),t(oe),t(Cs),t(Ws),t(ce),t(zs),t(me),t(Xs),t(Hs),t(he),t(Rs),t(_s),t(fe),t(Ns),t(Ys),t(je),t(Vs),t(be),t(Ls),t(we),t(Ss),t(Fs),t(Qs),t(Es),t(Te),t(Ps),t(As),t($e),t(Ds),t(Ue),t(Ks),t(Ze),t(Os),t(et),t(st),t(Ge),t(tt),t(lt),t(at),t(qe),t(nt),t(Ce),t(it),t(pt),t(rt),t(ot),t(Xe),t(ut),t(He),t(ct),t(mt),t(_e),t(dt),t(ht),t(Mt),t(Ve),t(ft),t(gt),t(Se),t(jt),t(bt),t(Qe),t(wt),t(Ee),t(yt),t(Jt),t(Ae)),t(M),h(J,e),h($,e),h(G,e),h(q,e),h(C,e),h(H,e),h(N,e),h(L,e),h(F,e),h(E,e),h(A,e),h(K,e),h(ee,e),h(te,e),h(ne,e),h(re,e),h(ue,e),h(de,e),h(Me,e),h(ge,e),h(ye,e),h(Je,e),h(Z,e),h(ve,e),h(Ie,e),h(xe,e),h(Be,e),h(ke,e),h(We,e),h(I,e),h(ze,e),h(Re,e),h(Ne,e),h(Ye,e),h(Le,e),h(Fe,e),h(Pe,e)}}}const Cl='{"title":"Pipelines pour l’inférence","local":"pipelines-pour-linférence","sections":[{"title":"Utilisation du pipeline","local":"utilisation-du-pipeline","sections":[],"depth":2},{"title":"Paramètres","local":"paramètres","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Paramètres spécifiques à la tâche","local":"paramètres-spécifiques-à-la-tâche","sections":[],"depth":3}],"depth":2},{"title":"Utilisation des pipelines sur un ensemble de données","local":"utilisation-des-pipelines-sur-un-ensemble-de-données","sections":[],"depth":2},{"title":"Utilisation des pipelines pour un serveur web","local":"utilisation-des-pipelines-pour-un-serveur-web","sections":[],"depth":2},{"title":"Pipeline de vision","local":"pipeline-de-vision","sections":[],"depth":2},{"title":"Pipeline de texte","local":"pipeline-de-texte","sections":[],"depth":2},{"title":"Pipeline multimodal","local":"pipeline-multimodal","sections":[],"depth":2},{"title":"Utilisation de pipeline sur de grands modèles avec 🤗 accelerate :","local":"utilisation-de-pipeline-sur-de-grands-modèles-avec--accelerate-","sections":[],"depth":2},{"title":"Création de démonstrations web à partir de pipelines avec gradio","local":"création-de-démonstrations-web-à-partir-de-pipelines-avec-gradio","sections":[],"depth":2}],"depth":1}';function Wl(v){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends Tl{constructor(M){super(),vl(this,M,Wl,ql,yl,{})}}export{Nl as component};
