import{s as or,f as nr,o as sr,n as K}from"../chunks/scheduler.25b97de1.js";import{S as ar,i as rr,g as i,s as n,r as m,A as ir,h as l,f as o,c as s,j as v,u,x as p,k as w,y as a,a as r,v as h,d as f,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as Nn}from"../chunks/Tip.baa67368.js";import{D as x}from"../chunks/Docstring.e257edda.js";import{C as V}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Uo}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as F,E as lr}from"../chunks/EditOnGithub.91d95064.js";function dr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNTW9kZWwlMkMlMjBNYXJrdXBMTUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXJrdXBMTSUyMG1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFya3VwTE1Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMModel, MarkupLMConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MarkupLM microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MarkupLMConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function cr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUwQSUwQXBhZ2VfbmFtZV8xJTIwJTNEJTIwJTIycGFnZTEuaHRtbCUyMiUwQXBhZ2VfbmFtZV8yJTIwJTNEJTIwJTIycGFnZTIuaHRtbCUyMiUwQXBhZ2VfbmFtZV8zJTIwJTNEJTIwJTIycGFnZTMuaHRtbCUyMiUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8xKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHNpbmdsZV9odG1sX3N0cmluZyUyMCUzRCUyMGYucmVhZCgpJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQSUwQSUyMyUyMHNpbmdsZSUyMGV4YW1wbGUlMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKHNpbmdsZV9odG1sX3N0cmluZyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCklMEElMEElMjMlMjBiYXRjaGVkJTIwZXhhbXBsZSUwQSUwQW11bHRpX2h0bWxfc3RyaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8yKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMG11bHRpX2h0bWxfc3RyaW5ncy5hcHBlbmQoZi5yZWFkKCkpJTBBd2l0aCUyMG9wZW4ocGFnZV9uYW1lXzMpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwbXVsdGlfaHRtbF9zdHJpbmdzLmFwcGVuZChmLnJlYWQoKSklMEElMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKG11bHRpX2h0bWxfc3RyaW5ncyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_1 = <span class="hljs-string">&quot;page1.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_2 = <span class="hljs-string">&quot;page2.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_3 = <span class="hljs-string">&quot;page3.html&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_1) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    single_html_string = f.read()

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = MarkupLMFeatureExtractor()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># single example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(single_html_string)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batched example</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>multi_html_strings = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_2) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_3) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(multi_html_strings)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function pr($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&o(c)}}}function mr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTU1vZGVsJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hcmt1cExNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFUGFnZSUyMFRpdGxlJTNDJTJGdGl0bGUlM0UlMjAlM0MlMkZoZWFkJTNFJTIwJTNDJTJGaHRtbCUzRSUyMiUwQSUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function ur($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&o(c)}}}function hr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0Q3KSUwQSUwQWh0bWxfc3RyaW5nJTIwJTNEJTIwJTIyJTNDaHRtbCUzRSUyMCUzQ2hlYWQlM0UlMjAlM0N0aXRsZSUzRVBhZ2UlMjBUaXRsZSUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function fr($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&o(c)}}}function gr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQXByb2Nlc3Nvci5wYXJzZV9odG1sJTIwJTNEJTIwRmFsc2UlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIlMkMlMjBudW1fbGFiZWxzJTNENyklMEElMEFub2RlcyUyMCUzRCUyMCU1QiUyMmhlbGxvJTIyJTJDJTIwJTIyd29ybGQlMjIlNUQlMEF4cGF0aHMlMjAlM0QlMjAlNUIlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlMkMlMjAlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTVEJTBBZW5jb2RpbmclMjAlM0QlMjBwcm9jZXNzb3Iobm9kZXMlM0Rub2RlcyUyQyUyMHhwYXRocyUzRHhwYXRocyUyQyUyMG5vZGVfbGFiZWxzJTNEbm9kZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function _r($){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=y},l(k){c=l(k,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(k,M){r(k,c,M)},p:K,d(k){k&&o(c)}}}function Mr($){let c,y="Examples:",k,M,b;return M=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFTXklMjBuYW1lJTIwaXMlMjBOaWVscyUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEElMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHF1ZXN0aW9ucyUzRHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwZW5jb2RpbmcuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMpLnN0cmlwKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;My name is Niels&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = encoding.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(predict_answer_tokens).strip()
<span class="hljs-string">&#x27;Niels&#x27;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=y,k=n(),m(M.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=y),k=s(d),u(M.$$.fragment,d)},m(d,T){r(d,c,T),r(d,k,T),h(M,d,T),b=!0},p:K,i(d){b||(f(M.$$.fragment,d),b=!0)},o(d){g(M.$$.fragment,d),b=!1},d(d){d&&(o(c),o(k)),_(M,d)}}}function kr($){let c,y,k,M,b,d,T,jo,ve,Xs=`The MarkupLM model was proposed in <a href="https://arxiv.org/abs/2110.08518" rel="nofollow">MarkupLM: Pre-training of Text and Markup Language for Visually-rich Document
Understanding</a> by Junlong Li, Yiheng Xu, Lei Cui, Furu Wei. MarkupLM is BERT, but
applied to HTML pages instead of raw text documents. The model incorporates additional embedding layers to improve
performance, similar to <a href="layoutlm">LayoutLM</a>.`,Co,xe,Ps=`The model can be used for tasks like question answering on web pages or information extraction from web pages. It obtains
state-of-the-art results on 2 important benchmarks:`,Fo,Le,As=`<li><a href="https://x-lance.github.io/WebSRC/" rel="nofollow">WebSRC</a>, a dataset for Web-Based Structural Reading Comprehension (a bit like SQuAD but for web pages)</li> <li><a href="https://www.researchgate.net/publication/221299838_From_one_tree_to_a_forest_a_unified_solution_for_structured_web_data_extraction" rel="nofollow">SWDE</a>, a dataset
for information extraction from web pages (basically named-entity recognition on web pages)</li>`,Io,$e,Ds="The abstract from the paper is the following:",No,Ue,Ys=`<em>Multimodal pre-training with text, layout, and image has made significant progress for Visually-rich Document
Understanding (VrDU), especially the fixed-layout documents such as scanned document images. While, there are still a
large number of digital documents where the layout information is not fixed and needs to be interactively and
dynamically rendered for visualization, making existing layout-based pre-training approaches not easy to apply. In this
paper, we propose MarkupLM for document understanding tasks with markup languages as the backbone such as
HTML/XML-based documents, where text and markup information is jointly pre-trained. Experiment results show that the
pre-trained MarkupLM significantly outperforms the existing strong baseline models on several document understanding
tasks. The pre-trained model and code will be publicly available.</em>`,Zo,Je,Os='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/markuplm" rel="nofollow">here</a>.',Ro,ze,Bo,qe,Ks=`<li>In addition to <code>input_ids</code>, <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMModel.forward">forward()</a> expects 2 additional inputs, namely <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.
These are the XPATH tags and subscripts respectively for each token in the input sequence.</li> <li>One can use <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> to prepare all data for the model. Refer to the <a href="#usage-markuplmprocessor">usage guide</a> for more info.</li>`,Go,oe,ea,Ho,je,ta='MarkupLM architecture. Taken from the <a href="https://arxiv.org/abs/2110.08518">original paper.</a>',Eo,Ce,Wo,Fe,oa=`The easiest way to prepare data for the model is to use <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>, which internally combines a feature extractor
(<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>) and a tokenizer (<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>). The feature extractor is
used to extract all nodes and xpaths from the HTML strings, which are then provided to the tokenizer, which turns them into the
token-level inputs of the model (<code>input_ids</code> etc.). Note that you can still use the feature extractor and tokenizer separately,
if you only want to handle one of the two tasks.`,Vo,Ie,So,Ne,na=`In short, one can provide HTML strings (and possibly additional data) to <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>,
and it will create the inputs expected by the model. Internally, the processor first uses
<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to get a list of nodes and corresponding xpaths. The nodes and
xpaths are then provided to <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which converts them
to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_subs_seq</code>, <code>xpath_tags_seq</code>.
Optionally, one can provide node labels to the processor, which are turned into token-level <code>labels</code>.`,Qo,Ze,sa=`<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> uses <a href="https://www.crummy.com/software/BeautifulSoup/bs4/doc/" rel="nofollow">Beautiful Soup</a>, a Python library for
pulling data out of HTML and XML files, under the hood. Note that you can still use your own parsing solution of
choice, and provide the nodes and xpaths yourself to <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>.`,Xo,Re,aa=`In total, there are 5 use cases that are supported by the processor. Below, we list them all. Note that each of these
use cases work for both batched and non-batched inputs (we illustrate them for non-batched inputs).`,Po,Be,ra="<strong>Use case 1: web page classification (training, inference) + token classification (inference), parse_html = True</strong>",Ao,Ge,ia="This is the simplest case, in which the processor will use the feature extractor to get all nodes and xpaths from the HTML.",Do,He,Yo,Ee,la="<strong>Use case 2: web page classification (training, inference) + token classification (inference), parse_html=False</strong>",Oo,We,da=`In case one already has obtained all nodes and xpaths, one doesn’t need the feature extractor. In that case, one should
provide the nodes and corresponding xpaths themselves to the processor, and make sure to set <code>parse_html</code> to <code>False</code>.`,Ko,Ve,en,Se,ca="<strong>Use case 3: token classification (training), parse_html=False</strong>",tn,Qe,pa=`For token classification tasks (such as <a href="https://paperswithcode.com/dataset/swde" rel="nofollow">SWDE</a>), one can also provide the
corresponding node labels in order to train a model. The processor will then convert these into token-level <code>labels</code>.
By default, it will only label the first wordpiece of a word, and label the remaining wordpieces with -100, which is the
<code>ignore_index</code> of PyTorch’s CrossEntropyLoss. In case you want all wordpieces of a word to be labeled, you can
initialize the tokenizer with <code>only_label_first_subword</code> set to <code>False</code>.`,on,Xe,nn,Pe,ma="<strong>Use case 4: web page question answering (inference), parse_html=True</strong>",sn,Ae,ua=`For question answering tasks on web pages, you can provide a question to the processor. By default, the
processor will use the feature extractor to get all nodes and xpaths, and create [CLS] question tokens [SEP] word tokens [SEP].`,an,De,rn,Ye,ha="<strong>Use case 5: web page question answering (inference), parse_html=False</strong>",ln,Oe,fa=`For question answering tasks (such as WebSRC), you can provide a question to the processor. If you have extracted
all nodes and xpaths yourself, you can provide them directly to the processor. Make sure to set <code>parse_html</code> to <code>False</code>.`,dn,Ke,cn,et,pn,tt,ga='<li><a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MarkupLM" rel="nofollow">Demo notebooks</a></li> <li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li>',mn,ot,un,I,nt,Zn,Zt,_a=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>. It is used to instantiate a
MarkupLM model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the MarkupLM
<a href="https://huggingface.co/microsoft/markuplm-base" rel="nofollow">microsoft/markuplm-base</a> architecture.`,Rn,Rt,Ma=`Configuration objects inherit from <a href="/docs/transformers/pr_28071/en/model_doc/bert#transformers.BertConfig">BertConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28071/en/model_doc/bert#transformers.BertConfig">BertConfig</a> for more information.`,Bn,ne,hn,st,fn,N,at,Gn,Bt,ka=`Constructs a MarkupLM feature extractor. This can be used to get a list of nodes and corresponding xpaths from HTML
strings.`,Hn,Gt,ba=`This feature extractor inherits from <code>PreTrainedFeatureExtractor()</code> which contains most
of the main methods. Users should refer to this superclass for more information regarding those methods.`,En,A,rt,Wn,Ht,ya="Main method to prepare for the model one or several HTML strings.",Vn,se,gn,it,_n,z,lt,Sn,Et,Ta=`Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE). <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> can be used to
turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and
<code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/pr_28071/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods.
Users should refer to this superclass for more information regarding those methods.`,Qn,D,dt,Xn,Wt,wa=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,Pn,Vt,va="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",An,St,ct,Dn,ae,pt,Yn,Qt,xa=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,On,Xt,mt,Mn,ut,kn,L,ht,Kn,Pt,La="Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE).",es,At,$a=`<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a> can be used to turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>,
<code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/pr_28071/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which
contains most of the main methods.`,ts,Dt,Ua="Users should refer to this superclass for more information regarding those methods.",os,J,ft,ns,Yt,Ja=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,ss,Ot,za=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters.</p></li>`,as,Kt,qa=`If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
is_split_into_words (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).
return_tensors (<code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:`,rs,eo,ja="<li><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</li> <li><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li> <li><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</li>",is,to,Ca=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to encode the sequences with the special tokens relative to their model.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,ls,oo,Fa=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).
return_tensors (<code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:</p></li> <li><p><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</p></li> <li><p><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</p></li> <li><p><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</p></li>`,ds,Y,gt,cs,no,Ia=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,ps,so,Na="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",ms,re,_t,us,ao,Za=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,hs,ie,Mt,fs,ro,Ra=`Tokenize and prepare for the model a sequence or a pair of sequences. .. warning:: This method is deprecated,
<code>__call__</code> should be used instead.`,gs,le,kt,_s,io,Ba=`Given the xpath expression of one particular node (like “/html/body/div/li[1]/div/span[2]”), return a list of
tag IDs and corresponding subscripts, taking into account max depth.`,bn,bt,yn,j,yt,Ms,lo,Ga=`Constructs a MarkupLM processor which combines a MarkupLM feature extractor and a MarkupLM tokenizer into a single
processor.`,ks,co,Ha='<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> offers all the functionalities you need to prepare data for the model.',bs,po,Ea=`It first uses <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to extract nodes and corresponding xpaths from one or more HTML strings.
Next, these are provided to <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which turns them into token-level
<code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.`,ys,B,Tt,Ts,mo,Wa=`This method first forwards the <code>html_strings</code> argument to <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor.__call__"><strong>call</strong>()</a>. Next, it
passes the <code>nodes</code> and <code>xpaths</code> along with the additional arguments to <code>__call__()</code> and
returns the output.`,ws,uo,Va="Optionally, one can also provide a <code>text</code> argument which is passed along as first sequence.",vs,ho,Sa="Please refer to the docstring of the above two methods for more information.",Tn,wt,wn,S,vt,xs,fo,Qa=`The bare MarkupLM Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ls,G,xt,$s,go,Xa='The <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> forward method, overrides the <code>__call__</code> special method.',Us,de,Js,ce,vn,Lt,xn,Z,$t,zs,_o,Pa=`MarkupLM Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,qs,Mo,Aa=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,js,H,Ut,Cs,ko,Da='The <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Fs,pe,Is,me,Ln,Jt,$n,Q,zt,Ns,bo,Ya=`MarkupLM Model with a <code>token_classification</code> head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Zs,E,qt,Rs,yo,Oa='The <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Bs,ue,Gs,he,Un,jt,Jn,R,Ct,Hs,To,Ka=`MarkupLM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Es,wo,er=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ws,W,Ft,Vs,vo,tr='The <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Ss,fe,Qs,ge,zn,It,qn,Jo,jn;return b=new F({props:{title:"MarkupLM",local:"markuplm",headingTag:"h1"}}),T=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ze=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Ce=new F({props:{title:"Usage: MarkupLMProcessor",local:"usage-markuplmprocessor",headingTag:"h2"}}),Ie=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUyQyUyME1hcmt1cExNVG9rZW5pemVyRmFzdCUyQyUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQXRva2VuaXplciUyMCUzRCUyME1hcmt1cExNVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBNYXJrdXBMTVByb2Nlc3NvcihmZWF0dXJlX2V4dHJhY3RvciUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor, MarkupLMTokenizerFast, MarkupLMProcessor

feature_extractor = MarkupLMFeatureExtractor()
tokenizer = MarkupLMTokenizerFast.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
processor = MarkupLMProcessor(feature_extractor, tokenizer)`,wrap:!1}}),He=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VIZXJlJTIwaXMlMjBteSUyMHdlYnNpdGUuJTNDJTJGcCUzRSUwQSUyMCUzQyUyRmJvZHklM0UlMEElMjAlM0MlMkZodG1sJTNFJTIyJTIyJTIyJTBBJTBBJTIzJTIwbm90ZSUyMHRoYXQlMjB5b3UlMjBjYW4lMjBhbHNvJTIwYWRkJTIwcHJvdmlkZSUyMGFsbCUyMHRva2VuaXplciUyMHBhcmFtZXRlcnMlMjBoZXJlJTIwc3VjaCUyMGFzJTIwcGFkZGluZyUyQyUyMHRydW5jYXRpb24lMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;Here is my website.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note that you can also add provide all tokenizer parameters here such as padding, truncation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Ve=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChlbmNvZGluZy5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Xe=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTJDJTIwMiUyQyUyMDElNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwbm9kZV9sYWJlbHMlM0Rub2RlX2xhYmVscyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>])`,wrap:!1}}),De=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VNeSUyMG5hbWUlMjBpcyUyME5pZWxzLiUzQyUyRnAlM0UlMEElMjAlM0MlMkZib2R5JTNFJTBBJTIwJTNDJTJGaHRtbCUzRSUyMiUyMiUyMiUwQSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwaGlzJTIwbmFtZSUzRiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;My name is Niels.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),Ke=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`,wrap:!1}}),et=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ot=new F({props:{title:"MarkupLMConfig",local:"transformers.MarkupLMConfig",headingTag:"h2"}}),nt=new x({props:{name:"class transformers.MarkupLMConfig",anchor:"transformers.MarkupLMConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_xpath_tag_unit_embeddings",val:" = 256"},{name:"max_xpath_subs_unit_embeddings",val:" = 1024"},{name:"tag_pad_id",val:" = 216"},{name:"subs_pad_id",val:" = 1001"},{name:"xpath_unit_hidden_size",val:" = 32"},{name:"max_depth",val:" = 50"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the MarkupLM model. Defines the different tokens that can be represented by the
<em>inputs_ids</em> passed to the forward method of <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"vocab_size"},{anchor:"transformers.MarkupLMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MarkupLMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MarkupLMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.MarkupLMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.MarkupLMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.MarkupLMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.MarkupLMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.MarkupLMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MarkupLMConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed into <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.MarkupLMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MarkupLMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MarkupLMConfig.max_tree_id_unit_embeddings",description:`<strong>max_tree_id_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the tree id unit embedding might ever use. Typically set this to something large
just in case (e.g., 1024).`,name:"max_tree_id_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_tag_unit_embeddings",description:`<strong>max_xpath_tag_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum value that the xpath tag unit embedding might ever use. Typically set this to something large
just in case (e.g., 256).`,name:"max_xpath_tag_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_subs_unit_embeddings",description:`<strong>max_xpath_subs_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the xpath subscript unit embedding might ever use. Typically set this to something
large just in case (e.g., 1024).`,name:"max_xpath_subs_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.tag_pad_id",description:`<strong>tag_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 216) &#x2014;
The id of the padding token in the xpath tags.`,name:"tag_pad_id"},{anchor:"transformers.MarkupLMConfig.subs_pad_id",description:`<strong>subs_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1001) &#x2014;
The id of the padding token in the xpath subscripts.`,name:"subs_pad_id"},{anchor:"transformers.MarkupLMConfig.xpath_tag_unit_hidden_size",description:`<strong>xpath_tag_unit_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The hidden size of each tree id unit. One complete tree index will have
(50*xpath_tag_unit_hidden_size)-dim.`,name:"xpath_tag_unit_hidden_size"},{anchor:"transformers.MarkupLMConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The maximum depth in xpath.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/configuration_markuplm.py#L24"}}),ne=new Uo({props:{anchor:"transformers.MarkupLMConfig.example",$$slots:{default:[dr]},$$scope:{ctx:$}}}),st=new F({props:{title:"MarkupLMFeatureExtractor",local:"transformers.MarkupLMFeatureExtractor",headingTag:"h2"}}),at=new x({props:{name:"class transformers.MarkupLMFeatureExtractor",anchor:"transformers.MarkupLMFeatureExtractor",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/feature_extraction_markuplm.py#L33"}}),rt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMFeatureExtractor.__call__",parameters:[{name:"html_strings",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMFeatureExtractor.__call__.html_strings",description:`<strong>html_strings</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The HTML string or batch of HTML strings from which to extract nodes and corresponding xpaths.`,name:"html_strings"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/feature_extraction_markuplm.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>nodes</strong> — Nodes.</li>
<li><strong>xpaths</strong> — Corresponding xpaths.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),se=new Uo({props:{anchor:"transformers.MarkupLMFeatureExtractor.__call__.example",$$slots:{default:[cr]},$$scope:{ctx:$}}}),it=new F({props:{title:"MarkupLMTokenizer",local:"transformers.MarkupLMTokenizer",headingTag:"h2"}}),lt=new x({props:{name:"class transformers.MarkupLMTokenizer",anchor:"transformers.MarkupLMTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizer.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizer.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm.py#L128"}}),dt=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ct=new x({props:{name:"get_special_tokens_mask",anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.Retrieve",description:"<strong>Retrieve</strong> sequence ids from a token list that has no special tokens added. This method is called when adding &#x2014;",name:"Retrieve"},{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.special",description:`<strong>special</strong> tokens using the tokenizer <code>prepare_for_model</code> method. &#x2014;
token_ids_0 (<code>List[int]</code>):
List of IDs.
token_ids_1 (<code>List[int]</code>, <em>optional</em>):
Optional second list of IDs for sequence pairs.
already_has_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the token list is already formatted with special tokens for the model.`,name:"special"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),pt=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),mt=new x({props:{name:"save_vocabulary",anchor:"transformers.MarkupLMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm.py#L370"}}),ut=new F({props:{title:"MarkupLMTokenizerFast",local:"transformers.MarkupLMTokenizerFast",headingTag:"h2"}}),ht=new x({props:{name:"class transformers.MarkupLMTokenizerFast",anchor:"transformers.MarkupLMTokenizerFast",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"tokenizer_file",val:" = None"},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"trim_offsets",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizerFast.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L83"}}),ft=new x({props:{name:"batch_encode_plus",anchor:"transformers.MarkupLMTokenizerFast.batch_encode_plus",parameters:[{name:"batch_text_or_text_pairs",val:": Union"},{name:"is_pair",val:": bool = None"},{name:"xpaths",val:": Optional = None"},{name:"node_labels",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L421"}}),gt=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L871",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_t=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L894",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Mt=new x({props:{name:"encode_plus",anchor:"transformers.MarkupLMTokenizerFast.encode_plus",parameters:[{name:"text",val:": Union"},{name:"text_pair",val:": Optional = None"},{name:"xpaths",val:": Optional = None"},{name:"node_labels",val:": Optional = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The first sequence to be encoded. This can be a string, a list of strings or a list of list of strings.`,name:"text"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text_pair",description:`<strong>text_pair</strong> (<code>List[str]</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second sequence to be encoded. This can be a list of strings (words of a single example) or a
list of list of strings (words of a batch of examples).`,name:"text_pair"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_28071/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L488"}}),kt=new x({props:{name:"get_xpath_seq",anchor:"transformers.MarkupLMTokenizerFast.get_xpath_seq",parameters:[{name:"xpath",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L251"}}),bt=new F({props:{title:"MarkupLMProcessor",local:"transformers.MarkupLMProcessor",headingTag:"h2"}}),yt=new x({props:{name:"class transformers.MarkupLMProcessor",anchor:"transformers.MarkupLMProcessor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MarkupLMFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MarkupLMProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>MarkupLMTokenizer</code> or <code>MarkupLMTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.MarkupLMProcessor.parse_html",description:`<strong>parse_html</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use <code>MarkupLMFeatureExtractor</code> to parse HTML strings into nodes and corresponding xpaths.`,name:"parse_html"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/processing_markuplm.py#L26"}}),Tt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMProcessor.__call__",parameters:[{name:"html_strings",val:" = None"},{name:"nodes",val:" = None"},{name:"xpaths",val:" = None"},{name:"node_labels",val:" = None"},{name:"questions",val:" = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"return_tensors",val:": Union = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/processing_markuplm.py#L50"}}),wt=new F({props:{title:"MarkupLMModel",local:"transformers.MarkupLMModel",headingTag:"h2"}}),vt=new x({props:{name:"class transformers.MarkupLMModel",anchor:"transformers.MarkupLMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L802"}}),xt=new x({props:{name:"forward",anchor:"transformers.MarkupLMModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMModel.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMModel.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L834",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Nn({props:{$$slots:{default:[pr]},$$scope:{ctx:$}}}),ce=new Uo({props:{anchor:"transformers.MarkupLMModel.forward.example",$$slots:{default:[mr]},$$scope:{ctx:$}}}),Lt=new F({props:{title:"MarkupLMForSequenceClassification",local:"transformers.MarkupLMForSequenceClassification",headingTag:"h2"}}),$t=new x({props:{name:"class transformers.MarkupLMForSequenceClassification",anchor:"transformers.MarkupLMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L1204"}}),Ut=new x({props:{name:"forward",anchor:"transformers.MarkupLMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new Nn({props:{$$slots:{default:[ur]},$$scope:{ctx:$}}}),me=new Uo({props:{anchor:"transformers.MarkupLMForSequenceClassification.forward.example",$$slots:{default:[hr]},$$scope:{ctx:$}}}),Jt=new F({props:{title:"MarkupLMForTokenClassification",local:"transformers.MarkupLMForTokenClassification",headingTag:"h2"}}),zt=new x({props:{name:"class transformers.MarkupLMForTokenClassification",anchor:"transformers.MarkupLMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L1104"}}),qt=new x({props:{name:"forward",anchor:"transformers.MarkupLMForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L1121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new Nn({props:{$$slots:{default:[fr]},$$scope:{ctx:$}}}),he=new Uo({props:{anchor:"transformers.MarkupLMForTokenClassification.forward.example",$$slots:{default:[gr]},$$scope:{ctx:$}}}),jt=new F({props:{title:"MarkupLMForQuestionAnswering",local:"transformers.MarkupLMForQuestionAnswering",headingTag:"h2"}}),Ct=new x({props:{name:"class transformers.MarkupLMForQuestionAnswering",anchor:"transformers.MarkupLMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L978"}}),Ft=new x({props:{name:"forward",anchor:"transformers.MarkupLMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"xpath_tags_seq",val:": Optional = None"},{name:"xpath_subs_seq",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28071/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/markuplm/modeling_markuplm.py#L997",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new Nn({props:{$$slots:{default:[_r]},$$scope:{ctx:$}}}),ge=new Uo({props:{anchor:"transformers.MarkupLMForQuestionAnswering.forward.example",$$slots:{default:[Mr]},$$scope:{ctx:$}}}),It=new lr({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/markuplm.md"}}),{c(){c=i("meta"),y=n(),k=i("p"),M=n(),m(b.$$.fragment),d=n(),m(T.$$.fragment),jo=n(),ve=i("p"),ve.innerHTML=Xs,Co=n(),xe=i("p"),xe.textContent=Ps,Fo=n(),Le=i("ul"),Le.innerHTML=As,Io=n(),$e=i("p"),$e.textContent=Ds,No=n(),Ue=i("p"),Ue.innerHTML=Ys,Zo=n(),Je=i("p"),Je.innerHTML=Os,Ro=n(),m(ze.$$.fragment),Bo=n(),qe=i("ul"),qe.innerHTML=Ks,Go=n(),oe=i("img"),Ho=n(),je=i("small"),je.innerHTML=ta,Eo=n(),m(Ce.$$.fragment),Wo=n(),Fe=i("p"),Fe.innerHTML=oa,Vo=n(),m(Ie.$$.fragment),So=n(),Ne=i("p"),Ne.innerHTML=na,Qo=n(),Ze=i("p"),Ze.innerHTML=sa,Xo=n(),Re=i("p"),Re.textContent=aa,Po=n(),Be=i("p"),Be.innerHTML=ra,Ao=n(),Ge=i("p"),Ge.textContent=ia,Do=n(),m(He.$$.fragment),Yo=n(),Ee=i("p"),Ee.innerHTML=la,Oo=n(),We=i("p"),We.innerHTML=da,Ko=n(),m(Ve.$$.fragment),en=n(),Se=i("p"),Se.innerHTML=ca,tn=n(),Qe=i("p"),Qe.innerHTML=pa,on=n(),m(Xe.$$.fragment),nn=n(),Pe=i("p"),Pe.innerHTML=ma,sn=n(),Ae=i("p"),Ae.textContent=ua,an=n(),m(De.$$.fragment),rn=n(),Ye=i("p"),Ye.innerHTML=ha,ln=n(),Oe=i("p"),Oe.innerHTML=fa,dn=n(),m(Ke.$$.fragment),cn=n(),m(et.$$.fragment),pn=n(),tt=i("ul"),tt.innerHTML=ga,mn=n(),m(ot.$$.fragment),un=n(),I=i("div"),m(nt.$$.fragment),Zn=n(),Zt=i("p"),Zt.innerHTML=_a,Rn=n(),Rt=i("p"),Rt.innerHTML=Ma,Bn=n(),m(ne.$$.fragment),hn=n(),m(st.$$.fragment),fn=n(),N=i("div"),m(at.$$.fragment),Gn=n(),Bt=i("p"),Bt.textContent=ka,Hn=n(),Gt=i("p"),Gt.innerHTML=ba,En=n(),A=i("div"),m(rt.$$.fragment),Wn=n(),Ht=i("p"),Ht.textContent=ya,Vn=n(),m(se.$$.fragment),gn=n(),m(it.$$.fragment),_n=n(),z=i("div"),m(lt.$$.fragment),Sn=n(),Et=i("p"),Et.innerHTML=Ta,Qn=n(),D=i("div"),m(dt.$$.fragment),Xn=n(),Wt=i("p"),Wt.textContent=wa,Pn=n(),Vt=i("ul"),Vt.innerHTML=va,An=n(),St=i("div"),m(ct.$$.fragment),Dn=n(),ae=i("div"),m(pt.$$.fragment),Yn=n(),Qt=i("p"),Qt.textContent=xa,On=n(),Xt=i("div"),m(mt.$$.fragment),Mn=n(),m(ut.$$.fragment),kn=n(),L=i("div"),m(ht.$$.fragment),Kn=n(),Pt=i("p"),Pt.textContent=La,es=n(),At=i("p"),At.innerHTML=$a,ts=n(),Dt=i("p"),Dt.textContent=Ua,os=n(),J=i("div"),m(ft.$$.fragment),ns=n(),Yt=i("p"),Yt.innerHTML=Ja,ss=n(),Ot=i("ul"),Ot.innerHTML=za,as=n(),Kt=i("p"),Kt.innerHTML=qa,rs=n(),eo=i("ul"),eo.innerHTML=ja,is=n(),to=i("p"),to.innerHTML=Ca,ls=n(),oo=i("ul"),oo.innerHTML=Fa,ds=n(),Y=i("div"),m(gt.$$.fragment),cs=n(),no=i("p"),no.textContent=Ia,ps=n(),so=i("ul"),so.innerHTML=Na,ms=n(),re=i("div"),m(_t.$$.fragment),us=n(),ao=i("p"),ao.textContent=Za,hs=n(),ie=i("div"),m(Mt.$$.fragment),fs=n(),ro=i("p"),ro.innerHTML=Ra,gs=n(),le=i("div"),m(kt.$$.fragment),_s=n(),io=i("p"),io.textContent=Ba,bn=n(),m(bt.$$.fragment),yn=n(),j=i("div"),m(yt.$$.fragment),Ms=n(),lo=i("p"),lo.textContent=Ga,ks=n(),co=i("p"),co.innerHTML=Ha,bs=n(),po=i("p"),po.innerHTML=Ea,ys=n(),B=i("div"),m(Tt.$$.fragment),Ts=n(),mo=i("p"),mo.innerHTML=Wa,ws=n(),uo=i("p"),uo.innerHTML=Va,vs=n(),ho=i("p"),ho.textContent=Sa,Tn=n(),m(wt.$$.fragment),wn=n(),S=i("div"),m(vt.$$.fragment),xs=n(),fo=i("p"),fo.innerHTML=Qa,Ls=n(),G=i("div"),m(xt.$$.fragment),$s=n(),go=i("p"),go.innerHTML=Xa,Us=n(),m(de.$$.fragment),Js=n(),m(ce.$$.fragment),vn=n(),m(Lt.$$.fragment),xn=n(),Z=i("div"),m($t.$$.fragment),zs=n(),_o=i("p"),_o.textContent=Pa,qs=n(),Mo=i("p"),Mo.innerHTML=Aa,js=n(),H=i("div"),m(Ut.$$.fragment),Cs=n(),ko=i("p"),ko.innerHTML=Da,Fs=n(),m(pe.$$.fragment),Is=n(),m(me.$$.fragment),Ln=n(),m(Jt.$$.fragment),$n=n(),Q=i("div"),m(zt.$$.fragment),Ns=n(),bo=i("p"),bo.innerHTML=Ya,Zs=n(),E=i("div"),m(qt.$$.fragment),Rs=n(),yo=i("p"),yo.innerHTML=Oa,Bs=n(),m(ue.$$.fragment),Gs=n(),m(he.$$.fragment),Un=n(),m(jt.$$.fragment),Jn=n(),R=i("div"),m(Ct.$$.fragment),Hs=n(),To=i("p"),To.innerHTML=Ka,Es=n(),wo=i("p"),wo.innerHTML=er,Ws=n(),W=i("div"),m(Ft.$$.fragment),Vs=n(),vo=i("p"),vo.innerHTML=tr,Ss=n(),m(fe.$$.fragment),Qs=n(),m(ge.$$.fragment),zn=n(),m(It.$$.fragment),qn=n(),Jo=i("p"),this.h()},l(e){const t=ir("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(o),y=s(e),k=l(e,"P",{}),v(k).forEach(o),M=s(e),u(b.$$.fragment,e),d=s(e),u(T.$$.fragment,e),jo=s(e),ve=l(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1t0sxmg"&&(ve.innerHTML=Xs),Co=s(e),xe=l(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1ytlk74"&&(xe.textContent=Ps),Fo=s(e),Le=l(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-6h13ie"&&(Le.innerHTML=As),Io=s(e),$e=l(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-vfdo9a"&&($e.textContent=Ds),No=s(e),Ue=l(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-hdnp88"&&(Ue.innerHTML=Ys),Zo=s(e),Je=l(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-rdxa92"&&(Je.innerHTML=Os),Ro=s(e),u(ze.$$.fragment,e),Bo=s(e),qe=l(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-btjm0v"&&(qe.innerHTML=Ks),Go=s(e),oe=l(e,"IMG",{src:!0,alt:!0,width:!0}),Ho=s(e),je=l(e,"SMALL",{"data-svelte-h":!0}),p(je)!=="svelte-1ylkkn"&&(je.innerHTML=ta),Eo=s(e),u(Ce.$$.fragment,e),Wo=s(e),Fe=l(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1b5xync"&&(Fe.innerHTML=oa),Vo=s(e),u(Ie.$$.fragment,e),So=s(e),Ne=l(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-jmzcqd"&&(Ne.innerHTML=na),Qo=s(e),Ze=l(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-h6xeeb"&&(Ze.innerHTML=sa),Xo=s(e),Re=l(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-jv0had"&&(Re.textContent=aa),Po=s(e),Be=l(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-dkcsne"&&(Be.innerHTML=ra),Ao=s(e),Ge=l(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-6kpuj"&&(Ge.textContent=ia),Do=s(e),u(He.$$.fragment,e),Yo=s(e),Ee=l(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1i783jq"&&(Ee.innerHTML=la),Oo=s(e),We=l(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-glfvnv"&&(We.innerHTML=da),Ko=s(e),u(Ve.$$.fragment,e),en=s(e),Se=l(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-owkrw8"&&(Se.innerHTML=ca),tn=s(e),Qe=l(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1x7hckg"&&(Qe.innerHTML=pa),on=s(e),u(Xe.$$.fragment,e),nn=s(e),Pe=l(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-34jdzj"&&(Pe.innerHTML=ma),sn=s(e),Ae=l(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-11r3tgp"&&(Ae.textContent=ua),an=s(e),u(De.$$.fragment,e),rn=s(e),Ye=l(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-147vwql"&&(Ye.innerHTML=ha),ln=s(e),Oe=l(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1wesasz"&&(Oe.innerHTML=fa),dn=s(e),u(Ke.$$.fragment,e),cn=s(e),u(et.$$.fragment,e),pn=s(e),tt=l(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-1o7x1ln"&&(tt.innerHTML=ga),mn=s(e),u(ot.$$.fragment,e),un=s(e),I=l(e,"DIV",{class:!0});var X=v(I);u(nt.$$.fragment,X),Zn=s(X),Zt=l(X,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1hqk0ce"&&(Zt.innerHTML=_a),Rn=s(X),Rt=l(X,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1mzzm23"&&(Rt.innerHTML=Ma),Bn=s(X),u(ne.$$.fragment,X),X.forEach(o),hn=s(e),u(st.$$.fragment,e),fn=s(e),N=l(e,"DIV",{class:!0});var P=v(N);u(at.$$.fragment,P),Gn=s(P),Bt=l(P,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-t29t5v"&&(Bt.textContent=ka),Hn=s(P),Gt=l(P,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1xyp3q9"&&(Gt.innerHTML=ba),En=s(P),A=l(P,"DIV",{class:!0});var ee=v(A);u(rt.$$.fragment,ee),Wn=s(ee),Ht=l(ee,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-ep3db5"&&(Ht.textContent=ya),Vn=s(ee),u(se.$$.fragment,ee),ee.forEach(o),P.forEach(o),gn=s(e),u(it.$$.fragment,e),_n=s(e),z=l(e,"DIV",{class:!0});var C=v(z);u(lt.$$.fragment,C),Sn=s(C),Et=l(C,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-700zbh"&&(Et.innerHTML=Ta),Qn=s(C),D=l(C,"DIV",{class:!0});var te=v(D);u(dt.$$.fragment,te),Xn=s(te),Wt=l(te,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-og4clw"&&(Wt.textContent=wa),Pn=s(te),Vt=l(te,"UL",{"data-svelte-h":!0}),p(Vt)!=="svelte-rq8uot"&&(Vt.innerHTML=va),te.forEach(o),An=s(C),St=l(C,"DIV",{class:!0});var zo=v(St);u(ct.$$.fragment,zo),zo.forEach(o),Dn=s(C),ae=l(C,"DIV",{class:!0});var Nt=v(ae);u(pt.$$.fragment,Nt),Yn=s(Nt),Qt=l(Nt,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-wwxeoo"&&(Qt.textContent=xa),Nt.forEach(o),On=s(C),Xt=l(C,"DIV",{class:!0});var qo=v(Xt);u(mt.$$.fragment,qo),qo.forEach(o),C.forEach(o),Mn=s(e),u(ut.$$.fragment,e),kn=s(e),L=l(e,"DIV",{class:!0});var U=v(L);u(ht.$$.fragment,U),Kn=s(U),Pt=l(U,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-w71jv6"&&(Pt.textContent=La),es=s(U),At=l(U,"P",{"data-svelte-h":!0}),p(At)!=="svelte-17vnevg"&&(At.innerHTML=$a),ts=s(U),Dt=l(U,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1x24yjd"&&(Dt.textContent=Ua),os=s(U),J=l(U,"DIV",{class:!0});var q=v(J);u(ft.$$.fragment,q),ns=s(q),Yt=l(q,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-11vymkz"&&(Yt.innerHTML=Ja),ss=s(q),Ot=l(q,"UL",{"data-svelte-h":!0}),p(Ot)!=="svelte-1qgqc1b"&&(Ot.innerHTML=za),as=s(q),Kt=l(q,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-12rz1z9"&&(Kt.innerHTML=qa),rs=s(q),eo=l(q,"UL",{"data-svelte-h":!0}),p(eo)!=="svelte-sxb3sg"&&(eo.innerHTML=ja),is=s(q),to=l(q,"P",{"data-svelte-h":!0}),p(to)!=="svelte-1hqzrao"&&(to.innerHTML=Ca),ls=s(q),oo=l(q,"UL",{"data-svelte-h":!0}),p(oo)!=="svelte-bu4osf"&&(oo.innerHTML=Fa),q.forEach(o),ds=s(U),Y=l(U,"DIV",{class:!0});var xo=v(Y);u(gt.$$.fragment,xo),cs=s(xo),no=l(xo,"P",{"data-svelte-h":!0}),p(no)!=="svelte-og4clw"&&(no.textContent=Ia),ps=s(xo),so=l(xo,"UL",{"data-svelte-h":!0}),p(so)!=="svelte-rq8uot"&&(so.innerHTML=Na),xo.forEach(o),ms=s(U),re=l(U,"DIV",{class:!0});var Cn=v(re);u(_t.$$.fragment,Cn),us=s(Cn),ao=l(Cn,"P",{"data-svelte-h":!0}),p(ao)!=="svelte-wwxeoo"&&(ao.textContent=Za),Cn.forEach(o),hs=s(U),ie=l(U,"DIV",{class:!0});var Fn=v(ie);u(Mt.$$.fragment,Fn),fs=s(Fn),ro=l(Fn,"P",{"data-svelte-h":!0}),p(ro)!=="svelte-1eppb6b"&&(ro.innerHTML=Ra),Fn.forEach(o),gs=s(U),le=l(U,"DIV",{class:!0});var In=v(le);u(kt.$$.fragment,In),_s=s(In),io=l(In,"P",{"data-svelte-h":!0}),p(io)!=="svelte-19qak01"&&(io.textContent=Ba),In.forEach(o),U.forEach(o),bn=s(e),u(bt.$$.fragment,e),yn=s(e),j=l(e,"DIV",{class:!0});var O=v(j);u(yt.$$.fragment,O),Ms=s(O),lo=l(O,"P",{"data-svelte-h":!0}),p(lo)!=="svelte-jukxuq"&&(lo.textContent=Ga),ks=s(O),co=l(O,"P",{"data-svelte-h":!0}),p(co)!=="svelte-84a86c"&&(co.innerHTML=Ha),bs=s(O),po=l(O,"P",{"data-svelte-h":!0}),p(po)!=="svelte-9i1jd4"&&(po.innerHTML=Ea),ys=s(O),B=l(O,"DIV",{class:!0});var _e=v(B);u(Tt.$$.fragment,_e),Ts=s(_e),mo=l(_e,"P",{"data-svelte-h":!0}),p(mo)!=="svelte-6983do"&&(mo.innerHTML=Wa),ws=s(_e),uo=l(_e,"P",{"data-svelte-h":!0}),p(uo)!=="svelte-yz8mju"&&(uo.innerHTML=Va),vs=s(_e),ho=l(_e,"P",{"data-svelte-h":!0}),p(ho)!=="svelte-ws0hzs"&&(ho.textContent=Sa),_e.forEach(o),O.forEach(o),Tn=s(e),u(wt.$$.fragment,e),wn=s(e),S=l(e,"DIV",{class:!0});var Lo=v(S);u(vt.$$.fragment,Lo),xs=s(Lo),fo=l(Lo,"P",{"data-svelte-h":!0}),p(fo)!=="svelte-du7a53"&&(fo.innerHTML=Qa),Ls=s(Lo),G=l(Lo,"DIV",{class:!0});var Me=v(G);u(xt.$$.fragment,Me),$s=s(Me),go=l(Me,"P",{"data-svelte-h":!0}),p(go)!=="svelte-kcrv2o"&&(go.innerHTML=Xa),Us=s(Me),u(de.$$.fragment,Me),Js=s(Me),u(ce.$$.fragment,Me),Me.forEach(o),Lo.forEach(o),vn=s(e),u(Lt.$$.fragment,e),xn=s(e),Z=l(e,"DIV",{class:!0});var ke=v(Z);u($t.$$.fragment,ke),zs=s(ke),_o=l(ke,"P",{"data-svelte-h":!0}),p(_o)!=="svelte-hwwz9z"&&(_o.textContent=Pa),qs=s(ke),Mo=l(ke,"P",{"data-svelte-h":!0}),p(Mo)!=="svelte-68lg8f"&&(Mo.innerHTML=Aa),js=s(ke),H=l(ke,"DIV",{class:!0});var be=v(H);u(Ut.$$.fragment,be),Cs=s(be),ko=l(be,"P",{"data-svelte-h":!0}),p(ko)!=="svelte-c3gns"&&(ko.innerHTML=Da),Fs=s(be),u(pe.$$.fragment,be),Is=s(be),u(me.$$.fragment,be),be.forEach(o),ke.forEach(o),Ln=s(e),u(Jt.$$.fragment,e),$n=s(e),Q=l(e,"DIV",{class:!0});var $o=v(Q);u(zt.$$.fragment,$o),Ns=s($o),bo=l($o,"P",{"data-svelte-h":!0}),p(bo)!=="svelte-z4eix7"&&(bo.innerHTML=Ya),Zs=s($o),E=l($o,"DIV",{class:!0});var ye=v(E);u(qt.$$.fragment,ye),Rs=s(ye),yo=l(ye,"P",{"data-svelte-h":!0}),p(yo)!=="svelte-10put22"&&(yo.innerHTML=Oa),Bs=s(ye),u(ue.$$.fragment,ye),Gs=s(ye),u(he.$$.fragment,ye),ye.forEach(o),$o.forEach(o),Un=s(e),u(jt.$$.fragment,e),Jn=s(e),R=l(e,"DIV",{class:!0});var Te=v(R);u(Ct.$$.fragment,Te),Hs=s(Te),To=l(Te,"P",{"data-svelte-h":!0}),p(To)!=="svelte-15cf5fq"&&(To.innerHTML=Ka),Es=s(Te),wo=l(Te,"P",{"data-svelte-h":!0}),p(wo)!=="svelte-68lg8f"&&(wo.innerHTML=er),Ws=s(Te),W=l(Te,"DIV",{class:!0});var we=v(W);u(Ft.$$.fragment,we),Vs=s(we),vo=l(we,"P",{"data-svelte-h":!0}),p(vo)!=="svelte-n9a1vw"&&(vo.innerHTML=tr),Ss=s(we),u(fe.$$.fragment,we),Qs=s(we),u(ge.$$.fragment,we),we.forEach(o),Te.forEach(o),zn=s(e),u(It.$$.fragment,e),qn=s(e),Jo=l(e,"P",{}),v(Jo).forEach(o),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",br),nr(oe.src,ea="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/markuplm_architecture.jpg")||w(oe,"src",ea),w(oe,"alt","drawing"),w(oe,"width","600"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,c),r(e,y,t),r(e,k,t),r(e,M,t),h(b,e,t),r(e,d,t),h(T,e,t),r(e,jo,t),r(e,ve,t),r(e,Co,t),r(e,xe,t),r(e,Fo,t),r(e,Le,t),r(e,Io,t),r(e,$e,t),r(e,No,t),r(e,Ue,t),r(e,Zo,t),r(e,Je,t),r(e,Ro,t),h(ze,e,t),r(e,Bo,t),r(e,qe,t),r(e,Go,t),r(e,oe,t),r(e,Ho,t),r(e,je,t),r(e,Eo,t),h(Ce,e,t),r(e,Wo,t),r(e,Fe,t),r(e,Vo,t),h(Ie,e,t),r(e,So,t),r(e,Ne,t),r(e,Qo,t),r(e,Ze,t),r(e,Xo,t),r(e,Re,t),r(e,Po,t),r(e,Be,t),r(e,Ao,t),r(e,Ge,t),r(e,Do,t),h(He,e,t),r(e,Yo,t),r(e,Ee,t),r(e,Oo,t),r(e,We,t),r(e,Ko,t),h(Ve,e,t),r(e,en,t),r(e,Se,t),r(e,tn,t),r(e,Qe,t),r(e,on,t),h(Xe,e,t),r(e,nn,t),r(e,Pe,t),r(e,sn,t),r(e,Ae,t),r(e,an,t),h(De,e,t),r(e,rn,t),r(e,Ye,t),r(e,ln,t),r(e,Oe,t),r(e,dn,t),h(Ke,e,t),r(e,cn,t),h(et,e,t),r(e,pn,t),r(e,tt,t),r(e,mn,t),h(ot,e,t),r(e,un,t),r(e,I,t),h(nt,I,null),a(I,Zn),a(I,Zt),a(I,Rn),a(I,Rt),a(I,Bn),h(ne,I,null),r(e,hn,t),h(st,e,t),r(e,fn,t),r(e,N,t),h(at,N,null),a(N,Gn),a(N,Bt),a(N,Hn),a(N,Gt),a(N,En),a(N,A),h(rt,A,null),a(A,Wn),a(A,Ht),a(A,Vn),h(se,A,null),r(e,gn,t),h(it,e,t),r(e,_n,t),r(e,z,t),h(lt,z,null),a(z,Sn),a(z,Et),a(z,Qn),a(z,D),h(dt,D,null),a(D,Xn),a(D,Wt),a(D,Pn),a(D,Vt),a(z,An),a(z,St),h(ct,St,null),a(z,Dn),a(z,ae),h(pt,ae,null),a(ae,Yn),a(ae,Qt),a(z,On),a(z,Xt),h(mt,Xt,null),r(e,Mn,t),h(ut,e,t),r(e,kn,t),r(e,L,t),h(ht,L,null),a(L,Kn),a(L,Pt),a(L,es),a(L,At),a(L,ts),a(L,Dt),a(L,os),a(L,J),h(ft,J,null),a(J,ns),a(J,Yt),a(J,ss),a(J,Ot),a(J,as),a(J,Kt),a(J,rs),a(J,eo),a(J,is),a(J,to),a(J,ls),a(J,oo),a(L,ds),a(L,Y),h(gt,Y,null),a(Y,cs),a(Y,no),a(Y,ps),a(Y,so),a(L,ms),a(L,re),h(_t,re,null),a(re,us),a(re,ao),a(L,hs),a(L,ie),h(Mt,ie,null),a(ie,fs),a(ie,ro),a(L,gs),a(L,le),h(kt,le,null),a(le,_s),a(le,io),r(e,bn,t),h(bt,e,t),r(e,yn,t),r(e,j,t),h(yt,j,null),a(j,Ms),a(j,lo),a(j,ks),a(j,co),a(j,bs),a(j,po),a(j,ys),a(j,B),h(Tt,B,null),a(B,Ts),a(B,mo),a(B,ws),a(B,uo),a(B,vs),a(B,ho),r(e,Tn,t),h(wt,e,t),r(e,wn,t),r(e,S,t),h(vt,S,null),a(S,xs),a(S,fo),a(S,Ls),a(S,G),h(xt,G,null),a(G,$s),a(G,go),a(G,Us),h(de,G,null),a(G,Js),h(ce,G,null),r(e,vn,t),h(Lt,e,t),r(e,xn,t),r(e,Z,t),h($t,Z,null),a(Z,zs),a(Z,_o),a(Z,qs),a(Z,Mo),a(Z,js),a(Z,H),h(Ut,H,null),a(H,Cs),a(H,ko),a(H,Fs),h(pe,H,null),a(H,Is),h(me,H,null),r(e,Ln,t),h(Jt,e,t),r(e,$n,t),r(e,Q,t),h(zt,Q,null),a(Q,Ns),a(Q,bo),a(Q,Zs),a(Q,E),h(qt,E,null),a(E,Rs),a(E,yo),a(E,Bs),h(ue,E,null),a(E,Gs),h(he,E,null),r(e,Un,t),h(jt,e,t),r(e,Jn,t),r(e,R,t),h(Ct,R,null),a(R,Hs),a(R,To),a(R,Es),a(R,wo),a(R,Ws),a(R,W),h(Ft,W,null),a(W,Vs),a(W,vo),a(W,Ss),h(fe,W,null),a(W,Qs),h(ge,W,null),r(e,zn,t),h(It,e,t),r(e,qn,t),r(e,Jo,t),jn=!0},p(e,[t]){const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),ne.$set(X);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),se.$set(P);const ee={};t&2&&(ee.$$scope={dirty:t,ctx:e}),de.$set(ee);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),ce.$set(C);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),pe.$set(te);const zo={};t&2&&(zo.$$scope={dirty:t,ctx:e}),me.$set(zo);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),ue.$set(Nt);const qo={};t&2&&(qo.$$scope={dirty:t,ctx:e}),he.$set(qo);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),fe.$set(U);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),ge.$set(q)},i(e){jn||(f(b.$$.fragment,e),f(T.$$.fragment,e),f(ze.$$.fragment,e),f(Ce.$$.fragment,e),f(Ie.$$.fragment,e),f(He.$$.fragment,e),f(Ve.$$.fragment,e),f(Xe.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(ne.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(se.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(gt.$$.fragment,e),f(_t.$$.fragment,e),f(Mt.$$.fragment,e),f(kt.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(Tt.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(xt.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(Lt.$$.fragment,e),f($t.$$.fragment,e),f(Ut.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(Jt.$$.fragment,e),f(zt.$$.fragment,e),f(qt.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(jt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ft.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(It.$$.fragment,e),jn=!0)},o(e){g(b.$$.fragment,e),g(T.$$.fragment,e),g(ze.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(He.$$.fragment,e),g(Ve.$$.fragment,e),g(Xe.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(ot.$$.fragment,e),g(nt.$$.fragment,e),g(ne.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(se.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(mt.$$.fragment,e),g(ut.$$.fragment,e),g(ht.$$.fragment,e),g(ft.$$.fragment,e),g(gt.$$.fragment,e),g(_t.$$.fragment,e),g(Mt.$$.fragment,e),g(kt.$$.fragment,e),g(bt.$$.fragment,e),g(yt.$$.fragment,e),g(Tt.$$.fragment,e),g(wt.$$.fragment,e),g(vt.$$.fragment,e),g(xt.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(Lt.$$.fragment,e),g($t.$$.fragment,e),g(Ut.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(Jt.$$.fragment,e),g(zt.$$.fragment,e),g(qt.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(jt.$$.fragment,e),g(Ct.$$.fragment,e),g(Ft.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(It.$$.fragment,e),jn=!1},d(e){e&&(o(y),o(k),o(M),o(d),o(jo),o(ve),o(Co),o(xe),o(Fo),o(Le),o(Io),o($e),o(No),o(Ue),o(Zo),o(Je),o(Ro),o(Bo),o(qe),o(Go),o(oe),o(Ho),o(je),o(Eo),o(Wo),o(Fe),o(Vo),o(So),o(Ne),o(Qo),o(Ze),o(Xo),o(Re),o(Po),o(Be),o(Ao),o(Ge),o(Do),o(Yo),o(Ee),o(Oo),o(We),o(Ko),o(en),o(Se),o(tn),o(Qe),o(on),o(nn),o(Pe),o(sn),o(Ae),o(an),o(rn),o(Ye),o(ln),o(Oe),o(dn),o(cn),o(pn),o(tt),o(mn),o(un),o(I),o(hn),o(fn),o(N),o(gn),o(_n),o(z),o(Mn),o(kn),o(L),o(bn),o(yn),o(j),o(Tn),o(wn),o(S),o(vn),o(xn),o(Z),o(Ln),o($n),o(Q),o(Un),o(Jn),o(R),o(zn),o(qn),o(Jo)),o(c),_(b,e),_(T,e),_(ze,e),_(Ce,e),_(Ie,e),_(He,e),_(Ve,e),_(Xe,e),_(De,e),_(Ke,e),_(et,e),_(ot,e),_(nt),_(ne),_(st,e),_(at),_(rt),_(se),_(it,e),_(lt),_(dt),_(ct),_(pt),_(mt),_(ut,e),_(ht),_(ft),_(gt),_(_t),_(Mt),_(kt),_(bt,e),_(yt),_(Tt),_(wt,e),_(vt),_(xt),_(de),_(ce),_(Lt,e),_($t),_(Ut),_(pe),_(me),_(Jt,e),_(zt),_(qt),_(ue),_(he),_(jt,e),_(Ct),_(Ft),_(fe),_(ge),_(It,e)}}}const br='{"title":"MarkupLM","local":"markuplm","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage: MarkupLMProcessor","local":"usage-markuplmprocessor","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MarkupLMConfig","local":"transformers.MarkupLMConfig","sections":[],"depth":2},{"title":"MarkupLMFeatureExtractor","local":"transformers.MarkupLMFeatureExtractor","sections":[],"depth":2},{"title":"MarkupLMTokenizer","local":"transformers.MarkupLMTokenizer","sections":[],"depth":2},{"title":"MarkupLMTokenizerFast","local":"transformers.MarkupLMTokenizerFast","sections":[],"depth":2},{"title":"MarkupLMProcessor","local":"transformers.MarkupLMProcessor","sections":[],"depth":2},{"title":"MarkupLMModel","local":"transformers.MarkupLMModel","sections":[],"depth":2},{"title":"MarkupLMForSequenceClassification","local":"transformers.MarkupLMForSequenceClassification","sections":[],"depth":2},{"title":"MarkupLMForTokenClassification","local":"transformers.MarkupLMForTokenClassification","sections":[],"depth":2},{"title":"MarkupLMForQuestionAnswering","local":"transformers.MarkupLMForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function yr($){return sr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jr extends ar{constructor(c){super(),rr(this,c,yr,kr,or,{})}}export{Jr as component};
