import{s as Bt,o as Gt,n as Ce}from"../chunks/scheduler.37c15a92.js";import{S as kt,i as Vt,g as h,s as a,r as p,A as Wt,h as y,f as t,c as n,j as xt,u as o,x as u,k as Zt,y as Rt,a as l,v as r,d as c,t as M,w as d}from"../chunks/index.2bf4358c.js";import{T as Re}from"../chunks/Tip.363c041f.js";import{Y as Ct}from"../chunks/Youtube.1e50a667.js";import{C as J}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Nt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as Ls,E as Xt}from"../chunks/EditOnGithub.8916dc7c.js";function Et(T){let i,f='✎ By default, 🤗 Datasets will decompress the files needed to load a dataset. If you want to preserve hard drive space, you can pass <code>DownloadConfig(delete_extracted=True)</code> to the <code>download_config</code> argument of <code>load_dataset()</code>. See the <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentation</a> for more details.';return{c(){i=h("p"),i.innerHTML=f},l(m){i=y(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1j3uv2u"&&(i.innerHTML=f)},m(m,w){l(m,i,w)},p:Ce,d(m){m&&t(i)}}}function vt(T){let i,f='✏️ <strong>Try it out!</strong> Pick one of the <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">subsets</a> from the Pile that is larger than your laptop or desktop’s RAM, load it with 🤗 Datasets, and measure the amount of RAM used. Note that to get an accurate measurement, you’ll want to do this in a new process. You can find the decompressed sizes of each subset in Table 1 of <a href="https://arxiv.org/abs/2101.00027" rel="nofollow">the Pile paper</a>.';return{c(){i=h("p"),i.innerHTML=f},l(m){i=y(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-16kedbl"&&(i.innerHTML=f)},m(m,w){l(m,i,w)},p:Ce,d(m){m&&t(i)}}}function _t(T){let i,f='💡 In Jupyter notebooks you can also time cells using the <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code> magic function</a>.';return{c(){i=h("p"),i.innerHTML=f},l(m){i=y(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-8b0mae"&&(i.innerHTML=f)},m(m,w){l(m,i,w)},p:Ce,d(m){m&&t(i)}}}function Qt(T){let i,f="💡 To speed up tokenization with streaming you can pass <code>batched=True</code>, as we saw in the last section. It will process the examples batch by batch; the default batch size is 1,000 and can be specified with the <code>batch_size</code> argument.";return{c(){i=h("p"),i.innerHTML=f},l(m){i=y(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-81vf72"&&(i.innerHTML=f)},m(m,w){l(m,i,w)},p:Ce,d(m){m&&t(i)}}}function Yt(T){let i,f='✏️ <strong>Try it out!</strong> Use one of the large Common Crawl corpora like <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> or <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> to create a streaming multilingual dataset that represents the spoken proportions of languages in a country of your choice. For example, the four national languages in Switzerland are German, French, Italian, and Romansh, so you could try creating a Swiss corpus by sampling the Oscar subsets according to their spoken proportion.';return{c(){i=h("p"),i.innerHTML=f},l(m){i=y(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1e4y0rz"&&(i.innerHTML=f)},m(m,w){l(m,i,w)},p:Ce,d(m){m&&t(i)}}}function zt(T){let i,f,m,w,$,Ne,x,Xe,Z,Ps="Nowadays it is not uncommon to find yourself working with multi-gigabyte datasets, especially if you’re planning to pretrain a transformer like BERT or GPT-2 from scratch. In these cases, even <em>loading</em> the data can be a challenge. For example, the WebText corpus used to pretrain GPT-2 consists of over 8 million documents and 40 GB of text — loading this into your laptop’s RAM is likely to give it a heart attack!",Ee,B,qs="Fortunately, 🤗 Datasets has been designed to overcome these limitations. It frees you from memory management problems by treating datasets as <em>memory-mapped</em> files, and from hard drive limits by <em>streaming</em> the entries in a corpus.",ve,G,_e,k,Os='In this section we’ll explore these features of 🤗 Datasets with a huge 825 GB corpus known as <a href="https://pile.eleuther.ai" rel="nofollow">the Pile</a>. Let’s get started!',Qe,V,Ye,W,Ks='The Pile is an English text corpus that was created by <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> for training large-scale language models. It includes a diverse range of datasets, spanning scientific articles, GitHub code repositories, and filtered web text. The training corpus is available in <a href="https://the-eye.eu/public/AI/pile/" rel="nofollow">14 GB chunks</a>, and you can also download several of the <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">individual components</a>. Let’s start by taking a look at the PubMed Abstracts dataset, which is a corpus of abstracts from 15 million biomedical publications on <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. The dataset is in <a href="https://jsonlines.org" rel="nofollow">JSON Lines format</a> and is compressed using the <code>zstandard</code> library, so first we need to install that:',ze,R,He,C,et='Next, we can load the dataset using the method for remote files that we learned in <a href="/course/chapter5/2">section 2</a>:',Fe,N,Ae,X,Se,E,st="We can see that there are 15,518,009 rows and 2 columns in our dataset — that’s a lot!",De,b,Le,v,tt="Let’s inspect the contents of the first example:",Pe,_,qe,Q,Oe,Y,lt="Okay, this looks like the abstract from a medical article. Now let’s see how much RAM we’ve used to load the dataset!",Ke,z,es,H,at='A simple way to measure memory usage in Python is with the <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a> library, which can be installed with <code>pip</code> as follows:',ss,F,ts,A,nt="It provides a <code>Process</code> class that allows us to check the memory usage of the current process as follows:",ls,S,as,D,ns,L,it="Here the <code>rss</code> attribute refers to the <em>resident set size</em>, which is the fraction of memory that a process occupies in RAM. This measurement also includes the memory used by the Python interpreter and the libraries we’ve loaded, so the actual amount of memory used to load the dataset is a bit smaller. For comparison, let’s see how large the dataset is on disk, using the <code>dataset_size</code> attribute. Since the result is expressed in bytes like before, we need to manually convert it to gigabytes:",is,P,ps,q,os,O,pt="Nice — despite it being almost 20 GB large, we’re able to load and access the dataset with much less RAM!",rs,j,cs,K,ot='If you’re familiar with Pandas, this result might come as a surprise because of Wes Kinney’s famous <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">rule of thumb</a> that you typically need 5 to 10 times as much RAM as the size of your dataset. So how does 🤗 Datasets solve this memory management problem? 🤗 Datasets treats each dataset as a <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">memory-mapped file</a>, which provides a mapping between RAM and filesystem storage that allows the library to access and operate on elements of the dataset without needing to fully load it into memory.',Ms,ee,rt='Memory-mapped files can also be shared across multiple processes, which enables methods like <code>Dataset.map()</code> to be parallelized without needing to move or copy the dataset. Under the hood, these capabilities are all realized by the <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> memory format and <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a> library, which make the data loading and processing lightning fast. (For more details about Apache Arrow and comparisons to Pandas, check out <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">Dejan Simic’s blog post</a>.) To see this in action, let’s run a little speed test by iterating over all the elements in the PubMed Abstracts dataset:',ds,se,ms,te,hs,le,ct="Here we’ve used Python’s <code>timeit</code> module to measure the execution time taken by <code>code_snippet</code>. You’ll typically be able to iterate over a dataset at speed of a few tenths of a GB/s to several GB/s. This works great for the vast majority of applications, but sometimes you’ll have to work with a dataset that is too large to even store on your laptop’s hard drive. For example, if we tried to download the Pile in its entirety, we’d need 825 GB of free disk space! To handle these cases, 🤗 Datasets provides a streaming feature that allows us to download and access elements on the fly, without needing to download the whole dataset. Let’s take a look at how this works.",ys,U,us,ae,Js,ne,Mt="To enable dataset streaming you just need to pass the <code>streaming=True</code> argument to the <code>load_dataset()</code> function. For example, let’s load the PubMed Abstracts dataset again, but in streaming mode:",fs,ie,ws,pe,dt="Instead of the familiar <code>Dataset</code> that we’ve encountered elsewhere in this chapter, the object returned with <code>streaming=True</code> is an <code>IterableDataset</code>. As the name suggests, to access the elements of an <code>IterableDataset</code> we need to iterate over it. We can access the first element of our streamed dataset as follows:",Ts,oe,bs,re,js,ce,mt='The elements from a streamed dataset can be processed on the fly using <code>IterableDataset.map()</code>, which is useful during training if you need to tokenize the inputs. The process is exactly the same as the one we used to tokenize our dataset in <a href="/course/chapter3">Chapter 3</a>, with the only difference being that outputs are returned one by one:',Us,Me,gs,de,Is,g,$s,me,ht="You can also shuffle a streamed dataset using <code>IterableDataset.shuffle()</code>, but unlike <code>Dataset.shuffle()</code> this only shuffles the elements in a predefined <code>buffer_size</code>:",xs,he,Zs,ye,Bs,ue,yt="In this example, we selected a random example from the first 10,000 examples in the buffer. Once an example is accessed, its spot in the buffer is filled with the next example in the corpus (i.e., the 10,001st example in the case above). You can also select elements from a streamed dataset using the <code>IterableDataset.take()</code> and <code>IterableDataset.skip()</code> functions, which act in a similar way to <code>Dataset.select()</code>. For example, to select the first 5 examples in the PubMed Abstracts dataset we can do the following:",Gs,Je,ks,fe,Vs,we,ut="Similarly, you can use the <code>IterableDataset.skip()</code> function to create training and validation splits from a shuffled dataset as follows:",Ws,Te,Rs,be,Jt="Let’s round out our exploration of dataset streaming with a common application: combining multiple datasets together to create a single corpus. 🤗 Datasets provides an <code>interleave_datasets()</code> function that converts a list of <code>IterableDataset</code> objects into a single <code>IterableDataset</code>, where the elements of the new dataset are obtained by alternating among the source examples. This function is especially useful when you’re trying to combine large datasets, so as an example let’s stream the FreeLaw subset of the Pile, which is a 51 GB dataset of legal opinions from US courts:",Cs,je,Ns,Ue,Xs,ge,ft="This dataset is large enough to stress the RAM of most laptops, yet we’ve been able to load and access it without breaking a sweat! Let’s now combine the examples from the FreeLaw and PubMed Abstracts datasets with the <code>interleave_datasets()</code> function:",Es,Ie,vs,$e,_s,xe,wt="Here we’ve used the <code>islice()</code> function from Python’s <code>itertools</code> module to select the first two examples from the combined dataset, and we can see that they match the first examples from each of the two source datasets.",Qs,Ze,Tt="Finally, if you want to stream the Pile in its 825 GB entirety, you can grab all the prepared files as follows:",Ys,Be,zs,Ge,Hs,I,Fs,ke,bt="You now have all the tools you need to load and process datasets of all shapes and sizes — but unless you’re exceptionally lucky, there will come a point in your NLP journey where you’ll have to actually create a dataset to solve the problem at hand. That’s the topic of the next section!",As,Ve,Ss,We,Ds;return $=new Ls({props:{title:"Big data? 🤗 Datasets to the rescue!",local:"big-data-datasets-to-the-rescue",headingTag:"h1"}}),x=new Nt({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"}]}}),G=new Ct({props:{id:"JwISwTCPPWo"}}),V=new Ls({props:{title:"What is the Pile?",local:"what-is-the-pile",headingTag:"h2"}}),R=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),N=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVGhpcyUyMHRha2VzJTIwYSUyMGZldyUyMG1pbnV0ZXMlMjB0byUyMHJ1biUyQyUyMHNvJTIwZ28lMjBncmFiJTIwYSUyMHRlYSUyMG9yJTIwY29mZmVlJTIwd2hpbGUlMjB5b3UlMjB3YWl0JTIwJTNBKSUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRlBVQk1FRF90aXRsZV9hYnN0cmFjdHNfMjAxOV9iYXNlbGluZS5qc29ubC56c3QlMjIlMEFwdWJtZWRfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXB1Ym1lZF9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># This takes a few minutes to run, so go grab a tea or coffee while you wait :)</span>
data_files = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/PUBMED_title_abstracts_2019_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),X=new J({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),b=new Re({props:{$$slots:{default:[Et]},$$scope:{ctx:T}}}),_=new J({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Q=new J({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),z=new Ls({props:{title:"The magic of memory mapping",local:"the-magic-of-memory-mapping",headingTag:"h2"}}),F=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),S=new J({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGlzJTIwZXhwcmVzc2VkJTIwaW4lMjBieXRlcyUyQyUyMHNvJTIwY29udmVydCUyMHRvJTIwbWVnYWJ5dGVzJTBBcHJpbnQoZiUyMlJBTSUyMHVzZWQlM0ElMjAlN0Jwc3V0aWwuUHJvY2VzcygpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklM0EuMmYlN0QlMjBNQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info is expressed in bytes, so convert to megabytes</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),D=new J({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),P=new J({props:{code:"cHJpbnQoZiUyMk51bWJlciUyMG9mJTIwZmlsZXMlMjBpbiUyMGRhdGFzZXQlMjAlM0ElMjAlN0JwdWJtZWRfZGF0YXNldC5kYXRhc2V0X3NpemUlN0QlMjIpJTBBc2l6ZV9nYiUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSUyMCUyRiUyMCgxMDI0KiozKSUwQXByaW50KGYlMjJEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwJTdCc2l6ZV9nYiUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of files in dataset : <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),q=new J({props:{code:"TnVtYmVyJTIwb2YlMjBmaWxlcyUyMGluJTIwZGF0YXNldCUyMCUzQSUyMDIwOTc5NDM3MDUxJTBBRGF0YXNldCUyMHNpemUlMjAoY2FjaGUlMjBmaWxlKSUyMCUzQSUyMDE5LjU0JTIwR0I=",highlighted:`Number of files <span class="hljs-keyword">in</span> dataset : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),j=new Re({props:{$$slots:{default:[vt]},$$scope:{ctx:T}}}),se=new J({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),te=new J({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),U=new Re({props:{$$slots:{default:[_t]},$$scope:{ctx:T}}}),ae=new Ls({props:{title:"Streaming datasets",local:"streaming-datasets",headingTag:"h2"}}),ie=new J({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),oe=new J({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),re=new J({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),Me=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),de=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new Re({props:{$$slots:{default:[Qt]},$$scope:{ctx:T}}}),he=new J({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),ye=new J({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>}`,wrap:!1}}),Je=new J({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),fe=new J({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzUlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnQ2xpbmljYWwlMjBzaWducyUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjB3aXRoJTIwYWN1dGUlMjBsb3dlciUyMHJlc3BpcmF0b3J5JTIwaW5mZWN0aW9uJTNBJTIwaW5kaWNhdG9ycyUyMG9mJTIwb3h5Z2VuJTIwdGhlcmFweSUyMC4uLiclN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NiUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCUyMkh5cG94YWVtaWElMjBpbiUyMGNoaWxkcmVuJTIwd2l0aCUyMHNldmVyZSUyMHBuZXVtb25pYSUyMGluJTIwUGFwdWElMjBOZXclMjBHdWluZWElMjAuLi4lMjIlN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NyUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCdPeHlnZW4lMjBjb25jZW50cmF0b3JzJTIwYW5kJTIwY3lsaW5kZXJzJTIwLi4uJyU3RCUyQyUwQSUyMCU3QidtZXRhJyUzQSUyMCU3QidwbWlkJyUzQSUyMDExNDA5NTc4JTJDJTIwJ2xhbmd1YWdlJyUzQSUyMCdlbmcnJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJ094eWdlbiUyMHN1cHBseSUyMGluJTIwcnVyYWwlMjBhZnJpY2ElM0ElMjBhJTIwcGVyc29uYWwlMjBleHBlcmllbmNlJTIwLi4uJyU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>}]`,wrap:!1}}),Te=new J({props:{code:"JTIzJTIwU2tpcCUyMHRoZSUyMGZpcnN0JTIwMSUyQzAwMCUyMGV4YW1wbGVzJTIwYW5kJTIwaW5jbHVkZSUyMHRoZSUyMHJlc3QlMjBpbiUyMHRoZSUyMHRyYWluaW5nJTIwc2V0JTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKSUwQSUyMyUyMFRha2UlMjB0aGUlMjBmaXJzdCUyMDElMkMwMDAlMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHZhbGlkYXRpb24lMjBzZXQlMEF2YWxpZGF0aW9uX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnRha2UoMTAwMCk=",highlighted:`<span class="hljs-comment"># Skip the first 1,000 examples and include the rest in the training set</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Take the first 1,000 examples for the validation set</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),je=new J({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRkZyZWVMYXdfT3BpbmlvbnMuanNvbmwuenN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbWluZyUzRFRydWUlMkMlMEEpJTBBbmV4dChpdGVyKGxhd19kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),Ue=new J({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),Ie=new J({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),$e=new J({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),Be=new J({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGUlMkYlMjIlMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjAlNUJiYXNlX3VybCUyMCUyQiUyMCUyMnRyYWluJTJGJTIyJTIwJTJCJTIwZiUyMiU3QmlkeCUzQTAyZCU3RC5qc29ubC56c3QlMjIlMjBmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDMwKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjBiYXNlX3VybCUyMCUyQiUyMCUyMnZhbC5qc29ubC56c3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXN0JTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0ZXN0Lmpzb25sLnpzdCUyMiUyQyUwQSU3RCUwQXBpbGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQW5leHQoaXRlcihwaWxlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:`base_url = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),Ge=new J({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),I=new Re({props:{$$slots:{default:[Yt]},$$scope:{ctx:T}}}),Ve=new Xt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter5/4.mdx"}}),{c(){i=h("meta"),f=a(),m=h("p"),w=a(),p($.$$.fragment),Ne=a(),p(x.$$.fragment),Xe=a(),Z=h("p"),Z.innerHTML=Ps,Ee=a(),B=h("p"),B.innerHTML=qs,ve=a(),p(G.$$.fragment),_e=a(),k=h("p"),k.innerHTML=Os,Qe=a(),p(V.$$.fragment),Ye=a(),W=h("p"),W.innerHTML=Ks,ze=a(),p(R.$$.fragment),He=a(),C=h("p"),C.innerHTML=et,Fe=a(),p(N.$$.fragment),Ae=a(),p(X.$$.fragment),Se=a(),E=h("p"),E.textContent=st,De=a(),p(b.$$.fragment),Le=a(),v=h("p"),v.textContent=tt,Pe=a(),p(_.$$.fragment),qe=a(),p(Q.$$.fragment),Oe=a(),Y=h("p"),Y.textContent=lt,Ke=a(),p(z.$$.fragment),es=a(),H=h("p"),H.innerHTML=at,ss=a(),p(F.$$.fragment),ts=a(),A=h("p"),A.innerHTML=nt,ls=a(),p(S.$$.fragment),as=a(),p(D.$$.fragment),ns=a(),L=h("p"),L.innerHTML=it,is=a(),p(P.$$.fragment),ps=a(),p(q.$$.fragment),os=a(),O=h("p"),O.textContent=pt,rs=a(),p(j.$$.fragment),cs=a(),K=h("p"),K.innerHTML=ot,Ms=a(),ee=h("p"),ee.innerHTML=rt,ds=a(),p(se.$$.fragment),ms=a(),p(te.$$.fragment),hs=a(),le=h("p"),le.innerHTML=ct,ys=a(),p(U.$$.fragment),us=a(),p(ae.$$.fragment),Js=a(),ne=h("p"),ne.innerHTML=Mt,fs=a(),p(ie.$$.fragment),ws=a(),pe=h("p"),pe.innerHTML=dt,Ts=a(),p(oe.$$.fragment),bs=a(),p(re.$$.fragment),js=a(),ce=h("p"),ce.innerHTML=mt,Us=a(),p(Me.$$.fragment),gs=a(),p(de.$$.fragment),Is=a(),p(g.$$.fragment),$s=a(),me=h("p"),me.innerHTML=ht,xs=a(),p(he.$$.fragment),Zs=a(),p(ye.$$.fragment),Bs=a(),ue=h("p"),ue.innerHTML=yt,Gs=a(),p(Je.$$.fragment),ks=a(),p(fe.$$.fragment),Vs=a(),we=h("p"),we.innerHTML=ut,Ws=a(),p(Te.$$.fragment),Rs=a(),be=h("p"),be.innerHTML=Jt,Cs=a(),p(je.$$.fragment),Ns=a(),p(Ue.$$.fragment),Xs=a(),ge=h("p"),ge.innerHTML=ft,Es=a(),p(Ie.$$.fragment),vs=a(),p($e.$$.fragment),_s=a(),xe=h("p"),xe.innerHTML=wt,Qs=a(),Ze=h("p"),Ze.textContent=Tt,Ys=a(),p(Be.$$.fragment),zs=a(),p(Ge.$$.fragment),Hs=a(),p(I.$$.fragment),Fs=a(),ke=h("p"),ke.textContent=bt,As=a(),p(Ve.$$.fragment),Ss=a(),We=h("p"),this.h()},l(e){const s=Wt("svelte-u9bgzb",document.head);i=y(s,"META",{name:!0,content:!0}),s.forEach(t),f=n(e),m=y(e,"P",{}),xt(m).forEach(t),w=n(e),o($.$$.fragment,e),Ne=n(e),o(x.$$.fragment,e),Xe=n(e),Z=y(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-kyt5th"&&(Z.innerHTML=Ps),Ee=n(e),B=y(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-101a1li"&&(B.innerHTML=qs),ve=n(e),o(G.$$.fragment,e),_e=n(e),k=y(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-akmr9k"&&(k.innerHTML=Os),Qe=n(e),o(V.$$.fragment,e),Ye=n(e),W=y(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-14mo1po"&&(W.innerHTML=Ks),ze=n(e),o(R.$$.fragment,e),He=n(e),C=y(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-16qj1dd"&&(C.innerHTML=et),Fe=n(e),o(N.$$.fragment,e),Ae=n(e),o(X.$$.fragment,e),Se=n(e),E=y(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-cbv5ht"&&(E.textContent=st),De=n(e),o(b.$$.fragment,e),Le=n(e),v=y(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1w1s5mw"&&(v.textContent=tt),Pe=n(e),o(_.$$.fragment,e),qe=n(e),o(Q.$$.fragment,e),Oe=n(e),Y=y(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-jeugzh"&&(Y.textContent=lt),Ke=n(e),o(z.$$.fragment,e),es=n(e),H=y(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1ym3qey"&&(H.innerHTML=at),ss=n(e),o(F.$$.fragment,e),ts=n(e),A=y(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-703q8t"&&(A.innerHTML=nt),ls=n(e),o(S.$$.fragment,e),as=n(e),o(D.$$.fragment,e),ns=n(e),L=y(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1g80mam"&&(L.innerHTML=it),is=n(e),o(P.$$.fragment,e),ps=n(e),o(q.$$.fragment,e),os=n(e),O=y(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-e299qv"&&(O.textContent=pt),rs=n(e),o(j.$$.fragment,e),cs=n(e),K=y(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-19s0dv4"&&(K.innerHTML=ot),Ms=n(e),ee=y(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-rzk2et"&&(ee.innerHTML=rt),ds=n(e),o(se.$$.fragment,e),ms=n(e),o(te.$$.fragment,e),hs=n(e),le=y(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-ozqcdp"&&(le.innerHTML=ct),ys=n(e),o(U.$$.fragment,e),us=n(e),o(ae.$$.fragment,e),Js=n(e),ne=y(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-2xtgtq"&&(ne.innerHTML=Mt),fs=n(e),o(ie.$$.fragment,e),ws=n(e),pe=y(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-xqykn4"&&(pe.innerHTML=dt),Ts=n(e),o(oe.$$.fragment,e),bs=n(e),o(re.$$.fragment,e),js=n(e),ce=y(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-vmgfpy"&&(ce.innerHTML=mt),Us=n(e),o(Me.$$.fragment,e),gs=n(e),o(de.$$.fragment,e),Is=n(e),o(g.$$.fragment,e),$s=n(e),me=y(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-128fecr"&&(me.innerHTML=ht),xs=n(e),o(he.$$.fragment,e),Zs=n(e),o(ye.$$.fragment,e),Bs=n(e),ue=y(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-13vs8h4"&&(ue.innerHTML=yt),Gs=n(e),o(Je.$$.fragment,e),ks=n(e),o(fe.$$.fragment,e),Vs=n(e),we=y(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-88ekky"&&(we.innerHTML=ut),Ws=n(e),o(Te.$$.fragment,e),Rs=n(e),be=y(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-iuph5y"&&(be.innerHTML=Jt),Cs=n(e),o(je.$$.fragment,e),Ns=n(e),o(Ue.$$.fragment,e),Xs=n(e),ge=y(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-cn8r79"&&(ge.innerHTML=ft),Es=n(e),o(Ie.$$.fragment,e),vs=n(e),o($e.$$.fragment,e),_s=n(e),xe=y(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-a5vxnl"&&(xe.innerHTML=wt),Qs=n(e),Ze=y(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1j6091b"&&(Ze.textContent=Tt),Ys=n(e),o(Be.$$.fragment,e),zs=n(e),o(Ge.$$.fragment,e),Hs=n(e),o(I.$$.fragment,e),Fs=n(e),ke=y(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-9015n6"&&(ke.textContent=bt),As=n(e),o(Ve.$$.fragment,e),Ss=n(e),We=y(e,"P",{}),xt(We).forEach(t),this.h()},h(){Zt(i,"name","hf:doc:metadata"),Zt(i,"content",Ht)},m(e,s){Rt(document.head,i),l(e,f,s),l(e,m,s),l(e,w,s),r($,e,s),l(e,Ne,s),r(x,e,s),l(e,Xe,s),l(e,Z,s),l(e,Ee,s),l(e,B,s),l(e,ve,s),r(G,e,s),l(e,_e,s),l(e,k,s),l(e,Qe,s),r(V,e,s),l(e,Ye,s),l(e,W,s),l(e,ze,s),r(R,e,s),l(e,He,s),l(e,C,s),l(e,Fe,s),r(N,e,s),l(e,Ae,s),r(X,e,s),l(e,Se,s),l(e,E,s),l(e,De,s),r(b,e,s),l(e,Le,s),l(e,v,s),l(e,Pe,s),r(_,e,s),l(e,qe,s),r(Q,e,s),l(e,Oe,s),l(e,Y,s),l(e,Ke,s),r(z,e,s),l(e,es,s),l(e,H,s),l(e,ss,s),r(F,e,s),l(e,ts,s),l(e,A,s),l(e,ls,s),r(S,e,s),l(e,as,s),r(D,e,s),l(e,ns,s),l(e,L,s),l(e,is,s),r(P,e,s),l(e,ps,s),r(q,e,s),l(e,os,s),l(e,O,s),l(e,rs,s),r(j,e,s),l(e,cs,s),l(e,K,s),l(e,Ms,s),l(e,ee,s),l(e,ds,s),r(se,e,s),l(e,ms,s),r(te,e,s),l(e,hs,s),l(e,le,s),l(e,ys,s),r(U,e,s),l(e,us,s),r(ae,e,s),l(e,Js,s),l(e,ne,s),l(e,fs,s),r(ie,e,s),l(e,ws,s),l(e,pe,s),l(e,Ts,s),r(oe,e,s),l(e,bs,s),r(re,e,s),l(e,js,s),l(e,ce,s),l(e,Us,s),r(Me,e,s),l(e,gs,s),r(de,e,s),l(e,Is,s),r(g,e,s),l(e,$s,s),l(e,me,s),l(e,xs,s),r(he,e,s),l(e,Zs,s),r(ye,e,s),l(e,Bs,s),l(e,ue,s),l(e,Gs,s),r(Je,e,s),l(e,ks,s),r(fe,e,s),l(e,Vs,s),l(e,we,s),l(e,Ws,s),r(Te,e,s),l(e,Rs,s),l(e,be,s),l(e,Cs,s),r(je,e,s),l(e,Ns,s),r(Ue,e,s),l(e,Xs,s),l(e,ge,s),l(e,Es,s),r(Ie,e,s),l(e,vs,s),r($e,e,s),l(e,_s,s),l(e,xe,s),l(e,Qs,s),l(e,Ze,s),l(e,Ys,s),r(Be,e,s),l(e,zs,s),r(Ge,e,s),l(e,Hs,s),r(I,e,s),l(e,Fs,s),l(e,ke,s),l(e,As,s),r(Ve,e,s),l(e,Ss,s),l(e,We,s),Ds=!0},p(e,[s]){const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),b.$set(jt);const Ut={};s&2&&(Ut.$$scope={dirty:s,ctx:e}),j.$set(Ut);const gt={};s&2&&(gt.$$scope={dirty:s,ctx:e}),U.$set(gt);const It={};s&2&&(It.$$scope={dirty:s,ctx:e}),g.$set(It);const $t={};s&2&&($t.$$scope={dirty:s,ctx:e}),I.$set($t)},i(e){Ds||(c($.$$.fragment,e),c(x.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(X.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(F.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(q.$$.fragment,e),c(j.$$.fragment,e),c(se.$$.fragment,e),c(te.$$.fragment,e),c(U.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(de.$$.fragment,e),c(g.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(fe.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c($e.$$.fragment,e),c(Be.$$.fragment,e),c(Ge.$$.fragment,e),c(I.$$.fragment,e),c(Ve.$$.fragment,e),Ds=!0)},o(e){M($.$$.fragment,e),M(x.$$.fragment,e),M(G.$$.fragment,e),M(V.$$.fragment,e),M(R.$$.fragment,e),M(N.$$.fragment,e),M(X.$$.fragment,e),M(b.$$.fragment,e),M(_.$$.fragment,e),M(Q.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),M(S.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(j.$$.fragment,e),M(se.$$.fragment,e),M(te.$$.fragment,e),M(U.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(g.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(fe.$$.fragment,e),M(Te.$$.fragment,e),M(je.$$.fragment,e),M(Ue.$$.fragment,e),M(Ie.$$.fragment,e),M($e.$$.fragment,e),M(Be.$$.fragment,e),M(Ge.$$.fragment,e),M(I.$$.fragment,e),M(Ve.$$.fragment,e),Ds=!1},d(e){e&&(t(f),t(m),t(w),t(Ne),t(Xe),t(Z),t(Ee),t(B),t(ve),t(_e),t(k),t(Qe),t(Ye),t(W),t(ze),t(He),t(C),t(Fe),t(Ae),t(Se),t(E),t(De),t(Le),t(v),t(Pe),t(qe),t(Oe),t(Y),t(Ke),t(es),t(H),t(ss),t(ts),t(A),t(ls),t(as),t(ns),t(L),t(is),t(ps),t(os),t(O),t(rs),t(cs),t(K),t(Ms),t(ee),t(ds),t(ms),t(hs),t(le),t(ys),t(us),t(Js),t(ne),t(fs),t(ws),t(pe),t(Ts),t(bs),t(js),t(ce),t(Us),t(gs),t(Is),t($s),t(me),t(xs),t(Zs),t(Bs),t(ue),t(Gs),t(ks),t(Vs),t(we),t(Ws),t(Rs),t(be),t(Cs),t(Ns),t(Xs),t(ge),t(Es),t(vs),t(_s),t(xe),t(Qs),t(Ze),t(Ys),t(zs),t(Hs),t(Fs),t(ke),t(As),t(Ss),t(We)),t(i),d($,e),d(x,e),d(G,e),d(V,e),d(R,e),d(N,e),d(X,e),d(b,e),d(_,e),d(Q,e),d(z,e),d(F,e),d(S,e),d(D,e),d(P,e),d(q,e),d(j,e),d(se,e),d(te,e),d(U,e),d(ae,e),d(ie,e),d(oe,e),d(re,e),d(Me,e),d(de,e),d(g,e),d(he,e),d(ye,e),d(Je,e),d(fe,e),d(Te,e),d(je,e),d(Ue,e),d(Ie,e),d($e,e),d(Be,e),d(Ge,e),d(I,e),d(Ve,e)}}}const Ht='{"title":"Big data? 🤗 Datasets to the rescue!","local":"big-data-datasets-to-the-rescue","sections":[{"title":"What is the Pile?","local":"what-is-the-pile","sections":[],"depth":2},{"title":"The magic of memory mapping","local":"the-magic-of-memory-mapping","sections":[],"depth":2},{"title":"Streaming datasets","local":"streaming-datasets","sections":[],"depth":2}],"depth":1}';function Ft(T){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends kt{constructor(i){super(),Vt(this,i,Ft,zt,Bt,{})}}export{Kt as component};
