import{s as IM,n as fM,o as bM}from"../chunks/scheduler.25b97de1.js";import{S as AM,i as _M,g as n,s as a,r as y,m as ZM,A as gM,h as i,f as s,c as M,j as ea,u as w,x as o,n as BM,k as sa,y as GM,a as t,v as p,d,t as c,w as U}from"../chunks/index.d9030fc9.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as r,E as vM}from"../chunks/EditOnGithub.91d95064.js";function kM(ta){let j,We,Re,Xe,J,Ee,m,aa='<code>transformers</code> is an opinionated framework; our philosophy is defined in the following <a href="./philosophy">conceptual guide</a>.',Ve,h,Ma=`The core of that philosophy is exemplified by the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a>
aspect of the library. This component’s downside is that it limits the inheritance and importability of components from
files to others in the toolkit.`,$e,C,na=`As a result, model components tend to be repeated across many files. There are as many attention layers defined
in <code>transformers</code> as there are models, and a significant number of those are identical to each other.
The unfortunate consequence is that independent implementations tend to diverge as fixes and changes get applied
to specific parts of the code.`,xe,u,ia=`In order to balance this issue, we introduced the concept of “copies” across the library. By adding a comment indicating
that code is a copy of another, we can enforce through CI and local commands that copies do not diverge. However,
while the complexity is low, this is often quite tedious to do.`,ze,I,oa=`And, finally, this contributes to adding a significant overhead to contributing models which we would like to remove.
This approach often requires model contributions to add modeling code (~1k lines), processor (~500 lines), tests, docs,
etc. Model contribution PRs rarely add less than 3-5k lines of code, with much of this code being boilerplate.`,Ye,f,ya=`This raises the bar for contributions, and with Modular Transformers, we’re aiming to lower the bar to a much more
acceptable point.`,Qe,b,wa=`If you plan to add a model to <code>transformers</code> make sure you read <a href="https://huggingface.co/docs/transformers/add_new_model" rel="nofollow">How to add a model to 🤗 Transformers?</a>.
For any kind of contributions, see <a href="https://github.com/huggingface/transformers/blob/main/CONTRIBUTING.md" rel="nofollow">CONTRIBUTING.md</a>.`,He,A,Se,_,pa=`Modular Transformers introduces the concept of a “modular” file to a model folder. This modular file accepts code
that isn’t typically accepted in modeling/processing files, as it allows importing from neighbouring models as well
as inheritance from classes to others.`,Fe,Z,da=`This modular file defines models, processors, and the configuration class that would otherwise be defined in their
respective modules.`,Le,g,ca=`Finally, this feature introduces a new <code>linter</code> which will “unravel” the modular file into the “single model, single
file” directory structure. These files will get auto-generated every time the script is run; reducing the required
contributions to the modular file, and therefore only to the changes between the contributed model and others.`,De,B,Ua=`Model users will end up importing and using the single-file interface, so no change is expected here. Doing this, we
hope to combine the best of both worlds: enabling simple contributions while sticking to our philosophy.`,Oe,G,Ta=`This is therefore a replacement for the <code># Copied from</code> markers, and previously contributed models can be expected to
be moved to the new Modular Transformers format in the coming months.`,Pe,v,Ke,k,ra="To generate a single file from the modular file, run the following command.",qe,R,ls,N,ja=`The “linter”, which unravels the inheritance and creates all single-files from the modular file, will flatten the
inheritance while trying to be invisible to Python users. At this time, the linter flattens a <strong>single</strong> level of
inheritance.`,es,W,Ja="For example:",ss,X,ma=`<li>If a configuration class inherits from another and adds/deletes an argument, the generated file will either directly
reference it (in case of addition) or completely remove it (in case of deletion).</li> <li>If a class inherits from another, for example: <code>class GemmaModel(LlamaModel):</code>, dependencies are automatically
inferred. All submodules will be automatically added from the superclass.</li> <li>If you define new functions in the <code>modular</code> and use them inside classes, the linter will automatically infer the</li>`,ts,E,ha=`You should be able to write everything (the tokenizer, the image processor, the model, the config) in this <code>modular</code>
file, and the corresponding files will be created for you.`,as,V,Ms,$,Ca="Run the command below to ensure the generated content matches <code>modular_&lt;your_model&gt;.py</code>",ns,x,is,z,os,Y,ua=`Here is a quick example with BERT and RoBERTa. The two models are intimately related: their modeling implementation
differs solely by a change in the embedding layer.`,ys,Q,Ia=`Instead of redefining the model entirely, here is what the <code>modular_roberta.py</code> file looks like for the modeling &amp;
configuration classes (for the sake of the example, the tokenizer is ignored at this time as very different).`,ws,H,ps,S,ds,F,fa="It is not a replacement for the modeling code (yet?), and if your model is not based on anything else that ever existed, then you can add a <code>modeling</code> file as usual. Similarly, if you cannot easily inherit your <code>configuration</code> (or <code>tokenization</code> or <code>processing</code>) file from another model’s similar file, you can add that filetype directly (even though defining it in the modular file would work, it would clutter it).",cs,L,Us,D,ba="As explained, modular allows you to use regular Python inheritance from any other model’s code in the library, in order to define your own. For this reason, it will work better/be easier if you first browse the library a bit to find models close to yours, in order to inherit from them. For example, are you using a sliding window in the <code>Attention</code> class? Then start by checking models that are well known to use it, e.g. <code>Mistral</code>, or <code>Qwen2</code>! Are you using interleaved <code>RotaryEmbedding</code> modules? Check out <code>Cohere</code>, <code>Cohere2</code> and <code>Glm</code> models! Otherwise a very strong starting point is to check out <code>Llama</code>. And if you are doing a bit of all of that at once, then you can mix and match!",Ts,O,Aa="Here are some common properties that your model might be using, and corresponding modeling files to check as an example:",rs,P,_a="<li>Mixture of expert: <code>SwitchTransformers</code> or <code>Mixtral</code></li> <li>Interleaved (and/or partial) rotary embedding: <code>Glm</code>, <code>Phi</code></li> <li>State space models: <ul><li>Hybrid with attention: <code>Jamba</code> , <code>Bamba</code>, <code>Zamba</code></li> <li>Mamba2: <code>Mamba2</code></li></ul></li> <li>Recurrent hidden states: <code>Gemma2</code></li> <li>Different sliding window attention/full attention patterns per layer: <code>Gemma2</code>, <code>Cohere2</code></li> <li>Clipping of QKV: <code>Olmo</code></li> <li>Normalization of QK: <code>Olmo2</code>, <code>Cohere</code></li> <li>Fused QKV (not recommended): <code>Phi3</code></li>",js,K,Za='At Hugging Face, we feel that learning by example is usually (one of) the best way, so we will now go over a typical modular file, and the different features our linter provides (and its limitations)! 🤗 Let’s use a real world example with Olmo2 model, which I feel provides a very good illustration of the modular mechanisms. The original file can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modular_olmo2.py" rel="nofollow">here</a>. For simplicity, we will go over it class by class, and repeat the modular’s definition of ech class. For reference, the modeling and configuration of Olmo (v1) on which we will inherit a lot can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo/modeling_olmo.py" rel="nofollow">here</a> and <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo/configuration_olmo.py" rel="nofollow">here</a> respectively. The final modeling of Olmo2 (generated by running our linter on the modular we will describe below) can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">here</a>',Js,q,ga="Let’s break it down!",ms,ll,hs,el,Ba="Here is the <code>Config</code> definition in modular:",Cs,sl,us,tl,Ga="Here, we correctly identified that the <code>Config</code> in Olmo2 is similar to Olmo’s, up to a few details:",Is,al,va="<li>The default value of most arguments has changed</li> <li>we have a new argument, <code>rms_norm_eps</code></li> <li>the argument <code>clip_qkv</code> is not used anymore</li>",fs,Ml,ka=`To solve points 1. and 2., simply overwriting the <code>__init__</code> function with the new default arguments and adding the new one is enough, as you would expect when you want to overwrite a method in Python! Of course you also need to assign the new attribute <code>rms_norm_eps</code> to <code>self</code> in the <code>__init__</code>’s body.<br/>
For point 3., we use the special syntax <code>del self.clip_qkv</code>, which, has you can expect, removed the assignment of this attribute in the unravelled code (after the conversion with the linter).`,bs,nl,Ra="Now, there is a subtility here: as you can see, we used <code>super().__init__(...)</code>. Usually, in Python, it is simply used to call the parent’s <code>__init__</code>. In modular terms, however, it has a <em>slightly</em> different meaning. When we find a call such as <code>super().my_function(...)</code> in the modular file, the linter will take the body of the <code>my_function</code> function in the parent, and unravel it where the call to <code>super().my_function(...)</code> occured. Then, the <code>del self.clip_qkv</code> statement will remove the reference to <code>self.clip_qkv</code> from the unravelled body. Thus <code>del self.xxx</code> can only work in pair with <code>super().my_function(...)</code>, and should always be placed after it (but you can add whatever you want <em>before</em> calling <code>super()</code>, and it will be placed, as you can expect, before the parent’s body).",As,il,_s,ol,Na="Here is the <code>Norm</code> class:",Zs,yl,gs,wl,Wa="What to say here, it is pretty explicit isn’t it? We do not modify anything from the <code>LlamaRMSNorm</code> definition. Thus the linter will unravel exactly the content of the parent (<code>LlamaRMSNorm</code>). Only change will be that every reference to “llama” on the docstrings, type hints, and comments (basically everywhere) will be changed to references to “olmo2” for consistency!",Bs,pl,Gs,dl,Xa="Here is the <code>Attention</code> class:",vs,cl,ks,Ul,Ea=`Now, what’s happening here? In the <code>__init__</code>, we call <code>super().__init__(...)</code>, thus copying the parent’s definition, then add 2 new layers of the <code>Olmo2RMSNorm</code> we just added previously. Indeed, those were not present in the original <code>Olmo</code> (v1) model. So, now, we also have to overwrite the <code>forward</code> method to use these 2 new layers right? Indeed, if you check carefully, the definition of <code>forward</code> is identical to <code>Olmo</code>’s, but we added a pass with the norm layers just before projecting with <code>q_proj</code> and <code>k_proj</code>. However, to help us, we directly imported the functions <code>eager_attention_forward</code> from llama, and <code>apply_rotary_pos_emb</code> from olmo. The linter will then automatically add these imported functions in the final <code>modeling_olmo2.py</code> file, by copying their definitions from the source (imported) files. And it will even add the <code>rotate_half</code> and <code>repeat_kv</code> functions (which are used inside <code>apply_rotary_pos_embed</code> and <code>eager_attention_forward</code> respectively) by figuring out the dependency automatically. Neat, right?<br/>
Note that we had to redefine this class, because we did not find any model defining the <code>Attention</code> layer with the added <code>RMSNorm</code> layer anywhere else in the library! Otherwise, we would have simply inherited from this model instead as we did for the <code>RMSNorm</code>!`,Rs,Tl,Ns,rl,Va="Here is the <code>DecoderLayer</code> class:",Ws,jl,Xs,Jl,$a="At this point, you should start to pick up what is happening for this class. We switched the type of norm in the <code>__init__</code> by overwriting <code>self.post_attention_layernorm</code> after the call to <code>super().__init__(...)</code>, thus going from a <code>LayerNorm</code> in the parent class, to our <code>RMSNorm</code> in this class. Then we simply deleted the <code>self.input_layernorm</code> attribute, and replaced it by <code>self.post_feedforward_layernorm</code>, because the name was not making sense anymore as we apply it after in <code>Olmo2</code> instead of before in <code>Olmo</code>. For this reason, we also need to overwrite the <code>forward</code> method, to reflect the logic change.",Es,ml,xa="Note however that if we had only switched <code>self.post_attention_layernorm</code> and <code>self.input_layernorm</code> from <code>LayerNorm</code>s to <code>RMSNorm</code>s (without the name and logic change of <code>elf.input_layernorm</code>), we would not have had to redefine the <code>forward</code> method!",Vs,hl,$s,Cl,xs,ul,za="Here, this is exactly what I was pointing out before: we simply change the <em>type</em> of the <code>self.norm</code> attribute (going from <code>LayerNorn</code> in <code>Olmo</code> to <code>RMSNorm</code> in <code>Olmo2</code>). Since this change does not reflect the logic of the <code>forward</code> method (the name of the layer and where it is used is identical to the parent’s), then we do not even need to overwrite it! It will be unravelled automatically! Note that we redefined <code>self.layers</code> for the sake of being explicit, but this is not even strictly required here as the definition is similar to what is found in <code>Olmo</code> (v1).",zs,Il,Ys,fl,Ya="Finally, here is the definition of the <code>ForCausalLM</code>:",Qs,bl,Hs,Al,Qa="As for the <code>RMSNorm</code>, it is exactly similar to the parent’s in logic, so we do not have anything to do, the linter will all figure it out by itself. Almost disappointing, no?",Ss,ke,Fs,_l,Ha='Indeed, if you inspect the file <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">modeling_olmo2.py</a> which is created by running the linter on <code>modular_olmo2.py</code>, you will notice that it also creates <code>Olmo2MLP</code>, <code>Olmo2RotaryEmbedding</code>, and <code>Olmo2PreTrainedModel</code> classes, that we did not define explicitly in <code>modular_olmo2.py</code>.',Ls,Zl,Sa="Well, it is one of the main feature of our modular linter. Similarly to how some functions were added automatically with the <code>Attention</code> class (without directly importing them), classes that are a dependency of one of the class inherited class and which are not explicitly defined in the modular file, will be added automatically as part of the dependeny tracing. For example, in <code>OlmoDecoderLayer</code>, there is an attribute defined as <code>self.mlp = OlmoMLP(config)</code>. Because we never explicitly redefined a class named <code>Olmo2MLP</code> in <code>modular_olmo2.py</code>, the linter automatically created a class <code>Olmo2MLP</code>, similar to <code>OlmoMLP</code>. This is exactly the same as if we had done:",Ds,gl,Os,Bl,Fa="but we did not even bother, because we <em>know</em> this class is supposed to be exactly similar, and we never needed it anywhere else in the <code>modular_olmo2.py</code> file. In contrast, the class <code>Olmo2RMSNorm</code> was needed to (re)define the norms both in the <code>Attention</code> and <code>DecoderLayer</code> classes. The same logic is true for the <code>Olmo2PreTrainedModel</code> and <code>Olmo2RotaryEmbedding</code> classes.",Ps,Gl,La="Note however that if not redefined, classes will be copied from the file in which an inherited module uses them first. So if you wanted e.g. <code>Olmo2MLP</code> to inherit from, say, <code>MistralMLP</code> instead of <code>OlmoMLP</code> (here it was <code>OlmoMLP</code> because it was first implicitly used in <code>Olmo2DecoderLayer</code>, which inherited from <code>OlmoDecoderLayer</code>), you would need to be explicit and do:",Ks,vl,qs,kl,lt,Rl,Da="Now that you should have a good grasp of how modular works, let’s see some more advanced use cases and features you can use.",et,Nl,st,Wl,Oa="As we have seen before, after using <code>super().__init__()</code>, we can use <code>del self.attribute</code> to remove a specific attribute which was defined in the parent. What if this attribute was used elsewhere though? Meaning it was not just “defined to be stored” as in the config for example. For example, consider the following case:",tt,Xl,at,El,Pa="Then inheriting from this <code>DummyModel</code> and doing",Mt,Vl,nt,$l,Ka="is not supported, because it will only suppress the assignment, i.e. the line <code>self.attribute = config.attribute</code> will disappear, but the <code>if</code> statement will stay and reference the attribute. We tried to make it work by suppressing every mentions of the attribute, however it it not a sound solution in the general case (it can lead to very surprising effects and remove other important parts) and is therefore not possible.",it,xl,qa="But what if I still want to inherit from <code>DummyModel</code>? How to properly do it? How to use <code>super().__init__()</code> without copy/pasting the parent then? This brings us to the next point:",ot,zl,yt,Yl,lM="Say you still want to inherit from <code>DummyModel</code> (because it is convenient for some other methods) but you do want to remove the <code>self.attribute</code>. How to properly override the <code>__init__</code> method, while calling <code>super()</code> but without unravelling the parent’s code? Well, then be explicit about which class <code>super()</code>’s you are calling! If we want to call the <code>nn.Module</code>’s <code>super()</code> for example, we can do the following (unravelled code on the right):",wt,Ql,pt,Hl,dt,Sl,eM="Removing a class method is pretty similar to remove an attribute, you just need to overwrite it with a <code>raise AttributeError(&quot;&quot;)</code> to mimick the behaviour you actually want when you remove a parent function in python. For example, the following will remove the methods in the unravelled code:",ct,Fl,Ut,Ll,Tt,Dl,sM="Of course, if you define a new function in the <code>modular</code> file, and use it inside an inherited class, say",rt,Ol,jt,Pl,tM="the <code>my_new_function</code> function (and, recursively, any other functions called in its body) will be automatically added to the unravelled code even if it is not present in the parent’s file (here Llama).",Jt,Kl,mt,ql,aM="By default, if you inherit from a class and override a method which has 1 (or more) decorators in the parent’s method, the decorators will be added as well in the unravelled code, <em>but only if you do not add any yourself</em>. Otherwise, it will of course use whatever decorator your redefined.",ht,le,MM="That, is, imagine the following parent class",Ct,ee,ut,se,nM="Then, if you simply override the method it will produce (modular on the left, unravelled code on the right):",It,te,ft,ae,iM="That is, it keeps the parent’s decorators by default. However, if you do:",bt,Me,At,ne,oM="Then it keeps you own new decorator.",_t,ie,Zt,oe,yM="In the above case about decorators, what if the <code>forward</code> method is really long, and I just want to switch the decorators? Do I really have to redefine it all and copy/paste the body just for the decorator? Fortunately, no. If you followed until this point, you now that you can use <code>super().forward(...)</code>, and it will unravel the parent’s body automatically. But what if there are plenty of arguments in the function’s signature, and we are very lazy? For that use-case, we introduced the special syntax <code>**super_kwargs</code> in the overriden method signature. It basically mean: “unravel all the parent’s signature arguments here”. For example, a common signature in the <code>ForCausalLM</code> model is the following (copied from llama’s modeling):",gt,ye,Bt,we,wM="As you can see, this is a rather long and complicated signature. But if you do the following (as usual, modular on the left, unravelled code by the linter on the right):",Gt,pe,vt,de,pM="and the <code>**super_kwargs</code> syntax unravelled all the arguments, while the <code>super().forward()</code> syntax unravelled the whole body! As you can see, this is  great combo when you just want to switch the decorators, as it is very easy to use, and make it explicit that the only change you want to apply is the decorator.",kt,ce,dM="However, we want to make it clear that the <code>**super_kwargs</code> syntax is not a replacement to being explicit when you redefine your methods: if you actually overwrite the method (i.e. you do not call <code>super().method()</code>), then we want you to explicitly write the signature as you would usually. This is only a short-cut when switching decorators, and a few other niche cases.",Rt,Ue,Nt,Te,cM='Usually, if whatever object is defned both in the modular file and the modeling file from which we inherit, then the definition of the modular takes precedence. However, this is not the case for assignments containing the pattern <code>DOCSTRING</code>. Indeed, we usually have variables defined as <code>MODEL_START_DOCSTRING</code> and <code>MODEL_INPUT_DOCSTRING</code> in the modeling files. These are just very big blocks of, well, docstrings… But they are (almost) always exactly the same up to the model name! And modular automatically rewrite the names everywhere! For this reason, assignments containing the pattern will <em>always</em> use the definition found in the source file instead of the modular file. This is extremely handy if we need the variable reference somewhere (e.g. to redefine a decorator) but we do not want to clutter the modular file with 100 lines of docstrings which are always the same. It allows to do the following (taken from <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modular_starcoder2.py#L146" rel="nofollow">modular_starcoder2.py</a>)',Wt,re,Xt,je,UM="and here, the linter will correctly take the same definition of the docstring as in <code>Mistral</code>, without having to clutter the modular file!",Et,Je,Vt,me,TM="Now, let’s go over some of the limitations of modular.",$t,he,xt,Ce,rM="Because our linter automatically renames everything when inheriting from a class (defining <code>class NewModelMLP(LlamaMLP)</code> will rename every mention of <code>Llama</code> to <code>NewModel</code>, and recursively for all dependencies grabbed), it has somewhat strict rules when it comes to naming. For consistency reasons, we require that you always use the same class name prefix when inheriting different classes from the same file. For example, doing:",zt,ue,Yt,Ie,jM="is not recommended, first because it breaks standards in the library and we do not like it, and second because the linter will not know how to rename potential high-order dependencies (should we use <code>MyModelIncredible</code>, or <code>MyModel</code>?).",Qt,fe,JM='If there are no dependencies to grab implicitly however (see <a href="#dependencies">this section</a> to understand implicit dependencies), local renaming (for a single class) will not be an issue and the linter will not complain. But make sure to explicitly redefine every other mentions of the class with the new name pattern! For example in the example above, all mentions of <code>LlamaMLP</code> in other modules inherited should be explicitly replaced by mentions to <code>MyModelIncredibleMLP</code>, otherwise the linter may add a new and unwanted <code>MyModelMLP</code> class!',Ht,be,mM="In any way, if there is an ambiguous case detected, the linter will raise a warning such as",St,Ae,Ft,_e,hM="explaining what is happening, and which prefix is used by default for grabbing dependencies. As explained, if you see automatic dependencies appear with a prefix but you want another one, then explicitly rename these classes locally with a simple <code>pass</code> class, such as",Lt,Ze,Dt,ge,CM="Such warnings and renaming patterns complications usually only arise when defining multimodel models, when you want to define e.g. the text part of your model from an existing model, but want to add the part <code>Text</code> to the class names to make it clear what they refer to in the multimodal setup.",Ot,Be,Pt,Ge,uM="When inheriting a Config class and adding or deleting some attributes, it may be tempting to only redefine the new attributes in the docstring, and hoping that modular will do the rest. And similarly when deleting an argument, do nothing and hope that modular will remove itself from the docstring. However, due to current limitations of our linter, this is not yet supported. Thus, if you are in this case, you need to directly put the whole docstring (as it should appear in the end, with the correct arguments and default values) directly in the modular file under the class definition.",Kt,ve,qt,Ne,la;return J=new r({props:{title:"Modular transformers",local:"modular-transformers",headingTag:"h1"}}),A=new r({props:{title:"What is it?",local:"what-is-it",headingTag:"h2"}}),v=new r({props:{title:"Details",local:"details",headingTag:"h3"}}),R=new T({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZtb2R1bGFyX21vZGVsX2NvbnZlcnRlci5weSUyMC0tZmlsZXMtdG8tcGFyc2UlMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkYlM0N5b3VyX21vZGVsJTNFJTJGbW9kdWxhcl8lM0N5b3VyX21vZGVsJTNFLnB5",highlighted:"python utils/modular_model_converter.py --files-to-parse src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),V=new r({props:{title:"Enforcement",local:"enforcement",headingTag:"h3"}}),x=new T({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19tb2R1bGFyX2NvbnZlcnNpb24ucHklMjAtLWZpbGVzJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGJTNDeW91cl9tb2RlbCUzRSUyRm1vZHVsYXJfJTNDeW91cl9tb2RlbCUzRS5weQ==",highlighted:"python utils/check_modular_conversion.py --files src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),z=new r({props:{title:"Examples",local:"examples",headingTag:"h3"}}),H=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># The RoBERTa config is identical to BERT&#x27;s config</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># We redefine the embeddings here to highlight the padding ID difference, and we redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># The RoBERTa model is identical to the BERT model, except for the embedding layer. </span>
<span class="hljs-comment"># We redefine the embeddings above, so here there is no need to do additional work</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)

      
<span class="hljs-comment"># The heads now only need to redefine the model inside to the correct \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),S=new r({props:{title:"What it is not",local:"what-it-is-not",headingTag:"h2"}}),L=new r({props:{title:"Real world example breakdown",local:"real-world-example-breakdown",headingTag:"h2"}}),ll=new r({props:{title:"Config class",local:"config-class",headingTag:"h3"}}),sl=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.configuration_olmo <span class="hljs-keyword">import</span> OlmoConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Config</span>(<span class="hljs-title class_ inherited__">OlmoConfig</span>):
    <span class="hljs-string">r&quot;&quot;&quot;
    This is the configuration class to store the configuration of a [Olmo2Model](/docs/transformers/pr_30803/en/model_doc/olmo2#transformers.Olmo2Model).
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        vocab_size=<span class="hljs-number">50304</span>,
        hidden_size=<span class="hljs-number">4096</span>,
        intermediate_size=<span class="hljs-number">11008</span>,
        num_hidden_layers=<span class="hljs-number">32</span>,
        num_attention_heads=<span class="hljs-number">32</span>,
        num_key_value_heads=<span class="hljs-literal">None</span>,
        hidden_act=<span class="hljs-string">&quot;silu&quot;</span>,
        max_position_embeddings=<span class="hljs-number">2048</span>,
        initializer_range=<span class="hljs-number">0.02</span>,
        use_cache=<span class="hljs-literal">True</span>,
        pad_token_id=<span class="hljs-number">1</span>,
        bos_token_id=<span class="hljs-literal">None</span>,
        eos_token_id=<span class="hljs-number">50279</span>,
        tie_word_embeddings=<span class="hljs-literal">False</span>,
        rope_theta=<span class="hljs-number">10000.0</span>,
        rope_scaling=<span class="hljs-literal">None</span>,
        attention_bias=<span class="hljs-literal">False</span>,
        attention_dropout=<span class="hljs-number">0.0</span>,
        rms_norm_eps=<span class="hljs-number">1e-5</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__(
            vocab_size=vocab_size,
            hidden_size=hidden_size,
            intermediate_size=intermediate_size,
            num_hidden_layers=num_hidden_layers,
            num_attention_heads=num_attention_heads,
            num_key_value_heads=num_key_value_heads,
            hidden_act=hidden_act,
            max_position_embeddings=max_position_embeddings,
            initializer_range=initializer_range,
            use_cache=use_cache,
            pad_token_id=pad_token_id,
            bos_token_id=bos_token_id,
            eos_token_id=eos_token_id,
            tie_word_embeddings=tie_word_embeddings,
            rope_theta=rope_theta,
            rope_scaling=rope_scaling,
            attention_bias=attention_bias,
            attention_dropout=attention_dropout,
            **kwargs,
        )

        self.rms_norm_eps = rms_norm_eps
        <span class="hljs-keyword">del</span> self.clip_qkv`,wrap:!1}}),il=new r({props:{title:"Norm class",local:"norm-class",headingTag:"h3"}}),yl=new T({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBMbGFtYVJNU05vcm0lMEElMEFjbGFzcyUyME9sbW8yUk1TTm9ybShMbGFtYVJNU05vcm0pJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> LlamaRMSNorm

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2RMSNorm</span>(<span class="hljs-title class_ inherited__">LlamaRMSNorm</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),pl=new r({props:{title:"Attention class",local:"attention-class",headingTag:"h3"}}),cl=new T({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBlYWdlcl9hdHRlbnRpb25fZm9yd2FyZCUwQWZyb20lMjAuLm9sbW8ubW9kZWxpbmdfb2xtbyUyMGltcG9ydCUyME9sbW9BdHRlbnRpb24lMkMlMjBhcHBseV9yb3RhcnlfcG9zX2VtYiUwQSUwQSUwQSUyMyUyME9sbW8yJTIwYXR0ZW50aW9uJTIwaXMlMjBpZGVudGljYWwlMjB0byUyME9MTW8lMjBhdHRlbnRpb24lMjBleGNlcHQlM0ElMEElMjMlMjAtJTIwTm9ybSUyMGlzJTIwYXBwbGllZCUyMHRvJTIwYXR0ZW50aW9uJTIwcXVlcmllcyUyMGFuZCUyMGtleXMuJTBBJTIzJTIwLSUyME5vJTIwcWt2JTIwY2xpcHBpbmcuJTBBY2xhc3MlMjBPbG1vMkF0dGVudGlvbihPbG1vQXR0ZW50aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWclM0ElMjBPbG1vMkNvbmZpZyUyQyUyMGxheWVyX2lkeCUzQSUyME9wdGlvbmFsJTVCaW50JTVEJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyUyQyUyMGxheWVyX2lkeCUzRGxheWVyX2lkeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnFfbm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcubnVtX2F0dGVudGlvbl9oZWFkcyUyMColMjBzZWxmLmhlYWRfZGltJTJDJTIwY29uZmlnLnJtc19ub3JtX2VwcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmtfbm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcubnVtX2tleV92YWx1ZV9oZWFkcyUyMColMjBzZWxmLmhlYWRfZGltJTJDJTIwY29uZmlnLnJtc19ub3JtX2VwcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTNBJTIwdG9yY2guVGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25fZW1iZWRkaW5ncyUzQSUyMFR1cGxlJTVCdG9yY2guVGVuc29yJTJDJTIwdG9yY2guVGVuc29yJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0ElMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlJTNBJTIwT3B0aW9uYWwlNUJDYWNoZSU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmt3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMjAtJTNFJTIwVHVwbGUlNUJ0b3JjaC5UZW5zb3IlMkMlMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyQyUyME9wdGlvbmFsJTVCVHVwbGUlNUJ0b3JjaC5UZW5zb3IlNUQlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9zaGFwZSUyMCUzRCUyMGhpZGRlbl9zdGF0ZXMuc2hhcGUlNUIlM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zaGFwZSUyMCUzRCUyMCgqaW5wdXRfc2hhcGUlMkMlMjAtMSUyQyUyMHNlbGYuaGVhZF9kaW0pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTIwJTNEJTIwc2VsZi5xX25vcm0oc2VsZi5xX3Byb2ooaGlkZGVuX3N0YXRlcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyMCUzRCUyMHNlbGYua19ub3JtKHNlbGYua19wcm9qKGhpZGRlbl9zdGF0ZXMpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlX3N0YXRlcyUyMCUzRCUyMHNlbGYudl9wcm9qKGhpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTIwJTNEJTIwcXVlcnlfc3RhdGVzLnZpZXcoaGlkZGVuX3NoYXBlKS50cmFuc3Bvc2UoMSUyQyUyMDIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyMCUzRCUyMGtleV9zdGF0ZXMudmlldyhoaWRkZW5fc2hhcGUpLnRyYW5zcG9zZSgxJTJDJTIwMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZV9zdGF0ZXMlMjAlM0QlMjB2YWx1ZV9zdGF0ZXMudmlldyhoaWRkZW5fc2hhcGUpLnRyYW5zcG9zZSgxJTJDJTIwMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb3MlMkMlMjBzaW4lMjAlM0QlMjBwb3NpdGlvbl9lbWJlZGRpbmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTJDJTIwa2V5X3N0YXRlcyUyMCUzRCUyMGFwcGx5X3JvdGFyeV9wb3NfZW1iKHF1ZXJ5X3N0YXRlcyUyQyUyMGtleV9zdGF0ZXMlMkMlMjBjb3MlMkMlMjBzaW4pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBwYXN0X2tleV92YWx1ZSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNpbiUyMGFuZCUyMGNvcyUyMGFyZSUyMHNwZWNpZmljJTIwdG8lMjBSb1BFJTIwbW9kZWxzJTNCJTIwY2FjaGVfcG9zaXRpb24lMjBuZWVkZWQlMjBmb3IlMjB0aGUlMjBzdGF0aWMlMjBjYWNoZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2t3YXJncyUyMCUzRCUyMCU3QiUyMnNpbiUyMiUzQSUyMHNpbiUyQyUyMCUyMmNvcyUyMiUzQSUyMGNvcyUyQyUyMCUyMmNhY2hlX3Bvc2l0aW9uJTIyJTNBJTIwY2FjaGVfcG9zaXRpb24lN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlfc3RhdGVzJTJDJTIwdmFsdWVfc3RhdGVzJTIwJTNEJTIwcGFzdF9rZXlfdmFsdWUudXBkYXRlKGtleV9zdGF0ZXMlMkMlMjB2YWx1ZV9zdGF0ZXMlMkMlMjBzZWxmLmxheWVyX2lkeCUyQyUyMGNhY2hlX2t3YXJncyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25faW50ZXJmYWNlJTNBJTIwQ2FsbGFibGUlMjAlM0QlMjBlYWdlcl9hdHRlbnRpb25fZm9yd2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5jb25maWcuX2F0dG5faW1wbGVtZW50YXRpb24lMjAhJTNEJTIwJTIyZWFnZXIlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYuY29uZmlnLl9hdHRuX2ltcGxlbWVudGF0aW9uJTIwJTNEJTNEJTIwJTIyc2RwYSUyMiUyMGFuZCUyMGt3YXJncy5nZXQoJTIyb3V0cHV0X2F0dGVudGlvbnMlMjIlMkMlMjBGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dnZXIud2FybmluZ19vbmNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiU2MHRvcmNoLm5uLmZ1bmN0aW9uYWwuc2NhbGVkX2RvdF9wcm9kdWN0X2F0dGVudGlvbiU2MCUyMGRvZXMlMjBub3QlMjBzdXBwb3J0JTIwJTYwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTYwLiUyMEZhbGxpbmclMjBiYWNrJTIwdG8lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZWFnZXIlMjBhdHRlbnRpb24uJTIwVGhpcyUyMHdhcm5pbmclMjBjYW4lMjBiZSUyMHJlbW92ZWQlMjB1c2luZyUyMHRoZSUyMGFyZ3VtZW50JTIwJTYwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmVhZ2VyJTIyJTYwJTIwd2hlbiUyMGxvYWRpbmclMjB0aGUlMjBtb2RlbC4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25faW50ZXJmYWNlJTIwJTNEJTIwQUxMX0FUVEVOVElPTl9GVU5DVElPTlMlNUJzZWxmLmNvbmZpZy5fYXR0bl9pbXBsZW1lbnRhdGlvbiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dG5fb3V0cHV0JTJDJTIwYXR0bl93ZWlnaHRzJTIwJTNEJTIwYXR0ZW50aW9uX2ludGVyZmFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlX3N0YXRlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dCUzRDAuMCUyMGlmJTIwbm90JTIwc2VsZi50cmFpbmluZyUyMGVsc2UlMjBzZWxmLmF0dGVudGlvbl9kcm9wb3V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NhbGluZyUzRHNlbGYuc2NhbGluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqa3dhcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dG5fb3V0cHV0JTIwJTNEJTIwYXR0bl9vdXRwdXQucmVzaGFwZSgqaW5wdXRfc2hhcGUlMkMlMjAtMSkuY29udGlndW91cygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0bl9vdXRwdXQlMjAlM0QlMjBzZWxmLm9fcHJvaihhdHRuX291dHB1dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhdHRuX291dHB1dCUyQyUyMGF0dG5fd2VpZ2h0cw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> eager_attention_forward
<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoAttention, apply_rotary_pos_emb


<span class="hljs-comment"># Olmo2 attention is identical to OLMo attention except:</span>
<span class="hljs-comment"># - Norm is applied to attention queries and keys.</span>
<span class="hljs-comment"># - No qkv clipping.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Attention</span>(<span class="hljs-title class_ inherited__">OlmoAttention</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.q_norm = Olmo2RMSNorm(config.num_attention_heads * self.head_dim, config.rms_norm_eps)
        self.k_norm = Olmo2RMSNorm(config.num_key_value_heads * self.head_dim, config.rms_norm_eps)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        position_embeddings: <span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor],
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor], <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor]]]:
        input_shape = hidden_states.shape[:-<span class="hljs-number">1</span>]
        hidden_shape = (*input_shape, -<span class="hljs-number">1</span>, self.head_dim)

        query_states = self.q_norm(self.q_proj(hidden_states))
        key_states = self.k_norm(self.k_proj(hidden_states))
        value_states = self.v_proj(hidden_states)

        query_states = query_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        key_states = key_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        value_states = value_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)

        cos, sin = position_embeddings
        query_states, key_states = apply_rotary_pos_emb(query_states, key_states, cos, sin)

        <span class="hljs-keyword">if</span> past_key_value <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># sin and cos are specific to RoPE models; cache_position needed for the static cache</span>
            cache_kwargs = {<span class="hljs-string">&quot;sin&quot;</span>: sin, <span class="hljs-string">&quot;cos&quot;</span>: cos, <span class="hljs-string">&quot;cache_position&quot;</span>: cache_position}
            key_states, value_states = past_key_value.update(key_states, value_states, self.layer_idx, cache_kwargs)

        attention_interface: <span class="hljs-type">Callable</span> = eager_attention_forward
        <span class="hljs-keyword">if</span> self.config._attn_implementation != <span class="hljs-string">&quot;eager&quot;</span>:
            <span class="hljs-keyword">if</span> self.config._attn_implementation == <span class="hljs-string">&quot;sdpa&quot;</span> <span class="hljs-keyword">and</span> kwargs.get(<span class="hljs-string">&quot;output_attentions&quot;</span>, <span class="hljs-literal">False</span>):
                logger.warning_once(
                    <span class="hljs-string">&quot;\`torch.nn.functional.scaled_dot_product_attention\` does not support \`output_attentions=True\`. Falling back to &quot;</span>
                    <span class="hljs-string">&#x27;eager attention. This warning can be removed using the argument \`attn_implementation=&quot;eager&quot;\` when loading the model.&#x27;</span>
                )
            <span class="hljs-keyword">else</span>:
                attention_interface = ALL_ATTENTION_FUNCTIONS[self.config._attn_implementation]

        attn_output, attn_weights = attention_interface(
            self,
            query_states,
            key_states,
            value_states,
            attention_mask,
            dropout=<span class="hljs-number">0.0</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.training <span class="hljs-keyword">else</span> self.attention_dropout,
            scaling=self.scaling,
            **kwargs,
        )

        attn_output = attn_output.reshape(*input_shape, -<span class="hljs-number">1</span>).contiguous()
        attn_output = self.o_proj(attn_output)
        <span class="hljs-keyword">return</span> attn_output, attn_weights`,wrap:!1}}),Tl=new r({props:{title:"The DecoderLayer class",local:"the-decoderlayer-class",headingTag:"h3"}}),jl=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoDecoderLayer

<span class="hljs-comment"># The OLMo2 layers are identical to those of the OLMo model except:</span>
<span class="hljs-comment"># - RMSNorm is used instead of standard layer norm.</span>
<span class="hljs-comment"># - Norm is applied after attention/feedforward rather than before.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2DecoderLayer</span>(<span class="hljs-title class_ inherited__">OlmoDecoderLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.post_attention_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.post_feedforward_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.self_attn = Olmo2Attention(config=config, layer_idx=layer_idx)
        <span class="hljs-keyword">del</span> self.input_layernorm

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        position_embeddings: <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor]] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># necessary, but kept here for BC</span>
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.FloatTensor, <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.FloatTensor, torch.FloatTensor]]]:
        residual = hidden_states

        <span class="hljs-comment"># Self Attention</span>
        hidden_states, self_attn_weights = self.self_attn(
            hidden_states=hidden_states,
            attention_mask=attention_mask,
            position_ids=position_ids,
            past_key_value=past_key_value,
            output_attentions=output_attentions,
            use_cache=use_cache,
            cache_position=cache_position,
            position_embeddings=position_embeddings,
            **kwargs,
        )
        hidden_states = self.post_attention_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        <span class="hljs-comment"># Fully Connected</span>
        residual = hidden_states
        hidden_states = self.mlp(hidden_states)
        hidden_states = self.post_feedforward_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        outputs = (hidden_states,)
        <span class="hljs-keyword">if</span> output_attentions:
            outputs += (self_attn_weights,)

        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),hl=new r({props:{title:"The Model class",local:"the-model-class",headingTag:"h3"}}),Cl=new T({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01vZGVsJTBBJTBBJTIzJTIwVGhlJTIwT0xNbzIlMjBtb2RlbCUyMGlzJTIwaWRlbnRpY2FsJTIwdG8lMjB0aGUlMjBPTE1vJTIwbW9kZWwlMkMlMjBleGNlcHQlMjBSTVNOb3JtJTIwaXMlMjB1c2VkJTIwaW5zdGVhZCUyMG9mJTBBJTIzJTIwc3RhbmRhcmQlMjBsYXllciUyMG5vcm0lMjBmb3IlMjB0aGUlMjBvdXRwdXQlMjBub3JtLiUwQWNsYXNzJTIwT2xtbzJNb2RlbChPbG1vTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME9sbW8yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcuaGlkZGVuX3NpemUlMkMlMjBlcHMlM0Rjb25maWcucm1zX25vcm1fZXBzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJzJTIwJTNEJTIwbm4uTW9kdWxlTGlzdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJPbG1vMkRlY29kZXJMYXllcihjb25maWclMkMlMjBsYXllcl9pZHgpJTIwZm9yJTIwbGF5ZXJfaWR4JTIwaW4lMjByYW5nZShjb25maWcubnVtX2hpZGRlbl9sYXllcnMpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoModel

<span class="hljs-comment"># The OLMo2 model is identical to the OLMo model, except RMSNorm is used instead of</span>
<span class="hljs-comment"># standard layer norm for the output norm.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Model</span>(<span class="hljs-title class_ inherited__">OlmoModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.norm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.layers = nn.ModuleList(
            [Olmo2DecoderLayer(config, layer_idx) <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)]
        )`,wrap:!1}}),Il=new r({props:{title:"Finally… The ForCausalLM class",local:"finally-the-forcausallm-class",headingTag:"h3"}}),bl=new T({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb0ZvckNhdXNhbExNJTBBJTBBY2xhc3MlMjBPbG1vMkZvckNhdXNhbExNKE9sbW9Gb3JDYXVzYWxMTSklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoForCausalLM

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2ForCausalLM</span>(<span class="hljs-title class_ inherited__">OlmoForCausalLM</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),gl=new T({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01MUCUwQSUwQWNsYXNzJTIwT2xtbzJNTFAoT2xtb01MUCklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">OlmoMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),vl=new T({props:{code:"JTIzJTIwc3dpdGNoJTIwdG8lMjBtaXN0cmFsJTIwZGVmaW5pdGlvbiUwQWZyb20lMjAuLm1pc3RyYWwubW9kZWxpbmdfbWlzdHJhbCUyMGltcG9ydCUyME1pc3RyYWxNTFAlMEElMEFjbGFzcyUyME9sbW8yTUxQKE1pc3RyYWxNTFApJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-comment"># switch to mistral definition</span>
<span class="hljs-keyword">from</span> ..mistral.modeling_mistral <span class="hljs-keyword">import</span> MistralMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">MistralMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),kl=new r({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Nl=new r({props:{title:"Removing attributes which are not just assignments",local:"removing-attributes-which-are-not-just-assignments",headingTag:"h3"}}),Xl=new T({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwRHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwc2VsZi5hdHRyaWJ1dGUlMjAlM0QlMjBjb25maWcuYXR0cmlidXRlJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmF0dHJpYnV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwbW9yZSUyMHN0dWZmJTIwd2l0aCUyMCU2MHNlbGYuYXR0cmlidXRlJTYwJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: DummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__()
    self.attribute = config.attribute
    <span class="hljs-keyword">if</span> self.attribute:
      <span class="hljs-comment"># do more stuff with \`self.attribute\` here</span>
      ...`,wrap:!1}}),Vl=new T({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwTXlOZXdEdW1teUNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjBkZWwlMjBzZWxmLmF0dHJpYnV0ZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-keyword">del</span> self.attribute`,wrap:!1}}),zl=new r({props:{title:"Avoiding super() special meaning",local:"avoiding-super-special-meaning",headingTag:"h3"}}),Ql=new T({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCUyQyUyMG5uLk1vZHVsZSklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjBjbGFzcyUyME15TmV3RHVtbXlNb2RlbChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlLl9faW5pdF9fKGNvbmZpZyklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(DummyModel, nn.Module):        |     <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(nn.Module):
                                                     |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):      |       <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    nn.Module.__init__(config)                       |         <span class="hljs-built_in">super</span>().__init__()
    self.foo = config.foo                            |         self.foo = config.foo
    ...                                              |         ...`,wrap:!1}}),Hl=new r({props:{title:"Deleting unused methods",local:"deleting-unused-methods",headingTag:"h3"}}),Fl=new T({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfc3BtX3Byb2Nlc3NvcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdW5rX3Rva2VuX2xlbmd0aChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(<span class="hljs-title class_ inherited__">LlamaTokenizer</span>):
    ...

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_spm_processor</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">unk_token_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)`,wrap:!1}}),Ll=new r({props:{title:"Define new functions",local:"define-new-functions",headingTag:"h3"}}),Ol=new T({props:{code:"ZGVmJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIzJTIwRG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwcGFzcyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbChMbGFtYU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoKmFyZ3MlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDYWxsJTIwdGhlJTIwZnVuY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwY29udGludWUlMjBoZXJl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_function</span>(<span class="hljs-params">*args, **kwargs</span>):
  <span class="hljs-comment"># Do something here</span>
  <span class="hljs-keyword">pass</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(<span class="hljs-title class_ inherited__">LlamaModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">*args, **kwargs</span>):
      <span class="hljs-comment"># Call the function</span>
      example = my_new_function(*args, **kwargs)
      <span class="hljs-comment"># continue here</span>`,wrap:!1}}),Kl=new r({props:{title:"Decorators",local:"decorators",headingTag:"h3"}}),ee=new T({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBkZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc3R1ZmYlMjBoZXJl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):
  ...

<span class="hljs-meta">  @decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
    <span class="hljs-comment"># do stuff here</span>`,wrap:!1}}),te=new T({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MGRlY29yYXRvciguLi4pJTBBJTIwJTIwJTIwJTIwLi4uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     @decorator(...)
    ...                           |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
                                  |       ...`,wrap:!1}}),Me=new T({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
<span class="hljs-meta">  @my_new_decorator(<span class="hljs-params">...</span>)          |     @my_new_decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
    ...                           |       ...`,wrap:!1}}),ie=new r({props:{title:"The super_kwargs special case",local:"the-superkwargs-special-case",headingTag:"h3"}}),ye=new T({props:{code:"Y2xhc3MlMjBMbGFtYUZvckNhdXNhbExNKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBhZGRfc3RhcnRfZG9jc3RyaW5nc190b19tb2RlbF9mb3J3YXJkKExMQU1BX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTQwcmVwbGFjZV9yZXR1cm5fZG9jc3RyaW5ncyhvdXRwdXRfdHlwZSUzRENhdXNhbExNT3V0cHV0V2l0aFBhc3QlMkMlMjBjb25maWdfY2xhc3MlM0RfQ09ORklHX0ZPUl9ET0MpJTBBJTIwJTIwZGVmJTIwZm9yd2FyZCglMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNBJTIwdG9yY2guTG9uZ1RlbnNvciUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHBvc2l0aW9uX2lkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwYXN0X2tleV92YWx1ZXMlM0ElMjBPcHRpb25hbCU1QlVuaW9uJTVCQ2FjaGUlMkMlMjBMaXN0JTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlNUQlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzX2VtYmVkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5Mb25nVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfYXR0ZW50aW9ucyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfaGlkZGVuX3N0YXRlcyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBudW1fbG9naXRzX3RvX2tlZXAlM0ElMjBpbnQlMjAlM0QlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlM0ElMjBVbnBhY2slNUJLd2FyZ3NGb3JDYXVzYWxMTSU1RCUyQyUwQSUyMCUyMCklMjAtJTNFJTIwVW5pb24lNUJUdXBsZSUyQyUyMENhdXNhbExNT3V0cHV0V2l0aFBhc3QlNUQlM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...

<span class="hljs-meta">  @add_start_docstrings_to_model_forward(<span class="hljs-params">LLAMA_INPUTS_DOCSTRING</span>)</span>
<span class="hljs-meta">  @replace_return_docstrings(<span class="hljs-params">output_type=CausalLMOutputWithPast, config_class=_CONFIG_FOR_DOC</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
      self,
      input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
      attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
      position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = <span class="hljs-literal">None</span>,
      inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
      labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
      **kwargs: Unpack[KwargsForCausalLM],
  </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
    ...`,wrap:!1}}),pe=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModelForCausalLM</span>(<span class="hljs-title class_ inherited__">LlamaForCausalLM</span>):    |    <span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...                                           |      ...
                                                |
<span class="hljs-meta">  @my_new_decorator                             |     @my_new_decorator</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, **super_kwargs</span>):            |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
    <span class="hljs-built_in">super</span>(<span class="hljs-params"></span>).forward(<span class="hljs-params">**super_kwargs</span>)             |         self,
                                                |         input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
                                                |         attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
                                                |         position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = |<span class="hljs-literal">None</span>,
                                                |         inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
                                                |         labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
                                                |         **kwargs: Unpack[KwargsForCausalLM],
                                                |     </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
                                                |       ...`,wrap:!1}}),Ue=new r({props:{title:"The DOCSTRING variables",local:"the-docstring-variables",headingTag:"h3"}}),re=new T({props:{code:"U1RBUkNPREVSMl9JTlBVVFNfRE9DU1RSSU5HJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMGF1dG9tYXRpY2FsbHklMjByZWRlZmluZWQlMEElMEFjbGFzcyUyMFN0YXJjb2RlcjJNb2RlbChNaXN0cmFsTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTQwYWRkX3N0YXJ0X2RvY3N0cmluZ3NfdG9fbW9kZWxfZm9yd2FyZChTVEFSQ09ERVIyX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`STARCODER2_INPUTS_DOCSTRING = <span class="hljs-literal">None</span>  <span class="hljs-comment"># will be automatically redefined</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Starcoder2Model</span>(<span class="hljs-title class_ inherited__">MistralModel</span>):
    ...

<span class="hljs-meta">    @add_start_docstrings_to_model_forward(<span class="hljs-params">STARCODER2_INPUTS_DOCSTRING</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
        ...`,wrap:!1}}),Je=new r({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),he=new r({props:{title:"Special naming (essentially for multimodal models)",local:"special-naming-essentially-for-multimodal-models",headingTag:"h3"}}),ue=new T({props:{code:"Y2xhc3MlMjBNeU1vZGVsSW5jcmVkaWJsZU1MUChMbGFtYU1MUCklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFjbGFzcyUyME15TW9kZWxEZWNvZGVyTGF5ZXIoTGxhbWFEZWNvZGVyTGF5ZXIpJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelIncredibleMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):
    ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelDecoderLayer</span>(<span class="hljs-title class_ inherited__">LlamaDecoderLayer</span>):
    ...`,wrap:!1}}),Ae=new T({props:{code:"V2UlMjBkZXRlY3RlZCUyMG11bHRpcGxlJTIwcHJlZml4JTIwbmFtZXMlMjB3aGVuJTIwaW5oZXJpdGluZyUyMGZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLmxsYW1hLm1vZGVsaW5nX2xsYW1hJTNBJTIwKCdFbXUzVGV4dCclMkMlMjAnRW11MycpLiUyMFdlJTIwd2lsbCUyMG9ubHklMjB1c2UlMjB0aGUlMjBtb3N0JTIwdXNlZCUyMCdFbXUzJyUyMHByZWZpeCUyMHdoZW4lMjBncmFiYmluZyUyMGFyZ3MlMjBhbmQlMjBkZXBlbmRlbmNpZXMuJTIwTWFrZSUyMHN1cmUlMjB0byUyMHN1YmNsYXNzJTIwdGhlJTIwaW50ZXJtZWRpYXRlJTIwY2xhc3NlcyUyMHdpdGglMjB0aGUlMjBwcmVmaXglMjB5b3UlMjB3YW50JTIwKGlmJTIwZGlmZmVyZW50JTIwZnJvbSUyMCdFbXUzJyklMjBvciUyMHVzZSUyMGElMjBzaW5nbGUlMjBwcmVmaXglMjBpbiUyMGFsbCUyMHRoZSUyMG1vZHVsYXIlMjAoYmVzdCku",highlighted:'We detected multiple prefix names when inheriting <span class="hljs-built_in">from</span> transformers.models.llama.modeling_llama: (<span class="hljs-string">&#x27;Emu3Text&#x27;</span>, <span class="hljs-string">&#x27;Emu3&#x27;</span>). We will only use <span class="hljs-keyword">the</span> most used <span class="hljs-string">&#x27;Emu3&#x27;</span> prefix when grabbing args <span class="hljs-keyword">and</span> dependencies. Make sure <span class="hljs-built_in">to</span> subclass <span class="hljs-keyword">the</span> intermediate classes <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> prefix you want (<span class="hljs-keyword">if</span> different <span class="hljs-built_in">from</span> <span class="hljs-string">&#x27;Emu3&#x27;</span>) <span class="hljs-keyword">or</span> use <span class="hljs-keyword">a</span> single prefix <span class="hljs-keyword">in</span> all <span class="hljs-keyword">the</span> modular (best).',wrap:!1}}),Ze=new T({props:{code:"Y2xhc3MlMjBFbXUzVGV4dE1MUChMbGFtYU1MUCklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Emu3TextMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):                                 
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Be=new r({props:{title:"Automatic docstrings issue (mostly for Configs)",local:"automatic-docstrings-issue-mostly-for-configs",headingTag:"h3"}}),ve=new vM({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){j=n("meta"),We=a(),Re=n("p"),Xe=a(),y(J.$$.fragment),Ee=a(),m=n("p"),m.innerHTML=aa,Ve=a(),h=n("p"),h.innerHTML=Ma,$e=a(),C=n("p"),C.innerHTML=na,xe=a(),u=n("p"),u.textContent=ia,ze=a(),I=n("p"),I.textContent=oa,Ye=a(),f=n("p"),f.textContent=ya,Qe=a(),b=n("p"),b.innerHTML=wa,He=a(),y(A.$$.fragment),Se=a(),_=n("p"),_.textContent=pa,Fe=a(),Z=n("p"),Z.textContent=da,Le=a(),g=n("p"),g.innerHTML=ca,De=a(),B=n("p"),B.textContent=Ua,Oe=a(),G=n("p"),G.innerHTML=Ta,Pe=a(),y(v.$$.fragment),Ke=a(),k=n("p"),k.textContent=ra,qe=a(),y(R.$$.fragment),ls=a(),N=n("p"),N.innerHTML=ja,es=a(),W=n("p"),W.textContent=Ja,ss=a(),X=n("ul"),X.innerHTML=ma,ts=a(),E=n("p"),E.innerHTML=ha,as=a(),y(V.$$.fragment),Ms=a(),$=n("p"),$.innerHTML=Ca,ns=a(),y(x.$$.fragment),is=a(),y(z.$$.fragment),os=a(),Y=n("p"),Y.textContent=ua,ys=a(),Q=n("p"),Q.innerHTML=Ia,ws=a(),y(H.$$.fragment),ps=a(),y(S.$$.fragment),ds=a(),F=n("p"),F.innerHTML=fa,cs=a(),y(L.$$.fragment),Us=a(),D=n("p"),D.innerHTML=ba,Ts=a(),O=n("p"),O.textContent=Aa,rs=a(),P=n("ul"),P.innerHTML=_a,js=a(),K=n("p"),K.innerHTML=Za,Js=a(),q=n("p"),q.textContent=ga,ms=a(),y(ll.$$.fragment),hs=a(),el=n("p"),el.innerHTML=Ba,Cs=a(),y(sl.$$.fragment),us=a(),tl=n("p"),tl.innerHTML=Ga,Is=a(),al=n("ol"),al.innerHTML=va,fs=a(),Ml=n("p"),Ml.innerHTML=ka,bs=a(),nl=n("p"),nl.innerHTML=Ra,As=a(),y(il.$$.fragment),_s=a(),ol=n("p"),ol.innerHTML=Na,Zs=a(),y(yl.$$.fragment),gs=a(),wl=n("p"),wl.innerHTML=Wa,Bs=a(),y(pl.$$.fragment),Gs=a(),dl=n("p"),dl.innerHTML=Xa,vs=a(),y(cl.$$.fragment),ks=a(),Ul=n("p"),Ul.innerHTML=Ea,Rs=a(),y(Tl.$$.fragment),Ns=a(),rl=n("p"),rl.innerHTML=Va,Ws=a(),y(jl.$$.fragment),Xs=a(),Jl=n("p"),Jl.innerHTML=$a,Es=a(),ml=n("p"),ml.innerHTML=xa,Vs=a(),y(hl.$$.fragment),$s=a(),y(Cl.$$.fragment),xs=a(),ul=n("p"),ul.innerHTML=za,zs=a(),y(Il.$$.fragment),Ys=a(),fl=n("p"),fl.innerHTML=Ya,Qs=a(),y(bl.$$.fragment),Hs=a(),Al=n("p"),Al.innerHTML=Qa,Ss=a(),ke=n("a"),Fs=ZM(`
### But... What about the MLP, RotaryEmbedding and PreTrainedModel classes?
`),_l=n("p"),_l.innerHTML=Ha,Ls=a(),Zl=n("p"),Zl.innerHTML=Sa,Ds=a(),y(gl.$$.fragment),Os=a(),Bl=n("p"),Bl.innerHTML=Fa,Ps=a(),Gl=n("p"),Gl.innerHTML=La,Ks=a(),y(vl.$$.fragment),qs=a(),y(kl.$$.fragment),lt=a(),Rl=n("p"),Rl.textContent=Da,et=a(),y(Nl.$$.fragment),st=a(),Wl=n("p"),Wl.innerHTML=Oa,tt=a(),y(Xl.$$.fragment),at=a(),El=n("p"),El.innerHTML=Pa,Mt=a(),y(Vl.$$.fragment),nt=a(),$l=n("p"),$l.innerHTML=Ka,it=a(),xl=n("p"),xl.innerHTML=qa,ot=a(),y(zl.$$.fragment),yt=a(),Yl=n("p"),Yl.innerHTML=lM,wt=a(),y(Ql.$$.fragment),pt=a(),y(Hl.$$.fragment),dt=a(),Sl=n("p"),Sl.innerHTML=eM,ct=a(),y(Fl.$$.fragment),Ut=a(),y(Ll.$$.fragment),Tt=a(),Dl=n("p"),Dl.innerHTML=sM,rt=a(),y(Ol.$$.fragment),jt=a(),Pl=n("p"),Pl.innerHTML=tM,Jt=a(),y(Kl.$$.fragment),mt=a(),ql=n("p"),ql.innerHTML=aM,ht=a(),le=n("p"),le.textContent=MM,Ct=a(),y(ee.$$.fragment),ut=a(),se=n("p"),se.textContent=nM,It=a(),y(te.$$.fragment),ft=a(),ae=n("p"),ae.textContent=iM,bt=a(),y(Me.$$.fragment),At=a(),ne=n("p"),ne.textContent=oM,_t=a(),y(ie.$$.fragment),Zt=a(),oe=n("p"),oe.innerHTML=yM,gt=a(),y(ye.$$.fragment),Bt=a(),we=n("p"),we.textContent=wM,Gt=a(),y(pe.$$.fragment),vt=a(),de=n("p"),de.innerHTML=pM,kt=a(),ce=n("p"),ce.innerHTML=dM,Rt=a(),y(Ue.$$.fragment),Nt=a(),Te=n("p"),Te.innerHTML=cM,Wt=a(),y(re.$$.fragment),Xt=a(),je=n("p"),je.innerHTML=UM,Et=a(),y(Je.$$.fragment),Vt=a(),me=n("p"),me.textContent=TM,$t=a(),y(he.$$.fragment),xt=a(),Ce=n("p"),Ce.innerHTML=rM,zt=a(),y(ue.$$.fragment),Yt=a(),Ie=n("p"),Ie.innerHTML=jM,Qt=a(),fe=n("p"),fe.innerHTML=JM,Ht=a(),be=n("p"),be.textContent=mM,St=a(),y(Ae.$$.fragment),Ft=a(),_e=n("p"),_e.innerHTML=hM,Lt=a(),y(Ze.$$.fragment),Dt=a(),ge=n("p"),ge.innerHTML=CM,Ot=a(),y(Be.$$.fragment),Pt=a(),Ge=n("p"),Ge.textContent=uM,Kt=a(),y(ve.$$.fragment),qt=a(),Ne=n("p"),this.h()},l(l){const e=gM("svelte-u9bgzb",document.head);j=i(e,"META",{name:!0,content:!0}),e.forEach(s),We=M(l),Re=i(l,"P",{}),ea(Re).forEach(s),Xe=M(l),w(J.$$.fragment,l),Ee=M(l),m=i(l,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1qsl2az"&&(m.innerHTML=aa),Ve=M(l),h=i(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1qcwnc7"&&(h.innerHTML=Ma),$e=M(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-hcbv0p"&&(C.innerHTML=na),xe=M(l),u=i(l,"P",{"data-svelte-h":!0}),o(u)!=="svelte-14lpvvv"&&(u.textContent=ia),ze=M(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1tehds2"&&(I.textContent=oa),Ye=M(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-5u9x31"&&(f.textContent=ya),Qe=M(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-c0230n"&&(b.innerHTML=wa),He=M(l),w(A.$$.fragment,l),Se=M(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1qqnnub"&&(_.textContent=pa),Fe=M(l),Z=i(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-huwsbv"&&(Z.textContent=da),Le=M(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-dk7wye"&&(g.innerHTML=ca),De=M(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-12pm85e"&&(B.textContent=Ua),Oe=M(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ah1dr9"&&(G.innerHTML=Ta),Pe=M(l),w(v.$$.fragment,l),Ke=M(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-11y95xa"&&(k.textContent=ra),qe=M(l),w(R.$$.fragment,l),ls=M(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-xkvkhs"&&(N.innerHTML=ja),es=M(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1gkqha7"&&(W.textContent=Ja),ss=M(l),X=i(l,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-1np4rww"&&(X.innerHTML=ma),ts=M(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12b6859"&&(E.innerHTML=ha),as=M(l),w(V.$$.fragment,l),Ms=M(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1jju20g"&&($.innerHTML=Ca),ns=M(l),w(x.$$.fragment,l),is=M(l),w(z.$$.fragment,l),os=M(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1o8u693"&&(Y.textContent=ua),ys=M(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-si4m91"&&(Q.innerHTML=Ia),ws=M(l),w(H.$$.fragment,l),ps=M(l),w(S.$$.fragment,l),ds=M(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-bvl6dd"&&(F.innerHTML=fa),cs=M(l),w(L.$$.fragment,l),Us=M(l),D=i(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-6v2s2r"&&(D.innerHTML=ba),Ts=M(l),O=i(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1cop7hb"&&(O.textContent=Aa),rs=M(l),P=i(l,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-579f4p"&&(P.innerHTML=_a),js=M(l),K=i(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-52k0wz"&&(K.innerHTML=Za),Js=M(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-33jo7g"&&(q.textContent=ga),ms=M(l),w(ll.$$.fragment,l),hs=M(l),el=i(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1xf26oy"&&(el.innerHTML=Ba),Cs=M(l),w(sl.$$.fragment,l),us=M(l),tl=i(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-17h1ydr"&&(tl.innerHTML=Ga),Is=M(l),al=i(l,"OL",{"data-svelte-h":!0}),o(al)!=="svelte-wmze1e"&&(al.innerHTML=va),fs=M(l),Ml=i(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-18k2jgy"&&(Ml.innerHTML=ka),bs=M(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-8zw5rz"&&(nl.innerHTML=Ra),As=M(l),w(il.$$.fragment,l),_s=M(l),ol=i(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-zq0wu8"&&(ol.innerHTML=Na),Zs=M(l),w(yl.$$.fragment,l),gs=M(l),wl=i(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-4e6smr"&&(wl.innerHTML=Wa),Bs=M(l),w(pl.$$.fragment,l),Gs=M(l),dl=i(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-m4gli0"&&(dl.innerHTML=Xa),vs=M(l),w(cl.$$.fragment,l),ks=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-f779jp"&&(Ul.innerHTML=Ea),Rs=M(l),w(Tl.$$.fragment,l),Ns=M(l),rl=i(l,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-8hd4fl"&&(rl.innerHTML=Va),Ws=M(l),w(jl.$$.fragment,l),Xs=M(l),Jl=i(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1puk9ym"&&(Jl.innerHTML=$a),Es=M(l),ml=i(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1jvwg68"&&(ml.innerHTML=xa),Vs=M(l),w(hl.$$.fragment,l),$s=M(l),w(Cl.$$.fragment,l),xs=M(l),ul=i(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1upff2z"&&(ul.innerHTML=za),zs=M(l),w(Il.$$.fragment,l),Ys=M(l),fl=i(l,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-hjuool"&&(fl.innerHTML=Ya),Qs=M(l),w(bl.$$.fragment,l),Hs=M(l),Al=i(l,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-1p1nc5i"&&(Al.innerHTML=Qa),Ss=M(l),ke=i(l,"A",{id:!0}),ea(ke).forEach(s),Fs=BM(l,`
### But... What about the MLP, RotaryEmbedding and PreTrainedModel classes?
`),_l=i(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-129wpkp"&&(_l.innerHTML=Ha),Ls=M(l),Zl=i(l,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-1iwt0rn"&&(Zl.innerHTML=Sa),Ds=M(l),w(gl.$$.fragment,l),Os=M(l),Bl=i(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-hx072i"&&(Bl.innerHTML=Fa),Ps=M(l),Gl=i(l,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-115qkhu"&&(Gl.innerHTML=La),Ks=M(l),w(vl.$$.fragment,l),qs=M(l),w(kl.$$.fragment,l),lt=M(l),Rl=i(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-2lsmzy"&&(Rl.textContent=Da),et=M(l),w(Nl.$$.fragment,l),st=M(l),Wl=i(l,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-j6677p"&&(Wl.innerHTML=Oa),tt=M(l),w(Xl.$$.fragment,l),at=M(l),El=i(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1y6u0yw"&&(El.innerHTML=Pa),Mt=M(l),w(Vl.$$.fragment,l),nt=M(l),$l=i(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1gbrqtm"&&($l.innerHTML=Ka),it=M(l),xl=i(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-1kphpee"&&(xl.innerHTML=qa),ot=M(l),w(zl.$$.fragment,l),yt=M(l),Yl=i(l,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-1bd6kt0"&&(Yl.innerHTML=lM),wt=M(l),w(Ql.$$.fragment,l),pt=M(l),w(Hl.$$.fragment,l),dt=M(l),Sl=i(l,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-c9w476"&&(Sl.innerHTML=eM),ct=M(l),w(Fl.$$.fragment,l),Ut=M(l),w(Ll.$$.fragment,l),Tt=M(l),Dl=i(l,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-hvsyf6"&&(Dl.innerHTML=sM),rt=M(l),w(Ol.$$.fragment,l),jt=M(l),Pl=i(l,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ov84rp"&&(Pl.innerHTML=tM),Jt=M(l),w(Kl.$$.fragment,l),mt=M(l),ql=i(l,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-i7t16s"&&(ql.innerHTML=aM),ht=M(l),le=i(l,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1xerhbv"&&(le.textContent=MM),Ct=M(l),w(ee.$$.fragment,l),ut=M(l),se=i(l,"P",{"data-svelte-h":!0}),o(se)!=="svelte-3hueol"&&(se.textContent=nM),It=M(l),w(te.$$.fragment,l),ft=M(l),ae=i(l,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-gta4rc"&&(ae.textContent=iM),bt=M(l),w(Me.$$.fragment,l),At=M(l),ne=i(l,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1u8jzso"&&(ne.textContent=oM),_t=M(l),w(ie.$$.fragment,l),Zt=M(l),oe=i(l,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-cbveqz"&&(oe.innerHTML=yM),gt=M(l),w(ye.$$.fragment,l),Bt=M(l),we=i(l,"P",{"data-svelte-h":!0}),o(we)!=="svelte-154jhi"&&(we.textContent=wM),Gt=M(l),w(pe.$$.fragment,l),vt=M(l),de=i(l,"P",{"data-svelte-h":!0}),o(de)!=="svelte-2ilo5h"&&(de.innerHTML=pM),kt=M(l),ce=i(l,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-sb4f3e"&&(ce.innerHTML=dM),Rt=M(l),w(Ue.$$.fragment,l),Nt=M(l),Te=i(l,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-187vlwj"&&(Te.innerHTML=cM),Wt=M(l),w(re.$$.fragment,l),Xt=M(l),je=i(l,"P",{"data-svelte-h":!0}),o(je)!=="svelte-sm5l0i"&&(je.innerHTML=UM),Et=M(l),w(Je.$$.fragment,l),Vt=M(l),me=i(l,"P",{"data-svelte-h":!0}),o(me)!=="svelte-168b6cn"&&(me.textContent=TM),$t=M(l),w(he.$$.fragment,l),xt=M(l),Ce=i(l,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1gs6a5h"&&(Ce.innerHTML=rM),zt=M(l),w(ue.$$.fragment,l),Yt=M(l),Ie=i(l,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-um3kky"&&(Ie.innerHTML=jM),Qt=M(l),fe=i(l,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-143l68k"&&(fe.innerHTML=JM),Ht=M(l),be=i(l,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1b02g9p"&&(be.textContent=mM),St=M(l),w(Ae.$$.fragment,l),Ft=M(l),_e=i(l,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-152u23"&&(_e.innerHTML=hM),Lt=M(l),w(Ze.$$.fragment,l),Dt=M(l),ge=i(l,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1sm5een"&&(ge.innerHTML=CM),Ot=M(l),w(Be.$$.fragment,l),Pt=M(l),Ge=i(l,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1i3zif8"&&(Ge.textContent=uM),Kt=M(l),w(ve.$$.fragment,l),qt=M(l),Ne=i(l,"P",{}),ea(Ne).forEach(s),this.h()},h(){sa(j,"name","hf:doc:metadata"),sa(j,"content",RM),sa(ke,"id","dependencies")},m(l,e){GM(document.head,j),t(l,We,e),t(l,Re,e),t(l,Xe,e),p(J,l,e),t(l,Ee,e),t(l,m,e),t(l,Ve,e),t(l,h,e),t(l,$e,e),t(l,C,e),t(l,xe,e),t(l,u,e),t(l,ze,e),t(l,I,e),t(l,Ye,e),t(l,f,e),t(l,Qe,e),t(l,b,e),t(l,He,e),p(A,l,e),t(l,Se,e),t(l,_,e),t(l,Fe,e),t(l,Z,e),t(l,Le,e),t(l,g,e),t(l,De,e),t(l,B,e),t(l,Oe,e),t(l,G,e),t(l,Pe,e),p(v,l,e),t(l,Ke,e),t(l,k,e),t(l,qe,e),p(R,l,e),t(l,ls,e),t(l,N,e),t(l,es,e),t(l,W,e),t(l,ss,e),t(l,X,e),t(l,ts,e),t(l,E,e),t(l,as,e),p(V,l,e),t(l,Ms,e),t(l,$,e),t(l,ns,e),p(x,l,e),t(l,is,e),p(z,l,e),t(l,os,e),t(l,Y,e),t(l,ys,e),t(l,Q,e),t(l,ws,e),p(H,l,e),t(l,ps,e),p(S,l,e),t(l,ds,e),t(l,F,e),t(l,cs,e),p(L,l,e),t(l,Us,e),t(l,D,e),t(l,Ts,e),t(l,O,e),t(l,rs,e),t(l,P,e),t(l,js,e),t(l,K,e),t(l,Js,e),t(l,q,e),t(l,ms,e),p(ll,l,e),t(l,hs,e),t(l,el,e),t(l,Cs,e),p(sl,l,e),t(l,us,e),t(l,tl,e),t(l,Is,e),t(l,al,e),t(l,fs,e),t(l,Ml,e),t(l,bs,e),t(l,nl,e),t(l,As,e),p(il,l,e),t(l,_s,e),t(l,ol,e),t(l,Zs,e),p(yl,l,e),t(l,gs,e),t(l,wl,e),t(l,Bs,e),p(pl,l,e),t(l,Gs,e),t(l,dl,e),t(l,vs,e),p(cl,l,e),t(l,ks,e),t(l,Ul,e),t(l,Rs,e),p(Tl,l,e),t(l,Ns,e),t(l,rl,e),t(l,Ws,e),p(jl,l,e),t(l,Xs,e),t(l,Jl,e),t(l,Es,e),t(l,ml,e),t(l,Vs,e),p(hl,l,e),t(l,$s,e),p(Cl,l,e),t(l,xs,e),t(l,ul,e),t(l,zs,e),p(Il,l,e),t(l,Ys,e),t(l,fl,e),t(l,Qs,e),p(bl,l,e),t(l,Hs,e),t(l,Al,e),t(l,Ss,e),t(l,ke,e),t(l,Fs,e),t(l,_l,e),t(l,Ls,e),t(l,Zl,e),t(l,Ds,e),p(gl,l,e),t(l,Os,e),t(l,Bl,e),t(l,Ps,e),t(l,Gl,e),t(l,Ks,e),p(vl,l,e),t(l,qs,e),p(kl,l,e),t(l,lt,e),t(l,Rl,e),t(l,et,e),p(Nl,l,e),t(l,st,e),t(l,Wl,e),t(l,tt,e),p(Xl,l,e),t(l,at,e),t(l,El,e),t(l,Mt,e),p(Vl,l,e),t(l,nt,e),t(l,$l,e),t(l,it,e),t(l,xl,e),t(l,ot,e),p(zl,l,e),t(l,yt,e),t(l,Yl,e),t(l,wt,e),p(Ql,l,e),t(l,pt,e),p(Hl,l,e),t(l,dt,e),t(l,Sl,e),t(l,ct,e),p(Fl,l,e),t(l,Ut,e),p(Ll,l,e),t(l,Tt,e),t(l,Dl,e),t(l,rt,e),p(Ol,l,e),t(l,jt,e),t(l,Pl,e),t(l,Jt,e),p(Kl,l,e),t(l,mt,e),t(l,ql,e),t(l,ht,e),t(l,le,e),t(l,Ct,e),p(ee,l,e),t(l,ut,e),t(l,se,e),t(l,It,e),p(te,l,e),t(l,ft,e),t(l,ae,e),t(l,bt,e),p(Me,l,e),t(l,At,e),t(l,ne,e),t(l,_t,e),p(ie,l,e),t(l,Zt,e),t(l,oe,e),t(l,gt,e),p(ye,l,e),t(l,Bt,e),t(l,we,e),t(l,Gt,e),p(pe,l,e),t(l,vt,e),t(l,de,e),t(l,kt,e),t(l,ce,e),t(l,Rt,e),p(Ue,l,e),t(l,Nt,e),t(l,Te,e),t(l,Wt,e),p(re,l,e),t(l,Xt,e),t(l,je,e),t(l,Et,e),p(Je,l,e),t(l,Vt,e),t(l,me,e),t(l,$t,e),p(he,l,e),t(l,xt,e),t(l,Ce,e),t(l,zt,e),p(ue,l,e),t(l,Yt,e),t(l,Ie,e),t(l,Qt,e),t(l,fe,e),t(l,Ht,e),t(l,be,e),t(l,St,e),p(Ae,l,e),t(l,Ft,e),t(l,_e,e),t(l,Lt,e),p(Ze,l,e),t(l,Dt,e),t(l,ge,e),t(l,Ot,e),p(Be,l,e),t(l,Pt,e),t(l,Ge,e),t(l,Kt,e),p(ve,l,e),t(l,qt,e),t(l,Ne,e),la=!0},p:fM,i(l){la||(d(J.$$.fragment,l),d(A.$$.fragment,l),d(v.$$.fragment,l),d(R.$$.fragment,l),d(V.$$.fragment,l),d(x.$$.fragment,l),d(z.$$.fragment,l),d(H.$$.fragment,l),d(S.$$.fragment,l),d(L.$$.fragment,l),d(ll.$$.fragment,l),d(sl.$$.fragment,l),d(il.$$.fragment,l),d(yl.$$.fragment,l),d(pl.$$.fragment,l),d(cl.$$.fragment,l),d(Tl.$$.fragment,l),d(jl.$$.fragment,l),d(hl.$$.fragment,l),d(Cl.$$.fragment,l),d(Il.$$.fragment,l),d(bl.$$.fragment,l),d(gl.$$.fragment,l),d(vl.$$.fragment,l),d(kl.$$.fragment,l),d(Nl.$$.fragment,l),d(Xl.$$.fragment,l),d(Vl.$$.fragment,l),d(zl.$$.fragment,l),d(Ql.$$.fragment,l),d(Hl.$$.fragment,l),d(Fl.$$.fragment,l),d(Ll.$$.fragment,l),d(Ol.$$.fragment,l),d(Kl.$$.fragment,l),d(ee.$$.fragment,l),d(te.$$.fragment,l),d(Me.$$.fragment,l),d(ie.$$.fragment,l),d(ye.$$.fragment,l),d(pe.$$.fragment,l),d(Ue.$$.fragment,l),d(re.$$.fragment,l),d(Je.$$.fragment,l),d(he.$$.fragment,l),d(ue.$$.fragment,l),d(Ae.$$.fragment,l),d(Ze.$$.fragment,l),d(Be.$$.fragment,l),d(ve.$$.fragment,l),la=!0)},o(l){c(J.$$.fragment,l),c(A.$$.fragment,l),c(v.$$.fragment,l),c(R.$$.fragment,l),c(V.$$.fragment,l),c(x.$$.fragment,l),c(z.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(L.$$.fragment,l),c(ll.$$.fragment,l),c(sl.$$.fragment,l),c(il.$$.fragment,l),c(yl.$$.fragment,l),c(pl.$$.fragment,l),c(cl.$$.fragment,l),c(Tl.$$.fragment,l),c(jl.$$.fragment,l),c(hl.$$.fragment,l),c(Cl.$$.fragment,l),c(Il.$$.fragment,l),c(bl.$$.fragment,l),c(gl.$$.fragment,l),c(vl.$$.fragment,l),c(kl.$$.fragment,l),c(Nl.$$.fragment,l),c(Xl.$$.fragment,l),c(Vl.$$.fragment,l),c(zl.$$.fragment,l),c(Ql.$$.fragment,l),c(Hl.$$.fragment,l),c(Fl.$$.fragment,l),c(Ll.$$.fragment,l),c(Ol.$$.fragment,l),c(Kl.$$.fragment,l),c(ee.$$.fragment,l),c(te.$$.fragment,l),c(Me.$$.fragment,l),c(ie.$$.fragment,l),c(ye.$$.fragment,l),c(pe.$$.fragment,l),c(Ue.$$.fragment,l),c(re.$$.fragment,l),c(Je.$$.fragment,l),c(he.$$.fragment,l),c(ue.$$.fragment,l),c(Ae.$$.fragment,l),c(Ze.$$.fragment,l),c(Be.$$.fragment,l),c(ve.$$.fragment,l),la=!1},d(l){l&&(s(We),s(Re),s(Xe),s(Ee),s(m),s(Ve),s(h),s($e),s(C),s(xe),s(u),s(ze),s(I),s(Ye),s(f),s(Qe),s(b),s(He),s(Se),s(_),s(Fe),s(Z),s(Le),s(g),s(De),s(B),s(Oe),s(G),s(Pe),s(Ke),s(k),s(qe),s(ls),s(N),s(es),s(W),s(ss),s(X),s(ts),s(E),s(as),s(Ms),s($),s(ns),s(is),s(os),s(Y),s(ys),s(Q),s(ws),s(ps),s(ds),s(F),s(cs),s(Us),s(D),s(Ts),s(O),s(rs),s(P),s(js),s(K),s(Js),s(q),s(ms),s(hs),s(el),s(Cs),s(us),s(tl),s(Is),s(al),s(fs),s(Ml),s(bs),s(nl),s(As),s(_s),s(ol),s(Zs),s(gs),s(wl),s(Bs),s(Gs),s(dl),s(vs),s(ks),s(Ul),s(Rs),s(Ns),s(rl),s(Ws),s(Xs),s(Jl),s(Es),s(ml),s(Vs),s($s),s(xs),s(ul),s(zs),s(Ys),s(fl),s(Qs),s(Hs),s(Al),s(Ss),s(ke),s(Fs),s(_l),s(Ls),s(Zl),s(Ds),s(Os),s(Bl),s(Ps),s(Gl),s(Ks),s(qs),s(lt),s(Rl),s(et),s(st),s(Wl),s(tt),s(at),s(El),s(Mt),s(nt),s($l),s(it),s(xl),s(ot),s(yt),s(Yl),s(wt),s(pt),s(dt),s(Sl),s(ct),s(Ut),s(Tt),s(Dl),s(rt),s(jt),s(Pl),s(Jt),s(mt),s(ql),s(ht),s(le),s(Ct),s(ut),s(se),s(It),s(ft),s(ae),s(bt),s(At),s(ne),s(_t),s(Zt),s(oe),s(gt),s(Bt),s(we),s(Gt),s(vt),s(de),s(kt),s(ce),s(Rt),s(Nt),s(Te),s(Wt),s(Xt),s(je),s(Et),s(Vt),s(me),s($t),s(xt),s(Ce),s(zt),s(Yt),s(Ie),s(Qt),s(fe),s(Ht),s(be),s(St),s(Ft),s(_e),s(Lt),s(Dt),s(ge),s(Ot),s(Pt),s(Ge),s(Kt),s(qt),s(Ne)),s(j),U(J,l),U(A,l),U(v,l),U(R,l),U(V,l),U(x,l),U(z,l),U(H,l),U(S,l),U(L,l),U(ll,l),U(sl,l),U(il,l),U(yl,l),U(pl,l),U(cl,l),U(Tl,l),U(jl,l),U(hl,l),U(Cl,l),U(Il,l),U(bl,l),U(gl,l),U(vl,l),U(kl,l),U(Nl,l),U(Xl,l),U(Vl,l),U(zl,l),U(Ql,l),U(Hl,l),U(Fl,l),U(Ll,l),U(Ol,l),U(Kl,l),U(ee,l),U(te,l),U(Me,l),U(ie,l),U(ye,l),U(pe,l),U(Ue,l),U(re,l),U(Je,l),U(he,l),U(ue,l),U(Ae,l),U(Ze,l),U(Be,l),U(ve,l)}}}const RM='{"title":"Modular transformers","local":"modular-transformers","sections":[{"title":"What is it?","local":"what-is-it","sections":[{"title":"Details","local":"details","sections":[],"depth":3},{"title":"Enforcement","local":"enforcement","sections":[],"depth":3},{"title":"Examples","local":"examples","sections":[],"depth":3}],"depth":2},{"title":"What it is not","local":"what-it-is-not","sections":[],"depth":2},{"title":"Real world example breakdown","local":"real-world-example-breakdown","sections":[{"title":"Config class","local":"config-class","sections":[],"depth":3},{"title":"Norm class","local":"norm-class","sections":[],"depth":3},{"title":"Attention class","local":"attention-class","sections":[],"depth":3},{"title":"The DecoderLayer class","local":"the-decoderlayer-class","sections":[],"depth":3},{"title":"The Model class","local":"the-model-class","sections":[],"depth":3},{"title":"Finally… The ForCausalLM class","local":"finally-the-forcausallm-class","sections":[],"depth":3}],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Removing attributes which are not just assignments","local":"removing-attributes-which-are-not-just-assignments","sections":[],"depth":3},{"title":"Avoiding super() special meaning","local":"avoiding-super-special-meaning","sections":[],"depth":3},{"title":"Deleting unused methods","local":"deleting-unused-methods","sections":[],"depth":3},{"title":"Define new functions","local":"define-new-functions","sections":[],"depth":3},{"title":"Decorators","local":"decorators","sections":[],"depth":3},{"title":"The super_kwargs special case","local":"the-superkwargs-special-case","sections":[],"depth":3},{"title":"The DOCSTRING variables","local":"the-docstring-variables","sections":[],"depth":3}],"depth":2},{"title":"Limitations","local":"limitations","sections":[{"title":"Special naming (essentially for multimodal models)","local":"special-naming-essentially-for-multimodal-models","sections":[],"depth":3},{"title":"Automatic docstrings issue (mostly for Configs)","local":"automatic-docstrings-issue-mostly-for-configs","sections":[],"depth":3}],"depth":2}],"depth":1}';function NM(ta){return bM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $M extends AM{constructor(j){super(),_M(this,j,NM,kM,IM,{})}}export{$M as component};
