import{s as ol,f as il,o as rl,n as z}from"../chunks/scheduler.25b97de1.js";import{S as Ml,i as pl,g as u,s as M,r as J,A as cl,h,f as s,c as p,j as It,u as U,x as T,k as Xe,y as yl,a as n,v as f,d as w,t as j,w as b}from"../chunks/index.d9030fc9.js";import{T as H}from"../chunks/Tip.baa67368.js";import{C as V}from"../chunks/CodeBlock.e6cd0d95.js";import{H as E,E as dl}from"../chunks/EditOnGithub.91d95064.js";import{H as Gt,a as _e}from"../chunks/HfOption.1e589c90.js";function ml(Z){let t,c='Hugging Face also provides <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a library dedicated to deploying and serving highly optimized LLMs for inference. It includes deployment-oriented optimization features not included in Transformers, such as continuous batching for increasing throughput and tensor parallelism for multi-GPU inference.';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-utq275"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function ul(Z){let t,c='Currently, only <a href="./model_doc/llama2">Llama</a> and a few other models support static kv-cache and <code>torch.compile</code>. Check <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">this issue</a> for a live model compatibility list.';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1cpz1yf"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function hl(Z){let t,c='Regardless of the strategy used with <code>torch.compile</code>, you can avoid shape-related recompilations if you left-pad your LLM inputs to a limited set of values. The <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a> is your friend!';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1m3bnto"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Tl(Z){let t,c='For a more advanced usage of the static cache, such as multi-turn conversations, we recommend instantiating and manipulating the cache object outside <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. See the advanced usage tab.';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1asjxtp"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Jl(Z){let t,c='For this example, let’s use the <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> model. All we need to do is to:',l,o,i="<li>Access the model’s <code>generation_config</code> attribute and set the <code>cache_implementation</code> to “static”;</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li>",r,d,I="And that’s it!",C,G,v,g,k="Under the hood, <code>generate</code> will attempt to reuse the same cache object, removing the need for re-compilation at each call. Avoiding re-compilation is critical to get the most out of <code>torch.compile</code>, and you should be aware of the following:",F,R,X="<li>If the batch size changes or the maximum output length increases between calls, the cache will have to be reinitialized, triggering a new compilation;</li> <li>The first couple of calls of the compiled function are slower, as the function is being compiled.</li>",$,_,W;return G=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZS50eXBlKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAxLiUyMFRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQlMjBpbiUyMGFsbCUyMGluZXJ0aWFsJTIwcmVmZXJlbmNlJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),_=new H({props:{warning:!0,$$slots:{default:[Tl]},$$scope:{ctx:Z}}}),{c(){t=u("p"),t.innerHTML=c,l=M(),o=u("ol"),o.innerHTML=i,r=M(),d=u("p"),d.textContent=I,C=M(),J(G.$$.fragment),v=M(),g=u("p"),g.innerHTML=k,F=M(),R=u("ol"),R.innerHTML=X,$=M(),J(_.$$.fragment)},l(m){t=h(m,"P",{"data-svelte-h":!0}),T(t)!=="svelte-oys3sj"&&(t.innerHTML=c),l=p(m),o=h(m,"OL",{"data-svelte-h":!0}),T(o)!=="svelte-1fw1ivc"&&(o.innerHTML=i),r=p(m),d=h(m,"P",{"data-svelte-h":!0}),T(d)!=="svelte-9wooxy"&&(d.textContent=I),C=p(m),U(G.$$.fragment,m),v=p(m),g=h(m,"P",{"data-svelte-h":!0}),T(g)!=="svelte-yth3sl"&&(g.innerHTML=k),F=p(m),R=h(m,"OL",{"data-svelte-h":!0}),T(R)!=="svelte-u5kopl"&&(R.innerHTML=X),$=p(m),U(_.$$.fragment,m)},m(m,y){n(m,t,y),n(m,l,y),n(m,o,y),n(m,r,y),n(m,d,y),n(m,C,y),f(G,m,y),n(m,v,y),n(m,g,y),n(m,F,y),n(m,R,y),n(m,$,y),f(_,m,y),W=!0},p(m,y){const B={};y&2&&(B.$$scope={dirty:y,ctx:m}),_.$set(B)},i(m){W||(w(G.$$.fragment,m),w(_.$$.fragment,m),W=!0)},o(m){j(G.$$.fragment,m),j(_.$$.fragment,m),W=!1},d(m){m&&(s(t),s(l),s(o),s(r),s(d),s(C),s(v),s(g),s(F),s(R),s($)),b(G,m),b(_,m)}}}function Ul(Z){let t,c='If you want to reuse the same <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object on a new prompt, be sure to reset its contents with the <code>.reset()</code> method between calls';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1yzi617"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function fl(Z){let t,c='A <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can be passed to the model’s <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> under the <code>past_key_values</code> argument. The object will retain the cache contents, so you can pass it to a new <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> call to continue generation, like you would do with a dynamic cache.',l,o,i,r,d,I,C='If you want to go further down a level, the <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can also be passed to the model’s forward pass under the same <code>past_key_values</code> argument. Using this strategy, you can write your own function to decode the next token given the current token and position and cache position of previously generated tokens.',G,v,g,k,F="There are a few important things you must do to enable static kv-cache and <code>torch.compile</code> with the <code>StaticCache</code> method:",R,X,$='<li>Initialize the <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> instance before using the model for inference. There you can configure parameters like the maximum batch size and sequence length.</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li> <li>Use <code>SDPBackend.MATH</code> in the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</li>',_,W,m;return o=new V({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># If you plan to reuse the cache, make sure the cache length is large enough for all cases</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># pass in the generated text and the same cache object to continue generation from where it left off. Optionally, in a</span>
<span class="hljs-comment"># multi-turn conversation, append the new user input to the generated text.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),r=new H({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:Z}}}),v=new V({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),W=new V({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel

batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.MATH):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=c,l=M(),J(o.$$.fragment),i=M(),J(r.$$.fragment),d=M(),I=u("p"),I.innerHTML=C,G=M(),J(v.$$.fragment),g=M(),k=u("p"),k.innerHTML=F,R=M(),X=u("ol"),X.innerHTML=$,_=M(),J(W.$$.fragment)},l(y){t=h(y,"P",{"data-svelte-h":!0}),T(t)!=="svelte-ghxzbz"&&(t.innerHTML=c),l=p(y),U(o.$$.fragment,y),i=p(y),U(r.$$.fragment,y),d=p(y),I=h(y,"P",{"data-svelte-h":!0}),T(I)!=="svelte-ak6c2t"&&(I.innerHTML=C),G=p(y),U(v.$$.fragment,y),g=p(y),k=h(y,"P",{"data-svelte-h":!0}),T(k)!=="svelte-1haj213"&&(k.innerHTML=F),R=p(y),X=h(y,"OL",{"data-svelte-h":!0}),T(X)!=="svelte-1gbv8rz"&&(X.innerHTML=$),_=p(y),U(W.$$.fragment,y)},m(y,B){n(y,t,B),n(y,l,B),f(o,y,B),n(y,i,B),f(r,y,B),n(y,d,B),n(y,I,B),n(y,G,B),f(v,y,B),n(y,g,B),n(y,k,B),n(y,R,B),n(y,X,B),n(y,_,B),f(W,y,B),m=!0},p(y,B){const Y={};B&2&&(Y.$$scope={dirty:B,ctx:y}),r.$set(Y)},i(y){m||(w(o.$$.fragment,y),w(r.$$.fragment,y),w(v.$$.fragment,y),w(W.$$.fragment,y),m=!0)},o(y){j(o.$$.fragment,y),j(r.$$.fragment,y),j(v.$$.fragment,y),j(W.$$.fragment,y),m=!1},d(y){y&&(s(t),s(l),s(i),s(d),s(I),s(G),s(g),s(k),s(R),s(X),s(_)),b(o,y),b(r,y),b(v,y),b(W,y)}}}function wl(Z){let t,c="Compiling the entire <code>generate</code> function, in terms of code, is even simpler than in the basic usage: call <code>torch.compile</code> on <code>generate</code> to compile the entire function. No need to specify the use of the static cache: although it is compatible, dynamic cache (default) was faster in our benchmarks.",l,o,i,r,d="As a result, we compile not only the model forward pass, but also all input preparation, logit processor operations, and so on. The result should be a slightly <code>generate</code> call, compared to the basic usage example, and the compiled graph may be better suited to more exotic hardware devices or use cases. However, there are severe drawbacks in using this approach:",I,C,G="<li>Compilation is much slower;</li> <li>All parameterization of <code>generate</code> must be done through <code>generation_config</code>;</li> <li>Many warnings and exceptions are suppressed — we suggest testing with its uncompiled form first;</li> <li>Although we are working on it, it is heavily feature restricted (for instance, at the time of writing, generation does not stop if an EOS token is selected).</li>",v;return o=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZS50eXBlKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAxLiUyMFRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQlMjBpbiUyMGFsbCUyMGluZXJ0aWFsJTIwcmVmZXJlbmNlJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=c,l=M(),J(o.$$.fragment),i=M(),r=u("p"),r.innerHTML=d,I=M(),C=u("ol"),C.innerHTML=G},l(g){t=h(g,"P",{"data-svelte-h":!0}),T(t)!=="svelte-5smhof"&&(t.innerHTML=c),l=p(g),U(o.$$.fragment,g),i=p(g),r=h(g,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1sxxqo6"&&(r.innerHTML=d),I=p(g),C=h(g,"OL",{"data-svelte-h":!0}),T(C)!=="svelte-tj5w3v"&&(C.innerHTML=G)},m(g,k){n(g,t,k),n(g,l,k),f(o,g,k),n(g,i,k),n(g,r,k),n(g,I,k),n(g,C,k),v=!0},p:z,i(g){v||(w(o.$$.fragment,g),v=!0)},o(g){j(o.$$.fragment,g),v=!1},d(g){g&&(s(t),s(l),s(i),s(r),s(I),s(C)),b(o,g)}}}function jl(Z){let t,c,l,o,i,r;return t=new _e({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[Jl]},$$scope:{ctx:Z}}}),l=new _e({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[fl]},$$scope:{ctx:Z}}}),i=new _e({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[wl]},$$scope:{ctx:Z}}}),{c(){J(t.$$.fragment),c=M(),J(l.$$.fragment),o=M(),J(i.$$.fragment)},l(d){U(t.$$.fragment,d),c=p(d),U(l.$$.fragment,d),o=p(d),U(i.$$.fragment,d)},m(d,I){f(t,d,I),n(d,c,I),f(l,d,I),n(d,o,I),f(i,d,I),r=!0},p(d,I){const C={};I&2&&(C.$$scope={dirty:I,ctx:d}),t.$set(C);const G={};I&2&&(G.$$scope={dirty:I,ctx:d}),l.$set(G);const v={};I&2&&(v.$$scope={dirty:I,ctx:d}),i.$set(v)},i(d){r||(w(t.$$.fragment,d),w(l.$$.fragment,d),w(i.$$.fragment,d),r=!0)},o(d){j(t.$$.fragment,d),j(l.$$.fragment,d),j(i.$$.fragment,d),r=!1},d(d){d&&(s(c),s(o)),b(t,d),b(l,d),b(i,d)}}}function bl(Z){let t,c='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-112w74b"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Zl(Z){let t,c="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it also doesn’t support batched inputs.";return{c(){t=u("p"),t.textContent=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-eq929k"&&(t.textContent=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function gl(Z){let t,c;return t=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSU1QiUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwdGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudC4lMjAlMjAlMjAlMjAlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){U(t.$$.fragment,l)},m(l,o){f(t,l,o),c=!0},p:z,i(l){c||(w(t.$$.fragment,l),c=!0)},o(l){j(t.$$.fragment,l),c=!1},d(l){b(t,l)}}}function Il(Z){let t,c='For speculative sampling decoding, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method in addition to the assistant model.',l,o,i;return o=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMG1vdGlvbiUyMGluJTIwdGhlJTIwdW5pdmVyc2UlMjBpcyUyMG5vdCUyMGElMjBzdHJhaWdodCUyMGxpbmUuJTVDbiUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=c,l=M(),J(o.$$.fragment)},l(r){t=h(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fgqnix"&&(t.innerHTML=c),l=p(r),U(o.$$.fragment,r)},m(r,d){n(r,t,d),n(r,l,d),f(o,r,d),i=!0},p:z,i(r){i||(w(o.$$.fragment,r),i=!0)},o(r){j(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),b(o,r)}}}function Gl(Z){let t,c,l,o;return t=new _e({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[gl]},$$scope:{ctx:Z}}}),l=new _e({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[Il]},$$scope:{ctx:Z}}}),{c(){J(t.$$.fragment),c=M(),J(l.$$.fragment)},l(i){U(t.$$.fragment,i),c=p(i),U(l.$$.fragment,i)},m(i,r){f(t,i,r),n(i,c,r),f(l,i,r),o=!0},p(i,r){const d={};r&2&&(d.$$scope={dirty:r,ctx:i}),t.$set(d);const I={};r&2&&(I.$$scope={dirty:r,ctx:i}),l.$set(I)},i(i){o||(w(t.$$.fragment,i),w(l.$$.fragment,i),o=!0)},o(i){j(t.$$.fragment,i),j(l.$$.fragment,i),o=!1},d(i){i&&s(c),b(t,i),b(l,i)}}}function kl(Z){let t,c;return t=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcHJvbXB0X2xvb2t1cF9udW1fdG9rZW5zJTNEMyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjB0aGF0JTIwZW50cm9weSUyMGluY3JlYXNlcyUyMHdpdGglMjB0ZW1wZXJhdHVyZS4lMjAlMjAlMjAlMjAlMjAlMjAnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){U(t.$$.fragment,l)},m(l,o){f(t,l,o),c=!0},p:z,i(l){c||(w(t.$$.fragment,l),c=!0)},o(l){j(t.$$.fragment,l),c=!1},d(l){b(t,l)}}}function Bl(Z){let t,c='For prompt lookup decoding with sampling, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',l,o,i;return o=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QiUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjB0aGF0JTIwZW5lcmd5JTIwY2Fubm90JTIwYmUlMjBjcmVhdGVkJTIwbm9yJTIwZGVzdHJveWVkLiUyMEl0J3MlMjBub3QlMjBhJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=c,l=M(),J(o.$$.fragment)},l(r){t=h(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1urkrym"&&(t.innerHTML=c),l=p(r),U(o.$$.fragment,r)},m(r,d){n(r,t,d),n(r,l,d),f(o,r,d),i=!0},p:z,i(r){i||(w(o.$$.fragment,r),i=!0)},o(r){j(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),b(o,r)}}}function Cl(Z){let t,c,l,o;return t=new _e({props:{id:"pld",option:"greedy decoding",$$slots:{default:[kl]},$$scope:{ctx:Z}}}),l=new _e({props:{id:"pld",option:"sampling",$$slots:{default:[Bl]},$$scope:{ctx:Z}}}),{c(){J(t.$$.fragment),c=M(),J(l.$$.fragment)},l(i){U(t.$$.fragment,i),c=p(i),U(l.$$.fragment,i)},m(i,r){f(t,i,r),n(i,c,r),f(l,i,r),o=!0},p(i,r){const d={};r&2&&(d.$$scope={dirty:r,ctx:i}),t.$set(d);const I={};r&2&&(I.$$scope={dirty:r,ctx:i}),l.$set(I)},i(i){o||(w(t.$$.fragment,i),w(l.$$.fragment,i),o=!0)},o(i){j(t.$$.fragment,i),j(l.$$.fragment,i),o=!1},d(i){i&&s(c),b(t,i),b(l,i)}}}function vl(Z){let t,c="SDPA supports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=u("p"),t.textContent=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-12yxz1f"&&(t.textContent=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function _l(Z){let t,c='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, VPTQ, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=u("p"),t.innerHTML=c},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-p1oqjt"&&(t.innerHTML=c)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Xl(Z){let t,c,l,o,i,r,d,I="Large language models (LLMs) have pushed text generation applications, such as chat and code completion models, to the next level by producing text that displays a high level of understanding and fluency. But what makes LLMs so powerful - namely their size - also presents challenges for inference.",C,G,v="Basic inference is slow because LLMs have to be called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer for the LLM to process. LLMs also have billions of parameters, making it a challenge to store and handle all those weights in memory.",g,k,F="This guide will show you how to use the optimization techniques available in Transformers to accelerate LLM inference.",R,X,$,_,W,m,y="During decoding, a LLM computes the key-value (kv) values for each input token and since it is autoregressive, it computes the same kv values each time because the generated output becomes part of the input now. This is not very efficient because you’re recomputing the same kv values each time.",B,Y,kt='To optimize this, you can use a kv-cache to store the past keys and values instead of recomputing them each time. However, since the kv-cache grows with each generation step and is dynamic, it prevents you from taking advantage of <a href="./perf_torch_compile"><code>torch.compile</code></a>, a powerful optimization tool that fuses PyTorch code into fast and optimized kernels. We have an entire guide dedicated to kv-caches <a href="./kv_cache">here</a>.',We,O,Bt="The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value which allows you to combine it with <code>torch.compile</code> for up to a 4x speed up. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware.",Ve,Q,ze,ee,Ct="There are three flavors of static kv-cache usage, depending on the complexity of your task:",$e,te,vt="<li>Basic usage: simply set a flag in <code>generation_config</code> (recommended);</li> <li>Advanced usage: handle a cache object for multi-turn generation or a custom generation loop;</li> <li>Advanced usage: compile the entire <code>generate</code> function into a single graph, if having a single graph is relevant for you.</li>",Fe,le,_t="Select the correct tab below for further instructions on each of these flavors.",Ye,S,Ne,x,Ee,se,He,A,Qe,ae,Xt="Another issue with autoregression is that for each input token you need to load the model weights each time during the forward pass. This is slow and cumbersome for LLMs which have billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger LLM in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",Se,ne,Rt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",xe,L,Ae,oe,Wt='Enable speculative decoding by loading an assistant model and passing it to the <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',Le,q,qe,ie,De,re,Vt="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",Pe,Me,zt='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <code>prompt_lookup_num_tokens</code> parameter. Then you can pass this parameter to the <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',Ke,D,Oe,pe,et,ce,$t="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations and can accelerate inference.",tt,ye,lt,de,Ft='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',st,me,Yt='To use FlashAttention-2, set <code>attn_implementation=&quot;flash_attention_2&quot;</code> in the <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method.',at,ue,nt,he,ot,Te,Nt="In addition to optimizing inference, you can also enhance the training efficiency of large language models by leveraging torch.compile during fine-tuning and using a padding-free data collator. This approach can significantly speed up training and reduce computational overhead.",it,Je,Et="Here’s how you can fine-tune a Llama model using SFTTrainer from the TRL library, with torch_compile enabled and a padding-free data collator:",rt,Ue,Mt,fe,pt,we,Ht="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",ct,P,yt,je,Qt='Use the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to explicitly enable or disable any of the four attention algorithms. For example, use <code>SDPBackend.FLASH_ATTENTION</code> to enable FlashAttention.',dt,be,mt,Ze,ut,ge,St="Quantization reduces the size of the LLM weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by your GPUs memory. If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can incur a small latency cost (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",ht,K,Tt,Ie,xt='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating how much memory it costs to load <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',Jt,N,At,Ut,Ge,Lt='To load Mistral-7B-v0.1 in half-precision, set the <code>torch_dtype</code> parameter in the <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',ft,ke,wt,Be,qt='To load a quantized model (8-bit or 4-bit) for inference, try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <code>load_in_4bit</code> or <code>load_in_8bit</code> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',jt,Ce,bt,ve,Zt,Re,gt;return i=new E({props:{title:"LLM inference optimization",local:"llm-inference-optimization",headingTag:"h1"}}),X=new H({props:{warning:!1,$$slots:{default:[ml]},$$scope:{ctx:Z}}}),_=new E({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),Q=new H({props:{warning:!0,$$slots:{default:[ul]},$$scope:{ctx:Z}}}),S=new H({props:{warning:!1,$$slots:{default:[hl]},$$scope:{ctx:Z}}}),x=new Gt({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[jl]},$$scope:{ctx:Z}}}),se=new E({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h2"}}),A=new H({props:{warning:!1,$$slots:{default:[bl]},$$scope:{ctx:Z}}}),L=new H({props:{warning:!0,$$slots:{default:[Zl]},$$scope:{ctx:Z}}}),q=new Gt({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[Gl]},$$scope:{ctx:Z}}}),ie=new E({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),D=new Gt({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[Cl]},$$scope:{ctx:Z}}}),pe=new E({props:{title:"Attention optimizations",local:"attention-optimizations",headingTag:"h2"}}),ye=new E({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),ue=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),he=new E({props:{title:"Fine-Tuning with torch.compile and Padding-Free Data Collation",local:"fine-tuning-with-torchcompile-and-padding-free-data-collation",headingTag:"h3"}}),Ue=new V({props:{code:"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",highlighted:`#################### IMPORTS ###################

<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">import</span> dataclasses
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoTokenizer,
    TrainingArguments
)
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

#################### MODEL LOADING WITH FLASH ATTENTION ###################

model_name = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>  # Enables FlashAttention<span class="hljs-number">-2</span>
)
tokenizer = AutoTokenizer.from_pretrained(model_name, use_fast=<span class="hljs-literal">True</span>)

#################### DATA PREPROCESSING (PADDING-FREE) ###################

response_template = <span class="hljs-string">&quot;\\n### Label:&quot;</span>
response_template_ids = tokenizer.encode(
    response_template, add_special_tokens=<span class="hljs-literal">False</span>
)[<span class="hljs-number">2</span>:]  # Exclude <span class="hljs-keyword">special</span> tokens

data_collator = DataCollatorForCompletionOnlyLM(
    response_template_ids=response_template_ids,
    tokenizer=tokenizer,
    ignore_index=<span class="hljs-number">-100</span>,
    padding_free=<span class="hljs-literal">True</span>  # Enables padding-free collation
)

def format_dataset(example):
    return {
        <span class="hljs-string">&quot;output&quot;</span>: example[<span class="hljs-string">&quot;output&quot;</span>] + tokenizer.eos_token
    }

data_files = {<span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;path/to/dataset&quot;</span>}  # Replace <span class="hljs-keyword">with</span> your dataset path
json_dataset = datasets.load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files)
formatted_train_dataset = json_dataset[<span class="hljs-string">&quot;train&quot;</span>].map(format_dataset)

################# TRAINING CONFIGURATION ############################

train_args = TrainingArguments(
    num_train_epochs=<span class="hljs-number">5</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    weight_decay=<span class="hljs-number">0.0</span>,
    warmup_ratio=<span class="hljs-number">0.03</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
    logging_steps=<span class="hljs-number">1</span>,
    include_tokens_per_second=<span class="hljs-literal">True</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    torch_compile=<span class="hljs-literal">True</span>,  # Enables torch.compile
    torch_compile_backend=<span class="hljs-string">&quot;inductor&quot;</span>,
    torch_compile_mode=<span class="hljs-string">&quot;default&quot;</span>
)

# Convert TrainingArguments to SFTConfig
transformer_train_arg_fields = [x.name for x <span class="hljs-keyword">in</span> dataclasses.fields(SFTConfig)]
transformer_kwargs = {
    k: v
    for k, v <span class="hljs-keyword">in</span> train_args.to_dict().items()
    <span class="hljs-keyword">if</span> k <span class="hljs-keyword">in</span> transformer_train_arg_fields
}
training_args = SFTConfig(**transformer_kwargs)

####################### FINE-TUNING #####################

trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    train_dataset=formatted_train_dataset,
    data_collator=data_collator,
    dataset_text_field=<span class="hljs-string">&quot;output&quot;</span>,
    args=training_args,
)
trainer.train()`,wrap:!1}}),fe=new E({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),P=new H({props:{warning:!1,$$slots:{default:[vl]},$$scope:{ctx:Z}}}),be=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gubm4uYXR0ZW50aW9uJTIwaW1wb3J0JTIwU0RQQmFja2VuZCUyQyUyMHNkcGFfa2VybmVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQXdpdGglMjBzZHBhX2tlcm5lbChTRFBCYWNrZW5kLkZMQVNIX0FUVEVOVElPTiklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.FLASH_ATTENTION):
    outputs = model.generate(**inputs)`,wrap:!1}}),Ze=new E({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),K=new H({props:{warning:!1,$$slots:{default:[_l]},$$scope:{ctx:Z}}}),ke=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),Ce=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ve=new dl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=u("meta"),c=M(),l=u("p"),o=M(),J(i.$$.fragment),r=M(),d=u("p"),d.textContent=I,C=M(),G=u("p"),G.textContent=v,g=M(),k=u("p"),k.textContent=F,R=M(),J(X.$$.fragment),$=M(),J(_.$$.fragment),W=M(),m=u("p"),m.textContent=y,B=M(),Y=u("p"),Y.innerHTML=kt,We=M(),O=u("p"),O.innerHTML=Bt,Ve=M(),J(Q.$$.fragment),ze=M(),ee=u("p"),ee.textContent=Ct,$e=M(),te=u("ol"),te.innerHTML=vt,Fe=M(),le=u("p"),le.textContent=_t,Ye=M(),J(S.$$.fragment),Ne=M(),J(x.$$.fragment),Ee=M(),J(se.$$.fragment),He=M(),J(A.$$.fragment),Qe=M(),ae=u("p"),ae.textContent=Xt,Se=M(),ne=u("p"),ne.textContent=Rt,xe=M(),J(L.$$.fragment),Ae=M(),oe=u("p"),oe.innerHTML=Wt,Le=M(),J(q.$$.fragment),qe=M(),J(ie.$$.fragment),De=M(),re=u("p"),re.textContent=Vt,Pe=M(),Me=u("p"),Me.innerHTML=zt,Ke=M(),J(D.$$.fragment),Oe=M(),J(pe.$$.fragment),et=M(),ce=u("p"),ce.textContent=$t,tt=M(),J(ye.$$.fragment),lt=M(),de=u("p"),de.innerHTML=Ft,st=M(),me=u("p"),me.innerHTML=Yt,at=M(),J(ue.$$.fragment),nt=M(),J(he.$$.fragment),ot=M(),Te=u("p"),Te.textContent=Nt,it=M(),Je=u("p"),Je.textContent=Et,rt=M(),J(Ue.$$.fragment),Mt=M(),J(fe.$$.fragment),pt=M(),we=u("p"),we.textContent=Ht,ct=M(),J(P.$$.fragment),yt=M(),je=u("p"),je.innerHTML=Qt,dt=M(),J(be.$$.fragment),mt=M(),J(Ze.$$.fragment),ut=M(),ge=u("p"),ge.textContent=St,ht=M(),J(K.$$.fragment),Tt=M(),Ie=u("p"),Ie.innerHTML=xt,Jt=M(),N=u("iframe"),Ut=M(),Ge=u("p"),Ge.innerHTML=Lt,ft=M(),J(ke.$$.fragment),wt=M(),Be=u("p"),Be.innerHTML=qt,jt=M(),J(Ce.$$.fragment),bt=M(),J(ve.$$.fragment),Zt=M(),Re=u("p"),this.h()},l(e){const a=cl("svelte-u9bgzb",document.head);t=h(a,"META",{name:!0,content:!0}),a.forEach(s),c=p(e),l=h(e,"P",{}),It(l).forEach(s),o=p(e),U(i.$$.fragment,e),r=p(e),d=h(e,"P",{"data-svelte-h":!0}),T(d)!=="svelte-1kjw8nj"&&(d.textContent=I),C=p(e),G=h(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1l3iyos"&&(G.textContent=v),g=p(e),k=h(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-1wb7yan"&&(k.textContent=F),R=p(e),U(X.$$.fragment,e),$=p(e),U(_.$$.fragment,e),W=p(e),m=h(e,"P",{"data-svelte-h":!0}),T(m)!=="svelte-bq37ce"&&(m.textContent=y),B=p(e),Y=h(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-w4nvh4"&&(Y.innerHTML=kt),We=p(e),O=h(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-jt9td8"&&(O.innerHTML=Bt),Ve=p(e),U(Q.$$.fragment,e),ze=p(e),ee=h(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-1439wi2"&&(ee.textContent=Ct),$e=p(e),te=h(e,"OL",{"data-svelte-h":!0}),T(te)!=="svelte-165n3j5"&&(te.innerHTML=vt),Fe=p(e),le=h(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-etip6m"&&(le.textContent=_t),Ye=p(e),U(S.$$.fragment,e),Ne=p(e),U(x.$$.fragment,e),Ee=p(e),U(se.$$.fragment,e),He=p(e),U(A.$$.fragment,e),Qe=p(e),ae=h(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-18z9bzk"&&(ae.textContent=Xt),Se=p(e),ne=h(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-1nm1j4o"&&(ne.textContent=Rt),xe=p(e),U(L.$$.fragment,e),Ae=p(e),oe=h(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-mlman7"&&(oe.innerHTML=Wt),Le=p(e),U(q.$$.fragment,e),qe=p(e),U(ie.$$.fragment,e),De=p(e),re=h(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-123yl06"&&(re.textContent=Vt),Pe=p(e),Me=h(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-1xj5v2o"&&(Me.innerHTML=zt),Ke=p(e),U(D.$$.fragment,e),Oe=p(e),U(pe.$$.fragment,e),et=p(e),ce=h(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-zxt0p7"&&(ce.textContent=$t),tt=p(e),U(ye.$$.fragment,e),lt=p(e),de=h(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-pa091d"&&(de.innerHTML=Ft),st=p(e),me=h(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1vyvbca"&&(me.innerHTML=Yt),at=p(e),U(ue.$$.fragment,e),nt=p(e),U(he.$$.fragment,e),ot=p(e),Te=h(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-avgiyv"&&(Te.textContent=Nt),it=p(e),Je=h(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-1wz30yc"&&(Je.textContent=Et),rt=p(e),U(Ue.$$.fragment,e),Mt=p(e),U(fe.$$.fragment,e),pt=p(e),we=h(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-16n93px"&&(we.textContent=Ht),ct=p(e),U(P.$$.fragment,e),yt=p(e),je=h(e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-xcpcjc"&&(je.innerHTML=Qt),dt=p(e),U(be.$$.fragment,e),mt=p(e),U(Ze.$$.fragment,e),ut=p(e),ge=h(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-x4c749"&&(ge.textContent=St),ht=p(e),U(K.$$.fragment,e),Tt=p(e),Ie=h(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-1i2aaqz"&&(Ie.innerHTML=xt),Jt=p(e),N=h(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),It(N).forEach(s),Ut=p(e),Ge=h(e,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1egvcqt"&&(Ge.innerHTML=Lt),ft=p(e),U(ke.$$.fragment,e),wt=p(e),Be=h(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-a32zwr"&&(Be.innerHTML=qt),jt=p(e),U(Ce.$$.fragment,e),bt=p(e),U(ve.$$.fragment,e),Zt=p(e),Re=h(e,"P",{}),It(Re).forEach(s),this.h()},h(){Xe(t,"name","hf:doc:metadata"),Xe(t,"content",Rl),il(N.src,At="https://hf-accelerate-model-memory-usage.hf.space")||Xe(N,"src",At),Xe(N,"frameborder","0"),Xe(N,"width","850"),Xe(N,"height","450")},m(e,a){yl(document.head,t),n(e,c,a),n(e,l,a),n(e,o,a),f(i,e,a),n(e,r,a),n(e,d,a),n(e,C,a),n(e,G,a),n(e,g,a),n(e,k,a),n(e,R,a),f(X,e,a),n(e,$,a),f(_,e,a),n(e,W,a),n(e,m,a),n(e,B,a),n(e,Y,a),n(e,We,a),n(e,O,a),n(e,Ve,a),f(Q,e,a),n(e,ze,a),n(e,ee,a),n(e,$e,a),n(e,te,a),n(e,Fe,a),n(e,le,a),n(e,Ye,a),f(S,e,a),n(e,Ne,a),f(x,e,a),n(e,Ee,a),f(se,e,a),n(e,He,a),f(A,e,a),n(e,Qe,a),n(e,ae,a),n(e,Se,a),n(e,ne,a),n(e,xe,a),f(L,e,a),n(e,Ae,a),n(e,oe,a),n(e,Le,a),f(q,e,a),n(e,qe,a),f(ie,e,a),n(e,De,a),n(e,re,a),n(e,Pe,a),n(e,Me,a),n(e,Ke,a),f(D,e,a),n(e,Oe,a),f(pe,e,a),n(e,et,a),n(e,ce,a),n(e,tt,a),f(ye,e,a),n(e,lt,a),n(e,de,a),n(e,st,a),n(e,me,a),n(e,at,a),f(ue,e,a),n(e,nt,a),f(he,e,a),n(e,ot,a),n(e,Te,a),n(e,it,a),n(e,Je,a),n(e,rt,a),f(Ue,e,a),n(e,Mt,a),f(fe,e,a),n(e,pt,a),n(e,we,a),n(e,ct,a),f(P,e,a),n(e,yt,a),n(e,je,a),n(e,dt,a),f(be,e,a),n(e,mt,a),f(Ze,e,a),n(e,ut,a),n(e,ge,a),n(e,ht,a),f(K,e,a),n(e,Tt,a),n(e,Ie,a),n(e,Jt,a),n(e,N,a),n(e,Ut,a),n(e,Ge,a),n(e,ft,a),f(ke,e,a),n(e,wt,a),n(e,Be,a),n(e,jt,a),f(Ce,e,a),n(e,bt,a),f(ve,e,a),n(e,Zt,a),n(e,Re,a),gt=!0},p(e,[a]){const Dt={};a&2&&(Dt.$$scope={dirty:a,ctx:e}),X.$set(Dt);const Pt={};a&2&&(Pt.$$scope={dirty:a,ctx:e}),Q.$set(Pt);const Kt={};a&2&&(Kt.$$scope={dirty:a,ctx:e}),S.$set(Kt);const Ot={};a&2&&(Ot.$$scope={dirty:a,ctx:e}),x.$set(Ot);const el={};a&2&&(el.$$scope={dirty:a,ctx:e}),A.$set(el);const tl={};a&2&&(tl.$$scope={dirty:a,ctx:e}),L.$set(tl);const ll={};a&2&&(ll.$$scope={dirty:a,ctx:e}),q.$set(ll);const sl={};a&2&&(sl.$$scope={dirty:a,ctx:e}),D.$set(sl);const al={};a&2&&(al.$$scope={dirty:a,ctx:e}),P.$set(al);const nl={};a&2&&(nl.$$scope={dirty:a,ctx:e}),K.$set(nl)},i(e){gt||(w(i.$$.fragment,e),w(X.$$.fragment,e),w(_.$$.fragment,e),w(Q.$$.fragment,e),w(S.$$.fragment,e),w(x.$$.fragment,e),w(se.$$.fragment,e),w(A.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(ie.$$.fragment,e),w(D.$$.fragment,e),w(pe.$$.fragment,e),w(ye.$$.fragment,e),w(ue.$$.fragment,e),w(he.$$.fragment,e),w(Ue.$$.fragment,e),w(fe.$$.fragment,e),w(P.$$.fragment,e),w(be.$$.fragment,e),w(Ze.$$.fragment,e),w(K.$$.fragment,e),w(ke.$$.fragment,e),w(Ce.$$.fragment,e),w(ve.$$.fragment,e),gt=!0)},o(e){j(i.$$.fragment,e),j(X.$$.fragment,e),j(_.$$.fragment,e),j(Q.$$.fragment,e),j(S.$$.fragment,e),j(x.$$.fragment,e),j(se.$$.fragment,e),j(A.$$.fragment,e),j(L.$$.fragment,e),j(q.$$.fragment,e),j(ie.$$.fragment,e),j(D.$$.fragment,e),j(pe.$$.fragment,e),j(ye.$$.fragment,e),j(ue.$$.fragment,e),j(he.$$.fragment,e),j(Ue.$$.fragment,e),j(fe.$$.fragment,e),j(P.$$.fragment,e),j(be.$$.fragment,e),j(Ze.$$.fragment,e),j(K.$$.fragment,e),j(ke.$$.fragment,e),j(Ce.$$.fragment,e),j(ve.$$.fragment,e),gt=!1},d(e){e&&(s(c),s(l),s(o),s(r),s(d),s(C),s(G),s(g),s(k),s(R),s($),s(W),s(m),s(B),s(Y),s(We),s(O),s(Ve),s(ze),s(ee),s($e),s(te),s(Fe),s(le),s(Ye),s(Ne),s(Ee),s(He),s(Qe),s(ae),s(Se),s(ne),s(xe),s(Ae),s(oe),s(Le),s(qe),s(De),s(re),s(Pe),s(Me),s(Ke),s(Oe),s(et),s(ce),s(tt),s(lt),s(de),s(st),s(me),s(at),s(nt),s(ot),s(Te),s(it),s(Je),s(rt),s(Mt),s(pt),s(we),s(ct),s(yt),s(je),s(dt),s(mt),s(ut),s(ge),s(ht),s(Tt),s(Ie),s(Jt),s(N),s(Ut),s(Ge),s(ft),s(wt),s(Be),s(jt),s(bt),s(Zt),s(Re)),s(t),b(i,e),b(X,e),b(_,e),b(Q,e),b(S,e),b(x,e),b(se,e),b(A,e),b(L,e),b(q,e),b(ie,e),b(D,e),b(pe,e),b(ye,e),b(ue,e),b(he,e),b(Ue,e),b(fe,e),b(P,e),b(be,e),b(Ze,e),b(K,e),b(ke,e),b(Ce,e),b(ve,e)}}}const Rl='{"title":"LLM inference optimization","local":"llm-inference-optimization","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Speculative decoding","local":"speculative-decoding","sections":[{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention optimizations","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"Fine-Tuning with torch.compile and Padding-Free Data Collation","local":"fine-tuning-with-torchcompile-and-padding-free-data-collation","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Wl(Z){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Ml{constructor(t){super(),pl(this,t,Wl,Xl,ol,{})}}export{El as component};
