import{s as Ms,f as rs,o as us,n as yl}from"../chunks/scheduler.f6319a2a.js";import{S as cs,i as ds,g as a,s as o,r as M,A as ms,h as i,f as l,c as n,j as ps,u,x as r,k as dl,y as ys,a as s,v as c,d,t as m,w as y}from"../chunks/index.85aa684c.js";import{T as ml}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as hs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as g,E as bs}from"../chunks/index.c8a0819f.js";function ws(f){let p,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=U)},m(h,w){s(h,p,w)},p:yl,d(h){h&&l(p)}}}function Us(f){let p,U="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=U)},m(h,w){s(h,p,w)},p:yl,d(h){h&&l(p)}}}function Ts(f){let p,U="<strong>Security Warning:</strong> Using MCP servers comes with security risks:",h,w,j="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers</strong> while the remote MCP servers will not be able to execute code on your machine, still proceed with caution.</li>",C,J,W="Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.";return{c(){p=a("p"),p.innerHTML=U,h=o(),w=a("ul"),w.innerHTML=j,C=o(),J=a("p"),J.textContent=W},l(b){p=i(b,"P",{"data-svelte-h":!0}),r(p)!=="svelte-936g9o"&&(p.innerHTML=U),h=n(b),w=i(b,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-17a5h6o"&&(w.innerHTML=j),C=n(b),J=i(b,"P",{"data-svelte-h":!0}),r(J)!=="svelte-57pqg4"&&(J.textContent=W)},m(b,v){s(b,p,v),s(b,h,v),s(b,w,v),s(b,C,v),s(b,J,v)},p:yl,d(b){b&&(l(p),l(h),l(w),l(C),l(J))}}}function Js(f){let p,U="<strong>Security Warning:</strong> The same security warnings mentioned for <code>ToolCollection.from_mcp</code> apply when using <code>MCPClient</code> directly.";return{c(){p=a("p"),p.innerHTML=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dxey55"&&(p.innerHTML=U)},m(h,w){s(h,p,w)},p:yl,d(h){h&&l(p)}}}function fs(f){let p,U,h,w,j,C,J,W,b,v="Here, we’re going to see advanced tool usage.",ze,I,Fe,_,hl='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',Pe,G,Le,Q,bl="A tool is mostly a function that an LLM can use in an agentic system.",De,k,wl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ke,H,Ul="So it cannot be only a function. It should be a class.",Oe,x,Tl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",et,V,Jl="Here’s how it looks:",tt,R,lt,N,fl='The custom tool subclasses <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',st,E,jl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',ot,S,gl="And that’s all it needs to be used in an agent!",nt,q,Cl='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',at,A,vl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool">Tool</a> as described above.',it,X,rt,Y,Il='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',pt,z,Mt,F,Zl="For the push to Hub to work, your tool will need to respect some rules:",ut,P,$l='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',ct,L,Bl='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',dt,D,Wl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',mt,K,_l=`Then you can load the tool with <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,yt,O,ht,ee,bt,te,Gl='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',wt,le,Ql='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Ut,se,kl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Tt,oe,Jt,ne,Hl="And voilà, here’s your image! 🏖️",ft,Ae,xl,jt,ae,Vl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",gt,ie,Ct,re,vt,Xe,Rl,It,pe,Nl="How cool is this? 🤩",Zt,Me,$t,ue,El=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,Bt,ce,Sl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,Wt,de,_t,me,Gt,ye,ql="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",Qt,he,Al="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",kt,be,Ht,we,Xl="Now we can leverage the new tool:",xt,Ue,Vt,Z,Rt,Te,Nt,Je,Yl='You can leverage tool collections by using <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Et,fe,St,je,zl=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,qt,ge,At,Ce,Fl="To speed up the start, tools are loaded only if called by the agent.",Xt,ve,Yt,Ie,Pl='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',zt,$,Ft,Ze,Ll='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1384/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Pt,$e,Dl="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Lt,Be,Dt,We,Kl="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",Kt,_e,Ot,Ge,el,Qe,Ol="You can also work with MCP tools by using the <code>MCPClient</code> directly, which gives you more control over the connection and tool management:",tl,ke,es="For stdio-based MCP servers:",ll,He,sl,xe,ts="For Streamable HTTP-based MCP servers:",ol,Ve,nl,Re,ls="You can also manually manage the connection lifecycle with the try…finally pattern:",al,Ne,il,Ee,ss="You can also connect to multiple MCP servers at once by passing a list of server parameters:",rl,Se,pl,B,Ml,qe,ul,Ye,cl;return j=new g({props:{title:"Tools",local:"tools",headingTag:"h1"}}),J=new hs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),I=new ml({props:{warning:!1,$$slots:{default:[ws]},$$scope:{ctx:f}}}),G=new g({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),R=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),X=new g({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),z=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),O=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ee=new g({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),oe=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ie=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),re=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),Me=new g({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),de=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),me=new g({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),be=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Ue=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),Z=new ml({props:{warning:!1,$$slots:{default:[Us]},$$scope:{ctx:f}}}),Te=new g({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),fe=new g({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),ge=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ve=new g({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),$=new ml({props:{warning:!0,$$slots:{default:[Ts]},$$scope:{ctx:f}}}),Be=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),_e=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ge=new g({props:{title:"Use MCP tools with MCPClient directly",local:"use-mcp-tools-with-mcpclient-directly",headingTag:"h3"}}),He=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),Ve=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ne=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),Se=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),B=new ml({props:{warning:!0,$$slots:{default:[Js]},$$scope:{ctx:f}}}),qe=new bs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=a("meta"),U=o(),h=a("p"),w=o(),M(j.$$.fragment),C=o(),M(J.$$.fragment),W=o(),b=a("p"),b.textContent=v,ze=o(),M(I.$$.fragment),Fe=o(),_=a("ul"),_.innerHTML=hl,Pe=o(),M(G.$$.fragment),Le=o(),Q=a("p"),Q.textContent=bl,De=o(),k=a("p"),k.textContent=wl,Ke=o(),H=a("p"),H.textContent=Ul,Oe=o(),x=a("p"),x.textContent=Tl,et=o(),V=a("p"),V.textContent=Jl,tt=o(),M(R.$$.fragment),lt=o(),N=a("p"),N.innerHTML=fl,st=o(),E=a("ul"),E.innerHTML=jl,ot=o(),S=a("p"),S.textContent=gl,nt=o(),q=a("p"),q.innerHTML=Cl,at=o(),A=a("p"),A.innerHTML=vl,it=o(),M(X.$$.fragment),rt=o(),Y=a("p"),Y.innerHTML=Il,pt=o(),M(z.$$.fragment),Mt=o(),F=a("p"),F.textContent=Zl,ut=o(),P=a("ul"),P.innerHTML=$l,ct=o(),L=a("p"),L.innerHTML=Bl,dt=o(),D=a("p"),D.innerHTML=Wl,mt=o(),K=a("p"),K.innerHTML=_l,yt=o(),M(O.$$.fragment),ht=o(),M(ee.$$.fragment),bt=o(),te=a("p"),te.innerHTML=Gl,wt=o(),le=a("p"),le.innerHTML=Ql,Ut=o(),se=a("p"),se.innerHTML=kl,Tt=o(),M(oe.$$.fragment),Jt=o(),ne=a("p"),ne.textContent=Hl,ft=o(),Ae=a("img"),jt=o(),ae=a("p"),ae.innerHTML=Vl,gt=o(),M(ie.$$.fragment),Ct=o(),M(re.$$.fragment),vt=o(),Xe=a("img"),It=o(),pe=a("p"),pe.textContent=Nl,Zt=o(),M(Me.$$.fragment),$t=o(),ue=a("p"),ue.innerHTML=El,Bt=o(),ce=a("p"),ce.innerHTML=Sl,Wt=o(),M(de.$$.fragment),_t=o(),M(me.$$.fragment),Gt=o(),ye=a("p"),ye.innerHTML=ql,Qt=o(),he=a("p"),he.innerHTML=Al,kt=o(),M(be.$$.fragment),Ht=o(),we=a("p"),we.textContent=Xl,xt=o(),M(Ue.$$.fragment),Vt=o(),M(Z.$$.fragment),Rt=o(),M(Te.$$.fragment),Nt=o(),Je=a("p"),Je.innerHTML=Yl,Et=o(),M(fe.$$.fragment),St=o(),je=a("p"),je.textContent=zl,qt=o(),M(ge.$$.fragment),At=o(),Ce=a("p"),Ce.textContent=Fl,Xt=o(),M(ve.$$.fragment),Yt=o(),Ie=a("p"),Ie.innerHTML=Pl,zt=o(),M($.$$.fragment),Ft=o(),Ze=a("p"),Ze.innerHTML=Ll,Pt=o(),$e=a("p"),$e.innerHTML=Dl,Lt=o(),M(Be.$$.fragment),Dt=o(),We=a("p"),We.innerHTML=Kl,Kt=o(),M(_e.$$.fragment),Ot=o(),M(Ge.$$.fragment),el=o(),Qe=a("p"),Qe.innerHTML=Ol,tl=o(),ke=a("p"),ke.textContent=es,ll=o(),M(He.$$.fragment),sl=o(),xe=a("p"),xe.textContent=ts,ol=o(),M(Ve.$$.fragment),nl=o(),Re=a("p"),Re.textContent=ls,al=o(),M(Ne.$$.fragment),il=o(),Ee=a("p"),Ee.textContent=ss,rl=o(),M(Se.$$.fragment),pl=o(),M(B.$$.fragment),Ml=o(),M(qe.$$.fragment),ul=o(),Ye=a("p"),this.h()},l(e){const t=ms("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=n(e),h=i(e,"P",{}),ps(h).forEach(l),w=n(e),u(j.$$.fragment,e),C=n(e),u(J.$$.fragment,e),W=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-8951oz"&&(b.textContent=v),ze=n(e),u(I.$$.fragment,e),Fe=n(e),_=i(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-gdosxb"&&(_.innerHTML=hl),Pe=n(e),u(G.$$.fragment,e),Le=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-50z9h0"&&(Q.textContent=bl),De=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1llqfcr"&&(k.textContent=wl),Ke=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-eilpgu"&&(H.textContent=Ul),Oe=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-suz7fy"&&(x.textContent=Tl),et=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-x18ywb"&&(V.textContent=Jl),tt=n(e),u(R.$$.fragment,e),lt=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ad0m47"&&(N.innerHTML=fl),st=n(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xqgwuf"&&(E.innerHTML=jl),ot=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-220ayw"&&(S.textContent=gl),nt=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1dn3kyh"&&(q.innerHTML=Cl),at=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lrxw91"&&(A.innerHTML=vl),it=n(e),u(X.$$.fragment,e),rt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1y6bndw"&&(Y.innerHTML=Il),pt=n(e),u(z.$$.fragment,e),Mt=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hoocvd"&&(F.textContent=Zl),ut=n(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-ggv8xl"&&(P.innerHTML=$l),ct=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-4n5s3c"&&(L.innerHTML=Bl),dt=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1knl8v8"&&(D.innerHTML=Wl),mt=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-c1ldso"&&(K.innerHTML=_l),yt=n(e),u(O.$$.fragment,e),ht=n(e),u(ee.$$.fragment,e),bt=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1qtw7l5"&&(te.innerHTML=Gl),wt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-17wa58l"&&(le.innerHTML=Ql),Ut=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1gucs20"&&(se.innerHTML=kl),Tt=n(e),u(oe.$$.fragment,e),Jt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-sgspwr"&&(ne.textContent=Hl),ft=n(e),Ae=i(e,"IMG",{src:!0}),jt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1y8rl57"&&(ae.innerHTML=Vl),gt=n(e),u(ie.$$.fragment,e),Ct=n(e),u(re.$$.fragment,e),vt=n(e),Xe=i(e,"IMG",{src:!0}),It=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-i5dtbz"&&(pe.textContent=Nl),Zt=n(e),u(Me.$$.fragment,e),$t=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1rq40pf"&&(ue.innerHTML=El),Bt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1g7jkvd"&&(ce.innerHTML=Sl),Wt=n(e),u(de.$$.fragment,e),_t=n(e),u(me.$$.fragment,e),Gt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-69p3x"&&(ye.innerHTML=ql),Qt=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ocb8u2"&&(he.innerHTML=Al),kt=n(e),u(be.$$.fragment,e),Ht=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-o3ledg"&&(we.textContent=Xl),xt=n(e),u(Ue.$$.fragment,e),Vt=n(e),u(Z.$$.fragment,e),Rt=n(e),u(Te.$$.fragment,e),Nt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1tmjqba"&&(Je.innerHTML=Yl),Et=n(e),u(fe.$$.fragment,e),St=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-qubpc6"&&(je.textContent=zl),qt=n(e),u(ge.$$.fragment,e),At=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-6r1jgt"&&(Ce.textContent=Fl),Xt=n(e),u(ve.$$.fragment,e),Yt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1q39vf"&&(Ie.innerHTML=Pl),zt=n(e),u($.$$.fragment,e),Ft=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-n2e8og"&&(Ze.innerHTML=Ll),Pt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-s0gh2b"&&($e.innerHTML=Dl),Lt=n(e),u(Be.$$.fragment,e),Dt=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-j0i0xh"&&(We.innerHTML=Kl),Kt=n(e),u(_e.$$.fragment,e),Ot=n(e),u(Ge.$$.fragment,e),el=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9674bn"&&(Qe.innerHTML=Ol),tl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1en3ihe"&&(ke.textContent=es),ll=n(e),u(He.$$.fragment,e),sl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ro6hjz"&&(xe.textContent=ts),ol=n(e),u(Ve.$$.fragment,e),nl=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1and4a8"&&(Re.textContent=ls),al=n(e),u(Ne.$$.fragment,e),il=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-7q6kbi"&&(Ee.textContent=ss),rl=n(e),u(Se.$$.fragment,e),pl=n(e),u(B.$$.fragment,e),Ml=n(e),u(qe.$$.fragment,e),ul=n(e),Ye=i(e,"P",{}),ps(Ye).forEach(l),this.h()},h(){dl(p,"name","hf:doc:metadata"),dl(p,"content",js),rs(Ae.src,xl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||dl(Ae,"src",xl),rs(Xe.src,Rl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||dl(Xe,"src",Rl)},m(e,t){ys(document.head,p),s(e,U,t),s(e,h,t),s(e,w,t),c(j,e,t),s(e,C,t),c(J,e,t),s(e,W,t),s(e,b,t),s(e,ze,t),c(I,e,t),s(e,Fe,t),s(e,_,t),s(e,Pe,t),c(G,e,t),s(e,Le,t),s(e,Q,t),s(e,De,t),s(e,k,t),s(e,Ke,t),s(e,H,t),s(e,Oe,t),s(e,x,t),s(e,et,t),s(e,V,t),s(e,tt,t),c(R,e,t),s(e,lt,t),s(e,N,t),s(e,st,t),s(e,E,t),s(e,ot,t),s(e,S,t),s(e,nt,t),s(e,q,t),s(e,at,t),s(e,A,t),s(e,it,t),c(X,e,t),s(e,rt,t),s(e,Y,t),s(e,pt,t),c(z,e,t),s(e,Mt,t),s(e,F,t),s(e,ut,t),s(e,P,t),s(e,ct,t),s(e,L,t),s(e,dt,t),s(e,D,t),s(e,mt,t),s(e,K,t),s(e,yt,t),c(O,e,t),s(e,ht,t),c(ee,e,t),s(e,bt,t),s(e,te,t),s(e,wt,t),s(e,le,t),s(e,Ut,t),s(e,se,t),s(e,Tt,t),c(oe,e,t),s(e,Jt,t),s(e,ne,t),s(e,ft,t),s(e,Ae,t),s(e,jt,t),s(e,ae,t),s(e,gt,t),c(ie,e,t),s(e,Ct,t),c(re,e,t),s(e,vt,t),s(e,Xe,t),s(e,It,t),s(e,pe,t),s(e,Zt,t),c(Me,e,t),s(e,$t,t),s(e,ue,t),s(e,Bt,t),s(e,ce,t),s(e,Wt,t),c(de,e,t),s(e,_t,t),c(me,e,t),s(e,Gt,t),s(e,ye,t),s(e,Qt,t),s(e,he,t),s(e,kt,t),c(be,e,t),s(e,Ht,t),s(e,we,t),s(e,xt,t),c(Ue,e,t),s(e,Vt,t),c(Z,e,t),s(e,Rt,t),c(Te,e,t),s(e,Nt,t),s(e,Je,t),s(e,Et,t),c(fe,e,t),s(e,St,t),s(e,je,t),s(e,qt,t),c(ge,e,t),s(e,At,t),s(e,Ce,t),s(e,Xt,t),c(ve,e,t),s(e,Yt,t),s(e,Ie,t),s(e,zt,t),c($,e,t),s(e,Ft,t),s(e,Ze,t),s(e,Pt,t),s(e,$e,t),s(e,Lt,t),c(Be,e,t),s(e,Dt,t),s(e,We,t),s(e,Kt,t),c(_e,e,t),s(e,Ot,t),c(Ge,e,t),s(e,el,t),s(e,Qe,t),s(e,tl,t),s(e,ke,t),s(e,ll,t),c(He,e,t),s(e,sl,t),s(e,xe,t),s(e,ol,t),c(Ve,e,t),s(e,nl,t),s(e,Re,t),s(e,al,t),c(Ne,e,t),s(e,il,t),s(e,Ee,t),s(e,rl,t),c(Se,e,t),s(e,pl,t),c(B,e,t),s(e,Ml,t),c(qe,e,t),s(e,ul,t),s(e,Ye,t),cl=!0},p(e,[t]){const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),I.$set(os);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),Z.$set(ns);const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),$.$set(as);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),B.$set(is)},i(e){cl||(d(j.$$.fragment,e),d(J.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(be.$$.fragment,e),d(Ue.$$.fragment,e),d(Z.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(ve.$$.fragment,e),d($.$$.fragment,e),d(Be.$$.fragment,e),d(_e.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(B.$$.fragment,e),d(qe.$$.fragment,e),cl=!0)},o(e){m(j.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(oe.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(Z.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m($.$$.fragment,e),m(Be.$$.fragment,e),m(_e.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Se.$$.fragment,e),m(B.$$.fragment,e),m(qe.$$.fragment,e),cl=!1},d(e){e&&(l(U),l(h),l(w),l(C),l(W),l(b),l(ze),l(Fe),l(_),l(Pe),l(Le),l(Q),l(De),l(k),l(Ke),l(H),l(Oe),l(x),l(et),l(V),l(tt),l(lt),l(N),l(st),l(E),l(ot),l(S),l(nt),l(q),l(at),l(A),l(it),l(rt),l(Y),l(pt),l(Mt),l(F),l(ut),l(P),l(ct),l(L),l(dt),l(D),l(mt),l(K),l(yt),l(ht),l(bt),l(te),l(wt),l(le),l(Ut),l(se),l(Tt),l(Jt),l(ne),l(ft),l(Ae),l(jt),l(ae),l(gt),l(Ct),l(vt),l(Xe),l(It),l(pe),l(Zt),l($t),l(ue),l(Bt),l(ce),l(Wt),l(_t),l(Gt),l(ye),l(Qt),l(he),l(kt),l(Ht),l(we),l(xt),l(Vt),l(Rt),l(Nt),l(Je),l(Et),l(St),l(je),l(qt),l(At),l(Ce),l(Xt),l(Yt),l(Ie),l(zt),l(Ft),l(Ze),l(Pt),l($e),l(Lt),l(Dt),l(We),l(Kt),l(Ot),l(el),l(Qe),l(tl),l(ke),l(ll),l(sl),l(xe),l(ol),l(nl),l(Re),l(al),l(il),l(Ee),l(rl),l(pl),l(Ml),l(ul),l(Ye)),l(p),y(j,e),y(J,e),y(I,e),y(G,e),y(R,e),y(X,e),y(z,e),y(O,e),y(ee,e),y(oe,e),y(ie,e),y(re,e),y(Me,e),y(de,e),y(me,e),y(be,e),y(Ue,e),y(Z,e),y(Te,e),y(fe,e),y(ge,e),y(ve,e),y($,e),y(Be,e),y(_e,e),y(Ge,e),y(He,e),y(Ve,e),y(Ne,e),y(Se,e),y(B,e),y(qe,e)}}}const js='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3},{"title":"Use MCP tools with MCPClient directly","local":"use-mcp-tools-with-mcpclient-directly","sections":[],"depth":3}],"depth":1}';function gs(f){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends cs{constructor(p){super(),ds(this,p,gs,fs,Ms,{})}}export{Ws as component};
