import{s as hs,o as Js}from"../chunks/scheduler.f7e1785c.js";import{S as Ts,i as Us,g as i,s as n,r as o,A as ws,h as u,f as t,c as a,j as fs,u as p,x as r,k as Fe,y as bs,a as l,v as d,d as c,t as M,w as m,m as gs,n as vs}from"../chunks/index.9f8f0838.js";import{T as Is}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.4baef5d7.js";import{H as Le,E as Cs}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function qs(ae){let j;return{c(){j=gs(`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},l(f){j=vs(f,`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},m(f,T){l(f,j,T)},d(f){f&&t(j)}}}function As(ae){let j,f,T,ie,U,ue,w,Se=`Le chargement d’un jeu de données avec 🤗 <em>Datasets</em> n’est que la moitié du plaisir.
Si vous prévoyez de l’utiliser pour entraîner un modèle ou pour exécuter l’inférence, vous devrez d’abord prétraiter les données. En général, cela impliquera les étapes suivantes:`,re,b,De="<li>Rééchantillonnage des données audio</li> <li>Filtrage du jeu de données</li> <li>Conversion des données audio en entrée attendue du modèle</li>",oe,g,pe,v,Pe=`La fonction <code>load_dataset</code> télécharge des exemples audio avec le taux d’échantillonnage avec lequel ils ont été publiés.
Ce n’est pas toujours le taux d’échantillonnage attendu par un modèle que vous prévoyez d’entraîner ou d’utiliser pour l’inférence.
S’il existe un écart entre les taux d’échantillonnage, vous pouvez rééchantillonner l’audio à la fréquence d’échantillonnage attendue du modèle.
La plupart des modèles pré-entraînés disponibles ont été pré-entraînés sur des jeux de données audio à une fréquence d’échantillonnage de 16 kHz.
Lorsque nous avons exploré le jeu de données MINDS-14, vous avez peut-être remarqué qu’il est échantillonné à 8 kHz, ce qui signifie que nous devrons probablement le suréchantillonner.
Pour ce faire, utilisez la méthode <code>cast_column</code> de 🤗 Datasets.
Cette opération ne modifie pas l’audio sur place, mais plutôt les signaux aux jeux de données pour rééchantillonner les exemples audio à la volée lorsqu’ils sont chargés.
Le code suivant définira la fréquence d’échantillonnage à 16 kHz :`,de,I,ce,C,Oe="Rechargez le premier exemple audio dans le jeu de données MINDS-14 et vérifiez qu’il a été rééchantillonné à la « fréquence d’échantillonnage » souhaitée :",Me,q,me,A,Ke="<strong>Sortie :</strong>",je,$,ye,x,es="Vous remarquerez peut-être que les valeurs de tableau sont maintenant également différentes. C’est parce que nous avons maintenant deux fois plus de valeurs d’amplitude pour chacune d’entre elles que nous avions auparavant.",fe,h,he,B,Je,G,ss=`Vous devrez peut-être filtrer les données en fonction de certains critères. L’un des cas courants consiste à limiter les exemples audio à une certaine durée.
Par exemple, nous pourrions vouloir filtrer tous les exemples de plus de 20 secondes pour éviter les erreurs de mémoire insuffisante lors de l’entraînement d’un modèle.
Nous pouvons le faire en utilisant la  méthode <code>filter</code> de 🤗 <em>Datasets</em> et en lui passant une fonction avec une logique de filtrage. Commençons par écrire une fonction qui indique quels exemples conserver et lesquels rejeter.
Cette fonction, <code>is_audio_length_in_range&#39;, renvoie </code>True<code>si un échantillon est inférieur à 20s et</code>False\` s’il est plus long que 20s.`,Te,R,Ue,z,ts=`La fonction de filtrage peut être appliquée à la colonne d’un jeu de données, mais nous n’avons pas de colonne avec une durée de piste audio dans ce jeu de données.
Cependant, nous pouvons en créer un, filtrer en fonction des valeurs de cette colonne, puis le supprimer.`,we,_,be,Z,ls="<strong>Sortie :</strong>",ge,k,ve,V,ns="Nous pouvons vérifier que le jeu de données a été filtré de 654 exemples à 624.",Ie,W,Ce,N,as=`L’un des aspects les plus difficiles de l’utilisation d’ensembles de données audio consiste à préparer les données dans le bon format pour la formation des modèles.
Comme vous l’avez vu, les données audio brutes se présentent sous la forme d’un tableau de valeurs d’échantillon.
Cependant, les modèles pré-entraînés, que vous les utilisiez pour l’inférence ou que vous souhaitiez les finetuner pour votre tâche, s’attendent à ce que les données brutes soient converties en fonctionnalités d’entrée.
Les exigences pour les caractéristiques d’entrée peuvent varier d’un modèle à l’autre. Elles dépendent de l’architecture du modèle et des données avec lesquelles il a été pré-entraîné.
La bonne nouvelle est que, pour chaque modèle audio pris en charge, 🤗 <em>Transformers</em> offrent une classe d’extracteur de caractéristiques qui peut convertir les données audio brutes en caractéristiques d’entrée attendues par le modèle.`,qe,H,is=`Alors, que fait un extracteur de caractéristiques avec les données audio brutes ? Jetons un coup d’œil à l’extracteur de caractéristiques de <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a> pour comprendre certaines transformations d’extraction de caractéristiques courantes.
Whisper est un modèle pré-entraîné pour la reconnaissance vocale automatique (ASR) publié en septembre 2022 par Alec Radford et al. d’OpenAI.
Tout d’abord, l’extracteur de fonction Whisper pave / tronque un batch d’exemples audio de sorte que tous les exemples ont une longueur d’entrée de 30s.
Les exemples plus courts sont complétés à 30s en ajoutant des zéros à la fin de la séquence (les zéros dans un signal audio correspondent à l’absence de signal ou au silence). Les exemples de plus de 30 ans sont tronqués à 30 s.
Étant donné que tous les éléments du batch sont rembourrés/tronqués à une longueur maximale dans l’espace d’entrée, il n’y a pas besoin d’un masque d’attention.
Whisper est unique à cet égard, la plupart des autres modèles audio nécessitent un masque d’attention qui détaille où les séquences ont été rembourrées, et donc où elles doivent être ignorées dans le mécanisme d’auto-attention.
Whisper est entraîné pour fonctionner sans masque d’attention et déduire directement des signaux vocaux où ignorer les entrées.
La deuxième opération effectuée par l’extracteur de fonctions Whisper consiste à convertir les matrices audio rembourrées en spectrogrammes log-mel.
Ces spectrogrammes décrivent comment les fréquences d’un signal changent au fil du temps, exprimées sur l’échelle mel et mesurées en décibels (la partie log) pour rendre les fréquences et les amplitudes plus représentatives de l’audition humaine.
Toutes ces transformations peuvent être appliquées à vos données audio brutes avec quelques lignes de code.
Allons de l’avant et chargeons l’extracteur de caractéristiques à partir du <em>checkpoint</em> de Whisper pré-entraîné pour être prêt pour nos données audio:`,Ae,X,$e,E,us="Ensuite, vous pouvez écrire une fonction pour pré-traiter un seul exemple audio en le faisant passer par le <code>feature_extractor</code>.",xe,Y,Be,Q,rs="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>map</code> de 🤗 <em>Datasets</em> :",Ge,L,Re,F,os="<strong>Sortie :</strong>",ze,S,_e,D,ps=`Aussi simple que cela, nous avons maintenant des spectrogrammes log-mel comme <code>input_features</code> dans le jeu de données.
Visualisons-le pour l’un des exemples de <code>minds</code> :`,Ze,P,ke,J,ds='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Ve,O,cs="Vous pouvez maintenant voir à quoi ressemble l’entrée audio du modèle Whisper après le prétraitement.",We,K,Ms=`La classe d’extracteur de caractéristiques du modèle se charge de transformer les données audio brutes au format attendu par le modèle. Cependant, de nombreuses tâches impliquant l’audio sont multimodales, par exemple la reconnaissance vocale.
Dans de tels cas, 🤗 <em>Transformers</em> offrent également des tokeniseurs spécifiques au modèle pour traiter les entrées de texte. Pour une plongée approfondie dans les tokeniseurs, veuillez vous référer à notre <a href="https://huggingface.co/learn/nlp-course/fr/chapter2/4" rel="nofollow">cours de NLP</a>.`,Ne,ee,ms=`Vous pouvez charger séparément l’extracteur de caractéristiques et le tokeniseur pour Whisper et d’autres modèles multimodaux, ou vous pouvez charger les deux via un processeur.
Pour rendre les choses encore plus simples, utilisez <code>AutoProcessor</code> pour charger l’extracteur de caractéristiques et le processeur d’un modèle à partir d’un <em>checkpoint</em>, comme ceci :`,He,se,Xe,te,js=`Nous avons illustré ici les étapes fondamentales de préparation des données. Bien entendu, les données personnalisées peuvent nécessiter un prétraitement plus complexe.
Dans ce cas, vous pouvez étendre la fonction <code>prepare_dataset</code> pour effectuer n’importe quel type de transformations de données personnalisées.
Avec 🤗 <em>Datasets</em>, si vous pouvez l’écrire en tant que fonction Python, vous pouvez l’appliquer à votre jeu de données !`,Ee,le,Ye,ne,Qe;return U=new Le({props:{title:"Prétraitement d’un jeu de données audio",local:"prétraitement-dun-jeu-de-données-audio",headingTag:"h1"}}),g=new Le({props:{title:"Rééchantillonnage des données audio",local:"rééchantillonnage-des-données-audio",headingTag:"h2"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),q=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),$=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RCUwQQ==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}
`,wrap:!1}}),h=new Is({props:{$$slots:{default:[qs]},$$scope:{ctx:ae}}}),B=new Le({props:{title:"Filtrage du jeu de données",local:"filtrage-du-jeu-de-données",headingTag:"h2"}}),R=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),_=new y({props:{code:"JTIzJTIwVXRpbGlzZXolMjBsaWJyb3NhJTIwcG91ciUyMG9idGVuaXIlMjBsYSUyMGR1ciVDMyVBOWUlMjBkZSUyMGwnZXhlbXBsZSUyMCVDMyVBMCUyMHBhcnRpciUyMGR1JTIwZmljaGllciUyMGF1ZGlvJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXRpbGlzZXIlMjBsYSUyMG0lQzMlQTl0aG9kZSUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwb3VyJTIwYXBwbGlxdWVyJTIwbGElMjBmb25jdGlvbiUyMGRlJTIwZmlsdHJhZ2UlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwc3VwcHJpbWVyJTIwbGElMjBjb2xvbm5lJTIwZCdhc3Npc3RhbmNlJTIwdGVtcG9yYWlyZSUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># Utilisez librosa pour obtenir la durée de l&#x27;exemple à partir du fichier audio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># utiliser la méthode \`filter\` de 🤗 Datasets pour appliquer la fonction de filtrage</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># supprimer la colonne d&#x27;assistance temporaire</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),k=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),W=new Le({props:{title:"Prétraitement des données audio",local:"prétraitement-des-données-audio",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),Y=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),L=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),S=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),P=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),le=new Cs({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter1/preprocessing.mdx"}}),{c(){j=i("meta"),f=n(),T=i("p"),ie=n(),o(U.$$.fragment),ue=n(),w=i("p"),w.innerHTML=Se,re=n(),b=i("ul"),b.innerHTML=De,oe=n(),o(g.$$.fragment),pe=n(),v=i("p"),v.innerHTML=Pe,de=n(),o(I.$$.fragment),ce=n(),C=i("p"),C.textContent=Oe,Me=n(),o(q.$$.fragment),me=n(),A=i("p"),A.innerHTML=Ke,je=n(),o($.$$.fragment),ye=n(),x=i("p"),x.textContent=es,fe=n(),o(h.$$.fragment),he=n(),o(B.$$.fragment),Je=n(),G=i("p"),G.innerHTML=ss,Te=n(),o(R.$$.fragment),Ue=n(),z=i("p"),z.textContent=ts,we=n(),o(_.$$.fragment),be=n(),Z=i("p"),Z.innerHTML=ls,ge=n(),o(k.$$.fragment),ve=n(),V=i("p"),V.textContent=ns,Ie=n(),o(W.$$.fragment),Ce=n(),N=i("p"),N.innerHTML=as,qe=n(),H=i("p"),H.innerHTML=is,Ae=n(),o(X.$$.fragment),$e=n(),E=i("p"),E.innerHTML=us,xe=n(),o(Y.$$.fragment),Be=n(),Q=i("p"),Q.innerHTML=rs,Ge=n(),o(L.$$.fragment),Re=n(),F=i("p"),F.innerHTML=os,ze=n(),o(S.$$.fragment),_e=n(),D=i("p"),D.innerHTML=ps,Ze=n(),o(P.$$.fragment),ke=n(),J=i("div"),J.innerHTML=ds,Ve=n(),O=i("p"),O.textContent=cs,We=n(),K=i("p"),K.innerHTML=Ms,Ne=n(),ee=i("p"),ee.innerHTML=ms,He=n(),o(se.$$.fragment),Xe=n(),te=i("p"),te.innerHTML=js,Ee=n(),o(le.$$.fragment),Ye=n(),ne=i("p"),this.h()},l(e){const s=ws("svelte-u9bgzb",document.head);j=u(s,"META",{name:!0,content:!0}),s.forEach(t),f=a(e),T=u(e,"P",{}),fs(T).forEach(t),ie=a(e),p(U.$$.fragment,e),ue=a(e),w=u(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-mdqbw0"&&(w.innerHTML=Se),re=a(e),b=u(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-yk9hcg"&&(b.innerHTML=De),oe=a(e),p(g.$$.fragment,e),pe=a(e),v=u(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ivzlq3"&&(v.innerHTML=Pe),de=a(e),p(I.$$.fragment,e),ce=a(e),C=u(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-538ngx"&&(C.textContent=Oe),Me=a(e),p(q.$$.fragment,e),me=a(e),A=u(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-dbzevp"&&(A.innerHTML=Ke),je=a(e),p($.$$.fragment,e),ye=a(e),x=u(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-164hhon"&&(x.textContent=es),fe=a(e),p(h.$$.fragment,e),he=a(e),p(B.$$.fragment,e),Je=a(e),G=u(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-mbvv6"&&(G.innerHTML=ss),Te=a(e),p(R.$$.fragment,e),Ue=a(e),z=u(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-8vpyeu"&&(z.textContent=ts),we=a(e),p(_.$$.fragment,e),be=a(e),Z=u(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-dbzevp"&&(Z.innerHTML=ls),ge=a(e),p(k.$$.fragment,e),ve=a(e),V=u(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tdnd34"&&(V.textContent=ns),Ie=a(e),p(W.$$.fragment,e),Ce=a(e),N=u(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9jm202"&&(N.innerHTML=as),qe=a(e),H=u(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18oi0yw"&&(H.innerHTML=is),Ae=a(e),p(X.$$.fragment,e),$e=a(e),E=u(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-iag9pm"&&(E.innerHTML=us),xe=a(e),p(Y.$$.fragment,e),Be=a(e),Q=u(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1le6nsz"&&(Q.innerHTML=rs),Ge=a(e),p(L.$$.fragment,e),Re=a(e),F=u(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-dbzevp"&&(F.innerHTML=os),ze=a(e),p(S.$$.fragment,e),_e=a(e),D=u(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ojjqz9"&&(D.innerHTML=ps),Ze=a(e),p(P.$$.fragment,e),ke=a(e),J=u(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-csckl"&&(J.innerHTML=ds),Ve=a(e),O=u(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-y12i6c"&&(O.textContent=cs),We=a(e),K=u(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-19a55if"&&(K.innerHTML=Ms),Ne=a(e),ee=u(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1sqx47z"&&(ee.innerHTML=ms),He=a(e),p(se.$$.fragment,e),Xe=a(e),te=u(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-172ihj8"&&(te.innerHTML=js),Ee=a(e),p(le.$$.fragment,e),Ye=a(e),ne=u(e,"P",{}),fs(ne).forEach(t),this.h()},h(){Fe(j,"name","hf:doc:metadata"),Fe(j,"content",$s),Fe(J,"class","flex justify-center")},m(e,s){bs(document.head,j),l(e,f,s),l(e,T,s),l(e,ie,s),d(U,e,s),l(e,ue,s),l(e,w,s),l(e,re,s),l(e,b,s),l(e,oe,s),d(g,e,s),l(e,pe,s),l(e,v,s),l(e,de,s),d(I,e,s),l(e,ce,s),l(e,C,s),l(e,Me,s),d(q,e,s),l(e,me,s),l(e,A,s),l(e,je,s),d($,e,s),l(e,ye,s),l(e,x,s),l(e,fe,s),d(h,e,s),l(e,he,s),d(B,e,s),l(e,Je,s),l(e,G,s),l(e,Te,s),d(R,e,s),l(e,Ue,s),l(e,z,s),l(e,we,s),d(_,e,s),l(e,be,s),l(e,Z,s),l(e,ge,s),d(k,e,s),l(e,ve,s),l(e,V,s),l(e,Ie,s),d(W,e,s),l(e,Ce,s),l(e,N,s),l(e,qe,s),l(e,H,s),l(e,Ae,s),d(X,e,s),l(e,$e,s),l(e,E,s),l(e,xe,s),d(Y,e,s),l(e,Be,s),l(e,Q,s),l(e,Ge,s),d(L,e,s),l(e,Re,s),l(e,F,s),l(e,ze,s),d(S,e,s),l(e,_e,s),l(e,D,s),l(e,Ze,s),d(P,e,s),l(e,ke,s),l(e,J,s),l(e,Ve,s),l(e,O,s),l(e,We,s),l(e,K,s),l(e,Ne,s),l(e,ee,s),l(e,He,s),d(se,e,s),l(e,Xe,s),l(e,te,s),l(e,Ee,s),d(le,e,s),l(e,Ye,s),l(e,ne,s),Qe=!0},p(e,[s]){const ys={};s&2&&(ys.$$scope={dirty:s,ctx:e}),h.$set(ys)},i(e){Qe||(c(U.$$.fragment,e),c(g.$$.fragment,e),c(I.$$.fragment,e),c(q.$$.fragment,e),c($.$$.fragment,e),c(h.$$.fragment,e),c(B.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),Qe=!0)},o(e){M(U.$$.fragment,e),M(g.$$.fragment,e),M(I.$$.fragment,e),M(q.$$.fragment,e),M($.$$.fragment,e),M(h.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),Qe=!1},d(e){e&&(t(f),t(T),t(ie),t(ue),t(w),t(re),t(b),t(oe),t(pe),t(v),t(de),t(ce),t(C),t(Me),t(me),t(A),t(je),t(ye),t(x),t(fe),t(he),t(Je),t(G),t(Te),t(Ue),t(z),t(we),t(be),t(Z),t(ge),t(ve),t(V),t(Ie),t(Ce),t(N),t(qe),t(H),t(Ae),t($e),t(E),t(xe),t(Be),t(Q),t(Ge),t(Re),t(F),t(ze),t(_e),t(D),t(Ze),t(ke),t(J),t(Ve),t(O),t(We),t(K),t(Ne),t(ee),t(He),t(Xe),t(te),t(Ee),t(Ye),t(ne)),t(j),m(U,e),m(g,e),m(I,e),m(q,e),m($,e),m(h,e),m(B,e),m(R,e),m(_,e),m(k,e),m(W,e),m(X,e),m(Y,e),m(L,e),m(S,e),m(P,e),m(se,e),m(le,e)}}}const $s='{"title":"Prétraitement d’un jeu de données audio","local":"prétraitement-dun-jeu-de-données-audio","sections":[{"title":"Rééchantillonnage des données audio","local":"rééchantillonnage-des-données-audio","sections":[],"depth":2},{"title":"Filtrage du jeu de données","local":"filtrage-du-jeu-de-données","sections":[],"depth":2},{"title":"Prétraitement des données audio","local":"prétraitement-des-données-audio","sections":[],"depth":2}],"depth":1}';function xs(ae){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends Ts{constructor(j){super(),Us(this,j,xs,As,hs,{})}}export{Zs as component};
