import{s as lo,n as co,o as io}from"../chunks/scheduler.0219f8bd.js";import{S as ao,i as po,g as c,s as r,r as p,A as no,h as i,f as o,c as l,j as n,u as m,x as a,k as d,y as mo,a as s,v as f,d as u,t as _,w as h}from"../chunks/index.f61edf3b.js";import{C as fo}from"../chunks/CodeBlock.38e566ae.js";import{H as T,E as uo}from"../chunks/EditOnGithub.48fa589f.js";function _o(At){let P,_e,fe,he,y,Te,M,Pe,$,Ut="Processors are used to prepare inputs (e.g., text, image or audio) for a model.",ye,b,Et="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",Me,g,$e,w,It='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..PreTrainedTokenizer"><code>~PreTrainedTokenizer</code></a> : <code>Object</code></li></ul></li></ul></li>',be,ge,we,x,xe,v,ve,j,Rt="Represents a Processor that extracts features from an input.",je,J,Nt='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Je,k,Bt='<li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li>',ke,He,Ce,H,Le,C,ze,L,Qt="Creates a new Processor with the given components",Ae,z,Dt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td> </tr><tr><td>components</td><td><code>Record.&lt;string, Object&gt;</code></td></tr></tbody>",Ue,Ee,Ie,A,Re,U,Ne,E,Zt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image processor of the processor, if it exists.',Be,Qe,De,I,Ze,R,Ye,N,Yt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>PreTrainedTokenizer</code> | <code>undefined</code> - The tokenizer of the processor, if it exists.',Xe,Ge,We,B,Fe,Q,Ke,D,Xt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The feature extractor of the processor, if it exists.',Oe,Se,Ve,Z,qe,Y,et,X,Gt='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',tt,G,Wt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>messages</td><td><code>*</code></td> </tr><tr><td>options</td><td><code>*</code></td></tr></tbody>",ot,st,rt,W,lt,F,ct,K,Ft='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',it,O,Kt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",at,dt,pt,S,nt,V,mt,q,Ot="Calls the feature_extractor function with the given input.",ft,ee,St='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',ut,te,Vt="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",_t,ht,Tt,oe,Pt,se,yt,re,qt="Instantiate one of the processor classes of the library from a pretrained model.",Mt,le,eo=`The processor class to instantiate is selected based on the <code>image_processor_type</code> (or <code>feature_extractor_type</code>; legacy)
property of the config object (either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,$t,ce,to='<strong>Kind</strong>: static method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',bt,ie,oo=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>PretrainedProcessorOptions</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,gt,wt,xt,ae,vt,de,jt,pe,so="Additional processor-specific properties.",Jt,ne,ro='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',kt,Ht,Ct,me,Lt,ue,zt;return M=new T({props:{title:"processors",local:"processors",headingTag:"h1"}}),g=new fo({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFjb25zdCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWNvbnN0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">const</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),v=new T({props:{title:"processors.Processor",local:"processorsprocessor",headingTag:"h2"}}),C=new T({props:{title:"new Processor(config, components)",local:"new-processorconfig-components",headingTag:"h3"}}),U=new T({props:{title:"processor.image_processor ⇒ <code> * </code>",local:"processorimageprocessor--code--code",headingTag:"h3"}}),R=new T({props:{title:"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>",local:"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code",headingTag:"h3"}}),Q=new T({props:{title:"processor.feature_extractor ⇒ <code> * </code>",local:"processorfeatureextractor--code--code",headingTag:"h3"}}),Y=new T({props:{title:"processor.apply_chat_template(messages, options) ⇒ <code> * </code>",local:"processorapplychattemplatemessages-options--code--code",headingTag:"h3"}}),F=new T({props:{title:"processor.batch_decode(...args) ⇒ <code> * </code>",local:"processorbatchdecodeargs--code--code",headingTag:"h3"}}),V=new T({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),se=new T({props:{title:"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),de=new T({props:{title:"processors~PreTrainedTokenizer : <code> Object </code>",local:"processorspretrainedtokenizer--code-object-code",headingTag:"h2"}}),me=new uo({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){P=c("meta"),_e=r(),fe=c("p"),he=r(),y=c("a"),Te=r(),p(M.$$.fragment),Pe=r(),$=c("p"),$.textContent=Ut,ye=r(),b=c("p"),b.innerHTML=Et,Me=r(),p(g.$$.fragment),$e=r(),w=c("ul"),w.innerHTML=It,be=r(),ge=c("hr"),we=r(),x=c("a"),xe=r(),p(v.$$.fragment),ve=r(),j=c("p"),j.textContent=Rt,je=r(),J=c("p"),J.innerHTML=Nt,Je=r(),k=c("ul"),k.innerHTML=Bt,ke=r(),He=c("hr"),Ce=r(),H=c("a"),Le=r(),p(C.$$.fragment),ze=r(),L=c("p"),L.textContent=Qt,Ae=r(),z=c("table"),z.innerHTML=Dt,Ue=r(),Ee=c("hr"),Ie=r(),A=c("a"),Re=r(),p(U.$$.fragment),Ne=r(),E=c("p"),E.innerHTML=Zt,Be=r(),Qe=c("hr"),De=r(),I=c("a"),Ze=r(),p(R.$$.fragment),Ye=r(),N=c("p"),N.innerHTML=Yt,Xe=r(),Ge=c("hr"),We=r(),B=c("a"),Fe=r(),p(Q.$$.fragment),Ke=r(),D=c("p"),D.innerHTML=Xt,Oe=r(),Se=c("hr"),Ve=r(),Z=c("a"),qe=r(),p(Y.$$.fragment),et=r(),X=c("p"),X.innerHTML=Gt,tt=r(),G=c("table"),G.innerHTML=Wt,ot=r(),st=c("hr"),rt=r(),W=c("a"),lt=r(),p(F.$$.fragment),ct=r(),K=c("p"),K.innerHTML=Ft,it=r(),O=c("table"),O.innerHTML=Kt,at=r(),dt=c("hr"),pt=r(),S=c("a"),nt=r(),p(V.$$.fragment),mt=r(),q=c("p"),q.textContent=Ot,ft=r(),ee=c("p"),ee.innerHTML=St,ut=r(),te=c("table"),te.innerHTML=Vt,_t=r(),ht=c("hr"),Tt=r(),oe=c("a"),Pt=r(),p(se.$$.fragment),yt=r(),re=c("p"),re.textContent=qt,Mt=r(),le=c("p"),le.innerHTML=eo,$t=r(),ce=c("p"),ce.innerHTML=to,bt=r(),ie=c("table"),ie.innerHTML=oo,gt=r(),wt=c("hr"),xt=r(),ae=c("a"),vt=r(),p(de.$$.fragment),jt=r(),pe=c("p"),pe.textContent=so,Jt=r(),ne=c("p"),ne.innerHTML=ro,kt=r(),Ht=c("hr"),Ct=r(),p(me.$$.fragment),Lt=r(),ue=c("p"),this.h()},l(e){const t=no("svelte-u9bgzb",document.head);P=i(t,"META",{name:!0,content:!0}),t.forEach(o),_e=l(e),fe=i(e,"P",{}),n(fe).forEach(o),he=l(e),y=i(e,"A",{id:!0,class:!0}),n(y).forEach(o),Te=l(e),m(M.$$.fragment,e),Pe=l(e),$=i(e,"P",{"data-svelte-h":!0}),a($)!=="svelte-199vh5q"&&($.textContent=Ut),ye=l(e),b=i(e,"P",{"data-svelte-h":!0}),a(b)!=="svelte-1olsie5"&&(b.innerHTML=Et),Me=l(e),m(g.$$.fragment,e),$e=l(e),w=i(e,"UL",{"data-svelte-h":!0}),a(w)!=="svelte-194f3yo"&&(w.innerHTML=It),be=l(e),ge=i(e,"HR",{}),we=l(e),x=i(e,"A",{id:!0,class:!0}),n(x).forEach(o),xe=l(e),m(v.$$.fragment,e),ve=l(e),j=i(e,"P",{"data-svelte-h":!0}),a(j)!=="svelte-o9f953"&&(j.textContent=Rt),je=l(e),J=i(e,"P",{"data-svelte-h":!0}),a(J)!=="svelte-wmyz1o"&&(J.innerHTML=Nt),Je=l(e),k=i(e,"UL",{"data-svelte-h":!0}),a(k)!=="svelte-il7upz"&&(k.innerHTML=Bt),ke=l(e),He=i(e,"HR",{}),Ce=l(e),H=i(e,"A",{id:!0,class:!0}),n(H).forEach(o),Le=l(e),m(C.$$.fragment,e),ze=l(e),L=i(e,"P",{"data-svelte-h":!0}),a(L)!=="svelte-rj7jmq"&&(L.textContent=Qt),Ae=l(e),z=i(e,"TABLE",{"data-svelte-h":!0}),a(z)!=="svelte-4j8lfj"&&(z.innerHTML=Dt),Ue=l(e),Ee=i(e,"HR",{}),Ie=l(e),A=i(e,"A",{id:!0,class:!0}),n(A).forEach(o),Re=l(e),m(U.$$.fragment,e),Ne=l(e),E=i(e,"P",{"data-svelte-h":!0}),a(E)!=="svelte-gyqxdz"&&(E.innerHTML=Zt),Be=l(e),Qe=i(e,"HR",{}),De=l(e),I=i(e,"A",{id:!0,class:!0}),n(I).forEach(o),Ze=l(e),m(R.$$.fragment,e),Ye=l(e),N=i(e,"P",{"data-svelte-h":!0}),a(N)!=="svelte-ao82kh"&&(N.innerHTML=Yt),Xe=l(e),Ge=i(e,"HR",{}),We=l(e),B=i(e,"A",{id:!0,class:!0}),n(B).forEach(o),Fe=l(e),m(Q.$$.fragment,e),Ke=l(e),D=i(e,"P",{"data-svelte-h":!0}),a(D)!=="svelte-iz9woy"&&(D.innerHTML=Xt),Oe=l(e),Se=i(e,"HR",{}),Ve=l(e),Z=i(e,"A",{id:!0,class:!0}),n(Z).forEach(o),qe=l(e),m(Y.$$.fragment,e),et=l(e),X=i(e,"P",{"data-svelte-h":!0}),a(X)!=="svelte-jg083b"&&(X.innerHTML=Gt),tt=l(e),G=i(e,"TABLE",{"data-svelte-h":!0}),a(G)!=="svelte-1dyy5ym"&&(G.innerHTML=Wt),ot=l(e),st=i(e,"HR",{}),rt=l(e),W=i(e,"A",{id:!0,class:!0}),n(W).forEach(o),lt=l(e),m(F.$$.fragment,e),ct=l(e),K=i(e,"P",{"data-svelte-h":!0}),a(K)!=="svelte-jg083b"&&(K.innerHTML=Ft),it=l(e),O=i(e,"TABLE",{"data-svelte-h":!0}),a(O)!=="svelte-ee7emz"&&(O.innerHTML=Kt),at=l(e),dt=i(e,"HR",{}),pt=l(e),S=i(e,"A",{id:!0,class:!0}),n(S).forEach(o),nt=l(e),m(V.$$.fragment,e),mt=l(e),q=i(e,"P",{"data-svelte-h":!0}),a(q)!=="svelte-zbbm3j"&&(q.textContent=Ot),ft=l(e),ee=i(e,"P",{"data-svelte-h":!0}),a(ee)!=="svelte-kflsb2"&&(ee.innerHTML=St),ut=l(e),te=i(e,"TABLE",{"data-svelte-h":!0}),a(te)!=="svelte-pm1u9z"&&(te.innerHTML=Vt),_t=l(e),ht=i(e,"HR",{}),Tt=l(e),oe=i(e,"A",{id:!0,class:!0}),n(oe).forEach(o),Pt=l(e),m(se.$$.fragment,e),yt=l(e),re=i(e,"P",{"data-svelte-h":!0}),a(re)!=="svelte-jwfdp9"&&(re.textContent=qt),Mt=l(e),le=i(e,"P",{"data-svelte-h":!0}),a(le)!=="svelte-1l7cuz8"&&(le.innerHTML=eo),$t=l(e),ce=i(e,"P",{"data-svelte-h":!0}),a(ce)!=="svelte-vp40qx"&&(ce.innerHTML=to),bt=l(e),ie=i(e,"TABLE",{"data-svelte-h":!0}),a(ie)!=="svelte-fupyjd"&&(ie.innerHTML=oo),gt=l(e),wt=i(e,"HR",{}),xt=l(e),ae=i(e,"A",{id:!0,class:!0}),n(ae).forEach(o),vt=l(e),m(de.$$.fragment,e),jt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),a(pe)!=="svelte-ivm759"&&(pe.textContent=so),Jt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),a(ne)!=="svelte-3xndnt"&&(ne.innerHTML=ro),kt=l(e),Ht=i(e,"HR",{}),Ct=l(e),m(me.$$.fragment,e),Lt=l(e),ue=i(e,"P",{}),n(ue).forEach(o),this.h()},h(){d(P,"name","hf:doc:metadata"),d(P,"content",ho),d(y,"id","module_processors"),d(y,"class","group"),d(x,"id","module_processors.Processor"),d(x,"class","group"),d(H,"id","new_module_processors.Processor_new"),d(H,"class","group"),d(A,"id","module_processors.Processor+image_processor"),d(A,"class","group"),d(I,"id","module_processors.Processor+tokenizer"),d(I,"class","group"),d(B,"id","module_processors.Processor+feature_extractor"),d(B,"class","group"),d(Z,"id","module_processors.Processor+apply_chat_template"),d(Z,"class","group"),d(W,"id","module_processors.Processor+batch_decode"),d(W,"class","group"),d(S,"id","module_processors.Processor+_call"),d(S,"class","group"),d(oe,"id","module_processors.Processor.from_pretrained"),d(oe,"class","group"),d(ae,"id","module_processors..PreTrainedTokenizer"),d(ae,"class","group")},m(e,t){mo(document.head,P),s(e,_e,t),s(e,fe,t),s(e,he,t),s(e,y,t),s(e,Te,t),f(M,e,t),s(e,Pe,t),s(e,$,t),s(e,ye,t),s(e,b,t),s(e,Me,t),f(g,e,t),s(e,$e,t),s(e,w,t),s(e,be,t),s(e,ge,t),s(e,we,t),s(e,x,t),s(e,xe,t),f(v,e,t),s(e,ve,t),s(e,j,t),s(e,je,t),s(e,J,t),s(e,Je,t),s(e,k,t),s(e,ke,t),s(e,He,t),s(e,Ce,t),s(e,H,t),s(e,Le,t),f(C,e,t),s(e,ze,t),s(e,L,t),s(e,Ae,t),s(e,z,t),s(e,Ue,t),s(e,Ee,t),s(e,Ie,t),s(e,A,t),s(e,Re,t),f(U,e,t),s(e,Ne,t),s(e,E,t),s(e,Be,t),s(e,Qe,t),s(e,De,t),s(e,I,t),s(e,Ze,t),f(R,e,t),s(e,Ye,t),s(e,N,t),s(e,Xe,t),s(e,Ge,t),s(e,We,t),s(e,B,t),s(e,Fe,t),f(Q,e,t),s(e,Ke,t),s(e,D,t),s(e,Oe,t),s(e,Se,t),s(e,Ve,t),s(e,Z,t),s(e,qe,t),f(Y,e,t),s(e,et,t),s(e,X,t),s(e,tt,t),s(e,G,t),s(e,ot,t),s(e,st,t),s(e,rt,t),s(e,W,t),s(e,lt,t),f(F,e,t),s(e,ct,t),s(e,K,t),s(e,it,t),s(e,O,t),s(e,at,t),s(e,dt,t),s(e,pt,t),s(e,S,t),s(e,nt,t),f(V,e,t),s(e,mt,t),s(e,q,t),s(e,ft,t),s(e,ee,t),s(e,ut,t),s(e,te,t),s(e,_t,t),s(e,ht,t),s(e,Tt,t),s(e,oe,t),s(e,Pt,t),f(se,e,t),s(e,yt,t),s(e,re,t),s(e,Mt,t),s(e,le,t),s(e,$t,t),s(e,ce,t),s(e,bt,t),s(e,ie,t),s(e,gt,t),s(e,wt,t),s(e,xt,t),s(e,ae,t),s(e,vt,t),f(de,e,t),s(e,jt,t),s(e,pe,t),s(e,Jt,t),s(e,ne,t),s(e,kt,t),s(e,Ht,t),s(e,Ct,t),f(me,e,t),s(e,Lt,t),s(e,ue,t),zt=!0},p:co,i(e){zt||(u(M.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(U.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(V.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),zt=!0)},o(e){_(M.$$.fragment,e),_(g.$$.fragment,e),_(v.$$.fragment,e),_(C.$$.fragment,e),_(U.$$.fragment,e),_(R.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(F.$$.fragment,e),_(V.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),zt=!1},d(e){e&&(o(_e),o(fe),o(he),o(y),o(Te),o(Pe),o($),o(ye),o(b),o(Me),o($e),o(w),o(be),o(ge),o(we),o(x),o(xe),o(ve),o(j),o(je),o(J),o(Je),o(k),o(ke),o(He),o(Ce),o(H),o(Le),o(ze),o(L),o(Ae),o(z),o(Ue),o(Ee),o(Ie),o(A),o(Re),o(Ne),o(E),o(Be),o(Qe),o(De),o(I),o(Ze),o(Ye),o(N),o(Xe),o(Ge),o(We),o(B),o(Fe),o(Ke),o(D),o(Oe),o(Se),o(Ve),o(Z),o(qe),o(et),o(X),o(tt),o(G),o(ot),o(st),o(rt),o(W),o(lt),o(ct),o(K),o(it),o(O),o(at),o(dt),o(pt),o(S),o(nt),o(mt),o(q),o(ft),o(ee),o(ut),o(te),o(_t),o(ht),o(Tt),o(oe),o(Pt),o(yt),o(re),o(Mt),o(le),o($t),o(ce),o(bt),o(ie),o(gt),o(wt),o(xt),o(ae),o(vt),o(jt),o(pe),o(Jt),o(ne),o(kt),o(Ht),o(Ct),o(Lt),o(ue)),o(P),h(M,e),h(g,e),h(v,e),h(C,e),h(U,e),h(R,e),h(Q,e),h(Y,e),h(F,e),h(V,e),h(se,e),h(de,e),h(me,e)}}}const ho='{"title":"processors","local":"processors","sections":[{"title":"processors.Processor","local":"processorsprocessor","sections":[{"title":"new Processor(config, components)","local":"new-processorconfig-components","sections":[],"depth":3},{"title":"processor.image_processor ⇒ <code> * </code>","local":"processorimageprocessor--code--code","sections":[],"depth":3},{"title":"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>","local":"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code","sections":[],"depth":3},{"title":"processor.feature_extractor ⇒ <code> * </code>","local":"processorfeatureextractor--code--code","sections":[],"depth":3},{"title":"processor.apply_chat_template(messages, options) ⇒ <code> * </code>","local":"processorapplychattemplatemessages-options--code--code","sections":[],"depth":3},{"title":"processor.batch_decode(...args) ⇒ <code> * </code>","local":"processorbatchdecodeargs--code--code","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3},{"title":"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~PreTrainedTokenizer : <code> Object </code>","local":"processorspretrainedtokenizer--code-object-code","sections":[],"depth":2}],"depth":1}';function To(At){return io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bo extends ao{constructor(P){super(),po(this,P,To,_o,lo,{})}}export{bo as component};
