import{s as ja,f as Qs,n as ca,o as wa}from"../chunks/scheduler.39a43cde.js";import{S as Ta,i as fa,g as A,s as n,r as p,A as Ja,h as i,f as e,c as a,j as ra,u as M,x as o,k as Ct,y as ua,a as s,v as U,d as r,t as j,w as c}from"../chunks/index.23ec2204.js";import{D as ya,C as w}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as T,E as ma}from"../chunks/EditOnGithub.f2d09226.js";function da(xs){let f,Bt,bt,vt,J,It,u,gt,y,Hs='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Et,m,qs="这个 notebook 主要讲述了你怎么构建一个高级的 RAG，用于回答一个关于特定知识库的问题（这里，是 HuggingFace 文档），使用 LangChain。",Kt,d,Ps='对于 RAG 的介绍，你可以查看<a href="rag_zephyr_langch">这个教程</a>',Vt,R,Gs="RAG 系统是复杂的，它有许多组块:这里画一个简单的 RAG 图表，其中用蓝色标注了所有系统增强的可能性。",Nt,C,Ws,Xt,h,zs="<p>💡 可以看到，这个架构中有许多步骤可以调整：正确调整系统将带来显著的性能提升。</p>",kt,b,Zs="在这个 notebook 中，我们将研究许多这些蓝色标注的部分，看看如何调整你的 RAG 系统以获得最佳性能。",Qt,F,Ls="<strong>让我们深入研究模型架构吧！</strong> 首先，安装所需的模型依赖项。",xt,B,Ht,v,qt,I,Pt,g,Gt,E,Wt,K,zt,V,Zt,N,Ss="<strong>检索器的作用类似于内部搜索引擎</strong>：给定用户查询，它从你的知识库中返回几个相关的片段。",Lt,X,Ds="这些片段随后将被输入到阅读器模型中，以帮助其生成答案。",St,k,Ys="所以 <strong>我们的目标在这里是，给定一个用户问题，从我们的知识库中找到最多的片段来回答这个问题。</strong>",Dt,Q,_s="这是一个宽泛的目标，它留下了一些问题。我们应该检索多少片段？这个参数将被命名为<code>top_k</code>。",Yt,x,Os="这些片段应该有多长？这被称为 <code>chunk size</code> （片段大小）。没有一刀切的答案，但这里有一些要点：",_t,H,$s='<li>🔀 你的 <code>chunk size</code> 允许从一段片段到另一段片段有所不同。</li> <li>由于你的检索中总会存在一些噪音，增加 <code>top_k</code> 可以提高你检索到的片段中包含相关元素的概率。🎯 射更多的箭增加了你命中目标的概率。</li> <li>同时，你检索到的文档的总长度不应过高：例如，对于大多数当前模型来说，16k 个 token 可能会因为<a href="https://huggingface.co/papers/2307.03172" rel="nofollow">中间丢失现象</a>而在信息中淹没你的阅读器模型。🎯 只给你的阅读器模型提供最相关的见解，而不是一堆书！</li>',Ot,q,ln="<p>在这个 notebook 中，我们使用 Langchain 库，因为 <strong>它为向量数据库提供了大量的选项，并允许我们在整个处理过程中保留文档的元数据</strong>。</p>",$t,P,le,G,tn="<li>在这一部分，<strong>我们将知识库中的文档拆分成更小的片段</strong>，这些片段将是喂给阅读器 LLM 生成答案的片段。</li> <li>目标是准备一组<strong>语义上相关的片段</strong>。因此，它们的大小应该适配确切的想法：太小会截断想法，太大则会稀释它们。</li>",te,W,en='💡 <em>对于文本拆分存在许多选项：按单词拆分，按句子边界拆分，递归拆分以树状方式处理文档以保留结构信息… 要了解更多关于拆分的信息，我建议你阅读<a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">这个很棒的 notebook</a>，这是由 Greg Kamradt 编写的。</em>',ee,z,sn="<li><p><strong>递归拆分</strong>使用给定的一组分隔符逐步将文本分解为更小的部分，这些分隔符按从最重要到最不重要的顺序排序。如果第一次拆分没有给出正确大小或形状的片段，该方法会使用不同的分隔符在新的片段上重复自身。例如，使用分隔符列表<code>[&quot;\\n\\n&quot;, &quot;\\n&quot;, &quot;.&quot;, &quot;&quot;]</code>：</p> <ul><li>该方法首先在出现双行中断<code>&quot;\\n\\n&quot;</code>的任何地方拆分文档。</li> <li>结果文档将在简单的行中断<code>&quot;\\n&quot;</code>处再次拆分，然后在句子结尾<code>&quot;.&quot;</code>处拆分。</li> <li>最后，如果有些片段仍然太大，它们将在超过最大大小时拆分。</li></ul></li> <li><p>使用这种方法，整体结构得到了很好的保留，代价是片段大小会有轻微的变化。</p></li>",se,Z,nn='<p><a href="https://huggingface.co/spaces/A-Roucher/chunk_visualizer" rel="nofollow">这个空间</a>让你可视化不同的拆分选项如何影响你得到的片段。</p>',ne,L,an="🔬 让我们用片段大小做一些实验，从任意大小开始，看看拆分是如何工作的。我们使用 Langchain 的 <code>RecursiveCharacterTextSplitter</code> 实现递归拆分。",ae,S,An="<li>参数 <code>chunk_size</code> 控制单个片段的长度：这个长度默认计算为片段中的字符数。</li> <li>参数 <code>chunk_overlap</code> 允许相邻片段彼此有一些重叠。这减少了想法被两个相邻片段之间的拆分切割成两半的概率。我们武断地将这个设置为片段大小的1/10，你可以尝试不同的值！</li>",Ae,D,ie,Y,on="我们还必须记住，当我们嵌入文档时，我们将使用一个接受特定最大序列长度 <code>max_seq_length</code> 的嵌入模型。",oe,_,pn="因此，我们应该确保我们的片段大小低于这个限制，因为任何更长的片段在处理之前都会被截断，从而失去相关性。",pe,O,Me,$,Mn=`Model's maximum sequence length: 512
`,Ue,ll,Un="👀 可以看到，<strong>片段长度与我们的 512 个 token 的限制不匹配</strong>，并且有些文档超出了限制，因此它们的一部分将在截断中丢失！",re,tl,rn="<li>因此，我们应该更改 <code>RecursiveCharacterTextSplitter</code> 类，以计算 token 数量而不是字符数量。</li> <li>然后，我们可以选择一个特定的片段大小，这里我们会选择低于 512 的阈值：<ul><li>较小的文档可能允许拆分更专注于特定想法的内容。</li> <li>但太小的片段会拆分句子，从而再次失去意义：适当的调整是一个平衡的问题。</li></ul></li>",je,el,ce,ht,jn,we,sl,cn="➡️ 现在分块长度分布看起来好多了!",Te,nl,wn="### 1.2 构建向量数据库",fe,al,Tn='我们希望为我们知识库的所有片段计算嵌入向量：要了解更多关于句子嵌入的信息，我们建议阅读<a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/" rel="nofollow">这个指南</a>。',Je,Al,fn="#### 检索的工作原理",ue,il,Jn="一旦所有片段都被嵌入，我们就将它们存储到一个向量数据库中。当用户输入一个查询时，它会被之前使用的同一模型嵌入，并且相似性搜索会返回向量数据库中最接近的文档。",ye,ol,un="因此，技术挑战在于，给定一个查询向量，快速找到向量数据库中这个向量的最近邻。为此，我们需要选择两件事：一个距离度量，以及一个搜索算法，以便在成千上万的记录数据库中快速找到最近邻。",me,pl,yn="##### 最近邻搜索算法",de,Ml,mn='最近邻搜索算法有很多选择：我们选择 Facebook 的 <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a>，因为 FAISS 对于大多数用例来说性能足够好，而且它广为人知，因此被广泛实现。',Re,Ul,dn="##### 距离度量",Ce,rl,Rn='关于距离度量，你可以在<a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/#distance-between-embeddings" rel="nofollow">这里</a>找到一个很好的指南。简而言之：',he,jl,Cn="<li><strong>余弦相似度</strong>计算两个向量之间的相似性，作为它们相对角度的余弦值：它允许我们比较向量的方向，而不考虑它们的幅度。使用它需要对所有向量进行归一化，将它们重新缩放到单位范数。</li> <li><strong>点积</strong>考虑幅度，有时会有不希望的效果，即增加向量的长度会使它与所有其他向量更相似。</li> <li><strong>欧氏距离</strong>是向量末端之间的距离。</li>",be,cl,hn='你可以尝试<a href="https://developers.google.com/machine-learning/clustering/similarity/check-your-understanding" rel="nofollow">这个小测</a>来检查你对这些概念的理解。但是一旦向量被归一化，<a href="https://platform.openai.com/docs/guides/embeddings/which-distance-function-should-i-use" rel="nofollow">选择特定的距离度量并不重要</a>。',Fe,wl,bn="我们的特定模型与余弦相似度配合得很好，所以我们选择这个距离度量，并在嵌入模型中以及 FAISS 索引的 <code>distance_strategy</code> 参数中设置它。使用余弦相似度，我们需要归一化我们的嵌入向量。",Be,Tl,Fn="🚨👇 下面的单元格需要在 A10G 上运行几分钟！",ve,fl,Ie,Jl,Bn="👀 为了可视化搜索最接近的文档，我们使用 PaCMAP 将我们的嵌入向量从 384 维降至 2 维。",ge,ul,vn='💡 <em>我们选择 PaCMAP 而不是其他技术，如 t-SNE 或 UMAP，因为<a href="https://www.nature.com/articles/s42003-022-03628-x#Abs1" rel="nofollow">它效率高（保留局部和全局结构），对初始化参数鲁棒且速度快</a>。</em>',Ee,yl,Ke,ml,Ve,dl,Ne,Rl,In,Xe,Cl,gn="➡️ 在上面的图表中，你可以看到知识库文档的空间表示。由于向量嵌入代表了文档的含义，它们在意义上的接近应该在它们的嵌入的接近程度上反映出来。",ke,hl,En="用户查询的嵌入也被显示出来：我们想要找到意义最接近的 <code>k</code> 个文档，因此我们选择最接近的 <code>k</code> 个向量。",Qe,bl,Kn="在 LangChain 向量数据库实现中，这个搜索操作是由方法 <code>vector_database.similarity_search(query)</code> 执行的。",xe,Fl,Vn="这里是结果：",He,Bl,qe,vl,Nn=`Starting retrieval for user_query='How to create a pipeline object?'...

==================================Top document==================================
\`\`\`

## Available Pipelines:
==================================Metadata==================================
&#123;'source': 'huggingface/diffusers/blob/main/docs/source/en/api/pipelines/deepfloyd_if.md', 'start_index': 16887}
`,Pe,Il,Ge,gl,Xn="在这一部分，<strong>LLM 阅读器读取检索到的上下文以形成其答案。</strong>",We,El,kn="实际上有多个可以调整的子步骤：",ze,Kl,Qn="<li>检索到的文档内容被聚合并放入“上下文”中，这其中有许多处理选项，如<em>提示压缩</em>。</li> <li>上下文和用户查询被聚合并形成一个提示(prompt)，然后交给 LLM 生成其答案。</li>",Ze,Vl,Le,Nl,xn="在选择阅读器模型时，有几个方面很重要：",Se,Xl,Hn="<li>阅读器模型的 <code>max_seq_length</code> 必须适应我们的提示(prompt)，其中包括检索器调用输出的上下文：上下文包括 5 个每份 512 个 token 的文档，所以我们至少需要 4k 个 token 的上下文长度。</li> <li>阅读器模型</li>",De,kl,qn='在这个例子中，我们选择了 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>，这是一个小而强大的模型。',Ye,Ql,Pn='由于每周都会发布许多模型，你可能想要用最新最好的模型替换这个模型。跟踪开源 LLM 的最佳方式是查看 <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>。',_e,xl,Gn="为了加速推理，我们将加载模型的量化版本：",Oe,Hl,$e,ql,ls,Pl,ts,Gl,Wn="下面的 RAG 提示模板是我们将要提供给阅读器 LLM 的内容：需要将其格式化为阅读器 LLM 的聊天模板,这点非常重要。",es,Wl,zn="我们向其提供我们的上下文和用户的问题。",ss,zl,ns,Zl,Zn=`<|system|>
Using the information contained in the context, 
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.
<|user|>
Context:
&#123;context}
---
Now here is the question you need to answer.

Question: &#123;question}
<|assistant|>
`,as,Ll,Ln="让我们在之前检索的文档上测试我们的阅读器!",As,Sl,is,Dl,Sn=`To create a pipeline object, follow these steps:

1. Define the inputs and outputs of your pipeline. These could be strings, dictionaries, or any other format that best suits your use case.

2. Inherit the \`Pipeline\` class from the \`transformers\` module and implement the following methods:

   - \`preprocess\`: This method takes the raw inputs and returns a preprocessed dictionary that can be passed to the model.

   - \`_forward\`: This method performs the actual inference using the model and returns the output tensor.

   - \`postprocess\`: This method takes the output tensor and returns the final output in the desired format.

   - \`_sanitize_parameters\`: This method is used to sanitize the input parameters before passing them to the model.

3. Load the necessary components, such as the model and scheduler, into the pipeline object.

4. Instantiate the pipeline object and return it.

Here's an example implementation based on the given context:

\`\`\`python
from transformers import Pipeline
import torch
from diffusers import StableDiffusionPipeline

class MyPipeline(Pipeline):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.pipe = StableDiffusionPipeline.from_pretrained("my_model")

    def preprocess(self, inputs):
        &num; Preprocess the inputs as needed
        return &#123;"input_ids":...}

    def _forward(self, inputs):
        &num; Run the forward pass of the model
        return self.pipe(**inputs).images[0]

    def postprocess(self, outputs):
        &num; Postprocess the outputs as needed
        return outputs["sample"]

    def _sanitize_parameters(self, params):
        &num; Sanitize the input parameters
        return params

my_pipeline = MyPipeline()
result = my_pipeline("My input string")
print(result)
\`\`\`

Note that this implementation assumes that the model and scheduler are already loaded into memory. If they need to be loaded dynamically, you can modify the \`__init__\` method accordingly.
`,os,Yl,ps,_l,Dn="对于 RAG 来说，通常更好的选择会最终检索出比你想要的更多的文档，然后在保留 <code>top_k</code> 之前，使用更强大的检索模型对结果进行重新排序。",Ms,Ol,Yn='为此，<a href="https://arxiv.org/abs/2112.01488" rel="nofollow">Colbertv2</a>是一个很好的选择：它不是像我们传统的嵌入模型那样的双向编码器，而是一个交叉编码器，它计算查询 token 与每个文档 token 之间更细致的交互。',Us,$l,_n='由于有了 <a href="https://github.com/bclavie/RAGatouille" rel="nofollow">RAGatouille 库</a>，它的使用变得非常简单。',rs,lt,js,tt,cs,et,ws,st,On="让我们看看我们的 RAG 流水线是怎么回答用户的询问的。",Ts,nt,fs,at,$n=`=> Retrieving documents...
`,Js,At,us,it,la=`==================================Answer==================================
To create a pipeline object, follow these steps:

1. Import the \`pipeline\` function from the \`transformers\` module:

   \`\`\`python
   from transformers import pipeline
   \`\`\`

2. Choose the task you want to perform, such as object detection, sentiment analysis, or image generation, and pass it as an argument to the \`pipeline\` function:

   - For object detection:

     \`\`\`python
     >>> object_detector = pipeline('object-detection')
     >>> object_detector(image)
     [&#123;'score': 0.9982201457023621,
       'label':'remote',
       'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
     ...]
     \`\`\`

   - For sentiment analysis:

     \`\`\`python
     >>> classifier = pipeline("sentiment-analysis")
     >>> classifier("This is a great product!")
     &#123;'labels': ['POSITIVE'],'scores': tensor([0.9999], device='cpu', dtype=torch.float32)}
     \`\`\`

   - For image generation:

     \`\`\`python
     >>> image = pipeline(
    ... "stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
    ... ).images[0]
     >>> image
     PILImage mode RGB size 7680x4320 at 0 DPI
     \`\`\`

Note that the exact syntax may vary depending on the specific pipeline being used. Refer to the documentation for more details on how to use each pipeline.

In general, the process involves importing the necessary modules, selecting the desired pipeline task, and passing it to the \`pipeline\` function along with any required arguments. The resulting pipeline object can then be used to perform the selected task on input data.
==================================Source docs==================================
Document 0------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object-detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 1------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object_detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 2------------------------------------------------------------
Start by creating an instance of [\`pipeline\`] and specifying a task you want to use it for. In this guide, you'll use the [\`pipeline\`] for sentiment analysis as an example:

\`\`\`py
>>> from transformers import pipeline

>>> classifier = pipeline("sentiment-analysis")
Document 3------------------------------------------------------------
\`\`\`

## Add the pipeline to 🤗 Transformers

If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the \`pipelines\` submodule
with the code of your pipeline, then add it to the list of tasks defined in \`pipelines/__init__.py\`.

Then you will need to add tests. Create a new file \`tests/test_pipelines_MY_PIPELINE.py\` with examples of the other tests.

The \`run_pipeline_test\` function will be very generic and run on small random models on every possible
architecture as defined by \`model_mapping\` and \`tf_model_mapping\`.

This is very important to test future compatibility, meaning if someone adds a new model for
\`XXXForQuestionAnswering\` then the pipeline test will attempt to run on it. Because the models are random it's
impossible to check for actual values, that's why there is a helper \`ANY\` that will simply attempt to match the
output of the pipeline TYPE.

You also *need* to implement 2 (ideally 4) tests.

- \`test_small_model_pt\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_tf\`.
- \`test_small_model_tf\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_pt\`.
- \`test_large_model_pt\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
- \`test_large_model_tf\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
Document 4------------------------------------------------------------
\`\`\`

2. Pass a prompt to the pipeline to generate an image:

\`\`\`py
image = pipeline(
	"stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
).images[0]
image
`,ys,ot,ta="✅ 现在我们已经拥有了一个完整且性能出色的 RAG 系统。今天的教程就到这里！恭喜你坚持到了最后 🥳",ms,pt,ds,Mt,ea="这并不是旅程的终点！你可以尝试许多步骤来改进你的 RAG 系统。我们建议以迭代的方式进行：对系统进行小的更改，看看哪些可以提升性能。",Rs,Ut,Cs,rt,sa="<li>💬 “你不能改进你没有衡量的模型性能”，甘地说过… 或者至少 Llama2 告诉我他这么说过。无论如何，你绝对应该从衡量性能开始：这意味着构建一个小的评估数据集，然后在评估数据集上监控你的 RAG 系统的性能。</li>",hs,jt,bs,ct,na="🛠️ <strong>你可以使用这些选项来调整结果：</strong>",Fs,wt,aa='<li><p>调整分块方法：</p> <ul><li>片段的大小</li> <li>方法：使用不同的分隔符进行拆分，使用<a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">语义分块</a>…</li></ul></li> <li><p>更改嵌入模型</p></li>',Bs,Tt,Aa="👷‍♀️ <strong>还可以考虑以下事项：</strong>",vs,ft,ia="<li>尝试另一种分块方法，如语义分块</li> <li>更改使用的索引（这里使用的是 FAISS）</li> <li>查询扩展：以略微不同的方式重新构建用户查询以检索更多文档。</li>",Is,Jt,gs,ut,oa="🛠️ <strong>这里你可以尝试以下选项来改善结果：</strong>",Es,yt,pa="<li>调整提示</li> <li>开启/关闭重排序</li> <li>选择一个更强大的阅读器模型</li>",Ks,mt,Ma="💡 <strong>这里有许多选项可以考虑以进一步改善结果：</strong>",Vs,dt,Ua="<li>压缩检索到的上下文，只保留与回答查询最相关的部分。</li> <li>扩展 RAG 系统，使其更加用户友好：<ul><li>引用来源</li> <li>使其能够进行对话</li></ul></li>",Ns,Rt,Xs,Ft,ks;return J=new ya({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/tgi_messages_notebook/notebooks/zh-CN/advanced_rag.ipynb"}]}}),u=new T({props:{title:"使用 LangChain 在 HuggingFace 文档上构建高级 RAG",local:"使用-langchain-在-huggingface-文档上构建高级-rag",headingTag:"h1"}}),B=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdSUyMG9wZW5weXhsJTIwcGFjbWFw",highlighted:"!pip install -q torch transformers transformers accelerate bitsandbytes langchain sentence-transformers faiss-gpu openpyxl pacmap",wrap:!1}}),v=new w({props:{code:"JTI1cmVsb2FkX2V4dCUyMGRvdGVudiUwQSUyNWRvdGVudg==",highlighted:`%reload_ext dotenv
%dotenv`,wrap:!1}}),I=new w({props:{code:"ZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRtJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMExpc3QlMkMlMjBUdXBsZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTIwJTIwJTIzJTIwdGhpcyUyMHdpbGwlMjBiZSUyMGhlbHBmdWwlMjB3aGVuJTIwdmlzdWFsaXppbmclMjByZXRyaWV2ZXIlMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)  <span class="hljs-comment"># this will be helpful when visualizing retriever outputs</span>`,wrap:!1}}),g=new T({props:{title:"加载你的知识基础",local:"加载你的知识基础",headingTag:"h3"}}),E=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),K=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),V=new T({props:{title:"1. 检索器- 嵌入 🗂️",local:"1-检索器--嵌入-",headingTag:"h1"}}),P=new T({props:{title:"1.1 将文档拆分为片段(chuncks)",local:"11-将文档拆分为片段chuncks",headingTag:"h3"}}),D=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBJTIzJTIwV2UlMjB1c2UlMjBhJTIwaGllcmFyY2hpY2FsJTIwbGlzdCUyMG9mJTIwc2VwYXJhdG9ycyUyMHNwZWNpZmljYWxseSUyMHRhaWxvcmVkJTIwZm9yJTIwc3BsaXR0aW5nJTIwTWFya2Rvd24lMjBkb2N1bWVudHMlMEElMjMlMjBUaGlzJTIwbGlzdCUyMGlzJTIwdGFrZW4lMjBmcm9tJTIwTGFuZ0NoYWluJ3MlMjBNYXJrZG93blRleHRTcGxpdHRlciUyMGNsYXNzLiUwQU1BUktET1dOX1NFUEFSQVRPUlMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIzJTdCMSUyQzYlN0QlMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNjAlNjAlNjAlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1QyU1QyolNUMlNUMqJTVDJTVDKiUyQiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuLS0tJTJCJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU1Q25fX18lMkIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTJDJTBBJTVEJTBBJTBBdGV4dF9zcGxpdHRlciUyMCUzRCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciglMEElMjAlMjAlMjAlMjBjaHVua19zaXplJTNEMTAwMCUyQyUyMCUyMCUyMyUyMHRoZSUyMG1heGltdW0lMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjBpbiUyMGElMjBjaHVuayUzQSUyMHdlJTIwc2VsZWN0ZWQlMjB0aGlzJTIwdmFsdWUlMjBhcmJpdHJhcmlseSUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0QxMDAlMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjB0byUyMG92ZXJsYXAlMjBiZXR3ZWVuJTIwY2h1bmtzJTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMElmJTIwJTYwVHJ1ZSU2MCUyQyUyMGluY2x1ZGVzJTIwY2h1bmsncyUyMHN0YXJ0JTIwaW5kZXglMjBpbiUyMG1ldGFkYXRhJTBBJTIwJTIwJTIwJTIwc3RyaXBfd2hpdGVzcGFjZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBJZiUyMCU2MFRydWUlNjAlMkMlMjBzdHJpcHMlMjB3aGl0ZXNwYWNlJTIwZnJvbSUyMHRoZSUyMHN0YXJ0JTIwYW5kJTIwZW5kJTIwb2YlMjBldmVyeSUyMGRvY3VtZW50JTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRE1BUktET1dOX1NFUEFSQVRPUlMlMkMlMEEpJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBkb2MlMjBpbiUyMFJBV19LTk9XTEVER0VfQkFTRSUzQSUwQSUyMCUyMCUyMCUyMGRvY3NfcHJvY2Vzc2VkJTIwJTJCJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoJTVCZG9jJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

<span class="hljs-comment"># We use a hierarchical list of separators specifically tailored for splitting Markdown documents</span>
<span class="hljs-comment"># This list is taken from LangChain&#x27;s MarkdownTextSplitter class.</span>
MARKDOWN_SEPARATORS = [
    <span class="hljs-string">&quot;\\n#{1,6} &quot;</span>,
    <span class="hljs-string">&quot;\`\`\`\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\\\*\\\\*\\\\*+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n---+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n___+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n&quot;</span>,
    <span class="hljs-string">&quot; &quot;</span>,
    <span class="hljs-string">&quot;&quot;</span>,
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># the maximum number of characters in a chunk: we selected this value arbitrarily</span>
    chunk_overlap=<span class="hljs-number">100</span>,  <span class="hljs-comment"># the number of characters to overlap between chunks</span>
    add_start_index=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, includes chunk&#x27;s start index in metadata</span>
    strip_whitespace=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, strips whitespace from the start and end of every document</span>
    separators=MARKDOWN_SEPARATORS,
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> RAW_KNOWLEDGE_BASE:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),O=new w({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBUbyUyMGdldCUyMHRoZSUyMHZhbHVlJTIwb2YlMjB0aGUlMjBtYXglMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjB3ZSUyMHdpbGwlMjBxdWVyeSUyMHRoZSUyMHVuZGVybHlpbmclMjAlNjBTZW50ZW5jZVRyYW5zZm9ybWVyJTYwJTIwb2JqZWN0JTIwdXNlZCUyMGluJTIwdGhlJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyLiUwQXByaW50KGYlMjJNb2RlbCdzJTIwbWF4aW11bSUyMHNlcXVlbmNlJTIwbGVuZ3RoJTNBJTIwJTdCU2VudGVuY2VUcmFuc2Zvcm1lcigndGhlbmxwZXIlMkZndGUtc21hbGwnKS5tYXhfc2VxX2xlbmd0aCU3RCUyMiklMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQWxlbmd0aHMlMjAlM0QlMjAlNUJsZW4odG9rZW5pemVyLmVuY29kZShkb2MucGFnZV9jb250ZW50KSklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZG9jc19wcm9jZXNzZWQpJTVEJTBBJTBBJTIzJTIwUGxvdCUyMHRoZSUyMGRpc3RydWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTJDJTIwY291bnRlZCUyMGFzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjB0b2tlbnMlMEFmaWclMjAlM0QlMjBwZC5TZXJpZXMobGVuZ3RocykuaGlzdCgpJTBBcGx0LnRpdGxlKCUyMkRpc3RyaWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTIwaW4lMjB0aGUlMjBrbm93bGVkZ2UlMjBiYXNlJTIwKGluJTIwY291bnQlMjBvZiUyMHRva2VucyklMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To get the value of the max sequence_length, we will query the underlying \`SentenceTransformer\` object used in the RecursiveCharacterTextSplitter.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model&#x27;s maximum sequence length: <span class="hljs-subst">{SentenceTransformer(<span class="hljs-string">&#x27;thenlper/gte-small&#x27;</span>).max_seq_length}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot the distrubution of document lengths, counted as the number of tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),el=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>EMBEDDING_MODEL_NAME = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
<span class="hljs-meta">... </span>    chunk_size: <span class="hljs-built_in">int</span>,
<span class="hljs-meta">... </span>    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
<span class="hljs-meta">... </span>    tokenizer_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = EMBEDDING_MODEL_NAME,
<span class="hljs-meta">... </span></span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Split documents into chunks of maximum size \`chunk_size\` tokens and return a list of documents.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>        AutoTokenizer.from_pretrained(tokenizer_name),
<span class="hljs-meta">... </span>        chunk_size=chunk_size,
<span class="hljs-meta">... </span>        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
<span class="hljs-meta">... </span>        add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        separators=MARKDOWN_SEPARATORS,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    docs_processed = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
<span class="hljs-meta">... </span>        docs_processed += text_splitter.split_documents([doc])

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Remove duplicates</span>
<span class="hljs-meta">... </span>    unique_texts = {}
<span class="hljs-meta">... </span>    docs_processed_unique = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed_unique.append(doc)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> docs_processed_unique


<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = split_documents(
<span class="hljs-meta">... </span>    <span class="hljs-number">512</span>,  <span class="hljs-comment"># We choose a chunk size adapted to our model</span>
<span class="hljs-meta">... </span>    RAW_KNOWLEDGE_BASE,
<span class="hljs-meta">... </span>    tokenizer_name=EMBEDDING_MODEL_NAME,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s visualize the chunk sizes we would have in tokens from a common model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(EMBEDDING_MODEL_NAME)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),fl=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS52ZWN0b3JzdG9yZXMudXRpbHMlMjBpbXBvcnQlMjBEaXN0YW5jZVN0cmF0ZWd5JTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RFTUJFRERJTkdfTU9ERUxfTkFNRSUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX3Byb2Nlc3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3VkYSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZV9rd2FyZ3MlM0QlN0IlMjJub3JtYWxpemVfZW1iZWRkaW5ncyUyMiUzQSUyMFRydWUlN0QlMkMlMjAlMjAlMjMlMjBzZXQlMjBUcnVlJTIwZm9yJTIwY29zaW5lJTIwc2ltaWxhcml0eSUwQSklMEElMEFLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoJTBBJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmdfbW9kZWwlMkMlMjBkaXN0YW5jZV9zdHJhdGVneSUzRERpc3RhbmNlU3RyYXRlZ3kuQ09TSU5FJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

embedding_model = HuggingFaceEmbeddings(
    model_name=EMBEDDING_MODEL_NAME,
    multi_process=<span class="hljs-literal">True</span>,
    model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
    encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># set True for cosine similarity</span>
)

KNOWLEDGE_VECTOR_DATABASE = FAISS.from_documents(
    docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
)`,wrap:!1}}),yl=new w({props:{code:"JTIzJTIwZW1iZWQlMjBhJTIwdXNlciUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBzYW1lJTIwc3BhY2UlMEF1c2VyX3F1ZXJ5JTIwJTNEJTIwJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMEFxdWVyeV92ZWN0b3IlMjAlM0QlMjBlbWJlZGRpbmdfbW9kZWwuZW1iZWRfcXVlcnkodXNlcl9xdWVyeSk=",highlighted:`<span class="hljs-comment"># embed a user query in the same space</span>
user_query = <span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>
query_vector = embedding_model.embed_query(user_query)`,wrap:!1}}),ml=new w({props:{code:"aW1wb3J0JTIwcGFjbWFwJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBZW1iZWRkaW5nX3Byb2plY3RvciUyMCUzRCUyMHBhY21hcC5QYUNNQVAobl9jb21wb25lbnRzJTNEMiUyQyUyMG5fbmVpZ2hib3JzJTNETm9uZSUyQyUyME1OX3JhdGlvJTNEMC41JTJDJTIwRlBfcmF0aW8lM0QyLjAlMkMlMjByYW5kb21fc3RhdGUlM0QxKSUwQSUwQWVtYmVkZGluZ3NfMmQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBsaXN0KEtOT1dMRURHRV9WRUNUT1JfREFUQUJBU0UuaW5kZXgucmVjb25zdHJ1Y3RfbihpZHglMkMlMjAxKSU1QjAlNUQpJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZShsZW4oZG9jc19wcm9jZXNzZWQpKSUwQSU1RCUyMCUyQiUyMCU1QnF1ZXJ5X3ZlY3RvciU1RCUwQSUwQSUyMyUyMGZpdCUyMHRoZSUyMGRhdGElMjAoVGhlJTIwaW5kZXglMjBvZiUyMHRyYW5zZm9ybWVkJTIwZGF0YSUyMGNvcnJlc3BvbmRzJTIwdG8lMjB0aGUlMjBpbmRleCUyMG9mJTIwdGhlJTIwb3JpZ2luYWwlMjBkYXRhKSUwQWRvY3VtZW50c19wcm9qZWN0ZWQlMjAlM0QlMjBlbWJlZGRpbmdfcHJvamVjdG9yLmZpdF90cmFuc2Zvcm0obnAuYXJyYXkoZW1iZWRkaW5nc18yZCklMkMlMjBpbml0JTNEJTIycGNhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pacmap
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

embedding_projector = pacmap.PaCMAP(n_components=<span class="hljs-number">2</span>, n_neighbors=<span class="hljs-literal">None</span>, MN_ratio=<span class="hljs-number">0.5</span>, FP_ratio=<span class="hljs-number">2.0</span>, random_state=<span class="hljs-number">1</span>)

embeddings_2d = [
    <span class="hljs-built_in">list</span>(KNOWLEDGE_VECTOR_DATABASE.index.reconstruct_n(idx, <span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
] + [query_vector]

<span class="hljs-comment"># fit the data (The index of transformed data corresponds to the index of the original data)</span>
documents_projected = embedding_projector.fit_transform(np.array(embeddings_2d), init=<span class="hljs-string">&quot;pca&quot;</span>)`,wrap:!1}}),dl=new w({props:{code:"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",highlighted:`df = pd.DataFrame.from_dict(
    [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[i, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[i, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: docs_processed[i].metadata[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;extract&quot;</span>: docs_processed[i].page_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;circle&quot;</span>,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">4</span>,
        }
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
    ]
    + [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;User query&quot;</span>,
            <span class="hljs-string">&quot;extract&quot;</span>: user_query,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">100</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;star&quot;</span>,
        }
    ]
)

<span class="hljs-comment"># visualize the embedding</span>
fig = px.scatter(
    df,
    x=<span class="hljs-string">&quot;x&quot;</span>,
    y=<span class="hljs-string">&quot;y&quot;</span>,
    color=<span class="hljs-string">&quot;source&quot;</span>,
    hover_data=<span class="hljs-string">&quot;extract&quot;</span>,
    size=<span class="hljs-string">&quot;size_col&quot;</span>,
    symbol=<span class="hljs-string">&quot;symbol&quot;</span>,
    color_discrete_map={<span class="hljs-string">&quot;User query&quot;</span>: <span class="hljs-string">&quot;black&quot;</span>},
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">700</span>,
)
fig.update_traces(marker=<span class="hljs-built_in">dict</span>(opacity=<span class="hljs-number">1</span>, line=<span class="hljs-built_in">dict</span>(width=<span class="hljs-number">0</span>, color=<span class="hljs-string">&quot;DarkSlateGrey&quot;</span>)), selector=<span class="hljs-built_in">dict</span>(mode=<span class="hljs-string">&quot;markers&quot;</span>))
fig.update_layout(
    legend_title_text=<span class="hljs-string">&quot;&lt;b&gt;Chunk source&lt;/b&gt;&quot;</span>,
    title=<span class="hljs-string">&quot;&lt;b&gt;2D Projection of Chunk Embeddings via PaCMAP&lt;/b&gt;&quot;</span>,
)
fig.show()`,wrap:!1}}),Bl=new w({props:{code:"cHJpbnQoZiUyMiU1Q25TdGFydGluZyUyMHJldHJpZXZhbCUyMGZvciUyMCU3QnVzZXJfcXVlcnklM0QlN0QuLi4lMjIpJTBBcmV0cmlldmVkX2RvY3MlMjAlM0QlMjBLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFLnNpbWlsYXJpdHlfc2VhcmNoKHF1ZXJ5JTNEdXNlcl9xdWVyeSUyQyUyMGslM0Q1KSUwQXByaW50KCUyMiU1Q24lM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0RUb3AlMjBkb2N1bWVudCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFwcmludChyZXRyaWV2ZWRfZG9jcyU1QjAlNUQucGFnZV9jb250ZW50KSUwQXByaW50KCUyMiUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRE1ldGFkYXRhJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KHJldHJpZXZlZF9kb2NzJTVCMCU1RC5tZXRhZGF0YSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStarting retrieval for <span class="hljs-subst">{user_query=}</span>...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs = KNOWLEDGE_VECTOR_DATABASE.similarity_search(query=user_query, k=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n==================================Top document==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].page_content)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Metadata==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].metadata)`,wrap:!1}}),Il=new T({props:{title:"2. 阅读器- LLM 💬",local:"2-阅读器--llm-",headingTag:"h1"}}),Vl=new T({props:{title:"2.1. 阅读器模型",local:"21-阅读器模型",headingTag:"h3"}}),Hl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBUkVBREVSX01PREVMX05BTUUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoUkVBREVSX01PREVMX05BTUUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChSRUFERVJfTU9ERUxfTkFNRSklMEElMEFSRUFERVJfTExNJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

READER_MODEL_NAME = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)
model = AutoModelForCausalLM.from_pretrained(READER_MODEL_NAME, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(READER_MODEL_NAME)

READER_LLM = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.2</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">500</span>,
)`,wrap:!1}}),ql=new w({props:{code:"UkVBREVSX0xMTSglMjJXaGF0JTIwaXMlMjA0JTJCNCUzRiUyMEFuc3dlciUzQSUyMik=",highlighted:'READER_LLM(<span class="hljs-string">&quot;What is 4+4? Answer:&quot;</span>)',wrap:!1}}),Pl=new T({props:{title:"2.2. 提示(Prompt)",local:"22-提示prompt",headingTag:"h3"}}),zl=new w({props:{code:"cHJvbXB0X2luX2NoYXRfZm9ybWF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJVc2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwY29udGFpbmVkJTIwaW4lMjB0aGUlMjBjb250ZXh0JTJDJTBBZ2l2ZSUyMGElMjBjb21wcmVoZW5zaXZlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbi4lMEFSZXNwb25kJTIwb25seSUyMHRvJTIwdGhlJTIwcXVlc3Rpb24lMjBhc2tlZCUyQyUyMHJlc3BvbnNlJTIwc2hvdWxkJTIwYmUlMjBjb25jaXNlJTIwYW5kJTIwcmVsZXZhbnQlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVByb3ZpZGUlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHRoZSUyMHNvdXJjZSUyMGRvY3VtZW50JTIwd2hlbiUyMHJlbGV2YW50LiUwQUlmJTIwdGhlJTIwYW5zd2VyJTIwY2Fubm90JTIwYmUlMjBkZWR1Y2VkJTIwZnJvbSUyMHRoZSUyMGNvbnRleHQlMkMlMjBkbyUyMG5vdCUyMGdpdmUlMjBhbiUyMGFuc3dlci4lMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJDb250ZXh0JTNBJTBBJTdCY29udGV4dCU3RCUwQS0tLSUwQU5vdyUyMGhlcmUlMjBpcyUyMHRoZSUyMHF1ZXN0aW9uJTIweW91JTIwbmVlZCUyMHRvJTIwYW5zd2VyLiUwQSUwQVF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFSQUdfUFJPTVBUX1RFTVBMQVRFJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2luX2NoYXRfZm9ybWF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBcHJpbnQoUkFHX1BST01QVF9URU1QTEFURSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_in_chat_format = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Using the information contained in the context,
<span class="hljs-meta">... </span>give a comprehensive answer to the question.
<span class="hljs-meta">... </span>Respond only to the question asked, response should be concise and relevant to the question.
<span class="hljs-meta">... </span>Provide the number of the source document when relevant.
<span class="hljs-meta">... </span>If the answer cannot be deduced from the context, do not give an answer.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Context:
<span class="hljs-meta">... </span>{context}
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>Now here is the question you need to answer.

<span class="hljs-meta">... </span>Question: {question}&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>RAG_PROMPT_TEMPLATE = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>    prompt_in_chat_format, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(RAG_PROMPT_TEMPLATE)`,wrap:!1}}),Sl=new w({props:{code:"cmV0cmlldmVkX2RvY3NfdGV4dCUyMCUzRCUyMCU1QmRvYy5wYWdlX2NvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMHJldHJpZXZlZF9kb2NzJTVEJTIwJTIwJTIzJTIwd2UlMjBvbmx5JTIwbmVlZCUyMHRoZSUyMHRleHQlMjBvZiUyMHRoZSUyMGRvY3VtZW50cyUwQWNvbnRleHQlMjAlM0QlMjAlMjIlNUNuRXh0cmFjdGVkJTIwZG9jdW1lbnRzJTNBJTVDbiUyMiUwQWNvbnRleHQlMjAlMkIlM0QlMjAlMjIlMjIuam9pbiglNUJmJTIyRG9jdW1lbnQlMjAlN0JzdHIoaSklN0QlM0ElM0ElM0ElNUNuJTIyJTIwJTJCJTIwZG9jJTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKHJldHJpZXZlZF9kb2NzX3RleHQpJTVEKSUwQSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMFJBR19QUk9NUFRfVEVNUExBVEUuZm9ybWF0KHF1ZXN0aW9uJTNEJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMkMlMjBjb250ZXh0JTNEY29udGV4dCklMEElMEElMjMlMjBSZWRhY3QlMjBhbiUyMGFuc3dlciUwQWFuc3dlciUyMCUzRCUyMFJFQURFUl9MTE0oZmluYWxfcHJvbXB0KSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQXByaW50KGFuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs_text = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> retrieved_docs]  <span class="hljs-comment"># we only need the text of the documents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(retrieved_docs_text)])

<span class="hljs-meta">&gt;&gt;&gt; </span>final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=<span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>, context=context)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Redact an answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>answer = READER_LLM(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),Yl=new T({props:{title:"2.3. 重排序(rerank)",local:"23-重排序rerank",headingTag:"h3"}}),lt=new w({props:{code:"ZnJvbSUyMHJhZ2F0b3VpbGxlJTIwaW1wb3J0JTIwUkFHUHJldHJhaW5lZE1vZGVsJTBBJTBBUkVSQU5LRVIlMjAlM0QlMjBSQUdQcmV0cmFpbmVkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNvbGJlcnQtaXIlMkZjb2xiZXJ0djIuMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel

RERANKER = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>)`,wrap:!1}}),tt=new T({props:{title:"3. 集成所有组件",local:"3-集成所有组件",headingTag:"h1"}}),et=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwYW5zd2VyX3dpdGhfcmFnKCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwc3RyJTJDJTBBJTIwJTIwJTIwJTIwbGxtJTNBJTIwUGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBrbm93bGVkZ2VfaW5kZXglM0ElMjBGQUlTUyUyQyUwQSUyMCUyMCUyMCUyMHJlcmFua2VyJTNBJTIwT3B0aW9uYWwlNUJSQUdQcmV0cmFpbmVkTW9kZWwlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3JldHJpZXZlZF9kb2NzJTNBJTIwaW50JTIwJTNEJTIwMzAlMkMlMEElMjAlMjAlMjAlMjBudW1fZG9jc19maW5hbCUzQSUyMGludCUyMCUzRCUyMDUlMkMlMEEpJTIwLSUzRSUyMFR1cGxlJTVCc3RyJTJDJTIwTGlzdCU1QkxhbmdjaGFpbkRvY3VtZW50JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2F0aGVyJTIwZG9jdW1lbnRzJTIwd2l0aCUyMHJldHJpZXZlciUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiUzRCUzRSUyMFJldHJpZXZpbmclMjBkb2N1bWVudHMuLi4lMjIpJTBBJTIwJTIwJTIwJTIwcmVsZXZhbnRfZG9jcyUyMCUzRCUyMGtub3dsZWRnZV9pbmRleC5zaW1pbGFyaXR5X3NlYXJjaChxdWVyeSUzRHF1ZXN0aW9uJTJDJTIwayUzRG51bV9yZXRyaWV2ZWRfZG9jcyklMEElMjAlMjAlMjAlMjByZWxldmFudF9kb2NzJTIwJTNEJTIwJTVCZG9jLnBhZ2VfY29udGVudCUyMGZvciUyMGRvYyUyMGluJTIwcmVsZXZhbnRfZG9jcyU1RCUyMCUyMCUyMyUyMGtlZXAlMjBvbmx5JTIwdGhlJTIwdGV4dCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME9wdGlvbmFsbHklMjByZXJhbmslMjByZXN1bHRzJTBBJTIwJTIwJTIwJTIwaWYlMjByZXJhbmtlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiUzRCUzRSUyMFJlcmFua2luZyUyMGRvY3VtZW50cy4uLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWxldmFudF9kb2NzJTIwJTNEJTIwcmVyYW5rZXIucmVyYW5rKHF1ZXN0aW9uJTJDJTIwcmVsZXZhbnRfZG9jcyUyQyUyMGslM0RudW1fZG9jc19maW5hbCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWxldmFudF9kb2NzJTIwJTNEJTIwJTVCZG9jJTVCJTIyY29udGVudCUyMiU1RCUyMGZvciUyMGRvYyUyMGluJTIwcmVsZXZhbnRfZG9jcyU1RCUwQSUwQSUyMCUyMCUyMCUyMHJlbGV2YW50X2RvY3MlMjAlM0QlMjByZWxldmFudF9kb2NzJTVCJTNBbnVtX2RvY3NfZmluYWwlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBCdWlsZCUyMHRoZSUyMGZpbmFsJTIwcHJvbXB0JTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMCUyMiU1Q25FeHRyYWN0ZWQlMjBkb2N1bWVudHMlM0ElNUNuJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUyQiUzRCUyMCUyMiUyMi5qb2luKCU1QmYlMjJEb2N1bWVudCUyMCU3QnN0cihpKSU3RCUzQSUzQSUzQSU1Q24lMjIlMjAlMkIlMjBkb2MlMjBmb3IlMjBpJTJDJTIwZG9jJTIwaW4lMjBlbnVtZXJhdGUocmVsZXZhbnRfZG9jcyklNUQpJTBBJTBBJTIwJTIwJTIwJTIwZmluYWxfcHJvbXB0JTIwJTNEJTIwUkFHX1BST01QVF9URU1QTEFURS5mb3JtYXQocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlZGFjdCUyMGFuJTIwYW5zd2VyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTNEJTNFJTIwR2VuZXJhdGluZyUyMGFuc3dlci4uLiUyMiklMEElMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjBsbG0oZmluYWxfcHJvbXB0KSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGFuc3dlciUyQyUyMHJlbGV2YW50X2RvY3M=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: Pipeline,
    knowledge_index: FAISS,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-comment"># Gather documents with retriever</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Retrieving documents...&quot;</span>)
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Reranking documents...&quot;</span>)
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Generating answer...&quot;</span>)
    answer = llm(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),nt=new w({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJob3clMjB0byUyMGNyZWF0ZSUyMGElMjBwaXBlbGluZSUyMG9iamVjdCUzRiUyMiUwQSUwQWFuc3dlciUyQyUyMHJlbGV2YW50X2RvY3MlMjAlM0QlMjBhbnN3ZXJfd2l0aF9yYWcocXVlc3Rpb24lMkMlMjBSRUFERVJfTExNJTJDJTIwS05PV0xFREdFX1ZFQ1RPUl9EQVRBQkFTRSUyQyUyMHJlcmFua2VyJTNEUkVSQU5LRVIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;how to create a pipeline object?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>answer, relevant_docs = answer_with_rag(question, READER_LLM, KNOWLEDGE_VECTOR_DATABASE, reranker=RERANKER)`,wrap:!1}}),At=new w({props:{code:"cHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEQW5zd2VyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KGYlMjIlN0JhbnN3ZXIlN0QlMjIpJTBBcHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEU291cmNlJTIwZG9jcyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFmb3IlMjBpJTJDJTIwZG9jJTIwaW4lMjBlbnVtZXJhdGUocmVsZXZhbnRfZG9jcyklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyRG9jdW1lbnQlMjAlN0JpJTdELS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGRvYyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Answer==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{answer}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Source docs==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Document <span class="hljs-subst">{i}</span>------------------------------------------------------------&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(doc)`,wrap:!1}}),pt=new T({props:{title:"进一步探索 🗺️",local:"进一步探索-",headingTag:"h1"}}),Ut=new T({props:{title:"设置评估流水线",local:"设置评估流水线",headingTag:"h3"}}),jt=new T({props:{title:"改进检索器",local:"改进检索器",headingTag:"h3"}}),Jt=new T({props:{title:"改进阅读器",local:"改进阅读器",headingTag:"h3"}}),Rt=new ma({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/advanced_rag.md"}}),{c(){f=A("meta"),Bt=n(),bt=A("p"),vt=n(),p(J.$$.fragment),It=n(),p(u.$$.fragment),gt=n(),y=A("p"),y.innerHTML=Hs,Et=n(),m=A("p"),m.textContent=qs,Kt=n(),d=A("p"),d.innerHTML=Ps,Vt=n(),R=A("p"),R.textContent=Gs,Nt=n(),C=A("img"),Xt=n(),h=A("blockquote"),h.innerHTML=zs,kt=n(),b=A("p"),b.textContent=Zs,Qt=n(),F=A("p"),F.innerHTML=Ls,xt=n(),p(B.$$.fragment),Ht=n(),p(v.$$.fragment),qt=n(),p(I.$$.fragment),Pt=n(),p(g.$$.fragment),Gt=n(),p(E.$$.fragment),Wt=n(),p(K.$$.fragment),zt=n(),p(V.$$.fragment),Zt=n(),N=A("p"),N.innerHTML=Ss,Lt=n(),X=A("p"),X.textContent=Ds,St=n(),k=A("p"),k.innerHTML=Ys,Dt=n(),Q=A("p"),Q.innerHTML=_s,Yt=n(),x=A("p"),x.innerHTML=Os,_t=n(),H=A("ul"),H.innerHTML=$s,Ot=n(),q=A("blockquote"),q.innerHTML=ln,$t=n(),p(P.$$.fragment),le=n(),G=A("ul"),G.innerHTML=tn,te=n(),W=A("p"),W.innerHTML=en,ee=n(),z=A("ul"),z.innerHTML=sn,se=n(),Z=A("blockquote"),Z.innerHTML=nn,ne=n(),L=A("p"),L.innerHTML=an,ae=n(),S=A("ul"),S.innerHTML=An,Ae=n(),p(D.$$.fragment),ie=n(),Y=A("p"),Y.innerHTML=on,oe=n(),_=A("p"),_.textContent=pn,pe=n(),p(O.$$.fragment),Me=n(),$=A("pre"),$.textContent=Mn,Ue=n(),ll=A("p"),ll.innerHTML=Un,re=n(),tl=A("ul"),tl.innerHTML=rn,je=n(),p(el.$$.fragment),ce=n(),ht=A("img"),we=n(),sl=A("p"),sl.textContent=cn,Te=n(),nl=A("p"),nl.textContent=wn,fe=n(),al=A("p"),al.innerHTML=Tn,Je=n(),Al=A("p"),Al.textContent=fn,ue=n(),il=A("p"),il.textContent=Jn,ye=n(),ol=A("p"),ol.textContent=un,me=n(),pl=A("p"),pl.textContent=yn,de=n(),Ml=A("p"),Ml.innerHTML=mn,Re=n(),Ul=A("p"),Ul.textContent=dn,Ce=n(),rl=A("p"),rl.innerHTML=Rn,he=n(),jl=A("ul"),jl.innerHTML=Cn,be=n(),cl=A("p"),cl.innerHTML=hn,Fe=n(),wl=A("p"),wl.innerHTML=bn,Be=n(),Tl=A("p"),Tl.textContent=Fn,ve=n(),p(fl.$$.fragment),Ie=n(),Jl=A("p"),Jl.textContent=Bn,ge=n(),ul=A("p"),ul.innerHTML=vn,Ee=n(),p(yl.$$.fragment),Ke=n(),p(ml.$$.fragment),Ve=n(),p(dl.$$.fragment),Ne=n(),Rl=A("img"),Xe=n(),Cl=A("p"),Cl.textContent=gn,ke=n(),hl=A("p"),hl.innerHTML=En,Qe=n(),bl=A("p"),bl.innerHTML=Kn,xe=n(),Fl=A("p"),Fl.textContent=Vn,He=n(),p(Bl.$$.fragment),qe=n(),vl=A("pre"),vl.textContent=Nn,Pe=n(),p(Il.$$.fragment),Ge=n(),gl=A("p"),gl.innerHTML=Xn,We=n(),El=A("p"),El.textContent=kn,ze=n(),Kl=A("ol"),Kl.innerHTML=Qn,Ze=n(),p(Vl.$$.fragment),Le=n(),Nl=A("p"),Nl.textContent=xn,Se=n(),Xl=A("ul"),Xl.innerHTML=Hn,De=n(),kl=A("p"),kl.innerHTML=qn,Ye=n(),Ql=A("p"),Ql.innerHTML=Pn,_e=n(),xl=A("p"),xl.textContent=Gn,Oe=n(),p(Hl.$$.fragment),$e=n(),p(ql.$$.fragment),ls=n(),p(Pl.$$.fragment),ts=n(),Gl=A("p"),Gl.textContent=Wn,es=n(),Wl=A("p"),Wl.textContent=zn,ss=n(),p(zl.$$.fragment),ns=n(),Zl=A("pre"),Zl.textContent=Zn,as=n(),Ll=A("p"),Ll.textContent=Ln,As=n(),p(Sl.$$.fragment),is=n(),Dl=A("pre"),Dl.textContent=Sn,os=n(),p(Yl.$$.fragment),ps=n(),_l=A("p"),_l.innerHTML=Dn,Ms=n(),Ol=A("p"),Ol.innerHTML=Yn,Us=n(),$l=A("p"),$l.innerHTML=_n,rs=n(),p(lt.$$.fragment),js=n(),p(tt.$$.fragment),cs=n(),p(et.$$.fragment),ws=n(),st=A("p"),st.textContent=On,Ts=n(),p(nt.$$.fragment),fs=n(),at=A("pre"),at.textContent=$n,Js=n(),p(At.$$.fragment),us=n(),it=A("pre"),it.textContent=la,ys=n(),ot=A("p"),ot.textContent=ta,ms=n(),p(pt.$$.fragment),ds=n(),Mt=A("p"),Mt.textContent=ea,Rs=n(),p(Ut.$$.fragment),Cs=n(),rt=A("ul"),rt.innerHTML=sa,hs=n(),p(jt.$$.fragment),bs=n(),ct=A("p"),ct.innerHTML=na,Fs=n(),wt=A("ul"),wt.innerHTML=aa,Bs=n(),Tt=A("p"),Tt.innerHTML=Aa,vs=n(),ft=A("ul"),ft.innerHTML=ia,Is=n(),p(Jt.$$.fragment),gs=n(),ut=A("p"),ut.innerHTML=oa,Es=n(),yt=A("ul"),yt.innerHTML=pa,Ks=n(),mt=A("p"),mt.innerHTML=Ma,Vs=n(),dt=A("ul"),dt.innerHTML=Ua,Ns=n(),p(Rt.$$.fragment),Xs=n(),Ft=A("p"),this.h()},l(l){const t=Ja("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(e),Bt=a(l),bt=i(l,"P",{}),ra(bt).forEach(e),vt=a(l),M(J.$$.fragment,l),It=a(l),M(u.$$.fragment,l),gt=a(l),y=i(l,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1ouqjzx"&&(y.innerHTML=Hs),Et=a(l),m=i(l,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1y8o57u"&&(m.textContent=qs),Kt=a(l),d=i(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-cgsx28"&&(d.innerHTML=Ps),Vt=a(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-45g62z"&&(R.textContent=Gs),Nt=a(l),C=i(l,"IMG",{src:!0,height:!0}),Xt=a(l),h=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(h)!=="svelte-oiyp3w"&&(h.innerHTML=zs),kt=a(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1c77kj2"&&(b.textContent=Zs),Qt=a(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-16f9kjd"&&(F.innerHTML=Ls),xt=a(l),M(B.$$.fragment,l),Ht=a(l),M(v.$$.fragment,l),qt=a(l),M(I.$$.fragment,l),Pt=a(l),M(g.$$.fragment,l),Gt=a(l),M(E.$$.fragment,l),Wt=a(l),M(K.$$.fragment,l),zt=a(l),M(V.$$.fragment,l),Zt=a(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ql0xxw"&&(N.innerHTML=Ss),Lt=a(l),X=i(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-79k71u"&&(X.textContent=Ds),St=a(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-gfu2zq"&&(k.innerHTML=Ys),Dt=a(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-c8pzbv"&&(Q.innerHTML=_s),Yt=a(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1ylwvta"&&(x.innerHTML=Os),_t=a(l),H=i(l,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-1ynnvg9"&&(H.innerHTML=$s),Ot=a(l),q=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(q)!=="svelte-1jq112o"&&(q.innerHTML=ln),$t=a(l),M(P.$$.fragment,l),le=a(l),G=i(l,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-18g8ey5"&&(G.innerHTML=tn),te=a(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-uaz899"&&(W.innerHTML=en),ee=a(l),z=i(l,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-1j9j687"&&(z.innerHTML=sn),se=a(l),Z=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Z)!=="svelte-nls6mz"&&(Z.innerHTML=nn),ne=a(l),L=i(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-164rw2z"&&(L.innerHTML=an),ae=a(l),S=i(l,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-j32ek"&&(S.innerHTML=An),Ae=a(l),M(D.$$.fragment,l),ie=a(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-y33335"&&(Y.innerHTML=on),oe=a(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1yay3kj"&&(_.textContent=pn),pe=a(l),M(O.$$.fragment,l),Me=a(l),$=i(l,"PRE",{"data-svelte-h":!0}),o($)!=="svelte-h6hpdk"&&($.textContent=Mn),Ue=a(l),ll=i(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-1k6h3dv"&&(ll.innerHTML=Un),re=a(l),tl=i(l,"UL",{"data-svelte-h":!0}),o(tl)!=="svelte-j2u3py"&&(tl.innerHTML=rn),je=a(l),M(el.$$.fragment,l),ce=a(l),ht=i(l,"IMG",{src:!0}),we=a(l),sl=i(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1su99xg"&&(sl.textContent=cn),Te=a(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-1ybi5r3"&&(nl.textContent=wn),fe=a(l),al=i(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-1q1eqv0"&&(al.innerHTML=Tn),Je=a(l),Al=i(l,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-4l6ji"&&(Al.textContent=fn),ue=a(l),il=i(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-120j1u7"&&(il.textContent=Jn),ye=a(l),ol=i(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-187cxhr"&&(ol.textContent=un),me=a(l),pl=i(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-13r1nip"&&(pl.textContent=yn),de=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-mw3wdi"&&(Ml.innerHTML=mn),Re=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-zgqoei"&&(Ul.textContent=dn),Ce=a(l),rl=i(l,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-b66gqb"&&(rl.innerHTML=Rn),he=a(l),jl=i(l,"UL",{"data-svelte-h":!0}),o(jl)!=="svelte-1wwyqqn"&&(jl.innerHTML=Cn),be=a(l),cl=i(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-1jcvwk2"&&(cl.innerHTML=hn),Fe=a(l),wl=i(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-ibu9nm"&&(wl.innerHTML=bn),Be=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-fspy7m"&&(Tl.textContent=Fn),ve=a(l),M(fl.$$.fragment,l),Ie=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1wro3yx"&&(Jl.textContent=Bn),ge=a(l),ul=i(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-17l8q8z"&&(ul.innerHTML=vn),Ee=a(l),M(yl.$$.fragment,l),Ke=a(l),M(ml.$$.fragment,l),Ve=a(l),M(dl.$$.fragment,l),Ne=a(l),Rl=i(l,"IMG",{src:!0,height:!0}),Xe=a(l),Cl=i(l,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-1k4v1uw"&&(Cl.textContent=gn),ke=a(l),hl=i(l,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-1nzosig"&&(hl.innerHTML=En),Qe=a(l),bl=i(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1mlsch3"&&(bl.innerHTML=Kn),xe=a(l),Fl=i(l,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-1l1mro3"&&(Fl.textContent=Vn),He=a(l),M(Bl.$$.fragment,l),qe=a(l),vl=i(l,"PRE",{"data-svelte-h":!0}),o(vl)!=="svelte-1q4z1pg"&&(vl.textContent=Nn),Pe=a(l),M(Il.$$.fragment,l),Ge=a(l),gl=i(l,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1jbxnsj"&&(gl.innerHTML=Xn),We=a(l),El=i(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-15oxcnc"&&(El.textContent=kn),ze=a(l),Kl=i(l,"OL",{"data-svelte-h":!0}),o(Kl)!=="svelte-1x6zhcr"&&(Kl.innerHTML=Qn),Ze=a(l),M(Vl.$$.fragment,l),Le=a(l),Nl=i(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-jar50q"&&(Nl.textContent=xn),Se=a(l),Xl=i(l,"UL",{"data-svelte-h":!0}),o(Xl)!=="svelte-btzwg9"&&(Xl.innerHTML=Hn),De=a(l),kl=i(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1lm1kj0"&&(kl.innerHTML=qn),Ye=a(l),Ql=i(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-me1why"&&(Ql.innerHTML=Pn),_e=a(l),xl=i(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-6joo08"&&(xl.textContent=Gn),Oe=a(l),M(Hl.$$.fragment,l),$e=a(l),M(ql.$$.fragment,l),ls=a(l),M(Pl.$$.fragment,l),ts=a(l),Gl=i(l,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-npbw3t"&&(Gl.textContent=Wn),es=a(l),Wl=i(l,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-h6ikmf"&&(Wl.textContent=zn),ss=a(l),M(zl.$$.fragment,l),ns=a(l),Zl=i(l,"PRE",{"data-svelte-h":!0}),o(Zl)!=="svelte-aa4a7a"&&(Zl.textContent=Zn),as=a(l),Ll=i(l,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-l9rg7w"&&(Ll.textContent=Ln),As=a(l),M(Sl.$$.fragment,l),is=a(l),Dl=i(l,"PRE",{"data-svelte-h":!0}),o(Dl)!=="svelte-bk4o47"&&(Dl.textContent=Sn),os=a(l),M(Yl.$$.fragment,l),ps=a(l),_l=i(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-13uoub8"&&(_l.innerHTML=Dn),Ms=a(l),Ol=i(l,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-vhdu58"&&(Ol.innerHTML=Yn),Us=a(l),$l=i(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1b58ltx"&&($l.innerHTML=_n),rs=a(l),M(lt.$$.fragment,l),js=a(l),M(tt.$$.fragment,l),cs=a(l),M(et.$$.fragment,l),ws=a(l),st=i(l,"P",{"data-svelte-h":!0}),o(st)!=="svelte-352kfz"&&(st.textContent=On),Ts=a(l),M(nt.$$.fragment,l),fs=a(l),at=i(l,"PRE",{"data-svelte-h":!0}),o(at)!=="svelte-drvpbm"&&(at.textContent=$n),Js=a(l),M(At.$$.fragment,l),us=a(l),it=i(l,"PRE",{"data-svelte-h":!0}),o(it)!=="svelte-8jp8ub"&&(it.textContent=la),ys=a(l),ot=i(l,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-wgk4la"&&(ot.textContent=ta),ms=a(l),M(pt.$$.fragment,l),ds=a(l),Mt=i(l,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1vytx7u"&&(Mt.textContent=ea),Rs=a(l),M(Ut.$$.fragment,l),Cs=a(l),rt=i(l,"UL",{"data-svelte-h":!0}),o(rt)!=="svelte-1reib3"&&(rt.innerHTML=sa),hs=a(l),M(jt.$$.fragment,l),bs=a(l),ct=i(l,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1dq1tqp"&&(ct.innerHTML=na),Fs=a(l),wt=i(l,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-euuksf"&&(wt.innerHTML=aa),Bs=a(l),Tt=i(l,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-1ykhfl1"&&(Tt.innerHTML=Aa),vs=a(l),ft=i(l,"UL",{"data-svelte-h":!0}),o(ft)!=="svelte-1csot73"&&(ft.innerHTML=ia),Is=a(l),M(Jt.$$.fragment,l),gs=a(l),ut=i(l,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-pzw0dh"&&(ut.innerHTML=oa),Es=a(l),yt=i(l,"UL",{"data-svelte-h":!0}),o(yt)!=="svelte-1v6dvb"&&(yt.innerHTML=pa),Ks=a(l),mt=i(l,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-fpwmko"&&(mt.innerHTML=Ma),Vs=a(l),dt=i(l,"UL",{"data-svelte-h":!0}),o(dt)!=="svelte-16c8sbr"&&(dt.innerHTML=Ua),Ns=a(l),M(Rt.$$.fragment,l),Xs=a(l),Ft=i(l,"P",{}),ra(Ft).forEach(e),this.h()},h(){Ct(f,"name","hf:doc:metadata"),Ct(f,"content",Ra),Qs(C.src,Ws="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||Ct(C,"src",Ws),Ct(C,"height","700"),Qs(ht.src,jn="data:image/jpeg;base64,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")||Ct(ht,"src",jn),Qs(Rl.src,In="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/PaCMAP_embeddings.png")||Ct(Rl,"src",In),Ct(Rl,"height","700")},m(l,t){ua(document.head,f),s(l,Bt,t),s(l,bt,t),s(l,vt,t),U(J,l,t),s(l,It,t),U(u,l,t),s(l,gt,t),s(l,y,t),s(l,Et,t),s(l,m,t),s(l,Kt,t),s(l,d,t),s(l,Vt,t),s(l,R,t),s(l,Nt,t),s(l,C,t),s(l,Xt,t),s(l,h,t),s(l,kt,t),s(l,b,t),s(l,Qt,t),s(l,F,t),s(l,xt,t),U(B,l,t),s(l,Ht,t),U(v,l,t),s(l,qt,t),U(I,l,t),s(l,Pt,t),U(g,l,t),s(l,Gt,t),U(E,l,t),s(l,Wt,t),U(K,l,t),s(l,zt,t),U(V,l,t),s(l,Zt,t),s(l,N,t),s(l,Lt,t),s(l,X,t),s(l,St,t),s(l,k,t),s(l,Dt,t),s(l,Q,t),s(l,Yt,t),s(l,x,t),s(l,_t,t),s(l,H,t),s(l,Ot,t),s(l,q,t),s(l,$t,t),U(P,l,t),s(l,le,t),s(l,G,t),s(l,te,t),s(l,W,t),s(l,ee,t),s(l,z,t),s(l,se,t),s(l,Z,t),s(l,ne,t),s(l,L,t),s(l,ae,t),s(l,S,t),s(l,Ae,t),U(D,l,t),s(l,ie,t),s(l,Y,t),s(l,oe,t),s(l,_,t),s(l,pe,t),U(O,l,t),s(l,Me,t),s(l,$,t),s(l,Ue,t),s(l,ll,t),s(l,re,t),s(l,tl,t),s(l,je,t),U(el,l,t),s(l,ce,t),s(l,ht,t),s(l,we,t),s(l,sl,t),s(l,Te,t),s(l,nl,t),s(l,fe,t),s(l,al,t),s(l,Je,t),s(l,Al,t),s(l,ue,t),s(l,il,t),s(l,ye,t),s(l,ol,t),s(l,me,t),s(l,pl,t),s(l,de,t),s(l,Ml,t),s(l,Re,t),s(l,Ul,t),s(l,Ce,t),s(l,rl,t),s(l,he,t),s(l,jl,t),s(l,be,t),s(l,cl,t),s(l,Fe,t),s(l,wl,t),s(l,Be,t),s(l,Tl,t),s(l,ve,t),U(fl,l,t),s(l,Ie,t),s(l,Jl,t),s(l,ge,t),s(l,ul,t),s(l,Ee,t),U(yl,l,t),s(l,Ke,t),U(ml,l,t),s(l,Ve,t),U(dl,l,t),s(l,Ne,t),s(l,Rl,t),s(l,Xe,t),s(l,Cl,t),s(l,ke,t),s(l,hl,t),s(l,Qe,t),s(l,bl,t),s(l,xe,t),s(l,Fl,t),s(l,He,t),U(Bl,l,t),s(l,qe,t),s(l,vl,t),s(l,Pe,t),U(Il,l,t),s(l,Ge,t),s(l,gl,t),s(l,We,t),s(l,El,t),s(l,ze,t),s(l,Kl,t),s(l,Ze,t),U(Vl,l,t),s(l,Le,t),s(l,Nl,t),s(l,Se,t),s(l,Xl,t),s(l,De,t),s(l,kl,t),s(l,Ye,t),s(l,Ql,t),s(l,_e,t),s(l,xl,t),s(l,Oe,t),U(Hl,l,t),s(l,$e,t),U(ql,l,t),s(l,ls,t),U(Pl,l,t),s(l,ts,t),s(l,Gl,t),s(l,es,t),s(l,Wl,t),s(l,ss,t),U(zl,l,t),s(l,ns,t),s(l,Zl,t),s(l,as,t),s(l,Ll,t),s(l,As,t),U(Sl,l,t),s(l,is,t),s(l,Dl,t),s(l,os,t),U(Yl,l,t),s(l,ps,t),s(l,_l,t),s(l,Ms,t),s(l,Ol,t),s(l,Us,t),s(l,$l,t),s(l,rs,t),U(lt,l,t),s(l,js,t),U(tt,l,t),s(l,cs,t),U(et,l,t),s(l,ws,t),s(l,st,t),s(l,Ts,t),U(nt,l,t),s(l,fs,t),s(l,at,t),s(l,Js,t),U(At,l,t),s(l,us,t),s(l,it,t),s(l,ys,t),s(l,ot,t),s(l,ms,t),U(pt,l,t),s(l,ds,t),s(l,Mt,t),s(l,Rs,t),U(Ut,l,t),s(l,Cs,t),s(l,rt,t),s(l,hs,t),U(jt,l,t),s(l,bs,t),s(l,ct,t),s(l,Fs,t),s(l,wt,t),s(l,Bs,t),s(l,Tt,t),s(l,vs,t),s(l,ft,t),s(l,Is,t),U(Jt,l,t),s(l,gs,t),s(l,ut,t),s(l,Es,t),s(l,yt,t),s(l,Ks,t),s(l,mt,t),s(l,Vs,t),s(l,dt,t),s(l,Ns,t),U(Rt,l,t),s(l,Xs,t),s(l,Ft,t),ks=!0},p:ca,i(l){ks||(r(J.$$.fragment,l),r(u.$$.fragment,l),r(B.$$.fragment,l),r(v.$$.fragment,l),r(I.$$.fragment,l),r(g.$$.fragment,l),r(E.$$.fragment,l),r(K.$$.fragment,l),r(V.$$.fragment,l),r(P.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(el.$$.fragment,l),r(fl.$$.fragment,l),r(yl.$$.fragment,l),r(ml.$$.fragment,l),r(dl.$$.fragment,l),r(Bl.$$.fragment,l),r(Il.$$.fragment,l),r(Vl.$$.fragment,l),r(Hl.$$.fragment,l),r(ql.$$.fragment,l),r(Pl.$$.fragment,l),r(zl.$$.fragment,l),r(Sl.$$.fragment,l),r(Yl.$$.fragment,l),r(lt.$$.fragment,l),r(tt.$$.fragment,l),r(et.$$.fragment,l),r(nt.$$.fragment,l),r(At.$$.fragment,l),r(pt.$$.fragment,l),r(Ut.$$.fragment,l),r(jt.$$.fragment,l),r(Jt.$$.fragment,l),r(Rt.$$.fragment,l),ks=!0)},o(l){j(J.$$.fragment,l),j(u.$$.fragment,l),j(B.$$.fragment,l),j(v.$$.fragment,l),j(I.$$.fragment,l),j(g.$$.fragment,l),j(E.$$.fragment,l),j(K.$$.fragment,l),j(V.$$.fragment,l),j(P.$$.fragment,l),j(D.$$.fragment,l),j(O.$$.fragment,l),j(el.$$.fragment,l),j(fl.$$.fragment,l),j(yl.$$.fragment,l),j(ml.$$.fragment,l),j(dl.$$.fragment,l),j(Bl.$$.fragment,l),j(Il.$$.fragment,l),j(Vl.$$.fragment,l),j(Hl.$$.fragment,l),j(ql.$$.fragment,l),j(Pl.$$.fragment,l),j(zl.$$.fragment,l),j(Sl.$$.fragment,l),j(Yl.$$.fragment,l),j(lt.$$.fragment,l),j(tt.$$.fragment,l),j(et.$$.fragment,l),j(nt.$$.fragment,l),j(At.$$.fragment,l),j(pt.$$.fragment,l),j(Ut.$$.fragment,l),j(jt.$$.fragment,l),j(Jt.$$.fragment,l),j(Rt.$$.fragment,l),ks=!1},d(l){l&&(e(Bt),e(bt),e(vt),e(It),e(gt),e(y),e(Et),e(m),e(Kt),e(d),e(Vt),e(R),e(Nt),e(C),e(Xt),e(h),e(kt),e(b),e(Qt),e(F),e(xt),e(Ht),e(qt),e(Pt),e(Gt),e(Wt),e(zt),e(Zt),e(N),e(Lt),e(X),e(St),e(k),e(Dt),e(Q),e(Yt),e(x),e(_t),e(H),e(Ot),e(q),e($t),e(le),e(G),e(te),e(W),e(ee),e(z),e(se),e(Z),e(ne),e(L),e(ae),e(S),e(Ae),e(ie),e(Y),e(oe),e(_),e(pe),e(Me),e($),e(Ue),e(ll),e(re),e(tl),e(je),e(ce),e(ht),e(we),e(sl),e(Te),e(nl),e(fe),e(al),e(Je),e(Al),e(ue),e(il),e(ye),e(ol),e(me),e(pl),e(de),e(Ml),e(Re),e(Ul),e(Ce),e(rl),e(he),e(jl),e(be),e(cl),e(Fe),e(wl),e(Be),e(Tl),e(ve),e(Ie),e(Jl),e(ge),e(ul),e(Ee),e(Ke),e(Ve),e(Ne),e(Rl),e(Xe),e(Cl),e(ke),e(hl),e(Qe),e(bl),e(xe),e(Fl),e(He),e(qe),e(vl),e(Pe),e(Ge),e(gl),e(We),e(El),e(ze),e(Kl),e(Ze),e(Le),e(Nl),e(Se),e(Xl),e(De),e(kl),e(Ye),e(Ql),e(_e),e(xl),e(Oe),e($e),e(ls),e(ts),e(Gl),e(es),e(Wl),e(ss),e(ns),e(Zl),e(as),e(Ll),e(As),e(is),e(Dl),e(os),e(ps),e(_l),e(Ms),e(Ol),e(Us),e($l),e(rs),e(js),e(cs),e(ws),e(st),e(Ts),e(fs),e(at),e(Js),e(us),e(it),e(ys),e(ot),e(ms),e(ds),e(Mt),e(Rs),e(Cs),e(rt),e(hs),e(bs),e(ct),e(Fs),e(wt),e(Bs),e(Tt),e(vs),e(ft),e(Is),e(gs),e(ut),e(Es),e(yt),e(Ks),e(mt),e(Vs),e(dt),e(Ns),e(Xs),e(Ft)),e(f),c(J,l),c(u,l),c(B,l),c(v,l),c(I,l),c(g,l),c(E,l),c(K,l),c(V,l),c(P,l),c(D,l),c(O,l),c(el,l),c(fl,l),c(yl,l),c(ml,l),c(dl,l),c(Bl,l),c(Il,l),c(Vl,l),c(Hl,l),c(ql,l),c(Pl,l),c(zl,l),c(Sl,l),c(Yl,l),c(lt,l),c(tt,l),c(et,l),c(nt,l),c(At,l),c(pt,l),c(Ut,l),c(jt,l),c(Jt,l),c(Rt,l)}}}const Ra='{"title":"使用 LangChain 在 HuggingFace 文档上构建高级 RAG","local":"使用-langchain-在-huggingface-文档上构建高级-rag","sections":[{"title":"加载你的知识基础","local":"加载你的知识基础","sections":[],"depth":3}],"depth":1}';function Ca(xs){return wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends Ta{constructor(f){super(),fa(this,f,Ca,da,ja,{})}}export{va as component};
