import{s as ss,n as ls,o as ps}from"../chunks/scheduler.85c25b89.js";import{S as ds,i as cs,g as a,s as o,r as d,A as gs,h as r,f as i,c as n,j as l,u as c,x as m,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as K,E as us}from"../chunks/EditOnGithub.b65eee75.js";function fs(bi){let Z,vr,rr,br,ve,_r,be,_i="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",xr,_e,$r,xe,yr,_,$e,$o,At,xi="Create an optimizer instance via timm registry.",yo,Tt,$i=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,wo,Dt,yi="Examples:",Co,or,nr,ye,we,Lo,zt,wi="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",Ao,ir,mr,Ce,Le,To,Mt,Ci=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Do,sr,lr,Ae,Te,zo,Pt,Li=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Mo,pr,dr,De,ze,Po,qt,Ai=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,qo,kt,Ti=`Note:
Parameter group handling precedence:`,ko,Et,Di="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",wr,x,Me,Eo,Nt,zi="List available optimizer names, optionally filtered.",No,Ot,Mi=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,Oo,It,Pi="Examples:",Io,Ft,qi=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Fo,Ht,ki=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Ho,Bt,Ei=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Bo,Rt,Ni=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,Cr,C,Pe,Ro,Gt,Oi="Get optimizer class by name with option to bind default arguments.",Go,St,Ii=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,So,Vt,Fi="Examples:",Vo,cr,gr,qe,ke,Wo,Wt,Hi=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Uo,ur,fr,Ee,Ne,Qo,Ut,Bi=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,Lr,Oe,Ar,L,Ie,jo,Qt,Ri="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Ko,jt,Gi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Zo,Kt,Si=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Xo,Zt,Vi='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Jo,J,Fe,Yo,Xt,Wi="Performs a single optimization step.",Tr,A,He,en,Jt,Ui="Implements Adafactor algorithm.",tn,Yt,Qi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,an,ea,ji=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,rn,ta,Ki=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,on,Y,Be,nn,aa,Zi="Performs a single optimization step.",Dr,R,Re,mn,ra,Xi="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",sn,oa,Ji='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',zr,T,Ge,ln,na,Yi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",pn,ee,Se,dn,ia,em="Gets all parameters in all param_groups with gradients",cn,te,Ve,gn,ma,tm="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",un,ae,We,fn,sa,am="Performs a single optimization step.",hn,re,Ue,vn,la,rm="Zeros out the accumalated hessian traces.",Mr,Qe,je,Pr,P,Ke,bn,pa,om="Implements AdamW algorithm.",_n,da,nm=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,xn,ca,im=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,$n,oe,Ze,yn,ga,mm="Performs a single optimization step.",qr,G,Xe,wn,ua,sm=`Implements a pytorch variant of Adan
Adan was proposed in
Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models[J]. arXiv preprint arXiv:2208.06677, 2022.
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,Cn,ne,Je,Ln,fa,lm="Performs a single optimization step.",kr,S,Ye,An,ha,pm='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',Tn,ie,et,Dn,va,dm="Perform a single optimization step.",Er,q,tt,zn,ba,cm=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Mn,_a,gm="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",Pn,xa,um=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,qn,me,at,kn,$a,fm="Performs a single optimization step.",Nr,N,rt,En,ya,hm="LARS for PyTorch",Nn,wa,vm='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',On,se,ot,In,Ca,bm="Performs a single optimization step.",Or,V,nt,Fn,La,_m="Implements Lion algorithm.",Hn,le,it,Bn,Aa,xm="Performs a single optimization step.",Ir,mt,st,Fr,w,lt,Rn,Ta,$m=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Gn,Da,ym='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Sn,za,wm=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Vn,Ma,Cm=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Wn,Pa,Lm="On sparse problems both weight_decay and momentum should be set to 0.",Un,pe,pt,Qn,qa,Am="Performs a single optimization step.",Hr,D,dt,jn,ka,Tm="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",Kn,Ea,Dm="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",Zn,Na,zm='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',Xn,Oa,Mm=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,Jn,de,ct,Yn,Ia,Pm="Performs a single optimization step.",Br,k,gt,ei,Fa,qm="Implements NAdamW algorithm.",ti,Ha,km=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).
For further details regarding the algorithm we refer to
<code>Decoupled Weight Decay Regularization</code>_.`,ai,Ba,Em=`.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,ri,ce,ut,oi,Ra,Nm="Performs a single optimization step.",Rr,W,ft,ni,Ga,Om="Implements Novograd algorithm.",ii,ge,ht,mi,Sa,Im="Performs a single optimization step.",Gr,vt,bt,Sr,$,_t,si,Va,Fm="Implements RMSprop algorithm (TensorFlow style epsilon)",li,Wa,Hm=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,pi,Ua,Bm="Noteworthy changes include:",di,Qa,Rm="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",ci,ja,Gm=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,gi,Ka,Sm=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,ui,ue,xt,fi,Za,Vm="Performs a single optimization step.",Vr,$t,yt,Wr,X,wt,hi,fe,Ct,vi,Xa,Wm="Performs a single optimization step.",Ur,Lt,Qr,hr,jr;return ve=new K({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_e=new K({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new K({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": Union"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": Optional = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": Optional = None"},{name:"param_group_fn",val:": Optional = None"},{name:"**kwargs",val:": Any"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/_optim_factory.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),we=new K({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Le=new K({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),Te=new K({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),ze=new K({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": Union = ''"},{name:"exclude_filters",val:": Optional = None"},{name:"with_description",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/_optim_factory.py#L739",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),Pe=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/_optim_factory.py#L799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ke=new K({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Ne=new K({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Oe=new K({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Ie=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adabelief.py#L6"}}),Fe=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adabelief.py#L106"}}),He=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"},{name:"min_dim_size_to_factor",val:" = 32"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adafactor.py#L17"}}),Be=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adafactor.py#L117"}}),Re=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:""},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 32"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": Optional = 0.9"},{name:"momentum_dtype",val:": Union = torch.bfloat16"},{name:"eps",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": Optional = None"},{name:"unscaled_wd",val:": bool = False"},{name:"foreach",val:": Optional = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adafactor_bv.py#L48"}}),Ge=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adahessian.py#L9"}}),Se=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adahessian.py#L74"}}),Ve=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adahessian.py#L90"}}),We=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adahessian.py#L118"}}),Ue=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adahessian.py#L81"}}),je=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adamp.py#L43"}}),Ke=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adamw.py#L12"}}),Ze=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adamw.py#L71"}}),Xe=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.98, 0.92, 0.99)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"no_prox",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Adan.betas",description:`<strong>betas</strong> (Tuple[float, float, flot], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.98, 0.92, 0.99))`,name:"betas"},{anchor:"timm.optim.Adan.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; decoupled weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> (bool) &#x2014; how to perform the decoupled weight decay (default: False)",name:"no_prox"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adan.py#L16"}}),Je=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adan.py#L71"}}),Ye=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:""},{name:"lr",val:": Union = 0.001"},{name:"betas",val:": Tuple = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adopt.py#L56"}}),et=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/adopt.py#L191"}}),tt=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lamb.py#L60"}}),at=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lamb.py#L131"}}),rt=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lars.py#L17"}}),ot=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lars.py#L75"}}),nt=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.0001"},{name:"betas",val:" = (0.9, 0.99)"},{name:"weight_decay",val:" = 0.0"},{name:"maximize",val:" = False"},{name:"foreach",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lion.py#L25"}}),it=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lion.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),st=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/lookahead.py#L15"}}),lt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/madgrad.py#L24"}}),pt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": Optional = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/madgrad.py#L90"}}),dt=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nadam.py#L7"}}),ct=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nadam.py#L50"}}),gt=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nadamw.py#L15"}}),ut=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nadamw.py#L80"}}),ft=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nvnovograd.py#L13"}}),ht=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/radam.py#L10"}}),_t=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/rmsprop_tf.py#L14"}}),xt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/rmsprop_tf.py#L89"}}),yt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/sgdp.py#L19"}}),wt=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/sgdw.py#L16"}}),Ct=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2334/timm/optim/sgdw.py#L79"}}),Lt=new us({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Z=a("meta"),vr=o(),rr=a("p"),br=o(),d(ve.$$.fragment),_r=o(),be=a("p"),be.innerHTML=_i,xr=o(),d(_e.$$.fragment),$r=o(),d(xe.$$.fragment),yr=o(),_=a("div"),d($e.$$.fragment),$o=o(),At=a("p"),At.textContent=xi,yo=o(),Tt=a("p"),Tt.textContent=$i,wo=o(),Dt=a("p"),Dt.textContent=yi,Co=o(),or=a("blockquote"),nr=a("blockquote"),ye=a("blockquote"),d(we.$$.fragment),Lo=o(),zt=a("p"),zt.textContent=wi,Ao=o(),ir=a("blockquote"),mr=a("blockquote"),Ce=a("blockquote"),d(Le.$$.fragment),To=o(),Mt=a("p"),Mt.textContent=Ci,Do=o(),sr=a("blockquote"),lr=a("blockquote"),Ae=a("blockquote"),d(Te.$$.fragment),zo=o(),Pt=a("p"),Pt.textContent=Li,Mo=o(),pr=a("blockquote"),dr=a("blockquote"),De=a("blockquote"),d(ze.$$.fragment),Po=o(),qt=a("p"),qt.textContent=Ai,qo=o(),kt=a("p"),kt.textContent=Ti,ko=o(),Et=a("ol"),Et.innerHTML=Di,wr=o(),x=a("div"),d(Me.$$.fragment),Eo=o(),Nt=a("p"),Nt.textContent=zi,No=o(),Ot=a("p"),Ot.textContent=Mi,Oo=o(),It=a("p"),It.textContent=Pi,Io=o(),Ft=a("blockquote"),Ft.innerHTML=qi,Fo=o(),Ht=a("blockquote"),Ht.innerHTML=ki,Ho=o(),Bt=a("blockquote"),Bt.innerHTML=Ei,Bo=o(),Rt=a("blockquote"),Rt.innerHTML=Ni,Cr=o(),C=a("div"),d(Pe.$$.fragment),Ro=o(),Gt=a("p"),Gt.textContent=Oi,Go=o(),St=a("p"),St.textContent=Ii,So=o(),Vt=a("p"),Vt.textContent=Fi,Vo=o(),cr=a("blockquote"),gr=a("blockquote"),qe=a("blockquote"),d(ke.$$.fragment),Wo=o(),Wt=a("p"),Wt.textContent=Hi,Uo=o(),ur=a("blockquote"),fr=a("blockquote"),Ee=a("blockquote"),d(Ne.$$.fragment),Qo=o(),Ut=a("p"),Ut.textContent=Bi,Lr=o(),d(Oe.$$.fragment),Ar=o(),L=a("div"),d(Ie.$$.fragment),jo=o(),Qt=a("p"),Qt.textContent=Ri,Ko=o(),jt=a("p"),jt.textContent=Gi,Zo=o(),Kt=a("p"),Kt.innerHTML=Si,Xo=o(),Zt=a("ul"),Zt.innerHTML=Vi,Jo=o(),J=a("div"),d(Fe.$$.fragment),Yo=o(),Xt=a("p"),Xt.textContent=Wi,Tr=o(),A=a("div"),d(He.$$.fragment),en=o(),Jt=a("p"),Jt.textContent=Ui,tn=o(),Yt=a("p"),Yt.innerHTML=Qi,an=o(),ea=a("p"),ea.innerHTML=ji,rn=o(),ta=a("p"),ta.innerHTML=Ki,on=o(),Y=a("div"),d(Be.$$.fragment),nn=o(),aa=a("p"),aa.textContent=Zi,Dr=o(),R=a("div"),d(Re.$$.fragment),mn=o(),ra=a("p"),ra.textContent=Xi,sn=o(),oa=a("p"),oa.innerHTML=Ji,zr=o(),T=a("div"),d(Ge.$$.fragment),ln=o(),na=a("p"),na.textContent=Yi,pn=o(),ee=a("div"),d(Se.$$.fragment),dn=o(),ia=a("p"),ia.textContent=em,cn=o(),te=a("div"),d(Ve.$$.fragment),gn=o(),ma=a("p"),ma.textContent=tm,un=o(),ae=a("div"),d(We.$$.fragment),fn=o(),sa=a("p"),sa.textContent=am,hn=o(),re=a("div"),d(Ue.$$.fragment),vn=o(),la=a("p"),la.textContent=rm,Mr=o(),Qe=a("div"),d(je.$$.fragment),Pr=o(),P=a("div"),d(Ke.$$.fragment),bn=o(),pa=a("p"),pa.textContent=om,_n=o(),da=a("p"),da.innerHTML=nm,xn=o(),ca=a("p"),ca.innerHTML=im,$n=o(),oe=a("div"),d(Ze.$$.fragment),yn=o(),ga=a("p"),ga.textContent=mm,qr=o(),G=a("div"),d(Xe.$$.fragment),wn=o(),ua=a("p"),ua.innerHTML=sm,Cn=o(),ne=a("div"),d(Je.$$.fragment),Ln=o(),fa=a("p"),fa.textContent=lm,kr=o(),S=a("div"),d(Ye.$$.fragment),An=o(),ha=a("p"),ha.innerHTML=pm,Tn=o(),ie=a("div"),d(et.$$.fragment),Dn=o(),va=a("p"),va.textContent=dm,Er=o(),q=a("div"),d(tt.$$.fragment),zn=o(),ba=a("p"),ba.innerHTML=cm,Mn=o(),_a=a("p"),_a.innerHTML=gm,Pn=o(),xa=a("p"),xa.innerHTML=um,qn=o(),me=a("div"),d(at.$$.fragment),kn=o(),$a=a("p"),$a.textContent=fm,Nr=o(),N=a("div"),d(rt.$$.fragment),En=o(),ya=a("p"),ya.textContent=hm,Nn=o(),wa=a("p"),wa.innerHTML=vm,On=o(),se=a("div"),d(ot.$$.fragment),In=o(),Ca=a("p"),Ca.textContent=bm,Or=o(),V=a("div"),d(nt.$$.fragment),Fn=o(),La=a("p"),La.textContent=_m,Hn=o(),le=a("div"),d(it.$$.fragment),Bn=o(),Aa=a("p"),Aa.textContent=xm,Ir=o(),mt=a("div"),d(st.$$.fragment),Fr=o(),w=a("div"),d(lt.$$.fragment),Rn=o(),Ta=a("p"),Ta.textContent=$m,Gn=o(),Da=a("p"),Da.innerHTML=ym,Sn=o(),za=a("p"),za.textContent=wm,Vn=o(),Ma=a("p"),Ma.textContent=Cm,Wn=o(),Pa=a("p"),Pa.textContent=Lm,Un=o(),pe=a("div"),d(pt.$$.fragment),Qn=o(),qa=a("p"),qa.textContent=Am,Hr=o(),D=a("div"),d(dt.$$.fragment),jn=o(),ka=a("p"),ka.textContent=Tm,Kn=o(),Ea=a("p"),Ea.innerHTML=Dm,Zn=o(),Na=a("p"),Na.innerHTML=zm,Xn=o(),Oa=a("p"),Oa.innerHTML=Mm,Jn=o(),de=a("div"),d(ct.$$.fragment),Yn=o(),Ia=a("p"),Ia.textContent=Pm,Br=o(),k=a("div"),d(gt.$$.fragment),ei=o(),Fa=a("p"),Fa.textContent=qm,ti=o(),Ha=a("p"),Ha.innerHTML=km,ai=o(),Ba=a("p"),Ba.innerHTML=Em,ri=o(),ce=a("div"),d(ut.$$.fragment),oi=o(),Ra=a("p"),Ra.textContent=Nm,Rr=o(),W=a("div"),d(ft.$$.fragment),ni=o(),Ga=a("p"),Ga.textContent=Om,ii=o(),ge=a("div"),d(ht.$$.fragment),mi=o(),Sa=a("p"),Sa.textContent=Im,Gr=o(),vt=a("div"),d(bt.$$.fragment),Sr=o(),$=a("div"),d(_t.$$.fragment),si=o(),Va=a("p"),Va.textContent=Fm,li=o(),Wa=a("p"),Wa.textContent=Hm,pi=o(),Ua=a("p"),Ua.textContent=Bm,di=o(),Qa=a("ol"),Qa.innerHTML=Rm,ci=o(),ja=a("p"),ja.innerHTML=Gm,gi=o(),Ka=a("p"),Ka.innerHTML=Sm,ui=o(),ue=a("div"),d(xt.$$.fragment),fi=o(),Za=a("p"),Za.textContent=Vm,Vr=o(),$t=a("div"),d(yt.$$.fragment),Wr=o(),X=a("div"),d(wt.$$.fragment),hi=o(),fe=a("div"),d(Ct.$$.fragment),vi=o(),Xa=a("p"),Xa.textContent=Wm,Ur=o(),d(Lt.$$.fragment),Qr=o(),hr=a("p"),this.h()},l(e){const s=gs("svelte-u9bgzb",document.head);Z=r(s,"META",{name:!0,content:!0}),s.forEach(i),vr=n(e),rr=r(e,"P",{}),l(rr).forEach(i),br=n(e),c(ve.$$.fragment,e),_r=n(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1c6qm22"&&(be.innerHTML=_i),xr=n(e),c(_e.$$.fragment,e),$r=n(e),c(xe.$$.fragment,e),yr=n(e),_=r(e,"DIV",{class:!0});var y=l(_);c($e.$$.fragment,y),$o=n(y),At=r(y,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1330e7"&&(At.textContent=xi),yo=n(y),Tt=r(y,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-9cjiwr"&&(Tt.textContent=$i),wo=n(y),Dt=r(y,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-kvfsh7"&&(Dt.textContent=yi),Co=n(y),or=r(y,"BLOCKQUOTE",{});var Um=l(or);nr=r(Um,"BLOCKQUOTE",{});var Qm=l(nr);ye=r(Qm,"BLOCKQUOTE",{});var Kr=l(ye);c(we.$$.fragment,Kr),Lo=n(Kr),zt=r(Kr,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-180ncmf"&&(zt.textContent=wi),Kr.forEach(i),Qm.forEach(i),Um.forEach(i),Ao=n(y),ir=r(y,"BLOCKQUOTE",{});var jm=l(ir);mr=r(jm,"BLOCKQUOTE",{});var Km=l(mr);Ce=r(Km,"BLOCKQUOTE",{});var Zr=l(Ce);c(Le.$$.fragment,Zr),To=n(Zr),Mt=r(Zr,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-6yrpk7"&&(Mt.textContent=Ci),Zr.forEach(i),Km.forEach(i),jm.forEach(i),Do=n(y),sr=r(y,"BLOCKQUOTE",{});var Zm=l(sr);lr=r(Zm,"BLOCKQUOTE",{});var Xm=l(lr);Ae=r(Xm,"BLOCKQUOTE",{});var Xr=l(Ae);c(Te.$$.fragment,Xr),zo=n(Xr),Pt=r(Xr,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=Li),Xr.forEach(i),Xm.forEach(i),Zm.forEach(i),Mo=n(y),pr=r(y,"BLOCKQUOTE",{});var Jm=l(pr);dr=r(Jm,"BLOCKQUOTE",{});var Ym=l(dr);De=r(Ym,"BLOCKQUOTE",{});var Jr=l(De);c(ze.$$.fragment,Jr),Po=n(Jr),qt=r(Jr,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-15ovmpe"&&(qt.textContent=Ai),Jr.forEach(i),Ym.forEach(i),Jm.forEach(i),qo=n(y),kt=r(y,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-sgpn75"&&(kt.textContent=Ti),ko=n(y),Et=r(y,"OL",{"data-svelte-h":!0}),m(Et)!=="svelte-psaz57"&&(Et.innerHTML=Di),y.forEach(i),wr=n(e),x=r(e,"DIV",{class:!0});var z=l(x);c(Me.$$.fragment,z),Eo=n(z),Nt=r(z,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1h2sspw"&&(Nt.textContent=zi),No=n(z),Ot=r(z,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1tapwxe"&&(Ot.textContent=Mi),Oo=n(z),It=r(z,"P",{"data-svelte-h":!0}),m(It)!=="svelte-kvfsh7"&&(It.textContent=Pi),Io=n(z),Ft=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ft)!=="svelte-m875zf"&&(Ft.innerHTML=qi),Fo=n(z),Ht=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ht)!=="svelte-1mioyvo"&&(Ht.innerHTML=ki),Ho=n(z),Bt=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Bt)!=="svelte-ji9gfr"&&(Bt.innerHTML=Ei),Bo=n(z),Rt=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Rt)!=="svelte-tvmm3x"&&(Rt.innerHTML=Ni),z.forEach(i),Cr=n(e),C=r(e,"DIV",{class:!0});var O=l(C);c(Pe.$$.fragment,O),Ro=n(O),Gt=r(O,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Oi),Go=n(O),St=r(O,"P",{"data-svelte-h":!0}),m(St)!=="svelte-13jhmtj"&&(St.textContent=Ii),So=n(O),Vt=r(O,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-kvfsh7"&&(Vt.textContent=Fi),Vo=n(O),cr=r(O,"BLOCKQUOTE",{});var es=l(cr);gr=r(es,"BLOCKQUOTE",{});var ts=l(gr);qe=r(ts,"BLOCKQUOTE",{});var Yr=l(qe);c(ke.$$.fragment,Yr),Wo=n(Yr),Wt=r(Yr,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-1en25gb"&&(Wt.textContent=Hi),Yr.forEach(i),ts.forEach(i),es.forEach(i),Uo=n(O),ur=r(O,"BLOCKQUOTE",{});var as=l(ur);fr=r(as,"BLOCKQUOTE",{});var rs=l(fr);Ee=r(rs,"BLOCKQUOTE",{});var eo=l(Ee);c(Ne.$$.fragment,eo),Qo=n(eo),Ut=r(eo,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-gfx8y2"&&(Ut.textContent=Bi),eo.forEach(i),rs.forEach(i),as.forEach(i),O.forEach(i),Lr=n(e),c(Oe.$$.fragment,e),Ar=n(e),L=r(e,"DIV",{class:!0});var I=l(L);c(Ie.$$.fragment,I),jo=n(I),Qt=r(I,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1hnunr4"&&(Qt.textContent=Ri),Ko=n(I),jt=r(I,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1cjb7xo"&&(jt.textContent=Gi),Zo=n(I),Kt=r(I,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-1347q2l"&&(Kt.innerHTML=Si),Xo=n(I),Zt=r(I,"UL",{"data-svelte-h":!0}),m(Zt)!=="svelte-12x3l9q"&&(Zt.innerHTML=Vi),Jo=n(I),J=r(I,"DIV",{class:!0});var to=l(J);c(Fe.$$.fragment,to),Yo=n(to),Xt=r(to,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-1gr03w4"&&(Xt.textContent=Wi),to.forEach(i),I.forEach(i),Tr=n(e),A=r(e,"DIV",{class:!0});var F=l(A);c(He.$$.fragment,F),en=n(F),Jt=r(F,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1j9mkxe"&&(Jt.textContent=Ui),tn=n(F),Yt=r(F,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-1xvyiun"&&(Yt.innerHTML=Qi),an=n(F),ea=r(F,"P",{"data-svelte-h":!0}),m(ea)!=="svelte-1i7ubkr"&&(ea.innerHTML=ji),rn=n(F),ta=r(F,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-96f97i"&&(ta.innerHTML=Ki),on=n(F),Y=r(F,"DIV",{class:!0});var ao=l(Y);c(Be.$$.fragment,ao),nn=n(ao),aa=r(ao,"P",{"data-svelte-h":!0}),m(aa)!=="svelte-1gr03w4"&&(aa.textContent=Zi),ao.forEach(i),F.forEach(i),Dr=n(e),R=r(e,"DIV",{class:!0});var Ja=l(R);c(Re.$$.fragment,Ja),mn=n(Ja),ra=r(Ja,"P",{"data-svelte-h":!0}),m(ra)!=="svelte-19t8yzj"&&(ra.textContent=Xi),sn=n(Ja),oa=r(Ja,"P",{"data-svelte-h":!0}),m(oa)!=="svelte-aajaln"&&(oa.innerHTML=Ji),Ja.forEach(i),zr=n(e),T=r(e,"DIV",{class:!0});var H=l(T);c(Ge.$$.fragment,H),ln=n(H),na=r(H,"P",{"data-svelte-h":!0}),m(na)!=="svelte-1cuo0rh"&&(na.textContent=Yi),pn=n(H),ee=r(H,"DIV",{class:!0});var ro=l(ee);c(Se.$$.fragment,ro),dn=n(ro),ia=r(ro,"P",{"data-svelte-h":!0}),m(ia)!=="svelte-1jz1hl7"&&(ia.textContent=em),ro.forEach(i),cn=n(H),te=r(H,"DIV",{class:!0});var oo=l(te);c(Ve.$$.fragment,oo),gn=n(oo),ma=r(oo,"P",{"data-svelte-h":!0}),m(ma)!=="svelte-1y1oyzd"&&(ma.textContent=tm),oo.forEach(i),un=n(H),ae=r(H,"DIV",{class:!0});var no=l(ae);c(We.$$.fragment,no),fn=n(no),sa=r(no,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-1gr03w4"&&(sa.textContent=am),no.forEach(i),hn=n(H),re=r(H,"DIV",{class:!0});var io=l(re);c(Ue.$$.fragment,io),vn=n(io),la=r(io,"P",{"data-svelte-h":!0}),m(la)!=="svelte-4lvf5h"&&(la.textContent=rm),io.forEach(i),H.forEach(i),Mr=n(e),Qe=r(e,"DIV",{class:!0});var os=l(Qe);c(je.$$.fragment,os),os.forEach(i),Pr=n(e),P=r(e,"DIV",{class:!0});var U=l(P);c(Ke.$$.fragment,U),bn=n(U),pa=r(U,"P",{"data-svelte-h":!0}),m(pa)!=="svelte-c51pd7"&&(pa.textContent=om),_n=n(U),da=r(U,"P",{"data-svelte-h":!0}),m(da)!=="svelte-1cgyzi6"&&(da.innerHTML=nm),xn=n(U),ca=r(U,"P",{"data-svelte-h":!0}),m(ca)!=="svelte-1pe3ewc"&&(ca.innerHTML=im),$n=n(U),oe=r(U,"DIV",{class:!0});var mo=l(oe);c(Ze.$$.fragment,mo),yn=n(mo),ga=r(mo,"P",{"data-svelte-h":!0}),m(ga)!=="svelte-1gr03w4"&&(ga.textContent=mm),mo.forEach(i),U.forEach(i),qr=n(e),G=r(e,"DIV",{class:!0});var Ya=l(G);c(Xe.$$.fragment,Ya),wn=n(Ya),ua=r(Ya,"P",{"data-svelte-h":!0}),m(ua)!=="svelte-acz7r2"&&(ua.innerHTML=sm),Cn=n(Ya),ne=r(Ya,"DIV",{class:!0});var so=l(ne);c(Je.$$.fragment,so),Ln=n(so),fa=r(so,"P",{"data-svelte-h":!0}),m(fa)!=="svelte-1gr03w4"&&(fa.textContent=lm),so.forEach(i),Ya.forEach(i),kr=n(e),S=r(e,"DIV",{class:!0});var er=l(S);c(Ye.$$.fragment,er),An=n(er),ha=r(er,"P",{"data-svelte-h":!0}),m(ha)!=="svelte-bxurot"&&(ha.innerHTML=pm),Tn=n(er),ie=r(er,"DIV",{class:!0});var lo=l(ie);c(et.$$.fragment,lo),Dn=n(lo),va=r(lo,"P",{"data-svelte-h":!0}),m(va)!=="svelte-1siu6mf"&&(va.textContent=dm),lo.forEach(i),er.forEach(i),Er=n(e),q=r(e,"DIV",{class:!0});var Q=l(q);c(tt.$$.fragment,Q),zn=n(Q),ba=r(Q,"P",{"data-svelte-h":!0}),m(ba)!=="svelte-d5zqgn"&&(ba.innerHTML=cm),Mn=n(Q),_a=r(Q,"P",{"data-svelte-h":!0}),m(_a)!=="svelte-1wamkfv"&&(_a.innerHTML=gm),Pn=n(Q),xa=r(Q,"P",{"data-svelte-h":!0}),m(xa)!=="svelte-dty621"&&(xa.innerHTML=um),qn=n(Q),me=r(Q,"DIV",{class:!0});var po=l(me);c(at.$$.fragment,po),kn=n(po),$a=r(po,"P",{"data-svelte-h":!0}),m($a)!=="svelte-1gr03w4"&&($a.textContent=fm),po.forEach(i),Q.forEach(i),Nr=n(e),N=r(e,"DIV",{class:!0});var he=l(N);c(rt.$$.fragment,he),En=n(he),ya=r(he,"P",{"data-svelte-h":!0}),m(ya)!=="svelte-vzcsb8"&&(ya.textContent=hm),Nn=n(he),wa=r(he,"P",{"data-svelte-h":!0}),m(wa)!=="svelte-euart9"&&(wa.innerHTML=vm),On=n(he),se=r(he,"DIV",{class:!0});var co=l(se);c(ot.$$.fragment,co),In=n(co),Ca=r(co,"P",{"data-svelte-h":!0}),m(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=bm),co.forEach(i),he.forEach(i),Or=n(e),V=r(e,"DIV",{class:!0});var tr=l(V);c(nt.$$.fragment,tr),Fn=n(tr),La=r(tr,"P",{"data-svelte-h":!0}),m(La)!=="svelte-pwyp7b"&&(La.textContent=_m),Hn=n(tr),le=r(tr,"DIV",{class:!0});var go=l(le);c(it.$$.fragment,go),Bn=n(go),Aa=r(go,"P",{"data-svelte-h":!0}),m(Aa)!=="svelte-1gr03w4"&&(Aa.textContent=xm),go.forEach(i),tr.forEach(i),Ir=n(e),mt=r(e,"DIV",{class:!0});var ns=l(mt);c(st.$$.fragment,ns),ns.forEach(i),Fr=n(e),w=r(e,"DIV",{class:!0});var E=l(w);c(lt.$$.fragment,E),Rn=n(E),Ta=r(E,"P",{"data-svelte-h":!0}),m(Ta)!=="svelte-wmmdpx"&&(Ta.textContent=$m),Gn=n(E),Da=r(E,"P",{"data-svelte-h":!0}),m(Da)!=="svelte-12dyngi"&&(Da.innerHTML=ym),Sn=n(E),za=r(E,"P",{"data-svelte-h":!0}),m(za)!=="svelte-qjjdis"&&(za.textContent=wm),Vn=n(E),Ma=r(E,"P",{"data-svelte-h":!0}),m(Ma)!=="svelte-rosfou"&&(Ma.textContent=Cm),Wn=n(E),Pa=r(E,"P",{"data-svelte-h":!0}),m(Pa)!=="svelte-hlwvkn"&&(Pa.textContent=Lm),Un=n(E),pe=r(E,"DIV",{class:!0});var uo=l(pe);c(pt.$$.fragment,uo),Qn=n(uo),qa=r(uo,"P",{"data-svelte-h":!0}),m(qa)!=="svelte-1gr03w4"&&(qa.textContent=Am),uo.forEach(i),E.forEach(i),Hr=n(e),D=r(e,"DIV",{class:!0});var B=l(D);c(dt.$$.fragment,B),jn=n(B),ka=r(B,"P",{"data-svelte-h":!0}),m(ka)!=="svelte-1ss2c23"&&(ka.textContent=Tm),Kn=n(B),Ea=r(B,"P",{"data-svelte-h":!0}),m(Ea)!=="svelte-ewqetr"&&(Ea.innerHTML=Dm),Zn=n(B),Na=r(B,"P",{"data-svelte-h":!0}),m(Na)!=="svelte-1q705lb"&&(Na.innerHTML=zm),Xn=n(B),Oa=r(B,"P",{"data-svelte-h":!0}),m(Oa)!=="svelte-14ul3re"&&(Oa.innerHTML=Mm),Jn=n(B),de=r(B,"DIV",{class:!0});var fo=l(de);c(ct.$$.fragment,fo),Yn=n(fo),Ia=r(fo,"P",{"data-svelte-h":!0}),m(Ia)!=="svelte-1gr03w4"&&(Ia.textContent=Pm),fo.forEach(i),B.forEach(i),Br=n(e),k=r(e,"DIV",{class:!0});var j=l(k);c(gt.$$.fragment,j),ei=n(j),Fa=r(j,"P",{"data-svelte-h":!0}),m(Fa)!=="svelte-3mtxcr"&&(Fa.textContent=qm),ti=n(j),Ha=r(j,"P",{"data-svelte-h":!0}),m(Ha)!=="svelte-797qvx"&&(Ha.innerHTML=km),ai=n(j),Ba=r(j,"P",{"data-svelte-h":!0}),m(Ba)!=="svelte-1qa39gq"&&(Ba.innerHTML=Em),ri=n(j),ce=r(j,"DIV",{class:!0});var ho=l(ce);c(ut.$$.fragment,ho),oi=n(ho),Ra=r(ho,"P",{"data-svelte-h":!0}),m(Ra)!=="svelte-1gr03w4"&&(Ra.textContent=Nm),ho.forEach(i),j.forEach(i),Rr=n(e),W=r(e,"DIV",{class:!0});var ar=l(W);c(ft.$$.fragment,ar),ni=n(ar),Ga=r(ar,"P",{"data-svelte-h":!0}),m(Ga)!=="svelte-5vv99d"&&(Ga.textContent=Om),ii=n(ar),ge=r(ar,"DIV",{class:!0});var vo=l(ge);c(ht.$$.fragment,vo),mi=n(vo),Sa=r(vo,"P",{"data-svelte-h":!0}),m(Sa)!=="svelte-1gr03w4"&&(Sa.textContent=Im),vo.forEach(i),ar.forEach(i),Gr=n(e),vt=r(e,"DIV",{class:!0});var is=l(vt);c(bt.$$.fragment,is),is.forEach(i),Sr=n(e),$=r(e,"DIV",{class:!0});var M=l($);c(_t.$$.fragment,M),si=n(M),Va=r(M,"P",{"data-svelte-h":!0}),m(Va)!=="svelte-1tqv0s5"&&(Va.textContent=Fm),li=n(M),Wa=r(M,"P",{"data-svelte-h":!0}),m(Wa)!=="svelte-g10xv4"&&(Wa.textContent=Hm),pi=n(M),Ua=r(M,"P",{"data-svelte-h":!0}),m(Ua)!=="svelte-1acg3vg"&&(Ua.textContent=Bm),di=n(M),Qa=r(M,"OL",{"data-svelte-h":!0}),m(Qa)!=="svelte-15y6o6y"&&(Qa.innerHTML=Rm),ci=n(M),ja=r(M,"P",{"data-svelte-h":!0}),m(ja)!=="svelte-1yvkj2h"&&(ja.innerHTML=Gm),gi=n(M),Ka=r(M,"P",{"data-svelte-h":!0}),m(Ka)!=="svelte-53x1ow"&&(Ka.innerHTML=Sm),ui=n(M),ue=r(M,"DIV",{class:!0});var bo=l(ue);c(xt.$$.fragment,bo),fi=n(bo),Za=r(bo,"P",{"data-svelte-h":!0}),m(Za)!=="svelte-1gr03w4"&&(Za.textContent=Vm),bo.forEach(i),M.forEach(i),Vr=n(e),$t=r(e,"DIV",{class:!0});var ms=l($t);c(yt.$$.fragment,ms),ms.forEach(i),Wr=n(e),X=r(e,"DIV",{class:!0});var _o=l(X);c(wt.$$.fragment,_o),hi=n(_o),fe=r(_o,"DIV",{class:!0});var xo=l(fe);c(Ct.$$.fragment,xo),vi=n(xo),Xa=r(xo,"P",{"data-svelte-h":!0}),m(Xa)!=="svelte-1gr03w4"&&(Xa.textContent=Wm),xo.forEach(i),_o.forEach(i),Ur=n(e),c(Lt.$$.fragment,e),Qr=n(e),hr=r(e,"P",{}),l(hr).forEach(i),this.h()},h(){v(Z,"name","hf:doc:metadata"),v(Z,"content",hs),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Z),p(e,vr,s),p(e,rr,s),p(e,br,s),g(ve,e,s),p(e,_r,s),p(e,be,s),p(e,xr,s),g(_e,e,s),p(e,$r,s),g(xe,e,s),p(e,yr,s),p(e,_,s),g($e,_,null),t(_,$o),t(_,At),t(_,yo),t(_,Tt),t(_,wo),t(_,Dt),t(_,Co),t(_,or),t(or,nr),t(nr,ye),g(we,ye,null),t(ye,Lo),t(ye,zt),t(_,Ao),t(_,ir),t(ir,mr),t(mr,Ce),g(Le,Ce,null),t(Ce,To),t(Ce,Mt),t(_,Do),t(_,sr),t(sr,lr),t(lr,Ae),g(Te,Ae,null),t(Ae,zo),t(Ae,Pt),t(_,Mo),t(_,pr),t(pr,dr),t(dr,De),g(ze,De,null),t(De,Po),t(De,qt),t(_,qo),t(_,kt),t(_,ko),t(_,Et),p(e,wr,s),p(e,x,s),g(Me,x,null),t(x,Eo),t(x,Nt),t(x,No),t(x,Ot),t(x,Oo),t(x,It),t(x,Io),t(x,Ft),t(x,Fo),t(x,Ht),t(x,Ho),t(x,Bt),t(x,Bo),t(x,Rt),p(e,Cr,s),p(e,C,s),g(Pe,C,null),t(C,Ro),t(C,Gt),t(C,Go),t(C,St),t(C,So),t(C,Vt),t(C,Vo),t(C,cr),t(cr,gr),t(gr,qe),g(ke,qe,null),t(qe,Wo),t(qe,Wt),t(C,Uo),t(C,ur),t(ur,fr),t(fr,Ee),g(Ne,Ee,null),t(Ee,Qo),t(Ee,Ut),p(e,Lr,s),g(Oe,e,s),p(e,Ar,s),p(e,L,s),g(Ie,L,null),t(L,jo),t(L,Qt),t(L,Ko),t(L,jt),t(L,Zo),t(L,Kt),t(L,Xo),t(L,Zt),t(L,Jo),t(L,J),g(Fe,J,null),t(J,Yo),t(J,Xt),p(e,Tr,s),p(e,A,s),g(He,A,null),t(A,en),t(A,Jt),t(A,tn),t(A,Yt),t(A,an),t(A,ea),t(A,rn),t(A,ta),t(A,on),t(A,Y),g(Be,Y,null),t(Y,nn),t(Y,aa),p(e,Dr,s),p(e,R,s),g(Re,R,null),t(R,mn),t(R,ra),t(R,sn),t(R,oa),p(e,zr,s),p(e,T,s),g(Ge,T,null),t(T,ln),t(T,na),t(T,pn),t(T,ee),g(Se,ee,null),t(ee,dn),t(ee,ia),t(T,cn),t(T,te),g(Ve,te,null),t(te,gn),t(te,ma),t(T,un),t(T,ae),g(We,ae,null),t(ae,fn),t(ae,sa),t(T,hn),t(T,re),g(Ue,re,null),t(re,vn),t(re,la),p(e,Mr,s),p(e,Qe,s),g(je,Qe,null),p(e,Pr,s),p(e,P,s),g(Ke,P,null),t(P,bn),t(P,pa),t(P,_n),t(P,da),t(P,xn),t(P,ca),t(P,$n),t(P,oe),g(Ze,oe,null),t(oe,yn),t(oe,ga),p(e,qr,s),p(e,G,s),g(Xe,G,null),t(G,wn),t(G,ua),t(G,Cn),t(G,ne),g(Je,ne,null),t(ne,Ln),t(ne,fa),p(e,kr,s),p(e,S,s),g(Ye,S,null),t(S,An),t(S,ha),t(S,Tn),t(S,ie),g(et,ie,null),t(ie,Dn),t(ie,va),p(e,Er,s),p(e,q,s),g(tt,q,null),t(q,zn),t(q,ba),t(q,Mn),t(q,_a),t(q,Pn),t(q,xa),t(q,qn),t(q,me),g(at,me,null),t(me,kn),t(me,$a),p(e,Nr,s),p(e,N,s),g(rt,N,null),t(N,En),t(N,ya),t(N,Nn),t(N,wa),t(N,On),t(N,se),g(ot,se,null),t(se,In),t(se,Ca),p(e,Or,s),p(e,V,s),g(nt,V,null),t(V,Fn),t(V,La),t(V,Hn),t(V,le),g(it,le,null),t(le,Bn),t(le,Aa),p(e,Ir,s),p(e,mt,s),g(st,mt,null),p(e,Fr,s),p(e,w,s),g(lt,w,null),t(w,Rn),t(w,Ta),t(w,Gn),t(w,Da),t(w,Sn),t(w,za),t(w,Vn),t(w,Ma),t(w,Wn),t(w,Pa),t(w,Un),t(w,pe),g(pt,pe,null),t(pe,Qn),t(pe,qa),p(e,Hr,s),p(e,D,s),g(dt,D,null),t(D,jn),t(D,ka),t(D,Kn),t(D,Ea),t(D,Zn),t(D,Na),t(D,Xn),t(D,Oa),t(D,Jn),t(D,de),g(ct,de,null),t(de,Yn),t(de,Ia),p(e,Br,s),p(e,k,s),g(gt,k,null),t(k,ei),t(k,Fa),t(k,ti),t(k,Ha),t(k,ai),t(k,Ba),t(k,ri),t(k,ce),g(ut,ce,null),t(ce,oi),t(ce,Ra),p(e,Rr,s),p(e,W,s),g(ft,W,null),t(W,ni),t(W,Ga),t(W,ii),t(W,ge),g(ht,ge,null),t(ge,mi),t(ge,Sa),p(e,Gr,s),p(e,vt,s),g(bt,vt,null),p(e,Sr,s),p(e,$,s),g(_t,$,null),t($,si),t($,Va),t($,li),t($,Wa),t($,pi),t($,Ua),t($,di),t($,Qa),t($,ci),t($,ja),t($,gi),t($,Ka),t($,ui),t($,ue),g(xt,ue,null),t(ue,fi),t(ue,Za),p(e,Vr,s),p(e,$t,s),g(yt,$t,null),p(e,Wr,s),p(e,X,s),g(wt,X,null),t(X,hi),t(X,fe),g(Ct,fe,null),t(fe,vi),t(fe,Xa),p(e,Ur,s),g(Lt,e,s),p(e,Qr,s),p(e,hr,s),jr=!0},p:ls,i(e){jr||(u(ve.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Le.$$.fragment,e),u(Te.$$.fragment,e),u(ze.$$.fragment,e),u(Me.$$.fragment,e),u(Pe.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Oe.$$.fragment,e),u(Ie.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(rt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(bt.$$.fragment,e),u(_t.$$.fragment,e),u(xt.$$.fragment,e),u(yt.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),u(Lt.$$.fragment,e),jr=!0)},o(e){f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Le.$$.fragment,e),f(Te.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(ke.$$.fragment,e),f(Ne.$$.fragment,e),f(Oe.$$.fragment,e),f(Ie.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(lt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(bt.$$.fragment,e),f(_t.$$.fragment,e),f(xt.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Lt.$$.fragment,e),jr=!1},d(e){e&&(i(vr),i(rr),i(br),i(_r),i(be),i(xr),i($r),i(yr),i(_),i(wr),i(x),i(Cr),i(C),i(Lr),i(Ar),i(L),i(Tr),i(A),i(Dr),i(R),i(zr),i(T),i(Mr),i(Qe),i(Pr),i(P),i(qr),i(G),i(kr),i(S),i(Er),i(q),i(Nr),i(N),i(Or),i(V),i(Ir),i(mt),i(Fr),i(w),i(Hr),i(D),i(Br),i(k),i(Rr),i(W),i(Gr),i(vt),i(Sr),i($),i(Vr),i($t),i(Wr),i(X),i(Ur),i(Qr),i(hr)),i(Z),h(ve,e),h(_e,e),h(xe,e),h($e),h(we),h(Le),h(Te),h(ze),h(Me),h(Pe),h(ke),h(Ne),h(Oe,e),h(Ie),h(Fe),h(He),h(Be),h(Re),h(Ge),h(Se),h(Ve),h(We),h(Ue),h(je),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(rt),h(ot),h(nt),h(it),h(st),h(lt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(bt),h(_t),h(xt),h(yt),h(wt),h(Ct),h(Lt,e)}}}const hs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function vs(bi){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ds{constructor(Z){super(),cs(this,Z,vs,fs,ss,{})}}export{ys as component};
