import{s as ea,o as ta,n as Ut}from"../chunks/scheduler.6062bdaf.js";import{S as aa,i as sa,g as i,s as l,r as p,A as la,h,f as a,c as n,j as Kt,u as r,x as b,k as Tt,y as na,a as s,v as c,d as u,t as d,w}from"../chunks/index.4bca734e.js";import{T as Jt}from"../chunks/Tip.b9ac1f03.js";import{C as f}from"../chunks/CodeBlock.fa01571c.js";import{H as g,E as oa}from"../chunks/EditOnGithub.74ab2baa.js";function ia(k){let o,M=`To see a running example of a webhook server, check out the <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>
one. It is a Space that launches ephemeral environments when a PR is opened on a Space.`;return{c(){o=i("p"),o.innerHTML=M},l(y){o=h(y,"P",{"data-svelte-h":!0}),b(o)!=="svelte-18sko4t"&&(o.innerHTML=M)},m(y,m){s(y,o,m)},p:Ut,d(y){y&&a(o)}}}function ha(k){let o,M=`This is an <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimental feature</a>. This
means that we are still working on improving the API. Breaking changes might be introduced in the future without prior
notice. Make sure to pin the version of <code>huggingface_hub</code> in your requirements.`;return{c(){o=i("p"),o.innerHTML=M},l(y){o=h(y,"P",{"data-svelte-h":!0}),b(o)!=="svelte-fuzk6g"&&(o.innerHTML=M)},m(y,m){s(y,o,m)},p:Ut,d(y){y&&a(o)}}}function pa(k){let o,M=`By default, the server is started at the end of your script. If you are running it in a notebook, you can start the
server manually by calling <code>decorated_function.run()</code>. Since a unique server is used, you only have to start the server
once even if you have multiple endpoints.`;return{c(){o=i("p"),o.innerHTML=M},l(y){o=h(y,"P",{"data-svelte-h":!0}),b(o)!=="svelte-1jc349n"&&(o.innerHTML=M)},m(y,m){s(y,o,m)},p:Ut,d(y){y&&a(o)}}}function ra(k){let o,M,y,m,v,Te,$,jt="Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to all repos belonging to particular users/organizations you’re interested in following. This guide will first explain how to manage webhooks programmatically. Then we’ll see how to leverage <code>huggingface_hub</code> to create a server listening to webhooks and deploy it to a Space.",Je,I,vt='This guide assumes you are familiar with the concept of webhooks on the Huggingface Hub. To learn more about webhooks themselves, you should read this <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">guide</a> first.',Ue,W,je,_,$t="<code>huggingface_hub</code> allows you to manage your webhooks programmatically. You can list your existing webhooks, create new ones, and update, enable, disable or delete them. This section guides you through the procedures using the Hugging Face Hub’s API functions.",ve,Z,$e,G,It='To create a new webhook, use <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.create_webhook">create_webhook()</a> and specify the URL where payloads should be sent, what events should be watched, and optionally set a domain and a secret for security.',Ie,B,We,C,_e,S,Wt='To see all the webhooks you have configured, you can list them with <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.list_webhooks">list_webhooks()</a>. This is useful to review their IDs, URLs, and statuses.',Ze,Y,Ge,H,Be,V,_t='If you need to change the configuration of an existing webhook, such as the URL or the events it watches, you can update it using <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.update_webhook">update_webhook()</a>.',Ce,R,Se,F,Ye,X,Zt='You might want to temporarily disable a webhook without deleting it. This can be done using <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.disable_webhook">disable_webhook()</a>, and the webhook can be re-enabled later with <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.enable_webhook">enable_webhook()</a>.',He,E,Ve,Q,Re,L,Gt='When a webhook is no longer needed, it can be permanently deleted using <a href="/docs/huggingface_hub/pr_2388/en/package_reference/hf_api#huggingface_hub.HfApi.delete_webhook">delete_webhook()</a>.',Fe,x,Xe,N,Ee,q,Bt=`The base class that we will use in this guides section is <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. It is a class for easily configuring a server that
can receive webhooks from the Huggingface Hub. The server is based on a <a href="https://gradio.app/" rel="nofollow">Gradio</a> app. It has a UI
to display instructions for you or your users and an API to listen to webhooks.`,Qe,T,Le,J,xe,z,Ne,A,Ct=`Implementing a webhook endpoint is as simple as decorating a function. Let’s see a first example to explain the main
concepts:`,qe,P,ze,D,St="Save this snippet in a file called <code>&#39;app.py&#39;</code> and run it with <code>&#39;python app.py&#39;</code>. You should see a message like this:",Ae,O,Pe,K,Yt="Good job! You just launched a webhook server! Let’s break down what happened exactly:",De,ee,Ht=`<li>By decorating a function with <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.webhook_endpoint">webhook_endpoint()</a>, a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object has been created in the background.
As you can see, this server is a Gradio app running on <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a>. If you open this URL in your browser, you
will see a landing page with instructions about the registered webhooks.</li> <li>A Gradio app is a FastAPI server under the hood. A new POST route <code>/webhooks/trigger_training</code> has been added to it.
This is the route that will listen to webhooks and run the <code>trigger_training</code> function when triggered. FastAPI will
automatically parse the payload and pass it to the function as a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhookPayload">WebhookPayload</a> object. This is a <code>pydantic</code> object
that contains all the information about the event that triggered the webhook.</li> <li>The Gradio app also opened a tunnel to receive requests from the internet. This is the interesting part: you can
configure a Webhook on <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> pointing to your local machine. This is useful for
debugging your webhook server and quickly iterating before deploying it to a Space.</li> <li>Finally, the logs also tell you that your server is currently not secured by a secret. This is not problematic for
local debugging but is to keep in mind for later.</li>`,Oe,U,Ke,te,et,ae,Vt=`Now that you have a webhook server running, you want to configure a Webhook to start receiving messages.
Go to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, click on “Add a new webhook” and configure your Webhook. Set the target
repositories you want to watch and the Webhook URL, here <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,tt,j,Rt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',at,se,Ft=`And that’s it! You can now trigger that webhook by updating the target repository (e.g. push a commit). Check the
Activity tab of your Webhook to see the events that have been triggered. Now that you have a working setup, you can
test it and quickly iterate. If you modify your code and restart the server, your public URL might change. Make sure
to update the webhook configuration on the Hub if needed.`,st,le,lt,ne,Xt=`Now that you have a working webhook server, the goal is to deploy it to a Space. Go to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>
to create a Space. Give it a name, select the Gradio SDK and click on “Create Space”. Upload your code to the Space
in a file called <code>app.py</code>. Your Space will start automatically! For more details about Spaces, please refer to this
<a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">guide</a>.`,nt,oe,Et=`Your webhook server is now running on a public Space. If most cases, you will want to secure it with a secret. Go to
your Space settings &gt; Section “Repository secrets” &gt; “Add a secret”. Set the <code>WEBHOOK_SECRET</code> environment variable to
the value of your choice. Go back to the <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhooks settings</a> and set the
secret in the webhook configuration. Now, only requests with the correct secret will be accepted by your server.`,ot,ie,Qt=`And this is it! Your Space is now ready to receive webhooks from the Hub. Please keep in mind that if you run the Space
on a free ‘cpu-basic’ hardware, it will be shut down after 48 hours of inactivity. If you need a permanent Space, you
should consider setting to an <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a>.`,it,he,ht,pe,Lt=`The guide above explained the quickest way to setup a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. In this section, we will see how to customize
it further.`,pt,re,rt,ce,xt=`You can register multiple endpoints on the same server. For example, you might want to have one endpoint to trigger
a training job and another one to trigger a model evaluation. You can do this by adding multiple <code>@webhook_endpoint</code>
decorators:`,ct,ue,ut,de,Nt="Which will create two endpoints:",dt,we,wt,be,bt,ye,qt=`To get more flexibility, you can also create a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object directly. This is useful if you want to
customize the landing page of your server. You can do this by passing a <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a>
that will overwrite the default one. For example, you can add instructions for your users or add a form to manually
trigger the webhooks. When creating a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>, you can register new webhooks using the
<code>add_webhook()</code> decorator.`,yt,ge,zt="Here is a complete example:",gt,Me,Mt,me,At=`<li>We define a custom UI using Gradio blocks. This UI will be displayed on the landing page of the server.</li> <li>We create a <a href="/docs/huggingface_hub/pr_2388/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object with a custom UI and a secret. The secret is optional and can be set with
the <code>WEBHOOK_SECRET</code> environment variable.</li> <li>We register a webhook with an explicit name. This will create an endpoint at <code>/webhooks/say_hello</code>.</li> <li>We register a webhook with an implicit name. This will create an endpoint at <code>/webhooks/goodbye</code>.</li> <li>We start the server. This is optional as your server will automatically be started at the end of the script.</li>`,mt,fe,ft,ke,kt;return v=new g({props:{title:"Webhooks",local:"webhooks",headingTag:"h1"}}),W=new g({props:{title:"Managing Webhooks",local:"managing-webhooks",headingTag:"h2"}}),Z=new g({props:{title:"Creating a Webhook",local:"creating-a-webhook",headingTag:"h3"}}),B=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMENyZWF0aW5nJTIwYSUyMHdlYmhvb2slMEF3ZWJob29rJTIwJTNEJTIwY3JlYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkZ3ZWJob29rLnNpdGUlMkZ5b3VyLWN1c3RvbS11cmwlMjIlMkMlMEElMjAlMjAlMjAlMjB3YXRjaGVkJTNEJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIyeW91ci11c2VybmFtZSUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIyeW91ci1vcmctbmFtZSUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTJDJTIwJTIyZGlzY3Vzc2lvbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldCUzRCUyMnlvdXItc2VjcmV0JTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook

<span class="hljs-comment"># Example: Creating a webhook</span>
webhook = create_webhook(
    url=<span class="hljs-string">&quot;https://webhook.site/your-custom-url&quot;</span>,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-username&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-org-name&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;your-secret&quot;</span>
)`,wrap:!1}}),C=new g({props:{title:"Listing Webhooks",local:"listing-webhooks",headingTag:"h3"}}),Y=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwTGlzdGluZyUyMGFsbCUyMHdlYmhvb2tzJTBBd2ViaG9va3MlMjAlM0QlMjBsaXN0X3dlYmhvb2tzKCklMEFmb3IlMjB3ZWJob29rJTIwaW4lMjB3ZWJob29rcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHdlYmhvb2sp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks

<span class="hljs-comment"># Example: Listing all webhooks</span>
webhooks = list_webhooks()
<span class="hljs-keyword">for</span> webhook <span class="hljs-keyword">in</span> webhooks:
    <span class="hljs-built_in">print</span>(webhook)`,wrap:!1}}),H=new g({props:{title:"Updating a Webhook",local:"updating-a-webhook",headingTag:"h3"}}),R=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMFVwZGF0aW5nJTIwYSUyMHdlYmhvb2slMEF1cGRhdGVkX3dlYmhvb2slMjAlM0QlMjB1cGRhdGVfd2ViaG9vayglMEElMjAlMjAlMjAlMjB3ZWJob29rX2lkJTNEJTIyeW91ci13ZWJob29rLWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkZuZXcud2ViaG9vay5zaXRlJTJGdXJsJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2F0Y2hlZCUzRCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMm5ldy11c2VybmFtZSUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook

<span class="hljs-comment"># Example: Updating a webhook</span>
updated_webhook = update_webhook(
    webhook_id=<span class="hljs-string">&quot;your-webhook-id&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/url&quot;</span>,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;new-username&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>]
)`,wrap:!1}}),F=new g({props:{title:"Enabling and Disabling Webhooks",local:"enabling-and-disabling-webhooks",headingTag:"h3"}}),E=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTJDJTIwZGlzYWJsZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMEVuYWJsaW5nJTIwYSUyMHdlYmhvb2slMEFlbmFibGVkX3dlYmhvb2slMjAlM0QlMjBlbmFibGVfd2ViaG9vayglMjJ5b3VyLXdlYmhvb2staWQlMjIpJTBBcHJpbnQoJTIyRW5hYmxlZCUzQSUyMiUyQyUyMGVuYWJsZWRfd2ViaG9vayklMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwRGlzYWJsaW5nJTIwYSUyMHdlYmhvb2slMEFkaXNhYmxlZF93ZWJob29rJTIwJTNEJTIwZGlzYWJsZV93ZWJob29rKCUyMnlvdXItd2ViaG9vay1pZCUyMiklMEFwcmludCglMjJEaXNhYmxlZCUzQSUyMiUyQyUyMGRpc2FibGVkX3dlYmhvb2sp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook, disable_webhook

<span class="hljs-comment"># Example: Enabling a webhook</span>
enabled_webhook = enable_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Enabled:&quot;</span>, enabled_webhook)

<span class="hljs-comment"># Example: Disabling a webhook</span>
disabled_webhook = disable_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Disabled:&quot;</span>, disabled_webhook)`,wrap:!1}}),Q=new g({props:{title:"Deleting a Webhook",local:"deleting-a-webhook",headingTag:"h3"}}),x=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMERlbGV0aW5nJTIwYSUyMHdlYmhvb2slMEFkZWxldGVfd2ViaG9vayglMjJ5b3VyLXdlYmhvb2staWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook

<span class="hljs-comment"># Example: Deleting a webhook</span>
delete_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)`,wrap:!1}}),N=new g({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h2"}}),T=new Jt({props:{$$slots:{default:[ia]},$$scope:{ctx:k}}}),J=new Jt({props:{warning:!0,$$slots:{default:[ha]},$$scope:{ctx:k}}}),z=new g({props:{title:"Create an endpoint",local:"create-an-endpoint",headingTag:"h3"}}),P=new f({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...`,wrap:!1}}),O=new f({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization:
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),U=new Jt({props:{warning:!0,$$slots:{default:[pa]},$$scope:{ctx:k}}}),te=new g({props:{title:"Configure a Webhook",local:"configure-a-webhook",headingTag:"h3"}}),le=new g({props:{title:"Deploy to a Space",local:"deploy-to-a-space",headingTag:"h3"}}),he=new g({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),re=new g({props:{title:"Multiple endpoints",local:"multiple-endpoints",headingTag:"h4"}}),ue=new f({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJpZ2dlciUyMGFuJTIwZXZhbHVhdGlvbiUyMGpvYiUyMGlmJTIwYSUyMG1vZGVsJTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger an evaluation job if a model is updated</span>
        ...`,wrap:!1}}),we=new f({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),be=new g({props:{title:"Custom server",local:"custom-server",headingTag:"h4"}}),Me=new f({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBEZWZpbmUlMjAlMjBVSSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwdWklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMFdlYmhvb2tzU2VydmVyJTIwd2l0aCUyMGN1c3RvbSUyMFVJJTIwYW5kJTIwc2VjcmV0JTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFJlZ2lzdGVyJTIwd2ViaG9vayUyMHdpdGglMjBleHBsaWNpdCUyMG5hbWUlMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwUmVnaXN0ZXIlMjB3ZWJob29rJTIwd2l0aCUyMGltcGxpY2l0JTIwbmFtZSUwQSU0MGFwcC5hZGRfd2ViaG9vayUwQWFzeW5jJTIwZGVmJTIwZ29vZGJ5ZShwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZSUyMiUzQSUyMCUyMmdvb2RieWUlMjIlN0QlMEElMEElMjMlMjA1LiUyMFN0YXJ0JTIwc2VydmVyJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Define  UI</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Create WebhooksServer with custom UI and secret</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Register webhook with explicit name</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Register webhook with implicit name</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Start server (optional)</span>
app.run()`,wrap:!1}}),fe=new oa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/webhooks.md"}}),{c(){o=i("meta"),M=l(),y=i("p"),m=l(),p(v.$$.fragment),Te=l(),$=i("p"),$.innerHTML=jt,Je=l(),I=i("p"),I.innerHTML=vt,Ue=l(),p(W.$$.fragment),je=l(),_=i("p"),_.innerHTML=$t,ve=l(),p(Z.$$.fragment),$e=l(),G=i("p"),G.innerHTML=It,Ie=l(),p(B.$$.fragment),We=l(),p(C.$$.fragment),_e=l(),S=i("p"),S.innerHTML=Wt,Ze=l(),p(Y.$$.fragment),Ge=l(),p(H.$$.fragment),Be=l(),V=i("p"),V.innerHTML=_t,Ce=l(),p(R.$$.fragment),Se=l(),p(F.$$.fragment),Ye=l(),X=i("p"),X.innerHTML=Zt,He=l(),p(E.$$.fragment),Ve=l(),p(Q.$$.fragment),Re=l(),L=i("p"),L.innerHTML=Gt,Fe=l(),p(x.$$.fragment),Xe=l(),p(N.$$.fragment),Ee=l(),q=i("p"),q.innerHTML=Bt,Qe=l(),p(T.$$.fragment),Le=l(),p(J.$$.fragment),xe=l(),p(z.$$.fragment),Ne=l(),A=i("p"),A.textContent=Ct,qe=l(),p(P.$$.fragment),ze=l(),D=i("p"),D.innerHTML=St,Ae=l(),p(O.$$.fragment),Pe=l(),K=i("p"),K.textContent=Yt,De=l(),ee=i("ol"),ee.innerHTML=Ht,Oe=l(),p(U.$$.fragment),Ke=l(),p(te.$$.fragment),et=l(),ae=i("p"),ae.innerHTML=Vt,tt=l(),j=i("div"),j.innerHTML=Rt,at=l(),se=i("p"),se.textContent=Ft,st=l(),p(le.$$.fragment),lt=l(),ne=i("p"),ne.innerHTML=Xt,nt=l(),oe=i("p"),oe.innerHTML=Et,ot=l(),ie=i("p"),ie.innerHTML=Qt,it=l(),p(he.$$.fragment),ht=l(),pe=i("p"),pe.innerHTML=Lt,pt=l(),p(re.$$.fragment),rt=l(),ce=i("p"),ce.innerHTML=xt,ct=l(),p(ue.$$.fragment),ut=l(),de=i("p"),de.textContent=Nt,dt=l(),p(we.$$.fragment),wt=l(),p(be.$$.fragment),bt=l(),ye=i("p"),ye.innerHTML=qt,yt=l(),ge=i("p"),ge.textContent=zt,gt=l(),p(Me.$$.fragment),Mt=l(),me=i("ol"),me.innerHTML=At,mt=l(),p(fe.$$.fragment),ft=l(),ke=i("p"),this.h()},l(e){const t=la("svelte-u9bgzb",document.head);o=h(t,"META",{name:!0,content:!0}),t.forEach(a),M=n(e),y=h(e,"P",{}),Kt(y).forEach(a),m=n(e),r(v.$$.fragment,e),Te=n(e),$=h(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-10vagzm"&&($.innerHTML=jt),Je=n(e),I=h(e,"P",{"data-svelte-h":!0}),b(I)!=="svelte-p4l94c"&&(I.innerHTML=vt),Ue=n(e),r(W.$$.fragment,e),je=n(e),_=h(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-1ao4rts"&&(_.innerHTML=$t),ve=n(e),r(Z.$$.fragment,e),$e=n(e),G=h(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-exddtt"&&(G.innerHTML=It),Ie=n(e),r(B.$$.fragment,e),We=n(e),r(C.$$.fragment,e),_e=n(e),S=h(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1ygw6nu"&&(S.innerHTML=Wt),Ze=n(e),r(Y.$$.fragment,e),Ge=n(e),r(H.$$.fragment,e),Be=n(e),V=h(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-1ha346p"&&(V.innerHTML=_t),Ce=n(e),r(R.$$.fragment,e),Se=n(e),r(F.$$.fragment,e),Ye=n(e),X=h(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1sz0mme"&&(X.innerHTML=Zt),He=n(e),r(E.$$.fragment,e),Ve=n(e),r(Q.$$.fragment,e),Re=n(e),L=h(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-kq8cm3"&&(L.innerHTML=Gt),Fe=n(e),r(x.$$.fragment,e),Xe=n(e),r(N.$$.fragment,e),Ee=n(e),q=h(e,"P",{"data-svelte-h":!0}),b(q)!=="svelte-1hjpwfw"&&(q.innerHTML=Bt),Qe=n(e),r(T.$$.fragment,e),Le=n(e),r(J.$$.fragment,e),xe=n(e),r(z.$$.fragment,e),Ne=n(e),A=h(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-1dl6tkz"&&(A.textContent=Ct),qe=n(e),r(P.$$.fragment,e),ze=n(e),D=h(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-nkdywa"&&(D.innerHTML=St),Ae=n(e),r(O.$$.fragment,e),Pe=n(e),K=h(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-bjh0uv"&&(K.textContent=Yt),De=n(e),ee=h(e,"OL",{"data-svelte-h":!0}),b(ee)!=="svelte-1hfmejk"&&(ee.innerHTML=Ht),Oe=n(e),r(U.$$.fragment,e),Ke=n(e),r(te.$$.fragment,e),et=n(e),ae=h(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-febs9a"&&(ae.innerHTML=Vt),tt=n(e),j=h(e,"DIV",{class:!0,"data-svelte-h":!0}),b(j)!=="svelte-9ld38f"&&(j.innerHTML=Rt),at=n(e),se=h(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-1sr65c9"&&(se.textContent=Ft),st=n(e),r(le.$$.fragment,e),lt=n(e),ne=h(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-apq0kg"&&(ne.innerHTML=Xt),nt=n(e),oe=h(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1h3f73"&&(oe.innerHTML=Et),ot=n(e),ie=h(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-1cxtt3c"&&(ie.innerHTML=Qt),it=n(e),r(he.$$.fragment,e),ht=n(e),pe=h(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1d301tp"&&(pe.innerHTML=Lt),pt=n(e),r(re.$$.fragment,e),rt=n(e),ce=h(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-gotrx0"&&(ce.innerHTML=xt),ct=n(e),r(ue.$$.fragment,e),ut=n(e),de=h(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-o8x9sv"&&(de.textContent=Nt),dt=n(e),r(we.$$.fragment,e),wt=n(e),r(be.$$.fragment,e),bt=n(e),ye=h(e,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-19jagj2"&&(ye.innerHTML=qt),yt=n(e),ge=h(e,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-1plkp10"&&(ge.textContent=zt),gt=n(e),r(Me.$$.fragment,e),Mt=n(e),me=h(e,"OL",{"data-svelte-h":!0}),b(me)!=="svelte-31aah"&&(me.innerHTML=At),mt=n(e),r(fe.$$.fragment,e),ft=n(e),ke=h(e,"P",{}),Kt(ke).forEach(a),this.h()},h(){Tt(o,"name","hf:doc:metadata"),Tt(o,"content",ca),Tt(j,"class","flex justify-center")},m(e,t){na(document.head,o),s(e,M,t),s(e,y,t),s(e,m,t),c(v,e,t),s(e,Te,t),s(e,$,t),s(e,Je,t),s(e,I,t),s(e,Ue,t),c(W,e,t),s(e,je,t),s(e,_,t),s(e,ve,t),c(Z,e,t),s(e,$e,t),s(e,G,t),s(e,Ie,t),c(B,e,t),s(e,We,t),c(C,e,t),s(e,_e,t),s(e,S,t),s(e,Ze,t),c(Y,e,t),s(e,Ge,t),c(H,e,t),s(e,Be,t),s(e,V,t),s(e,Ce,t),c(R,e,t),s(e,Se,t),c(F,e,t),s(e,Ye,t),s(e,X,t),s(e,He,t),c(E,e,t),s(e,Ve,t),c(Q,e,t),s(e,Re,t),s(e,L,t),s(e,Fe,t),c(x,e,t),s(e,Xe,t),c(N,e,t),s(e,Ee,t),s(e,q,t),s(e,Qe,t),c(T,e,t),s(e,Le,t),c(J,e,t),s(e,xe,t),c(z,e,t),s(e,Ne,t),s(e,A,t),s(e,qe,t),c(P,e,t),s(e,ze,t),s(e,D,t),s(e,Ae,t),c(O,e,t),s(e,Pe,t),s(e,K,t),s(e,De,t),s(e,ee,t),s(e,Oe,t),c(U,e,t),s(e,Ke,t),c(te,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,j,t),s(e,at,t),s(e,se,t),s(e,st,t),c(le,e,t),s(e,lt,t),s(e,ne,t),s(e,nt,t),s(e,oe,t),s(e,ot,t),s(e,ie,t),s(e,it,t),c(he,e,t),s(e,ht,t),s(e,pe,t),s(e,pt,t),c(re,e,t),s(e,rt,t),s(e,ce,t),s(e,ct,t),c(ue,e,t),s(e,ut,t),s(e,de,t),s(e,dt,t),c(we,e,t),s(e,wt,t),c(be,e,t),s(e,bt,t),s(e,ye,t),s(e,yt,t),s(e,ge,t),s(e,gt,t),c(Me,e,t),s(e,Mt,t),s(e,me,t),s(e,mt,t),c(fe,e,t),s(e,ft,t),s(e,ke,t),kt=!0},p(e,[t]){const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),T.$set(Pt);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),J.$set(Dt);const Ot={};t&2&&(Ot.$$scope={dirty:t,ctx:e}),U.$set(Ot)},i(e){kt||(u(v.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(C.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(x.$$.fragment,e),u(N.$$.fragment,e),u(T.$$.fragment,e),u(J.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(U.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(he.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(fe.$$.fragment,e),kt=!0)},o(e){d(v.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(C.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(x.$$.fragment,e),d(N.$$.fragment,e),d(T.$$.fragment,e),d(J.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(U.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(he.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(be.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),kt=!1},d(e){e&&(a(M),a(y),a(m),a(Te),a($),a(Je),a(I),a(Ue),a(je),a(_),a(ve),a($e),a(G),a(Ie),a(We),a(_e),a(S),a(Ze),a(Ge),a(Be),a(V),a(Ce),a(Se),a(Ye),a(X),a(He),a(Ve),a(Re),a(L),a(Fe),a(Xe),a(Ee),a(q),a(Qe),a(Le),a(xe),a(Ne),a(A),a(qe),a(ze),a(D),a(Ae),a(Pe),a(K),a(De),a(ee),a(Oe),a(Ke),a(et),a(ae),a(tt),a(j),a(at),a(se),a(st),a(lt),a(ne),a(nt),a(oe),a(ot),a(ie),a(it),a(ht),a(pe),a(pt),a(rt),a(ce),a(ct),a(ut),a(de),a(dt),a(wt),a(bt),a(ye),a(yt),a(ge),a(gt),a(Mt),a(me),a(mt),a(ft),a(ke)),a(o),w(v,e),w(W,e),w(Z,e),w(B,e),w(C,e),w(Y,e),w(H,e),w(R,e),w(F,e),w(E,e),w(Q,e),w(x,e),w(N,e),w(T,e),w(J,e),w(z,e),w(P,e),w(O,e),w(U,e),w(te,e),w(le,e),w(he,e),w(re,e),w(ue,e),w(we,e),w(be,e),w(Me,e),w(fe,e)}}}const ca='{"title":"Webhooks","local":"webhooks","sections":[{"title":"Managing Webhooks","local":"managing-webhooks","sections":[{"title":"Creating a Webhook","local":"creating-a-webhook","sections":[],"depth":3},{"title":"Listing Webhooks","local":"listing-webhooks","sections":[],"depth":3},{"title":"Updating a Webhook","local":"updating-a-webhook","sections":[],"depth":3},{"title":"Enabling and Disabling Webhooks","local":"enabling-and-disabling-webhooks","sections":[],"depth":3},{"title":"Deleting a Webhook","local":"deleting-a-webhook","sections":[],"depth":3}],"depth":2},{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Create an endpoint","local":"create-an-endpoint","sections":[],"depth":3},{"title":"Configure a Webhook","local":"configure-a-webhook","sections":[],"depth":3},{"title":"Deploy to a Space","local":"deploy-to-a-space","sections":[],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Multiple endpoints","local":"multiple-endpoints","sections":[],"depth":4},{"title":"Custom server","local":"custom-server","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function ua(k){return ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends aa{constructor(o){super(),sa(this,o,ua,ra,ea,{})}}export{Ma as component};
