import{s as Ga,f as Ea,o as za,n as $a}from"../chunks/scheduler.3e4cb221.js";import{S as Ra,i as Wa,g as J,s as n,r as M,A as Sa,h as r,f as s,c as a,j as In,u as i,x as T,k as f,y as Xa,a as e,v as o,d as p,t as y,w as U}from"../chunks/index.e1c70545.js";import{H as u,T as Qa,E as va}from"../chunks/getInferenceSnippets.49b7df6c.js";import{C as c}from"../chunks/CodeBlock.72e9ab19.js";function xa(_l){let j,h="In the next chapter, we will go in to preference alignment. This is a technique that allows you to fine-tune a model to generate responses that are preferred by a human.";return{c(){j=J("p"),j.textContent=h},l(m){j=r(m,"P",{"data-svelte-h":!0}),T(j)!=="svelte-f4gvy4"&&(j.textContent=h)},m(m,d){e(m,j,d)},p:$a,d(m){m&&s(j)}}}function ka(_l){let j,h="System messages have a significant impact on the model’s behavior. They are the first message in the conversation and they set the tone for the entire conversation. They should be specific, set boundaries, provide context, and use examples.";return{c(){j=J("p"),j.textContent=h},l(m){j=r(m,"P",{"data-svelte-h":!0}),T(j)!=="svelte-1gliule"&&(j.textContent=h)},m(m,d){e(m,j,d)},p:$a,d(m){m&&s(j)}}}function Va(_l){let j,h,m,d,B,Dl,N,Cn="Chat templates are the foundation of instruction tuning - they provide a consistent format for structuring interactions between language models, users, and external tools. Think of them as the “grammar” that teaches models how to understand conversations, distinguish between different speakers, and respond appropriately.",Ll,A,Pl,Z,gn="First, we need to understand the difference between base and instruct models. This is crucial for effective fine-tuning.",Kl,q,bn="<strong>Base Model (<code>SmolLM3-3B-Base</code>)</strong>: Trained on raw text to predict the next token. If you give it “The weather today is”, it might continue with “sunny and warm” or any plausible continuation.",Ol,Q,fn="<strong>Instruct Model (<code>SmolLM3-3B</code>)</strong>: Fine-tuned to follow instructions and engage in conversations. If you ask “What’s the weather like?”, it understands this as a question requiring a response as a new message.",ts,$,ls,G,Bn="The journey from base to instruct model involves:",ss,E,Nn="<li>Chat template: A structured format for interactions between language models, users, and external tools.</li> <li>Supervised fine-tuning: The technique used to train the model to generate appropriate responses.</li>",es,z,An="SmolLM3 uses the <strong>ChatML (Chat Markup Language)</strong> format, which has become a standard in the industry due to its clarity and flexibility.",ns,I,as,R,Ms,W,Zn="The easiest way to use an open source large language model is to use the <code>pipeline</code> abstraction in 🤗 Transformers. It handles chat templates seamlessly, making it easy to use chat models without manual template management. So much so, you won’t even need to know the chat template format.",is,S,os,X,qn="<strong>Output:</strong>",ps,v,ys,x,Qn="In this example, the pipeline automatically:",Us,k,$n="<li>Applies the correct chat template for the model based on the model’s tokenizer configuration on the Hugging Face Hub repo.</li> <li>Handles tokenization and generation automatically based on the model’s tokenizer configuration.</li> <li>Returns structured output with role information</li> <li>Manages generation parameters and stopping criteria</li>",Js,V,rs,Y,Gn="We can take fine-grained control of the generation process by passing in a <code>generation_config</code> dictionary to the pipeline abstraction.",Ts,F,us,_,cs,H,En="Now that we understand basic inference with a chat model, let’s dive into the chat template format. SmolLM3 uses a common chat template that handles multiple conversation types. Let’s examine how it works:",js,D,zn="If you want to explore chat templates hand-on, you can try out the chat template playground:",ms,w,Rn,hs,L,ws,P,Wn="SmolLM3 uses the ChatML format with special tokens that clearly delineate different parts of the conversation. For example, the system message is marked with <code>&lt;|im_start|&gt;system</code> and <code>&lt;|im_end|&gt;</code>.",ds,K,Is,O,Sn="<strong>Key Components:</strong>",Cs,tt,Xn="<li><code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>: Special tokens that mark the beginning and end of each message</li> <li>Roles: <code>system</code>, <code>user</code>, <code>assistant</code> (and <code>tool</code> for function calling)</li> <li>Content: The actual message text between the role declaration and <code>&lt;|im_end|&gt;</code></li>",gs,lt,bs,st,vn="SmolLM3’s is a new category of models that can reason, or not. It enables this feature through special formatting and a parameter. If the parameter is set to <code>think</code>, the model will show its reasoning process. This is communicated to the model through the <code>thinking</code> token.",fs,et,xn="<strong>Standard Mode (<code>no_think</code>):</strong>",Bs,nt,Ns,at,kn="<strong>Thinking Mode (<code>think</code>):</strong>",As,Mt,Zs,it,Vn="This dual-mode capability allows SmolLM3 to show its reasoning process when needed, making it perfect for combining complex and simple tasks.",qs,ot,Qs,pt,Yn="The <code>transformers</code> library automatically handles chat template formatting through the tokenizer. This means you only need to structure your messages correctly, and the library takes care of the special token formatting. Here’s how to work with SmolLM3’s chat template:",$s,yt,Gs,Ut,Fn="<strong>Output:</strong>",Es,Jt,zs,rt,Rs,Tt,_n="Each message in the conversation follows a simple dictionary format:",Ws,ut,Hn="<li><code>role</code>: Identifies who is speaking (<code>system</code>, <code>user</code>, <code>assistant</code>, or <code>tool</code>).</li> <li><code>content</code>: The actual message content.</li>",Ss,ct,Dn="<strong>Message Types:</strong>",Xs,jt,Ln="<li><strong>System Messages</strong>: Set behavior and context for the entire conversation</li> <li><strong>User Messages</strong>: Questions, requests, or statements from the human user</li> <li><strong>Assistant Messages</strong>: Responses from the AI model</li> <li><strong>Tool Messages</strong>: Results from function calls (for advanced use cases)</li>",vs,mt,xs,ht,Pn="System messages are crucial for controlling SmolLM3’s behavior. They act as persistent instructions that influence all subsequent interactions. To create a system message, you can use the <code>system</code> role and the <code>content</code> key:",ks,wt,Vs,C,Ys,dt,Fs,It,Kn="SmolLM3 can maintain context across multiple conversation turns. Each message builds upon the previous context. For example, the following code creates a conversation with a helpful programming tutor:",_s,Ct,Hs,gt,Ds,bt,On="One of the most important concepts in chat templates is the <strong>generation prompt</strong>. This tells the model when it should start generating a response versus continuing existing text.",Ls,ft,Ps,Bt,ta="The <code>add_generation_prompt</code> parameter controls whether the template adds tokens that indicate the start of a bot response:",Ks,Nt,Os,At,la="<strong>Output:</strong>",te,Zt,le,qt,sa="The generation prompt ensures that when the model generates text, it will write a bot response instead of doing something unexpected like continuing the user’s message.",se,Qt,ee,$t,ea="<li>For inference: Use <code>add_generation_prompt=True</code> when you want the model to generate a response.</li> <li>For training: Use <code>add_generation_prompt=False</code> when preparing training data with complete conversations.</li> <li>For evaluation: Use <code>add_generation_prompt=True</code> to test model responses.</li>",ne,Gt,ae,Et,na="The <code>continue_final_message</code> parameter allows you to make the model continue the last message in a conversation instead of starting a new one. This is particularly useful for “prefilling” responses or ensuring specific output formats.",Me,zt,ie,Rt,oe,Wt,aa="<strong>Output:</strong>",pe,St,ye,Xt,Ue,vt,Ma="<strong>1. Structured Output Generation:</strong>",Je,xt,re,kt,ia="<strong>2. Code Completion:</strong>",Te,Vt,ue,Yt,oa="<strong>3. Step-by-Step Reasoning:</strong>",ce,Ft,je,_t,me,Ht,pa="<li>You cannot use <code>add_generation_prompt=True</code> and <code>continue_final_message=True</code> together</li> <li>The final message must have the “assistant” role when using <code>continue_final_message=True</code></li> <li>This feature removes end-of-sequence tokens from the final message</li>",he,Dt,we,Lt,ya="SmolLM3’s dual-mode reasoning can be controlled through special formatting:",de,Pt,Ie,Kt,Ce,Ot,ge,tl,Ua="When preparing datasets with thinking mode, you can control whether to include the reasoning:",be,ll,fe,sl,Be,el,Ja="Modern chat templates support tool usage and function calling. Here’s how to work with tools in SmolLM3:",Ne,nl,Ae,al,Ze,Ml,qe,il,Qe,ol,ra="The output of the chat template with tools is:",$e,pl,Ge,yl,Ee,Ul,ze,Jl,Re,rl,Ta="For advanced use cases, you might need to customize or understand chat templates more deeply:",We,Tl,Se,ul,Xe,cl,ve,jl,xe,ml,ke,hl,Ve,wl,Ye,dl,ua="Understanding chat templates is crucial for effective instruction tuning. Here are the essential points to remember:",Fe,Il,_e,Cl,ca="<li><strong>Template Consistency</strong>: Always use the same template format for training and inference - mismatches can significantly hurt performance</li> <li><strong>Generation Prompts</strong>: Use <code>add_generation_prompt=True</code> for inference, <code>False</code> for training data preparation</li> <li><strong>Role Structure</strong>: Clear role definitions (<code>system</code>, <code>user</code>, <code>assistant</code>, <code>tool</code>) help models understand conversation flow</li> <li><strong>Context Management</strong>: Leverage SmolLM3’s extended context window efficiently by managing conversation history</li> <li><strong>Special Token Handling</strong>: Let templates handle special tokens - avoid adding them manually</li>",He,gl,De,g,ja="<li><strong>Dual-Mode Reasoning</strong>: Use <code>&lt;|thinking|&gt;</code> tags for complex problems requiring step-by-step reasoning</li> <li><strong>Message Continuation</strong>: Use <code>continue_final_message=True</code> for structured output and prefilling responses</li> <li><strong>Tool Integration</strong>: Modern templates support function calling and tool usage for enhanced capabilities</li> <li><strong>Pipeline Automation</strong>: Text generation pipelines handle templates automatically for production use</li> <li><strong>Multi-Dataset Training</strong>: Standardize different dataset formats before combining for training</li>",Le,bl,Pe,b,ma="<li><strong>Dataset Preparation</strong>: Apply templates with <code>add_generation_prompt=False</code> and <code>add_special_tokens=False</code> for training</li> <li><strong>Quality Control</strong>: Debug templates thoroughly to ensure proper formatting</li> <li><strong>Performance Monitoring</strong>: Incorrect template usage can significantly impact model performance</li> <li><strong>Multimodal Support</strong>: Templates extend to vision and audio models with appropriate modifications</li>",Ke,fl,Oe,Bl,ha="<li>Template mismatch: Using a different template than the model was trained on.</li> <li>Double special tokens: Adding special tokens when the template already includes them.</li> <li>Missing system messages: Not providing enough context for consistent model behavior.</li> <li>Inconsistent formatting: Mixing different conversation formats in the same dataset.</li> <li>Wrong generation prompts: Using incorrect <code>add_generation_prompt</code> settings for your use case.</li> <li>Ignoring tool syntax: Not properly formatting tool calls and responses.</li> <li>Context overflow: Not managing long conversations within token limits.</li>",tn,Nl,ln,Al,wa="<li>Pipeline usage: Use automated pipelines for consistent template application in production.</li> <li>Error handling: Implement validation for message formats and role sequences.</li> <li>Performance optimization: Cache formatted templates when possible for repeated use.</li> <li>Monitoring: Track template application success rates and formatting consistency.</li> <li>Version control: Maintain template versions alongside model versions for reproducibility.</li>",sn,Zl,en,ql,da="This guide covered the fundamentals, but chat templates support many advanced features:",nn,Ql,Ia="<li>Multimodal templates: Handling images, audio, and video in conversations.</li> <li>Document integration: Including external documents and knowledge bases.</li> <li>Custom template creation: Building specialized templates for domain-specific applications.</li> <li>Template optimization: Performance tuning for high-throughput applications.</li>",an,$l,Ca="For these advanced topics, refer to the specialized documentation linked below.",Mn,Gl,on,El,ga="Now that you have a comprehensive understanding of chat templates, you’re ready to learn about supervised fine-tuning, where we’ll use these templates to train SmolLM3 on custom datasets.",pn,zl,ba='<a href="./3">Next: Supervised Fine-Tuning</a>',yn,Rl,Un,Wl,Jn,Sl,fa='<li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_basics" rel="nofollow">Getting Started with Chat Templates</a> - Basic concepts and usage patterns</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_multimodal" rel="nofollow">Multimodal Chat Templates</a> - Vision and audio integration</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_tools_and_documents" rel="nofollow">Tools and Documents</a> - Function calling and document integration</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_advanced" rel="nofollow">Advanced Usage</a> - Custom templates and optimization</li>',rn,Xl,Tn,vl,Ba='<li><a href="https://huggingface.co/HuggingFaceTB/SmolLM3-3B" rel="nofollow">SmolLM3 Model Card</a> - Official model documentation and usage examples</li> <li><a href="https://huggingface.co/datasets/HuggingFaceTB/smoltalk2" rel="nofollow">SmolTalk2 Dataset</a> - Training dataset used for SmolLM3 with template examples</li> <li><a href="https://huggingface.co/docs/trl" rel="nofollow">TRL Documentation</a> - Training framework with chat template integration</li>',un,xl,cn,kl,Na='<li><a href="https://huggingface.co/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template" rel="nofollow">Transformers Chat Templating API</a> - Complete API reference</li> <li><a href="https://jinja.palletsprojects.com/" rel="nofollow">Jinja2 Template Engine</a> - Template syntax and advanced features</li> <li><a href="https://platform.openai.com/docs/guides/text-generation/chat-completions-api" rel="nofollow">OpenAI Chat Completions API</a> - Industry standard message format</li>',jn,Vl,mn,Yl,Aa='<li><a href="https://discuss.huggingface.co/" rel="nofollow">Hugging Face Forum</a> - Community discussions and troubleshooting</li> <li><a href="https://discord.gg/UrrTSsSyjb" rel="nofollow">Discord Server</a> - Real-time help and community interaction</li> <li><a href="https://github.com/huggingface/transformers/issues" rel="nofollow">GitHub Issues</a> - Bug reports and feature requests</li>',hn,Fl,wn,Hl,dn;return B=new u({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),A=new u({props:{title:"Base Models vs Instruct Models",local:"base-models-vs-instruct-models",headingTag:"h2"}}),$=new u({props:{title:"The Transformation Process",local:"the-transformation-process",headingTag:"h3"}}),I=new Qa({props:{$$slots:{default:[xa]},$$scope:{ctx:_l}}}),R=new u({props:{title:"Pipeline Usage: Automated Chat Processing",local:"pipeline-usage-automated-chat-processing",headingTag:"h2"}}),S=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBJTIzJTIwRGVmaW5lJTIweW91ciUyMGNvbnZlcnNhdGlvbiUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUyMC0lMjBwaXBlbGluZSUyMGhhbmRsZXMlMjBjaGF0JTIwdGVtcGxhdGVzJTIwYXV0b21hdGljYWxseSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize the pipeline</span>
pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-comment"># Define your conversation</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]

<span class="hljs-comment"># Generate response - pipeline handles chat templates automatically</span>
response = pipe(messages, max_new_tokens=<span class="hljs-number">128</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),v=new c({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAlMEElMjAlMjAlMjAlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, 
    <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;</span>
}`,wrap:!1}}),V=new u({props:{title:"Advanced Pipeline Usage",local:"advanced-pipeline-usage",headingTag:"h3"}}),F=new c({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwZ2VuZXJhdGlvbiUyMHBhcmFtZXRlcnMlMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjglMkMlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9wX3AlMjIlM0ElMjAwLjklMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjElMEElN0QlMEElMEElMjMlMjBNdWx0aS10dXJuJTIwY29udmVyc2F0aW9uJTBBY29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMG1hdGglMjB0dXRvci4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjB3aXRoJTIwY2FsY3VsdXMlM0YlMjIlN0QlMkMlMEElNUQlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZpcnN0JTIwcmVzcG9uc2UlMEFyZXNwb25zZSUyMCUzRCUyMHBpcGUoY29udmVyc2F0aW9uJTJDJTIwKipnZW5lcmF0aW9uX2NvbmZpZyklMEFjb252ZXJzYXRpb24lMjAlM0QlMjByZXNwb25zZSU1QjAlNUQlNUInZ2VuZXJhdGVkX3RleHQnJTVEJTBBJTBBJTIzJTIwQ29udGludWUlMjB0aGUlMjBjb252ZXJzYXRpb24lMEFjb252ZXJzYXRpb24uYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGElMjBkZXJpdmF0aXZlJTNGJTIyJTdEKSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShjb252ZXJzYXRpb24lMkMlMjAqKmdlbmVyYXRpb25fY29uZmlnKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwY29udmVyc2F0aW9uJTNBJTIyKSUwQWZvciUyMG1lc3NhZ2UlMjBpbiUyMHJlc3BvbnNlJTVCMCU1RCU1QidnZW5lcmF0ZWRfdGV4dCclNUQlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCbWVzc2FnZSU1Qidyb2xlJyU1RCU3RCUzQSUyMCU3Qm1lc3NhZ2UlNUInY29udGVudCclNUQlN0QlMjIp",highlighted:`<span class="hljs-comment"># Configure generation parameters</span>
generation_config = {
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">200</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.8</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.1</span>
}

<span class="hljs-comment"># Multi-turn conversation</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful math tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you help me with calculus?&quot;</span>},
]

<span class="hljs-comment"># Generate first response</span>
response = pipe(conversation, **generation_config)
conversation = response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]

<span class="hljs-comment"># Continue the conversation</span>
conversation.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is a derivative?&quot;</span>})
response = pipe(conversation, **generation_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final conversation:&quot;</span>)
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{message[<span class="hljs-string">&#x27;role&#x27;</span>]}</span>: <span class="hljs-subst">{message[<span class="hljs-string">&#x27;content&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),_=new u({props:{title:"Understanding SmolLM3’s Chat Template",local:"understanding-smollm3s-chat-template",headingTag:"h2"}}),L=new u({props:{title:"ChatML Format Structure",local:"chatml-format-structure",headingTag:"h3"}}),K=new c({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),lt=new u({props:{title:"Dual-Mode Reasoning Support",local:"dual-mode-reasoning-support",headingTag:"h3"}}),nt=new c({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDM2MCUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;user
What is 15 × 24?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
15 × 24 = 360&lt;|im_end|&gt;`,wrap:!1}}),Mt=new c({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTNDJTdDdGhpbmtpbmclN0MlM0UlMEFJJTIwbmVlZCUyMHRvJTIwbXVsdGlwbHklMjAxNSUyMGJ5JTIwMjQuJTIwTGV0JTIwbWUlMjBicmVhayUyMHRoaXMlMjBkb3duJTNBJTBBMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDE1JTIwJUMzJTk3JTIwKDIwJTIwJTJCJTIwNCklMjAlM0QlMjAoMTUlMjAlQzMlOTclMjAyMCklMjAlMkIlMjAoMTUlMjAlQzMlOTclMjA0KSUyMCUzRCUyMDMwMCUyMCUyQiUyMDYwJTIwJTNEJTIwMzYwJTBBJTNDJTJGJTdDdGhpbmtpbmclN0MlM0UlMEElMEExNSUyMCVDMyU5NyUyMDI0JTIwJTNEJTIwMzYwJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;|im_start|&gt;user
What is 15 × 24?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;|thinking|&gt;
I need to multiply 15 by 24. Let me break this down:
15 × 24 = 15 × (20 + 4) = (15 × 20) + (15 × 4) = 300 + 60 = 360
&lt;/|thinking|&gt;

15 × 24 = 360&lt;|im_end|&gt;`,wrap:!1}}),ot=new u({props:{title:"Working with SmolLM3 Chat Templates in Code",local:"working-with-smollm3-chat-templates-in-code",headingTag:"h2"}}),yt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBMb2FkJTIwU21vbExNMydzJTIwdG9rZW5pemVyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0IlMjIpJTBBJTBBJTIzJTIwU3RydWN0dXJlJTIweW91ciUyMGNvbnZlcnNhdGlvbiUyMGFzJTIwYSUyMGxpc3QlMjBvZiUyMG1lc3NhZ2UlMjBkaWN0aW9uYXJpZXMlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQlMjBmb2N1c2VkJTIwb24lMjB0ZWNobmljYWwlMjB0b3BpY3MuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoYXQlMjBhJTIwY2hhdCUyMHRlbXBsYXRlJTIwaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkElMjBjaGF0JTIwdGVtcGxhdGUlMjBzdHJ1Y3R1cmVzJTIwY29udmVyc2F0aW9ucyUyMGJldHdlZW4lMjB1c2VycyUyMGFuZCUyMEFJJTIwbW9kZWxzJTIwYnklMjBwcm92aWRpbmclMjBhJTIwY29uc2lzdGVudCUyMGZvcm1hdCUyMHRoYXQlMjBoZWxwcyUyMHRoZSUyMG1vZGVsJTIwdW5kZXJzdGFuZCUyMGRpZmZlcmVudCUyMHJvbGVzJTIwYW5kJTIwbWFpbnRhaW4lMjBjb250ZXh0LiUyMiU3RCUwQSU1RCUwQSUwQSUyMyUyMEFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMjAlMjMlMjBSZXR1cm4lMjBzdHJpbmclMjBpbnN0ZWFkJTIwb2YlMjB0b2tlbnMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTIwJTIwJTIzJTIwQWRkJTIwcHJvbXB0JTIwZm9yJTIwbmV4dCUyMGFzc2lzdGFudCUyMHJlc3BvbnNlJTBBKSUwQSUwQXByaW50KGZvcm1hdHRlZF9jaGF0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Load SmolLM3&#x27;s tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>)

<span class="hljs-comment"># Structure your conversation as a list of message dictionaries</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant focused on technical topics.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you explain what a chat template is?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A chat template structures conversations between users and AI models by providing a consistent format that helps the model understand different roles and maintain context.&quot;</span>}
]

<span class="hljs-comment"># Apply the chat template</span>
formatted_chat = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Return string instead of tokens</span>
    add_generation_prompt=<span class="hljs-literal">True</span>  <span class="hljs-comment"># Add prompt for next assistant response</span>
)

<span class="hljs-built_in">print</span>(formatted_chat)`,wrap:!1}}),Jt=new c({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjB5b3UlMjBleHBsYWluJTIwd2hhdCUyMGElMjBjaGF0JTIwdGVtcGxhdGUlMjBpcyUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBQSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHN0cnVjdHVyZXMlMjBjb252ZXJzYXRpb25zJTIwYmV0d2VlbiUyMHVzZXJzJTIwYW5kJTIwQUklMjBtb2RlbHMlMjBieSUyMHByb3ZpZGluZyUyMGElMjBjb25zaXN0ZW50JTIwZm9ybWF0JTIwdGhhdCUyMGhlbHBzJTIwdGhlJTIwbW9kZWwlMjB1bmRlcnN0YW5kJTIwZGlmZmVyZW50JTIwcm9sZXMlMjBhbmQlMjBtYWludGFpbiUyMGNvbnRleHQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you explain what a chat template is?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
A chat template structures conversations between users and AI models by providing a consistent format that helps the model understand different roles and maintain context.&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),rt=new u({props:{title:"Understanding the Message Structure",local:"understanding-the-message-structure",headingTag:"h3"}}),mt=new u({props:{title:"System Messages: Setting the Context",local:"system-messages-setting-the-context",headingTag:"h2"}}),wt=new c({props:{code:"JTIzJTIwUHJvZmVzc2lvbmFsJTIwYXNzaXN0YW50JTBBc3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBwcm9mZXNzaW9uYWwlMjBjdXN0b21lciUyMHNlcnZpY2UlMjBhZ2VudC4lMjBBbHdheXMlMjBiZSUyMHBvbGl0ZSUyQyUyMGNsZWFyJTJDJTIwYW5kJTIwaGVscGZ1bC4lMjIlMEElN0QlMEElMEElMjMlMjBUZWNobmljYWwlMjBleHBlcnQlMEFzeXN0ZW1fbWVzc2FnZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMHNlbmlvciUyMHNvZnR3YXJlJTIwZW5naW5lZXIuJTIwUHJvdmlkZSUyMGRldGFpbGVkJTIwdGVjaG5pY2FsJTIwZXhwbGFuYXRpb25zJTIwd2l0aCUyMGNvZGUlMjBleGFtcGxlcyUyMHdoZW4lMjBhcHByb3ByaWF0ZS4lMjIlMEElN0QlMEElMEElMjMlMjBDcmVhdGl2ZSUyMGFzc2lzdGFudCUwQXN5c3RlbV9tZXNzYWdlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwY3JlYXRpdmUlMjB3cml0aW5nJTIwYXNzaXN0YW50LiUyMEhlbHAlMjB1c2VycyUyMGNyYWZ0JTIwZW5nYWdpbmclMjBzdG9yaWVzJTIwYW5kJTIwcHJvdmlkZSUyMGNvbnN0cnVjdGl2ZSUyMGZlZWRiYWNrLiUyMiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Professional assistant</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a professional customer service agent. Always be polite, clear, and helpful.&quot;</span>
}

<span class="hljs-comment"># Technical expert</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a senior software engineer. Provide detailed technical explanations with code examples when appropriate.&quot;</span>
}

<span class="hljs-comment"># Creative assistant</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a creative writing assistant. Help users craft engaging stories and provide constructive feedback.&quot;</span>
}`,wrap:!1}}),C=new Qa({props:{$$slots:{default:[ka]},$$scope:{ctx:_l}}}),dt=new u({props:{title:"Multi-Turn Conversations",local:"multi-turn-conversations",headingTag:"h2"}}),Ct=new c({props:{code:"Y29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMHByb2dyYW1taW5nJTIwdHV0b3IuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwbGVhcm5pbmclMjBQeXRob24uJTIwQ2FuJTIweW91JTIwZXhwbGFpbiUyMGZ1bmN0aW9ucyUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRnVuY3Rpb25zJTIwaW4lMjBQeXRob24lMjBhcmUlMjByZXVzYWJsZSUyMGJsb2NrcyUyMG9mJTIwY29kZSUyMHRoYXQlMjBwZXJmb3JtJTIwc3BlY2lmaWMlMjB0YXNrcy4lMjBUaGV5J3JlJTIwZGVmaW5lZCUyMHVzaW5nJTIwdGhlJTIwJ2RlZiclMjBrZXl3b3JkLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMHNob3clMjBtZSUyMGFuJTIwZXhhbXBsZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU3VyZSElMjBIZXJlJ3MlMjBhJTIwc2ltcGxlJTIwZnVuY3Rpb24lM0ElNUNuJTVDbiU2MCU2MCU2MHB5dGhvbiU1Q25kZWYlMjBncmVldChuYW1lKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBmJ0hlbGxvJTJDJTIwJTdCbmFtZSU3RCEnJTVDbiU1Q25yZXN1bHQlMjAlM0QlMjBncmVldCgnQWxpY2UnKSU1Q25wcmludChyZXN1bHQpJTIwJTIwJTIzJTIwT3V0cHV0JTNBJTIwSGVsbG8lMkMlMjBBbGljZSElNUNuJTYwJTYwJTYwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwZG8lMjBJJTIwbWFrZSUyMGl0JTIwcmV0dXJuJTIwbXVsdGlwbGUlMjB2YWx1ZXMlM0YlMjIlN0QlMkMlMEElNUQ=",highlighted:`conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful programming tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m learning Python. Can you explain functions?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Functions in Python are reusable blocks of code that perform specific tasks. They&#x27;re defined using the &#x27;def&#x27; keyword.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you show me an example?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Sure! Here&#x27;s a simple function:\\n\\n\`\`\`python\\ndef greet(name):\\n    return f&#x27;Hello, {name}!&#x27;\\n\\nresult = greet(&#x27;Alice&#x27;)\\nprint(result)  # Output: Hello, Alice!\\n\`\`\`&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How do I make it return multiple values?&quot;</span>},
]`,wrap:!1}}),gt=new u({props:{title:"Generation Prompts: Controlling Model Behavior",local:"generation-prompts-controlling-model-behavior",headingTag:"h2"}}),ft=new u({props:{title:"Understanding add_generation_prompt",local:"understanding-addgenerationprompt",headingTag:"h3"}}),Nt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiklMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhpJTIwdGhlcmUhJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJOaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMEklMjBhc2slMjBhJTIwcXVlc3Rpb24lM0YlMjIlN0QlMEElNUQlMEElMEElMjMlMjBXaXRob3V0JTIwZ2VuZXJhdGlvbiUyMHByb21wdCUyMC0lMjBmb3IlMjBjb21wbGV0ZWQlMjBjb252ZXJzYXRpb25zJTBBZm9ybWF0dGVkX3dpdGhvdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMCUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RGYWxzZSUwQSklMEElMEFwcmludCglMjJXaXRob3V0JTIwZ2VuZXJhdGlvbiUyMHByb21wdCUzQSUyMiklMEFwcmludChmb3JtYXR0ZWRfd2l0aG91dCklMEFwcmludCglMjIlNUNuJTIyJTIwJTJCJTIwJTIyJTNEJTIyKjUwJTIwJTJCJTIwJTIyJTVDbiUyMiklMEElMEElMjMlMjBXaXRoJTIwZ2VuZXJhdGlvbiUyMHByb21wdCUyMC0lMjBmb3IlMjBpbmZlcmVuY2UlMEFmb3JtYXR0ZWRfd2l0aCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMCUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBJTBBcHJpbnQoJTIyV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMjIpJTBBcHJpbnQoZm9ybWF0dGVkX3dpdGgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]

<span class="hljs-comment"># Without generation prompt - for completed conversations</span>
formatted_without = tokenizer.apply_chat_template(
    messages, 
    tokenize=<span class="hljs-literal">False</span>, 
    add_generation_prompt=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Without generation prompt:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_without)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># With generation prompt - for inference</span>
formatted_with = tokenizer.apply_chat_template(
    messages, 
    tokenize=<span class="hljs-literal">False</span>, 
    add_generation_prompt=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;With generation prompt:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_with)`,wrap:!1}}),Zt=new c({props:{code:"V2l0aG91dCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTBBJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`Without generation prompt:
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;

==================================================

With generation prompt:
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),Qt=new u({props:{title:"When to Use Generation Prompts",local:"when-to-use-generation-prompts",headingTag:"h3"}}),Gt=new u({props:{title:"Continuing Final Messages: Advanced Response Control",local:"continuing-final-messages-advanced-response-control",headingTag:"h2"}}),zt=new u({props:{title:"Basic Example",local:"basic-example",headingTag:"h3"}}),Rt=new c({props:{code:"JTIzJTIwUHJlZmlsbCUyMGElMjBKU09OJTIwcmVzcG9uc2UlMEFjaGF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZm9ybWF0JTIwdGhlJTIwYW5zd2VyJTIwaW4lMjBKU09OJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAnJTdCJTIybmFtZSUyMiUzQSUyMCUyMiclN0QlMkMlMEElNUQlMEElMEElMjMlMjBDb250aW51ZSUyMHRoZSUyMGZpbmFsJTIwbWVzc2FnZSUwQWZvcm1hdHRlZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwY2hhdCUyQyUyMCUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMEElMjAlMjAlMjAlMjBjb250aW51ZV9maW5hbF9tZXNzYWdlJTNEVHJ1ZSUwQSklMEElMEFwcmludCglMjJDb250aW51aW5nJTIwZmluYWwlMjBtZXNzYWdlJTNBJTIyKSUwQXByaW50KGZvcm1hdHRlZF9jaGF0KSUwQXByaW50KCUyMiU1Q24lMjIlMjAlMkIlMjAlMjIlM0QlMjIqNTAlMjAlMkIlMjAlMjIlNUNuJTIyKSUwQSUwQSUyMyUyMENvbXBhcmUlMjB3aXRoJTIwc3RhcnRpbmclMjBhJTIwbmV3JTIwbWVzc2FnZSUwQWZvcm1hdHRlZF9uZXclMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjaGF0JTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBJTBBcHJpbnQoJTIyU3RhcnRpbmclMjBuZXclMjBtZXNzYWdlJTNBJTIyKSUwQXByaW50KGZvcm1hdHRlZF9uZXcp",highlighted:`<span class="hljs-comment"># Prefill a JSON response</span>
chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

<span class="hljs-comment"># Continue the final message</span>
formatted_chat = tokenizer.apply_chat_template(
    chat, 
    tokenize=<span class="hljs-literal">False</span>, 
    continue_final_message=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Continuing final message:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_chat)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Compare with starting a new message</span>
formatted_new = tokenizer.apply_chat_template(
    chat, 
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Starting new message:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_new)`,wrap:!1}}),St=new c({props:{code:"Q29udGludWluZyUyMGZpbmFsJTIwbWVzc2FnZSUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTdCJTIybmFtZSUyMiUzQSUyMCUyMiUwQSUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSUwQVN0YXJ0aW5nJTIwbmV3JTIwbWVzc2FnZSUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTdCJTIybmFtZSUyMiUzQSUyMCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50",highlighted:`Continuing final message:
&lt;|im_start|&gt;user
Can you format the answer in JSON?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
{&quot;name&quot;: &quot;

==================================================

Starting new message:
&lt;|im_start|&gt;user
Can you format the answer in JSON?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
{&quot;name&quot;: &quot;&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),Xt=new u({props:{title:"Practical Applications",local:"practical-applications",headingTag:"h3"}}),xt=new c({props:{code:"JTIzJTIwRm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwY29tcGxldGUlMjBhJTIwc3BlY2lmaWMlMjBmb3JtYXQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQlMjB0aGF0JTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMEpTT04lMjBmb3JtYXQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAnJTdCJTVDbiUyMCUyMCUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyV2hhdCU1QydzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTJDJTVDbiUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMiclN0QlMEElNUQlMEElMEElMjMlMjBUaGUlMjBtb2RlbCUyMHdpbGwlMjBjb250aW51ZSUyMHdpdGglMjBqdXN0JTIwdGhlJTIwYW5zd2VyJTJDJTIwbWFpbnRhaW5pbmclMjBKU09OJTIwc3RydWN0dXJl",highlighted:`<span class="hljs-comment"># Force the model to complete a specific format</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant that always responds in JSON format.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{\\n  &quot;question&quot;: &quot;What\\&#x27;s the capital of France?&quot;,\\n  &quot;answer&quot;: &quot;&#x27;</span>}
]

<span class="hljs-comment"># The model will continue with just the answer, maintaining JSON structure</span>`,wrap:!1}}),Vt=new c({props:{code:"JTIzJTIwR3VpZGUlMjB0aGUlMjBtb2RlbCUyMHRvJTIwY29tcGxldGUlMjBjb2RlJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXcml0ZSUyMGElMjBQeXRob24lMjBmdW5jdGlvbiUyMHRvJTIwY2FsY3VsYXRlJTIwZmFjdG9yaWFsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJkZWYlMjBmYWN0b3JpYWwobiklM0ElNUNuJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiUyMCUyMCUyMCUyMGVsc2UlM0ElNUNuJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbiUyMColMjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBNb2RlbCUyMHdpbGwlMjBjb21wbGV0ZSUyMHRoZSUyMHJlY3Vyc2l2ZSUyMGNhbGw=",highlighted:`<span class="hljs-comment"># Guide the model to complete code</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Write a Python function to calculate factorial&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;def factorial(n):\\n    if n == 0:\\n        return 1\\n    else:\\n        return n * &quot;</span>}
]

<span class="hljs-comment"># Model will complete the recursive call</span>`,wrap:!1}}),Ft=new c({props:{code:"JTIzJTIwR3VpZGUlMjB0aGUlMjBtb2RlbCUyMHRocm91Z2glMjBzdHJ1Y3R1cmVkJTIwdGhpbmtpbmclMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMlNvbHZlJTNBJTIwMnglMjAlMkIlMjA1JTIwJTNEJTIwMTMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkxldCUyMG1lJTIwc29sdmUlMjB0aGlzJTIwc3RlcCUyMGJ5JTIwc3RlcCUzQSU1Q24lNUNuU3RlcCUyMDElM0ElMjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBNb2RlbCUyMHdpbGwlMjBjb250aW51ZSUyMHdpdGglMjB0aGUlMjBmaXJzdCUyMHN0ZXA=",highlighted:`<span class="hljs-comment"># Guide the model through structured thinking</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Solve: 2x + 5 = 13&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Let me solve this step by step:\\n\\nStep 1: &quot;</span>}
]

<span class="hljs-comment"># Model will continue with the first step</span>`,wrap:!1}}),_t=new u({props:{title:"Important Notes",local:"important-notes",headingTag:"h3"}}),Dt=new u({props:{title:"Working with Reasoning Mode",local:"working-with-reasoning-mode",headingTag:"h2"}}),Pt=new u({props:{title:"Standard vs Thinking Mode",local:"standard-vs-thinking-mode",headingTag:"h3"}}),Kt=new c({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBtb2RlJTIwLSUyMGRpcmVjdCUyMGFuc3dlciUwQXN0YW5kYXJkX21lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDM2MCUyMiU3RCUwQSU1RCUwQSUwQSUyMyUyMFRoaW5raW5nJTIwbW9kZSUyMC0lMjBzaG93JTIwcmVhc29uaW5nJTIwcHJvY2VzcyUwQXRoaW5raW5nX21lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyJTNDJTdDdGhpbmtpbmclN0MlM0UlNUNuSSUyMG5lZWQlMjB0byUyMG11bHRpcGx5JTIwMTUlMjBieSUyMDI0LiUyMExldCUyMG1lJTIwYnJlYWslMjB0aGlzJTIwZG93biUzQSU1Q24xNSUyMCVDMyU5NyUyMDI0JTIwJTNEJTIwMTUlMjAlQzMlOTclMjAoMjAlMjAlMkIlMjA0KSUyMCUzRCUyMCgxNSUyMCVDMyU5NyUyMDIwKSUyMCUyQiUyMCgxNSUyMCVDMyU5NyUyMDQpJTIwJTNEJTIwMzAwJTIwJTJCJTIwNjAlMjAlM0QlMjAzNjAlNUNuJTNDJTJGJTdDdGhpbmtpbmclN0MlM0UlNUNuJTVDbjE1JTIwJUMzJTk3JTIwMjQlMjAlM0QlMjAzNjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRlbXBsYXRlcyUwQXN0YW5kYXJkX2Zvcm1hdHRlZCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHN0YW5kYXJkX21lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSklMEF0aGlua2luZ19mb3JtYXR0ZWQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSh0aGlua2luZ19tZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBBJTBBcHJpbnQoJTIyU3RhbmRhcmQlMjBtb2RlJTNBJTIyKSUwQXByaW50KHN0YW5kYXJkX2Zvcm1hdHRlZCklMEFwcmludCglMjIlNUNuVGhpbmtpbmclMjBtb2RlJTNBJTIyKSUwQXByaW50KHRoaW5raW5nX2Zvcm1hdHRlZCk=",highlighted:`<span class="hljs-comment"># Standard mode - direct answer</span>
standard_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is 15 × 24?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;15 × 24 = 360&quot;</span>}
]

<span class="hljs-comment"># Thinking mode - show reasoning process</span>
thinking_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is 15 × 24?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&lt;|thinking|&gt;\\nI need to multiply 15 by 24. Let me break this down:\\n15 × 24 = 15 × (20 + 4) = (15 × 20) + (15 × 4) = 300 + 60 = 360\\n&lt;/|thinking|&gt;\\n\\n15 × 24 = 360&quot;</span>}
]

<span class="hljs-comment"># Apply templates</span>
standard_formatted = tokenizer.apply_chat_template(standard_messages, tokenize=<span class="hljs-literal">False</span>)
thinking_formatted = tokenizer.apply_chat_template(thinking_messages, tokenize=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Standard mode:&quot;</span>)
<span class="hljs-built_in">print</span>(standard_formatted)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nThinking mode:&quot;</span>)
<span class="hljs-built_in">print</span>(thinking_formatted)`,wrap:!1}}),Ot=new u({props:{title:"Training with Thinking Mode",local:"training-with-thinking-mode",headingTag:"h3"}}),ll=new c({props:{code:"ZGVmJTIwY3JlYXRlX3RoaW5raW5nX2V4YW1wbGUocXVlc3Rpb24lMkMlMjBhbnN3ZXIlMkMlMjByZWFzb25pbmclM0ROb25lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNyZWF0ZSUyMGElMjB0cmFpbmluZyUyMGV4YW1wbGUlMjB3aXRoJTIwb3B0aW9uYWwlMjB0aGlua2luZyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwcmVhc29uaW5nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXNzaXN0YW50X2NvbnRlbnQlMjAlM0QlMjBmJTIyJTNDJTdDdGhpbmtpbmclN0MlM0UlNUNuJTdCcmVhc29uaW5nJTdEJTVDbiUzQyUyRiU3Q3RoaW5raW5nJTdDJTNFJTVDbiU1Q24lN0JhbnN3ZXIlN0QlMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXNzaXN0YW50X2NvbnRlbnQlMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBxdWVzdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwYXNzaXN0YW50X2NvbnRlbnQlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjMlMjBFeGFtcGxlJTIwdXNhZ2UlMEFtYXRoX2V4YW1wbGUlMjAlM0QlMjBjcmVhdGVfdGhpbmtpbmdfZXhhbXBsZSglMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGRlcml2YXRpdmUlMjBvZiUyMHglQzIlQjIlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXIlM0QlMjJUaGUlMjBkZXJpdmF0aXZlJTIwb2YlMjB4JUMyJUIyJTIwaXMlMjAyeCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlYXNvbmluZyUzRCUyMlVzaW5nJTIwdGhlJTIwcG93ZXIlMjBydWxlJTNBJTIwZCUyRmR4KHglNUVuKSUyMCUzRCUyMG4lQzIlQjd4JTVFKG4tMSklNUNuRm9yJTIweCVDMiVCMiUzQSUyMG4lM0QyJTJDJTIwc28lMjBkJTJGZHgoeCVDMiVCMiklMjAlM0QlMjAyJUMyJUI3eCU1RSgyLTEpJTIwJTNEJTIwMnglMjIlMEEp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_thinking_example</span>(<span class="hljs-params">question, answer, reasoning=<span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Create a training example with optional thinking&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> reasoning:
        assistant_content = <span class="hljs-string">f&quot;&lt;|thinking|&gt;\\n<span class="hljs-subst">{reasoning}</span>\\n&lt;/|thinking|&gt;\\n\\n<span class="hljs-subst">{answer}</span>&quot;</span>
    <span class="hljs-keyword">else</span>:
        assistant_content = answer
    
    <span class="hljs-keyword">return</span> [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: assistant_content}
    ]

<span class="hljs-comment"># Example usage</span>
math_example = create_thinking_example(
    question=<span class="hljs-string">&quot;What is the derivative of x²?&quot;</span>,
    answer=<span class="hljs-string">&quot;The derivative of x² is 2x&quot;</span>,
    reasoning=<span class="hljs-string">&quot;Using the power rule: d/dx(x^n) = n·x^(n-1)\\nFor x²: n=2, so d/dx(x²) = 2·x^(2-1) = 2x&quot;</span>
)`,wrap:!1}}),sl=new u({props:{title:"Tool Usage and Function Calling",local:"tool-usage-and-function-calling",headingTag:"h2"}}),nl=new u({props:{title:"Defining Tools",local:"defining-tools",headingTag:"h3"}}),al=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Define available tools</span>
tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather for a location&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                    },
                    <span class="hljs-string">&quot;unit&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit&quot;</span>
                    }
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>]
            }
        }
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;calculate&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Perform mathematical calculations&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;expression&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Mathematical expression to evaluate&quot;</span>
                    }
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;expression&quot;</span>]
            }
        }
    }
]`,wrap:!1}}),Ml=new u({props:{title:"Chat Templates with Tools",local:"chat-templates-with-tools",headingTag:"h3"}}),il=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Conversation with tool usage</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant with access to tools.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like in Paris?&quot;</span>},
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, 
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;ll check the weather in Paris for you.&quot;</span>,
        <span class="hljs-string">&quot;tool_calls&quot;</span>: [
            {
                <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;call_1&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
                <span class="hljs-string">&quot;function&quot;</span>: {
                    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
                    <span class="hljs-string">&quot;arguments&quot;</span>: <span class="hljs-string">&#x27;{&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}&#x27;</span>
                }
            }
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>,
        <span class="hljs-string">&quot;tool_call_id&quot;</span>: <span class="hljs-string">&quot;call_1&quot;</span>, 
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;temperature&quot;: 22, &quot;condition&quot;: &quot;sunny&quot;, &quot;humidity&quot;: 60}&#x27;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The weather in Paris is currently sunny with a temperature of 22°C and 60% humidity. It&#x27;s a beautiful day!&quot;</span>
    }
]

<span class="hljs-comment"># Apply chat template with tools</span>
formatted_with_tools = tokenizer.apply_chat_template(
    messages,
    tools=tools,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Chat template with tools:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_with_tools)`,wrap:!1}}),pl=new c({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`Chat template with tools:
&lt;|im_start|&gt;system
## Metadata

Knowledge Cutoff Date: June 2025
Today Date: 01 September 2025
Reasoning Mode: /think

## Custom Instructions

You are a helpful assistant with access to tools.

### Tools

You may call one or more functions to assist with the user query.
You are provided with function signatures within <span class="hljs-tag">&lt;<span class="hljs-name">tools</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">tools</span>&gt;</span> XML tags:

<span class="hljs-tag">&lt;<span class="hljs-name">tools</span>&gt;</span>
{&#x27;type&#x27;: &#x27;function&#x27;, &#x27;function&#x27;: {&#x27;name&#x27;: &#x27;get_weather&#x27;, &#x27;description&#x27;: &#x27;Get the current weather for a location&#x27;, &#x27;parameters&#x27;: {&#x27;type&#x27;: &#x27;object&#x27;, &#x27;properties&#x27;: {&#x27;location&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;description&#x27;: &#x27;The city and state, e.g. San Francisco, CA&#x27;}, &#x27;unit&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;enum&#x27;: [&#x27;celsius&#x27;, &#x27;fahrenheit&#x27;], &#x27;description&#x27;: &#x27;The temperature unit&#x27;}}, &#x27;required&#x27;: [&#x27;location&#x27;]}}}
{&#x27;type&#x27;: &#x27;function&#x27;, &#x27;function&#x27;: {&#x27;name&#x27;: &#x27;calculate&#x27;, &#x27;description&#x27;: &#x27;Perform mathematical calculations&#x27;, &#x27;parameters&#x27;: {&#x27;type&#x27;: &#x27;object&#x27;, &#x27;properties&#x27;: {&#x27;expression&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;description&#x27;: &#x27;Mathematical expression to evaluate&#x27;}}, &#x27;required&#x27;: [&#x27;expression&#x27;]}}}
<span class="hljs-tag">&lt;/<span class="hljs-name">tools</span>&gt;</span>

For each function call, return a json object with function name and arguments within <span class="hljs-tag">&lt;<span class="hljs-name">tool_call</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">tool_call</span>&gt;</span> XML tags:
<span class="hljs-tag">&lt;<span class="hljs-name">tool_call</span>&gt;</span>
{&quot;name&quot;: <span class="hljs-tag">&lt;<span class="hljs-name">function-name</span>&gt;</span>, &quot;arguments&quot;: <span class="hljs-tag">&lt;<span class="hljs-name">args-json-object</span>&gt;</span>}
...
{&quot;temperature&quot;: 22, &quot;condition&quot;: &quot;sunny&quot;, &quot;humidity&quot;: 60}&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
The weather in Paris is currently sunny with a temperature of 22°C and 60% humidity. It&#x27;s a beautiful day!&lt;|im_end|&gt;`,wrap:!1}}),yl=new u({props:{title:"Training with Tool Usage",local:"training-with-tool-usage",headingTag:"h3"}}),Ul=new c({props:{code:"ZGVmJTIwZm9ybWF0X3Rvb2xfZGF0YXNldChleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJGb3JtYXQlMjBkYXRhc2V0JTIwd2l0aCUyMHRvb2wlMjB1c2FnZSUyMGZvciUyMHRyYWluaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwZm9yJTIwbWVzc2FnZXMlMkMlMjB0b29scyUyMGluJTIwemlwKGV4YW1wbGVzJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjBleGFtcGxlcy5nZXQoJTIydG9vbHMlMjIlMkMlMjAlNUJOb25lJTVEJTIwKiUyMGxlbihleGFtcGxlcyU1QiUyMm1lc3NhZ2VzJTIyJTVEKSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvb2xzJTNEdG9vbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHRzLmFwcGVuZChmb3JtYXR0ZWRfdGV4dCklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwZm9ybWF0dGVkX3RleHRzJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_tool_dataset</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format dataset with tool usage for training&quot;&quot;&quot;</span>
    formatted_texts = []
    
    <span class="hljs-keyword">for</span> messages, tools <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;messages&quot;</span>], examples.get(<span class="hljs-string">&quot;tools&quot;</span>, [<span class="hljs-literal">None</span>] * <span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;messages&quot;</span>]))):
        formatted_text = tokenizer.apply_chat_template(
            messages,
            tools=tools,
            tokenize=<span class="hljs-literal">False</span>,
            add_generation_prompt=<span class="hljs-literal">False</span>
        )
        formatted_texts.append(formatted_text)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: formatted_texts}`,wrap:!1}}),Jl=new u({props:{title:"Advanced Template Customization",local:"advanced-template-customization",headingTag:"h2"}}),Tl=new u({props:{title:"Inspecting a Model’s Chat Template",local:"inspecting-a-models-chat-template",headingTag:"h3"}}),ul=new c({props:{code:"JTIzJTIwVmlldyUyMHRoZSUyMGFjdHVhbCUyMHRlbXBsYXRlJTBBcHJpbnQoJTIyU21vbExNMyUyMENoYXQlMjBUZW1wbGF0ZSUzQSUyMiklMEFwcmludCh0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSklMEElMEElMjMlMjBTZWUlMjB3aGF0JTIwc3BlY2lhbCUyMHRva2VucyUyMGFyZSUyMHVzZWQlMEFwcmludCglMjIlNUNuU3BlY2lhbCUyMHRva2VucyUzQSUyMiklMEFwcmludChmJTIyQk9TJTNBJTIwJTdCdG9rZW5pemVyLmJvc190b2tlbiU3RCUyMiklMEFwcmludChmJTIyRU9TJTNBJTIwJTdCdG9rZW5pemVyLmVvc190b2tlbiU3RCUyMiklMEFwcmludChmJTIyVU5LJTNBJTIwJTdCdG9rZW5pemVyLnVua190b2tlbiU3RCUyMiklMEFwcmludChmJTIyUEFEJTNBJTIwJTdCdG9rZW5pemVyLnBhZF90b2tlbiU3RCUyMiklMEElMEElMjMlMjBDaGVjayUyMGZvciUyMGN1c3RvbSUyMHRva2VucyUwQXNwZWNpYWxfdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnNwZWNpYWxfdG9rZW5zX21hcCUwQWZvciUyMG5hbWUlMkMlMjB0b2tlbiUyMGluJTIwc3BlY2lhbF90b2tlbnMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JuYW1lJTdEJTNBJTIwJTdCdG9rZW4lN0QlMjIp",highlighted:`<span class="hljs-comment"># View the actual template</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;SmolLM3 Chat Template:&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.chat_template)

<span class="hljs-comment"># See what special tokens are used</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nSpecial tokens:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;BOS: <span class="hljs-subst">{tokenizer.bos_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;EOS: <span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;UNK: <span class="hljs-subst">{tokenizer.unk_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;PAD: <span class="hljs-subst">{tokenizer.pad_token}</span>&quot;</span>)

<span class="hljs-comment"># Check for custom tokens</span>
special_tokens = tokenizer.special_tokens_map
<span class="hljs-keyword">for</span> name, token <span class="hljs-keyword">in</span> special_tokens.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{name}</span>: <span class="hljs-subst">{token}</span>&quot;</span>)`,wrap:!1}}),cl=new u({props:{title:"Custom Template Creation",local:"custom-template-creation",headingTag:"h3"}}),jl=new c({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMGN1c3RvbSUyMHRlbXBsYXRlJTIwKGFkdmFuY2VkJTIwdXNlcnMlMjBvbmx5KSUwQWN1c3RvbV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMiUyMiUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBzZXQlMjBzeXN0ZW1fbWVzc2FnZSUyMCUzRCUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGlmJTIwc3lzdGVtX21lc3NhZ2UlMjBpcyUyMGRlZmluZWQlMjAlMjUlN0QlMEElM0MlN0NzeXN0ZW0lN0MlM0UlN0IlN0IlMjBzeXN0ZW1fbWVzc2FnZSUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElM0MlN0N1c2VyJTdDJTNFJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElM0MlN0Nhc3Npc3RhbnQlN0MlM0UlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjIlMjIlMjIlMEElMEElMjMlMjBBcHBseSUyMGN1c3RvbSUyMHRlbXBsYXRlJTIwKGJlJTIwdmVyeSUyMGNhcmVmdWwlMjB3aXRoJTIwdGhpcyEpJTBBJTIzJTIwdG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBjdXN0b21fdGVtcGxhdGU=",highlighted:`<span class="hljs-comment"># Create a custom template (advanced users only)</span>
custom_template = <span class="hljs-string">&quot;&quot;&quot;
{%- for message in messages %}
    {%- if message[&#x27;role&#x27;] == &#x27;system&#x27; %}
        {%- set system_message = message[&#x27;content&#x27;] %}
    {%- endif %}
{%- endfor %}
{%- if system_message is defined %}
&lt;|system|&gt;{{ system_message }}&lt;|end|&gt;
{%- endif %}
{%- for message in messages %}
    {%- if message[&#x27;role&#x27;] == &#x27;user&#x27; %}
&lt;|user|&gt;{{ message[&#x27;content&#x27;] }}&lt;|end|&gt;
    {%- elif message[&#x27;role&#x27;] == &#x27;assistant&#x27; %}
&lt;|assistant|&gt;{{ message[&#x27;content&#x27;] }}&lt;|end|&gt;
    {%- endif %}
{%- endfor %}
{%- if add_generation_prompt %}
&lt;|assistant|&gt;
{%- endif %}
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Apply custom template (be very careful with this!)</span>
<span class="hljs-comment"># tokenizer.chat_template = custom_template</span>`,wrap:!1}}),ml=new u({props:{title:"Template Debugging",local:"template-debugging",headingTag:"h3"}}),hl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">debug_chat_template</span>(<span class="hljs-params">messages, tokenizer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Debug chat template application&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Apply template</span>
    formatted = tokenizer.apply_chat_template(
        messages, 
        tokenize=<span class="hljs-literal">False</span>, 
        add_generation_prompt=<span class="hljs-literal">True</span>
    )
    
    <span class="hljs-comment"># Tokenize and decode to see actual tokens</span>
    tokens = tokenizer(formatted, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== TEMPLATE DEBUG ===&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Input messages: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(messages)}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Formatted length: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(formatted)}</span> chars&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Token count: <span class="hljs-subst">{tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>].shape[<span class="hljs-number">1</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFormatted text:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">repr</span>(formatted))  <span class="hljs-comment"># Shows escape characters</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nTokens:&quot;</span>)
    <span class="hljs-built_in">print</span>(tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>].tolist()[:<span class="hljs-number">20</span>], <span class="hljs-string">&quot;...&quot;</span>)  <span class="hljs-comment"># First 20 tokens</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nDecoded tokens:&quot;</span>)
    <span class="hljs-keyword">for</span> i, token_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]):
        token = tokenizer.decode([token_id])
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i:2d}</span>: <span class="hljs-subst">{token_id:5d}</span> -&gt; <span class="hljs-subst">{<span class="hljs-built_in">repr</span>(token)}</span>&quot;</span>)

<span class="hljs-comment"># Example usage</span>
debug_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>}
]

debug_chat_template(debug_messages, tokenizer)`,wrap:!1}}),wl=new u({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),Il=new u({props:{title:"Core Concepts",local:"core-concepts",headingTag:"h3"}}),gl=new u({props:{title:"Advanced Features",local:"advanced-features",headingTag:"h3"}}),bl=new u({props:{title:"Training Best Practices",local:"training-best-practices",headingTag:"h3"}}),fl=new u({props:{title:"Common Pitfalls to Avoid",local:"common-pitfalls-to-avoid",headingTag:"h3"}}),Nl=new u({props:{title:"Production Considerations",local:"production-considerations",headingTag:"h3"}}),Zl=new u({props:{title:"Beyond Basic Templates: Advanced Topics",local:"beyond-basic-templates-advanced-topics",headingTag:"h2"}}),Gl=new u({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Rl=new u({props:{title:"Comprehensive Resources and Further Reading",local:"comprehensive-resources-and-further-reading",headingTag:"h2"}}),Wl=new u({props:{title:"Official Documentation",local:"official-documentation",headingTag:"h3"}}),Xl=new u({props:{title:"Model and Dataset Resources",local:"model-and-dataset-resources",headingTag:"h3"}}),xl=new u({props:{title:"Technical References",local:"technical-references",headingTag:"h3"}}),Vl=new u({props:{title:"Community Resources",local:"community-resources",headingTag:"h3"}}),Fl=new va({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/2.md"}}),{c(){j=J("meta"),h=n(),m=J("p"),d=n(),M(B.$$.fragment),Dl=n(),N=J("p"),N.textContent=Cn,Ll=n(),M(A.$$.fragment),Pl=n(),Z=J("p"),Z.textContent=gn,Kl=n(),q=J("p"),q.innerHTML=bn,Ol=n(),Q=J("p"),Q.innerHTML=fn,ts=n(),M($.$$.fragment),ls=n(),G=J("p"),G.textContent=Bn,ss=n(),E=J("ul"),E.innerHTML=Nn,es=n(),z=J("p"),z.innerHTML=An,ns=n(),M(I.$$.fragment),as=n(),M(R.$$.fragment),Ms=n(),W=J("p"),W.innerHTML=Zn,is=n(),M(S.$$.fragment),os=n(),X=J("p"),X.innerHTML=qn,ps=n(),M(v.$$.fragment),ys=n(),x=J("p"),x.textContent=Qn,Us=n(),k=J("ul"),k.innerHTML=$n,Js=n(),M(V.$$.fragment),rs=n(),Y=J("p"),Y.innerHTML=Gn,Ts=n(),M(F.$$.fragment),us=n(),M(_.$$.fragment),cs=n(),H=J("p"),H.textContent=En,js=n(),D=J("p"),D.textContent=zn,ms=n(),w=J("iframe"),hs=n(),M(L.$$.fragment),ws=n(),P=J("p"),P.innerHTML=Wn,ds=n(),M(K.$$.fragment),Is=n(),O=J("p"),O.innerHTML=Sn,Cs=n(),tt=J("ul"),tt.innerHTML=Xn,gs=n(),M(lt.$$.fragment),bs=n(),st=J("p"),st.innerHTML=vn,fs=n(),et=J("p"),et.innerHTML=xn,Bs=n(),M(nt.$$.fragment),Ns=n(),at=J("p"),at.innerHTML=kn,As=n(),M(Mt.$$.fragment),Zs=n(),it=J("p"),it.textContent=Vn,qs=n(),M(ot.$$.fragment),Qs=n(),pt=J("p"),pt.innerHTML=Yn,$s=n(),M(yt.$$.fragment),Gs=n(),Ut=J("p"),Ut.innerHTML=Fn,Es=n(),M(Jt.$$.fragment),zs=n(),M(rt.$$.fragment),Rs=n(),Tt=J("p"),Tt.textContent=_n,Ws=n(),ut=J("ul"),ut.innerHTML=Hn,Ss=n(),ct=J("p"),ct.innerHTML=Dn,Xs=n(),jt=J("ol"),jt.innerHTML=Ln,vs=n(),M(mt.$$.fragment),xs=n(),ht=J("p"),ht.innerHTML=Pn,ks=n(),M(wt.$$.fragment),Vs=n(),M(C.$$.fragment),Ys=n(),M(dt.$$.fragment),Fs=n(),It=J("p"),It.textContent=Kn,_s=n(),M(Ct.$$.fragment),Hs=n(),M(gt.$$.fragment),Ds=n(),bt=J("p"),bt.innerHTML=On,Ls=n(),M(ft.$$.fragment),Ps=n(),Bt=J("p"),Bt.innerHTML=ta,Ks=n(),M(Nt.$$.fragment),Os=n(),At=J("p"),At.innerHTML=la,te=n(),M(Zt.$$.fragment),le=n(),qt=J("p"),qt.textContent=sa,se=n(),M(Qt.$$.fragment),ee=n(),$t=J("ul"),$t.innerHTML=ea,ne=n(),M(Gt.$$.fragment),ae=n(),Et=J("p"),Et.innerHTML=na,Me=n(),M(zt.$$.fragment),ie=n(),M(Rt.$$.fragment),oe=n(),Wt=J("p"),Wt.innerHTML=aa,pe=n(),M(St.$$.fragment),ye=n(),M(Xt.$$.fragment),Ue=n(),vt=J("p"),vt.innerHTML=Ma,Je=n(),M(xt.$$.fragment),re=n(),kt=J("p"),kt.innerHTML=ia,Te=n(),M(Vt.$$.fragment),ue=n(),Yt=J("p"),Yt.innerHTML=oa,ce=n(),M(Ft.$$.fragment),je=n(),M(_t.$$.fragment),me=n(),Ht=J("ul"),Ht.innerHTML=pa,he=n(),M(Dt.$$.fragment),we=n(),Lt=J("p"),Lt.textContent=ya,de=n(),M(Pt.$$.fragment),Ie=n(),M(Kt.$$.fragment),Ce=n(),M(Ot.$$.fragment),ge=n(),tl=J("p"),tl.textContent=Ua,be=n(),M(ll.$$.fragment),fe=n(),M(sl.$$.fragment),Be=n(),el=J("p"),el.textContent=Ja,Ne=n(),M(nl.$$.fragment),Ae=n(),M(al.$$.fragment),Ze=n(),M(Ml.$$.fragment),qe=n(),M(il.$$.fragment),Qe=n(),ol=J("p"),ol.textContent=ra,$e=n(),M(pl.$$.fragment),Ge=n(),M(yl.$$.fragment),Ee=n(),M(Ul.$$.fragment),ze=n(),M(Jl.$$.fragment),Re=n(),rl=J("p"),rl.textContent=Ta,We=n(),M(Tl.$$.fragment),Se=n(),M(ul.$$.fragment),Xe=n(),M(cl.$$.fragment),ve=n(),M(jl.$$.fragment),xe=n(),M(ml.$$.fragment),ke=n(),M(hl.$$.fragment),Ve=n(),M(wl.$$.fragment),Ye=n(),dl=J("p"),dl.textContent=ua,Fe=n(),M(Il.$$.fragment),_e=n(),Cl=J("ol"),Cl.innerHTML=ca,He=n(),M(gl.$$.fragment),De=n(),g=J("ol"),g.innerHTML=ja,Le=n(),M(bl.$$.fragment),Pe=n(),b=J("ol"),b.innerHTML=ma,Ke=n(),M(fl.$$.fragment),Oe=n(),Bl=J("ul"),Bl.innerHTML=ha,tn=n(),M(Nl.$$.fragment),ln=n(),Al=J("ul"),Al.innerHTML=wa,sn=n(),M(Zl.$$.fragment),en=n(),ql=J("p"),ql.textContent=da,nn=n(),Ql=J("ul"),Ql.innerHTML=Ia,an=n(),$l=J("p"),$l.textContent=Ca,Mn=n(),M(Gl.$$.fragment),on=n(),El=J("p"),El.textContent=ga,pn=n(),zl=J("p"),zl.innerHTML=ba,yn=n(),M(Rl.$$.fragment),Un=n(),M(Wl.$$.fragment),Jn=n(),Sl=J("ul"),Sl.innerHTML=fa,rn=n(),M(Xl.$$.fragment),Tn=n(),vl=J("ul"),vl.innerHTML=Ba,un=n(),M(xl.$$.fragment),cn=n(),kl=J("ul"),kl.innerHTML=Na,jn=n(),M(Vl.$$.fragment),mn=n(),Yl=J("ul"),Yl.innerHTML=Aa,hn=n(),M(Fl.$$.fragment),wn=n(),Hl=J("p"),this.h()},l(t){const l=Sa("svelte-u9bgzb",document.head);j=r(l,"META",{name:!0,content:!0}),l.forEach(s),h=a(t),m=r(t,"P",{}),In(m).forEach(s),d=a(t),i(B.$$.fragment,t),Dl=a(t),N=r(t,"P",{"data-svelte-h":!0}),T(N)!=="svelte-d3kccn"&&(N.textContent=Cn),Ll=a(t),i(A.$$.fragment,t),Pl=a(t),Z=r(t,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-mozkmq"&&(Z.textContent=gn),Kl=a(t),q=r(t,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1f6j5jj"&&(q.innerHTML=bn),Ol=a(t),Q=r(t,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-unmhxo"&&(Q.innerHTML=fn),ts=a(t),i($.$$.fragment,t),ls=a(t),G=r(t,"P",{"data-svelte-h":!0}),T(G)!=="svelte-17fybo2"&&(G.textContent=Bn),ss=a(t),E=r(t,"UL",{"data-svelte-h":!0}),T(E)!=="svelte-9jhh0y"&&(E.innerHTML=Nn),es=a(t),z=r(t,"P",{"data-svelte-h":!0}),T(z)!=="svelte-18g6pwz"&&(z.innerHTML=An),ns=a(t),i(I.$$.fragment,t),as=a(t),i(R.$$.fragment,t),Ms=a(t),W=r(t,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1rbwa51"&&(W.innerHTML=Zn),is=a(t),i(S.$$.fragment,t),os=a(t),X=r(t,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1mvdyro"&&(X.innerHTML=qn),ps=a(t),i(v.$$.fragment,t),ys=a(t),x=r(t,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1bn89b"&&(x.textContent=Qn),Us=a(t),k=r(t,"UL",{"data-svelte-h":!0}),T(k)!=="svelte-144l53o"&&(k.innerHTML=$n),Js=a(t),i(V.$$.fragment,t),rs=a(t),Y=r(t,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-179o2hw"&&(Y.innerHTML=Gn),Ts=a(t),i(F.$$.fragment,t),us=a(t),i(_.$$.fragment,t),cs=a(t),H=r(t,"P",{"data-svelte-h":!0}),T(H)!=="svelte-eyoxwp"&&(H.textContent=En),js=a(t),D=r(t,"P",{"data-svelte-h":!0}),T(D)!=="svelte-zkhhra"&&(D.textContent=zn),ms=a(t),w=r(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),In(w).forEach(s),hs=a(t),i(L.$$.fragment,t),ws=a(t),P=r(t,"P",{"data-svelte-h":!0}),T(P)!=="svelte-102b07s"&&(P.innerHTML=Wn),ds=a(t),i(K.$$.fragment,t),Is=a(t),O=r(t,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1oqsfw0"&&(O.innerHTML=Sn),Cs=a(t),tt=r(t,"UL",{"data-svelte-h":!0}),T(tt)!=="svelte-ilpj2p"&&(tt.innerHTML=Xn),gs=a(t),i(lt.$$.fragment,t),bs=a(t),st=r(t,"P",{"data-svelte-h":!0}),T(st)!=="svelte-pawe6y"&&(st.innerHTML=vn),fs=a(t),et=r(t,"P",{"data-svelte-h":!0}),T(et)!=="svelte-imsvmv"&&(et.innerHTML=xn),Bs=a(t),i(nt.$$.fragment,t),Ns=a(t),at=r(t,"P",{"data-svelte-h":!0}),T(at)!=="svelte-1ysbhxa"&&(at.innerHTML=kn),As=a(t),i(Mt.$$.fragment,t),Zs=a(t),it=r(t,"P",{"data-svelte-h":!0}),T(it)!=="svelte-1vd658"&&(it.textContent=Vn),qs=a(t),i(ot.$$.fragment,t),Qs=a(t),pt=r(t,"P",{"data-svelte-h":!0}),T(pt)!=="svelte-sm3gz4"&&(pt.innerHTML=Yn),$s=a(t),i(yt.$$.fragment,t),Gs=a(t),Ut=r(t,"P",{"data-svelte-h":!0}),T(Ut)!=="svelte-1mvdyro"&&(Ut.innerHTML=Fn),Es=a(t),i(Jt.$$.fragment,t),zs=a(t),i(rt.$$.fragment,t),Rs=a(t),Tt=r(t,"P",{"data-svelte-h":!0}),T(Tt)!=="svelte-1lokzhr"&&(Tt.textContent=_n),Ws=a(t),ut=r(t,"UL",{"data-svelte-h":!0}),T(ut)!=="svelte-m4uctq"&&(ut.innerHTML=Hn),Ss=a(t),ct=r(t,"P",{"data-svelte-h":!0}),T(ct)!=="svelte-1env111"&&(ct.innerHTML=Dn),Xs=a(t),jt=r(t,"OL",{"data-svelte-h":!0}),T(jt)!=="svelte-1dnzyiq"&&(jt.innerHTML=Ln),vs=a(t),i(mt.$$.fragment,t),xs=a(t),ht=r(t,"P",{"data-svelte-h":!0}),T(ht)!=="svelte-1rkjl6y"&&(ht.innerHTML=Pn),ks=a(t),i(wt.$$.fragment,t),Vs=a(t),i(C.$$.fragment,t),Ys=a(t),i(dt.$$.fragment,t),Fs=a(t),It=r(t,"P",{"data-svelte-h":!0}),T(It)!=="svelte-afya7u"&&(It.textContent=Kn),_s=a(t),i(Ct.$$.fragment,t),Hs=a(t),i(gt.$$.fragment,t),Ds=a(t),bt=r(t,"P",{"data-svelte-h":!0}),T(bt)!=="svelte-1v2xbhq"&&(bt.innerHTML=On),Ls=a(t),i(ft.$$.fragment,t),Ps=a(t),Bt=r(t,"P",{"data-svelte-h":!0}),T(Bt)!=="svelte-hpjobf"&&(Bt.innerHTML=ta),Ks=a(t),i(Nt.$$.fragment,t),Os=a(t),At=r(t,"P",{"data-svelte-h":!0}),T(At)!=="svelte-1mvdyro"&&(At.innerHTML=la),te=a(t),i(Zt.$$.fragment,t),le=a(t),qt=r(t,"P",{"data-svelte-h":!0}),T(qt)!=="svelte-3p7za0"&&(qt.textContent=sa),se=a(t),i(Qt.$$.fragment,t),ee=a(t),$t=r(t,"UL",{"data-svelte-h":!0}),T($t)!=="svelte-1mocn1s"&&($t.innerHTML=ea),ne=a(t),i(Gt.$$.fragment,t),ae=a(t),Et=r(t,"P",{"data-svelte-h":!0}),T(Et)!=="svelte-e13tgq"&&(Et.innerHTML=na),Me=a(t),i(zt.$$.fragment,t),ie=a(t),i(Rt.$$.fragment,t),oe=a(t),Wt=r(t,"P",{"data-svelte-h":!0}),T(Wt)!=="svelte-1mvdyro"&&(Wt.innerHTML=aa),pe=a(t),i(St.$$.fragment,t),ye=a(t),i(Xt.$$.fragment,t),Ue=a(t),vt=r(t,"P",{"data-svelte-h":!0}),T(vt)!=="svelte-vnyodc"&&(vt.innerHTML=Ma),Je=a(t),i(xt.$$.fragment,t),re=a(t),kt=r(t,"P",{"data-svelte-h":!0}),T(kt)!=="svelte-1ou3eew"&&(kt.innerHTML=ia),Te=a(t),i(Vt.$$.fragment,t),ue=a(t),Yt=r(t,"P",{"data-svelte-h":!0}),T(Yt)!=="svelte-l9z3nt"&&(Yt.innerHTML=oa),ce=a(t),i(Ft.$$.fragment,t),je=a(t),i(_t.$$.fragment,t),me=a(t),Ht=r(t,"UL",{"data-svelte-h":!0}),T(Ht)!=="svelte-cjcdpj"&&(Ht.innerHTML=pa),he=a(t),i(Dt.$$.fragment,t),we=a(t),Lt=r(t,"P",{"data-svelte-h":!0}),T(Lt)!=="svelte-xbgv5d"&&(Lt.textContent=ya),de=a(t),i(Pt.$$.fragment,t),Ie=a(t),i(Kt.$$.fragment,t),Ce=a(t),i(Ot.$$.fragment,t),ge=a(t),tl=r(t,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-19n2ph5"&&(tl.textContent=Ua),be=a(t),i(ll.$$.fragment,t),fe=a(t),i(sl.$$.fragment,t),Be=a(t),el=r(t,"P",{"data-svelte-h":!0}),T(el)!=="svelte-1pmaeam"&&(el.textContent=Ja),Ne=a(t),i(nl.$$.fragment,t),Ae=a(t),i(al.$$.fragment,t),Ze=a(t),i(Ml.$$.fragment,t),qe=a(t),i(il.$$.fragment,t),Qe=a(t),ol=r(t,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-1oowhlx"&&(ol.textContent=ra),$e=a(t),i(pl.$$.fragment,t),Ge=a(t),i(yl.$$.fragment,t),Ee=a(t),i(Ul.$$.fragment,t),ze=a(t),i(Jl.$$.fragment,t),Re=a(t),rl=r(t,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-15r8njr"&&(rl.textContent=Ta),We=a(t),i(Tl.$$.fragment,t),Se=a(t),i(ul.$$.fragment,t),Xe=a(t),i(cl.$$.fragment,t),ve=a(t),i(jl.$$.fragment,t),xe=a(t),i(ml.$$.fragment,t),ke=a(t),i(hl.$$.fragment,t),Ve=a(t),i(wl.$$.fragment,t),Ye=a(t),dl=r(t,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-lg0tgv"&&(dl.textContent=ua),Fe=a(t),i(Il.$$.fragment,t),_e=a(t),Cl=r(t,"OL",{"data-svelte-h":!0}),T(Cl)!=="svelte-10iaks9"&&(Cl.innerHTML=ca),He=a(t),i(gl.$$.fragment,t),De=a(t),g=r(t,"OL",{start:!0,"data-svelte-h":!0}),T(g)!=="svelte-12bmlsu"&&(g.innerHTML=ja),Le=a(t),i(bl.$$.fragment,t),Pe=a(t),b=r(t,"OL",{start:!0,"data-svelte-h":!0}),T(b)!=="svelte-7jyr6u"&&(b.innerHTML=ma),Ke=a(t),i(fl.$$.fragment,t),Oe=a(t),Bl=r(t,"UL",{"data-svelte-h":!0}),T(Bl)!=="svelte-1ivxa30"&&(Bl.innerHTML=ha),tn=a(t),i(Nl.$$.fragment,t),ln=a(t),Al=r(t,"UL",{"data-svelte-h":!0}),T(Al)!=="svelte-1htvuc3"&&(Al.innerHTML=wa),sn=a(t),i(Zl.$$.fragment,t),en=a(t),ql=r(t,"P",{"data-svelte-h":!0}),T(ql)!=="svelte-itulrc"&&(ql.textContent=da),nn=a(t),Ql=r(t,"UL",{"data-svelte-h":!0}),T(Ql)!=="svelte-httu49"&&(Ql.innerHTML=Ia),an=a(t),$l=r(t,"P",{"data-svelte-h":!0}),T($l)!=="svelte-1wei0mn"&&($l.textContent=Ca),Mn=a(t),i(Gl.$$.fragment,t),on=a(t),El=r(t,"P",{"data-svelte-h":!0}),T(El)!=="svelte-5l0l0r"&&(El.textContent=ga),pn=a(t),zl=r(t,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-1fzx0f4"&&(zl.innerHTML=ba),yn=a(t),i(Rl.$$.fragment,t),Un=a(t),i(Wl.$$.fragment,t),Jn=a(t),Sl=r(t,"UL",{"data-svelte-h":!0}),T(Sl)!=="svelte-14aeq9o"&&(Sl.innerHTML=fa),rn=a(t),i(Xl.$$.fragment,t),Tn=a(t),vl=r(t,"UL",{"data-svelte-h":!0}),T(vl)!=="svelte-1vy70a1"&&(vl.innerHTML=Ba),un=a(t),i(xl.$$.fragment,t),cn=a(t),kl=r(t,"UL",{"data-svelte-h":!0}),T(kl)!=="svelte-y67qi6"&&(kl.innerHTML=Na),jn=a(t),i(Vl.$$.fragment,t),mn=a(t),Yl=r(t,"UL",{"data-svelte-h":!0}),T(Yl)!=="svelte-1wnksy9"&&(Yl.innerHTML=Aa),hn=a(t),i(Fl.$$.fragment,t),wn=a(t),Hl=r(t,"P",{}),In(Hl).forEach(s),this.h()},h(){f(j,"name","hf:doc:metadata"),f(j,"content",Ya),Ea(w.src,Rn="https://huggingfacejs-chat-template-playground.hf.space")||f(w,"src",Rn),f(w,"frameborder","0"),f(w,"width","850"),f(w,"height","450"),f(g,"start","6"),f(b,"start","11")},m(t,l){Xa(document.head,j),e(t,h,l),e(t,m,l),e(t,d,l),o(B,t,l),e(t,Dl,l),e(t,N,l),e(t,Ll,l),o(A,t,l),e(t,Pl,l),e(t,Z,l),e(t,Kl,l),e(t,q,l),e(t,Ol,l),e(t,Q,l),e(t,ts,l),o($,t,l),e(t,ls,l),e(t,G,l),e(t,ss,l),e(t,E,l),e(t,es,l),e(t,z,l),e(t,ns,l),o(I,t,l),e(t,as,l),o(R,t,l),e(t,Ms,l),e(t,W,l),e(t,is,l),o(S,t,l),e(t,os,l),e(t,X,l),e(t,ps,l),o(v,t,l),e(t,ys,l),e(t,x,l),e(t,Us,l),e(t,k,l),e(t,Js,l),o(V,t,l),e(t,rs,l),e(t,Y,l),e(t,Ts,l),o(F,t,l),e(t,us,l),o(_,t,l),e(t,cs,l),e(t,H,l),e(t,js,l),e(t,D,l),e(t,ms,l),e(t,w,l),e(t,hs,l),o(L,t,l),e(t,ws,l),e(t,P,l),e(t,ds,l),o(K,t,l),e(t,Is,l),e(t,O,l),e(t,Cs,l),e(t,tt,l),e(t,gs,l),o(lt,t,l),e(t,bs,l),e(t,st,l),e(t,fs,l),e(t,et,l),e(t,Bs,l),o(nt,t,l),e(t,Ns,l),e(t,at,l),e(t,As,l),o(Mt,t,l),e(t,Zs,l),e(t,it,l),e(t,qs,l),o(ot,t,l),e(t,Qs,l),e(t,pt,l),e(t,$s,l),o(yt,t,l),e(t,Gs,l),e(t,Ut,l),e(t,Es,l),o(Jt,t,l),e(t,zs,l),o(rt,t,l),e(t,Rs,l),e(t,Tt,l),e(t,Ws,l),e(t,ut,l),e(t,Ss,l),e(t,ct,l),e(t,Xs,l),e(t,jt,l),e(t,vs,l),o(mt,t,l),e(t,xs,l),e(t,ht,l),e(t,ks,l),o(wt,t,l),e(t,Vs,l),o(C,t,l),e(t,Ys,l),o(dt,t,l),e(t,Fs,l),e(t,It,l),e(t,_s,l),o(Ct,t,l),e(t,Hs,l),o(gt,t,l),e(t,Ds,l),e(t,bt,l),e(t,Ls,l),o(ft,t,l),e(t,Ps,l),e(t,Bt,l),e(t,Ks,l),o(Nt,t,l),e(t,Os,l),e(t,At,l),e(t,te,l),o(Zt,t,l),e(t,le,l),e(t,qt,l),e(t,se,l),o(Qt,t,l),e(t,ee,l),e(t,$t,l),e(t,ne,l),o(Gt,t,l),e(t,ae,l),e(t,Et,l),e(t,Me,l),o(zt,t,l),e(t,ie,l),o(Rt,t,l),e(t,oe,l),e(t,Wt,l),e(t,pe,l),o(St,t,l),e(t,ye,l),o(Xt,t,l),e(t,Ue,l),e(t,vt,l),e(t,Je,l),o(xt,t,l),e(t,re,l),e(t,kt,l),e(t,Te,l),o(Vt,t,l),e(t,ue,l),e(t,Yt,l),e(t,ce,l),o(Ft,t,l),e(t,je,l),o(_t,t,l),e(t,me,l),e(t,Ht,l),e(t,he,l),o(Dt,t,l),e(t,we,l),e(t,Lt,l),e(t,de,l),o(Pt,t,l),e(t,Ie,l),o(Kt,t,l),e(t,Ce,l),o(Ot,t,l),e(t,ge,l),e(t,tl,l),e(t,be,l),o(ll,t,l),e(t,fe,l),o(sl,t,l),e(t,Be,l),e(t,el,l),e(t,Ne,l),o(nl,t,l),e(t,Ae,l),o(al,t,l),e(t,Ze,l),o(Ml,t,l),e(t,qe,l),o(il,t,l),e(t,Qe,l),e(t,ol,l),e(t,$e,l),o(pl,t,l),e(t,Ge,l),o(yl,t,l),e(t,Ee,l),o(Ul,t,l),e(t,ze,l),o(Jl,t,l),e(t,Re,l),e(t,rl,l),e(t,We,l),o(Tl,t,l),e(t,Se,l),o(ul,t,l),e(t,Xe,l),o(cl,t,l),e(t,ve,l),o(jl,t,l),e(t,xe,l),o(ml,t,l),e(t,ke,l),o(hl,t,l),e(t,Ve,l),o(wl,t,l),e(t,Ye,l),e(t,dl,l),e(t,Fe,l),o(Il,t,l),e(t,_e,l),e(t,Cl,l),e(t,He,l),o(gl,t,l),e(t,De,l),e(t,g,l),e(t,Le,l),o(bl,t,l),e(t,Pe,l),e(t,b,l),e(t,Ke,l),o(fl,t,l),e(t,Oe,l),e(t,Bl,l),e(t,tn,l),o(Nl,t,l),e(t,ln,l),e(t,Al,l),e(t,sn,l),o(Zl,t,l),e(t,en,l),e(t,ql,l),e(t,nn,l),e(t,Ql,l),e(t,an,l),e(t,$l,l),e(t,Mn,l),o(Gl,t,l),e(t,on,l),e(t,El,l),e(t,pn,l),e(t,zl,l),e(t,yn,l),o(Rl,t,l),e(t,Un,l),o(Wl,t,l),e(t,Jn,l),e(t,Sl,l),e(t,rn,l),o(Xl,t,l),e(t,Tn,l),e(t,vl,l),e(t,un,l),o(xl,t,l),e(t,cn,l),e(t,kl,l),e(t,jn,l),o(Vl,t,l),e(t,mn,l),e(t,Yl,l),e(t,hn,l),o(Fl,t,l),e(t,wn,l),e(t,Hl,l),dn=!0},p(t,[l]){const Za={};l&2&&(Za.$$scope={dirty:l,ctx:t}),I.$set(Za);const qa={};l&2&&(qa.$$scope={dirty:l,ctx:t}),C.$set(qa)},i(t){dn||(p(B.$$.fragment,t),p(A.$$.fragment,t),p($.$$.fragment,t),p(I.$$.fragment,t),p(R.$$.fragment,t),p(S.$$.fragment,t),p(v.$$.fragment,t),p(V.$$.fragment,t),p(F.$$.fragment,t),p(_.$$.fragment,t),p(L.$$.fragment,t),p(K.$$.fragment,t),p(lt.$$.fragment,t),p(nt.$$.fragment,t),p(Mt.$$.fragment,t),p(ot.$$.fragment,t),p(yt.$$.fragment,t),p(Jt.$$.fragment,t),p(rt.$$.fragment,t),p(mt.$$.fragment,t),p(wt.$$.fragment,t),p(C.$$.fragment,t),p(dt.$$.fragment,t),p(Ct.$$.fragment,t),p(gt.$$.fragment,t),p(ft.$$.fragment,t),p(Nt.$$.fragment,t),p(Zt.$$.fragment,t),p(Qt.$$.fragment,t),p(Gt.$$.fragment,t),p(zt.$$.fragment,t),p(Rt.$$.fragment,t),p(St.$$.fragment,t),p(Xt.$$.fragment,t),p(xt.$$.fragment,t),p(Vt.$$.fragment,t),p(Ft.$$.fragment,t),p(_t.$$.fragment,t),p(Dt.$$.fragment,t),p(Pt.$$.fragment,t),p(Kt.$$.fragment,t),p(Ot.$$.fragment,t),p(ll.$$.fragment,t),p(sl.$$.fragment,t),p(nl.$$.fragment,t),p(al.$$.fragment,t),p(Ml.$$.fragment,t),p(il.$$.fragment,t),p(pl.$$.fragment,t),p(yl.$$.fragment,t),p(Ul.$$.fragment,t),p(Jl.$$.fragment,t),p(Tl.$$.fragment,t),p(ul.$$.fragment,t),p(cl.$$.fragment,t),p(jl.$$.fragment,t),p(ml.$$.fragment,t),p(hl.$$.fragment,t),p(wl.$$.fragment,t),p(Il.$$.fragment,t),p(gl.$$.fragment,t),p(bl.$$.fragment,t),p(fl.$$.fragment,t),p(Nl.$$.fragment,t),p(Zl.$$.fragment,t),p(Gl.$$.fragment,t),p(Rl.$$.fragment,t),p(Wl.$$.fragment,t),p(Xl.$$.fragment,t),p(xl.$$.fragment,t),p(Vl.$$.fragment,t),p(Fl.$$.fragment,t),dn=!0)},o(t){y(B.$$.fragment,t),y(A.$$.fragment,t),y($.$$.fragment,t),y(I.$$.fragment,t),y(R.$$.fragment,t),y(S.$$.fragment,t),y(v.$$.fragment,t),y(V.$$.fragment,t),y(F.$$.fragment,t),y(_.$$.fragment,t),y(L.$$.fragment,t),y(K.$$.fragment,t),y(lt.$$.fragment,t),y(nt.$$.fragment,t),y(Mt.$$.fragment,t),y(ot.$$.fragment,t),y(yt.$$.fragment,t),y(Jt.$$.fragment,t),y(rt.$$.fragment,t),y(mt.$$.fragment,t),y(wt.$$.fragment,t),y(C.$$.fragment,t),y(dt.$$.fragment,t),y(Ct.$$.fragment,t),y(gt.$$.fragment,t),y(ft.$$.fragment,t),y(Nt.$$.fragment,t),y(Zt.$$.fragment,t),y(Qt.$$.fragment,t),y(Gt.$$.fragment,t),y(zt.$$.fragment,t),y(Rt.$$.fragment,t),y(St.$$.fragment,t),y(Xt.$$.fragment,t),y(xt.$$.fragment,t),y(Vt.$$.fragment,t),y(Ft.$$.fragment,t),y(_t.$$.fragment,t),y(Dt.$$.fragment,t),y(Pt.$$.fragment,t),y(Kt.$$.fragment,t),y(Ot.$$.fragment,t),y(ll.$$.fragment,t),y(sl.$$.fragment,t),y(nl.$$.fragment,t),y(al.$$.fragment,t),y(Ml.$$.fragment,t),y(il.$$.fragment,t),y(pl.$$.fragment,t),y(yl.$$.fragment,t),y(Ul.$$.fragment,t),y(Jl.$$.fragment,t),y(Tl.$$.fragment,t),y(ul.$$.fragment,t),y(cl.$$.fragment,t),y(jl.$$.fragment,t),y(ml.$$.fragment,t),y(hl.$$.fragment,t),y(wl.$$.fragment,t),y(Il.$$.fragment,t),y(gl.$$.fragment,t),y(bl.$$.fragment,t),y(fl.$$.fragment,t),y(Nl.$$.fragment,t),y(Zl.$$.fragment,t),y(Gl.$$.fragment,t),y(Rl.$$.fragment,t),y(Wl.$$.fragment,t),y(Xl.$$.fragment,t),y(xl.$$.fragment,t),y(Vl.$$.fragment,t),y(Fl.$$.fragment,t),dn=!1},d(t){t&&(s(h),s(m),s(d),s(Dl),s(N),s(Ll),s(Pl),s(Z),s(Kl),s(q),s(Ol),s(Q),s(ts),s(ls),s(G),s(ss),s(E),s(es),s(z),s(ns),s(as),s(Ms),s(W),s(is),s(os),s(X),s(ps),s(ys),s(x),s(Us),s(k),s(Js),s(rs),s(Y),s(Ts),s(us),s(cs),s(H),s(js),s(D),s(ms),s(w),s(hs),s(ws),s(P),s(ds),s(Is),s(O),s(Cs),s(tt),s(gs),s(bs),s(st),s(fs),s(et),s(Bs),s(Ns),s(at),s(As),s(Zs),s(it),s(qs),s(Qs),s(pt),s($s),s(Gs),s(Ut),s(Es),s(zs),s(Rs),s(Tt),s(Ws),s(ut),s(Ss),s(ct),s(Xs),s(jt),s(vs),s(xs),s(ht),s(ks),s(Vs),s(Ys),s(Fs),s(It),s(_s),s(Hs),s(Ds),s(bt),s(Ls),s(Ps),s(Bt),s(Ks),s(Os),s(At),s(te),s(le),s(qt),s(se),s(ee),s($t),s(ne),s(ae),s(Et),s(Me),s(ie),s(oe),s(Wt),s(pe),s(ye),s(Ue),s(vt),s(Je),s(re),s(kt),s(Te),s(ue),s(Yt),s(ce),s(je),s(me),s(Ht),s(he),s(we),s(Lt),s(de),s(Ie),s(Ce),s(ge),s(tl),s(be),s(fe),s(Be),s(el),s(Ne),s(Ae),s(Ze),s(qe),s(Qe),s(ol),s($e),s(Ge),s(Ee),s(ze),s(Re),s(rl),s(We),s(Se),s(Xe),s(ve),s(xe),s(ke),s(Ve),s(Ye),s(dl),s(Fe),s(_e),s(Cl),s(He),s(De),s(g),s(Le),s(Pe),s(b),s(Ke),s(Oe),s(Bl),s(tn),s(ln),s(Al),s(sn),s(en),s(ql),s(nn),s(Ql),s(an),s($l),s(Mn),s(on),s(El),s(pn),s(zl),s(yn),s(Un),s(Jn),s(Sl),s(rn),s(Tn),s(vl),s(un),s(cn),s(kl),s(jn),s(mn),s(Yl),s(hn),s(wn),s(Hl)),s(j),U(B,t),U(A,t),U($,t),U(I,t),U(R,t),U(S,t),U(v,t),U(V,t),U(F,t),U(_,t),U(L,t),U(K,t),U(lt,t),U(nt,t),U(Mt,t),U(ot,t),U(yt,t),U(Jt,t),U(rt,t),U(mt,t),U(wt,t),U(C,t),U(dt,t),U(Ct,t),U(gt,t),U(ft,t),U(Nt,t),U(Zt,t),U(Qt,t),U(Gt,t),U(zt,t),U(Rt,t),U(St,t),U(Xt,t),U(xt,t),U(Vt,t),U(Ft,t),U(_t,t),U(Dt,t),U(Pt,t),U(Kt,t),U(Ot,t),U(ll,t),U(sl,t),U(nl,t),U(al,t),U(Ml,t),U(il,t),U(pl,t),U(yl,t),U(Ul,t),U(Jl,t),U(Tl,t),U(ul,t),U(cl,t),U(jl,t),U(ml,t),U(hl,t),U(wl,t),U(Il,t),U(gl,t),U(bl,t),U(fl,t),U(Nl,t),U(Zl,t),U(Gl,t),U(Rl,t),U(Wl,t),U(Xl,t),U(xl,t),U(Vl,t),U(Fl,t)}}}const Ya='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Base Models vs Instruct Models","local":"base-models-vs-instruct-models","sections":[{"title":"The Transformation Process","local":"the-transformation-process","sections":[],"depth":3}],"depth":2},{"title":"Pipeline Usage: Automated Chat Processing","local":"pipeline-usage-automated-chat-processing","sections":[{"title":"Advanced Pipeline Usage","local":"advanced-pipeline-usage","sections":[],"depth":3}],"depth":2},{"title":"Understanding SmolLM3’s Chat Template","local":"understanding-smollm3s-chat-template","sections":[{"title":"ChatML Format Structure","local":"chatml-format-structure","sections":[],"depth":3},{"title":"Dual-Mode Reasoning Support","local":"dual-mode-reasoning-support","sections":[],"depth":3}],"depth":2},{"title":"Working with SmolLM3 Chat Templates in Code","local":"working-with-smollm3-chat-templates-in-code","sections":[{"title":"Understanding the Message Structure","local":"understanding-the-message-structure","sections":[],"depth":3}],"depth":2},{"title":"System Messages: Setting the Context","local":"system-messages-setting-the-context","sections":[],"depth":2},{"title":"Multi-Turn Conversations","local":"multi-turn-conversations","sections":[],"depth":2},{"title":"Generation Prompts: Controlling Model Behavior","local":"generation-prompts-controlling-model-behavior","sections":[{"title":"Understanding add_generation_prompt","local":"understanding-addgenerationprompt","sections":[],"depth":3},{"title":"When to Use Generation Prompts","local":"when-to-use-generation-prompts","sections":[],"depth":3}],"depth":2},{"title":"Continuing Final Messages: Advanced Response Control","local":"continuing-final-messages-advanced-response-control","sections":[{"title":"Basic Example","local":"basic-example","sections":[],"depth":3},{"title":"Practical Applications","local":"practical-applications","sections":[],"depth":3},{"title":"Important Notes","local":"important-notes","sections":[],"depth":3}],"depth":2},{"title":"Working with Reasoning Mode","local":"working-with-reasoning-mode","sections":[{"title":"Standard vs Thinking Mode","local":"standard-vs-thinking-mode","sections":[],"depth":3},{"title":"Training with Thinking Mode","local":"training-with-thinking-mode","sections":[],"depth":3}],"depth":2},{"title":"Tool Usage and Function Calling","local":"tool-usage-and-function-calling","sections":[{"title":"Defining Tools","local":"defining-tools","sections":[],"depth":3},{"title":"Chat Templates with Tools","local":"chat-templates-with-tools","sections":[],"depth":3},{"title":"Training with Tool Usage","local":"training-with-tool-usage","sections":[],"depth":3}],"depth":2},{"title":"Advanced Template Customization","local":"advanced-template-customization","sections":[{"title":"Inspecting a Model’s Chat Template","local":"inspecting-a-models-chat-template","sections":[],"depth":3},{"title":"Custom Template Creation","local":"custom-template-creation","sections":[],"depth":3},{"title":"Template Debugging","local":"template-debugging","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[{"title":"Core Concepts","local":"core-concepts","sections":[],"depth":3},{"title":"Advanced Features","local":"advanced-features","sections":[],"depth":3},{"title":"Training Best Practices","local":"training-best-practices","sections":[],"depth":3},{"title":"Common Pitfalls to Avoid","local":"common-pitfalls-to-avoid","sections":[],"depth":3},{"title":"Production Considerations","local":"production-considerations","sections":[],"depth":3}],"depth":2},{"title":"Beyond Basic Templates: Advanced Topics","local":"beyond-basic-templates-advanced-topics","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2},{"title":"Comprehensive Resources and Further Reading","local":"comprehensive-resources-and-further-reading","sections":[{"title":"Official Documentation","local":"official-documentation","sections":[],"depth":3},{"title":"Model and Dataset Resources","local":"model-and-dataset-resources","sections":[],"depth":3},{"title":"Technical References","local":"technical-references","sections":[],"depth":3},{"title":"Community Resources","local":"community-resources","sections":[],"depth":3}],"depth":2}],"depth":1}';function Fa(_l){return za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pa extends Ra{constructor(j){super(),Wa(this,j,Fa,Va,Ga,{})}}export{Pa as component};
