import{s as mt,f as ct,o as ht,n as ut}from"../chunks/scheduler.37c15a92.js";import{S as It,i as dt,g as M,s as e,r as J,A as gt,h as p,f as t,c as n,j as wt,u as o,x as i,k as b,y as bt,a,v as y,d as j,t as T,w as c,m as rt,n as Ut}from"../chunks/index.2bf4358c.js";import{T as Ct}from"../chunks/Tip.363c041f.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{H as m}from"../chunks/Heading.8ada512a.js";import{E as ft}from"../chunks/getInferenceSnippets.d4d07d1e.js";function Bt(Zl){let r,U,I="this notebook",u;return{c(){r=rt("You can follow the code in "),U=M("a"),U.textContent=I,u=rt(" that you can run using Google Colab."),this.h()},l(w){r=Ut(w,"You can follow the code in "),U=p(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(U)!=="svelte-1wsoqbe"&&(U.textContent=I),u=Ut(w," that you can run using Google Colab."),this.h()},h(){b(U,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/mail_sorting.ipynb"),b(U,"target","_blank")},m(w,d){a(w,r,d),a(w,U,d),a(w,u,d)},p:ut,d(w){w&&(t(r),t(U),t(u))}}}function Wt(Zl){let r,U,I,u,w,d,C,Qs="Now that we understand the building blocks, let’s put them into practice by building our first functional graph. We’ll implement Alfred’s email processing system, where he needs to:",Gl,f,Ss="<li>Read incoming emails</li> <li>Classify them as spam or legitimate</li> <li>Draft a preliminary response for legitimate emails</li> <li>Send information to Mr. Wayne when legitimate (printing only)</li>",El,B,ks="This example demonstrates how to structure a workflow with LangGraph that involves LLM-based decision-making. While this can’t be considered an Agent as no tool is involved, this section focuses more on learning the LangGraph framework than Agents.",ql,g,Al,W,Nl,Z,Vs="Here’s the workflow we’ll build:",Ql,G,Ys,Sl,E,kl,q,Fs="First, let’s install the required packages:",Vl,A,Yl,N,$s="Next, let’s import the necessary modules:",Fl,Q,$l,S,_l,k,_s="Let’s define what information Alfred needs to track during the email processing workflow:",Xl,V,xl,Y,Xs="<p>💡 <strong>Tip:</strong> Make your state comprehensive enough to track all the important information, but avoid bloating it with unnecessary details.</p>",vl,F,Rl,$,xs="Now, let’s create the processing functions that will form our nodes:",zl,_,Hl,X,Ll,x,vs="We need a function to determine which path to take after classification:",Dl,v,Ol,R,Rs="<p>💡 <strong>Note:</strong> This routing function is called by LangGraph to determine which edge to follow after the classification node. The return value must match one of the keys in our conditional edges mapping.</p>",Pl,z,Kl,H,zs="Now we connect everything together:",ls,L,ss,D,Hs="Notice how we use the special <code>END</code> node provided by LangGraph. This indicates terminal states where the workflow completes.",ts,O,as,P,Ls="Let’s test our graph with a legitimate email and a spam email:",es,K,ns,ll,Ms,sl,Ds="As Alfred fine-tunes the Mail Sorting Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Spam Detection Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",ps,tl,Os='To do this, Alfred can use an observability tool such as <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> to trace and monitor the agent.',is,al,Ps="First, we pip install Langfuse:",Js,el,os,nl,Ks="Second, we pip install Langchain (LangChain is required because we use LangFuse):",ys,Ml,js,pl,lt='Next, we add the Langfuse API keys and host address as environment variables. You can get your Langfuse credentials by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',Ts,il,cs,Jl,st='Then, we configure the <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> and instrument the agent by adding the <code>langfuse_callback</code> to the invocation of the graph: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',ws,ol,rs,yl,tt="Alfred is now connected 🔌! The runs from LangGraph are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Mail Sorting Agent even further.",Us,jl,at='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',ms,Tl,et='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',hs,cl,us,wl,nt="LangGraph allows us to visualize our workflow to better understand and debug its structure:",Is,rl,ds,Ul,Mt,gs,ml,pt="This produces a visual representation showing how our nodes are connected and the conditional paths that can be taken.",bs,hl,Cs,ul,it="We’ve created a complete email processing workflow that:",fs,Il,Jt="<li>Takes an incoming email</li> <li>Uses an LLM to classify it as spam or legitimate</li> <li>Handles spam by discarding it</li> <li>For legitimate emails, drafts a response and notifies Mr. Hugg</li>",Bs,dl,ot="This demonstrates the power of LangGraph to orchestrate complex workflows with LLMs while maintaining a clear, structured flow.",Ws,gl,Zs,bl,yt="<li><strong>State Management</strong>: We defined comprehensive state to track all aspects of email processing</li> <li><strong>Node Implementation</strong>: We created functional nodes that interact with an LLM</li> <li><strong>Conditional Routing</strong>: We implemented branching logic based on email classification</li> <li><strong>Terminal States</strong>: We used the END node to mark completion points in our workflow</li>",Gs,Cl,Es,fl,jt="In the next section, we’ll explore more advanced features of LangGraph, including handling human interaction in the workflow and implementing more complex branching logic based on multiple conditions.",qs,Bl,As,Wl,Ns;return w=new m({props:{title:"Building Your First LangGraph",local:"building-your-first-langgraph",headingTag:"h1"}}),g=new Ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:Zl}}}),W=new m({props:{title:"Our Workflow",local:"our-workflow",headingTag:"h2"}}),E=new m({props:{title:"Setting Up Our Environment",local:"setting-up-our-environment",headingTag:"h2"}}),A=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),Q=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUubWVzc2FnZXMlMjBpbXBvcnQlMjBIdW1hbk1lc3NhZ2U=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage`,wrap:!1}}),S=new m({props:{title:"Step 1: Define Our State",local:"step-1-define-our-state",headingTag:"h2"}}),V=new h({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBlbWFpbCUyMGJlaW5nJTIwcHJvY2Vzc2VkJTBBJTIwJTIwJTIwJTIwZW1haWwlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBzdWJqZWN0JTJDJTIwc2VuZGVyJTJDJTIwYm9keSUyQyUyMGV0Yy4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDYXRlZ29yeSUyMG9mJTIwdGhlJTIwZW1haWwlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMGV0Yy4pJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlYXNvbiUyMHdoeSUyMHRoZSUyMGVtYWlsJTIwd2FzJTIwbWFya2VkJTIwYXMlMjBzcGFtJTBBJTIwJTIwJTIwJTIwc3BhbV9yZWFzb24lM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFuYWx5c2lzJTIwYW5kJTIwZGVjaXNpb25zJTBBJTIwJTIwJTIwJTIwaXNfc3BhbSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlc3BvbnNlJTIwZ2VuZXJhdGlvbiUwQSUyMCUyMCUyMCUyMGVtYWlsX2RyYWZ0JTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzaW5nJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTIwJTIwJTIzJTIwVHJhY2slMjBjb252ZXJzYXRpb24lMjB3aXRoJTIwTExNJTIwZm9yJTIwYW5hbHlzaXM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The email being processed</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contains subject, sender, body, etc.</span>

    <span class="hljs-comment"># Category of the email (inquiry, complaint, etc.)</span>
    email_category: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Reason why the email was marked as spam</span>
    spam_reason: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Analysis and decisions</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Response generation</span>
    email_draft: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Processing metadata</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Track conversation with LLM for analysis</span>`,wrap:!1}}),F=new m({props:{title:"Step 2: Define Our Nodes",local:"step-2-define-our-nodes",headingTag:"h2"}}),_=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Initialize our LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred reads and logs the incoming email&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Here we might do some initial preprocessing</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred is processing an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> with subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No state changes needed here</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred uses an LLM to determine if the email is spam or legitimate&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, analyze this email and determine if it is spam or legitimate.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    First, determine if this email is spam. If it is spam, explain why.
    If it is legitimate, categorize it (inquiry, complaint, thank you, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Simple logic to parse the response (in a real app, you&#x27;d want more robust parsing)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extract a reason if it&#x27;s spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determine category if legitimate</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred discards spam email with a note&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred has marked the email as spam. Reason: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The email has been moved to the spam folder.&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred drafts a preliminary response for legitimate emails&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, draft a polite preliminary response to this email.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    This email has been categorized as: <span class="hljs-subst">{category}</span>
    
    Draft a brief, professional response that Mr. Hugg can review and personalize before sending.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;email_draft&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifies Mr. Hugg about the email and presents the draft response&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sir, you&#x27;ve received an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Category: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nI&#x27;ve prepared a draft response for your review:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;email_draft&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),X=new m({props:{title:"Step 3: Define Our Routing Logic",local:"step-3-define-our-routing-logic",headingTag:"h2"}}),v=new h({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmUlMjB0aGUlMjBuZXh0JTIwc3RlcCUyMGJhc2VkJTIwb24lMjBzcGFtJTIwY2xhc3NpZmljYXRpb24lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMHN0YXRlJTVCJTIyaXNfc3BhbSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMnNwYW0lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybGVnaXRpbWF0ZSUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determine the next step based on spam classification&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),z=new m({props:{title:"Step 4: Create the StateGraph and Define Edges",local:"step-4-create-the-stategraph-and-define-edges",headingTag:"h2"}}),L=new h({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZ3JhcGglMEFlbWFpbF9ncmFwaCUyMCUzRCUyMFN0YXRlR3JhcGgoRW1haWxTdGF0ZSklMEElMEElMjMlMjBBZGQlMjBub2RlcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwU3RhcnQlMjB0aGUlMjBlZGdlcyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIycmVhZF9lbWFpbCUyMiklMEElMjMlMjBBZGQlMjBlZGdlcyUyMC0lMjBkZWZpbmluZyUyMHRoZSUyMGZsb3clMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJyZWFkX2VtYWlsJTIyJTJDJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIpJTBBJTBBJTIzJTIwQWRkJTIwY29uZGl0aW9uYWwlMjBicmFuY2hpbmclMjBmcm9tJTIwY2xhc3NpZnlfZW1haWwlMEFlbWFpbF9ncmFwaC5hZGRfY29uZGl0aW9uYWxfZWRnZXMoJTBBJTIwJTIwJTIwJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIlMkMlMEElMjAlMjAlMjAlMjByb3V0ZV9lbWFpbCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwYW0lMjIlM0ElMjAlMjJoYW5kbGVfc3BhbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlZ2l0aW1hdGUlMjIlM0ElMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSklMEElMEElMjMlMjBBZGQlMjB0aGUlMjBmaW5hbCUyMGVkZ2VzJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBFTkQpJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyZHJhZnRfcmVzcG9uc2UlMjIlMkMlMjAlMjJub3RpZnlfbXJfaHVnZyUyMiklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJub3RpZnlfbXJfaHVnZyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBDb21waWxlJTIwdGhlJTIwZ3JhcGglMEFjb21waWxlZF9ncmFwaCUyMCUzRCUyMGVtYWlsX2dyYXBoLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-comment"># Create the graph</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Add nodes</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Start the edges</span>
email_graph.add_edge(START, <span class="hljs-string">&quot;read_email&quot;</span>)
<span class="hljs-comment"># Add edges - defining the flow</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Add conditional branching from classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Add the final edges</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compile the graph</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),O=new m({props:{title:"Step 5: Run the Application",local:"step-5-run-the-application",headingTag:"h2"}}),K=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Example legitimate email</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question about your services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Dear Mr. Hugg, I was referred to you by a colleague and I&#x27;m interested in learning more about your consulting services. Could we schedule a call next week? Best regards, John Smith&quot;</span>
}

<span class="hljs-comment"># Example spam email</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;YOU HAVE WON $5,000,000!!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;CONGRATULATIONS! You have been selected as the winner of our international lottery! To claim your $5,000,000 prize, please send us your bank details and a processing fee of $100.&quot;</span>
}

<span class="hljs-comment"># Process the legitimate email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing legitimate email...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># Process the spam email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing spam email...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),ll=new m({props:{title:"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡",local:"step-6-inspecting-our-mail-sorting-agent-with-langfuse-",headingTag:"h2"}}),el=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),Ml=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdjaGFpbg==",highlighted:"%pip install langchain",wrap:!1}}),il=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),ol=new h({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmxhbmdjaGFpbiUyMGltcG9ydCUyMENhbGxiYWNrSGFuZGxlciUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBMYW5nZnVzZSUyMENhbGxiYWNrSGFuZGxlciUyMGZvciUyMExhbmdHcmFwaCUyRkxhbmdjaGFpbiUyMCh0cmFjaW5nKSUwQWxhbmdmdXNlX2hhbmRsZXIlMjAlM0QlMjBDYWxsYmFja0hhbmRsZXIoKSUwQSUwQSUyMyUyMFByb2Nlc3MlMjBsZWdpdGltYXRlJTIwZW1haWwlMEFsZWdpdGltYXRlX3Jlc3VsdCUyMCUzRCUyMGNvbXBpbGVkX2dyYXBoLmludm9rZSglMEElMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMmVtYWlsJTIyJTNBJTIwbGVnaXRpbWF0ZV9lbWFpbCUyQyUyMCUyMmlzX3NwYW0lMjIlM0ElMjBOb25lJTJDJTIwJTIyc3BhbV9yZWFzb24lMjIlM0ElMjBOb25lJTJDJTIwJTIyZW1haWxfY2F0ZWdvcnklMjIlM0ElMjBOb25lJTJDJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlM0ElMjBOb25lJTJDJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBjb25maWclM0QlN0IlMjJjYWxsYmFja3MlMjIlM0ElMjAlNUJsYW5nZnVzZV9oYW5kbGVyJTVEJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langfuse.langchain <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Initialize Langfuse CallbackHandler for LangGraph/Langchain (tracing)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Process legitimate email</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),cl=new m({props:{title:"Visualizing Our Graph",local:"visualizing-our-graph",headingTag:"h2"}}),rl=new h({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),hl=new m({props:{title:"What We’ve Built",local:"what-weve-built",headingTag:"h2"}}),gl=new m({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),Cl=new m({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),Bl=new ft({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/first_graph.mdx"}}),{c(){r=M("meta"),U=e(),I=M("p"),u=e(),J(w.$$.fragment),d=e(),C=M("p"),C.textContent=Qs,Gl=e(),f=M("ol"),f.innerHTML=Ss,El=e(),B=M("p"),B.textContent=ks,ql=e(),J(g.$$.fragment),Al=e(),J(W.$$.fragment),Nl=e(),Z=M("p"),Z.textContent=Vs,Ql=e(),G=M("img"),Sl=e(),J(E.$$.fragment),kl=e(),q=M("p"),q.textContent=Fs,Vl=e(),J(A.$$.fragment),Yl=e(),N=M("p"),N.textContent=$s,Fl=e(),J(Q.$$.fragment),$l=e(),J(S.$$.fragment),_l=e(),k=M("p"),k.textContent=_s,Xl=e(),J(V.$$.fragment),xl=e(),Y=M("blockquote"),Y.innerHTML=Xs,vl=e(),J(F.$$.fragment),Rl=e(),$=M("p"),$.textContent=xs,zl=e(),J(_.$$.fragment),Hl=e(),J(X.$$.fragment),Ll=e(),x=M("p"),x.textContent=vs,Dl=e(),J(v.$$.fragment),Ol=e(),R=M("blockquote"),R.innerHTML=Rs,Pl=e(),J(z.$$.fragment),Kl=e(),H=M("p"),H.textContent=zs,ls=e(),J(L.$$.fragment),ss=e(),D=M("p"),D.innerHTML=Hs,ts=e(),J(O.$$.fragment),as=e(),P=M("p"),P.textContent=Ls,es=e(),J(K.$$.fragment),ns=e(),J(ll.$$.fragment),Ms=e(),sl=M("p"),sl.textContent=Ds,ps=e(),tl=M("p"),tl.innerHTML=Os,is=e(),al=M("p"),al.textContent=Ps,Js=e(),J(el.$$.fragment),os=e(),nl=M("p"),nl.textContent=Ks,ys=e(),J(Ml.$$.fragment),js=e(),pl=M("p"),pl.innerHTML=lt,Ts=e(),J(il.$$.fragment),cs=e(),Jl=M("p"),Jl.innerHTML=st,ws=e(),J(ol.$$.fragment),rs=e(),yl=M("p"),yl.textContent=tt,Us=e(),jl=M("p"),jl.innerHTML=at,ms=e(),Tl=M("p"),Tl.innerHTML=et,hs=e(),J(cl.$$.fragment),us=e(),wl=M("p"),wl.textContent=nt,Is=e(),J(rl.$$.fragment),ds=e(),Ul=M("img"),gs=e(),ml=M("p"),ml.textContent=pt,bs=e(),J(hl.$$.fragment),Cs=e(),ul=M("p"),ul.textContent=it,fs=e(),Il=M("ol"),Il.innerHTML=Jt,Bs=e(),dl=M("p"),dl.textContent=ot,Ws=e(),J(gl.$$.fragment),Zs=e(),bl=M("ul"),bl.innerHTML=yt,Gs=e(),J(Cl.$$.fragment),Es=e(),fl=M("p"),fl.textContent=jt,qs=e(),J(Bl.$$.fragment),As=e(),Wl=M("p"),this.h()},l(l){const s=gt("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),U=n(l),I=p(l,"P",{}),wt(I).forEach(t),u=n(l),o(w.$$.fragment,l),d=n(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-vhd0jr"&&(C.textContent=Qs),Gl=n(l),f=p(l,"OL",{"data-svelte-h":!0}),i(f)!=="svelte-1v71265"&&(f.innerHTML=Ss),El=n(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1qg9fnr"&&(B.textContent=ks),ql=n(l),o(g.$$.fragment,l),Al=n(l),o(W.$$.fragment,l),Nl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-9r2hfn"&&(Z.textContent=Vs),Ql=n(l),G=p(l,"IMG",{src:!0,alt:!0}),Sl=n(l),o(E.$$.fragment,l),kl=n(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1n92y5t"&&(q.textContent=Fs),Vl=n(l),o(A.$$.fragment,l),Yl=n(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-rnel3w"&&(N.textContent=$s),Fl=n(l),o(Q.$$.fragment,l),$l=n(l),o(S.$$.fragment,l),_l=n(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-54271l"&&(k.textContent=_s),Xl=n(l),o(V.$$.fragment,l),xl=n(l),Y=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Y)!=="svelte-10gtfo"&&(Y.innerHTML=Xs),vl=n(l),o(F.$$.fragment,l),Rl=n(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1d4gnq4"&&($.textContent=xs),zl=n(l),o(_.$$.fragment,l),Hl=n(l),o(X.$$.fragment,l),Ll=n(l),x=p(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1n2afnf"&&(x.textContent=vs),Dl=n(l),o(v.$$.fragment,l),Ol=n(l),R=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(R)!=="svelte-k4q46u"&&(R.innerHTML=Rs),Pl=n(l),o(z.$$.fragment,l),Kl=n(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1c3pli7"&&(H.textContent=zs),ls=n(l),o(L.$$.fragment,l),ss=n(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-18k1jtw"&&(D.innerHTML=Hs),ts=n(l),o(O.$$.fragment,l),as=n(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1kryxnq"&&(P.textContent=Ls),es=n(l),o(K.$$.fragment,l),ns=n(l),o(ll.$$.fragment,l),Ms=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-xyrseq"&&(sl.textContent=Ds),ps=n(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-i70kr9"&&(tl.innerHTML=Os),is=n(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-fhqopd"&&(al.textContent=Ps),Js=n(l),o(el.$$.fragment,l),os=n(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1ketwty"&&(nl.textContent=Ks),ys=n(l),o(Ml.$$.fragment,l),js=n(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1i2d6na"&&(pl.innerHTML=lt),Ts=n(l),o(il.$$.fragment,l),cs=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1bzsazf"&&(Jl.innerHTML=st),ws=n(l),o(ol.$$.fragment,l),rs=n(l),yl=p(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-blbazh"&&(yl.textContent=tt),Us=n(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-3rgcl6"&&(jl.innerHTML=at),ms=n(l),Tl=p(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1kmw2a1"&&(Tl.innerHTML=et),hs=n(l),o(cl.$$.fragment,l),us=n(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1wkuxx2"&&(wl.textContent=nt),Is=n(l),o(rl.$$.fragment,l),ds=n(l),Ul=p(l,"IMG",{src:!0,alt:!0}),gs=n(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-hhguub"&&(ml.textContent=pt),bs=n(l),o(hl.$$.fragment,l),Cs=n(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1vjenz"&&(ul.textContent=it),fs=n(l),Il=p(l,"OL",{"data-svelte-h":!0}),i(Il)!=="svelte-eyxtqr"&&(Il.innerHTML=Jt),Bs=n(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1evobzg"&&(dl.textContent=ot),Ws=n(l),o(gl.$$.fragment,l),Zs=n(l),bl=p(l,"UL",{"data-svelte-h":!0}),i(bl)!=="svelte-w0bhrr"&&(bl.innerHTML=yt),Gs=n(l),o(Cl.$$.fragment,l),Es=n(l),fl=p(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1kcwc84"&&(fl.textContent=jt),qs=n(l),o(Bl.$$.fragment,l),As=n(l),Wl=p(l,"P",{}),wt(Wl).forEach(t),this.h()},h(){b(r,"name","hf:doc:metadata"),b(r,"content",Zt),ct(G.src,Ys="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||b(G,"src",Ys),b(G,"alt","First LangGraph"),ct(Ul.src,Mt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||b(Ul,"src",Mt),b(Ul,"alt","Mail LangGraph")},m(l,s){bt(document.head,r),a(l,U,s),a(l,I,s),a(l,u,s),y(w,l,s),a(l,d,s),a(l,C,s),a(l,Gl,s),a(l,f,s),a(l,El,s),a(l,B,s),a(l,ql,s),y(g,l,s),a(l,Al,s),y(W,l,s),a(l,Nl,s),a(l,Z,s),a(l,Ql,s),a(l,G,s),a(l,Sl,s),y(E,l,s),a(l,kl,s),a(l,q,s),a(l,Vl,s),y(A,l,s),a(l,Yl,s),a(l,N,s),a(l,Fl,s),y(Q,l,s),a(l,$l,s),y(S,l,s),a(l,_l,s),a(l,k,s),a(l,Xl,s),y(V,l,s),a(l,xl,s),a(l,Y,s),a(l,vl,s),y(F,l,s),a(l,Rl,s),a(l,$,s),a(l,zl,s),y(_,l,s),a(l,Hl,s),y(X,l,s),a(l,Ll,s),a(l,x,s),a(l,Dl,s),y(v,l,s),a(l,Ol,s),a(l,R,s),a(l,Pl,s),y(z,l,s),a(l,Kl,s),a(l,H,s),a(l,ls,s),y(L,l,s),a(l,ss,s),a(l,D,s),a(l,ts,s),y(O,l,s),a(l,as,s),a(l,P,s),a(l,es,s),y(K,l,s),a(l,ns,s),y(ll,l,s),a(l,Ms,s),a(l,sl,s),a(l,ps,s),a(l,tl,s),a(l,is,s),a(l,al,s),a(l,Js,s),y(el,l,s),a(l,os,s),a(l,nl,s),a(l,ys,s),y(Ml,l,s),a(l,js,s),a(l,pl,s),a(l,Ts,s),y(il,l,s),a(l,cs,s),a(l,Jl,s),a(l,ws,s),y(ol,l,s),a(l,rs,s),a(l,yl,s),a(l,Us,s),a(l,jl,s),a(l,ms,s),a(l,Tl,s),a(l,hs,s),y(cl,l,s),a(l,us,s),a(l,wl,s),a(l,Is,s),y(rl,l,s),a(l,ds,s),a(l,Ul,s),a(l,gs,s),a(l,ml,s),a(l,bs,s),y(hl,l,s),a(l,Cs,s),a(l,ul,s),a(l,fs,s),a(l,Il,s),a(l,Bs,s),a(l,dl,s),a(l,Ws,s),y(gl,l,s),a(l,Zs,s),a(l,bl,s),a(l,Gs,s),y(Cl,l,s),a(l,Es,s),a(l,fl,s),a(l,qs,s),y(Bl,l,s),a(l,As,s),a(l,Wl,s),Ns=!0},p(l,[s]){const Tt={};s&2&&(Tt.$$scope={dirty:s,ctx:l}),g.$set(Tt)},i(l){Ns||(j(w.$$.fragment,l),j(g.$$.fragment,l),j(W.$$.fragment,l),j(E.$$.fragment,l),j(A.$$.fragment,l),j(Q.$$.fragment,l),j(S.$$.fragment,l),j(V.$$.fragment,l),j(F.$$.fragment,l),j(_.$$.fragment,l),j(X.$$.fragment,l),j(v.$$.fragment,l),j(z.$$.fragment,l),j(L.$$.fragment,l),j(O.$$.fragment,l),j(K.$$.fragment,l),j(ll.$$.fragment,l),j(el.$$.fragment,l),j(Ml.$$.fragment,l),j(il.$$.fragment,l),j(ol.$$.fragment,l),j(cl.$$.fragment,l),j(rl.$$.fragment,l),j(hl.$$.fragment,l),j(gl.$$.fragment,l),j(Cl.$$.fragment,l),j(Bl.$$.fragment,l),Ns=!0)},o(l){T(w.$$.fragment,l),T(g.$$.fragment,l),T(W.$$.fragment,l),T(E.$$.fragment,l),T(A.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(V.$$.fragment,l),T(F.$$.fragment,l),T(_.$$.fragment,l),T(X.$$.fragment,l),T(v.$$.fragment,l),T(z.$$.fragment,l),T(L.$$.fragment,l),T(O.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(el.$$.fragment,l),T(Ml.$$.fragment,l),T(il.$$.fragment,l),T(ol.$$.fragment,l),T(cl.$$.fragment,l),T(rl.$$.fragment,l),T(hl.$$.fragment,l),T(gl.$$.fragment,l),T(Cl.$$.fragment,l),T(Bl.$$.fragment,l),Ns=!1},d(l){l&&(t(U),t(I),t(u),t(d),t(C),t(Gl),t(f),t(El),t(B),t(ql),t(Al),t(Nl),t(Z),t(Ql),t(G),t(Sl),t(kl),t(q),t(Vl),t(Yl),t(N),t(Fl),t($l),t(_l),t(k),t(Xl),t(xl),t(Y),t(vl),t(Rl),t($),t(zl),t(Hl),t(Ll),t(x),t(Dl),t(Ol),t(R),t(Pl),t(Kl),t(H),t(ls),t(ss),t(D),t(ts),t(as),t(P),t(es),t(ns),t(Ms),t(sl),t(ps),t(tl),t(is),t(al),t(Js),t(os),t(nl),t(ys),t(js),t(pl),t(Ts),t(cs),t(Jl),t(ws),t(rs),t(yl),t(Us),t(jl),t(ms),t(Tl),t(hs),t(us),t(wl),t(Is),t(ds),t(Ul),t(gs),t(ml),t(bs),t(Cs),t(ul),t(fs),t(Il),t(Bs),t(dl),t(Ws),t(Zs),t(bl),t(Gs),t(Es),t(fl),t(qs),t(As),t(Wl)),t(r),c(w,l),c(g,l),c(W,l),c(E,l),c(A,l),c(Q,l),c(S,l),c(V,l),c(F,l),c(_,l),c(X,l),c(v,l),c(z,l),c(L,l),c(O,l),c(K,l),c(ll,l),c(el,l),c(Ml,l),c(il,l),c(ol,l),c(cl,l),c(rl,l),c(hl,l),c(gl,l),c(Cl,l),c(Bl,l)}}}const Zt='{"title":"Building Your First LangGraph","local":"building-your-first-langgraph","sections":[{"title":"Our Workflow","local":"our-workflow","sections":[],"depth":2},{"title":"Setting Up Our Environment","local":"setting-up-our-environment","sections":[],"depth":2},{"title":"Step 1: Define Our State","local":"step-1-define-our-state","sections":[],"depth":2},{"title":"Step 2: Define Our Nodes","local":"step-2-define-our-nodes","sections":[],"depth":2},{"title":"Step 3: Define Our Routing Logic","local":"step-3-define-our-routing-logic","sections":[],"depth":2},{"title":"Step 4: Create the StateGraph and Define Edges","local":"step-4-create-the-stategraph-and-define-edges","sections":[],"depth":2},{"title":"Step 5: Run the Application","local":"step-5-run-the-application","sections":[],"depth":2},{"title":"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡","local":"step-6-inspecting-our-mail-sorting-agent-with-langfuse-","sections":[],"depth":2},{"title":"Visualizing Our Graph","local":"visualizing-our-graph","sections":[],"depth":2},{"title":"What We’ve Built","local":"what-weve-built","sections":[],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Gt(Zl){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends It{constructor(r){super(),dt(this,r,Gt,Wt,mt,{})}}export{kt as component};
