import{s as Rn,o as Vn,n as zn}from"../chunks/scheduler.7bc62968.js";import{S as Fn,i as Hn,g as h,s as a,r as i,A as _n,h as j,f as t,c as n,j as An,u as p,x as y,k as Yn,y as Ln,a as e,v as o,d as r,t as M,w as c}from"../chunks/index.66556066.js";import{T as Dn}from"../chunks/Tip.ad57eee8.js";import{C as u}from"../chunks/CodeBlock.5372f996.js";import{H as m,E as Pn}from"../chunks/index.c085705e.js";function Kn(lt){let J,T="Similarily to the OpenAI JS client, <code>InferenceClient</code> can be used to run Chat Completion inference with any OpenAI REST API-compatible endpoint.";return{c(){J=h("p"),J.innerHTML=T},l(f){J=j(f,"P",{"data-svelte-h":!0}),y(J)!=="svelte-hfbgnr"&&(J.innerHTML=T)},m(f,Ol){e(f,J,Ol)},p:zn,d(f){f&&t(J)}}}function On(lt){let J,T,f,Ol,d,tt,g,Ea="A Typescript powered wrapper that provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:",et,U,Wa='<li><a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a>: a streamlined, unified access to hundreds of machine learning models, powered by our serverless inference partners. This new approach builds on our previous Serverless Inference API, offering more models, improved performance, and greater reliability thanks to world-class providers. Refer to the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">documentation</a> for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li> <li>Local endpoints: you can also run inference with local inference servers like <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://ollama.com/" rel="nofollow">Ollama</a>, <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a>, <a href="https://docs.litellm.ai/docs/simple_proxy" rel="nofollow">LiteLLM</a>, or <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> by connecting the client to these local endpoints.</li>',at,$,nt,I,it,b,pt,C,ot,x,rt,B,Mt,Z,ct,k,ht,Q,Sa='❗<strong>Important note:</strong> Always pass an access token. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',jt,v,Xa="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",yt,N,mt,G,qa="You can send inference requests to third-party providers with the inference client.",ut,E,Aa="Currently, we support the following providers:",Jt,W,Ya='<li><a href="https://fal.ai" rel="nofollow">Fal.ai</a></li> <li><a href="https://featherless.ai" rel="nofollow">Featherless AI</a></li> <li><a href="https://fireworks.ai" rel="nofollow">Fireworks AI</a></li> <li><a href="https://huggingface.co/docs/inference-providers/providers/hf-inference" rel="nofollow">HF Inference</a></li> <li><a href="https://hyperbolic.xyz" rel="nofollow">Hyperbolic</a></li> <li><a href="https://studio.nebius.ai" rel="nofollow">Nebius</a></li> <li><a href="https://novita.ai" rel="nofollow">Novita</a></li> <li><a href="https://nscale.com" rel="nofollow">Nscale</a></li> <li><a href="https://endpoints.ai.cloud.ovh.net/" rel="nofollow">OVHcloud</a></li> <li><a href="https://replicate.com" rel="nofollow">Replicate</a></li> <li><a href="https://sambanova.ai" rel="nofollow">Sambanova</a></li> <li><a href="https://together.xyz" rel="nofollow">Together</a></li> <li><a href="https://blackforestlabs.ai" rel="nofollow">Blackforestlabs</a></li> <li><a href="https://cohere.com" rel="nofollow">Cohere</a></li> <li><a href="https://cerebras.ai/" rel="nofollow">Cerebras</a></li> <li><a href="https://groq.com" rel="nofollow">Groq</a></li>',ft,S,Ra='To send requests to a third-party provider, you have to pass the <code>provider</code> parameter to the inference function. The default value of the <code>provider</code> parameter is “auto”, which will select the first of the providers available for the model, sorted by your preferred order in <a href="https://hf.co/settings/inference-providers" rel="nofollow">https://hf.co/settings/inference-providers</a>.',wt,X,Tt,q,Va=`You also have to make sure your request is authenticated with an access token.
When authenticated with a Hugging Face access token, the request is routed through <a href="https://huggingface.co." rel="nofollow">https://huggingface.co.</a>
When authenticated with a third-party provider key, the request is made directly against that provider’s inference API.`,dt,A,za="Only a subset of models are supported when requesting third-party providers. You can check the list of supported models per pipeline tasks here:",gt,Y,Fa='<li><a href="https://huggingface.co/api/partners/fal-ai/models" rel="nofollow">Fal.ai supported models</a></li> <li><a href="https://huggingface.co/api/partners/featherless-ai/models" rel="nofollow">Featherless AI supported models</a></li> <li><a href="https://huggingface.co/api/partners/fireworks-ai/models" rel="nofollow">Fireworks AI supported models</a></li> <li><a href="https://huggingface.co/api/partners/hf-inference/models" rel="nofollow">HF Inference supported models</a></li> <li><a href="https://huggingface.co/api/partners/hyperbolic/models" rel="nofollow">Hyperbolic supported models</a></li> <li><a href="https://huggingface.co/api/partners/nebius/models" rel="nofollow">Nebius supported models</a></li> <li><a href="https://huggingface.co/api/partners/nscale/models" rel="nofollow">Nscale supported models</a></li> <li><a href="https://huggingface.co/api/partners/ovhcloud/models" rel="nofollow">OVHcloud supported models</a></li> <li><a href="https://huggingface.co/api/partners/replicate/models" rel="nofollow">Replicate supported models</a></li> <li><a href="https://huggingface.co/api/partners/sambanova/models" rel="nofollow">Sambanova supported models</a></li> <li><a href="https://huggingface.co/api/partners/together/models" rel="nofollow">Together supported models</a></li> <li><a href="https://huggingface.co/api/partners/cohere/models" rel="nofollow">Cohere supported models</a></li> <li><a href="https://huggingface.co/api/partners/cerebras/models" rel="nofollow">Cerebras supported models</a></li> <li><a href="https://console.groq.com/docs/models" rel="nofollow">Groq supported models</a></li> <li><a href="https://huggingface.co/api/partners/novita/models" rel="nofollow">Novita AI supported models</a></li>',Ut,R,Ha=`❗<strong>Important note:</strong> To be compatible, the third-party API must adhere to the “standard” shape API we expect on HF model pages for each pipeline task type.
This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there exists no standard API. Let us know if any help is needed or if we can make things easier for you!`,$t,V,_a='👋<strong>Want to add another provider?</strong> Get in touch if you’d like to add support for another Inference provider, and/or request it on <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49</a>',It,z,bt,F,La="You can import the functions you need directly from the module instead of using the <code>InferenceClient</code> class.",Ct,H,xt,_,Da="This will enable tree-shaking by your bundler.",Bt,L,Zt,D,kt,P,Pa="Generates text from an input prompt.",Qt,K,vt,O,Nt,ss,Ka="Generate a model response from a list of messages comprising a conversation.",Gt,ls,Et,ts,Wt,es,Oa="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",St,as,Xt,ns,qt,is,sn="Tries to fill in a hole with a missing word (token to be precise).",At,ps,Yt,os,Rt,rs,ln="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",Vt,Ms,zt,cs,Ft,hs,tn="Answers questions based on the context you provide.",Ht,js,_t,ys,Lt,ms,Dt,us,Pt,Js,en="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",Kt,fs,Ot,ws,se,Ts,an="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",le,ds,te,gs,ee,Us,nn="Converts text from one language to another.",ae,$s,ne,Is,ie,bs,pn="Checks how well an input text fits into a set of labels you provide.",pe,Cs,oe,xs,re,Bs,on="Calculate the semantic similarity between one text and a list of other sentences.",Me,Zs,ce,ks,he,Qs,je,vs,rn="Transcribes speech from an audio file.",ye,Ns,Mn='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',me,Gs,ue,Es,Je,Ws,cn="Assigns labels to the given audio along with a probability score of that label.",fe,Ss,hn='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',we,Xs,Te,qs,de,As,jn="Generates natural-sounding speech from text input.",ge,Ys,yn='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Ue,Rs,$e,Vs,Ie,zs,mn="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",be,Fs,Ce,Hs,xe,_s,Be,Ls,un="Assigns labels to a given image along with a probability score of that label.",Ze,Ds,Jn='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',ke,Ps,Qe,Ks,ve,Os,fn="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",Ne,sl,wn='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',Ge,ll,Ee,tl,We,el,Tn="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",Se,al,Xe,nl,qe,il,dn="Outputs text from a given image, commonly used for captioning or optical character recognition.",Ae,pl,Ye,ol,Re,rl,gn="Creates an image from a text prompt.",Ve,Ml,Un='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',ze,cl,Fe,hl,He,jl,$n="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",_e,yl,In='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Le,ml,De,ul,Pe,Jl,bn="Checks how well an input image fits into a set of labels you provide.",Ke,fl,Oe,wl,sa,Tl,la,dl,Cn="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",ta,gl,xn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',ea,Ul,aa,$l,na,Il,Bn="Document question answering models take a (document, question) pair as input and return an answer in natural language.",ia,bl,Zn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',pa,Cl,oa,xl,ra,Bl,Ma,Zl,kn="Tabular regression is the task of predicting a numerical value given a set of attributes.",ca,kl,ha,Ql,ja,vl,Qn="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",ya,Nl,ma,Gl,vn="You can use any Chat Completion API-compatible provider with the <code>chatCompletion</code> method.",ua,El,Ja,Wl,fa,Sl,Nn=`The examples we saw above use inference providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure. That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to:`,wa,Xl,Ta,ql,Gn=`By default, all calls to the inference endpoint will wait until the model is loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to 0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP errors yourself, you can do so like so:`,da,Al,ga,Yl,Ua,Rl,En="You can use <code>InferenceClient</code> to run chat completion with local inference servers (llama.cpp, vllm, litellm server, TGI, mlx, etc.) running on your own machine. The API should be OpenAI API-compatible.",$a,Vl,Ia,w,ba,zl,Ca,Fl,xa,Hl,Ba,_l,Wn='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Za,Ll,Sn="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",ka,Dl,Qa,Pl,Xn="<li><code>@huggingface/tasks</code> : Typings only</li>",va,Kl,Na,st,Ga;return d=new m({props:{title:"🤗 Hugging Face Inference",local:"-hugging-face-inference",headingTag:"h1"}}),$=new m({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),I=new m({props:{title:"Install",local:"install",headingTag:"h3"}}),b=new m({props:{title:"Node",local:"node",headingTag:"h4"}}),C=new u({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),x=new m({props:{title:"Deno",local:"deno",headingTag:"h4"}}),B=new u({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUzQg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>;
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>;`,wrap:!1}}),Z=new m({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),k=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCclNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSclM0IlMEElMEFjb25zdCUyMGhmJTIwJTNEJTIwbmV3JTIwSW5mZXJlbmNlQ2xpZW50KCd5b3VyJTIwYWNjZXNzJTIwdG9rZW4nKSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>;

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>);`,wrap:!1}}),N=new m({props:{title:"Using Inference Providers",local:"using-inference-providers",headingTag:"h2"}}),X=new u({props:{code:"Y29uc3QlMjBhY2Nlc3NUb2tlbiUyMCUzRCUyMCUyMmhmXy4uLiUyMiUzQiUyMCUyRiUyRiUyMEVpdGhlciUyMGElMjBIRiUyMGFjY2VzcyUyMHRva2VuJTJDJTIwb3IlMjBhbiUyMEFQSSUyMGtleSUyMGZyb20lMjB0aGUlMjB0aGlyZC1wYXJ0eSUyMHByb3ZpZGVyJTIwKFJlcGxpY2F0ZSUyMGluJTIwdGhpcyUyMGV4YW1wbGUpJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoYWNjZXNzVG9rZW4pJTNCJTBBYXdhaXQlMjBjbGllbnQudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwcHJvdmlkZXIlM0ElMjAlMjJyZXBsaWNhdGUlMjIlMkMlMEElMjAlMjBtb2RlbCUzQSUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLWRldiUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCUyMkElMjBibGFjayUyMGZvcmVzdCUyMGNha2UlMjIlMEElN0Qp",highlighted:`<span class="hljs-keyword">const</span> accessToken = <span class="hljs-string">&quot;hf_...&quot;</span>; <span class="hljs-comment">// Either a HF access token, or an API key from the third-party provider (Replicate in this example)</span>

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(accessToken);
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">model</span>:<span class="hljs-string">&quot;black-forest-labs/Flux.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A black forest cake&quot;</span>
})`,wrap:!1}}),z=new m({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h3"}}),H=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),L=new m({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h3"}}),D=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h4"}}),K=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItdjAuMSclMkMlMEElMjAlMjBwcm92aWRlciUzQSUyMCUyMnRvZ2V0aGVyJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ1RoZSUyMGFuc3dlciUyMHRvJTIwdGhlJTIwdW5pdmVyc2UlMjBpcyclMEElN0QpJTBBJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBvdXRwdXQlMjBvZiUyMGhmLnRleHRHZW5lcmF0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLXYwLjElMjIlMkMlMEElMjAlMjBwcm92aWRlciUzQSUyMCUyMnRvZ2V0aGVyJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;mistralai/Mixtral-8x7B-v0.1&#x27;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;together&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;together&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),O=new m({props:{title:"Chat Completion",local:"chat-completion",headingTag:"h4"}}),ls=new u({props:{code:"JTJGJTJGJTIwTm9uLXN0cmVhbWluZyUyMEFQSSUwQWNvbnN0JTIwb3V0JTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMlF3ZW4lMkZRd2VuMy0zMkIlMjIlMkMlMEElMjAlMjBwcm92aWRlciUzQSUyMCUyMmNlcmVicmFzJTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJIZWxsbyUyQyUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTIyJTIwJTdEJTVEJTJDJTBBJTIwJTIwbWF4X3Rva2VucyUzQSUyMDUxMiUyQyUwQSUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC4xJTJDJTBBJTdEKSUzQiUwQSUwQSUyRiUyRiUyMFN0cmVhbWluZyUyMEFQSSUwQWxldCUyMG91dCUyMCUzRCUyMCUyMiUyMiUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwY2h1bmslMjBvZiUyMGhmLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyUXdlbiUyRlF3ZW4zLTMyQiUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyY2VyZWJyYXMlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNhbiUyMHlvdSUyMGhlbHAlMjBtZSUyMHNvbHZlJTIwYW4lMjBlcXVhdGlvbiUzRiUyMiUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MTIlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuMSUyQyUwQSU3RCkpJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-comment">// Non-streaming API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;Qwen/Qwen3-32B&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;cerebras&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
});

<span class="hljs-comment">// Streaming API</span>
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;Qwen/Qwen3-32B&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;cerebras&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Can you help me solve an equation?&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}`,wrap:!1}}),ts=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h4"}}),as=new u({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),ns=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h4"}}),ps=new u({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),os=new m({props:{title:"Summarization",local:"summarization",headingTag:"h4"}}),Ms=new u({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),cs=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h4"}}),js=new u({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),ys=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h4"}}),ms=new u({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),us=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h4"}}),fs=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),ws=new m({props:{title:"Token Classification",local:"token-classification",headingTag:"h4"}}),ds=new u({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),gs=new m({props:{title:"Translation",local:"translation",headingTag:"h4"}}),$s=new u({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMjAlMjAlMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
  <span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
  <span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
 }
})`,wrap:!1}}),Is=new m({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h4"}}),Cs=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),xs=new m({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h4"}}),Zs=new u({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),ks=new m({props:{title:"Audio",local:"audio",headingTag:"h3"}}),Qs=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h4"}}),Gs=new u({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Es=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h4"}}),Xs=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),qs=new m({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h4"}}),Rs=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),Vs=new m({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h4"}}),Fs=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Hs=new m({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h3"}}),_s=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h4"}}),Ps=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Ks=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h4"}}),ll=new u({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),tl=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h4"}}),al=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),nl=new m({props:{title:"Image To Text",local:"image-to-text",headingTag:"h4"}}),pl=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),ol=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h4"}}),cl=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2ElMjBwaWN0dXJlJTIwb2YlMjBhJTIwZ3JlZW4lMjBiaXJkJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>
})`,wrap:!1}}),hl=new m({props:{title:"Image To Image",local:"image-to-image",headingTag:"h4"}}),ml=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),ul=new m({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h4"}}),fl=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),wl=new m({props:{title:"Multimodal",local:"multimodal",headingTag:"h3"}}),Tl=new m({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h4"}}),Ul=new u({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),$l=new m({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h4"}}),Cl=new u({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),xl=new m({props:{title:"Tabular",local:"tabular",headingTag:"h3"}}),Bl=new m({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h4"}}),kl=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),Ql=new m({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h4"}}),Nl=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),El=new u({props:{code:"JTJGJTJGJTIwQ2hhdCUyMENvbXBsZXRpb24lMjBFeGFtcGxlJTBBY29uc3QlMjBNSVNUUkFMX0tFWSUyMCUzRCUyMHByb2Nlc3MuZW52Lk1JU1RSQUxfS0VZJTNCJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudChNSVNUUkFMX0tFWSklM0IlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGkubWlzdHJhbC5haSUyMiklM0IlMEFjb25zdCUyMHN0cmVhbSUyMCUzRCUyMGVwLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWlzdHJhbC10aW55JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDb21wbGV0ZSUyMHRoZSUyMGVxdWF0aW9uJTIwb25lJTIwJTJCJTIwb25lJTIwJTNEJTIwJTJDJTIwanVzdCUyMHRoZSUyMGFuc3dlciUyMiUyMCU3RCU1RCUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjAlMjIlMjIlM0IlMEFmb3IlMjBhd2FpdCUyMChjb25zdCUyMGNodW5rJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2cob3V0KSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">MISTRAL_KEY</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">MISTRAL_KEY</span>;
<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">MISTRAL_KEY</span>);
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.mistral.ai&quot;</span>);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistral-tiny&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation one + one = , just the answer&quot;</span> }],
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),Wl=new m({props:{title:"Using Inference Endpoints",local:"using-inference-endpoints",headingTag:"h2"}}),Xl=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCclNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSclM0IlMEElMEFjb25zdCUyMGhmJTIwJTNEJTIwbmV3JTIwSW5mZXJlbmNlQ2xpZW50KCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTJDJTIwJTdCJTBBJTA5ZW5kcG9pbnRVcmwlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmozejVsdXUwb29vNzZqbmwudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMkZ2MSUyRiUyMiUyQyUwQSU3RCklM0IlMEElMEFjb25zdCUyMHJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMDltZXNzYWdlcyUzQSUyMCU1QiUwQSUwOSUwOSU3QiUwQSUwOSUwOSUwOXJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTA5JTA5JTA5Y29udGVudCUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiUyQyUwQSUwOSUwOSU3RCUyQyUwQSUwOSU1RCUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhyZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>;

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>, {
	<span class="hljs-attr">endpointUrl</span>: <span class="hljs-string">&quot;https://j3z5luu0ooo76jnl.us-east-1.aws.endpoints.huggingface.cloud/v1/&quot;</span>,
});

<span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
	<span class="hljs-attr">messages</span>: [
		{
			<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
			<span class="hljs-attr">content</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
		},
	],
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(response.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>.<span class="hljs-property">content</span>);`,wrap:!1}}),Al=new u({props:{code:"Y29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudCglMjJoZl94eHh4eHh4eHh4eHh4eCUyMiUyQyUyMCU3QiUwQSUwOWVuZHBvaW50VXJsJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZqM3o1bHV1MG9vbzc2am5sLnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGdjElMkYlMjIlMkMlMEElN0QpJTNCJTBBJTBBY29uc3QlMjByZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwaGYuY2hhdENvbXBsZXRpb24oJTBBJTA5JTdCJTBBJTA5JTA5bWVzc2FnZXMlM0ElMjAlNUIlMEElMDklMDklMDklN0IlMEElMDklMDklMDklMDlyb2xlJTNBJTIwJTIydXNlciUyMiUyQyUwQSUwOSUwOSUwOSUwOWNvbnRlbnQlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlMkMlMEElMDklMDklMDklN0QlMkMlMEElMDklMDklNUQlMkMlMEElMDklN0QlMkMlMEElMDklN0IlMEElMDklMDlyZXRyeV9vbl9lcnJvciUzQSUyMGZhbHNlJTJDJTBBJTA5JTdEJTBBKSUzQg==",highlighted:`<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>, {
	<span class="hljs-attr">endpointUrl</span>: <span class="hljs-string">&quot;https://j3z5luu0ooo76jnl.us-east-1.aws.endpoints.huggingface.cloud/v1/&quot;</span>,
});

<span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>(
	{
		<span class="hljs-attr">messages</span>: [
			{
				<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
				<span class="hljs-attr">content</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
			},
		],
	},
	{
		<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>,
	}
);`,wrap:!1}}),Yl=new m({props:{title:"Using local endpoints",local:"using-local-endpoints",headingTag:"h2"}}),Vl=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCclNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSclM0IlMEElMEFjb25zdCUyMGhmJTIwJTNEJTIwbmV3JTIwSW5mZXJlbmNlQ2xpZW50KHVuZGVmaW5lZCUyQyUyMCU3QiUwQSUwOWVuZHBvaW50VXJsJTNBJTIwJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTgwODAlMjIlMkMlMEElN0QpJTNCJTBBJTBBY29uc3QlMjByZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwaGYuY2hhdENvbXBsZXRpb24oJTdCJTBBJTA5bWVzc2FnZXMlM0ElMjAlNUIlMEElMDklMDklN0IlMEElMDklMDklMDlyb2xlJTNBJTIwJTIydXNlciUyMiUyQyUwQSUwOSUwOSUwOWNvbnRlbnQlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlMkMlMEElMDklMDklN0QlMkMlMEElMDklNUQlMkMlMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>;

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-literal">undefined</span>, {
	<span class="hljs-attr">endpointUrl</span>: <span class="hljs-string">&quot;http://localhost:8080&quot;</span>,
});

<span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
	<span class="hljs-attr">messages</span>: [
		{
			<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
			<span class="hljs-attr">content</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
		},
	],
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(response.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>.<span class="hljs-property">content</span>);`,wrap:!1}}),w=new Dn({props:{$$slots:{default:[Kn]},$$scope:{ctx:lt}}}),zl=new m({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Fl=new u({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Hl=new m({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Dl=new m({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),Kl=new Pn({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){J=h("meta"),T=a(),f=h("p"),Ol=a(),i(d.$$.fragment),tt=a(),g=h("p"),g.textContent=Ea,et=a(),U=h("ol"),U.innerHTML=Wa,at=a(),i($.$$.fragment),nt=a(),i(I.$$.fragment),it=a(),i(b.$$.fragment),pt=a(),i(C.$$.fragment),ot=a(),i(x.$$.fragment),rt=a(),i(B.$$.fragment),Mt=a(),i(Z.$$.fragment),ct=a(),i(k.$$.fragment),ht=a(),Q=h("p"),Q.innerHTML=Sa,jt=a(),v=h("p"),v.textContent=Xa,yt=a(),i(N.$$.fragment),mt=a(),G=h("p"),G.textContent=qa,ut=a(),E=h("p"),E.textContent=Aa,Jt=a(),W=h("ul"),W.innerHTML=Ya,ft=a(),S=h("p"),S.innerHTML=Ra,wt=a(),i(X.$$.fragment),Tt=a(),q=h("p"),q.innerHTML=Va,dt=a(),A=h("p"),A.textContent=za,gt=a(),Y=h("ul"),Y.innerHTML=Fa,Ut=a(),R=h("p"),R.innerHTML=Ha,$t=a(),V=h("p"),V.innerHTML=_a,It=a(),i(z.$$.fragment),bt=a(),F=h("p"),F.innerHTML=La,Ct=a(),i(H.$$.fragment),xt=a(),_=h("p"),_.textContent=Da,Bt=a(),i(L.$$.fragment),Zt=a(),i(D.$$.fragment),kt=a(),P=h("p"),P.textContent=Pa,Qt=a(),i(K.$$.fragment),vt=a(),i(O.$$.fragment),Nt=a(),ss=h("p"),ss.textContent=Ka,Gt=a(),i(ls.$$.fragment),Et=a(),i(ts.$$.fragment),Wt=a(),es=h("p"),es.textContent=Oa,St=a(),i(as.$$.fragment),Xt=a(),i(ns.$$.fragment),qt=a(),is=h("p"),is.textContent=sn,At=a(),i(ps.$$.fragment),Yt=a(),i(os.$$.fragment),Rt=a(),rs=h("p"),rs.textContent=ln,Vt=a(),i(Ms.$$.fragment),zt=a(),i(cs.$$.fragment),Ft=a(),hs=h("p"),hs.textContent=tn,Ht=a(),i(js.$$.fragment),_t=a(),i(ys.$$.fragment),Lt=a(),i(ms.$$.fragment),Dt=a(),i(us.$$.fragment),Pt=a(),Js=h("p"),Js.textContent=en,Kt=a(),i(fs.$$.fragment),Ot=a(),i(ws.$$.fragment),se=a(),Ts=h("p"),Ts.textContent=an,le=a(),i(ds.$$.fragment),te=a(),i(gs.$$.fragment),ee=a(),Us=h("p"),Us.textContent=nn,ae=a(),i($s.$$.fragment),ne=a(),i(Is.$$.fragment),ie=a(),bs=h("p"),bs.textContent=pn,pe=a(),i(Cs.$$.fragment),oe=a(),i(xs.$$.fragment),re=a(),Bs=h("p"),Bs.textContent=on,Me=a(),i(Zs.$$.fragment),ce=a(),i(ks.$$.fragment),he=a(),i(Qs.$$.fragment),je=a(),vs=h("p"),vs.textContent=rn,ye=a(),Ns=h("p"),Ns.innerHTML=Mn,me=a(),i(Gs.$$.fragment),ue=a(),i(Es.$$.fragment),Je=a(),Ws=h("p"),Ws.textContent=cn,fe=a(),Ss=h("p"),Ss.innerHTML=hn,we=a(),i(Xs.$$.fragment),Te=a(),i(qs.$$.fragment),de=a(),As=h("p"),As.textContent=jn,ge=a(),Ys=h("p"),Ys.innerHTML=yn,Ue=a(),i(Rs.$$.fragment),$e=a(),i(Vs.$$.fragment),Ie=a(),zs=h("p"),zs.textContent=mn,be=a(),i(Fs.$$.fragment),Ce=a(),i(Hs.$$.fragment),xe=a(),i(_s.$$.fragment),Be=a(),Ls=h("p"),Ls.textContent=un,Ze=a(),Ds=h("p"),Ds.innerHTML=Jn,ke=a(),i(Ps.$$.fragment),Qe=a(),i(Ks.$$.fragment),ve=a(),Os=h("p"),Os.textContent=fn,Ne=a(),sl=h("p"),sl.innerHTML=wn,Ge=a(),i(ll.$$.fragment),Ee=a(),i(tl.$$.fragment),We=a(),el=h("p"),el.textContent=Tn,Se=a(),i(al.$$.fragment),Xe=a(),i(nl.$$.fragment),qe=a(),il=h("p"),il.textContent=dn,Ae=a(),i(pl.$$.fragment),Ye=a(),i(ol.$$.fragment),Re=a(),rl=h("p"),rl.textContent=gn,Ve=a(),Ml=h("p"),Ml.innerHTML=Un,ze=a(),i(cl.$$.fragment),Fe=a(),i(hl.$$.fragment),He=a(),jl=h("p"),jl.textContent=$n,_e=a(),yl=h("p"),yl.innerHTML=In,Le=a(),i(ml.$$.fragment),De=a(),i(ul.$$.fragment),Pe=a(),Jl=h("p"),Jl.textContent=bn,Ke=a(),i(fl.$$.fragment),Oe=a(),i(wl.$$.fragment),sa=a(),i(Tl.$$.fragment),la=a(),dl=h("p"),dl.textContent=Cn,ta=a(),gl=h("p"),gl.innerHTML=xn,ea=a(),i(Ul.$$.fragment),aa=a(),i($l.$$.fragment),na=a(),Il=h("p"),Il.textContent=Bn,ia=a(),bl=h("p"),bl.innerHTML=Zn,pa=a(),i(Cl.$$.fragment),oa=a(),i(xl.$$.fragment),ra=a(),i(Bl.$$.fragment),Ma=a(),Zl=h("p"),Zl.textContent=kn,ca=a(),i(kl.$$.fragment),ha=a(),i(Ql.$$.fragment),ja=a(),vl=h("p"),vl.textContent=Qn,ya=a(),i(Nl.$$.fragment),ma=a(),Gl=h("p"),Gl.innerHTML=vn,ua=a(),i(El.$$.fragment),Ja=a(),i(Wl.$$.fragment),fa=a(),Sl=h("p"),Sl.innerHTML=Nn,wa=a(),i(Xl.$$.fragment),Ta=a(),ql=h("p"),ql.innerHTML=Gn,da=a(),i(Al.$$.fragment),ga=a(),i(Yl.$$.fragment),Ua=a(),Rl=h("p"),Rl.innerHTML=En,$a=a(),i(Vl.$$.fragment),Ia=a(),i(w.$$.fragment),ba=a(),i(zl.$$.fragment),Ca=a(),i(Fl.$$.fragment),xa=a(),i(Hl.$$.fragment),Ba=a(),_l=h("p"),_l.innerHTML=Wn,Za=a(),Ll=h("p"),Ll.textContent=Sn,ka=a(),i(Dl.$$.fragment),Qa=a(),Pl=h("ul"),Pl.innerHTML=Xn,va=a(),i(Kl.$$.fragment),Na=a(),st=h("p"),this.h()},l(s){const l=_n("svelte-u9bgzb",document.head);J=j(l,"META",{name:!0,content:!0}),l.forEach(t),T=n(s),f=j(s,"P",{}),An(f).forEach(t),Ol=n(s),p(d.$$.fragment,s),tt=n(s),g=j(s,"P",{"data-svelte-h":!0}),y(g)!=="svelte-o9dp75"&&(g.textContent=Ea),et=n(s),U=j(s,"OL",{"data-svelte-h":!0}),y(U)!=="svelte-113kt9p"&&(U.innerHTML=Wa),at=n(s),p($.$$.fragment,s),nt=n(s),p(I.$$.fragment,s),it=n(s),p(b.$$.fragment,s),pt=n(s),p(C.$$.fragment,s),ot=n(s),p(x.$$.fragment,s),rt=n(s),p(B.$$.fragment,s),Mt=n(s),p(Z.$$.fragment,s),ct=n(s),p(k.$$.fragment,s),ht=n(s),Q=j(s,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-h4fnsz"&&(Q.innerHTML=Sa),jt=n(s),v=j(s,"P",{"data-svelte-h":!0}),y(v)!=="svelte-2l8ybr"&&(v.textContent=Xa),yt=n(s),p(N.$$.fragment,s),mt=n(s),G=j(s,"P",{"data-svelte-h":!0}),y(G)!=="svelte-jymwke"&&(G.textContent=qa),ut=n(s),E=j(s,"P",{"data-svelte-h":!0}),y(E)!=="svelte-10x65ih"&&(E.textContent=Aa),Jt=n(s),W=j(s,"UL",{"data-svelte-h":!0}),y(W)!=="svelte-8494ll"&&(W.innerHTML=Ya),ft=n(s),S=j(s,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1wv2aqg"&&(S.innerHTML=Ra),wt=n(s),p(X.$$.fragment,s),Tt=n(s),q=j(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-qkqyx6"&&(q.innerHTML=Va),dt=n(s),A=j(s,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1q5o8lp"&&(A.textContent=za),gt=n(s),Y=j(s,"UL",{"data-svelte-h":!0}),y(Y)!=="svelte-hqxpry"&&(Y.innerHTML=Fa),Ut=n(s),R=j(s,"P",{"data-svelte-h":!0}),y(R)!=="svelte-w24fai"&&(R.innerHTML=Ha),$t=n(s),V=j(s,"P",{"data-svelte-h":!0}),y(V)!=="svelte-anhj2e"&&(V.innerHTML=_a),It=n(s),p(z.$$.fragment,s),bt=n(s),F=j(s,"P",{"data-svelte-h":!0}),y(F)!=="svelte-9hw06n"&&(F.innerHTML=La),Ct=n(s),p(H.$$.fragment,s),xt=n(s),_=j(s,"P",{"data-svelte-h":!0}),y(_)!=="svelte-88xj6h"&&(_.textContent=Da),Bt=n(s),p(L.$$.fragment,s),Zt=n(s),p(D.$$.fragment,s),kt=n(s),P=j(s,"P",{"data-svelte-h":!0}),y(P)!=="svelte-18cimv4"&&(P.textContent=Pa),Qt=n(s),p(K.$$.fragment,s),vt=n(s),p(O.$$.fragment,s),Nt=n(s),ss=j(s,"P",{"data-svelte-h":!0}),y(ss)!=="svelte-m9kc1"&&(ss.textContent=Ka),Gt=n(s),p(ls.$$.fragment,s),Et=n(s),p(ts.$$.fragment,s),Wt=n(s),es=j(s,"P",{"data-svelte-h":!0}),y(es)!=="svelte-174b8m1"&&(es.textContent=Oa),St=n(s),p(as.$$.fragment,s),Xt=n(s),p(ns.$$.fragment,s),qt=n(s),is=j(s,"P",{"data-svelte-h":!0}),y(is)!=="svelte-1mnrr3b"&&(is.textContent=sn),At=n(s),p(ps.$$.fragment,s),Yt=n(s),p(os.$$.fragment,s),Rt=n(s),rs=j(s,"P",{"data-svelte-h":!0}),y(rs)!=="svelte-4s1xv3"&&(rs.textContent=ln),Vt=n(s),p(Ms.$$.fragment,s),zt=n(s),p(cs.$$.fragment,s),Ft=n(s),hs=j(s,"P",{"data-svelte-h":!0}),y(hs)!=="svelte-vnhv92"&&(hs.textContent=tn),Ht=n(s),p(js.$$.fragment,s),_t=n(s),p(ys.$$.fragment,s),Lt=n(s),p(ms.$$.fragment,s),Dt=n(s),p(us.$$.fragment,s),Pt=n(s),Js=j(s,"P",{"data-svelte-h":!0}),y(Js)!=="svelte-vlz10z"&&(Js.textContent=en),Kt=n(s),p(fs.$$.fragment,s),Ot=n(s),p(ws.$$.fragment,s),se=n(s),Ts=j(s,"P",{"data-svelte-h":!0}),y(Ts)!=="svelte-qln4hq"&&(Ts.textContent=an),le=n(s),p(ds.$$.fragment,s),te=n(s),p(gs.$$.fragment,s),ee=n(s),Us=j(s,"P",{"data-svelte-h":!0}),y(Us)!=="svelte-yinzpl"&&(Us.textContent=nn),ae=n(s),p($s.$$.fragment,s),ne=n(s),p(Is.$$.fragment,s),ie=n(s),bs=j(s,"P",{"data-svelte-h":!0}),y(bs)!=="svelte-mqluby"&&(bs.textContent=pn),pe=n(s),p(Cs.$$.fragment,s),oe=n(s),p(xs.$$.fragment,s),re=n(s),Bs=j(s,"P",{"data-svelte-h":!0}),y(Bs)!=="svelte-tf7teq"&&(Bs.textContent=on),Me=n(s),p(Zs.$$.fragment,s),ce=n(s),p(ks.$$.fragment,s),he=n(s),p(Qs.$$.fragment,s),je=n(s),vs=j(s,"P",{"data-svelte-h":!0}),y(vs)!=="svelte-1in7idl"&&(vs.textContent=rn),ye=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),y(Ns)!=="svelte-18afluh"&&(Ns.innerHTML=Mn),me=n(s),p(Gs.$$.fragment,s),ue=n(s),p(Es.$$.fragment,s),Je=n(s),Ws=j(s,"P",{"data-svelte-h":!0}),y(Ws)!=="svelte-12s1din"&&(Ws.textContent=cn),fe=n(s),Ss=j(s,"P",{"data-svelte-h":!0}),y(Ss)!=="svelte-1jpdfy8"&&(Ss.innerHTML=hn),we=n(s),p(Xs.$$.fragment,s),Te=n(s),p(qs.$$.fragment,s),de=n(s),As=j(s,"P",{"data-svelte-h":!0}),y(As)!=="svelte-1h8ubig"&&(As.textContent=jn),ge=n(s),Ys=j(s,"P",{"data-svelte-h":!0}),y(Ys)!=="svelte-1edrfzt"&&(Ys.innerHTML=yn),Ue=n(s),p(Rs.$$.fragment,s),$e=n(s),p(Vs.$$.fragment,s),Ie=n(s),zs=j(s,"P",{"data-svelte-h":!0}),y(zs)!=="svelte-zj5o06"&&(zs.textContent=mn),be=n(s),p(Fs.$$.fragment,s),Ce=n(s),p(Hs.$$.fragment,s),xe=n(s),p(_s.$$.fragment,s),Be=n(s),Ls=j(s,"P",{"data-svelte-h":!0}),y(Ls)!=="svelte-1nlp89w"&&(Ls.textContent=un),Ze=n(s),Ds=j(s,"P",{"data-svelte-h":!0}),y(Ds)!=="svelte-10vvvxx"&&(Ds.innerHTML=Jn),ke=n(s),p(Ps.$$.fragment,s),Qe=n(s),p(Ks.$$.fragment,s),ve=n(s),Os=j(s,"P",{"data-svelte-h":!0}),y(Os)!=="svelte-d15mev"&&(Os.textContent=fn),Ne=n(s),sl=j(s,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-pxrbuw"&&(sl.innerHTML=wn),Ge=n(s),p(ll.$$.fragment,s),Ee=n(s),p(tl.$$.fragment,s),We=n(s),el=j(s,"P",{"data-svelte-h":!0}),y(el)!=="svelte-1oenl8f"&&(el.textContent=Tn),Se=n(s),p(al.$$.fragment,s),Xe=n(s),p(nl.$$.fragment,s),qe=n(s),il=j(s,"P",{"data-svelte-h":!0}),y(il)!=="svelte-66badz"&&(il.textContent=dn),Ae=n(s),p(pl.$$.fragment,s),Ye=n(s),p(ol.$$.fragment,s),Re=n(s),rl=j(s,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-13iv3hh"&&(rl.textContent=gn),Ve=n(s),Ml=j(s,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-1mgyz4r"&&(Ml.innerHTML=Un),ze=n(s),p(cl.$$.fragment,s),Fe=n(s),p(hl.$$.fragment,s),He=n(s),jl=j(s,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-1y7kqaa"&&(jl.textContent=$n),_e=n(s),yl=j(s,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-m8xmew"&&(yl.innerHTML=In),Le=n(s),p(ml.$$.fragment,s),De=n(s),p(ul.$$.fragment,s),Pe=n(s),Jl=j(s,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-m7q2yg"&&(Jl.textContent=bn),Ke=n(s),p(fl.$$.fragment,s),Oe=n(s),p(wl.$$.fragment,s),sa=n(s),p(Tl.$$.fragment,s),la=n(s),dl=j(s,"P",{"data-svelte-h":!0}),y(dl)!=="svelte-cnruui"&&(dl.textContent=Cn),ta=n(s),gl=j(s,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-hwgezm"&&(gl.innerHTML=xn),ea=n(s),p(Ul.$$.fragment,s),aa=n(s),p($l.$$.fragment,s),na=n(s),Il=j(s,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-1tpexz3"&&(Il.textContent=Bn),ia=n(s),bl=j(s,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-hwgezm"&&(bl.innerHTML=Zn),pa=n(s),p(Cl.$$.fragment,s),oa=n(s),p(xl.$$.fragment,s),ra=n(s),p(Bl.$$.fragment,s),Ma=n(s),Zl=j(s,"P",{"data-svelte-h":!0}),y(Zl)!=="svelte-1js246c"&&(Zl.textContent=kn),ca=n(s),p(kl.$$.fragment,s),ha=n(s),p(Ql.$$.fragment,s),ja=n(s),vl=j(s,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-7l7zu1"&&(vl.textContent=Qn),ya=n(s),p(Nl.$$.fragment,s),ma=n(s),Gl=j(s,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-cw0lq3"&&(Gl.innerHTML=vn),ua=n(s),p(El.$$.fragment,s),Ja=n(s),p(Wl.$$.fragment,s),fa=n(s),Sl=j(s,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-ffw62v"&&(Sl.innerHTML=Nn),wa=n(s),p(Xl.$$.fragment,s),Ta=n(s),ql=j(s,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-1uo8u1x"&&(ql.innerHTML=Gn),da=n(s),p(Al.$$.fragment,s),ga=n(s),p(Yl.$$.fragment,s),Ua=n(s),Rl=j(s,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-x73hle"&&(Rl.innerHTML=En),$a=n(s),p(Vl.$$.fragment,s),Ia=n(s),p(w.$$.fragment,s),ba=n(s),p(zl.$$.fragment,s),Ca=n(s),p(Fl.$$.fragment,s),xa=n(s),p(Hl.$$.fragment,s),Ba=n(s),_l=j(s,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-62a9et"&&(_l.innerHTML=Wn),Za=n(s),Ll=j(s,"P",{"data-svelte-h":!0}),y(Ll)!=="svelte-1yyf4wc"&&(Ll.textContent=Sn),ka=n(s),p(Dl.$$.fragment,s),Qa=n(s),Pl=j(s,"UL",{"data-svelte-h":!0}),y(Pl)!=="svelte-mopwlb"&&(Pl.innerHTML=Xn),va=n(s),p(Kl.$$.fragment,s),Na=n(s),st=j(s,"P",{}),An(st).forEach(t),this.h()},h(){Yn(J,"name","hf:doc:metadata"),Yn(J,"content",si)},m(s,l){Ln(document.head,J),e(s,T,l),e(s,f,l),e(s,Ol,l),o(d,s,l),e(s,tt,l),e(s,g,l),e(s,et,l),e(s,U,l),e(s,at,l),o($,s,l),e(s,nt,l),o(I,s,l),e(s,it,l),o(b,s,l),e(s,pt,l),o(C,s,l),e(s,ot,l),o(x,s,l),e(s,rt,l),o(B,s,l),e(s,Mt,l),o(Z,s,l),e(s,ct,l),o(k,s,l),e(s,ht,l),e(s,Q,l),e(s,jt,l),e(s,v,l),e(s,yt,l),o(N,s,l),e(s,mt,l),e(s,G,l),e(s,ut,l),e(s,E,l),e(s,Jt,l),e(s,W,l),e(s,ft,l),e(s,S,l),e(s,wt,l),o(X,s,l),e(s,Tt,l),e(s,q,l),e(s,dt,l),e(s,A,l),e(s,gt,l),e(s,Y,l),e(s,Ut,l),e(s,R,l),e(s,$t,l),e(s,V,l),e(s,It,l),o(z,s,l),e(s,bt,l),e(s,F,l),e(s,Ct,l),o(H,s,l),e(s,xt,l),e(s,_,l),e(s,Bt,l),o(L,s,l),e(s,Zt,l),o(D,s,l),e(s,kt,l),e(s,P,l),e(s,Qt,l),o(K,s,l),e(s,vt,l),o(O,s,l),e(s,Nt,l),e(s,ss,l),e(s,Gt,l),o(ls,s,l),e(s,Et,l),o(ts,s,l),e(s,Wt,l),e(s,es,l),e(s,St,l),o(as,s,l),e(s,Xt,l),o(ns,s,l),e(s,qt,l),e(s,is,l),e(s,At,l),o(ps,s,l),e(s,Yt,l),o(os,s,l),e(s,Rt,l),e(s,rs,l),e(s,Vt,l),o(Ms,s,l),e(s,zt,l),o(cs,s,l),e(s,Ft,l),e(s,hs,l),e(s,Ht,l),o(js,s,l),e(s,_t,l),o(ys,s,l),e(s,Lt,l),o(ms,s,l),e(s,Dt,l),o(us,s,l),e(s,Pt,l),e(s,Js,l),e(s,Kt,l),o(fs,s,l),e(s,Ot,l),o(ws,s,l),e(s,se,l),e(s,Ts,l),e(s,le,l),o(ds,s,l),e(s,te,l),o(gs,s,l),e(s,ee,l),e(s,Us,l),e(s,ae,l),o($s,s,l),e(s,ne,l),o(Is,s,l),e(s,ie,l),e(s,bs,l),e(s,pe,l),o(Cs,s,l),e(s,oe,l),o(xs,s,l),e(s,re,l),e(s,Bs,l),e(s,Me,l),o(Zs,s,l),e(s,ce,l),o(ks,s,l),e(s,he,l),o(Qs,s,l),e(s,je,l),e(s,vs,l),e(s,ye,l),e(s,Ns,l),e(s,me,l),o(Gs,s,l),e(s,ue,l),o(Es,s,l),e(s,Je,l),e(s,Ws,l),e(s,fe,l),e(s,Ss,l),e(s,we,l),o(Xs,s,l),e(s,Te,l),o(qs,s,l),e(s,de,l),e(s,As,l),e(s,ge,l),e(s,Ys,l),e(s,Ue,l),o(Rs,s,l),e(s,$e,l),o(Vs,s,l),e(s,Ie,l),e(s,zs,l),e(s,be,l),o(Fs,s,l),e(s,Ce,l),o(Hs,s,l),e(s,xe,l),o(_s,s,l),e(s,Be,l),e(s,Ls,l),e(s,Ze,l),e(s,Ds,l),e(s,ke,l),o(Ps,s,l),e(s,Qe,l),o(Ks,s,l),e(s,ve,l),e(s,Os,l),e(s,Ne,l),e(s,sl,l),e(s,Ge,l),o(ll,s,l),e(s,Ee,l),o(tl,s,l),e(s,We,l),e(s,el,l),e(s,Se,l),o(al,s,l),e(s,Xe,l),o(nl,s,l),e(s,qe,l),e(s,il,l),e(s,Ae,l),o(pl,s,l),e(s,Ye,l),o(ol,s,l),e(s,Re,l),e(s,rl,l),e(s,Ve,l),e(s,Ml,l),e(s,ze,l),o(cl,s,l),e(s,Fe,l),o(hl,s,l),e(s,He,l),e(s,jl,l),e(s,_e,l),e(s,yl,l),e(s,Le,l),o(ml,s,l),e(s,De,l),o(ul,s,l),e(s,Pe,l),e(s,Jl,l),e(s,Ke,l),o(fl,s,l),e(s,Oe,l),o(wl,s,l),e(s,sa,l),o(Tl,s,l),e(s,la,l),e(s,dl,l),e(s,ta,l),e(s,gl,l),e(s,ea,l),o(Ul,s,l),e(s,aa,l),o($l,s,l),e(s,na,l),e(s,Il,l),e(s,ia,l),e(s,bl,l),e(s,pa,l),o(Cl,s,l),e(s,oa,l),o(xl,s,l),e(s,ra,l),o(Bl,s,l),e(s,Ma,l),e(s,Zl,l),e(s,ca,l),o(kl,s,l),e(s,ha,l),o(Ql,s,l),e(s,ja,l),e(s,vl,l),e(s,ya,l),o(Nl,s,l),e(s,ma,l),e(s,Gl,l),e(s,ua,l),o(El,s,l),e(s,Ja,l),o(Wl,s,l),e(s,fa,l),e(s,Sl,l),e(s,wa,l),o(Xl,s,l),e(s,Ta,l),e(s,ql,l),e(s,da,l),o(Al,s,l),e(s,ga,l),o(Yl,s,l),e(s,Ua,l),e(s,Rl,l),e(s,$a,l),o(Vl,s,l),e(s,Ia,l),o(w,s,l),e(s,ba,l),o(zl,s,l),e(s,Ca,l),o(Fl,s,l),e(s,xa,l),o(Hl,s,l),e(s,Ba,l),e(s,_l,l),e(s,Za,l),e(s,Ll,l),e(s,ka,l),o(Dl,s,l),e(s,Qa,l),e(s,Pl,l),e(s,va,l),o(Kl,s,l),e(s,Na,l),e(s,st,l),Ga=!0},p(s,[l]){const qn={};l&2&&(qn.$$scope={dirty:l,ctx:s}),w.$set(qn)},i(s){Ga||(r(d.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(x.$$.fragment,s),r(B.$$.fragment,s),r(Z.$$.fragment,s),r(k.$$.fragment,s),r(N.$$.fragment,s),r(X.$$.fragment,s),r(z.$$.fragment,s),r(H.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(K.$$.fragment,s),r(O.$$.fragment,s),r(ls.$$.fragment,s),r(ts.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(Ms.$$.fragment,s),r(cs.$$.fragment,s),r(js.$$.fragment,s),r(ys.$$.fragment,s),r(ms.$$.fragment,s),r(us.$$.fragment,s),r(fs.$$.fragment,s),r(ws.$$.fragment,s),r(ds.$$.fragment,s),r(gs.$$.fragment,s),r($s.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Gs.$$.fragment,s),r(Es.$$.fragment,s),r(Xs.$$.fragment,s),r(qs.$$.fragment,s),r(Rs.$$.fragment,s),r(Vs.$$.fragment,s),r(Fs.$$.fragment,s),r(Hs.$$.fragment,s),r(_s.$$.fragment,s),r(Ps.$$.fragment,s),r(Ks.$$.fragment,s),r(ll.$$.fragment,s),r(tl.$$.fragment,s),r(al.$$.fragment,s),r(nl.$$.fragment,s),r(pl.$$.fragment,s),r(ol.$$.fragment,s),r(cl.$$.fragment,s),r(hl.$$.fragment,s),r(ml.$$.fragment,s),r(ul.$$.fragment,s),r(fl.$$.fragment,s),r(wl.$$.fragment,s),r(Tl.$$.fragment,s),r(Ul.$$.fragment,s),r($l.$$.fragment,s),r(Cl.$$.fragment,s),r(xl.$$.fragment,s),r(Bl.$$.fragment,s),r(kl.$$.fragment,s),r(Ql.$$.fragment,s),r(Nl.$$.fragment,s),r(El.$$.fragment,s),r(Wl.$$.fragment,s),r(Xl.$$.fragment,s),r(Al.$$.fragment,s),r(Yl.$$.fragment,s),r(Vl.$$.fragment,s),r(w.$$.fragment,s),r(zl.$$.fragment,s),r(Fl.$$.fragment,s),r(Hl.$$.fragment,s),r(Dl.$$.fragment,s),r(Kl.$$.fragment,s),Ga=!0)},o(s){M(d.$$.fragment,s),M($.$$.fragment,s),M(I.$$.fragment,s),M(b.$$.fragment,s),M(C.$$.fragment,s),M(x.$$.fragment,s),M(B.$$.fragment,s),M(Z.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(X.$$.fragment,s),M(z.$$.fragment,s),M(H.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(O.$$.fragment,s),M(ls.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(os.$$.fragment,s),M(Ms.$$.fragment,s),M(cs.$$.fragment,s),M(js.$$.fragment,s),M(ys.$$.fragment,s),M(ms.$$.fragment,s),M(us.$$.fragment,s),M(fs.$$.fragment,s),M(ws.$$.fragment,s),M(ds.$$.fragment,s),M(gs.$$.fragment,s),M($s.$$.fragment,s),M(Is.$$.fragment,s),M(Cs.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M(ks.$$.fragment,s),M(Qs.$$.fragment,s),M(Gs.$$.fragment,s),M(Es.$$.fragment,s),M(Xs.$$.fragment,s),M(qs.$$.fragment,s),M(Rs.$$.fragment,s),M(Vs.$$.fragment,s),M(Fs.$$.fragment,s),M(Hs.$$.fragment,s),M(_s.$$.fragment,s),M(Ps.$$.fragment,s),M(Ks.$$.fragment,s),M(ll.$$.fragment,s),M(tl.$$.fragment,s),M(al.$$.fragment,s),M(nl.$$.fragment,s),M(pl.$$.fragment,s),M(ol.$$.fragment,s),M(cl.$$.fragment,s),M(hl.$$.fragment,s),M(ml.$$.fragment,s),M(ul.$$.fragment,s),M(fl.$$.fragment,s),M(wl.$$.fragment,s),M(Tl.$$.fragment,s),M(Ul.$$.fragment,s),M($l.$$.fragment,s),M(Cl.$$.fragment,s),M(xl.$$.fragment,s),M(Bl.$$.fragment,s),M(kl.$$.fragment,s),M(Ql.$$.fragment,s),M(Nl.$$.fragment,s),M(El.$$.fragment,s),M(Wl.$$.fragment,s),M(Xl.$$.fragment,s),M(Al.$$.fragment,s),M(Yl.$$.fragment,s),M(Vl.$$.fragment,s),M(w.$$.fragment,s),M(zl.$$.fragment,s),M(Fl.$$.fragment,s),M(Hl.$$.fragment,s),M(Dl.$$.fragment,s),M(Kl.$$.fragment,s),Ga=!1},d(s){s&&(t(T),t(f),t(Ol),t(tt),t(g),t(et),t(U),t(at),t(nt),t(it),t(pt),t(ot),t(rt),t(Mt),t(ct),t(ht),t(Q),t(jt),t(v),t(yt),t(mt),t(G),t(ut),t(E),t(Jt),t(W),t(ft),t(S),t(wt),t(Tt),t(q),t(dt),t(A),t(gt),t(Y),t(Ut),t(R),t($t),t(V),t(It),t(bt),t(F),t(Ct),t(xt),t(_),t(Bt),t(Zt),t(kt),t(P),t(Qt),t(vt),t(Nt),t(ss),t(Gt),t(Et),t(Wt),t(es),t(St),t(Xt),t(qt),t(is),t(At),t(Yt),t(Rt),t(rs),t(Vt),t(zt),t(Ft),t(hs),t(Ht),t(_t),t(Lt),t(Dt),t(Pt),t(Js),t(Kt),t(Ot),t(se),t(Ts),t(le),t(te),t(ee),t(Us),t(ae),t(ne),t(ie),t(bs),t(pe),t(oe),t(re),t(Bs),t(Me),t(ce),t(he),t(je),t(vs),t(ye),t(Ns),t(me),t(ue),t(Je),t(Ws),t(fe),t(Ss),t(we),t(Te),t(de),t(As),t(ge),t(Ys),t(Ue),t($e),t(Ie),t(zs),t(be),t(Ce),t(xe),t(Be),t(Ls),t(Ze),t(Ds),t(ke),t(Qe),t(ve),t(Os),t(Ne),t(sl),t(Ge),t(Ee),t(We),t(el),t(Se),t(Xe),t(qe),t(il),t(Ae),t(Ye),t(Re),t(rl),t(Ve),t(Ml),t(ze),t(Fe),t(He),t(jl),t(_e),t(yl),t(Le),t(De),t(Pe),t(Jl),t(Ke),t(Oe),t(sa),t(la),t(dl),t(ta),t(gl),t(ea),t(aa),t(na),t(Il),t(ia),t(bl),t(pa),t(oa),t(ra),t(Ma),t(Zl),t(ca),t(ha),t(ja),t(vl),t(ya),t(ma),t(Gl),t(ua),t(Ja),t(fa),t(Sl),t(wa),t(Ta),t(ql),t(da),t(ga),t(Ua),t(Rl),t($a),t(Ia),t(ba),t(Ca),t(xa),t(Ba),t(_l),t(Za),t(Ll),t(ka),t(Qa),t(Pl),t(va),t(Na),t(st)),t(J),c(d,s),c($,s),c(I,s),c(b,s),c(C,s),c(x,s),c(B,s),c(Z,s),c(k,s),c(N,s),c(X,s),c(z,s),c(H,s),c(L,s),c(D,s),c(K,s),c(O,s),c(ls,s),c(ts,s),c(as,s),c(ns,s),c(ps,s),c(os,s),c(Ms,s),c(cs,s),c(js,s),c(ys,s),c(ms,s),c(us,s),c(fs,s),c(ws,s),c(ds,s),c(gs,s),c($s,s),c(Is,s),c(Cs,s),c(xs,s),c(Zs,s),c(ks,s),c(Qs,s),c(Gs,s),c(Es,s),c(Xs,s),c(qs,s),c(Rs,s),c(Vs,s),c(Fs,s),c(Hs,s),c(_s,s),c(Ps,s),c(Ks,s),c(ll,s),c(tl,s),c(al,s),c(nl,s),c(pl,s),c(ol,s),c(cl,s),c(hl,s),c(ml,s),c(ul,s),c(fl,s),c(wl,s),c(Tl,s),c(Ul,s),c($l,s),c(Cl,s),c(xl,s),c(Bl,s),c(kl,s),c(Ql,s),c(Nl,s),c(El,s),c(Wl,s),c(Xl,s),c(Al,s),c(Yl,s),c(Vl,s),c(w,s),c(zl,s),c(Fl,s),c(Hl,s),c(Dl,s),c(Kl,s)}}}const si='{"title":"🤗 Hugging Face Inference","local":"-hugging-face-inference","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[],"depth":3}],"depth":2},{"title":"Using Inference Providers","local":"using-inference-providers","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":3},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Text Generation","local":"text-generation","sections":[],"depth":4},{"title":"Chat Completion","local":"chat-completion","sections":[],"depth":4},{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":4},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":4},{"title":"Summarization","local":"summarization","sections":[],"depth":4},{"title":"Question Answering","local":"question-answering","sections":[],"depth":4},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":4},{"title":"Text Classification","local":"text-classification","sections":[],"depth":4},{"title":"Token Classification","local":"token-classification","sections":[],"depth":4},{"title":"Translation","local":"translation","sections":[],"depth":4},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":4},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":4}],"depth":3},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":4},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":4},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":4},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":4}],"depth":3},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":4},{"title":"Object Detection","local":"object-detection","sections":[],"depth":4},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":4},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":4},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":4},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":4},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":4}],"depth":3},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":4},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":4}],"depth":3},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":4},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Using Inference Endpoints","local":"using-inference-endpoints","sections":[],"depth":2},{"title":"Using local endpoints","local":"using-local-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function li(lt){return Vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pi extends Fn{constructor(J){super(),Hn(this,J,li,On,Rn,{})}}export{pi as component};
