import{s as Fe,n as Ze,o as Re}from"../chunks/scheduler.c59d9fbb.js";import{S as ve,i as Ge,g as i,s,r as c,A as Qe,h as r,f as a,c as n,j as We,u as p,x as o,k as $e,y as Ye,a as l,v as d,d as m,t as f,w as M}from"../chunks/index.a47918e3.js";import{C as Me}from"../chunks/CodeBlock.936db8cd.js";import{H as X,E as xe}from"../chunks/EditOnGithub.813e7c73.js";function Be(be){let b,H,B,E,h,A,y,he="SetFit models can be influenced by callbacks, for example for logging or early stopping.",N,u,ye="This guide will show you what they are and how they can be used.",q,g,z,T,ue='Callbacks are objects that customize the behaviour of the training loop in the SetFit <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer">Trainer</a> that can inspect the training loop state (for progress reporting, logging, inspecting embeddings during training) and take decisions (e.g. early stopping).',L,w,ge='In particular, the <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer">Trainer</a> uses a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerControl" rel="nofollow"><code>TrainerControl</code></a> that can be influenced by callbacks to stop training, save models, evaluate, or log, and a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerState" rel="nofollow"><code>TrainerState</code></a> which tracks some training loop metrics during training, such as the number of training steps so far.',V,J,Te='SetFit relies on the Callbacks implemented in <code>transformers</code>, as described in the <code>transformers</code> documentation <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">here</a>.',P,U,K,C,we='SetFit uses the <code>TrainingArguments.report_to</code> argument to specify which of the built-in callbacks should be enabled. This argument defaults to <code>&quot;all&quot;</code>, meaning that all third-party callbacks from <code>transformers</code> that are also installed will be enabled. For example the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow"><code>TensorBoardCallback</code></a> or the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.WandbCallback" rel="nofollow"><code>WandbCallback</code></a>.',D,j,Je='Beyond that, the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.PrinterCallback" rel="nofollow"><code>PrinterCallback</code></a> or <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.ProgressCallback" rel="nofollow"><code>ProgressCallback</code></a> is always enabled to show the training progress, and <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.DefaultFlowCallback" rel="nofollow"><code>DefaultFlowCallback</code></a> is also always enabled to properly update the <code>TrainerControl</code>.',O,k,ee,_,Ue="As mentioned, you can use <code>TrainingArguments.report_to</code> to specify exactly which callbacks you would like to enable. For example:",te,I,ae,W,Ce='You can also use <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer.add_callback">Trainer.add_callback()</a>, <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer.pop_callback">Trainer.pop_callback()</a> and <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer.remove_callback">Trainer.remove_callback()</a> to influence the trainer callbacks, and you can specify callbacks via the <a href="/docs/setfit/pr_550/en/reference/trainer#setfit.Trainer">Trainer</a> init, e.g.:',le,$,se,F,ne,Z,je='SetFit supports custom callbacks in the same way that <code>transformers</code> does: by subclassing <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerCallback" rel="nofollow"><code>TrainerCallback</code></a>. This class implements a lot of <code>on_...</code> methods that can be overridden. For example, the following script shows a custom callback that saves plots of the tSNE of the training and evaluation embeddings during training.',ie,R,re,v,ke="with",oe,G,ce,Q,_e="The <code>on_evaluate</code> from <code>EmbeddingPlotCallback</code> will be triggered on every single evaluation call. In the case of this example, it resulted in the following figures being plotted:",pe,Y,Ie='<thead><tr><th>Step 20</th> <th>Step 40</th></tr></thead> <tbody><tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/7200d00a-fd48-4038-bcbe-f2d5f1280162" alt="step_20"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/be12e3c4-867c-452d-89a0-0677f035516d" alt="step_40"/></td></tr> <tr><td><strong>Step 60</strong></td> <td><strong>Step 80</strong></td></tr> <tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/3a384aa2-51ce-40d7-b02c-a2c986f3aeb4" alt="step_60"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/b5aa9835-40cb-4327-9f31-b3ababeca769" alt="step_80"/></td></tr></tbody>',de,x,me,S,fe;return h=new X({props:{title:"Callbacks",local:"callbacks",headingTag:"h1"}}),g=new X({props:{title:"Callbacks in SetFit",local:"callbacks-in-setfit",headingTag:"h2"}}),U=new X({props:{title:"Default Callbacks",local:"default-callbacks",headingTag:"h2"}}),k=new X({props:{title:"Using Callbacks",local:"using-callbacks",headingTag:"h2"}}),I=new Me({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMndhbmRiJTIyJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBKSUwQSUyMyUyMG9yJTIwJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCU1QiUyMndhbmRiJTIyJTJDJTIwJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAuLi4lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

args = TrainingArguments(
    ...,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    ...,
)
<span class="hljs-comment"># or </span>
args = TrainingArguments(
    ...,
    report_to=[<span class="hljs-string">&quot;wandb&quot;</span>, <span class="hljs-string">&quot;tensorboard&quot;</span>],
    ...,
)`,wrap:!1}}),$=new Me({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

...

trainer = Trainer(
    model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EarlyStoppingCallback(early_stopping_patience=<span class="hljs-number">5</span>)],
)
trainer.train()`,wrap:!1}}),F=new X({props:{title:"Custom Callbacks",local:"custom-callbacks",headingTag:"h2"}}),R=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> sklearn.manifold <span class="hljs-keyword">import</span> TSNE

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmbeddingPlotCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simple embedding plotting callback that plots the tSNE of the training and evaluation datasets throughout training.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_evaluate</span>(<span class="hljs-params">self, args: TrainingArguments, state: TrainerState, control: TrainerControl, model: SetFitModel, **kwargs</span>):
        train_embeddings = model.encode(train_dataset[<span class="hljs-string">&quot;text&quot;</span>])
        eval_embeddings = model.encode(eval_dataset[<span class="hljs-string">&quot;text&quot;</span>])

        fig, (train_ax, eval_ax) = plt.subplots(ncols=<span class="hljs-number">2</span>)

        train_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(train_embeddings)
        train_ax.scatter(*train_X.T, c=train_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=train_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        train_ax.set_title(<span class="hljs-string">&quot;Training embeddings&quot;</span>)

        eval_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(eval_embeddings)
        eval_ax.scatter(*eval_X.T, c=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        eval_ax.set_title(<span class="hljs-string">&quot;Evaluation embeddings&quot;</span>)

        fig.suptitle(<span class="hljs-string">f&quot;tSNE of training and evaluation embeddings at step <span class="hljs-subst">{state.global_step}</span> of <span class="hljs-subst">{state.max_steps}</span>.&quot;</span>)
        fig.savefig(<span class="hljs-string">f&quot;logs/step_<span class="hljs-subst">{state.global_step}</span>.png&quot;</span>)`,wrap:!1}}),G=new Me({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0QlNUJFbWJlZGRpbmdQbG90Q2FsbGJhY2soKSU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EmbeddingPlotCallback()]
)
trainer.train()`,wrap:!1}}),x=new xe({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/how_to/callbacks.mdx"}}),{c(){b=i("meta"),H=s(),B=i("p"),E=s(),c(h.$$.fragment),A=s(),y=i("p"),y.textContent=he,N=s(),u=i("p"),u.textContent=ye,q=s(),c(g.$$.fragment),z=s(),T=i("p"),T.innerHTML=ue,L=s(),w=i("p"),w.innerHTML=ge,V=s(),J=i("p"),J.innerHTML=Te,P=s(),c(U.$$.fragment),K=s(),C=i("p"),C.innerHTML=we,D=s(),j=i("p"),j.innerHTML=Je,O=s(),c(k.$$.fragment),ee=s(),_=i("p"),_.innerHTML=Ue,te=s(),c(I.$$.fragment),ae=s(),W=i("p"),W.innerHTML=Ce,le=s(),c($.$$.fragment),se=s(),c(F.$$.fragment),ne=s(),Z=i("p"),Z.innerHTML=je,ie=s(),c(R.$$.fragment),re=s(),v=i("p"),v.textContent=ke,oe=s(),c(G.$$.fragment),ce=s(),Q=i("p"),Q.innerHTML=_e,pe=s(),Y=i("table"),Y.innerHTML=Ie,de=s(),c(x.$$.fragment),me=s(),S=i("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);b=r(t,"META",{name:!0,content:!0}),t.forEach(a),H=n(e),B=r(e,"P",{}),We(B).forEach(a),E=n(e),p(h.$$.fragment,e),A=n(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1qsyej"&&(y.textContent=he),N=n(e),u=r(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1neobwt"&&(u.textContent=ye),q=n(e),p(g.$$.fragment,e),z=n(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-igqqxf"&&(T.innerHTML=ue),L=n(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-13kz2wi"&&(w.innerHTML=ge),V=n(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-m6jr23"&&(J.innerHTML=Te),P=n(e),p(U.$$.fragment,e),K=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1d5its4"&&(C.innerHTML=we),D=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-195z5eh"&&(j.innerHTML=Je),O=n(e),p(k.$$.fragment,e),ee=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-9jofl1"&&(_.innerHTML=Ue),te=n(e),p(I.$$.fragment,e),ae=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-g8p4kh"&&(W.innerHTML=Ce),le=n(e),p($.$$.fragment,e),se=n(e),p(F.$$.fragment,e),ne=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1a0isl"&&(Z.innerHTML=je),ie=n(e),p(R.$$.fragment,e),re=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1jtaf10"&&(v.textContent=ke),oe=n(e),p(G.$$.fragment,e),ce=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-14nrepa"&&(Q.innerHTML=_e),pe=n(e),Y=r(e,"TABLE",{"data-svelte-h":!0}),o(Y)!=="svelte-g475cj"&&(Y.innerHTML=Ie),de=n(e),p(x.$$.fragment,e),me=n(e),S=r(e,"P",{}),We(S).forEach(a),this.h()},h(){$e(b,"name","hf:doc:metadata"),$e(b,"content",Se)},m(e,t){Ye(document.head,b),l(e,H,t),l(e,B,t),l(e,E,t),d(h,e,t),l(e,A,t),l(e,y,t),l(e,N,t),l(e,u,t),l(e,q,t),d(g,e,t),l(e,z,t),l(e,T,t),l(e,L,t),l(e,w,t),l(e,V,t),l(e,J,t),l(e,P,t),d(U,e,t),l(e,K,t),l(e,C,t),l(e,D,t),l(e,j,t),l(e,O,t),d(k,e,t),l(e,ee,t),l(e,_,t),l(e,te,t),d(I,e,t),l(e,ae,t),l(e,W,t),l(e,le,t),d($,e,t),l(e,se,t),d(F,e,t),l(e,ne,t),l(e,Z,t),l(e,ie,t),d(R,e,t),l(e,re,t),l(e,v,t),l(e,oe,t),d(G,e,t),l(e,ce,t),l(e,Q,t),l(e,pe,t),l(e,Y,t),l(e,de,t),d(x,e,t),l(e,me,t),l(e,S,t),fe=!0},p:Ze,i(e){fe||(m(h.$$.fragment,e),m(g.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m(I.$$.fragment,e),m($.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),fe=!0)},o(e){f(h.$$.fragment,e),f(g.$$.fragment,e),f(U.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f($.$$.fragment,e),f(F.$$.fragment,e),f(R.$$.fragment,e),f(G.$$.fragment,e),f(x.$$.fragment,e),fe=!1},d(e){e&&(a(H),a(B),a(E),a(A),a(y),a(N),a(u),a(q),a(z),a(T),a(L),a(w),a(V),a(J),a(P),a(K),a(C),a(D),a(j),a(O),a(ee),a(_),a(te),a(ae),a(W),a(le),a(se),a(ne),a(Z),a(ie),a(re),a(v),a(oe),a(ce),a(Q),a(pe),a(Y),a(de),a(me),a(S)),a(b),M(h,e),M(g,e),M(U,e),M(k,e),M(I,e),M($,e),M(F,e),M(R,e),M(G,e),M(x,e)}}}const Se='{"title":"Callbacks","local":"callbacks","sections":[{"title":"Callbacks in SetFit","local":"callbacks-in-setfit","sections":[],"depth":2},{"title":"Default Callbacks","local":"default-callbacks","sections":[],"depth":2},{"title":"Using Callbacks","local":"using-callbacks","sections":[],"depth":2},{"title":"Custom Callbacks","local":"custom-callbacks","sections":[],"depth":2}],"depth":1}';function Xe(be){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends ve{constructor(b){super(),Ge(this,b,Xe,Be,Fe,{})}}export{qe as component};
