import{s as i1,n as d1,o as r1}from"../chunks/scheduler.0219f8bd.js";import{S as u1,i as a1,g as i,s,r as a,A as m1,h as d,f as l,c as n,j as h,u as m,x as r,k as u,y as p1,a as o,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as Ic}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as c1}from"../chunks/EditOnGithub.48fa589f.js";function f1(Kc){let $,_n,Tn,$n,v,vn,b,bn,y,Bc="Helper module for <code>Tensor</code> processing.",yn,M,Nc=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Mn,x,Vc='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',xn,Cn,Hn,C,Ln,H,wn,L,Qc='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',An,w,Sc='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',zn,gn,Pn,A,Rn,z,kn,g,Oc="Create a new Tensor or copy an existing Tensor.",En,P,Fc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Un,jn,Jn,R,Dn,k,qn,E,Yc="Dimensions of the tensor.",In,U,Wc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Kn,Bn,Nn,j,Vn,J,Qn,D,Gc="Type of the tensor.",Sn,q,Xc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',On,Fn,Yn,I,Wn,K,Gn,B,Zc="The data stored in the tensor.",Xn,N,ef='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Zn,ei,ti,V,li,Q,oi,S,tf="The number of elements in the tensor.",si,O,lf='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ni,ii,di,F,ri,Y,ui,W,of="The location of the tensor data.",ai,G,sf='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',mi,pi,ci,X,fi,Z,Ti,ee,nf=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,hi,te,df='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',_i,$i,vi,le,bi,oe,yi,se,rf="Index into a Tensor object.",Mi,ne,uf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',xi,ie,af="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Ci,Hi,Li,de,wi,re,Ai,ue,mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',zi,ae,pf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",gi,Pi,Ri,me,ki,pe,Ei,ce,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ui,fe,ff="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",ji,Ji,Di,Te,qi,he,Ii,_e,Tf=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Ki,$e,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Bi,ve,_f="<li><code>Error</code> If the tensor has more than one element.</li>",Ni,Vi,Qi,be,Si,ye,Oi,Me,$f="Convert tensor data to a n-dimensional JS list",Fi,xe,vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Yi,Wi,Gi,Ce,Xi,He,Zi,Le,bf="Return a new Tensor with the sigmoid function applied to each element.",ed,we,yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',td,ld,od,Ae,sd,ze,nd,ge,Mf="Applies the sigmoid function to the tensor in place.",id,Pe,xf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',dd,rd,ud,Re,ad,ke,md,Ee,Cf="Return a new Tensor with a callback function applied to each element.",pd,Ue,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new Tensor with the callback function applied to each element.',cd,je,Lf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,fd,Td,hd,Je,_d,De,$d,qe,wf="Apply a callback function to each element of the tensor in place.",vd,Ie,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',bd,Ke,zf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,yd,Md,xd,Be,Cd,Ne,Hd,Ve,gf="Return a new Tensor with every element multiplied by a constant.",Ld,Qe,Pf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',wd,Se,Rf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Ad,zd,gd,Oe,Pd,Fe,Rd,Ye,kf="Multiply the tensor by a constant in place.",kd,We,Ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Ed,Ge,Uf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Ud,jd,Jd,Xe,Dd,Ze,qd,et,jf="Return a new Tensor with every element divided by a constant.",Id,tt,Jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Kd,lt,Df="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Bd,Nd,Vd,ot,Qd,st,Sd,nt,qf="Divide the tensor by a constant in place.",Od,it,If='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Fd,dt,Kf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Yd,Wd,Gd,rt,Xd,ut,Zd,at,Bf="Return a new Tensor with every element added by a constant.",er,mt,Nf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',tr,pt,Vf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",lr,or,sr,ct,nr,ft,ir,Tt,Qf="Add the tensor by a constant in place.",dr,ht,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',rr,_t,Of="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",ur,ar,mr,$t,pr,vt,cr,bt,Ff="Return a new Tensor with every element subtracted by a constant.",fr,yt,Yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Tr,Mt,Wf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",hr,_r,$r,xt,vr,Ct,br,Ht,Gf="Subtract the tensor by a constant in place.",yr,Lt,Xf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Mr,wt,Zf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",xr,Cr,Hr,At,Lr,zt,wr,gt,eT="Return a permuted version of this Tensor, according to the provided dimensions.",Ar,Pt,tT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',zr,Rt,lT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",gr,Pr,Rr,kt,kr,Et,Er,Ut,oT="Returns the sum of each row of the input tensor in the given dimension dim.",Ur,jt,sT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',jr,Jt,nT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Jr,Dr,qr,Dt,Ir,qt,Kr,It,iT="Returns the matrix norm or vector norm of a given tensor.",Br,Kt,dT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Nr,Bt,rT=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Vr,Qr,Sr,Nt,Or,Vt,Fr,Qt,uT="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Yr,St,aT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Wr,Ot,mT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Gr,Xr,Zr,Ft,eu,Yt,tu,Wt,pT="Performs <code>L_p</code> normalization of inputs over specified dimension.",lu,Gt,cT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',ou,Xt,fT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",su,nu,iu,Zt,du,el,ru,tl,TT=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,uu,ll,hT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',au,mu,pu,ol,cu,sl,fu,nl,_T="Returns a tensor with all specified dimensions of input of size 1 removed.",Tu,il,$T=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,hu,dl,vT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The squeezed tensor',_u,rl,bT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",$u,vu,bu,ul,yu,al,Mu,ml,yT='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',xu,pl,MT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Cu,Hu,Lu,cl,wu,fl,Au,Tl,xT="Returns a new tensor with a dimension of size one inserted at the specified position.",zu,hl,CT="NOTE: The returned tensor shares the same underlying data with this tensor.",gu,_l,HT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The unsqueezed tensor',Pu,$l,LT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Ru,ku,Eu,vl,Uu,bl,ju,yl,wT='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Ju,Ml,AT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Du,qu,Iu,xl,Ku,Cl,Bu,Hl,zT='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Nu,Ll,gT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vu,Qu,Su,wl,Ou,Al,Fu,zl,PT=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Yu,gl,RT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The flattened tensor.',Wu,Pl,kT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Gu,Xu,Zu,Rl,ea,kl,ta,El,ET="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",la,Ul,UT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',oa,jl,jT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",sa,na,ia,Jl,da,Dl,ra,ql,JT='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',ua,Il,DT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',aa,ma,pa,Kl,ca,Bl,fa,Nl,qT="Clamps all elements in input into the range [ min, max ]",Ta,Vl,IT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',ha,Ql,KT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",_a,$a,va,Sl,ba,Ol,ya,Fl,BT='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Ma,Yl,NT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',xa,Ca,Ha,Wl,La,Gl,wa,Xl,VT="Rounds elements of input to the nearest integer.",Aa,Zl,QT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',za,ga,Pa,eo,Ra,to,ka,lo,ST="Performs Tensor dtype conversion.",Ea,oo,OT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Ua,so,FT='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',ja,Ja,Da,no,qa,io,Ia,ro,YT="Permutes a tensor according to the provided axes.",Ka,uo,WT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Ba,ao,GT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Na,Va,Qa,mo,Sa,po,Oa,co,XT="Interpolates an Tensor to the given size.",Fa,fo,ZT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Ya,To,eh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Wa,Ga,Xa,ho,Za,_o,em,$o,th=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,tm,vo,lh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The interpolated tensor.',lm,bo,oh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>",om,sm,nm,yo,im,Mo,dm,xo,sh=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,rm,Co,nh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The matrix product of the two tensors.',um,Ho,ih="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code>Tensor</code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code>Tensor</code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>",am,mm,pm,Lo,cm,wo,fm,Ao,dh=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,Tm,zo,rh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - the output tensor.',hm,go,uh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code>Tensor</code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>",_m,$m,vm,Po,bm,Ro,ym,ko,ah=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Mm,Eo,mh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',xm,Uo,ph="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>",Cm,Hm,Lm,jo,wm,Jo,Am,Do,ch="Perform mean pooling of the last hidden state followed by a normalization step.",zm,qo,fh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',gm,Io,Th="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Pm,Rm,km,Ko,Em,Bo,Um,No,hh="Apply Layer Normalization for last certain number of dimensions.",jm,Vo,_h='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Jm,Qo,$h="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",Dm,qm,Im,So,Km,Oo,Bm,Fo,vh="Concatenates an array of tensors along a specified dimension.",Nm,Yo,bh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',Vm,Wo,yh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",Qm,Sm,Om,Go,Fm,Xo,Ym,Zo,Mh="Stack an array of tensors along a specified dimension.",Wm,es,xh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',Gm,ts,Ch="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",Xm,Zm,ep,ls,tp,os,lp,ss,Hh="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",op,ns,Lh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',sp,is,wh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",np,ip,dp,ds,rp,rs,up,us,Ah="Returns the mean value of each row of the input tensor in the given dimension dim.",ap,as,zh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new tensor with means taken along the specified dimension.',mp,ms,gh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",pp,cp,fp,ps,Tp,cs,hp,fs,Ph="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",_p,Ts,Rh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The filled tensor.',$p,hs,kh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",vp,bp,yp,_s,Mp,$s,xp,vs,Eh="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Cp,bs,Uh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Hp,ys,jh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Lp,wp,Ap,Ms,zp,xs,gp,Cs,Jh="Returns a tensor filled with the scalar value 1, with the same size as input.",Pp,Hs,Dh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Rp,Ls,qh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",kp,Ep,Up,ws,jp,As,Jp,zs,Ih="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",Dp,gs,Kh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',qp,Ps,Bh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Ip,Kp,Bp,Rs,Np,ks,Vp,Es,Nh="Returns a tensor filled with the scalar value 0, with the same size as input.",Qp,Us,Vh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Sp,js,Qh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Op,Fp,Yp,Js,Wp,Ds,Gp,qs,Sh="Quantizes the embeddings tensor to binary or unsigned binary precision.",Xp,Is,Oh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',Zp,Ks,Fh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",ec,tc,lc,Bs,oc,Ns,sc,Vs,Yh='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',nc,ic,dc,Qs,rc,Ss,uc,Os,Wh="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",ac,Fs,Gh='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',mc,Ys,Xh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",pc,Ws,Zh="<strong>Example</strong>",cc,Gs,fc,Tc,hc,Xs,_c,Zs,$c,en,e1='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',vc,bc,yc,tn,Mc,ln,xc,on,t1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Cc,Hc,Lc,sn,wc,nn,Ac,dn,l1="This creates a nested array of a given type and depth (see examples).",zc,rn,o1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',gc,un,Pc,an,s1="<strong>Example</strong>",Rc,mn,kc,pn,n1="<strong>Example</strong>",Ec,cn,Uc,jc,Jc,fn,Dc,hn,qc;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),z=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),k=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),re=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ke=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),st=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),zt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Et=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),qt=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Yt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),el=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),sl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),al=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),fl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),bl=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Cl=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Al=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),kl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),Dl=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),Bl=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),Ol=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),Gl=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),to=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),io=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),po=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),_o=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),Mo=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),wo=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Ro=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),Jo=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Bo=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Oo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Xo=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),os=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),cs=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),$s=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),xs=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),As=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),ks=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),Ds=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),Ns=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),Ss=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Gs=new Ic({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Zs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),ln=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),un=new Ic({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),mn=new Ic({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),cn=new Ic({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),fn=new c1({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),_n=s(),Tn=i("p"),$n=s(),v=i("a"),vn=s(),a(b.$$.fragment),bn=s(),y=i("p"),y.innerHTML=Bc,yn=s(),M=i("p"),M.textContent=Nc,Mn=s(),x=i("ul"),x.innerHTML=Vc,xn=s(),Cn=i("hr"),Hn=s(),C=i("a"),Ln=s(),a(H.$$.fragment),wn=s(),L=i("p"),L.innerHTML=Qc,An=s(),w=i("ul"),w.innerHTML=Sc,zn=s(),gn=i("hr"),Pn=s(),A=i("a"),Rn=s(),a(z.$$.fragment),kn=s(),g=i("p"),g.textContent=Oc,En=s(),P=i("table"),P.innerHTML=Fc,Un=s(),jn=i("hr"),Jn=s(),R=i("a"),Dn=s(),a(k.$$.fragment),qn=s(),E=i("p"),E.textContent=Yc,In=s(),U=i("p"),U.innerHTML=Wc,Kn=s(),Bn=i("hr"),Nn=s(),j=i("a"),Vn=s(),a(J.$$.fragment),Qn=s(),D=i("p"),D.textContent=Gc,Sn=s(),q=i("p"),q.innerHTML=Xc,On=s(),Fn=i("hr"),Yn=s(),I=i("a"),Wn=s(),a(K.$$.fragment),Gn=s(),B=i("p"),B.textContent=Zc,Xn=s(),N=i("p"),N.innerHTML=ef,Zn=s(),ei=i("hr"),ti=s(),V=i("a"),li=s(),a(Q.$$.fragment),oi=s(),S=i("p"),S.textContent=tf,si=s(),O=i("p"),O.innerHTML=lf,ni=s(),ii=i("hr"),di=s(),F=i("a"),ri=s(),a(Y.$$.fragment),ui=s(),W=i("p"),W.textContent=of,ai=s(),G=i("p"),G.innerHTML=sf,mi=s(),pi=i("hr"),ci=s(),X=i("a"),fi=s(),a(Z.$$.fragment),Ti=s(),ee=i("p"),ee.textContent=nf,hi=s(),te=i("p"),te.innerHTML=df,_i=s(),$i=i("hr"),vi=s(),le=i("a"),bi=s(),a(oe.$$.fragment),yi=s(),se=i("p"),se.textContent=rf,Mi=s(),ne=i("p"),ne.innerHTML=uf,xi=s(),ie=i("table"),ie.innerHTML=af,Ci=s(),Hi=i("hr"),Li=s(),de=i("a"),wi=s(),a(re.$$.fragment),Ai=s(),ue=i("p"),ue.innerHTML=mf,zi=s(),ae=i("table"),ae.innerHTML=pf,gi=s(),Pi=i("hr"),Ri=s(),me=i("a"),ki=s(),a(pe.$$.fragment),Ei=s(),ce=i("p"),ce.innerHTML=cf,Ui=s(),fe=i("table"),fe.innerHTML=ff,ji=s(),Ji=i("hr"),Di=s(),Te=i("a"),qi=s(),a(he.$$.fragment),Ii=s(),_e=i("p"),_e.innerHTML=Tf,Ki=s(),$e=i("p"),$e.innerHTML=hf,Bi=s(),ve=i("ul"),ve.innerHTML=_f,Ni=s(),Vi=i("hr"),Qi=s(),be=i("a"),Si=s(),a(ye.$$.fragment),Oi=s(),Me=i("p"),Me.textContent=$f,Fi=s(),xe=i("p"),xe.innerHTML=vf,Yi=s(),Wi=i("hr"),Gi=s(),Ce=i("a"),Xi=s(),a(He.$$.fragment),Zi=s(),Le=i("p"),Le.textContent=bf,ed=s(),we=i("p"),we.innerHTML=yf,td=s(),ld=i("hr"),od=s(),Ae=i("a"),sd=s(),a(ze.$$.fragment),nd=s(),ge=i("p"),ge.textContent=Mf,id=s(),Pe=i("p"),Pe.innerHTML=xf,dd=s(),rd=i("hr"),ud=s(),Re=i("a"),ad=s(),a(ke.$$.fragment),md=s(),Ee=i("p"),Ee.textContent=Cf,pd=s(),Ue=i("p"),Ue.innerHTML=Hf,cd=s(),je=i("table"),je.innerHTML=Lf,fd=s(),Td=i("hr"),hd=s(),Je=i("a"),_d=s(),a(De.$$.fragment),$d=s(),qe=i("p"),qe.textContent=wf,vd=s(),Ie=i("p"),Ie.innerHTML=Af,bd=s(),Ke=i("table"),Ke.innerHTML=zf,yd=s(),Md=i("hr"),xd=s(),Be=i("a"),Cd=s(),a(Ne.$$.fragment),Hd=s(),Ve=i("p"),Ve.textContent=gf,Ld=s(),Qe=i("p"),Qe.innerHTML=Pf,wd=s(),Se=i("table"),Se.innerHTML=Rf,Ad=s(),zd=i("hr"),gd=s(),Oe=i("a"),Pd=s(),a(Fe.$$.fragment),Rd=s(),Ye=i("p"),Ye.textContent=kf,kd=s(),We=i("p"),We.innerHTML=Ef,Ed=s(),Ge=i("table"),Ge.innerHTML=Uf,Ud=s(),jd=i("hr"),Jd=s(),Xe=i("a"),Dd=s(),a(Ze.$$.fragment),qd=s(),et=i("p"),et.textContent=jf,Id=s(),tt=i("p"),tt.innerHTML=Jf,Kd=s(),lt=i("table"),lt.innerHTML=Df,Bd=s(),Nd=i("hr"),Vd=s(),ot=i("a"),Qd=s(),a(st.$$.fragment),Sd=s(),nt=i("p"),nt.textContent=qf,Od=s(),it=i("p"),it.innerHTML=If,Fd=s(),dt=i("table"),dt.innerHTML=Kf,Yd=s(),Wd=i("hr"),Gd=s(),rt=i("a"),Xd=s(),a(ut.$$.fragment),Zd=s(),at=i("p"),at.textContent=Bf,er=s(),mt=i("p"),mt.innerHTML=Nf,tr=s(),pt=i("table"),pt.innerHTML=Vf,lr=s(),or=i("hr"),sr=s(),ct=i("a"),nr=s(),a(ft.$$.fragment),ir=s(),Tt=i("p"),Tt.textContent=Qf,dr=s(),ht=i("p"),ht.innerHTML=Sf,rr=s(),_t=i("table"),_t.innerHTML=Of,ur=s(),ar=i("hr"),mr=s(),$t=i("a"),pr=s(),a(vt.$$.fragment),cr=s(),bt=i("p"),bt.textContent=Ff,fr=s(),yt=i("p"),yt.innerHTML=Yf,Tr=s(),Mt=i("table"),Mt.innerHTML=Wf,hr=s(),_r=i("hr"),$r=s(),xt=i("a"),vr=s(),a(Ct.$$.fragment),br=s(),Ht=i("p"),Ht.textContent=Gf,yr=s(),Lt=i("p"),Lt.innerHTML=Xf,Mr=s(),wt=i("table"),wt.innerHTML=Zf,xr=s(),Cr=i("hr"),Hr=s(),At=i("a"),Lr=s(),a(zt.$$.fragment),wr=s(),gt=i("p"),gt.textContent=eT,Ar=s(),Pt=i("p"),Pt.innerHTML=tT,zr=s(),Rt=i("table"),Rt.innerHTML=lT,gr=s(),Pr=i("hr"),Rr=s(),kt=i("a"),kr=s(),a(Et.$$.fragment),Er=s(),Ut=i("p"),Ut.textContent=oT,Ur=s(),jt=i("p"),jt.innerHTML=sT,jr=s(),Jt=i("table"),Jt.innerHTML=nT,Jr=s(),Dr=i("hr"),qr=s(),Dt=i("a"),Ir=s(),a(qt.$$.fragment),Kr=s(),It=i("p"),It.textContent=iT,Br=s(),Kt=i("p"),Kt.innerHTML=dT,Nr=s(),Bt=i("table"),Bt.innerHTML=rT,Vr=s(),Qr=i("hr"),Sr=s(),Nt=i("a"),Or=s(),a(Vt.$$.fragment),Fr=s(),Qt=i("p"),Qt.innerHTML=uT,Yr=s(),St=i("p"),St.innerHTML=aT,Wr=s(),Ot=i("table"),Ot.innerHTML=mT,Gr=s(),Xr=i("hr"),Zr=s(),Ft=i("a"),eu=s(),a(Yt.$$.fragment),tu=s(),Wt=i("p"),Wt.innerHTML=pT,lu=s(),Gt=i("p"),Gt.innerHTML=cT,ou=s(),Xt=i("table"),Xt.innerHTML=fT,su=s(),nu=i("hr"),iu=s(),Zt=i("a"),du=s(),a(el.$$.fragment),ru=s(),tl=i("p"),tl.textContent=TT,uu=s(),ll=i("p"),ll.innerHTML=hT,au=s(),mu=i("hr"),pu=s(),ol=i("a"),cu=s(),a(sl.$$.fragment),fu=s(),nl=i("p"),nl.textContent=_T,Tu=s(),il=i("p"),il.innerHTML=$T,hu=s(),dl=i("p"),dl.innerHTML=vT,_u=s(),rl=i("table"),rl.innerHTML=bT,$u=s(),vu=i("hr"),bu=s(),ul=i("a"),yu=s(),a(al.$$.fragment),Mu=s(),ml=i("p"),ml.innerHTML=yT,xu=s(),pl=i("p"),pl.innerHTML=MT,Cu=s(),Hu=i("hr"),Lu=s(),cl=i("a"),wu=s(),a(fl.$$.fragment),Au=s(),Tl=i("p"),Tl.textContent=xT,zu=s(),hl=i("p"),hl.textContent=CT,gu=s(),_l=i("p"),_l.innerHTML=HT,Pu=s(),$l=i("table"),$l.innerHTML=LT,Ru=s(),ku=i("hr"),Eu=s(),vl=i("a"),Uu=s(),a(bl.$$.fragment),ju=s(),yl=i("p"),yl.innerHTML=wT,Ju=s(),Ml=i("p"),Ml.innerHTML=AT,Du=s(),qu=i("hr"),Iu=s(),xl=i("a"),Ku=s(),a(Cl.$$.fragment),Bu=s(),Hl=i("p"),Hl.innerHTML=zT,Nu=s(),Ll=i("p"),Ll.innerHTML=gT,Vu=s(),Qu=i("hr"),Su=s(),wl=i("a"),Ou=s(),a(Al.$$.fragment),Fu=s(),zl=i("p"),zl.innerHTML=PT,Yu=s(),gl=i("p"),gl.innerHTML=RT,Wu=s(),Pl=i("table"),Pl.innerHTML=kT,Gu=s(),Xu=i("hr"),Zu=s(),Rl=i("a"),ea=s(),a(kl.$$.fragment),ta=s(),El=i("p"),El.innerHTML=ET,la=s(),Ul=i("p"),Ul.innerHTML=UT,oa=s(),jl=i("table"),jl.innerHTML=jT,sa=s(),na=i("hr"),ia=s(),Jl=i("a"),da=s(),a(Dl.$$.fragment),ra=s(),ql=i("p"),ql.innerHTML=JT,ua=s(),Il=i("p"),Il.innerHTML=DT,aa=s(),ma=i("hr"),pa=s(),Kl=i("a"),ca=s(),a(Bl.$$.fragment),fa=s(),Nl=i("p"),Nl.textContent=qT,Ta=s(),Vl=i("p"),Vl.innerHTML=IT,ha=s(),Ql=i("table"),Ql.innerHTML=KT,_a=s(),$a=i("hr"),va=s(),Sl=i("a"),ba=s(),a(Ol.$$.fragment),ya=s(),Fl=i("p"),Fl.innerHTML=BT,Ma=s(),Yl=i("p"),Yl.innerHTML=NT,xa=s(),Ca=i("hr"),Ha=s(),Wl=i("a"),La=s(),a(Gl.$$.fragment),wa=s(),Xl=i("p"),Xl.textContent=VT,Aa=s(),Zl=i("p"),Zl.innerHTML=QT,za=s(),ga=i("hr"),Pa=s(),eo=i("a"),Ra=s(),a(to.$$.fragment),ka=s(),lo=i("p"),lo.textContent=ST,Ea=s(),oo=i("p"),oo.innerHTML=OT,Ua=s(),so=i("table"),so.innerHTML=FT,ja=s(),Ja=i("hr"),Da=s(),no=i("a"),qa=s(),a(io.$$.fragment),Ia=s(),ro=i("p"),ro.textContent=YT,Ka=s(),uo=i("p"),uo.innerHTML=WT,Ba=s(),ao=i("table"),ao.innerHTML=GT,Na=s(),Va=i("hr"),Qa=s(),mo=i("a"),Sa=s(),a(po.$$.fragment),Oa=s(),co=i("p"),co.textContent=XT,Fa=s(),fo=i("p"),fo.innerHTML=ZT,Ya=s(),To=i("table"),To.innerHTML=eh,Wa=s(),Ga=i("hr"),Xa=s(),ho=i("a"),Za=s(),a(_o.$$.fragment),em=s(),$o=i("p"),$o.innerHTML=th,tm=s(),vo=i("p"),vo.innerHTML=lh,lm=s(),bo=i("table"),bo.innerHTML=oh,om=s(),sm=i("hr"),nm=s(),yo=i("a"),im=s(),a(Mo.$$.fragment),dm=s(),xo=i("p"),xo.innerHTML=sh,rm=s(),Co=i("p"),Co.innerHTML=nh,um=s(),Ho=i("table"),Ho.innerHTML=ih,am=s(),mm=i("hr"),pm=s(),Lo=i("a"),cm=s(),a(wo.$$.fragment),fm=s(),Ao=i("p"),Ao.innerHTML=dh,Tm=s(),zo=i("p"),zo.innerHTML=rh,hm=s(),go=i("table"),go.innerHTML=uh,_m=s(),$m=i("hr"),vm=s(),Po=i("a"),bm=s(),a(Ro.$$.fragment),ym=s(),ko=i("p"),ko.innerHTML=ah,Mm=s(),Eo=i("p"),Eo.innerHTML=mh,xm=s(),Uo=i("table"),Uo.innerHTML=ph,Cm=s(),Hm=i("hr"),Lm=s(),jo=i("a"),wm=s(),a(Jo.$$.fragment),Am=s(),Do=i("p"),Do.textContent=ch,zm=s(),qo=i("p"),qo.innerHTML=fh,gm=s(),Io=i("table"),Io.innerHTML=Th,Pm=s(),Rm=i("hr"),km=s(),Ko=i("a"),Em=s(),a(Bo.$$.fragment),Um=s(),No=i("p"),No.textContent=hh,jm=s(),Vo=i("p"),Vo.innerHTML=_h,Jm=s(),Qo=i("table"),Qo.innerHTML=$h,Dm=s(),qm=i("hr"),Im=s(),So=i("a"),Km=s(),a(Oo.$$.fragment),Bm=s(),Fo=i("p"),Fo.textContent=vh,Nm=s(),Yo=i("p"),Yo.innerHTML=bh,Vm=s(),Wo=i("table"),Wo.innerHTML=yh,Qm=s(),Sm=i("hr"),Om=s(),Go=i("a"),Fm=s(),a(Xo.$$.fragment),Ym=s(),Zo=i("p"),Zo.textContent=Mh,Wm=s(),es=i("p"),es.innerHTML=xh,Gm=s(),ts=i("table"),ts.innerHTML=Ch,Xm=s(),Zm=i("hr"),ep=s(),ls=i("a"),tp=s(),a(os.$$.fragment),lp=s(),ss=i("p"),ss.innerHTML=Hh,op=s(),ns=i("p"),ns.innerHTML=Lh,sp=s(),is=i("table"),is.innerHTML=wh,np=s(),ip=i("hr"),dp=s(),ds=i("a"),rp=s(),a(rs.$$.fragment),up=s(),us=i("p"),us.textContent=Ah,ap=s(),as=i("p"),as.innerHTML=zh,mp=s(),ms=i("table"),ms.innerHTML=gh,pp=s(),cp=i("hr"),fp=s(),ps=i("a"),Tp=s(),a(cs.$$.fragment),hp=s(),fs=i("p"),fs.textContent=Ph,_p=s(),Ts=i("p"),Ts.innerHTML=Rh,$p=s(),hs=i("table"),hs.innerHTML=kh,vp=s(),bp=i("hr"),yp=s(),_s=i("a"),Mp=s(),a($s.$$.fragment),xp=s(),vs=i("p"),vs.textContent=Eh,Cp=s(),bs=i("p"),bs.innerHTML=Uh,Hp=s(),ys=i("table"),ys.innerHTML=jh,Lp=s(),wp=i("hr"),Ap=s(),Ms=i("a"),zp=s(),a(xs.$$.fragment),gp=s(),Cs=i("p"),Cs.textContent=Jh,Pp=s(),Hs=i("p"),Hs.innerHTML=Dh,Rp=s(),Ls=i("table"),Ls.innerHTML=qh,kp=s(),Ep=i("hr"),Up=s(),ws=i("a"),jp=s(),a(As.$$.fragment),Jp=s(),zs=i("p"),zs.textContent=Ih,Dp=s(),gs=i("p"),gs.innerHTML=Kh,qp=s(),Ps=i("table"),Ps.innerHTML=Bh,Ip=s(),Kp=i("hr"),Bp=s(),Rs=i("a"),Np=s(),a(ks.$$.fragment),Vp=s(),Es=i("p"),Es.textContent=Nh,Qp=s(),Us=i("p"),Us.innerHTML=Vh,Sp=s(),js=i("table"),js.innerHTML=Qh,Op=s(),Fp=i("hr"),Yp=s(),Js=i("a"),Wp=s(),a(Ds.$$.fragment),Gp=s(),qs=i("p"),qs.textContent=Sh,Xp=s(),Is=i("p"),Is.innerHTML=Oh,Zp=s(),Ks=i("table"),Ks.innerHTML=Fh,ec=s(),tc=i("hr"),lc=s(),Bs=i("a"),oc=s(),a(Ns.$$.fragment),sc=s(),Vs=i("p"),Vs.innerHTML=Yh,nc=s(),ic=i("hr"),dc=s(),Qs=i("a"),rc=s(),a(Ss.$$.fragment),uc=s(),Os=i("p"),Os.textContent=Wh,ac=s(),Fs=i("p"),Fs.innerHTML=Gh,mc=s(),Ys=i("table"),Ys.innerHTML=Xh,pc=s(),Ws=i("p"),Ws.innerHTML=Zh,cc=s(),a(Gs.$$.fragment),fc=s(),Tc=i("hr"),hc=s(),Xs=i("a"),_c=s(),a(Zs.$$.fragment),$c=s(),en=i("p"),en.innerHTML=e1,vc=s(),bc=i("hr"),yc=s(),tn=i("a"),Mc=s(),a(ln.$$.fragment),xc=s(),on=i("p"),on.innerHTML=t1,Cc=s(),Hc=i("hr"),Lc=s(),sn=i("a"),wc=s(),a(nn.$$.fragment),Ac=s(),dn=i("p"),dn.textContent=l1,zc=s(),rn=i("p"),rn.innerHTML=o1,gc=s(),a(un.$$.fragment),Pc=s(),an=i("p"),an.innerHTML=s1,Rc=s(),a(mn.$$.fragment),kc=s(),pn=i("p"),pn.innerHTML=n1,Ec=s(),a(cn.$$.fragment),Uc=s(),jc=i("hr"),Jc=s(),a(fn.$$.fragment),Dc=s(),hn=i("p"),this.h()},l(e){const t=m1("svelte-u9bgzb",document.head);$=d(t,"META",{name:!0,content:!0}),t.forEach(l),_n=n(e),Tn=d(e,"P",{}),h(Tn).forEach(l),$n=n(e),v=d(e,"A",{id:!0,class:!0}),h(v).forEach(l),vn=n(e),m(b.$$.fragment,e),bn=n(e),y=d(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-uw4y1m"&&(y.innerHTML=Bc),yn=n(e),M=d(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-il3kl8"&&(M.textContent=Nc),Mn=n(e),x=d(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-knyh1p"&&(x.innerHTML=Vc),xn=n(e),Cn=d(e,"HR",{}),Hn=n(e),C=d(e,"A",{id:!0,class:!0}),h(C).forEach(l),Ln=n(e),m(H.$$.fragment,e),wn=n(e),L=d(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Qc),An=n(e),w=d(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-1yut26q"&&(w.innerHTML=Sc),zn=n(e),gn=d(e,"HR",{}),Pn=n(e),A=d(e,"A",{id:!0,class:!0}),h(A).forEach(l),Rn=n(e),m(z.$$.fragment,e),kn=n(e),g=d(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-55wecd"&&(g.textContent=Oc),En=n(e),P=d(e,"TABLE",{"data-svelte-h":!0}),r(P)!=="svelte-ee7emz"&&(P.innerHTML=Fc),Un=n(e),jn=d(e,"HR",{}),Jn=n(e),R=d(e,"A",{id:!0,class:!0}),h(R).forEach(l),Dn=n(e),m(k.$$.fragment,e),qn=n(e),E=d(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1gc2rt4"&&(E.textContent=Yc),In=n(e),U=d(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-10qzguj"&&(U.innerHTML=Wc),Kn=n(e),Bn=d(e,"HR",{}),Nn=n(e),j=d(e,"A",{id:!0,class:!0}),h(j).forEach(l),Vn=n(e),m(J.$$.fragment,e),Qn=n(e),D=d(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-81y0bb"&&(D.textContent=Gc),Sn=n(e),q=d(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10qzguj"&&(q.innerHTML=Xc),On=n(e),Fn=d(e,"HR",{}),Yn=n(e),I=d(e,"A",{id:!0,class:!0}),h(I).forEach(l),Wn=n(e),m(K.$$.fragment,e),Gn=n(e),B=d(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1eqabt7"&&(B.textContent=Zc),Xn=n(e),N=d(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-10qzguj"&&(N.innerHTML=ef),Zn=n(e),ei=d(e,"HR",{}),ti=n(e),V=d(e,"A",{id:!0,class:!0}),h(V).forEach(l),li=n(e),m(Q.$$.fragment,e),oi=n(e),S=d(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-krrt97"&&(S.textContent=tf),si=n(e),O=d(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10qzguj"&&(O.innerHTML=lf),ni=n(e),ii=d(e,"HR",{}),di=n(e),F=d(e,"A",{id:!0,class:!0}),h(F).forEach(l),ri=n(e),m(Y.$$.fragment,e),ui=n(e),W=d(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1iaptgl"&&(W.textContent=of),ai=n(e),G=d(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-10qzguj"&&(G.innerHTML=sf),mi=n(e),pi=d(e,"HR",{}),ci=n(e),X=d(e,"A",{id:!0,class:!0}),h(X).forEach(l),fi=n(e),m(Z.$$.fragment,e),Ti=n(e),ee=d(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1adn56z"&&(ee.textContent=nf),hi=n(e),te=d(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gxgvk6"&&(te.innerHTML=df),_i=n(e),$i=d(e,"HR",{}),vi=n(e),le=d(e,"A",{id:!0,class:!0}),h(le).forEach(l),bi=n(e),m(oe.$$.fragment,e),yi=n(e),se=d(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1u97xg1"&&(se.textContent=rf),Mi=n(e),ne=d(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1afa2dz"&&(ne.innerHTML=uf),xi=n(e),ie=d(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1kq04ga"&&(ie.innerHTML=af),Ci=n(e),Hi=d(e,"HR",{}),Li=n(e),de=d(e,"A",{id:!0,class:!0}),h(de).forEach(l),wi=n(e),m(re.$$.fragment,e),Ai=n(e),ue=d(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1cg22af"&&(ue.innerHTML=mf),zi=n(e),ae=d(e,"TABLE",{"data-svelte-h":!0}),r(ae)!=="svelte-1hful42"&&(ae.innerHTML=pf),gi=n(e),Pi=d(e,"HR",{}),Ri=n(e),me=d(e,"A",{id:!0,class:!0}),h(me).forEach(l),ki=n(e),m(pe.$$.fragment,e),Ei=n(e),ce=d(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=cf),Ui=n(e),fe=d(e,"TABLE",{"data-svelte-h":!0}),r(fe)!=="svelte-153ftfy"&&(fe.innerHTML=ff),ji=n(e),Ji=d(e,"HR",{}),Di=n(e),Te=d(e,"A",{id:!0,class:!0}),h(Te).forEach(l),qi=n(e),m(he.$$.fragment,e),Ii=n(e),_e=d(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=Tf),Ki=n(e),$e=d(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11rv1mu"&&($e.innerHTML=hf),Bi=n(e),ve=d(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-5t2sg3"&&(ve.innerHTML=_f),Ni=n(e),Vi=d(e,"HR",{}),Qi=n(e),be=d(e,"A",{id:!0,class:!0}),h(be).forEach(l),Si=n(e),m(ye.$$.fragment,e),Oi=n(e),Me=d(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-87xdyr"&&(Me.textContent=$f),Fi=n(e),xe=d(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=vf),Yi=n(e),Wi=d(e,"HR",{}),Gi=n(e),Ce=d(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Xi=n(e),m(He.$$.fragment,e),Zi=n(e),Le=d(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-2wti2w"&&(Le.textContent=bf),ed=n(e),we=d(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-kpq7mo"&&(we.innerHTML=yf),td=n(e),ld=d(e,"HR",{}),od=n(e),Ae=d(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),sd=n(e),m(ze.$$.fragment,e),nd=n(e),ge=d(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1edu6c8"&&(ge.textContent=Mf),id=n(e),Pe=d(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1hc4oxa"&&(Pe.innerHTML=xf),dd=n(e),rd=d(e,"HR",{}),ud=n(e),Re=d(e,"A",{id:!0,class:!0}),h(Re).forEach(l),ad=n(e),m(ke.$$.fragment,e),md=n(e),Ee=d(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-az0crx"&&(Ee.textContent=Cf),pd=n(e),Ue=d(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-r66g1b"&&(Ue.innerHTML=Hf),cd=n(e),je=d(e,"TABLE",{"data-svelte-h":!0}),r(je)!=="svelte-1ok4yhn"&&(je.innerHTML=Lf),fd=n(e),Td=d(e,"HR",{}),hd=n(e),Je=d(e,"A",{id:!0,class:!0}),h(Je).forEach(l),_d=n(e),m(De.$$.fragment,e),$d=n(e),qe=d(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-jlfq15"&&(qe.textContent=wf),vd=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1hc4oxa"&&(Ie.innerHTML=Af),bd=n(e),Ke=d(e,"TABLE",{"data-svelte-h":!0}),r(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=zf),yd=n(e),Md=d(e,"HR",{}),xd=n(e),Be=d(e,"A",{id:!0,class:!0}),h(Be).forEach(l),Cd=n(e),m(Ne.$$.fragment,e),Hd=n(e),Ve=d(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-xg80lg"&&(Ve.textContent=gf),Ld=n(e),Qe=d(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1aygav2"&&(Qe.innerHTML=Pf),wd=n(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),r(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=Rf),Ad=n(e),zd=d(e,"HR",{}),gd=n(e),Oe=d(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),Pd=n(e),m(Fe.$$.fragment,e),Rd=n(e),Ye=d(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=kf),kd=n(e),We=d(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1hc4oxa"&&(We.innerHTML=Ef),Ed=n(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=Uf),Ud=n(e),jd=d(e,"HR",{}),Jd=n(e),Xe=d(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Dd=n(e),m(Ze.$$.fragment,e),qd=n(e),et=d(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-45kvaw"&&(et.textContent=jf),Id=n(e),tt=d(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1aygav2"&&(tt.innerHTML=Jf),Kd=n(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),r(lt)!=="svelte-46t58i"&&(lt.innerHTML=Df),Bd=n(e),Nd=d(e,"HR",{}),Vd=n(e),ot=d(e,"A",{id:!0,class:!0}),h(ot).forEach(l),Qd=n(e),m(st.$$.fragment,e),Sd=n(e),nt=d(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-6s524n"&&(nt.textContent=qf),Od=n(e),it=d(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1hc4oxa"&&(it.innerHTML=If),Fd=n(e),dt=d(e,"TABLE",{"data-svelte-h":!0}),r(dt)!=="svelte-46t58i"&&(dt.innerHTML=Kf),Yd=n(e),Wd=d(e,"HR",{}),Gd=n(e),rt=d(e,"A",{id:!0,class:!0}),h(rt).forEach(l),Xd=n(e),m(ut.$$.fragment,e),Zd=n(e),at=d(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1hl64jn"&&(at.textContent=Bf),er=n(e),mt=d(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1aygav2"&&(mt.innerHTML=Nf),tr=n(e),pt=d(e,"TABLE",{"data-svelte-h":!0}),r(pt)!=="svelte-1p5444"&&(pt.innerHTML=Vf),lr=n(e),or=d(e,"HR",{}),sr=n(e),ct=d(e,"A",{id:!0,class:!0}),h(ct).forEach(l),nr=n(e),m(ft.$$.fragment,e),ir=n(e),Tt=d(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-bbf4x3"&&(Tt.textContent=Qf),dr=n(e),ht=d(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1hc4oxa"&&(ht.innerHTML=Sf),rr=n(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),r(_t)!=="svelte-1p5444"&&(_t.innerHTML=Of),ur=n(e),ar=d(e,"HR",{}),mr=n(e),$t=d(e,"A",{id:!0,class:!0}),h($t).forEach(l),pr=n(e),m(vt.$$.fragment,e),cr=n(e),bt=d(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-wbrx6g"&&(bt.textContent=Ff),fr=n(e),yt=d(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1aygav2"&&(yt.innerHTML=Yf),Tr=n(e),Mt=d(e,"TABLE",{"data-svelte-h":!0}),r(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=Wf),hr=n(e),_r=d(e,"HR",{}),$r=n(e),xt=d(e,"A",{id:!0,class:!0}),h(xt).forEach(l),vr=n(e),m(Ct.$$.fragment,e),br=n(e),Ht=d(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-wqxtec"&&(Ht.textContent=Gf),yr=n(e),Lt=d(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1hc4oxa"&&(Lt.innerHTML=Xf),Mr=n(e),wt=d(e,"TABLE",{"data-svelte-h":!0}),r(wt)!=="svelte-flm2g1"&&(wt.innerHTML=Zf),xr=n(e),Cr=d(e,"HR",{}),Hr=n(e),At=d(e,"A",{id:!0,class:!0}),h(At).forEach(l),Lr=n(e),m(zt.$$.fragment,e),wr=n(e),gt=d(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1g8ouql"&&(gt.textContent=eT),Ar=n(e),Pt=d(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1scc4l4"&&(Pt.innerHTML=tT),zr=n(e),Rt=d(e,"TABLE",{"data-svelte-h":!0}),r(Rt)!=="svelte-1p49qvp"&&(Rt.innerHTML=lT),gr=n(e),Pr=d(e,"HR",{}),Rr=n(e),kt=d(e,"A",{id:!0,class:!0}),h(kt).forEach(l),kr=n(e),m(Et.$$.fragment,e),Er=n(e),Ut=d(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-yjryb1"&&(Ut.textContent=oT),Ur=n(e),jt=d(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-xtr8tc"&&(jt.innerHTML=sT),jr=n(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),r(Jt)!=="svelte-6xvdso"&&(Jt.innerHTML=nT),Jr=n(e),Dr=d(e,"HR",{}),qr=n(e),Dt=d(e,"A",{id:!0,class:!0}),h(Dt).forEach(l),Ir=n(e),m(qt.$$.fragment,e),Kr=n(e),It=d(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1okfsqx"&&(It.textContent=iT),Br=n(e),Kt=d(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1t556pk"&&(Kt.innerHTML=dT),Nr=n(e),Bt=d(e,"TABLE",{"data-svelte-h":!0}),r(Bt)!=="svelte-13m2wni"&&(Bt.innerHTML=rT),Vr=n(e),Qr=d(e,"HR",{}),Sr=n(e),Nt=d(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),Or=n(e),m(Vt.$$.fragment,e),Fr=n(e),Qt=d(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1htpbrk"&&(Qt.innerHTML=uT),Yr=n(e),St=d(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1t0m8l6"&&(St.innerHTML=aT),Wr=n(e),Ot=d(e,"TABLE",{"data-svelte-h":!0}),r(Ot)!=="svelte-1qi99pl"&&(Ot.innerHTML=mT),Gr=n(e),Xr=d(e,"HR",{}),Zr=n(e),Ft=d(e,"A",{id:!0,class:!0}),h(Ft).forEach(l),eu=n(e),m(Yt.$$.fragment,e),tu=n(e),Wt=d(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1ztgqp"&&(Wt.innerHTML=pT),lu=n(e),Gt=d(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-mvb39p"&&(Gt.innerHTML=cT),ou=n(e),Xt=d(e,"TABLE",{"data-svelte-h":!0}),r(Xt)!=="svelte-1qi99pl"&&(Xt.innerHTML=fT),su=n(e),nu=d(e,"HR",{}),iu=n(e),Zt=d(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),du=n(e),m(el.$$.fragment,e),ru=n(e),tl=d(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1a7u185"&&(tl.textContent=TT),uu=n(e),ll=d(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1eu3doh"&&(ll.innerHTML=hT),au=n(e),mu=d(e,"HR",{}),pu=n(e),ol=d(e,"A",{id:!0,class:!0}),h(ol).forEach(l),cu=n(e),m(sl.$$.fragment,e),fu=n(e),nl=d(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-qls17b"&&(nl.textContent=_T),Tu=n(e),il=d(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-5nabmy"&&(il.innerHTML=$T),hu=n(e),dl=d(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-muvb5c"&&(dl.innerHTML=vT),_u=n(e),rl=d(e,"TABLE",{"data-svelte-h":!0}),r(rl)!=="svelte-52pnzr"&&(rl.innerHTML=bT),$u=n(e),vu=d(e,"HR",{}),bu=n(e),ul=d(e,"A",{id:!0,class:!0}),h(ul).forEach(l),yu=n(e),m(al.$$.fragment,e),Mu=n(e),ml=d(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-19w0pic"&&(ml.innerHTML=yT),xu=n(e),pl=d(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1mr58c3"&&(pl.innerHTML=MT),Cu=n(e),Hu=d(e,"HR",{}),Lu=n(e),cl=d(e,"A",{id:!0,class:!0}),h(cl).forEach(l),wu=n(e),m(fl.$$.fragment,e),Au=n(e),Tl=d(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-18ws76n"&&(Tl.textContent=xT),zu=n(e),hl=d(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-1tnr5gm"&&(hl.textContent=CT),gu=n(e),_l=d(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-1si6y4t"&&(_l.innerHTML=HT),Pu=n(e),$l=d(e,"TABLE",{"data-svelte-h":!0}),r($l)!=="svelte-1u9lyxp"&&($l.innerHTML=LT),Ru=n(e),ku=d(e,"HR",{}),Eu=n(e),vl=d(e,"A",{id:!0,class:!0}),h(vl).forEach(l),Uu=n(e),m(bl.$$.fragment,e),ju=n(e),yl=d(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1b9ygao"&&(yl.innerHTML=wT),Ju=n(e),Ml=d(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-1mr58c3"&&(Ml.innerHTML=AT),Du=n(e),qu=d(e,"HR",{}),Iu=n(e),xl=d(e,"A",{id:!0,class:!0}),h(xl).forEach(l),Ku=n(e),m(Cl.$$.fragment,e),Bu=n(e),Hl=d(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-1vkr5xo"&&(Hl.innerHTML=zT),Nu=n(e),Ll=d(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-1mr58c3"&&(Ll.innerHTML=gT),Vu=n(e),Qu=d(e,"HR",{}),Su=n(e),wl=d(e,"A",{id:!0,class:!0}),h(wl).forEach(l),Ou=n(e),m(Al.$$.fragment,e),Fu=n(e),zl=d(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1gguudf"&&(zl.innerHTML=PT),Yu=n(e),gl=d(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-6vkfxj"&&(gl.innerHTML=RT),Wu=n(e),Pl=d(e,"TABLE",{"data-svelte-h":!0}),r(Pl)!=="svelte-z6whez"&&(Pl.innerHTML=kT),Gu=n(e),Xu=d(e,"HR",{}),Zu=n(e),Rl=d(e,"A",{id:!0,class:!0}),h(Rl).forEach(l),ea=n(e),m(kl.$$.fragment,e),ta=n(e),El=d(e,"P",{"data-svelte-h":!0}),r(El)!=="svelte-d6gvut"&&(El.innerHTML=ET),la=n(e),Ul=d(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-18n9ux4"&&(Ul.innerHTML=UT),oa=n(e),jl=d(e,"TABLE",{"data-svelte-h":!0}),r(jl)!=="svelte-jj58dd"&&(jl.innerHTML=jT),sa=n(e),na=d(e,"HR",{}),ia=n(e),Jl=d(e,"A",{id:!0,class:!0}),h(Jl).forEach(l),da=n(e),m(Dl.$$.fragment,e),ra=n(e),ql=d(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-1adolpg"&&(ql.innerHTML=JT),ua=n(e),Il=d(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-1mr58c3"&&(Il.innerHTML=DT),aa=n(e),ma=d(e,"HR",{}),pa=n(e),Kl=d(e,"A",{id:!0,class:!0}),h(Kl).forEach(l),ca=n(e),m(Bl.$$.fragment,e),fa=n(e),Nl=d(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-1hm8vtj"&&(Nl.textContent=qT),Ta=n(e),Vl=d(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-1ywpke5"&&(Vl.innerHTML=IT),ha=n(e),Ql=d(e,"TABLE",{"data-svelte-h":!0}),r(Ql)!=="svelte-9ff0sy"&&(Ql.innerHTML=KT),_a=n(e),$a=d(e,"HR",{}),va=n(e),Sl=d(e,"A",{id:!0,class:!0}),h(Sl).forEach(l),ba=n(e),m(Ol.$$.fragment,e),ya=n(e),Fl=d(e,"P",{"data-svelte-h":!0}),r(Fl)!=="svelte-1e6kzks"&&(Fl.innerHTML=BT),Ma=n(e),Yl=d(e,"P",{"data-svelte-h":!0}),r(Yl)!=="svelte-1mr58c3"&&(Yl.innerHTML=NT),xa=n(e),Ca=d(e,"HR",{}),Ha=n(e),Wl=d(e,"A",{id:!0,class:!0}),h(Wl).forEach(l),La=n(e),m(Gl.$$.fragment,e),wa=n(e),Xl=d(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-t5k6jp"&&(Xl.textContent=VT),Aa=n(e),Zl=d(e,"P",{"data-svelte-h":!0}),r(Zl)!=="svelte-1ywpke5"&&(Zl.innerHTML=QT),za=n(e),ga=d(e,"HR",{}),Pa=n(e),eo=d(e,"A",{id:!0,class:!0}),h(eo).forEach(l),Ra=n(e),m(to.$$.fragment,e),ka=n(e),lo=d(e,"P",{"data-svelte-h":!0}),r(lo)!=="svelte-avw2a1"&&(lo.textContent=ST),Ea=n(e),oo=d(e,"P",{"data-svelte-h":!0}),r(oo)!=="svelte-16q99cu"&&(oo.innerHTML=OT),Ua=n(e),so=d(e,"TABLE",{"data-svelte-h":!0}),r(so)!=="svelte-jj5vaa"&&(so.innerHTML=FT),ja=n(e),Ja=d(e,"HR",{}),Da=n(e),no=d(e,"A",{id:!0,class:!0}),h(no).forEach(l),qa=n(e),m(io.$$.fragment,e),Ia=n(e),ro=d(e,"P",{"data-svelte-h":!0}),r(ro)!=="svelte-167n5bd"&&(ro.textContent=YT),Ka=n(e),uo=d(e,"P",{"data-svelte-h":!0}),r(uo)!=="svelte-1pz529g"&&(uo.innerHTML=WT),Ba=n(e),ao=d(e,"TABLE",{"data-svelte-h":!0}),r(ao)!=="svelte-1oyadc3"&&(ao.innerHTML=GT),Na=n(e),Va=d(e,"HR",{}),Qa=n(e),mo=d(e,"A",{id:!0,class:!0}),h(mo).forEach(l),Sa=n(e),m(po.$$.fragment,e),Oa=n(e),co=d(e,"P",{"data-svelte-h":!0}),r(co)!=="svelte-fju8tm"&&(co.textContent=XT),Fa=n(e),fo=d(e,"P",{"data-svelte-h":!0}),r(fo)!=="svelte-13s6o0v"&&(fo.innerHTML=ZT),Ya=n(e),To=d(e,"TABLE",{"data-svelte-h":!0}),r(To)!=="svelte-8i278m"&&(To.innerHTML=eh),Wa=n(e),Ga=d(e,"HR",{}),Xa=n(e),ho=d(e,"A",{id:!0,class:!0}),h(ho).forEach(l),Za=n(e),m(_o.$$.fragment,e),em=n(e),$o=d(e,"P",{"data-svelte-h":!0}),r($o)!=="svelte-18v04la"&&($o.innerHTML=th),tm=n(e),vo=d(e,"P",{"data-svelte-h":!0}),r(vo)!=="svelte-16ws0dc"&&(vo.innerHTML=lh),lm=n(e),bo=d(e,"TABLE",{"data-svelte-h":!0}),r(bo)!=="svelte-14k2n4x"&&(bo.innerHTML=oh),om=n(e),sm=d(e,"HR",{}),nm=n(e),yo=d(e,"A",{id:!0,class:!0}),h(yo).forEach(l),im=n(e),m(Mo.$$.fragment,e),dm=n(e),xo=d(e,"P",{"data-svelte-h":!0}),r(xo)!=="svelte-1yvow13"&&(xo.innerHTML=sh),rm=n(e),Co=d(e,"P",{"data-svelte-h":!0}),r(Co)!=="svelte-13n2k7m"&&(Co.innerHTML=nh),um=n(e),Ho=d(e,"TABLE",{"data-svelte-h":!0}),r(Ho)!=="svelte-1ha3siw"&&(Ho.innerHTML=ih),am=n(e),mm=d(e,"HR",{}),pm=n(e),Lo=d(e,"A",{id:!0,class:!0}),h(Lo).forEach(l),cm=n(e),m(wo.$$.fragment,e),fm=n(e),Ao=d(e,"P",{"data-svelte-h":!0}),r(Ao)!=="svelte-19dtamh"&&(Ao.innerHTML=dh),Tm=n(e),zo=d(e,"P",{"data-svelte-h":!0}),r(zo)!=="svelte-1nr5iz8"&&(zo.innerHTML=rh),hm=n(e),go=d(e,"TABLE",{"data-svelte-h":!0}),r(go)!=="svelte-1hw4pq9"&&(go.innerHTML=uh),_m=n(e),$m=d(e,"HR",{}),vm=n(e),Po=d(e,"A",{id:!0,class:!0}),h(Po).forEach(l),bm=n(e),m(Ro.$$.fragment,e),ym=n(e),ko=d(e,"P",{"data-svelte-h":!0}),r(ko)!=="svelte-bd7moq"&&(ko.innerHTML=ah),Mm=n(e),Eo=d(e,"P",{"data-svelte-h":!0}),r(Eo)!=="svelte-jyg3bg"&&(Eo.innerHTML=mh),xm=n(e),Uo=d(e,"TABLE",{"data-svelte-h":!0}),r(Uo)!=="svelte-1sdadnq"&&(Uo.innerHTML=ph),Cm=n(e),Hm=d(e,"HR",{}),Lm=n(e),jo=d(e,"A",{id:!0,class:!0}),h(jo).forEach(l),wm=n(e),m(Jo.$$.fragment,e),Am=n(e),Do=d(e,"P",{"data-svelte-h":!0}),r(Do)!=="svelte-11ei68w"&&(Do.textContent=ch),zm=n(e),qo=d(e,"P",{"data-svelte-h":!0}),r(qo)!=="svelte-1p3llh"&&(qo.innerHTML=fh),gm=n(e),Io=d(e,"TABLE",{"data-svelte-h":!0}),r(Io)!=="svelte-1xe0vb8"&&(Io.innerHTML=Th),Pm=n(e),Rm=d(e,"HR",{}),km=n(e),Ko=d(e,"A",{id:!0,class:!0}),h(Ko).forEach(l),Em=n(e),m(Bo.$$.fragment,e),Um=n(e),No=d(e,"P",{"data-svelte-h":!0}),r(No)!=="svelte-7ivim4"&&(No.textContent=hh),jm=n(e),Vo=d(e,"P",{"data-svelte-h":!0}),r(Vo)!=="svelte-151n4qz"&&(Vo.innerHTML=_h),Jm=n(e),Qo=d(e,"TABLE",{"data-svelte-h":!0}),r(Qo)!=="svelte-iprxta"&&(Qo.innerHTML=$h),Dm=n(e),qm=d(e,"HR",{}),Im=n(e),So=d(e,"A",{id:!0,class:!0}),h(So).forEach(l),Km=n(e),m(Oo.$$.fragment,e),Bm=n(e),Fo=d(e,"P",{"data-svelte-h":!0}),r(Fo)!=="svelte-k6p1db"&&(Fo.textContent=vh),Nm=n(e),Yo=d(e,"P",{"data-svelte-h":!0}),r(Yo)!=="svelte-1o30xnd"&&(Yo.innerHTML=bh),Vm=n(e),Wo=d(e,"TABLE",{"data-svelte-h":!0}),r(Wo)!=="svelte-101obk2"&&(Wo.innerHTML=yh),Qm=n(e),Sm=d(e,"HR",{}),Om=n(e),Go=d(e,"A",{id:!0,class:!0}),h(Go).forEach(l),Fm=n(e),m(Xo.$$.fragment,e),Ym=n(e),Zo=d(e,"P",{"data-svelte-h":!0}),r(Zo)!=="svelte-8afo9v"&&(Zo.textContent=Mh),Wm=n(e),es=d(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1vvmhgz"&&(es.innerHTML=xh),Gm=n(e),ts=d(e,"TABLE",{"data-svelte-h":!0}),r(ts)!=="svelte-wz2jkw"&&(ts.innerHTML=Ch),Xm=n(e),Zm=d(e,"HR",{}),ep=n(e),ls=d(e,"A",{id:!0,class:!0}),h(ls).forEach(l),tp=n(e),m(os.$$.fragment,e),lp=n(e),ss=d(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-11plveb"&&(ss.innerHTML=Hh),op=n(e),ns=d(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1wu8g4g"&&(ns.innerHTML=Lh),sp=n(e),is=d(e,"TABLE",{"data-svelte-h":!0}),r(is)!=="svelte-1vsvca3"&&(is.innerHTML=wh),np=n(e),ip=d(e,"HR",{}),dp=n(e),ds=d(e,"A",{id:!0,class:!0}),h(ds).forEach(l),rp=n(e),m(rs.$$.fragment,e),up=n(e),us=d(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-17f4oxi"&&(us.textContent=Ah),ap=n(e),as=d(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-2yq8vx"&&(as.innerHTML=zh),mp=n(e),ms=d(e,"TABLE",{"data-svelte-h":!0}),r(ms)!=="svelte-m4z8c4"&&(ms.innerHTML=gh),pp=n(e),cp=d(e,"HR",{}),fp=n(e),ps=d(e,"A",{id:!0,class:!0}),h(ps).forEach(l),Tp=n(e),m(cs.$$.fragment,e),hp=n(e),fs=d(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-10qu7f7"&&(fs.textContent=Ph),_p=n(e),Ts=d(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-14iug9a"&&(Ts.innerHTML=Rh),$p=n(e),hs=d(e,"TABLE",{"data-svelte-h":!0}),r(hs)!=="svelte-stphn2"&&(hs.innerHTML=kh),vp=n(e),bp=d(e,"HR",{}),yp=n(e),_s=d(e,"A",{id:!0,class:!0}),h(_s).forEach(l),Mp=n(e),m($s.$$.fragment,e),xp=n(e),vs=d(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1ayje0f"&&(vs.textContent=Eh),Cp=n(e),bs=d(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-1ywifoz"&&(bs.innerHTML=Uh),Hp=n(e),ys=d(e,"TABLE",{"data-svelte-h":!0}),r(ys)!=="svelte-gyxne1"&&(ys.innerHTML=jh),Lp=n(e),wp=d(e,"HR",{}),Ap=n(e),Ms=d(e,"A",{id:!0,class:!0}),h(Ms).forEach(l),zp=n(e),m(xs.$$.fragment,e),gp=n(e),Cs=d(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-1wvb8sq"&&(Cs.textContent=Jh),Pp=n(e),Hs=d(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-1ywifoz"&&(Hs.innerHTML=Dh),Rp=n(e),Ls=d(e,"TABLE",{"data-svelte-h":!0}),r(Ls)!=="svelte-1fk5fng"&&(Ls.innerHTML=qh),kp=n(e),Ep=d(e,"HR",{}),Up=n(e),ws=d(e,"A",{id:!0,class:!0}),h(ws).forEach(l),jp=n(e),m(As.$$.fragment,e),Jp=n(e),zs=d(e,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-1798kaw"&&(zs.textContent=Ih),Dp=n(e),gs=d(e,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-11aypax"&&(gs.innerHTML=Kh),qp=n(e),Ps=d(e,"TABLE",{"data-svelte-h":!0}),r(Ps)!=="svelte-gyxne1"&&(Ps.innerHTML=Bh),Ip=n(e),Kp=d(e,"HR",{}),Bp=n(e),Rs=d(e,"A",{id:!0,class:!0}),h(Rs).forEach(l),Np=n(e),m(ks.$$.fragment,e),Vp=n(e),Es=d(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-9nnpip"&&(Es.textContent=Nh),Qp=n(e),Us=d(e,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-11aypax"&&(Us.innerHTML=Vh),Sp=n(e),js=d(e,"TABLE",{"data-svelte-h":!0}),r(js)!=="svelte-1fk5fng"&&(js.innerHTML=Qh),Op=n(e),Fp=d(e,"HR",{}),Yp=n(e),Js=d(e,"A",{id:!0,class:!0}),h(Js).forEach(l),Wp=n(e),m(Ds.$$.fragment,e),Gp=n(e),qs=d(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-185sm1b"&&(qs.textContent=Sh),Xp=n(e),Is=d(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-1y8qzzr"&&(Is.innerHTML=Oh),Zp=n(e),Ks=d(e,"TABLE",{"data-svelte-h":!0}),r(Ks)!=="svelte-1v01t7k"&&(Ks.innerHTML=Fh),ec=n(e),tc=d(e,"HR",{}),lc=n(e),Bs=d(e,"A",{id:!0,class:!0}),h(Bs).forEach(l),oc=n(e),m(Ns.$$.fragment,e),sc=n(e),Vs=d(e,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-12loz97"&&(Vs.innerHTML=Yh),nc=n(e),ic=d(e,"HR",{}),dc=n(e),Qs=d(e,"A",{id:!0,class:!0}),h(Qs).forEach(l),rc=n(e),m(Ss.$$.fragment,e),uc=n(e),Os=d(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-40isdg"&&(Os.textContent=Wh),ac=n(e),Fs=d(e,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-tlsa2h"&&(Fs.innerHTML=Gh),mc=n(e),Ys=d(e,"TABLE",{"data-svelte-h":!0}),r(Ys)!=="svelte-17343p6"&&(Ys.innerHTML=Xh),pc=n(e),Ws=d(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1aswmub"&&(Ws.innerHTML=Zh),cc=n(e),m(Gs.$$.fragment,e),fc=n(e),Tc=d(e,"HR",{}),hc=n(e),Xs=d(e,"A",{id:!0,class:!0}),h(Xs).forEach(l),_c=n(e),m(Zs.$$.fragment,e),$c=n(e),en=d(e,"P",{"data-svelte-h":!0}),r(en)!=="svelte-kp31r8"&&(en.innerHTML=e1),vc=n(e),bc=d(e,"HR",{}),yc=n(e),tn=d(e,"A",{id:!0,class:!0}),h(tn).forEach(l),Mc=n(e),m(ln.$$.fragment,e),xc=n(e),on=d(e,"P",{"data-svelte-h":!0}),r(on)!=="svelte-1fs9no9"&&(on.innerHTML=t1),Cc=n(e),Hc=d(e,"HR",{}),Lc=n(e),sn=d(e,"A",{id:!0,class:!0}),h(sn).forEach(l),wc=n(e),m(nn.$$.fragment,e),Ac=n(e),dn=d(e,"P",{"data-svelte-h":!0}),r(dn)!=="svelte-2mif9c"&&(dn.textContent=l1),zc=n(e),rn=d(e,"P",{"data-svelte-h":!0}),r(rn)!=="svelte-1jas2kw"&&(rn.innerHTML=o1),gc=n(e),m(un.$$.fragment,e),Pc=n(e),an=d(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-1aswmub"&&(an.innerHTML=s1),Rc=n(e),m(mn.$$.fragment,e),kc=n(e),pn=d(e,"P",{"data-svelte-h":!0}),r(pn)!=="svelte-1aswmub"&&(pn.innerHTML=n1),Ec=n(e),m(cn.$$.fragment,e),Uc=n(e),jc=d(e,"HR",{}),Jc=n(e),m(fn.$$.fragment,e),Dc=n(e),hn=d(e,"P",{}),h(hn).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",T1),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(R,"id","module_utils/tensor.Tensor+dims"),u(R,"class","group"),u(j,"id","module_utils/tensor.Tensor+type"),u(j,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(F,"id","module_utils/tensor.Tensor+location"),u(F,"class","group"),u(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(X,"class","group"),u(le,"id","module_utils/tensor.Tensor+_getitem"),u(le,"class","group"),u(de,"id","module_utils/tensor.Tensor+indexOf"),u(de,"class","group"),u(me,"id","module_utils/tensor.Tensor+_subarray"),u(me,"class","group"),u(Te,"id","module_utils/tensor.Tensor+item"),u(Te,"class","group"),u(be,"id","module_utils/tensor.Tensor+tolist"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+map"),u(Re,"class","group"),u(Je,"id","module_utils/tensor.Tensor+map_"),u(Je,"class","group"),u(Be,"id","module_utils/tensor.Tensor+mul"),u(Be,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+mul_"),u(Oe,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+div"),u(Xe,"class","group"),u(ot,"id","module_utils/tensor.Tensor+div_"),u(ot,"class","group"),u(rt,"id","module_utils/tensor.Tensor+add"),u(rt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+add_"),u(ct,"class","group"),u($t,"id","module_utils/tensor.Tensor+sub"),u($t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+sub_"),u(xt,"class","group"),u(At,"id","module_utils/tensor.Tensor+permute"),u(At,"class","group"),u(kt,"id","module_utils/tensor.Tensor+sum"),u(kt,"class","group"),u(Dt,"id","module_utils/tensor.Tensor+norm"),u(Dt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+normalize_"),u(Nt,"class","group"),u(Ft,"id","module_utils/tensor.Tensor+normalize"),u(Ft,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+stride"),u(Zt,"class","group"),u(ol,"id","module_utils/tensor.Tensor+squeeze"),u(ol,"class","group"),u(ul,"id","module_utils/tensor.Tensor+squeeze_"),u(ul,"class","group"),u(cl,"id","module_utils/tensor.Tensor+unsqueeze"),u(cl,"class","group"),u(vl,"id","module_utils/tensor.Tensor+unsqueeze_"),u(vl,"class","group"),u(xl,"id","module_utils/tensor.Tensor+flatten_"),u(xl,"class","group"),u(wl,"id","module_utils/tensor.Tensor+flatten"),u(wl,"class","group"),u(Rl,"id","module_utils/tensor.Tensor+view"),u(Rl,"class","group"),u(Jl,"id","module_utils/tensor.Tensor+clamp_"),u(Jl,"class","group"),u(Kl,"id","module_utils/tensor.Tensor+clamp"),u(Kl,"class","group"),u(Sl,"id","module_utils/tensor.Tensor+round_"),u(Sl,"class","group"),u(Wl,"id","module_utils/tensor.Tensor+round"),u(Wl,"class","group"),u(eo,"id","module_utils/tensor.Tensor+to"),u(eo,"class","group"),u(no,"id","module_utils/tensor.permute"),u(no,"class","group"),u(mo,"id","module_utils/tensor.interpolate"),u(mo,"class","group"),u(ho,"id","module_utils/tensor.interpolate_4d"),u(ho,"class","group"),u(yo,"id","module_utils/tensor.matmul"),u(yo,"class","group"),u(Lo,"id","module_utils/tensor.rfft"),u(Lo,"class","group"),u(Po,"id","module_utils/tensor.topk"),u(Po,"class","group"),u(jo,"id","module_utils/tensor.mean_pooling"),u(jo,"class","group"),u(Ko,"id","module_utils/tensor.layer_norm"),u(Ko,"class","group"),u(So,"id","module_utils/tensor.cat"),u(So,"class","group"),u(Go,"id","module_utils/tensor.stack"),u(Go,"class","group"),u(ls,"id","module_utils/tensor.std_mean"),u(ls,"class","group"),u(ds,"id","module_utils/tensor.mean"),u(ds,"class","group"),u(ps,"id","module_utils/tensor.full"),u(ps,"class","group"),u(_s,"id","module_utils/tensor.ones"),u(_s,"class","group"),u(Ms,"id","module_utils/tensor.ones_like"),u(Ms,"class","group"),u(ws,"id","module_utils/tensor.zeros"),u(ws,"class","group"),u(Rs,"id","module_utils/tensor.zeros_like"),u(Rs,"class","group"),u(Js,"id","module_utils/tensor.quantize_embeddings"),u(Js,"class","group"),u(Bs,"id","module_utils/tensor..args[0]"),u(Bs,"class","group"),u(Qs,"id","module_utils/tensor..reshape"),u(Qs,"class","group"),u(Xs,"id","module_utils/tensor..reshape..reshapedArray"),u(Xs,"class","group"),u(tn,"id","module_utils/tensor..DataArray"),u(tn,"class","group"),u(sn,"id","module_utils/tensor..NestArray"),u(sn,"class","group")},m(e,t){p1(document.head,$),o(e,_n,t),o(e,Tn,t),o(e,$n,t),o(e,v,t),o(e,vn,t),p(b,e,t),o(e,bn,t),o(e,y,t),o(e,yn,t),o(e,M,t),o(e,Mn,t),o(e,x,t),o(e,xn,t),o(e,Cn,t),o(e,Hn,t),o(e,C,t),o(e,Ln,t),p(H,e,t),o(e,wn,t),o(e,L,t),o(e,An,t),o(e,w,t),o(e,zn,t),o(e,gn,t),o(e,Pn,t),o(e,A,t),o(e,Rn,t),p(z,e,t),o(e,kn,t),o(e,g,t),o(e,En,t),o(e,P,t),o(e,Un,t),o(e,jn,t),o(e,Jn,t),o(e,R,t),o(e,Dn,t),p(k,e,t),o(e,qn,t),o(e,E,t),o(e,In,t),o(e,U,t),o(e,Kn,t),o(e,Bn,t),o(e,Nn,t),o(e,j,t),o(e,Vn,t),p(J,e,t),o(e,Qn,t),o(e,D,t),o(e,Sn,t),o(e,q,t),o(e,On,t),o(e,Fn,t),o(e,Yn,t),o(e,I,t),o(e,Wn,t),p(K,e,t),o(e,Gn,t),o(e,B,t),o(e,Xn,t),o(e,N,t),o(e,Zn,t),o(e,ei,t),o(e,ti,t),o(e,V,t),o(e,li,t),p(Q,e,t),o(e,oi,t),o(e,S,t),o(e,si,t),o(e,O,t),o(e,ni,t),o(e,ii,t),o(e,di,t),o(e,F,t),o(e,ri,t),p(Y,e,t),o(e,ui,t),o(e,W,t),o(e,ai,t),o(e,G,t),o(e,mi,t),o(e,pi,t),o(e,ci,t),o(e,X,t),o(e,fi,t),p(Z,e,t),o(e,Ti,t),o(e,ee,t),o(e,hi,t),o(e,te,t),o(e,_i,t),o(e,$i,t),o(e,vi,t),o(e,le,t),o(e,bi,t),p(oe,e,t),o(e,yi,t),o(e,se,t),o(e,Mi,t),o(e,ne,t),o(e,xi,t),o(e,ie,t),o(e,Ci,t),o(e,Hi,t),o(e,Li,t),o(e,de,t),o(e,wi,t),p(re,e,t),o(e,Ai,t),o(e,ue,t),o(e,zi,t),o(e,ae,t),o(e,gi,t),o(e,Pi,t),o(e,Ri,t),o(e,me,t),o(e,ki,t),p(pe,e,t),o(e,Ei,t),o(e,ce,t),o(e,Ui,t),o(e,fe,t),o(e,ji,t),o(e,Ji,t),o(e,Di,t),o(e,Te,t),o(e,qi,t),p(he,e,t),o(e,Ii,t),o(e,_e,t),o(e,Ki,t),o(e,$e,t),o(e,Bi,t),o(e,ve,t),o(e,Ni,t),o(e,Vi,t),o(e,Qi,t),o(e,be,t),o(e,Si,t),p(ye,e,t),o(e,Oi,t),o(e,Me,t),o(e,Fi,t),o(e,xe,t),o(e,Yi,t),o(e,Wi,t),o(e,Gi,t),o(e,Ce,t),o(e,Xi,t),p(He,e,t),o(e,Zi,t),o(e,Le,t),o(e,ed,t),o(e,we,t),o(e,td,t),o(e,ld,t),o(e,od,t),o(e,Ae,t),o(e,sd,t),p(ze,e,t),o(e,nd,t),o(e,ge,t),o(e,id,t),o(e,Pe,t),o(e,dd,t),o(e,rd,t),o(e,ud,t),o(e,Re,t),o(e,ad,t),p(ke,e,t),o(e,md,t),o(e,Ee,t),o(e,pd,t),o(e,Ue,t),o(e,cd,t),o(e,je,t),o(e,fd,t),o(e,Td,t),o(e,hd,t),o(e,Je,t),o(e,_d,t),p(De,e,t),o(e,$d,t),o(e,qe,t),o(e,vd,t),o(e,Ie,t),o(e,bd,t),o(e,Ke,t),o(e,yd,t),o(e,Md,t),o(e,xd,t),o(e,Be,t),o(e,Cd,t),p(Ne,e,t),o(e,Hd,t),o(e,Ve,t),o(e,Ld,t),o(e,Qe,t),o(e,wd,t),o(e,Se,t),o(e,Ad,t),o(e,zd,t),o(e,gd,t),o(e,Oe,t),o(e,Pd,t),p(Fe,e,t),o(e,Rd,t),o(e,Ye,t),o(e,kd,t),o(e,We,t),o(e,Ed,t),o(e,Ge,t),o(e,Ud,t),o(e,jd,t),o(e,Jd,t),o(e,Xe,t),o(e,Dd,t),p(Ze,e,t),o(e,qd,t),o(e,et,t),o(e,Id,t),o(e,tt,t),o(e,Kd,t),o(e,lt,t),o(e,Bd,t),o(e,Nd,t),o(e,Vd,t),o(e,ot,t),o(e,Qd,t),p(st,e,t),o(e,Sd,t),o(e,nt,t),o(e,Od,t),o(e,it,t),o(e,Fd,t),o(e,dt,t),o(e,Yd,t),o(e,Wd,t),o(e,Gd,t),o(e,rt,t),o(e,Xd,t),p(ut,e,t),o(e,Zd,t),o(e,at,t),o(e,er,t),o(e,mt,t),o(e,tr,t),o(e,pt,t),o(e,lr,t),o(e,or,t),o(e,sr,t),o(e,ct,t),o(e,nr,t),p(ft,e,t),o(e,ir,t),o(e,Tt,t),o(e,dr,t),o(e,ht,t),o(e,rr,t),o(e,_t,t),o(e,ur,t),o(e,ar,t),o(e,mr,t),o(e,$t,t),o(e,pr,t),p(vt,e,t),o(e,cr,t),o(e,bt,t),o(e,fr,t),o(e,yt,t),o(e,Tr,t),o(e,Mt,t),o(e,hr,t),o(e,_r,t),o(e,$r,t),o(e,xt,t),o(e,vr,t),p(Ct,e,t),o(e,br,t),o(e,Ht,t),o(e,yr,t),o(e,Lt,t),o(e,Mr,t),o(e,wt,t),o(e,xr,t),o(e,Cr,t),o(e,Hr,t),o(e,At,t),o(e,Lr,t),p(zt,e,t),o(e,wr,t),o(e,gt,t),o(e,Ar,t),o(e,Pt,t),o(e,zr,t),o(e,Rt,t),o(e,gr,t),o(e,Pr,t),o(e,Rr,t),o(e,kt,t),o(e,kr,t),p(Et,e,t),o(e,Er,t),o(e,Ut,t),o(e,Ur,t),o(e,jt,t),o(e,jr,t),o(e,Jt,t),o(e,Jr,t),o(e,Dr,t),o(e,qr,t),o(e,Dt,t),o(e,Ir,t),p(qt,e,t),o(e,Kr,t),o(e,It,t),o(e,Br,t),o(e,Kt,t),o(e,Nr,t),o(e,Bt,t),o(e,Vr,t),o(e,Qr,t),o(e,Sr,t),o(e,Nt,t),o(e,Or,t),p(Vt,e,t),o(e,Fr,t),o(e,Qt,t),o(e,Yr,t),o(e,St,t),o(e,Wr,t),o(e,Ot,t),o(e,Gr,t),o(e,Xr,t),o(e,Zr,t),o(e,Ft,t),o(e,eu,t),p(Yt,e,t),o(e,tu,t),o(e,Wt,t),o(e,lu,t),o(e,Gt,t),o(e,ou,t),o(e,Xt,t),o(e,su,t),o(e,nu,t),o(e,iu,t),o(e,Zt,t),o(e,du,t),p(el,e,t),o(e,ru,t),o(e,tl,t),o(e,uu,t),o(e,ll,t),o(e,au,t),o(e,mu,t),o(e,pu,t),o(e,ol,t),o(e,cu,t),p(sl,e,t),o(e,fu,t),o(e,nl,t),o(e,Tu,t),o(e,il,t),o(e,hu,t),o(e,dl,t),o(e,_u,t),o(e,rl,t),o(e,$u,t),o(e,vu,t),o(e,bu,t),o(e,ul,t),o(e,yu,t),p(al,e,t),o(e,Mu,t),o(e,ml,t),o(e,xu,t),o(e,pl,t),o(e,Cu,t),o(e,Hu,t),o(e,Lu,t),o(e,cl,t),o(e,wu,t),p(fl,e,t),o(e,Au,t),o(e,Tl,t),o(e,zu,t),o(e,hl,t),o(e,gu,t),o(e,_l,t),o(e,Pu,t),o(e,$l,t),o(e,Ru,t),o(e,ku,t),o(e,Eu,t),o(e,vl,t),o(e,Uu,t),p(bl,e,t),o(e,ju,t),o(e,yl,t),o(e,Ju,t),o(e,Ml,t),o(e,Du,t),o(e,qu,t),o(e,Iu,t),o(e,xl,t),o(e,Ku,t),p(Cl,e,t),o(e,Bu,t),o(e,Hl,t),o(e,Nu,t),o(e,Ll,t),o(e,Vu,t),o(e,Qu,t),o(e,Su,t),o(e,wl,t),o(e,Ou,t),p(Al,e,t),o(e,Fu,t),o(e,zl,t),o(e,Yu,t),o(e,gl,t),o(e,Wu,t),o(e,Pl,t),o(e,Gu,t),o(e,Xu,t),o(e,Zu,t),o(e,Rl,t),o(e,ea,t),p(kl,e,t),o(e,ta,t),o(e,El,t),o(e,la,t),o(e,Ul,t),o(e,oa,t),o(e,jl,t),o(e,sa,t),o(e,na,t),o(e,ia,t),o(e,Jl,t),o(e,da,t),p(Dl,e,t),o(e,ra,t),o(e,ql,t),o(e,ua,t),o(e,Il,t),o(e,aa,t),o(e,ma,t),o(e,pa,t),o(e,Kl,t),o(e,ca,t),p(Bl,e,t),o(e,fa,t),o(e,Nl,t),o(e,Ta,t),o(e,Vl,t),o(e,ha,t),o(e,Ql,t),o(e,_a,t),o(e,$a,t),o(e,va,t),o(e,Sl,t),o(e,ba,t),p(Ol,e,t),o(e,ya,t),o(e,Fl,t),o(e,Ma,t),o(e,Yl,t),o(e,xa,t),o(e,Ca,t),o(e,Ha,t),o(e,Wl,t),o(e,La,t),p(Gl,e,t),o(e,wa,t),o(e,Xl,t),o(e,Aa,t),o(e,Zl,t),o(e,za,t),o(e,ga,t),o(e,Pa,t),o(e,eo,t),o(e,Ra,t),p(to,e,t),o(e,ka,t),o(e,lo,t),o(e,Ea,t),o(e,oo,t),o(e,Ua,t),o(e,so,t),o(e,ja,t),o(e,Ja,t),o(e,Da,t),o(e,no,t),o(e,qa,t),p(io,e,t),o(e,Ia,t),o(e,ro,t),o(e,Ka,t),o(e,uo,t),o(e,Ba,t),o(e,ao,t),o(e,Na,t),o(e,Va,t),o(e,Qa,t),o(e,mo,t),o(e,Sa,t),p(po,e,t),o(e,Oa,t),o(e,co,t),o(e,Fa,t),o(e,fo,t),o(e,Ya,t),o(e,To,t),o(e,Wa,t),o(e,Ga,t),o(e,Xa,t),o(e,ho,t),o(e,Za,t),p(_o,e,t),o(e,em,t),o(e,$o,t),o(e,tm,t),o(e,vo,t),o(e,lm,t),o(e,bo,t),o(e,om,t),o(e,sm,t),o(e,nm,t),o(e,yo,t),o(e,im,t),p(Mo,e,t),o(e,dm,t),o(e,xo,t),o(e,rm,t),o(e,Co,t),o(e,um,t),o(e,Ho,t),o(e,am,t),o(e,mm,t),o(e,pm,t),o(e,Lo,t),o(e,cm,t),p(wo,e,t),o(e,fm,t),o(e,Ao,t),o(e,Tm,t),o(e,zo,t),o(e,hm,t),o(e,go,t),o(e,_m,t),o(e,$m,t),o(e,vm,t),o(e,Po,t),o(e,bm,t),p(Ro,e,t),o(e,ym,t),o(e,ko,t),o(e,Mm,t),o(e,Eo,t),o(e,xm,t),o(e,Uo,t),o(e,Cm,t),o(e,Hm,t),o(e,Lm,t),o(e,jo,t),o(e,wm,t),p(Jo,e,t),o(e,Am,t),o(e,Do,t),o(e,zm,t),o(e,qo,t),o(e,gm,t),o(e,Io,t),o(e,Pm,t),o(e,Rm,t),o(e,km,t),o(e,Ko,t),o(e,Em,t),p(Bo,e,t),o(e,Um,t),o(e,No,t),o(e,jm,t),o(e,Vo,t),o(e,Jm,t),o(e,Qo,t),o(e,Dm,t),o(e,qm,t),o(e,Im,t),o(e,So,t),o(e,Km,t),p(Oo,e,t),o(e,Bm,t),o(e,Fo,t),o(e,Nm,t),o(e,Yo,t),o(e,Vm,t),o(e,Wo,t),o(e,Qm,t),o(e,Sm,t),o(e,Om,t),o(e,Go,t),o(e,Fm,t),p(Xo,e,t),o(e,Ym,t),o(e,Zo,t),o(e,Wm,t),o(e,es,t),o(e,Gm,t),o(e,ts,t),o(e,Xm,t),o(e,Zm,t),o(e,ep,t),o(e,ls,t),o(e,tp,t),p(os,e,t),o(e,lp,t),o(e,ss,t),o(e,op,t),o(e,ns,t),o(e,sp,t),o(e,is,t),o(e,np,t),o(e,ip,t),o(e,dp,t),o(e,ds,t),o(e,rp,t),p(rs,e,t),o(e,up,t),o(e,us,t),o(e,ap,t),o(e,as,t),o(e,mp,t),o(e,ms,t),o(e,pp,t),o(e,cp,t),o(e,fp,t),o(e,ps,t),o(e,Tp,t),p(cs,e,t),o(e,hp,t),o(e,fs,t),o(e,_p,t),o(e,Ts,t),o(e,$p,t),o(e,hs,t),o(e,vp,t),o(e,bp,t),o(e,yp,t),o(e,_s,t),o(e,Mp,t),p($s,e,t),o(e,xp,t),o(e,vs,t),o(e,Cp,t),o(e,bs,t),o(e,Hp,t),o(e,ys,t),o(e,Lp,t),o(e,wp,t),o(e,Ap,t),o(e,Ms,t),o(e,zp,t),p(xs,e,t),o(e,gp,t),o(e,Cs,t),o(e,Pp,t),o(e,Hs,t),o(e,Rp,t),o(e,Ls,t),o(e,kp,t),o(e,Ep,t),o(e,Up,t),o(e,ws,t),o(e,jp,t),p(As,e,t),o(e,Jp,t),o(e,zs,t),o(e,Dp,t),o(e,gs,t),o(e,qp,t),o(e,Ps,t),o(e,Ip,t),o(e,Kp,t),o(e,Bp,t),o(e,Rs,t),o(e,Np,t),p(ks,e,t),o(e,Vp,t),o(e,Es,t),o(e,Qp,t),o(e,Us,t),o(e,Sp,t),o(e,js,t),o(e,Op,t),o(e,Fp,t),o(e,Yp,t),o(e,Js,t),o(e,Wp,t),p(Ds,e,t),o(e,Gp,t),o(e,qs,t),o(e,Xp,t),o(e,Is,t),o(e,Zp,t),o(e,Ks,t),o(e,ec,t),o(e,tc,t),o(e,lc,t),o(e,Bs,t),o(e,oc,t),p(Ns,e,t),o(e,sc,t),o(e,Vs,t),o(e,nc,t),o(e,ic,t),o(e,dc,t),o(e,Qs,t),o(e,rc,t),p(Ss,e,t),o(e,uc,t),o(e,Os,t),o(e,ac,t),o(e,Fs,t),o(e,mc,t),o(e,Ys,t),o(e,pc,t),o(e,Ws,t),o(e,cc,t),p(Gs,e,t),o(e,fc,t),o(e,Tc,t),o(e,hc,t),o(e,Xs,t),o(e,_c,t),p(Zs,e,t),o(e,$c,t),o(e,en,t),o(e,vc,t),o(e,bc,t),o(e,yc,t),o(e,tn,t),o(e,Mc,t),p(ln,e,t),o(e,xc,t),o(e,on,t),o(e,Cc,t),o(e,Hc,t),o(e,Lc,t),o(e,sn,t),o(e,wc,t),p(nn,e,t),o(e,Ac,t),o(e,dn,t),o(e,zc,t),o(e,rn,t),o(e,gc,t),p(un,e,t),o(e,Pc,t),o(e,an,t),o(e,Rc,t),p(mn,e,t),o(e,kc,t),o(e,pn,t),o(e,Ec,t),p(cn,e,t),o(e,Uc,t),o(e,jc,t),o(e,Jc,t),p(fn,e,t),o(e,Dc,t),o(e,hn,t),qc=!0},p:d1,i(e){qc||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(k.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ze.$$.fragment,e),c(ke.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(st.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Yt.$$.fragment,e),c(el.$$.fragment,e),c(sl.$$.fragment,e),c(al.$$.fragment,e),c(fl.$$.fragment,e),c(bl.$$.fragment,e),c(Cl.$$.fragment,e),c(Al.$$.fragment,e),c(kl.$$.fragment,e),c(Dl.$$.fragment,e),c(Bl.$$.fragment,e),c(Ol.$$.fragment,e),c(Gl.$$.fragment,e),c(to.$$.fragment,e),c(io.$$.fragment,e),c(po.$$.fragment,e),c(_o.$$.fragment,e),c(Mo.$$.fragment,e),c(wo.$$.fragment,e),c(Ro.$$.fragment,e),c(Jo.$$.fragment,e),c(Bo.$$.fragment,e),c(Oo.$$.fragment,e),c(Xo.$$.fragment,e),c(os.$$.fragment,e),c(rs.$$.fragment,e),c(cs.$$.fragment,e),c($s.$$.fragment,e),c(xs.$$.fragment,e),c(As.$$.fragment,e),c(ks.$$.fragment,e),c(Ds.$$.fragment,e),c(Ns.$$.fragment,e),c(Ss.$$.fragment,e),c(Gs.$$.fragment,e),c(Zs.$$.fragment,e),c(ln.$$.fragment,e),c(nn.$$.fragment,e),c(un.$$.fragment,e),c(mn.$$.fragment,e),c(cn.$$.fragment,e),c(fn.$$.fragment,e),qc=!0)},o(e){f(b.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(k.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(ke.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(st.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(qt.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(el.$$.fragment,e),f(sl.$$.fragment,e),f(al.$$.fragment,e),f(fl.$$.fragment,e),f(bl.$$.fragment,e),f(Cl.$$.fragment,e),f(Al.$$.fragment,e),f(kl.$$.fragment,e),f(Dl.$$.fragment,e),f(Bl.$$.fragment,e),f(Ol.$$.fragment,e),f(Gl.$$.fragment,e),f(to.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(_o.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(Ro.$$.fragment,e),f(Jo.$$.fragment,e),f(Bo.$$.fragment,e),f(Oo.$$.fragment,e),f(Xo.$$.fragment,e),f(os.$$.fragment,e),f(rs.$$.fragment,e),f(cs.$$.fragment,e),f($s.$$.fragment,e),f(xs.$$.fragment,e),f(As.$$.fragment,e),f(ks.$$.fragment,e),f(Ds.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(Gs.$$.fragment,e),f(Zs.$$.fragment,e),f(ln.$$.fragment,e),f(nn.$$.fragment,e),f(un.$$.fragment,e),f(mn.$$.fragment,e),f(cn.$$.fragment,e),f(fn.$$.fragment,e),qc=!1},d(e){e&&(l(_n),l(Tn),l($n),l(v),l(vn),l(bn),l(y),l(yn),l(M),l(Mn),l(x),l(xn),l(Cn),l(Hn),l(C),l(Ln),l(wn),l(L),l(An),l(w),l(zn),l(gn),l(Pn),l(A),l(Rn),l(kn),l(g),l(En),l(P),l(Un),l(jn),l(Jn),l(R),l(Dn),l(qn),l(E),l(In),l(U),l(Kn),l(Bn),l(Nn),l(j),l(Vn),l(Qn),l(D),l(Sn),l(q),l(On),l(Fn),l(Yn),l(I),l(Wn),l(Gn),l(B),l(Xn),l(N),l(Zn),l(ei),l(ti),l(V),l(li),l(oi),l(S),l(si),l(O),l(ni),l(ii),l(di),l(F),l(ri),l(ui),l(W),l(ai),l(G),l(mi),l(pi),l(ci),l(X),l(fi),l(Ti),l(ee),l(hi),l(te),l(_i),l($i),l(vi),l(le),l(bi),l(yi),l(se),l(Mi),l(ne),l(xi),l(ie),l(Ci),l(Hi),l(Li),l(de),l(wi),l(Ai),l(ue),l(zi),l(ae),l(gi),l(Pi),l(Ri),l(me),l(ki),l(Ei),l(ce),l(Ui),l(fe),l(ji),l(Ji),l(Di),l(Te),l(qi),l(Ii),l(_e),l(Ki),l($e),l(Bi),l(ve),l(Ni),l(Vi),l(Qi),l(be),l(Si),l(Oi),l(Me),l(Fi),l(xe),l(Yi),l(Wi),l(Gi),l(Ce),l(Xi),l(Zi),l(Le),l(ed),l(we),l(td),l(ld),l(od),l(Ae),l(sd),l(nd),l(ge),l(id),l(Pe),l(dd),l(rd),l(ud),l(Re),l(ad),l(md),l(Ee),l(pd),l(Ue),l(cd),l(je),l(fd),l(Td),l(hd),l(Je),l(_d),l($d),l(qe),l(vd),l(Ie),l(bd),l(Ke),l(yd),l(Md),l(xd),l(Be),l(Cd),l(Hd),l(Ve),l(Ld),l(Qe),l(wd),l(Se),l(Ad),l(zd),l(gd),l(Oe),l(Pd),l(Rd),l(Ye),l(kd),l(We),l(Ed),l(Ge),l(Ud),l(jd),l(Jd),l(Xe),l(Dd),l(qd),l(et),l(Id),l(tt),l(Kd),l(lt),l(Bd),l(Nd),l(Vd),l(ot),l(Qd),l(Sd),l(nt),l(Od),l(it),l(Fd),l(dt),l(Yd),l(Wd),l(Gd),l(rt),l(Xd),l(Zd),l(at),l(er),l(mt),l(tr),l(pt),l(lr),l(or),l(sr),l(ct),l(nr),l(ir),l(Tt),l(dr),l(ht),l(rr),l(_t),l(ur),l(ar),l(mr),l($t),l(pr),l(cr),l(bt),l(fr),l(yt),l(Tr),l(Mt),l(hr),l(_r),l($r),l(xt),l(vr),l(br),l(Ht),l(yr),l(Lt),l(Mr),l(wt),l(xr),l(Cr),l(Hr),l(At),l(Lr),l(wr),l(gt),l(Ar),l(Pt),l(zr),l(Rt),l(gr),l(Pr),l(Rr),l(kt),l(kr),l(Er),l(Ut),l(Ur),l(jt),l(jr),l(Jt),l(Jr),l(Dr),l(qr),l(Dt),l(Ir),l(Kr),l(It),l(Br),l(Kt),l(Nr),l(Bt),l(Vr),l(Qr),l(Sr),l(Nt),l(Or),l(Fr),l(Qt),l(Yr),l(St),l(Wr),l(Ot),l(Gr),l(Xr),l(Zr),l(Ft),l(eu),l(tu),l(Wt),l(lu),l(Gt),l(ou),l(Xt),l(su),l(nu),l(iu),l(Zt),l(du),l(ru),l(tl),l(uu),l(ll),l(au),l(mu),l(pu),l(ol),l(cu),l(fu),l(nl),l(Tu),l(il),l(hu),l(dl),l(_u),l(rl),l($u),l(vu),l(bu),l(ul),l(yu),l(Mu),l(ml),l(xu),l(pl),l(Cu),l(Hu),l(Lu),l(cl),l(wu),l(Au),l(Tl),l(zu),l(hl),l(gu),l(_l),l(Pu),l($l),l(Ru),l(ku),l(Eu),l(vl),l(Uu),l(ju),l(yl),l(Ju),l(Ml),l(Du),l(qu),l(Iu),l(xl),l(Ku),l(Bu),l(Hl),l(Nu),l(Ll),l(Vu),l(Qu),l(Su),l(wl),l(Ou),l(Fu),l(zl),l(Yu),l(gl),l(Wu),l(Pl),l(Gu),l(Xu),l(Zu),l(Rl),l(ea),l(ta),l(El),l(la),l(Ul),l(oa),l(jl),l(sa),l(na),l(ia),l(Jl),l(da),l(ra),l(ql),l(ua),l(Il),l(aa),l(ma),l(pa),l(Kl),l(ca),l(fa),l(Nl),l(Ta),l(Vl),l(ha),l(Ql),l(_a),l($a),l(va),l(Sl),l(ba),l(ya),l(Fl),l(Ma),l(Yl),l(xa),l(Ca),l(Ha),l(Wl),l(La),l(wa),l(Xl),l(Aa),l(Zl),l(za),l(ga),l(Pa),l(eo),l(Ra),l(ka),l(lo),l(Ea),l(oo),l(Ua),l(so),l(ja),l(Ja),l(Da),l(no),l(qa),l(Ia),l(ro),l(Ka),l(uo),l(Ba),l(ao),l(Na),l(Va),l(Qa),l(mo),l(Sa),l(Oa),l(co),l(Fa),l(fo),l(Ya),l(To),l(Wa),l(Ga),l(Xa),l(ho),l(Za),l(em),l($o),l(tm),l(vo),l(lm),l(bo),l(om),l(sm),l(nm),l(yo),l(im),l(dm),l(xo),l(rm),l(Co),l(um),l(Ho),l(am),l(mm),l(pm),l(Lo),l(cm),l(fm),l(Ao),l(Tm),l(zo),l(hm),l(go),l(_m),l($m),l(vm),l(Po),l(bm),l(ym),l(ko),l(Mm),l(Eo),l(xm),l(Uo),l(Cm),l(Hm),l(Lm),l(jo),l(wm),l(Am),l(Do),l(zm),l(qo),l(gm),l(Io),l(Pm),l(Rm),l(km),l(Ko),l(Em),l(Um),l(No),l(jm),l(Vo),l(Jm),l(Qo),l(Dm),l(qm),l(Im),l(So),l(Km),l(Bm),l(Fo),l(Nm),l(Yo),l(Vm),l(Wo),l(Qm),l(Sm),l(Om),l(Go),l(Fm),l(Ym),l(Zo),l(Wm),l(es),l(Gm),l(ts),l(Xm),l(Zm),l(ep),l(ls),l(tp),l(lp),l(ss),l(op),l(ns),l(sp),l(is),l(np),l(ip),l(dp),l(ds),l(rp),l(up),l(us),l(ap),l(as),l(mp),l(ms),l(pp),l(cp),l(fp),l(ps),l(Tp),l(hp),l(fs),l(_p),l(Ts),l($p),l(hs),l(vp),l(bp),l(yp),l(_s),l(Mp),l(xp),l(vs),l(Cp),l(bs),l(Hp),l(ys),l(Lp),l(wp),l(Ap),l(Ms),l(zp),l(gp),l(Cs),l(Pp),l(Hs),l(Rp),l(Ls),l(kp),l(Ep),l(Up),l(ws),l(jp),l(Jp),l(zs),l(Dp),l(gs),l(qp),l(Ps),l(Ip),l(Kp),l(Bp),l(Rs),l(Np),l(Vp),l(Es),l(Qp),l(Us),l(Sp),l(js),l(Op),l(Fp),l(Yp),l(Js),l(Wp),l(Gp),l(qs),l(Xp),l(Is),l(Zp),l(Ks),l(ec),l(tc),l(lc),l(Bs),l(oc),l(sc),l(Vs),l(nc),l(ic),l(dc),l(Qs),l(rc),l(uc),l(Os),l(ac),l(Fs),l(mc),l(Ys),l(pc),l(Ws),l(cc),l(fc),l(Tc),l(hc),l(Xs),l(_c),l($c),l(en),l(vc),l(bc),l(yc),l(tn),l(Mc),l(xc),l(on),l(Cc),l(Hc),l(Lc),l(sn),l(wc),l(Ac),l(dn),l(zc),l(rn),l(gc),l(Pc),l(an),l(Rc),l(kc),l(pn),l(Ec),l(Uc),l(jc),l(Jc),l(Dc),l(hn)),l($),T(b,e),T(H,e),T(z,e),T(k,e),T(J,e),T(K,e),T(Q,e),T(Y,e),T(Z,e),T(oe,e),T(re,e),T(pe,e),T(he,e),T(ye,e),T(He,e),T(ze,e),T(ke,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(st,e),T(ut,e),T(ft,e),T(vt,e),T(Ct,e),T(zt,e),T(Et,e),T(qt,e),T(Vt,e),T(Yt,e),T(el,e),T(sl,e),T(al,e),T(fl,e),T(bl,e),T(Cl,e),T(Al,e),T(kl,e),T(Dl,e),T(Bl,e),T(Ol,e),T(Gl,e),T(to,e),T(io,e),T(po,e),T(_o,e),T(Mo,e),T(wo,e),T(Ro,e),T(Jo,e),T(Bo,e),T(Oo,e),T(Xo,e),T(os,e),T(rs,e),T(cs,e),T($s,e),T(xs,e),T(As,e),T(ks,e),T(Ds,e),T(Ns,e),T(Ss,e),T(Gs,e),T(Zs,e),T(ln,e),T(nn,e),T(un,e),T(mn,e),T(cn,e),T(fn,e)}}}const T1='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function h1(Kc){return r1(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class y1 extends u1{constructor($){super(),a1(this,$,h1,f1,i1,{})}}export{y1 as component};
