import{s as Nt,n as Lt,o as Pt}from"../chunks/scheduler.65852ee5.js";import{S as Dt,i as Kt,g as i,s as n,r as y,A as Ot,h as o,f as l,c as s,j as St,u as r,x as M,k as At,y as te,a,v as p,d,t as u,w as m}from"../chunks/index.aa74147d.js";import{D as ee,C as z}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as It,E as le}from"../chunks/EditOnGithub.4eda6a96.js";function ae(Bt){let c,N,S,L,h,P,U,D,b,vt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',K,J,Ct='<p>This tutorial is advanced. You should have notions from <a href="agents">this other cookbook</a> first!</p>',O,w,Zt="In this notebook we will make a <strong>data analyst agent: a Code agent armed with data analysis libraries, that can load and transform dataframes to extract insights from your data, and even plots the results!</strong>",tt,T,Wt='Let’s say I want to analyze the data from the <a href="https://www.kaggle.com/competitions/titanic" rel="nofollow">Kaggle Titanic challenge</a> in order to predict the survival of individual passengers. But before digging into this myself, I want an autonomous agent to prepare the analysis for me by extracting trends and plotting some figures to find insights.',et,j,Rt="Let’s set up this system.",lt,f,$t="Run the line below to install required dependancies:",at,g,nt,G,kt='We first create the agent. We used a <code>ReactCodeAgent</code> (read the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a> to learn more about types of agents), so we do not even need to give it any tools: it can directly run its code.',st,I,Yt="We simply make sure to let it use data science-related libraries by passing these in <code>additional_authorized_imports</code>: <code>[&quot;numpy&quot;, &quot;pandas&quot;, &quot;matplotlib.pyplot&quot;, &quot;seaborn&quot;]</code>.",it,B,Vt="In general when passing libraries in <code>additional_authorized_imports</code>, make sure they are installed on your local environment, since the python interpreter can only use libraries installed on your environment.",ot,v,xt='⚙ Our agent will be powered by <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-70B-Instruct</a> using <code>HfEngine</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',Mt,C,yt,Z,rt,W,Ht="Upon running the agent, we provide it with additional notes directly taken from the competition, and give these as a kwarg to the <code>run</code> method:",pt,R,dt,$,ut,k,mt,Y,Xt=`Here are the correlations and trends found in the data:

1. **Correlation between age and survival rate**: The correlation is -0.0772, which suggests that as age increases, the survival rate decreases. This implies that older passengers were less likely to survive the Titanic disaster.

2. **Relationship between Pclass and survival rate**: The survival rates for each Pclass are:
   - Pclass 1: 62.96%
   - Pclass 2: 47.28%
   - Pclass 3: 24.24%
   This shows that passengers in higher socio-economic classes (Pclass 1 and 2) had a significantly higher survival rate compared to those in the lower class (Pclass 3).

3. **Relationship between fare and survival rate**: The correlation is 0.2573, which suggests a moderate positive relationship between fare and survival rate. This implies that passengers who paid higher fares were more likely to survive the disaster.
`,ct,V,Et="Impressive, isn’t it? You could also provide your agent with a visualizer tool to let it reflect upon its own graphs!",ht,x,Ut,H,Qt="👉 Now let’s dig further: <strong>we will let our model perform predictions on the data.</strong>",bt,X,qt="To do so, we also let it use <code>sklearn</code> in the <code>additional_authorized_imports</code>.",Jt,E,wt,Q,Ft="The test predictions that the agent output above, once submitted to Kaggle, score <strong>0.78229</strong>, which is #2824 out of 17,360, and better than what I had painfully achieved when first trying the challenge years ago.",Tt,q,_t="Your result will vary, but anyway I find it very impressive to achieve this with an agent in a few seconds.",jt,F,zt="🚀 The above is just a naive attempt with agent data analyst: it can certainly be improved a lot to fit your use case better!",ft,_,gt,A,Gt;return h=new ee({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/fixed_malformed_url/notebooks/en/agent_data_analyst.ipynb"}]}}),U=new It({props:{title:"Data analyst agent: get your data’s insights in the blink of an eye ✨",local:"data-analyst-agent-get-your-datas-insights-in-the-blink-of-an-eye-",headingTag:"h1"}}),g=new z({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzZWFib3JuJTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIy",highlighted:'!pip install seaborn <span class="hljs-string">&quot;transformers[agents]&quot;</span>',wrap:!1}}),C=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0Q29kZUFnZW50JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBaW1wb3J0JTIwb3MlMEElMEFsb2dpbihvcy5nZXRlbnYoJTIySFVHR0lOR0ZBQ0VIVUJfQVBJX1RPS0VOJTIyKSklMEElMEFsbG1fZW5naW5lJTIwJTNEJTIwSGZFbmdpbmUoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLTcwQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTJDJTIwJTIybWF0cGxvdGxpYi5weXBsb3QlMjIlMkMlMjAlMjJzZWFib3JuJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2l0ZXJhdGlvbnMlM0QxMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactCodeAgent
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-keyword">import</span> os

login(os.getenv(<span class="hljs-string">&quot;HUGGINGFACEHUB_API_TOKEN&quot;</span>))

llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>)

agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    additional_authorized_imports=[<span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>, <span class="hljs-string">&quot;matplotlib.pyplot&quot;</span>, <span class="hljs-string">&quot;seaborn&quot;</span>],
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),Z=new It({props:{title:"Data analysis 📊🤔",local:"data-analysis-",headingTag:"h2"}}),R=new z({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5ta2RpciglMjIuJTJGZmlndXJlcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> os

os.mkdir(<span class="hljs-string">&quot;./figures&quot;</span>)`,wrap:!1}}),$=new z({props:{code:"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",highlighted:`additional_notes = <span class="hljs-string">&quot;&quot;&quot;
### Variable Notes
pclass: A proxy for socio-economic status (SES)
1st = Upper
2nd = Middle
3rd = Lower
age: Age is fractional if less than 1. If the age is estimated, is it in the form of xx.5
sibsp: The dataset defines family relations in this way...
Sibling = brother, sister, stepbrother, stepsister
Spouse = husband, wife (mistresses and fiancés were ignored)
parch: The dataset defines family relations in this way...
Parent = mother, father
Child = daughter, son, stepdaughter, stepson
Some children travelled only with a nanny, therefore parch=0 for them.
&quot;&quot;&quot;</span>

analysis = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;You are an expert data analyst.
Please load the source file and analyze its content.
According to the variables you have, begin by listing 3 interesting questions that could be asked on this data, for instance about specific correlations with survival rate.
Then answer these questions one by one, by finding the relevant numbers.
Meanwhile, plot some figures using matplotlib/seaborn and save them to the (already existing) folder &#x27;./figures/&#x27;: take care to clear each figure with plt.clf() before doing another plot.

In your final answer: summarize these correlations and trends
After each number derive real worlds insights, for instance: &quot;Correlation between is_december and boredness is 1.3453, which suggest people are more bored in winter&quot;.
Your final answer should have at least 3 numbered and detailed parts.
&quot;&quot;&quot;</span>,
    additional_notes=additional_notes,
    source_file=<span class="hljs-string">&quot;titanic/train.csv&quot;</span>,
)`,wrap:!1}}),k=new z({props:{code:"cHJpbnQoYW5hbHlzaXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(analysis)',wrap:!1}}),x=new It({props:{title:"Data scientist agent: Run predictions 🛠️",local:"data-scientist-agent-run-predictions-",headingTag:"h2"}}),E=new z({props:{code:"YWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1weSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhbmRhcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1hdHBsb3RsaWIucHlwbG90JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2VhYm9ybiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNrbGVhcm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfaXRlcmF0aW9ucyUzRDEyJTJDJTBBKSUwQSUwQW91dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJZb3UlMjBhcmUlMjBhbiUyMGV4cGVydCUyMG1hY2hpbmUlMjBsZWFybmluZyUyMGVuZ2luZWVyLiUwQVBsZWFzZSUyMHRyYWluJTIwYSUyME1MJTIwbW9kZWwlMjBvbiUyMCUyMnRpdGFuaWMlMkZ0cmFpbi5jc3YlMjIlMjB0byUyMHByZWRpY3QlMjB0aGUlMjBzdXJ2aXZhbCUyMGZvciUyMHJvd3MlMjBvZiUyMCUyMnRpdGFuaWMlMkZ0ZXN0LmNzdiUyMi4lMEFPdXRwdXQlMjB0aGUlMjByZXN1bHRzJTIwdW5kZXIlMjAnLiUyRm91dHB1dC5jc3YnLiUwQVRha2UlMjBjYXJlJTIwdG8lMjBpbXBvcnQlMjBmdW5jdGlvbnMlMjBhbmQlMjBtb2R1bGVzJTIwYmVmb3JlJTIwdXNpbmclMjB0aGVtISUwQSUyMiUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfbm90ZXMlM0RhZGRpdGlvbmFsX25vdGVzJTIwJTJCJTIwJTIyJTVDbiUyMiUyMCUyQiUyMGFuYWx5c2lzJTJDJTBBKQ==",highlighted:`agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    additional_authorized_imports=[
        <span class="hljs-string">&quot;numpy&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;matplotlib.pyplot&quot;</span>,
        <span class="hljs-string">&quot;seaborn&quot;</span>,
        <span class="hljs-string">&quot;sklearn&quot;</span>,
    ],
    max_iterations=<span class="hljs-number">12</span>,
)

output = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;You are an expert machine learning engineer.
Please train a ML model on &quot;titanic/train.csv&quot; to predict the survival for rows of &quot;titanic/test.csv&quot;.
Output the results under &#x27;./output.csv&#x27;.
Take care to import functions and modules before using them!
&quot;&quot;&quot;</span>,
    additional_notes=additional_notes + <span class="hljs-string">&quot;\\n&quot;</span> + analysis,
)`,wrap:!1}}),_=new le({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_data_analyst.md"}}),{c(){c=i("meta"),N=n(),S=i("p"),L=n(),y(h.$$.fragment),P=n(),y(U.$$.fragment),D=n(),b=i("p"),b.innerHTML=vt,K=n(),J=i("blockquote"),J.innerHTML=Ct,O=n(),w=i("p"),w.innerHTML=Zt,tt=n(),T=i("p"),T.innerHTML=Wt,et=n(),j=i("p"),j.textContent=Rt,lt=n(),f=i("p"),f.textContent=$t,at=n(),y(g.$$.fragment),nt=n(),G=i("p"),G.innerHTML=kt,st=n(),I=i("p"),I.innerHTML=Yt,it=n(),B=i("p"),B.innerHTML=Vt,ot=n(),v=i("p"),v.innerHTML=xt,Mt=n(),y(C.$$.fragment),yt=n(),y(Z.$$.fragment),rt=n(),W=i("p"),W.innerHTML=Ht,pt=n(),y(R.$$.fragment),dt=n(),y($.$$.fragment),ut=n(),y(k.$$.fragment),mt=n(),Y=i("pre"),Y.textContent=Xt,ct=n(),V=i("p"),V.textContent=Et,ht=n(),y(x.$$.fragment),Ut=n(),H=i("p"),H.innerHTML=Qt,bt=n(),X=i("p"),X.innerHTML=qt,Jt=n(),y(E.$$.fragment),wt=n(),Q=i("p"),Q.innerHTML=Ft,Tt=n(),q=i("p"),q.textContent=_t,jt=n(),F=i("p"),F.textContent=zt,ft=n(),y(_.$$.fragment),gt=n(),A=i("p"),this.h()},l(t){const e=Ot("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(l),N=s(t),S=o(t,"P",{}),St(S).forEach(l),L=s(t),r(h.$$.fragment,t),P=s(t),r(U.$$.fragment,t),D=s(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1xlqnsv"&&(b.innerHTML=vt),K=s(t),J=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(J)!=="svelte-uy67xy"&&(J.innerHTML=Ct),O=s(t),w=o(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-tl5s4n"&&(w.innerHTML=Zt),tt=s(t),T=o(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-11twhfa"&&(T.innerHTML=Wt),et=s(t),j=o(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1occiln"&&(j.textContent=Rt),lt=s(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1gevz3t"&&(f.textContent=$t),at=s(t),r(g.$$.fragment,t),nt=s(t),G=o(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-el1yem"&&(G.innerHTML=kt),st=s(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-pmtf76"&&(I.innerHTML=Yt),it=s(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1wjkf4s"&&(B.innerHTML=Vt),ot=s(t),v=o(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-va2n1b"&&(v.innerHTML=xt),Mt=s(t),r(C.$$.fragment,t),yt=s(t),r(Z.$$.fragment,t),rt=s(t),W=o(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-235ghl"&&(W.innerHTML=Ht),pt=s(t),r(R.$$.fragment,t),dt=s(t),r($.$$.fragment,t),ut=s(t),r(k.$$.fragment,t),mt=s(t),Y=o(t,"PRE",{"data-svelte-h":!0}),M(Y)!=="svelte-i4e8sv"&&(Y.textContent=Xt),ct=s(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-13xtbjl"&&(V.textContent=Et),ht=s(t),r(x.$$.fragment,t),Ut=s(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1jv562d"&&(H.innerHTML=Qt),bt=s(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-74eafc"&&(X.innerHTML=qt),Jt=s(t),r(E.$$.fragment,t),wt=s(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-lh4j5y"&&(Q.innerHTML=Ft),Tt=s(t),q=o(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1w7ien5"&&(q.textContent=_t),jt=s(t),F=o(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1ftox8r"&&(F.textContent=zt),ft=s(t),r(_.$$.fragment,t),gt=s(t),A=o(t,"P",{}),St(A).forEach(l),this.h()},h(){At(c,"name","hf:doc:metadata"),At(c,"content",ne)},m(t,e){te(document.head,c),a(t,N,e),a(t,S,e),a(t,L,e),p(h,t,e),a(t,P,e),p(U,t,e),a(t,D,e),a(t,b,e),a(t,K,e),a(t,J,e),a(t,O,e),a(t,w,e),a(t,tt,e),a(t,T,e),a(t,et,e),a(t,j,e),a(t,lt,e),a(t,f,e),a(t,at,e),p(g,t,e),a(t,nt,e),a(t,G,e),a(t,st,e),a(t,I,e),a(t,it,e),a(t,B,e),a(t,ot,e),a(t,v,e),a(t,Mt,e),p(C,t,e),a(t,yt,e),p(Z,t,e),a(t,rt,e),a(t,W,e),a(t,pt,e),p(R,t,e),a(t,dt,e),p($,t,e),a(t,ut,e),p(k,t,e),a(t,mt,e),a(t,Y,e),a(t,ct,e),a(t,V,e),a(t,ht,e),p(x,t,e),a(t,Ut,e),a(t,H,e),a(t,bt,e),a(t,X,e),a(t,Jt,e),p(E,t,e),a(t,wt,e),a(t,Q,e),a(t,Tt,e),a(t,q,e),a(t,jt,e),a(t,F,e),a(t,ft,e),p(_,t,e),a(t,gt,e),a(t,A,e),Gt=!0},p:Lt,i(t){Gt||(d(h.$$.fragment,t),d(U.$$.fragment,t),d(g.$$.fragment,t),d(C.$$.fragment,t),d(Z.$$.fragment,t),d(R.$$.fragment,t),d($.$$.fragment,t),d(k.$$.fragment,t),d(x.$$.fragment,t),d(E.$$.fragment,t),d(_.$$.fragment,t),Gt=!0)},o(t){u(h.$$.fragment,t),u(U.$$.fragment,t),u(g.$$.fragment,t),u(C.$$.fragment,t),u(Z.$$.fragment,t),u(R.$$.fragment,t),u($.$$.fragment,t),u(k.$$.fragment,t),u(x.$$.fragment,t),u(E.$$.fragment,t),u(_.$$.fragment,t),Gt=!1},d(t){t&&(l(N),l(S),l(L),l(P),l(D),l(b),l(K),l(J),l(O),l(w),l(tt),l(T),l(et),l(j),l(lt),l(f),l(at),l(nt),l(G),l(st),l(I),l(it),l(B),l(ot),l(v),l(Mt),l(yt),l(rt),l(W),l(pt),l(dt),l(ut),l(mt),l(Y),l(ct),l(V),l(ht),l(Ut),l(H),l(bt),l(X),l(Jt),l(wt),l(Q),l(Tt),l(q),l(jt),l(F),l(ft),l(gt),l(A)),l(c),m(h,t),m(U,t),m(g,t),m(C,t),m(Z,t),m(R,t),m($,t),m(k,t),m(x,t),m(E,t),m(_,t)}}}const ne='{"title":"Data analyst agent: get your data’s insights in the blink of an eye ✨","local":"data-analyst-agent-get-your-datas-insights-in-the-blink-of-an-eye-","sections":[{"title":"Data analysis 📊🤔","local":"data-analysis-","sections":[],"depth":2},{"title":"Data scientist agent: Run predictions 🛠️","local":"data-scientist-agent-run-predictions-","sections":[],"depth":2}],"depth":1}';function se(Bt){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class re extends Dt{constructor(c){super(),Kt(this,c,se,ae,Nt,{})}}export{re as component};
