import{s as ls,o as gs,n as wn}from"../chunks/scheduler.6062bdaf.js";import{S as ps,i as ds,g as r,s as o,r as p,A as hs,h as a,f as s,c as n,j as b,u as d,x as l,k as v,y as t,a as _,v as h,d as u,t as m,w as f}from"../chunks/index.4bca734e.js";import{T as ra}from"../chunks/Tip.b9ac1f03.js";import{D as $}from"../chunks/Docstring.d7918b6d.js";import{C as us}from"../chunks/CodeBlock.fa01571c.js";import{E as ms}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as xn,E as fs}from"../chunks/EditOnGithub.74ab2baa.js";function _s(H){let y,T=`<a href="/docs/huggingface_hub/pr_2397/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/pr_2397/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/pr_2397/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),l(y)!=="svelte-18qgu8f"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:wn,d(w){w&&s(y)}}}function bs(H){let y,T="Raises the following error:",w,C,R=`<li><p><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if an organization token (starts with “api_org”) is passed. Use must use
your own personal access token (see <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a>).</p></li> <li><p><a href="https://docs.python.org/3/library/exceptions.html#EnvironmentError" rel="nofollow"><code>EnvironmentError</code></a>
if you are trying to clone the repository in a non-empty folder, or if the
<code>git</code> operations raise errors.</p></li>`;return{c(){y=r("p"),y.textContent=T,w=o(),C=r("ul"),C.innerHTML=R},l(x){y=a(x,"P",{"data-svelte-h":!0}),l(y)!=="svelte-1f6kjc7"&&(y.textContent=T),w=n(x),C=a(x,"UL",{"data-svelte-h":!0}),l(C)!=="svelte-dnmxmk"&&(C.innerHTML=R)},m(x,I){_(x,y,I),_(x,w,I),_(x,C,I)},p:wn,d(x){x&&(s(y),s(w),s(C))}}}function vs(H){let y,T="Examples:",w,C,R;return C=new us({props:{code:"d2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSkuY29tbWl0KCUyMk15JTIwZmlyc3QlMjBmaWxlJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJmaWxlLnR4dCUyMiUyQyUyMCUyMnclMkIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmhleSUyMiUzQSUyMDglN0QpKSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5ubi5UcmFuc2Zvcm1lcigpJTBBd2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydG9yY2gtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRnRvcmNoLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0RUcnVlJTJDJTBBKS5jb21taXQoJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwuc3RhdGVfZGljdCgpJTJDJTIwJTIybW9kZWwucHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-files&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;torch-model&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),{c(){y=r("p"),y.textContent=T,w=o(),p(C.$$.fragment)},l(x){y=a(x,"P",{"data-svelte-h":!0}),l(y)!=="svelte-kvfsh7"&&(y.textContent=T),w=n(x),d(C.$$.fragment,x)},m(x,I){_(x,y,I),_(x,w,I),h(C,x,I),R=!0},p:wn,i(x){R||(u(C.$$.fragment,x),R=!0)},o(x){m(C.$$.fragment,x),R=!1},d(x){x&&(s(y),s(w)),f(C,x)}}}function ys(H){let y,T=`<a href="/docs/huggingface_hub/pr_2397/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/pr_2397/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/pr_2397/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),l(y)!=="svelte-18qgu8f"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:wn,d(w){w&&s(y)}}}function $s(H){let y,T,w,C,R,x,I,aa=`The <code>Repository</code> class is a helper class that wraps <code>git</code> and <code>git-lfs</code> commands. It provides tooling adapted
for managing repositories which can be very large.`,To,we,sa=`It is the recommended tool as soon as any <code>git</code> operation is involved, or when collaboration will be a point
of focus with the repository itself.`,Ro,Ce,Io,i,ke,Cn,vt,ia="Helper class to wrap the git and git-lfs commands.",kn,yt,ca=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Tn,Q,Rn,M,Te,In,$t,la="Instantiate a local clone of a git repo.",Dn,xt,ga=`If <code>clone_from</code> is set, the repo will be cloned from an existing remote repository.
If the remote repo does not exist, a <code>EnvironmentError</code> exception will be thrown.
Please create the remote repo first using <a href="/docs/huggingface_hub/pr_2397/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`,Mn,wt,pa=`<code>Repository</code> uses the local git credentials by default. If explicitly set, the <code>token</code>
or the <code>git_user</code>/<code>git_email</code> pair will be used instead.`,Ln,Z,Re,En,Ct,da="Returns the current checked out branch.",Pn,L,Ie,jn,kt,ha="Add a tag at the current head and push it",Un,Tt,ua="If remote is None, will just be updated locally",Hn,Rt,ma=`If no message is provided, the tag will be lightweight. if a message is
provided, the tag will be annotated.`,Jn,X,De,Vn,It,fa="Automatically track binary files with git-lfs.",Fn,K,Me,Nn,Dt,_a=`Automatically track large files (files that weigh more than 10MBs) with
git-lfs.`,qn,Y,Le,Wn,Mt,ba="Checks that <code>git</code> and <code>git-lfs</code> can be run.",Bn,E,Ee,Sn,Lt,va=`Clone from a remote. If the folder already exists, will try to clone the
repository within it.`,An,Et,ya=`If this folder is a git repository with linked history, will try to
update the repository.`,On,ee,Gn,J,Pe,zn,Pt,$a=`Context manager utility to handle committing to a repository. This
automatically tracks large files (&gt;10Mb) with git-lfs. Set the
<code>track_large_files</code> argument to <code>False</code> if you wish to ignore that
behavior.`,Qn,te,Zn,oe,je,Xn,jt,xa="Delete a tag, both local and remote, if it exists",Kn,V,Ue,Yn,Ut,wa="git add",er,Ht,Ca=`Setting the <code>auto_lfs_track</code> parameter to <code>True</code> will automatically
track files that are larger than 10MB with <code>git-lfs</code>.`,tr,F,He,or,Jt,ka="git checkout a given revision",nr,Vt,Ta=`Specifying <code>create_branch_ok</code> to <code>True</code> will create the branch to the
given revision if that revision doesn’t exist.`,rr,ne,Je,ar,Ft,Ra="git commit",sr,re,Ve,ir,Nt,Ia="Sets git username and email (only in the current repo).",cr,ae,Fe,lr,qt,Da="Sets the git credential helper to <code>store</code>",gr,se,Ne,pr,Wt,Ma=`Get URL to last commit on HEAD. We assume it’s been pushed, and the url
scheme is the same one as for GitHub or HuggingFace.`,dr,ie,qe,hr,Bt,La="Get commit sha on top of HEAD.",ur,ce,We,mr,St,Ea="git pull",fr,N,Be,_r,At,Pa="git push",br,Ot,ja=`If used without setting <code>blocking</code>, will return url to commit on remote
repo. If used with <code>blocking=True</code>, will return a tuple containing the
url to commit and the command object to follow for information about the
process.`,vr,le,Se,yr,Gt,Ua="Get URL to origin remote.",$r,ge,Ae,xr,zt,Ha="Return whether or not the git status is clean or not",wr,pe,Oe,Cr,Qt,Ja="HF-specific. This enables upload support of files >5GB.",kr,de,Ge,Tr,Zt,Va="git lfs prune",Rr,q,ze,Ir,Xt,Fa="Tell git-lfs to track files according to a pattern.",Dr,Kt,Na=`Setting the <code>filename</code> argument to <code>True</code> will treat the arguments as
literal filenames, not as patterns. Any special glob characters in the
filename will be escaped when writing to the <code>.gitattributes</code> file.`,Mr,he,Qe,Lr,Yt,qa="Tell git-lfs to untrack those files.",Er,ue,Ze,Pr,eo,Wa=`Returns a list of the files that are deleted in the working directory or
index.`,jr,me,Xe,Ur,to,Ba=`Helper to add, commit, and push files to remote repository on the
HuggingFace Hub. Will automatically track large files (>10MB).`,Hr,fe,Ke,Jr,oo,Sa="Check if a tag exists or not.",Vr,_e,Ye,Fr,no,Aa=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Do,et,Mo,W,tt,Nr,ro,Oa="Check if the folder is the root or part of a git repository",Lo,B,ot,qr,ao,Ga="Check if the folder is a local clone of the remote_url",Eo,S,nt,Wr,so,za="Check if the file passed is tracked with git-lfs.",Po,A,rt,Br,io,Qa="Check if file is git-ignored. Supports nested .gitignore files.",jo,O,at,Sr,co,Za="Returns a list of filenames that are to be staged.",Uo,G,st,Ar,lo,Xa="Check if the current checked-out branch is tracked upstream.",Ho,P,it,Or,go,Ka="Check the number of commits that would be pushed upstream",Gr,po,Ya=`The name of the upstream repository with which the comparison should be
made.`,Jo,ct,Vo,lt,es="The <code>Repository</code> utility offers several methods which can be launched asynchronously:",Fo,gt,ts="<li><code>git_push</code></li> <li><code>git_pull</code></li> <li><code>push_to_hub</code></li> <li>The <code>commit</code> context manager</li>",No,pt,os="See below for utilities to manage such asynchronous methods.",qo,k,dt,zr,ho,ns="Helper class to wrap the git and git-lfs commands.",Qr,uo,rs=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Zr,be,Xr,ve,ht,Kr,mo,as="Returns the asynchronous commands that failed.",Yr,ye,ut,ea,fo,ss="Returns the asynchronous commands that are currently in progress.",ta,$e,mt,oa,_o,is=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Wo,z,ft,na,bo,cs="Utility to follow commands launched asynchronously.",Bo,_t,So,ko,Ao;return R=new xn({props:{title:"Managing local and online repositories",local:"managing-local-and-online-repositories",headingTag:"h1"}}),Ce=new xn({props:{title:"The Repository class",local:"huggingface_hub.Repository",headingTag:"h2"}}),ke=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L426"}}),Q=new ra({props:{warning:!0,$$slots:{default:[_s]},$$scope:{ctx:H}}}),Te=new $({props:{name:"__init__",anchor:"huggingface_hub.Repository.__init__",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.__init__.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>) &#x2014;
path (e.g. <code>&apos;my_trained_model/&apos;</code>) to the local directory, where
the <code>Repository</code> will be initialized.`,name:"local_dir"},{anchor:"huggingface_hub.Repository.__init__.clone_from",description:`<strong>clone_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Either a repository url or <code>repo_id</code>.
Example:<ul>
<li><code>&quot;https://huggingface.co/philschmid/playground-tests&quot;</code></li>
<li><code>&quot;philschmid/playground-tests&quot;</code></li>
</ul>`,name:"clone_from"},{anchor:"huggingface_hub.Repository.__init__.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
To set when cloning a repo from a repo_id. Default is model.`,name:"repo_type"},{anchor:"huggingface_hub.Repository.__init__.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
A valid authentication token (see <a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>).
If <code>None</code> or <code>True</code> and machine is logged in (through <code>huggingface-cli login</code>
or <a href="/docs/huggingface_hub/pr_2397/en/package_reference/login#huggingface_hub.login">login()</a>), token will be retrieved from the cache.
If <code>False</code>, token is not sent in the request header.`,name:"token"},{anchor:"huggingface_hub.Repository.__init__.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.name</code> for committing and
pushing files to the hub.`,name:"git_user"},{anchor:"huggingface_hub.Repository.__init__.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.email</code> for committing and
pushing files to the hub.`,name:"git_email"},{anchor:"huggingface_hub.Repository.__init__.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision to checkout after initializing the repository. If the
revision doesn&#x2019;t exist, a branch will be created with that
revision name from the default branch&#x2019;s current HEAD.`,name:"revision"},{anchor:"huggingface_hub.Repository.__init__.skip_lfs_files",description:`<strong>skip_lfs_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
whether to skip git-LFS files or not.`,name:"skip_lfs_files"},{anchor:"huggingface_hub.Repository.__init__.client",description:`<strong>client</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
Instance of <a href="/docs/huggingface_hub/pr_2397/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> to use when calling the HF Hub API. A new
instance will be created if this is left to <code>None</code>.`,name:"client"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L446",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If the remote repository set in <code>clone_from</code> does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>EnvironmentError</code></p>
`}}),Re=new $({props:{name:"current_branch",anchor:"huggingface_hub.Repository.current_branch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L563",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Current checked out branch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ie=new $({props:{name:"add_tag",anchor:"huggingface_hub.Repository.add_tag",parameters:[{name:"tag_name",val:": str"},{name:"message",val:": Optional = None"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.add_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to be added.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.add_tag.message",description:`<strong>message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The message that accompanies the tag. The tag will turn into an
annotated tag if a message is passed.`,name:"message"},{anchor:"huggingface_hub.Repository.add_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to add the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1247"}}),De=new $({props:{name:"auto_track_binary_files",anchor:"huggingface_hub.Repository.auto_track_binary_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_binary_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are binary.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L889",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to being
binary files</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Me=new $({props:{name:"auto_track_large_files",anchor:"huggingface_hub.Repository.auto_track_large_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_large_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are above 10MBs.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to their
size.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Le=new $({props:{name:"check_git_versions",anchor:"huggingface_hub.Repository.check_git_versions",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L578",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>git</code> or <code>git-lfs</code> are not installed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>EnvironmentError</code></p>
`}}),Ee=new $({props:{name:"clone_from",anchor:"huggingface_hub.Repository.clone_from",parameters:[{name:"repo_url",val:": str"},{name:"token",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.clone_from.repo_url",description:`<strong>repo_url</strong> (<code>str</code>) &#x2014;
The URL from which to clone the repository`,name:"repo_url"},{anchor:"huggingface_hub.Repository.clone_from.token",description:`<strong>token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Whether to use the authentication token. It can be:<ul>
<li>a string which is the token itself</li>
<li><code>False</code>, which would not use the authentication token</li>
<li><code>True</code>, which would fetch the authentication token from the
local folder and use it (you should be logged in for this to
work).</li>
<li><code>None</code>, which would retrieve the value of
<code>self.huggingface_token</code>.</li>
</ul>`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L601"}}),ee=new ra({props:{$$slots:{default:[bs]},$$scope:{ctx:H}}}),Pe=new $({props:{name:"commit",anchor:"huggingface_hub.Repository.commit",parameters:[{name:"commit_message",val:": str"},{name:"branch",val:": Optional = None"},{name:"track_large_files",val:": bool = True"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.commit.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch on which the commit will appear. This branch will be
checked-out before any operation.`,name:"branch"},{anchor:"huggingface_hub.Repository.commit.track_large_files",description:`<strong>track_large_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to automatically track large files or not. Will do so by
default.`,name:"track_large_files"},{anchor:"huggingface_hub.Repository.commit.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.commit.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1331"}}),te=new ms({props:{anchor:"huggingface_hub.Repository.commit.example",$$slots:{default:[vs]},$$scope:{ctx:H}}}),je=new $({props:{name:"delete_tag",anchor:"huggingface_hub.Repository.delete_tag",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.delete_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The tag name to delete.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.delete_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to delete the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1210",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if deleted, <code>False</code> if the tag didn’t exist.
If remote is not passed, will just be updated locally</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ue=new $({props:{name:"git_add",anchor:"huggingface_hub.Repository.git_add",parameters:[{name:"pattern",val:": str = '.'"},{name:"auto_lfs_track",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_add.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to add files to staging.`,name:"pattern"},{anchor:"huggingface_hub.Repository.git_add.auto_lfs_track",description:`<strong>auto_lfs_track</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically track large and binary files with
git-lfs. Any file over 10MB in size, or in binary format, will
be automatically tracked.`,name:"auto_lfs_track"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1007"}}),He=new $({props:{name:"git_checkout",anchor:"huggingface_hub.Repository.git_checkout",parameters:[{name:"revision",val:": str"},{name:"create_branch_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_checkout.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision to checkout.`,name:"revision"},{anchor:"huggingface_hub.Repository.git_checkout.create_branch_ok",description:`<strong>create_branch_ok</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether creating a branch named with the <code>revision</code> passed at
the current checked-out reference if <code>revision</code> isn&#x2019;t an
existing revision is allowed.`,name:"create_branch_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1148"}}),Je=new $({props:{name:"git_commit",anchor:"huggingface_hub.Repository.git_commit",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;commit files to HF hub&#x201D;) &#x2014;
The message attributed to the commit.`,name:"commit_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1041"}}),Ve=new $({props:{name:"git_config_username_and_email",anchor:"huggingface_hub.Repository.git_config_username_and_email",parameters:[{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The username to register through <code>git</code>.`,name:"git_user"},{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The email to register through <code>git</code>.`,name:"git_email"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L729"}}),Fe=new $({props:{name:"git_credential_helper_store",anchor:"huggingface_hub.Repository.git_credential_helper_store",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L748"}}),Ne=new $({props:{name:"git_head_commit_url",anchor:"huggingface_hub.Repository.git_head_commit_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL to the current checked-out commit.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),qe=new $({props:{name:"git_head_hash",anchor:"huggingface_hub.Repository.git_head_hash",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The current checked out commit SHA.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),We=new $({props:{name:"git_pull",anchor:"huggingface_hub.Repository.git_pull",parameters:[{name:"rebase",val:": bool = False"},{name:"lfs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_pull.rebase",description:`<strong>rebase</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rebase the current branch on top of the upstream
branch after fetching.`,name:"rebase"},{anchor:"huggingface_hub.Repository.git_pull.lfs",description:`<strong>lfs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch the LFS files too. This option only changes the
behavior when a repository was cloned without fetching the LFS
files; calling <code>repo.git_pull(lfs=True)</code> will then fetch the LFS
file from the remote repository.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L983"}}),Be=new $({props:{name:"git_push",anchor:"huggingface_hub.Repository.git_push",parameters:[{name:"upstream",val:": Optional = None"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_push.upstream",description:`<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Upstream to which this should push. If not specified, will push
to the lastly defined upstream or to the default one (<code>origin main</code>).`,name:"upstream"},{anchor:"huggingface_hub.Repository.git_push.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the push has
finished. Setting this to <code>False</code> will return an
<code>CommandInProgress</code> object which has an <code>is_done</code> property. This
property will be set to <code>True</code> when the push is finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.git_push.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1058"}}),Se=new $({props:{name:"git_remote_url",anchor:"huggingface_hub.Repository.git_remote_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L770",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL of the <code>origin</code> remote.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ae=new $({props:{name:"is_repo_clean",anchor:"huggingface_hub.Repository.is_repo_clean",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1281",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the git status is clean, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Oe=new $({props:{name:"lfs_enable_largefiles",anchor:"huggingface_hub.Repository.lfs_enable_largefiles",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L875"}}),Ge=new $({props:{name:"lfs_prune",anchor:"huggingface_hub.Repository.lfs_prune",parameters:[{name:"recent",val:" = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_prune.recent",description:`<strong>recent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to prune files even if they were referenced by recent
commits. See the following
<a href="https://github.com/git-lfs/git-lfs/blob/f3d43f0428a84fc4f1e5405b76b5a73ec2437e65/docs/man/git-lfs-prune.1.ronn#recent-files" rel="nofollow">link</a>
for more information.`,name:"recent"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L965"}}),ze=new $({props:{name:"lfs_track",anchor:"huggingface_hub.Repository.lfs_track",parameters:[{name:"patterns",val:": Union"},{name:"filename",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_track.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to track with git-lfs.`,name:"patterns"},{anchor:"huggingface_hub.Repository.lfs_track.filename",description:`<strong>filename</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the patterns as literal filenames.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L834"}}),Qe=new $({props:{name:"lfs_untrack",anchor:"huggingface_hub.Repository.lfs_untrack",parameters:[{name:"patterns",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_untrack.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to untrack with git-lfs.`,name:"patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L859"}}),Ze=new $({props:{name:"list_deleted_files",anchor:"huggingface_hub.Repository.list_deleted_files",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of files that have been deleted in the working
directory or index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Xe=new $({props:{name:"push_to_hub",anchor:"huggingface_hub.Repository.push_to_hub",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"},{name:"blocking",val:": bool = True"},{name:"clean_ok",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.push_to_hub.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.push_to_hub.clean_ok",description:`<strong>clean_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, this function will return None if the repo is
untouched. Default behavior is to fail because the git command
fails.`,name:"clean_ok"},{anchor:"huggingface_hub.Repository.push_to_hub.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1295"}}),Ke=new $({props:{name:"tag_exists",anchor:"huggingface_hub.Repository.tag_exists",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.tag_exists.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to check.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.tag_exists.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether to check if the tag exists on a remote. This parameter
should be the identifier of the remote.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1180",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether the tag exists.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ye=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1459"}}),et=new xn({props:{title:"Helper methods",local:"huggingface_hub.repository.is_git_repo",headingTag:"h2"}}),tt=new $({props:{name:"huggingface_hub.repository.is_git_repo",anchor:"huggingface_hub.repository.is_git_repo",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_repo.folder",description:`<strong>folder</strong> (<code>str</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is part of a repository, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ot=new $({props:{name:"huggingface_hub.repository.is_local_clone",anchor:"huggingface_hub.repository.is_local_clone",parameters:[{name:"folder",val:": Union"},{name:"remote_url",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_local_clone.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.is_local_clone.remote_url",description:`<strong>remote_url</strong> (<code>str</code>) &#x2014;
The url of a git repository.`,name:"remote_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is a local clone of the remote
repository specified, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),nt=new $({props:{name:"huggingface_hub.repository.is_tracked_with_lfs",anchor:"huggingface_hub.repository.is_tracked_with_lfs",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_with_lfs.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is tracked with git-lfs, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),rt=new $({props:{name:"huggingface_hub.repository.is_git_ignored",anchor:"huggingface_hub.repository.is_git_ignored",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_ignored.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is ignored by <code>git</code>, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),at=new $({props:{name:"huggingface_hub.repository.files_to_be_staged",anchor:"huggingface_hub.repository.files_to_be_staged",parameters:[{name:"pattern",val:": str = '.'"},{name:"folder",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.files_to_be_staged.pattern",description:`<strong>pattern</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The pattern of filenames to check. Put <code>.</code> to get all files.`,name:"pattern"},{anchor:"huggingface_hub.repository.files_to_be_staged.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of files that are to be staged.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),st=new $({props:{name:"huggingface_hub.repository.is_tracked_upstream",anchor:"huggingface_hub.repository.is_tracked_upstream",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_upstream.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L266",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the current checked-out branch is tracked upstream,
<code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),it=new $({props:{name:"huggingface_hub.repository.commits_to_push",anchor:"huggingface_hub.repository.commits_to_push",parameters:[{name:"folder",val:": Union"},{name:"upstream",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.commits_to_push.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.commits_to_push.upstream",description:"<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;",name:"upstream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of commits that would be pushed upstream were a <code>git push</code> to proceed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),ct=new xn({props:{title:"Following asynchronous commands",local:"huggingface_hub.Repository",headingTag:"h2"}}),dt=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L426"}}),be=new ra({props:{warning:!0,$$slots:{default:[ys]},$$scope:{ctx:H}}}),ht=new $({props:{name:"commands_failed",anchor:"huggingface_hub.Repository.commands_failed",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1445"}}),ut=new $({props:{name:"commands_in_progress",anchor:"huggingface_hub.Repository.commands_in_progress",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1452"}}),mt=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L1459"}}),ft=new $({props:{name:"class huggingface_hub.repository.CommandInProgress",anchor:"huggingface_hub.repository.CommandInProgress",parameters:[{name:"title",val:": str"},{name:"is_done_method",val:": Callable"},{name:"status_method",val:": Callable"},{name:"process",val:": Popen"},{name:"post_method",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2397/src/huggingface_hub/repository.py#L31"}}),_t=new fs({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/repository.md"}}),{c(){y=r("meta"),T=o(),w=r("p"),C=o(),p(R.$$.fragment),x=o(),I=r("p"),I.innerHTML=aa,To=o(),we=r("p"),we.innerHTML=sa,Ro=o(),p(Ce.$$.fragment),Io=o(),i=r("div"),p(ke.$$.fragment),Cn=o(),vt=r("p"),vt.textContent=ia,kn=o(),yt=r("p"),yt.textContent=ca,Tn=o(),p(Q.$$.fragment),Rn=o(),M=r("div"),p(Te.$$.fragment),In=o(),$t=r("p"),$t.textContent=la,Dn=o(),xt=r("p"),xt.innerHTML=ga,Mn=o(),wt=r("p"),wt.innerHTML=pa,Ln=o(),Z=r("div"),p(Re.$$.fragment),En=o(),Ct=r("p"),Ct.textContent=da,Pn=o(),L=r("div"),p(Ie.$$.fragment),jn=o(),kt=r("p"),kt.textContent=ha,Un=o(),Tt=r("p"),Tt.textContent=ua,Hn=o(),Rt=r("p"),Rt.textContent=ma,Jn=o(),X=r("div"),p(De.$$.fragment),Vn=o(),It=r("p"),It.textContent=fa,Fn=o(),K=r("div"),p(Me.$$.fragment),Nn=o(),Dt=r("p"),Dt.textContent=_a,qn=o(),Y=r("div"),p(Le.$$.fragment),Wn=o(),Mt=r("p"),Mt.innerHTML=ba,Bn=o(),E=r("div"),p(Ee.$$.fragment),Sn=o(),Lt=r("p"),Lt.textContent=va,An=o(),Et=r("p"),Et.textContent=ya,On=o(),p(ee.$$.fragment),Gn=o(),J=r("div"),p(Pe.$$.fragment),zn=o(),Pt=r("p"),Pt.innerHTML=$a,Qn=o(),p(te.$$.fragment),Zn=o(),oe=r("div"),p(je.$$.fragment),Xn=o(),jt=r("p"),jt.textContent=xa,Kn=o(),V=r("div"),p(Ue.$$.fragment),Yn=o(),Ut=r("p"),Ut.textContent=wa,er=o(),Ht=r("p"),Ht.innerHTML=Ca,tr=o(),F=r("div"),p(He.$$.fragment),or=o(),Jt=r("p"),Jt.textContent=ka,nr=o(),Vt=r("p"),Vt.innerHTML=Ta,rr=o(),ne=r("div"),p(Je.$$.fragment),ar=o(),Ft=r("p"),Ft.textContent=Ra,sr=o(),re=r("div"),p(Ve.$$.fragment),ir=o(),Nt=r("p"),Nt.textContent=Ia,cr=o(),ae=r("div"),p(Fe.$$.fragment),lr=o(),qt=r("p"),qt.innerHTML=Da,gr=o(),se=r("div"),p(Ne.$$.fragment),pr=o(),Wt=r("p"),Wt.textContent=Ma,dr=o(),ie=r("div"),p(qe.$$.fragment),hr=o(),Bt=r("p"),Bt.textContent=La,ur=o(),ce=r("div"),p(We.$$.fragment),mr=o(),St=r("p"),St.textContent=Ea,fr=o(),N=r("div"),p(Be.$$.fragment),_r=o(),At=r("p"),At.textContent=Pa,br=o(),Ot=r("p"),Ot.innerHTML=ja,vr=o(),le=r("div"),p(Se.$$.fragment),yr=o(),Gt=r("p"),Gt.textContent=Ua,$r=o(),ge=r("div"),p(Ae.$$.fragment),xr=o(),zt=r("p"),zt.textContent=Ha,wr=o(),pe=r("div"),p(Oe.$$.fragment),Cr=o(),Qt=r("p"),Qt.textContent=Ja,kr=o(),de=r("div"),p(Ge.$$.fragment),Tr=o(),Zt=r("p"),Zt.textContent=Va,Rr=o(),q=r("div"),p(ze.$$.fragment),Ir=o(),Xt=r("p"),Xt.textContent=Fa,Dr=o(),Kt=r("p"),Kt.innerHTML=Na,Mr=o(),he=r("div"),p(Qe.$$.fragment),Lr=o(),Yt=r("p"),Yt.textContent=qa,Er=o(),ue=r("div"),p(Ze.$$.fragment),Pr=o(),eo=r("p"),eo.textContent=Wa,jr=o(),me=r("div"),p(Xe.$$.fragment),Ur=o(),to=r("p"),to.textContent=Ba,Hr=o(),fe=r("div"),p(Ke.$$.fragment),Jr=o(),oo=r("p"),oo.textContent=Sa,Vr=o(),_e=r("div"),p(Ye.$$.fragment),Fr=o(),no=r("p"),no.textContent=Aa,Do=o(),p(et.$$.fragment),Mo=o(),W=r("div"),p(tt.$$.fragment),Nr=o(),ro=r("p"),ro.textContent=Oa,Lo=o(),B=r("div"),p(ot.$$.fragment),qr=o(),ao=r("p"),ao.textContent=Ga,Eo=o(),S=r("div"),p(nt.$$.fragment),Wr=o(),so=r("p"),so.textContent=za,Po=o(),A=r("div"),p(rt.$$.fragment),Br=o(),io=r("p"),io.textContent=Qa,jo=o(),O=r("div"),p(at.$$.fragment),Sr=o(),co=r("p"),co.textContent=Za,Uo=o(),G=r("div"),p(st.$$.fragment),Ar=o(),lo=r("p"),lo.textContent=Xa,Ho=o(),P=r("div"),p(it.$$.fragment),Or=o(),go=r("p"),go.textContent=Ka,Gr=o(),po=r("p"),po.textContent=Ya,Jo=o(),p(ct.$$.fragment),Vo=o(),lt=r("p"),lt.innerHTML=es,Fo=o(),gt=r("ul"),gt.innerHTML=ts,No=o(),pt=r("p"),pt.textContent=os,qo=o(),k=r("div"),p(dt.$$.fragment),zr=o(),ho=r("p"),ho.textContent=ns,Qr=o(),uo=r("p"),uo.textContent=rs,Zr=o(),p(be.$$.fragment),Xr=o(),ve=r("div"),p(ht.$$.fragment),Kr=o(),mo=r("p"),mo.textContent=as,Yr=o(),ye=r("div"),p(ut.$$.fragment),ea=o(),fo=r("p"),fo.textContent=ss,ta=o(),$e=r("div"),p(mt.$$.fragment),oa=o(),_o=r("p"),_o.textContent=is,Wo=o(),z=r("div"),p(ft.$$.fragment),na=o(),bo=r("p"),bo.textContent=cs,Bo=o(),p(_t.$$.fragment),So=o(),ko=r("p"),this.h()},l(e){const g=hs("svelte-u9bgzb",document.head);y=a(g,"META",{name:!0,content:!0}),g.forEach(s),T=n(e),w=a(e,"P",{}),b(w).forEach(s),C=n(e),d(R.$$.fragment,e),x=n(e),I=a(e,"P",{"data-svelte-h":!0}),l(I)!=="svelte-fqtivw"&&(I.innerHTML=aa),To=n(e),we=a(e,"P",{"data-svelte-h":!0}),l(we)!=="svelte-1mkssuw"&&(we.innerHTML=sa),Ro=n(e),d(Ce.$$.fragment,e),Io=n(e),i=a(e,"DIV",{class:!0});var c=b(i);d(ke.$$.fragment,c),Cn=n(c),vt=a(c,"P",{"data-svelte-h":!0}),l(vt)!=="svelte-sfljep"&&(vt.textContent=ia),kn=n(c),yt=a(c,"P",{"data-svelte-h":!0}),l(yt)!=="svelte-130r937"&&(yt.textContent=ca),Tn=n(c),d(Q.$$.fragment,c),Rn=n(c),M=a(c,"DIV",{class:!0});var j=b(M);d(Te.$$.fragment,j),In=n(j),$t=a(j,"P",{"data-svelte-h":!0}),l($t)!=="svelte-u91m2x"&&($t.textContent=la),Dn=n(j),xt=a(j,"P",{"data-svelte-h":!0}),l(xt)!=="svelte-1qltdmq"&&(xt.innerHTML=ga),Mn=n(j),wt=a(j,"P",{"data-svelte-h":!0}),l(wt)!=="svelte-1rccgws"&&(wt.innerHTML=pa),j.forEach(s),Ln=n(c),Z=a(c,"DIV",{class:!0});var bt=b(Z);d(Re.$$.fragment,bt),En=n(bt),Ct=a(bt,"P",{"data-svelte-h":!0}),l(Ct)!=="svelte-1931o36"&&(Ct.textContent=da),bt.forEach(s),Pn=n(c),L=a(c,"DIV",{class:!0});var U=b(L);d(Ie.$$.fragment,U),jn=n(U),kt=a(U,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-63n9b3"&&(kt.textContent=ha),Un=n(U),Tt=a(U,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-1mgqvlx"&&(Tt.textContent=ua),Hn=n(U),Rt=a(U,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-10sq8kk"&&(Rt.textContent=ma),U.forEach(s),Jn=n(c),X=a(c,"DIV",{class:!0});var Oo=b(X);d(De.$$.fragment,Oo),Vn=n(Oo),It=a(Oo,"P",{"data-svelte-h":!0}),l(It)!=="svelte-1xz8ip4"&&(It.textContent=fa),Oo.forEach(s),Fn=n(c),K=a(c,"DIV",{class:!0});var Go=b(K);d(Me.$$.fragment,Go),Nn=n(Go),Dt=a(Go,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-gpfomi"&&(Dt.textContent=_a),Go.forEach(s),qn=n(c),Y=a(c,"DIV",{class:!0});var zo=b(Y);d(Le.$$.fragment,zo),Wn=n(zo),Mt=a(zo,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-i6ef2h"&&(Mt.innerHTML=ba),zo.forEach(s),Bn=n(c),E=a(c,"DIV",{class:!0});var xe=b(E);d(Ee.$$.fragment,xe),Sn=n(xe),Lt=a(xe,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-yrpdu4"&&(Lt.textContent=va),An=n(xe),Et=a(xe,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-kcbb31"&&(Et.textContent=ya),On=n(xe),d(ee.$$.fragment,xe),xe.forEach(s),Gn=n(c),J=a(c,"DIV",{class:!0});var vo=b(J);d(Pe.$$.fragment,vo),zn=n(vo),Pt=a(vo,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-srmdei"&&(Pt.innerHTML=$a),Qn=n(vo),d(te.$$.fragment,vo),vo.forEach(s),Zn=n(c),oe=a(c,"DIV",{class:!0});var Qo=b(oe);d(je.$$.fragment,Qo),Xn=n(Qo),jt=a(Qo,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-x8sm21"&&(jt.textContent=xa),Qo.forEach(s),Kn=n(c),V=a(c,"DIV",{class:!0});var yo=b(V);d(Ue.$$.fragment,yo),Yn=n(yo),Ut=a(yo,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-1eaw53"&&(Ut.textContent=wa),er=n(yo),Ht=a(yo,"P",{"data-svelte-h":!0}),l(Ht)!=="svelte-1gwi68h"&&(Ht.innerHTML=Ca),yo.forEach(s),tr=n(c),F=a(c,"DIV",{class:!0});var $o=b(F);d(He.$$.fragment,$o),or=n($o),Jt=a($o,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-fr7o3n"&&(Jt.textContent=ka),nr=n($o),Vt=a($o,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-1f8uww9"&&(Vt.innerHTML=Ta),$o.forEach(s),rr=n(c),ne=a(c,"DIV",{class:!0});var Zo=b(ne);d(Je.$$.fragment,Zo),ar=n(Zo),Ft=a(Zo,"P",{"data-svelte-h":!0}),l(Ft)!=="svelte-10kdqwr"&&(Ft.textContent=Ra),Zo.forEach(s),sr=n(c),re=a(c,"DIV",{class:!0});var Xo=b(re);d(Ve.$$.fragment,Xo),ir=n(Xo),Nt=a(Xo,"P",{"data-svelte-h":!0}),l(Nt)!=="svelte-1jc3bks"&&(Nt.textContent=Ia),Xo.forEach(s),cr=n(c),ae=a(c,"DIV",{class:!0});var Ko=b(ae);d(Fe.$$.fragment,Ko),lr=n(Ko),qt=a(Ko,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-1pc1msi"&&(qt.innerHTML=Da),Ko.forEach(s),gr=n(c),se=a(c,"DIV",{class:!0});var Yo=b(se);d(Ne.$$.fragment,Yo),pr=n(Yo),Wt=a(Yo,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1v7pd4y"&&(Wt.textContent=Ma),Yo.forEach(s),dr=n(c),ie=a(c,"DIV",{class:!0});var en=b(ie);d(qe.$$.fragment,en),hr=n(en),Bt=a(en,"P",{"data-svelte-h":!0}),l(Bt)!=="svelte-vce47s"&&(Bt.textContent=La),en.forEach(s),ur=n(c),ce=a(c,"DIV",{class:!0});var tn=b(ce);d(We.$$.fragment,tn),mr=n(tn),St=a(tn,"P",{"data-svelte-h":!0}),l(St)!=="svelte-14r2tu1"&&(St.textContent=Ea),tn.forEach(s),fr=n(c),N=a(c,"DIV",{class:!0});var xo=b(N);d(Be.$$.fragment,xo),_r=n(xo),At=a(xo,"P",{"data-svelte-h":!0}),l(At)!=="svelte-7q6b1s"&&(At.textContent=Pa),br=n(xo),Ot=a(xo,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-13r9fow"&&(Ot.innerHTML=ja),xo.forEach(s),vr=n(c),le=a(c,"DIV",{class:!0});var on=b(le);d(Se.$$.fragment,on),yr=n(on),Gt=a(on,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-1gemtfc"&&(Gt.textContent=Ua),on.forEach(s),$r=n(c),ge=a(c,"DIV",{class:!0});var nn=b(ge);d(Ae.$$.fragment,nn),xr=n(nn),zt=a(nn,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-1szkij9"&&(zt.textContent=Ha),nn.forEach(s),wr=n(c),pe=a(c,"DIV",{class:!0});var rn=b(pe);d(Oe.$$.fragment,rn),Cr=n(rn),Qt=a(rn,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-ywq4p5"&&(Qt.textContent=Ja),rn.forEach(s),kr=n(c),de=a(c,"DIV",{class:!0});var an=b(de);d(Ge.$$.fragment,an),Tr=n(an),Zt=a(an,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-o0hw73"&&(Zt.textContent=Va),an.forEach(s),Rr=n(c),q=a(c,"DIV",{class:!0});var wo=b(q);d(ze.$$.fragment,wo),Ir=n(wo),Xt=a(wo,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-rew8wo"&&(Xt.textContent=Fa),Dr=n(wo),Kt=a(wo,"P",{"data-svelte-h":!0}),l(Kt)!=="svelte-9edfgw"&&(Kt.innerHTML=Na),wo.forEach(s),Mr=n(c),he=a(c,"DIV",{class:!0});var sn=b(he);d(Qe.$$.fragment,sn),Lr=n(sn),Yt=a(sn,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-un1lv4"&&(Yt.textContent=qa),sn.forEach(s),Er=n(c),ue=a(c,"DIV",{class:!0});var cn=b(ue);d(Ze.$$.fragment,cn),Pr=n(cn),eo=a(cn,"P",{"data-svelte-h":!0}),l(eo)!=="svelte-1i0xpsk"&&(eo.textContent=Wa),cn.forEach(s),jr=n(c),me=a(c,"DIV",{class:!0});var ln=b(me);d(Xe.$$.fragment,ln),Ur=n(ln),to=a(ln,"P",{"data-svelte-h":!0}),l(to)!=="svelte-jqquke"&&(to.textContent=Ba),ln.forEach(s),Hr=n(c),fe=a(c,"DIV",{class:!0});var gn=b(fe);d(Ke.$$.fragment,gn),Jr=n(gn),oo=a(gn,"P",{"data-svelte-h":!0}),l(oo)!=="svelte-j7abay"&&(oo.textContent=Sa),gn.forEach(s),Vr=n(c),_e=a(c,"DIV",{class:!0});var pn=b(_e);d(Ye.$$.fragment,pn),Fr=n(pn),no=a(pn,"P",{"data-svelte-h":!0}),l(no)!=="svelte-11wx7zp"&&(no.textContent=Aa),pn.forEach(s),c.forEach(s),Do=n(e),d(et.$$.fragment,e),Mo=n(e),W=a(e,"DIV",{class:!0});var dn=b(W);d(tt.$$.fragment,dn),Nr=n(dn),ro=a(dn,"P",{"data-svelte-h":!0}),l(ro)!=="svelte-5hpmfd"&&(ro.textContent=Oa),dn.forEach(s),Lo=n(e),B=a(e,"DIV",{class:!0});var hn=b(B);d(ot.$$.fragment,hn),qr=n(hn),ao=a(hn,"P",{"data-svelte-h":!0}),l(ao)!=="svelte-1d1mfv5"&&(ao.textContent=Ga),hn.forEach(s),Eo=n(e),S=a(e,"DIV",{class:!0});var un=b(S);d(nt.$$.fragment,un),Wr=n(un),so=a(un,"P",{"data-svelte-h":!0}),l(so)!=="svelte-oqtt44"&&(so.textContent=za),un.forEach(s),Po=n(e),A=a(e,"DIV",{class:!0});var mn=b(A);d(rt.$$.fragment,mn),Br=n(mn),io=a(mn,"P",{"data-svelte-h":!0}),l(io)!=="svelte-1jg2eg8"&&(io.textContent=Qa),mn.forEach(s),jo=n(e),O=a(e,"DIV",{class:!0});var fn=b(O);d(at.$$.fragment,fn),Sr=n(fn),co=a(fn,"P",{"data-svelte-h":!0}),l(co)!=="svelte-97mwvc"&&(co.textContent=Za),fn.forEach(s),Uo=n(e),G=a(e,"DIV",{class:!0});var _n=b(G);d(st.$$.fragment,_n),Ar=n(_n),lo=a(_n,"P",{"data-svelte-h":!0}),l(lo)!=="svelte-vpsey2"&&(lo.textContent=Xa),_n.forEach(s),Ho=n(e),P=a(e,"DIV",{class:!0});var Co=b(P);d(it.$$.fragment,Co),Or=n(Co),go=a(Co,"P",{"data-svelte-h":!0}),l(go)!=="svelte-18uhass"&&(go.textContent=Ka),Gr=n(Co),po=a(Co,"P",{"data-svelte-h":!0}),l(po)!=="svelte-zq2g9v"&&(po.textContent=Ya),Co.forEach(s),Jo=n(e),d(ct.$$.fragment,e),Vo=n(e),lt=a(e,"P",{"data-svelte-h":!0}),l(lt)!=="svelte-1w5vmm6"&&(lt.innerHTML=es),Fo=n(e),gt=a(e,"UL",{"data-svelte-h":!0}),l(gt)!=="svelte-1dzo48z"&&(gt.innerHTML=ts),No=n(e),pt=a(e,"P",{"data-svelte-h":!0}),l(pt)!=="svelte-1k7k7po"&&(pt.textContent=os),qo=n(e),k=a(e,"DIV",{class:!0});var D=b(k);d(dt.$$.fragment,D),zr=n(D),ho=a(D,"P",{"data-svelte-h":!0}),l(ho)!=="svelte-sfljep"&&(ho.textContent=ns),Qr=n(D),uo=a(D,"P",{"data-svelte-h":!0}),l(uo)!=="svelte-130r937"&&(uo.textContent=rs),Zr=n(D),d(be.$$.fragment,D),Xr=n(D),ve=a(D,"DIV",{class:!0});var bn=b(ve);d(ht.$$.fragment,bn),Kr=n(bn),mo=a(bn,"P",{"data-svelte-h":!0}),l(mo)!=="svelte-1qshjwq"&&(mo.textContent=as),bn.forEach(s),Yr=n(D),ye=a(D,"DIV",{class:!0});var vn=b(ye);d(ut.$$.fragment,vn),ea=n(vn),fo=a(vn,"P",{"data-svelte-h":!0}),l(fo)!=="svelte-54rv4h"&&(fo.textContent=ss),vn.forEach(s),ta=n(D),$e=a(D,"DIV",{class:!0});var yn=b($e);d(mt.$$.fragment,yn),oa=n(yn),_o=a(yn,"P",{"data-svelte-h":!0}),l(_o)!=="svelte-11wx7zp"&&(_o.textContent=is),yn.forEach(s),D.forEach(s),Wo=n(e),z=a(e,"DIV",{class:!0});var $n=b(z);d(ft.$$.fragment,$n),na=n($n),bo=a($n,"P",{"data-svelte-h":!0}),l(bo)!=="svelte-1na97wh"&&(bo.textContent=cs),$n.forEach(s),Bo=n(e),d(_t.$$.fragment,e),So=n(e),ko=a(e,"P",{}),b(ko).forEach(s),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",xs),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,g){t(document.head,y),_(e,T,g),_(e,w,g),_(e,C,g),h(R,e,g),_(e,x,g),_(e,I,g),_(e,To,g),_(e,we,g),_(e,Ro,g),h(Ce,e,g),_(e,Io,g),_(e,i,g),h(ke,i,null),t(i,Cn),t(i,vt),t(i,kn),t(i,yt),t(i,Tn),h(Q,i,null),t(i,Rn),t(i,M),h(Te,M,null),t(M,In),t(M,$t),t(M,Dn),t(M,xt),t(M,Mn),t(M,wt),t(i,Ln),t(i,Z),h(Re,Z,null),t(Z,En),t(Z,Ct),t(i,Pn),t(i,L),h(Ie,L,null),t(L,jn),t(L,kt),t(L,Un),t(L,Tt),t(L,Hn),t(L,Rt),t(i,Jn),t(i,X),h(De,X,null),t(X,Vn),t(X,It),t(i,Fn),t(i,K),h(Me,K,null),t(K,Nn),t(K,Dt),t(i,qn),t(i,Y),h(Le,Y,null),t(Y,Wn),t(Y,Mt),t(i,Bn),t(i,E),h(Ee,E,null),t(E,Sn),t(E,Lt),t(E,An),t(E,Et),t(E,On),h(ee,E,null),t(i,Gn),t(i,J),h(Pe,J,null),t(J,zn),t(J,Pt),t(J,Qn),h(te,J,null),t(i,Zn),t(i,oe),h(je,oe,null),t(oe,Xn),t(oe,jt),t(i,Kn),t(i,V),h(Ue,V,null),t(V,Yn),t(V,Ut),t(V,er),t(V,Ht),t(i,tr),t(i,F),h(He,F,null),t(F,or),t(F,Jt),t(F,nr),t(F,Vt),t(i,rr),t(i,ne),h(Je,ne,null),t(ne,ar),t(ne,Ft),t(i,sr),t(i,re),h(Ve,re,null),t(re,ir),t(re,Nt),t(i,cr),t(i,ae),h(Fe,ae,null),t(ae,lr),t(ae,qt),t(i,gr),t(i,se),h(Ne,se,null),t(se,pr),t(se,Wt),t(i,dr),t(i,ie),h(qe,ie,null),t(ie,hr),t(ie,Bt),t(i,ur),t(i,ce),h(We,ce,null),t(ce,mr),t(ce,St),t(i,fr),t(i,N),h(Be,N,null),t(N,_r),t(N,At),t(N,br),t(N,Ot),t(i,vr),t(i,le),h(Se,le,null),t(le,yr),t(le,Gt),t(i,$r),t(i,ge),h(Ae,ge,null),t(ge,xr),t(ge,zt),t(i,wr),t(i,pe),h(Oe,pe,null),t(pe,Cr),t(pe,Qt),t(i,kr),t(i,de),h(Ge,de,null),t(de,Tr),t(de,Zt),t(i,Rr),t(i,q),h(ze,q,null),t(q,Ir),t(q,Xt),t(q,Dr),t(q,Kt),t(i,Mr),t(i,he),h(Qe,he,null),t(he,Lr),t(he,Yt),t(i,Er),t(i,ue),h(Ze,ue,null),t(ue,Pr),t(ue,eo),t(i,jr),t(i,me),h(Xe,me,null),t(me,Ur),t(me,to),t(i,Hr),t(i,fe),h(Ke,fe,null),t(fe,Jr),t(fe,oo),t(i,Vr),t(i,_e),h(Ye,_e,null),t(_e,Fr),t(_e,no),_(e,Do,g),h(et,e,g),_(e,Mo,g),_(e,W,g),h(tt,W,null),t(W,Nr),t(W,ro),_(e,Lo,g),_(e,B,g),h(ot,B,null),t(B,qr),t(B,ao),_(e,Eo,g),_(e,S,g),h(nt,S,null),t(S,Wr),t(S,so),_(e,Po,g),_(e,A,g),h(rt,A,null),t(A,Br),t(A,io),_(e,jo,g),_(e,O,g),h(at,O,null),t(O,Sr),t(O,co),_(e,Uo,g),_(e,G,g),h(st,G,null),t(G,Ar),t(G,lo),_(e,Ho,g),_(e,P,g),h(it,P,null),t(P,Or),t(P,go),t(P,Gr),t(P,po),_(e,Jo,g),h(ct,e,g),_(e,Vo,g),_(e,lt,g),_(e,Fo,g),_(e,gt,g),_(e,No,g),_(e,pt,g),_(e,qo,g),_(e,k,g),h(dt,k,null),t(k,zr),t(k,ho),t(k,Qr),t(k,uo),t(k,Zr),h(be,k,null),t(k,Xr),t(k,ve),h(ht,ve,null),t(ve,Kr),t(ve,mo),t(k,Yr),t(k,ye),h(ut,ye,null),t(ye,ea),t(ye,fo),t(k,ta),t(k,$e),h(mt,$e,null),t($e,oa),t($e,_o),_(e,Wo,g),_(e,z,g),h(ft,z,null),t(z,na),t(z,bo),_(e,Bo,g),h(_t,e,g),_(e,So,g),_(e,ko,g),Ao=!0},p(e,[g]){const c={};g&2&&(c.$$scope={dirty:g,ctx:e}),Q.$set(c);const j={};g&2&&(j.$$scope={dirty:g,ctx:e}),ee.$set(j);const bt={};g&2&&(bt.$$scope={dirty:g,ctx:e}),te.$set(bt);const U={};g&2&&(U.$$scope={dirty:g,ctx:e}),be.$set(U)},i(e){Ao||(u(R.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Q.$$.fragment,e),u(Te.$$.fragment,e),u(Re.$$.fragment,e),u(Ie.$$.fragment,e),u(De.$$.fragment,e),u(Me.$$.fragment,e),u(Le.$$.fragment,e),u(Ee.$$.fragment,e),u(ee.$$.fragment,e),u(Pe.$$.fragment,e),u(te.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(He.$$.fragment,e),u(Je.$$.fragment,e),u(Ve.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(Ge.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(ct.$$.fragment,e),u(dt.$$.fragment,e),u(be.$$.fragment,e),u(ht.$$.fragment,e),u(ut.$$.fragment,e),u(mt.$$.fragment,e),u(ft.$$.fragment,e),u(_t.$$.fragment,e),Ao=!0)},o(e){m(R.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),m(Q.$$.fragment,e),m(Te.$$.fragment,e),m(Re.$$.fragment,e),m(Ie.$$.fragment,e),m(De.$$.fragment,e),m(Me.$$.fragment,e),m(Le.$$.fragment,e),m(Ee.$$.fragment,e),m(ee.$$.fragment,e),m(Pe.$$.fragment,e),m(te.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Je.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(Ne.$$.fragment,e),m(qe.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Oe.$$.fragment,e),m(Ge.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ze.$$.fragment,e),m(Xe.$$.fragment,e),m(Ke.$$.fragment,e),m(Ye.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(ot.$$.fragment,e),m(nt.$$.fragment,e),m(rt.$$.fragment,e),m(at.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(ct.$$.fragment,e),m(dt.$$.fragment,e),m(be.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(mt.$$.fragment,e),m(ft.$$.fragment,e),m(_t.$$.fragment,e),Ao=!1},d(e){e&&(s(T),s(w),s(C),s(x),s(I),s(To),s(we),s(Ro),s(Io),s(i),s(Do),s(Mo),s(W),s(Lo),s(B),s(Eo),s(S),s(Po),s(A),s(jo),s(O),s(Uo),s(G),s(Ho),s(P),s(Jo),s(Vo),s(lt),s(Fo),s(gt),s(No),s(pt),s(qo),s(k),s(Wo),s(z),s(Bo),s(So),s(ko)),s(y),f(R,e),f(Ce,e),f(ke),f(Q),f(Te),f(Re),f(Ie),f(De),f(Me),f(Le),f(Ee),f(ee),f(Pe),f(te),f(je),f(Ue),f(He),f(Je),f(Ve),f(Fe),f(Ne),f(qe),f(We),f(Be),f(Se),f(Ae),f(Oe),f(Ge),f(ze),f(Qe),f(Ze),f(Xe),f(Ke),f(Ye),f(et,e),f(tt),f(ot),f(nt),f(rt),f(at),f(st),f(it),f(ct,e),f(dt),f(be),f(ht),f(ut),f(mt),f(ft),f(_t,e)}}}const xs='{"title":"Managing local and online repositories","local":"managing-local-and-online-repositories","sections":[{"title":"The Repository class","local":"huggingface_hub.Repository","sections":[],"depth":2},{"title":"Helper methods","local":"huggingface_hub.repository.is_git_repo","sections":[],"depth":2},{"title":"Following asynchronous commands","local":"huggingface_hub.Repository","sections":[],"depth":2}],"depth":1}';function ws(H){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends ps{constructor(y){super(),ds(this,y,ws,$s,ls,{})}}export{Ls as component};
