import{s as hl,n as Jl,o as Ml}from"../chunks/scheduler.7bc62968.js";import{S as Tl,i as ul,g as p,s as t,r as o,A as wl,h as i,f as a,c as n,j as ol,u as c,x as u,k as cl,y as rl,a as e,v as h,d as J,t as M,w as T}from"../chunks/index.66556066.js";import{C as ss}from"../chunks/CodeBlock.5372f996.js";import{H as w,E as jl}from"../chunks/index.c085705e.js";function dl(Fs){let r,es,ls,ts,j,ns,d,Ls="Official utilities to use the Hugging Face Hub API.",ps,y,is,m,os,f,cs,g,hs,U,Js,b,Ss='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',Ms,I,Xs='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',Ts,B,us,C,ws,Z,qs='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',rs,$,zs="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",js,k,ds,G,As='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',ys,N,ms,W,Ds='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',fs,v,gs,E,Ps="You can get the list of cached repositories using the <code>scanCacheDir</code> function.",Us,R,bs,V,Ks="Note: this does not work in the browser",Is,Q,Bs,Y,Os="You can cache a file of a repository using the <code>downloadFileToCacheDir</code> function.",Cs,_,Zs,x,sl="Note: this does not work in the browser",$s,H,ks,F,ll="You can download an entire repository at a given revision in the cache directory using the <code>snapshotDownload</code> function.",Gs,L,Ns,S,al="The code use internally the <code>downloadFileToCacheDir</code> function.",Ws,X,el="Note: this does not work in the browser",vs,q,Es,z,tl="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",Rs,A,nl="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",Vs,D,pl="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",Qs,P,Ys,K,il="<li><code>@huggingface/tasks</code> : Typings only</li> <li><code>@huggingface/lz4</code> : URL join utility</li>",_s,O,xs,as,Hs;return j=new w({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),y=new w({props:{title:"Install",local:"install",headingTag:"h2"}}),m=new ss({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),f=new w({props:{title:"Deno",local:"deno",headingTag:"h3"}}),g=new ss({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),U=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),B=new ss({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Local folder URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./models&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),C=new w({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),k=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),N=new w({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),v=new w({props:{title:"scanCacheDir",local:"scancachedir",headingTag:"h3"}}),R=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),Q=new w({props:{title:"downloadFileToCacheDir",local:"downloadfiletocachedir",headingTag:"h3"}}),_=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZmlsZSUyMCUzRCUyMGF3YWl0JTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciglN0IlMEElMjAlMjByZXBvJTNBJTIwJ2ZvbyUyRmJhciclMkMlMEElMjAlMjBwYXRoJTNBJTIwJ1JFQURNRS5tZCclMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coZmlsZSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { downloadFileToCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> file = <span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFileToCacheDir</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
  <span class="hljs-attr">path</span>: <span class="hljs-string">&#x27;README.md&#x27;</span>
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(file);`,wrap:!1}}),H=new w({props:{title:"snapshotDownload",local:"snapshotdownload",headingTag:"h3"}}),L=new ss({props:{code:"aW1wb3J0JTIwJTdCJTIwc25hcHNob3REb3dubG9hZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZGlyZWN0b3J5JTIwJTNEJTIwYXdhaXQlMjBzbmFwc2hvdERvd25sb2FkKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAnZm9vJTJGYmFyJyUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhkaXJlY3RvcnkpJTNC",highlighted:`<span class="hljs-keyword">import</span> { snapshotDownload } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> directory = <span class="hljs-keyword">await</span> <span class="hljs-title function_">snapshotDownload</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(directory);`,wrap:!1}}),q=new w({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),P=new w({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),O=new jl({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){r=p("meta"),es=t(),ls=p("p"),ts=t(),o(j.$$.fragment),ns=t(),d=p("p"),d.textContent=Ls,ps=t(),o(y.$$.fragment),is=t(),o(m.$$.fragment),os=t(),o(f.$$.fragment),cs=t(),o(g.$$.fragment),hs=t(),o(U.$$.fragment),Js=t(),b=p("p"),b.innerHTML=Ss,Ms=t(),I=p("p"),I.innerHTML=Xs,Ts=t(),o(B.$$.fragment),us=t(),o(C.$$.fragment),ws=t(),Z=p("p"),Z.innerHTML=qs,rs=t(),$=p("p"),$.textContent=zs,js=t(),o(k.$$.fragment),ds=t(),G=p("p"),G.innerHTML=As,ys=t(),o(N.$$.fragment),ms=t(),W=p("p"),W.innerHTML=Ds,fs=t(),o(v.$$.fragment),gs=t(),E=p("p"),E.innerHTML=Ps,Us=t(),o(R.$$.fragment),bs=t(),V=p("p"),V.textContent=Ks,Is=t(),o(Q.$$.fragment),Bs=t(),Y=p("p"),Y.innerHTML=Os,Cs=t(),o(_.$$.fragment),Zs=t(),x=p("p"),x.textContent=sl,$s=t(),o(H.$$.fragment),ks=t(),F=p("p"),F.innerHTML=ll,Gs=t(),o(L.$$.fragment),Ns=t(),S=p("p"),S.innerHTML=al,Ws=t(),X=p("p"),X.textContent=el,vs=t(),o(q.$$.fragment),Es=t(),z=p("p"),z.innerHTML=tl,Rs=t(),A=p("p"),A.innerHTML=nl,Vs=t(),D=p("p"),D.innerHTML=pl,Qs=t(),o(P.$$.fragment),Ys=t(),K=p("ul"),K.innerHTML=il,_s=t(),o(O.$$.fragment),xs=t(),as=p("p"),this.h()},l(s){const l=wl("svelte-u9bgzb",document.head);r=i(l,"META",{name:!0,content:!0}),l.forEach(a),es=n(s),ls=i(s,"P",{}),ol(ls).forEach(a),ts=n(s),c(j.$$.fragment,s),ns=n(s),d=i(s,"P",{"data-svelte-h":!0}),u(d)!=="svelte-a2asrt"&&(d.textContent=Ls),ps=n(s),c(y.$$.fragment,s),is=n(s),c(m.$$.fragment,s),os=n(s),c(f.$$.fragment,s),cs=n(s),c(g.$$.fragment,s),hs=n(s),c(U.$$.fragment,s),Js=n(s),b=i(s,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1nqczoz"&&(b.innerHTML=Ss),Ms=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6ptpin"&&(I.innerHTML=Xs),Ts=n(s),c(B.$$.fragment,s),us=n(s),c(C.$$.fragment,s),ws=n(s),Z=i(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-bfok93"&&(Z.innerHTML=qs),rs=n(s),$=i(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-1az135e"&&($.textContent=zs),js=n(s),c(k.$$.fragment,s),ds=n(s),G=i(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1qsa6tj"&&(G.innerHTML=As),ys=n(s),c(N.$$.fragment,s),ms=n(s),W=i(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-8xjlck"&&(W.innerHTML=Ds),fs=n(s),c(v.$$.fragment,s),gs=n(s),E=i(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1s5ry35"&&(E.innerHTML=Ps),Us=n(s),c(R.$$.fragment,s),bs=n(s),V=i(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-zyh43t"&&(V.textContent=Ks),Is=n(s),c(Q.$$.fragment,s),Bs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1ucnuxi"&&(Y.innerHTML=Os),Cs=n(s),c(_.$$.fragment,s),Zs=n(s),x=i(s,"P",{"data-svelte-h":!0}),u(x)!=="svelte-zyh43t"&&(x.textContent=sl),$s=n(s),c(H.$$.fragment,s),ks=n(s),F=i(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1yti9iu"&&(F.innerHTML=ll),Gs=n(s),c(L.$$.fragment,s),Ns=n(s),S=i(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-809o1h"&&(S.innerHTML=al),Ws=n(s),X=i(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-zyh43t"&&(X.textContent=el),vs=n(s),c(q.$$.fragment,s),Es=n(s),z=i(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1gspubq"&&(z.innerHTML=tl),Rs=n(s),A=i(s,"P",{"data-svelte-h":!0}),u(A)!=="svelte-em0etc"&&(A.innerHTML=nl),Vs=n(s),D=i(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-lja874"&&(D.innerHTML=pl),Qs=n(s),c(P.$$.fragment,s),Ys=n(s),K=i(s,"UL",{"data-svelte-h":!0}),u(K)!=="svelte-3axdjj"&&(K.innerHTML=il),_s=n(s),c(O.$$.fragment,s),xs=n(s),as=i(s,"P",{}),ol(as).forEach(a),this.h()},h(){cl(r,"name","hf:doc:metadata"),cl(r,"content",yl)},m(s,l){rl(document.head,r),e(s,es,l),e(s,ls,l),e(s,ts,l),h(j,s,l),e(s,ns,l),e(s,d,l),e(s,ps,l),h(y,s,l),e(s,is,l),h(m,s,l),e(s,os,l),h(f,s,l),e(s,cs,l),h(g,s,l),e(s,hs,l),h(U,s,l),e(s,Js,l),e(s,b,l),e(s,Ms,l),e(s,I,l),e(s,Ts,l),h(B,s,l),e(s,us,l),h(C,s,l),e(s,ws,l),e(s,Z,l),e(s,rs,l),e(s,$,l),e(s,js,l),h(k,s,l),e(s,ds,l),e(s,G,l),e(s,ys,l),h(N,s,l),e(s,ms,l),e(s,W,l),e(s,fs,l),h(v,s,l),e(s,gs,l),e(s,E,l),e(s,Us,l),h(R,s,l),e(s,bs,l),e(s,V,l),e(s,Is,l),h(Q,s,l),e(s,Bs,l),e(s,Y,l),e(s,Cs,l),h(_,s,l),e(s,Zs,l),e(s,x,l),e(s,$s,l),h(H,s,l),e(s,ks,l),e(s,F,l),e(s,Gs,l),h(L,s,l),e(s,Ns,l),e(s,S,l),e(s,Ws,l),e(s,X,l),e(s,vs,l),h(q,s,l),e(s,Es,l),e(s,z,l),e(s,Rs,l),e(s,A,l),e(s,Vs,l),e(s,D,l),e(s,Qs,l),h(P,s,l),e(s,Ys,l),e(s,K,l),e(s,_s,l),h(O,s,l),e(s,xs,l),e(s,as,l),Hs=!0},p:Jl,i(s){Hs||(J(j.$$.fragment,s),J(y.$$.fragment,s),J(m.$$.fragment,s),J(f.$$.fragment,s),J(g.$$.fragment,s),J(U.$$.fragment,s),J(B.$$.fragment,s),J(C.$$.fragment,s),J(k.$$.fragment,s),J(N.$$.fragment,s),J(v.$$.fragment,s),J(R.$$.fragment,s),J(Q.$$.fragment,s),J(_.$$.fragment,s),J(H.$$.fragment,s),J(L.$$.fragment,s),J(q.$$.fragment,s),J(P.$$.fragment,s),J(O.$$.fragment,s),Hs=!0)},o(s){M(j.$$.fragment,s),M(y.$$.fragment,s),M(m.$$.fragment,s),M(f.$$.fragment,s),M(g.$$.fragment,s),M(U.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(v.$$.fragment,s),M(R.$$.fragment,s),M(Q.$$.fragment,s),M(_.$$.fragment,s),M(H.$$.fragment,s),M(L.$$.fragment,s),M(q.$$.fragment,s),M(P.$$.fragment,s),M(O.$$.fragment,s),Hs=!1},d(s){s&&(a(es),a(ls),a(ts),a(ns),a(d),a(ps),a(is),a(os),a(cs),a(hs),a(Js),a(b),a(Ms),a(I),a(Ts),a(us),a(ws),a(Z),a(rs),a($),a(js),a(ds),a(G),a(ys),a(ms),a(W),a(fs),a(gs),a(E),a(Us),a(bs),a(V),a(Is),a(Bs),a(Y),a(Cs),a(Zs),a(x),a($s),a(ks),a(F),a(Gs),a(Ns),a(S),a(Ws),a(X),a(vs),a(Es),a(z),a(Rs),a(A),a(Vs),a(D),a(Qs),a(Ys),a(K),a(_s),a(xs),a(as)),a(r),T(j,s),T(y,s),T(m,s),T(f,s),T(g,s),T(U,s),T(B,s),T(C,s),T(k,s),T(N,s),T(v,s),T(R,s),T(Q,s),T(_,s),T(H,s),T(L,s),T(q,s),T(P,s),T(O,s)}}}const yl='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[{"title":"scanCacheDir","local":"scancachedir","sections":[],"depth":3},{"title":"downloadFileToCacheDir","local":"downloadfiletocachedir","sections":[],"depth":3},{"title":"snapshotDownload","local":"snapshotdownload","sections":[],"depth":3}],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ml(Fs){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends Tl{constructor(r){super(),ul(this,r,ml,dl,hl,{})}}export{Il as component};
