import{s as Es,n as Os,o as Us}from"../chunks/scheduler.0219f8bd.js";import{S as Bs,i as Ks,g as s,s as o,r as p,A as qs,h as n,f as l,c as d,j as a,u as c,x as r,k as u,y as Ns,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.f61edf3b.js";import{H as _,E as Is}from"../chunks/EditOnGithub.48fa589f.js";function ks(md){let $,kt,Nt,St,v,Jt,T,Dt,g,bd='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',zt,y,_d='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..ModelSpecificPretrainedOptions"><code>~ModelSpecificPretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..PretrainedModelOptions"><code>~PretrainedModelOptions</code></a> : <code>*</code></li></ul></li></ul></li>',Wt,Vt,Yt,P,Gt,R,Qt,C,$d="Helper function to get a file, using either the Fetch API or FileSystem API.",Xt,M,vd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',Zt,H,Td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",el,tl,ll,L,il,x,ol,F,gd=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,dl,w,yd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',sl,A,Pd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",nl,j,Rd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",rl,E,Cd='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',ul,al,pl,O,cl,U,fl,B,Md='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',hl,ml,bl,K,_l,q,$l,N,Hd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',vl,Tl,gl,I,yl,k,Pl,S,Ld='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Rl,Cl,Ml,J,Hl,D,Ll,z,xd="Fetches a JSON file from a given path and file name.",xl,W,Fd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',Fl,V,wd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",wl,Y,Ad="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Al,jl,El,G,Ol,Q,Ul,X,jd='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Bl,Z,Ed='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Kl,ql,Nl,ee,Il,te,kl,le,Od="Creates a new <code>FileResponse</code> object.",Sl,ie,Ud="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",Jl,Dl,zl,oe,Wl,de,Vl,se,Bd=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,Yl,ne,Kd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Gl,Ql,Xl,re,Zl,ue,ei,ae,qd="Clone the current FileResponse object.",ti,pe,Nd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',li,ii,oi,ce,di,fe,si,he,Id=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,ni,me,kd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',ri,be,Sd="<li><code>Error</code> If the file cannot be read.</li>",ui,ai,pi,_e,ci,$e,fi,ve,Jd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,hi,Te,Dd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',mi,ge,zd="<li><code>Error</code> If the file cannot be read.</li>",bi,_i,$i,ye,vi,Pe,Ti,Re,Wd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,gi,Ce,Vd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',yi,Me,Yd="<li><code>Error</code> If the file cannot be read.</li>",Pi,Ri,Ci,He,Mi,Le,Hi,xe,Gd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Li,Fe,Qd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',xi,we,Xd="<li><code>Error</code> If the file cannot be read.</li>",Fi,wi,Ai,Ae,ji,je,Ei,Ee,Zd='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Oi,Oe,es='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',Ui,Bi,Ki,Ue,qi,Be,Ni,Ke,ts="Instantiate a <code>FileCache</code> object.",Ii,qe,ls="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",ki,Si,Ji,Ne,Di,Ie,zi,ke,is="Checks whether the given request is in the cache.",Wi,Se,os='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Vi,Je,ds="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",Yi,Gi,Qi,De,Xi,ze,Zi,We,ss="Adds the given response to the cache.",eo,Ve,ns='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',to,Ye,rs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",lo,io,oo,Ge,so,Qe,no,Xe,us="Mapping from file extensions to MIME types.",ro,Ze,as='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub"><code>utils/hub</code></a>',uo,ao,po,et,co,tt,fo,lt,ps="Determines whether the given string is a valid URL.",ho,it,cs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',mo,ot,fs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",bo,_o,$o,dt,vo,st,To,nt,hs="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",go,rt,ms='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',yo,ut,bs="<li><code>Error</code> If `fatal = false`.</li>",Po,at,_s="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",Ro,Co,Mo,pt,Ho,ct,Lo,ft,$s='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',xo,ht,vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",Fo,wo,Ao,mt,jo,bt,Eo,_t,Ts="Read and track progress when reading a Response object",Oo,$t,gs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Uo,vt,ys="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Bo,Ko,qo,Tt,No,gt,Io,yt,Ps="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",ko,Pt,Rs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',So,Rt,Cs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Jo,Do,zo,Ct,Wo,Mt,Vo,Ht,Ms="Options for loading a pretrained model.",Yo,Lt,Hs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',Go,xt,Ls=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[progress_callback]</td><td><code>function</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>*</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td></tr></tbody>`,Qo,Xo,Zo,Ft,ed,wt,td,At,xs="Options for loading a pretrained model.",ld,jt,Fs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',id,Et,ws=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[subfolder]</td><td><code>string</code></td><td><code>&quot;&#39;onnx&#39;&quot;</code></td><td><p>In case the relevant files are located inside a subfolder of the model repo on huggingface.co,
you can specify the folder name here.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td> </tr><tr><td>[device]</td><td><code>*</code></td><td><code></code></td><td><p>The device to run the model on. If not specified, the device will be chosen from the environment settings.</p></td> </tr><tr><td>[dtype]</td><td><code>*</code></td><td><code></code></td><td><p>The data type to use for the model. If not specified, the data type will be chosen from the environment settings.</p></td> </tr><tr><td>[use_external_data_format]</td><td><code>boolean</code> | <code>Record&lt;string, boolean&gt;</code></td><td><code>false</code></td><td><p>Whether to load the model using the external data format (used for models &gt;= 2GB in size).</p></td> </tr><tr><td>[session_options]</td><td><code>*</code></td><td></td><td><p>(Optional) User-specified session options passed to the runtime. If not provided, suitable defaults will be chosen.</p></td></tr></tbody>`,od,dd,sd,Ot,nd,Ut,rd,Bt,As="Options for loading a pretrained model.",ud,Kt,js='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',ad,pd,cd,qt,fd,It,hd;return T=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),R=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),x=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise--uint8array--code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),q=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),k=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),D=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),de=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),$e=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Pe=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),Le=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),je=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),Be=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),Ie=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),ze=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),Qe=new _({props:{title:"utils/hub~CONTENT_TYPE_MAP",local:"utilshubcontenttypemap",headingTag:"h2"}}),tt=new _({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),st=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),bt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),gt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Mt=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),wt=new _({props:{title:"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>",local:"utilshubmodelspecificpretrainedoptions--code-object-code",headingTag:"h2"}}),Ut=new _({props:{title:"utils/hub~PretrainedModelOptions : <code> * </code>",local:"utilshubpretrainedmodeloptions--code--code",headingTag:"h2"}}),qt=new Is({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){$=s("meta"),kt=o(),Nt=s("p"),St=o(),v=s("a"),Jt=o(),p(T.$$.fragment),Dt=o(),g=s("p"),g.innerHTML=bd,zt=o(),y=s("ul"),y.innerHTML=_d,Wt=o(),Vt=s("hr"),Yt=o(),P=s("a"),Gt=o(),p(R.$$.fragment),Qt=o(),C=s("p"),C.textContent=$d,Xt=o(),M=s("p"),M.innerHTML=vd,Zt=o(),H=s("table"),H.innerHTML=Td,el=o(),tl=s("hr"),ll=o(),L=s("a"),il=o(),p(x.$$.fragment),ol=o(),F=s("p"),F.innerHTML=gd,dl=o(),w=s("p"),w.innerHTML=yd,sl=o(),A=s("ul"),A.innerHTML=Pd,nl=o(),j=s("table"),j.innerHTML=Rd,rl=o(),E=s("ul"),E.innerHTML=Cd,ul=o(),al=s("hr"),pl=o(),O=s("a"),cl=o(),p(U.$$.fragment),fl=o(),B=s("p"),B.innerHTML=Md,hl=o(),ml=s("hr"),bl=o(),K=s("a"),_l=o(),p(q.$$.fragment),$l=o(),N=s("p"),N.innerHTML=Hd,vl=o(),Tl=s("hr"),gl=o(),I=s("a"),yl=o(),p(k.$$.fragment),Pl=o(),S=s("p"),S.innerHTML=Ld,Rl=o(),Cl=s("hr"),Ml=o(),J=s("a"),Hl=o(),p(D.$$.fragment),Ll=o(),z=s("p"),z.textContent=xd,xl=o(),W=s("p"),W.innerHTML=Fd,Fl=o(),V=s("ul"),V.innerHTML=wd,wl=o(),Y=s("table"),Y.innerHTML=Ad,Al=o(),jl=s("hr"),El=o(),G=s("a"),Ol=o(),p(Q.$$.fragment),Ul=o(),X=s("p"),X.innerHTML=jd,Bl=o(),Z=s("ul"),Z.innerHTML=Ed,Kl=o(),ql=s("hr"),Nl=o(),ee=s("a"),Il=o(),p(te.$$.fragment),kl=o(),le=s("p"),le.innerHTML=Od,Sl=o(),ie=s("table"),ie.innerHTML=Ud,Jl=o(),Dl=s("hr"),zl=o(),oe=s("a"),Wl=o(),p(de.$$.fragment),Vl=o(),se=s("p"),se.textContent=Bd,Yl=o(),ne=s("p"),ne.innerHTML=Kd,Gl=o(),Ql=s("hr"),Xl=o(),re=s("a"),Zl=o(),p(ue.$$.fragment),ei=o(),ae=s("p"),ae.textContent=qd,ti=o(),pe=s("p"),pe.innerHTML=Nd,li=o(),ii=s("hr"),oi=o(),ce=s("a"),di=o(),p(fe.$$.fragment),si=o(),he=s("p"),he.textContent=Id,ni=o(),me=s("p"),me.innerHTML=kd,ri=o(),be=s("ul"),be.innerHTML=Sd,ui=o(),ai=s("hr"),pi=o(),_e=s("a"),ci=o(),p($e.$$.fragment),fi=o(),ve=s("p"),ve.textContent=Jd,hi=o(),Te=s("p"),Te.innerHTML=Dd,mi=o(),ge=s("ul"),ge.innerHTML=zd,bi=o(),_i=s("hr"),$i=o(),ye=s("a"),vi=o(),p(Pe.$$.fragment),Ti=o(),Re=s("p"),Re.textContent=Wd,gi=o(),Ce=s("p"),Ce.innerHTML=Vd,yi=o(),Me=s("ul"),Me.innerHTML=Yd,Pi=o(),Ri=s("hr"),Ci=o(),He=s("a"),Mi=o(),p(Le.$$.fragment),Hi=o(),xe=s("p"),xe.textContent=Gd,Li=o(),Fe=s("p"),Fe.innerHTML=Qd,xi=o(),we=s("ul"),we.innerHTML=Xd,Fi=o(),wi=s("hr"),Ai=o(),Ae=s("a"),ji=o(),p(je.$$.fragment),Ei=o(),Ee=s("p"),Ee.innerHTML=Zd,Oi=o(),Oe=s("ul"),Oe.innerHTML=es,Ui=o(),Bi=s("hr"),Ki=o(),Ue=s("a"),qi=o(),p(Be.$$.fragment),Ni=o(),Ke=s("p"),Ke.innerHTML=ts,Ii=o(),qe=s("table"),qe.innerHTML=ls,ki=o(),Si=s("hr"),Ji=o(),Ne=s("a"),Di=o(),p(Ie.$$.fragment),zi=o(),ke=s("p"),ke.textContent=is,Wi=o(),Se=s("p"),Se.innerHTML=os,Vi=o(),Je=s("table"),Je.innerHTML=ds,Yi=o(),Gi=s("hr"),Qi=o(),De=s("a"),Xi=o(),p(ze.$$.fragment),Zi=o(),We=s("p"),We.textContent=ss,eo=o(),Ve=s("p"),Ve.innerHTML=ns,to=o(),Ye=s("table"),Ye.innerHTML=rs,lo=o(),io=s("hr"),oo=o(),Ge=s("a"),so=o(),p(Qe.$$.fragment),no=o(),Xe=s("p"),Xe.textContent=us,ro=o(),Ze=s("p"),Ze.innerHTML=as,uo=o(),ao=s("hr"),po=o(),et=s("a"),co=o(),p(tt.$$.fragment),fo=o(),lt=s("p"),lt.textContent=ps,ho=o(),it=s("p"),it.innerHTML=cs,mo=o(),ot=s("table"),ot.innerHTML=fs,bo=o(),_o=s("hr"),$o=o(),dt=s("a"),vo=o(),p(st.$$.fragment),To=o(),nt=s("p"),nt.textContent=hs,go=o(),rt=s("p"),rt.innerHTML=ms,yo=o(),ut=s("ul"),ut.innerHTML=bs,Po=o(),at=s("table"),at.innerHTML=_s,Ro=o(),Co=s("hr"),Mo=o(),pt=s("a"),Ho=o(),p(ct.$$.fragment),Lo=o(),ft=s("p"),ft.innerHTML=$s,xo=o(),ht=s("table"),ht.innerHTML=vs,Fo=o(),wo=s("hr"),Ao=o(),mt=s("a"),jo=o(),p(bt.$$.fragment),Eo=o(),_t=s("p"),_t.textContent=Ts,Oo=o(),$t=s("p"),$t.innerHTML=gs,Uo=o(),vt=s("table"),vt.innerHTML=ys,Bo=o(),Ko=s("hr"),qo=o(),Tt=s("a"),No=o(),p(gt.$$.fragment),Io=o(),yt=s("p"),yt.textContent=Ps,ko=o(),Pt=s("p"),Pt.innerHTML=Rs,So=o(),Rt=s("table"),Rt.innerHTML=Cs,Jo=o(),Do=s("hr"),zo=o(),Ct=s("a"),Wo=o(),p(Mt.$$.fragment),Vo=o(),Ht=s("p"),Ht.textContent=Ms,Yo=o(),Lt=s("p"),Lt.innerHTML=Hs,Go=o(),xt=s("table"),xt.innerHTML=Ls,Qo=o(),Xo=s("hr"),Zo=o(),Ft=s("a"),ed=o(),p(wt.$$.fragment),td=o(),At=s("p"),At.textContent=xs,ld=o(),jt=s("p"),jt.innerHTML=Fs,id=o(),Et=s("table"),Et.innerHTML=ws,od=o(),dd=s("hr"),sd=o(),Ot=s("a"),nd=o(),p(Ut.$$.fragment),rd=o(),Bt=s("p"),Bt.textContent=As,ud=o(),Kt=s("p"),Kt.innerHTML=js,ad=o(),pd=s("hr"),cd=o(),p(qt.$$.fragment),fd=o(),It=s("p"),this.h()},l(e){const t=qs("svelte-u9bgzb",document.head);$=n(t,"META",{name:!0,content:!0}),t.forEach(l),kt=d(e),Nt=n(e,"P",{}),a(Nt).forEach(l),St=d(e),v=n(e,"A",{id:!0,class:!0}),a(v).forEach(l),Jt=d(e),c(T.$$.fragment,e),Dt=d(e),g=n(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1jxl61c"&&(g.innerHTML=bd),zt=d(e),y=n(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-1qli3hk"&&(y.innerHTML=_d),Wt=d(e),Vt=n(e,"HR",{}),Yt=d(e),P=n(e,"A",{id:!0,class:!0}),a(P).forEach(l),Gt=d(e),c(R.$$.fragment,e),Qt=d(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10mshiw"&&(C.textContent=$d),Xt=d(e),M=n(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1jj7eze"&&(M.innerHTML=vd),Zt=d(e),H=n(e,"TABLE",{"data-svelte-h":!0}),r(H)!=="svelte-pbwhgs"&&(H.innerHTML=Td),el=d(e),tl=n(e,"HR",{}),ll=d(e),L=n(e,"A",{id:!0,class:!0}),a(L).forEach(l),il=d(e),c(x.$$.fragment,e),ol=d(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1l3bjq3"&&(F.innerHTML=gd),dl=d(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-11sljb4"&&(w.innerHTML=yd),sl=d(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=Pd),nl=d(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=Rd),rl=d(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-z767d8"&&(E.innerHTML=Cd),ul=d(e),al=n(e,"HR",{}),pl=d(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),cl=d(e),c(U.$$.fragment,e),fl=d(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=Md),hl=d(e),ml=n(e,"HR",{}),bl=d(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),_l=d(e),c(q.$$.fragment,e),$l=d(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ys3w38"&&(N.innerHTML=Hd),vl=d(e),Tl=n(e,"HR",{}),gl=d(e),I=n(e,"A",{id:!0,class:!0}),a(I).forEach(l),yl=d(e),c(k.$$.fragment,e),Pl=d(e),S=n(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ys3w38"&&(S.innerHTML=Ld),Rl=d(e),Cl=n(e,"HR",{}),Ml=d(e),J=n(e,"A",{id:!0,class:!0}),a(J).forEach(l),Hl=d(e),c(D.$$.fragment,e),Ll=d(e),z=n(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1en2wh4"&&(z.textContent=xd),xl=d(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1l5qo0i"&&(W.innerHTML=Fd),Fl=d(e),V=n(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-jl6z4b"&&(V.innerHTML=wd),wl=d(e),Y=n(e,"TABLE",{"data-svelte-h":!0}),r(Y)!=="svelte-1iel3tk"&&(Y.innerHTML=Ad),Al=d(e),jl=n(e,"HR",{}),El=d(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(l),Ol=d(e),c(Q.$$.fragment,e),Ul=d(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16uuos4"&&(X.innerHTML=jd),Bl=d(e),Z=n(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-olh855"&&(Z.innerHTML=Ed),Kl=d(e),ql=n(e,"HR",{}),Nl=d(e),ee=n(e,"A",{id:!0,class:!0}),a(ee).forEach(l),Il=d(e),c(te.$$.fragment,e),kl=d(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zzl0lp"&&(le.innerHTML=Od),Sl=d(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1y2k5ta"&&(ie.innerHTML=Ud),Jl=d(e),Dl=n(e,"HR",{}),zl=d(e),oe=n(e,"A",{id:!0,class:!0}),a(oe).forEach(l),Wl=d(e),c(de.$$.fragment,e),Vl=d(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1u1tjx3"&&(se.textContent=Bd),Yl=d(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1sowe6d"&&(ne.innerHTML=Kd),Gl=d(e),Ql=n(e,"HR",{}),Xl=d(e),re=n(e,"A",{id:!0,class:!0}),a(re).forEach(l),Zl=d(e),c(ue.$$.fragment,e),ei=d(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-d8j2xp"&&(ae.textContent=qd),ti=d(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-8jlahc"&&(pe.innerHTML=Nd),li=d(e),ii=n(e,"HR",{}),oi=d(e),ce=n(e,"A",{id:!0,class:!0}),a(ce).forEach(l),di=d(e),c(fe.$$.fragment,e),si=d(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1a8fecx"&&(he.textContent=Id),ni=d(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-v2f2ae"&&(me.innerHTML=kd),ri=d(e),be=n(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1f4f3jw"&&(be.innerHTML=Sd),ui=d(e),ai=n(e,"HR",{}),pi=d(e),_e=n(e,"A",{id:!0,class:!0}),a(_e).forEach(l),ci=d(e),c($e.$$.fragment,e),fi=d(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-h3zv97"&&(ve.textContent=Jd),hi=d(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1e723py"&&(Te.innerHTML=Dd),mi=d(e),ge=n(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-1f4f3jw"&&(ge.innerHTML=zd),bi=d(e),_i=n(e,"HR",{}),$i=d(e),ye=n(e,"A",{id:!0,class:!0}),a(ye).forEach(l),vi=d(e),c(Pe.$$.fragment,e),Ti=d(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-jd4zuh"&&(Re.textContent=Wd),gi=d(e),Ce=n(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ozy582"&&(Ce.innerHTML=Vd),yi=d(e),Me=n(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-1f4f3jw"&&(Me.innerHTML=Yd),Pi=d(e),Ri=n(e,"HR",{}),Ci=d(e),He=n(e,"A",{id:!0,class:!0}),a(He).forEach(l),Mi=d(e),c(Le.$$.fragment,e),Hi=d(e),xe=n(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-cd4397"&&(xe.textContent=Gd),Li=d(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-j83voe"&&(Fe.innerHTML=Qd),xi=d(e),we=n(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-1f4f3jw"&&(we.innerHTML=Xd),Fi=d(e),wi=n(e,"HR",{}),Ai=d(e),Ae=n(e,"A",{id:!0,class:!0}),a(Ae).forEach(l),ji=d(e),c(je.$$.fragment,e),Ei=d(e),Ee=n(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-16uuos4"&&(Ee.innerHTML=Zd),Oi=d(e),Oe=n(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-136j1yr"&&(Oe.innerHTML=es),Ui=d(e),Bi=n(e,"HR",{}),Ki=d(e),Ue=n(e,"A",{id:!0,class:!0}),a(Ue).forEach(l),qi=d(e),c(Be.$$.fragment,e),Ni=d(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-pake4r"&&(Ke.innerHTML=ts),Ii=d(e),qe=n(e,"TABLE",{"data-svelte-h":!0}),r(qe)!=="svelte-f03x1m"&&(qe.innerHTML=ls),ki=d(e),Si=n(e,"HR",{}),Ji=d(e),Ne=n(e,"A",{id:!0,class:!0}),a(Ne).forEach(l),Di=d(e),c(Ie.$$.fragment,e),zi=d(e),ke=n(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-13oc2rp"&&(ke.textContent=is),Wi=d(e),Se=n(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1wxlxpn"&&(Se.innerHTML=os),Vi=d(e),Je=n(e,"TABLE",{"data-svelte-h":!0}),r(Je)!=="svelte-2kmk06"&&(Je.innerHTML=ds),Yi=d(e),Gi=n(e,"HR",{}),Qi=d(e),De=n(e,"A",{id:!0,class:!0}),a(De).forEach(l),Xi=d(e),c(ze.$$.fragment,e),Zi=d(e),We=n(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-bwoz3v"&&(We.textContent=ss),eo=d(e),Ve=n(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1wxlxpn"&&(Ve.innerHTML=ns),to=d(e),Ye=n(e,"TABLE",{"data-svelte-h":!0}),r(Ye)!=="svelte-yj5tj6"&&(Ye.innerHTML=rs),lo=d(e),io=n(e,"HR",{}),oo=d(e),Ge=n(e,"A",{id:!0,class:!0}),a(Ge).forEach(l),so=d(e),c(Qe.$$.fragment,e),no=d(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-15u13r6"&&(Xe.textContent=us),ro=d(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1tftvai"&&(Ze.innerHTML=as),uo=d(e),ao=n(e,"HR",{}),po=d(e),et=n(e,"A",{id:!0,class:!0}),a(et).forEach(l),co=d(e),c(tt.$$.fragment,e),fo=d(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-fkm19c"&&(lt.textContent=ps),ho=d(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-xyh2rt"&&(it.innerHTML=cs),mo=d(e),ot=n(e,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-mnoe75"&&(ot.innerHTML=fs),bo=d(e),_o=n(e,"HR",{}),$o=d(e),dt=n(e,"A",{id:!0,class:!0}),a(dt).forEach(l),vo=d(e),c(st.$$.fragment,e),To=d(e),nt=n(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-112gzs0"&&(nt.textContent=hs),go=d(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-9i72aw"&&(rt.innerHTML=ms),yo=d(e),ut=n(e,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-w7pu3"&&(ut.innerHTML=bs),Po=d(e),at=n(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-bpbhxc"&&(at.innerHTML=_s),Ro=d(e),Co=n(e,"HR",{}),Mo=d(e),pt=n(e,"A",{id:!0,class:!0}),a(pt).forEach(l),Ho=d(e),c(ct.$$.fragment,e),Lo=d(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1h1o1yf"&&(ft.innerHTML=$s),xo=d(e),ht=n(e,"TABLE",{"data-svelte-h":!0}),r(ht)!=="svelte-17sk6uf"&&(ht.innerHTML=vs),Fo=d(e),wo=n(e,"HR",{}),Ao=d(e),mt=n(e,"A",{id:!0,class:!0}),a(mt).forEach(l),jo=d(e),c(bt.$$.fragment,e),Eo=d(e),_t=n(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1tqccie"&&(_t.textContent=Ts),Oo=d(e),$t=n(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-dyyw29"&&($t.innerHTML=gs),Uo=d(e),vt=n(e,"TABLE",{"data-svelte-h":!0}),r(vt)!=="svelte-13fau3m"&&(vt.innerHTML=ys),Bo=d(e),Ko=n(e,"HR",{}),qo=d(e),Tt=n(e,"A",{id:!0,class:!0}),a(Tt).forEach(l),No=d(e),c(gt.$$.fragment,e),Io=d(e),yt=n(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-7vbcne"&&(yt.textContent=Ps),ko=d(e),Pt=n(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-wjfx67"&&(Pt.innerHTML=Rs),So=d(e),Rt=n(e,"TABLE",{"data-svelte-h":!0}),r(Rt)!=="svelte-61qi9d"&&(Rt.innerHTML=Cs),Jo=d(e),Do=n(e,"HR",{}),zo=d(e),Ct=n(e,"A",{id:!0,class:!0}),a(Ct).forEach(l),Wo=d(e),c(Mt.$$.fragment,e),Vo=d(e),Ht=n(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1oi15lr"&&(Ht.textContent=Ms),Yo=d(e),Lt=n(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-121rdz"&&(Lt.innerHTML=Hs),Go=d(e),xt=n(e,"TABLE",{"data-svelte-h":!0}),r(xt)!=="svelte-a8j5ef"&&(xt.innerHTML=Ls),Qo=d(e),Xo=n(e,"HR",{}),Zo=d(e),Ft=n(e,"A",{id:!0,class:!0}),a(Ft).forEach(l),ed=d(e),c(wt.$$.fragment,e),td=d(e),At=n(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1oi15lr"&&(At.textContent=xs),ld=d(e),jt=n(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-121rdz"&&(jt.innerHTML=Fs),id=d(e),Et=n(e,"TABLE",{"data-svelte-h":!0}),r(Et)!=="svelte-k5ce7a"&&(Et.innerHTML=ws),od=d(e),dd=n(e,"HR",{}),sd=d(e),Ot=n(e,"A",{id:!0,class:!0}),a(Ot).forEach(l),nd=d(e),c(Ut.$$.fragment,e),rd=d(e),Bt=n(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1oi15lr"&&(Bt.textContent=As),ud=d(e),Kt=n(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-ghvp2p"&&(Kt.innerHTML=js),ad=d(e),pd=n(e,"HR",{}),cd=d(e),c(qt.$$.fragment,e),fd=d(e),It=n(e,"P",{}),a(It).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",Ss),u(v,"id","module_utils/hub"),u(v,"class","group"),u(P,"id","module_utils/hub.getFile"),u(P,"class","group"),u(L,"id","module_utils/hub.getModelFile"),u(L,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(I,"id","module_utils/hub.getModelFile..buffer"),u(I,"class","group"),u(J,"id","module_utils/hub.getModelJSON"),u(J,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+updateContentType"),u(oe,"class","group"),u(re,"id","module_utils/hub..FileResponse+clone"),u(re,"class","group"),u(ce,"id","module_utils/hub..FileResponse+arrayBuffer"),u(ce,"class","group"),u(_e,"id","module_utils/hub..FileResponse+blob"),u(_e,"class","group"),u(ye,"id","module_utils/hub..FileResponse+text"),u(ye,"class","group"),u(He,"id","module_utils/hub..FileResponse+json"),u(He,"class","group"),u(Ae,"id","module_utils/hub..FileCache"),u(Ae,"class","group"),u(Ue,"id","new_module_utils/hub..FileCache_new"),u(Ue,"class","group"),u(Ne,"id","module_utils/hub..FileCache+match"),u(Ne,"class","group"),u(De,"id","module_utils/hub..FileCache+put"),u(De,"class","group"),u(Ge,"id","module_utils/hub..CONTENT_TYPE_MAP"),u(Ge,"class","group"),u(et,"id","module_utils/hub..isValidUrl"),u(et,"class","group"),u(dt,"id","module_utils/hub..handleError"),u(dt,"class","group"),u(pt,"id","module_utils/hub..tryCache"),u(pt,"class","group"),u(mt,"id","module_utils/hub..readResponse"),u(mt,"class","group"),u(Tt,"id","module_utils/hub..pathJoin"),u(Tt,"class","group"),u(Ct,"id","module_utils/hub..PretrainedOptions"),u(Ct,"class","group"),u(Ft,"id","module_utils/hub..ModelSpecificPretrainedOptions"),u(Ft,"class","group"),u(Ot,"id","module_utils/hub..PretrainedModelOptions"),u(Ot,"class","group")},m(e,t){Ns(document.head,$),i(e,kt,t),i(e,Nt,t),i(e,St,t),i(e,v,t),i(e,Jt,t),f(T,e,t),i(e,Dt,t),i(e,g,t),i(e,zt,t),i(e,y,t),i(e,Wt,t),i(e,Vt,t),i(e,Yt,t),i(e,P,t),i(e,Gt,t),f(R,e,t),i(e,Qt,t),i(e,C,t),i(e,Xt,t),i(e,M,t),i(e,Zt,t),i(e,H,t),i(e,el,t),i(e,tl,t),i(e,ll,t),i(e,L,t),i(e,il,t),f(x,e,t),i(e,ol,t),i(e,F,t),i(e,dl,t),i(e,w,t),i(e,sl,t),i(e,A,t),i(e,nl,t),i(e,j,t),i(e,rl,t),i(e,E,t),i(e,ul,t),i(e,al,t),i(e,pl,t),i(e,O,t),i(e,cl,t),f(U,e,t),i(e,fl,t),i(e,B,t),i(e,hl,t),i(e,ml,t),i(e,bl,t),i(e,K,t),i(e,_l,t),f(q,e,t),i(e,$l,t),i(e,N,t),i(e,vl,t),i(e,Tl,t),i(e,gl,t),i(e,I,t),i(e,yl,t),f(k,e,t),i(e,Pl,t),i(e,S,t),i(e,Rl,t),i(e,Cl,t),i(e,Ml,t),i(e,J,t),i(e,Hl,t),f(D,e,t),i(e,Ll,t),i(e,z,t),i(e,xl,t),i(e,W,t),i(e,Fl,t),i(e,V,t),i(e,wl,t),i(e,Y,t),i(e,Al,t),i(e,jl,t),i(e,El,t),i(e,G,t),i(e,Ol,t),f(Q,e,t),i(e,Ul,t),i(e,X,t),i(e,Bl,t),i(e,Z,t),i(e,Kl,t),i(e,ql,t),i(e,Nl,t),i(e,ee,t),i(e,Il,t),f(te,e,t),i(e,kl,t),i(e,le,t),i(e,Sl,t),i(e,ie,t),i(e,Jl,t),i(e,Dl,t),i(e,zl,t),i(e,oe,t),i(e,Wl,t),f(de,e,t),i(e,Vl,t),i(e,se,t),i(e,Yl,t),i(e,ne,t),i(e,Gl,t),i(e,Ql,t),i(e,Xl,t),i(e,re,t),i(e,Zl,t),f(ue,e,t),i(e,ei,t),i(e,ae,t),i(e,ti,t),i(e,pe,t),i(e,li,t),i(e,ii,t),i(e,oi,t),i(e,ce,t),i(e,di,t),f(fe,e,t),i(e,si,t),i(e,he,t),i(e,ni,t),i(e,me,t),i(e,ri,t),i(e,be,t),i(e,ui,t),i(e,ai,t),i(e,pi,t),i(e,_e,t),i(e,ci,t),f($e,e,t),i(e,fi,t),i(e,ve,t),i(e,hi,t),i(e,Te,t),i(e,mi,t),i(e,ge,t),i(e,bi,t),i(e,_i,t),i(e,$i,t),i(e,ye,t),i(e,vi,t),f(Pe,e,t),i(e,Ti,t),i(e,Re,t),i(e,gi,t),i(e,Ce,t),i(e,yi,t),i(e,Me,t),i(e,Pi,t),i(e,Ri,t),i(e,Ci,t),i(e,He,t),i(e,Mi,t),f(Le,e,t),i(e,Hi,t),i(e,xe,t),i(e,Li,t),i(e,Fe,t),i(e,xi,t),i(e,we,t),i(e,Fi,t),i(e,wi,t),i(e,Ai,t),i(e,Ae,t),i(e,ji,t),f(je,e,t),i(e,Ei,t),i(e,Ee,t),i(e,Oi,t),i(e,Oe,t),i(e,Ui,t),i(e,Bi,t),i(e,Ki,t),i(e,Ue,t),i(e,qi,t),f(Be,e,t),i(e,Ni,t),i(e,Ke,t),i(e,Ii,t),i(e,qe,t),i(e,ki,t),i(e,Si,t),i(e,Ji,t),i(e,Ne,t),i(e,Di,t),f(Ie,e,t),i(e,zi,t),i(e,ke,t),i(e,Wi,t),i(e,Se,t),i(e,Vi,t),i(e,Je,t),i(e,Yi,t),i(e,Gi,t),i(e,Qi,t),i(e,De,t),i(e,Xi,t),f(ze,e,t),i(e,Zi,t),i(e,We,t),i(e,eo,t),i(e,Ve,t),i(e,to,t),i(e,Ye,t),i(e,lo,t),i(e,io,t),i(e,oo,t),i(e,Ge,t),i(e,so,t),f(Qe,e,t),i(e,no,t),i(e,Xe,t),i(e,ro,t),i(e,Ze,t),i(e,uo,t),i(e,ao,t),i(e,po,t),i(e,et,t),i(e,co,t),f(tt,e,t),i(e,fo,t),i(e,lt,t),i(e,ho,t),i(e,it,t),i(e,mo,t),i(e,ot,t),i(e,bo,t),i(e,_o,t),i(e,$o,t),i(e,dt,t),i(e,vo,t),f(st,e,t),i(e,To,t),i(e,nt,t),i(e,go,t),i(e,rt,t),i(e,yo,t),i(e,ut,t),i(e,Po,t),i(e,at,t),i(e,Ro,t),i(e,Co,t),i(e,Mo,t),i(e,pt,t),i(e,Ho,t),f(ct,e,t),i(e,Lo,t),i(e,ft,t),i(e,xo,t),i(e,ht,t),i(e,Fo,t),i(e,wo,t),i(e,Ao,t),i(e,mt,t),i(e,jo,t),f(bt,e,t),i(e,Eo,t),i(e,_t,t),i(e,Oo,t),i(e,$t,t),i(e,Uo,t),i(e,vt,t),i(e,Bo,t),i(e,Ko,t),i(e,qo,t),i(e,Tt,t),i(e,No,t),f(gt,e,t),i(e,Io,t),i(e,yt,t),i(e,ko,t),i(e,Pt,t),i(e,So,t),i(e,Rt,t),i(e,Jo,t),i(e,Do,t),i(e,zo,t),i(e,Ct,t),i(e,Wo,t),f(Mt,e,t),i(e,Vo,t),i(e,Ht,t),i(e,Yo,t),i(e,Lt,t),i(e,Go,t),i(e,xt,t),i(e,Qo,t),i(e,Xo,t),i(e,Zo,t),i(e,Ft,t),i(e,ed,t),f(wt,e,t),i(e,td,t),i(e,At,t),i(e,ld,t),i(e,jt,t),i(e,id,t),i(e,Et,t),i(e,od,t),i(e,dd,t),i(e,sd,t),i(e,Ot,t),i(e,nd,t),f(Ut,e,t),i(e,rd,t),i(e,Bt,t),i(e,ud,t),i(e,Kt,t),i(e,ad,t),i(e,pd,t),i(e,cd,t),f(qt,e,t),i(e,fd,t),i(e,It,t),hd=!0},p:Os,i(e){hd||(h(T.$$.fragment,e),h(R.$$.fragment,e),h(x.$$.fragment,e),h(U.$$.fragment,e),h(q.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h($e.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(gt.$$.fragment,e),h(Mt.$$.fragment,e),h(wt.$$.fragment,e),h(Ut.$$.fragment,e),h(qt.$$.fragment,e),hd=!0)},o(e){m(T.$$.fragment,e),m(R.$$.fragment,e),m(x.$$.fragment,e),m(U.$$.fragment,e),m(q.$$.fragment,e),m(k.$$.fragment,e),m(D.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m($e.$$.fragment,e),m(Pe.$$.fragment,e),m(Le.$$.fragment,e),m(je.$$.fragment,e),m(Be.$$.fragment,e),m(Ie.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(ct.$$.fragment,e),m(bt.$$.fragment,e),m(gt.$$.fragment,e),m(Mt.$$.fragment,e),m(wt.$$.fragment,e),m(Ut.$$.fragment,e),m(qt.$$.fragment,e),hd=!1},d(e){e&&(l(kt),l(Nt),l(St),l(v),l(Jt),l(Dt),l(g),l(zt),l(y),l(Wt),l(Vt),l(Yt),l(P),l(Gt),l(Qt),l(C),l(Xt),l(M),l(Zt),l(H),l(el),l(tl),l(ll),l(L),l(il),l(ol),l(F),l(dl),l(w),l(sl),l(A),l(nl),l(j),l(rl),l(E),l(ul),l(al),l(pl),l(O),l(cl),l(fl),l(B),l(hl),l(ml),l(bl),l(K),l(_l),l($l),l(N),l(vl),l(Tl),l(gl),l(I),l(yl),l(Pl),l(S),l(Rl),l(Cl),l(Ml),l(J),l(Hl),l(Ll),l(z),l(xl),l(W),l(Fl),l(V),l(wl),l(Y),l(Al),l(jl),l(El),l(G),l(Ol),l(Ul),l(X),l(Bl),l(Z),l(Kl),l(ql),l(Nl),l(ee),l(Il),l(kl),l(le),l(Sl),l(ie),l(Jl),l(Dl),l(zl),l(oe),l(Wl),l(Vl),l(se),l(Yl),l(ne),l(Gl),l(Ql),l(Xl),l(re),l(Zl),l(ei),l(ae),l(ti),l(pe),l(li),l(ii),l(oi),l(ce),l(di),l(si),l(he),l(ni),l(me),l(ri),l(be),l(ui),l(ai),l(pi),l(_e),l(ci),l(fi),l(ve),l(hi),l(Te),l(mi),l(ge),l(bi),l(_i),l($i),l(ye),l(vi),l(Ti),l(Re),l(gi),l(Ce),l(yi),l(Me),l(Pi),l(Ri),l(Ci),l(He),l(Mi),l(Hi),l(xe),l(Li),l(Fe),l(xi),l(we),l(Fi),l(wi),l(Ai),l(Ae),l(ji),l(Ei),l(Ee),l(Oi),l(Oe),l(Ui),l(Bi),l(Ki),l(Ue),l(qi),l(Ni),l(Ke),l(Ii),l(qe),l(ki),l(Si),l(Ji),l(Ne),l(Di),l(zi),l(ke),l(Wi),l(Se),l(Vi),l(Je),l(Yi),l(Gi),l(Qi),l(De),l(Xi),l(Zi),l(We),l(eo),l(Ve),l(to),l(Ye),l(lo),l(io),l(oo),l(Ge),l(so),l(no),l(Xe),l(ro),l(Ze),l(uo),l(ao),l(po),l(et),l(co),l(fo),l(lt),l(ho),l(it),l(mo),l(ot),l(bo),l(_o),l($o),l(dt),l(vo),l(To),l(nt),l(go),l(rt),l(yo),l(ut),l(Po),l(at),l(Ro),l(Co),l(Mo),l(pt),l(Ho),l(Lo),l(ft),l(xo),l(ht),l(Fo),l(wo),l(Ao),l(mt),l(jo),l(Eo),l(_t),l(Oo),l($t),l(Uo),l(vt),l(Bo),l(Ko),l(qo),l(Tt),l(No),l(Io),l(yt),l(ko),l(Pt),l(So),l(Rt),l(Jo),l(Do),l(zo),l(Ct),l(Wo),l(Vo),l(Ht),l(Yo),l(Lt),l(Go),l(xt),l(Qo),l(Xo),l(Zo),l(Ft),l(ed),l(td),l(At),l(ld),l(jt),l(id),l(Et),l(od),l(dd),l(sd),l(Ot),l(nd),l(rd),l(Bt),l(ud),l(Kt),l(ad),l(pd),l(cd),l(fd),l(It)),l($),b(T,e),b(R,e),b(x,e),b(U,e),b(q,e),b(k,e),b(D,e),b(Q,e),b(te,e),b(de,e),b(ue,e),b(fe,e),b($e,e),b(Pe,e),b(Le,e),b(je,e),b(Be,e),b(Ie,e),b(ze,e),b(Qe,e),b(tt,e),b(st,e),b(ct,e),b(bt,e),b(gt,e),b(Mt,e),b(wt,e),b(Ut,e),b(qt,e)}}}const Ss='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise--uint8array--code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~CONTENT_TYPE_MAP","local":"utilshubcontenttypemap","sections":[],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>","local":"utilshubmodelspecificpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedModelOptions : <code> * </code>","local":"utilshubpretrainedmodeloptions--code--code","sections":[],"depth":2}],"depth":1}';function Js(md){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Bs{constructor($){super(),Ks(this,$,Js,ks,Es,{})}}export{Vs as component};
