import{s as Bi,n as Ki,o as Yi}from"../chunks/scheduler.0219f8bd.js";import{S as Ji,i as Ni,g as d,s as i,r as n,A as qi,h as o,f as a,c as m,j as g,u,x as s,k as r,y as Gi,a as l,v as c,d as p,t as f,w as h}from"../chunks/index.f61edf3b.js";import{C as Oi}from"../chunks/CodeBlock.38e566ae.js";import{H as w,E as Si}from"../chunks/EditOnGithub.48fa589f.js";function Di(Bl){let R,st,dt,rt,I,nt,$,gt,v,Kl="Helper module for image processing.",ut,_,Yl=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ct,T,Jl='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+putAlpha"><code>.putAlpha(mask)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li> <li><a href="#module_utils/image.load_image"><code>.load_image</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',pt,ft,ht,b,wt,C,Rt,x,Nl='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',It,H,ql='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+putAlpha"><code>.putAlpha(mask)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',$t,vt,_t,L,Tt,y,bt,M,Gl="Create a new <code>RawImage</code> object.",Ct,P,Ol="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",xt,Ht,Lt,A,yt,E,Mt,z,Sl="Returns the size of the image (width, height).",Pt,j,Dl='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',At,Et,zt,U,jt,k,Ut,B,Zl="Convert the image to grayscale format.",kt,K,Wl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Bt,Kt,Yt,Y,Jt,J,Nt,N,Fl="Convert the image to RGB format.",qt,q,Vl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Gt,Ot,St,G,Dt,O,Zt,S,Ql="Convert the image to RGBA format.",Wt,D,Xl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Ft,Vt,Qt,Z,Xt,W,ea,F,ei="Apply an alpha mask to the image. Operates in place.",ta,V,ti='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The masked image.<br/> <strong>Throws</strong>:',aa,Q,ai="<li><code>Error</code> If the mask is not the same size as the image.</li> <li><code>Error</code> If the image does not have 4 channels.</li> <li><code>Error</code> If the mask is not a single channel.</li>",la,X,li="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>mask</td><td><code>RawImage</code></td><td><p>The mask to apply. It should have a single channel.</p></td></tr></tbody>",ia,ma,da,ee,oa,te,sa,ae,ii="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",ra,le,mi='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',na,ie,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",ga,ua,ca,me,pa,de,fa,oe,oi=`Split this image into individual bands. This method returns an array of individual image bands from an image.
For example, splitting an “RGB” image creates three new images each containing a copy of one of the original bands (red, green, blue).`,ha,se,si='Inspired by PIL’s <code>Image.split()</code> <a href="https://pillow.readthedocs.io/en/latest/reference/Image.html#PIL.Image.Image.split" rel="nofollow">function</a>.',wa,re,ri='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;RawImage&gt;</code> - An array containing bands.',Ra,Ia,$a,ne,va,ge,_a,ue,ni="Clone the image",Ta,ce,gi='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',ba,Ca,xa,pe,Ha,fe,La,he,ui="Helper method for converting image to have a certain number of channels",ya,we,ci='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Ma,Re,pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",Pa,Aa,Ea,Ie,za,$e,ja,ve,fi="Save the image to the given path.",Ua,_e,hi='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',ka,Te,wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",Ba,Ka,Ya,be,Ja,Ce,Na,xe,Ri="Helper method for reading an image from a variety of input types.",qa,He,Ii='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',Ga,Le,$i="<strong>Example:</strong> Read image from a URL.",Oa,ye,Sa,Me,vi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",Da,Za,Wa,Pe,Fa,Ae,Va,Ee,_i="Read an image from a canvas.",Qa,ze,Ti='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The image object.',Xa,je,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>canvas</td><td><code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td><td><p>The canvas to read the image from.</p></td></tr></tbody>",el,tl,al,Ue,ll,ke,il,Be,Ci="Read an image from a URL or file path.",ml,Ke,xi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',dl,Ye,Hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",ol,sl,rl,Je,nl,Ne,gl,qe,Li="Helper method to create a new Image from a blob.",ul,Ge,yi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',cl,Oe,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",pl,fl,hl,Se,wl,De,Rl,Ze,Pi="Helper method to create a new Image from a tensor",Il,We,Ai='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',$l,Fe,Ei='<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td></tr></tbody>',vl,_l,Tl,Ve,bl,Qe,Cl,Xe,zi="Helper function to load an image from a URL, path, etc.",xl,et,ji='<strong>Kind</strong>: static constant of <a href="#module_utils/image"><code>utils/image</code></a>',Hl,Ll,yl,tt,Ml,at,Pl,lt,Ui="Mapping from file extensions to MIME types.",Al,it,ki='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',El,zl,jl,mt,Ul,ot,kl;return $=new w({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new w({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),y=new w({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),E=new w({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),k=new w({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),J=new w({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),O=new w({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),W=new w({props:{title:"rawImage.putAlpha(mask) ⇒ <code> RawImage </code>",local:"rawimageputalphamask--code-rawimage-code",headingTag:"h3"}}),te=new w({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),de=new w({props:{title:"rawImage.split() ⇒ <code> Array. < RawImage > </code>",local:"rawimagesplit--code-array--rawimage--code",headingTag:"h3"}}),ge=new w({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),fe=new w({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),$e=new w({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),Ce=new w({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),ye=new Oi({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),Ae=new w({props:{title:"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>",local:"rawimagefromcanvascanvas--code-rawimage-code",headingTag:"h3"}}),ke=new w({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),Ne=new w({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),De=new w({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),Qe=new w({props:{title:"utils/image.load_image",local:"utilsimageloadimage",headingTag:"h2"}}),at=new w({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),mt=new Si({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/image.md"}}),{c(){R=d("meta"),st=i(),dt=d("p"),rt=i(),I=d("a"),nt=i(),n($.$$.fragment),gt=i(),v=d("p"),v.textContent=Kl,ut=i(),_=d("p"),_.textContent=Yl,ct=i(),T=d("ul"),T.innerHTML=Jl,pt=i(),ft=d("hr"),ht=i(),b=d("a"),wt=i(),n(C.$$.fragment),Rt=i(),x=d("p"),x.innerHTML=Nl,It=i(),H=d("ul"),H.innerHTML=ql,$t=i(),vt=d("hr"),_t=i(),L=d("a"),Tt=i(),n(y.$$.fragment),bt=i(),M=d("p"),M.innerHTML=Gl,Ct=i(),P=d("table"),P.innerHTML=Ol,xt=i(),Ht=d("hr"),Lt=i(),A=d("a"),yt=i(),n(E.$$.fragment),Mt=i(),z=d("p"),z.textContent=Sl,Pt=i(),j=d("p"),j.innerHTML=Dl,At=i(),Et=d("hr"),zt=i(),U=d("a"),jt=i(),n(k.$$.fragment),Ut=i(),B=d("p"),B.textContent=Zl,kt=i(),K=d("p"),K.innerHTML=Wl,Bt=i(),Kt=d("hr"),Yt=i(),Y=d("a"),Jt=i(),n(J.$$.fragment),Nt=i(),N=d("p"),N.textContent=Fl,qt=i(),q=d("p"),q.innerHTML=Vl,Gt=i(),Ot=d("hr"),St=i(),G=d("a"),Dt=i(),n(O.$$.fragment),Zt=i(),S=d("p"),S.textContent=Ql,Wt=i(),D=d("p"),D.innerHTML=Xl,Ft=i(),Vt=d("hr"),Qt=i(),Z=d("a"),Xt=i(),n(W.$$.fragment),ea=i(),F=d("p"),F.textContent=ei,ta=i(),V=d("p"),V.innerHTML=ti,aa=i(),Q=d("ul"),Q.innerHTML=ai,la=i(),X=d("table"),X.innerHTML=li,ia=i(),ma=d("hr"),da=i(),ee=d("a"),oa=i(),n(te.$$.fragment),sa=i(),ae=d("p"),ae.textContent=ii,ra=i(),le=d("p"),le.innerHTML=mi,na=i(),ie=d("table"),ie.innerHTML=di,ga=i(),ua=d("hr"),ca=i(),me=d("a"),pa=i(),n(de.$$.fragment),fa=i(),oe=d("p"),oe.textContent=oi,ha=i(),se=d("p"),se.innerHTML=si,wa=i(),re=d("p"),re.innerHTML=ri,Ra=i(),Ia=d("hr"),$a=i(),ne=d("a"),va=i(),n(ge.$$.fragment),_a=i(),ue=d("p"),ue.textContent=ni,Ta=i(),ce=d("p"),ce.innerHTML=gi,ba=i(),Ca=d("hr"),xa=i(),pe=d("a"),Ha=i(),n(fe.$$.fragment),La=i(),he=d("p"),he.textContent=ui,ya=i(),we=d("p"),we.innerHTML=ci,Ma=i(),Re=d("table"),Re.innerHTML=pi,Pa=i(),Aa=d("hr"),Ea=i(),Ie=d("a"),za=i(),n($e.$$.fragment),ja=i(),ve=d("p"),ve.textContent=fi,Ua=i(),_e=d("p"),_e.innerHTML=hi,ka=i(),Te=d("table"),Te.innerHTML=wi,Ba=i(),Ka=d("hr"),Ya=i(),be=d("a"),Ja=i(),n(Ce.$$.fragment),Na=i(),xe=d("p"),xe.textContent=Ri,qa=i(),He=d("p"),He.innerHTML=Ii,Ga=i(),Le=d("p"),Le.innerHTML=$i,Oa=i(),n(ye.$$.fragment),Sa=i(),Me=d("table"),Me.innerHTML=vi,Da=i(),Za=d("hr"),Wa=i(),Pe=d("a"),Fa=i(),n(Ae.$$.fragment),Va=i(),Ee=d("p"),Ee.textContent=_i,Qa=i(),ze=d("p"),ze.innerHTML=Ti,Xa=i(),je=d("table"),je.innerHTML=bi,el=i(),tl=d("hr"),al=i(),Ue=d("a"),ll=i(),n(ke.$$.fragment),il=i(),Be=d("p"),Be.textContent=Ci,ml=i(),Ke=d("p"),Ke.innerHTML=xi,dl=i(),Ye=d("table"),Ye.innerHTML=Hi,ol=i(),sl=d("hr"),rl=i(),Je=d("a"),nl=i(),n(Ne.$$.fragment),gl=i(),qe=d("p"),qe.textContent=Li,ul=i(),Ge=d("p"),Ge.innerHTML=yi,cl=i(),Oe=d("table"),Oe.innerHTML=Mi,pl=i(),fl=d("hr"),hl=i(),Se=d("a"),wl=i(),n(De.$$.fragment),Rl=i(),Ze=d("p"),Ze.textContent=Pi,Il=i(),We=d("p"),We.innerHTML=Ai,$l=i(),Fe=d("table"),Fe.innerHTML=Ei,vl=i(),_l=d("hr"),Tl=i(),Ve=d("a"),bl=i(),n(Qe.$$.fragment),Cl=i(),Xe=d("p"),Xe.textContent=zi,xl=i(),et=d("p"),et.innerHTML=ji,Hl=i(),Ll=d("hr"),yl=i(),tt=d("a"),Ml=i(),n(at.$$.fragment),Pl=i(),lt=d("p"),lt.textContent=Ui,Al=i(),it=d("p"),it.innerHTML=ki,El=i(),zl=d("hr"),jl=i(),n(mt.$$.fragment),Ul=i(),ot=d("p"),this.h()},l(e){const t=qi("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),st=m(e),dt=o(e,"P",{}),g(dt).forEach(a),rt=m(e),I=o(e,"A",{id:!0,class:!0}),g(I).forEach(a),nt=m(e),u($.$$.fragment,e),gt=m(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1uts7np"&&(v.textContent=Kl),ut=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-il3kl8"&&(_.textContent=Yl),ct=m(e),T=o(e,"UL",{"data-svelte-h":!0}),s(T)!=="svelte-1mr7ud8"&&(T.innerHTML=Jl),pt=m(e),ft=o(e,"HR",{}),ht=m(e),b=o(e,"A",{id:!0,class:!0}),g(b).forEach(a),wt=m(e),u(C.$$.fragment,e),Rt=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=Nl),It=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-bl4gmp"&&(H.innerHTML=ql),$t=m(e),vt=o(e,"HR",{}),_t=m(e),L=o(e,"A",{id:!0,class:!0}),g(L).forEach(a),Tt=m(e),u(y.$$.fragment,e),bt=m(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-36fe9a"&&(M.innerHTML=Gl),Ct=m(e),P=o(e,"TABLE",{"data-svelte-h":!0}),s(P)!=="svelte-vkeoul"&&(P.innerHTML=Ol),xt=m(e),Ht=o(e,"HR",{}),Lt=m(e),A=o(e,"A",{id:!0,class:!0}),g(A).forEach(a),yt=m(e),u(E.$$.fragment,e),Mt=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=Sl),Pt=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-gwg1mu"&&(j.innerHTML=Dl),At=m(e),Et=o(e,"HR",{}),zt=m(e),U=o(e,"A",{id:!0,class:!0}),g(U).forEach(a),jt=m(e),u(k.$$.fragment,e),Ut=m(e),B=o(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-1owjjfe"&&(B.textContent=Zl),kt=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-11e9r18"&&(K.innerHTML=Wl),Bt=m(e),Kt=o(e,"HR",{}),Yt=m(e),Y=o(e,"A",{id:!0,class:!0}),g(Y).forEach(a),Jt=m(e),u(J.$$.fragment,e),Nt=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-qyo04e"&&(N.textContent=Fl),qt=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-11e9r18"&&(q.innerHTML=Vl),Gt=m(e),Ot=o(e,"HR",{}),St=m(e),G=o(e,"A",{id:!0,class:!0}),g(G).forEach(a),Dt=m(e),u(O.$$.fragment,e),Zt=m(e),S=o(e,"P",{"data-svelte-h":!0}),s(S)!=="svelte-19kp14j"&&(S.textContent=Ql),Wt=m(e),D=o(e,"P",{"data-svelte-h":!0}),s(D)!=="svelte-11e9r18"&&(D.innerHTML=Xl),Ft=m(e),Vt=o(e,"HR",{}),Qt=m(e),Z=o(e,"A",{id:!0,class:!0}),g(Z).forEach(a),Xt=m(e),u(W.$$.fragment,e),ea=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1r4j26z"&&(F.textContent=ei),ta=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1sc5phl"&&(V.innerHTML=ti),aa=m(e),Q=o(e,"UL",{"data-svelte-h":!0}),s(Q)!=="svelte-1jw508h"&&(Q.innerHTML=ai),la=m(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-zr81ae"&&(X.innerHTML=li),ia=m(e),ma=o(e,"HR",{}),da=m(e),ee=o(e,"A",{id:!0,class:!0}),g(ee).forEach(a),oa=m(e),u(te.$$.fragment,e),sa=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-s4dm9o"&&(ae.textContent=ii),ra=m(e),le=o(e,"P",{"data-svelte-h":!0}),s(le)!=="svelte-1jh8cjr"&&(le.innerHTML=mi),na=m(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-h7uulu"&&(ie.innerHTML=di),ga=m(e),ua=o(e,"HR",{}),ca=m(e),me=o(e,"A",{id:!0,class:!0}),g(me).forEach(a),pa=m(e),u(de.$$.fragment,e),fa=m(e),oe=o(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-2m63ix"&&(oe.textContent=oi),ha=m(e),se=o(e,"P",{"data-svelte-h":!0}),s(se)!=="svelte-k44jcf"&&(se.innerHTML=si),wa=m(e),re=o(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-1jdggat"&&(re.innerHTML=ri),Ra=m(e),Ia=o(e,"HR",{}),$a=m(e),ne=o(e,"A",{id:!0,class:!0}),g(ne).forEach(a),va=m(e),u(ge.$$.fragment,e),_a=m(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1eu6jk3"&&(ue.textContent=ni),Ta=m(e),ce=o(e,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-1w4hta5"&&(ce.innerHTML=gi),ba=m(e),Ca=o(e,"HR",{}),xa=m(e),pe=o(e,"A",{id:!0,class:!0}),g(pe).forEach(a),Ha=m(e),u(fe.$$.fragment,e),La=m(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-5ze294"&&(he.textContent=ui),ya=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-11e9r18"&&(we.innerHTML=ci),Ma=m(e),Re=o(e,"TABLE",{"data-svelte-h":!0}),s(Re)!=="svelte-1hxqxaq"&&(Re.innerHTML=pi),Pa=m(e),Aa=o(e,"HR",{}),Ea=m(e),Ie=o(e,"A",{id:!0,class:!0}),g(Ie).forEach(a),za=m(e),u($e.$$.fragment,e),ja=m(e),ve=o(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-119su55"&&(ve.textContent=fi),Ua=m(e),_e=o(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-1epyezb"&&(_e.innerHTML=hi),ka=m(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),s(Te)!=="svelte-1h4z9xq"&&(Te.innerHTML=wi),Ba=m(e),Ka=o(e,"HR",{}),Ya=m(e),be=o(e,"A",{id:!0,class:!0}),g(be).forEach(a),Ja=m(e),u(Ce.$$.fragment,e),Na=m(e),xe=o(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-5659h9"&&(xe.textContent=Ri),qa=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1800vfp"&&(He.innerHTML=Ii),Ga=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-14z54gq"&&(Le.innerHTML=$i),Oa=m(e),u(ye.$$.fragment,e),Sa=m(e),Me=o(e,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-eqolu5"&&(Me.innerHTML=vi),Da=m(e),Za=o(e,"HR",{}),Wa=m(e),Pe=o(e,"A",{id:!0,class:!0}),g(Pe).forEach(a),Fa=m(e),u(Ae.$$.fragment,e),Va=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-mjjjch"&&(Ee.textContent=_i),Qa=m(e),ze=o(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-hagi3s"&&(ze.innerHTML=Ti),Xa=m(e),je=o(e,"TABLE",{"data-svelte-h":!0}),s(je)!=="svelte-hzvu44"&&(je.innerHTML=bi),el=m(e),tl=o(e,"HR",{}),al=m(e),Ue=o(e,"A",{id:!0,class:!0}),g(Ue).forEach(a),ll=m(e),u(ke.$$.fragment,e),il=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1355z3u"&&(Be.textContent=Ci),ml=m(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-10btw3j"&&(Ke.innerHTML=xi),dl=m(e),Ye=o(e,"TABLE",{"data-svelte-h":!0}),s(Ye)!=="svelte-ncveta"&&(Ye.innerHTML=Hi),ol=m(e),sl=o(e,"HR",{}),rl=m(e),Je=o(e,"A",{id:!0,class:!0}),g(Je).forEach(a),nl=m(e),u(Ne.$$.fragment,e),gl=m(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1s704mu"&&(qe.textContent=Li),ul=m(e),Ge=o(e,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-10btw3j"&&(Ge.innerHTML=yi),cl=m(e),Oe=o(e,"TABLE",{"data-svelte-h":!0}),s(Oe)!=="svelte-34rbhe"&&(Oe.innerHTML=Mi),pl=m(e),fl=o(e,"HR",{}),hl=m(e),Se=o(e,"A",{id:!0,class:!0}),g(Se).forEach(a),wl=m(e),u(De.$$.fragment,e),Rl=m(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-nwy2y"&&(Ze.textContent=Pi),Il=m(e),We=o(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-sl3vqa"&&(We.innerHTML=Ai),$l=m(e),Fe=o(e,"TABLE",{"data-svelte-h":!0}),s(Fe)!=="svelte-16eqzfb"&&(Fe.innerHTML=Ei),vl=m(e),_l=o(e,"HR",{}),Tl=m(e),Ve=o(e,"A",{id:!0,class:!0}),g(Ve).forEach(a),bl=m(e),u(Qe.$$.fragment,e),Cl=m(e),Xe=o(e,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-eu8o7o"&&(Xe.textContent=zi),xl=m(e),et=o(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1ricti2"&&(et.innerHTML=ji),Hl=m(e),Ll=o(e,"HR",{}),yl=m(e),tt=o(e,"A",{id:!0,class:!0}),g(tt).forEach(a),Ml=m(e),u(at.$$.fragment,e),Pl=m(e),lt=o(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-15u13r6"&&(lt.textContent=Ui),Al=m(e),it=o(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1cwm6ga"&&(it.innerHTML=ki),El=m(e),zl=o(e,"HR",{}),jl=m(e),u(mt.$$.fragment,e),Ul=m(e),ot=o(e,"P",{}),g(ot).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Zi),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(A,"id","module_utils/image.RawImage+size"),r(A,"class","group"),r(U,"id","module_utils/image.RawImage+grayscale"),r(U,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(G,"id","module_utils/image.RawImage+rgba"),r(G,"class","group"),r(Z,"id","module_utils/image.RawImage+putAlpha"),r(Z,"class","group"),r(ee,"id","module_utils/image.RawImage+resize"),r(ee,"class","group"),r(me,"id","module_utils/image.RawImage+split"),r(me,"class","group"),r(ne,"id","module_utils/image.RawImage+clone"),r(ne,"class","group"),r(pe,"id","module_utils/image.RawImage+convert"),r(pe,"class","group"),r(Ie,"id","module_utils/image.RawImage+save"),r(Ie,"class","group"),r(be,"id","module_utils/image.RawImage.read"),r(be,"class","group"),r(Pe,"id","module_utils/image.RawImage.fromCanvas"),r(Pe,"class","group"),r(Ue,"id","module_utils/image.RawImage.fromURL"),r(Ue,"class","group"),r(Je,"id","module_utils/image.RawImage.fromBlob"),r(Je,"class","group"),r(Se,"id","module_utils/image.RawImage.fromTensor"),r(Se,"class","group"),r(Ve,"id","module_utils/image.load_image"),r(Ve,"class","group"),r(tt,"id","module_utils/image..CONTENT_TYPE_MAP"),r(tt,"class","group")},m(e,t){Gi(document.head,R),l(e,st,t),l(e,dt,t),l(e,rt,t),l(e,I,t),l(e,nt,t),c($,e,t),l(e,gt,t),l(e,v,t),l(e,ut,t),l(e,_,t),l(e,ct,t),l(e,T,t),l(e,pt,t),l(e,ft,t),l(e,ht,t),l(e,b,t),l(e,wt,t),c(C,e,t),l(e,Rt,t),l(e,x,t),l(e,It,t),l(e,H,t),l(e,$t,t),l(e,vt,t),l(e,_t,t),l(e,L,t),l(e,Tt,t),c(y,e,t),l(e,bt,t),l(e,M,t),l(e,Ct,t),l(e,P,t),l(e,xt,t),l(e,Ht,t),l(e,Lt,t),l(e,A,t),l(e,yt,t),c(E,e,t),l(e,Mt,t),l(e,z,t),l(e,Pt,t),l(e,j,t),l(e,At,t),l(e,Et,t),l(e,zt,t),l(e,U,t),l(e,jt,t),c(k,e,t),l(e,Ut,t),l(e,B,t),l(e,kt,t),l(e,K,t),l(e,Bt,t),l(e,Kt,t),l(e,Yt,t),l(e,Y,t),l(e,Jt,t),c(J,e,t),l(e,Nt,t),l(e,N,t),l(e,qt,t),l(e,q,t),l(e,Gt,t),l(e,Ot,t),l(e,St,t),l(e,G,t),l(e,Dt,t),c(O,e,t),l(e,Zt,t),l(e,S,t),l(e,Wt,t),l(e,D,t),l(e,Ft,t),l(e,Vt,t),l(e,Qt,t),l(e,Z,t),l(e,Xt,t),c(W,e,t),l(e,ea,t),l(e,F,t),l(e,ta,t),l(e,V,t),l(e,aa,t),l(e,Q,t),l(e,la,t),l(e,X,t),l(e,ia,t),l(e,ma,t),l(e,da,t),l(e,ee,t),l(e,oa,t),c(te,e,t),l(e,sa,t),l(e,ae,t),l(e,ra,t),l(e,le,t),l(e,na,t),l(e,ie,t),l(e,ga,t),l(e,ua,t),l(e,ca,t),l(e,me,t),l(e,pa,t),c(de,e,t),l(e,fa,t),l(e,oe,t),l(e,ha,t),l(e,se,t),l(e,wa,t),l(e,re,t),l(e,Ra,t),l(e,Ia,t),l(e,$a,t),l(e,ne,t),l(e,va,t),c(ge,e,t),l(e,_a,t),l(e,ue,t),l(e,Ta,t),l(e,ce,t),l(e,ba,t),l(e,Ca,t),l(e,xa,t),l(e,pe,t),l(e,Ha,t),c(fe,e,t),l(e,La,t),l(e,he,t),l(e,ya,t),l(e,we,t),l(e,Ma,t),l(e,Re,t),l(e,Pa,t),l(e,Aa,t),l(e,Ea,t),l(e,Ie,t),l(e,za,t),c($e,e,t),l(e,ja,t),l(e,ve,t),l(e,Ua,t),l(e,_e,t),l(e,ka,t),l(e,Te,t),l(e,Ba,t),l(e,Ka,t),l(e,Ya,t),l(e,be,t),l(e,Ja,t),c(Ce,e,t),l(e,Na,t),l(e,xe,t),l(e,qa,t),l(e,He,t),l(e,Ga,t),l(e,Le,t),l(e,Oa,t),c(ye,e,t),l(e,Sa,t),l(e,Me,t),l(e,Da,t),l(e,Za,t),l(e,Wa,t),l(e,Pe,t),l(e,Fa,t),c(Ae,e,t),l(e,Va,t),l(e,Ee,t),l(e,Qa,t),l(e,ze,t),l(e,Xa,t),l(e,je,t),l(e,el,t),l(e,tl,t),l(e,al,t),l(e,Ue,t),l(e,ll,t),c(ke,e,t),l(e,il,t),l(e,Be,t),l(e,ml,t),l(e,Ke,t),l(e,dl,t),l(e,Ye,t),l(e,ol,t),l(e,sl,t),l(e,rl,t),l(e,Je,t),l(e,nl,t),c(Ne,e,t),l(e,gl,t),l(e,qe,t),l(e,ul,t),l(e,Ge,t),l(e,cl,t),l(e,Oe,t),l(e,pl,t),l(e,fl,t),l(e,hl,t),l(e,Se,t),l(e,wl,t),c(De,e,t),l(e,Rl,t),l(e,Ze,t),l(e,Il,t),l(e,We,t),l(e,$l,t),l(e,Fe,t),l(e,vl,t),l(e,_l,t),l(e,Tl,t),l(e,Ve,t),l(e,bl,t),c(Qe,e,t),l(e,Cl,t),l(e,Xe,t),l(e,xl,t),l(e,et,t),l(e,Hl,t),l(e,Ll,t),l(e,yl,t),l(e,tt,t),l(e,Ml,t),c(at,e,t),l(e,Pl,t),l(e,lt,t),l(e,Al,t),l(e,it,t),l(e,El,t),l(e,zl,t),l(e,jl,t),c(mt,e,t),l(e,Ul,t),l(e,ot,t),kl=!0},p:Ki,i(e){kl||(p($.$$.fragment,e),p(C.$$.fragment,e),p(y.$$.fragment,e),p(E.$$.fragment,e),p(k.$$.fragment,e),p(J.$$.fragment,e),p(O.$$.fragment,e),p(W.$$.fragment,e),p(te.$$.fragment,e),p(de.$$.fragment,e),p(ge.$$.fragment,e),p(fe.$$.fragment,e),p($e.$$.fragment,e),p(Ce.$$.fragment,e),p(ye.$$.fragment,e),p(Ae.$$.fragment,e),p(ke.$$.fragment,e),p(Ne.$$.fragment,e),p(De.$$.fragment,e),p(Qe.$$.fragment,e),p(at.$$.fragment,e),p(mt.$$.fragment,e),kl=!0)},o(e){f($.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(E.$$.fragment,e),f(k.$$.fragment,e),f(J.$$.fragment,e),f(O.$$.fragment,e),f(W.$$.fragment,e),f(te.$$.fragment,e),f(de.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(ye.$$.fragment,e),f(Ae.$$.fragment,e),f(ke.$$.fragment,e),f(Ne.$$.fragment,e),f(De.$$.fragment,e),f(Qe.$$.fragment,e),f(at.$$.fragment,e),f(mt.$$.fragment,e),kl=!1},d(e){e&&(a(st),a(dt),a(rt),a(I),a(nt),a(gt),a(v),a(ut),a(_),a(ct),a(T),a(pt),a(ft),a(ht),a(b),a(wt),a(Rt),a(x),a(It),a(H),a($t),a(vt),a(_t),a(L),a(Tt),a(bt),a(M),a(Ct),a(P),a(xt),a(Ht),a(Lt),a(A),a(yt),a(Mt),a(z),a(Pt),a(j),a(At),a(Et),a(zt),a(U),a(jt),a(Ut),a(B),a(kt),a(K),a(Bt),a(Kt),a(Yt),a(Y),a(Jt),a(Nt),a(N),a(qt),a(q),a(Gt),a(Ot),a(St),a(G),a(Dt),a(Zt),a(S),a(Wt),a(D),a(Ft),a(Vt),a(Qt),a(Z),a(Xt),a(ea),a(F),a(ta),a(V),a(aa),a(Q),a(la),a(X),a(ia),a(ma),a(da),a(ee),a(oa),a(sa),a(ae),a(ra),a(le),a(na),a(ie),a(ga),a(ua),a(ca),a(me),a(pa),a(fa),a(oe),a(ha),a(se),a(wa),a(re),a(Ra),a(Ia),a($a),a(ne),a(va),a(_a),a(ue),a(Ta),a(ce),a(ba),a(Ca),a(xa),a(pe),a(Ha),a(La),a(he),a(ya),a(we),a(Ma),a(Re),a(Pa),a(Aa),a(Ea),a(Ie),a(za),a(ja),a(ve),a(Ua),a(_e),a(ka),a(Te),a(Ba),a(Ka),a(Ya),a(be),a(Ja),a(Na),a(xe),a(qa),a(He),a(Ga),a(Le),a(Oa),a(Sa),a(Me),a(Da),a(Za),a(Wa),a(Pe),a(Fa),a(Va),a(Ee),a(Qa),a(ze),a(Xa),a(je),a(el),a(tl),a(al),a(Ue),a(ll),a(il),a(Be),a(ml),a(Ke),a(dl),a(Ye),a(ol),a(sl),a(rl),a(Je),a(nl),a(gl),a(qe),a(ul),a(Ge),a(cl),a(Oe),a(pl),a(fl),a(hl),a(Se),a(wl),a(Rl),a(Ze),a(Il),a(We),a($l),a(Fe),a(vl),a(_l),a(Tl),a(Ve),a(bl),a(Cl),a(Xe),a(xl),a(et),a(Hl),a(Ll),a(yl),a(tt),a(Ml),a(Pl),a(lt),a(Al),a(it),a(El),a(zl),a(jl),a(Ul),a(ot)),a(R),h($,e),h(C,e),h(y,e),h(E,e),h(k,e),h(J,e),h(O,e),h(W,e),h(te,e),h(de,e),h(ge,e),h(fe,e),h($e,e),h(Ce,e),h(ye,e),h(Ae,e),h(ke,e),h(Ne,e),h(De,e),h(Qe,e),h(at,e),h(mt,e)}}}const Zi='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.putAlpha(mask) ⇒ <code> RawImage </code>","local":"rawimageputalphamask--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.split() ⇒ <code> Array. < RawImage > </code>","local":"rawimagesplit--code-array--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>","local":"rawimagefromcanvascanvas--code-rawimage-code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image.load_image","local":"utilsimageloadimage","sections":[],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Wi(Bl){return Yi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class em extends Ji{constructor(R){super(),Ni(this,R,Wi,Di,Bi,{})}}export{em as component};
