import{s as _e,n as He,o as Fe}from"../chunks/scheduler.eb0ed874.js";import{S as Pe,i as Le,g as i,s as n,r as o,A as Oe,h as M,f as l,c as a,j as ze,u as p,x as T,k as Re,y as De,a as s,v as y,d as r,t as u,w as J}from"../chunks/index.b954ae78.js";import{C as P}from"../chunks/CodeBlock.2e864717.js";import{H as c,E as Ke}from"../chunks/EditOnGithub.6f0e1a75.js";function et(Qe){let U,L,H,O,w,D,m,K,j,Ze='<li><a href="#text-generation-inference-custom-api">Text Generation Inference custom API</a></li> <li><a href="#openai-messages-api">OpenAI Messages API</a><ul><li><a href="#making-a-request">Making a Request</a></li> <li><a href="#streaming">Streaming</a></li> <li><a href="#synchronous">Synchronous</a></li> <li><a href="#hugging-face-inference-endpoints">Hugging Face Inference Endpoints</a></li> <li><a href="#cloud-providers">Cloud Providers</a><ul><li><a href="#amazon-sagemaker">Amazon SageMaker</a></li></ul></li></ul></li>',ee,h,qe="The HTTP API is a RESTful API that allows you to interact with the text-generation-inference component. Two endpoints are available:",te,I,Se='<li>Text Generation Inference <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">custom API</a></li> <li>OpenAI’s <a href="#openai-messages-api">Messages API</a></li>',le,g,se,d,$e='Check the <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">API documentation</a> for more information on how to interact with the Text Generation Inference API.',ne,f,ae,C,Ae="Text Generation Inference (TGI) now supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. This feature is available starting from version 1.4.0. You can use OpenAI’s client libraries or third-party libraries expecting OpenAI schema to interact with TGI’s Messages API. Below are some examples of how to utilize this compatibility.",ie,b,Ee="<p><strong>Note:</strong> The Messages API is supported from TGI version 1.4.0 and above. Ensure you are using a compatible version to access this feature.</p>",Me,B,oe,G,We="You can make a request to TGI’s Messages API using <code>curl</code>. Here’s an example:",pe,Q,ye,Z,re,q,ke="You can also use OpenAI’s Python client library to make a streaming request. Here’s how:",ue,S,Je,$,Te,A,xe="If you prefer to make a synchronous request, you can do so like this:",ce,E,Ue,W,we,k,Ve=`The Messages API is integrated with <a href="https://huggingface.co/inference-endpoints/dedicated" rel="nofollow">Inference Endpoints</a>.
Every endpoint that uses “Text Generation Inference” with an LLM, which has a chat template can now be used. Below is an example of how to use IE with TGI using OpenAI’s Python client library:`,me,x,Ne="<p><strong>Note:</strong> Make sure to replace <code>base_url</code> with your endpoint URL and to include <code>v1/</code> at the end of the URL. The <code>api_key</code> should be replaced with your Hugging Face API key.</p>",je,V,he,N,Ie,Y,Ye="TGI can be deployed on various cloud providers for scalable and robust text generation. One such provider is Amazon SageMaker, which has recently added support for TGI. Here’s how you can deploy TGI on Amazon SageMaker:",ge,v,de,X,ve="To enable the Messages API in Amazon SageMaker you need to set the environment variable <code>MESSAGES_API_ENABLED=true</code>.",fe,z,Xe="This will modify the <code>/invocations</code> route to accept Messages dictonaries consisting out of role and content. See the example below on how to deploy Llama with the new Messages API.",Ce,R,be,_,Be,F,Ge;return w=new c({props:{title:"HTTP API Reference",local:"http-api-reference",headingTag:"h1"}}),m=new c({props:{title:"Table of Contents",local:"table-of-contents",headingTag:"h4"}}),g=new c({props:{title:"Text Generation Inference custom API",local:"text-generation-inference-custom-api",headingTag:"h2"}}),f=new c({props:{title:"OpenAI Messages API",local:"openai-messages-api",headingTag:"h2"}}),B=new c({props:{title:"Making a Request",local:"making-a-request",headingTag:"h2"}}),Q=new P({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTMwMDAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:3000/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),Z=new c({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),S=new P({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),$=new c({props:{title:"Synchronous",local:"synchronous",headingTag:"h2"}}),E=new P({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzREZhbHNlJTBBKSUwQSUwQXByaW50KGNoYXRfY29tcGxldGlvbik=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(chat_completion)`,wrap:!1}}),W=new c({props:{title:"Hugging Face Inference Endpoints",local:"hugging-face-inference-endpoints",headingTag:"h2"}}),V=new P({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwZW5kcG9pbnQlMjB1cmwlMkMlMjBtYWtlJTIwc3VyZSUyMHRvJTIwaW5jbHVkZSUyMCUyMnYxJTJGJTIyJTIwYXQlMjB0aGUlMjBlbmQlMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGdmx6ejEwZXEzZm9sMzQyOS51cy1lYXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwQVBJJTIwa2V5JTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmX1hYWCUyMiUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    <span class="hljs-comment"># replace with your endpoint url, make sure to include &quot;v1/&quot; at the end</span>
    base_url=<span class="hljs-string">&quot;https://vlzz10eq3fol3429.us-east-1.aws.endpoints.huggingface.cloud/v1/&quot;</span>,
    <span class="hljs-comment"># replace with your API key</span>
    api_key=<span class="hljs-string">&quot;hf_XXX&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),N=new c({props:{title:"Cloud Providers",local:"cloud-providers",headingTag:"h2"}}),v=new c({props:{title:"Amazon SageMaker",local:"amazon-sagemaker",headingTag:"h2"}}),R=new P({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHNhZ2VtYWtlciUwQWltcG9ydCUyMGJvdG8zJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQSUwQXRyeSUzQSUwQSUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQSUyMyUyMEh1YiUyME1vZGVsJTIwY29uZmlndXJhdGlvbi4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTBBaHViJTIwJTNEJTIwJTdCJTBBJTIwJ0hGX01PREVMX0lEJyUzQSdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTJDJTBBJTIwJ1NNX05VTV9HUFVTJyUzQSUyMGpzb24uZHVtcHMoMSklMkMlMEElMjAnTUVTU0FHRVNfQVBJX0VOQUJMRUQnJTNBJTIwVHJ1ZSUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmclMjBGYWNlJTIwTW9kZWwlMjBDbGFzcyUwQWh1Z2dpbmdmYWNlX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjBpbWFnZV91cmklM0RnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSglMjJodWdnaW5nZmFjZSUyMiUyQ3ZlcnNpb24lM0QlMjIxLjQuMCUyMiklMkMlMEElMjBlbnYlM0RodWIlMkMlMEElMjByb2xlJTNEcm9sZSUyQyUwQSklMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfbW9kZWwuZGVwbG95KCUwQSUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjBjb250YWluZXJfc3RhcnR1cF9oZWFsdGhfY2hlY2tfdGltZW91dCUzRDMwMCUyQyUwQSUyMCUyMCklMEElMEElMjMlMjBzZW5kJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KCU3QiUwQSUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri

<span class="hljs-keyword">try</span>:
 role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
 iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
 role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

<span class="hljs-comment"># Hub Model configuration. https://huggingface.co/models</span>
hub = {
 <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>,
 <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>: json.dumps(<span class="hljs-number">1</span>),
 <span class="hljs-string">&#x27;MESSAGES_API_ENABLED&#x27;</span>: <span class="hljs-literal">True</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
 image_uri=get_huggingface_llm_image_uri(<span class="hljs-string">&quot;huggingface&quot;</span>,version=<span class="hljs-string">&quot;1.4.0&quot;</span>),
 env=hub,
 role=role,
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
 initial_instance_count=<span class="hljs-number">1</span>,
 instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
 container_startup_health_check_timeout=<span class="hljs-number">300</span>,
  )

<span class="hljs-comment"># send request</span>
predictor.predict({
<span class="hljs-string">&quot;messages&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
})`,wrap:!1}}),_=new Ke({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/reference/api_reference.md"}}),{c(){U=i("meta"),L=n(),H=i("p"),O=n(),o(w.$$.fragment),D=n(),o(m.$$.fragment),K=n(),j=i("ul"),j.innerHTML=Ze,ee=n(),h=i("p"),h.textContent=qe,te=n(),I=i("ul"),I.innerHTML=Se,le=n(),o(g.$$.fragment),se=n(),d=i("p"),d.innerHTML=$e,ne=n(),o(f.$$.fragment),ae=n(),C=i("p"),C.textContent=Ae,ie=n(),b=i("blockquote"),b.innerHTML=Ee,Me=n(),o(B.$$.fragment),oe=n(),G=i("p"),G.innerHTML=We,pe=n(),o(Q.$$.fragment),ye=n(),o(Z.$$.fragment),re=n(),q=i("p"),q.textContent=ke,ue=n(),o(S.$$.fragment),Je=n(),o($.$$.fragment),Te=n(),A=i("p"),A.textContent=xe,ce=n(),o(E.$$.fragment),Ue=n(),o(W.$$.fragment),we=n(),k=i("p"),k.innerHTML=Ve,me=n(),x=i("blockquote"),x.innerHTML=Ne,je=n(),o(V.$$.fragment),he=n(),o(N.$$.fragment),Ie=n(),Y=i("p"),Y.textContent=Ye,ge=n(),o(v.$$.fragment),de=n(),X=i("p"),X.innerHTML=ve,fe=n(),z=i("p"),z.innerHTML=Xe,Ce=n(),o(R.$$.fragment),be=n(),o(_.$$.fragment),Be=n(),F=i("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);U=M(t,"META",{name:!0,content:!0}),t.forEach(l),L=a(e),H=M(e,"P",{}),ze(H).forEach(l),O=a(e),p(w.$$.fragment,e),D=a(e),p(m.$$.fragment,e),K=a(e),j=M(e,"UL",{"data-svelte-h":!0}),T(j)!=="svelte-1yjeuvp"&&(j.innerHTML=Ze),ee=a(e),h=M(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-342cv9"&&(h.textContent=qe),te=a(e),I=M(e,"UL",{"data-svelte-h":!0}),T(I)!=="svelte-z81dww"&&(I.innerHTML=Se),le=a(e),p(g.$$.fragment,e),se=a(e),d=M(e,"P",{"data-svelte-h":!0}),T(d)!=="svelte-hezjaf"&&(d.innerHTML=$e),ne=a(e),p(f.$$.fragment,e),ae=a(e),C=M(e,"P",{"data-svelte-h":!0}),T(C)!=="svelte-1npf6uj"&&(C.textContent=Ae),ie=a(e),b=M(e,"BLOCKQUOTE",{"data-svelte-h":!0}),T(b)!=="svelte-d3rfkz"&&(b.innerHTML=Ee),Me=a(e),p(B.$$.fragment,e),oe=a(e),G=M(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1w70cim"&&(G.innerHTML=We),pe=a(e),p(Q.$$.fragment,e),ye=a(e),p(Z.$$.fragment,e),re=a(e),q=M(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1g3ypvi"&&(q.textContent=ke),ue=a(e),p(S.$$.fragment,e),Je=a(e),p($.$$.fragment,e),Te=a(e),A=M(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1xyk36t"&&(A.textContent=xe),ce=a(e),p(E.$$.fragment,e),Ue=a(e),p(W.$$.fragment,e),we=a(e),k=M(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-1xit2od"&&(k.innerHTML=Ve),me=a(e),x=M(e,"BLOCKQUOTE",{"data-svelte-h":!0}),T(x)!=="svelte-1ga4y2y"&&(x.innerHTML=Ne),je=a(e),p(V.$$.fragment,e),he=a(e),p(N.$$.fragment,e),Ie=a(e),Y=M(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-10f0asl"&&(Y.textContent=Ye),ge=a(e),p(v.$$.fragment,e),de=a(e),X=M(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-zm7msf"&&(X.innerHTML=ve),fe=a(e),z=M(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-7x0wid"&&(z.innerHTML=Xe),Ce=a(e),p(R.$$.fragment,e),be=a(e),p(_.$$.fragment,e),Be=a(e),F=M(e,"P",{}),ze(F).forEach(l),this.h()},h(){Re(U,"name","hf:doc:metadata"),Re(U,"content",tt)},m(e,t){De(document.head,U),s(e,L,t),s(e,H,t),s(e,O,t),y(w,e,t),s(e,D,t),y(m,e,t),s(e,K,t),s(e,j,t),s(e,ee,t),s(e,h,t),s(e,te,t),s(e,I,t),s(e,le,t),y(g,e,t),s(e,se,t),s(e,d,t),s(e,ne,t),y(f,e,t),s(e,ae,t),s(e,C,t),s(e,ie,t),s(e,b,t),s(e,Me,t),y(B,e,t),s(e,oe,t),s(e,G,t),s(e,pe,t),y(Q,e,t),s(e,ye,t),y(Z,e,t),s(e,re,t),s(e,q,t),s(e,ue,t),y(S,e,t),s(e,Je,t),y($,e,t),s(e,Te,t),s(e,A,t),s(e,ce,t),y(E,e,t),s(e,Ue,t),y(W,e,t),s(e,we,t),s(e,k,t),s(e,me,t),s(e,x,t),s(e,je,t),y(V,e,t),s(e,he,t),y(N,e,t),s(e,Ie,t),s(e,Y,t),s(e,ge,t),y(v,e,t),s(e,de,t),s(e,X,t),s(e,fe,t),s(e,z,t),s(e,Ce,t),y(R,e,t),s(e,be,t),y(_,e,t),s(e,Be,t),s(e,F,t),Ge=!0},p:He,i(e){Ge||(r(w.$$.fragment,e),r(m.$$.fragment,e),r(g.$$.fragment,e),r(f.$$.fragment,e),r(B.$$.fragment,e),r(Q.$$.fragment,e),r(Z.$$.fragment,e),r(S.$$.fragment,e),r($.$$.fragment,e),r(E.$$.fragment,e),r(W.$$.fragment,e),r(V.$$.fragment,e),r(N.$$.fragment,e),r(v.$$.fragment,e),r(R.$$.fragment,e),r(_.$$.fragment,e),Ge=!0)},o(e){u(w.$$.fragment,e),u(m.$$.fragment,e),u(g.$$.fragment,e),u(f.$$.fragment,e),u(B.$$.fragment,e),u(Q.$$.fragment,e),u(Z.$$.fragment,e),u(S.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(v.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),Ge=!1},d(e){e&&(l(L),l(H),l(O),l(D),l(K),l(j),l(ee),l(h),l(te),l(I),l(le),l(se),l(d),l(ne),l(ae),l(C),l(ie),l(b),l(Me),l(oe),l(G),l(pe),l(ye),l(re),l(q),l(ue),l(Je),l(Te),l(A),l(ce),l(Ue),l(we),l(k),l(me),l(x),l(je),l(he),l(Ie),l(Y),l(ge),l(de),l(X),l(fe),l(z),l(Ce),l(be),l(Be),l(F)),l(U),J(w,e),J(m,e),J(g,e),J(f,e),J(B,e),J(Q,e),J(Z,e),J(S,e),J($,e),J(E,e),J(W,e),J(V,e),J(N,e),J(v,e),J(R,e),J(_,e)}}}const tt='{"title":"HTTP API Reference","local":"http-api-reference","sections":[{"title":"Table of Contents","local":"table-of-contents","sections":[],"depth":4},{"title":"Text Generation Inference custom API","local":"text-generation-inference-custom-api","sections":[],"depth":2},{"title":"OpenAI Messages API","local":"openai-messages-api","sections":[],"depth":2},{"title":"Making a Request","local":"making-a-request","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Synchronous","local":"synchronous","sections":[],"depth":2},{"title":"Hugging Face Inference Endpoints","local":"hugging-face-inference-endpoints","sections":[],"depth":2},{"title":"Cloud Providers","local":"cloud-providers","sections":[],"depth":2},{"title":"Amazon SageMaker","local":"amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function lt(Qe){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends Pe{constructor(U){super(),Le(this,U,lt,et,_e,{})}}export{Mt as component};
